; Based on CPU DB MC9S08SV16_32_LQFP, version 3.00.003 (RegistersPrg V2.28)

; ###################################################################
;     Filename  : mc9s08sv8.inc
;     Processor : MC9S08SV8CLC
;     FileFormat: V2.28
;     DataSheet : MC9S08SV16RM Rev. 1 3/2009
;     Compiler  : CodeWarrior compiler
;     Date/Time : 27.5.2009, 10:22
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 6.4.2009, V3.00.0:
;              - Removed bits FPROT[FPDIS], NVPROT[FPDIS].
;              -   REASON: Changes in the RM (from Rev. 0 Draft B 5/2008 to Rev. 1 3/2009).
;
;     File-Format-Revisions:
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matchs with anouther bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
ROMStart:           equ   $0000E000
ROMEnd:             equ   $0000FFAD
Z_RAMStart:         equ   $00000040
Z_RAMEnd:           equ   $000000FF
RAMStart:           equ   $00000100
RAMEnd:             equ   $0000033F
ROM1Start:          equ   $0000FFC0
ROM1End:            equ   $0000FFCF
;
Vrtc:               equ   $0000FFD0
Vscitx:             equ   $0000FFD2
Vscirx:             equ   $0000FFD4
Vscierr:            equ   $0000FFD6
Viic:               equ   $0000FFD8
Vspi:               equ   $0000FFDA
Vadc:               equ   $0000FFDC
Vtpm2ovf:           equ   $0000FFDE
Vtpm2ch1:           equ   $0000FFE0
Vtpm2ch0:           equ   $0000FFE2
Vtpm1ovf:           equ   $0000FFE4
Vtpm1ch5:           equ   $0000FFE6
Vtpm1ch4:           equ   $0000FFE8
Vtpm1ch3:           equ   $0000FFEA
Vtpm1ch2:           equ   $0000FFEC
Vtpm1ch1:           equ   $0000FFEE
Vtpm1ch0:           equ   $0000FFF0
Vmtim:              equ   $0000FFF2
Vacmp:              equ   $0000FFF4
Vkeyboard:          equ   $0000FFF6
Vlvd:               equ   $0000FFF8
Virq:               equ   $0000FFFA
Vswi:               equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** ADCSC1 - Status and Control Register 1; 0x00000000 ***
ADCSC1:             equ    $00000000                                ;*** ADCSC1 - Status and Control Register 1; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCSC1_ADCH0:       equ    0                                         ; Input Channel Select Bit 0
ADCSC1_ADCH1:       equ    1                                         ; Input Channel Select Bit 1
ADCSC1_ADCH2:       equ    2                                         ; Input Channel Select Bit 2
ADCSC1_ADCH3:       equ    3                                         ; Input Channel Select Bit 3
ADCSC1_ADCH4:       equ    4                                         ; Input Channel Select Bit 4
ADCSC1_ADCO:        equ    5                                         ; Continuous Conversion Enable - ADCO is used to enable continuous conversions
ADCSC1_AIEN:        equ    6                                         ; Interrupt Enable - AIEN is used to enable conversion complete interrupts. When COCO becomes set while AIEN is high, an interrupt is asserted
ADCSC1_COCO:        equ    7                                         ; Conversion Complete Flag
; bit position masks
mADCSC1_ADCH0:      equ    %00000001
mADCSC1_ADCH1:      equ    %00000010
mADCSC1_ADCH2:      equ    %00000100
mADCSC1_ADCH3:      equ    %00001000
mADCSC1_ADCH4:      equ    %00010000
mADCSC1_ADCO:       equ    %00100000
mADCSC1_AIEN:       equ    %01000000
mADCSC1_COCO:       equ    %10000000


;*** ADCSC2 - Status and Control Register 2; 0x00000001 ***
ADCSC2:             equ    $00000001                                ;*** ADCSC2 - Status and Control Register 2; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCSC2_ACFGT:       equ    4                                         ; Compare Function Greater Than Enable
ADCSC2_ACFE:        equ    5                                         ; Compare Function Enable - ACFE is used to enable the compare function
ADCSC2_ADTRG:       equ    6                                         ; Conversion Trigger Select-ADTRG is used to select the type of trigger to be used for initiating a conversion
ADCSC2_ADACT:       equ    7                                         ; Conversion Active - ADACT indicates that a conversion is in progress. ADACT is set when a conversion is initiated and cleared when a conversion is completed or aborted
; bit position masks
mADCSC2_ACFGT:      equ    %00010000
mADCSC2_ACFE:       equ    %00100000
mADCSC2_ADTRG:      equ    %01000000
mADCSC2_ADACT:      equ    %10000000


;*** ADCR - Data Result Register; 0x00000002 ***
ADCR:               equ    $00000002                                ;*** ADCR - Data Result Register; 0x00000002 ***


;*** ADCRH - Data Result High Register; 0x00000002 ***
ADCRH:              equ    $00000002                                ;*** ADCRH - Data Result High Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCRH_ADR8:         equ    0                                         ; ADC Result Data Bit 8
ADCRH_ADR9:         equ    1                                         ; ADC Result Data Bit 9
; bit position masks
mADCRH_ADR8:        equ    %00000001
mADCRH_ADR9:        equ    %00000010


;*** ADCRL - Data Result Low Register; 0x00000003 ***
ADCRL:              equ    $00000003                                ;*** ADCRL - Data Result Low Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCRL_ADR0:         equ    0                                         ; ADC Result Data Bit 0
ADCRL_ADR1:         equ    1                                         ; ADC Result Data Bit 1
ADCRL_ADR2:         equ    2                                         ; ADC Result Data Bit 2
ADCRL_ADR3:         equ    3                                         ; ADC Result Data Bit 3
ADCRL_ADR4:         equ    4                                         ; ADC Result Data Bit 4
ADCRL_ADR5:         equ    5                                         ; ADC Result Data Bit 5
ADCRL_ADR6:         equ    6                                         ; ADC Result Data Bit 6
ADCRL_ADR7:         equ    7                                         ; ADC Result Data Bit 7
; bit position masks
mADCRL_ADR0:        equ    %00000001
mADCRL_ADR1:        equ    %00000010
mADCRL_ADR2:        equ    %00000100
mADCRL_ADR3:        equ    %00001000
mADCRL_ADR4:        equ    %00010000
mADCRL_ADR5:        equ    %00100000
mADCRL_ADR6:        equ    %01000000
mADCRL_ADR7:        equ    %10000000


;*** ADCCV - Compare Value Register; 0x00000004 ***
ADCCV:              equ    $00000004                                ;*** ADCCV - Compare Value Register; 0x00000004 ***


;*** ADCCVH - Compare Value High Register; 0x00000004 ***
ADCCVH:             equ    $00000004                                ;*** ADCCVH - Compare Value High Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCVH_ADCV8:       equ    0                                         ; Compare Function Value 8
ADCCVH_ADCV9:       equ    1                                         ; Compare Function Value 9
; bit position masks
mADCCVH_ADCV8:      equ    %00000001
mADCCVH_ADCV9:      equ    %00000010


;*** ADCCVL - Compare Value Low Register; 0x00000005 ***
ADCCVL:             equ    $00000005                                ;*** ADCCVL - Compare Value Low Register; 0x00000005 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCVL_ADCV0:       equ    0                                         ; Compare Function Value 0
ADCCVL_ADCV1:       equ    1                                         ; Compare Function Value 1
ADCCVL_ADCV2:       equ    2                                         ; Compare Function Value 2
ADCCVL_ADCV3:       equ    3                                         ; Compare Function Value 3
ADCCVL_ADCV4:       equ    4                                         ; Compare Function Value 4
ADCCVL_ADCV5:       equ    5                                         ; Compare Function Value 5
ADCCVL_ADCV6:       equ    6                                         ; Compare Function Value 6
ADCCVL_ADCV7:       equ    7                                         ; Compare Function Value 7
; bit position masks
mADCCVL_ADCV0:      equ    %00000001
mADCCVL_ADCV1:      equ    %00000010
mADCCVL_ADCV2:      equ    %00000100
mADCCVL_ADCV3:      equ    %00001000
mADCCVL_ADCV4:      equ    %00010000
mADCCVL_ADCV5:      equ    %00100000
mADCCVL_ADCV6:      equ    %01000000
mADCCVL_ADCV7:      equ    %10000000


;*** ADCCFG - Configuration Register; 0x00000006 ***
ADCCFG:             equ    $00000006                                ;*** ADCCFG - Configuration Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCFG_ADICLK0:     equ    0                                         ; Input Clock Select Bit 0
ADCCFG_ADICLK1:     equ    1                                         ; Input Clock Select Bit 1
ADCCFG_MODE0:       equ    2                                         ; Conversion Mode Selection Bit 0
ADCCFG_MODE1:       equ    3                                         ; Conversion Mode Selection Bit 1
ADCCFG_ADLSMP:      equ    4                                         ; Long Sample Time Configuration
ADCCFG_ADIV0:       equ    5                                         ; Clock Divide Select Bit 0
ADCCFG_ADIV1:       equ    6                                         ; Clock Divide Select Bit 1
ADCCFG_ADLPC:       equ    7                                         ; Low Power Configuration
; bit position masks
mADCCFG_ADICLK0:    equ    %00000001
mADCCFG_ADICLK1:    equ    %00000010
mADCCFG_MODE0:      equ    %00000100
mADCCFG_MODE1:      equ    %00001000
mADCCFG_ADLSMP:     equ    %00010000
mADCCFG_ADIV0:      equ    %00100000
mADCCFG_ADIV1:      equ    %01000000
mADCCFG_ADLPC:      equ    %10000000


;*** APCTL1 - Pin Control 1 Register; 0x00000007 ***
APCTL1:             equ    $00000007                                ;*** APCTL1 - Pin Control 1 Register; 0x00000007 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
APCTL1_ADPC0:       equ    0                                         ; ADC Pin Control 0 - ADPC0 is used to control the pin associated with channel AD0
APCTL1_ADPC1:       equ    1                                         ; ADC Pin Control 1 - ADPC1 is used to control the pin associated with channel AD1
APCTL1_ADPC2:       equ    2                                         ; ADC Pin Control 2 - ADPC2 is used to control the pin associated with channel AD2
APCTL1_ADPC3:       equ    3                                         ; ADC Pin Control 3 - ADPC3 is used to control the pin associated with channel AD3
APCTL1_ADPC4:       equ    4                                         ; ADC Pin Control 4 - ADPC4 is used to control the pin associated with channel AD4
APCTL1_ADPC5:       equ    5                                         ; ADC Pin Control 5 - ADPC5 is used to control the pin associated with channel AD5
APCTL1_ADPC6:       equ    6                                         ; ADC Pin Control 6 - ADPC6 is used to control the pin associated with channel AD6
APCTL1_ADPC7:       equ    7                                         ; ADC Pin Control 7 - ADPC7 is used to control the pin associated with channel AD7
; bit position masks
mAPCTL1_ADPC0:      equ    %00000001
mAPCTL1_ADPC1:      equ    %00000010
mAPCTL1_ADPC2:      equ    %00000100
mAPCTL1_ADPC3:      equ    %00001000
mAPCTL1_ADPC4:      equ    %00010000
mAPCTL1_ADPC5:      equ    %00100000
mAPCTL1_ADPC6:      equ    %01000000
mAPCTL1_ADPC7:      equ    %10000000


;*** APCTL2 - Pin Control 2 Register; 0x00000008 ***
APCTL2:             equ    $00000008                                ;*** APCTL2 - Pin Control 2 Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
APCTL2_ADPC8:       equ    0                                         ; ADC Pin Control 8 - ADPC8 is used to control the pin associated with channel AD8
APCTL2_ADPC9:       equ    1                                         ; ADC Pin Control 9 - ADPC9 is used to control the pin associated with channel AD9
APCTL2_ADPC10:      equ    2                                         ; ADC Pin Control 10 - ADPC10 is used to control the pin associated with channel AD10
APCTL2_ADPC11:      equ    3                                         ; ADC Pin Control 11 - ADPC11 is used to control the pin associated with channel AD11
; bit position masks
mAPCTL2_ADPC8:      equ    %00000001
mAPCTL2_ADPC9:      equ    %00000010
mAPCTL2_ADPC10:     equ    %00000100
mAPCTL2_ADPC11:     equ    %00001000


;*** IRQSC - Interrupt request status and control register; 0x0000000B ***
IRQSC:              equ    $0000000B                                ;*** IRQSC - Interrupt request status and control register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQSC_IRQMOD:       equ    0                                         ; IRQ Detection Mode
IRQSC_IRQIE:        equ    1                                         ; IRQ Interrupt Enable
IRQSC_IRQACK:       equ    2                                         ; IRQ Acknowledge
IRQSC_IRQF:         equ    3                                         ; IRQ Flag
IRQSC_IRQPE:        equ    4                                         ; IRQ Pin Enable
IRQSC_IRQEDG:       equ    5                                         ; IRQ Edge Select
IRQSC_IRQPDD:       equ    6                                         ; IRQ Pull Device Disable
; bit position masks
mIRQSC_IRQMOD:      equ    %00000001
mIRQSC_IRQIE:       equ    %00000010
mIRQSC_IRQACK:      equ    %00000100
mIRQSC_IRQF:        equ    %00001000
mIRQSC_IRQPE:       equ    %00010000
mIRQSC_IRQEDG:      equ    %00100000
mIRQSC_IRQPDD:      equ    %01000000


;*** KBISC - KBI Status and Control Register; 0x0000000C ***
KBISC:              equ    $0000000C                                ;*** KBISC - KBI Status and Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBISC_KBIMOD:       equ    0                                         ; Keyboard Detection Mode
KBISC_KBIE:         equ    1                                         ; Keyboard Interrupt Enable
KBISC_KBACK:        equ    2                                         ; Keyboard Interrupt Acknowledge
KBISC_KBF:          equ    3                                         ; Keyboard Interrupt Flag
; bit position masks
mKBISC_KBIMOD:      equ    %00000001
mKBISC_KBIE:        equ    %00000010
mKBISC_KBACK:       equ    %00000100
mKBISC_KBF:         equ    %00001000


;*** KBIPE - KBI Pin Enable Register; 0x0000000D ***
KBIPE:              equ    $0000000D                                ;*** KBIPE - KBI Pin Enable Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBIPE_KBIPE0:       equ    0                                         ; Keyboard Pin Enable for KBI Port Bit 0
KBIPE_KBIPE1:       equ    1                                         ; Keyboard Pin Enable for KBI Port Bit 1
KBIPE_KBIPE2:       equ    2                                         ; Keyboard Pin Enable for KBI Port Bit 2
KBIPE_KBIPE3:       equ    3                                         ; Keyboard Pin Enable for KBI Port Bit 3
KBIPE_KBIPE4:       equ    4                                         ; Keyboard Pin Enable for KBI Port Bit 4
KBIPE_KBIPE5:       equ    5                                         ; Keyboard Pin Enable for KBI Port Bit 5
KBIPE_KBIPE6:       equ    6                                         ; Keyboard Pin Enable for KBI Port Bit 6
KBIPE_KBIPE7:       equ    7                                         ; Keyboard Pin Enable for KBI Port Bit 7
; bit position masks
mKBIPE_KBIPE0:      equ    %00000001
mKBIPE_KBIPE1:      equ    %00000010
mKBIPE_KBIPE2:      equ    %00000100
mKBIPE_KBIPE3:      equ    %00001000
mKBIPE_KBIPE4:      equ    %00010000
mKBIPE_KBIPE5:      equ    %00100000
mKBIPE_KBIPE6:      equ    %01000000
mKBIPE_KBIPE7:      equ    %10000000


;*** KBIES - KBI Edge Select Register; 0x0000000E ***
KBIES:              equ    $0000000E                                ;*** KBIES - KBI Edge Select Register; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBIES_KBEDG0:       equ    0                                         ; Keyboard Edge Select Bit 0
KBIES_KBEDG1:       equ    1                                         ; Keyboard Edge Select Bit 1
KBIES_KBEDG2:       equ    2                                         ; Keyboard Edge Select Bit 2
KBIES_KBEDG3:       equ    3                                         ; Keyboard Edge Select Bit 3
KBIES_KBEDG4:       equ    4                                         ; Keyboard Edge Select Bit 4
KBIES_KBEDG5:       equ    5                                         ; Keyboard Edge Select Bit 5
KBIES_KBEDG6:       equ    6                                         ; Keyboard Edge Select Bit 6
KBIES_KBEDG7:       equ    7                                         ; Keyboard Edge Select Bit 7
; bit position masks
mKBIES_KBEDG0:      equ    %00000001
mKBIES_KBEDG1:      equ    %00000010
mKBIES_KBEDG2:      equ    %00000100
mKBIES_KBEDG3:      equ    %00001000
mKBIES_KBEDG4:      equ    %00010000
mKBIES_KBEDG5:      equ    %00100000
mKBIES_KBEDG6:      equ    %01000000
mKBIES_KBEDG7:      equ    %10000000


;*** ACMPSC - ACMP Status and Control Register; 0x0000000F ***
ACMPSC:             equ    $0000000F                                ;*** ACMPSC - ACMP Status and Control Register; 0x0000000F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ACMPSC_ACMOD0:      equ    0                                         ; Analog Comparator Mode Bit 0
ACMPSC_ACMOD1:      equ    1                                         ; Analog Comparator Mode Bit 1
ACMPSC_ACOPE:       equ    2                                         ; Analog Comparator Output Pin Enable
ACMPSC_ACO:         equ    3                                         ; Analog Comparator Output
ACMPSC_ACIE:        equ    4                                         ; Analog Comparator Interrupt Enable
ACMPSC_ACF:         equ    5                                         ; Analog Comparator Flag
ACMPSC_ACBGS:       equ    6                                         ; Analog Comparator Bandgap Select
ACMPSC_ACME:        equ    7                                         ; Analog Comparator Module Enable
; bit position masks
mACMPSC_ACMOD0:     equ    %00000001
mACMPSC_ACMOD1:     equ    %00000010
mACMPSC_ACOPE:      equ    %00000100
mACMPSC_ACO:        equ    %00001000
mACMPSC_ACIE:       equ    %00010000
mACMPSC_ACF:        equ    %00100000
mACMPSC_ACBGS:      equ    %01000000
mACMPSC_ACME:       equ    %10000000


;*** TPM2SC - TPM2 Status and Control Register; 0x00000010 ***
TPM2SC:             equ    $00000010                                ;*** TPM2SC - TPM2 Status and Control Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM2SC_PS0:         equ    0                                         ; Prescale Divisor Select Bit 0
TPM2SC_PS1:         equ    1                                         ; Prescale Divisor Select Bit 1
TPM2SC_PS2:         equ    2                                         ; Prescale Divisor Select Bit 2
TPM2SC_CLKSA:       equ    3                                         ; Clock Source Select A
TPM2SC_CLKSB:       equ    4                                         ; Clock Source Select B
TPM2SC_CPWMS:       equ    5                                         ; Center-Aligned PWM Select
TPM2SC_TOIE:        equ    6                                         ; Timer Overflow Interrupt Enable
TPM2SC_TOF:         equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPM2SC_PS0:        equ    %00000001
mTPM2SC_PS1:        equ    %00000010
mTPM2SC_PS2:        equ    %00000100
mTPM2SC_CLKSA:      equ    %00001000
mTPM2SC_CLKSB:      equ    %00010000
mTPM2SC_CPWMS:      equ    %00100000
mTPM2SC_TOIE:       equ    %01000000
mTPM2SC_TOF:        equ    %10000000


;*** TPM2CNT - TPM2 Timer Counter Register; 0x00000011 ***
TPM2CNT:            equ    $00000011                                ;*** TPM2CNT - TPM2 Timer Counter Register; 0x00000011 ***


;*** TPM2CNTH - TPM2 Timer Counter Register High; 0x00000011 ***
TPM2CNTH:           equ    $00000011                                ;*** TPM2CNTH - TPM2 Timer Counter Register High; 0x00000011 ***


;*** TPM2CNTL - TPM2 Timer Counter Register Low; 0x00000012 ***
TPM2CNTL:           equ    $00000012                                ;*** TPM2CNTL - TPM2 Timer Counter Register Low; 0x00000012 ***


;*** TPM2MOD - TPM2 Timer Counter Modulo Register; 0x00000013 ***
TPM2MOD:            equ    $00000013                                ;*** TPM2MOD - TPM2 Timer Counter Modulo Register; 0x00000013 ***


;*** TPM2MODH - TPM2 Timer Counter Modulo Register High; 0x00000013 ***
TPM2MODH:           equ    $00000013                                ;*** TPM2MODH - TPM2 Timer Counter Modulo Register High; 0x00000013 ***


;*** TPM2MODL - TPM2 Timer Counter Modulo Register Low; 0x00000014 ***
TPM2MODL:           equ    $00000014                                ;*** TPM2MODL - TPM2 Timer Counter Modulo Register Low; 0x00000014 ***


;*** TPM2C0SC - TPM2 Timer Channel 0 Status and Control Register; 0x00000015 ***
TPM2C0SC:           equ    $00000015                                ;*** TPM2C0SC - TPM2 Timer Channel 0 Status and Control Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM2C0SC_ELS0A:     equ    2                                         ; Edge/Level Select Bit A
TPM2C0SC_ELS0B:     equ    3                                         ; Edge/Level Select Bit B
TPM2C0SC_MS0A:      equ    4                                         ; Mode Select A for TPM Channel 0
TPM2C0SC_MS0B:      equ    5                                         ; Mode Select B for TPM Channel 0
TPM2C0SC_CH0IE:     equ    6                                         ; Channel 0 Interrupt Enable
TPM2C0SC_CH0F:      equ    7                                         ; Channel 0 Flag
; bit position masks
mTPM2C0SC_ELS0A:    equ    %00000100
mTPM2C0SC_ELS0B:    equ    %00001000
mTPM2C0SC_MS0A:     equ    %00010000
mTPM2C0SC_MS0B:     equ    %00100000
mTPM2C0SC_CH0IE:    equ    %01000000
mTPM2C0SC_CH0F:     equ    %10000000


;*** TPM2C0V - TPM2 Timer Channel 0 Value Register; 0x00000016 ***
TPM2C0V:            equ    $00000016                                ;*** TPM2C0V - TPM2 Timer Channel 0 Value Register; 0x00000016 ***


;*** TPM2C0VH - TPM2 Timer Channel 0 Value Register High; 0x00000016 ***
TPM2C0VH:           equ    $00000016                                ;*** TPM2C0VH - TPM2 Timer Channel 0 Value Register High; 0x00000016 ***


;*** TPM2C0VL - TPM2 Timer Channel 0 Value Register Low; 0x00000017 ***
TPM2C0VL:           equ    $00000017                                ;*** TPM2C0VL - TPM2 Timer Channel 0 Value Register Low; 0x00000017 ***


;*** TPM2C1SC - TPM2 Timer Channel 1 Status and Control Register; 0x00000018 ***
TPM2C1SC:           equ    $00000018                                ;*** TPM2C1SC - TPM2 Timer Channel 1 Status and Control Register; 0x00000018 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM2C1SC_ELS1A:     equ    2                                         ; Edge/Level Select Bit A
TPM2C1SC_ELS1B:     equ    3                                         ; Edge/Level Select Bit B
TPM2C1SC_MS1A:      equ    4                                         ; Mode Select A for TPM Channel 1
TPM2C1SC_MS1B:      equ    5                                         ; Mode Select B for TPM Channel 1
TPM2C1SC_CH1IE:     equ    6                                         ; Channel 1 Interrupt Enable
TPM2C1SC_CH1F:      equ    7                                         ; Channel 1 Flag
; bit position masks
mTPM2C1SC_ELS1A:    equ    %00000100
mTPM2C1SC_ELS1B:    equ    %00001000
mTPM2C1SC_MS1A:     equ    %00010000
mTPM2C1SC_MS1B:     equ    %00100000
mTPM2C1SC_CH1IE:    equ    %01000000
mTPM2C1SC_CH1F:     equ    %10000000


;*** TPM2C1V - TPM2 Timer Channel 1 Value Register; 0x00000019 ***
TPM2C1V:            equ    $00000019                                ;*** TPM2C1V - TPM2 Timer Channel 1 Value Register; 0x00000019 ***


;*** TPM2C1VH - TPM2 Timer Channel 1 Value Register High; 0x00000019 ***
TPM2C1VH:           equ    $00000019                                ;*** TPM2C1VH - TPM2 Timer Channel 1 Value Register High; 0x00000019 ***


;*** TPM2C1VL - TPM2 Timer Channel 1 Value Register Low; 0x0000001A ***
TPM2C1VL:           equ    $0000001A                                ;*** TPM2C1VL - TPM2 Timer Channel 1 Value Register Low; 0x0000001A ***


;*** IPCSC - IPC Status and Control Register; 0x0000001E ***
IPCSC:              equ    $0000001E                                ;*** IPCSC - IPC Status and Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IPCSC_IPM0:         equ    0                                         ; Interrupt Priority Mask, bit 0
IPCSC_IPM1:         equ    1                                         ; Interrupt Priority Mask, bit 1
IPCSC_PULIPM:       equ    3                                         ; Pull IPM from IPMPS
IPCSC_PSF:          equ    4                                         ; Pseudo Stack Full
IPCSC_PSE:          equ    5                                         ; Pseudo Stack Empty
IPCSC_IPCE:         equ    7                                         ; Interrupt Priority Controller Enable
; bit position masks
mIPCSC_IPM0:        equ    %00000001
mIPCSC_IPM1:        equ    %00000010
mIPCSC_PULIPM:      equ    %00001000
mIPCSC_PSF:         equ    %00010000
mIPCSC_PSE:         equ    %00100000
mIPCSC_IPCE:        equ    %10000000


;*** IPMPS - Interrupt Priority Mask Pseudo Stack Register; 0x0000001F ***
IPMPS:              equ    $0000001F                                ;*** IPMPS - Interrupt Priority Mask Pseudo Stack Register; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IPMPS_IPM00:        equ    0                                         ; Interrupt Priority Mask pseudo stack position 0, bit 0
IPMPS_IPM01:        equ    1                                         ; Interrupt Priority Mask pseudo stack position 0, bit 1
IPMPS_IPM10:        equ    2                                         ; Interrupt Priority Mask pseudo stack position 1, bit 0
IPMPS_IPM11:        equ    3                                         ; Interrupt Priority Mask pseudo stack position 1, bit 1
IPMPS_IPM20:        equ    4                                         ; Interrupt Priority Mask pseudo stack position 2, bit 0
IPMPS_IPM21:        equ    5                                         ; Interrupt Priority Mask pseudo stack position 2, bit 1
IPMPS_IPM30:        equ    6                                         ; Interrupt Priority Mask pseudo stack position 3, bit 0
IPMPS_IPM31:        equ    7                                         ; Interrupt Priority Mask pseudo stack position 3, bit 1
; bit position masks
mIPMPS_IPM00:       equ    %00000001
mIPMPS_IPM01:       equ    %00000010
mIPMPS_IPM10:       equ    %00000100
mIPMPS_IPM11:       equ    %00001000
mIPMPS_IPM20:       equ    %00010000
mIPMPS_IPM21:       equ    %00100000
mIPMPS_IPM30:       equ    %01000000
mIPMPS_IPM31:       equ    %10000000


;*** TPM1SC - TPM1 Status and Control Register; 0x00000020 ***
TPM1SC:             equ    $00000020                                ;*** TPM1SC - TPM1 Status and Control Register; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1SC_PS0:         equ    0                                         ; Prescale Divisor Select Bit 0
TPM1SC_PS1:         equ    1                                         ; Prescale Divisor Select Bit 1
TPM1SC_PS2:         equ    2                                         ; Prescale Divisor Select Bit 2
TPM1SC_CLKSA:       equ    3                                         ; Clock Source Select A
TPM1SC_CLKSB:       equ    4                                         ; Clock Source Select B
TPM1SC_CPWMS:       equ    5                                         ; Center-Aligned PWM Select
TPM1SC_TOIE:        equ    6                                         ; Timer Overflow Interrupt Enable
TPM1SC_TOF:         equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPM1SC_PS0:        equ    %00000001
mTPM1SC_PS1:        equ    %00000010
mTPM1SC_PS2:        equ    %00000100
mTPM1SC_CLKSA:      equ    %00001000
mTPM1SC_CLKSB:      equ    %00010000
mTPM1SC_CPWMS:      equ    %00100000
mTPM1SC_TOIE:       equ    %01000000
mTPM1SC_TOF:        equ    %10000000


;*** TPM1CNT - TPM1 Timer Counter Register; 0x00000021 ***
TPM1CNT:            equ    $00000021                                ;*** TPM1CNT - TPM1 Timer Counter Register; 0x00000021 ***


;*** TPM1CNTH - TPM1 Timer Counter Register High; 0x00000021 ***
TPM1CNTH:           equ    $00000021                                ;*** TPM1CNTH - TPM1 Timer Counter Register High; 0x00000021 ***


;*** TPM1CNTL - TPM1 Timer Counter Register Low; 0x00000022 ***
TPM1CNTL:           equ    $00000022                                ;*** TPM1CNTL - TPM1 Timer Counter Register Low; 0x00000022 ***


;*** TPM1MOD - TPM1 Timer Counter Modulo Register; 0x00000023 ***
TPM1MOD:            equ    $00000023                                ;*** TPM1MOD - TPM1 Timer Counter Modulo Register; 0x00000023 ***


;*** TPM1MODH - TPM1 Timer Counter Modulo Register High; 0x00000023 ***
TPM1MODH:           equ    $00000023                                ;*** TPM1MODH - TPM1 Timer Counter Modulo Register High; 0x00000023 ***


;*** TPM1MODL - TPM1 Timer Counter Modulo Register Low; 0x00000024 ***
TPM1MODL:           equ    $00000024                                ;*** TPM1MODL - TPM1 Timer Counter Modulo Register Low; 0x00000024 ***


;*** TPM1C0SC - TPM1 Timer Channel 0 Status and Control Register; 0x00000025 ***
TPM1C0SC:           equ    $00000025                                ;*** TPM1C0SC - TPM1 Timer Channel 0 Status and Control Register; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C0SC_ELS0A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C0SC_ELS0B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C0SC_MS0A:      equ    4                                         ; Mode Select A for TPM Channel 0
TPM1C0SC_MS0B:      equ    5                                         ; Mode Select B for TPM Channel 0
TPM1C0SC_CH0IE:     equ    6                                         ; Channel 0 Interrupt Enable
TPM1C0SC_CH0F:      equ    7                                         ; Channel 0 Flag
; bit position masks
mTPM1C0SC_ELS0A:    equ    %00000100
mTPM1C0SC_ELS0B:    equ    %00001000
mTPM1C0SC_MS0A:     equ    %00010000
mTPM1C0SC_MS0B:     equ    %00100000
mTPM1C0SC_CH0IE:    equ    %01000000
mTPM1C0SC_CH0F:     equ    %10000000


;*** TPM1C0V - TPM1 Timer Channel 0 Value Register; 0x00000026 ***
TPM1C0V:            equ    $00000026                                ;*** TPM1C0V - TPM1 Timer Channel 0 Value Register; 0x00000026 ***


;*** TPM1C0VH - TPM1 Timer Channel 0 Value Register High; 0x00000026 ***
TPM1C0VH:           equ    $00000026                                ;*** TPM1C0VH - TPM1 Timer Channel 0 Value Register High; 0x00000026 ***


;*** TPM1C0VL - TPM1 Timer Channel 0 Value Register Low; 0x00000027 ***
TPM1C0VL:           equ    $00000027                                ;*** TPM1C0VL - TPM1 Timer Channel 0 Value Register Low; 0x00000027 ***


;*** TPM1C1SC - TPM1 Timer Channel 1 Status and Control Register; 0x00000028 ***
TPM1C1SC:           equ    $00000028                                ;*** TPM1C1SC - TPM1 Timer Channel 1 Status and Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C1SC_ELS1A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C1SC_ELS1B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C1SC_MS1A:      equ    4                                         ; Mode Select A for TPM Channel 1
TPM1C1SC_MS1B:      equ    5                                         ; Mode Select B for TPM Channel 1
TPM1C1SC_CH1IE:     equ    6                                         ; Channel 1 Interrupt Enable
TPM1C1SC_CH1F:      equ    7                                         ; Channel 1 Flag
; bit position masks
mTPM1C1SC_ELS1A:    equ    %00000100
mTPM1C1SC_ELS1B:    equ    %00001000
mTPM1C1SC_MS1A:     equ    %00010000
mTPM1C1SC_MS1B:     equ    %00100000
mTPM1C1SC_CH1IE:    equ    %01000000
mTPM1C1SC_CH1F:     equ    %10000000


;*** TPM1C1V - TPM1 Timer Channel 1 Value Register; 0x00000029 ***
TPM1C1V:            equ    $00000029                                ;*** TPM1C1V - TPM1 Timer Channel 1 Value Register; 0x00000029 ***


;*** TPM1C1VH - TPM1 Timer Channel 1 Value Register High; 0x00000029 ***
TPM1C1VH:           equ    $00000029                                ;*** TPM1C1VH - TPM1 Timer Channel 1 Value Register High; 0x00000029 ***


;*** TPM1C1VL - TPM1 Timer Channel 1 Value Register Low; 0x0000002A ***
TPM1C1VL:           equ    $0000002A                                ;*** TPM1C1VL - TPM1 Timer Channel 1 Value Register Low; 0x0000002A ***


;*** TPM1C2SC - TPM1 Timer Channel 2 Status and Control Register; 0x0000002B ***
TPM1C2SC:           equ    $0000002B                                ;*** TPM1C2SC - TPM1 Timer Channel 2 Status and Control Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C2SC_ELS2A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C2SC_ELS2B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C2SC_MS2A:      equ    4                                         ; Mode Select A for TPM Channel 2
TPM1C2SC_MS2B:      equ    5                                         ; Mode Select B for TPM Channel 2
TPM1C2SC_CH2IE:     equ    6                                         ; Channel 2 Interrupt Enable
TPM1C2SC_CH2F:      equ    7                                         ; Channel 2 Flag
; bit position masks
mTPM1C2SC_ELS2A:    equ    %00000100
mTPM1C2SC_ELS2B:    equ    %00001000
mTPM1C2SC_MS2A:     equ    %00010000
mTPM1C2SC_MS2B:     equ    %00100000
mTPM1C2SC_CH2IE:    equ    %01000000
mTPM1C2SC_CH2F:     equ    %10000000


;*** TPM1C2V - TPM1 Timer Channel 2 Value Register; 0x0000002C ***
TPM1C2V:            equ    $0000002C                                ;*** TPM1C2V - TPM1 Timer Channel 2 Value Register; 0x0000002C ***


;*** TPM1C2VH - TPM1 Timer Channel 2 Value Register High; 0x0000002C ***
TPM1C2VH:           equ    $0000002C                                ;*** TPM1C2VH - TPM1 Timer Channel 2 Value Register High; 0x0000002C ***


;*** TPM1C2VL - TPM1 Timer Channel 2 Value Register Low; 0x0000002D ***
TPM1C2VL:           equ    $0000002D                                ;*** TPM1C2VL - TPM1 Timer Channel 2 Value Register Low; 0x0000002D ***


;*** TPM1C3SC - TPM1 Timer Channel 3 Status and Control Register; 0x0000002E ***
TPM1C3SC:           equ    $0000002E                                ;*** TPM1C3SC - TPM1 Timer Channel 3 Status and Control Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C3SC_ELS3A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C3SC_ELS3B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C3SC_MS3A:      equ    4                                         ; Mode Select A for TPM Channel 3
TPM1C3SC_MS3B:      equ    5                                         ; Mode Select B for TPM Channel 3
TPM1C3SC_CH3IE:     equ    6                                         ; Channel 3 Interrupt Enable
TPM1C3SC_CH3F:      equ    7                                         ; Channel 3 Flag
; bit position masks
mTPM1C3SC_ELS3A:    equ    %00000100
mTPM1C3SC_ELS3B:    equ    %00001000
mTPM1C3SC_MS3A:     equ    %00010000
mTPM1C3SC_MS3B:     equ    %00100000
mTPM1C3SC_CH3IE:    equ    %01000000
mTPM1C3SC_CH3F:     equ    %10000000


;*** TPM1C3V - TPM1 Timer Channel 3 Value Register; 0x0000002F ***
TPM1C3V:            equ    $0000002F                                ;*** TPM1C3V - TPM1 Timer Channel 3 Value Register; 0x0000002F ***


;*** TPM1C3VH - TPM1 Timer Channel 3 Value Register High; 0x0000002F ***
TPM1C3VH:           equ    $0000002F                                ;*** TPM1C3VH - TPM1 Timer Channel 3 Value Register High; 0x0000002F ***


;*** TPM1C3VL - TPM1 Timer Channel 3 Value Register Low; 0x00000030 ***
TPM1C3VL:           equ    $00000030                                ;*** TPM1C3VL - TPM1 Timer Channel 3 Value Register Low; 0x00000030 ***


;*** TPM1C4SC - TPM1 Timer Channel 4 Status and Control Register; 0x00000031 ***
TPM1C4SC:           equ    $00000031                                ;*** TPM1C4SC - TPM1 Timer Channel 4 Status and Control Register; 0x00000031 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C4SC_ELS4A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C4SC_ELS4B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C4SC_MS4A:      equ    4                                         ; Mode Select A for TPM Channel 4
TPM1C4SC_MS4B:      equ    5                                         ; Mode Select B for TPM Channel 4
TPM1C4SC_CH4IE:     equ    6                                         ; Channel 4 Interrupt Enable
TPM1C4SC_CH4F:      equ    7                                         ; Channel 4 Flag
; bit position masks
mTPM1C4SC_ELS4A:    equ    %00000100
mTPM1C4SC_ELS4B:    equ    %00001000
mTPM1C4SC_MS4A:     equ    %00010000
mTPM1C4SC_MS4B:     equ    %00100000
mTPM1C4SC_CH4IE:    equ    %01000000
mTPM1C4SC_CH4F:     equ    %10000000


;*** TPM1C4V - TPM1 Timer Channel 4 Value Register; 0x00000032 ***
TPM1C4V:            equ    $00000032                                ;*** TPM1C4V - TPM1 Timer Channel 4 Value Register; 0x00000032 ***


;*** TPM1C4VH - TPM1 Timer Channel 4 Value Register High; 0x00000032 ***
TPM1C4VH:           equ    $00000032                                ;*** TPM1C4VH - TPM1 Timer Channel 4 Value Register High; 0x00000032 ***


;*** TPM1C4VL - TPM1 Timer Channel 4 Value Register Low; 0x00000033 ***
TPM1C4VL:           equ    $00000033                                ;*** TPM1C4VL - TPM1 Timer Channel 4 Value Register Low; 0x00000033 ***


;*** TPM1C5SC - TPM1 Timer Channel 5 Status and Control Register; 0x00000034 ***
TPM1C5SC:           equ    $00000034                                ;*** TPM1C5SC - TPM1 Timer Channel 5 Status and Control Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C5SC_ELS5A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C5SC_ELS5B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C5SC_MS5A:      equ    4                                         ; Mode Select A for TPM Channel 5
TPM1C5SC_MS5B:      equ    5                                         ; Mode Select B for TPM Channel 5
TPM1C5SC_CH5IE:     equ    6                                         ; Channel 5 Interrupt Enable
TPM1C5SC_CH5F:      equ    7                                         ; Channel 5 Flag
; bit position masks
mTPM1C5SC_ELS5A:    equ    %00000100
mTPM1C5SC_ELS5B:    equ    %00001000
mTPM1C5SC_MS5A:     equ    %00010000
mTPM1C5SC_MS5B:     equ    %00100000
mTPM1C5SC_CH5IE:    equ    %01000000
mTPM1C5SC_CH5F:     equ    %10000000


;*** TPM1C5V - TPM1 Timer Channel 5 Value Register; 0x00000035 ***
TPM1C5V:            equ    $00000035                                ;*** TPM1C5V - TPM1 Timer Channel 5 Value Register; 0x00000035 ***


;*** TPM1C5VH - TPM1 Timer Channel 5 Value Register High; 0x00000035 ***
TPM1C5VH:           equ    $00000035                                ;*** TPM1C5VH - TPM1 Timer Channel 5 Value Register High; 0x00000035 ***


;*** TPM1C5VL - TPM1 Timer Channel 5 Value Register Low; 0x00000036 ***
TPM1C5VL:           equ    $00000036                                ;*** TPM1C5VL - TPM1 Timer Channel 5 Value Register Low; 0x00000036 ***


;*** PTAD - Port A Data Register; 0x00000038 ***
PTAD:               equ    $00000038                                ;*** PTAD - Port A Data Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port A Data Register Bit 0
PTAD_PTAD1:         equ    1                                         ; Port A Data Register Bit 1
PTAD_PTAD2:         equ    2                                         ; Port A Data Register Bit 2
PTAD_PTAD3:         equ    3                                         ; Port A Data Register Bit 3
PTAD_PTAD4:         equ    4                                         ; Port A Data Register Bit 4
PTAD_PTAD5:         equ    5                                         ; Port A Data Register Bit 5
PTAD_PTAD6:         equ    6                                         ; Port A Data Register Bit 6
PTAD_PTAD7:         equ    7                                         ; Port A Data Register Bit 7
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000
mPTAD_PTAD6:        equ    %01000000
mPTAD_PTAD7:        equ    %10000000


;*** PTADD - Port A Data Direction Register; 0x00000039 ***
PTADD:              equ    $00000039                                ;*** PTADD - Port A Data Direction Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADD_PTADD0:       equ    0                                         ; Data Direction for Port A Bit 0
PTADD_PTADD1:       equ    1                                         ; Data Direction for Port A Bit 1
PTADD_PTADD2:       equ    2                                         ; Data Direction for Port A Bit 2
PTADD_PTADD3:       equ    3                                         ; Data Direction for Port A Bit 3
PTADD_PTADD6:       equ    6                                         ; Data Direction for Port A Bit 6
PTADD_PTADD7:       equ    7                                         ; Data Direction for Port A Bit 7
; bit position masks
mPTADD_PTADD0:      equ    %00000001
mPTADD_PTADD1:      equ    %00000010
mPTADD_PTADD2:      equ    %00000100
mPTADD_PTADD3:      equ    %00001000
mPTADD_PTADD6:      equ    %01000000
mPTADD_PTADD7:      equ    %10000000


;*** PTBD - Port B Data Register; 0x0000003A ***
PTBD:               equ    $0000003A                                ;*** PTBD - Port B Data Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBD_PTBD0:         equ    0                                         ; Port B Data Register Bit 0
PTBD_PTBD1:         equ    1                                         ; Port B Data Register Bit 1
PTBD_PTBD2:         equ    2                                         ; Port B Data Register Bit 2
PTBD_PTBD3:         equ    3                                         ; Port B Data Register Bit 3
PTBD_PTBD4:         equ    4                                         ; Port B Data Register Bit 4
PTBD_PTBD5:         equ    5                                         ; Port B Data Register Bit 5
PTBD_PTBD6:         equ    6                                         ; Port B Data Register Bit 6
PTBD_PTBD7:         equ    7                                         ; Port B Data Register Bit 7
; bit position masks
mPTBD_PTBD0:        equ    %00000001
mPTBD_PTBD1:        equ    %00000010
mPTBD_PTBD2:        equ    %00000100
mPTBD_PTBD3:        equ    %00001000
mPTBD_PTBD4:        equ    %00010000
mPTBD_PTBD5:        equ    %00100000
mPTBD_PTBD6:        equ    %01000000
mPTBD_PTBD7:        equ    %10000000


;*** PTBDD - Port B Data Direction Register; 0x0000003B ***
PTBDD:              equ    $0000003B                                ;*** PTBDD - Port B Data Direction Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBDD_PTBDD0:       equ    0                                         ; Data Direction for Port B Bit 0
PTBDD_PTBDD1:       equ    1                                         ; Data Direction for Port B Bit 1
PTBDD_PTBDD2:       equ    2                                         ; Data Direction for Port B Bit 2
PTBDD_PTBDD3:       equ    3                                         ; Data Direction for Port B Bit 3
PTBDD_PTBDD4:       equ    4                                         ; Data Direction for Port B Bit 4
PTBDD_PTBDD5:       equ    5                                         ; Data Direction for Port B Bit 5
PTBDD_PTBDD6:       equ    6                                         ; Data Direction for Port B Bit 6
PTBDD_PTBDD7:       equ    7                                         ; Data Direction for Port B Bit 7
; bit position masks
mPTBDD_PTBDD0:      equ    %00000001
mPTBDD_PTBDD1:      equ    %00000010
mPTBDD_PTBDD2:      equ    %00000100
mPTBDD_PTBDD3:      equ    %00001000
mPTBDD_PTBDD4:      equ    %00010000
mPTBDD_PTBDD5:      equ    %00100000
mPTBDD_PTBDD6:      equ    %01000000
mPTBDD_PTBDD7:      equ    %10000000


;*** PTCD - Port C Data Register; 0x0000003C ***
PTCD:               equ    $0000003C                                ;*** PTCD - Port C Data Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCD_PTCD0:         equ    0                                         ; Port C Data Register Bit 0
PTCD_PTCD1:         equ    1                                         ; Port C Data Register Bit 1
PTCD_PTCD2:         equ    2                                         ; Port C Data Register Bit 2
PTCD_PTCD3:         equ    3                                         ; Port C Data Register Bit 3
PTCD_PTCD4:         equ    4                                         ; Port C Data Register Bit 4
PTCD_PTCD5:         equ    5                                         ; Port C Data Register Bit 5
PTCD_PTCD6:         equ    6                                         ; Port C Data Register Bit 6
PTCD_PTCD7:         equ    7                                         ; Port C Data Register Bit 7
; bit position masks
mPTCD_PTCD0:        equ    %00000001
mPTCD_PTCD1:        equ    %00000010
mPTCD_PTCD2:        equ    %00000100
mPTCD_PTCD3:        equ    %00001000
mPTCD_PTCD4:        equ    %00010000
mPTCD_PTCD5:        equ    %00100000
mPTCD_PTCD6:        equ    %01000000
mPTCD_PTCD7:        equ    %10000000


;*** PTCDD - Port C Data Direction Register; 0x0000003D ***
PTCDD:              equ    $0000003D                                ;*** PTCDD - Port C Data Direction Register; 0x0000003D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCDD_PTCDD0:       equ    0                                         ; Data Direction for Port C Bit 0
PTCDD_PTCDD1:       equ    1                                         ; Data Direction for Port C Bit 1
PTCDD_PTCDD2:       equ    2                                         ; Data Direction for Port C Bit 2
PTCDD_PTCDD3:       equ    3                                         ; Data Direction for Port C Bit 3
PTCDD_PTCDD4:       equ    4                                         ; Data Direction for Port C Bit 4
PTCDD_PTCDD5:       equ    5                                         ; Data Direction for Port C Bit 5
PTCDD_PTCDD6:       equ    6                                         ; Data Direction for Port C Bit 6
PTCDD_PTCDD7:       equ    7                                         ; Data Direction for Port C Bit 7
; bit position masks
mPTCDD_PTCDD0:      equ    %00000001
mPTCDD_PTCDD1:      equ    %00000010
mPTCDD_PTCDD2:      equ    %00000100
mPTCDD_PTCDD3:      equ    %00001000
mPTCDD_PTCDD4:      equ    %00010000
mPTCDD_PTCDD5:      equ    %00100000
mPTCDD_PTCDD6:      equ    %01000000
mPTCDD_PTCDD7:      equ    %10000000


;*** PTDD - Port D Data Register; 0x0000003E ***
PTDD:               equ    $0000003E                                ;*** PTDD - Port D Data Register; 0x0000003E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDD_PTDD0:         equ    0                                         ; Port D Data Register Bit 0
PTDD_PTDD1:         equ    1                                         ; Port D Data Register Bit 1
PTDD_PTDD2:         equ    2                                         ; Port D Data Register Bit 2
PTDD_PTDD3:         equ    3                                         ; Port D Data Register Bit 3
PTDD_PTDD4:         equ    4                                         ; Port D Data Register Bit 4
PTDD_PTDD5:         equ    5                                         ; Port D Data Register Bit 5
; bit position masks
mPTDD_PTDD0:        equ    %00000001
mPTDD_PTDD1:        equ    %00000010
mPTDD_PTDD2:        equ    %00000100
mPTDD_PTDD3:        equ    %00001000
mPTDD_PTDD4:        equ    %00010000
mPTDD_PTDD5:        equ    %00100000


;*** PTDDD - Port D Data Direction Register; 0x0000003F ***
PTDDD:              equ    $0000003F                                ;*** PTDDD - Port D Data Direction Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDDD_PTDDD0:       equ    0                                         ; Data Direction for Port D Bit 0
PTDDD_PTDDD1:       equ    1                                         ; Data Direction for Port D Bit 1
PTDDD_PTDDD2:       equ    2                                         ; Data Direction for Port D Bit 2
PTDDD_PTDDD3:       equ    3                                         ; Data Direction for Port D Bit 3
PTDDD_PTDDD4:       equ    4                                         ; Data Direction for Port D Bit 4
PTDDD_PTDDD5:       equ    5                                         ; Data Direction for Port D Bit 5
; bit position masks
mPTDDD_PTDDD0:      equ    %00000001
mPTDDD_PTDDD1:      equ    %00000010
mPTDDD_PTDDD2:      equ    %00000100
mPTDDD_PTDDD3:      equ    %00001000
mPTDDD_PTDDD4:      equ    %00010000
mPTDDD_PTDDD5:      equ    %00100000


;*** SRS - System Reset Status Register; 0x00001800 ***
SRS:                equ    $00001800                                ;*** SRS - System Reset Status Register; 0x00001800 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRS_LVD:            equ    1                                         ; Low Voltage Detect
SRS_ILAD:           equ    3                                         ; Illegal Address
SRS_ILOP:           equ    4                                         ; Illegal Opcode
SRS_COP:            equ    5                                         ; Computer Operating Properly (COP) Watchdog
SRS_PIN:            equ    6                                         ; External Reset Pin
SRS_POR:            equ    7                                         ; Power-On Reset
; bit position masks
mSRS_LVD:           equ    %00000010
mSRS_ILAD:          equ    %00001000
mSRS_ILOP:          equ    %00010000
mSRS_COP:           equ    %00100000
mSRS_PIN:           equ    %01000000
mSRS_POR:           equ    %10000000


;*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***
SBDFR:              equ    $00001801                                ;*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SBDFR_BDFR:         equ    0                                         ; Background Debug Force Reset
; bit position masks
mSBDFR_BDFR:        equ    %00000001


;*** SOPT1 - System Options Register 1; 0x00001802 ***
SOPT1:              equ    $00001802                                ;*** SOPT1 - System Options Register 1; 0x00001802 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT1_RSTPE:        equ    0                                         ; RESET Pin Enable
SOPT1_BKGDPE:       equ    1                                         ; Background Debug Mode Pin Enable
SOPT1_ADHWTS0:      equ    2                                         ; ADC Hardware Trigger Source, bit 0
SOPT1_ADHWTS1:      equ    3                                         ; ADC Hardware Trigger Source, bit 1
SOPT1_TCLKPEN:      equ    4                                         ; TCLK Pin Enable
SOPT1_STOPE:        equ    5                                         ; Stop Mode Enable
SOPT1_COPT0:        equ    6                                         ; COP Watchdog Timeout, bit 0
SOPT1_COPT1:        equ    7                                         ; COP Watchdog Timeout, bit 1
; bit position masks
mSOPT1_RSTPE:       equ    %00000001
mSOPT1_BKGDPE:      equ    %00000010
mSOPT1_ADHWTS0:     equ    %00000100
mSOPT1_ADHWTS1:     equ    %00001000
mSOPT1_TCLKPEN:     equ    %00010000
mSOPT1_STOPE:       equ    %00100000
mSOPT1_COPT0:       equ    %01000000
mSOPT1_COPT1:       equ    %10000000


;*** SOPT2 - System Options Register 2; 0x00001803 ***
SOPT2:              equ    $00001803                                ;*** SOPT2 - System Options Register 2; 0x00001803 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT2_COPW:         equ    6                                         ; COP Window
SOPT2_COPCLKS:      equ    7                                         ; COP Watchdog Clock Select
; bit position masks
mSOPT2_COPW:        equ    %01000000
mSOPT2_COPCLKS:     equ    %10000000


;*** SDID - System Device Identification Register; 0x00001806 ***
SDID:               equ    $00001806                                ;*** SDID - System Device Identification Register; 0x00001806 ***


;*** SDIDH - System Device Identification Register High; 0x00001806 ***
SDIDH:              equ    $00001806                                ;*** SDIDH - System Device Identification Register High; 0x00001806 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDH_ID8:          equ    0                                         ; Part Identification Number, bit 8
SDIDH_ID9:          equ    1                                         ; Part Identification Number, bit 9
SDIDH_ID10:         equ    2                                         ; Part Identification Number, bit 10
SDIDH_ID11:         equ    3                                         ; Part Identification Number, bit 11
; bit position masks
mSDIDH_ID8:         equ    %00000001
mSDIDH_ID9:         equ    %00000010
mSDIDH_ID10:        equ    %00000100
mSDIDH_ID11:        equ    %00001000


;*** SDIDL - System Device Identification Register Low; 0x00001807 ***
SDIDL:              equ    $00001807                                ;*** SDIDL - System Device Identification Register Low; 0x00001807 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDL_ID0:          equ    0                                         ; Part Identification Number, bit 0
SDIDL_ID1:          equ    1                                         ; Part Identification Number, bit 1
SDIDL_ID2:          equ    2                                         ; Part Identification Number, bit 2
SDIDL_ID3:          equ    3                                         ; Part Identification Number, bit 3
SDIDL_ID4:          equ    4                                         ; Part Identification Number, bit 4
SDIDL_ID5:          equ    5                                         ; Part Identification Number, bit 5
SDIDL_ID6:          equ    6                                         ; Part Identification Number, bit 6
SDIDL_ID7:          equ    7                                         ; Part Identification Number, bit 7
; bit position masks
mSDIDL_ID0:         equ    %00000001
mSDIDL_ID1:         equ    %00000010
mSDIDL_ID2:         equ    %00000100
mSDIDL_ID3:         equ    %00001000
mSDIDL_ID4:         equ    %00010000
mSDIDL_ID5:         equ    %00100000
mSDIDL_ID6:         equ    %01000000
mSDIDL_ID7:         equ    %10000000


;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00001809 ***
SPMSC1:             equ    $00001809                                ;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00001809 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC1_BGBE:        equ    0                                         ; Bandgap Buffer Enable
SPMSC1_LVDE:        equ    2                                         ; Low-Voltage Detect Enable
SPMSC1_LVDSE:       equ    3                                         ; Low-Voltage Detect Stop Enable
SPMSC1_LVDRE:       equ    4                                         ; Low-Voltage Detect Reset Enable
SPMSC1_LVWIE:       equ    5                                         ; Low-Voltage Warning Interrupt Enable
SPMSC1_LVWACK:      equ    6                                         ; Low-Voltage Warning Acknowledge
SPMSC1_LVWF:        equ    7                                         ; Low-Voltage Warning status
; bit position masks
mSPMSC1_BGBE:       equ    %00000001
mSPMSC1_LVDE:       equ    %00000100
mSPMSC1_LVDSE:      equ    %00001000
mSPMSC1_LVDRE:      equ    %00010000
mSPMSC1_LVWIE:      equ    %00100000
mSPMSC1_LVWACK:     equ    %01000000
mSPMSC1_LVWF:       equ    %10000000


;*** SPMSC2 - System Power Management Status and Control 2 Register; 0x0000180A ***
SPMSC2:             equ    $0000180A                                ;*** SPMSC2 - System Power Management Status and Control 2 Register; 0x0000180A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC2_PPDC:        equ    0                                         ; Partial Power Down Control
SPMSC2_PPDACK:      equ    2                                         ; Partial Power Down Acknowledge
SPMSC2_PPDF:        equ    3                                         ; Partial Power Down Flag
SPMSC2_LVWV:        equ    4                                         ; Low-Voltage Warning Voltage Select
SPMSC2_LVDV:        equ    5                                         ; Low-Voltage Detect Voltage Select
; bit position masks
mSPMSC2_PPDC:       equ    %00000001
mSPMSC2_PPDACK:     equ    %00000100
mSPMSC2_PPDF:       equ    %00001000
mSPMSC2_LVWV:       equ    %00010000
mSPMSC2_LVDV:       equ    %00100000


;*** DBGCA - Debug Comparator A Register; 0x00001810 ***
DBGCA:              equ    $00001810                                ;*** DBGCA - Debug Comparator A Register; 0x00001810 ***


;*** DBGCAH - Debug Comparator A High Register; 0x00001810 ***
DBGCAH:             equ    $00001810                                ;*** DBGCAH - Debug Comparator A High Register; 0x00001810 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_Bit8:        equ    0                                         ; Comparator A High Compare Bit 8
DBGCAH_Bit9:        equ    1                                         ; Comparator A High Compare Bit 9
DBGCAH_Bit10:       equ    2                                         ; Comparator A High Compare Bit 10
DBGCAH_Bit11:       equ    3                                         ; Comparator A High Compare Bit 11
DBGCAH_Bit12:       equ    4                                         ; Comparator A High Compare Bit 12
DBGCAH_Bit13:       equ    5                                         ; Comparator A High Compare Bit 13
DBGCAH_Bit14:       equ    6                                         ; Comparator A High Compare Bit 14
DBGCAH_Bit15:       equ    7                                         ; Comparator A High Compare Bit 15
; bit position masks
mDBGCAH_Bit8:       equ    %00000001
mDBGCAH_Bit9:       equ    %00000010
mDBGCAH_Bit10:      equ    %00000100
mDBGCAH_Bit11:      equ    %00001000
mDBGCAH_Bit12:      equ    %00010000
mDBGCAH_Bit13:      equ    %00100000
mDBGCAH_Bit14:      equ    %01000000
mDBGCAH_Bit15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Low Register; 0x00001811 ***
DBGCAL:             equ    $00001811                                ;*** DBGCAL - Debug Comparator A Low Register; 0x00001811 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_Bit0:        equ    0                                         ; Comparator A Low Compare Bit 0
DBGCAL_Bit1:        equ    1                                         ; Comparator A Low Compare Bit 1
DBGCAL_Bit2:        equ    2                                         ; Comparator A Low Compare Bit 2
DBGCAL_Bit3:        equ    3                                         ; Comparator A Low Compare Bit 3
DBGCAL_Bit4:        equ    4                                         ; Comparator A Low Compare Bit 4
DBGCAL_Bit5:        equ    5                                         ; Comparator A Low Compare Bit 5
DBGCAL_Bit6:        equ    6                                         ; Comparator A Low Compare Bit 6
DBGCAL_Bit7:        equ    7                                         ; Comparator A Low Compare Bit 7
; bit position masks
mDBGCAL_Bit0:       equ    %00000001
mDBGCAL_Bit1:       equ    %00000010
mDBGCAL_Bit2:       equ    %00000100
mDBGCAL_Bit3:       equ    %00001000
mDBGCAL_Bit4:       equ    %00010000
mDBGCAL_Bit5:       equ    %00100000
mDBGCAL_Bit6:       equ    %01000000
mDBGCAL_Bit7:       equ    %10000000


;*** DBGCB - Debug Comparator B Register; 0x00001812 ***
DBGCB:              equ    $00001812                                ;*** DBGCB - Debug Comparator B Register; 0x00001812 ***


;*** DBGCBH - Debug Comparator B High Register; 0x00001812 ***
DBGCBH:             equ    $00001812                                ;*** DBGCBH - Debug Comparator B High Register; 0x00001812 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_Bit8:        equ    0                                         ; Comparator B High Compare Bit 8
DBGCBH_Bit9:        equ    1                                         ; Comparator B High Compare Bit 9
DBGCBH_Bit10:       equ    2                                         ; Comparator B High Compare Bit 10
DBGCBH_Bit11:       equ    3                                         ; Comparator B High Compare Bit 11
DBGCBH_Bit12:       equ    4                                         ; Comparator B High Compare Bit 12
DBGCBH_Bit13:       equ    5                                         ; Comparator B High Compare Bit 13
DBGCBH_Bit14:       equ    6                                         ; Comparator B High Compare Bit 14
DBGCBH_Bit15:       equ    7                                         ; Comparator B High Compare Bit 15
; bit position masks
mDBGCBH_Bit8:       equ    %00000001
mDBGCBH_Bit9:       equ    %00000010
mDBGCBH_Bit10:      equ    %00000100
mDBGCBH_Bit11:      equ    %00001000
mDBGCBH_Bit12:      equ    %00010000
mDBGCBH_Bit13:      equ    %00100000
mDBGCBH_Bit14:      equ    %01000000
mDBGCBH_Bit15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Low Register; 0x00001813 ***
DBGCBL:             equ    $00001813                                ;*** DBGCBL - Debug Comparator B Low Register; 0x00001813 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_Bit0:        equ    0                                         ; Comparator B Low Compare Bit 0
DBGCBL_Bit1:        equ    1                                         ; Comparator B Low Compare Bit 1
DBGCBL_Bit2:        equ    2                                         ; Comparator B Low Compare Bit 2
DBGCBL_Bit3:        equ    3                                         ; Comparator B Low Compare Bit 3
DBGCBL_Bit4:        equ    4                                         ; Comparator B Low Compare Bit 4
DBGCBL_Bit5:        equ    5                                         ; Comparator B Low Compare Bit 5
DBGCBL_Bit6:        equ    6                                         ; Comparator B Low Compare Bit 6
DBGCBL_Bit7:        equ    7                                         ; Comparator B Low Compare Bit 7
; bit position masks
mDBGCBL_Bit0:       equ    %00000001
mDBGCBL_Bit1:       equ    %00000010
mDBGCBL_Bit2:       equ    %00000100
mDBGCBL_Bit3:       equ    %00001000
mDBGCBL_Bit4:       equ    %00010000
mDBGCBL_Bit5:       equ    %00100000
mDBGCBL_Bit6:       equ    %01000000
mDBGCBL_Bit7:       equ    %10000000


;*** DBGF - Debug FIFO Register; 0x00001814 ***
DBGF:               equ    $00001814                                ;*** DBGF - Debug FIFO Register; 0x00001814 ***


;*** DBGFH - Debug FIFO High Register; 0x00001814 ***
DBGFH:              equ    $00001814                                ;*** DBGFH - Debug FIFO High Register; 0x00001814 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFH_Bit8:         equ    0                                         ; FIFO High Data Bit 8
DBGFH_Bit9:         equ    1                                         ; FIFO High Data Bit 9
DBGFH_Bit10:        equ    2                                         ; FIFO High Data Bit 10
DBGFH_Bit11:        equ    3                                         ; FIFO High Data Bit 11
DBGFH_Bit12:        equ    4                                         ; FIFO High Data Bit 12
DBGFH_Bit13:        equ    5                                         ; FIFO High Data Bit 13
DBGFH_Bit14:        equ    6                                         ; FIFO High Data Bit 14
DBGFH_Bit15:        equ    7                                         ; FIFO High Data Bit 15
; bit position masks
mDBGFH_Bit8:        equ    %00000001
mDBGFH_Bit9:        equ    %00000010
mDBGFH_Bit10:       equ    %00000100
mDBGFH_Bit11:       equ    %00001000
mDBGFH_Bit12:       equ    %00010000
mDBGFH_Bit13:       equ    %00100000
mDBGFH_Bit14:       equ    %01000000
mDBGFH_Bit15:       equ    %10000000


;*** DBGFL - Debug FIFO Low Register; 0x00001815 ***
DBGFL:              equ    $00001815                                ;*** DBGFL - Debug FIFO Low Register; 0x00001815 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFL_Bit0:         equ    0                                         ; FIFO Low Data Bit 0
DBGFL_Bit1:         equ    1                                         ; FIFO Low Data Bit 1
DBGFL_Bit2:         equ    2                                         ; FIFO Low Data Bit 2
DBGFL_Bit3:         equ    3                                         ; FIFO Low Data Bit 3
DBGFL_Bit4:         equ    4                                         ; FIFO Low Data Bit 4
DBGFL_Bit5:         equ    5                                         ; FIFO Low Data Bit 5
DBGFL_Bit6:         equ    6                                         ; FIFO Low Data Bit 6
DBGFL_Bit7:         equ    7                                         ; FIFO Low Data Bit 7
; bit position masks
mDBGFL_Bit0:        equ    %00000001
mDBGFL_Bit1:        equ    %00000010
mDBGFL_Bit2:        equ    %00000100
mDBGFL_Bit3:        equ    %00001000
mDBGFL_Bit4:        equ    %00010000
mDBGFL_Bit5:        equ    %00100000
mDBGFL_Bit6:        equ    %01000000
mDBGFL_Bit7:        equ    %10000000


;*** DBGC - Debug Control Register; 0x00001816 ***
DBGC:               equ    $00001816                                ;*** DBGC - Debug Control Register; 0x00001816 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC_RWBEN:         equ    0                                         ; Enable R/W for Comparator B
DBGC_RWB:           equ    1                                         ; R/W Comparison Value for Comparator B
DBGC_RWAEN:         equ    2                                         ; Enable R/W for Comparator A
DBGC_RWA:           equ    3                                         ; R/W Comparison Value for Comparator A
DBGC_BRKEN:         equ    4                                         ; Break Enable
DBGC_TAG:           equ    5                                         ; Tag/Force Select
DBGC_ARM:           equ    6                                         ; Arm Control
DBGC_DBGEN:         equ    7                                         ; Debug Module Enable
; bit position masks
mDBGC_RWBEN:        equ    %00000001
mDBGC_RWB:          equ    %00000010
mDBGC_RWAEN:        equ    %00000100
mDBGC_RWA:          equ    %00001000
mDBGC_BRKEN:        equ    %00010000
mDBGC_TAG:          equ    %00100000
mDBGC_ARM:          equ    %01000000
mDBGC_DBGEN:        equ    %10000000


;*** DBGT - Debug Trigger Register; 0x00001817 ***
DBGT:               equ    $00001817                                ;*** DBGT - Debug Trigger Register; 0x00001817 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGT_TRG0:          equ    0                                         ; Select Trigger Mode Bit 0
DBGT_TRG1:          equ    1                                         ; Select Trigger Mode Bit 1
DBGT_TRG2:          equ    2                                         ; Select Trigger Mode Bit 2
DBGT_TRG3:          equ    3                                         ; Select Trigger Mode Bit 3
DBGT_BEGIN:         equ    6                                         ; Begin/End Trigger Select
DBGT_TRGSEL:        equ    7                                         ; Trigger Type
; bit position masks
mDBGT_TRG0:         equ    %00000001
mDBGT_TRG1:         equ    %00000010
mDBGT_TRG2:         equ    %00000100
mDBGT_TRG3:         equ    %00001000
mDBGT_BEGIN:        equ    %01000000
mDBGT_TRGSEL:       equ    %10000000


;*** DBGS - Debug Status Register; 0x00001818 ***
DBGS:               equ    $00001818                                ;*** DBGS - Debug Status Register; 0x00001818 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGS_CNT0:          equ    0                                         ; FIFO Valid Count Bit 0
DBGS_CNT1:          equ    1                                         ; FIFO Valid Count Bit 1
DBGS_CNT2:          equ    2                                         ; FIFO Valid Count Bit 2
DBGS_CNT3:          equ    3                                         ; FIFO Valid Count Bit 3
DBGS_ARMF:          equ    5                                         ; Arm Flag
DBGS_BF:            equ    6                                         ; Trigger Match B Flag
DBGS_AF:            equ    7                                         ; Trigger Match A Flag
; bit position masks
mDBGS_CNT0:         equ    %00000001
mDBGS_CNT1:         equ    %00000010
mDBGS_CNT2:         equ    %00000100
mDBGS_CNT3:         equ    %00001000
mDBGS_ARMF:         equ    %00100000
mDBGS_BF:           equ    %01000000
mDBGS_AF:           equ    %10000000


;*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***
FCDIV:              equ    $00001820                                ;*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCDIV_DIV0:         equ    0                                         ; Divisor for FLASH Clock Divider, bit 0
FCDIV_DIV1:         equ    1                                         ; Divisor for FLASH Clock Divider, bit 1
FCDIV_DIV2:         equ    2                                         ; Divisor for FLASH Clock Divider, bit 2
FCDIV_DIV3:         equ    3                                         ; Divisor for FLASH Clock Divider, bit 3
FCDIV_DIV4:         equ    4                                         ; Divisor for FLASH Clock Divider, bit 4
FCDIV_DIV5:         equ    5                                         ; Divisor for FLASH Clock Divider, bit 5
FCDIV_PRDIV8:       equ    6                                         ; Prescale (Divide) FLASH Clock by 8
FCDIV_DIVLD:        equ    7                                         ; Divisor Loaded Status Flag
; bit position masks
mFCDIV_DIV0:        equ    %00000001
mFCDIV_DIV1:        equ    %00000010
mFCDIV_DIV2:        equ    %00000100
mFCDIV_DIV3:        equ    %00001000
mFCDIV_DIV4:        equ    %00010000
mFCDIV_DIV5:        equ    %00100000
mFCDIV_PRDIV8:      equ    %01000000
mFCDIV_DIVLD:       equ    %10000000


;*** FOPT - FLASH Options Register; 0x00001821 ***
FOPT:               equ    $00001821                                ;*** FOPT - FLASH Options Register; 0x00001821 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_SEC00:         equ    0                                         ; Security State Code, bit 0
FOPT_SEC01:         equ    1                                         ; Security State Code, bit 1
FOPT_FNORED:        equ    6                                         ; Vector Redirection Disable
FOPT_KEYEN:         equ    7                                         ; Backdoor Key Mechanism Enable
; bit position masks
mFOPT_SEC00:        equ    %00000001
mFOPT_SEC01:        equ    %00000010
mFOPT_FNORED:       equ    %01000000
mFOPT_KEYEN:        equ    %10000000


;*** FCNFG - FLASH Configuration Register; 0x00001823 ***
FCNFG:              equ    $00001823                                ;*** FCNFG - FLASH Configuration Register; 0x00001823 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_KEYACC:       equ    5                                         ; Enable Writing of Access Key
; bit position masks
mFCNFG_KEYACC:      equ    %00100000


;*** FPROT - FLASH Protection Register; 0x00001824 ***
FPROT:              equ    $00001824                                ;*** FPROT - FLASH Protection Register; 0x00001824 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPS1:         equ    1                                         ; FLASH Protect Select Bit 1
FPROT_FPS2:         equ    2                                         ; FLASH Protect Select Bit 2
FPROT_FPS3:         equ    3                                         ; FLASH Protect Select Bit 3
FPROT_FPS4:         equ    4                                         ; FLASH Protect Select Bit 4
FPROT_FPS5:         equ    5                                         ; FLASH Protect Select Bit 5
FPROT_FPS6:         equ    6                                         ; FLASH Protect Select Bit 6
FPROT_FPS7:         equ    7                                         ; FLASH Protect Select Bit 7
; bit position masks
mFPROT_FPS1:        equ    %00000010
mFPROT_FPS2:        equ    %00000100
mFPROT_FPS3:        equ    %00001000
mFPROT_FPS4:        equ    %00010000
mFPROT_FPS5:        equ    %00100000
mFPROT_FPS6:        equ    %01000000
mFPROT_FPS7:        equ    %10000000


;*** FSTAT - Flash Status Register; 0x00001825 ***
FSTAT:              equ    $00001825                                ;*** FSTAT - Flash Status Register; 0x00001825 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_FBLANK:       equ    2                                         ; FLASH Flag Indicating the Erase Verify Operation Status
FSTAT_FACCERR:      equ    4                                         ; FLASH Access Error Flag
FSTAT_FPVIOL:       equ    5                                         ; FLASH Protection Violation Flag
FSTAT_FCCF:         equ    6                                         ; FLASH Command Complete Interrupt Flag
FSTAT_FCBEF:        equ    7                                         ; FLASH Command Buffer Empty Flag
; bit position masks
mFSTAT_FBLANK:      equ    %00000100
mFSTAT_FACCERR:     equ    %00010000
mFSTAT_FPVIOL:      equ    %00100000
mFSTAT_FCCF:        equ    %01000000
mFSTAT_FCBEF:       equ    %10000000


;*** FCMD - FLASH Command Register; 0x00001826 ***
FCMD:               equ    $00001826                                ;*** FCMD - FLASH Command Register; 0x00001826 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_FCMD0:         equ    0                                         ; FLASH Command Bit 0
FCMD_FCMD1:         equ    1                                         ; FLASH Command Bit 1
FCMD_FCMD2:         equ    2                                         ; FLASH Command Bit 2
FCMD_FCMD3:         equ    3                                         ; FLASH Command Bit 3
FCMD_FCMD4:         equ    4                                         ; FLASH Command Bit 4
FCMD_FCMD5:         equ    5                                         ; FLASH Command Bit 5
FCMD_FCMD6:         equ    6                                         ; FLASH Command Bit 6
FCMD_FCMD7:         equ    7                                         ; FLASH Command Bit 7
; bit position masks
mFCMD_FCMD0:        equ    %00000001
mFCMD_FCMD1:        equ    %00000010
mFCMD_FCMD2:        equ    %00000100
mFCMD_FCMD3:        equ    %00001000
mFCMD_FCMD4:        equ    %00010000
mFCMD_FCMD5:        equ    %00100000
mFCMD_FCMD6:        equ    %01000000
mFCMD_FCMD7:        equ    %10000000


;*** PTAPE - Port A Pull Enable Register; 0x00001840 ***
PTAPE:              equ    $00001840                                ;*** PTAPE - Port A Pull Enable Register; 0x00001840 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAPE_PTAPE0:       equ    0                                         ; Internal Pull Enable for Port A Bit 0
PTAPE_PTAPE1:       equ    1                                         ; Internal Pull Enable for Port A Bit 1
PTAPE_PTAPE2:       equ    2                                         ; Internal Pull Enable for Port A Bit 2
PTAPE_PTAPE3:       equ    3                                         ; Internal Pull Enable for Port A Bit 3
PTAPE_PTAPE5:       equ    5                                         ; Internal Pull Enable for Port A Bit 5
PTAPE_PTAPE6:       equ    6                                         ; Internal Pull Enable for Port A Bit 6
PTAPE_PTAPE7:       equ    7                                         ; Internal Pull Enable for Port A Bit 7
; bit position masks
mPTAPE_PTAPE0:      equ    %00000001
mPTAPE_PTAPE1:      equ    %00000010
mPTAPE_PTAPE2:      equ    %00000100
mPTAPE_PTAPE3:      equ    %00001000
mPTAPE_PTAPE5:      equ    %00100000
mPTAPE_PTAPE6:      equ    %01000000
mPTAPE_PTAPE7:      equ    %10000000


;*** PTASE - Port A Slew Rate Enable Register; 0x00001841 ***
PTASE:              equ    $00001841                                ;*** PTASE - Port A Slew Rate Enable Register; 0x00001841 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTASE_PTASE0:       equ    0                                         ; Output Slew Rate Enable for Port A Bit 0
PTASE_PTASE1:       equ    1                                         ; Output Slew Rate Enable for Port A Bit 1
PTASE_PTASE2:       equ    2                                         ; Output Slew Rate Enable for Port A Bit 2
PTASE_PTASE3:       equ    3                                         ; Output Slew Rate Enable for Port A Bit 3
PTASE_PTASE4:       equ    4                                         ; Output Slew Rate Enable for Port A Bit 4
PTASE_PTASE6:       equ    6                                         ; Output Slew Rate Enable for Port A Bit 6
PTASE_PTASE7:       equ    7                                         ; Output Slew Rate Enable for Port A Bit 7
; bit position masks
mPTASE_PTASE0:      equ    %00000001
mPTASE_PTASE1:      equ    %00000010
mPTASE_PTASE2:      equ    %00000100
mPTASE_PTASE3:      equ    %00001000
mPTASE_PTASE4:      equ    %00010000
mPTASE_PTASE6:      equ    %01000000
mPTASE_PTASE7:      equ    %10000000


;*** PTADS - Port A Drive Strength Selection Register; 0x00001842 ***
PTADS:              equ    $00001842                                ;*** PTADS - Port A Drive Strength Selection Register; 0x00001842 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADS_PTADS0:       equ    0                                         ; Output Drive Strength Selection for Port A Bit 0
PTADS_PTADS1:       equ    1                                         ; Output Drive Strength Selection for Port A Bit 1
PTADS_PTADS2:       equ    2                                         ; Output Drive Strength Selection for Port A Bit 2
PTADS_PTADS3:       equ    3                                         ; Output Drive Strength Selection for Port A Bit 3
PTADS_PTADS4:       equ    4                                         ; Output Drive Strength Selection for Port A Bit 4
PTADS_PTADS6:       equ    6                                         ; Output Drive Strength Selection for Port A Bit 6
PTADS_PTADS7:       equ    7                                         ; Output Drive Strength Selection for Port A Bit 7
; bit position masks
mPTADS_PTADS0:      equ    %00000001
mPTADS_PTADS1:      equ    %00000010
mPTADS_PTADS2:      equ    %00000100
mPTADS_PTADS3:      equ    %00001000
mPTADS_PTADS4:      equ    %00010000
mPTADS_PTADS6:      equ    %01000000
mPTADS_PTADS7:      equ    %10000000


;*** PTBPE - Port B Pull Enable Register; 0x00001844 ***
PTBPE:              equ    $00001844                                ;*** PTBPE - Port B Pull Enable Register; 0x00001844 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBPE_PTBPE0:       equ    0                                         ; Internal Pull Enable for Port B Bit 0
PTBPE_PTBPE1:       equ    1                                         ; Internal Pull Enable for Port B Bit 1
PTBPE_PTBPE2:       equ    2                                         ; Internal Pull Enable for Port B Bit 2
PTBPE_PTBPE3:       equ    3                                         ; Internal Pull Enable for Port B Bit 3
PTBPE_PTBPE4:       equ    4                                         ; Internal Pull Enable for Port B Bit 4
PTBPE_PTBPE5:       equ    5                                         ; Internal Pull Enable for Port B Bit 5
PTBPE_PTBPE6:       equ    6                                         ; Internal Pull Enable for Port B Bit 6
PTBPE_PTBPE7:       equ    7                                         ; Internal Pull Enable for Port B Bit 7
; bit position masks
mPTBPE_PTBPE0:      equ    %00000001
mPTBPE_PTBPE1:      equ    %00000010
mPTBPE_PTBPE2:      equ    %00000100
mPTBPE_PTBPE3:      equ    %00001000
mPTBPE_PTBPE4:      equ    %00010000
mPTBPE_PTBPE5:      equ    %00100000
mPTBPE_PTBPE6:      equ    %01000000
mPTBPE_PTBPE7:      equ    %10000000


;*** PTBSE - Port B Slew Rate Enable Register; 0x00001845 ***
PTBSE:              equ    $00001845                                ;*** PTBSE - Port B Slew Rate Enable Register; 0x00001845 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBSE_PTBSE0:       equ    0                                         ; Output Slew Rate Enable for Port B Bit 0
PTBSE_PTBSE1:       equ    1                                         ; Output Slew Rate Enable for Port B Bit 1
PTBSE_PTBSE2:       equ    2                                         ; Output Slew Rate Enable for Port B Bit 2
PTBSE_PTBSE3:       equ    3                                         ; Output Slew Rate Enable for Port B Bit 3
PTBSE_PTBSE4:       equ    4                                         ; Output Slew Rate Enable for Port B Bit 4
PTBSE_PTBSE5:       equ    5                                         ; Output Slew Rate Enable for Port B Bit 5
PTBSE_PTBSE6:       equ    6                                         ; Output Slew Rate Enable for Port B Bit 6
PTBSE_PTBSE7:       equ    7                                         ; Output Slew Rate Enable for Port B Bit 7
; bit position masks
mPTBSE_PTBSE0:      equ    %00000001
mPTBSE_PTBSE1:      equ    %00000010
mPTBSE_PTBSE2:      equ    %00000100
mPTBSE_PTBSE3:      equ    %00001000
mPTBSE_PTBSE4:      equ    %00010000
mPTBSE_PTBSE5:      equ    %00100000
mPTBSE_PTBSE6:      equ    %01000000
mPTBSE_PTBSE7:      equ    %10000000


;*** PTBDS - Port B Drive Strength Selection Register; 0x00001846 ***
PTBDS:              equ    $00001846                                ;*** PTBDS - Port B Drive Strength Selection Register; 0x00001846 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBDS_PTBDS0:       equ    0                                         ; Output Drive Strength Selection for Port B Bit 0
PTBDS_PTBDS1:       equ    1                                         ; Output Drive Strength Selection for Port B Bit 1
PTBDS_PTBDS2:       equ    2                                         ; Output Drive Strength Selection for Port B Bit 2
PTBDS_PTBDS3:       equ    3                                         ; Output Drive Strength Selection for Port B Bit 3
PTBDS_PTBDS4:       equ    4                                         ; Output Drive Strength Selection for Port B Bit 4
PTBDS_PTBDS5:       equ    5                                         ; Output Drive Strength Selection for Port B Bit 5
PTBDS_PTBDS6:       equ    6                                         ; Output Drive Strength Selection for Port B Bit 6
PTBDS_PTBDS7:       equ    7                                         ; Output Drive Strength Selection for Port B Bit 7
; bit position masks
mPTBDS_PTBDS0:      equ    %00000001
mPTBDS_PTBDS1:      equ    %00000010
mPTBDS_PTBDS2:      equ    %00000100
mPTBDS_PTBDS3:      equ    %00001000
mPTBDS_PTBDS4:      equ    %00010000
mPTBDS_PTBDS5:      equ    %00100000
mPTBDS_PTBDS6:      equ    %01000000
mPTBDS_PTBDS7:      equ    %10000000


;*** PTCPE - Port C Pull Enable Register; 0x00001848 ***
PTCPE:              equ    $00001848                                ;*** PTCPE - Port C Pull Enable Register; 0x00001848 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCPE_PTCPE0:       equ    0                                         ; Internal Pull Enable for Port C Bit 0
PTCPE_PTCPE1:       equ    1                                         ; Internal Pull Enable for Port C Bit 1
PTCPE_PTCPE2:       equ    2                                         ; Internal Pull Enable for Port C Bit 2
PTCPE_PTCPE3:       equ    3                                         ; Internal Pull Enable for Port C Bit 3
PTCPE_PTCPE4:       equ    4                                         ; Internal Pull Enable for Port C Bit 4
PTCPE_PTCPE5:       equ    5                                         ; Internal Pull Enable for Port C Bit 5
PTCPE_PTCPE6:       equ    6                                         ; Internal Pull Enable for Port C Bit 6
PTCPE_PTCPE7:       equ    7                                         ; Internal Pull Enable for Port C Bit 7
; bit position masks
mPTCPE_PTCPE0:      equ    %00000001
mPTCPE_PTCPE1:      equ    %00000010
mPTCPE_PTCPE2:      equ    %00000100
mPTCPE_PTCPE3:      equ    %00001000
mPTCPE_PTCPE4:      equ    %00010000
mPTCPE_PTCPE5:      equ    %00100000
mPTCPE_PTCPE6:      equ    %01000000
mPTCPE_PTCPE7:      equ    %10000000


;*** PTCSE - Port C Slew Rate Enable Register; 0x00001849 ***
PTCSE:              equ    $00001849                                ;*** PTCSE - Port C Slew Rate Enable Register; 0x00001849 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCSE_PTCSE0:       equ    0                                         ; Output Slew Rate Enable for Port C Bit 0
PTCSE_PTCSE1:       equ    1                                         ; Output Slew Rate Enable for Port C Bit 1
PTCSE_PTCSE2:       equ    2                                         ; Output Slew Rate Enable for Port C Bit 2
PTCSE_PTCSE3:       equ    3                                         ; Output Slew Rate Enable for Port C Bit 3
PTCSE_PTCSE4:       equ    4                                         ; Output Slew Rate Enable for Port C Bit 4
PTCSE_PTCSE5:       equ    5                                         ; Output Slew Rate Enable for Port C Bit 5
PTCSE_PTCSE6:       equ    6                                         ; Output Slew Rate Enable for Port C Bit 6
PTCSE_PTCSE7:       equ    7                                         ; Output Slew Rate Enable for Port C Bit 7
; bit position masks
mPTCSE_PTCSE0:      equ    %00000001
mPTCSE_PTCSE1:      equ    %00000010
mPTCSE_PTCSE2:      equ    %00000100
mPTCSE_PTCSE3:      equ    %00001000
mPTCSE_PTCSE4:      equ    %00010000
mPTCSE_PTCSE5:      equ    %00100000
mPTCSE_PTCSE6:      equ    %01000000
mPTCSE_PTCSE7:      equ    %10000000


;*** PTCDS - Port C Drive Strength Selection Register; 0x0000184A ***
PTCDS:              equ    $0000184A                                ;*** PTCDS - Port C Drive Strength Selection Register; 0x0000184A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCDS_PTCDS0:       equ    0                                         ; Output Drive Strength Selection for Port C Bit 0
PTCDS_PTCDS1:       equ    1                                         ; Output Drive Strength Selection for Port C Bit 1
PTCDS_PTCDS2:       equ    2                                         ; Output Drive Strength Selection for Port C Bit 2
PTCDS_PTCDS3:       equ    3                                         ; Output Drive Strength Selection for Port C Bit 3
PTCDS_PTCDS4:       equ    4                                         ; Output Drive Strength Selection for Port C Bit 4
PTCDS_PTCDS5:       equ    5                                         ; Output Drive Strength Selection for Port C Bit 5
PTCDS_PTCDS6:       equ    6                                         ; Output Drive Strength Selection for Port C Bit 6
PTCDS_PTCDS7:       equ    7                                         ; Output Drive Strength Selection for Port C Bit 7
; bit position masks
mPTCDS_PTCDS0:      equ    %00000001
mPTCDS_PTCDS1:      equ    %00000010
mPTCDS_PTCDS2:      equ    %00000100
mPTCDS_PTCDS3:      equ    %00001000
mPTCDS_PTCDS4:      equ    %00010000
mPTCDS_PTCDS5:      equ    %00100000
mPTCDS_PTCDS6:      equ    %01000000
mPTCDS_PTCDS7:      equ    %10000000


;*** PTDPE - Port D Pull Enable Register; 0x0000184C ***
PTDPE:              equ    $0000184C                                ;*** PTDPE - Port D Pull Enable Register; 0x0000184C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDPE_PTDPE0:       equ    0                                         ; Internal Pull Enable for Port D Bit 0
PTDPE_PTDPE1:       equ    1                                         ; Internal Pull Enable for Port D Bit 1
PTDPE_PTDPE2:       equ    2                                         ; Internal Pull Enable for Port D Bit 2
PTDPE_PTDPE3:       equ    3                                         ; Internal Pull Enable for Port D Bit 3
PTDPE_PTDPE4:       equ    4                                         ; Internal Pull Enable for Port D Bit 4
PTDPE_PTDPE5:       equ    5                                         ; Internal Pull Enable for Port D Bit 5
; bit position masks
mPTDPE_PTDPE0:      equ    %00000001
mPTDPE_PTDPE1:      equ    %00000010
mPTDPE_PTDPE2:      equ    %00000100
mPTDPE_PTDPE3:      equ    %00001000
mPTDPE_PTDPE4:      equ    %00010000
mPTDPE_PTDPE5:      equ    %00100000


;*** PTDSE - Port D Slew Rate Enable Register; 0x0000184D ***
PTDSE:              equ    $0000184D                                ;*** PTDSE - Port D Slew Rate Enable Register; 0x0000184D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDSE_PTDSE0:       equ    0                                         ; Output Slew Rate Enable for Port D Bit 0
PTDSE_PTDSE1:       equ    1                                         ; Output Slew Rate Enable for Port D Bit 1
PTDSE_PTDSE2:       equ    2                                         ; Output Slew Rate Enable for Port D Bit 2
PTDSE_PTDSE3:       equ    3                                         ; Output Slew Rate Enable for Port D Bit 3
PTDSE_PTDSE4:       equ    4                                         ; Output Slew Rate Enable for Port D Bit 4
PTDSE_PTDSE5:       equ    5                                         ; Output Slew Rate Enable for Port D Bit 5
; bit position masks
mPTDSE_PTDSE0:      equ    %00000001
mPTDSE_PTDSE1:      equ    %00000010
mPTDSE_PTDSE2:      equ    %00000100
mPTDSE_PTDSE3:      equ    %00001000
mPTDSE_PTDSE4:      equ    %00010000
mPTDSE_PTDSE5:      equ    %00100000


;*** PTDDS - Port D Drive Strength Selection Register; 0x0000184E ***
PTDDS:              equ    $0000184E                                ;*** PTDDS - Port D Drive Strength Selection Register; 0x0000184E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDDS_PTDDS0:       equ    0                                         ; Output Drive Strength Selection for Port D Bit 0
PTDDS_PTDDS1:       equ    1                                         ; Output Drive Strength Selection for Port D Bit 1
PTDDS_PTDDS2:       equ    2                                         ; Output Drive Strength Selection for Port D Bit 2
PTDDS_PTDDS3:       equ    3                                         ; Output Drive Strength Selection for Port D Bit 3
PTDDS_PTDDS4:       equ    4                                         ; Output Drive Strength Selection for Port D Bit 4
PTDDS_PTDDS5:       equ    5                                         ; Output Drive Strength Selection for Port D Bit 5
; bit position masks
mPTDDS_PTDDS0:      equ    %00000001
mPTDDS_PTDDS1:      equ    %00000010
mPTDDS_PTDDS2:      equ    %00000100
mPTDDS_PTDDS3:      equ    %00001000
mPTDDS_PTDDS4:      equ    %00010000
mPTDDS_PTDDS5:      equ    %00100000


;*** SCIBD - SCI Baud Rate Register; 0x00001850 ***
SCIBD:              equ    $00001850                                ;*** SCIBD - SCI Baud Rate Register; 0x00001850 ***


;*** SCIBDH - SCI Baud Rate Register High; 0x00001850 ***
SCIBDH:             equ    $00001850                                ;*** SCIBDH - SCI Baud Rate Register High; 0x00001850 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDH_SBR8:        equ    0                                         ; Baud Rate Modulo Divisor Bit 8
SCIBDH_SBR9:        equ    1                                         ; Baud Rate Modulo Divisor Bit 9
SCIBDH_SBR10:       equ    2                                         ; Baud Rate Modulo Divisor Bit 10
SCIBDH_SBR11:       equ    3                                         ; Baud Rate Modulo Divisor Bit 11
SCIBDH_SBR12:       equ    4                                         ; Baud Rate Modulo Divisor Bit 12
SCIBDH_RXEDGIE:     equ    6                                         ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
SCIBDH_LBKDIE:      equ    7                                         ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mSCIBDH_SBR8:       equ    %00000001
mSCIBDH_SBR9:       equ    %00000010
mSCIBDH_SBR10:      equ    %00000100
mSCIBDH_SBR11:      equ    %00001000
mSCIBDH_SBR12:      equ    %00010000
mSCIBDH_RXEDGIE:    equ    %01000000
mSCIBDH_LBKDIE:     equ    %10000000


;*** SCIBDL - SCI Baud Rate Register Low; 0x00001851 ***
SCIBDL:             equ    $00001851                                ;*** SCIBDL - SCI Baud Rate Register Low; 0x00001851 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDL_SBR0:        equ    0                                         ; Baud Rate Modulo Divisor Bit 0
SCIBDL_SBR1:        equ    1                                         ; Baud Rate Modulo Divisor Bit 1
SCIBDL_SBR2:        equ    2                                         ; Baud Rate Modulo Divisor Bit 2
SCIBDL_SBR3:        equ    3                                         ; Baud Rate Modulo Divisor Bit 3
SCIBDL_SBR4:        equ    4                                         ; Baud Rate Modulo Divisor Bit 4
SCIBDL_SBR5:        equ    5                                         ; Baud Rate Modulo Divisor Bit 5
SCIBDL_SBR6:        equ    6                                         ; Baud Rate Modulo Divisor Bit 6
SCIBDL_SBR7:        equ    7                                         ; Baud Rate Modulo Divisor Bit 7
; bit position masks
mSCIBDL_SBR0:       equ    %00000001
mSCIBDL_SBR1:       equ    %00000010
mSCIBDL_SBR2:       equ    %00000100
mSCIBDL_SBR3:       equ    %00001000
mSCIBDL_SBR4:       equ    %00010000
mSCIBDL_SBR5:       equ    %00100000
mSCIBDL_SBR6:       equ    %01000000
mSCIBDL_SBR7:       equ    %10000000


;*** SCIC1 - SCI Control Register 1; 0x00001852 ***
SCIC1:              equ    $00001852                                ;*** SCIC1 - SCI Control Register 1; 0x00001852 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC1_PT:           equ    0                                         ; Parity Type
SCIC1_PE:           equ    1                                         ; Parity Enable
SCIC1_ILT:          equ    2                                         ; Idle Line Type Select
SCIC1_WAKE:         equ    3                                         ; Receiver Wakeup Method Select
SCIC1_M:            equ    4                                         ; 9-Bit or 8-Bit Mode Select
SCIC1_RSRC:         equ    5                                         ; Receiver Source Select
SCIC1_SCISWAI:      equ    6                                         ; SCI Stops in Wait Mode
SCIC1_LOOPS:        equ    7                                         ; Loop Mode Select
; bit position masks
mSCIC1_PT:          equ    %00000001
mSCIC1_PE:          equ    %00000010
mSCIC1_ILT:         equ    %00000100
mSCIC1_WAKE:        equ    %00001000
mSCIC1_M:           equ    %00010000
mSCIC1_RSRC:        equ    %00100000
mSCIC1_SCISWAI:     equ    %01000000
mSCIC1_LOOPS:       equ    %10000000


;*** SCIC2 - SCI Control Register 2; 0x00001853 ***
SCIC2:              equ    $00001853                                ;*** SCIC2 - SCI Control Register 2; 0x00001853 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC2_SBK:          equ    0                                         ; Send Break
SCIC2_RWU:          equ    1                                         ; Receiver Wakeup Control
SCIC2_RE:           equ    2                                         ; Receiver Enable
SCIC2_TE:           equ    3                                         ; Transmitter Enable
SCIC2_ILIE:         equ    4                                         ; Idle Line Interrupt Enable (for IDLE)
SCIC2_RIE:          equ    5                                         ; Receiver Interrupt Enable (for RDRF)
SCIC2_TCIE:         equ    6                                         ; Transmission Complete Interrupt Enable (for TC)
SCIC2_TIE:          equ    7                                         ; Transmit Interrupt Enable (for TDRE)
; bit position masks
mSCIC2_SBK:         equ    %00000001
mSCIC2_RWU:         equ    %00000010
mSCIC2_RE:          equ    %00000100
mSCIC2_TE:          equ    %00001000
mSCIC2_ILIE:        equ    %00010000
mSCIC2_RIE:         equ    %00100000
mSCIC2_TCIE:        equ    %01000000
mSCIC2_TIE:         equ    %10000000


;*** SCIS1 - SCI Status Register 1; 0x00001854 ***
SCIS1:              equ    $00001854                                ;*** SCIS1 - SCI Status Register 1; 0x00001854 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIS1_PF:           equ    0                                         ; Parity Error Flag
SCIS1_FE:           equ    1                                         ; Framing Error Flag
SCIS1_NF:           equ    2                                         ; Noise Flag
SCIS1_OR:           equ    3                                         ; Receiver Overrun Flag
SCIS1_IDLE:         equ    4                                         ; Idle Line Flag
SCIS1_RDRF:         equ    5                                         ; Receive Data Register Full Flag
SCIS1_TC:           equ    6                                         ; Transmission Complete Flag
SCIS1_TDRE:         equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCIS1_PF:          equ    %00000001
mSCIS1_FE:          equ    %00000010
mSCIS1_NF:          equ    %00000100
mSCIS1_OR:          equ    %00001000
mSCIS1_IDLE:        equ    %00010000
mSCIS1_RDRF:        equ    %00100000
mSCIS1_TC:          equ    %01000000
mSCIS1_TDRE:        equ    %10000000


;*** SCIS2 - SCI Status Register 2; 0x00001855 ***
SCIS2:              equ    $00001855                                ;*** SCIS2 - SCI Status Register 2; 0x00001855 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIS2_RAF:          equ    0                                         ; Receiver Active Flag
SCIS2_LBKDE:        equ    1                                         ; LIN Break Detection Enable
SCIS2_BRK13:        equ    2                                         ; Break Character Generation Length
SCIS2_RWUID:        equ    3                                         ; Receive Wake Up Idle Detect
SCIS2_RXINV:        equ    4                                         ; Receive Data Inversion
SCIS2_RXEDGIF:      equ    6                                         ; RxD Pin Active Edge Interrupt Flag
SCIS2_LBKDIF:       equ    7                                         ; LIN Break Detect Interrupt Flag
; bit position masks
mSCIS2_RAF:         equ    %00000001
mSCIS2_LBKDE:       equ    %00000010
mSCIS2_BRK13:       equ    %00000100
mSCIS2_RWUID:       equ    %00001000
mSCIS2_RXINV:       equ    %00010000
mSCIS2_RXEDGIF:     equ    %01000000
mSCIS2_LBKDIF:      equ    %10000000


;*** SCIC3 - SCI Control Register 3; 0x00001856 ***
SCIC3:              equ    $00001856                                ;*** SCIC3 - SCI Control Register 3; 0x00001856 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC3_PEIE:         equ    0                                         ; Parity Error Interrupt Enable
SCIC3_FEIE:         equ    1                                         ; Framing Error Interrupt Enable
SCIC3_NEIE:         equ    2                                         ; Noise Error Interrupt Enable
SCIC3_ORIE:         equ    3                                         ; Overrun Interrupt Enable
SCIC3_TXINV:        equ    4                                         ; Transmit Data Inversion
SCIC3_TXDIR:        equ    5                                         ; TxD Pin Direction in Single-Wire Mode
SCIC3_T8:           equ    6                                         ; Ninth Data Bit for Transmitter
SCIC3_R8:           equ    7                                         ; Ninth Data Bit for Receiver
; bit position masks
mSCIC3_PEIE:        equ    %00000001
mSCIC3_FEIE:        equ    %00000010
mSCIC3_NEIE:        equ    %00000100
mSCIC3_ORIE:        equ    %00001000
mSCIC3_TXINV:       equ    %00010000
mSCIC3_TXDIR:       equ    %00100000
mSCIC3_T8:          equ    %01000000
mSCIC3_R8:          equ    %10000000


;*** SCID - SCI Data Register; 0x00001857 ***
SCID:               equ    $00001857                                ;*** SCID - SCI Data Register; 0x00001857 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCID_R0_T0:         equ    0                                         ; Receive/Transmit Data Bit 0
SCID_R1_T1:         equ    1                                         ; Receive/Transmit Data Bit 1
SCID_R2_T2:         equ    2                                         ; Receive/Transmit Data Bit 2
SCID_R3_T3:         equ    3                                         ; Receive/Transmit Data Bit 3
SCID_R4_T4:         equ    4                                         ; Receive/Transmit Data Bit 4
SCID_R5_T5:         equ    5                                         ; Receive/Transmit Data Bit 5
SCID_R6_T6:         equ    6                                         ; Receive/Transmit Data Bit 6
SCID_R7_T7:         equ    7                                         ; Receive/Transmit Data Bit 7
; bit position masks
mSCID_R0_T0:        equ    %00000001
mSCID_R1_T1:        equ    %00000010
mSCID_R2_T2:        equ    %00000100
mSCID_R3_T3:        equ    %00001000
mSCID_R4_T4:        equ    %00010000
mSCID_R5_T5:        equ    %00100000
mSCID_R6_T6:        equ    %01000000
mSCID_R7_T7:        equ    %10000000


;*** ICSC1 - ICS Control Register 1; 0x00001858 ***
ICSC1:              equ    $00001858                                ;*** ICSC1 - ICS Control Register 1; 0x00001858 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSC1_IREFSTEN:     equ    0                                         ; Internal Reference Stop Enable
ICSC1_IRCLKEN:      equ    1                                         ; Internal Reference Clock Enable
ICSC1_IREFS:        equ    2                                         ; Internal Reference Select
ICSC1_RDIV0:        equ    3                                         ; Reference Divider, bit 0
ICSC1_RDIV1:        equ    4                                         ; Reference Divider, bit 1
ICSC1_RDIV2:        equ    5                                         ; Reference Divider, bit 2
ICSC1_CLKS0:        equ    6                                         ; Clock Source Select, bit 0
ICSC1_CLKS1:        equ    7                                         ; Clock Source Select, bit 1
; bit position masks
mICSC1_IREFSTEN:    equ    %00000001
mICSC1_IRCLKEN:     equ    %00000010
mICSC1_IREFS:       equ    %00000100
mICSC1_RDIV0:       equ    %00001000
mICSC1_RDIV1:       equ    %00010000
mICSC1_RDIV2:       equ    %00100000
mICSC1_CLKS0:       equ    %01000000
mICSC1_CLKS1:       equ    %10000000


;*** ICSC2 - ICS Control Register 2; 0x00001859 ***
ICSC2:              equ    $00001859                                ;*** ICSC2 - ICS Control Register 2; 0x00001859 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSC2_EREFSTEN:     equ    0                                         ; External Reference Stop Enable
ICSC2_ERCLKEN:      equ    1                                         ; External Reference Enable
ICSC2_EREFS:        equ    2                                         ; External Reference Select
ICSC2_LP:           equ    3                                         ; Low Power Select
ICSC2_HGO:          equ    4                                         ; High Gain Oscillator Select
ICSC2_RANGE:        equ    5                                         ; Frequency Range Select
ICSC2_BDIV0:        equ    6                                         ; Bus Frequency Divider, bit 0
ICSC2_BDIV1:        equ    7                                         ; Bus Frequency Divider, bit 1
; bit position masks
mICSC2_EREFSTEN:    equ    %00000001
mICSC2_ERCLKEN:     equ    %00000010
mICSC2_EREFS:       equ    %00000100
mICSC2_LP:          equ    %00001000
mICSC2_HGO:         equ    %00010000
mICSC2_RANGE:       equ    %00100000
mICSC2_BDIV0:       equ    %01000000
mICSC2_BDIV1:       equ    %10000000


;*** ICSTRM - ICS Trim Register; 0x0000185A ***
ICSTRM:             equ    $0000185A                                ;*** ICSTRM - ICS Trim Register; 0x0000185A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSTRM_TRIM0:       equ    0                                         ; ICS Trim Setting, bit 0
ICSTRM_TRIM1:       equ    1                                         ; ICS Trim Setting, bit 1
ICSTRM_TRIM2:       equ    2                                         ; ICS Trim Setting, bit 2
ICSTRM_TRIM3:       equ    3                                         ; ICS Trim Setting, bit 3
ICSTRM_TRIM4:       equ    4                                         ; ICS Trim Setting, bit 4
ICSTRM_TRIM5:       equ    5                                         ; ICS Trim Setting, bit 5
ICSTRM_TRIM6:       equ    6                                         ; ICS Trim Setting, bit 6
ICSTRM_TRIM7:       equ    7                                         ; ICS Trim Setting, bit 7
; bit position masks
mICSTRM_TRIM0:      equ    %00000001
mICSTRM_TRIM1:      equ    %00000010
mICSTRM_TRIM2:      equ    %00000100
mICSTRM_TRIM3:      equ    %00001000
mICSTRM_TRIM4:      equ    %00010000
mICSTRM_TRIM5:      equ    %00100000
mICSTRM_TRIM6:      equ    %01000000
mICSTRM_TRIM7:      equ    %10000000


;*** ICSSC - ICS Status and Control Register; 0x0000185B ***
ICSSC:              equ    $0000185B                                ;*** ICSSC - ICS Status and Control Register; 0x0000185B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSSC_FTRIM:        equ    0                                         ; ICS Fine Trim
ICSSC_OSCINIT:      equ    1                                         ; OSC Initialization
ICSSC_CLKST0:       equ    2                                         ; Clock Mode Status, bit 0
ICSSC_CLKST1:       equ    3                                         ; Clock Mode Status, bit 1
ICSSC_IREFST:       equ    4                                         ; Internal Reference Status
ICSSC_DMX32:        equ    5                                         ; DCO Maximum frequency with 32.768 kHz reference
ICSSC_DRST_DRS0:    equ    6                                         ; DCO Range Status/Range Select, bit 0
ICSSC_DRST_DRS1:    equ    7                                         ; DCO Range Status/Range Select, bit 1
; bit position masks
mICSSC_FTRIM:       equ    %00000001
mICSSC_OSCINIT:     equ    %00000010
mICSSC_CLKST0:      equ    %00000100
mICSSC_CLKST1:      equ    %00001000
mICSSC_IREFST:      equ    %00010000
mICSSC_DMX32:       equ    %00100000
mICSSC_DRST_DRS0:   equ    %01000000
mICSSC_DRST_DRS1:   equ    %10000000


;*** RTCSC - RTC Status and Control Register; 0x0000185C ***
RTCSC:              equ    $0000185C                                ;*** RTCSC - RTC Status and Control Register; 0x0000185C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTCSC_RTCPS0:       equ    0                                         ; Real-Time Clock Prescaler Select, bit 0
RTCSC_RTCPS1:       equ    1                                         ; Real-Time Clock Prescaler Select, bit 1
RTCSC_RTCPS2:       equ    2                                         ; Real-Time Clock Prescaler Select, bit 2
RTCSC_RTCPS3:       equ    3                                         ; Real-Time Clock Prescaler Select, bit 3
RTCSC_RTIE:         equ    4                                         ; Real-Time Interrupt Enable
RTCSC_RTCLKS0:      equ    5                                         ; Real-Time Clock Source Select, bit 0
RTCSC_RTCLKS1:      equ    6                                         ; Real-Time Clock Source Select, bit 1
RTCSC_RTIF:         equ    7                                         ; Real-Time Interrupt Flag
; bit position masks
mRTCSC_RTCPS0:      equ    %00000001
mRTCSC_RTCPS1:      equ    %00000010
mRTCSC_RTCPS2:      equ    %00000100
mRTCSC_RTCPS3:      equ    %00001000
mRTCSC_RTIE:        equ    %00010000
mRTCSC_RTCLKS0:     equ    %00100000
mRTCSC_RTCLKS1:     equ    %01000000
mRTCSC_RTIF:        equ    %10000000


;*** RTCCNT - RTC Counter Register; 0x0000185D ***
RTCCNT:             equ    $0000185D                                ;*** RTCCNT - RTC Counter Register; 0x0000185D ***


;*** RTCMOD - RTC Modulo Register; 0x0000185E ***
RTCMOD:             equ    $0000185E                                ;*** RTCMOD - RTC Modulo Register; 0x0000185E ***


;*** MTIMSC - MTIM16 Status and Control Register; 0x00001860 ***
MTIMSC:             equ    $00001860                                ;*** MTIMSC - MTIM16 Status and Control Register; 0x00001860 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTIMSC_TSTP:        equ    4                                         ; MTIM16 Counter Stop
MTIMSC_TRST:        equ    5                                         ; MTIM16 Counter Reset
MTIMSC_TOIE:        equ    6                                         ; MTIM16 Overflow Interrupt Enable
MTIMSC_TOF:         equ    7                                         ; MTIM16 Overflow Flag
; bit position masks
mMTIMSC_TSTP:       equ    %00010000
mMTIMSC_TRST:       equ    %00100000
mMTIMSC_TOIE:       equ    %01000000
mMTIMSC_TOF:        equ    %10000000


;*** MTIMCLK - MTIM16 Clock Configuration Register; 0x00001861 ***
MTIMCLK:            equ    $00001861                                ;*** MTIMCLK - MTIM16 Clock Configuration Register; 0x00001861 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTIMCLK_PS0:        equ    0                                         ; Clock source Prescaler Bit 0
MTIMCLK_PS1:        equ    1                                         ; Clock source Prescaler Bit 1
MTIMCLK_PS2:        equ    2                                         ; Clock source Prescaler Bit 2
MTIMCLK_PS3:        equ    3                                         ; Clock source Prescaler Bit 3
MTIMCLK_CLKS0:      equ    4                                         ; Clock source Select Bit 0
MTIMCLK_CLKS1:      equ    5                                         ; Clock source Select Bit 1
; bit position masks
mMTIMCLK_PS0:       equ    %00000001
mMTIMCLK_PS1:       equ    %00000010
mMTIMCLK_PS2:       equ    %00000100
mMTIMCLK_PS3:       equ    %00001000
mMTIMCLK_CLKS0:     equ    %00010000
mMTIMCLK_CLKS1:     equ    %00100000


;*** MTIMCNT - MTIM16 Counter Register; 0x00001862 ***
MTIMCNT:            equ    $00001862                                ;*** MTIMCNT - MTIM16 Counter Register; 0x00001862 ***


;*** MTIMCNTH - MTIM16 Counter Register High; 0x00001862 ***
MTIMCNTH:           equ    $00001862                                ;*** MTIMCNTH - MTIM16 Counter Register High; 0x00001862 ***


;*** MTIMCNTL - MTIM16 Counter Register Low; 0x00001863 ***
MTIMCNTL:           equ    $00001863                                ;*** MTIMCNTL - MTIM16 Counter Register Low; 0x00001863 ***


;*** MTIMMOD - MTIM16 Modulo Register; 0x00001864 ***
MTIMMOD:            equ    $00001864                                ;*** MTIMMOD - MTIM16 Modulo Register; 0x00001864 ***


;*** MTIMMODH - MTIM16 Modulo Register High; 0x00001864 ***
MTIMMODH:           equ    $00001864                                ;*** MTIMMODH - MTIM16 Modulo Register High; 0x00001864 ***


;*** MTIMMODL - MTIM16 Modulo Register Low; 0x00001865 ***
MTIMMODL:           equ    $00001865                                ;*** MTIMMODL - MTIM16 Modulo Register Low; 0x00001865 ***


;*** SPIC1 - SPI Control Register 1; 0x00001868 ***
SPIC1:              equ    $00001868                                ;*** SPIC1 - SPI Control Register 1; 0x00001868 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIC1_LSBFE:        equ    0                                         ; LSB First (Shifter Direction)
SPIC1_SSOE:         equ    1                                         ; Slave Select Output Enable
SPIC1_CPHA:         equ    2                                         ; Clock Phase
SPIC1_CPOL:         equ    3                                         ; Clock Polarity
SPIC1_MSTR:         equ    4                                         ; Master/Slave Mode Select
SPIC1_SPTIE:        equ    5                                         ; SPI Transmit Interrupt Enable
SPIC1_SPE:          equ    6                                         ; SPI System Enable
SPIC1_SPIE:         equ    7                                         ; SPI Interrupt Enable (for SPRF and MODF)
; bit position masks
mSPIC1_LSBFE:       equ    %00000001
mSPIC1_SSOE:        equ    %00000010
mSPIC1_CPHA:        equ    %00000100
mSPIC1_CPOL:        equ    %00001000
mSPIC1_MSTR:        equ    %00010000
mSPIC1_SPTIE:       equ    %00100000
mSPIC1_SPE:         equ    %01000000
mSPIC1_SPIE:        equ    %10000000


;*** SPIC2 - SPI Control Register 2; 0x00001869 ***
SPIC2:              equ    $00001869                                ;*** SPIC2 - SPI Control Register 2; 0x00001869 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIC2_SPC0:         equ    0                                         ; SPI Pin Control 0
SPIC2_SPISWAI:      equ    1                                         ; SPI Stop in Wait Mode
SPIC2_BIDIROE:      equ    3                                         ; Bidirectional Mode Output Enable
SPIC2_MODFEN:       equ    4                                         ; Master Mode-Fault Function Enable
; bit position masks
mSPIC2_SPC0:        equ    %00000001
mSPIC2_SPISWAI:     equ    %00000010
mSPIC2_BIDIROE:     equ    %00001000
mSPIC2_MODFEN:      equ    %00010000


;*** SPIBR - SPI Baud Rate Register; 0x0000186A ***
SPIBR:              equ    $0000186A                                ;*** SPIBR - SPI Baud Rate Register; 0x0000186A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Divisor Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Divisor Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Divisor Bit 2
SPIBR_SPR3:         equ    3                                         ; SPI Baud Rate Divisor Bit 3
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Prescale Divisor Bit 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Prescale Divisor Bit 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Prescale Divisor Bit 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPR3:        equ    %00001000
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPIS - SPI Status Register; 0x0000186B ***
SPIS:               equ    $0000186B                                ;*** SPIS - SPI Status Register; 0x0000186B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIS_MODF:          equ    4                                         ; Master Mode Fault Flag
SPIS_SPTEF:         equ    5                                         ; SPI Transmit Buffer Empty Flag
SPIS_SPRF:          equ    7                                         ; SPI Read Buffer Full Flag
; bit position masks
mSPIS_MODF:         equ    %00010000
mSPIS_SPTEF:        equ    %00100000
mSPIS_SPRF:         equ    %10000000


;*** SPID - SPI Data Register; 0x0000186D ***
SPID:               equ    $0000186D                                ;*** SPID - SPI Data Register; 0x0000186D ***


;*** IICA - IIC Address Register; 0x00001870 ***
IICA:               equ    $00001870                                ;*** IICA - IIC Address Register; 0x00001870 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICA_AD1:           equ    1                                         ; Slave Address Bit 1
IICA_AD2:           equ    2                                         ; Slave Address Bit 2
IICA_AD3:           equ    3                                         ; Slave Address Bit 3
IICA_AD4:           equ    4                                         ; Slave Address Bit 4
IICA_AD5:           equ    5                                         ; Slave Address Bit 5
IICA_AD6:           equ    6                                         ; Slave Address Bit 6
IICA_AD7:           equ    7                                         ; Slave Address Bit 7
; bit position masks
mIICA_AD1:          equ    %00000010
mIICA_AD2:          equ    %00000100
mIICA_AD3:          equ    %00001000
mIICA_AD4:          equ    %00010000
mIICA_AD5:          equ    %00100000
mIICA_AD6:          equ    %01000000
mIICA_AD7:          equ    %10000000


;*** IICF - IIC Frequency Divider Register; 0x00001871 ***
IICF:               equ    $00001871                                ;*** IICF - IIC Frequency Divider Register; 0x00001871 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICF_ICR0:          equ    0                                         ; IIC Clock Rate Bit 0
IICF_ICR1:          equ    1                                         ; IIC Clock Rate Bit 1
IICF_ICR2:          equ    2                                         ; IIC Clock Rate Bit 2
IICF_ICR3:          equ    3                                         ; IIC Clock Rate Bit 3
IICF_ICR4:          equ    4                                         ; IIC Clock Rate Bit 4
IICF_ICR5:          equ    5                                         ; IIC Clock Rate Bit 5
IICF_MULT0:         equ    6                                         ; Multiplier Factor Bit 0
IICF_MULT1:         equ    7                                         ; Multiplier Factor Bit 1
; bit position masks
mIICF_ICR0:         equ    %00000001
mIICF_ICR1:         equ    %00000010
mIICF_ICR2:         equ    %00000100
mIICF_ICR3:         equ    %00001000
mIICF_ICR4:         equ    %00010000
mIICF_ICR5:         equ    %00100000
mIICF_MULT0:        equ    %01000000
mIICF_MULT1:        equ    %10000000


;*** IICC1 - IIC Control Register 1; 0x00001872 ***
IICC1:              equ    $00001872                                ;*** IICC1 - IIC Control Register 1; 0x00001872 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC1_RSTA:         equ    2                                         ; Repeat START
IICC1_TXAK:         equ    3                                         ; Transmit Acknowledge Enable
IICC1_TX:           equ    4                                         ; Transmit Mode Select
IICC1_MST:          equ    5                                         ; Master Mode Select
IICC1_IICIE:        equ    6                                         ; IIC Interrupt Enable
IICC1_IICEN:        equ    7                                         ; IIC Enable
; bit position masks
mIICC1_RSTA:        equ    %00000100
mIICC1_TXAK:        equ    %00001000
mIICC1_TX:          equ    %00010000
mIICC1_MST:         equ    %00100000
mIICC1_IICIE:       equ    %01000000
mIICC1_IICEN:       equ    %10000000


;*** IICC - IIC Control Register; 0x00001872 ***
IICC:               equ    $00001872                                ;*** IICC - IIC Control Register; 0x00001872 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC_RSTA:          equ    2                                         ; Repeat START
IICC_TXAK:          equ    3                                         ; Transmit Acknowledge Enable
IICC_TX:            equ    4                                         ; Transmit Mode Select
IICC_MST:           equ    5                                         ; Master Mode Select
IICC_IICIE:         equ    6                                         ; IIC Interrupt Enable
IICC_IICEN:         equ    7                                         ; IIC Enable
; bit position masks
mIICC_RSTA:         equ    %00000100
mIICC_TXAK:         equ    %00001000
mIICC_TX:           equ    %00010000
mIICC_MST:          equ    %00100000
mIICC_IICIE:        equ    %01000000
mIICC_IICEN:        equ    %10000000


;*** IICS - IIC Status Register; 0x00001873 ***
IICS:               equ    $00001873                                ;*** IICS - IIC Status Register; 0x00001873 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICS_RXAK:          equ    0                                         ; Receive Acknowledge
IICS_IICIF:         equ    1                                         ; IIC Interrupt Flag
IICS_SRW:           equ    2                                         ; Slave Read/Write
IICS_ARBL:          equ    4                                         ; Arbitration Lost
IICS_BUSY:          equ    5                                         ; Bus Busy
IICS_IAAS:          equ    6                                         ; Addressed as a Slave
IICS_TCF:           equ    7                                         ; Transfer Complete Flag
; bit position masks
mIICS_RXAK:         equ    %00000001
mIICS_IICIF:        equ    %00000010
mIICS_SRW:          equ    %00000100
mIICS_ARBL:         equ    %00010000
mIICS_BUSY:         equ    %00100000
mIICS_IAAS:         equ    %01000000
mIICS_TCF:          equ    %10000000


;*** IICD - IIC Data I/O Register; 0x00001874 ***
IICD:               equ    $00001874                                ;*** IICD - IIC Data I/O Register; 0x00001874 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICD_DATA0:         equ    0                                         ; IIC Data Bit 0
IICD_DATA1:         equ    1                                         ; IIC Data Bit 1
IICD_DATA2:         equ    2                                         ; IIC Data Bit 2
IICD_DATA3:         equ    3                                         ; IIC Data Bit 3
IICD_DATA4:         equ    4                                         ; IIC Data Bit 4
IICD_DATA5:         equ    5                                         ; IIC Data Bit 5
IICD_DATA6:         equ    6                                         ; IIC Data Bit 6
IICD_DATA7:         equ    7                                         ; IIC Data Bit 7
; bit position masks
mIICD_DATA0:        equ    %00000001
mIICD_DATA1:        equ    %00000010
mIICD_DATA2:        equ    %00000100
mIICD_DATA3:        equ    %00001000
mIICD_DATA4:        equ    %00010000
mIICD_DATA5:        equ    %00100000
mIICD_DATA6:        equ    %01000000
mIICD_DATA7:        equ    %10000000


;*** IICC2 - IIC Control Register 2; 0x00001875 ***
IICC2:              equ    $00001875                                ;*** IICC2 - IIC Control Register 2; 0x00001875 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC2_AD8:          equ    0                                         ; Slave Address Bit 8
IICC2_AD9:          equ    1                                         ; Slave Address Bit 9
IICC2_AD10:         equ    2                                         ; Slave Address Bit 10
IICC2_ADEXT:        equ    6                                         ; Address Extension
IICC2_GCAEN:        equ    7                                         ; General Call Address Enable
; bit position masks
mIICC2_AD8:         equ    %00000001
mIICC2_AD9:         equ    %00000010
mIICC2_AD10:        equ    %00000100
mIICC2_ADEXT:       equ    %01000000
mIICC2_GCAEN:       equ    %10000000


;*** ILRS0 - Interrupt Level Setting Register; 0x00001878 ***
ILRS0:              equ    $00001878                                ;*** ILRS0 - Interrupt Level Setting Register; 0x00001878 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ILRS0_ILR00:        equ    0                                         ; Interrupt Level Register for Source 0, bit 0
ILRS0_ILR01:        equ    1                                         ; Interrupt Level Register for Source 0, bit 1
ILRS0_ILR10:        equ    2                                         ; Interrupt Level Register for Source 1, bit 0
ILRS0_ILR11:        equ    3                                         ; Interrupt Level Register for Source 1, bit 1
ILRS0_ILR20:        equ    4                                         ; Interrupt Level Register for Source 2, bit 0
ILRS0_ILR21:        equ    5                                         ; Interrupt Level Register for Source 2, bit 1
ILRS0_ILR30:        equ    6                                         ; Interrupt Level Register for Source 3, bit 0
ILRS0_ILR31:        equ    7                                         ; Interrupt Level Register for Source 3, bit 1
; bit position masks
mILRS0_ILR00:       equ    %00000001
mILRS0_ILR01:       equ    %00000010
mILRS0_ILR10:       equ    %00000100
mILRS0_ILR11:       equ    %00001000
mILRS0_ILR20:       equ    %00010000
mILRS0_ILR21:       equ    %00100000
mILRS0_ILR30:       equ    %01000000
mILRS0_ILR31:       equ    %10000000


;*** ILRS1 - Interrupt Level Setting Register; 0x00001879 ***
ILRS1:              equ    $00001879                                ;*** ILRS1 - Interrupt Level Setting Register; 0x00001879 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ILRS1_ILR40:        equ    0                                         ; Interrupt Level Register for Source 4, bit 0
ILRS1_ILR41:        equ    1                                         ; Interrupt Level Register for Source 4, bit 1
ILRS1_ILR50:        equ    2                                         ; Interrupt Level Register for Source 5, bit 0
ILRS1_ILR51:        equ    3                                         ; Interrupt Level Register for Source 5, bit 1
ILRS1_ILR60:        equ    4                                         ; Interrupt Level Register for Source 6, bit 0
ILRS1_ILR61:        equ    5                                         ; Interrupt Level Register for Source 6, bit 1
ILRS1_ILR70:        equ    6                                         ; Interrupt Level Register for Source 7, bit 0
ILRS1_ILR71:        equ    7                                         ; Interrupt Level Register for Source 7, bit 1
; bit position masks
mILRS1_ILR40:       equ    %00000001
mILRS1_ILR41:       equ    %00000010
mILRS1_ILR50:       equ    %00000100
mILRS1_ILR51:       equ    %00001000
mILRS1_ILR60:       equ    %00010000
mILRS1_ILR61:       equ    %00100000
mILRS1_ILR70:       equ    %01000000
mILRS1_ILR71:       equ    %10000000


;*** ILRS2 - Interrupt Level Setting Register; 0x0000187A ***
ILRS2:              equ    $0000187A                                ;*** ILRS2 - Interrupt Level Setting Register; 0x0000187A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ILRS2_ILR80:        equ    0                                         ; Interrupt Level Register for Source 8, bit 0
ILRS2_ILR81:        equ    1                                         ; Interrupt Level Register for Source 8, bit 1
ILRS2_ILR90:        equ    2                                         ; Interrupt Level Register for Source 9, bit 0
ILRS2_ILR91:        equ    3                                         ; Interrupt Level Register for Source 9, bit 1
ILRS2_ILR100:       equ    4                                         ; Interrupt Level Register for Source 10, bit 0
ILRS2_ILR101:       equ    5                                         ; Interrupt Level Register for Source 10, bit 1
ILRS2_ILR110:       equ    6                                         ; Interrupt Level Register for Source 11, bit 0
ILRS2_ILR111:       equ    7                                         ; Interrupt Level Register for Source 11, bit 1
; bit position masks
mILRS2_ILR80:       equ    %00000001
mILRS2_ILR81:       equ    %00000010
mILRS2_ILR90:       equ    %00000100
mILRS2_ILR91:       equ    %00001000
mILRS2_ILR100:      equ    %00010000
mILRS2_ILR101:      equ    %00100000
mILRS2_ILR110:      equ    %01000000
mILRS2_ILR111:      equ    %10000000


;*** ILRS3 - Interrupt Level Setting Register; 0x0000187B ***
ILRS3:              equ    $0000187B                                ;*** ILRS3 - Interrupt Level Setting Register; 0x0000187B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ILRS3_ILR120:       equ    0                                         ; Interrupt Level Register for Source 12, bit 0
ILRS3_ILR121:       equ    1                                         ; Interrupt Level Register for Source 12, bit 1
ILRS3_ILR130:       equ    2                                         ; Interrupt Level Register for Source 13, bit 0
ILRS3_ILR131:       equ    3                                         ; Interrupt Level Register for Source 13, bit 1
ILRS3_ILR140:       equ    4                                         ; Interrupt Level Register for Source 14, bit 0
ILRS3_ILR141:       equ    5                                         ; Interrupt Level Register for Source 14, bit 1
ILRS3_ILR150:       equ    6                                         ; Interrupt Level Register for Source 15, bit 0
ILRS3_ILR151:       equ    7                                         ; Interrupt Level Register for Source 15, bit 1
; bit position masks
mILRS3_ILR120:      equ    %00000001
mILRS3_ILR121:      equ    %00000010
mILRS3_ILR130:      equ    %00000100
mILRS3_ILR131:      equ    %00001000
mILRS3_ILR140:      equ    %00010000
mILRS3_ILR141:      equ    %00100000
mILRS3_ILR150:      equ    %01000000
mILRS3_ILR151:      equ    %10000000


;*** ILRS4 - Interrupt Level Setting Register; 0x0000187C ***
ILRS4:              equ    $0000187C                                ;*** ILRS4 - Interrupt Level Setting Register; 0x0000187C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ILRS4_ILR160:       equ    0                                         ; Interrupt Level Register for Source 16, bit 0
ILRS4_ILR161:       equ    1                                         ; Interrupt Level Register for Source 16, bit 1
ILRS4_ILR170:       equ    2                                         ; Interrupt Level Register for Source 17, bit 0
ILRS4_ILR171:       equ    3                                         ; Interrupt Level Register for Source 17, bit 1
ILRS4_ILR180:       equ    4                                         ; Interrupt Level Register for Source 18, bit 0
ILRS4_ILR181:       equ    5                                         ; Interrupt Level Register for Source 18, bit 1
ILRS4_ILR190:       equ    6                                         ; Interrupt Level Register for Source 19, bit 0
ILRS4_ILR191:       equ    7                                         ; Interrupt Level Register for Source 19, bit 1
; bit position masks
mILRS4_ILR160:      equ    %00000001
mILRS4_ILR161:      equ    %00000010
mILRS4_ILR170:      equ    %00000100
mILRS4_ILR171:      equ    %00001000
mILRS4_ILR180:      equ    %00010000
mILRS4_ILR181:      equ    %00100000
mILRS4_ILR190:      equ    %01000000
mILRS4_ILR191:      equ    %10000000


;*** ILRS5 - Interrupt Level Setting Register; 0x0000187D ***
ILRS5:              equ    $0000187D                                ;*** ILRS5 - Interrupt Level Setting Register; 0x0000187D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ILRS5_ILR200:       equ    0                                         ; Interrupt Level Register for Source 20, bit 0
ILRS5_ILR201:       equ    1                                         ; Interrupt Level Register for Source 20, bit 1
ILRS5_ILR210:       equ    2                                         ; Interrupt Level Register for Source 21, bit 0
ILRS5_ILR211:       equ    3                                         ; Interrupt Level Register for Source 21, bit 1
ILRS5_ILR220:       equ    4                                         ; Interrupt Level Register for Source 22, bit 0
ILRS5_ILR221:       equ    5                                         ; Interrupt Level Register for Source 22, bit 1
ILRS5_ILR230:       equ    6                                         ; Interrupt Level Register for Source 23, bit 0
ILRS5_ILR231:       equ    7                                         ; Interrupt Level Register for Source 23, bit 1
; bit position masks
mILRS5_ILR200:      equ    %00000001
mILRS5_ILR201:      equ    %00000010
mILRS5_ILR210:      equ    %00000100
mILRS5_ILR211:      equ    %00001000
mILRS5_ILR220:      equ    %00010000
mILRS5_ILR221:      equ    %00100000
mILRS5_ILR230:      equ    %01000000
mILRS5_ILR231:      equ    %10000000


;*** ILRS6 - Interrupt Level Setting Register; 0x0000187E ***
ILRS6:              equ    $0000187E                                ;*** ILRS6 - Interrupt Level Setting Register; 0x0000187E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ILRS6_ILR240:       equ    0                                         ; Interrupt Level Register for Source 24, bit 0
ILRS6_ILR241:       equ    1                                         ; Interrupt Level Register for Source 24, bit 1
ILRS6_ILR250:       equ    2                                         ; Interrupt Level Register for Source 25, bit 0
ILRS6_ILR251:       equ    3                                         ; Interrupt Level Register for Source 25, bit 1
ILRS6_ILR260:       equ    4                                         ; Interrupt Level Register for Source 26, bit 0
ILRS6_ILR261:       equ    5                                         ; Interrupt Level Register for Source 26, bit 1
ILRS6_ILR270:       equ    6                                         ; Interrupt Level Register for Source 27, bit 0
ILRS6_ILR271:       equ    7                                         ; Interrupt Level Register for Source 27, bit 1
; bit position masks
mILRS6_ILR240:      equ    %00000001
mILRS6_ILR241:      equ    %00000010
mILRS6_ILR250:      equ    %00000100
mILRS6_ILR251:      equ    %00001000
mILRS6_ILR260:      equ    %00010000
mILRS6_ILR261:      equ    %00100000
mILRS6_ILR270:      equ    %01000000
mILRS6_ILR271:      equ    %10000000


;*** ILRS7 - Interrupt Level Setting Register; 0x0000187F ***
ILRS7:              equ    $0000187F                                ;*** ILRS7 - Interrupt Level Setting Register; 0x0000187F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ILRS7_ILR280:       equ    0                                         ; Interrupt Level Register for Source 28, bit 0
ILRS7_ILR281:       equ    1                                         ; Interrupt Level Register for Source 28, bit 1
ILRS7_ILR290:       equ    2                                         ; Interrupt Level Register for Source 29, bit 0
ILRS7_ILR291:       equ    3                                         ; Interrupt Level Register for Source 29, bit 1
ILRS7_ILR300:       equ    4                                         ; Interrupt Level Register for Source 30, bit 0
ILRS7_ILR301:       equ    5                                         ; Interrupt Level Register for Source 30, bit 1
ILRS7_ILR310:       equ    6                                         ; Interrupt Level Register for Source 31, bit 0
ILRS7_ILR311:       equ    7                                         ; Interrupt Level Register for Source 31, bit 1
; bit position masks
mILRS7_ILR280:      equ    %00000001
mILRS7_ILR281:      equ    %00000010
mILRS7_ILR290:      equ    %00000100
mILRS7_ILR291:      equ    %00001000
mILRS7_ILR300:      equ    %00010000
mILRS7_ILR301:      equ    %00100000
mILRS7_ILR310:      equ    %01000000
mILRS7_ILR311:      equ    %10000000


;*** NVFTRIM - Nonvolatile ICS Fine Trim; 0x0000FFAE ***
NVFTRIM:            equ    $0000FFAE                                ;*** NVFTRIM - Nonvolatile ICS Fine Trim; 0x0000FFAE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFTRIM_FTRIM:      equ    0                                         ; ICS Fine Trim
; bit position masks
mNVFTRIM_FTRIM:     equ    %00000001


;*** NVICSTRM - Nonvolatile ICS Trim Register; 0x0000FFAF ***
NVICSTRM:           equ    $0000FFAF                                ;*** NVICSTRM - Nonvolatile ICS Trim Register; 0x0000FFAF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVICSTRM_TRIM0:     equ    0                                         ; ICS Trim Setting, bit 0
NVICSTRM_TRIM1:     equ    1                                         ; ICS Trim Setting, bit 1
NVICSTRM_TRIM2:     equ    2                                         ; ICS Trim Setting, bit 2
NVICSTRM_TRIM3:     equ    3                                         ; ICS Trim Setting, bit 3
NVICSTRM_TRIM4:     equ    4                                         ; ICS Trim Setting, bit 4
NVICSTRM_TRIM5:     equ    5                                         ; ICS Trim Setting, bit 5
NVICSTRM_TRIM6:     equ    6                                         ; ICS Trim Setting, bit 6
NVICSTRM_TRIM7:     equ    7                                         ; ICS Trim Setting, bit 7
; bit position masks
mNVICSTRM_TRIM0:    equ    %00000001
mNVICSTRM_TRIM1:    equ    %00000010
mNVICSTRM_TRIM2:    equ    %00000100
mNVICSTRM_TRIM3:    equ    %00001000
mNVICSTRM_TRIM4:    equ    %00010000
mNVICSTRM_TRIM5:    equ    %00100000
mNVICSTRM_TRIM6:    equ    %01000000
mNVICSTRM_TRIM7:    equ    %10000000


;*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***
NVBACKKEY0:         equ    $0000FFB0                                ;*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY0_KEY0:    equ    0                                         ; Backdoor Comparison Key 0 Bits, bit 0
NVBACKKEY0_KEY1:    equ    1                                         ; Backdoor Comparison Key 0 Bits, bit 1
NVBACKKEY0_KEY2:    equ    2                                         ; Backdoor Comparison Key 0 Bits, bit 2
NVBACKKEY0_KEY3:    equ    3                                         ; Backdoor Comparison Key 0 Bits, bit 3
NVBACKKEY0_KEY4:    equ    4                                         ; Backdoor Comparison Key 0 Bits, bit 4
NVBACKKEY0_KEY5:    equ    5                                         ; Backdoor Comparison Key 0 Bits, bit 5
NVBACKKEY0_KEY6:    equ    6                                         ; Backdoor Comparison Key 0 Bits, bit 6
NVBACKKEY0_KEY7:    equ    7                                         ; Backdoor Comparison Key 0 Bits, bit 7
; bit position masks
mNVBACKKEY0_KEY0:   equ    %00000001
mNVBACKKEY0_KEY1:   equ    %00000010
mNVBACKKEY0_KEY2:   equ    %00000100
mNVBACKKEY0_KEY3:   equ    %00001000
mNVBACKKEY0_KEY4:   equ    %00010000
mNVBACKKEY0_KEY5:   equ    %00100000
mNVBACKKEY0_KEY6:   equ    %01000000
mNVBACKKEY0_KEY7:   equ    %10000000


;*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***
NVBACKKEY1:         equ    $0000FFB1                                ;*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY1_KEY0:    equ    0                                         ; Backdoor Comparison Key 1 Bits, bit 0
NVBACKKEY1_KEY1:    equ    1                                         ; Backdoor Comparison Key 1 Bits, bit 1
NVBACKKEY1_KEY2:    equ    2                                         ; Backdoor Comparison Key 1 Bits, bit 2
NVBACKKEY1_KEY3:    equ    3                                         ; Backdoor Comparison Key 1 Bits, bit 3
NVBACKKEY1_KEY4:    equ    4                                         ; Backdoor Comparison Key 1 Bits, bit 4
NVBACKKEY1_KEY5:    equ    5                                         ; Backdoor Comparison Key 1 Bits, bit 5
NVBACKKEY1_KEY6:    equ    6                                         ; Backdoor Comparison Key 1 Bits, bit 6
NVBACKKEY1_KEY7:    equ    7                                         ; Backdoor Comparison Key 1 Bits, bit 7
; bit position masks
mNVBACKKEY1_KEY0:   equ    %00000001
mNVBACKKEY1_KEY1:   equ    %00000010
mNVBACKKEY1_KEY2:   equ    %00000100
mNVBACKKEY1_KEY3:   equ    %00001000
mNVBACKKEY1_KEY4:   equ    %00010000
mNVBACKKEY1_KEY5:   equ    %00100000
mNVBACKKEY1_KEY6:   equ    %01000000
mNVBACKKEY1_KEY7:   equ    %10000000


;*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***
NVBACKKEY2:         equ    $0000FFB2                                ;*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY2_KEY0:    equ    0                                         ; Backdoor Comparison Key 2 Bits, bit 0
NVBACKKEY2_KEY1:    equ    1                                         ; Backdoor Comparison Key 2 Bits, bit 1
NVBACKKEY2_KEY2:    equ    2                                         ; Backdoor Comparison Key 2 Bits, bit 2
NVBACKKEY2_KEY3:    equ    3                                         ; Backdoor Comparison Key 2 Bits, bit 3
NVBACKKEY2_KEY4:    equ    4                                         ; Backdoor Comparison Key 2 Bits, bit 4
NVBACKKEY2_KEY5:    equ    5                                         ; Backdoor Comparison Key 2 Bits, bit 5
NVBACKKEY2_KEY6:    equ    6                                         ; Backdoor Comparison Key 2 Bits, bit 6
NVBACKKEY2_KEY7:    equ    7                                         ; Backdoor Comparison Key 2 Bits, bit 7
; bit position masks
mNVBACKKEY2_KEY0:   equ    %00000001
mNVBACKKEY2_KEY1:   equ    %00000010
mNVBACKKEY2_KEY2:   equ    %00000100
mNVBACKKEY2_KEY3:   equ    %00001000
mNVBACKKEY2_KEY4:   equ    %00010000
mNVBACKKEY2_KEY5:   equ    %00100000
mNVBACKKEY2_KEY6:   equ    %01000000
mNVBACKKEY2_KEY7:   equ    %10000000


;*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***
NVBACKKEY3:         equ    $0000FFB3                                ;*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY3_KEY0:    equ    0                                         ; Backdoor Comparison Key 3 Bits, bit 0
NVBACKKEY3_KEY1:    equ    1                                         ; Backdoor Comparison Key 3 Bits, bit 1
NVBACKKEY3_KEY2:    equ    2                                         ; Backdoor Comparison Key 3 Bits, bit 2
NVBACKKEY3_KEY3:    equ    3                                         ; Backdoor Comparison Key 3 Bits, bit 3
NVBACKKEY3_KEY4:    equ    4                                         ; Backdoor Comparison Key 3 Bits, bit 4
NVBACKKEY3_KEY5:    equ    5                                         ; Backdoor Comparison Key 3 Bits, bit 5
NVBACKKEY3_KEY6:    equ    6                                         ; Backdoor Comparison Key 3 Bits, bit 6
NVBACKKEY3_KEY7:    equ    7                                         ; Backdoor Comparison Key 3 Bits, bit 7
; bit position masks
mNVBACKKEY3_KEY0:   equ    %00000001
mNVBACKKEY3_KEY1:   equ    %00000010
mNVBACKKEY3_KEY2:   equ    %00000100
mNVBACKKEY3_KEY3:   equ    %00001000
mNVBACKKEY3_KEY4:   equ    %00010000
mNVBACKKEY3_KEY5:   equ    %00100000
mNVBACKKEY3_KEY6:   equ    %01000000
mNVBACKKEY3_KEY7:   equ    %10000000


;*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***
NVBACKKEY4:         equ    $0000FFB4                                ;*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY4_KEY0:    equ    0                                         ; Backdoor Comparison Key 4 Bits, bit 0
NVBACKKEY4_KEY1:    equ    1                                         ; Backdoor Comparison Key 4 Bits, bit 1
NVBACKKEY4_KEY2:    equ    2                                         ; Backdoor Comparison Key 4 Bits, bit 2
NVBACKKEY4_KEY3:    equ    3                                         ; Backdoor Comparison Key 4 Bits, bit 3
NVBACKKEY4_KEY4:    equ    4                                         ; Backdoor Comparison Key 4 Bits, bit 4
NVBACKKEY4_KEY5:    equ    5                                         ; Backdoor Comparison Key 4 Bits, bit 5
NVBACKKEY4_KEY6:    equ    6                                         ; Backdoor Comparison Key 4 Bits, bit 6
NVBACKKEY4_KEY7:    equ    7                                         ; Backdoor Comparison Key 4 Bits, bit 7
; bit position masks
mNVBACKKEY4_KEY0:   equ    %00000001
mNVBACKKEY4_KEY1:   equ    %00000010
mNVBACKKEY4_KEY2:   equ    %00000100
mNVBACKKEY4_KEY3:   equ    %00001000
mNVBACKKEY4_KEY4:   equ    %00010000
mNVBACKKEY4_KEY5:   equ    %00100000
mNVBACKKEY4_KEY6:   equ    %01000000
mNVBACKKEY4_KEY7:   equ    %10000000


;*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***
NVBACKKEY5:         equ    $0000FFB5                                ;*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY5_KEY0:    equ    0                                         ; Backdoor Comparison Key 5 Bits, bit 0
NVBACKKEY5_KEY1:    equ    1                                         ; Backdoor Comparison Key 5 Bits, bit 1
NVBACKKEY5_KEY2:    equ    2                                         ; Backdoor Comparison Key 5 Bits, bit 2
NVBACKKEY5_KEY3:    equ    3                                         ; Backdoor Comparison Key 5 Bits, bit 3
NVBACKKEY5_KEY4:    equ    4                                         ; Backdoor Comparison Key 5 Bits, bit 4
NVBACKKEY5_KEY5:    equ    5                                         ; Backdoor Comparison Key 5 Bits, bit 5
NVBACKKEY5_KEY6:    equ    6                                         ; Backdoor Comparison Key 5 Bits, bit 6
NVBACKKEY5_KEY7:    equ    7                                         ; Backdoor Comparison Key 5 Bits, bit 7
; bit position masks
mNVBACKKEY5_KEY0:   equ    %00000001
mNVBACKKEY5_KEY1:   equ    %00000010
mNVBACKKEY5_KEY2:   equ    %00000100
mNVBACKKEY5_KEY3:   equ    %00001000
mNVBACKKEY5_KEY4:   equ    %00010000
mNVBACKKEY5_KEY5:   equ    %00100000
mNVBACKKEY5_KEY6:   equ    %01000000
mNVBACKKEY5_KEY7:   equ    %10000000


;*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***
NVBACKKEY6:         equ    $0000FFB6                                ;*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY6_KEY0:    equ    0                                         ; Backdoor Comparison Key 6 Bits, bit 0
NVBACKKEY6_KEY1:    equ    1                                         ; Backdoor Comparison Key 6 Bits, bit 1
NVBACKKEY6_KEY2:    equ    2                                         ; Backdoor Comparison Key 6 Bits, bit 2
NVBACKKEY6_KEY3:    equ    3                                         ; Backdoor Comparison Key 6 Bits, bit 3
NVBACKKEY6_KEY4:    equ    4                                         ; Backdoor Comparison Key 6 Bits, bit 4
NVBACKKEY6_KEY5:    equ    5                                         ; Backdoor Comparison Key 6 Bits, bit 5
NVBACKKEY6_KEY6:    equ    6                                         ; Backdoor Comparison Key 6 Bits, bit 6
NVBACKKEY6_KEY7:    equ    7                                         ; Backdoor Comparison Key 6 Bits, bit 7
; bit position masks
mNVBACKKEY6_KEY0:   equ    %00000001
mNVBACKKEY6_KEY1:   equ    %00000010
mNVBACKKEY6_KEY2:   equ    %00000100
mNVBACKKEY6_KEY3:   equ    %00001000
mNVBACKKEY6_KEY4:   equ    %00010000
mNVBACKKEY6_KEY5:   equ    %00100000
mNVBACKKEY6_KEY6:   equ    %01000000
mNVBACKKEY6_KEY7:   equ    %10000000


;*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***
NVBACKKEY7:         equ    $0000FFB7                                ;*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY7_KEY0:    equ    0                                         ; Backdoor Comparison Key 7 Bits, bit 0
NVBACKKEY7_KEY1:    equ    1                                         ; Backdoor Comparison Key 7 Bits, bit 1
NVBACKKEY7_KEY2:    equ    2                                         ; Backdoor Comparison Key 7 Bits, bit 2
NVBACKKEY7_KEY3:    equ    3                                         ; Backdoor Comparison Key 7 Bits, bit 3
NVBACKKEY7_KEY4:    equ    4                                         ; Backdoor Comparison Key 7 Bits, bit 4
NVBACKKEY7_KEY5:    equ    5                                         ; Backdoor Comparison Key 7 Bits, bit 5
NVBACKKEY7_KEY6:    equ    6                                         ; Backdoor Comparison Key 7 Bits, bit 6
NVBACKKEY7_KEY7:    equ    7                                         ; Backdoor Comparison Key 7 Bits, bit 7
; bit position masks
mNVBACKKEY7_KEY0:   equ    %00000001
mNVBACKKEY7_KEY1:   equ    %00000010
mNVBACKKEY7_KEY2:   equ    %00000100
mNVBACKKEY7_KEY3:   equ    %00001000
mNVBACKKEY7_KEY4:   equ    %00010000
mNVBACKKEY7_KEY5:   equ    %00100000
mNVBACKKEY7_KEY6:   equ    %01000000
mNVBACKKEY7_KEY7:   equ    %10000000


;*** NVPROT - Nonvolatile FLASH Protection Register; 0x0000FFBD ***
NVPROT:             equ    $0000FFBD                                ;*** NVPROT - Nonvolatile FLASH Protection Register; 0x0000FFBD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVPROT_FPS1:        equ    1                                         ; FLASH Protect Select Bit 1
NVPROT_FPS2:        equ    2                                         ; FLASH Protect Select Bit 2
NVPROT_FPS3:        equ    3                                         ; FLASH Protect Select Bit 3
NVPROT_FPS4:        equ    4                                         ; FLASH Protect Select Bit 4
NVPROT_FPS5:        equ    5                                         ; FLASH Protect Select Bit 5
NVPROT_FPS6:        equ    6                                         ; FLASH Protect Select Bit 6
NVPROT_FPS7:        equ    7                                         ; FLASH Protect Select Bit 7
; bit position masks
mNVPROT_FPS1:       equ    %00000010
mNVPROT_FPS2:       equ    %00000100
mNVPROT_FPS3:       equ    %00001000
mNVPROT_FPS4:       equ    %00010000
mNVPROT_FPS5:       equ    %00100000
mNVPROT_FPS6:       equ    %01000000
mNVPROT_FPS7:       equ    %10000000


;*** NVOPT - Nonvolatile Flash Options Register; 0x0000FFBF ***
NVOPT:              equ    $0000FFBF                                ;*** NVOPT - Nonvolatile Flash Options Register; 0x0000FFBF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVOPT_SEC00:        equ    0                                         ; Security State Code, bit 0
NVOPT_SEC01:        equ    1                                         ; Security State Code, bit 1
NVOPT_FNORED:       equ    6                                         ; Vector Redirection Disable
NVOPT_KEYEN:        equ    7                                         ; Backdoor Key Mechanism Enable
; bit position masks
mNVOPT_SEC00:       equ    %00000001
mNVOPT_SEC01:       equ    %00000010
mNVOPT_FNORED:      equ    %01000000
mNVOPT_KEYEN:       equ    %10000000



; Flash commands
mBlank:             equ     $05
mBurstProg:         equ     $25
mByteProg:          equ     $20
mMassErase:         equ     $41
mPageErase:         equ     $40


;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------



; **** 3.4.2009 15:54:34

        IFNDEF __GENERATE_APPLICATION__
FPROT_FPDIS:                             equ        This_symb_has_been_depreciated
mFPROT_FPDIS:                            equ        This_symb_has_been_depreciated
NVPROT_FPDIS:                            equ        This_symb_has_been_depreciated
mNVPROT_FPDIS:                           equ        This_symb_has_been_depreciated
        ENDIF

; EOF
