/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SMARTDMA_KEYSCAN_H
#define SMARTDMA_KEYSCAN_H


#define SMARTDMA_API_MEMORY_ADDRESS 0x04000000/*ramx*/
#define ARM2EZH                0x40033040
#define EZH2ARM                0x40033044

#define USE_6X15_KEYBOARD 1
#define KEY_ROW_COUNT    6
#define KEY_COL_COUNT    15

#define SMARTDMA_CODE                   __attribute__((section(".data.$SRAMX0"), aligned(4)))
#define SMARTDMA_DATA                   __attribute__((section(".ramfunc.$SRAMX0"), aligned(4)))
typedef void (*smartdma_func_t)(void);


#endif
