#
#  Copyright 2024 NXP
#
#  SPDX-License-Identifier: BSD-3-Clause
#

import matplotlib.backends
import numpy as np 
import matplotlib.pyplot as plt
import matplotlib
matplotlib.use('TkAgg')

if __name__ == "__main__":
    f = open("./test.h", "r")
    data = eval("[" + f.read() + "]")

    d16 = np.asarray(data, dtype="int16") / 32768
    fft = np.fft.rfft(d16)

    plt.plot(np.abs(fft) / 2048)

    cmsis_data_bin = open("./1.bin", "rb").read()
    cmsis_data = np.frombuffer(cmsis_data_bin, dtype="int32")
    real = (cmsis_data[0::2].astype("int32") / (1 << 4))
    imag = (cmsis_data[1::2].astype("int32") / (1 << 4))
    cmsis_data = real + 1j * imag
    plt.plot(np.abs(cmsis_data) / 2048)

    cmsis_data_bin_mag = open("./1_fp32_mag.bin", "rb").read()
    cmsis_data_mag = np.frombuffer(cmsis_data_bin_mag, dtype="float32")
    plt.plot(cmsis_data_mag[:1024])
    plt.show()

    div = fft / cmsis_data
    abs = fft - cmsis_data
    print(fft)

