/*
** ###################################################################
**     Processors:          MIMXRT1181CVP2B
**                          MIMXRT1181CVP2C
**                          MIMXRT1181XVP2B
**                          MIMXRT1181XVP2C
**                          MIMXRT1182CVP2B
**                          MIMXRT1182CVP2C
**                          MIMXRT1182XVP2B
**                          MIMXRT1182XVP2C
**                          MIMXRT1186CVJ8C_cm33
**                          MIMXRT1186CVJ8C_cm7
**                          MIMXRT1186XVJ8C_cm33
**                          MIMXRT1186XVJ8C_cm7
**                          MIMXRT1187AVM8B_cm33
**                          MIMXRT1187AVM8B_cm7
**                          MIMXRT1187AVM8C_cm33
**                          MIMXRT1187AVM8C_cm7
**                          MIMXRT1187CVM8B_cm33
**                          MIMXRT1187CVM8B_cm7
**                          MIMXRT1187CVM8C_cm33
**                          MIMXRT1187CVM8C_cm7
**                          MIMXRT1187XVM8B_cm33
**                          MIMXRT1187XVM8B_cm7
**                          MIMXRT1187XVM8C_cm33
**                          MIMXRT1187XVM8C_cm7
**                          MIMXRT1189CVM8B_cm33
**                          MIMXRT1189CVM8B_cm7
**                          MIMXRT1189CVM8C_cm33
**                          MIMXRT1189CVM8C_cm7
**                          MIMXRT1189XVM8B_cm33
**                          MIMXRT1189XVM8B_cm7
**                          MIMXRT1189XVM8C_cm33
**                          MIMXRT1189XVM8C_cm7
**
**     Version:             rev. 2.0, 2024-01-18
**     Build:               b250331
**
**     Abstract:
**         CMSIS Peripheral Access Layer for NETC_ETH_LINK
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2025 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2021-03-09)
**         Initial version.
**     - rev. 2.0 (2024-01-18)
**         Header RFP.
**
** ###################################################################
*/

/*!
 * @file PERI_NETC_ETH_LINK.h
 * @version 2.0
 * @date 2024-01-18
 * @brief CMSIS Peripheral Access Layer for NETC_ETH_LINK
 *
 * CMSIS Peripheral Access Layer for NETC_ETH_LINK
 */

#if !defined(PERI_NETC_ETH_LINK_H_)
#define PERI_NETC_ETH_LINK_H_                    /**< Symbol preventing repeated inclusion */

#if (defined(CPU_MIMXRT1181CVP2B) || defined(CPU_MIMXRT1181CVP2C) || defined(CPU_MIMXRT1181XVP2B) || defined(CPU_MIMXRT1181XVP2C))
#include "MIMXRT1181_COMMON.h"
#elif (defined(CPU_MIMXRT1182CVP2B) || defined(CPU_MIMXRT1182CVP2C) || defined(CPU_MIMXRT1182XVP2B) || defined(CPU_MIMXRT1182XVP2C))
#include "MIMXRT1182_COMMON.h"
#elif (defined(CPU_MIMXRT1186CVJ8C_cm33) || defined(CPU_MIMXRT1186XVJ8C_cm33))
#include "MIMXRT1186_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1186CVJ8C_cm7) || defined(CPU_MIMXRT1186XVJ8C_cm7))
#include "MIMXRT1186_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT1187AVM8B_cm33) || defined(CPU_MIMXRT1187AVM8C_cm33) || defined(CPU_MIMXRT1187CVM8B_cm33) || defined(CPU_MIMXRT1187CVM8C_cm33) || defined(CPU_MIMXRT1187XVM8B_cm33) || defined(CPU_MIMXRT1187XVM8C_cm33))
#include "MIMXRT1187_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1187AVM8B_cm7) || defined(CPU_MIMXRT1187AVM8C_cm7) || defined(CPU_MIMXRT1187CVM8B_cm7) || defined(CPU_MIMXRT1187CVM8C_cm7) || defined(CPU_MIMXRT1187XVM8B_cm7) || defined(CPU_MIMXRT1187XVM8C_cm7))
#include "MIMXRT1187_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT1189CVM8B_cm33) || defined(CPU_MIMXRT1189CVM8C_cm33) || defined(CPU_MIMXRT1189XVM8B_cm33) || defined(CPU_MIMXRT1189XVM8C_cm33))
#include "MIMXRT1189_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1189CVM8B_cm7) || defined(CPU_MIMXRT1189CVM8C_cm7) || defined(CPU_MIMXRT1189XVM8B_cm7) || defined(CPU_MIMXRT1189XVM8C_cm7))
#include "MIMXRT1189_cm7_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- NETC_ETH_LINK Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NETC_ETH_LINK_Peripheral_Access_Layer NETC_ETH_LINK Peripheral Access Layer
 * @{
 */

/** NETC_ETH_LINK - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[8];
  __IO uint32_t PM0_COMMAND_CONFIG;                /**< Port MAC 0 Command and Configuration Register, offset: 0x8 */
  __I  uint32_t PM0_MAC_ADDR_0;                    /**< Port MAC 0 MAC Address Register 0, offset: 0xC */
  __I  uint32_t PM0_MAC_ADDR_1;                    /**< Port MAC 0 MAC Address Register 1, offset: 0x10 */
  __IO uint32_t PM0_MAXFRM;                        /**< Port MAC 0 Maximum Frame Length Register, offset: 0x14 */
  __IO uint32_t PM0_MINFRM;                        /**< Port MAC 0 Minimum Frame Length Register, offset: 0x18 */
       uint8_t RESERVED_1[20];
  __IO uint32_t PM0_MDIO_CFG;                      /**< Port MAC 0 Internal MDIO Configuration Register, offset: 0x30, not available in all instances (available on 60 out of 100) */
  __IO uint32_t PM0_MDIO_CTL;                      /**< Port MAC 0 Internal MDIO Interface Control Register, offset: 0x34, not available in all instances (available on 60 out of 100) */
  __IO uint32_t PM0_MDIO_DATA;                     /**< Port MAC 0 Internal MDIO Interface Data Register, offset: 0x38, not available in all instances (available on 60 out of 100) */
       uint8_t RESERVED_2[4];
  __IO uint32_t PM0_IEVENT;                        /**< Port MAC 0 Interrupt Event Register, offset: 0x40 */
  __IO uint32_t PM0_TX_IPG_PREAMBLE;               /**< Port MAC 0 Transmit Inter-Packet Gap Length and Flexible Preamble length Register, offset: 0x44 */
       uint8_t RESERVED_3[4];
  __IO uint32_t PM0_IMASK;                         /**< Port MAC 0 Interrupt Mask Register(INT_MASK), offset: 0x4C */
       uint8_t RESERVED_4[4];
  __IO uint32_t PM0_PAUSE_QUANTA;                  /**< Port MAC 0 Pause Quanta Register, offset: 0x54 */
       uint8_t RESERVED_5[12];
  __IO uint32_t PM0_PAUSE_THRESH;                  /**< Port MAC 0 Pause Quanta Threshold Register, offset: 0x64 */
       uint8_t RESERVED_6[12];
  __I  uint32_t PM0_RX_PAUSE_STATUS;               /**< Port MAC 0 Receive Pause Status Register, offset: 0x74 */
       uint8_t RESERVED_7[64];
  __IO uint32_t PM0_LPWAKE_TIMER;                  /**< Port MAC 0 EEE Low Power Wakeup Timer Register, offset: 0xB8 */
  __IO uint32_t PM0_SLEEP_TIMER;                   /**< Port MAC 0 Transmit EEE Low Power Timer Register, offset: 0xBC */
  __IO uint32_t PM0_SINGLE_STEP;                   /**< Port MAC 0 IEEE1588 Single-Step Control Register, offset: 0xC0 */
       uint8_t RESERVED_8[12];
  __IO uint32_t PM0_HD_BACKOFF_ENTROPY;            /**< Port MAC 0 half-duplex backoff entropy register, offset: 0xD0 */
  __IO uint32_t PM0_HD_FLOW_CTRL;                  /**< Port MAC 0 Half-Duplex Flow Control Register, offset: 0xD4 */
       uint8_t RESERVED_9[8];
  __IO uint32_t PM0_STATN_CONFIG;                  /**< Port MAC 0 Statistics Configuration Register, offset: 0xE0 */
       uint8_t RESERVED_10[28];
  __I  uint64_t PM0_REOCTN;                        /**< Port MAC 0 Receive Ethernet Octets Counter(etherStatsOctetsn), offset: 0x100 */
  __I  uint64_t PM0_ROCTN;                         /**< Port MAC 0 Receive Octets Counter(iflnOctetsn), offset: 0x108 */
       uint8_t RESERVED_11[8];
  __I  uint64_t PM0_RXPFN;                         /**< Port MAC 0 Receive Valid Pause Frame Counter Register(aPAUSEMACCtrlFramesReceivedn), offset: 0x118 */
  __I  uint64_t PM0_RFRMN;                         /**< Port MAC 0 Receive Frame Counter Register(aFramesReceivedOKn), offset: 0x120 */
  __I  uint64_t PM0_RFCSN;                         /**< Port MAC 0 Receive Frame Check Sequence Error Counter Register(), offset: 0x128 */
  __I  uint64_t PM0_RVLANN;                        /**< Port MAC 0 Receive VLAN Frame Counter Register(VLANReceivedOKn), offset: 0x130 */
  __I  uint64_t PM0_RERRN;                         /**< Port MAC 0 Receive Frame Error Counter Register(ifInErrorsn), offset: 0x138 */
  __I  uint64_t PM0_RUCAN;                         /**< Port MAC 0 Receive Unicast Frame Counter Register(ifInUcastPktsn), offset: 0x140 */
  __I  uint64_t PM0_RMCAN;                         /**< Port MAC 0 Receive Multicast Frame Counter Register(ifInMulticastPktsn), offset: 0x148 */
  __I  uint64_t PM0_RBCAN;                         /**< Port MAC 0 Receive Broadcast Frame Counter Register(ifInBroadcastPktsn), offset: 0x150 */
  __I  uint64_t PM0_RDRPN;                         /**< Port MAC 0 Receive Dropped Packets Counter Register(etherStatsDropEventsn), offset: 0x158 */
  __I  uint64_t PM0_RPKTN;                         /**< Port MAC 0 Receive Packets Counter Register(etherStatsPktsn), offset: 0x160 */
  __I  uint64_t PM0_RUNDN;                         /**< Port MAC 0 Receive Undersized Packet Counter Register(etherStatsUndersizePktsn), offset: 0x168 */
  __I  uint64_t PM0_R64N;                          /**< Port MAC 0 Receive 64-Octet Packet Counter Register(etherStatsPkts64OctetsN), offset: 0x170 */
  __I  uint64_t PM0_R127N;                         /**< Port MAC 0 Receive 65 to 127-Octet Packet Counter Register(etherStatsPkts65to127OctetsN), offset: 0x178 */
  __I  uint64_t PM0_R255N;                         /**< Port MAC 0 Receive 128 to 255-Octet Packet Counter Register(etherStatsPkts128to255OctetsN), offset: 0x180 */
  __I  uint64_t PM0_R511N;                         /**< Port MAC 0 Receive 256 to 511-Octet Packet Counter Register(etherStatsPkts256to511OctetsN), offset: 0x188 */
  __I  uint64_t PM0_R1023N;                        /**< Port MAC 0 Receive 512 to 1023-Octet Packet Counter Register(etherStatsPkts512to1023OctetsN), offset: 0x190 */
  __I  uint64_t PM0_R1522N;                        /**< Port MAC 0 Receive 1024 to 1522-Octet Packet Counter Register(etherStatsPkts1024to1522OctetsN), offset: 0x198 */
  __I  uint64_t PM0_R1523XN;                       /**< Port MAC 0 Receive 1523 to Max-Octet Packet Counter Register(etherStatsPkts1523toMaxOctetsN), offset: 0x1A0 */
  __I  uint64_t PM0_ROVRN;                         /**< Port MAC 0 Receive Oversized Packet Counter Register(etherStatsOversizePktsn), offset: 0x1A8 */
  __I  uint64_t PM0_RJBRN;                         /**< Port MAC 0 Receive Jabber Packet Counter Register(etherStatsJabbersn), offset: 0x1B0 */
  __I  uint64_t PM0_RFRGN;                         /**< Port MAC 0 Receive Fragment Packet Counter Register(etherStatsFragmentsn, offset: 0x1B8 */
  __I  uint64_t PM0_RCNPN;                         /**< Port MAC 0 Receive Control Packet Counter Register, offset: 0x1C0 */
  __I  uint64_t PM0_RDRNTPN;                       /**< Port MAC 0 Receive Dropped Not Truncated Packets Counter Register(etherStatsDropEventsn), offset: 0x1C8 */
  __I  uint64_t PM0_RMIN63N;                       /**< Port MAC 0 Receive Valid Small Packet Counter Register, offset: 0x1D0 */
       uint8_t RESERVED_12[40];
  __I  uint64_t PM0_TEOCTN;                        /**< Port MAC 0 Transmit Ethernet Octets Counter(etherStatsOctetsn), offset: 0x200 */
  __I  uint64_t PM0_TOCTN;                         /**< Port MAC 0 Transmit Octets Counter Register(ifOutOctetsn), offset: 0x208 */
       uint8_t RESERVED_13[8];
  __I  uint64_t PM0_TXPFN;                         /**< Port MAC 0 Transmit Valid Pause Frame Counter Register(aPAUSEMACCtrlFramesReceivedn), offset: 0x218 */
  __I  uint64_t PM0_TFRMN;                         /**< Port MAC 0 Transmit Frame Counter Register(aFramesTransmittedOKn), offset: 0x220 */
  __I  uint64_t PM0_TFCSN;                         /**< Port MAC 0 Transmit Frame Check Sequence Error Counter Register(), offset: 0x228 */
  __I  uint64_t PM0_TVLANN;                        /**< Port MAC 0 Transmit VLAN Frame Counter Register(VLANTransmittedOKn), offset: 0x230 */
  __I  uint64_t PM0_TERRN;                         /**< Port MAC 0 Transmit Frame Error Counter Register(ifOutErrorsn), offset: 0x238 */
  __I  uint64_t PM0_TUCAN;                         /**< Port MAC 0 Transmit Unicast Frame Counter Register(ifOutUcastPktsn), offset: 0x240 */
  __I  uint64_t PM0_TMCAN;                         /**< Port MAC 0 Transmit Multicast Frame Counter Register(ifOutMulticastPktsn), offset: 0x248 */
  __I  uint64_t PM0_TBCAN;                         /**< Port MAC 0 Transmit Broadcast Frame Counter Register(ifOutBroadcastPktsn), offset: 0x250 */
       uint8_t RESERVED_14[8];
  __I  uint64_t PM0_TPKTN;                         /**< Port MAC 0 Transmit Packets Counter Register(etherStatsPktsn), offset: 0x260 */
  __I  uint64_t PM0_TUNDN;                         /**< Port MAC 0 Transmit Undersized Packet Counter Register(etherStatsUndersizePktsn), offset: 0x268 */
  __I  uint64_t PM0_T64N;                          /**< Port MAC 0 Transmit 64-Octet Packet Counter Register (etherStatsPkts64OctetsN), offset: 0x270 */
  __I  uint64_t PM0_T127N;                         /**< Port MAC 0 Transmit 65 to 127-Octet Packet Counter Register (etherStatsPkts65to127OctetsN), offset: 0x278 */
  __I  uint64_t PM0_T255N;                         /**< Port MAC 0 Transmit 128 to 255-Octet Packet Counter Register (etherStatsPkts128to255OctetsN), offset: 0x280 */
  __I  uint64_t PM0_T511N;                         /**< Port MAC 0 Transmit 256 to 511-Octet Packet Counter Register (etherStatsPkts256to511OctetsN), offset: 0x288 */
  __I  uint64_t PM0_T1023N;                        /**< Port MAC 0 Transmit 512 to 1023-Octet Packet Counter Register (etherStatsPkts512to1023OctetsN), offset: 0x290 */
  __I  uint64_t PM0_T1522N;                        /**< Port MAC 0 Transmit 1024 to 1522-Octet Packet Counter Register (etherStatsPkts1024to1522OctetsN), offset: 0x298 */
  __I  uint64_t PM0_T1523XN;                       /**< Port MAC 0 Transmit 1523 to TX_MTU-Octet Packet Counter Register (etherStatsPkts1523toMaxOctetsN), offset: 0x2A0 */
       uint8_t RESERVED_15[24];
  __I  uint64_t PM0_TCNPN;                         /**< Port MAC 0 Transmit Control Packet Counter Register, offset: 0x2C0 */
       uint8_t RESERVED_16[8];
  __I  uint64_t PM0_TDFRN;                         /**< Port MAC 0 Transmit Deferred Packet Counter Register(aFramesWithDeferredXmissions), offset: 0x2D0 */
  __I  uint64_t PM0_TMCOLN;                        /**< Port MAC 0 Transmit Multiple Collisions Counter Register(aMultipleCollisionFrames), offset: 0x2D8 */
  __I  uint64_t PM0_TSCOLN;                        /**< Port MAC 0 Transmit Single Collision Counter(aSingleCollisionFrames) Register, offset: 0x2E0 */
  __I  uint64_t PM0_TLCOLN;                        /**< Port MAC 0 Transmit Late Collision Counter(aLateCollisions) Register, offset: 0x2E8 */
  __I  uint64_t PM0_TECOLN;                        /**< Port MAC 0 Transmit Excessive Collisions Counter Register, offset: 0x2F0 */
       uint8_t RESERVED_17[8];
  __IO uint32_t PM0_IF_MODE;                       /**< Port MAC 0 Interface Mode Control Register, offset: 0x300 */
       uint8_t RESERVED_18[260];
  __IO uint32_t PM1_COMMAND_CONFIG;                /**< Port MAC 1 Command and Configuration Register, offset: 0x408 */
  __I  uint32_t PM1_MAC_ADDR_0;                    /**< Port MAC 1 MAC Address Register 0, offset: 0x40C */
  __I  uint32_t PM1_MAC_ADDR_1;                    /**< Port MAC 1 MAC Address Register 1, offset: 0x410 */
  __IO uint32_t PM1_MAXFRM;                        /**< Port MAC 1 Maximum Frame Length Register, offset: 0x414 */
  __IO uint32_t PM1_MINFRM;                        /**< Port MAC 1 Minimum Frame Length Register, offset: 0x418 */
       uint8_t RESERVED_19[36];
  __IO uint32_t PM1_IEVENT;                        /**< Port MAC 1 Interrupt Event Register, offset: 0x440 */
  __IO uint32_t PM1_TX_IPG_PREAMBLE;               /**< Port MAC 1 Transmit Inter-Packet Gap Length and Flexible Preamble length Register, offset: 0x444 */
       uint8_t RESERVED_20[4];
  __IO uint32_t PM1_IMASK;                         /**< Port MAC 1 Interrupt Mask Register(INT_MASK), offset: 0x44C */
       uint8_t RESERVED_21[4];
  __IO uint32_t PM1_PAUSE_QUANTA;                  /**< Port MAC 1 Pause Quanta Register, offset: 0x454 */
       uint8_t RESERVED_22[12];
  __IO uint32_t PM1_PAUSE_THRESH;                  /**< Port MAC 1 Pause Quanta Threshold Register, offset: 0x464 */
       uint8_t RESERVED_23[12];
  __I  uint32_t PM1_RX_PAUSE_STATUS;               /**< Port MAC 1 Receive Pause Status Register, offset: 0x474 */
       uint8_t RESERVED_24[64];
  __IO uint32_t PM1_LPWAKE_TIMER;                  /**< Port MAC 1 EEE Low Power Wakeup Timer Register, offset: 0x4B8 */
  __IO uint32_t PM1_SLEEP_TIMER;                   /**< Port MAC 1 Transmit EEE Low Power Timer Register, offset: 0x4BC */
  __IO uint32_t PM1_SINGLE_STEP;                   /**< Port MAC 1 IEEE1588 Single-Step Control Register, offset: 0x4C0 */
       uint8_t RESERVED_25[12];
  __IO uint32_t PM1_HD_BACKOFF_ENTROPY;            /**< Port MAC 1 half-duplex backoff entropy register, offset: 0x4D0 */
  __IO uint32_t PM1_HD_FLOW_CTRL;                  /**< Port MAC 1 Half-Duplex Flow Control Register, offset: 0x4D4 */
       uint8_t RESERVED_26[8];
  __IO uint32_t PM1_STATN_CONFIG;                  /**< Port MAC 1 Statistics Configuration Register, offset: 0x4E0 */
       uint8_t RESERVED_27[28];
  __I  uint64_t PM1_REOCTN;                        /**< Port MAC 1 Receive Ethernet Octets Counter(etherStatsOctetsn), offset: 0x500 */
  __I  uint64_t PM1_ROCTN;                         /**< Port MAC 1 Receive Octets Counter(iflnOctetsn), offset: 0x508 */
       uint8_t RESERVED_28[8];
  __I  uint64_t PM1_RXPFN;                         /**< Port MAC 1 Receive Valid Pause Frame Counter Register(aPAUSEMACCtrlFramesReceivedn), offset: 0x518 */
  __I  uint64_t PM1_RFRMN;                         /**< Port MAC 1 Receive Frame Counter Register(aFramesReceivedOKn), offset: 0x520 */
  __I  uint64_t PM1_RFCSN;                         /**< Port MAC 1 Receive Frame Check Sequence Error Counter Register(), offset: 0x528 */
  __I  uint64_t PM1_RVLANN;                        /**< Port MAC 1 Receive VLAN Frame Counter Register(VLANReceivedOKn), offset: 0x530 */
  __I  uint64_t PM1_RERRN;                         /**< Port MAC 1 Receive Frame Error Counter Register(ifInErrorsn), offset: 0x538 */
  __I  uint64_t PM1_RUCAN;                         /**< Port MAC 1 Receive Unicast Frame Counter Register(ifInUcastPktsn), offset: 0x540 */
  __I  uint64_t PM1_RMCAN;                         /**< Port MAC 1 Receive Multicast Frame Counter Register(ifInMulticastPktsn), offset: 0x548 */
  __I  uint64_t PM1_RBCAN;                         /**< Port MAC 1 Receive Broadcast Frame Counter Register(ifInBroadcastPktsn), offset: 0x550 */
  __I  uint64_t PM1_RDRPN;                         /**< Port MAC 1 Receive Dropped Packets Counter Register(etherStatsDropEventsn), offset: 0x558 */
  __I  uint64_t PM1_RPKTN;                         /**< Port MAC 1 Receive Packets Counter Register(etherStatsPktsn), offset: 0x560 */
  __I  uint64_t PM1_RUNDN;                         /**< Port MAC 1 Receive Undersized Packet Counter Register(etherStatsUndersizePktsn), offset: 0x568 */
  __I  uint64_t PM1_R64N;                          /**< Port MAC 1 Receive 64-Octet Packet Counter Register(etherStatsPkts64OctetsN), offset: 0x570 */
  __I  uint64_t PM1_R127N;                         /**< Port MAC 1 Receive 65 to 127-Octet Packet Counter Register(etherStatsPkts65to127OctetsN), offset: 0x578 */
  __I  uint64_t PM1_R255N;                         /**< Port MAC 1 Receive 128 to 255-Octet Packet Counter Register(etherStatsPkts128to255OctetsN), offset: 0x580 */
  __I  uint64_t PM1_R511N;                         /**< Port MAC 1 Receive 256 to 511-Octet Packet Counter Register(etherStatsPkts256to511OctetsN), offset: 0x588 */
  __I  uint64_t PM1_R1023N;                        /**< Port MAC 1 Receive 512 to 1023-Octet Packet Counter Register(etherStatsPkts512to1023OctetsN), offset: 0x590 */
  __I  uint64_t PM1_R1522N;                        /**< Port MAC 1 Receive 1024 to 1522-Octet Packet Counter Register(etherStatsPkts1024to1522OctetsN), offset: 0x598 */
  __I  uint64_t PM1_R1523XN;                       /**< Port MAC 1 Receive 1523 to Max-Octet Packet Counter Register(etherStatsPkts1523toMaxOctetsN), offset: 0x5A0 */
  __I  uint64_t PM1_ROVRN;                         /**< Port MAC 1 Receive Oversized Packet Counter Register(etherStatsOversizePktsn), offset: 0x5A8 */
  __I  uint64_t PM1_RJBRN;                         /**< Port MAC 1 Receive Jabber Packet Counter Register(etherStatsJabbersn), offset: 0x5B0 */
  __I  uint64_t PM1_RFRGN;                         /**< Port MAC 1 Receive Fragment Packet Counter Register(etherStatsFragmentsn, offset: 0x5B8 */
  __I  uint64_t PM1_RCNPN;                         /**< Port MAC 1 Receive Control Packet Counter Register, offset: 0x5C0 */
  __I  uint64_t PM1_RDRNTPN;                       /**< Port MAC 1 Receive Dropped Not Truncated Packets Counter Register(etherStatsDropEventsn), offset: 0x5C8 */
  __I  uint64_t PM1_RMIN63N;                       /**< Port MAC 1 Receive Valid Small Packet Counter Register, offset: 0x5D0 */
       uint8_t RESERVED_29[40];
  __I  uint64_t PM1_TEOCTN;                        /**< Port MAC 1 Transmit Ethernet Octets Counter(etherStatsOctetsn), offset: 0x600 */
  __I  uint64_t PM1_TOCTN;                         /**< Port MAC 1 Transmit Octets Counter Register(ifOutOctetsn), offset: 0x608 */
       uint8_t RESERVED_30[8];
  __I  uint64_t PM1_TXPFN;                         /**< Port MAC 1 Transmit Valid Pause Frame Counter Register(aPAUSEMACCtrlFramesReceivedn), offset: 0x618 */
  __I  uint64_t PM1_TFRMN;                         /**< Port MAC 1 Transmit Frame Counter Register(aFramesTransmittedOKn), offset: 0x620 */
  __I  uint64_t PM1_TFCSN;                         /**< Port MAC 1 Transmit Frame Check Sequence Error Counter Register(), offset: 0x628 */
  __I  uint64_t PM1_TVLANN;                        /**< Port MAC 1 Transmit VLAN Frame Counter Register(VLANTransmittedOKn), offset: 0x630 */
  __I  uint64_t PM1_TERRN;                         /**< Port MAC 1 Transmit Frame Error Counter Register(ifOutErrorsn), offset: 0x638 */
  __I  uint64_t PM1_TUCAN;                         /**< Port MAC 1 Transmit Unicast Frame Counter Register(ifOutUcastPktsn), offset: 0x640 */
  __I  uint64_t PM1_TMCAN;                         /**< Port MAC 1 Transmit Multicast Frame Counter Register(ifOutMulticastPktsn), offset: 0x648 */
  __I  uint64_t PM1_TBCAN;                         /**< Port MAC 1 Transmit Broadcast Frame Counter Register(ifOutBroadcastPktsn), offset: 0x650 */
       uint8_t RESERVED_31[8];
  __I  uint64_t PM1_TPKTN;                         /**< Port MAC 1 Transmit Packets Counter Register(etherStatsPktsn), offset: 0x660 */
  __I  uint64_t PM1_TUNDN;                         /**< Port MAC 1 Transmit Undersized Packet Counter Register(etherStatsUndersizePktsn), offset: 0x668 */
  __I  uint64_t PM1_T64N;                          /**< Port MAC 1 Transmit 64-Octet Packet Counter Register (etherStatsPkts64OctetsN), offset: 0x670 */
  __I  uint64_t PM1_T127N;                         /**< Port MAC 1 Transmit 65 to 127-Octet Packet Counter Register (etherStatsPkts65to127OctetsN), offset: 0x678 */
  __I  uint64_t PM1_T255N;                         /**< Port MAC 1 Transmit 128 to 255-Octet Packet Counter Register (etherStatsPkts128to255OctetsN), offset: 0x680 */
  __I  uint64_t PM1_T511N;                         /**< Port MAC 1 Transmit 256 to 511-Octet Packet Counter Register (etherStatsPkts256to511OctetsN), offset: 0x688 */
  __I  uint64_t PM1_T1023N;                        /**< Port MAC 1 Transmit 512 to 1023-Octet Packet Counter Register (etherStatsPkts512to1023OctetsN), offset: 0x690 */
  __I  uint64_t PM1_T1522N;                        /**< Port MAC 1 Transmit 1024 to 1522-Octet Packet Counter Register (etherStatsPkts1024to1522OctetsN), offset: 0x698 */
  __I  uint64_t PM1_T1523XN;                       /**< Port MAC 1 Transmit 1523 to TX_MTU-Octet Packet Counter Register (etherStatsPkts1523toMaxOctetsN), offset: 0x6A0 */
       uint8_t RESERVED_32[24];
  __I  uint64_t PM1_TCNPN;                         /**< Port MAC 1 Transmit Control Packet Counter Register, offset: 0x6C0 */
       uint8_t RESERVED_33[8];
  __I  uint64_t PM1_TDFRN;                         /**< Port MAC 1 Transmit Deferred Packet Counter Register(aFramesWithDeferredXmissions), offset: 0x6D0 */
  __I  uint64_t PM1_TMCOLN;                        /**< Port MAC 1 Transmit Multiple Collisions Counter Register(aMultipleCollisionFrames), offset: 0x6D8 */
  __I  uint64_t PM1_TSCOLN;                        /**< Port MAC 1 Transmit Single Collision Counter(aSingleCollisionFrames) Register, offset: 0x6E0 */
  __I  uint64_t PM1_TLCOLN;                        /**< Port MAC 1 Transmit Late Collision Counter(aLateCollisions) Register, offset: 0x6E8 */
  __I  uint64_t PM1_TECOLN;                        /**< Port MAC 1 Transmit Excessive Collisions Counter Register, offset: 0x6F0 */
       uint8_t RESERVED_34[8];
  __IO uint32_t PM1_IF_MODE;                       /**< Port MAC 1 Interface Mode Control Register, offset: 0x700 */
       uint8_t RESERVED_35[252];
  __IO uint32_t MAC_MERGE_MMCSR;                   /**< Port MAC Merge Control and Status Register, offset: 0x800 */
       uint8_t RESERVED_36[4];
  __IO uint32_t MAC_MERGE_MMFAECR;                 /**< Port MAC Merge Frame Assembly Error Count Register, offset: 0x808 */
  __IO uint32_t MAC_MERGE_MMFSECR;                 /**< Port MAC Merge Frame SMD Error Count Register, offset: 0x80C */
  __IO uint32_t MAC_MERGE_MMFAOCR;                 /**< Port MAC Merge Frame Assembly OK Count Register, offset: 0x810 */
  __IO uint32_t MAC_MERGE_MMFCRXR;                 /**< Port MAC Merge Fragment Count RX Register, offset: 0x814 */
  __IO uint32_t MAC_MERGE_MMFCTXR;                 /**< Port MAC Merge Fragment Count TX Register, offset: 0x818 */
  __IO uint32_t MAC_MERGE_MMHCR;                   /**< Port MAC Merge Hold Count Register, offset: 0x81C */
       uint8_t RESERVED_37[992];
  __IO uint32_t PEMDIOCR;                          /**< Port external MDIO configuration register, offset: 0xC00 */
  __IO uint32_t PEMDIOICR;                         /**< Port external MDIO interface control register, offset: 0xC04 */
  __IO uint32_t PEMDIOIDR;                         /**< Port external MDIO interface data register, offset: 0xC08 */
  __IO uint32_t PEMDIORAR;                         /**< Port external MDIO register address register, offset: 0xC0C */
  __I  uint32_t PEMDIOSR;                          /**< Port external MDIO status register, offset: 0xC10 */
       uint8_t RESERVED_38[12];
  __IO uint32_t PPSCR;                             /**< PHY status configuration register, offset: 0xC20 */
  __IO uint32_t PPSCTRLR;                          /**< Port PHY status control register, offset: 0xC24 */
  __I  uint32_t PPSDR;                             /**< Port PHY status data register, offset: 0xC28 */
  __IO uint32_t PPSRAR;                            /**< Port PHY status register address register, offset: 0xC2C */
  __IO uint32_t PPSER;                             /**< Port PHY status event register, offset: 0xC30 */
  __IO uint32_t PPSMR;                             /**< Port PHY status mask register, offset: 0xC34 */
} NETC_ETH_LINK_Type;

/* ----------------------------------------------------------------------------
   -- NETC_ETH_LINK Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NETC_ETH_LINK_Register_Masks NETC_ETH_LINK Register Masks
 * @{
 */

/*! @name PM0_COMMAND_CONFIG - Port MAC 0 Command and Configuration Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_EN_MASK (0x1U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_EN_SHIFT (0U)
/*! TX_EN - MAC transmit path enable */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_EN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_EN_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_EN_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_EN_MASK (0x2U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_EN_SHIFT (1U)
/*! RX_EN - MAC receive path enable */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_EN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_EN_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_EN_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_FWD_MASK (0x80U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_FWD_SHIFT (7U)
/*! PAUSE_FWD - Terminate/forward received PAUSE frames */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_FWD(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_FWD_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_FWD_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_IGN_MASK (0x100U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_IGN_SHIFT (8U)
/*! PAUSE_IGN - Ignore PAUSE frame quanta */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_IGN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_IGN_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_PAUSE_IGN_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_ADDR_INS_MASK (0x200U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_ADDR_INS_SHIFT (9U)
/*! TX_ADDR_INS - Transmit source MAC address insertion */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_ADDR_INS(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_ADDR_INS_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_ADDR_INS_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_LOOP_ENA_MASK (0x400U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_LOOP_ENA_SHIFT (10U)
/*! LOOP_ENA - Loopback enable */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_LOOP_ENA(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_LOOP_ENA_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_LOOP_ENA_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_LPBK_MODE_MASK (0x1800U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_LPBK_MODE_SHIFT (11U)
/*! LPBK_MODE - Loopback mode */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_LPBK_MODE(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_LPBK_MODE_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_LPBK_MODE_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_CNT_FRM_EN_MASK (0x2000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_CNT_FRM_EN_SHIFT (13U)
/*! CNT_FRM_EN - Control frame reception enable */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_CNT_FRM_EN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_CNT_FRM_EN_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_CNT_FRM_EN_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_PNT_MASK (0x4000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_PNT_SHIFT (14U)
/*! TS_PNT - Timestamp Point */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_PNT(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_PNT_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_PNT_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TXP_MASK (0x8000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TXP_SHIFT (15U)
/*! TXP - Enable padding of frames in transmit direction (1, default). */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TXP(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_TXP_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_TXP_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_HD_FCEN_MASK (0x40000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_HD_FCEN_SHIFT (18U)
/*! HD_FCEN - Half Duplex Flow Control Enable */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_HD_FCEN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_HD_FCEN_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_HD_FCEN_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_FLUSH_MASK (0x400000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_FLUSH_SHIFT (22U)
/*! TX_FLUSH - Tx flush */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_FLUSH(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_FLUSH_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_FLUSH_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_LOWP_ENA_MASK (0x800000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_LOWP_ENA_SHIFT (23U)
/*! TX_LOWP_ENA - Transmit Low Power Idle Enable.
 *  0b0..(default), the MAC operates in normal mode.
 *  0b1..The MAC completes the transmission of the current Frame and generates Low Power Idle Sequences to the
 *       line. It is advised to inspect IEVENT[TX_EMPTY] is set before enabling the LPI.
 */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_LOWP_ENA(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_LOWP_ENA_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_TX_LOWP_ENA_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_SWR_MASK (0x4000000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_SWR_SHIFT (26U)
/*! SWR - Software Reset. Self clearing bit. */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_SWR(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_SWR_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_SWR_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_FLUSH_MASK (0x10000000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_FLUSH_SHIFT (28U)
/*! RX_FLUSH - Ingress flush enable */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_FLUSH(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_FLUSH_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_RX_FLUSH_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_MODE_MASK (0x40000000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_MODE_SHIFT (30U)
/*! TS_MODE - Transmit timestamp mode */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_MODE(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_MODE_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_TS_MODE_MASK)

#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_MG_MASK (0x80000000U)
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_MG_SHIFT (31U)
/*! MG - Magic Packet detection enable. */
#define NETC_ETH_LINK_PM0_COMMAND_CONFIG_MG(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_COMMAND_CONFIG_MG_SHIFT)) & NETC_ETH_LINK_PM0_COMMAND_CONFIG_MG_MASK)
/*! @} */

/*! @name PM0_MAC_ADDR_0 - Port MAC 0 MAC Address Register 0 */
/*! @{ */

#define NETC_ETH_LINK_PM0_MAC_ADDR_0_MAC_ADDR_0_MASK (0xFFFFFFFFU)
#define NETC_ETH_LINK_PM0_MAC_ADDR_0_MAC_ADDR_0_SHIFT (0U)
/*! MAC_ADDR_0 - MAC address 0 */
#define NETC_ETH_LINK_PM0_MAC_ADDR_0_MAC_ADDR_0(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MAC_ADDR_0_MAC_ADDR_0_SHIFT)) & NETC_ETH_LINK_PM0_MAC_ADDR_0_MAC_ADDR_0_MASK)
/*! @} */

/*! @name PM0_MAC_ADDR_1 - Port MAC 0 MAC Address Register 1 */
/*! @{ */

#define NETC_ETH_LINK_PM0_MAC_ADDR_1_MAC_ADDR_1_MASK (0xFFFFU)
#define NETC_ETH_LINK_PM0_MAC_ADDR_1_MAC_ADDR_1_SHIFT (0U)
/*! MAC_ADDR_1 - MAC address 1 */
#define NETC_ETH_LINK_PM0_MAC_ADDR_1_MAC_ADDR_1(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MAC_ADDR_1_MAC_ADDR_1_SHIFT)) & NETC_ETH_LINK_PM0_MAC_ADDR_1_MAC_ADDR_1_MASK)
/*! @} */

/*! @name PM0_MAXFRM - Port MAC 0 Maximum Frame Length Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_MAXFRM_MAXFRM_MASK     (0xFFFFU)
#define NETC_ETH_LINK_PM0_MAXFRM_MAXFRM_SHIFT    (0U)
/*! MAXFRM - Maximum supported received frame length. */
#define NETC_ETH_LINK_PM0_MAXFRM_MAXFRM(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MAXFRM_MAXFRM_SHIFT)) & NETC_ETH_LINK_PM0_MAXFRM_MAXFRM_MASK)

#define NETC_ETH_LINK_PM0_MAXFRM_TX_MTU_MASK     (0xFFFF0000U)
#define NETC_ETH_LINK_PM0_MAXFRM_TX_MTU_SHIFT    (16U)
/*! TX_MTU - Maximum transmit frame length */
#define NETC_ETH_LINK_PM0_MAXFRM_TX_MTU(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MAXFRM_TX_MTU_SHIFT)) & NETC_ETH_LINK_PM0_MAXFRM_TX_MTU_MASK)
/*! @} */

/*! @name PM0_MINFRM - Port MAC 0 Minimum Frame Length Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_MINFRM_NUM_BYTES_MASK  (0x7FU)
#define NETC_ETH_LINK_PM0_MINFRM_NUM_BYTES_SHIFT (0U)
/*! NUM_BYTES - Receive Minimum Frame Length size in bytes. */
#define NETC_ETH_LINK_PM0_MINFRM_NUM_BYTES(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MINFRM_NUM_BYTES_SHIFT)) & NETC_ETH_LINK_PM0_MINFRM_NUM_BYTES_MASK)
/*! @} */

/*! @name PM0_MDIO_CFG - Port MAC 0 Internal MDIO Configuration Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_MDIO_CFG_BSY2_MASK     (0x1U)
#define NETC_ETH_LINK_PM0_MDIO_CFG_BSY2_SHIFT    (0U)
/*! BSY2 - MDIO busy (same as bit 31) */
#define NETC_ETH_LINK_PM0_MDIO_CFG_BSY2(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CFG_BSY2_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CFG_BSY2_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_HOLD_MASK (0x1CU)
#define NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_HOLD_SHIFT (2U)
/*! MDIO_HOLD - MDIO hold time */
#define NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_HOLD(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_HOLD_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_HOLD_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CFG_PRE_DIS_MASK  (0x20U)
#define NETC_ETH_LINK_PM0_MDIO_CFG_PRE_DIS_SHIFT (5U)
/*! PRE_DIS - MDIO preamble disable. */
#define NETC_ETH_LINK_PM0_MDIO_CFG_PRE_DIS(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CFG_PRE_DIS_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CFG_PRE_DIS_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CFG_ENC45_MASK    (0x40U)
#define NETC_ETH_LINK_PM0_MDIO_CFG_ENC45_SHIFT   (6U)
/*! ENC45 - Enable Clause 45 support. */
#define NETC_ETH_LINK_PM0_MDIO_CFG_ENC45(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CFG_ENC45_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CFG_ENC45_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_CLK_DIV_MASK (0xFF80U)
#define NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_CLK_DIV_SHIFT (7U)
/*! MDIO_CLK_DIV - MDIO clock divisor. */
#define NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_CLK_DIV(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_CLK_DIV_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CFG_MDIO_CLK_DIV_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CFG_CIM_MASK      (0x20000000U)
#define NETC_ETH_LINK_PM0_MDIO_CFG_CIM_SHIFT     (29U)
/*! CIM - MDIO command completion interrupt mask. */
#define NETC_ETH_LINK_PM0_MDIO_CFG_CIM(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CFG_CIM_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CFG_CIM_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CFG_CMP_MASK      (0x40000000U)
#define NETC_ETH_LINK_PM0_MDIO_CFG_CMP_SHIFT     (30U)
/*! CMP - MDIO command completion event. Bit is cleared by writing `1'. */
#define NETC_ETH_LINK_PM0_MDIO_CFG_CMP(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CFG_CMP_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CFG_CMP_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CFG_BSY1_MASK     (0x80000000U)
#define NETC_ETH_LINK_PM0_MDIO_CFG_BSY1_SHIFT    (31U)
/*! BSY1 - MDIO busy */
#define NETC_ETH_LINK_PM0_MDIO_CFG_BSY1(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CFG_BSY1_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CFG_BSY1_MASK)
/*! @} */

/*! @name PM0_MDIO_CTL - Port MAC 0 Internal MDIO Interface Control Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_MDIO_CTL_DEV_ADDR_MASK (0x1FU)
#define NETC_ETH_LINK_PM0_MDIO_CTL_DEV_ADDR_SHIFT (0U)
/*! DEV_ADDR - MDIO register address (Clause 22) */
#define NETC_ETH_LINK_PM0_MDIO_CTL_DEV_ADDR(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CTL_DEV_ADDR_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CTL_DEV_ADDR_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CTL_PORT_ADDR_MASK (0x3E0U)
#define NETC_ETH_LINK_PM0_MDIO_CTL_PORT_ADDR_SHIFT (5U)
/*! PORT_ADDR - MDIO PHY address (Clause 22) */
#define NETC_ETH_LINK_PM0_MDIO_CTL_PORT_ADDR(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CTL_PORT_ADDR_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CTL_PORT_ADDR_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CTL_READ_MASK     (0x8000U)
#define NETC_ETH_LINK_PM0_MDIO_CTL_READ_SHIFT    (15U)
/*! READ - MDIO read initiation. */
#define NETC_ETH_LINK_PM0_MDIO_CTL_READ(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CTL_READ_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CTL_READ_MASK)

#define NETC_ETH_LINK_PM0_MDIO_CTL_BSY_MASK      (0x80000000U)
#define NETC_ETH_LINK_PM0_MDIO_CTL_BSY_SHIFT     (31U)
/*! BSY - MDIO busy */
#define NETC_ETH_LINK_PM0_MDIO_CTL_BSY(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_CTL_BSY_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_CTL_BSY_MASK)
/*! @} */

/*! @name PM0_MDIO_DATA - Port MAC 0 Internal MDIO Interface Data Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_MDIO_DATA_MDIO_DATA_MASK (0xFFFFU)
#define NETC_ETH_LINK_PM0_MDIO_DATA_MDIO_DATA_SHIFT (0U)
/*! MDIO_DATA - 16-bit MDIO data. */
#define NETC_ETH_LINK_PM0_MDIO_DATA_MDIO_DATA(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_DATA_MDIO_DATA_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_DATA_MDIO_DATA_MASK)

#define NETC_ETH_LINK_PM0_MDIO_DATA_BUSY_MASK    (0x80000000U)
#define NETC_ETH_LINK_PM0_MDIO_DATA_BUSY_SHIFT   (31U)
/*! BUSY - MDIO busy bit. The state of this bit is also reflected in MDIO_CFG[BSY]. */
#define NETC_ETH_LINK_PM0_MDIO_DATA_BUSY(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_MDIO_DATA_BUSY_SHIFT)) & NETC_ETH_LINK_PM0_MDIO_DATA_BUSY_MASK)
/*! @} */

/*! @name PM0_IEVENT - Port MAC 0 Interrupt Event Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_IEVENT_TX_EMPTY_MASK   (0x20U)
#define NETC_ETH_LINK_PM0_IEVENT_TX_EMPTY_SHIFT  (5U)
/*! TX_EMPTY - Transmit fifo empty event */
#define NETC_ETH_LINK_PM0_IEVENT_TX_EMPTY(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_TX_EMPTY_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_TX_EMPTY_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_RX_EMPTY_MASK   (0x40U)
#define NETC_ETH_LINK_PM0_IEVENT_RX_EMPTY_SHIFT  (6U)
/*! RX_EMPTY - Receive idle event */
#define NETC_ETH_LINK_PM0_IEVENT_RX_EMPTY(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_RX_EMPTY_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_RX_EMPTY_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_TX_OVFL_MASK    (0x400U)
#define NETC_ETH_LINK_PM0_IEVENT_TX_OVFL_SHIFT   (10U)
/*! TX_OVFL - Transmit FIFO overflow event. */
#define NETC_ETH_LINK_PM0_IEVENT_TX_OVFL(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_TX_OVFL_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_TX_OVFL_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_TX_UNFL_MASK    (0x800U)
#define NETC_ETH_LINK_PM0_IEVENT_TX_UNFL_SHIFT   (11U)
/*! TX_UNFL - Transmit FIFO underflow event. */
#define NETC_ETH_LINK_PM0_IEVENT_TX_UNFL(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_TX_UNFL_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_TX_UNFL_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_RX_OVFL_MASK    (0x1000U)
#define NETC_ETH_LINK_PM0_IEVENT_RX_OVFL_SHIFT   (12U)
/*! RX_OVFL - Receive FIFO overflow event. */
#define NETC_ETH_LINK_PM0_IEVENT_RX_OVFL(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_RX_OVFL_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_RX_OVFL_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_MGI_MASK        (0x4000U)
#define NETC_ETH_LINK_PM0_IEVENT_MGI_SHIFT       (14U)
/*! MGI - Magic packet detection indication event */
#define NETC_ETH_LINK_PM0_IEVENT_MGI(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_MGI_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_MGI_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_TX_CSD_MASK     (0x200000U)
#define NETC_ETH_LINK_PM0_IEVENT_TX_CSD_SHIFT    (21U)
/*! TX_CSD - Tx Clock Stop Detection */
#define NETC_ETH_LINK_PM0_IEVENT_TX_CSD(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_TX_CSD_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_TX_CSD_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_RX_CSD_MASK     (0x400000U)
#define NETC_ETH_LINK_PM0_IEVENT_RX_CSD_SHIFT    (22U)
/*! RX_CSD - Rx Clock Stop Detection */
#define NETC_ETH_LINK_PM0_IEVENT_RX_CSD(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_RX_CSD_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_RX_CSD_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_SPD_DUP_MASK    (0x800000U)
#define NETC_ETH_LINK_PM0_IEVENT_SPD_DUP_SHIFT   (23U)
/*! SPD_DUP - Speed/Duplex Change */
#define NETC_ETH_LINK_PM0_IEVENT_SPD_DUP(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_SPD_DUP_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_SPD_DUP_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_MRG_SERR_MASK   (0x8000000U)
#define NETC_ETH_LINK_PM0_IEVENT_MRG_SERR_SHIFT  (27U)
/*! MRG_SERR - MAC merge frame SMD error received event */
#define NETC_ETH_LINK_PM0_IEVENT_MRG_SERR(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_MRG_SERR_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_MRG_SERR_MASK)

#define NETC_ETH_LINK_PM0_IEVENT_MRG_AERR_MASK   (0x10000000U)
#define NETC_ETH_LINK_PM0_IEVENT_MRG_AERR_SHIFT  (28U)
/*! MRG_AERR - MAC merge frame assembly error event */
#define NETC_ETH_LINK_PM0_IEVENT_MRG_AERR(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IEVENT_MRG_AERR_SHIFT)) & NETC_ETH_LINK_PM0_IEVENT_MRG_AERR_MASK)
/*! @} */

/*! @name PM0_TX_IPG_PREAMBLE - Port MAC 0 Transmit Inter-Packet Gap Length and Flexible Preamble length Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_IPG_LEN_MASK (0x7FU)
#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_IPG_LEN_SHIFT (0U)
/*! IPG_LEN - Transmit inter-packet gap value. */
#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_IPG_LEN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_IPG_LEN_SHIFT)) & NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_IPG_LEN_MASK)

#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT_MASK (0x700U)
#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT_SHIFT (8U)
/*! FLEX_PREAMBLE_CNT - Flexible Preamble Count */
#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT_SHIFT)) & NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT_MASK)

#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN_MASK (0x80000000U)
#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN_SHIFT (31U)
/*! FLEX_PREAMBLE_EN - Enable Flexible Preamble Count */
#define NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN_SHIFT)) & NETC_ETH_LINK_PM0_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN_MASK)
/*! @} */

/*! @name PM0_IMASK - Port MAC 0 Interrupt Mask Register(INT_MASK) */
/*! @{ */

#define NETC_ETH_LINK_PM0_IMASK_MGI_MASK         (0x4000U)
#define NETC_ETH_LINK_PM0_IMASK_MGI_SHIFT        (14U)
/*! MGI - Magic packet detection indication event mask. */
#define NETC_ETH_LINK_PM0_IMASK_MGI(x)           (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IMASK_MGI_SHIFT)) & NETC_ETH_LINK_PM0_IMASK_MGI_MASK)

#define NETC_ETH_LINK_PM0_IMASK_TX_CSD_MASK      (0x200000U)
#define NETC_ETH_LINK_PM0_IMASK_TX_CSD_SHIFT     (21U)
/*! TX_CSD - Tx Clock Stop Detection */
#define NETC_ETH_LINK_PM0_IMASK_TX_CSD(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IMASK_TX_CSD_SHIFT)) & NETC_ETH_LINK_PM0_IMASK_TX_CSD_MASK)

#define NETC_ETH_LINK_PM0_IMASK_RX_CSD_MASK      (0x400000U)
#define NETC_ETH_LINK_PM0_IMASK_RX_CSD_SHIFT     (22U)
/*! RX_CSD - Rx Clock Stop Detection */
#define NETC_ETH_LINK_PM0_IMASK_RX_CSD(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IMASK_RX_CSD_SHIFT)) & NETC_ETH_LINK_PM0_IMASK_RX_CSD_MASK)

#define NETC_ETH_LINK_PM0_IMASK_SPD_DUP_MASK     (0x800000U)
#define NETC_ETH_LINK_PM0_IMASK_SPD_DUP_SHIFT    (23U)
/*! SPD_DUP - Speed/Duplex change event mask. */
#define NETC_ETH_LINK_PM0_IMASK_SPD_DUP(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IMASK_SPD_DUP_SHIFT)) & NETC_ETH_LINK_PM0_IMASK_SPD_DUP_MASK)

#define NETC_ETH_LINK_PM0_IMASK_MRG_SERR_MASK    (0x8000000U)
#define NETC_ETH_LINK_PM0_IMASK_MRG_SERR_SHIFT   (27U)
/*! MRG_SERR - MAC merge frame SMD error received event interrupt mask */
#define NETC_ETH_LINK_PM0_IMASK_MRG_SERR(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IMASK_MRG_SERR_SHIFT)) & NETC_ETH_LINK_PM0_IMASK_MRG_SERR_MASK)

#define NETC_ETH_LINK_PM0_IMASK_MRG_AERR_MASK    (0x10000000U)
#define NETC_ETH_LINK_PM0_IMASK_MRG_AERR_SHIFT   (28U)
/*! MRG_AERR - MAC merge frame assembly error event interrupt mask */
#define NETC_ETH_LINK_PM0_IMASK_MRG_AERR(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IMASK_MRG_AERR_SHIFT)) & NETC_ETH_LINK_PM0_IMASK_MRG_AERR_MASK)
/*! @} */

/*! @name PM0_PAUSE_QUANTA - Port MAC 0 Pause Quanta Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_PAUSE_QUANTA_PQNT_MASK (0xFFFFU)
#define NETC_ETH_LINK_PM0_PAUSE_QUANTA_PQNT_SHIFT (0U)
/*! PQNT - Value to be used for the quanta value when XOFF is triggered. */
#define NETC_ETH_LINK_PM0_PAUSE_QUANTA_PQNT(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_PAUSE_QUANTA_PQNT_SHIFT)) & NETC_ETH_LINK_PM0_PAUSE_QUANTA_PQNT_MASK)
/*! @} */

/*! @name PM0_PAUSE_THRESH - Port MAC 0 Pause Quanta Threshold Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_PAUSE_THRESH_QTH_MASK  (0xFFFFU)
#define NETC_ETH_LINK_PM0_PAUSE_THRESH_QTH_SHIFT (0U)
/*! QTH - Quanta threshold. */
#define NETC_ETH_LINK_PM0_PAUSE_THRESH_QTH(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_PAUSE_THRESH_QTH_SHIFT)) & NETC_ETH_LINK_PM0_PAUSE_THRESH_QTH_MASK)
/*! @} */

/*! @name PM0_RX_PAUSE_STATUS - Port MAC 0 Receive Pause Status Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_RX_PAUSE_STATUS_PSTAT_MASK (0x1U)
#define NETC_ETH_LINK_PM0_RX_PAUSE_STATUS_PSTAT_SHIFT (0U)
/*! PSTAT - Pause status. */
#define NETC_ETH_LINK_PM0_RX_PAUSE_STATUS_PSTAT(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_RX_PAUSE_STATUS_PSTAT_SHIFT)) & NETC_ETH_LINK_PM0_RX_PAUSE_STATUS_PSTAT_MASK)
/*! @} */

/*! @name PM0_LPWAKE_TIMER - Port MAC 0 EEE Low Power Wakeup Timer Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_LPWAKE_TIMER_TW_SYS_TX_MASK (0xFFFFFFU)
#define NETC_ETH_LINK_PM0_LPWAKE_TIMER_TW_SYS_TX_SHIFT (0U)
/*! TW_SYS_TX - EEE System transmit wait time */
#define NETC_ETH_LINK_PM0_LPWAKE_TIMER_TW_SYS_TX(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_LPWAKE_TIMER_TW_SYS_TX_SHIFT)) & NETC_ETH_LINK_PM0_LPWAKE_TIMER_TW_SYS_TX_MASK)
/*! @} */

/*! @name PM0_SLEEP_TIMER - Port MAC 0 Transmit EEE Low Power Timer Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_SLEEP_TIMER_SLEEPT_MASK (0xFFFFFFU)
#define NETC_ETH_LINK_PM0_SLEEP_TIMER_SLEEPT_SHIFT (0U)
#define NETC_ETH_LINK_PM0_SLEEP_TIMER_SLEEPT(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_SLEEP_TIMER_SLEEPT_SHIFT)) & NETC_ETH_LINK_PM0_SLEEP_TIMER_SLEEPT_MASK)
/*! @} */

/*! @name PM0_SINGLE_STEP - Port MAC 0 IEEE1588 Single-Step Control Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_SINGLE_STEP_CH_MASK    (0x40U)
#define NETC_ETH_LINK_PM0_SINGLE_STEP_CH_SHIFT   (6U)
/*! CH - Checksum update */
#define NETC_ETH_LINK_PM0_SINGLE_STEP_CH(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_SINGLE_STEP_CH_SHIFT)) & NETC_ETH_LINK_PM0_SINGLE_STEP_CH_MASK)

#define NETC_ETH_LINK_PM0_SINGLE_STEP_OFFSET_MASK (0xFF80U)
#define NETC_ETH_LINK_PM0_SINGLE_STEP_OFFSET_SHIFT (7U)
#define NETC_ETH_LINK_PM0_SINGLE_STEP_OFFSET(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_SINGLE_STEP_OFFSET_SHIFT)) & NETC_ETH_LINK_PM0_SINGLE_STEP_OFFSET_MASK)

#define NETC_ETH_LINK_PM0_SINGLE_STEP_EN_MASK    (0x80000000U)
#define NETC_ETH_LINK_PM0_SINGLE_STEP_EN_SHIFT   (31U)
/*! EN - IEEE-1588 Single-Step enable. */
#define NETC_ETH_LINK_PM0_SINGLE_STEP_EN(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_SINGLE_STEP_EN_SHIFT)) & NETC_ETH_LINK_PM0_SINGLE_STEP_EN_MASK)
/*! @} */

/*! @name PM0_HD_BACKOFF_ENTROPY - Port MAC 0 half-duplex backoff entropy register */
/*! @{ */

#define NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY_MASK (0x3FFU)
#define NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY_SHIFT (0U)
/*! HD_BACKOFF_ENTROPY - Half duplex backoff entropy */
#define NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY_SHIFT)) & NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY_MASK)

#define NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID_MASK (0x80000000U)
#define NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID_SHIFT (31U)
/*! SW_ENTROPY_VALID - SW programmable entropy valid */
#define NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID_SHIFT)) & NETC_ETH_LINK_PM0_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID_MASK)
/*! @} */

/*! @name PM0_HD_FLOW_CTRL - Port MAC 0 Half-Duplex Flow Control Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_OFF_MIN_MASK (0xFFFU)
#define NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_OFF_MIN_SHIFT (0U)
/*! HD_BP_OFF_MIN - Half-Duplex Back-Pressure Off Minimum */
#define NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_OFF_MIN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_OFF_MIN_SHIFT)) & NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_OFF_MIN_MASK)

#define NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_ON_MAX_MASK (0xFFF0000U)
#define NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_ON_MAX_SHIFT (16U)
/*! HD_BP_ON_MAX - Half-Duplex Back-Pressure On Maximum */
#define NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_ON_MAX(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_ON_MAX_SHIFT)) & NETC_ETH_LINK_PM0_HD_FLOW_CTRL_HD_BP_ON_MAX_MASK)
/*! @} */

/*! @name PM0_STATN_CONFIG - Port MAC 0 Statistics Configuration Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_STATN_CONFIG_SAT_MASK  (0x1U)
#define NETC_ETH_LINK_PM0_STATN_CONFIG_SAT_SHIFT (0U)
#define NETC_ETH_LINK_PM0_STATN_CONFIG_SAT(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_STATN_CONFIG_SAT_SHIFT)) & NETC_ETH_LINK_PM0_STATN_CONFIG_SAT_MASK)

#define NETC_ETH_LINK_PM0_STATN_CONFIG_COD_MASK  (0x2U)
#define NETC_ETH_LINK_PM0_STATN_CONFIG_COD_SHIFT (1U)
#define NETC_ETH_LINK_PM0_STATN_CONFIG_COD(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_STATN_CONFIG_COD_SHIFT)) & NETC_ETH_LINK_PM0_STATN_CONFIG_COD_MASK)

#define NETC_ETH_LINK_PM0_STATN_CONFIG_CLR_MASK  (0x4U)
#define NETC_ETH_LINK_PM0_STATN_CONFIG_CLR_SHIFT (2U)
#define NETC_ETH_LINK_PM0_STATN_CONFIG_CLR(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_STATN_CONFIG_CLR_SHIFT)) & NETC_ETH_LINK_PM0_STATN_CONFIG_CLR_MASK)

#define NETC_ETH_LINK_PM0_STATN_CONFIG_WEN_MASK  (0x8U)
#define NETC_ETH_LINK_PM0_STATN_CONFIG_WEN_SHIFT (3U)
/*! WEN - Write enable for Tx/Rx stats registers */
#define NETC_ETH_LINK_PM0_STATN_CONFIG_WEN(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_STATN_CONFIG_WEN_SHIFT)) & NETC_ETH_LINK_PM0_STATN_CONFIG_WEN_MASK)
/*! @} */

/*! @name PM0_REOCTN - Port MAC 0 Receive Ethernet Octets Counter(etherStatsOctetsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_REOCTN_REOCTn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_REOCTN_REOCTn_SHIFT    (0U)
/*! REOCTn - Incremented for each octet received in both good and bad packets. */
#define NETC_ETH_LINK_PM0_REOCTN_REOCTn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_REOCTN_REOCTn_SHIFT)) & NETC_ETH_LINK_PM0_REOCTN_REOCTn_MASK)
/*! @} */

/*! @name PM0_ROCTN - Port MAC 0 Receive Octets Counter(iflnOctetsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_ROCTN_ROCTn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_ROCTN_ROCTn_SHIFT      (0U)
/*! ROCTn - Incremented for each octet received except preamble (that is, Header, Payload, Pad and
 *    FCS) for all valid frames and valid PAUSE frames received.
 */
#define NETC_ETH_LINK_PM0_ROCTN_ROCTn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_ROCTN_ROCTn_SHIFT)) & NETC_ETH_LINK_PM0_ROCTN_ROCTn_MASK)
/*! @} */

/*! @name PM0_RXPFN - Port MAC 0 Receive Valid Pause Frame Counter Register(aPAUSEMACCtrlFramesReceivedn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RXPFN_RXPFn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RXPFN_RXPFn_SHIFT      (0U)
/*! RXPFn - Incremented for each valid PAUSE frame received . */
#define NETC_ETH_LINK_PM0_RXPFN_RXPFn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RXPFN_RXPFn_SHIFT)) & NETC_ETH_LINK_PM0_RXPFN_RXPFn_MASK)
/*! @} */

/*! @name PM0_RFRMN - Port MAC 0 Receive Frame Counter Register(aFramesReceivedOKn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RFRMN_RFRMn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RFRMN_RFRMn_SHIFT      (0U)
/*! RFRMn - Incremented for each frame received without error, including PAUSE frames. */
#define NETC_ETH_LINK_PM0_RFRMN_RFRMn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RFRMN_RFRMn_SHIFT)) & NETC_ETH_LINK_PM0_RFRMN_RFRMn_MASK)
/*! @} */

/*! @name PM0_RFCSN - Port MAC 0 Receive Frame Check Sequence Error Counter Register() */
/*! @{ */

#define NETC_ETH_LINK_PM0_RFCSN_RFCSn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RFCSN_RFCSn_SHIFT      (0U)
/*! RFCSn - Incremented for each frame received with a CRC-32 error but the frame is otherwise of correct length. */
#define NETC_ETH_LINK_PM0_RFCSN_RFCSn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RFCSN_RFCSn_SHIFT)) & NETC_ETH_LINK_PM0_RFCSN_RFCSn_MASK)
/*! @} */

/*! @name PM0_RVLANN - Port MAC 0 Receive VLAN Frame Counter Register(VLANReceivedOKn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RVLANN_RVLANn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RVLANN_RVLANn_SHIFT    (0U)
/*! RVLANn - Incremented for each valid VLAN tagged frame received with ethertype 0x8100 */
#define NETC_ETH_LINK_PM0_RVLANN_RVLANn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RVLANN_RVLANn_SHIFT)) & NETC_ETH_LINK_PM0_RVLANN_RVLANn_MASK)
/*! @} */

/*! @name PM0_RERRN - Port MAC 0 Receive Frame Error Counter Register(ifInErrorsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RERRN_RERRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RERRN_RERRn_SHIFT      (0U)
/*! RERRn - Incremented for each frame received with an error (except for undersized/fragment frame): */
#define NETC_ETH_LINK_PM0_RERRN_RERRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RERRN_RERRn_SHIFT)) & NETC_ETH_LINK_PM0_RERRN_RERRn_MASK)
/*! @} */

/*! @name PM0_RUCAN - Port MAC 0 Receive Unicast Frame Counter Register(ifInUcastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RUCAN_RUCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RUCAN_RUCAn_SHIFT      (0U)
/*! RUCAn - Incremented for each valid frame received (on the receive FIFO interface) in which bit 0
 *    of the destination address was 0 .
 */
#define NETC_ETH_LINK_PM0_RUCAN_RUCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RUCAN_RUCAn_SHIFT)) & NETC_ETH_LINK_PM0_RUCAN_RUCAn_MASK)
/*! @} */

/*! @name PM0_RMCAN - Port MAC 0 Receive Multicast Frame Counter Register(ifInMulticastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RMCAN_RMCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RMCAN_RMCAn_SHIFT      (0U)
#define NETC_ETH_LINK_PM0_RMCAN_RMCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RMCAN_RMCAn_SHIFT)) & NETC_ETH_LINK_PM0_RMCAN_RMCAn_MASK)
/*! @} */

/*! @name PM0_RBCAN - Port MAC 0 Receive Broadcast Frame Counter Register(ifInBroadcastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RBCAN_RBCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RBCAN_RBCAn_SHIFT      (0U)
/*! RBCAn - Incremented for each valid frame received (on the receive FIFO interface) in which all
 *    bits of the destination address were 1 .
 */
#define NETC_ETH_LINK_PM0_RBCAN_RBCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RBCAN_RBCAn_SHIFT)) & NETC_ETH_LINK_PM0_RBCAN_RBCAn_MASK)
/*! @} */

/*! @name PM0_RDRPN - Port MAC 0 Receive Dropped Packets Counter Register(etherStatsDropEventsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RDRPN_RDRPn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RDRPN_RDRPn_SHIFT      (0U)
#define NETC_ETH_LINK_PM0_RDRPN_RDRPn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RDRPN_RDRPn_SHIFT)) & NETC_ETH_LINK_PM0_RDRPN_RDRPn_MASK)
/*! @} */

/*! @name PM0_RPKTN - Port MAC 0 Receive Packets Counter Register(etherStatsPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RPKTN_RPKTn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RPKTN_RPKTn_SHIFT      (0U)
/*! RPKTn - Incremented for each good or bad packet received. */
#define NETC_ETH_LINK_PM0_RPKTN_RPKTn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RPKTN_RPKTn_SHIFT)) & NETC_ETH_LINK_PM0_RPKTN_RPKTn_MASK)
/*! @} */

/*! @name PM0_RUNDN - Port MAC 0 Receive Undersized Packet Counter Register(etherStatsUndersizePktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RUNDN_RUNDn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RUNDN_RUNDn_SHIFT      (0U)
#define NETC_ETH_LINK_PM0_RUNDN_RUNDn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RUNDN_RUNDn_SHIFT)) & NETC_ETH_LINK_PM0_RUNDN_RUNDn_MASK)
/*! @} */

/*! @name PM0_R64N - Port MAC 0 Receive 64-Octet Packet Counter Register(etherStatsPkts64OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_R64N_R64n_MASK         (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_R64N_R64n_SHIFT        (0U)
/*! R64n - Incremented for each 64-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM0_R64N_R64n(x)           (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_R64N_R64n_SHIFT)) & NETC_ETH_LINK_PM0_R64N_R64n_MASK)
/*! @} */

/*! @name PM0_R127N - Port MAC 0 Receive 65 to 127-Octet Packet Counter Register(etherStatsPkts65to127OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_R127N_R127n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_R127N_R127n_SHIFT      (0U)
/*! R127n - Incremented for each 65- to 127-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM0_R127N_R127n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_R127N_R127n_SHIFT)) & NETC_ETH_LINK_PM0_R127N_R127n_MASK)
/*! @} */

/*! @name PM0_R255N - Port MAC 0 Receive 128 to 255-Octet Packet Counter Register(etherStatsPkts128to255OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_R255N_R255n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_R255N_R255n_SHIFT      (0U)
/*! R255n - Incremented for each 128- to 255-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM0_R255N_R255n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_R255N_R255n_SHIFT)) & NETC_ETH_LINK_PM0_R255N_R255n_MASK)
/*! @} */

/*! @name PM0_R511N - Port MAC 0 Receive 256 to 511-Octet Packet Counter Register(etherStatsPkts256to511OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_R511N_R511n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_R511N_R511n_SHIFT      (0U)
/*! R511n - Incremented for each 256- to 511-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM0_R511N_R511n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_R511N_R511n_SHIFT)) & NETC_ETH_LINK_PM0_R511N_R511n_MASK)
/*! @} */

/*! @name PM0_R1023N - Port MAC 0 Receive 512 to 1023-Octet Packet Counter Register(etherStatsPkts512to1023OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_R1023N_R1023n_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_R1023N_R1023n_SHIFT    (0U)
/*! R1023n - Incremented for each 512- to 1023-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM0_R1023N_R1023n(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_R1023N_R1023n_SHIFT)) & NETC_ETH_LINK_PM0_R1023N_R1023n_MASK)
/*! @} */

/*! @name PM0_R1522N - Port MAC 0 Receive 1024 to 1522-Octet Packet Counter Register(etherStatsPkts1024to1522OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_R1522N_R1522n_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_R1522N_R1522n_SHIFT    (0U)
/*! R1522n - Incremented for each 1024- to 1522-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM0_R1522N_R1522n(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_R1522N_R1522n_SHIFT)) & NETC_ETH_LINK_PM0_R1522N_R1522n_MASK)
/*! @} */

/*! @name PM0_R1523XN - Port MAC 0 Receive 1523 to Max-Octet Packet Counter Register(etherStatsPkts1523toMaxOctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_R1523XN_R1523Xn_MASK   (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_R1523XN_R1523Xn_SHIFT  (0U)
#define NETC_ETH_LINK_PM0_R1523XN_R1523Xn(x)     (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_R1523XN_R1523Xn_SHIFT)) & NETC_ETH_LINK_PM0_R1523XN_R1523Xn_MASK)
/*! @} */

/*! @name PM0_ROVRN - Port MAC 0 Receive Oversized Packet Counter Register(etherStatsOversizePktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_ROVRN_ROVRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_ROVRN_ROVRn_SHIFT      (0U)
#define NETC_ETH_LINK_PM0_ROVRN_ROVRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_ROVRN_ROVRn_SHIFT)) & NETC_ETH_LINK_PM0_ROVRN_ROVRn_MASK)
/*! @} */

/*! @name PM0_RJBRN - Port MAC 0 Receive Jabber Packet Counter Register(etherStatsJabbersn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RJBRN_RJBRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RJBRN_RJBRn_SHIFT      (0U)
#define NETC_ETH_LINK_PM0_RJBRN_RJBRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RJBRN_RJBRn_SHIFT)) & NETC_ETH_LINK_PM0_RJBRN_RJBRn_MASK)
/*! @} */

/*! @name PM0_RFRGN - Port MAC 0 Receive Fragment Packet Counter Register(etherStatsFragmentsn */
/*! @{ */

#define NETC_ETH_LINK_PM0_RFRGN_RFRGn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RFRGN_RFRGn_SHIFT      (0U)
#define NETC_ETH_LINK_PM0_RFRGN_RFRGn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RFRGN_RFRGn_SHIFT)) & NETC_ETH_LINK_PM0_RFRGN_RFRGn_MASK)
/*! @} */

/*! @name PM0_RCNPN - Port MAC 0 Receive Control Packet Counter Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_RCNPN_RCNPn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RCNPN_RCNPn_SHIFT      (0U)
/*! RCNPn - Incremented for each valid control packet (type 0x8808) but not for PAUSE packets */
#define NETC_ETH_LINK_PM0_RCNPN_RCNPn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RCNPN_RCNPn_SHIFT)) & NETC_ETH_LINK_PM0_RCNPN_RCNPn_MASK)
/*! @} */

/*! @name PM0_RDRNTPN - Port MAC 0 Receive Dropped Not Truncated Packets Counter Register(etherStatsDropEventsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_RDRNTPN_RDRNTPn_MASK   (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RDRNTPN_RDRNTPn_SHIFT  (0U)
/*! RDRNTPn - Incremented for each fully dropped packet (not truncated) due to internal errors of
 *    the MAC client. Occurs when a receive FIFO overflows.
 */
#define NETC_ETH_LINK_PM0_RDRNTPN_RDRNTPn(x)     (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RDRNTPN_RDRNTPn_SHIFT)) & NETC_ETH_LINK_PM0_RDRNTPN_RDRNTPn_MASK)
/*! @} */

/*! @name PM0_RMIN63N - Port MAC 0 Receive Valid Small Packet Counter Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_RMIN63N_RMIN63n_MASK   (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_RMIN63N_RMIN63n_SHIFT  (0U)
/*! RMIN63n - Incremented for each valid small packet less than 64B but greater or equal to the
 *    length programmed in PMa_MINFRM register
 */
#define NETC_ETH_LINK_PM0_RMIN63N_RMIN63n(x)     (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_RMIN63N_RMIN63n_SHIFT)) & NETC_ETH_LINK_PM0_RMIN63N_RMIN63n_MASK)
/*! @} */

/*! @name PM0_TEOCTN - Port MAC 0 Transmit Ethernet Octets Counter(etherStatsOctetsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TEOCTN_TEOCTn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TEOCTN_TEOCTn_SHIFT    (0U)
/*! TEOCTn - Incremented for each octet transmitted in both good and bad packets. */
#define NETC_ETH_LINK_PM0_TEOCTN_TEOCTn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TEOCTN_TEOCTn_SHIFT)) & NETC_ETH_LINK_PM0_TEOCTN_TEOCTn_MASK)
/*! @} */

/*! @name PM0_TOCTN - Port MAC 0 Transmit Octets Counter Register(ifOutOctetsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TOCTN_TOCTn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TOCTN_TOCTn_SHIFT      (0U)
#define NETC_ETH_LINK_PM0_TOCTN_TOCTn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TOCTN_TOCTn_SHIFT)) & NETC_ETH_LINK_PM0_TOCTN_TOCTn_MASK)
/*! @} */

/*! @name PM0_TXPFN - Port MAC 0 Transmit Valid Pause Frame Counter Register(aPAUSEMACCtrlFramesReceivedn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TXPFN_TXPFn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TXPFN_TXPFn_SHIFT      (0U)
/*! TXPFn - Incremented for each valid PAUSE frame transmitted . Note: Pause frames forwarded to the
 *    MAC from MAC Client are not counted by TXPFn.
 */
#define NETC_ETH_LINK_PM0_TXPFN_TXPFn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TXPFN_TXPFn_SHIFT)) & NETC_ETH_LINK_PM0_TXPFN_TXPFn_MASK)
/*! @} */

/*! @name PM0_TFRMN - Port MAC 0 Transmit Frame Counter Register(aFramesTransmittedOKn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TFRMN_TFRMn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TFRMN_TFRMn_SHIFT      (0U)
/*! TFRMn - Incremented for each frame transmitted without error, including PAUSE frames. */
#define NETC_ETH_LINK_PM0_TFRMN_TFRMn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TFRMN_TFRMn_SHIFT)) & NETC_ETH_LINK_PM0_TFRMN_TFRMn_MASK)
/*! @} */

/*! @name PM0_TFCSN - Port MAC 0 Transmit Frame Check Sequence Error Counter Register() */
/*! @{ */

#define NETC_ETH_LINK_PM0_TFCSN_TFCSn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TFCSN_TFCSn_SHIFT      (0U)
/*! TFCSn - Incremented for each frame transmitted with a CRC-32 error except for underflows. */
#define NETC_ETH_LINK_PM0_TFCSN_TFCSn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TFCSN_TFCSn_SHIFT)) & NETC_ETH_LINK_PM0_TFCSN_TFCSn_MASK)
/*! @} */

/*! @name PM0_TVLANN - Port MAC 0 Transmit VLAN Frame Counter Register(VLANTransmittedOKn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TVLANN_TVLANn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TVLANN_TVLANn_SHIFT    (0U)
/*! TVLANn - Incremented for each valid VLAN tagged frame transmitted with ethertype 0x8100. */
#define NETC_ETH_LINK_PM0_TVLANN_TVLANn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TVLANN_TVLANn_SHIFT)) & NETC_ETH_LINK_PM0_TVLANN_TVLANn_MASK)
/*! @} */

/*! @name PM0_TERRN - Port MAC 0 Transmit Frame Error Counter Register(ifOutErrorsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TERRN_TERRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TERRN_TERRn_SHIFT      (0U)
/*! TERRn - Transmit frame error count */
#define NETC_ETH_LINK_PM0_TERRN_TERRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TERRN_TERRn_SHIFT)) & NETC_ETH_LINK_PM0_TERRN_TERRn_MASK)
/*! @} */

/*! @name PM0_TUCAN - Port MAC 0 Transmit Unicast Frame Counter Register(ifOutUcastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TUCAN_TUCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TUCAN_TUCAn_SHIFT      (0U)
/*! TUCAn - Incremented for each valid frame transmitted (to the FIFO interface) in which bit 0 of the destination address was 0. */
#define NETC_ETH_LINK_PM0_TUCAN_TUCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TUCAN_TUCAn_SHIFT)) & NETC_ETH_LINK_PM0_TUCAN_TUCAn_MASK)
/*! @} */

/*! @name PM0_TMCAN - Port MAC 0 Transmit Multicast Frame Counter Register(ifOutMulticastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TMCAN_TMCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TMCAN_TMCAn_SHIFT      (0U)
#define NETC_ETH_LINK_PM0_TMCAN_TMCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TMCAN_TMCAn_SHIFT)) & NETC_ETH_LINK_PM0_TMCAN_TMCAn_MASK)
/*! @} */

/*! @name PM0_TBCAN - Port MAC 0 Transmit Broadcast Frame Counter Register(ifOutBroadcastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TBCAN_TBCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TBCAN_TBCAn_SHIFT      (0U)
/*! TBCAn - Incremented for each valid frame transmitted (to the FIFO interface) in which all bits
 *    of the destination address were 1 .
 */
#define NETC_ETH_LINK_PM0_TBCAN_TBCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TBCAN_TBCAn_SHIFT)) & NETC_ETH_LINK_PM0_TBCAN_TBCAn_MASK)
/*! @} */

/*! @name PM0_TPKTN - Port MAC 0 Transmit Packets Counter Register(etherStatsPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TPKTN_TPKTn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TPKTN_TPKTn_SHIFT      (0U)
/*! TPKTn - Incremented for each good or bad packet transmitted. */
#define NETC_ETH_LINK_PM0_TPKTN_TPKTn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TPKTN_TPKTn_SHIFT)) & NETC_ETH_LINK_PM0_TPKTN_TPKTn_MASK)
/*! @} */

/*! @name PM0_TUNDN - Port MAC 0 Transmit Undersized Packet Counter Register(etherStatsUndersizePktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TUNDN_TUNDn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TUNDN_TUNDn_SHIFT      (0U)
/*! TUNDn - Incremented for each packet transmitted that was less than 64 octets long with a good CRC. */
#define NETC_ETH_LINK_PM0_TUNDN_TUNDn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TUNDN_TUNDn_SHIFT)) & NETC_ETH_LINK_PM0_TUNDN_TUNDn_MASK)
/*! @} */

/*! @name PM0_T64N - Port MAC 0 Transmit 64-Octet Packet Counter Register (etherStatsPkts64OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_T64N_T64n_MASK         (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_T64N_T64n_SHIFT        (0U)
/*! T64n - Incremented for each 64-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM0_T64N_T64n(x)           (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_T64N_T64n_SHIFT)) & NETC_ETH_LINK_PM0_T64N_T64n_MASK)
/*! @} */

/*! @name PM0_T127N - Port MAC 0 Transmit 65 to 127-Octet Packet Counter Register (etherStatsPkts65to127OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_T127N_T127n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_T127N_T127n_SHIFT      (0U)
/*! T127n - Incremented for each 65 to 127-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM0_T127N_T127n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_T127N_T127n_SHIFT)) & NETC_ETH_LINK_PM0_T127N_T127n_MASK)
/*! @} */

/*! @name PM0_T255N - Port MAC 0 Transmit 128 to 255-Octet Packet Counter Register (etherStatsPkts128to255OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_T255N_T255n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_T255N_T255n_SHIFT      (0U)
/*! T255n - Incremented for each 128 to 255-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM0_T255N_T255n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_T255N_T255n_SHIFT)) & NETC_ETH_LINK_PM0_T255N_T255n_MASK)
/*! @} */

/*! @name PM0_T511N - Port MAC 0 Transmit 256 to 511-Octet Packet Counter Register (etherStatsPkts256to511OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_T511N_T511n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_T511N_T511n_SHIFT      (0U)
/*! T511n - Incremented for each 256 to 511-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM0_T511N_T511n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_T511N_T511n_SHIFT)) & NETC_ETH_LINK_PM0_T511N_T511n_MASK)
/*! @} */

/*! @name PM0_T1023N - Port MAC 0 Transmit 512 to 1023-Octet Packet Counter Register (etherStatsPkts512to1023OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_T1023N_T1023n_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_T1023N_T1023n_SHIFT    (0U)
/*! T1023n - Incremented for each 512 to 1023-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM0_T1023N_T1023n(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_T1023N_T1023n_SHIFT)) & NETC_ETH_LINK_PM0_T1023N_T1023n_MASK)
/*! @} */

/*! @name PM0_T1522N - Port MAC 0 Transmit 1024 to 1522-Octet Packet Counter Register (etherStatsPkts1024to1522OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_T1522N_T1522n_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_T1522N_T1522n_SHIFT    (0U)
/*! T1522n - Incremented for each 1024- to 1522-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM0_T1522N_T1522n(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_T1522N_T1522n_SHIFT)) & NETC_ETH_LINK_PM0_T1522N_T1522n_MASK)
/*! @} */

/*! @name PM0_T1523XN - Port MAC 0 Transmit 1523 to TX_MTU-Octet Packet Counter Register (etherStatsPkts1523toMaxOctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM0_T1523XN_T1523Xn_MASK   (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_T1523XN_T1523Xn_SHIFT  (0U)
#define NETC_ETH_LINK_PM0_T1523XN_T1523Xn(x)     (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_T1523XN_T1523Xn_SHIFT)) & NETC_ETH_LINK_PM0_T1523XN_T1523Xn_MASK)
/*! @} */

/*! @name PM0_TCNPN - Port MAC 0 Transmit Control Packet Counter Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_TCNPN_TCNPn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TCNPN_TCNPn_SHIFT      (0U)
/*! TCNPn - Incremented for each valid control packet transmitted (type 0x8808) but not for PAUSE packets */
#define NETC_ETH_LINK_PM0_TCNPN_TCNPn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TCNPN_TCNPn_SHIFT)) & NETC_ETH_LINK_PM0_TCNPN_TCNPn_MASK)
/*! @} */

/*! @name PM0_TDFRN - Port MAC 0 Transmit Deferred Packet Counter Register(aFramesWithDeferredXmissions) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TDFRN_TDFRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TDFRN_TDFRn_SHIFT      (0U)
/*! TDFRn - Increments for successful transmissions, without retransmits, that were deferred (half-duplex only). */
#define NETC_ETH_LINK_PM0_TDFRN_TDFRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TDFRN_TDFRn_SHIFT)) & NETC_ETH_LINK_PM0_TDFRN_TDFRn_MASK)
/*! @} */

/*! @name PM0_TMCOLN - Port MAC 0 Transmit Multiple Collisions Counter Register(aMultipleCollisionFrames) */
/*! @{ */

#define NETC_ETH_LINK_PM0_TMCOLN_TMCOLn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TMCOLN_TMCOLn_SHIFT    (0U)
/*! TMCOLn - Increments for successful transmission after more than one retransmission (half-duplex only). */
#define NETC_ETH_LINK_PM0_TMCOLN_TMCOLn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TMCOLN_TMCOLn_SHIFT)) & NETC_ETH_LINK_PM0_TMCOLN_TMCOLn_MASK)
/*! @} */

/*! @name PM0_TSCOLN - Port MAC 0 Transmit Single Collision Counter(aSingleCollisionFrames) Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_TSCOLN_TSCOLn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TSCOLN_TSCOLn_SHIFT    (0U)
/*! TSCOLn - Increments for successful transmission after one retransmission (half-duplex only). */
#define NETC_ETH_LINK_PM0_TSCOLN_TSCOLn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TSCOLN_TSCOLn_SHIFT)) & NETC_ETH_LINK_PM0_TSCOLN_TSCOLn_MASK)
/*! @} */

/*! @name PM0_TLCOLN - Port MAC 0 Transmit Late Collision Counter(aLateCollisions) Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_TLCOLN_TLCOLn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TLCOLN_TLCOLn_SHIFT    (0U)
/*! TLCOLn - Late collision occurred. Frame corrupted / discarded (half-duplex only) */
#define NETC_ETH_LINK_PM0_TLCOLN_TLCOLn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TLCOLN_TLCOLn_SHIFT)) & NETC_ETH_LINK_PM0_TLCOLN_TLCOLn_MASK)
/*! @} */

/*! @name PM0_TECOLN - Port MAC 0 Transmit Excessive Collisions Counter Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_TECOLN_TECOLn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM0_TECOLN_TECOLn_SHIFT    (0U)
/*! TECOLn - Excessive collisions occurred. Frame was discarded (half-duplex only) */
#define NETC_ETH_LINK_PM0_TECOLN_TECOLn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM0_TECOLN_TECOLn_SHIFT)) & NETC_ETH_LINK_PM0_TECOLN_TECOLn_MASK)
/*! @} */

/*! @name PM0_IF_MODE - Port MAC 0 Interface Mode Control Register */
/*! @{ */

#define NETC_ETH_LINK_PM0_IF_MODE_IFMODE_MASK    (0x7U)
#define NETC_ETH_LINK_PM0_IF_MODE_IFMODE_SHIFT   (0U)
/*! IFMODE - Interface mode */
#define NETC_ETH_LINK_PM0_IF_MODE_IFMODE(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IF_MODE_IFMODE_SHIFT)) & NETC_ETH_LINK_PM0_IF_MODE_IFMODE_MASK)

#define NETC_ETH_LINK_PM0_IF_MODE_REVMII_MASK    (0x8U)
#define NETC_ETH_LINK_PM0_IF_MODE_REVMII_SHIFT   (3U)
/*! REVMII - Reverse Mode
 *  0b0..Reverse mode disabled - port is in MAC mode
 *  0b1..Reverse mode enabled - port is in PHY mode
 */
#define NETC_ETH_LINK_PM0_IF_MODE_REVMII(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IF_MODE_REVMII_SHIFT)) & NETC_ETH_LINK_PM0_IF_MODE_REVMII_MASK)

#define NETC_ETH_LINK_PM0_IF_MODE_M10_MASK       (0x10U)
#define NETC_ETH_LINK_PM0_IF_MODE_M10_SHIFT      (4U)
/*! M10
 *  0b0..100 Mbps
 *  0b1..10 Mbps
 */
#define NETC_ETH_LINK_PM0_IF_MODE_M10(x)         (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IF_MODE_M10_SHIFT)) & NETC_ETH_LINK_PM0_IF_MODE_M10_MASK)

#define NETC_ETH_LINK_PM0_IF_MODE_HD_MASK        (0x40U)
#define NETC_ETH_LINK_PM0_IF_MODE_HD_SHIFT       (6U)
/*! HD - Half-duplex
 *  0b0..full duplex
 *  0b1..half duplex
 */
#define NETC_ETH_LINK_PM0_IF_MODE_HD(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IF_MODE_HD_SHIFT)) & NETC_ETH_LINK_PM0_IF_MODE_HD_MASK)

#define NETC_ETH_LINK_PM0_IF_MODE_CLK_STOP_MASK  (0x1000U)
#define NETC_ETH_LINK_PM0_IF_MODE_CLK_STOP_SHIFT (12U)
/*! CLK_STOP - Clock Stop
 *  0b0..Not stoppable
 *  0b1..Stoppable
 */
#define NETC_ETH_LINK_PM0_IF_MODE_CLK_STOP(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IF_MODE_CLK_STOP_SHIFT)) & NETC_ETH_LINK_PM0_IF_MODE_CLK_STOP_MASK)

#define NETC_ETH_LINK_PM0_IF_MODE_SSP_MASK       (0x6000U)
#define NETC_ETH_LINK_PM0_IF_MODE_SSP_SHIFT      (13U)
/*! SSP - Set Speed
 *  0b00..100 Mbps
 *  0b01..10 Mbps
 *  0b10..1 Gbps
 *  0b11..reserved
 */
#define NETC_ETH_LINK_PM0_IF_MODE_SSP(x)         (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM0_IF_MODE_SSP_SHIFT)) & NETC_ETH_LINK_PM0_IF_MODE_SSP_MASK)
/*! @} */

/*! @name PM1_COMMAND_CONFIG - Port MAC 1 Command and Configuration Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_EN_MASK (0x1U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_EN_SHIFT (0U)
/*! TX_EN - MAC transmit path enable */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_EN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_EN_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_EN_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_EN_MASK (0x2U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_EN_SHIFT (1U)
/*! RX_EN - MAC receive path enable */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_EN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_EN_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_EN_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_FWD_MASK (0x80U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_FWD_SHIFT (7U)
/*! PAUSE_FWD - Terminate/forward received PAUSE frames */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_FWD(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_FWD_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_FWD_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_IGN_MASK (0x100U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_IGN_SHIFT (8U)
/*! PAUSE_IGN - Ignore PAUSE frame quanta */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_IGN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_IGN_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_PAUSE_IGN_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_ADDR_INS_MASK (0x200U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_ADDR_INS_SHIFT (9U)
/*! TX_ADDR_INS - Transmit source MAC address insertion */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_ADDR_INS(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_ADDR_INS_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_ADDR_INS_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_LOOP_ENA_MASK (0x400U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_LOOP_ENA_SHIFT (10U)
/*! LOOP_ENA - Loopback enable */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_LOOP_ENA(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_LOOP_ENA_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_LOOP_ENA_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_LPBK_MODE_MASK (0x1800U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_LPBK_MODE_SHIFT (11U)
/*! LPBK_MODE - Loopback mode */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_LPBK_MODE(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_LPBK_MODE_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_LPBK_MODE_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_CNT_FRM_EN_MASK (0x2000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_CNT_FRM_EN_SHIFT (13U)
/*! CNT_FRM_EN - Control frame reception enable */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_CNT_FRM_EN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_CNT_FRM_EN_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_CNT_FRM_EN_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_PNT_MASK (0x4000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_PNT_SHIFT (14U)
/*! TS_PNT - Timestamp Point */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_PNT(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_PNT_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_PNT_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TXP_MASK (0x8000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TXP_SHIFT (15U)
/*! TXP - Enable padding of frames in transmit direction (1, default). */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TXP(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_TXP_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_TXP_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_HD_FCEN_MASK (0x40000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_HD_FCEN_SHIFT (18U)
/*! HD_FCEN - Half Duplex Flow Control Enable */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_HD_FCEN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_HD_FCEN_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_HD_FCEN_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_FLUSH_MASK (0x400000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_FLUSH_SHIFT (22U)
/*! TX_FLUSH - Tx flush */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_FLUSH(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_FLUSH_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_FLUSH_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_LOWP_ENA_MASK (0x800000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_LOWP_ENA_SHIFT (23U)
/*! TX_LOWP_ENA - Transmit Low Power Idle Enable.
 *  0b0..(default), the MAC operates in normal mode.
 *  0b1..The MAC completes the transmission of the current Frame and generates Low Power Idle Sequences to the
 *       line. It is advised to inspect IEVENT[TX_EMPTY] is set before enabling the LPI.
 */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_LOWP_ENA(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_LOWP_ENA_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_TX_LOWP_ENA_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_SWR_MASK (0x4000000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_SWR_SHIFT (26U)
/*! SWR - Software Reset. Self clearing bit. */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_SWR(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_SWR_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_SWR_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_FLUSH_MASK (0x10000000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_FLUSH_SHIFT (28U)
/*! RX_FLUSH - Ingress flush enable */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_FLUSH(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_FLUSH_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_RX_FLUSH_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_MODE_MASK (0x40000000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_MODE_SHIFT (30U)
/*! TS_MODE - Transmit timestamp mode */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_MODE(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_MODE_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_TS_MODE_MASK)

#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_MG_MASK (0x80000000U)
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_MG_SHIFT (31U)
/*! MG - Magic Packet detection enable. */
#define NETC_ETH_LINK_PM1_COMMAND_CONFIG_MG(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_COMMAND_CONFIG_MG_SHIFT)) & NETC_ETH_LINK_PM1_COMMAND_CONFIG_MG_MASK)
/*! @} */

/*! @name PM1_MAC_ADDR_0 - Port MAC 1 MAC Address Register 0 */
/*! @{ */

#define NETC_ETH_LINK_PM1_MAC_ADDR_0_MAC_ADDR_0_MASK (0xFFFFFFFFU)
#define NETC_ETH_LINK_PM1_MAC_ADDR_0_MAC_ADDR_0_SHIFT (0U)
/*! MAC_ADDR_0 - MAC address 0 */
#define NETC_ETH_LINK_PM1_MAC_ADDR_0_MAC_ADDR_0(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_MAC_ADDR_0_MAC_ADDR_0_SHIFT)) & NETC_ETH_LINK_PM1_MAC_ADDR_0_MAC_ADDR_0_MASK)
/*! @} */

/*! @name PM1_MAC_ADDR_1 - Port MAC 1 MAC Address Register 1 */
/*! @{ */

#define NETC_ETH_LINK_PM1_MAC_ADDR_1_MAC_ADDR_1_MASK (0xFFFFU)
#define NETC_ETH_LINK_PM1_MAC_ADDR_1_MAC_ADDR_1_SHIFT (0U)
/*! MAC_ADDR_1 - MAC address 1 */
#define NETC_ETH_LINK_PM1_MAC_ADDR_1_MAC_ADDR_1(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_MAC_ADDR_1_MAC_ADDR_1_SHIFT)) & NETC_ETH_LINK_PM1_MAC_ADDR_1_MAC_ADDR_1_MASK)
/*! @} */

/*! @name PM1_MAXFRM - Port MAC 1 Maximum Frame Length Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_MAXFRM_MAXFRM_MASK     (0xFFFFU)
#define NETC_ETH_LINK_PM1_MAXFRM_MAXFRM_SHIFT    (0U)
/*! MAXFRM - Maximum supported received frame length. */
#define NETC_ETH_LINK_PM1_MAXFRM_MAXFRM(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_MAXFRM_MAXFRM_SHIFT)) & NETC_ETH_LINK_PM1_MAXFRM_MAXFRM_MASK)

#define NETC_ETH_LINK_PM1_MAXFRM_TX_MTU_MASK     (0xFFFF0000U)
#define NETC_ETH_LINK_PM1_MAXFRM_TX_MTU_SHIFT    (16U)
/*! TX_MTU - Maximum transmit frame length */
#define NETC_ETH_LINK_PM1_MAXFRM_TX_MTU(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_MAXFRM_TX_MTU_SHIFT)) & NETC_ETH_LINK_PM1_MAXFRM_TX_MTU_MASK)
/*! @} */

/*! @name PM1_MINFRM - Port MAC 1 Minimum Frame Length Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_MINFRM_NUM_BYTES_MASK  (0x7FU)
#define NETC_ETH_LINK_PM1_MINFRM_NUM_BYTES_SHIFT (0U)
/*! NUM_BYTES - Receive Minimum Frame Length size in bytes. */
#define NETC_ETH_LINK_PM1_MINFRM_NUM_BYTES(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_MINFRM_NUM_BYTES_SHIFT)) & NETC_ETH_LINK_PM1_MINFRM_NUM_BYTES_MASK)
/*! @} */

/*! @name PM1_IEVENT - Port MAC 1 Interrupt Event Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_IEVENT_TX_EMPTY_MASK   (0x20U)
#define NETC_ETH_LINK_PM1_IEVENT_TX_EMPTY_SHIFT  (5U)
/*! TX_EMPTY - Transmit fifo empty event */
#define NETC_ETH_LINK_PM1_IEVENT_TX_EMPTY(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_TX_EMPTY_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_TX_EMPTY_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_RX_EMPTY_MASK   (0x40U)
#define NETC_ETH_LINK_PM1_IEVENT_RX_EMPTY_SHIFT  (6U)
/*! RX_EMPTY - Receive idle event */
#define NETC_ETH_LINK_PM1_IEVENT_RX_EMPTY(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_RX_EMPTY_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_RX_EMPTY_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_TX_OVFL_MASK    (0x400U)
#define NETC_ETH_LINK_PM1_IEVENT_TX_OVFL_SHIFT   (10U)
/*! TX_OVFL - Transmit FIFO overflow event. */
#define NETC_ETH_LINK_PM1_IEVENT_TX_OVFL(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_TX_OVFL_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_TX_OVFL_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_TX_UNFL_MASK    (0x800U)
#define NETC_ETH_LINK_PM1_IEVENT_TX_UNFL_SHIFT   (11U)
/*! TX_UNFL - Transmit FIFO underflow event. */
#define NETC_ETH_LINK_PM1_IEVENT_TX_UNFL(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_TX_UNFL_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_TX_UNFL_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_RX_OVFL_MASK    (0x1000U)
#define NETC_ETH_LINK_PM1_IEVENT_RX_OVFL_SHIFT   (12U)
/*! RX_OVFL - Receive FIFO overflow event. */
#define NETC_ETH_LINK_PM1_IEVENT_RX_OVFL(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_RX_OVFL_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_RX_OVFL_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_MGI_MASK        (0x4000U)
#define NETC_ETH_LINK_PM1_IEVENT_MGI_SHIFT       (14U)
/*! MGI - Magic packet detection indication event */
#define NETC_ETH_LINK_PM1_IEVENT_MGI(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_MGI_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_MGI_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_TX_CSD_MASK     (0x200000U)
#define NETC_ETH_LINK_PM1_IEVENT_TX_CSD_SHIFT    (21U)
/*! TX_CSD - Tx Clock Stop Detection */
#define NETC_ETH_LINK_PM1_IEVENT_TX_CSD(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_TX_CSD_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_TX_CSD_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_RX_CSD_MASK     (0x400000U)
#define NETC_ETH_LINK_PM1_IEVENT_RX_CSD_SHIFT    (22U)
/*! RX_CSD - Rx Clock Stop Detection */
#define NETC_ETH_LINK_PM1_IEVENT_RX_CSD(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_RX_CSD_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_RX_CSD_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_SPD_DUP_MASK    (0x800000U)
#define NETC_ETH_LINK_PM1_IEVENT_SPD_DUP_SHIFT   (23U)
/*! SPD_DUP - Speed/Duplex Change */
#define NETC_ETH_LINK_PM1_IEVENT_SPD_DUP(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_SPD_DUP_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_SPD_DUP_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_MRG_SERR_MASK   (0x8000000U)
#define NETC_ETH_LINK_PM1_IEVENT_MRG_SERR_SHIFT  (27U)
/*! MRG_SERR - MAC merge frame SMD error received event */
#define NETC_ETH_LINK_PM1_IEVENT_MRG_SERR(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_MRG_SERR_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_MRG_SERR_MASK)

#define NETC_ETH_LINK_PM1_IEVENT_MRG_AERR_MASK   (0x10000000U)
#define NETC_ETH_LINK_PM1_IEVENT_MRG_AERR_SHIFT  (28U)
/*! MRG_AERR - MAC merge frame assembly error event */
#define NETC_ETH_LINK_PM1_IEVENT_MRG_AERR(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IEVENT_MRG_AERR_SHIFT)) & NETC_ETH_LINK_PM1_IEVENT_MRG_AERR_MASK)
/*! @} */

/*! @name PM1_TX_IPG_PREAMBLE - Port MAC 1 Transmit Inter-Packet Gap Length and Flexible Preamble length Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_IPG_LEN_MASK (0x7FU)
#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_IPG_LEN_SHIFT (0U)
/*! IPG_LEN - Transmit inter-packet gap value. */
#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_IPG_LEN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_IPG_LEN_SHIFT)) & NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_IPG_LEN_MASK)

#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT_MASK (0x700U)
#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT_SHIFT (8U)
/*! FLEX_PREAMBLE_CNT - Flexible Preamble Count */
#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT_SHIFT)) & NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_CNT_MASK)

#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN_MASK (0x80000000U)
#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN_SHIFT (31U)
/*! FLEX_PREAMBLE_EN - Enable Flexible Preamble Count */
#define NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN_SHIFT)) & NETC_ETH_LINK_PM1_TX_IPG_PREAMBLE_FLEX_PREAMBLE_EN_MASK)
/*! @} */

/*! @name PM1_IMASK - Port MAC 1 Interrupt Mask Register(INT_MASK) */
/*! @{ */

#define NETC_ETH_LINK_PM1_IMASK_MGI_MASK         (0x4000U)
#define NETC_ETH_LINK_PM1_IMASK_MGI_SHIFT        (14U)
/*! MGI - Magic packet detection indication event mask. */
#define NETC_ETH_LINK_PM1_IMASK_MGI(x)           (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IMASK_MGI_SHIFT)) & NETC_ETH_LINK_PM1_IMASK_MGI_MASK)

#define NETC_ETH_LINK_PM1_IMASK_TX_CSD_MASK      (0x200000U)
#define NETC_ETH_LINK_PM1_IMASK_TX_CSD_SHIFT     (21U)
/*! TX_CSD - Tx Clock Stop Detection */
#define NETC_ETH_LINK_PM1_IMASK_TX_CSD(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IMASK_TX_CSD_SHIFT)) & NETC_ETH_LINK_PM1_IMASK_TX_CSD_MASK)

#define NETC_ETH_LINK_PM1_IMASK_RX_CSD_MASK      (0x400000U)
#define NETC_ETH_LINK_PM1_IMASK_RX_CSD_SHIFT     (22U)
/*! RX_CSD - Rx Clock Stop Detection */
#define NETC_ETH_LINK_PM1_IMASK_RX_CSD(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IMASK_RX_CSD_SHIFT)) & NETC_ETH_LINK_PM1_IMASK_RX_CSD_MASK)

#define NETC_ETH_LINK_PM1_IMASK_SPD_DUP_MASK     (0x800000U)
#define NETC_ETH_LINK_PM1_IMASK_SPD_DUP_SHIFT    (23U)
/*! SPD_DUP - Speed/Duplex change event mask. */
#define NETC_ETH_LINK_PM1_IMASK_SPD_DUP(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IMASK_SPD_DUP_SHIFT)) & NETC_ETH_LINK_PM1_IMASK_SPD_DUP_MASK)

#define NETC_ETH_LINK_PM1_IMASK_MRG_SERR_MASK    (0x8000000U)
#define NETC_ETH_LINK_PM1_IMASK_MRG_SERR_SHIFT   (27U)
/*! MRG_SERR - MAC merge frame SMD error received event interrupt mask */
#define NETC_ETH_LINK_PM1_IMASK_MRG_SERR(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IMASK_MRG_SERR_SHIFT)) & NETC_ETH_LINK_PM1_IMASK_MRG_SERR_MASK)

#define NETC_ETH_LINK_PM1_IMASK_MRG_AERR_MASK    (0x10000000U)
#define NETC_ETH_LINK_PM1_IMASK_MRG_AERR_SHIFT   (28U)
/*! MRG_AERR - MAC merge frame assembly error event interrupt mask */
#define NETC_ETH_LINK_PM1_IMASK_MRG_AERR(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IMASK_MRG_AERR_SHIFT)) & NETC_ETH_LINK_PM1_IMASK_MRG_AERR_MASK)
/*! @} */

/*! @name PM1_PAUSE_QUANTA - Port MAC 1 Pause Quanta Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_PAUSE_QUANTA_PQNT_MASK (0xFFFFU)
#define NETC_ETH_LINK_PM1_PAUSE_QUANTA_PQNT_SHIFT (0U)
/*! PQNT - Value to be used for the quanta value when XOFF is triggered. */
#define NETC_ETH_LINK_PM1_PAUSE_QUANTA_PQNT(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_PAUSE_QUANTA_PQNT_SHIFT)) & NETC_ETH_LINK_PM1_PAUSE_QUANTA_PQNT_MASK)
/*! @} */

/*! @name PM1_PAUSE_THRESH - Port MAC 1 Pause Quanta Threshold Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_PAUSE_THRESH_QTH_MASK  (0xFFFFU)
#define NETC_ETH_LINK_PM1_PAUSE_THRESH_QTH_SHIFT (0U)
/*! QTH - Quanta threshold. */
#define NETC_ETH_LINK_PM1_PAUSE_THRESH_QTH(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_PAUSE_THRESH_QTH_SHIFT)) & NETC_ETH_LINK_PM1_PAUSE_THRESH_QTH_MASK)
/*! @} */

/*! @name PM1_RX_PAUSE_STATUS - Port MAC 1 Receive Pause Status Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_RX_PAUSE_STATUS_PSTAT_MASK (0x1U)
#define NETC_ETH_LINK_PM1_RX_PAUSE_STATUS_PSTAT_SHIFT (0U)
/*! PSTAT - Pause status. */
#define NETC_ETH_LINK_PM1_RX_PAUSE_STATUS_PSTAT(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_RX_PAUSE_STATUS_PSTAT_SHIFT)) & NETC_ETH_LINK_PM1_RX_PAUSE_STATUS_PSTAT_MASK)
/*! @} */

/*! @name PM1_LPWAKE_TIMER - Port MAC 1 EEE Low Power Wakeup Timer Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_LPWAKE_TIMER_TW_SYS_TX_MASK (0xFFFFFFU)
#define NETC_ETH_LINK_PM1_LPWAKE_TIMER_TW_SYS_TX_SHIFT (0U)
/*! TW_SYS_TX - EEE System transmit wait time */
#define NETC_ETH_LINK_PM1_LPWAKE_TIMER_TW_SYS_TX(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_LPWAKE_TIMER_TW_SYS_TX_SHIFT)) & NETC_ETH_LINK_PM1_LPWAKE_TIMER_TW_SYS_TX_MASK)
/*! @} */

/*! @name PM1_SLEEP_TIMER - Port MAC 1 Transmit EEE Low Power Timer Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_SLEEP_TIMER_SLEEPT_MASK (0xFFFFFFU)
#define NETC_ETH_LINK_PM1_SLEEP_TIMER_SLEEPT_SHIFT (0U)
#define NETC_ETH_LINK_PM1_SLEEP_TIMER_SLEEPT(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_SLEEP_TIMER_SLEEPT_SHIFT)) & NETC_ETH_LINK_PM1_SLEEP_TIMER_SLEEPT_MASK)
/*! @} */

/*! @name PM1_SINGLE_STEP - Port MAC 1 IEEE1588 Single-Step Control Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_SINGLE_STEP_CH_MASK    (0x40U)
#define NETC_ETH_LINK_PM1_SINGLE_STEP_CH_SHIFT   (6U)
/*! CH - Checksum update */
#define NETC_ETH_LINK_PM1_SINGLE_STEP_CH(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_SINGLE_STEP_CH_SHIFT)) & NETC_ETH_LINK_PM1_SINGLE_STEP_CH_MASK)

#define NETC_ETH_LINK_PM1_SINGLE_STEP_OFFSET_MASK (0xFF80U)
#define NETC_ETH_LINK_PM1_SINGLE_STEP_OFFSET_SHIFT (7U)
#define NETC_ETH_LINK_PM1_SINGLE_STEP_OFFSET(x)  (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_SINGLE_STEP_OFFSET_SHIFT)) & NETC_ETH_LINK_PM1_SINGLE_STEP_OFFSET_MASK)

#define NETC_ETH_LINK_PM1_SINGLE_STEP_EN_MASK    (0x80000000U)
#define NETC_ETH_LINK_PM1_SINGLE_STEP_EN_SHIFT   (31U)
/*! EN - IEEE-1588 Single-Step enable. */
#define NETC_ETH_LINK_PM1_SINGLE_STEP_EN(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_SINGLE_STEP_EN_SHIFT)) & NETC_ETH_LINK_PM1_SINGLE_STEP_EN_MASK)
/*! @} */

/*! @name PM1_HD_BACKOFF_ENTROPY - Port MAC 1 half-duplex backoff entropy register */
/*! @{ */

#define NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY_MASK (0x3FFU)
#define NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY_SHIFT (0U)
/*! HD_BACKOFF_ENTROPY - Half duplex backoff entropy */
#define NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY_SHIFT)) & NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_HD_BACKOFF_ENTROPY_MASK)

#define NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID_MASK (0x80000000U)
#define NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID_SHIFT (31U)
/*! SW_ENTROPY_VALID - SW programmable entropy valid */
#define NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID_SHIFT)) & NETC_ETH_LINK_PM1_HD_BACKOFF_ENTROPY_SW_ENTROPY_VALID_MASK)
/*! @} */

/*! @name PM1_HD_FLOW_CTRL - Port MAC 1 Half-Duplex Flow Control Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_OFF_MIN_MASK (0xFFFU)
#define NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_OFF_MIN_SHIFT (0U)
/*! HD_BP_OFF_MIN - Half-Duplex Back-Pressure Off Minimum */
#define NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_OFF_MIN(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_OFF_MIN_SHIFT)) & NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_OFF_MIN_MASK)

#define NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_ON_MAX_MASK (0xFFF0000U)
#define NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_ON_MAX_SHIFT (16U)
/*! HD_BP_ON_MAX - Half-Duplex Back-Pressure On Maximum */
#define NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_ON_MAX(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_ON_MAX_SHIFT)) & NETC_ETH_LINK_PM1_HD_FLOW_CTRL_HD_BP_ON_MAX_MASK)
/*! @} */

/*! @name PM1_STATN_CONFIG - Port MAC 1 Statistics Configuration Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_STATN_CONFIG_SAT_MASK  (0x1U)
#define NETC_ETH_LINK_PM1_STATN_CONFIG_SAT_SHIFT (0U)
#define NETC_ETH_LINK_PM1_STATN_CONFIG_SAT(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_STATN_CONFIG_SAT_SHIFT)) & NETC_ETH_LINK_PM1_STATN_CONFIG_SAT_MASK)

#define NETC_ETH_LINK_PM1_STATN_CONFIG_COD_MASK  (0x2U)
#define NETC_ETH_LINK_PM1_STATN_CONFIG_COD_SHIFT (1U)
#define NETC_ETH_LINK_PM1_STATN_CONFIG_COD(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_STATN_CONFIG_COD_SHIFT)) & NETC_ETH_LINK_PM1_STATN_CONFIG_COD_MASK)

#define NETC_ETH_LINK_PM1_STATN_CONFIG_CLR_MASK  (0x4U)
#define NETC_ETH_LINK_PM1_STATN_CONFIG_CLR_SHIFT (2U)
#define NETC_ETH_LINK_PM1_STATN_CONFIG_CLR(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_STATN_CONFIG_CLR_SHIFT)) & NETC_ETH_LINK_PM1_STATN_CONFIG_CLR_MASK)

#define NETC_ETH_LINK_PM1_STATN_CONFIG_WEN_MASK  (0x8U)
#define NETC_ETH_LINK_PM1_STATN_CONFIG_WEN_SHIFT (3U)
/*! WEN - Write enable for Tx/Rx stats registers */
#define NETC_ETH_LINK_PM1_STATN_CONFIG_WEN(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_STATN_CONFIG_WEN_SHIFT)) & NETC_ETH_LINK_PM1_STATN_CONFIG_WEN_MASK)
/*! @} */

/*! @name PM1_REOCTN - Port MAC 1 Receive Ethernet Octets Counter(etherStatsOctetsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_REOCTN_REOCTn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_REOCTN_REOCTn_SHIFT    (0U)
/*! REOCTn - Incremented for each octet received in both good and bad packets. */
#define NETC_ETH_LINK_PM1_REOCTN_REOCTn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_REOCTN_REOCTn_SHIFT)) & NETC_ETH_LINK_PM1_REOCTN_REOCTn_MASK)
/*! @} */

/*! @name PM1_ROCTN - Port MAC 1 Receive Octets Counter(iflnOctetsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_ROCTN_ROCTn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_ROCTN_ROCTn_SHIFT      (0U)
/*! ROCTn - Incremented for each octet received except preamble (that is, Header, Payload, Pad and
 *    FCS) for all valid frames and valid PAUSE frames received.
 */
#define NETC_ETH_LINK_PM1_ROCTN_ROCTn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_ROCTN_ROCTn_SHIFT)) & NETC_ETH_LINK_PM1_ROCTN_ROCTn_MASK)
/*! @} */

/*! @name PM1_RXPFN - Port MAC 1 Receive Valid Pause Frame Counter Register(aPAUSEMACCtrlFramesReceivedn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RXPFN_RXPFn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RXPFN_RXPFn_SHIFT      (0U)
/*! RXPFn - Incremented for each valid PAUSE frame received . */
#define NETC_ETH_LINK_PM1_RXPFN_RXPFn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RXPFN_RXPFn_SHIFT)) & NETC_ETH_LINK_PM1_RXPFN_RXPFn_MASK)
/*! @} */

/*! @name PM1_RFRMN - Port MAC 1 Receive Frame Counter Register(aFramesReceivedOKn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RFRMN_RFRMn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RFRMN_RFRMn_SHIFT      (0U)
/*! RFRMn - Incremented for each frame received without error, including PAUSE frames. */
#define NETC_ETH_LINK_PM1_RFRMN_RFRMn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RFRMN_RFRMn_SHIFT)) & NETC_ETH_LINK_PM1_RFRMN_RFRMn_MASK)
/*! @} */

/*! @name PM1_RFCSN - Port MAC 1 Receive Frame Check Sequence Error Counter Register() */
/*! @{ */

#define NETC_ETH_LINK_PM1_RFCSN_RFCSn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RFCSN_RFCSn_SHIFT      (0U)
/*! RFCSn - Incremented for each frame received with a CRC-32 error but the frame is otherwise of correct length. */
#define NETC_ETH_LINK_PM1_RFCSN_RFCSn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RFCSN_RFCSn_SHIFT)) & NETC_ETH_LINK_PM1_RFCSN_RFCSn_MASK)
/*! @} */

/*! @name PM1_RVLANN - Port MAC 1 Receive VLAN Frame Counter Register(VLANReceivedOKn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RVLANN_RVLANn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RVLANN_RVLANn_SHIFT    (0U)
/*! RVLANn - Incremented for each valid VLAN tagged frame received with ethertype 0x8100 */
#define NETC_ETH_LINK_PM1_RVLANN_RVLANn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RVLANN_RVLANn_SHIFT)) & NETC_ETH_LINK_PM1_RVLANN_RVLANn_MASK)
/*! @} */

/*! @name PM1_RERRN - Port MAC 1 Receive Frame Error Counter Register(ifInErrorsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RERRN_RERRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RERRN_RERRn_SHIFT      (0U)
/*! RERRn - Incremented for each frame received with an error (except for undersized/fragment frame): */
#define NETC_ETH_LINK_PM1_RERRN_RERRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RERRN_RERRn_SHIFT)) & NETC_ETH_LINK_PM1_RERRN_RERRn_MASK)
/*! @} */

/*! @name PM1_RUCAN - Port MAC 1 Receive Unicast Frame Counter Register(ifInUcastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RUCAN_RUCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RUCAN_RUCAn_SHIFT      (0U)
/*! RUCAn - Incremented for each valid frame received (on the receive FIFO interface) in which bit 0
 *    of the destination address was 0 .
 */
#define NETC_ETH_LINK_PM1_RUCAN_RUCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RUCAN_RUCAn_SHIFT)) & NETC_ETH_LINK_PM1_RUCAN_RUCAn_MASK)
/*! @} */

/*! @name PM1_RMCAN - Port MAC 1 Receive Multicast Frame Counter Register(ifInMulticastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RMCAN_RMCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RMCAN_RMCAn_SHIFT      (0U)
#define NETC_ETH_LINK_PM1_RMCAN_RMCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RMCAN_RMCAn_SHIFT)) & NETC_ETH_LINK_PM1_RMCAN_RMCAn_MASK)
/*! @} */

/*! @name PM1_RBCAN - Port MAC 1 Receive Broadcast Frame Counter Register(ifInBroadcastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RBCAN_RBCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RBCAN_RBCAn_SHIFT      (0U)
/*! RBCAn - Incremented for each valid frame received (on the receive FIFO interface) in which all
 *    bits of the destination address were 1 .
 */
#define NETC_ETH_LINK_PM1_RBCAN_RBCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RBCAN_RBCAn_SHIFT)) & NETC_ETH_LINK_PM1_RBCAN_RBCAn_MASK)
/*! @} */

/*! @name PM1_RDRPN - Port MAC 1 Receive Dropped Packets Counter Register(etherStatsDropEventsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RDRPN_RDRPn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RDRPN_RDRPn_SHIFT      (0U)
#define NETC_ETH_LINK_PM1_RDRPN_RDRPn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RDRPN_RDRPn_SHIFT)) & NETC_ETH_LINK_PM1_RDRPN_RDRPn_MASK)
/*! @} */

/*! @name PM1_RPKTN - Port MAC 1 Receive Packets Counter Register(etherStatsPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RPKTN_RPKTn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RPKTN_RPKTn_SHIFT      (0U)
/*! RPKTn - Incremented for each good or bad packet received. */
#define NETC_ETH_LINK_PM1_RPKTN_RPKTn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RPKTN_RPKTn_SHIFT)) & NETC_ETH_LINK_PM1_RPKTN_RPKTn_MASK)
/*! @} */

/*! @name PM1_RUNDN - Port MAC 1 Receive Undersized Packet Counter Register(etherStatsUndersizePktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RUNDN_RUNDn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RUNDN_RUNDn_SHIFT      (0U)
#define NETC_ETH_LINK_PM1_RUNDN_RUNDn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RUNDN_RUNDn_SHIFT)) & NETC_ETH_LINK_PM1_RUNDN_RUNDn_MASK)
/*! @} */

/*! @name PM1_R64N - Port MAC 1 Receive 64-Octet Packet Counter Register(etherStatsPkts64OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_R64N_R64n_MASK         (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_R64N_R64n_SHIFT        (0U)
/*! R64n - Incremented for each 64-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM1_R64N_R64n(x)           (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_R64N_R64n_SHIFT)) & NETC_ETH_LINK_PM1_R64N_R64n_MASK)
/*! @} */

/*! @name PM1_R127N - Port MAC 1 Receive 65 to 127-Octet Packet Counter Register(etherStatsPkts65to127OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_R127N_R127n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_R127N_R127n_SHIFT      (0U)
/*! R127n - Incremented for each 65- to 127-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM1_R127N_R127n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_R127N_R127n_SHIFT)) & NETC_ETH_LINK_PM1_R127N_R127n_MASK)
/*! @} */

/*! @name PM1_R255N - Port MAC 1 Receive 128 to 255-Octet Packet Counter Register(etherStatsPkts128to255OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_R255N_R255n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_R255N_R255n_SHIFT      (0U)
/*! R255n - Incremented for each 128- to 255-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM1_R255N_R255n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_R255N_R255n_SHIFT)) & NETC_ETH_LINK_PM1_R255N_R255n_MASK)
/*! @} */

/*! @name PM1_R511N - Port MAC 1 Receive 256 to 511-Octet Packet Counter Register(etherStatsPkts256to511OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_R511N_R511n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_R511N_R511n_SHIFT      (0U)
/*! R511n - Incremented for each 256- to 511-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM1_R511N_R511n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_R511N_R511n_SHIFT)) & NETC_ETH_LINK_PM1_R511N_R511n_MASK)
/*! @} */

/*! @name PM1_R1023N - Port MAC 1 Receive 512 to 1023-Octet Packet Counter Register(etherStatsPkts512to1023OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_R1023N_R1023n_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_R1023N_R1023n_SHIFT    (0U)
/*! R1023n - Incremented for each 512- to 1023-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM1_R1023N_R1023n(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_R1023N_R1023n_SHIFT)) & NETC_ETH_LINK_PM1_R1023N_R1023n_MASK)
/*! @} */

/*! @name PM1_R1522N - Port MAC 1 Receive 1024 to 1522-Octet Packet Counter Register(etherStatsPkts1024to1522OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_R1522N_R1522n_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_R1522N_R1522n_SHIFT    (0U)
/*! R1522n - Incremented for each 1024- to 1522-octet frame received, good or bad. */
#define NETC_ETH_LINK_PM1_R1522N_R1522n(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_R1522N_R1522n_SHIFT)) & NETC_ETH_LINK_PM1_R1522N_R1522n_MASK)
/*! @} */

/*! @name PM1_R1523XN - Port MAC 1 Receive 1523 to Max-Octet Packet Counter Register(etherStatsPkts1523toMaxOctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_R1523XN_R1523Xn_MASK   (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_R1523XN_R1523Xn_SHIFT  (0U)
#define NETC_ETH_LINK_PM1_R1523XN_R1523Xn(x)     (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_R1523XN_R1523Xn_SHIFT)) & NETC_ETH_LINK_PM1_R1523XN_R1523Xn_MASK)
/*! @} */

/*! @name PM1_ROVRN - Port MAC 1 Receive Oversized Packet Counter Register(etherStatsOversizePktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_ROVRN_ROVRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_ROVRN_ROVRn_SHIFT      (0U)
#define NETC_ETH_LINK_PM1_ROVRN_ROVRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_ROVRN_ROVRn_SHIFT)) & NETC_ETH_LINK_PM1_ROVRN_ROVRn_MASK)
/*! @} */

/*! @name PM1_RJBRN - Port MAC 1 Receive Jabber Packet Counter Register(etherStatsJabbersn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RJBRN_RJBRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RJBRN_RJBRn_SHIFT      (0U)
#define NETC_ETH_LINK_PM1_RJBRN_RJBRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RJBRN_RJBRn_SHIFT)) & NETC_ETH_LINK_PM1_RJBRN_RJBRn_MASK)
/*! @} */

/*! @name PM1_RFRGN - Port MAC 1 Receive Fragment Packet Counter Register(etherStatsFragmentsn */
/*! @{ */

#define NETC_ETH_LINK_PM1_RFRGN_RFRGn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RFRGN_RFRGn_SHIFT      (0U)
#define NETC_ETH_LINK_PM1_RFRGN_RFRGn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RFRGN_RFRGn_SHIFT)) & NETC_ETH_LINK_PM1_RFRGN_RFRGn_MASK)
/*! @} */

/*! @name PM1_RCNPN - Port MAC 1 Receive Control Packet Counter Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_RCNPN_RCNPn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RCNPN_RCNPn_SHIFT      (0U)
/*! RCNPn - Incremented for each valid control packet (type 0x8808) but not for PAUSE packets */
#define NETC_ETH_LINK_PM1_RCNPN_RCNPn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RCNPN_RCNPn_SHIFT)) & NETC_ETH_LINK_PM1_RCNPN_RCNPn_MASK)
/*! @} */

/*! @name PM1_RDRNTPN - Port MAC 1 Receive Dropped Not Truncated Packets Counter Register(etherStatsDropEventsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_RDRNTPN_RDRNTPn_MASK   (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RDRNTPN_RDRNTPn_SHIFT  (0U)
/*! RDRNTPn - Incremented for each fully dropped packet (not truncated) due to internal errors of
 *    the MAC client. Occurs when a receive FIFO overflows.
 */
#define NETC_ETH_LINK_PM1_RDRNTPN_RDRNTPn(x)     (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RDRNTPN_RDRNTPn_SHIFT)) & NETC_ETH_LINK_PM1_RDRNTPN_RDRNTPn_MASK)
/*! @} */

/*! @name PM1_RMIN63N - Port MAC 1 Receive Valid Small Packet Counter Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_RMIN63N_RMIN63n_MASK   (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_RMIN63N_RMIN63n_SHIFT  (0U)
/*! RMIN63n - Incremented for each valid small packet less than 64B but greater or equal to the
 *    length programmed in PMa_MINFRM register
 */
#define NETC_ETH_LINK_PM1_RMIN63N_RMIN63n(x)     (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_RMIN63N_RMIN63n_SHIFT)) & NETC_ETH_LINK_PM1_RMIN63N_RMIN63n_MASK)
/*! @} */

/*! @name PM1_TEOCTN - Port MAC 1 Transmit Ethernet Octets Counter(etherStatsOctetsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TEOCTN_TEOCTn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TEOCTN_TEOCTn_SHIFT    (0U)
/*! TEOCTn - Incremented for each octet transmitted in both good and bad packets. */
#define NETC_ETH_LINK_PM1_TEOCTN_TEOCTn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TEOCTN_TEOCTn_SHIFT)) & NETC_ETH_LINK_PM1_TEOCTN_TEOCTn_MASK)
/*! @} */

/*! @name PM1_TOCTN - Port MAC 1 Transmit Octets Counter Register(ifOutOctetsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TOCTN_TOCTn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TOCTN_TOCTn_SHIFT      (0U)
#define NETC_ETH_LINK_PM1_TOCTN_TOCTn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TOCTN_TOCTn_SHIFT)) & NETC_ETH_LINK_PM1_TOCTN_TOCTn_MASK)
/*! @} */

/*! @name PM1_TXPFN - Port MAC 1 Transmit Valid Pause Frame Counter Register(aPAUSEMACCtrlFramesReceivedn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TXPFN_TXPFn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TXPFN_TXPFn_SHIFT      (0U)
/*! TXPFn - Incremented for each valid PAUSE frame transmitted . Note: Pause frames forwarded to the
 *    MAC from MAC Client are not counted by TXPFn.
 */
#define NETC_ETH_LINK_PM1_TXPFN_TXPFn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TXPFN_TXPFn_SHIFT)) & NETC_ETH_LINK_PM1_TXPFN_TXPFn_MASK)
/*! @} */

/*! @name PM1_TFRMN - Port MAC 1 Transmit Frame Counter Register(aFramesTransmittedOKn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TFRMN_TFRMn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TFRMN_TFRMn_SHIFT      (0U)
/*! TFRMn - Incremented for each frame transmitted without error, including PAUSE frames. */
#define NETC_ETH_LINK_PM1_TFRMN_TFRMn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TFRMN_TFRMn_SHIFT)) & NETC_ETH_LINK_PM1_TFRMN_TFRMn_MASK)
/*! @} */

/*! @name PM1_TFCSN - Port MAC 1 Transmit Frame Check Sequence Error Counter Register() */
/*! @{ */

#define NETC_ETH_LINK_PM1_TFCSN_TFCSn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TFCSN_TFCSn_SHIFT      (0U)
/*! TFCSn - Incremented for each frame transmitted with a CRC-32 error except for underflows. */
#define NETC_ETH_LINK_PM1_TFCSN_TFCSn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TFCSN_TFCSn_SHIFT)) & NETC_ETH_LINK_PM1_TFCSN_TFCSn_MASK)
/*! @} */

/*! @name PM1_TVLANN - Port MAC 1 Transmit VLAN Frame Counter Register(VLANTransmittedOKn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TVLANN_TVLANn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TVLANN_TVLANn_SHIFT    (0U)
/*! TVLANn - Incremented for each valid VLAN tagged frame transmitted with ethertype 0x8100. */
#define NETC_ETH_LINK_PM1_TVLANN_TVLANn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TVLANN_TVLANn_SHIFT)) & NETC_ETH_LINK_PM1_TVLANN_TVLANn_MASK)
/*! @} */

/*! @name PM1_TERRN - Port MAC 1 Transmit Frame Error Counter Register(ifOutErrorsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TERRN_TERRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TERRN_TERRn_SHIFT      (0U)
/*! TERRn - Transmit frame error count */
#define NETC_ETH_LINK_PM1_TERRN_TERRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TERRN_TERRn_SHIFT)) & NETC_ETH_LINK_PM1_TERRN_TERRn_MASK)
/*! @} */

/*! @name PM1_TUCAN - Port MAC 1 Transmit Unicast Frame Counter Register(ifOutUcastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TUCAN_TUCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TUCAN_TUCAn_SHIFT      (0U)
/*! TUCAn - Incremented for each valid frame transmitted (to the FIFO interface) in which bit 0 of the destination address was 0. */
#define NETC_ETH_LINK_PM1_TUCAN_TUCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TUCAN_TUCAn_SHIFT)) & NETC_ETH_LINK_PM1_TUCAN_TUCAn_MASK)
/*! @} */

/*! @name PM1_TMCAN - Port MAC 1 Transmit Multicast Frame Counter Register(ifOutMulticastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TMCAN_TMCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TMCAN_TMCAn_SHIFT      (0U)
#define NETC_ETH_LINK_PM1_TMCAN_TMCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TMCAN_TMCAn_SHIFT)) & NETC_ETH_LINK_PM1_TMCAN_TMCAn_MASK)
/*! @} */

/*! @name PM1_TBCAN - Port MAC 1 Transmit Broadcast Frame Counter Register(ifOutBroadcastPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TBCAN_TBCAn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TBCAN_TBCAn_SHIFT      (0U)
/*! TBCAn - Incremented for each valid frame transmitted (to the FIFO interface) in which all bits
 *    of the destination address were 1 .
 */
#define NETC_ETH_LINK_PM1_TBCAN_TBCAn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TBCAN_TBCAn_SHIFT)) & NETC_ETH_LINK_PM1_TBCAN_TBCAn_MASK)
/*! @} */

/*! @name PM1_TPKTN - Port MAC 1 Transmit Packets Counter Register(etherStatsPktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TPKTN_TPKTn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TPKTN_TPKTn_SHIFT      (0U)
/*! TPKTn - Incremented for each good or bad packet transmitted. */
#define NETC_ETH_LINK_PM1_TPKTN_TPKTn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TPKTN_TPKTn_SHIFT)) & NETC_ETH_LINK_PM1_TPKTN_TPKTn_MASK)
/*! @} */

/*! @name PM1_TUNDN - Port MAC 1 Transmit Undersized Packet Counter Register(etherStatsUndersizePktsn) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TUNDN_TUNDn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TUNDN_TUNDn_SHIFT      (0U)
/*! TUNDn - Incremented for each packet transmitted that was less than 64 octets long with a good CRC. */
#define NETC_ETH_LINK_PM1_TUNDN_TUNDn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TUNDN_TUNDn_SHIFT)) & NETC_ETH_LINK_PM1_TUNDN_TUNDn_MASK)
/*! @} */

/*! @name PM1_T64N - Port MAC 1 Transmit 64-Octet Packet Counter Register (etherStatsPkts64OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_T64N_T64n_MASK         (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_T64N_T64n_SHIFT        (0U)
/*! T64n - Incremented for each 64-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM1_T64N_T64n(x)           (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_T64N_T64n_SHIFT)) & NETC_ETH_LINK_PM1_T64N_T64n_MASK)
/*! @} */

/*! @name PM1_T127N - Port MAC 1 Transmit 65 to 127-Octet Packet Counter Register (etherStatsPkts65to127OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_T127N_T127n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_T127N_T127n_SHIFT      (0U)
/*! T127n - Incremented for each 65 to 127-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM1_T127N_T127n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_T127N_T127n_SHIFT)) & NETC_ETH_LINK_PM1_T127N_T127n_MASK)
/*! @} */

/*! @name PM1_T255N - Port MAC 1 Transmit 128 to 255-Octet Packet Counter Register (etherStatsPkts128to255OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_T255N_T255n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_T255N_T255n_SHIFT      (0U)
/*! T255n - Incremented for each 128 to 255-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM1_T255N_T255n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_T255N_T255n_SHIFT)) & NETC_ETH_LINK_PM1_T255N_T255n_MASK)
/*! @} */

/*! @name PM1_T511N - Port MAC 1 Transmit 256 to 511-Octet Packet Counter Register (etherStatsPkts256to511OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_T511N_T511n_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_T511N_T511n_SHIFT      (0U)
/*! T511n - Incremented for each 256 to 511-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM1_T511N_T511n(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_T511N_T511n_SHIFT)) & NETC_ETH_LINK_PM1_T511N_T511n_MASK)
/*! @} */

/*! @name PM1_T1023N - Port MAC 1 Transmit 512 to 1023-Octet Packet Counter Register (etherStatsPkts512to1023OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_T1023N_T1023n_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_T1023N_T1023n_SHIFT    (0U)
/*! T1023n - Incremented for each 512 to 1023-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM1_T1023N_T1023n(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_T1023N_T1023n_SHIFT)) & NETC_ETH_LINK_PM1_T1023N_T1023n_MASK)
/*! @} */

/*! @name PM1_T1522N - Port MAC 1 Transmit 1024 to 1522-Octet Packet Counter Register (etherStatsPkts1024to1522OctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_T1522N_T1522n_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_T1522N_T1522n_SHIFT    (0U)
/*! T1522n - Incremented for each 1024- to 1522-octet frame transmitted, good or bad. */
#define NETC_ETH_LINK_PM1_T1522N_T1522n(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_T1522N_T1522n_SHIFT)) & NETC_ETH_LINK_PM1_T1522N_T1522n_MASK)
/*! @} */

/*! @name PM1_T1523XN - Port MAC 1 Transmit 1523 to TX_MTU-Octet Packet Counter Register (etherStatsPkts1523toMaxOctetsN) */
/*! @{ */

#define NETC_ETH_LINK_PM1_T1523XN_T1523Xn_MASK   (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_T1523XN_T1523Xn_SHIFT  (0U)
#define NETC_ETH_LINK_PM1_T1523XN_T1523Xn(x)     (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_T1523XN_T1523Xn_SHIFT)) & NETC_ETH_LINK_PM1_T1523XN_T1523Xn_MASK)
/*! @} */

/*! @name PM1_TCNPN - Port MAC 1 Transmit Control Packet Counter Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_TCNPN_TCNPn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TCNPN_TCNPn_SHIFT      (0U)
/*! TCNPn - Incremented for each valid control packet transmitted (type 0x8808) but not for PAUSE packets */
#define NETC_ETH_LINK_PM1_TCNPN_TCNPn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TCNPN_TCNPn_SHIFT)) & NETC_ETH_LINK_PM1_TCNPN_TCNPn_MASK)
/*! @} */

/*! @name PM1_TDFRN - Port MAC 1 Transmit Deferred Packet Counter Register(aFramesWithDeferredXmissions) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TDFRN_TDFRn_MASK       (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TDFRN_TDFRn_SHIFT      (0U)
/*! TDFRn - Increments for successful transmissions, without retransmits, that were deferred (half-duplex only). */
#define NETC_ETH_LINK_PM1_TDFRN_TDFRn(x)         (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TDFRN_TDFRn_SHIFT)) & NETC_ETH_LINK_PM1_TDFRN_TDFRn_MASK)
/*! @} */

/*! @name PM1_TMCOLN - Port MAC 1 Transmit Multiple Collisions Counter Register(aMultipleCollisionFrames) */
/*! @{ */

#define NETC_ETH_LINK_PM1_TMCOLN_TMCOLn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TMCOLN_TMCOLn_SHIFT    (0U)
/*! TMCOLn - Increments for successful transmission after more than one retransmission (half-duplex only). */
#define NETC_ETH_LINK_PM1_TMCOLN_TMCOLn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TMCOLN_TMCOLn_SHIFT)) & NETC_ETH_LINK_PM1_TMCOLN_TMCOLn_MASK)
/*! @} */

/*! @name PM1_TSCOLN - Port MAC 1 Transmit Single Collision Counter(aSingleCollisionFrames) Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_TSCOLN_TSCOLn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TSCOLN_TSCOLn_SHIFT    (0U)
/*! TSCOLn - Increments for successful transmission after one retransmission (half-duplex only). */
#define NETC_ETH_LINK_PM1_TSCOLN_TSCOLn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TSCOLN_TSCOLn_SHIFT)) & NETC_ETH_LINK_PM1_TSCOLN_TSCOLn_MASK)
/*! @} */

/*! @name PM1_TLCOLN - Port MAC 1 Transmit Late Collision Counter(aLateCollisions) Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_TLCOLN_TLCOLn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TLCOLN_TLCOLn_SHIFT    (0U)
/*! TLCOLn - Late collision occurred. Frame corrupted / discarded (half-duplex only) */
#define NETC_ETH_LINK_PM1_TLCOLN_TLCOLn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TLCOLN_TLCOLn_SHIFT)) & NETC_ETH_LINK_PM1_TLCOLN_TLCOLn_MASK)
/*! @} */

/*! @name PM1_TECOLN - Port MAC 1 Transmit Excessive Collisions Counter Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_TECOLN_TECOLn_MASK     (0xFFFFFFFFFFFFFFFFU)
#define NETC_ETH_LINK_PM1_TECOLN_TECOLn_SHIFT    (0U)
/*! TECOLn - Excessive collisions occurred. Frame was discarded (half-duplex only) */
#define NETC_ETH_LINK_PM1_TECOLN_TECOLn(x)       (((uint64_t)(((uint64_t)(x)) << NETC_ETH_LINK_PM1_TECOLN_TECOLn_SHIFT)) & NETC_ETH_LINK_PM1_TECOLN_TECOLn_MASK)
/*! @} */

/*! @name PM1_IF_MODE - Port MAC 1 Interface Mode Control Register */
/*! @{ */

#define NETC_ETH_LINK_PM1_IF_MODE_IFMODE_MASK    (0x7U)
#define NETC_ETH_LINK_PM1_IF_MODE_IFMODE_SHIFT   (0U)
/*! IFMODE - Interface mode */
#define NETC_ETH_LINK_PM1_IF_MODE_IFMODE(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IF_MODE_IFMODE_SHIFT)) & NETC_ETH_LINK_PM1_IF_MODE_IFMODE_MASK)

#define NETC_ETH_LINK_PM1_IF_MODE_REVMII_MASK    (0x8U)
#define NETC_ETH_LINK_PM1_IF_MODE_REVMII_SHIFT   (3U)
/*! REVMII - Reverse Mode
 *  0b0..Reverse mode disabled - port is in MAC mode
 *  0b1..Reverse mode enabled - port is in PHY mode
 */
#define NETC_ETH_LINK_PM1_IF_MODE_REVMII(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IF_MODE_REVMII_SHIFT)) & NETC_ETH_LINK_PM1_IF_MODE_REVMII_MASK)

#define NETC_ETH_LINK_PM1_IF_MODE_M10_MASK       (0x10U)
#define NETC_ETH_LINK_PM1_IF_MODE_M10_SHIFT      (4U)
/*! M10
 *  0b0..100 Mbps
 *  0b1..10 Mbps
 */
#define NETC_ETH_LINK_PM1_IF_MODE_M10(x)         (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IF_MODE_M10_SHIFT)) & NETC_ETH_LINK_PM1_IF_MODE_M10_MASK)

#define NETC_ETH_LINK_PM1_IF_MODE_HD_MASK        (0x40U)
#define NETC_ETH_LINK_PM1_IF_MODE_HD_SHIFT       (6U)
/*! HD - Half-duplex
 *  0b0..full duplex
 *  0b1..half duplex
 */
#define NETC_ETH_LINK_PM1_IF_MODE_HD(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IF_MODE_HD_SHIFT)) & NETC_ETH_LINK_PM1_IF_MODE_HD_MASK)

#define NETC_ETH_LINK_PM1_IF_MODE_CLK_STOP_MASK  (0x1000U)
#define NETC_ETH_LINK_PM1_IF_MODE_CLK_STOP_SHIFT (12U)
/*! CLK_STOP - Clock Stop
 *  0b0..Not stoppable
 *  0b1..Stoppable
 */
#define NETC_ETH_LINK_PM1_IF_MODE_CLK_STOP(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IF_MODE_CLK_STOP_SHIFT)) & NETC_ETH_LINK_PM1_IF_MODE_CLK_STOP_MASK)

#define NETC_ETH_LINK_PM1_IF_MODE_SSP_MASK       (0x6000U)
#define NETC_ETH_LINK_PM1_IF_MODE_SSP_SHIFT      (13U)
/*! SSP - Set Speed
 *  0b00..100 Mbps
 *  0b01..10 Mbps
 *  0b10..1 Gbps
 *  0b11..reserved
 */
#define NETC_ETH_LINK_PM1_IF_MODE_SSP(x)         (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PM1_IF_MODE_SSP_SHIFT)) & NETC_ETH_LINK_PM1_IF_MODE_SSP_MASK)
/*! @} */

/*! @name MAC_MERGE_MMCSR - Port MAC Merge Control and Status Register */
/*! @{ */

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPS_MASK   (0x1U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPS_SHIFT  (0U)
/*! LPS - Local preemption supported */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPS(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_LPS_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_LPS_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPE_MASK   (0x2U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPE_SHIFT  (1U)
/*! LPE - Local preemption enabled */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPE(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_LPE_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_LPE_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPA_MASK   (0x4U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPA_SHIFT  (2U)
/*! LPA - Local preemption active */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LPA(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_LPA_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_LPA_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LAFS_MASK  (0x18U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LAFS_SHIFT (3U)
/*! LAFS - Local additional fragment size */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LAFS(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_LAFS_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_LAFS_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPS_MASK   (0x20U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPS_SHIFT  (5U)
/*! RPS - Remote preemption supported */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPS(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_RPS_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_RPS_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPE_MASK   (0x40U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPE_SHIFT  (6U)
/*! RPE - Remote preemption enabled */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPE(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_RPE_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_RPE_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPA_MASK   (0x80U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPA_SHIFT  (7U)
/*! RPA - Remote preemption active */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RPA(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_RPA_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_RPA_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RAFS_MASK  (0x300U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RAFS_SHIFT (8U)
/*! RAFS - Remote additional fragment size */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_RAFS(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_RAFS_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_RAFS_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_ME_MASK    (0x18000U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_ME_SHIFT   (15U)
/*! ME - Merge enabled */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_ME(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_ME_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_ME_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VDIS_MASK  (0x20000U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VDIS_SHIFT (17U)
/*! VDIS - Verify disabled */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VDIS(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_VDIS_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_VDIS_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VSTS_MASK  (0x1C0000U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VSTS_SHIFT (18U)
/*! VSTS - Verify status */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VSTS(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_VSTS_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_VSTS_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_TXSTS_MASK (0x600000U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_TXSTS_SHIFT (21U)
/*! TXSTS - Merge status */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_TXSTS(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_TXSTS_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_TXSTS_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VT_MASK    (0x3F800000U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VT_SHIFT   (23U)
/*! VT - Verify Time */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_VT(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_VT_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_VT_MASK)

#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LINK_FAIL_MASK (0x80000000U)
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LINK_FAIL_SHIFT (31U)
/*! LINK_FAIL - Link Fail */
#define NETC_ETH_LINK_MAC_MERGE_MMCSR_LINK_FAIL(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMCSR_LINK_FAIL_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMCSR_LINK_FAIL_MASK)
/*! @} */

/*! @name MAC_MERGE_MMFAECR - Port MAC Merge Frame Assembly Error Count Register */
/*! @{ */

#define NETC_ETH_LINK_MAC_MERGE_MMFAECR_MMFAEC_MASK (0xFFFFFFFFU)
#define NETC_ETH_LINK_MAC_MERGE_MMFAECR_MMFAEC_SHIFT (0U)
#define NETC_ETH_LINK_MAC_MERGE_MMFAECR_MMFAEC(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMFAECR_MMFAEC_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMFAECR_MMFAEC_MASK)
/*! @} */

/*! @name MAC_MERGE_MMFSECR - Port MAC Merge Frame SMD Error Count Register */
/*! @{ */

#define NETC_ETH_LINK_MAC_MERGE_MMFSECR_MMFSEC_MASK (0xFFFFFFFFU)
#define NETC_ETH_LINK_MAC_MERGE_MMFSECR_MMFSEC_SHIFT (0U)
#define NETC_ETH_LINK_MAC_MERGE_MMFSECR_MMFSEC(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMFSECR_MMFSEC_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMFSECR_MMFSEC_MASK)
/*! @} */

/*! @name MAC_MERGE_MMFAOCR - Port MAC Merge Frame Assembly OK Count Register */
/*! @{ */

#define NETC_ETH_LINK_MAC_MERGE_MMFAOCR_MMFAOC_MASK (0xFFFFFFFFU)
#define NETC_ETH_LINK_MAC_MERGE_MMFAOCR_MMFAOC_SHIFT (0U)
#define NETC_ETH_LINK_MAC_MERGE_MMFAOCR_MMFAOC(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMFAOCR_MMFAOC_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMFAOCR_MMFAOC_MASK)
/*! @} */

/*! @name MAC_MERGE_MMFCRXR - Port MAC Merge Fragment Count RX Register */
/*! @{ */

#define NETC_ETH_LINK_MAC_MERGE_MMFCRXR_MMFCRX_MASK (0xFFFFFFFFU)
#define NETC_ETH_LINK_MAC_MERGE_MMFCRXR_MMFCRX_SHIFT (0U)
#define NETC_ETH_LINK_MAC_MERGE_MMFCRXR_MMFCRX(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMFCRXR_MMFCRX_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMFCRXR_MMFCRX_MASK)
/*! @} */

/*! @name MAC_MERGE_MMFCTXR - Port MAC Merge Fragment Count TX Register */
/*! @{ */

#define NETC_ETH_LINK_MAC_MERGE_MMFCTXR_MMFCTX_MASK (0xFFFFFFFFU)
#define NETC_ETH_LINK_MAC_MERGE_MMFCTXR_MMFCTX_SHIFT (0U)
#define NETC_ETH_LINK_MAC_MERGE_MMFCTXR_MMFCTX(x) (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMFCTXR_MMFCTX_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMFCTXR_MMFCTX_MASK)
/*! @} */

/*! @name MAC_MERGE_MMHCR - Port MAC Merge Hold Count Register */
/*! @{ */

#define NETC_ETH_LINK_MAC_MERGE_MMHCR_MMHC_MASK  (0xFFFFFFFFU)
#define NETC_ETH_LINK_MAC_MERGE_MMHCR_MMHC_SHIFT (0U)
#define NETC_ETH_LINK_MAC_MERGE_MMHCR_MMHC(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_MAC_MERGE_MMHCR_MMHC_SHIFT)) & NETC_ETH_LINK_MAC_MERGE_MMHCR_MMHC_MASK)
/*! @} */

/*! @name PEMDIOCR - Port external MDIO configuration register */
/*! @{ */

#define NETC_ETH_LINK_PEMDIOCR_BSY2_MASK         (0x1U)
#define NETC_ETH_LINK_PEMDIOCR_BSY2_SHIFT        (0U)
/*! BSY2 - Busy 2 (same as bit 31)
 *  0b0..An MDIO transaction is not occurring; software may access other MDIO registers.
 *  0b1..An MDIO transaction is occurring.
 */
#define NETC_ETH_LINK_PEMDIOCR_BSY2(x)           (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_BSY2_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_BSY2_MASK)

#define NETC_ETH_LINK_PEMDIOCR_MDIO_RD_ER_MASK   (0x2U)
#define NETC_ETH_LINK_PEMDIOCR_MDIO_RD_ER_SHIFT  (1U)
/*! MDIO_RD_ER
 *  0b0..No error on last MDIO transaction (read or write).
 *  0b1..An error was detected on the last MDIO transaction (read or write). Errors on internal MDIO accesses can
 *       be triggered by an access to an invalid device, or by a write to a shared on-die PHY device that has not
 *       been locked.
 */
#define NETC_ETH_LINK_PEMDIOCR_MDIO_RD_ER(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_MDIO_RD_ER_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_MDIO_RD_ER_MASK)

#define NETC_ETH_LINK_PEMDIOCR_MDIO_HOLD_MASK    (0x1CU)
#define NETC_ETH_LINK_PEMDIOCR_MDIO_HOLD_SHIFT   (2U)
/*! MDIO_HOLD - MDIO Hold Time
 *  0b000..1 NETC cycle
 *  0b001..3 NETC cycles
 *  0b010..5 NETC cycles (default - recommended value)
 *  0b011..7 NETC cycles
 *  0b100..9 NETC cycles
 *  0b101..11 NETC cycles
 *  0b110..13 NETC cycles
 *  0b111..15 NETC cycles
 */
#define NETC_ETH_LINK_PEMDIOCR_MDIO_HOLD(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_MDIO_HOLD_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_MDIO_HOLD_MASK)

#define NETC_ETH_LINK_PEMDIOCR_PRE_DIS_MASK      (0x20U)
#define NETC_ETH_LINK_PEMDIOCR_PRE_DIS_SHIFT     (5U)
/*! PRE_DIS - MDIO Preamble Disable
 *  0b0..Generation of MDIO preamble is enabled (default operation).
 *  0b1..Generation of MDIO preamble is disabled.
 */
#define NETC_ETH_LINK_PEMDIOCR_PRE_DIS(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_PRE_DIS_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_PRE_DIS_MASK)

#define NETC_ETH_LINK_PEMDIOCR_ENC45_MASK        (0x40U)
#define NETC_ETH_LINK_PEMDIOCR_ENC45_SHIFT       (6U)
/*! ENC45 - Enable Clause 45 Support
 *  0b0..Clause 22 transactions are used.
 *  0b1..Clause 45 transactions are used.
 */
#define NETC_ETH_LINK_PEMDIOCR_ENC45(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_ENC45_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_ENC45_MASK)

#define NETC_ETH_LINK_PEMDIOCR_MDIO_CLK_DIV_MASK (0xFF80U)
#define NETC_ETH_LINK_PEMDIOCR_MDIO_CLK_DIV_SHIFT (7U)
/*! MDIO_CLK_DIV - MDIO Clock Divisor */
#define NETC_ETH_LINK_PEMDIOCR_MDIO_CLK_DIV(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_MDIO_CLK_DIV_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_MDIO_CLK_DIV_MASK)

#define NETC_ETH_LINK_PEMDIOCR_WHOAMI_MASK       (0x70000U)
#define NETC_ETH_LINK_PEMDIOCR_WHOAMI_SHIFT      (16U)
/*! WHOAMI - Returns the link ID */
#define NETC_ETH_LINK_PEMDIOCR_WHOAMI(x)         (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_WHOAMI_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_WHOAMI_MASK)

#define NETC_ETH_LINK_PEMDIOCR_EHOLD_MASK        (0x400000U)
#define NETC_ETH_LINK_PEMDIOCR_EHOLD_SHIFT       (22U)
/*! EHOLD - Extended HOLD
 *  0b0..Normal operation, MDIO hold time is as specified in PEMDIOCR[MDIO_HOLD].
 *  0b1..Extended operation
 */
#define NETC_ETH_LINK_PEMDIOCR_EHOLD(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_EHOLD_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_EHOLD_MASK)

#define NETC_ETH_LINK_PEMDIOCR_NEG_MASK          (0x800000U)
#define NETC_ETH_LINK_PEMDIOCR_NEG_SHIFT         (23U)
/*! NEG
 *  0b0..normal operation - positive edge
 *  0b1..MDIO is driven by master on MDC negative edge (default for external MDIOs)
 */
#define NETC_ETH_LINK_PEMDIOCR_NEG(x)            (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_NEG_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_NEG_MASK)

#define NETC_ETH_LINK_PEMDIOCR_ADDR_ERR_MASK     (0x10000000U)
#define NETC_ETH_LINK_PEMDIOCR_ADDR_ERR_SHIFT    (28U)
/*! ADDR_ERR - Address Error
 *  0b0..Normal
 *  0b1..Error. An access control violation has occurred. The request address used does not match the MDIO PHY's
 *       address (clause 22) or MDIO port address (clause 45) assigned.
 */
#define NETC_ETH_LINK_PEMDIOCR_ADDR_ERR(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_ADDR_ERR_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_ADDR_ERR_MASK)

#define NETC_ETH_LINK_PEMDIOCR_CIM_MASK          (0x20000000U)
#define NETC_ETH_LINK_PEMDIOCR_CIM_SHIFT         (29U)
/*! CIM
 *  0b0..Masked
 *  0b1..Enabled
 */
#define NETC_ETH_LINK_PEMDIOCR_CIM(x)            (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_CIM_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_CIM_MASK)

#define NETC_ETH_LINK_PEMDIOCR_CMP_MASK          (0x40000000U)
#define NETC_ETH_LINK_PEMDIOCR_CMP_SHIFT         (30U)
/*! CMP - MDIO Command Completion
 *  0b0..An MDIO command completion did not occur.
 *  0b1..An MDIO command completion occurred.
 */
#define NETC_ETH_LINK_PEMDIOCR_CMP(x)            (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_CMP_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_CMP_MASK)

#define NETC_ETH_LINK_PEMDIOCR_BSY1_MASK         (0x80000000U)
#define NETC_ETH_LINK_PEMDIOCR_BSY1_SHIFT        (31U)
/*! BSY1 - Busy 1
 *  0b0..An MDIO transaction is not occurring; software may access other MDIO registers.
 *  0b1..An MDIO transaction is occurring.
 */
#define NETC_ETH_LINK_PEMDIOCR_BSY1(x)           (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOCR_BSY1_SHIFT)) & NETC_ETH_LINK_PEMDIOCR_BSY1_MASK)
/*! @} */

/*! @name PEMDIOICR - Port external MDIO interface control register */
/*! @{ */

#define NETC_ETH_LINK_PEMDIOICR_DEV_ADDR_MASK    (0x1FU)
#define NETC_ETH_LINK_PEMDIOICR_DEV_ADDR_SHIFT   (0U)
/*! DEV_ADDR - 5-bit MDIO device address (Clause 45) / register address (Clause 22) */
#define NETC_ETH_LINK_PEMDIOICR_DEV_ADDR(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOICR_DEV_ADDR_SHIFT)) & NETC_ETH_LINK_PEMDIOICR_DEV_ADDR_MASK)

#define NETC_ETH_LINK_PEMDIOICR_PORT_ADDR_MASK   (0x3E0U)
#define NETC_ETH_LINK_PEMDIOICR_PORT_ADDR_SHIFT  (5U)
/*! PORT_ADDR - 5-bit MDIO port address (Clause 45) / PHY address (Clause 22) */
#define NETC_ETH_LINK_PEMDIOICR_PORT_ADDR(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOICR_PORT_ADDR_SHIFT)) & NETC_ETH_LINK_PEMDIOICR_PORT_ADDR_MASK)

#define NETC_ETH_LINK_PEMDIOICR_POST_INC_MASK    (0x4000U)
#define NETC_ETH_LINK_PEMDIOICR_POST_INC_SHIFT   (14U)
/*! POST_INC - MDIO read with address post-increment initiation. Self-clearing once transaction is complete. */
#define NETC_ETH_LINK_PEMDIOICR_POST_INC(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOICR_POST_INC_SHIFT)) & NETC_ETH_LINK_PEMDIOICR_POST_INC_MASK)

#define NETC_ETH_LINK_PEMDIOICR_READ_MASK        (0x8000U)
#define NETC_ETH_LINK_PEMDIOICR_READ_SHIFT       (15U)
/*! READ - MDIO read initiation. */
#define NETC_ETH_LINK_PEMDIOICR_READ(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOICR_READ_SHIFT)) & NETC_ETH_LINK_PEMDIOICR_READ_MASK)

#define NETC_ETH_LINK_PEMDIOICR_BSY_MASK         (0x80000000U)
#define NETC_ETH_LINK_PEMDIOICR_BSY_SHIFT        (31U)
/*! BSY - MDIO busy */
#define NETC_ETH_LINK_PEMDIOICR_BSY(x)           (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOICR_BSY_SHIFT)) & NETC_ETH_LINK_PEMDIOICR_BSY_MASK)
/*! @} */

/*! @name PEMDIOIDR - Port external MDIO interface data register */
/*! @{ */

#define NETC_ETH_LINK_PEMDIOIDR_MDIO_DATA_MASK   (0xFFFFU)
#define NETC_ETH_LINK_PEMDIOIDR_MDIO_DATA_SHIFT  (0U)
/*! MDIO_DATA - 16-bit MDIO data. */
#define NETC_ETH_LINK_PEMDIOIDR_MDIO_DATA(x)     (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOIDR_MDIO_DATA_SHIFT)) & NETC_ETH_LINK_PEMDIOIDR_MDIO_DATA_MASK)
/*! @} */

/*! @name PEMDIORAR - Port external MDIO register address register */
/*! @{ */

#define NETC_ETH_LINK_PEMDIORAR_REGADDR_MASK     (0xFFFFU)
#define NETC_ETH_LINK_PEMDIORAR_REGADDR_SHIFT    (0U)
/*! REGADDR - MDIO PHY register address. */
#define NETC_ETH_LINK_PEMDIORAR_REGADDR(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIORAR_REGADDR_SHIFT)) & NETC_ETH_LINK_PEMDIORAR_REGADDR_MASK)
/*! @} */

/*! @name PEMDIOSR - Port external MDIO status register */
/*! @{ */

#define NETC_ETH_LINK_PEMDIOSR_BSY_MASK          (0x1U)
#define NETC_ETH_LINK_PEMDIOSR_BSY_SHIFT         (0U)
/*! BSY - Global MDIO busy */
#define NETC_ETH_LINK_PEMDIOSR_BSY(x)            (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOSR_BSY_SHIFT)) & NETC_ETH_LINK_PEMDIOSR_BSY_MASK)

#define NETC_ETH_LINK_PEMDIOSR_WHT_LIST_MASK     (0x1F00U)
#define NETC_ETH_LINK_PEMDIOSR_WHT_LIST_SHIFT    (8U)
/*! WHT_LIST - PHY white list */
#define NETC_ETH_LINK_PEMDIOSR_WHT_LIST(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOSR_WHT_LIST_SHIFT)) & NETC_ETH_LINK_PEMDIOSR_WHT_LIST_MASK)

#define NETC_ETH_LINK_PEMDIOSR_WHT_LIST_ENA_MASK (0x8000U)
#define NETC_ETH_LINK_PEMDIOSR_WHT_LIST_ENA_SHIFT (15U)
/*! WHT_LIST_ENA - PHY white list enable */
#define NETC_ETH_LINK_PEMDIOSR_WHT_LIST_ENA(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOSR_WHT_LIST_ENA_SHIFT)) & NETC_ETH_LINK_PEMDIOSR_WHT_LIST_ENA_MASK)

#define NETC_ETH_LINK_PEMDIOSR_PORT_ID_MASK      (0x70000U)
#define NETC_ETH_LINK_PEMDIOSR_PORT_ID_SHIFT     (16U)
/*! PORT_ID - Port ID */
#define NETC_ETH_LINK_PEMDIOSR_PORT_ID(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOSR_PORT_ID_SHIFT)) & NETC_ETH_LINK_PEMDIOSR_PORT_ID_MASK)

#define NETC_ETH_LINK_PEMDIOSR_REQ_TYPE_MASK     (0x80000U)
#define NETC_ETH_LINK_PEMDIOSR_REQ_TYPE_SHIFT    (19U)
/*! REQ_TYPE - Port ID */
#define NETC_ETH_LINK_PEMDIOSR_REQ_TYPE(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PEMDIOSR_REQ_TYPE_SHIFT)) & NETC_ETH_LINK_PEMDIOSR_REQ_TYPE_MASK)
/*! @} */

/*! @name PPSCR - PHY status configuration register */
/*! @{ */

#define NETC_ETH_LINK_PPSCR_BSY_MASK             (0x1U)
#define NETC_ETH_LINK_PPSCR_BSY_SHIFT            (0U)
/*! BSY - MDIO busy */
#define NETC_ETH_LINK_PPSCR_BSY(x)               (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSCR_BSY_SHIFT)) & NETC_ETH_LINK_PPSCR_BSY_MASK)

#define NETC_ETH_LINK_PPSCR_MDIO_RD_ER_MASK      (0x2U)
#define NETC_ETH_LINK_PPSCR_MDIO_RD_ER_SHIFT     (1U)
/*! MDIO_RD_ER - MDIO read error */
#define NETC_ETH_LINK_PPSCR_MDIO_RD_ER(x)        (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSCR_MDIO_RD_ER_SHIFT)) & NETC_ETH_LINK_PPSCR_MDIO_RD_ER_MASK)

#define NETC_ETH_LINK_PPSCR_STATUS_INTERVAL_MASK (0xFFFF0000U)
#define NETC_ETH_LINK_PPSCR_STATUS_INTERVAL_SHIFT (16U)
/*! STATUS_INTERVAL - PHY status read interval */
#define NETC_ETH_LINK_PPSCR_STATUS_INTERVAL(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSCR_STATUS_INTERVAL_SHIFT)) & NETC_ETH_LINK_PPSCR_STATUS_INTERVAL_MASK)
/*! @} */

/*! @name PPSCTRLR - Port PHY status control register */
/*! @{ */

#define NETC_ETH_LINK_PPSCTRLR_DEV_ADDR_MASK     (0x1FU)
#define NETC_ETH_LINK_PPSCTRLR_DEV_ADDR_SHIFT    (0U)
/*! DEV_ADDR - 5-bit MDIO device address (Clause 45) / register address (Clause 22) */
#define NETC_ETH_LINK_PPSCTRLR_DEV_ADDR(x)       (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSCTRLR_DEV_ADDR_SHIFT)) & NETC_ETH_LINK_PPSCTRLR_DEV_ADDR_MASK)

#define NETC_ETH_LINK_PPSCTRLR_PORT_ADDR_MASK    (0x3E0U)
#define NETC_ETH_LINK_PPSCTRLR_PORT_ADDR_SHIFT   (5U)
/*! PORT_ADDR - 5-bit MDIO port address (Clause 45) / PHY address (Clause 22) */
#define NETC_ETH_LINK_PPSCTRLR_PORT_ADDR(x)      (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSCTRLR_PORT_ADDR_SHIFT)) & NETC_ETH_LINK_PPSCTRLR_PORT_ADDR_MASK)
/*! @} */

/*! @name PPSDR - Port PHY status data register */
/*! @{ */

#define NETC_ETH_LINK_PPSDR_MDIO_DATA_MASK       (0xFFFFU)
#define NETC_ETH_LINK_PPSDR_MDIO_DATA_SHIFT      (0U)
/*! MDIO_DATA - 16-bit MDIO data */
#define NETC_ETH_LINK_PPSDR_MDIO_DATA(x)         (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSDR_MDIO_DATA_SHIFT)) & NETC_ETH_LINK_PPSDR_MDIO_DATA_MASK)

#define NETC_ETH_LINK_PPSDR_CURR_CNT_MASK        (0xFFFF0000U)
#define NETC_ETH_LINK_PPSDR_CURR_CNT_SHIFT       (16U)
/*! CURR_CNT - Current count */
#define NETC_ETH_LINK_PPSDR_CURR_CNT(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSDR_CURR_CNT_SHIFT)) & NETC_ETH_LINK_PPSDR_CURR_CNT_MASK)
/*! @} */

/*! @name PPSRAR - Port PHY status register address register */
/*! @{ */

#define NETC_ETH_LINK_PPSRAR_REGADDR_MASK        (0xFFFFU)
#define NETC_ETH_LINK_PPSRAR_REGADDR_SHIFT       (0U)
/*! REGADDR - MDIO PHY register address. Address of the register within the Clause 45 PHY device from which data is to be read. */
#define NETC_ETH_LINK_PPSRAR_REGADDR(x)          (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSRAR_REGADDR_SHIFT)) & NETC_ETH_LINK_PPSRAR_REGADDR_MASK)
/*! @} */

/*! @name PPSER - Port PHY status event register */
/*! @{ */

#define NETC_ETH_LINK_PPSER_STATUS_EVENT_HL_MASK (0xFFFFU)
#define NETC_ETH_LINK_PPSER_STATUS_EVENT_HL_SHIFT (0U)
/*! STATUS_EVENT_HL - Status event high-to-low. Set to 1 if a 1->0 transition on a corresponding data bit has occurred. Write 1 to clear. */
#define NETC_ETH_LINK_PPSER_STATUS_EVENT_HL(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSER_STATUS_EVENT_HL_SHIFT)) & NETC_ETH_LINK_PPSER_STATUS_EVENT_HL_MASK)

#define NETC_ETH_LINK_PPSER_STATUS_EVENT_LH_MASK (0xFFFF0000U)
#define NETC_ETH_LINK_PPSER_STATUS_EVENT_LH_SHIFT (16U)
/*! STATUS_EVENT_LH - Status event low-to-high. Set to 1 if a 0->1 transition on a corresponding data bit has occurred. Write 1 to clear. */
#define NETC_ETH_LINK_PPSER_STATUS_EVENT_LH(x)   (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSER_STATUS_EVENT_LH_SHIFT)) & NETC_ETH_LINK_PPSER_STATUS_EVENT_LH_MASK)
/*! @} */

/*! @name PPSMR - Port PHY status mask register */
/*! @{ */

#define NETC_ETH_LINK_PPSMR_STATUS_MASK_HL_MASK  (0xFFFFU)
#define NETC_ETH_LINK_PPSMR_STATUS_MASK_HL_SHIFT (0U)
/*! STATUS_MASK_HL - Status high-to-low mask. If set to 1, assert an interrupt if the corresponding event bit is set. */
#define NETC_ETH_LINK_PPSMR_STATUS_MASK_HL(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSMR_STATUS_MASK_HL_SHIFT)) & NETC_ETH_LINK_PPSMR_STATUS_MASK_HL_MASK)

#define NETC_ETH_LINK_PPSMR_STATUS_MASK_LH_MASK  (0xFFFF0000U)
#define NETC_ETH_LINK_PPSMR_STATUS_MASK_LH_SHIFT (16U)
/*! STATUS_MASK_LH - Status mask low-to-high. If set to 1, assert an interrupt if the corresponding event bit is set. */
#define NETC_ETH_LINK_PPSMR_STATUS_MASK_LH(x)    (((uint32_t)(((uint32_t)(x)) << NETC_ETH_LINK_PPSMR_STATUS_MASK_LH_SHIFT)) & NETC_ETH_LINK_PPSMR_STATUS_MASK_LH_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group NETC_ETH_LINK_Register_Masks */


/*!
 * @}
 */ /* end of group NETC_ETH_LINK_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* PERI_NETC_ETH_LINK_H_ */

