/*
 * Copyright 2024 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v17.0
processor: MIMXRT798S
package_id: MIMXRT798SGFOA
mcu_data: ksdk2_0
processor_version: 0.2412.60
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_iopctl.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: N5, peripheral: LP_FLEXCOMM0, signal: P1, pin_signal: PIO1_0/LP_FLEXCOMM0_P1/SCT0_OUT9/CTIMER4_MAT1, selects_transmitter_current_drive: O_100}
  - {pin_num: N4, peripheral: LP_FLEXCOMM0, signal: P0, pin_signal: PIO0_31/LP_FLEXCOMM0_P0/UTICK0_CAP2/SCT0_OUT8/CTIMER4_MAT0, input_buffer: enable}
  - {pin_num: G12, peripheral: USDHC1, signal: USDHC_CARD_DET, pin_signal: PIO7_24/SDHC1_CARD_DET_N/LP_FLEXCOMM13_P4, selects_transmitter_current_drive: O_33, input_buffer: enable,
    pull_select: up, pull_enable: enable}
  - {pin_num: L17, peripheral: USDHC1, signal: USDHC_CLK, pin_signal: PIO7_17/SDHC1_CLK/LP_FLEXCOMM2_P0, selects_transmitter_current_drive: O_33, input_buffer: enable,
    pull_select: up, pull_enable: enable}
  - {pin_num: L16, peripheral: USDHC1, signal: USDHC_CMD, pin_signal: PIO7_18/SDHC1_CMD/LP_FLEXCOMM2_P1, selects_transmitter_current_drive: O_33, input_buffer: enable,
    pull_select: up, pull_enable: enable}
  - {pin_num: M17, peripheral: USDHC1, signal: 'USDHC_DATA, 0', pin_signal: PIO7_19/SDHC1_DATA0/LP_FLEXCOMM1_P4/LP_FLEXCOMM7_P3, selects_transmitter_current_drive: O_33,
    input_buffer: enable, pull_select: up, pull_enable: enable}
  - {pin_num: M18, peripheral: USDHC1, signal: 'USDHC_DATA, 1', pin_signal: PIO7_20/SDHC1_DATA1/LP_FLEXCOMM1_P5/LP_FLEXCOMM2_P4, selects_transmitter_current_drive: O_33,
    input_buffer: enable, pull_select: up, pull_enable: enable}
  - {pin_num: K18, peripheral: USDHC1, signal: 'USDHC_DATA, 2', pin_signal: PIO7_21/SDHC1_DATA2/LP_FLEXCOMM1_P6/LP_FLEXCOMM2_P5, selects_transmitter_current_drive: O_33,
    input_buffer: enable, pull_select: up, pull_enable: enable}
  - {pin_num: K17, peripheral: USDHC1, signal: 'USDHC_DATA, 3', pin_signal: PIO7_22/SDHC1_DATA3/LP_FLEXCOMM2_P2, selects_transmitter_current_drive: O_33, input_buffer: enable,
    pull_select: up, pull_enable: enable}
  - {pin_num: C5, peripheral: GPIO7, signal: 'GPIO, 11', pin_signal: PIO7_11/SDHC0_CARD_DET_N/LP_FLEXCOMM1_P1}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitPins(void)
{
    /* Reset IOPCTL0 module */
    RESET_ClearPeripheralReset(kIOPCTL0_RST_SHIFT_RSTn);
    /* Reset IOPCTL2 module */
    RESET_ClearPeripheralReset(kIOPCTL2_RST_SHIFT_RSTn);

    const uint32_t port0_pin31_config = (/* Pin is configured as LP_FLEXCOMM0_P0 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 100ohm */
                                         IOPCTL_PIO_DRIVE_100OHM);
    /* PORT0 PIN31 (coords: N4) is configured as LP_FLEXCOMM0_P0 */
    IOPCTL_PinMuxSet(0U, 31U, port0_pin31_config);

    const uint32_t port1_pin0_config = (/* Pin is configured as LP_FLEXCOMM0_P1 */
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI |
                                        /* Selects transmitter current drive 100ohm */
                                        IOPCTL_PIO_DRIVE_100OHM);
    /* PORT1 PIN0 (coords: N5) is configured as LP_FLEXCOMM0_P1 */
    IOPCTL_PinMuxSet(1U, 0U, port1_pin0_config);

    const uint32_t port7_pin11_config = (/* Pin is configured as PIO7_11 */
                                         IOPCTL_PIO_FUNC0 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 100ohm */
                                         IOPCTL_PIO_DRIVE_100OHM);
    /* PORT7 PIN11 (coords: C5) is configured as PIO7_11 */
    IOPCTL_PinMuxSet(7U, 11U, port7_pin11_config);

    const uint32_t port7_pin17_config = (/* Pin is configured as SDHC1_CLK */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN17 (coords: L17) is configured as SDHC1_CLK */
    IOPCTL_PinMuxSet(7U, 17U, port7_pin17_config);

    const uint32_t port7_pin18_config = (/* Pin is configured as SDHC1_CMD */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN18 (coords: L16) is configured as SDHC1_CMD */
    IOPCTL_PinMuxSet(7U, 18U, port7_pin18_config);

    const uint32_t port7_pin19_config = (/* Pin is configured as SDHC1_DATA0 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN19 (coords: M17) is configured as SDHC1_DATA0 */
    IOPCTL_PinMuxSet(7U, 19U, port7_pin19_config);

    const uint32_t port7_pin20_config = (/* Pin is configured as SDHC1_DATA1 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN20 (coords: M18) is configured as SDHC1_DATA1 */
    IOPCTL_PinMuxSet(7U, 20U, port7_pin20_config);

    const uint32_t port7_pin21_config = (/* Pin is configured as SDHC1_DATA2 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN21 (coords: K18) is configured as SDHC1_DATA2 */
    IOPCTL_PinMuxSet(7U, 21U, port7_pin21_config);

    const uint32_t port7_pin22_config = (/* Pin is configured as SDHC1_DATA3 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN22 (coords: K17) is configured as SDHC1_DATA3 */
    IOPCTL_PinMuxSet(7U, 22U, port7_pin22_config);

    const uint32_t port7_pin24_config = (/* Pin is configured as SDHC1_CARD_DET_N */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN24 (coords: G12) is configured as SDHC1_CARD_DET_N */
    IOPCTL_PinMuxSet(7U, 24U, port7_pin24_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitUARTPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: N4, peripheral: LP_FLEXCOMM0, signal: P0, pin_signal: PIO0_31}
  - {pin_num: N5, peripheral: LP_FLEXCOMM0, signal: P1, pin_signal: PIO1_0}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitUARTPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitUARTPins(void)
{

    const uint32_t port0_pin31_config = (/* Pin is configured as LP_FLEXCOMM0_P0 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT0 PIN31 (coords: N4) is configured as LP_FLEXCOMM0_P0 */
    IOPCTL_PinMuxSet(0U, 31U, port0_pin31_config);

    const uint32_t port1_pin0_config = (/* Pin is configured as LP_FLEXCOMM0_P1 */
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT1 PIN0 (coords: N5) is configured as LP_FLEXCOMM0_P1 */
    IOPCTL_PinMuxSet(1U, 0U, port1_pin0_config);
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
