/*
 * Copyright 2024 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _USB_HOST_CONFIG_H_
#define _USB_HOST_CONFIG_H_

#define USB_HOST_CONFIG_KHCI 0
#define USB_HOST_CONFIG_KHCI_DMA_ALIGN_BUFFER 64
#define USB_HOST_CONFIG_EHCI 1
#define USB_HOST_CONFIG_EHCI_FRAME_LIST_SIZE 1024
#define USB_HOST_CONFIG_EHCI_MAX_QH 16
#define USB_HOST_CONFIG_EHCI_MAX_QTD 16
#define USB_HOST_CONFIG_EHCI_MAX_ITD 16
#define USB_HOST_CONFIG_EHCI_MAX_SITD 16
#define USB_HOST_CONFIG_OHCI 0
#define USB_HOST_CONFIG_OHCI_MAX_ED 8
#define USB_HOST_CONFIG_OHCI_MAX_GTD 8
#define USB_HOST_CONFIG_OHCI_MAX_ITD 8
#define USB_HOST_CONFIG_IP3516HS 0
#define USB_HOST_CONFIG_IP3516HS_MAX_PIPE 32
#define USB_HOST_CONFIG_IP3516HS_MAX_ATL 32
#define USB_HOST_CONFIG_IP3516HS_MAX_INT 32
#define USB_HOST_CONFIG_IP3516HS_MAX_ISO 32
#define USB_HOST_CONFIG_MAX_HOST (USB_HOST_CONFIG_KHCI + USB_HOST_CONFIG_EHCI + USB_HOST_CONFIG_OHCI + USB_HOST_CONFIG_IP3516HS)
// #define USB_HOST_CONFIG_BATTERY_CHARGER 0
#define USB_HOST_CONFIG_AUDIO 0
#define USB_HOST_CONFIG_CDC 0
#define USB_HOST_CONFIG_CDC_ECM 0
#define USB_HOST_CONFIG_CDC_RNDIS 0
#define USB_HOST_CONFIG_HID 0
#define USB_HOST_CONFIG_PRINTER 0
#define USB_HOST_CONFIG_MSD 0
#define USB_HOST_CONFIG_HUB 1
#define USB_HOST_CONFIG_VIDEO 1
#define USB_HOST_CONFIG_PHDC 0
#define USB_HOST_CONFIG_MAX_POWER 250
#define USB_HOST_CONFIG_MAX_PIPES 16
#define USB_HOST_CONFIG_MAX_TRANSFERS 16
#define USB_HOST_CONFIG_CONFIGURATION_MAX_INTERFACE 5
#define USB_HOST_CONFIG_INTERFACE_MAX_EP 4
#define USB_HOST_CONFIG_ENUMERATION_MAX_RETRIES 3
#define USB_HOST_CONFIG_ENUMERATION_MAX_STALL_RETRIES 1
// #define USB_HOST_CONFIG_CLASS_AUTO_CLEAR_STALL 0
// #define USB_HOST_CONFIG_LOW_POWER_MODE 0
// #define USB_HOST_CONFIG_LPM_L1 0
#define USB_HOST_CONFIG_MAX_NAK 3000
// #define USB_HOST_CONFIG_COMPLIANCE_TEST 0

#endif /* _USB_HOST_CONFIG_H_ */
