/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __MEMORY_H__
#define __MEMORY_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include <stdint.h>
#include "fsl_flash.h"
#include "fsl_lpspi_nor_flash.h"

#if defined(LIB_DEBUG)
#include "fsl_debug_console.h"
#define LIB_TRACE	PRINTF
#else
#define LIB_TRACE(...)
#endif

#define SPI_FLASH_BAUDRATE                24000000

#define SPI_FLASH_ADDRESS_START           0xA0000000
#define SPI_FLASH_ADDRESS_END             (SPI_FLASH_ADDRESS_START + SPI_FLASH_SIZE)

#define SPI_FLASH_LPSPI                   LPSPI2
#define SPI_FLASH_DMA                     DMA0
#define SPI_FLASH_DMAMUX                  DMAMUX0
#define SPI_FLASH_DMA_TX_CHANNEL          0U
#define SPI_FLASH_DMA_RX_CHANNEL          1U
#define SPI_FLASH_DMA_TX_SOURCE           kDmaRequestMux0LPSPI2Tx
#define SPI_FLASH_DMA_RX_SOURCE           kDmaRequestMux0LPSPI2Rx
#define SPI_FLASH_CLK_FREQ                (CLOCK_GetIpFreq(kCLOCK_Lpspi2))

int memory_init(void);
int memory_erase(uint32_t addr, uint32_t len);
int memory_write(uint32_t addr, const uint8_t *buf, uint32_t len);
int memory_read(uint32_t addr, uint8_t *buf, uint32_t len);

#ifdef __cplusplus
}
#endif

#endif


