/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __DIMAGE_H__
#define __DIMAGE_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include <stdint.h>
#include "fsl_common.h"
#include "crc32.h"
#include "memory.h"

#if defined(DIMAGE_DEBUG)
#include "fsl_debug_console.h"
#define DIMAGE_TRACE	PRINTF
#else
#define DIMAGE_TRACE(...)
#endif

#define DUAL_IMAGE_MAKRER               (0x0FFEB6B6)
#define HEADER_BLOCK_MARKER             (0xFEEDA5A5)
#define DUAL_IMAGE_MARKER_OFFSET        (0x24)
#define DUAL_IMAGE_HDR_ADDR             (DUAL_IMAGE_MARKER_OFFSET + 4)
#define DUAL_IMAGE_HDR_OFFSET           (0x10C)
#define DUAL_IMAGE_HDR                  (GOLDEN_REGION_START + DUAL_IMAGE_HDR_OFFSET)

/* golden image region */
#define GOLDEN_REGION_START             (0x10000)       /* 64KB */
#define GOLDEN_IMAGE_CNT                (1)

/* back up image region */
#define BACKUP_REGION_START             (0xA0000000)
#define BACKUP_REGION_LEN               (0x80000)       /* 512KB */
#define BACKUP_IMAGE_CNT                (2)

/* generate image via: ./image_generator.exe -s ./MDK/lpc54608/se_image.bin ./se_image_crc.bin */

typedef struct
{
	uint32_t header_marker;						/*!< Image header marker should always be set to 0xFEEDA5A5 */
    uint32_t img_type;                          /*!< Image check type, with or without optional CRC */
    uint32_t reserved;                          /*!< Reserved word; must be 0 */
	uint32_t img_len;                           /*!< Image length or the length of image CRC check should be done. */
	uint32_t crc_value;                         /*!< CRC value  */
    uint32_t version;                           /*!< Image version for multi-image support */
} ihdr_t;

void dump_hdr(const ihdr_t *hdr);
int image_scan(uint32_t start_addr, uint32_t load_addr, uint32_t len, uint32_t *image_addr, uint32_t max_image_cnt);
int image_get_hdr(uint32_t addr, uint32_t load_addr, ihdr_t *hdr);
int image_check_and_boot(void);
int image_program(const uint8_t *image, uint32_t len);
int image_erase(uint32_t index);
int image_verify(uint32_t to, uint32_t from, uint32_t len);

#ifdef __cplusplus
}
#endif

#endif

