/*
 * Copyright 2020-2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef __SubFunc___
#define __SubFunc___

#ifdef __cplusplus
extern "C"{
#endif

#define GPIO1_DR             *(unsigned int*)(GPIO1_BASE+0x00)
#define GPIO2_DR             *(unsigned int*)(GPIO2_BASE+0x00)

/*
debug pin 0:		GPIO_AD_B1_04		GPIO1.20
debug pin 1:		GPIO_AD_B1_05		GPIO1.21
debug pin 2:		GPIO_AD_B1_06		GPIO1.22
debug pin 3:		GPIO_AD_B1_07		GPIO1.23

debug pin 4:		GPIO_AD_B1_10		GPIO1.26
debug pin 5:		GPIO_AD_B1_11		GPIO1.27
 */

#define DbgLedOn             GPIO1_DR &=~ (1<<9);
#define DbgLedOff            GPIO1_DR |=  (1<<9);

#if EnableDebugPins==1
	//enalbe all the debug pins
	#define DbgPin1Dn            GPIO1_DR &=~ (1<<20);
	#define DbgPin1Up            GPIO1_DR |=  (1<<20);
	#define DbgPin2Dn            GPIO1_DR &=~ (1<<22);
	#define DbgPin2Up            GPIO1_DR |=  (1<<22);
	#define DbgPin3Dn            GPIO1_DR &=~ (1<<23);
	#define DbgPin3Up            GPIO1_DR |=  (1<<23);
	#define DbgPin4Dn            GPIO1_DR &=~ (1<<27);
	#define DbgPin4Up            GPIO1_DR |=  (1<<27);
#else
	//disable all the debug pins
	#define DbgPin1Dn
	#define DbgPin1Up
	#define DbgPin2Dn
	#define DbgPin2Up
	#define DbgPin3Dn
	#define DbgPin3Up
	#define DbgPin4Dn
	#define DbgPin4Up
#endif



extern uint32_t CycCntA;
extern uint32_t CycCntB;

extern void OpeningBlink(uint32_t l);
extern void RoughUsDelay(int d);
extern void RoughMsDelay(int d);


#ifdef __cplusplus
}
#endif

#endif

