/*
 * Copyright 2020-2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef __Cirbuf___
#define __Cirbuf___

#ifdef __cplusplus
extern "C" {
#endif

#include "GlobalDef.h"

typedef struct
{
	int32_t s[UsbAudioFormat_NumUpStreamCh];
} T_MultiCh32BitAudioSample;

typedef struct
{
	unsigned int LengthInSamples;
	long long *PtrBufHead;
	long long *PtrRd;
	long long *PtrWr;
} T_CircularAudioBuf_S64;

typedef struct
{
	uint32_t LengthInSamples;
	int32_t *PtrBufHead;
	int32_t *PtrRd;
	int32_t *PtrWr;
} T_CircularAudioBuf;

typedef struct
{
	uint32_t LengthInSamples;
	T_MultiCh32BitAudioSample *PtrBufHead;
	T_MultiCh32BitAudioSample *PtrRd;
	T_MultiCh32BitAudioSample *PtrWr;
} T_CircularAudioBuf_MultiCh;

extern T_CircularAudioBuf_S64 UsbDnStrmCirBuf;
extern T_CircularAudioBuf_MultiCh UsbUpStrmCirBuf;

extern uint8_t UsbAudioUpStreamingIsStarted;
extern uint8_t UsbAudioDnStreamingIsStarted;
extern int16_t DecimatedAudio[16];
extern int32_t AllZeroBuf_48PointsSingleCh_32Bit[AUDIO_IN_FORMAT_CHANNELS*(AUDIO_IN_SAMPLING_RATE_KHZ+1)];

extern void InitAudioCircularBuf(void);

extern void CirAudioBuf_WriteSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int SampleNumbersToBePut, long long *PtrAudioDataSrc);
extern long long* CirAudioBuf_ReadSamples_GetRdPtr_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int SampleNumbersToBeGot);
extern unsigned int CirAudioBuf_SpaceOccupiedInSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr);
extern unsigned int CirAudioBuf_SpaceAvailableInSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr);
extern void CirAudioBuf_ClearAllSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr);

extern void CirAudioBuf_WriteSamples (T_CircularAudioBuf *CirBufPtr, uint32_t SampleNumbersToBePut, int32_t *PtrAudioDataSrc);
extern int32_t* CirAudioBuf_ReadSamples_GetRdPtr(T_CircularAudioBuf *CirBufPtr, uint32_t SampleNumbersToBeGot);
extern uint32_t CirAudioBuf_SpaceOccupiedInSamples(T_CircularAudioBuf *CirBufPtr);
extern uint32_t CirAudioBuf_SpaceAvailableInSamples(T_CircularAudioBuf *CirBufPtr);
extern void CirAudioBuf_ClearAllSamples(T_CircularAudioBuf *CirBufPtr);

extern void CirAudioBuf_WriteSamples_MultiCh(T_CircularAudioBuf_MultiCh *CirBufPtr, uint32_t SampleNumbersToBePut, T_MultiCh32BitAudioSample *PtrAudioDataSrc);
extern T_MultiCh32BitAudioSample* CirAudioBuf_ReadSamples_GetRdPtr_MultiCh(T_CircularAudioBuf_MultiCh *CirBufPtr, uint32_t SampleNumbersToBeGot);
extern uint32_t CirAudioBuf_SpaceOccupiedInSamples_MultiCh(T_CircularAudioBuf_MultiCh *CirBufPtr);
extern uint32_t CirAudioBuf_SpaceAvailableInSamples_MultiCh(T_CircularAudioBuf_MultiCh *CirBufPtr);
extern void CirAudioBuf_ClearAllSamples_MultiCh(T_CircularAudioBuf_MultiCh *CirBufPtr);

#ifdef __cplusplus
}
#endif

#endif

