/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdint.h>
#include <string.h>



#include "GlobalDef.h"

#include "CircularBufManagement.h"
#include "CircularBuf.h"


#include "usb_device_config.h"
#include "usb.h"
#include "usb_device.h"

#include "usb_device_class.h"
#include "usb_device_audio.h"
//#include "usb_device_cdc_acm.h"
//#include "usb_device_ch9.h"
#include "usb_device_descriptor.h"
#include "audio_unified.h"


T_CircularAudioBuf_S32 UsbDnSpkBuf_ForUacSyncModeL;
T_CircularAudioBuf_S32 UsbDnSpkBuf_ForUacSyncModeR;

int AllZeroBuf_48PointsSingleCh [AUDIO_IN_FORMAT_CHANNELS*AUDIO_IN_SAMPLING_RATE_KHZ*4];

__attribute__((__section__(".data.$RamSharedWithDsp")))
T_CommonVarSharedByDspAndMcu VarBlockSharedByDspAndMcu;



int32_t UsbDnSpkBuf_ForUacSyncMode_DataAreaL[AUDIO_SPEAKER_UsbDnBufLengthInMs * AUDIO_OUT_SAMPLING_RATE_KHZ + AudioFrameSizeInSamplePerCh];
int32_t UsbDnSpkBuf_ForUacSyncMode_DataAreaR[AUDIO_SPEAKER_UsbDnBufLengthInMs * AUDIO_OUT_SAMPLING_RATE_KHZ + AudioFrameSizeInSamplePerCh];

void InitAudioCircularBuf(void)
{

	InitCirAudioBuf_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingL1,VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingL1_DataArea,CirBufUsbAudioUpStreaming_Len_InSamples);
	InitCirAudioBuf_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingR1,VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingR1_DataArea,CirBufUsbAudioUpStreaming_Len_InSamples);
	InitCirAudioBuf_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingL2,VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingL2_DataArea,CirBufUsbAudioUpStreaming_Len_InSamples);
	InitCirAudioBuf_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingR2,VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingR2_DataArea,CirBufUsbAudioUpStreaming_Len_InSamples);
	InitCirAudioBuf_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioDnStreamingL, VarBlockSharedByDspAndMcu.CirBufUsbAudioDnStreamingL_DataArea,AsrcBufLengthInSamples);
	InitCirAudioBuf_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioDnStreamingR, VarBlockSharedByDspAndMcu.CirBufUsbAudioDnStreamingR_DataArea,AsrcBufLengthInSamples);

	InitCirAudioBuf_S32(&UsbDnSpkBuf_ForUacSyncModeL,UsbDnSpkBuf_ForUacSyncMode_DataAreaL,AUDIO_SPEAKER_UsbDnBufLengthInMs * AUDIO_OUT_SAMPLING_RATE_KHZ);
	InitCirAudioBuf_S32(&UsbDnSpkBuf_ForUacSyncModeR,UsbDnSpkBuf_ForUacSyncMode_DataAreaR,AUDIO_SPEAKER_UsbDnBufLengthInMs * AUDIO_OUT_SAMPLING_RATE_KHZ);


    memset(AllZeroBuf_48PointsSingleCh,0,sizeof(AllZeroBuf_48PointsSingleCh));
}



