@echo off
@rem Copyright 2020-2024 NXP
@rem SPDX-License-Identifier: BSD-3-Clause

@rem The script for writing the image into MCX A14x/A15x

@rem Environment variables - absolute paths simplifying re-use of the script on another machine
@rem  - Absolute path to SPT workspace (it is recommended to copy/move all user files in this workspace)
SETLOCAL ENABLEDELAYEDEXPANSION
if "%SPT_WORKSPACE%"=="" (
  SET "SPT_WORKSPACE=%~dp0"
  SET "SPT_WORKSPACE=!SPT_WORKSPACE:~0,-1!"
)
ENDLOCAL & SET "SPT_WORKSPACE=%SPT_WORKSPACE%"
if not exist "%SPT_WORKSPACE%\" (
  @echo FAILURE: Directory not found "%SPT_WORKSPACE%"
  exit 2
)
@rem  - Absolute path to SPT installation directory
if "%SPT_INSTALL_BIN%"=="" (
  SET "SPT_INSTALL_BIN=C:\nxp\MCUX_Provi_v9\bin\_internal"
)
if not exist "%SPT_INSTALL_BIN%\" (
  @echo FAILURE: Directory not found "%SPT_INSTALL_BIN%"
  exit 2
)

@rem Use parameter: "blhost_connect <connection_param>" to use custom connection parameters for blhost
@rem     <connection_param> should be in format "-p COMx[,baud]" or "-u VID,PID" and must be enclosed in quotes
@rem Use parameter: "manufacturing_task_no index" to set number/index of the manufacturing task (to avoid same filename created from two tasks)
@rem Use parameter: "erase_all" to perform an erase of the entire flash memory instead erasing only regions that will be written

@rem Default connection parameters
set blhost_connect=-u 0x1FC9,0x0155
set "manufacturing_task_no="

@echo ### Parse input arguments ###
:test_param_loop
if [%1]==[] (
  goto test_param_end
)
set param=%1
set known_param=0
if "%param%"=="blhost_connect" (
    set blhost_connect=%~2
    SHIFT
    set known_param=1
)
if "%param%"=="manufacturing_task_no" (
    set manufacturing_task_no=%~2
    SHIFT
    set known_param=1
)
if "%param%"=="erase_all" (
    set erase_all=1
    set known_param=1
)
if %known_param%==0 (
    echo ERROR: unsupported argument "%param%"
    exit /B 2
)
@rem Check for further batch arguments
SHIFT
goto test_param_loop
:test_param_end

@rem Used command line utilities
SET "blhost=%SPT_INSTALL_BIN%\tools_scripts\blhost_spsdk_win_wrapper.bat"

if exist "%SPT_WORKSPACE%\hooks\write_win.bat" (
    @rem hook executed before any other command is executed
    call "%SPT_WORKSPACE%\hooks\write_win.bat" started
    if errorlevel 1 exit 2
)

@rem Ping the device to establish communication; Result is ignored as the communication sometime fails for the first time
call "%blhost%" %blhost_connect% -j -- get-property 1 0 > nul 2> nul

@echo ### Check connection ###
call "%blhost%" %blhost_connect% -j -- get-property 1 0
if errorlevel 2 exit 2

@echo ### Erase flash ###
if [%erase_all%] == [1] (
    call "%blhost%" %blhost_connect% -j -- flash-erase-all 0
    if errorlevel 1 exit 2
) else (
    call "%blhost%" %blhost_connect% -j -- flash-erase-region 0x00000000 24576 0
    if errorlevel 1 exit 2

    @rem Erase memory for additional image: %SPT_WORKSPACE%\bootable_images\frdmmcxa153_ota_mcuboot_basic_signed.bin
    call "%blhost%" %blhost_connect% -j -- flash-erase-region 0x6000 49152 0
    if errorlevel 2 exit 2
)
if exist "%SPT_WORKSPACE%\hooks\write_win.bat" (
    @rem hook executed after erase of the memory is done
    call "%SPT_WORKSPACE%\hooks\write_win.bat" erase_done
    if errorlevel 1 exit 2
)

@rem CMPA must be erased before write, to avoid memory cumulative write
@echo ### Erase CMPA ###
call "%blhost%" %blhost_connect% -j -- flash-erase-region 0x01000000 512
if errorlevel 2 exit 2
@echo ### Write Customer Manufacturing/Factory Programmable Area [CMPA] ###
call "%blhost%" %blhost_connect% -j -- write-memory 0x01000000 "%SPT_WORKSPACE%\configs\cmpa.bin"
if errorlevel 2 exit 2
if exist "%SPT_WORKSPACE%\hooks\write_win.bat" (
    @rem hook executed after write of the CMPA is done
    call "%SPT_WORKSPACE%\hooks\write_win.bat" cmpa_written
    if errorlevel 1 exit 2
)

@echo ### Write image 0 ###
call "%blhost%" %blhost_connect% -j -- write-memory 0x00000000 "%SPT_WORKSPACE%\bootable_images\frdmmcxa153_mcuboot_opensource.bin"
if errorlevel 1 exit 2
if exist "%SPT_WORKSPACE%\hooks\write_win.bat" (
    @rem hook executed after write of the image is done
    call "%SPT_WORKSPACE%\hooks\write_win.bat" image_written
    if errorlevel 1 exit 2
)

@echo ### Write additional image: %SPT_WORKSPACE%\bootable_images\frdmmcxa153_ota_mcuboot_basic_signed.bin ###
call "%blhost%" %blhost_connect% -j -- write-memory 0x6000 "%SPT_WORKSPACE%\bootable_images\frdmmcxa153_ota_mcuboot_basic_signed.bin" 0
if errorlevel 2 exit 2
if exist "%SPT_WORKSPACE%\hooks\write_win.bat" (
    @rem hook executed after write of additional images is done
    call "%SPT_WORKSPACE%\hooks\write_win.bat" additional_images_written
    if errorlevel 1 exit 2
)
if exist "%SPT_WORKSPACE%\hooks\write_win.bat" (
    @rem hook executed after all steps of the script were executed
    call "%SPT_WORKSPACE%\hooks\write_win.bat" finished
    if errorlevel 1 exit 2
)
