/*
** ###################################################################
**     Processors:          MCXA156VLL
**                          MCXA156VMP
**                          MCXA156VPJ
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    MCXA18 User manual
**     Version:             rev. 1.0, 2022-03-29
**     Build:               b240403
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MCXA156
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2022-03-29)
**         Initial version based on v0.1UM
**
** ###################################################################
*/

/*!
 * @file MCXA156.h
 * @version 1.0
 * @date 2022-03-29
 * @brief CMSIS Peripheral Access Layer for MCXA156
 *
 * CMSIS Peripheral Access Layer for MCXA156
 */

#if !defined(MCXA156_H_)
#define MCXA156_H_                               /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 105                /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M33 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M33 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M33 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M33 Usage Fault Interrupt */
  SecureFault_IRQn             = -9,               /**< Cortex-M33 Secure Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M33 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M33 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M33 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M33 System Tick Interrupt */

  /* Device specific interrupts */
  Reserved16_IRQn              = 0,                /**< OR IRQ1 to IRQ53 */
  CMC_IRQn                     = 1,                /**< Core Mode Controller interrupt */
  DMA_CH0_IRQn                 = 2,                /**< DMA3_0_CH0 error or transfer complete */
  DMA_CH1_IRQn                 = 3,                /**< DMA3_0_CH1 error or transfer complete */
  DMA_CH2_IRQn                 = 4,                /**< DMA3_0_CH2 error or transfer complete */
  DMA_CH3_IRQn                 = 5,                /**< DMA3_0_CH3 error or transfer complete */
  DMA_CH4_IRQn                 = 6,                /**< DMA3_0_CH4 error or transfer complete */
  DMA_CH5_IRQn                 = 7,                /**< DMA3_0_CH5 error or transfer complete */
  DMA_CH6_IRQn                 = 8,                /**< DMA3_0_CH6 error or transfer complete */
  DMA_CH7_IRQn                 = 9,                /**< DMA3_0_CH7 error or transfer complete */
  ERM0_SINGLE_BIT_IRQn         = 10,               /**< ERM Single Bit error interrupt */
  ERM0_MULTI_BIT_IRQn          = 11,               /**< ERM Multi Bit error interrupt */
  FMU0_IRQn                    = 12,               /**< Flash Management Unit interrupt */
  GLIKEY0_IRQn                 = 13,               /**< GLIKEY Interrupt  */
  MBC0_IRQn                    = 14,               /**< MBC secure violation interrupt */
  SCG0_IRQn                    = 15,               /**< System Clock Generator interrupt */
  SPC0_IRQn                    = 16,               /**< System Power Controller interrupt */
  VBAT0_IRQn                   = 17,               /**< VBAT interrupt */
  WUU0_IRQn                    = 18,               /**< Wake Up Unit interrupt */
  CAN0_IRQn                    = 19,               /**< Controller Area Network 0 interrupt */
  Reserved36_IRQn              = 20,               /**< Reserved interrupt */
  Reserved37_IRQn              = 21,               /**< Reserved interrupt */
  Reserved38_IRQn              = 22,               /**< Reserved interrupt */
  FLEXIO_IRQn                  = 23,               /**< Flexible Input/Output interrupt */
  I3C0_IRQn                    = 24,               /**< Improved Inter Integrated Circuit interrupt 0 */
  Reserved41_IRQn              = 25,               /**< Reserved interrupt */
  LPI2C0_IRQn                  = 26,               /**< Low-Power Inter Integrated Circuit interrupt */
  LPI2C1_IRQn                  = 27,               /**< Low-Power Inter Integrated Circuit interrupt */
  LPSPI0_IRQn                  = 28,               /**< Low-Power Serial Peripheral Interface interrupt */
  LPSPI1_IRQn                  = 29,               /**< Low-Power Serial Peripheral Interface interrupt */
  Reserved46_IRQn              = 30,               /**< Reserved interrupt */
  LPUART0_IRQn                 = 31,               /**< Low-Power Universal Asynchronous Receive/Transmit interrupt */
  LPUART1_IRQn                 = 32,               /**< Low-Power Universal Asynchronous Receive/Transmit interrupt */
  LPUART2_IRQn                 = 33,               /**< Low-Power Universal Asynchronous Receive/Transmit interrupt */
  LPUART3_IRQn                 = 34,               /**< Low-Power Universal Asynchronous Receive/Transmit interrupt */
  LPUART4_IRQn                 = 35,               /**< Low-Power Universal Asynchronous Receive/Transmit interrupt */
  USB0_IRQn                    = 36,               /**< Universal Serial Bus - Full Speed interrupt */
  Reserved53_IRQn              = 37,               /**< Reserved interrupt */
  CDOG0_IRQn                   = 38,               /**< Code Watchdog Timer 0 interrupt */
  CTIMER0_IRQn                 = 39,               /**< Standard counter/timer 0 interrupt */
  CTIMER1_IRQn                 = 40,               /**< Standard counter/timer 1 interrupt */
  CTIMER2_IRQn                 = 41,               /**< Standard counter/timer 2 interrupt */
  CTIMER3_IRQn                 = 42,               /**< Standard counter/timer 3 interrupt */
  CTIMER4_IRQn                 = 43,               /**< Standard counter/timer 4 interrupt */
  FLEXPWM0_RELOAD_ERROR_IRQn   = 44,               /**< FlexPWM0_reload_error interrupt */
  FLEXPWM0_FAULT_IRQn          = 45,               /**< FlexPWM0_fault interrupt */
  FLEXPWM0_SUBMODULE0_IRQn     = 46,               /**< FlexPWM0 Submodule 0 capture/compare/reload interrupt */
  FLEXPWM0_SUBMODULE1_IRQn     = 47,               /**< FlexPWM0 Submodule 1 capture/compare/reload interrupt */
  FLEXPWM0_SUBMODULE2_IRQn     = 48,               /**< FlexPWM0 Submodule 2 capture/compare/reload interrupt */
  Reserved65_IRQn              = 49,               /**< Reserved interrupt */
  QDC0_COMPARE_IRQn            = 50,               /**< Compare */
  QDC0_HOME_IRQn               = 51,               /**< Home */
  QDC0_WATCHDOG_IRQn           = 52,               /**< Watchdog / Simultaneous A and B Change */
  QDC0_INDEX_IRQn              = 53,               /**< Index / Roll Over / Roll Under */
  FREQME0_IRQn                 = 54,               /**< Frequency Measurement interrupt */
  LPTMR0_IRQn                  = 55,               /**< Low Power Timer 0 interrupt */
  Reserved72_IRQn              = 56,               /**< Reserved interrupt */
  OS_EVENT_IRQn                = 57,               /**< OS event timer interrupt */
  WAKETIMER0_IRQn              = 58,               /**< Wake Timer Interrupt */
  UTICK0_IRQn                  = 59,               /**< Micro-Tick Timer interrupt */
  WWDT0_IRQn                   = 60,               /**< Windowed Watchdog Timer 0 interrupt */
  Reserved77_IRQn              = 61,               /**< Reserved interrupt */
  ADC0_IRQn                    = 62,               /**< Analog-to-Digital Converter interrupt */
  ADC1_IRQn                    = 63,               /**< Analog-to-Digital Converter interrupt */
  CMP0_IRQn                    = 64,               /**< Comparator interrupt */
  CMP1_IRQn                    = 65,               /**< Comparator interrupt */
  Reserved82_IRQn              = 66,               /**< Reserved interrupt */
  DAC0_IRQn                    = 67,               /**< Digital-to-Analog Converter 0 - General Purpose interrupt */
  Reserved84_IRQn              = 68,               /**< Reserved interrupt */
  Reserved85_IRQn              = 69,               /**< Reserved interrupt */
  Reserved86_IRQn              = 70,               /**< Reserved interrupt */
  GPIO0_IRQn                   = 71,               /**< General Purpose Input/Output interrupt 0 */
  GPIO1_IRQn                   = 72,               /**< General Purpose Input/Output interrupt 1 */
  GPIO2_IRQn                   = 73,               /**< General Purpose Input/Output interrupt 2 */
  GPIO3_IRQn                   = 74,               /**< General Purpose Input/Output interrupt 3 */
  GPIO4_IRQn                   = 75,               /**< General Purpose Input/Output interrupt 4 */
  Reserved92_IRQn              = 76,               /**< Reserved interrupt */
  LPI2C2_IRQn                  = 77,               /**< Low-Power Inter Integrated Circuit interrupt */
  LPI2C3_IRQn                  = 78,               /**< Low-Power Inter Integrated Circuit interrupt */
  FLEXPWM1_RELOAD_ERROR_IRQn   = 79,               /**< FlexPWM1_reload_error interrupt */
  FLEXPWM1_FAULT_IRQn          = 80,               /**< FlexPWM1_fault interrupt */
  FLEXPWM1_SUBMODULE0_IRQn     = 81,               /**< FlexPWM1 Submodule 0 capture/compare/reload interrupt */
  FLEXPWM1_SUBMODULE1_IRQn     = 82,               /**< FlexPWM1 Submodule 1 capture/compare/reload interrupt */
  FLEXPWM1_SUBMODULE2_IRQn     = 83,               /**< FlexPWM1 Submodule 2 capture/compare/reload interrupt */
  Reserved100_IRQn             = 84,               /**< Reserved interrupt */
  QDC1_COMPARE_IRQn            = 85,               /**< Compare */
  QDC1_HOME_IRQn               = 86,               /**< Home */
  QDC1_WATCHDOG_IRQn           = 87,               /**< Watchdog / Simultaneous A and B Change */
  QDC1_INDEX_IRQn              = 88                /**< Index / Roll Over / Roll Under */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M33 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M33 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  0         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               3         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */
#define __DSP_PRESENT                  1         /**< Defines if Armv8-M Mainline core supports DSP instructions */
#define __SAUREGION_PRESENT            0         /**< Defines if an SAU is present or not */

#include "core_cm33.h"                 /* Core Peripheral Access Layer */
#include "system_MCXA156.h"            /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup dma_request
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum _dma_request_source
{
    kDma0RequestDisabled            = 0U,          /**< Disabled */
    kDma0RequestWUU0                = 1U,          /**< WUU Wake up event */
    kDma0RequestMuxFlexCan0DmaRequest = 2U,        /**< CAN0 DMA request */
    kDma0RequestLPI2C2Rx            = 3U,          /**< LPI2C2 Receive request */
    kDma0RequestLPI2C2Tx            = 4U,          /**< LPI2C2 Transmit request */
    kDma0RequestLPI2C3Rx            = 5U,          /**< LPI2C3 Receive request */
    kDma0RequestLPI2C3Tx            = 6U,          /**< LPI2C3 Transmit request */
    kDma0RequestMuxI3c0Rx           = 7U,          /**< I3C0 Receive request */
    kDma0RequestMuxI3c0Tx           = 8U,          /**< I3C0 Transmit request */
    kDma0RequestLPI2C0Rx            = 11U,         /**< LPI2C0 Receive request */
    kDma0RequestLPI2C0Tx            = 12U,         /**< LPI2C0 Transmit request */
    kDma0RequestLPI2C1Rx            = 13U,         /**< LPI2C1 Receive request */
    kDma0RequestLPI2C1Tx            = 14U,         /**< LPI2C1 Transmit request */
    kDma0RequestLPSPI0Rx            = 15U,         /**< LPSPI0 Receive request */
    kDma0RequestLPSPI0Tx            = 16U,         /**< LPSPI0 Transmit request */
    kDma0RequestLPSPI1Rx            = 17U,         /**< LPSPI1 Receive request */
    kDma0RequestLPSPI1Tx            = 18U,         /**< LPSPI1 Transmit request */
    kDma0RequestLPUART0Rx           = 21U,         /**< LPUART0 Receive request */
    kDma0RequestLPUART0Tx           = 22U,         /**< LPUART0 Transmit request */
    kDma0RequestLPUART1Rx           = 23U,         /**< LPUART1 Receive request */
    kDma0RequestLPUART1Tx           = 24U,         /**< LPUART1 Transmit request */
    kDma0RequestLPUART2Rx           = 25U,         /**< LPUART2 Receive request */
    kDma0RequestLPUART2Tx           = 26U,         /**< LPUART2 Transmit request */
    kDma0RequestLPUART3Rx           = 27U,         /**< LPUART3 Receive request */
    kDma0RequestLPUART3Tx           = 28U,         /**< LPUART3 Transmit request */
    kDma0RequestLPUART4Rx           = 29U,         /**< LPUART4 Receive request */
    kDma0RequestLPUART4Tx           = 30U,         /**< LPUART4 Transmit request */
    kDma0RequestMuxCtimer0M0        = 31U,         /**< CTIMER0 Match channel 0 request */
    kDma0RequestMuxCtimer0M1        = 32U,         /**< CTIMER0 Match channel 1 request */
    kDma0RequestMuxCtimer1M0        = 33U,         /**< CTIMER1 Match channel 0 request */
    kDma0RequestMuxCtimer1M1        = 34U,         /**< CTIMER1 Match channel 1 request */
    kDma0RequestMuxCtimer2M0        = 35U,         /**< CTIMER2 Match channel 0 request */
    kDma0RequestMuxCtimer2M1        = 36U,         /**< CTIMER2 Match channel 1 request */
    kDma0RequestMuxCtimer3M0        = 37U,         /**< CTIMER3 Match channel 0 request */
    kDma0RequestMuxCtimer3M1        = 38U,         /**< CTIMER3 Match channel 1 request */
    kDma0RequestMuxCtimer4M0        = 39U,         /**< CTIMER4 Match channel 0 request */
    kDma0RequestMuxCtimer4M1        = 40U,         /**< CTIMER4 Match channel 1 request */
    kDma0RequestMuxFlexPWM0ReqCapt0 = 41U,         /**< FlexPWM0 capture0 request */
    kDma0RequestMuxFlexPWM0ReqCapt1 = 42U,         /**< FlexPWM0 capture1 request */
    kDma0RequestMuxFlexPWM0ReqCapt2 = 43U,         /**< FlexPWM0 capture2 request */
    kDma0RequestMuxFlexPWM0ReqVal0  = 45U,         /**< FlexPWM0 value0 request */
    kDma0RequestMuxFlexPWM0ReqVal1  = 46U,         /**< FlexPWM0 value1 request */
    kDma0RequestMuxFlexPWM0ReqVal2  = 47U,         /**< FlexPWM0 value2 request */
    kDma0RequestMuxLptmr0           = 49U,         /**< LPTMR0 Counter match event */
    kDma0RequestMuxAdc0FifoRequest  = 51U,         /**< ADC0 FIFO request */
    kDma0RequestMuxAdc1FifoRequest  = 52U,         /**< ADC1 FIFO request */
    kDma0RequestMuxHsCmp0DmaRequest = 53U,         /**< CMP0 DMA_request */
    kDma0RequestMuxHsCmp1DmaRequest = 54U,         /**< CMP1 DMA_request */
    kDma0RequestMuxDac0FifoRequest  = 56U,         /**< DAC0 FIFO request */
    kDma0RequestMuxGpio0PinEventRequest0 = 60U,    /**< GPIO0 Pin event request 0 */
    kDma0RequestMuxGpio1PinEventRequest0 = 61U,    /**< GPIO1 Pin event request 0 */
    kDma0RequestMuxGpio2PinEventRequest0 = 62U,    /**< GPIO2 Pin event request 0 */
    kDma0RequestMuxGpio3PinEventRequest0 = 63U,    /**< GPIO3 Pin event request 0 */
    kDma0RequestMuxGpio4PinEventRequest0 = 64U,    /**< GPIO4 Pin event request 0 */
    kDma0RequestMuxQdc0             = 65U,         /**< DMA request for new buffered value  */
    kDma0RequestMuxQdc1             = 66U,         /**< DMA request for new buffered value  */
    kDma0RequestMuxFlexIO0ShiftRegister0Request = 71U, /**< FlexIO0 Shifter0 Status DMA request OR Timer0 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister1Request = 72U, /**< FlexIO0 Shifter1 Status DMA request OR Timer1 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister2Request = 73U, /**< FlexIO0 Shifter2 Status DMA request OR Timer2 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister3Request = 74U, /**< FlexIO0 Shifter3 Status DMA request OR Timer3 Status DMA request */
    kDma0RequestMuxFlexPWM1ReqCapt0 = 79U,         /**< FlexPWM1 capture0 request */
    kDma0RequestMuxFlexPWM1ReqCapt1 = 80U,         /**< FlexPWM1 capture1 request */
    kDma0RequestMuxFlexPWM1ReqCapt2 = 81U,         /**< FlexPWM1 capture2 request */
    kDma0RequestMuxFlexPWM1ReqVal0  = 83U,         /**< FlexPWM1 value0 request */
    kDma0RequestMuxFlexPWM1ReqVal1  = 84U,         /**< FlexPWM1 value1 request */
    kDma0RequestMuxFlexPWM1ReqVal2  = 85U,         /**< FlexPWM1 value2 request */
} dma_request_source_t;

/* @} */

/*!
 * @addtogroup eim_memory_channel
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the eim_memory_channel
 *
 * Defines the structure for the EIM resource collections.
 */

typedef enum _eim_memory_channel
{
    kEIM_MemoryChannelRAMA0         = 0U,          /**< Memory RAMA0 */
} eim_memory_channel_t;

/* @} */

/*!
 * @addtogroup eim_error_injection_channel_enable
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the eim_error_injection_channel_enable
 *
 * Defines the structure for the EIM error injection resource collections.
 */

typedef enum _eim_error_injection_channel_enable
{
    kEIM_MemoryChannelRAMAEnable    = 0x80000000U, /**< Memory channel 0(RAMA0) error injection enable */
} eim_error_injection_channel_enable_t;

/* @} */

/*!
 * @addtogroup erm_memory_channel
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the erm_memory_channel
 *
 * Defines the structure for the ERM resource collections.
 */

typedef enum _erm_memory_channel
{
    kERM_MemoryChannelRAMA0         = 0U,          /**< Memory RAMA0 */
    kERM_MemoryChannelFLASH         = 1U,          /**< Memory FLASH */
} erm_memory_channel_t;

/* @} */


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CTRL;                              /**< Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< Pause Register, offset: 0x24 */
       uint8_t RESERVED_1[12];
  __O  uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
  __IO uint32_t TSTAT;                             /**< Trigger Status Register, offset: 0x38 */
       uint8_t RESERVED_2[4];
  __IO uint32_t OFSTRIM;                           /**< Offset Trim Register, offset: 0x40 */
       uint8_t RESERVED_3[4];
  __IO uint32_t HSTRIM;                            /**< High Speed Trim Register, offset: 0x48 */
       uint8_t RESERVED_4[84];
  __IO uint32_t TCTRL[4];                          /**< Trigger Control Register, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_5[48];
  __IO uint32_t FCTRL;                             /**< FIFO Control Register, offset: 0xE0 */
       uint8_t RESERVED_6[12];
  __I  uint32_t GCC[1];                            /**< Gain Calibration Control, array offset: 0xF0, array step: 0x4 */
       uint8_t RESERVED_7[4];
  __IO uint32_t GCR[1];                            /**< Gain Calculation Result, array offset: 0xF8, array step: 0x4 */
       uint8_t RESERVED_8[4];
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[7];
       uint8_t RESERVED_9[200];
  __IO uint32_t CV[7];                             /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_10[228];
  __I  uint32_t RESFIFO;                           /**< Data Result FIFO Register, offset: 0x300 */
       uint8_t RESERVED_11[252];
  __IO uint32_t CAL_GAR0;                          /**< Calibration General A-Side Registers, offset: 0x400 */
  __IO uint32_t CAL_GAR1;                          /**< Calibration General A-Side Registers, offset: 0x404 */
  __IO uint32_t CAL_GAR2;                          /**< Calibration General A-Side Registers, offset: 0x408 */
  __IO uint32_t CAL_GAR3;                          /**< Calibration General A-Side Registers, offset: 0x40C */
  __IO uint32_t CAL_GAR4;                          /**< Calibration General A-Side Registers, offset: 0x410 */
  __IO uint32_t CAL_GAR5;                          /**< Calibration General A-Side Registers, offset: 0x414 */
  __IO uint32_t CAL_GAR6;                          /**< Calibration General A-Side Registers, offset: 0x418 */
  __IO uint32_t CAL_GAR7;                          /**< Calibration General A-Side Registers, offset: 0x41C */
  __IO uint32_t CAL_GAR8;                          /**< Calibration General A-Side Registers, offset: 0x420 */
  __IO uint32_t CAL_GAR9;                          /**< Calibration General A-Side Registers, offset: 0x424 */
  __IO uint32_t CAL_GAR10;                         /**< Calibration General A-Side Registers, offset: 0x428 */
  __IO uint32_t CAL_GAR11;                         /**< Calibration General A-Side Registers, offset: 0x42C */
  __IO uint32_t CAL_GAR12;                         /**< Calibration General A-Side Registers, offset: 0x430 */
  __IO uint32_t CAL_GAR13;                         /**< Calibration General A-Side Registers, offset: 0x434 */
  __IO uint32_t CAL_GAR14;                         /**< Calibration General A-Side Registers, offset: 0x438 */
  __IO uint32_t CAL_GAR15;                         /**< Calibration General A-Side Registers, offset: 0x43C */
  __IO uint32_t CAL_GAR16;                         /**< Calibration General A-Side Registers, offset: 0x440 */
  __IO uint32_t CAL_GAR17;                         /**< Calibration General A-Side Registers, offset: 0x444 */
  __IO uint32_t CAL_GAR18;                         /**< Calibration General A-Side Registers, offset: 0x448 */
  __IO uint32_t CAL_GAR19;                         /**< Calibration General A-Side Registers, offset: 0x44C */
  __IO uint32_t CAL_GAR20;                         /**< Calibration General A-Side Registers, offset: 0x450 */
  __IO uint32_t CAL_GAR21;                         /**< Calibration General A-Side Registers, offset: 0x454 */
  __IO uint32_t CAL_GAR22;                         /**< Calibration General A-Side Registers, offset: 0x458 */
  __IO uint32_t CAL_GAR23;                         /**< Calibration General A-Side Registers, offset: 0x45C */
  __IO uint32_t CAL_GAR24;                         /**< Calibration General A-Side Registers, offset: 0x460 */
  __IO uint32_t CAL_GAR25;                         /**< Calibration General A-Side Registers, offset: 0x464 */
  __IO uint32_t CAL_GAR26;                         /**< Calibration General A-Side Registers, offset: 0x468 */
  __IO uint32_t CAL_GAR27;                         /**< Calibration General A-Side Registers, offset: 0x46C */
  __IO uint32_t CAL_GAR28;                         /**< Calibration General A-Side Registers, offset: 0x470 */
  __IO uint32_t CAL_GAR29;                         /**< Calibration General A-Side Registers, offset: 0x474 */
  __IO uint32_t CAL_GAR30;                         /**< Calibration General A-Side Registers, offset: 0x478 */
  __IO uint32_t CAL_GAR31;                         /**< Calibration General A-Side Registers, offset: 0x47C */
  __IO uint32_t CAL_GAR32;                         /**< Calibration General A-Side Registers, offset: 0x480 */
  __IO uint32_t CAL_GAR33;                         /**< Calibration General A-Side Registers, offset: 0x484 */
       uint8_t RESERVED_12[2928];
  __IO uint32_t CFG2;                              /**< Configuration 2 Register, offset: 0xFF8 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define ADC_VERID_RES_MASK                       (0x1U)
#define ADC_VERID_RES_SHIFT                      (0U)
/*! RES - Resolution
 *  0b0..Up to 12-bit single ended resolution supported (and 13-bit differential resolution if VERID[DIFFEN] = 1b).
 *  0b1..Up to 16-bit single ended resolution supported (and 16-bit differential resolution if VERID[DIFFEN] = 1b).
 */
#define ADC_VERID_RES(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)

#define ADC_VERID_DIFFEN_MASK                    (0x2U)
#define ADC_VERID_DIFFEN_SHIFT                   (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Differential operation not supported.
 *  0b1..Differential operation supported.
 */
#define ADC_VERID_DIFFEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)

#define ADC_VERID_MVI_MASK                       (0x8U)
#define ADC_VERID_MVI_SHIFT                      (3U)
/*! MVI - Multi Vref Implemented
 *  0b0..Single voltage reference high (VREFH) input supported.
 *  0b1..Multiple voltage reference high (VREFH) inputs supported.
 */
#define ADC_VERID_MVI(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)

#define ADC_VERID_CSW_MASK                       (0x70U)
#define ADC_VERID_CSW_SHIFT                      (4U)
/*! CSW - Channel Scale Width
 *  0b000..Channel scaling not supported.
 *  0b001..Channel scaling supported. 1-bit CSCALE control field.
 *  0b110..Channel scaling supported. 6-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)

#define ADC_VERID_VR1RNGI_MASK                   (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT                  (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required. CFG[VREF1RNG] is not implemented.
 *  0b1..Range control required. CFG[VREF1RNG] is implemented.
 */
#define ADC_VERID_VR1RNGI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)

#define ADC_VERID_IADCKI_MASK                    (0x200U)
#define ADC_VERID_IADCKI_SHIFT                   (9U)
/*! IADCKI - Internal ADC Clock Implemented
 *  0b0..Internal clock source not implemented.
 *  0b1..Internal clock source (and CFG[ADCKEN]) implemented.
 */
#define ADC_VERID_IADCKI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)

#define ADC_VERID_CALOFSI_MASK                   (0x400U)
#define ADC_VERID_CALOFSI_SHIFT                  (10U)
/*! CALOFSI - Calibration Function Implemented
 *  0b0..Calibration Not Implemented.
 *  0b1..Calibration Implemented.
 */
#define ADC_VERID_CALOFSI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)

#define ADC_VERID_NUM_SEC_MASK                   (0x800U)
#define ADC_VERID_NUM_SEC_SHIFT                  (11U)
/*! NUM_SEC - Number of Single Ended Outputs Supported
 *  0b0..This design supports one single ended conversion at a time.
 *  0b1..This design supports two simultaneous single ended conversions.
 */
#define ADC_VERID_NUM_SEC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_SEC_SHIFT)) & ADC_VERID_NUM_SEC_MASK)

#define ADC_VERID_NUM_FIFO_MASK                  (0x7000U)
#define ADC_VERID_NUM_FIFO_SHIFT                 (12U)
/*! NUM_FIFO - Number of FIFOs
 *  0b000..N/A
 *  0b001..This design supports one result FIFO.
 *  0b010..This design supports two result FIFOs.
 *  0b011..This design supports three result FIFOs.
 *  0b100..This design supports four result FIFOs.
 */
#define ADC_VERID_NUM_FIFO(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_FIFO_SHIFT)) & ADC_VERID_NUM_FIFO_MASK)

#define ADC_VERID_MINOR_MASK                     (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number */
#define ADC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)

#define ADC_VERID_MAJOR_MASK                     (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number */
#define ADC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)

#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..Result FIFO depth = 2 dataword.
 *  0b00000100..Result FIFO depth = 4 datawords.
 *  0b00001000..Result FIFO depth = 8 datawords.
 *  0b00010000..Result FIFO depth = 16 datawords.
 *  0b00100000..Result FIFO depth = 32 datawords.
 *  0b01000000..Result FIFO depth = 64 datawords.
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)

#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)

#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - Control Register */
/*! @{ */

#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - ADC Enable
 *  0b0..ADC is disabled.
 *  0b1..ADC is enabled.
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)

#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)

#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in low power mode.
 *  0b1..ADC is disabled in low power mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)

#define ADC_CTRL_CAL_REQ_MASK                    (0x8U)
#define ADC_CTRL_CAL_REQ_SHIFT                   (3U)
/*! CAL_REQ - Auto-Calibration Request
 *  0b0..No request for hardware calibration has been made
 *  0b1..A request for hardware calibration has been made
 */
#define ADC_CTRL_CAL_REQ(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_REQ_SHIFT)) & ADC_CTRL_CAL_REQ_MASK)

#define ADC_CTRL_CALOFS_MASK                     (0x10U)
#define ADC_CTRL_CALOFS_SHIFT                    (4U)
/*! CALOFS - Offset Calibration Request
 *  0b0..No request for offset calibration has been made
 *  0b1..Request for offset calibration function
 */
#define ADC_CTRL_CALOFS(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CALOFS_SHIFT)) & ADC_CTRL_CALOFS_MASK)

#define ADC_CTRL_CALHS_MASK                      (0x40U)
#define ADC_CTRL_CALHS_SHIFT                     (6U)
/*! CALHS - High Speed Mode Trim Request
 *  0b0..No request for high speed mode trim has been made
 *  0b1..Request for high speed mode trim has been made
 */
#define ADC_CTRL_CALHS(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CALHS_SHIFT)) & ADC_CTRL_CALHS_MASK)

#define ADC_CTRL_RSTFIFO0_MASK                   (0x100U)
#define ADC_CTRL_RSTFIFO0_SHIFT                  (8U)
/*! RSTFIFO0 - Reset FIFO 0
 *  0b0..No effect.
 *  0b1..FIFO 0 is reset.
 */
#define ADC_CTRL_RSTFIFO0(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO0_SHIFT)) & ADC_CTRL_RSTFIFO0_MASK)

#define ADC_CTRL_CAL_AVGS_MASK                   (0xF0000U)
#define ADC_CTRL_CAL_AVGS_SHIFT                  (16U)
/*! CAL_AVGS - Auto-Calibration Averages
 *  0b0000..Single conversion.
 *  0b0001..2 conversions averaged.
 *  0b0010..4 conversions averaged.
 *  0b0011..8 conversions averaged.
 *  0b0100..16 conversions averaged.
 *  0b0101..32 conversions averaged.
 *  0b0110..64 conversions averaged.
 *  0b0111..128 conversions averaged.
 *  0b1000..256 conversions averaged.
 *  0b1001..512 conversions averaged.
 *  0b1010..1024 conversions averaged.
 */
#define ADC_CTRL_CAL_AVGS(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_AVGS_SHIFT)) & ADC_CTRL_CAL_AVGS_MASK)
/*! @} */

/*! @name STAT - Status Register */
/*! @{ */

#define ADC_STAT_RDY0_MASK                       (0x1U)
#define ADC_STAT_RDY0_SHIFT                      (0U)
/*! RDY0 - Result FIFO 0 Ready Flag
 *  0b0..Result FIFO 0 data level not above watermark level.
 *  0b1..Result FIFO 0 holding data above watermark level.
 */
#define ADC_STAT_RDY0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY0_SHIFT)) & ADC_STAT_RDY0_MASK)

#define ADC_STAT_FOF0_MASK                       (0x2U)
#define ADC_STAT_FOF0_SHIFT                      (1U)
/*! FOF0 - Result FIFO 0 Overflow Flag
 *  0b0..No result FIFO 0 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO 0 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF0_SHIFT)) & ADC_STAT_FOF0_MASK)

#define ADC_STAT_TEXC_INT_MASK                   (0x100U)
#define ADC_STAT_TEXC_INT_SHIFT                  (8U)
/*! TEXC_INT - Interrupt Flag For High Priority Trigger Exception
 *  0b0..No trigger exceptions have occurred.
 *  0b1..A trigger exception has occurred and is pending acknowledgement.
 */
#define ADC_STAT_TEXC_INT(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TEXC_INT_SHIFT)) & ADC_STAT_TEXC_INT_MASK)

#define ADC_STAT_TCOMP_INT_MASK                  (0x200U)
#define ADC_STAT_TCOMP_INT_SHIFT                 (9U)
/*! TCOMP_INT - Interrupt Flag For Trigger Completion
 *  0b0..Either IE[TCOMP_IE] is set to 0, or no trigger sequences have run to completion.
 *  0b1..Trigger sequence has been completed and all data is stored in the associated FIFO.
 */
#define ADC_STAT_TCOMP_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TCOMP_INT_SHIFT)) & ADC_STAT_TCOMP_INT_MASK)

#define ADC_STAT_CAL_RDY_MASK                    (0x400U)
#define ADC_STAT_CAL_RDY_SHIFT                   (10U)
/*! CAL_RDY - Calibration Ready
 *  0b0..Calibration is incomplete or hasn't been ran.
 *  0b1..The ADC is calibrated.
 */
#define ADC_STAT_CAL_RDY(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CAL_RDY_SHIFT)) & ADC_STAT_CAL_RDY_MASK)

#define ADC_STAT_ADC_ACTIVE_MASK                 (0x800U)
#define ADC_STAT_ADC_ACTIVE_SHIFT                (11U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..The ADC is IDLE. There are no pending triggers to service and no active commands are being processed.
 *  0b1..The ADC is processing a conversion, running through the power up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)

#define ADC_STAT_TRGACT_MASK                     (0x30000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b00..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b01..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b10..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b11..Command (sequence) associated with Trigger 3 currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)

#define ADC_STAT_CMDACT_MASK                     (0x7000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b000..No command is currently in progress.
 *  0b001..Command 1 currently being executed.
 *  0b010..Command 2 currently being executed.
 *  0b011-0b111..Associated command number is currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */

#define ADC_IE_FWMIE0_MASK                       (0x1U)
#define ADC_IE_FWMIE0_SHIFT                      (0U)
/*! FWMIE0 - FIFO 0 Watermark Interrupt Enable
 *  0b0..FIFO 0 watermark interrupts are not enabled.
 *  0b1..FIFO 0 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE0_SHIFT)) & ADC_IE_FWMIE0_MASK)

#define ADC_IE_FOFIE0_MASK                       (0x2U)
#define ADC_IE_FOFIE0_SHIFT                      (1U)
/*! FOFIE0 - Result FIFO 0 Overflow Interrupt Enable
 *  0b0..FIFO 0 overflow interrupts are not enabled.
 *  0b1..FIFO 0 overflow interrupts are enabled.
 */
#define ADC_IE_FOFIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE0_SHIFT)) & ADC_IE_FOFIE0_MASK)

#define ADC_IE_TEXC_IE_MASK                      (0x100U)
#define ADC_IE_TEXC_IE_SHIFT                     (8U)
/*! TEXC_IE - Trigger Exception Interrupt Enable
 *  0b0..Trigger exception interrupts are disabled.
 *  0b1..Trigger exception interrupts are enabled.
 */
#define ADC_IE_TEXC_IE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_IE_TEXC_IE_SHIFT)) & ADC_IE_TEXC_IE_MASK)

#define ADC_IE_TCOMP_IE_MASK                     (0xF0000U)
#define ADC_IE_TCOMP_IE_SHIFT                    (16U)
/*! TCOMP_IE - Trigger Completion Interrupt Enable
 *  0b0000..Trigger completion interrupts are disabled.
 *  0b0001..Trigger completion interrupts are enabled for trigger source 0 only.
 *  0b0010..Trigger completion interrupts are enabled for trigger source 1 only.
 *  0b0011-0b1110..Associated trigger completion interrupts are enabled.
 *  0b1111..Trigger completion interrupts are enabled for every trigger source.
 */
#define ADC_IE_TCOMP_IE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_IE_TCOMP_IE_SHIFT)) & ADC_IE_TCOMP_IE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */

#define ADC_DE_FWMDE0_MASK                       (0x1U)
#define ADC_DE_FWMDE0_SHIFT                      (0U)
/*! FWMDE0 - FIFO 0 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE0_SHIFT)) & ADC_DE_FWMDE0_MASK)
/*! @} */

/*! @name CFG - Configuration Register */
/*! @{ */

#define ADC_CFG_TPRICTRL_MASK                    (0x3U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - ADC Trigger Priority Control
 *  0b00..If a higher priority trigger is detected during command processing, the current conversion is aborted
 *        and the new command specified by the trigger is started.
 *  0b01..If a higher priority trigger is received during command processing, the current command is stopped after
 *        completing the current conversion. If averaging is enabled, the averaging loop will be completed.
 *        However, CMDHa[LOOP] will be ignored and the higher priority trigger will be serviced.
 *  0b10..If a higher priority trigger is received during command processing, the current command will be
 *        completed (averaging, looping, compare) before servicing the higher priority trigger.
 *  0b11..
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)

#define ADC_CFG_PWRSEL_MASK                      (0x20U)
#define ADC_CFG_PWRSEL_SHIFT                     (5U)
/*! PWRSEL - Power Configuration Select
 *  0b0..Low power
 *  0b1..High power
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)

#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..(Default) Option 1 setting.
 *  0b01..Option 2 setting.
 *  0b10..Option 3 setting.
 *  0b11..Reserved
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)

#define ADC_CFG_TRES_MASK                        (0x100U)
#define ADC_CFG_TRES_SHIFT                       (8U)
/*! TRES - Trigger Resume Enable
 *  0b0..Trigger sequences interrupted by a high priority trigger exception are not automatically resumed or restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception are automatically resumed or restarted.
 */
#define ADC_CFG_TRES(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TRES_SHIFT)) & ADC_CFG_TRES_MASK)

#define ADC_CFG_TCMDRES_MASK                     (0x200U)
#define ADC_CFG_TCMDRES_SHIFT                    (9U)
/*! TCMDRES - Trigger Command Resume
 *  0b0..Trigger sequences interrupted by a high priority trigger exception is automatically restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception is resumed from the command executing before the exception.
 */
#define ADC_CFG_TCMDRES(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TCMDRES_SHIFT)) & ADC_CFG_TCMDRES_MASK)

#define ADC_CFG_HPT_EXDI_MASK                    (0x400U)
#define ADC_CFG_HPT_EXDI_SHIFT                   (10U)
/*! HPT_EXDI - High Priority Trigger Exception Disable
 *  0b0..High priority trigger exceptions are enabled.
 *  0b1..High priority trigger exceptions are disabled.
 */
#define ADC_CFG_HPT_EXDI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_HPT_EXDI_SHIFT)) & ADC_CFG_HPT_EXDI_MASK)

#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power Up Delay */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)

#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Performance is affected due to analog startup delays.
 *  0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays (at the cost
 *       of higher DC current consumption). Note that a single power up delay (CFG[PUDLY]) is executed immediately
 *       once PWREN is set, and any detected trigger does not begin ADC operation until the power up delay time has
 *       passed. After this initial delay expires the analog remains pre-enabled and no additional delays are
 *       executed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - Pause Register */
/*! @{ */

#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)

#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - PAUSE Option Enable
 *  0b0..Pause operation disabled
 *  0b1..Pause operation enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */

#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software Trigger 0 Event
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)

#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software Trigger 1 Event
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)

#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software Trigger 2 Event
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)

#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software Trigger 3 Event
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)
/*! @} */

/*! @name TSTAT - Trigger Status Register */
/*! @{ */

#define ADC_TSTAT_TEXC_NUM_MASK                  (0xFU)
#define ADC_TSTAT_TEXC_NUM_SHIFT                 (0U)
/*! TEXC_NUM - Trigger Exception Number
 *  0b0000..No triggers have been interrupted by a high priority exception. Or CFG[TRES] = 1.
 *  0b0001..Trigger 0 has been interrupted by a high priority exception.
 *  0b0010..Trigger 1 has been interrupted by a high priority exception.
 *  0b0011-0b1110..Associated trigger sequence has interrupted by a high priority exception.
 *  0b1111..Every trigger sequence has been interrupted by a high priority exception.
 */
#define ADC_TSTAT_TEXC_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TEXC_NUM_SHIFT)) & ADC_TSTAT_TEXC_NUM_MASK)

#define ADC_TSTAT_TCOMP_FLAG_MASK                (0xF0000U)
#define ADC_TSTAT_TCOMP_FLAG_SHIFT               (16U)
/*! TCOMP_FLAG - Trigger Completion Flag
 *  0b0000..No triggers have been completed. Trigger completion interrupts are disabled.
 *  0b0001..Trigger 0 has been completed and trigger 0 has enabled completion interrupts.
 *  0b0010..Trigger 1 has been completed and trigger 1 has enabled completion interrupts.
 *  0b0011-0b1110..Associated trigger sequence has completed and has enabled completion interrupts.
 *  0b1111..Every trigger sequence has been completed and every trigger has enabled completion interrupts.
 */
#define ADC_TSTAT_TCOMP_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TCOMP_FLAG_SHIFT)) & ADC_TSTAT_TCOMP_FLAG_MASK)
/*! @} */

/*! @name OFSTRIM - Offset Trim Register */
/*! @{ */

#define ADC_OFSTRIM_OFSTRIM_MASK                 (0x3FFU)
#define ADC_OFSTRIM_OFSTRIM_SHIFT                (0U)
/*! OFSTRIM - Trim for Offset */
#define ADC_OFSTRIM_OFSTRIM(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_SHIFT)) & ADC_OFSTRIM_OFSTRIM_MASK)
/*! @} */

/*! @name HSTRIM - High Speed Trim Register */
/*! @{ */

#define ADC_HSTRIM_HSTRIM_MASK                   (0x1FU)
#define ADC_HSTRIM_HSTRIM_SHIFT                  (0U)
/*! HSTRIM - Trim for High Speed Conversions */
#define ADC_HSTRIM_HSTRIM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_HSTRIM_HSTRIM_SHIFT)) & ADC_HSTRIM_HSTRIM_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */

#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger Enable
 *  0b0..Hardware trigger source disabled
 *  0b1..Hardware trigger source enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)

#define ADC_TCTRL_TPRI_MASK                      (0x300U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger Priority Setting
 *  0b00..Set to highest priority, Level 1
 *  0b01-0b10..Set to corresponding priority level
 *  0b11..Set to lowest priority, Level 4
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)

#define ADC_TCTRL_RSYNC_MASK                     (0x8000U)
#define ADC_TCTRL_RSYNC_SHIFT                    (15U)
/*! RSYNC - Trigger Resync */
#define ADC_TCTRL_RSYNC(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_RSYNC_SHIFT)) & ADC_TCTRL_RSYNC_MASK)

#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger Delay Select */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)

#define ADC_TCTRL_TSYNC_MASK                     (0x800000U)
#define ADC_TCTRL_TSYNC_SHIFT                    (23U)
/*! TSYNC - Trigger Synchronous Select */
#define ADC_TCTRL_TSYNC(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TSYNC_SHIFT)) & ADC_TCTRL_TSYNC_MASK)

#define ADC_TCTRL_TCMD_MASK                      (0x7000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger Command Select
 *  0b000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b001..CMD1 is executed
 *  0b010-0b110..Corresponding CMD is executed
 *  0b111..CMD7 is executed
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (4U)

/*! @name FCTRL - FIFO Control Register */
/*! @{ */

#define ADC_FCTRL_FCOUNT_MASK                    (0xFU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO Counter */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)

#define ADC_FCTRL_FWMARK_MASK                    (0x70000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark Level Selection */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/*! @name GCC - Gain Calibration Control */
/*! @{ */

#define ADC_GCC_GAIN_CAL_MASK                    (0xFFFFU)
#define ADC_GCC_GAIN_CAL_SHIFT                   (0U)
/*! GAIN_CAL - Gain Calibration Value */
#define ADC_GCC_GAIN_CAL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_GCC_GAIN_CAL_SHIFT)) & ADC_GCC_GAIN_CAL_MASK)

#define ADC_GCC_RDY_MASK                         (0x1000000U)
#define ADC_GCC_RDY_SHIFT                        (24U)
/*! RDY - Gain Calibration Value Valid
 *  0b0..The GAIN_CAL value is invalid. Run the hardware calibration routine for this value to be set.
 *  0b1..The GAIN_CAL value is valid. GAIN_CAL should be used by software to derive GCRa[GCALR].
 */
#define ADC_GCC_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCC_RDY_SHIFT)) & ADC_GCC_RDY_MASK)
/*! @} */

/* The count of ADC_GCC */
#define ADC_GCC_COUNT                            (1U)

/*! @name GCR - Gain Calculation Result */
/*! @{ */

#define ADC_GCR_GCALR_MASK                       (0x1FFFFU)
#define ADC_GCR_GCALR_SHIFT                      (0U)
/*! GCALR - Gain Calculation Result */
#define ADC_GCR_GCALR(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_GCR_GCALR_SHIFT)) & ADC_GCR_GCALR_MASK)

#define ADC_GCR_RDY_MASK                         (0x1000000U)
#define ADC_GCR_RDY_SHIFT                        (24U)
/*! RDY - Gain Calculation Ready
 *  0b0..The GCALR value is invalid.
 *  0b1..The GCALR value is valid.
 */
#define ADC_GCR_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCR_RDY_SHIFT)) & ADC_GCR_RDY_MASK)
/*! @} */

/* The count of ADC_GCR */
#define ADC_GCR_COUNT                            (1U)

/*! @name CMDL - Command Low Buffer Register */
/*! @{ */

#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input Channel Select
 *  0b00000..Select CH0A.
 *  0b00001..Select CH1A.
 *  0b00010..Select CH2A.
 *  0b00011..Select CH3A.
 *  0b00100-0b11101..Select corresponding channel CHnA.
 *  0b11110..Select CH30A.
 *  0b11111..Select CH31A.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)

#define ADC_CMDL_CTYPE_MASK                      (0x60U)
#define ADC_CMDL_CTYPE_SHIFT                     (5U)
/*! CTYPE - Conversion Type
 *  0b00..Single-Ended Mode. Only A side channel is converted.
 *  0b01-0b11..Reserved.
 */
#define ADC_CMDL_CTYPE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CTYPE_SHIFT)) & ADC_CMDL_CTYPE_MASK)

#define ADC_CMDL_MODE_MASK                       (0x80U)
#define ADC_CMDL_MODE_SHIFT                      (7U)
/*! MODE - Select Resolution of Conversions
 *  0b0..Standard resolution. Single-ended 12-bit conversion.
 *  0b1..High resolution. Single-ended 16-bit conversion.
 */
#define ADC_CMDL_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_MODE_SHIFT)) & ADC_CMDL_MODE_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (7U)

/*! @name CMDH - Command High Buffer Register */
/*! @{ */

#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Compare disabled.
 *  0b01..Reserved
 *  0b10..Compare enabled. Store on true.
 *  0b11..Compare enabled. Repeat channel acquisition (sample/convert/compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)

#define ADC_CMDH_WAIT_TRIG_MASK                  (0x4U)
#define ADC_CMDH_WAIT_TRIG_SHIFT                 (2U)
/*! WAIT_TRIG - Wait for Trigger Assertion before Execution.
 *  0b0..This command will be automatically executed.
 *  0b1..The active trigger must be asserted again before executing this command.
 */
#define ADC_CMDH_WAIT_TRIG(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_WAIT_TRIG_SHIFT)) & ADC_CMDH_WAIT_TRIG_MASK)

#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Auto channel increment disabled
 *  0b1..Auto channel increment enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)

#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3.5 ADCK cycles.
 *  0b001..3.5 + 21 ADCK cycles; 5.5 ADCK cycles total sample time.
 *  0b010..3.5 + 22 ADCK cycles; 7.5 ADCK cycles total sample time.
 *  0b011..3.5 + 23 ADCK cycles; 11.5 ADCK cycles total sample time.
 *  0b100..3.5 + 24 ADCK cycles; 19.5 ADCK cycles total sample time.
 *  0b101..3.5 + 25 ADCK cycles; 35.5 ADCK cycles total sample time.
 *  0b110..3.5 + 26 ADCK cycles; 67.5 ADCK cycles total sample time.
 *  0b111..3.5 + 27 ADCK cycles; 131.5 ADCK cycles total sample time.
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)

#define ADC_CMDH_AVGS_MASK                       (0xF000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b0000..Single conversion.
 *  0b0001..2 conversions averaged.
 *  0b0010..4 conversions averaged.
 *  0b0011..8 conversions averaged.
 *  0b0100..16 conversions averaged.
 *  0b0101..32 conversions averaged.
 *  0b0110..64 conversions averaged.
 *  0b0111..128 conversions averaged.
 *  0b1000..256 conversions averaged.
 *  0b1001..512 conversions averaged.
 *  0b1010..1024 conversions averaged.
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)

#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes 1 time.
 *  0b0001..Loop 1 time. Command executes 2 times.
 *  0b0010..Loop 2 times. Command executes 3 times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP+1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)

#define ADC_CMDH_NEXT_MASK                       (0x7000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *         trigger pending, begin command associated with lower priority trigger.
 *  0b001..Select CMD1 command buffer register as next command.
 *  0b010-0b110..Select corresponding CMD command buffer register as next command
 *  0b111..Select CMD7 command buffer register as next command.
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (7U)

/*! @name CV - Compare Value Register */
/*! @{ */

#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)

#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (7U)

/*! @name RESFIFO - Data Result FIFO Register */
/*! @{ */

#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data Result */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)

#define ADC_RESFIFO_TSRC_MASK                    (0x30000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b00..Trigger source 0 initiated this conversion.
 *  0b01..Trigger source 1 initiated this conversion.
 *  0b10..Trigger source 2 initiated this conversion.
 *  0b11..Trigger source 3 initiated this conversion.
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)

#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop Count Value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from LOOPCNT+1 conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)

#define ADC_RESFIFO_CMDSRC_MASK                  (0x7000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b000..Not a valid value CMDSRC value for a dataword in RESFIFO. 0x0 is only found in initial FIFO state prior
 *         to an ADC conversion result dataword being stored to a RESFIFO buffer.
 *  0b001..CMD1 buffer used as control settings for this conversion.
 *  0b010-0b110..Corresponding command buffer used as control settings for this conversion.
 *  0b111..CMD7 buffer used as control settings for this conversion.
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)

#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO Entry is Valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */

/*! @name CAL_GAR0 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR0_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR0_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR0_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR0_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR0_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR1 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR1_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR1_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR1_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR1_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR1_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR2 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR2_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR2_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR2_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR2_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR2_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR3 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR3_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR3_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR3_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR3_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR3_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR4 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR4_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR4_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR4_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR4_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR4_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR5 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR5_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR5_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR5_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR5_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR5_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR6 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR6_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR6_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR6_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR6_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR6_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR7 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR7_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR7_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR7_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR7_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR7_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR8 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR8_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR8_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR8_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR8_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR8_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR9 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR9_CAL_GAR_VAL_MASK            (0xFFFFU)
#define ADC_CAL_GAR9_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR9_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR9_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR9_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR10 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR10_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR10_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR10_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR10_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR10_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR11 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR11_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR11_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR11_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR11_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR11_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR12 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR12_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR12_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR12_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR12_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR12_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR13 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR13_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR13_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR13_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR13_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR13_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR14 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR14_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR14_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR14_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR14_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR14_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR15 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR15_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR15_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR15_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR15_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR15_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR16 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR16_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR16_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR16_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR16_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR16_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR17 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR17_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR17_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR17_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR17_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR17_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR18 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR18_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR18_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR18_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR18_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR18_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR19 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR19_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR19_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR19_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR19_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR19_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR20 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR20_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR20_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR20_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR20_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR20_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR21 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR21_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR21_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR21_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR21_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR21_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR22 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR22_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR22_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR22_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR22_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR22_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR23 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR23_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR23_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR23_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR23_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR23_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR24 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR24_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR24_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR24_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR24_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR24_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR25 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR25_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR25_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR25_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR25_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR25_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR26 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR26_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR26_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR26_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR26_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR26_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR27 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR27_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR27_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR27_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR27_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR27_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR28 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR28_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR28_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR28_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR28_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR28_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR29 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR29_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR29_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR29_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR29_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR29_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR30 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR30_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR30_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR30_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR30_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR30_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR31 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR31_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR31_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR31_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR31_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR31_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR32 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR32_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR32_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR32_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR32_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR32_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR33 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR33_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR33_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR33_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR33_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR33_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CFG2 - Configuration 2 Register */
/*! @{ */

#define ADC_CFG2_JLEFT_MASK                      (0x100U)
#define ADC_CFG2_JLEFT_SHIFT                     (8U)
/*! JLEFT - Justified Left Enable register */
#define ADC_CFG2_JLEFT(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_JLEFT_SHIFT)) & ADC_CFG2_JLEFT_MASK)

#define ADC_CFG2_HS_MASK                         (0x200U)
#define ADC_CFG2_HS_SHIFT                        (9U)
/*! HS - High Speed Enable register
 *  0b0..High speed conversion mode disabled
 *  0b1..High speed conversion mode enabled
 */
#define ADC_CFG2_HS(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_HS_SHIFT)) & ADC_CFG2_HS_MASK)

#define ADC_CFG2_HSEXTRA_MASK                    (0x400U)
#define ADC_CFG2_HSEXTRA_SHIFT                   (10U)
/*! HSEXTRA - High Speed Extra register
 *  0b0..No extra cycle added
 *  0b1..Extra cycle added
 */
#define ADC_CFG2_HSEXTRA(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_HSEXTRA_SHIFT)) & ADC_CFG2_HSEXTRA_MASK)

#define ADC_CFG2_TUNE_MASK                       (0x3000U)
#define ADC_CFG2_TUNE_SHIFT                      (12U)
/*! TUNE - Tune Mode register */
#define ADC_CFG2_TUNE(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_TUNE_SHIFT)) & ADC_CFG2_TUNE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC0 base address */
#define ADC0_BASE                                (0x400AF000u)
/** Peripheral ADC0 base pointer */
#define ADC0                                     ((ADC_Type *)ADC0_BASE)
/** Peripheral ADC1 base address */
#define ADC1_BASE                                (0x400B0000u)
/** Peripheral ADC1 base pointer */
#define ADC1                                     ((ADC_Type *)ADC1_BASE)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { ADC0_BASE, ADC1_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC0, ADC1 }
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { ADC0_IRQn, ADC1_IRQn }
/* Backward compatibility */
#define ADC_CTRL_RSTFIFO_MASK                     ADC_CTRL_RSTFIFO0_MASK
#define ADC_CTRL_RSTFIFO_SHIFT                    ADC_CTRL_RSTFIFO0_SHIFT
#define ADC_CTRL_RSTFIFO(x)                       ADC_CTRL_RSTFIFO0(x)
#define ADC_STAT_RDY_MASK                         ADC_STAT_RDY0_MASK
#define ADC_STAT_RDY_SHIFT                        ADC_STAT_RDY0_SHIFT
#define ADC_STAT_RDY(x)                           ADC_STAT_RDY0(x)
#define ADC_STAT_FOF_MASK                         ADC_STAT_FOF0_MASK
#define ADC_STAT_FOF_SHIFT                        ADC_STAT_FOF0_SHIFT
#define ADC_STAT_FOF(x)                           ADC_STAT_FOF0(x)
#define ADC_IE_FWMIE_MASK                         ADC_IE_FWMIE0_MASK
#define ADC_IE_FWMIE_SHIFT                        ADC_IE_FWMIE0_SHIFT
#define ADC_IE_FWMIE(x)                           ADC_IE_FWMIE0(x)
#define ADC_IE_FOFIE_MASK                         ADC_IE_FOFIE0_MASK
#define ADC_IE_FOFIE_SHIFT                        ADC_IE_FOFIE0_SHIFT
#define ADC_IE_FOFIE(x)                           ADC_IE_FOFIE0(x)
#define ADC_DE_FWMDE_MASK                         ADC_DE_FWMDE0_MASK
#define ADC_DE_FWMDE_SHIFT                        ADC_DE_FWMDE0_SHIFT
#define ADC_DE_FWMDE(x)                           ADC_DE_FWMDE0(x)


/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AOI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Peripheral_Access_Layer AOI Peripheral Access Layer
 * @{
 */

/** AOI - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x4 */
    __IO uint16_t BFCRT01;                           /**< Boolean Function Term 0 and 1 Configuration for EVENT0..Boolean Function Term 0 and 1 Configuration for EVENT3, array offset: 0x0, array step: 0x4 */
    __IO uint16_t BFCRT23;                           /**< Boolean Function Term 2 and 3 Configuration for EVENT0..Boolean Function Term 2 and 3 Configuration for EVENT3, array offset: 0x2, array step: 0x4 */
  } BFCRT[4];
} AOI_Type;

/* ----------------------------------------------------------------------------
   -- AOI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Register_Masks AOI Register Masks
 * @{
 */

/*! @name BFCRT01 - Boolean Function Term 0 and 1 Configuration for EVENT0..Boolean Function Term 0 and 1 Configuration for EVENT3 */
/*! @{ */

#define AOI_BFCRT01_PT1_DC_MASK                  (0x3U)
#define AOI_BFCRT01_PT1_DC_SHIFT                 (0U)
/*! PT1_DC - Product Term 1, Input D Configuration
 *  0b00..Force input D to become 0
 *  0b01..Pass input D
 *  0b10..Complement input D
 *  0b11..Force input D to become 1
 */
#define AOI_BFCRT01_PT1_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_DC_SHIFT)) & AOI_BFCRT01_PT1_DC_MASK)

#define AOI_BFCRT01_PT1_CC_MASK                  (0xCU)
#define AOI_BFCRT01_PT1_CC_SHIFT                 (2U)
/*! PT1_CC - Product Term 1, Input C Configuration
 *  0b00..Force input C to become 0
 *  0b01..Pass input C
 *  0b10..Complement input C
 *  0b11..Force input C to become 1
 */
#define AOI_BFCRT01_PT1_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_CC_SHIFT)) & AOI_BFCRT01_PT1_CC_MASK)

#define AOI_BFCRT01_PT1_BC_MASK                  (0x30U)
#define AOI_BFCRT01_PT1_BC_SHIFT                 (4U)
/*! PT1_BC - Product Term 1, Input B Configuration
 *  0b00..Force input B to become 0
 *  0b01..Pass input B
 *  0b10..Complement input B
 *  0b11..Force input B to become 1
 */
#define AOI_BFCRT01_PT1_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_BC_SHIFT)) & AOI_BFCRT01_PT1_BC_MASK)

#define AOI_BFCRT01_PT1_AC_MASK                  (0xC0U)
#define AOI_BFCRT01_PT1_AC_SHIFT                 (6U)
/*! PT1_AC - Product Term 1, Input A Configuration
 *  0b00..Force input A to become 0
 *  0b01..Pass input A
 *  0b10..Complement input A
 *  0b11..Force input A to become 1
 */
#define AOI_BFCRT01_PT1_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_AC_SHIFT)) & AOI_BFCRT01_PT1_AC_MASK)

#define AOI_BFCRT01_PT0_DC_MASK                  (0x300U)
#define AOI_BFCRT01_PT0_DC_SHIFT                 (8U)
/*! PT0_DC - Product Term 0, Input D Configuration
 *  0b00..Force input D to become 0
 *  0b01..Pass input D
 *  0b10..Complement input D
 *  0b11..Force input D to become 1
 */
#define AOI_BFCRT01_PT0_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_DC_SHIFT)) & AOI_BFCRT01_PT0_DC_MASK)

#define AOI_BFCRT01_PT0_CC_MASK                  (0xC00U)
#define AOI_BFCRT01_PT0_CC_SHIFT                 (10U)
/*! PT0_CC - Product Term 0, Input C Configuration
 *  0b00..Force input C to become 0
 *  0b01..Pass input C
 *  0b10..Complement input C
 *  0b11..Force input C to become 1
 */
#define AOI_BFCRT01_PT0_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_CC_SHIFT)) & AOI_BFCRT01_PT0_CC_MASK)

#define AOI_BFCRT01_PT0_BC_MASK                  (0x3000U)
#define AOI_BFCRT01_PT0_BC_SHIFT                 (12U)
/*! PT0_BC - Product Term 0, Input B Configuration
 *  0b00..Force input B to become 0
 *  0b01..Pass input B
 *  0b10..Complement input B
 *  0b11..Force input B to become 1
 */
#define AOI_BFCRT01_PT0_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_BC_SHIFT)) & AOI_BFCRT01_PT0_BC_MASK)

#define AOI_BFCRT01_PT0_AC_MASK                  (0xC000U)
#define AOI_BFCRT01_PT0_AC_SHIFT                 (14U)
/*! PT0_AC - Product Term 0, Input A Configuration
 *  0b00..Force input A to become 0
 *  0b01..Pass input A
 *  0b10..Complement input A
 *  0b11..Force input A to become 1
 */
#define AOI_BFCRT01_PT0_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_AC_SHIFT)) & AOI_BFCRT01_PT0_AC_MASK)
/*! @} */

/* The count of AOI_BFCRT01 */
#define AOI_BFCRT01_COUNT                        (4U)

/*! @name BFCRT23 - Boolean Function Term 2 and 3 Configuration for EVENT0..Boolean Function Term 2 and 3 Configuration for EVENT3 */
/*! @{ */

#define AOI_BFCRT23_PT3_DC_MASK                  (0x3U)
#define AOI_BFCRT23_PT3_DC_SHIFT                 (0U)
/*! PT3_DC - Product Term 3, Input D Configuration
 *  0b00..Force input D to become 0
 *  0b01..Pass input D
 *  0b10..Complement input D
 *  0b11..Force input D to become 1
 */
#define AOI_BFCRT23_PT3_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_DC_SHIFT)) & AOI_BFCRT23_PT3_DC_MASK)

#define AOI_BFCRT23_PT3_CC_MASK                  (0xCU)
#define AOI_BFCRT23_PT3_CC_SHIFT                 (2U)
/*! PT3_CC - Product Term 3, Input C Configuration
 *  0b00..Force input C to become 0
 *  0b01..Pass input C
 *  0b10..Complement input C
 *  0b11..Force input C to become 1
 */
#define AOI_BFCRT23_PT3_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_CC_SHIFT)) & AOI_BFCRT23_PT3_CC_MASK)

#define AOI_BFCRT23_PT3_BC_MASK                  (0x30U)
#define AOI_BFCRT23_PT3_BC_SHIFT                 (4U)
/*! PT3_BC - Product Term 3, Input B Configuration
 *  0b00..Force input B to become 0
 *  0b01..Pass input B
 *  0b10..Complement input B
 *  0b11..Force input B to become 1
 */
#define AOI_BFCRT23_PT3_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_BC_SHIFT)) & AOI_BFCRT23_PT3_BC_MASK)

#define AOI_BFCRT23_PT3_AC_MASK                  (0xC0U)
#define AOI_BFCRT23_PT3_AC_SHIFT                 (6U)
/*! PT3_AC - Product Term 3, Input A Configuration
 *  0b00..Force input A to become 0
 *  0b01..Pass input A
 *  0b10..Complement input A
 *  0b11..Force input to become 1
 */
#define AOI_BFCRT23_PT3_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_AC_SHIFT)) & AOI_BFCRT23_PT3_AC_MASK)

#define AOI_BFCRT23_PT2_DC_MASK                  (0x300U)
#define AOI_BFCRT23_PT2_DC_SHIFT                 (8U)
/*! PT2_DC - Product Term 2, Input D Configuration
 *  0b00..Force input D to become 0
 *  0b01..Pass input D
 *  0b10..Complement input D
 *  0b11..Force input D to become 1
 */
#define AOI_BFCRT23_PT2_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_DC_SHIFT)) & AOI_BFCRT23_PT2_DC_MASK)

#define AOI_BFCRT23_PT2_CC_MASK                  (0xC00U)
#define AOI_BFCRT23_PT2_CC_SHIFT                 (10U)
/*! PT2_CC - Product Term 2, Input C Configuration
 *  0b00..Force input C to become 0
 *  0b01..Pass input C
 *  0b10..Complement input C
 *  0b11..Force input C to become 1
 */
#define AOI_BFCRT23_PT2_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_CC_SHIFT)) & AOI_BFCRT23_PT2_CC_MASK)

#define AOI_BFCRT23_PT2_BC_MASK                  (0x3000U)
#define AOI_BFCRT23_PT2_BC_SHIFT                 (12U)
/*! PT2_BC - Product Term 2, Input B Configuration
 *  0b00..Force input B to become 0
 *  0b01..Pass input B
 *  0b10..Complement input B
 *  0b11..Force input B to become 1
 */
#define AOI_BFCRT23_PT2_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_BC_SHIFT)) & AOI_BFCRT23_PT2_BC_MASK)

#define AOI_BFCRT23_PT2_AC_MASK                  (0xC000U)
#define AOI_BFCRT23_PT2_AC_SHIFT                 (14U)
/*! PT2_AC - Product Term 2, Input A Configuration
 *  0b00..Force input A to become 0
 *  0b01..Pass input A
 *  0b10..Complement input A
 *  0b11..Force input A to become 1
 */
#define AOI_BFCRT23_PT2_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_AC_SHIFT)) & AOI_BFCRT23_PT2_AC_MASK)
/*! @} */

/* The count of AOI_BFCRT23 */
#define AOI_BFCRT23_COUNT                        (4U)


/*!
 * @}
 */ /* end of group AOI_Register_Masks */


/* AOI - Peripheral instance base addresses */
/** Peripheral AOI0 base address */
#define AOI0_BASE                                (0x40089000u)
/** Peripheral AOI0 base pointer */
#define AOI0                                     ((AOI_Type *)AOI0_BASE)
/** Peripheral AOI1 base address */
#define AOI1_BASE                                (0x40097000u)
/** Peripheral AOI1 base pointer */
#define AOI1                                     ((AOI_Type *)AOI1_BASE)
/** Array initializer of AOI peripheral base addresses */
#define AOI_BASE_ADDRS                           { AOI0_BASE, AOI1_BASE }
/** Array initializer of AOI peripheral base pointers */
#define AOI_BASE_PTRS                            { AOI0, AOI1 }

/*!
 * @}
 */ /* end of group AOI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1, offset: 0x4 */
  __IO uint32_t TIMER;                             /**< Free-Running Timer, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t RXMGMASK;                          /**< RX Message Buffers Global Mask, offset: 0x10 */
  __IO uint32_t RX14MASK;                          /**< Receive 14 Mask, offset: 0x14 */
  __IO uint32_t RX15MASK;                          /**< Receive 15 Mask, offset: 0x18 */
  __IO uint32_t ECR;                               /**< Error Counter, offset: 0x1C */
  __IO uint32_t ESR1;                              /**< Error and Status 1, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __IO uint32_t IMASK1;                            /**< Interrupt Masks 1, offset: 0x28 */
       uint8_t RESERVED_2[4];
  __IO uint32_t IFLAG1;                            /**< Interrupt Flags 1, offset: 0x30 */
  __IO uint32_t CTRL2;                             /**< Control 2, offset: 0x34 */
  __I  uint32_t ESR2;                              /**< Error and Status 2, offset: 0x38 */
       uint8_t RESERVED_3[8];
  __I  uint32_t CRCR;                              /**< Cyclic Redundancy Check, offset: 0x44 */
  __IO uint32_t RXFGMASK;                          /**< Legacy RX FIFO Global Mask, offset: 0x48 */
  __I  uint32_t RXFIR;                             /**< Legacy RX FIFO Information, offset: 0x4C */
  __IO uint32_t CBT;                               /**< CAN Bit Timing, offset: 0x50 */
       uint8_t RESERVED_4[44];
  union {                                          /* offset: 0x80 */
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD[2];                           /**< Message Buffer 0 WORD_8B Register..Message Buffer 31 WORD_8B Register, array offset: 0x88, array step: index*0x10, index2*0x4 */
    } MB_8B[32];
    struct {                                         /* offset: 0x80, array step: 0x18 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 20 CS Register, array offset: 0x80, array step: 0x18 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 20 ID Register, array offset: 0x84, array step: 0x18 */
      __IO uint32_t WORD[4];                           /**< Message Buffer 0 WORD_16B Register..Message Buffer 20 WORD_16B Register, array offset: 0x88, array step: index*0x18, index2*0x4 */
    } MB_16B[21];
    struct {                                         /* offset: 0x80, array step: 0x28 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 11 CS Register, array offset: 0x80, array step: 0x28 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 11 ID Register, array offset: 0x84, array step: 0x28 */
      __IO uint32_t WORD[8];                           /**< Message Buffer 0 WORD_32B Register..Message Buffer 11 WORD_32B Register, array offset: 0x88, array step: index*0x28, index2*0x4 */
    } MB_32B[12];
    struct {                                         /* offset: 0x80, array step: 0x48 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 6 CS Register, array offset: 0x80, array step: 0x48 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 6 ID Register, array offset: 0x84, array step: 0x48 */
      __IO uint32_t WORD[16];                          /**< Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register, array offset: 0x88, array step: index*0x48, index2*0x4 */
    } MB_64B[7];
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD0;                             /**< Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register, array offset: 0x88, array step: 0x10 */
      __IO uint32_t WORD1;                             /**< Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register, array offset: 0x8C, array step: 0x10 */
    } MB[32];
  };
       uint8_t RESERVED_5[1536];
  __IO uint32_t RXIMR[32];                         /**< Receive Individual Mask, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_6[512];
  __IO uint32_t CTRL1_PN;                          /**< Pretended Networking Control 1, offset: 0xB00 */
  __IO uint32_t CTRL2_PN;                          /**< Pretended Networking Control 2, offset: 0xB04 */
  __IO uint32_t WU_MTC;                            /**< Pretended Networking Wake-Up Match, offset: 0xB08 */
  __IO uint32_t FLT_ID1;                           /**< Pretended Networking ID Filter 1, offset: 0xB0C */
  __IO uint32_t FLT_DLC;                           /**< Pretended Networking Data Length Code (DLC) Filter, offset: 0xB10 */
  __IO uint32_t PL1_LO;                            /**< Pretended Networking Payload Low Filter 1, offset: 0xB14 */
  __IO uint32_t PL1_HI;                            /**< Pretended Networking Payload High Filter 1, offset: 0xB18 */
  __IO uint32_t FLT_ID2_IDMASK;                    /**< Pretended Networking ID Filter 2 or ID Mask, offset: 0xB1C */
  __IO uint32_t PL2_PLMASK_LO;                     /**< Pretended Networking Payload Low Filter 2 and Payload Low Mask, offset: 0xB20 */
  __IO uint32_t PL2_PLMASK_HI;                     /**< Pretended Networking Payload High Filter 2 and Payload High Mask, offset: 0xB24 */
       uint8_t RESERVED_7[24];
  struct {                                         /* offset: 0xB40, array step: 0x10 */
    __I  uint32_t CS;                                /**< Wake-Up Message Buffer, array offset: 0xB40, array step: 0x10 */
    __I  uint32_t ID;                                /**< Wake-Up Message Buffer for ID, array offset: 0xB44, array step: 0x10 */
    __I  uint32_t D03;                               /**< Wake-Up Message Buffer for Data 0-3, array offset: 0xB48, array step: 0x10 */
    __I  uint32_t D47;                               /**< Wake-Up Message Buffer Register Data 4-7, array offset: 0xB4C, array step: 0x10 */
  } WMB[4];
       uint8_t RESERVED_8[112];
  __IO uint32_t EPRS;                              /**< Enhanced CAN Bit Timing Prescalers, offset: 0xBF0 */
  __IO uint32_t ENCBT;                             /**< Enhanced Nominal CAN Bit Timing, offset: 0xBF4 */
  __IO uint32_t EDCBT;                             /**< Enhanced Data Phase CAN Bit Timing, offset: 0xBF8 */
  __IO uint32_t ETDC;                              /**< Enhanced Transceiver Delay Compensation, offset: 0xBFC */
  __IO uint32_t FDCTRL;                            /**< CAN FD Control, offset: 0xC00 */
  __IO uint32_t FDCBT;                             /**< CAN FD Bit Timing, offset: 0xC04 */
  __I  uint32_t FDCRC;                             /**< CAN FD CRC, offset: 0xC08 */
  __IO uint32_t ERFCR;                             /**< Enhanced RX FIFO Control, offset: 0xC0C */
  __IO uint32_t ERFIER;                            /**< Enhanced RX FIFO Interrupt Enable, offset: 0xC10 */
  __IO uint32_t ERFSR;                             /**< Enhanced RX FIFO Status, offset: 0xC14 */
       uint8_t RESERVED_9[9192];
  __IO uint32_t ERFFEL[32];                        /**< Enhanced RX FIFO Filter Element, array offset: 0x3000, array step: 0x4 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name MCR - Module Configuration */
/*! @{ */

#define CAN_MCR_MAXMB_MASK                       (0x7FU)
#define CAN_MCR_MAXMB_SHIFT                      (0U)
/*! MAXMB - Number of the Last Message Buffer */
#define CAN_MCR_MAXMB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MAXMB_SHIFT)) & CAN_MCR_MAXMB_MASK)

#define CAN_MCR_IDAM_MASK                        (0x300U)
#define CAN_MCR_IDAM_SHIFT                       (8U)
/*! IDAM - ID Acceptance Mode
 *  0b00..Format A: One full ID (standard and extended) per ID filter table element.
 *  0b01..Format B: Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID filter table element.
 *  0b10..Format C: Four partial 8-bit standard IDs per ID filter table element.
 *  0b11..Format D: All frames rejected.
 */
#define CAN_MCR_IDAM(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IDAM_SHIFT)) & CAN_MCR_IDAM_MASK)

#define CAN_MCR_FDEN_MASK                        (0x800U)
#define CAN_MCR_FDEN_SHIFT                       (11U)
/*! FDEN - CAN FD Operation Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define CAN_MCR_FDEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FDEN_SHIFT)) & CAN_MCR_FDEN_MASK)

#define CAN_MCR_AEN_MASK                         (0x1000U)
#define CAN_MCR_AEN_SHIFT                        (12U)
/*! AEN - Abort Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_MCR_AEN(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_AEN_SHIFT)) & CAN_MCR_AEN_MASK)

#define CAN_MCR_LPRIOEN_MASK                     (0x2000U)
#define CAN_MCR_LPRIOEN_SHIFT                    (13U)
/*! LPRIOEN - Local Priority Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_LPRIOEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPRIOEN_SHIFT)) & CAN_MCR_LPRIOEN_MASK)

#define CAN_MCR_PNET_EN_MASK                     (0x4000U)
#define CAN_MCR_PNET_EN_SHIFT                    (14U)
/*! PNET_EN - Pretended Networking Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_PNET_EN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_PNET_EN_SHIFT)) & CAN_MCR_PNET_EN_MASK)

#define CAN_MCR_DMA_MASK                         (0x8000U)
#define CAN_MCR_DMA_SHIFT                        (15U)
/*! DMA - DMA Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_DMA(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DMA_SHIFT)) & CAN_MCR_DMA_MASK)

#define CAN_MCR_IRMQ_MASK                        (0x10000U)
#define CAN_MCR_IRMQ_SHIFT                       (16U)
/*! IRMQ - Individual RX Masking and Queue Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_IRMQ(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IRMQ_SHIFT)) & CAN_MCR_IRMQ_MASK)

#define CAN_MCR_SRXDIS_MASK                      (0x20000U)
#define CAN_MCR_SRXDIS_SHIFT                     (17U)
/*! SRXDIS - Self-Reception Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_MCR_SRXDIS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SRXDIS_SHIFT)) & CAN_MCR_SRXDIS_MASK)

#define CAN_MCR_DOZE_MASK                        (0x40000U)
#define CAN_MCR_DOZE_SHIFT                       (18U)
/*! DOZE - Doze Mode Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_DOZE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DOZE_SHIFT)) & CAN_MCR_DOZE_MASK)

#define CAN_MCR_WAKSRC_MASK                      (0x80000U)
#define CAN_MCR_WAKSRC_SHIFT                     (19U)
/*! WAKSRC - Wake-Up Source
 *  0b0..No filter applied
 *  0b1..Filter applied
 */
#define CAN_MCR_WAKSRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKSRC_SHIFT)) & CAN_MCR_WAKSRC_MASK)

#define CAN_MCR_LPMACK_MASK                      (0x100000U)
#define CAN_MCR_LPMACK_SHIFT                     (20U)
/*! LPMACK - Low-Power Mode Acknowledge
 *  0b0..Not in a low-power mode
 *  0b1..In a low-power mode
 */
#define CAN_MCR_LPMACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPMACK_SHIFT)) & CAN_MCR_LPMACK_MASK)

#define CAN_MCR_WRNEN_MASK                       (0x200000U)
#define CAN_MCR_WRNEN_SHIFT                      (21U)
/*! WRNEN - Warning Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_WRNEN(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WRNEN_SHIFT)) & CAN_MCR_WRNEN_MASK)

#define CAN_MCR_SLFWAK_MASK                      (0x400000U)
#define CAN_MCR_SLFWAK_SHIFT                     (22U)
/*! SLFWAK - Self Wake-up
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_SLFWAK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SLFWAK_SHIFT)) & CAN_MCR_SLFWAK_MASK)

#define CAN_MCR_FRZACK_MASK                      (0x1000000U)
#define CAN_MCR_FRZACK_SHIFT                     (24U)
/*! FRZACK - Freeze Mode Acknowledge
 *  0b0..Not in Freeze mode, prescaler running.
 *  0b1..In Freeze mode, prescaler stopped.
 */
#define CAN_MCR_FRZACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZACK_SHIFT)) & CAN_MCR_FRZACK_MASK)

#define CAN_MCR_SOFTRST_MASK                     (0x2000000U)
#define CAN_MCR_SOFTRST_SHIFT                    (25U)
/*! SOFTRST - Soft Reset
 *  0b0..No reset
 *  0b1..Soft reset affects reset registers
 */
#define CAN_MCR_SOFTRST(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SOFTRST_SHIFT)) & CAN_MCR_SOFTRST_MASK)

#define CAN_MCR_WAKMSK_MASK                      (0x4000000U)
#define CAN_MCR_WAKMSK_SHIFT                     (26U)
/*! WAKMSK - Wake-up Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_MCR_WAKMSK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKMSK_SHIFT)) & CAN_MCR_WAKMSK_MASK)

#define CAN_MCR_NOTRDY_MASK                      (0x8000000U)
#define CAN_MCR_NOTRDY_SHIFT                     (27U)
/*! NOTRDY - FlexCAN Not Ready
 *  0b0..FlexCAN is in Normal mode, Listen-Only mode, or Loopback mode.
 *  0b1..FlexCAN is in Disable mode, Doze mode, Stop mode, or Freeze mode.
 */
#define CAN_MCR_NOTRDY(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_NOTRDY_SHIFT)) & CAN_MCR_NOTRDY_MASK)

#define CAN_MCR_HALT_MASK                        (0x10000000U)
#define CAN_MCR_HALT_SHIFT                       (28U)
/*! HALT - Halt FlexCAN
 *  0b0..No request
 *  0b1..Enter Freeze mode, if MCR[FRZ] = 1.
 */
#define CAN_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_HALT_SHIFT)) & CAN_MCR_HALT_MASK)

#define CAN_MCR_RFEN_MASK                        (0x20000000U)
#define CAN_MCR_RFEN_SHIFT                       (29U)
/*! RFEN - Legacy RX FIFO Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_RFEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_RFEN_SHIFT)) & CAN_MCR_RFEN_MASK)

#define CAN_MCR_FRZ_MASK                         (0x40000000U)
#define CAN_MCR_FRZ_SHIFT                        (30U)
/*! FRZ - Freeze Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZ_SHIFT)) & CAN_MCR_FRZ_MASK)

#define CAN_MCR_MDIS_MASK                        (0x80000000U)
#define CAN_MCR_MDIS_SHIFT                       (31U)
/*! MDIS - Module Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MDIS_SHIFT)) & CAN_MCR_MDIS_MASK)
/*! @} */

/*! @name CTRL1 - Control 1 */
/*! @{ */

#define CAN_CTRL1_PROPSEG_MASK                   (0x7U)
#define CAN_CTRL1_PROPSEG_SHIFT                  (0U)
/*! PROPSEG - Propagation Segment */
#define CAN_CTRL1_PROPSEG(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PROPSEG_SHIFT)) & CAN_CTRL1_PROPSEG_MASK)

#define CAN_CTRL1_LOM_MASK                       (0x8U)
#define CAN_CTRL1_LOM_SHIFT                      (3U)
/*! LOM - Listen-Only Mode
 *  0b0..Listen-Only mode is deactivated.
 *  0b1..FlexCAN module operates in Listen-Only mode.
 */
#define CAN_CTRL1_LOM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LOM_SHIFT)) & CAN_CTRL1_LOM_MASK)

#define CAN_CTRL1_LBUF_MASK                      (0x10U)
#define CAN_CTRL1_LBUF_SHIFT                     (4U)
/*! LBUF - Lowest Buffer Transmitted First
 *  0b0..Buffer with highest priority is transmitted first.
 *  0b1..Lowest number buffer is transmitted first.
 */
#define CAN_CTRL1_LBUF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LBUF_SHIFT)) & CAN_CTRL1_LBUF_MASK)

#define CAN_CTRL1_TSYN_MASK                      (0x20U)
#define CAN_CTRL1_TSYN_SHIFT                     (5U)
/*! TSYN - Timer Sync
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_TSYN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TSYN_SHIFT)) & CAN_CTRL1_TSYN_MASK)

#define CAN_CTRL1_BOFFREC_MASK                   (0x40U)
#define CAN_CTRL1_BOFFREC_SHIFT                  (6U)
/*! BOFFREC - Bus Off Recovery
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define CAN_CTRL1_BOFFREC(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFREC_SHIFT)) & CAN_CTRL1_BOFFREC_MASK)

#define CAN_CTRL1_SMP_MASK                       (0x80U)
#define CAN_CTRL1_SMP_SHIFT                      (7U)
/*! SMP - CAN Bit Sampling
 *  0b0..One sample is used to determine the bit value.
 *  0b1..Three samples are used to determine the value of the received bit: the regular one (sample point) and two
 *       preceding samples. A majority rule is used.
 */
#define CAN_CTRL1_SMP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_SMP_SHIFT)) & CAN_CTRL1_SMP_MASK)

#define CAN_CTRL1_RWRNMSK_MASK                   (0x400U)
#define CAN_CTRL1_RWRNMSK_SHIFT                  (10U)
/*! RWRNMSK - RX Warning Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_RWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RWRNMSK_SHIFT)) & CAN_CTRL1_RWRNMSK_MASK)

#define CAN_CTRL1_TWRNMSK_MASK                   (0x800U)
#define CAN_CTRL1_TWRNMSK_SHIFT                  (11U)
/*! TWRNMSK - TX Warning Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_TWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TWRNMSK_SHIFT)) & CAN_CTRL1_TWRNMSK_MASK)

#define CAN_CTRL1_LPB_MASK                       (0x1000U)
#define CAN_CTRL1_LPB_SHIFT                      (12U)
/*! LPB - Loopback Mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_LPB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LPB_SHIFT)) & CAN_CTRL1_LPB_MASK)

#define CAN_CTRL1_ERRMSK_MASK                    (0x4000U)
#define CAN_CTRL1_ERRMSK_SHIFT                   (14U)
/*! ERRMSK - Error Interrupt Mask
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_CTRL1_ERRMSK(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_ERRMSK_SHIFT)) & CAN_CTRL1_ERRMSK_MASK)

#define CAN_CTRL1_BOFFMSK_MASK                   (0x8000U)
#define CAN_CTRL1_BOFFMSK_SHIFT                  (15U)
/*! BOFFMSK - Bus Off Interrupt Mask
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_CTRL1_BOFFMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFMSK_SHIFT)) & CAN_CTRL1_BOFFMSK_MASK)

#define CAN_CTRL1_PSEG2_MASK                     (0x70000U)
#define CAN_CTRL1_PSEG2_SHIFT                    (16U)
/*! PSEG2 - Phase Segment 2 */
#define CAN_CTRL1_PSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG2_SHIFT)) & CAN_CTRL1_PSEG2_MASK)

#define CAN_CTRL1_PSEG1_MASK                     (0x380000U)
#define CAN_CTRL1_PSEG1_SHIFT                    (19U)
/*! PSEG1 - Phase Segment 1 */
#define CAN_CTRL1_PSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG1_SHIFT)) & CAN_CTRL1_PSEG1_MASK)

#define CAN_CTRL1_RJW_MASK                       (0xC00000U)
#define CAN_CTRL1_RJW_SHIFT                      (22U)
/*! RJW - Resync Jump Width */
#define CAN_CTRL1_RJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RJW_SHIFT)) & CAN_CTRL1_RJW_MASK)

#define CAN_CTRL1_PRESDIV_MASK                   (0xFF000000U)
#define CAN_CTRL1_PRESDIV_SHIFT                  (24U)
/*! PRESDIV - Prescaler Division Factor */
#define CAN_CTRL1_PRESDIV(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PRESDIV_SHIFT)) & CAN_CTRL1_PRESDIV_MASK)
/*! @} */

/*! @name TIMER - Free-Running Timer */
/*! @{ */

#define CAN_TIMER_TIMER_MASK                     (0xFFFFU)
#define CAN_TIMER_TIMER_SHIFT                    (0U)
/*! TIMER - Timer Value */
#define CAN_TIMER_TIMER(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TIMER_TIMER_SHIFT)) & CAN_TIMER_TIMER_MASK)
/*! @} */

/*! @name RXMGMASK - RX Message Buffers Global Mask */
/*! @{ */

#define CAN_RXMGMASK_MG_MASK                     (0xFFFFFFFFU)
#define CAN_RXMGMASK_MG_SHIFT                    (0U)
/*! MG - Global Mask for RX Message Buffers */
#define CAN_RXMGMASK_MG(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXMGMASK_MG_SHIFT)) & CAN_RXMGMASK_MG_MASK)
/*! @} */

/*! @name RX14MASK - Receive 14 Mask */
/*! @{ */

#define CAN_RX14MASK_RX14M_MASK                  (0xFFFFFFFFU)
#define CAN_RX14MASK_RX14M_SHIFT                 (0U)
/*! RX14M - RX Buffer 14 Mask Bits */
#define CAN_RX14MASK_RX14M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX14MASK_RX14M_SHIFT)) & CAN_RX14MASK_RX14M_MASK)
/*! @} */

/*! @name RX15MASK - Receive 15 Mask */
/*! @{ */

#define CAN_RX15MASK_RX15M_MASK                  (0xFFFFFFFFU)
#define CAN_RX15MASK_RX15M_SHIFT                 (0U)
/*! RX15M - RX Buffer 15 Mask Bits */
#define CAN_RX15MASK_RX15M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX15MASK_RX15M_SHIFT)) & CAN_RX15MASK_RX15M_MASK)
/*! @} */

/*! @name ECR - Error Counter */
/*! @{ */

#define CAN_ECR_TXERRCNT_MASK                    (0xFFU)
#define CAN_ECR_TXERRCNT_SHIFT                   (0U)
/*! TXERRCNT - Transmit Error Counter */
#define CAN_ECR_TXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_SHIFT)) & CAN_ECR_TXERRCNT_MASK)

#define CAN_ECR_RXERRCNT_MASK                    (0xFF00U)
#define CAN_ECR_RXERRCNT_SHIFT                   (8U)
/*! RXERRCNT - Receive Error Counter */
#define CAN_ECR_RXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_SHIFT)) & CAN_ECR_RXERRCNT_MASK)

#define CAN_ECR_TXERRCNT_FAST_MASK               (0xFF0000U)
#define CAN_ECR_TXERRCNT_FAST_SHIFT              (16U)
/*! TXERRCNT_FAST - Transmit Error Counter for Fast Bits */
#define CAN_ECR_TXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_FAST_SHIFT)) & CAN_ECR_TXERRCNT_FAST_MASK)

#define CAN_ECR_RXERRCNT_FAST_MASK               (0xFF000000U)
#define CAN_ECR_RXERRCNT_FAST_SHIFT              (24U)
/*! RXERRCNT_FAST - Receive Error Counter for Fast Bits */
#define CAN_ECR_RXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_FAST_SHIFT)) & CAN_ECR_RXERRCNT_FAST_MASK)
/*! @} */

/*! @name ESR1 - Error and Status 1 */
/*! @{ */

#define CAN_ESR1_WAKINT_MASK                     (0x1U)
#define CAN_ESR1_WAKINT_SHIFT                    (0U)
/*! WAKINT - Wake-up Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Indicates that a recessive-to-dominant transition was received on the CAN bus.
 */
#define CAN_ESR1_WAKINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_WAKINT_SHIFT)) & CAN_ESR1_WAKINT_MASK)

#define CAN_ESR1_ERRINT_MASK                     (0x2U)
#define CAN_ESR1_ERRINT_SHIFT                    (1U)
/*! ERRINT - Error Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error flag in the Error and Status register.
 */
#define CAN_ESR1_ERRINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_SHIFT)) & CAN_ESR1_ERRINT_MASK)

#define CAN_ESR1_BOFFINT_MASK                    (0x4U)
#define CAN_ESR1_BOFFINT_SHIFT                   (2U)
/*! BOFFINT - Bus Off Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module entered Bus Off state.
 */
#define CAN_ESR1_BOFFINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFINT_SHIFT)) & CAN_ESR1_BOFFINT_MASK)

#define CAN_ESR1_RX_MASK                         (0x8U)
#define CAN_ESR1_RX_SHIFT                        (3U)
/*! RX - FlexCAN in Reception Flag
 *  0b0..Not receiving
 *  0b1..Receiving
 */
#define CAN_ESR1_RX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RX_SHIFT)) & CAN_ESR1_RX_MASK)

#define CAN_ESR1_FLTCONF_MASK                    (0x30U)
#define CAN_ESR1_FLTCONF_SHIFT                   (4U)
/*! FLTCONF - Fault Confinement State
 *  0b00..Error Active
 *  0b01..Error Passive
 *  0b1x..Bus Off
 */
#define CAN_ESR1_FLTCONF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FLTCONF_SHIFT)) & CAN_ESR1_FLTCONF_MASK)

#define CAN_ESR1_TX_MASK                         (0x40U)
#define CAN_ESR1_TX_SHIFT                        (6U)
/*! TX - FlexCAN In Transmission
 *  0b0..Not transmitting
 *  0b1..Transmitting
 */
#define CAN_ESR1_TX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TX_SHIFT)) & CAN_ESR1_TX_MASK)

#define CAN_ESR1_IDLE_MASK                       (0x80U)
#define CAN_ESR1_IDLE_SHIFT                      (7U)
/*! IDLE - Idle
 *  0b0..Not IDLE
 *  0b1..IDLE
 */
#define CAN_ESR1_IDLE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_IDLE_SHIFT)) & CAN_ESR1_IDLE_MASK)

#define CAN_ESR1_RXWRN_MASK                      (0x100U)
#define CAN_ESR1_RXWRN_SHIFT                     (8U)
/*! RXWRN - RX Error Warning Flag
 *  0b0..No such occurrence.
 *  0b1..RXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_RXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RXWRN_SHIFT)) & CAN_ESR1_RXWRN_MASK)

#define CAN_ESR1_TXWRN_MASK                      (0x200U)
#define CAN_ESR1_TXWRN_SHIFT                     (9U)
/*! TXWRN - TX Error Warning Flag
 *  0b0..No such occurrence.
 *  0b1..TXERRCNT is 96 or greater.
 */
#define CAN_ESR1_TXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TXWRN_SHIFT)) & CAN_ESR1_TXWRN_MASK)

#define CAN_ESR1_STFERR_MASK                     (0x400U)
#define CAN_ESR1_STFERR_SHIFT                    (10U)
/*! STFERR - Stuffing Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_SHIFT)) & CAN_ESR1_STFERR_MASK)

#define CAN_ESR1_FRMERR_MASK                     (0x800U)
#define CAN_ESR1_FRMERR_SHIFT                    (11U)
/*! FRMERR - Form Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_SHIFT)) & CAN_ESR1_FRMERR_MASK)

#define CAN_ESR1_CRCERR_MASK                     (0x1000U)
#define CAN_ESR1_CRCERR_SHIFT                    (12U)
/*! CRCERR - Cyclic Redundancy Check Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_SHIFT)) & CAN_ESR1_CRCERR_MASK)

#define CAN_ESR1_ACKERR_MASK                     (0x2000U)
#define CAN_ESR1_ACKERR_SHIFT                    (13U)
/*! ACKERR - Acknowledge Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_ACKERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ACKERR_SHIFT)) & CAN_ESR1_ACKERR_MASK)

#define CAN_ESR1_BIT0ERR_MASK                    (0x4000U)
#define CAN_ESR1_BIT0ERR_SHIFT                   (14U)
/*! BIT0ERR - Bit0 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_SHIFT)) & CAN_ESR1_BIT0ERR_MASK)

#define CAN_ESR1_BIT1ERR_MASK                    (0x8000U)
#define CAN_ESR1_BIT1ERR_SHIFT                   (15U)
/*! BIT1ERR - Bit1 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_SHIFT)) & CAN_ESR1_BIT1ERR_MASK)

#define CAN_ESR1_RWRNINT_MASK                    (0x10000U)
#define CAN_ESR1_RWRNINT_SHIFT                   (16U)
/*! RWRNINT - RX Warning Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..RX error counter changed from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_RWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RWRNINT_SHIFT)) & CAN_ESR1_RWRNINT_MASK)

#define CAN_ESR1_TWRNINT_MASK                    (0x20000U)
#define CAN_ESR1_TWRNINT_SHIFT                   (17U)
/*! TWRNINT - TX Warning Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..TX error counter changed from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_TWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TWRNINT_SHIFT)) & CAN_ESR1_TWRNINT_MASK)

#define CAN_ESR1_SYNCH_MASK                      (0x40000U)
#define CAN_ESR1_SYNCH_SHIFT                     (18U)
/*! SYNCH - CAN Synchronization Status Flag
 *  0b0..Not synchronized
 *  0b1..Synchronized
 */
#define CAN_ESR1_SYNCH(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_SYNCH_SHIFT)) & CAN_ESR1_SYNCH_MASK)

#define CAN_ESR1_BOFFDONEINT_MASK                (0x80000U)
#define CAN_ESR1_BOFFDONEINT_SHIFT               (19U)
/*! BOFFDONEINT - Bus Off Done Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..FlexCAN module has completed Bus Off process.
 */
#define CAN_ESR1_BOFFDONEINT(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFDONEINT_SHIFT)) & CAN_ESR1_BOFFDONEINT_MASK)

#define CAN_ESR1_ERRINT_FAST_MASK                (0x100000U)
#define CAN_ESR1_ERRINT_FAST_SHIFT               (20U)
/*! ERRINT_FAST - Fast Error Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Error flag set in the data phase of CAN FD frames that have BRS = 1.
 */
#define CAN_ESR1_ERRINT_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_FAST_SHIFT)) & CAN_ESR1_ERRINT_FAST_MASK)

#define CAN_ESR1_ERROVR_MASK                     (0x200000U)
#define CAN_ESR1_ERROVR_SHIFT                    (21U)
/*! ERROVR - Error Overrun Flag
 *  0b0..No overrun
 *  0b1..Overrun
 */
#define CAN_ESR1_ERROVR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERROVR_SHIFT)) & CAN_ESR1_ERROVR_MASK)

#define CAN_ESR1_STFERR_FAST_MASK                (0x4000000U)
#define CAN_ESR1_STFERR_FAST_SHIFT               (26U)
/*! STFERR_FAST - Fast Stuffing Error Flag
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_FAST_SHIFT)) & CAN_ESR1_STFERR_FAST_MASK)

#define CAN_ESR1_FRMERR_FAST_MASK                (0x8000000U)
#define CAN_ESR1_FRMERR_FAST_SHIFT               (27U)
/*! FRMERR_FAST - Fast Form Error Flag
 *  0b0..No such occurrence.
 *  0b1..A form error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_FAST_SHIFT)) & CAN_ESR1_FRMERR_FAST_MASK)

#define CAN_ESR1_CRCERR_FAST_MASK                (0x10000000U)
#define CAN_ESR1_CRCERR_FAST_SHIFT               (28U)
/*! CRCERR_FAST - Fast Cyclic Redundancy Check Error Flag
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_FAST_SHIFT)) & CAN_ESR1_CRCERR_FAST_MASK)

#define CAN_ESR1_BIT0ERR_FAST_MASK               (0x40000000U)
#define CAN_ESR1_BIT0ERR_FAST_SHIFT              (30U)
/*! BIT0ERR_FAST - Fast Bit0 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit transmitted as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_FAST_SHIFT)) & CAN_ESR1_BIT0ERR_FAST_MASK)

#define CAN_ESR1_BIT1ERR_FAST_MASK               (0x80000000U)
#define CAN_ESR1_BIT1ERR_FAST_SHIFT              (31U)
/*! BIT1ERR_FAST - Fast Bit1 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit transmitted as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_FAST_SHIFT)) & CAN_ESR1_BIT1ERR_FAST_MASK)
/*! @} */

/*! @name IMASK1 - Interrupt Masks 1 */
/*! @{ */

#define CAN_IMASK1_BUF31TO0M_MASK                (0xFFFFFFFFU)
#define CAN_IMASK1_BUF31TO0M_SHIFT               (0U)
/*! BUF31TO0M - Buffer MBi Mask */
#define CAN_IMASK1_BUF31TO0M(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IMASK1_BUF31TO0M_SHIFT)) & CAN_IMASK1_BUF31TO0M_MASK)
/*! @} */

/*! @name IFLAG1 - Interrupt Flags 1 */
/*! @{ */

#define CAN_IFLAG1_BUF0I_MASK                    (0x1U)
#define CAN_IFLAG1_BUF0I_SHIFT                   (0U)
/*! BUF0I - Buffer MB0 Interrupt or Clear Legacy FIFO bit
 *  0b0..MB0 has no occurrence of successfully completed transmission or reception.
 *  0b1..MB0 has successfully completed transmission or reception.
 */
#define CAN_IFLAG1_BUF0I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF0I_SHIFT)) & CAN_IFLAG1_BUF0I_MASK)

#define CAN_IFLAG1_BUF4TO1I_MASK                 (0x1EU)
#define CAN_IFLAG1_BUF4TO1I_SHIFT                (1U)
/*! BUF4TO1I - Buffer MBi Interrupt or Reserved */
#define CAN_IFLAG1_BUF4TO1I(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF4TO1I_SHIFT)) & CAN_IFLAG1_BUF4TO1I_MASK)

#define CAN_IFLAG1_BUF5I_MASK                    (0x20U)
#define CAN_IFLAG1_BUF5I_SHIFT                   (5U)
/*! BUF5I - Buffer MB5 Interrupt or Frames available in Legacy RX FIFO
 *  0b0..No occurrence of completed transmission or reception, or no frames available
 *  0b1..MB5 completed transmission or reception, or frames available
 */
#define CAN_IFLAG1_BUF5I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF5I_SHIFT)) & CAN_IFLAG1_BUF5I_MASK)

#define CAN_IFLAG1_BUF6I_MASK                    (0x40U)
#define CAN_IFLAG1_BUF6I_SHIFT                   (6U)
/*! BUF6I - Buffer MB6 Interrupt or Legacy RX FIFO Warning
 *  0b0..No occurrence of MB6 completing transmission or reception, or FIFO not almost full.
 *  0b1..MB6 completed transmission or reception, or FIFO almost full.
 */
#define CAN_IFLAG1_BUF6I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF6I_SHIFT)) & CAN_IFLAG1_BUF6I_MASK)

#define CAN_IFLAG1_BUF7I_MASK                    (0x80U)
#define CAN_IFLAG1_BUF7I_SHIFT                   (7U)
/*! BUF7I - Buffer MB7 Interrupt or Legacy RX FIFO Overflow
 *  0b0..No occurrence of MB7 completing transmission or reception, or no FIFO overflow.
 *  0b1..MB7 completed transmission or reception, or FIFO overflow.
 */
#define CAN_IFLAG1_BUF7I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF7I_SHIFT)) & CAN_IFLAG1_BUF7I_MASK)

#define CAN_IFLAG1_BUF31TO8I_MASK                (0xFFFFFF00U)
#define CAN_IFLAG1_BUF31TO8I_SHIFT               (8U)
/*! BUF31TO8I - Buffer MBi Interrupt */
#define CAN_IFLAG1_BUF31TO8I(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF31TO8I_SHIFT)) & CAN_IFLAG1_BUF31TO8I_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 */
/*! @{ */

#define CAN_CTRL2_PES_MASK                       (0x1U)
#define CAN_CTRL2_PES_SHIFT                      (0U)
/*! PES - Payload Byte and Bit Order Selection
 *  0b0..Big-endian
 *  0b1..Little-endian
 */
#define CAN_CTRL2_PES(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PES_SHIFT)) & CAN_CTRL2_PES_MASK)

#define CAN_CTRL2_ASD_MASK                       (0x2U)
#define CAN_CTRL2_ASD_SHIFT                      (1U)
/*! ASD - ACK Suppression Disable
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define CAN_CTRL2_ASD(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ASD_SHIFT)) & CAN_CTRL2_ASD_MASK)

#define CAN_CTRL2_EDFLTDIS_MASK                  (0x800U)
#define CAN_CTRL2_EDFLTDIS_SHIFT                 (11U)
/*! EDFLTDIS - Edge Filter Disable
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define CAN_CTRL2_EDFLTDIS(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EDFLTDIS_SHIFT)) & CAN_CTRL2_EDFLTDIS_MASK)

#define CAN_CTRL2_ISOCANFDEN_MASK                (0x1000U)
#define CAN_CTRL2_ISOCANFDEN_SHIFT               (12U)
/*! ISOCANFDEN - ISO CAN FD Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_ISOCANFDEN(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ISOCANFDEN_SHIFT)) & CAN_CTRL2_ISOCANFDEN_MASK)

#define CAN_CTRL2_BTE_MASK                       (0x2000U)
#define CAN_CTRL2_BTE_SHIFT                      (13U)
/*! BTE - Bit Timing Expansion Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_BTE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BTE_SHIFT)) & CAN_CTRL2_BTE_MASK)

#define CAN_CTRL2_PREXCEN_MASK                   (0x4000U)
#define CAN_CTRL2_PREXCEN_SHIFT                  (14U)
/*! PREXCEN - Protocol Exception Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL2_PREXCEN(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PREXCEN_SHIFT)) & CAN_CTRL2_PREXCEN_MASK)

#define CAN_CTRL2_EACEN_MASK                     (0x10000U)
#define CAN_CTRL2_EACEN_SHIFT                    (16U)
/*! EACEN - Entire Frame Arbitration Field Comparison Enable for RX Message Buffers
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_EACEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EACEN_SHIFT)) & CAN_CTRL2_EACEN_MASK)

#define CAN_CTRL2_RRS_MASK                       (0x20000U)
#define CAN_CTRL2_RRS_SHIFT                      (17U)
/*! RRS - Remote Request Storing
 *  0b0..Generated
 *  0b1..Stored
 */
#define CAN_CTRL2_RRS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RRS_SHIFT)) & CAN_CTRL2_RRS_MASK)

#define CAN_CTRL2_MRP_MASK                       (0x40000U)
#define CAN_CTRL2_MRP_SHIFT                      (18U)
/*! MRP - Message Buffers Reception Priority
 *  0b0..Matching starts from Legacy RX FIFO or Enhanced RX FIFO and continues on message buffers.
 *  0b1..Matching starts from message buffers and continues on Legacy RX FIFO or Enhanced RX FIFO.
 */
#define CAN_CTRL2_MRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_MRP_SHIFT)) & CAN_CTRL2_MRP_MASK)

#define CAN_CTRL2_TASD_MASK                      (0xF80000U)
#define CAN_CTRL2_TASD_SHIFT                     (19U)
/*! TASD - Transmission Arbitration Start Delay */
#define CAN_CTRL2_TASD(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TASD_SHIFT)) & CAN_CTRL2_TASD_MASK)

#define CAN_CTRL2_RFFN_MASK                      (0xF000000U)
#define CAN_CTRL2_RFFN_SHIFT                     (24U)
/*! RFFN - Number of Legacy Receive FIFO Filters */
#define CAN_CTRL2_RFFN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RFFN_SHIFT)) & CAN_CTRL2_RFFN_MASK)

#define CAN_CTRL2_BOFFDONEMSK_MASK               (0x40000000U)
#define CAN_CTRL2_BOFFDONEMSK_SHIFT              (30U)
/*! BOFFDONEMSK - Bus Off Done Interrupt Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_BOFFDONEMSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BOFFDONEMSK_SHIFT)) & CAN_CTRL2_BOFFDONEMSK_MASK)

#define CAN_CTRL2_ERRMSK_FAST_MASK               (0x80000000U)
#define CAN_CTRL2_ERRMSK_FAST_SHIFT              (31U)
/*! ERRMSK_FAST - Error Interrupt Mask for Errors Detected in the Data Phase of Fast CAN FD Frames
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_ERRMSK_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ERRMSK_FAST_SHIFT)) & CAN_CTRL2_ERRMSK_FAST_MASK)
/*! @} */

/*! @name ESR2 - Error and Status 2 */
/*! @{ */

#define CAN_ESR2_IMB_MASK                        (0x2000U)
#define CAN_ESR2_IMB_SHIFT                       (13U)
/*! IMB - Inactive Message Buffer
 *  0b0..Message buffer indicated by ESR2[LPTM] is not inactive.
 *  0b1..At least one message buffer is inactive.
 */
#define CAN_ESR2_IMB(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_IMB_SHIFT)) & CAN_ESR2_IMB_MASK)

#define CAN_ESR2_VPS_MASK                        (0x4000U)
#define CAN_ESR2_VPS_SHIFT                       (14U)
/*! VPS - Valid Priority Status
 *  0b0..Invalid
 *  0b1..Valid
 */
#define CAN_ESR2_VPS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_VPS_SHIFT)) & CAN_ESR2_VPS_MASK)

#define CAN_ESR2_LPTM_MASK                       (0x7F0000U)
#define CAN_ESR2_LPTM_SHIFT                      (16U)
/*! LPTM - Lowest Priority TX Message Buffer */
#define CAN_ESR2_LPTM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_LPTM_SHIFT)) & CAN_ESR2_LPTM_MASK)
/*! @} */

/*! @name CRCR - Cyclic Redundancy Check */
/*! @{ */

#define CAN_CRCR_TXCRC_MASK                      (0x7FFFU)
#define CAN_CRCR_TXCRC_SHIFT                     (0U)
/*! TXCRC - Transmitted CRC value */
#define CAN_CRCR_TXCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_TXCRC_SHIFT)) & CAN_CRCR_TXCRC_MASK)

#define CAN_CRCR_MBCRC_MASK                      (0x7F0000U)
#define CAN_CRCR_MBCRC_SHIFT                     (16U)
/*! MBCRC - CRC Message Buffer */
#define CAN_CRCR_MBCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_MBCRC_SHIFT)) & CAN_CRCR_MBCRC_MASK)
/*! @} */

/*! @name RXFGMASK - Legacy RX FIFO Global Mask */
/*! @{ */

#define CAN_RXFGMASK_FGM_MASK                    (0xFFFFFFFFU)
#define CAN_RXFGMASK_FGM_SHIFT                   (0U)
/*! FGM - Legacy RX FIFO Global Mask Bits */
#define CAN_RXFGMASK_FGM(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_RXFGMASK_FGM_SHIFT)) & CAN_RXFGMASK_FGM_MASK)
/*! @} */

/*! @name RXFIR - Legacy RX FIFO Information */
/*! @{ */

#define CAN_RXFIR_IDHIT_MASK                     (0x1FFU)
#define CAN_RXFIR_IDHIT_SHIFT                    (0U)
/*! IDHIT - Identifier Acceptance Filter Hit Indicator */
#define CAN_RXFIR_IDHIT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXFIR_IDHIT_SHIFT)) & CAN_RXFIR_IDHIT_MASK)
/*! @} */

/*! @name CBT - CAN Bit Timing */
/*! @{ */

#define CAN_CBT_EPSEG2_MASK                      (0x1FU)
#define CAN_CBT_EPSEG2_SHIFT                     (0U)
/*! EPSEG2 - Extended Phase Segment 2 */
#define CAN_CBT_EPSEG2(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG2_SHIFT)) & CAN_CBT_EPSEG2_MASK)

#define CAN_CBT_EPSEG1_MASK                      (0x3E0U)
#define CAN_CBT_EPSEG1_SHIFT                     (5U)
/*! EPSEG1 - Extended Phase Segment 1 */
#define CAN_CBT_EPSEG1(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG1_SHIFT)) & CAN_CBT_EPSEG1_MASK)

#define CAN_CBT_EPROPSEG_MASK                    (0xFC00U)
#define CAN_CBT_EPROPSEG_SHIFT                   (10U)
/*! EPROPSEG - Extended Propagation Segment */
#define CAN_CBT_EPROPSEG(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPROPSEG_SHIFT)) & CAN_CBT_EPROPSEG_MASK)

#define CAN_CBT_ERJW_MASK                        (0x1F0000U)
#define CAN_CBT_ERJW_SHIFT                       (16U)
/*! ERJW - Extended Resync Jump Width */
#define CAN_CBT_ERJW(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CBT_ERJW_SHIFT)) & CAN_CBT_ERJW_MASK)

#define CAN_CBT_EPRESDIV_MASK                    (0x7FE00000U)
#define CAN_CBT_EPRESDIV_SHIFT                   (21U)
/*! EPRESDIV - Extended Prescaler Division Factor */
#define CAN_CBT_EPRESDIV(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPRESDIV_SHIFT)) & CAN_CBT_EPRESDIV_MASK)

#define CAN_CBT_BTF_MASK                         (0x80000000U)
#define CAN_CBT_BTF_SHIFT                        (31U)
/*! BTF - Bit Timing Format Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CBT_BTF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CBT_BTF_SHIFT)) & CAN_CBT_BTF_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB8B                        (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB8B                        (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B                      (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B2                     (2U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB16B                       (21U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB16B                       (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B                     (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B2                    (4U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB32B                       (12U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB32B                       (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B                     (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B2                    (8U)

/*! @name CS - Message Buffer 0 CS Register..Message Buffer 6 CS Register */
/*! @{ */

#define CAN_CS_TIME_STAMP_MASK                   (0xFFFFU)
#define CAN_CS_TIME_STAMP_SHIFT                  (0U)
/*! TIME_STAMP - Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running
 *    Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field
 *    appears on the CAN bus.
 */
#define CAN_CS_TIME_STAMP(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CS_TIME_STAMP_SHIFT)) & CAN_CS_TIME_STAMP_MASK)

#define CAN_CS_DLC_MASK                          (0xF0000U)
#define CAN_CS_DLC_SHIFT                         (16U)
/*! DLC - Length of the data to be stored/transmitted. */
#define CAN_CS_DLC(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_DLC_SHIFT)) & CAN_CS_DLC_MASK)

#define CAN_CS_RTR_MASK                          (0x100000U)
#define CAN_CS_RTR_SHIFT                         (20U)
/*! RTR - Remote Transmission Request. One/zero for remote/data frame. */
#define CAN_CS_RTR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_RTR_SHIFT)) & CAN_CS_RTR_MASK)

#define CAN_CS_IDE_MASK                          (0x200000U)
#define CAN_CS_IDE_SHIFT                         (21U)
/*! IDE - ID Extended. One/zero for extended/standard format frame. */
#define CAN_CS_IDE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_IDE_SHIFT)) & CAN_CS_IDE_MASK)

#define CAN_CS_SRR_MASK                          (0x400000U)
#define CAN_CS_SRR_SHIFT                         (22U)
/*! SRR - Substitute Remote Request. Contains a fixed recessive bit. */
#define CAN_CS_SRR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_SRR_SHIFT)) & CAN_CS_SRR_MASK)

#define CAN_CS_CODE_MASK                         (0xF000000U)
#define CAN_CS_CODE_SHIFT                        (24U)
/*! CODE - Message Buffer Code. This 4-bit field can be accessed (read or write) by the CPU and by
 *    the FlexCAN module itself, as part of the message buffer matching and arbitration process.
 */
#define CAN_CS_CODE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CS_CODE_SHIFT)) & CAN_CS_CODE_MASK)

#define CAN_CS_ESI_MASK                          (0x20000000U)
#define CAN_CS_ESI_SHIFT                         (29U)
/*! ESI - Error State Indicator. This bit indicates if the transmitting node is error active or error passive. */
#define CAN_CS_ESI(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_ESI_SHIFT)) & CAN_CS_ESI_MASK)

#define CAN_CS_BRS_MASK                          (0x40000000U)
#define CAN_CS_BRS_SHIFT                         (30U)
/*! BRS - Bit Rate Switch. This bit defines whether the bit rate is switched inside a CAN FD format frame. */
#define CAN_CS_BRS(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_BRS_SHIFT)) & CAN_CS_BRS_MASK)

#define CAN_CS_EDL_MASK                          (0x80000000U)
#define CAN_CS_EDL_SHIFT                         (31U)
/*! EDL - Extended Data Length. This bit distinguishes between CAN format and CAN FD format frames.
 *    The EDL bit must not be set for Message Buffers configured to RANSWER with code field 0b1010.
 */
#define CAN_CS_EDL(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_EDL_SHIFT)) & CAN_CS_EDL_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB64B                       (7U)

/*! @name ID - Message Buffer 0 ID Register..Message Buffer 6 ID Register */
/*! @{ */

#define CAN_ID_EXT_MASK                          (0x3FFFFU)
#define CAN_ID_EXT_SHIFT                         (0U)
/*! EXT - Contains extended (LOW word) identifier of message buffer. */
#define CAN_ID_EXT(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_EXT_SHIFT)) & CAN_ID_EXT_MASK)

#define CAN_ID_STD_MASK                          (0x1FFC0000U)
#define CAN_ID_STD_SHIFT                         (18U)
/*! STD - Contains standard/extended (HIGH word) identifier of message buffer. */
#define CAN_ID_STD(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_STD_SHIFT)) & CAN_ID_STD_MASK)

#define CAN_ID_PRIO_MASK                         (0xE0000000U)
#define CAN_ID_PRIO_SHIFT                        (29U)
/*! PRIO - Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only
 *    makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular
 *    ID to define the transmission priority.
 */
#define CAN_ID_PRIO(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ID_PRIO_SHIFT)) & CAN_ID_PRIO_MASK)
/*! @} */

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB64B                       (7U)

/*! @name WORD - Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register */
/*! @{ */

#define CAN_WORD_DATA_BYTE_3_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_3_SHIFT               (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_3(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_3_SHIFT)) & CAN_WORD_DATA_BYTE_3_MASK)

#define CAN_WORD_DATA_BYTE_7_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_7_SHIFT               (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_7(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_7_SHIFT)) & CAN_WORD_DATA_BYTE_7_MASK)

#define CAN_WORD_DATA_BYTE_11_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_11_SHIFT              (0U)
/*! DATA_BYTE_11 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_11(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_11_SHIFT)) & CAN_WORD_DATA_BYTE_11_MASK)

#define CAN_WORD_DATA_BYTE_15_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_15_SHIFT              (0U)
/*! DATA_BYTE_15 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_15(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_15_SHIFT)) & CAN_WORD_DATA_BYTE_15_MASK)

#define CAN_WORD_DATA_BYTE_19_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_19_SHIFT              (0U)
/*! DATA_BYTE_19 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_19(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_19_SHIFT)) & CAN_WORD_DATA_BYTE_19_MASK)

#define CAN_WORD_DATA_BYTE_23_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_23_SHIFT              (0U)
/*! DATA_BYTE_23 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_23(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_23_SHIFT)) & CAN_WORD_DATA_BYTE_23_MASK)

#define CAN_WORD_DATA_BYTE_27_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_27_SHIFT              (0U)
/*! DATA_BYTE_27 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_27(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_27_SHIFT)) & CAN_WORD_DATA_BYTE_27_MASK)

#define CAN_WORD_DATA_BYTE_31_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_31_SHIFT              (0U)
/*! DATA_BYTE_31 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_31(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_31_SHIFT)) & CAN_WORD_DATA_BYTE_31_MASK)

#define CAN_WORD_DATA_BYTE_35_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_35_SHIFT              (0U)
/*! DATA_BYTE_35 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_35(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_35_SHIFT)) & CAN_WORD_DATA_BYTE_35_MASK)

#define CAN_WORD_DATA_BYTE_39_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_39_SHIFT              (0U)
/*! DATA_BYTE_39 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_39(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_39_SHIFT)) & CAN_WORD_DATA_BYTE_39_MASK)

#define CAN_WORD_DATA_BYTE_43_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_43_SHIFT              (0U)
/*! DATA_BYTE_43 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_43(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_43_SHIFT)) & CAN_WORD_DATA_BYTE_43_MASK)

#define CAN_WORD_DATA_BYTE_47_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_47_SHIFT              (0U)
/*! DATA_BYTE_47 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_47(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_47_SHIFT)) & CAN_WORD_DATA_BYTE_47_MASK)

#define CAN_WORD_DATA_BYTE_51_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_51_SHIFT              (0U)
/*! DATA_BYTE_51 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_51(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_51_SHIFT)) & CAN_WORD_DATA_BYTE_51_MASK)

#define CAN_WORD_DATA_BYTE_55_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_55_SHIFT              (0U)
/*! DATA_BYTE_55 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_55(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_55_SHIFT)) & CAN_WORD_DATA_BYTE_55_MASK)

#define CAN_WORD_DATA_BYTE_59_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_59_SHIFT              (0U)
/*! DATA_BYTE_59 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_59(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_59_SHIFT)) & CAN_WORD_DATA_BYTE_59_MASK)

#define CAN_WORD_DATA_BYTE_63_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_63_SHIFT              (0U)
/*! DATA_BYTE_63 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_63(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_63_SHIFT)) & CAN_WORD_DATA_BYTE_63_MASK)

#define CAN_WORD_DATA_BYTE_2_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_2_SHIFT               (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_2(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_2_SHIFT)) & CAN_WORD_DATA_BYTE_2_MASK)

#define CAN_WORD_DATA_BYTE_6_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_6_SHIFT               (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_6(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_6_SHIFT)) & CAN_WORD_DATA_BYTE_6_MASK)

#define CAN_WORD_DATA_BYTE_10_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_10_SHIFT              (8U)
/*! DATA_BYTE_10 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_10(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_10_SHIFT)) & CAN_WORD_DATA_BYTE_10_MASK)

#define CAN_WORD_DATA_BYTE_14_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_14_SHIFT              (8U)
/*! DATA_BYTE_14 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_14(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_14_SHIFT)) & CAN_WORD_DATA_BYTE_14_MASK)

#define CAN_WORD_DATA_BYTE_18_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_18_SHIFT              (8U)
/*! DATA_BYTE_18 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_18(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_18_SHIFT)) & CAN_WORD_DATA_BYTE_18_MASK)

#define CAN_WORD_DATA_BYTE_22_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_22_SHIFT              (8U)
/*! DATA_BYTE_22 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_22(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_22_SHIFT)) & CAN_WORD_DATA_BYTE_22_MASK)

#define CAN_WORD_DATA_BYTE_26_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_26_SHIFT              (8U)
/*! DATA_BYTE_26 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_26(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_26_SHIFT)) & CAN_WORD_DATA_BYTE_26_MASK)

#define CAN_WORD_DATA_BYTE_30_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_30_SHIFT              (8U)
/*! DATA_BYTE_30 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_30(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_30_SHIFT)) & CAN_WORD_DATA_BYTE_30_MASK)

#define CAN_WORD_DATA_BYTE_34_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_34_SHIFT              (8U)
/*! DATA_BYTE_34 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_34(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_34_SHIFT)) & CAN_WORD_DATA_BYTE_34_MASK)

#define CAN_WORD_DATA_BYTE_38_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_38_SHIFT              (8U)
/*! DATA_BYTE_38 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_38(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_38_SHIFT)) & CAN_WORD_DATA_BYTE_38_MASK)

#define CAN_WORD_DATA_BYTE_42_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_42_SHIFT              (8U)
/*! DATA_BYTE_42 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_42(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_42_SHIFT)) & CAN_WORD_DATA_BYTE_42_MASK)

#define CAN_WORD_DATA_BYTE_46_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_46_SHIFT              (8U)
/*! DATA_BYTE_46 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_46(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_46_SHIFT)) & CAN_WORD_DATA_BYTE_46_MASK)

#define CAN_WORD_DATA_BYTE_50_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_50_SHIFT              (8U)
/*! DATA_BYTE_50 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_50(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_50_SHIFT)) & CAN_WORD_DATA_BYTE_50_MASK)

#define CAN_WORD_DATA_BYTE_54_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_54_SHIFT              (8U)
/*! DATA_BYTE_54 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_54(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_54_SHIFT)) & CAN_WORD_DATA_BYTE_54_MASK)

#define CAN_WORD_DATA_BYTE_58_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_58_SHIFT              (8U)
/*! DATA_BYTE_58 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_58(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_58_SHIFT)) & CAN_WORD_DATA_BYTE_58_MASK)

#define CAN_WORD_DATA_BYTE_62_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_62_SHIFT              (8U)
/*! DATA_BYTE_62 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_62(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_62_SHIFT)) & CAN_WORD_DATA_BYTE_62_MASK)

#define CAN_WORD_DATA_BYTE_1_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_1_SHIFT               (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_1(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_1_SHIFT)) & CAN_WORD_DATA_BYTE_1_MASK)

#define CAN_WORD_DATA_BYTE_5_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_5_SHIFT               (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_5(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_5_SHIFT)) & CAN_WORD_DATA_BYTE_5_MASK)

#define CAN_WORD_DATA_BYTE_9_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_9_SHIFT               (16U)
/*! DATA_BYTE_9 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_9(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_9_SHIFT)) & CAN_WORD_DATA_BYTE_9_MASK)

#define CAN_WORD_DATA_BYTE_13_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_13_SHIFT              (16U)
/*! DATA_BYTE_13 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_13(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_13_SHIFT)) & CAN_WORD_DATA_BYTE_13_MASK)

#define CAN_WORD_DATA_BYTE_17_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_17_SHIFT              (16U)
/*! DATA_BYTE_17 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_17(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_17_SHIFT)) & CAN_WORD_DATA_BYTE_17_MASK)

#define CAN_WORD_DATA_BYTE_21_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_21_SHIFT              (16U)
/*! DATA_BYTE_21 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_21(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_21_SHIFT)) & CAN_WORD_DATA_BYTE_21_MASK)

#define CAN_WORD_DATA_BYTE_25_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_25_SHIFT              (16U)
/*! DATA_BYTE_25 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_25(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_25_SHIFT)) & CAN_WORD_DATA_BYTE_25_MASK)

#define CAN_WORD_DATA_BYTE_29_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_29_SHIFT              (16U)
/*! DATA_BYTE_29 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_29(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_29_SHIFT)) & CAN_WORD_DATA_BYTE_29_MASK)

#define CAN_WORD_DATA_BYTE_33_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_33_SHIFT              (16U)
/*! DATA_BYTE_33 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_33(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_33_SHIFT)) & CAN_WORD_DATA_BYTE_33_MASK)

#define CAN_WORD_DATA_BYTE_37_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_37_SHIFT              (16U)
/*! DATA_BYTE_37 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_37(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_37_SHIFT)) & CAN_WORD_DATA_BYTE_37_MASK)

#define CAN_WORD_DATA_BYTE_41_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_41_SHIFT              (16U)
/*! DATA_BYTE_41 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_41(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_41_SHIFT)) & CAN_WORD_DATA_BYTE_41_MASK)

#define CAN_WORD_DATA_BYTE_45_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_45_SHIFT              (16U)
/*! DATA_BYTE_45 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_45(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_45_SHIFT)) & CAN_WORD_DATA_BYTE_45_MASK)

#define CAN_WORD_DATA_BYTE_49_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_49_SHIFT              (16U)
/*! DATA_BYTE_49 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_49(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_49_SHIFT)) & CAN_WORD_DATA_BYTE_49_MASK)

#define CAN_WORD_DATA_BYTE_53_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_53_SHIFT              (16U)
/*! DATA_BYTE_53 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_53(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_53_SHIFT)) & CAN_WORD_DATA_BYTE_53_MASK)

#define CAN_WORD_DATA_BYTE_57_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_57_SHIFT              (16U)
/*! DATA_BYTE_57 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_57(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_57_SHIFT)) & CAN_WORD_DATA_BYTE_57_MASK)

#define CAN_WORD_DATA_BYTE_61_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_61_SHIFT              (16U)
/*! DATA_BYTE_61 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_61(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_61_SHIFT)) & CAN_WORD_DATA_BYTE_61_MASK)

#define CAN_WORD_DATA_BYTE_0_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_0_SHIFT               (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_0(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_0_SHIFT)) & CAN_WORD_DATA_BYTE_0_MASK)

#define CAN_WORD_DATA_BYTE_4_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_4_SHIFT               (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_4(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_4_SHIFT)) & CAN_WORD_DATA_BYTE_4_MASK)

#define CAN_WORD_DATA_BYTE_8_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_8_SHIFT               (24U)
/*! DATA_BYTE_8 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_8(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_8_SHIFT)) & CAN_WORD_DATA_BYTE_8_MASK)

#define CAN_WORD_DATA_BYTE_12_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_12_SHIFT              (24U)
/*! DATA_BYTE_12 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_12(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_12_SHIFT)) & CAN_WORD_DATA_BYTE_12_MASK)

#define CAN_WORD_DATA_BYTE_16_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_16_SHIFT              (24U)
/*! DATA_BYTE_16 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_16(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_16_SHIFT)) & CAN_WORD_DATA_BYTE_16_MASK)

#define CAN_WORD_DATA_BYTE_20_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_20_SHIFT              (24U)
/*! DATA_BYTE_20 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_20(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_20_SHIFT)) & CAN_WORD_DATA_BYTE_20_MASK)

#define CAN_WORD_DATA_BYTE_24_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_24_SHIFT              (24U)
/*! DATA_BYTE_24 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_24(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_24_SHIFT)) & CAN_WORD_DATA_BYTE_24_MASK)

#define CAN_WORD_DATA_BYTE_28_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_28_SHIFT              (24U)
/*! DATA_BYTE_28 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_28(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_28_SHIFT)) & CAN_WORD_DATA_BYTE_28_MASK)

#define CAN_WORD_DATA_BYTE_32_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_32_SHIFT              (24U)
/*! DATA_BYTE_32 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_32(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_32_SHIFT)) & CAN_WORD_DATA_BYTE_32_MASK)

#define CAN_WORD_DATA_BYTE_36_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_36_SHIFT              (24U)
/*! DATA_BYTE_36 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_36(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_36_SHIFT)) & CAN_WORD_DATA_BYTE_36_MASK)

#define CAN_WORD_DATA_BYTE_40_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_40_SHIFT              (24U)
/*! DATA_BYTE_40 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_40(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_40_SHIFT)) & CAN_WORD_DATA_BYTE_40_MASK)

#define CAN_WORD_DATA_BYTE_44_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_44_SHIFT              (24U)
/*! DATA_BYTE_44 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_44(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_44_SHIFT)) & CAN_WORD_DATA_BYTE_44_MASK)

#define CAN_WORD_DATA_BYTE_48_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_48_SHIFT              (24U)
/*! DATA_BYTE_48 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_48(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_48_SHIFT)) & CAN_WORD_DATA_BYTE_48_MASK)

#define CAN_WORD_DATA_BYTE_52_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_52_SHIFT              (24U)
/*! DATA_BYTE_52 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_52(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_52_SHIFT)) & CAN_WORD_DATA_BYTE_52_MASK)

#define CAN_WORD_DATA_BYTE_56_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_56_SHIFT              (24U)
/*! DATA_BYTE_56 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_56(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_56_SHIFT)) & CAN_WORD_DATA_BYTE_56_MASK)

#define CAN_WORD_DATA_BYTE_60_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_60_SHIFT              (24U)
/*! DATA_BYTE_60 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_60(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_60_SHIFT)) & CAN_WORD_DATA_BYTE_60_MASK)
/*! @} */

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B                     (7U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B2                    (16U)

/* The count of CAN_CS */
#define CAN_CS_COUNT                             (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT                             (32U)

/*! @name WORD0 - Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register */
/*! @{ */

#define CAN_WORD0_DATA_BYTE_3_MASK               (0xFFU)
#define CAN_WORD0_DATA_BYTE_3_SHIFT              (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_3(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_3_SHIFT)) & CAN_WORD0_DATA_BYTE_3_MASK)

#define CAN_WORD0_DATA_BYTE_2_MASK               (0xFF00U)
#define CAN_WORD0_DATA_BYTE_2_SHIFT              (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_2(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_2_SHIFT)) & CAN_WORD0_DATA_BYTE_2_MASK)

#define CAN_WORD0_DATA_BYTE_1_MASK               (0xFF0000U)
#define CAN_WORD0_DATA_BYTE_1_SHIFT              (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_1(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_1_SHIFT)) & CAN_WORD0_DATA_BYTE_1_MASK)

#define CAN_WORD0_DATA_BYTE_0_MASK               (0xFF000000U)
#define CAN_WORD0_DATA_BYTE_0_SHIFT              (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_0(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_0_SHIFT)) & CAN_WORD0_DATA_BYTE_0_MASK)
/*! @} */

/* The count of CAN_WORD0 */
#define CAN_WORD0_COUNT                          (32U)

/*! @name WORD1 - Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register */
/*! @{ */

#define CAN_WORD1_DATA_BYTE_7_MASK               (0xFFU)
#define CAN_WORD1_DATA_BYTE_7_SHIFT              (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_7(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_7_SHIFT)) & CAN_WORD1_DATA_BYTE_7_MASK)

#define CAN_WORD1_DATA_BYTE_6_MASK               (0xFF00U)
#define CAN_WORD1_DATA_BYTE_6_SHIFT              (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_6(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_6_SHIFT)) & CAN_WORD1_DATA_BYTE_6_MASK)

#define CAN_WORD1_DATA_BYTE_5_MASK               (0xFF0000U)
#define CAN_WORD1_DATA_BYTE_5_SHIFT              (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_5(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_5_SHIFT)) & CAN_WORD1_DATA_BYTE_5_MASK)

#define CAN_WORD1_DATA_BYTE_4_MASK               (0xFF000000U)
#define CAN_WORD1_DATA_BYTE_4_SHIFT              (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_4(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_4_SHIFT)) & CAN_WORD1_DATA_BYTE_4_MASK)
/*! @} */

/* The count of CAN_WORD1 */
#define CAN_WORD1_COUNT                          (32U)

/*! @name RXIMR - Receive Individual Mask */
/*! @{ */

#define CAN_RXIMR_MI_MASK                        (0xFFFFFFFFU)
#define CAN_RXIMR_MI_SHIFT                       (0U)
/*! MI - Individual Mask Bits */
#define CAN_RXIMR_MI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_RXIMR_MI_SHIFT)) & CAN_RXIMR_MI_MASK)
/*! @} */

/* The count of CAN_RXIMR */
#define CAN_RXIMR_COUNT                          (32U)

/*! @name CTRL1_PN - Pretended Networking Control 1 */
/*! @{ */

#define CAN_CTRL1_PN_FCS_MASK                    (0x3U)
#define CAN_CTRL1_PN_FCS_SHIFT                   (0U)
/*! FCS - Filtering Combination Selection
 *  0b00..Message ID filtering only
 *  0b01..Message ID filtering and payload filtering
 *  0b10..Message ID filtering occurring a specified number of times
 *  0b11..Message ID filtering and payload filtering a specified number of times
 */
#define CAN_CTRL1_PN_FCS(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_FCS_SHIFT)) & CAN_CTRL1_PN_FCS_MASK)

#define CAN_CTRL1_PN_IDFS_MASK                   (0xCU)
#define CAN_CTRL1_PN_IDFS_SHIFT                  (2U)
/*! IDFS - ID Filtering Selection
 *  0b00..Match ID contents to an exact target value
 *  0b01..Match an ID value greater than or equal to a specified target value
 *  0b10..Match an ID value smaller than or equal to a specified target value
 *  0b11..Match an ID value within a range of values, inclusive
 */
#define CAN_CTRL1_PN_IDFS(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_IDFS_SHIFT)) & CAN_CTRL1_PN_IDFS_MASK)

#define CAN_CTRL1_PN_PLFS_MASK                   (0x30U)
#define CAN_CTRL1_PN_PLFS_SHIFT                  (4U)
/*! PLFS - Payload Filtering Selection
 *  0b00..Match payload contents to an exact target value
 *  0b01..Match a payload value greater than or equal to a specified target value
 *  0b10..Match a payload value smaller than or equal to a specified target value
 *  0b11..Match upon a payload value within a range of values, inclusive
 */
#define CAN_CTRL1_PN_PLFS(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_PLFS_SHIFT)) & CAN_CTRL1_PN_PLFS_MASK)

#define CAN_CTRL1_PN_NMATCH_MASK                 (0xFF00U)
#define CAN_CTRL1_PN_NMATCH_SHIFT                (8U)
/*! NMATCH - Number of Messages Matching the Same Filtering Criteria
 *  0b00000001..Once
 *  0b00000010..Twice
 *  0b11111111..255 times
 */
#define CAN_CTRL1_PN_NMATCH(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_NMATCH_SHIFT)) & CAN_CTRL1_PN_NMATCH_MASK)

#define CAN_CTRL1_PN_WUMF_MSK_MASK               (0x10000U)
#define CAN_CTRL1_PN_WUMF_MSK_SHIFT              (16U)
/*! WUMF_MSK - Wake-up by Matching Flag Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_PN_WUMF_MSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_WUMF_MSK_SHIFT)) & CAN_CTRL1_PN_WUMF_MSK_MASK)

#define CAN_CTRL1_PN_WTOF_MSK_MASK               (0x20000U)
#define CAN_CTRL1_PN_WTOF_MSK_SHIFT              (17U)
/*! WTOF_MSK - Wake-up by Timeout Flag Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_PN_WTOF_MSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_WTOF_MSK_SHIFT)) & CAN_CTRL1_PN_WTOF_MSK_MASK)
/*! @} */

/*! @name CTRL2_PN - Pretended Networking Control 2 */
/*! @{ */

#define CAN_CTRL2_PN_MATCHTO_MASK                (0xFFFFU)
#define CAN_CTRL2_PN_MATCHTO_SHIFT               (0U)
/*! MATCHTO - Timeout for No Message Matching the Filtering Criteria */
#define CAN_CTRL2_PN_MATCHTO(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PN_MATCHTO_SHIFT)) & CAN_CTRL2_PN_MATCHTO_MASK)
/*! @} */

/*! @name WU_MTC - Pretended Networking Wake-Up Match */
/*! @{ */

#define CAN_WU_MTC_MCOUNTER_MASK                 (0xFF00U)
#define CAN_WU_MTC_MCOUNTER_SHIFT                (8U)
/*! MCOUNTER - Number of Matches in Pretended Networking */
#define CAN_WU_MTC_MCOUNTER(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_MCOUNTER_SHIFT)) & CAN_WU_MTC_MCOUNTER_MASK)

#define CAN_WU_MTC_WUMF_MASK                     (0x10000U)
#define CAN_WU_MTC_WUMF_SHIFT                    (16U)
/*! WUMF - Wake-up by Match Flag
 *  0b0..No event detected
 *  0b1..Event detected
 */
#define CAN_WU_MTC_WUMF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_WUMF_SHIFT)) & CAN_WU_MTC_WUMF_MASK)

#define CAN_WU_MTC_WTOF_MASK                     (0x20000U)
#define CAN_WU_MTC_WTOF_SHIFT                    (17U)
/*! WTOF - Wake-up by Timeout Flag Bit
 *  0b0..No event detected
 *  0b1..Event detected
 */
#define CAN_WU_MTC_WTOF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_WTOF_SHIFT)) & CAN_WU_MTC_WTOF_MASK)
/*! @} */

/*! @name FLT_ID1 - Pretended Networking ID Filter 1 */
/*! @{ */

#define CAN_FLT_ID1_FLT_ID1_MASK                 (0x1FFFFFFFU)
#define CAN_FLT_ID1_FLT_ID1_SHIFT                (0U)
/*! FLT_ID1 - ID Filter 1 for Pretended Networking filtering */
#define CAN_FLT_ID1_FLT_ID1(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_ID1_SHIFT)) & CAN_FLT_ID1_FLT_ID1_MASK)

#define CAN_FLT_ID1_FLT_RTR_MASK                 (0x20000000U)
#define CAN_FLT_ID1_FLT_RTR_SHIFT                (29U)
/*! FLT_RTR - Remote Transmission Request Filter
 *  0b0..Reject remote frame (accept data frame)
 *  0b1..Accept remote frame
 */
#define CAN_FLT_ID1_FLT_RTR(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_RTR_SHIFT)) & CAN_FLT_ID1_FLT_RTR_MASK)

#define CAN_FLT_ID1_FLT_IDE_MASK                 (0x40000000U)
#define CAN_FLT_ID1_FLT_IDE_SHIFT                (30U)
/*! FLT_IDE - ID Extended Filter
 *  0b0..Standard
 *  0b1..Extended
 */
#define CAN_FLT_ID1_FLT_IDE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_IDE_SHIFT)) & CAN_FLT_ID1_FLT_IDE_MASK)
/*! @} */

/*! @name FLT_DLC - Pretended Networking Data Length Code (DLC) Filter */
/*! @{ */

#define CAN_FLT_DLC_FLT_DLC_HI_MASK              (0xFU)
#define CAN_FLT_DLC_FLT_DLC_HI_SHIFT             (0U)
/*! FLT_DLC_HI - Upper Limit for Length of Data Bytes Filter */
#define CAN_FLT_DLC_FLT_DLC_HI(x)                (((uint32_t)(((uint32_t)(x)) << CAN_FLT_DLC_FLT_DLC_HI_SHIFT)) & CAN_FLT_DLC_FLT_DLC_HI_MASK)

#define CAN_FLT_DLC_FLT_DLC_LO_MASK              (0xF0000U)
#define CAN_FLT_DLC_FLT_DLC_LO_SHIFT             (16U)
/*! FLT_DLC_LO - Lower Limit for Length of Data Bytes Filter */
#define CAN_FLT_DLC_FLT_DLC_LO(x)                (((uint32_t)(((uint32_t)(x)) << CAN_FLT_DLC_FLT_DLC_LO_SHIFT)) & CAN_FLT_DLC_FLT_DLC_LO_MASK)
/*! @} */

/*! @name PL1_LO - Pretended Networking Payload Low Filter 1 */
/*! @{ */

#define CAN_PL1_LO_Data_byte_3_MASK              (0xFFU)
#define CAN_PL1_LO_Data_byte_3_SHIFT             (0U)
/*! Data_byte_3 - Data byte 3 */
#define CAN_PL1_LO_Data_byte_3(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_3_SHIFT)) & CAN_PL1_LO_Data_byte_3_MASK)

#define CAN_PL1_LO_Data_byte_2_MASK              (0xFF00U)
#define CAN_PL1_LO_Data_byte_2_SHIFT             (8U)
/*! Data_byte_2 - Data byte 2 */
#define CAN_PL1_LO_Data_byte_2(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_2_SHIFT)) & CAN_PL1_LO_Data_byte_2_MASK)

#define CAN_PL1_LO_Data_byte_1_MASK              (0xFF0000U)
#define CAN_PL1_LO_Data_byte_1_SHIFT             (16U)
/*! Data_byte_1 - Data byte 1 */
#define CAN_PL1_LO_Data_byte_1(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_1_SHIFT)) & CAN_PL1_LO_Data_byte_1_MASK)

#define CAN_PL1_LO_Data_byte_0_MASK              (0xFF000000U)
#define CAN_PL1_LO_Data_byte_0_SHIFT             (24U)
/*! Data_byte_0 - Data byte 0 */
#define CAN_PL1_LO_Data_byte_0(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_0_SHIFT)) & CAN_PL1_LO_Data_byte_0_MASK)
/*! @} */

/*! @name PL1_HI - Pretended Networking Payload High Filter 1 */
/*! @{ */

#define CAN_PL1_HI_Data_byte_7_MASK              (0xFFU)
#define CAN_PL1_HI_Data_byte_7_SHIFT             (0U)
/*! Data_byte_7 - Data byte 7 */
#define CAN_PL1_HI_Data_byte_7(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_7_SHIFT)) & CAN_PL1_HI_Data_byte_7_MASK)

#define CAN_PL1_HI_Data_byte_6_MASK              (0xFF00U)
#define CAN_PL1_HI_Data_byte_6_SHIFT             (8U)
/*! Data_byte_6 - Data byte 6 */
#define CAN_PL1_HI_Data_byte_6(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_6_SHIFT)) & CAN_PL1_HI_Data_byte_6_MASK)

#define CAN_PL1_HI_Data_byte_5_MASK              (0xFF0000U)
#define CAN_PL1_HI_Data_byte_5_SHIFT             (16U)
/*! Data_byte_5 - Data byte 5 */
#define CAN_PL1_HI_Data_byte_5(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_5_SHIFT)) & CAN_PL1_HI_Data_byte_5_MASK)

#define CAN_PL1_HI_Data_byte_4_MASK              (0xFF000000U)
#define CAN_PL1_HI_Data_byte_4_SHIFT             (24U)
/*! Data_byte_4 - Data byte 4 */
#define CAN_PL1_HI_Data_byte_4(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_4_SHIFT)) & CAN_PL1_HI_Data_byte_4_MASK)
/*! @} */

/*! @name FLT_ID2_IDMASK - Pretended Networking ID Filter 2 or ID Mask */
/*! @{ */

#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_MASK   (0x1FFFFFFFU)
#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_SHIFT  (0U)
/*! FLT_ID2_IDMASK - ID Filter 2 for Pretended Networking Filtering or ID Mask Bits for Pretended Networking ID Filtering */
#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK(x)     (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_SHIFT)) & CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_MASK)

#define CAN_FLT_ID2_IDMASK_RTR_MSK_MASK          (0x20000000U)
#define CAN_FLT_ID2_IDMASK_RTR_MSK_SHIFT         (29U)
/*! RTR_MSK - Remote Transmission Request Mask
 *  0b0..The corresponding bit in the filter is "don't care."
 *  0b1..The corresponding bit in the filter is checked.
 */
#define CAN_FLT_ID2_IDMASK_RTR_MSK(x)            (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_RTR_MSK_SHIFT)) & CAN_FLT_ID2_IDMASK_RTR_MSK_MASK)

#define CAN_FLT_ID2_IDMASK_IDE_MSK_MASK          (0x40000000U)
#define CAN_FLT_ID2_IDMASK_IDE_MSK_SHIFT         (30U)
/*! IDE_MSK - ID Extended Mask
 *  0b0..The corresponding bit in the filter is "don't care."
 *  0b1..The corresponding bit in the filter is checked.
 */
#define CAN_FLT_ID2_IDMASK_IDE_MSK(x)            (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_IDE_MSK_SHIFT)) & CAN_FLT_ID2_IDMASK_IDE_MSK_MASK)
/*! @} */

/*! @name PL2_PLMASK_LO - Pretended Networking Payload Low Filter 2 and Payload Low Mask */
/*! @{ */

#define CAN_PL2_PLMASK_LO_Data_byte_3_MASK       (0xFFU)
#define CAN_PL2_PLMASK_LO_Data_byte_3_SHIFT      (0U)
/*! Data_byte_3 - Data Byte 3 */
#define CAN_PL2_PLMASK_LO_Data_byte_3(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_3_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_3_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_2_MASK       (0xFF00U)
#define CAN_PL2_PLMASK_LO_Data_byte_2_SHIFT      (8U)
/*! Data_byte_2 - Data Byte 2 */
#define CAN_PL2_PLMASK_LO_Data_byte_2(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_2_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_2_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_1_MASK       (0xFF0000U)
#define CAN_PL2_PLMASK_LO_Data_byte_1_SHIFT      (16U)
/*! Data_byte_1 - Data Byte 1 */
#define CAN_PL2_PLMASK_LO_Data_byte_1(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_1_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_1_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_0_MASK       (0xFF000000U)
#define CAN_PL2_PLMASK_LO_Data_byte_0_SHIFT      (24U)
/*! Data_byte_0 - Data Byte 0 */
#define CAN_PL2_PLMASK_LO_Data_byte_0(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_0_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_0_MASK)
/*! @} */

/*! @name PL2_PLMASK_HI - Pretended Networking Payload High Filter 2 and Payload High Mask */
/*! @{ */

#define CAN_PL2_PLMASK_HI_Data_byte_7_MASK       (0xFFU)
#define CAN_PL2_PLMASK_HI_Data_byte_7_SHIFT      (0U)
/*! Data_byte_7 - Data Byte 7 */
#define CAN_PL2_PLMASK_HI_Data_byte_7(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_7_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_7_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_6_MASK       (0xFF00U)
#define CAN_PL2_PLMASK_HI_Data_byte_6_SHIFT      (8U)
/*! Data_byte_6 - Data Byte 6 */
#define CAN_PL2_PLMASK_HI_Data_byte_6(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_6_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_6_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_5_MASK       (0xFF0000U)
#define CAN_PL2_PLMASK_HI_Data_byte_5_SHIFT      (16U)
/*! Data_byte_5 - Data Byte 5 */
#define CAN_PL2_PLMASK_HI_Data_byte_5(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_5_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_5_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_4_MASK       (0xFF000000U)
#define CAN_PL2_PLMASK_HI_Data_byte_4_SHIFT      (24U)
/*! Data_byte_4 - Data Byte 4 */
#define CAN_PL2_PLMASK_HI_Data_byte_4(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_4_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_4_MASK)
/*! @} */

/*! @name WMB_CS - Wake-Up Message Buffer */
/*! @{ */

#define CAN_WMB_CS_DLC_MASK                      (0xF0000U)
#define CAN_WMB_CS_DLC_SHIFT                     (16U)
/*! DLC - Length of Data in Bytes */
#define CAN_WMB_CS_DLC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_DLC_SHIFT)) & CAN_WMB_CS_DLC_MASK)

#define CAN_WMB_CS_RTR_MASK                      (0x100000U)
#define CAN_WMB_CS_RTR_SHIFT                     (20U)
/*! RTR - Remote Transmission Request
 *  0b0..Data
 *  0b1..Remote
 */
#define CAN_WMB_CS_RTR(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_RTR_SHIFT)) & CAN_WMB_CS_RTR_MASK)

#define CAN_WMB_CS_IDE_MASK                      (0x200000U)
#define CAN_WMB_CS_IDE_SHIFT                     (21U)
/*! IDE - ID Extended Bit
 *  0b0..Standard
 *  0b1..Extended
 */
#define CAN_WMB_CS_IDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_IDE_SHIFT)) & CAN_WMB_CS_IDE_MASK)

#define CAN_WMB_CS_SRR_MASK                      (0x400000U)
#define CAN_WMB_CS_SRR_SHIFT                     (22U)
/*! SRR - Substitute Remote Request
 *  0b0..Dominant
 *  0b1..Recessive
 */
#define CAN_WMB_CS_SRR(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_SRR_SHIFT)) & CAN_WMB_CS_SRR_MASK)
/*! @} */

/* The count of CAN_WMB_CS */
#define CAN_WMB_CS_COUNT                         (4U)

/*! @name WMB_ID - Wake-Up Message Buffer for ID */
/*! @{ */

#define CAN_WMB_ID_ID_MASK                       (0x1FFFFFFFU)
#define CAN_WMB_ID_ID_SHIFT                      (0U)
/*! ID - Received ID in Pretended Networking Mode */
#define CAN_WMB_ID_ID(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_WMB_ID_ID_SHIFT)) & CAN_WMB_ID_ID_MASK)
/*! @} */

/* The count of CAN_WMB_ID */
#define CAN_WMB_ID_COUNT                         (4U)

/*! @name WMB_D03 - Wake-Up Message Buffer for Data 0-3 */
/*! @{ */

#define CAN_WMB_D03_Data_byte_3_MASK             (0xFFU)
#define CAN_WMB_D03_Data_byte_3_SHIFT            (0U)
/*! Data_byte_3 - Data Byte 3 */
#define CAN_WMB_D03_Data_byte_3(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_3_SHIFT)) & CAN_WMB_D03_Data_byte_3_MASK)

#define CAN_WMB_D03_Data_byte_2_MASK             (0xFF00U)
#define CAN_WMB_D03_Data_byte_2_SHIFT            (8U)
/*! Data_byte_2 - Data Byte 2 */
#define CAN_WMB_D03_Data_byte_2(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_2_SHIFT)) & CAN_WMB_D03_Data_byte_2_MASK)

#define CAN_WMB_D03_Data_byte_1_MASK             (0xFF0000U)
#define CAN_WMB_D03_Data_byte_1_SHIFT            (16U)
/*! Data_byte_1 - Data Byte 1 */
#define CAN_WMB_D03_Data_byte_1(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_1_SHIFT)) & CAN_WMB_D03_Data_byte_1_MASK)

#define CAN_WMB_D03_Data_byte_0_MASK             (0xFF000000U)
#define CAN_WMB_D03_Data_byte_0_SHIFT            (24U)
/*! Data_byte_0 - Data Byte 0 */
#define CAN_WMB_D03_Data_byte_0(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_0_SHIFT)) & CAN_WMB_D03_Data_byte_0_MASK)
/*! @} */

/* The count of CAN_WMB_D03 */
#define CAN_WMB_D03_COUNT                        (4U)

/*! @name WMB_D47 - Wake-Up Message Buffer Register Data 4-7 */
/*! @{ */

#define CAN_WMB_D47_Data_byte_7_MASK             (0xFFU)
#define CAN_WMB_D47_Data_byte_7_SHIFT            (0U)
/*! Data_byte_7 - Data Byte 7 */
#define CAN_WMB_D47_Data_byte_7(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_7_SHIFT)) & CAN_WMB_D47_Data_byte_7_MASK)

#define CAN_WMB_D47_Data_byte_6_MASK             (0xFF00U)
#define CAN_WMB_D47_Data_byte_6_SHIFT            (8U)
/*! Data_byte_6 - Data Byte 6 */
#define CAN_WMB_D47_Data_byte_6(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_6_SHIFT)) & CAN_WMB_D47_Data_byte_6_MASK)

#define CAN_WMB_D47_Data_byte_5_MASK             (0xFF0000U)
#define CAN_WMB_D47_Data_byte_5_SHIFT            (16U)
/*! Data_byte_5 - Data Byte 5 */
#define CAN_WMB_D47_Data_byte_5(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_5_SHIFT)) & CAN_WMB_D47_Data_byte_5_MASK)

#define CAN_WMB_D47_Data_byte_4_MASK             (0xFF000000U)
#define CAN_WMB_D47_Data_byte_4_SHIFT            (24U)
/*! Data_byte_4 - Data Byte 4 */
#define CAN_WMB_D47_Data_byte_4(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_4_SHIFT)) & CAN_WMB_D47_Data_byte_4_MASK)
/*! @} */

/* The count of CAN_WMB_D47 */
#define CAN_WMB_D47_COUNT                        (4U)

/*! @name EPRS - Enhanced CAN Bit Timing Prescalers */
/*! @{ */

#define CAN_EPRS_ENPRESDIV_MASK                  (0x3FFU)
#define CAN_EPRS_ENPRESDIV_SHIFT                 (0U)
/*! ENPRESDIV - Extended Nominal Prescaler Division Factor */
#define CAN_EPRS_ENPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_EPRS_ENPRESDIV_SHIFT)) & CAN_EPRS_ENPRESDIV_MASK)

#define CAN_EPRS_EDPRESDIV_MASK                  (0x3FF0000U)
#define CAN_EPRS_EDPRESDIV_SHIFT                 (16U)
/*! EDPRESDIV - Extended Data Phase Prescaler Division Factor */
#define CAN_EPRS_EDPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_EPRS_EDPRESDIV_SHIFT)) & CAN_EPRS_EDPRESDIV_MASK)
/*! @} */

/*! @name ENCBT - Enhanced Nominal CAN Bit Timing */
/*! @{ */

#define CAN_ENCBT_NTSEG1_MASK                    (0xFFU)
#define CAN_ENCBT_NTSEG1_SHIFT                   (0U)
/*! NTSEG1 - Nominal Time Segment 1 */
#define CAN_ENCBT_NTSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NTSEG1_SHIFT)) & CAN_ENCBT_NTSEG1_MASK)

#define CAN_ENCBT_NTSEG2_MASK                    (0x7F000U)
#define CAN_ENCBT_NTSEG2_SHIFT                   (12U)
/*! NTSEG2 - Nominal Time Segment 2 */
#define CAN_ENCBT_NTSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NTSEG2_SHIFT)) & CAN_ENCBT_NTSEG2_MASK)

#define CAN_ENCBT_NRJW_MASK                      (0x1FC00000U)
#define CAN_ENCBT_NRJW_SHIFT                     (22U)
/*! NRJW - Nominal Resynchronization Jump Width */
#define CAN_ENCBT_NRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NRJW_SHIFT)) & CAN_ENCBT_NRJW_MASK)
/*! @} */

/*! @name EDCBT - Enhanced Data Phase CAN Bit Timing */
/*! @{ */

#define CAN_EDCBT_DTSEG1_MASK                    (0x1FU)
#define CAN_EDCBT_DTSEG1_SHIFT                   (0U)
/*! DTSEG1 - Data Phase Segment 1 */
#define CAN_EDCBT_DTSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DTSEG1_SHIFT)) & CAN_EDCBT_DTSEG1_MASK)

#define CAN_EDCBT_DTSEG2_MASK                    (0xF000U)
#define CAN_EDCBT_DTSEG2_SHIFT                   (12U)
/*! DTSEG2 - Data Phase Time Segment 2 */
#define CAN_EDCBT_DTSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DTSEG2_SHIFT)) & CAN_EDCBT_DTSEG2_MASK)

#define CAN_EDCBT_DRJW_MASK                      (0x3C00000U)
#define CAN_EDCBT_DRJW_SHIFT                     (22U)
/*! DRJW - Data Phase Resynchronization Jump Width */
#define CAN_EDCBT_DRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DRJW_SHIFT)) & CAN_EDCBT_DRJW_MASK)
/*! @} */

/*! @name ETDC - Enhanced Transceiver Delay Compensation */
/*! @{ */

#define CAN_ETDC_ETDCVAL_MASK                    (0xFFU)
#define CAN_ETDC_ETDCVAL_SHIFT                   (0U)
/*! ETDCVAL - Enhanced Transceiver Delay Compensation Value */
#define CAN_ETDC_ETDCVAL(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCVAL_SHIFT)) & CAN_ETDC_ETDCVAL_MASK)

#define CAN_ETDC_ETDCFAIL_MASK                   (0x8000U)
#define CAN_ETDC_ETDCFAIL_SHIFT                  (15U)
/*! ETDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..In range
 *  0b1..Out of range
 */
#define CAN_ETDC_ETDCFAIL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCFAIL_SHIFT)) & CAN_ETDC_ETDCFAIL_MASK)

#define CAN_ETDC_ETDCOFF_MASK                    (0x7F0000U)
#define CAN_ETDC_ETDCOFF_SHIFT                   (16U)
/*! ETDCOFF - Enhanced Transceiver Delay Compensation Offset */
#define CAN_ETDC_ETDCOFF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCOFF_SHIFT)) & CAN_ETDC_ETDCOFF_MASK)

#define CAN_ETDC_TDMDIS_MASK                     (0x40000000U)
#define CAN_ETDC_TDMDIS_SHIFT                    (30U)
/*! TDMDIS - Transceiver Delay Measurement Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_ETDC_TDMDIS(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_TDMDIS_SHIFT)) & CAN_ETDC_TDMDIS_MASK)

#define CAN_ETDC_ETDCEN_MASK                     (0x80000000U)
#define CAN_ETDC_ETDCEN_SHIFT                    (31U)
/*! ETDCEN - Transceiver Delay Compensation Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ETDC_ETDCEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCEN_SHIFT)) & CAN_ETDC_ETDCEN_MASK)
/*! @} */

/*! @name FDCTRL - CAN FD Control */
/*! @{ */

#define CAN_FDCTRL_TDCVAL_MASK                   (0x3FU)
#define CAN_FDCTRL_TDCVAL_SHIFT                  (0U)
/*! TDCVAL - Transceiver Delay Compensation Value */
#define CAN_FDCTRL_TDCVAL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCVAL_SHIFT)) & CAN_FDCTRL_TDCVAL_MASK)

#define CAN_FDCTRL_TDCOFF_MASK                   (0x1F00U)
#define CAN_FDCTRL_TDCOFF_SHIFT                  (8U)
/*! TDCOFF - Transceiver Delay Compensation Offset */
#define CAN_FDCTRL_TDCOFF(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCOFF_SHIFT)) & CAN_FDCTRL_TDCOFF_MASK)

#define CAN_FDCTRL_TDCFAIL_MASK                  (0x4000U)
#define CAN_FDCTRL_TDCFAIL_SHIFT                 (14U)
/*! TDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..In range
 *  0b1..Out of range
 */
#define CAN_FDCTRL_TDCFAIL(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCFAIL_SHIFT)) & CAN_FDCTRL_TDCFAIL_MASK)

#define CAN_FDCTRL_TDCEN_MASK                    (0x8000U)
#define CAN_FDCTRL_TDCEN_SHIFT                   (15U)
/*! TDCEN - Transceiver Delay Compensation Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_FDCTRL_TDCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCEN_SHIFT)) & CAN_FDCTRL_TDCEN_MASK)

#define CAN_FDCTRL_MBDSR0_MASK                   (0x30000U)
#define CAN_FDCTRL_MBDSR0_SHIFT                  (16U)
/*! MBDSR0 - Message Buffer Data Size for Region 0
 *  0b00..8 bytes
 *  0b01..16 bytes
 *  0b10..32 bytes
 *  0b11..64 bytes
 */
#define CAN_FDCTRL_MBDSR0(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_MBDSR0_SHIFT)) & CAN_FDCTRL_MBDSR0_MASK)

#define CAN_FDCTRL_FDRATE_MASK                   (0x80000000U)
#define CAN_FDCTRL_FDRATE_SHIFT                  (31U)
/*! FDRATE - Bit Rate Switch Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_FDCTRL_FDRATE(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_FDRATE_SHIFT)) & CAN_FDCTRL_FDRATE_MASK)
/*! @} */

/*! @name FDCBT - CAN FD Bit Timing */
/*! @{ */

#define CAN_FDCBT_FPSEG2_MASK                    (0x7U)
#define CAN_FDCBT_FPSEG2_SHIFT                   (0U)
/*! FPSEG2 - Fast Phase Segment 2 */
#define CAN_FDCBT_FPSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG2_SHIFT)) & CAN_FDCBT_FPSEG2_MASK)

#define CAN_FDCBT_FPSEG1_MASK                    (0xE0U)
#define CAN_FDCBT_FPSEG1_SHIFT                   (5U)
/*! FPSEG1 - Fast Phase Segment 1 */
#define CAN_FDCBT_FPSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG1_SHIFT)) & CAN_FDCBT_FPSEG1_MASK)

#define CAN_FDCBT_FPROPSEG_MASK                  (0x7C00U)
#define CAN_FDCBT_FPROPSEG_SHIFT                 (10U)
/*! FPROPSEG - Fast Propagation Segment */
#define CAN_FDCBT_FPROPSEG(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPROPSEG_SHIFT)) & CAN_FDCBT_FPROPSEG_MASK)

#define CAN_FDCBT_FRJW_MASK                      (0x70000U)
#define CAN_FDCBT_FRJW_SHIFT                     (16U)
/*! FRJW - Fast Resync Jump Width */
#define CAN_FDCBT_FRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FRJW_SHIFT)) & CAN_FDCBT_FRJW_MASK)

#define CAN_FDCBT_FPRESDIV_MASK                  (0x3FF00000U)
#define CAN_FDCBT_FPRESDIV_SHIFT                 (20U)
/*! FPRESDIV - Fast Prescaler Division Factor */
#define CAN_FDCBT_FPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPRESDIV_SHIFT)) & CAN_FDCBT_FPRESDIV_MASK)
/*! @} */

/*! @name FDCRC - CAN FD CRC */
/*! @{ */

#define CAN_FDCRC_FD_TXCRC_MASK                  (0x1FFFFFU)
#define CAN_FDCRC_FD_TXCRC_SHIFT                 (0U)
/*! FD_TXCRC - Extended Transmitted CRC value */
#define CAN_FDCRC_FD_TXCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_TXCRC_SHIFT)) & CAN_FDCRC_FD_TXCRC_MASK)

#define CAN_FDCRC_FD_MBCRC_MASK                  (0x7F000000U)
#define CAN_FDCRC_FD_MBCRC_SHIFT                 (24U)
/*! FD_MBCRC - CRC Message Buffer Number for FD_TXCRC */
#define CAN_FDCRC_FD_MBCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_MBCRC_SHIFT)) & CAN_FDCRC_FD_MBCRC_MASK)
/*! @} */

/*! @name ERFCR - Enhanced RX FIFO Control */
/*! @{ */

#define CAN_ERFCR_ERFWM_MASK                     (0x1FU)
#define CAN_ERFCR_ERFWM_SHIFT                    (0U)
/*! ERFWM - Enhanced RX FIFO Watermark */
#define CAN_ERFCR_ERFWM(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_ERFWM_SHIFT)) & CAN_ERFCR_ERFWM_MASK)

#define CAN_ERFCR_NFE_MASK                       (0x3F00U)
#define CAN_ERFCR_NFE_SHIFT                      (8U)
/*! NFE - Number of Enhanced RX FIFO Filter Elements */
#define CAN_ERFCR_NFE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_NFE_SHIFT)) & CAN_ERFCR_NFE_MASK)

#define CAN_ERFCR_NEXIF_MASK                     (0x7F0000U)
#define CAN_ERFCR_NEXIF_SHIFT                    (16U)
/*! NEXIF - Number of Extended ID Filter Elements */
#define CAN_ERFCR_NEXIF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_NEXIF_SHIFT)) & CAN_ERFCR_NEXIF_MASK)

#define CAN_ERFCR_DMALW_MASK                     (0x7C000000U)
#define CAN_ERFCR_DMALW_SHIFT                    (26U)
/*! DMALW - DMA Last Word */
#define CAN_ERFCR_DMALW(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_DMALW_SHIFT)) & CAN_ERFCR_DMALW_MASK)

#define CAN_ERFCR_ERFEN_MASK                     (0x80000000U)
#define CAN_ERFCR_ERFEN_SHIFT                    (31U)
/*! ERFEN - Enhanced RX FIFO enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFCR_ERFEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_ERFEN_SHIFT)) & CAN_ERFCR_ERFEN_MASK)
/*! @} */

/*! @name ERFIER - Enhanced RX FIFO Interrupt Enable */
/*! @{ */

#define CAN_ERFIER_ERFDAIE_MASK                  (0x10000000U)
#define CAN_ERFIER_ERFDAIE_SHIFT                 (28U)
/*! ERFDAIE - Enhanced RX FIFO Data Available Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFDAIE(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFDAIE_SHIFT)) & CAN_ERFIER_ERFDAIE_MASK)

#define CAN_ERFIER_ERFWMIIE_MASK                 (0x20000000U)
#define CAN_ERFIER_ERFWMIIE_SHIFT                (29U)
/*! ERFWMIIE - Enhanced RX FIFO Watermark Indication Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFWMIIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFWMIIE_SHIFT)) & CAN_ERFIER_ERFWMIIE_MASK)

#define CAN_ERFIER_ERFOVFIE_MASK                 (0x40000000U)
#define CAN_ERFIER_ERFOVFIE_SHIFT                (30U)
/*! ERFOVFIE - Enhanced RX FIFO Overflow Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFOVFIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFOVFIE_SHIFT)) & CAN_ERFIER_ERFOVFIE_MASK)

#define CAN_ERFIER_ERFUFWIE_MASK                 (0x80000000U)
#define CAN_ERFIER_ERFUFWIE_SHIFT                (31U)
/*! ERFUFWIE - Enhanced RX FIFO Underflow Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFUFWIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFUFWIE_SHIFT)) & CAN_ERFIER_ERFUFWIE_MASK)
/*! @} */

/*! @name ERFSR - Enhanced RX FIFO Status */
/*! @{ */

#define CAN_ERFSR_ERFEL_MASK                     (0x3FU)
#define CAN_ERFSR_ERFEL_SHIFT                    (0U)
/*! ERFEL - Enhanced RX FIFO Elements */
#define CAN_ERFSR_ERFEL(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFEL_SHIFT)) & CAN_ERFSR_ERFEL_MASK)

#define CAN_ERFSR_ERFF_MASK                      (0x10000U)
#define CAN_ERFSR_ERFF_SHIFT                     (16U)
/*! ERFF - Enhanced RX FIFO Full Flag
 *  0b0..Not full
 *  0b1..Full
 */
#define CAN_ERFSR_ERFF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFF_SHIFT)) & CAN_ERFSR_ERFF_MASK)

#define CAN_ERFSR_ERFE_MASK                      (0x20000U)
#define CAN_ERFSR_ERFE_SHIFT                     (17U)
/*! ERFE - Enhanced RX FIFO Empty Flag
 *  0b0..Not empty
 *  0b1..Empty
 */
#define CAN_ERFSR_ERFE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFE_SHIFT)) & CAN_ERFSR_ERFE_MASK)

#define CAN_ERFSR_ERFCLR_MASK                    (0x8000000U)
#define CAN_ERFSR_ERFCLR_SHIFT                   (27U)
/*! ERFCLR - Enhanced RX FIFO Clear
 *  0b0..No effect
 *  0b1..Clear enhanced RX FIFO content
 */
#define CAN_ERFSR_ERFCLR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFCLR_SHIFT)) & CAN_ERFSR_ERFCLR_MASK)

#define CAN_ERFSR_ERFDA_MASK                     (0x10000000U)
#define CAN_ERFSR_ERFDA_SHIFT                    (28U)
/*! ERFDA - Enhanced RX FIFO Data Available Flag
 *  0b0..No such occurrence
 *  0b1..At least one message stored in Enhanced RX FIFO
 */
#define CAN_ERFSR_ERFDA(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFDA_SHIFT)) & CAN_ERFSR_ERFDA_MASK)

#define CAN_ERFSR_ERFWMI_MASK                    (0x20000000U)
#define CAN_ERFSR_ERFWMI_SHIFT                   (29U)
/*! ERFWMI - Enhanced RX FIFO Watermark Indication Flag
 *  0b0..No such occurrence
 *  0b1..Number of messages in FIFO is greater than the watermark
 */
#define CAN_ERFSR_ERFWMI(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFWMI_SHIFT)) & CAN_ERFSR_ERFWMI_MASK)

#define CAN_ERFSR_ERFOVF_MASK                    (0x40000000U)
#define CAN_ERFSR_ERFOVF_SHIFT                   (30U)
/*! ERFOVF - Enhanced RX FIFO Overflow Flag
 *  0b0..No such occurrence
 *  0b1..Overflow
 */
#define CAN_ERFSR_ERFOVF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFOVF_SHIFT)) & CAN_ERFSR_ERFOVF_MASK)

#define CAN_ERFSR_ERFUFW_MASK                    (0x80000000U)
#define CAN_ERFSR_ERFUFW_SHIFT                   (31U)
/*! ERFUFW - Enhanced RX FIFO Underflow Flag
 *  0b0..No such occurrence
 *  0b1..Underflow
 */
#define CAN_ERFSR_ERFUFW(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFUFW_SHIFT)) & CAN_ERFSR_ERFUFW_MASK)
/*! @} */

/*! @name ERFFEL - Enhanced RX FIFO Filter Element */
/*! @{ */

#define CAN_ERFFEL_FEL_MASK                      (0xFFFFFFFFU)
#define CAN_ERFFEL_FEL_SHIFT                     (0U)
/*! FEL - Filter Element Bits */
#define CAN_ERFFEL_FEL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFFEL_FEL_SHIFT)) & CAN_ERFFEL_FEL_MASK)
/*! @} */

/* The count of CAN_ERFFEL */
#define CAN_ERFFEL_COUNT                         (32U)


/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
/** Peripheral CAN0 base address */
#define CAN0_BASE                                (0x400CC000u)
/** Peripheral CAN0 base pointer */
#define CAN0                                     ((CAN_Type *)CAN0_BASE)
/** Array initializer of CAN peripheral base addresses */
#define CAN_BASE_ADDRS                           { CAN0_BASE }
/** Array initializer of CAN peripheral base pointers */
#define CAN_BASE_PTRS                            { CAN0 }
/** Interrupt vectors for the CAN peripheral type */
#define CAN_Rx_Warning_IRQS                      { CAN0_IRQn }
#define CAN_Tx_Warning_IRQS                      { CAN0_IRQn }
#define CAN_Wake_Up_IRQS                         { CAN0_IRQn }
#define CAN_Error_IRQS                           { CAN0_IRQn }
#define CAN_Bus_Off_IRQS                         { CAN0_IRQn }
#define CAN_ORed_Message_buffer_IRQS             { CAN0_IRQn }

/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CDOG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Peripheral_Access_Layer CDOG Peripheral Access Layer
 * @{
 */

/** CDOG - Register Layout Typedef */
typedef struct {
  __IO uint32_t CONTROL;                           /**< Control Register, offset: 0x0 */
  __IO uint32_t RELOAD;                            /**< Instruction Timer Reload Register, offset: 0x4 */
  __I  uint32_t INSTRUCTION_TIMER;                 /**< Instruction Timer Register, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __I  uint32_t STATUS;                            /**< Status 1 Register, offset: 0x10 */
  __I  uint32_t STATUS2;                           /**< Status 2 Register, offset: 0x14 */
  __IO uint32_t FLAGS;                             /**< Flags Register, offset: 0x18 */
  __IO uint32_t PERSISTENT;                        /**< Persistent Data Storage Register, offset: 0x1C */
  __O  uint32_t START;                             /**< START Command Register, offset: 0x20 */
  __O  uint32_t STOP;                              /**< STOP Command Register, offset: 0x24 */
  __O  uint32_t RESTART;                           /**< RESTART Command Register, offset: 0x28 */
  __O  uint32_t ADD;                               /**< ADD Command Register, offset: 0x2C */
  __O  uint32_t ADD1;                              /**< ADD1 Command Register, offset: 0x30 */
  __O  uint32_t ADD16;                             /**< ADD16 Command Register, offset: 0x34 */
  __O  uint32_t ADD256;                            /**< ADD256 Command Register, offset: 0x38 */
  __O  uint32_t SUB;                               /**< SUB Command Register, offset: 0x3C */
  __O  uint32_t SUB1;                              /**< SUB1 Command Register, offset: 0x40 */
  __O  uint32_t SUB16;                             /**< SUB16 Command Register, offset: 0x44 */
  __O  uint32_t SUB256;                            /**< SUB256 Command Register, offset: 0x48 */
  __O  uint32_t ASSERT16;                          /**< ASSERT16 Command Register, offset: 0x4C */
} CDOG_Type;

/* ----------------------------------------------------------------------------
   -- CDOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Register_Masks CDOG Register Masks
 * @{
 */

/*! @name CONTROL - Control Register */
/*! @{ */

#define CDOG_CONTROL_LOCK_CTRL_MASK              (0x3U)
#define CDOG_CONTROL_LOCK_CTRL_SHIFT             (0U)
/*! LOCK_CTRL - Lock control
 *  0b01..Locked
 *  0b10..Unlocked
 */
#define CDOG_CONTROL_LOCK_CTRL(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_LOCK_CTRL_SHIFT)) & CDOG_CONTROL_LOCK_CTRL_MASK)

#define CDOG_CONTROL_TIMEOUT_CTRL_MASK           (0x1CU)
#define CDOG_CONTROL_TIMEOUT_CTRL_SHIFT          (2U)
/*! TIMEOUT_CTRL - TIMEOUT fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_TIMEOUT_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_TIMEOUT_CTRL_SHIFT)) & CDOG_CONTROL_TIMEOUT_CTRL_MASK)

#define CDOG_CONTROL_MISCOMPARE_CTRL_MASK        (0xE0U)
#define CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT       (5U)
/*! MISCOMPARE_CTRL - MISCOMPARE fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_MISCOMPARE_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT)) & CDOG_CONTROL_MISCOMPARE_CTRL_MASK)

#define CDOG_CONTROL_SEQUENCE_CTRL_MASK          (0x700U)
#define CDOG_CONTROL_SEQUENCE_CTRL_SHIFT         (8U)
/*! SEQUENCE_CTRL - SEQUENCE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_SEQUENCE_CTRL(x)            (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_SEQUENCE_CTRL_SHIFT)) & CDOG_CONTROL_SEQUENCE_CTRL_MASK)

#define CDOG_CONTROL_STATE_CTRL_MASK             (0x1C000U)
#define CDOG_CONTROL_STATE_CTRL_SHIFT            (14U)
/*! STATE_CTRL - STATE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_STATE_CTRL(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_STATE_CTRL_SHIFT)) & CDOG_CONTROL_STATE_CTRL_MASK)

#define CDOG_CONTROL_ADDRESS_CTRL_MASK           (0xE0000U)
#define CDOG_CONTROL_ADDRESS_CTRL_SHIFT          (17U)
/*! ADDRESS_CTRL - ADDRESS fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_ADDRESS_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_ADDRESS_CTRL_SHIFT)) & CDOG_CONTROL_ADDRESS_CTRL_MASK)

#define CDOG_CONTROL_IRQ_PAUSE_MASK              (0x30000000U)
#define CDOG_CONTROL_IRQ_PAUSE_SHIFT             (28U)
/*! IRQ_PAUSE - IRQ pause control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_IRQ_PAUSE(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_IRQ_PAUSE_SHIFT)) & CDOG_CONTROL_IRQ_PAUSE_MASK)

#define CDOG_CONTROL_DEBUG_HALT_CTRL_MASK        (0xC0000000U)
#define CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT       (30U)
/*! DEBUG_HALT_CTRL - DEBUG_HALT control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_DEBUG_HALT_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT)) & CDOG_CONTROL_DEBUG_HALT_CTRL_MASK)
/*! @} */

/*! @name RELOAD - Instruction Timer Reload Register */
/*! @{ */

#define CDOG_RELOAD_RLOAD_MASK                   (0xFFFFFFFFU)
#define CDOG_RELOAD_RLOAD_SHIFT                  (0U)
/*! RLOAD - Instruction Timer reload value */
#define CDOG_RELOAD_RLOAD(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_RELOAD_RLOAD_SHIFT)) & CDOG_RELOAD_RLOAD_MASK)
/*! @} */

/*! @name INSTRUCTION_TIMER - Instruction Timer Register */
/*! @{ */

#define CDOG_INSTRUCTION_TIMER_INSTIM_MASK       (0xFFFFFFFFU)
#define CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT      (0U)
/*! INSTIM - Current value of the Instruction Timer */
#define CDOG_INSTRUCTION_TIMER_INSTIM(x)         (((uint32_t)(((uint32_t)(x)) << CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT)) & CDOG_INSTRUCTION_TIMER_INSTIM_MASK)
/*! @} */

/*! @name STATUS - Status 1 Register */
/*! @{ */

#define CDOG_STATUS_NUMTOF_MASK                  (0xFFU)
#define CDOG_STATUS_NUMTOF_SHIFT                 (0U)
/*! NUMTOF - Number of TIMEOUT faults since the last POR */
#define CDOG_STATUS_NUMTOF(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMTOF_SHIFT)) & CDOG_STATUS_NUMTOF_MASK)

#define CDOG_STATUS_NUMMISCOMPF_MASK             (0xFF00U)
#define CDOG_STATUS_NUMMISCOMPF_SHIFT            (8U)
/*! NUMMISCOMPF - Number of MISCOMPARE faults since the last POR */
#define CDOG_STATUS_NUMMISCOMPF(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMMISCOMPF_SHIFT)) & CDOG_STATUS_NUMMISCOMPF_MASK)

#define CDOG_STATUS_NUMILSEQF_MASK               (0xFF0000U)
#define CDOG_STATUS_NUMILSEQF_SHIFT              (16U)
/*! NUMILSEQF - Number of SEQUENCE faults since the last POR */
#define CDOG_STATUS_NUMILSEQF(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMILSEQF_SHIFT)) & CDOG_STATUS_NUMILSEQF_MASK)

#define CDOG_STATUS_CURST_MASK                   (0xF0000000U)
#define CDOG_STATUS_CURST_SHIFT                  (28U)
/*! CURST - Current State */
#define CDOG_STATUS_CURST(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_CURST_SHIFT)) & CDOG_STATUS_CURST_MASK)
/*! @} */

/*! @name STATUS2 - Status 2 Register */
/*! @{ */

#define CDOG_STATUS2_NUMCNTF_MASK                (0xFFU)
#define CDOG_STATUS2_NUMCNTF_SHIFT               (0U)
/*! NUMCNTF - Number of CONTROL faults since the last POR */
#define CDOG_STATUS2_NUMCNTF(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMCNTF_SHIFT)) & CDOG_STATUS2_NUMCNTF_MASK)

#define CDOG_STATUS2_NUMILLSTF_MASK              (0xFF00U)
#define CDOG_STATUS2_NUMILLSTF_SHIFT             (8U)
/*! NUMILLSTF - Number of STATE faults since the last POR */
#define CDOG_STATUS2_NUMILLSTF(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLSTF_SHIFT)) & CDOG_STATUS2_NUMILLSTF_MASK)

#define CDOG_STATUS2_NUMILLA_MASK                (0xFF0000U)
#define CDOG_STATUS2_NUMILLA_SHIFT               (16U)
/*! NUMILLA - Number of ADDRESS faults since the last POR */
#define CDOG_STATUS2_NUMILLA(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLA_SHIFT)) & CDOG_STATUS2_NUMILLA_MASK)
/*! @} */

/*! @name FLAGS - Flags Register */
/*! @{ */

#define CDOG_FLAGS_TO_FLAG_MASK                  (0x1U)
#define CDOG_FLAGS_TO_FLAG_SHIFT                 (0U)
/*! TO_FLAG - TIMEOUT fault flag
 *  0b0..A TIMEOUT fault has not occurred
 *  0b1..A TIMEOUT fault has occurred
 */
#define CDOG_FLAGS_TO_FLAG(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_TO_FLAG_SHIFT)) & CDOG_FLAGS_TO_FLAG_MASK)

#define CDOG_FLAGS_MISCOM_FLAG_MASK              (0x2U)
#define CDOG_FLAGS_MISCOM_FLAG_SHIFT             (1U)
/*! MISCOM_FLAG - MISCOMPARE fault flag
 *  0b0..A MISCOMPARE fault has not occurred
 *  0b1..A MISCOMPARE fault has occurred
 */
#define CDOG_FLAGS_MISCOM_FLAG(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_MISCOM_FLAG_SHIFT)) & CDOG_FLAGS_MISCOM_FLAG_MASK)

#define CDOG_FLAGS_SEQ_FLAG_MASK                 (0x4U)
#define CDOG_FLAGS_SEQ_FLAG_SHIFT                (2U)
/*! SEQ_FLAG - SEQUENCE fault flag
 *  0b0..A SEQUENCE fault has not occurred
 *  0b1..A SEQUENCE fault has occurred
 */
#define CDOG_FLAGS_SEQ_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_SEQ_FLAG_SHIFT)) & CDOG_FLAGS_SEQ_FLAG_MASK)

#define CDOG_FLAGS_CNT_FLAG_MASK                 (0x8U)
#define CDOG_FLAGS_CNT_FLAG_SHIFT                (3U)
/*! CNT_FLAG - CONTROL fault flag
 *  0b0..A CONTROL fault has not occurred
 *  0b1..A CONTROL fault has occurred
 */
#define CDOG_FLAGS_CNT_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_CNT_FLAG_SHIFT)) & CDOG_FLAGS_CNT_FLAG_MASK)

#define CDOG_FLAGS_STATE_FLAG_MASK               (0x10U)
#define CDOG_FLAGS_STATE_FLAG_SHIFT              (4U)
/*! STATE_FLAG - STATE fault flag
 *  0b0..A STATE fault has not occurred
 *  0b1..A STATE fault has occurred
 */
#define CDOG_FLAGS_STATE_FLAG(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_STATE_FLAG_SHIFT)) & CDOG_FLAGS_STATE_FLAG_MASK)

#define CDOG_FLAGS_ADDR_FLAG_MASK                (0x20U)
#define CDOG_FLAGS_ADDR_FLAG_SHIFT               (5U)
/*! ADDR_FLAG - ADDRESS fault flag
 *  0b0..An ADDRESS fault has not occurred
 *  0b1..An ADDRESS fault has occurred
 */
#define CDOG_FLAGS_ADDR_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_ADDR_FLAG_SHIFT)) & CDOG_FLAGS_ADDR_FLAG_MASK)

#define CDOG_FLAGS_POR_FLAG_MASK                 (0x10000U)
#define CDOG_FLAGS_POR_FLAG_SHIFT                (16U)
/*! POR_FLAG - Power-on reset flag
 *  0b0..A Power-on reset event has not occurred
 *  0b1..A Power-on reset event has occurred
 */
#define CDOG_FLAGS_POR_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_POR_FLAG_SHIFT)) & CDOG_FLAGS_POR_FLAG_MASK)
/*! @} */

/*! @name PERSISTENT - Persistent Data Storage Register */
/*! @{ */

#define CDOG_PERSISTENT_PERSIS_MASK              (0xFFFFFFFFU)
#define CDOG_PERSISTENT_PERSIS_SHIFT             (0U)
/*! PERSIS - Persistent Storage */
#define CDOG_PERSISTENT_PERSIS(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_PERSISTENT_PERSIS_SHIFT)) & CDOG_PERSISTENT_PERSIS_MASK)
/*! @} */

/*! @name START - START Command Register */
/*! @{ */

#define CDOG_START_STRT_MASK                     (0xFFFFFFFFU)
#define CDOG_START_STRT_SHIFT                    (0U)
/*! STRT - Start command */
#define CDOG_START_STRT(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_START_STRT_SHIFT)) & CDOG_START_STRT_MASK)
/*! @} */

/*! @name STOP - STOP Command Register */
/*! @{ */

#define CDOG_STOP_STP_MASK                       (0xFFFFFFFFU)
#define CDOG_STOP_STP_SHIFT                      (0U)
/*! STP - Stop command */
#define CDOG_STOP_STP(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_STOP_STP_SHIFT)) & CDOG_STOP_STP_MASK)
/*! @} */

/*! @name RESTART - RESTART Command Register */
/*! @{ */

#define CDOG_RESTART_RSTRT_MASK                  (0xFFFFFFFFU)
#define CDOG_RESTART_RSTRT_SHIFT                 (0U)
/*! RSTRT - Restart command */
#define CDOG_RESTART_RSTRT(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_RESTART_RSTRT_SHIFT)) & CDOG_RESTART_RSTRT_MASK)
/*! @} */

/*! @name ADD - ADD Command Register */
/*! @{ */

#define CDOG_ADD_AD_MASK                         (0xFFFFFFFFU)
#define CDOG_ADD_AD_SHIFT                        (0U)
/*! AD - ADD Write Value */
#define CDOG_ADD_AD(x)                           (((uint32_t)(((uint32_t)(x)) << CDOG_ADD_AD_SHIFT)) & CDOG_ADD_AD_MASK)
/*! @} */

/*! @name ADD1 - ADD1 Command Register */
/*! @{ */

#define CDOG_ADD1_AD1_MASK                       (0xFFFFFFFFU)
#define CDOG_ADD1_AD1_SHIFT                      (0U)
/*! AD1 - ADD 1 */
#define CDOG_ADD1_AD1(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_ADD1_AD1_SHIFT)) & CDOG_ADD1_AD1_MASK)
/*! @} */

/*! @name ADD16 - ADD16 Command Register */
/*! @{ */

#define CDOG_ADD16_AD16_MASK                     (0xFFFFFFFFU)
#define CDOG_ADD16_AD16_SHIFT                    (0U)
/*! AD16 - ADD 16 */
#define CDOG_ADD16_AD16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_ADD16_AD16_SHIFT)) & CDOG_ADD16_AD16_MASK)
/*! @} */

/*! @name ADD256 - ADD256 Command Register */
/*! @{ */

#define CDOG_ADD256_AD256_MASK                   (0xFFFFFFFFU)
#define CDOG_ADD256_AD256_SHIFT                  (0U)
/*! AD256 - ADD 256 */
#define CDOG_ADD256_AD256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_ADD256_AD256_SHIFT)) & CDOG_ADD256_AD256_MASK)
/*! @} */

/*! @name SUB - SUB Command Register */
/*! @{ */

#define CDOG_SUB_SB_MASK                         (0xFFFFFFFFU)
#define CDOG_SUB_SB_SHIFT                        (0U)
/*! SB - Subtract Write Value */
#define CDOG_SUB_SB(x)                           (((uint32_t)(((uint32_t)(x)) << CDOG_SUB_SB_SHIFT)) & CDOG_SUB_SB_MASK)
/*! @} */

/*! @name SUB1 - SUB1 Command Register */
/*! @{ */

#define CDOG_SUB1_SB1_MASK                       (0xFFFFFFFFU)
#define CDOG_SUB1_SB1_SHIFT                      (0U)
/*! SB1 - Subtract 1 */
#define CDOG_SUB1_SB1(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_SUB1_SB1_SHIFT)) & CDOG_SUB1_SB1_MASK)
/*! @} */

/*! @name SUB16 - SUB16 Command Register */
/*! @{ */

#define CDOG_SUB16_SB16_MASK                     (0xFFFFFFFFU)
#define CDOG_SUB16_SB16_SHIFT                    (0U)
/*! SB16 - Subtract 16 */
#define CDOG_SUB16_SB16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_SUB16_SB16_SHIFT)) & CDOG_SUB16_SB16_MASK)
/*! @} */

/*! @name SUB256 - SUB256 Command Register */
/*! @{ */

#define CDOG_SUB256_SB256_MASK                   (0xFFFFFFFFU)
#define CDOG_SUB256_SB256_SHIFT                  (0U)
/*! SB256 - Subtract 256 */
#define CDOG_SUB256_SB256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_SUB256_SB256_SHIFT)) & CDOG_SUB256_SB256_MASK)
/*! @} */

/*! @name ASSERT16 - ASSERT16 Command Register */
/*! @{ */

#define CDOG_ASSERT16_AST16_MASK                 (0xFFFFFFFFU)
#define CDOG_ASSERT16_AST16_SHIFT                (0U)
/*! AST16 - ASSERT16 Command */
#define CDOG_ASSERT16_AST16(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_ASSERT16_AST16_SHIFT)) & CDOG_ASSERT16_AST16_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CDOG_Register_Masks */


/* CDOG - Peripheral instance base addresses */
/** Peripheral CDOG base address */
#define CDOG_BASE                                (0x40100000u)
/** Peripheral CDOG base pointer */
#define CDOG                                     ((CDOG_Type *)CDOG_BASE)
/** Array initializer of CDOG peripheral base addresses */
#define CDOG_BASE_ADDRS                          { CDOG_BASE }
/** Array initializer of CDOG peripheral base pointers */
#define CDOG_BASE_PTRS                           { CDOG }
/** Interrupt vectors for the CDOG peripheral type */
#define CDOG_IRQS                                { CDOG0_IRQn }

/*!
 * @}
 */ /* end of group CDOG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMC_Peripheral_Access_Layer CMC Peripheral Access Layer
 * @{
 */

/** CMC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t CKCTRL;                            /**< Clock Control, offset: 0x10 */
  __IO uint32_t CKSTAT;                            /**< Clock Status, offset: 0x14 */
  __IO uint32_t PMPROT;                            /**< Power Mode Protection, offset: 0x18 */
  __O  uint32_t GPMCTRL;                           /**< Global Power Mode Control, offset: 0x1C */
  __IO uint32_t PMCTRL[1];                         /**< Power Mode Control, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_1[92];
  __I  uint32_t SRS;                               /**< System Reset Status, offset: 0x80 */
  __IO uint32_t RPC;                               /**< Reset Pin Control, offset: 0x84 */
  __IO uint32_t SSRS;                              /**< Sticky System Reset Status, offset: 0x88 */
  __IO uint32_t SRIE;                              /**< System Reset Interrupt Enable, offset: 0x8C */
  __IO uint32_t SRIF;                              /**< System Reset Interrupt Flag, offset: 0x90 */
       uint8_t RESERVED_2[8];
  __I  uint32_t RSTCNT;                            /**< Reset Count Register, offset: 0x9C */
  __IO uint32_t MR[1];                             /**< Mode, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_3[12];
  __IO uint32_t FM[1];                             /**< Force Mode, array offset: 0xB0, array step: 0x4 */
       uint8_t RESERVED_4[44];
  __IO uint32_t FLASHCR;                           /**< Flash Control, offset: 0xE0 */
       uint8_t RESERVED_5[44];
  __IO uint32_t CORECTL;                           /**< Core Control, offset: 0x110 */
       uint8_t RESERVED_6[12];
  __IO uint32_t DBGCTL;                            /**< Debug Control, offset: 0x120 */
} CMC_Type;

/* ----------------------------------------------------------------------------
   -- CMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMC_Register_Masks CMC Register Masks
 * @{
 */

/*! @name VERID - Version ID */
/*! @{ */

#define CMC_VERID_FEATURE_MASK                   (0xFFFFU)
#define CMC_VERID_FEATURE_SHIFT                  (0U)
/*! FEATURE - Feature Specification Number */
#define CMC_VERID_FEATURE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_VERID_FEATURE_SHIFT)) & CMC_VERID_FEATURE_MASK)

#define CMC_VERID_MINOR_MASK                     (0xFF0000U)
#define CMC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number */
#define CMC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_VERID_MINOR_SHIFT)) & CMC_VERID_MINOR_MASK)

#define CMC_VERID_MAJOR_MASK                     (0xFF000000U)
#define CMC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number */
#define CMC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_VERID_MAJOR_SHIFT)) & CMC_VERID_MAJOR_MASK)
/*! @} */

/*! @name CKCTRL - Clock Control */
/*! @{ */

#define CMC_CKCTRL_CKMODE_MASK                   (0xFU)
#define CMC_CKCTRL_CKMODE_SHIFT                  (0U)
/*! CKMODE - Clocking Mode
 *  0b0000..No clock gating
 *  0b1111..Core, platform, and peripheral clocks are gated, and core enters Low-Power mode.
 */
#define CMC_CKCTRL_CKMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKCTRL_CKMODE_SHIFT)) & CMC_CKCTRL_CKMODE_MASK)

#define CMC_CKCTRL_LOCK_MASK                     (0x80000000U)
#define CMC_CKCTRL_LOCK_SHIFT                    (31U)
/*! LOCK - Lock
 *  0b0..Allowed
 *  0b1..Blocked
 */
#define CMC_CKCTRL_LOCK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_CKCTRL_LOCK_SHIFT)) & CMC_CKCTRL_LOCK_MASK)
/*! @} */

/*! @name CKSTAT - Clock Status */
/*! @{ */

#define CMC_CKSTAT_CKMODE_MASK                   (0xFU)
#define CMC_CKSTAT_CKMODE_SHIFT                  (0U)
/*! CKMODE - Low Power Status
 *  0b0000..Core clock not gated
 *  0b1111..Core, platform, and peripheral clocks were gated, and power domain entered Low-Power mode
 *  *..
 */
#define CMC_CKSTAT_CKMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_CKMODE_SHIFT)) & CMC_CKSTAT_CKMODE_MASK)

#define CMC_CKSTAT_WAKEUP_MASK                   (0xFF00U)
#define CMC_CKSTAT_WAKEUP_SHIFT                  (8U)
/*! WAKEUP - Wake-up Source */
#define CMC_CKSTAT_WAKEUP(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_WAKEUP_SHIFT)) & CMC_CKSTAT_WAKEUP_MASK)

#define CMC_CKSTAT_VALID_MASK                    (0x80000000U)
#define CMC_CKSTAT_VALID_SHIFT                   (31U)
/*! VALID - Clock Status Valid
 *  0b0..Core clock not gated
 *  0b1..Core clock was gated due to Low-Power mode entry
 */
#define CMC_CKSTAT_VALID(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_VALID_SHIFT)) & CMC_CKSTAT_VALID_MASK)
/*! @} */

/*! @name PMPROT - Power Mode Protection */
/*! @{ */

#define CMC_PMPROT_LPMODE_MASK                   (0xFU)
#define CMC_PMPROT_LPMODE_SHIFT                  (0U)
/*! LPMODE - Low-Power Mode
 *  0b0000..Not allowed
 *  0b0001..Allowed
 *  0b0010..Allowed
 *  0b0011..Allowed
 *  0b0100..Allowed
 *  0b0101..Allowed
 *  0b0110..Allowed
 *  0b0111..Allowed
 *  0b1000..Allowed
 *  0b1001..Allowed
 *  0b1010..Allowed
 *  0b1011..Allowed
 *  0b1100..Allowed
 *  0b1101..Allowed
 *  0b1110..Allowed
 *  0b1111..Allowed
 */
#define CMC_PMPROT_LPMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_PMPROT_LPMODE_SHIFT)) & CMC_PMPROT_LPMODE_MASK)

#define CMC_PMPROT_LOCK_MASK                     (0x80000000U)
#define CMC_PMPROT_LOCK_SHIFT                    (31U)
/*! LOCK - Lock Register
 *  0b0..Allowed
 *  0b1..Blocked
 */
#define CMC_PMPROT_LOCK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_PMPROT_LOCK_SHIFT)) & CMC_PMPROT_LOCK_MASK)
/*! @} */

/*! @name GPMCTRL - Global Power Mode Control */
/*! @{ */

#define CMC_GPMCTRL_LPMODE_MASK                  (0xFU)
#define CMC_GPMCTRL_LPMODE_SHIFT                 (0U)
/*! LPMODE - Low-Power Mode */
#define CMC_GPMCTRL_LPMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CMC_GPMCTRL_LPMODE_SHIFT)) & CMC_GPMCTRL_LPMODE_MASK)
/*! @} */

/*! @name PMCTRL - Power Mode Control */
/*! @{ */

#define CMC_PMCTRL_LPMODE_MASK                   (0xFU)
#define CMC_PMCTRL_LPMODE_SHIFT                  (0U)
/*! LPMODE - Low-Power Mode
 *  0b0000..Active/Sleep
 *  0b0001..Deep Sleep
 *  0b0011..Power Down
 *  0b0111..Reserved
 *  0b1111..Deep-Power Down
 */
#define CMC_PMCTRL_LPMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_PMCTRL_LPMODE_SHIFT)) & CMC_PMCTRL_LPMODE_MASK)
/*! @} */

/* The count of CMC_PMCTRL */
#define CMC_PMCTRL_COUNT                         (1U)

/*! @name SRS - System Reset Status */
/*! @{ */

#define CMC_SRS_WAKEUP_MASK                      (0x1U)
#define CMC_SRS_WAKEUP_SHIFT                     (0U)
/*! WAKEUP - Wake-up Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_WAKEUP(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WAKEUP_SHIFT)) & CMC_SRS_WAKEUP_MASK)

#define CMC_SRS_POR_MASK                         (0x2U)
#define CMC_SRS_POR_SHIFT                        (1U)
/*! POR - Power-on Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_POR(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_POR_SHIFT)) & CMC_SRS_POR_MASK)

#define CMC_SRS_VD_MASK                          (0x4U)
#define CMC_SRS_VD_SHIFT                         (2U)
/*! VD - Voltage Detect Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_VD(x)                            (((uint32_t)(((uint32_t)(x)) << CMC_SRS_VD_SHIFT)) & CMC_SRS_VD_MASK)

#define CMC_SRS_WARM_MASK                        (0x10U)
#define CMC_SRS_WARM_SHIFT                       (4U)
/*! WARM - Warm Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_WARM(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WARM_SHIFT)) & CMC_SRS_WARM_MASK)

#define CMC_SRS_FATAL_MASK                       (0x20U)
#define CMC_SRS_FATAL_SHIFT                      (5U)
/*! FATAL - Fatal Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_FATAL(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_FATAL_SHIFT)) & CMC_SRS_FATAL_MASK)

#define CMC_SRS_PIN_MASK                         (0x100U)
#define CMC_SRS_PIN_SHIFT                        (8U)
/*! PIN - Pin Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_PIN(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_PIN_SHIFT)) & CMC_SRS_PIN_MASK)

#define CMC_SRS_DAP_MASK                         (0x200U)
#define CMC_SRS_DAP_SHIFT                        (9U)
/*! DAP - Debug Access Port Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_DAP(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_DAP_SHIFT)) & CMC_SRS_DAP_MASK)

#define CMC_SRS_RSTACK_MASK                      (0x400U)
#define CMC_SRS_RSTACK_SHIFT                     (10U)
/*! RSTACK - Reset Timeout
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_RSTACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_RSTACK_SHIFT)) & CMC_SRS_RSTACK_MASK)

#define CMC_SRS_LPACK_MASK                       (0x800U)
#define CMC_SRS_LPACK_SHIFT                      (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_LPACK(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LPACK_SHIFT)) & CMC_SRS_LPACK_MASK)

#define CMC_SRS_SCG_MASK                         (0x1000U)
#define CMC_SRS_SCG_SHIFT                        (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_SCG(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SCG_SHIFT)) & CMC_SRS_SCG_MASK)

#define CMC_SRS_WWDT0_MASK                       (0x2000U)
#define CMC_SRS_WWDT0_SHIFT                      (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_WWDT0(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WWDT0_SHIFT)) & CMC_SRS_WWDT0_MASK)

#define CMC_SRS_SW_MASK                          (0x4000U)
#define CMC_SRS_SW_SHIFT                         (14U)
/*! SW - Software Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_SW(x)                            (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SW_SHIFT)) & CMC_SRS_SW_MASK)

#define CMC_SRS_LOCKUP_MASK                      (0x8000U)
#define CMC_SRS_LOCKUP_SHIFT                     (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_LOCKUP(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LOCKUP_SHIFT)) & CMC_SRS_LOCKUP_MASK)

#define CMC_SRS_CDOG0_MASK                       (0x4000000U)
#define CMC_SRS_CDOG0_SHIFT                      (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_CDOG0(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_CDOG0_SHIFT)) & CMC_SRS_CDOG0_MASK)

#define CMC_SRS_JTAG_MASK                        (0x10000000U)
#define CMC_SRS_JTAG_SHIFT                       (28U)
/*! JTAG - JTAG System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_JTAG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_JTAG_SHIFT)) & CMC_SRS_JTAG_MASK)
/*! @} */

/*! @name RPC - Reset Pin Control */
/*! @{ */

#define CMC_RPC_FILTCFG_MASK                     (0x1FU)
#define CMC_RPC_FILTCFG_SHIFT                    (0U)
/*! FILTCFG - Reset Filter Configuration */
#define CMC_RPC_FILTCFG(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_RPC_FILTCFG_SHIFT)) & CMC_RPC_FILTCFG_MASK)

#define CMC_RPC_FILTEN_MASK                      (0x100U)
#define CMC_RPC_FILTEN_SHIFT                     (8U)
/*! FILTEN - Filter Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_RPC_FILTEN(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_RPC_FILTEN_SHIFT)) & CMC_RPC_FILTEN_MASK)

#define CMC_RPC_LPFEN_MASK                       (0x200U)
#define CMC_RPC_LPFEN_SHIFT                      (9U)
/*! LPFEN - Low-Power Filter Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_RPC_LPFEN(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_RPC_LPFEN_SHIFT)) & CMC_RPC_LPFEN_MASK)
/*! @} */

/*! @name SSRS - Sticky System Reset Status */
/*! @{ */

#define CMC_SSRS_WAKEUP_MASK                     (0x1U)
#define CMC_SSRS_WAKEUP_SHIFT                    (0U)
/*! WAKEUP - Wake-up Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_WAKEUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WAKEUP_SHIFT)) & CMC_SSRS_WAKEUP_MASK)

#define CMC_SSRS_POR_MASK                        (0x2U)
#define CMC_SSRS_POR_SHIFT                       (1U)
/*! POR - Power-on Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_POR(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_POR_SHIFT)) & CMC_SSRS_POR_MASK)

#define CMC_SSRS_VD_MASK                         (0x4U)
#define CMC_SSRS_VD_SHIFT                        (2U)
/*! VD - Voltage Detect Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_VD(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_VD_SHIFT)) & CMC_SSRS_VD_MASK)

#define CMC_SSRS_WARM_MASK                       (0x10U)
#define CMC_SSRS_WARM_SHIFT                      (4U)
/*! WARM - Warm Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_WARM(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WARM_SHIFT)) & CMC_SSRS_WARM_MASK)

#define CMC_SSRS_FATAL_MASK                      (0x20U)
#define CMC_SSRS_FATAL_SHIFT                     (5U)
/*! FATAL - Fatal Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SSRS_FATAL(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_FATAL_SHIFT)) & CMC_SSRS_FATAL_MASK)

#define CMC_SSRS_PIN_MASK                        (0x100U)
#define CMC_SSRS_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_PIN_SHIFT)) & CMC_SSRS_PIN_MASK)

#define CMC_SSRS_DAP_MASK                        (0x200U)
#define CMC_SSRS_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_DAP_SHIFT)) & CMC_SSRS_DAP_MASK)

#define CMC_SSRS_RSTACK_MASK                     (0x400U)
#define CMC_SSRS_RSTACK_SHIFT                    (10U)
/*! RSTACK - Reset Timeout
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_RSTACK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_RSTACK_SHIFT)) & CMC_SSRS_RSTACK_MASK)

#define CMC_SSRS_LPACK_MASK                      (0x800U)
#define CMC_SSRS_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LPACK_SHIFT)) & CMC_SSRS_LPACK_MASK)

#define CMC_SSRS_SCG_MASK                        (0x1000U)
#define CMC_SSRS_SCG_SHIFT                       (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_SCG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SCG_SHIFT)) & CMC_SSRS_SCG_MASK)

#define CMC_SSRS_WWDT0_MASK                      (0x2000U)
#define CMC_SSRS_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WWDT0_SHIFT)) & CMC_SSRS_WWDT0_MASK)

#define CMC_SSRS_SW_MASK                         (0x4000U)
#define CMC_SSRS_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SW_SHIFT)) & CMC_SSRS_SW_MASK)

#define CMC_SSRS_LOCKUP_MASK                     (0x8000U)
#define CMC_SSRS_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LOCKUP_SHIFT)) & CMC_SSRS_LOCKUP_MASK)

#define CMC_SSRS_CDOG0_MASK                      (0x4000000U)
#define CMC_SSRS_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_CDOG0_SHIFT)) & CMC_SSRS_CDOG0_MASK)

#define CMC_SSRS_JTAG_MASK                       (0x10000000U)
#define CMC_SSRS_JTAG_SHIFT                      (28U)
/*! JTAG - JTAG System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_JTAG(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_JTAG_SHIFT)) & CMC_SSRS_JTAG_MASK)
/*! @} */

/*! @name SRIE - System Reset Interrupt Enable */
/*! @{ */

#define CMC_SRIE_PIN_MASK                        (0x100U)
#define CMC_SRIE_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_PIN_SHIFT)) & CMC_SRIE_PIN_MASK)

#define CMC_SRIE_DAP_MASK                        (0x200U)
#define CMC_SRIE_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_DAP_SHIFT)) & CMC_SRIE_DAP_MASK)

#define CMC_SRIE_LPACK_MASK                      (0x800U)
#define CMC_SRIE_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_LPACK_SHIFT)) & CMC_SRIE_LPACK_MASK)

#define CMC_SRIE_SCG_MASK                        (0x1000U)
#define CMC_SRIE_SCG_SHIFT                       (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_SCG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_SCG_SHIFT)) & CMC_SRIE_SCG_MASK)

#define CMC_SRIE_WWDT0_MASK                      (0x2000U)
#define CMC_SRIE_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_WWDT0_SHIFT)) & CMC_SRIE_WWDT0_MASK)

#define CMC_SRIE_SW_MASK                         (0x4000U)
#define CMC_SRIE_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_SW_SHIFT)) & CMC_SRIE_SW_MASK)

#define CMC_SRIE_LOCKUP_MASK                     (0x8000U)
#define CMC_SRIE_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_LOCKUP_SHIFT)) & CMC_SRIE_LOCKUP_MASK)

#define CMC_SRIE_CDOG0_MASK                      (0x4000000U)
#define CMC_SRIE_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_CDOG0_SHIFT)) & CMC_SRIE_CDOG0_MASK)
/*! @} */

/*! @name SRIF - System Reset Interrupt Flag */
/*! @{ */

#define CMC_SRIF_PIN_MASK                        (0x100U)
#define CMC_SRIF_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_PIN_SHIFT)) & CMC_SRIF_PIN_MASK)

#define CMC_SRIF_DAP_MASK                        (0x200U)
#define CMC_SRIF_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_DAP_SHIFT)) & CMC_SRIF_DAP_MASK)

#define CMC_SRIF_LPACK_MASK                      (0x800U)
#define CMC_SRIF_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_LPACK_SHIFT)) & CMC_SRIF_LPACK_MASK)

#define CMC_SRIF_WWDT0_MASK                      (0x2000U)
#define CMC_SRIF_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_WWDT0_SHIFT)) & CMC_SRIF_WWDT0_MASK)

#define CMC_SRIF_SW_MASK                         (0x4000U)
#define CMC_SRIF_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_SW_SHIFT)) & CMC_SRIF_SW_MASK)

#define CMC_SRIF_LOCKUP_MASK                     (0x8000U)
#define CMC_SRIF_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_LOCKUP_SHIFT)) & CMC_SRIF_LOCKUP_MASK)

#define CMC_SRIF_CDOG0_MASK                      (0x4000000U)
#define CMC_SRIF_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_CDOG0_SHIFT)) & CMC_SRIF_CDOG0_MASK)
/*! @} */

/*! @name RSTCNT - Reset Count Register */
/*! @{ */

#define CMC_RSTCNT_COUNT_MASK                    (0xFFU)
#define CMC_RSTCNT_COUNT_SHIFT                   (0U)
/*! COUNT - Count */
#define CMC_RSTCNT_COUNT(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_RSTCNT_COUNT_SHIFT)) & CMC_RSTCNT_COUNT_MASK)
/*! @} */

/*! @name MR - Mode */
/*! @{ */

#define CMC_MR_ISPMODE_n_MASK                    (0x1U)
#define CMC_MR_ISPMODE_n_SHIFT                   (0U)
/*! ISPMODE_n - In System Programming Mode */
#define CMC_MR_ISPMODE_n(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_MR_ISPMODE_n_SHIFT)) & CMC_MR_ISPMODE_n_MASK)
/*! @} */

/* The count of CMC_MR */
#define CMC_MR_COUNT                             (1U)

/*! @name FM - Force Mode */
/*! @{ */

#define CMC_FM_FORCECFG_MASK                     (0x1U)
#define CMC_FM_FORCECFG_SHIFT                    (0U)
/*! FORCECFG - Boot Configuration
 *  0b0..No effect
 *  0b1..Asserts
 */
#define CMC_FM_FORCECFG(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_FM_FORCECFG_SHIFT)) & CMC_FM_FORCECFG_MASK)
/*! @} */

/* The count of CMC_FM */
#define CMC_FM_COUNT                             (1U)

/*! @name FLASHCR - Flash Control */
/*! @{ */

#define CMC_FLASHCR_FLASHDIS_MASK                (0x1U)
#define CMC_FLASHCR_FLASHDIS_SHIFT               (0U)
/*! FLASHDIS - Flash Disable
 *  0b0..No effect
 *  0b1..Flash memory is disabled
 */
#define CMC_FLASHCR_FLASHDIS(x)                  (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHDIS_SHIFT)) & CMC_FLASHCR_FLASHDIS_MASK)

#define CMC_FLASHCR_FLASHDOZE_MASK               (0x2U)
#define CMC_FLASHCR_FLASHDOZE_SHIFT              (1U)
/*! FLASHDOZE - Flash Doze
 *  0b0..No effect
 *  0b1..Flash memory is disabled when core is sleeping (CKMODE > 0)
 */
#define CMC_FLASHCR_FLASHDOZE(x)                 (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHDOZE_SHIFT)) & CMC_FLASHCR_FLASHDOZE_MASK)

#define CMC_FLASHCR_FLASHWAKE_MASK               (0x4U)
#define CMC_FLASHCR_FLASHWAKE_SHIFT              (2U)
/*! FLASHWAKE - Flash Wake
 *  0b0..No effect
 *  0b1..Flash memory is not disabled during flash memory accesses
 */
#define CMC_FLASHCR_FLASHWAKE(x)                 (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHWAKE_SHIFT)) & CMC_FLASHCR_FLASHWAKE_MASK)
/*! @} */

/*! @name CORECTL - Core Control */
/*! @{ */

#define CMC_CORECTL_NPIE_MASK                    (0x1U)
#define CMC_CORECTL_NPIE_SHIFT                   (0U)
/*! NPIE - Non-maskable Pin Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_CORECTL_NPIE(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_CORECTL_NPIE_SHIFT)) & CMC_CORECTL_NPIE_MASK)
/*! @} */

/*! @name DBGCTL - Debug Control */
/*! @{ */

#define CMC_DBGCTL_SOD_MASK                      (0x1U)
#define CMC_DBGCTL_SOD_SHIFT                     (0U)
/*! SOD - Sleep Or Debug
 *  0b0..Remains enabled
 *  0b1..Disabled
 */
#define CMC_DBGCTL_SOD(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_DBGCTL_SOD_SHIFT)) & CMC_DBGCTL_SOD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CMC_Register_Masks */


/* CMC - Peripheral instance base addresses */
/** Peripheral CMC base address */
#define CMC_BASE                                 (0x4008B000u)
/** Peripheral CMC base pointer */
#define CMC                                      ((CMC_Type *)CMC_BASE)
/** Array initializer of CMC peripheral base addresses */
#define CMC_BASE_ADDRS                           { CMC_BASE }
/** Array initializer of CMC peripheral base pointers */
#define CMC_BASE_PTRS                            { CMC }

/*!
 * @}
 */ /* end of group CMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint8_t DATALL;                             /**< CRC_DATALL register, offset: 0x0 */
      __IO uint8_t DATALU;                             /**< CRC_DATALU register, offset: 0x1 */
      __IO uint8_t DATAHL;                             /**< CRC_DATAHL register, offset: 0x2 */
      __IO uint8_t DATAHU;                             /**< CRC_DATAHU register, offset: 0x3 */
    } ACCESS8BIT;
    struct {                                         /* offset: 0x0 */
      __IO uint16_t DATAL;                             /**< CRC_DATAL register, offset: 0x0 */
      __IO uint16_t DATAH;                             /**< CRC_DATAH register, offset: 0x2 */
    } ACCESS16BIT;
    __IO uint32_t DATA;                              /**< Data, offset: 0x0 */
  };
  union {                                          /* offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint8_t GPOLYLL;                            /**< CRC_GPOLYLL register, offset: 0x4 */
      __IO uint8_t GPOLYLU;                            /**< CRC_GPOLYLU register, offset: 0x5 */
      __IO uint8_t GPOLYHL;                            /**< CRC_GPOLYHL register, offset: 0x6 */
      __IO uint8_t GPOLYHU;                            /**< CRC_GPOLYHU register, offset: 0x7 */
    } GPOLY_ACCESS8BIT;
    struct {                                         /* offset: 0x4 */
      __IO uint16_t GPOLYL;                            /**< CRC_GPOLYL register, offset: 0x4 */
      __IO uint16_t GPOLYH;                            /**< CRC_GPOLYH register, offset: 0x6 */
    } GPOLY_ACCESS16BIT;
    __IO uint32_t GPOLY;                             /**< Polynomial, offset: 0x4 */
  };
  union {                                          /* offset: 0x8 */
    struct {                                         /* offset: 0x8 */
           uint8_t RESERVED_0[3];
      __IO uint8_t CTRLHU;                             /**< CRC_CTRLHU register, offset: 0xB */
    } CTRL_ACCESS8BIT;
    __IO uint32_t CTRL;                              /**< Control, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name DATALL - CRC_DATALL register */
/*! @{ */

#define CRC_DATALL_DATALL_MASK                   (0xFFU)
#define CRC_DATALL_DATALL_SHIFT                  (0U)
#define CRC_DATALL_DATALL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALL_DATALL_SHIFT)) & CRC_DATALL_DATALL_MASK)
/*! @} */

/*! @name DATALU - CRC_DATALU register */
/*! @{ */

#define CRC_DATALU_DATALU_MASK                   (0xFFU)
#define CRC_DATALU_DATALU_SHIFT                  (0U)
#define CRC_DATALU_DATALU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALU_DATALU_SHIFT)) & CRC_DATALU_DATALU_MASK)
/*! @} */

/*! @name DATAHL - CRC_DATAHL register */
/*! @{ */

#define CRC_DATAHL_DATAHL_MASK                   (0xFFU)
#define CRC_DATAHL_DATAHL_SHIFT                  (0U)
#define CRC_DATAHL_DATAHL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHL_DATAHL_SHIFT)) & CRC_DATAHL_DATAHL_MASK)
/*! @} */

/*! @name DATAHU - CRC_DATAHU register */
/*! @{ */

#define CRC_DATAHU_DATAHU_MASK                   (0xFFU)
#define CRC_DATAHU_DATAHU_SHIFT                  (0U)
#define CRC_DATAHU_DATAHU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHU_DATAHU_SHIFT)) & CRC_DATAHU_DATAHU_MASK)
/*! @} */

/*! @name DATAL - CRC_DATAL register */
/*! @{ */

#define CRC_DATAL_DATAL_MASK                     (0xFFFFU)
#define CRC_DATAL_DATAL_SHIFT                    (0U)
#define CRC_DATAL_DATAL(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAL_DATAL_SHIFT)) & CRC_DATAL_DATAL_MASK)
/*! @} */

/*! @name DATAH - CRC_DATAH register */
/*! @{ */

#define CRC_DATAH_DATAH_MASK                     (0xFFFFU)
#define CRC_DATAH_DATAH_SHIFT                    (0U)
#define CRC_DATAH_DATAH(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAH_DATAH_SHIFT)) & CRC_DATAH_DATAH_MASK)
/*! @} */

/*! @name DATA - Data */
/*! @{ */

#define CRC_DATA_LL_MASK                         (0xFFU)
#define CRC_DATA_LL_SHIFT                        (0U)
/*! LL - Lower Part of Low Byte */
#define CRC_DATA_LL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LL_SHIFT)) & CRC_DATA_LL_MASK)

#define CRC_DATA_LU_MASK                         (0xFF00U)
#define CRC_DATA_LU_SHIFT                        (8U)
/*! LU - Upper Part of Low Byte */
#define CRC_DATA_LU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LU_SHIFT)) & CRC_DATA_LU_MASK)

#define CRC_DATA_HL_MASK                         (0xFF0000U)
#define CRC_DATA_HL_SHIFT                        (16U)
/*! HL - Lower Part of High Byte */
#define CRC_DATA_HL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HL_SHIFT)) & CRC_DATA_HL_MASK)

#define CRC_DATA_HU_MASK                         (0xFF000000U)
#define CRC_DATA_HU_SHIFT                        (24U)
/*! HU - Upper Part of High Byte */
#define CRC_DATA_HU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HU_SHIFT)) & CRC_DATA_HU_MASK)
/*! @} */

/*! @name GPOLYLL - CRC_GPOLYLL register */
/*! @{ */

#define CRC_GPOLYLL_GPOLYLL_MASK                 (0xFFU)
#define CRC_GPOLYLL_GPOLYLL_SHIFT                (0U)
#define CRC_GPOLYLL_GPOLYLL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLL_GPOLYLL_SHIFT)) & CRC_GPOLYLL_GPOLYLL_MASK)
/*! @} */

/*! @name GPOLYLU - CRC_GPOLYLU register */
/*! @{ */

#define CRC_GPOLYLU_GPOLYLU_MASK                 (0xFFU)
#define CRC_GPOLYLU_GPOLYLU_SHIFT                (0U)
#define CRC_GPOLYLU_GPOLYLU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLU_GPOLYLU_SHIFT)) & CRC_GPOLYLU_GPOLYLU_MASK)
/*! @} */

/*! @name GPOLYHL - CRC_GPOLYHL register */
/*! @{ */

#define CRC_GPOLYHL_GPOLYHL_MASK                 (0xFFU)
#define CRC_GPOLYHL_GPOLYHL_SHIFT                (0U)
#define CRC_GPOLYHL_GPOLYHL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHL_GPOLYHL_SHIFT)) & CRC_GPOLYHL_GPOLYHL_MASK)
/*! @} */

/*! @name GPOLYHU - CRC_GPOLYHU register */
/*! @{ */

#define CRC_GPOLYHU_GPOLYHU_MASK                 (0xFFU)
#define CRC_GPOLYHU_GPOLYHU_SHIFT                (0U)
#define CRC_GPOLYHU_GPOLYHU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHU_GPOLYHU_SHIFT)) & CRC_GPOLYHU_GPOLYHU_MASK)
/*! @} */

/*! @name GPOLYL - CRC_GPOLYL register */
/*! @{ */

#define CRC_GPOLYL_GPOLYL_MASK                   (0xFFFFU)
#define CRC_GPOLYL_GPOLYL_SHIFT                  (0U)
#define CRC_GPOLYL_GPOLYL(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYL_GPOLYL_SHIFT)) & CRC_GPOLYL_GPOLYL_MASK)
/*! @} */

/*! @name GPOLYH - CRC_GPOLYH register */
/*! @{ */

#define CRC_GPOLYH_GPOLYH_MASK                   (0xFFFFU)
#define CRC_GPOLYH_GPOLYH_SHIFT                  (0U)
#define CRC_GPOLYH_GPOLYH(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYH_GPOLYH_SHIFT)) & CRC_GPOLYH_GPOLYH_MASK)
/*! @} */

/*! @name GPOLY - Polynomial */
/*! @{ */

#define CRC_GPOLY_LOW_MASK                       (0xFFFFU)
#define CRC_GPOLY_LOW_SHIFT                      (0U)
/*! LOW - Low Half-Word */
#define CRC_GPOLY_LOW(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_LOW_SHIFT)) & CRC_GPOLY_LOW_MASK)

#define CRC_GPOLY_HIGH_MASK                      (0xFFFF0000U)
#define CRC_GPOLY_HIGH_SHIFT                     (16U)
/*! HIGH - High Half-Word */
#define CRC_GPOLY_HIGH(x)                        (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_HIGH_SHIFT)) & CRC_GPOLY_HIGH_MASK)
/*! @} */

/*! @name CTRLHU - CRC_CTRLHU register */
/*! @{ */

#define CRC_CTRLHU_TCRC_MASK                     (0x1U)
#define CRC_CTRLHU_TCRC_SHIFT                    (0U)
/*! TCRC - TCRC
 *  0b0..16 bits
 *  0b1..32 bits
 */
#define CRC_CTRLHU_TCRC(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TCRC_SHIFT)) & CRC_CTRLHU_TCRC_MASK)

#define CRC_CTRLHU_WAS_MASK                      (0x2U)
#define CRC_CTRLHU_WAS_SHIFT                     (1U)
/*! WAS - Write as Seed
 *  0b0..Data values
 *  0b1..Seed values
 */
#define CRC_CTRLHU_WAS(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_WAS_SHIFT)) & CRC_CTRLHU_WAS_MASK)

#define CRC_CTRLHU_FXOR_MASK                     (0x4U)
#define CRC_CTRLHU_FXOR_SHIFT                    (2U)
/*! FXOR - Complement Read of CRC Data Register
 *  0b0..Disables XOR on reading data.
 *  0b1..Inverts or complements the read value of the CRC Data.
 */
#define CRC_CTRLHU_FXOR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_FXOR_SHIFT)) & CRC_CTRLHU_FXOR_MASK)

#define CRC_CTRLHU_TOTR_MASK                     (0x30U)
#define CRC_CTRLHU_TOTR_SHIFT                    (4U)
/*! TOTR - Transpose Type for Read
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed, but bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed, no bits in a byte are transposed.
 */
#define CRC_CTRLHU_TOTR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOTR_SHIFT)) & CRC_CTRLHU_TOTR_MASK)

#define CRC_CTRLHU_TOT_MASK                      (0xC0U)
#define CRC_CTRLHU_TOT_SHIFT                     (6U)
/*! TOT - Transpose Type for Write
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed, but bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed, no bits in a byte are transposed.
 */
#define CRC_CTRLHU_TOT(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOT_SHIFT)) & CRC_CTRLHU_TOT_MASK)
/*! @} */

/*! @name CTRL - Control */
/*! @{ */

#define CRC_CTRL_TCRC_MASK                       (0x1000000U)
#define CRC_CTRL_TCRC_SHIFT                      (24U)
/*! TCRC - TCRC
 *  0b0..16 bits
 *  0b1..32 bits
 */
#define CRC_CTRL_TCRC(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TCRC_SHIFT)) & CRC_CTRL_TCRC_MASK)

#define CRC_CTRL_WAS_MASK                        (0x2000000U)
#define CRC_CTRL_WAS_SHIFT                       (25U)
/*! WAS - Write as Seed
 *  0b0..Data values
 *  0b1..Seed values
 */
#define CRC_CTRL_WAS(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_WAS_SHIFT)) & CRC_CTRL_WAS_MASK)

#define CRC_CTRL_FXOR_MASK                       (0x4000000U)
#define CRC_CTRL_FXOR_SHIFT                      (26U)
/*! FXOR - Complement Read of CRC Data Register
 *  0b0..Disables XOR on reading data.
 *  0b1..Inverts or complements the read value of the CRC Data.
 */
#define CRC_CTRL_FXOR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_FXOR_SHIFT)) & CRC_CTRL_FXOR_MASK)

#define CRC_CTRL_TOTR_MASK                       (0x30000000U)
#define CRC_CTRL_TOTR_SHIFT                      (28U)
/*! TOTR - Transpose Type for Read
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed, but bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed, no bits in a byte are transposed.
 */
#define CRC_CTRL_TOTR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOTR_SHIFT)) & CRC_CTRL_TOTR_MASK)

#define CRC_CTRL_TOT_MASK                        (0xC0000000U)
#define CRC_CTRL_TOT_SHIFT                       (30U)
/*! TOT - Transpose Type for Write
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed, but bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed, no bits in a byte are transposed.
 */
#define CRC_CTRL_TOT(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOT_SHIFT)) & CRC_CTRL_TOT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
/** Peripheral CRC0 base address */
#define CRC0_BASE                                (0x4008A000u)
/** Peripheral CRC0 base pointer */
#define CRC0                                     ((CRC_Type *)CRC0_BASE)
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS                           { CRC0_BASE }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS                            { CRC0 }

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct {
  __IO uint32_t IR;                                /**< Interrupt, offset: 0x0 */
  __IO uint32_t TCR;                               /**< Timer Control, offset: 0x4 */
  __IO uint32_t TC;                                /**< Timer Counter, offset: 0x8 */
  __IO uint32_t PR;                                /**< Prescale, offset: 0xC */
  __IO uint32_t PC;                                /**< Prescale Counter, offset: 0x10 */
  __IO uint32_t MCR;                               /**< Match Control, offset: 0x14 */
  __IO uint32_t MR[4];                             /**< Match, array offset: 0x18, array step: 0x4 */
  __IO uint32_t CCR;                               /**< Capture Control, offset: 0x28 */
  __I  uint32_t CR[4];                             /**< Capture, array offset: 0x2C, array step: 0x4 */
  __IO uint32_t EMR;                               /**< External Match, offset: 0x3C */
       uint8_t RESERVED_0[48];
  __IO uint32_t CTCR;                              /**< Count Control, offset: 0x70 */
  __IO uint32_t PWMC;                              /**< PWM Control, offset: 0x74 */
  __IO uint32_t MSR[4];                            /**< Match Shadow, array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt */
/*! @{ */

#define CTIMER_IR_MR0INT_MASK                    (0x1U)
#define CTIMER_IR_MR0INT_SHIFT                   (0U)
/*! MR0INT - Interrupt Flag for Match Channel 0 Event */
#define CTIMER_IR_MR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)

#define CTIMER_IR_MR1INT_MASK                    (0x2U)
#define CTIMER_IR_MR1INT_SHIFT                   (1U)
/*! MR1INT - Interrupt Flag for Match Channel 1 Event */
#define CTIMER_IR_MR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)

#define CTIMER_IR_MR2INT_MASK                    (0x4U)
#define CTIMER_IR_MR2INT_SHIFT                   (2U)
/*! MR2INT - Interrupt Flag for Match Channel 2 Event */
#define CTIMER_IR_MR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)

#define CTIMER_IR_MR3INT_MASK                    (0x8U)
#define CTIMER_IR_MR3INT_SHIFT                   (3U)
/*! MR3INT - Interrupt Flag for Match Channel 3 Event */
#define CTIMER_IR_MR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)

#define CTIMER_IR_CR0INT_MASK                    (0x10U)
#define CTIMER_IR_CR0INT_SHIFT                   (4U)
/*! CR0INT - Interrupt Flag for Capture Channel 0 Event */
#define CTIMER_IR_CR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)

#define CTIMER_IR_CR1INT_MASK                    (0x20U)
#define CTIMER_IR_CR1INT_SHIFT                   (5U)
/*! CR1INT - Interrupt Flag for Capture Channel 1 Event */
#define CTIMER_IR_CR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)

#define CTIMER_IR_CR2INT_MASK                    (0x40U)
#define CTIMER_IR_CR2INT_SHIFT                   (6U)
/*! CR2INT - Interrupt Flag for Capture Channel 2 Event */
#define CTIMER_IR_CR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)

#define CTIMER_IR_CR3INT_MASK                    (0x80U)
#define CTIMER_IR_CR3INT_SHIFT                   (7U)
/*! CR3INT - Interrupt Flag for Capture Channel 3 Event */
#define CTIMER_IR_CR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control */
/*! @{ */

#define CTIMER_TCR_CEN_MASK                      (0x1U)
#define CTIMER_TCR_CEN_SHIFT                     (0U)
/*! CEN - Counter Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_CEN(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)

#define CTIMER_TCR_CRST_MASK                     (0x2U)
#define CTIMER_TCR_CRST_SHIFT                    (1U)
/*! CRST - Counter Reset Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_CRST(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)

#define CTIMER_TCR_AGCEN_MASK                    (0x10U)
#define CTIMER_TCR_AGCEN_SHIFT                   (4U)
/*! AGCEN - Allow Global Count Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_AGCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_AGCEN_SHIFT)) & CTIMER_TCR_AGCEN_MASK)

#define CTIMER_TCR_ATCEN_MASK                    (0x20U)
#define CTIMER_TCR_ATCEN_SHIFT                   (5U)
/*! ATCEN - Allow Trigger Count Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_ATCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_ATCEN_SHIFT)) & CTIMER_TCR_ATCEN_MASK)
/*! @} */

/*! @name TC - Timer Counter */
/*! @{ */

#define CTIMER_TC_TCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT                    (0U)
/*! TCVAL - Timer Counter Value */
#define CTIMER_TC_TCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale */
/*! @{ */

#define CTIMER_PR_PRVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT                    (0U)
/*! PRVAL - Prescale Reload Value */
#define CTIMER_PR_PRVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter */
/*! @{ */

#define CTIMER_PC_PCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT                    (0U)
/*! PCVAL - Prescale Counter Value */
#define CTIMER_PC_PCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control */
/*! @{ */

#define CTIMER_MCR_MR0I_MASK                     (0x1U)
#define CTIMER_MCR_MR0I_SHIFT                    (0U)
/*! MR0I - Interrupt on MR0
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR0I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)

#define CTIMER_MCR_MR0R_MASK                     (0x2U)
#define CTIMER_MCR_MR0R_SHIFT                    (1U)
/*! MR0R - Reset on MR0
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR0R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)

#define CTIMER_MCR_MR0S_MASK                     (0x4U)
#define CTIMER_MCR_MR0S_SHIFT                    (2U)
/*! MR0S - Stop on MR0
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR0S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)

#define CTIMER_MCR_MR1I_MASK                     (0x8U)
#define CTIMER_MCR_MR1I_SHIFT                    (3U)
/*! MR1I - Interrupt on MR1
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR1I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)

#define CTIMER_MCR_MR1R_MASK                     (0x10U)
#define CTIMER_MCR_MR1R_SHIFT                    (4U)
/*! MR1R - Reset on MR1
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR1R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)

#define CTIMER_MCR_MR1S_MASK                     (0x20U)
#define CTIMER_MCR_MR1S_SHIFT                    (5U)
/*! MR1S - Stop on MR1
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR1S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)

#define CTIMER_MCR_MR2I_MASK                     (0x40U)
#define CTIMER_MCR_MR2I_SHIFT                    (6U)
/*! MR2I - Interrupt on MR2
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR2I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)

#define CTIMER_MCR_MR2R_MASK                     (0x80U)
#define CTIMER_MCR_MR2R_SHIFT                    (7U)
/*! MR2R - Reset on MR2
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR2R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)

#define CTIMER_MCR_MR2S_MASK                     (0x100U)
#define CTIMER_MCR_MR2S_SHIFT                    (8U)
/*! MR2S - Stop on MR2
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR2S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)

#define CTIMER_MCR_MR3I_MASK                     (0x200U)
#define CTIMER_MCR_MR3I_SHIFT                    (9U)
/*! MR3I - Interrupt on MR3
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR3I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)

#define CTIMER_MCR_MR3R_MASK                     (0x400U)
#define CTIMER_MCR_MR3R_SHIFT                    (10U)
/*! MR3R - Reset on MR3
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR3R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)

#define CTIMER_MCR_MR3S_MASK                     (0x800U)
#define CTIMER_MCR_MR3S_SHIFT                    (11U)
/*! MR3S - Stop on MR3
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR3S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)

#define CTIMER_MCR_MR0RL_MASK                    (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT                   (24U)
/*! MR0RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR0RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)

#define CTIMER_MCR_MR1RL_MASK                    (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT                   (25U)
/*! MR1RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR1RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)

#define CTIMER_MCR_MR2RL_MASK                    (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT                   (26U)
/*! MR2RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR2RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)

#define CTIMER_MCR_MR3RL_MASK                    (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT                   (27U)
/*! MR3RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR3RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match */
/*! @{ */

#define CTIMER_MR_MATCH_MASK                     (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT                    (0U)
/*! MATCH - Timer Counter Match Value */
#define CTIMER_MR_MATCH(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT                          (4U)

/*! @name CCR - Capture Control */
/*! @{ */

#define CTIMER_CCR_CAP0RE_MASK                   (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT                  (0U)
/*! CAP0RE - Rising Edge of Capture Channel 0
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP0RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)

#define CTIMER_CCR_CAP0FE_MASK                   (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT                  (1U)
/*! CAP0FE - Falling Edge of Capture Channel 0
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP0FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)

#define CTIMER_CCR_CAP0I_MASK                    (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT                   (2U)
/*! CAP0I - Generate Interrupt on Channel 0 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP0I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)

#define CTIMER_CCR_CAP1RE_MASK                   (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT                  (3U)
/*! CAP1RE - Rising Edge of Capture Channel 1
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP1RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)

#define CTIMER_CCR_CAP1FE_MASK                   (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT                  (4U)
/*! CAP1FE - Falling Edge of Capture Channel 1
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP1FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)

#define CTIMER_CCR_CAP1I_MASK                    (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT                   (5U)
/*! CAP1I - Generate Interrupt on Channel 1 Capture Event
 *  0b0..Does not generates
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP1I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)

#define CTIMER_CCR_CAP2RE_MASK                   (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT                  (6U)
/*! CAP2RE - Rising Edge of Capture Channel 2
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP2RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)

#define CTIMER_CCR_CAP2FE_MASK                   (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT                  (7U)
/*! CAP2FE - Falling Edge of Capture Channel 2
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP2FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)

#define CTIMER_CCR_CAP2I_MASK                    (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT                   (8U)
/*! CAP2I - Generate Interrupt on Channel 2 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP2I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)

#define CTIMER_CCR_CAP3RE_MASK                   (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT                  (9U)
/*! CAP3RE - Rising Edge of Capture Channel 3
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP3RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)

#define CTIMER_CCR_CAP3FE_MASK                   (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT                  (10U)
/*! CAP3FE - Falling Edge of Capture Channel 3
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP3FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)

#define CTIMER_CCR_CAP3I_MASK                    (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT                   (11U)
/*! CAP3I - Generate Interrupt on Channel 3 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP3I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture */
/*! @{ */

#define CTIMER_CR_CAP_MASK                       (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT                      (0U)
/*! CAP - Timer Counter Capture Value */
#define CTIMER_CR_CAP(x)                         (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT                          (4U)

/*! @name EMR - External Match */
/*! @{ */

#define CTIMER_EMR_EM0_MASK                      (0x1U)
#define CTIMER_EMR_EM0_SHIFT                     (0U)
/*! EM0 - External Match 0
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM0(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)

#define CTIMER_EMR_EM1_MASK                      (0x2U)
#define CTIMER_EMR_EM1_SHIFT                     (1U)
/*! EM1 - External Match 1
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM1(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)

#define CTIMER_EMR_EM2_MASK                      (0x4U)
#define CTIMER_EMR_EM2_SHIFT                     (2U)
/*! EM2 - External Match 2
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM2(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)

#define CTIMER_EMR_EM3_MASK                      (0x8U)
#define CTIMER_EMR_EM3_SHIFT                     (3U)
/*! EM3 - External Match 3
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM3(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)

#define CTIMER_EMR_EMC0_MASK                     (0x30U)
#define CTIMER_EMR_EMC0_SHIFT                    (4U)
/*! EMC0 - External Match Control 0
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC0(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)

#define CTIMER_EMR_EMC1_MASK                     (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT                    (6U)
/*! EMC1 - External Match Control 1
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC1(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)

#define CTIMER_EMR_EMC2_MASK                     (0x300U)
#define CTIMER_EMR_EMC2_SHIFT                    (8U)
/*! EMC2 - External Match Control 2
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC2(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)

#define CTIMER_EMR_EMC3_MASK                     (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT                    (10U)
/*! EMC3 - External Match Control 3
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC3(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control */
/*! @{ */

#define CTIMER_CTCR_CTMODE_MASK                  (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT                 (0U)
/*! CTMODE - Counter Timer Mode
 *  0b00..Timer mode
 *  0b01..Counter mode rising edge
 *  0b10..Counter mode falling edge
 *  0b11..Counter mode dual edge
 */
#define CTIMER_CTCR_CTMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)

#define CTIMER_CTCR_CINSEL_MASK                  (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT                 (2U)
/*! CINSEL - Count Input Select
 *  0b00..Channel 0, CAPn[0] for CTIMERn
 *  0b01..Channel 1, CAPn[1] for CTIMERn
 *  0b10..Channel 2, CAPn[2] for CTIMERn
 *  0b11..Channel 3, CAPn[3] for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)

#define CTIMER_CTCR_ENCC_MASK                    (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT                   (4U)
/*! ENCC - Capture Channel Enable */
#define CTIMER_CTCR_ENCC(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)

#define CTIMER_CTCR_SELCC_MASK                   (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT                  (5U)
/*! SELCC - Edge Select
 *  0b000..Capture channel 0 rising edge
 *  0b001..Capture channel 0 falling edge
 *  0b010..Capture channel 1 rising edge
 *  0b011..Capture channel 1 falling edge
 *  0b100..Capture channel 2 rising edge
 *  0b101..Capture channel 2 falling edge
 */
#define CTIMER_CTCR_SELCC(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control */
/*! @{ */

#define CTIMER_PWMC_PWMEN0_MASK                  (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT                 (0U)
/*! PWMEN0 - PWM Mode Enable for Channel 0
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN0(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)

#define CTIMER_PWMC_PWMEN1_MASK                  (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT                 (1U)
/*! PWMEN1 - PWM Mode Enable for Channel 1
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN1(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)

#define CTIMER_PWMC_PWMEN2_MASK                  (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT                 (2U)
/*! PWMEN2 - PWM Mode Enable for Channel 2
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN2(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)

#define CTIMER_PWMC_PWMEN3_MASK                  (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT                 (3U)
/*! PWMEN3 - PWM Mode Enable for Channel 3
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN3(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow */
/*! @{ */

#define CTIMER_MSR_MATCH_SHADOW_MASK             (0xFFFFFFFFU)
#define CTIMER_MSR_MATCH_SHADOW_SHIFT            (0U)
/*! MATCH_SHADOW - Timer Counter Match Shadow Value */
#define CTIMER_MSR_MATCH_SHADOW(x)               (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_MATCH_SHADOW_SHIFT)) & CTIMER_MSR_MATCH_SHADOW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT                         (4U)


/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */


/* CTIMER - Peripheral instance base addresses */
/** Peripheral CTIMER0 base address */
#define CTIMER0_BASE                             (0x40004000u)
/** Peripheral CTIMER0 base pointer */
#define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
/** Peripheral CTIMER1 base address */
#define CTIMER1_BASE                             (0x40005000u)
/** Peripheral CTIMER1 base pointer */
#define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
/** Peripheral CTIMER2 base address */
#define CTIMER2_BASE                             (0x40006000u)
/** Peripheral CTIMER2 base pointer */
#define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
/** Peripheral CTIMER3 base address */
#define CTIMER3_BASE                             (0x40007000u)
/** Peripheral CTIMER3 base pointer */
#define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
/** Peripheral CTIMER4 base address */
#define CTIMER4_BASE                             (0x40008000u)
/** Peripheral CTIMER4 base pointer */
#define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
/** Array initializer of CTIMER peripheral base addresses */
#define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
/** Array initializer of CTIMER peripheral base pointers */
#define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                              { CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DEBUGMAILBOX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DEBUGMAILBOX_Peripheral_Access_Layer DEBUGMAILBOX Peripheral Access Layer
 * @{
 */

/** DEBUGMAILBOX - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSW;                               /**< Command and Status Word, offset: 0x0 */
  __IO uint32_t REQUEST;                           /**< Request Value, offset: 0x4 */
  __IO uint32_t RETURN;                            /**< Return Value, offset: 0x8 */
       uint8_t RESERVED_0[240];
  __I  uint32_t ID;                                /**< Identification, offset: 0xFC */
} DEBUGMAILBOX_Type;

/* ----------------------------------------------------------------------------
   -- DEBUGMAILBOX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DEBUGMAILBOX_Register_Masks DEBUGMAILBOX Register Masks
 * @{
 */

/*! @name CSW - Command and Status Word */
/*! @{ */

#define DEBUGMAILBOX_CSW_RESYNCH_REQ_MASK        (0x1U)
#define DEBUGMAILBOX_CSW_RESYNCH_REQ_SHIFT       (0U)
/*! RESYNCH_REQ - Resynchronization Request
 *  0b0..No request
 *  0b1..Request for resynchronization
 */
#define DEBUGMAILBOX_CSW_RESYNCH_REQ(x)          (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_CSW_RESYNCH_REQ_SHIFT)) & DEBUGMAILBOX_CSW_RESYNCH_REQ_MASK)

#define DEBUGMAILBOX_CSW_REQ_PENDING_MASK        (0x2U)
#define DEBUGMAILBOX_CSW_REQ_PENDING_SHIFT       (1U)
/*! REQ_PENDING - Request Pending
 *  0b0..No request pending
 *  0b1..Request for resynchronization pending
 */
#define DEBUGMAILBOX_CSW_REQ_PENDING(x)          (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_CSW_REQ_PENDING_SHIFT)) & DEBUGMAILBOX_CSW_REQ_PENDING_MASK)

#define DEBUGMAILBOX_CSW_DBG_OR_ERR_MASK         (0x4U)
#define DEBUGMAILBOX_CSW_DBG_OR_ERR_SHIFT        (2U)
/*! DBG_OR_ERR - DBGMB Overrun Error
 *  0b0..No overrun
 *  0b1..Overrun occurred
 */
#define DEBUGMAILBOX_CSW_DBG_OR_ERR(x)           (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_CSW_DBG_OR_ERR_SHIFT)) & DEBUGMAILBOX_CSW_DBG_OR_ERR_MASK)

#define DEBUGMAILBOX_CSW_AHB_OR_ERR_MASK         (0x8U)
#define DEBUGMAILBOX_CSW_AHB_OR_ERR_SHIFT        (3U)
/*! AHB_OR_ERR - AHB Overrun Error
 *  0b0..No overrun
 *  0b1..Overrun occurred
 */
#define DEBUGMAILBOX_CSW_AHB_OR_ERR(x)           (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_CSW_AHB_OR_ERR_SHIFT)) & DEBUGMAILBOX_CSW_AHB_OR_ERR_MASK)

#define DEBUGMAILBOX_CSW_SOFT_RESET_MASK         (0x10U)
#define DEBUGMAILBOX_CSW_SOFT_RESET_SHIFT        (4U)
/*! SOFT_RESET - Soft Reset */
#define DEBUGMAILBOX_CSW_SOFT_RESET(x)           (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_CSW_SOFT_RESET_SHIFT)) & DEBUGMAILBOX_CSW_SOFT_RESET_MASK)

#define DEBUGMAILBOX_CSW_CHIP_RESET_REQ_MASK     (0x20U)
#define DEBUGMAILBOX_CSW_CHIP_RESET_REQ_SHIFT    (5U)
/*! CHIP_RESET_REQ - Chip Reset Request */
#define DEBUGMAILBOX_CSW_CHIP_RESET_REQ(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_CSW_CHIP_RESET_REQ_SHIFT)) & DEBUGMAILBOX_CSW_CHIP_RESET_REQ_MASK)
/*! @} */

/*! @name REQUEST - Request Value */
/*! @{ */

#define DEBUGMAILBOX_REQUEST_REQUEST_MASK        (0xFFFFFFFFU)
#define DEBUGMAILBOX_REQUEST_REQUEST_SHIFT       (0U)
/*! REQUEST - Request Value */
#define DEBUGMAILBOX_REQUEST_REQUEST(x)          (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_REQUEST_REQUEST_SHIFT)) & DEBUGMAILBOX_REQUEST_REQUEST_MASK)
/*! @} */

/*! @name RETURN - Return Value */
/*! @{ */

#define DEBUGMAILBOX_RETURN_RET_MASK             (0xFFFFFFFFU)
#define DEBUGMAILBOX_RETURN_RET_SHIFT            (0U)
/*! RET - Return Value */
#define DEBUGMAILBOX_RETURN_RET(x)               (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_RETURN_RET_SHIFT)) & DEBUGMAILBOX_RETURN_RET_MASK)
/*! @} */

/*! @name ID - Identification */
/*! @{ */

#define DEBUGMAILBOX_ID_ID_MASK                  (0xFFFFFFFFU)
#define DEBUGMAILBOX_ID_ID_SHIFT                 (0U)
/*! ID - Identification Value */
#define DEBUGMAILBOX_ID_ID(x)                    (((uint32_t)(((uint32_t)(x)) << DEBUGMAILBOX_ID_ID_SHIFT)) & DEBUGMAILBOX_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DEBUGMAILBOX_Register_Masks */


/* DEBUGMAILBOX - Peripheral instance base addresses */
/** Peripheral DBGMAILBOX base address */
#define DBGMAILBOX_BASE                          (0x40101000u)
/** Peripheral DBGMAILBOX base pointer */
#define DBGMAILBOX                               ((DEBUGMAILBOX_Type *)DBGMAILBOX_BASE)
/** Array initializer of DEBUGMAILBOX peripheral base addresses */
#define DEBUGMAILBOX_BASE_ADDRS                  { DBGMAILBOX_BASE }
/** Array initializer of DEBUGMAILBOX peripheral base pointers */
#define DEBUGMAILBOX_BASE_PTRS                   { DBGMAILBOX }

/*!
 * @}
 */ /* end of group DEBUGMAILBOX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t MP_CSR;                            /**< Management Page Control, offset: 0x0 */
  __I  uint32_t MP_ES;                             /**< Management Page Error Status, offset: 0x4 */
  __I  uint32_t MP_INT;                            /**< Management Page Interrupt Request Status, offset: 0x8 */
  __I  uint32_t MP_HRS;                            /**< Management Page Hardware Request Status, offset: 0xC */
       uint8_t RESERVED_0[240];
  __IO uint32_t CH_GRPRI[8];                       /**< Channel Arbitration Group, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_1[3808];
  struct {                                         /* offset: 0x1000, array step: 0x1000 */
    __IO uint32_t CH_CSR;                            /**< Channel Control and Status, array offset: 0x1000, array step: 0x1000 */
    __IO uint32_t CH_ES;                             /**< Channel Error Status, array offset: 0x1004, array step: 0x1000 */
    __IO uint32_t CH_INT;                            /**< Channel Interrupt Status, array offset: 0x1008, array step: 0x1000 */
    __IO uint32_t CH_SBR;                            /**< Channel System Bus, array offset: 0x100C, array step: 0x1000 */
    __IO uint32_t CH_PRI;                            /**< Channel Priority, array offset: 0x1010, array step: 0x1000 */
    __IO uint32_t CH_MUX;                            /**< Channel Multiplexor Configuration, array offset: 0x1014, array step: 0x1000 */
         uint8_t RESERVED_0[8];
    __IO uint32_t TCD_SADDR;                         /**< TCD Source Address, array offset: 0x1020, array step: 0x1000 */
    __IO uint16_t TCD_SOFF;                          /**< TCD Signed Source Address Offset, array offset: 0x1024, array step: 0x1000 */
    __IO uint16_t TCD_ATTR;                          /**< TCD Transfer Attributes, array offset: 0x1026, array step: 0x1000 */
    union {                                          /* offset: 0x1028, array step: 0x1000 */
      __IO uint32_t TCD_NBYTES_MLOFFNO;                /**< TCD Transfer Size Without Minor Loop Offsets, array offset: 0x1028, array step: 0x1000 */
      __IO uint32_t TCD_NBYTES_MLOFFYES;               /**< TCD Transfer Size with Minor Loop Offsets, array offset: 0x1028, array step: 0x1000 */
    };
    __IO uint32_t TCD_SLAST_SDA;                     /**< TCD Last Source Address Adjustment / Store DADDR Address, array offset: 0x102C, array step: 0x1000 */
    __IO uint32_t TCD_DADDR;                         /**< TCD Destination Address, array offset: 0x1030, array step: 0x1000 */
    __IO uint16_t TCD_DOFF;                          /**< TCD Signed Destination Address Offset, array offset: 0x1034, array step: 0x1000 */
    union {                                          /* offset: 0x1036, array step: 0x1000 */
      __IO uint16_t TCD_CITER_ELINKNO;                 /**< TCD Current Major Loop Count (Minor Loop Channel Linking Disabled), array offset: 0x1036, array step: 0x1000 */
      __IO uint16_t TCD_CITER_ELINKYES;                /**< TCD Current Major Loop Count (Minor Loop Channel Linking Enabled), array offset: 0x1036, array step: 0x1000 */
    };
    __IO uint32_t TCD_DLAST_SGA;                     /**< TCD Last Destination Address Adjustment / Scatter Gather Address, array offset: 0x1038, array step: 0x1000 */
    __IO uint16_t TCD_CSR;                           /**< TCD Control and Status, array offset: 0x103C, array step: 0x1000 */
    union {                                          /* offset: 0x103E, array step: 0x1000 */
      __IO uint16_t TCD_BITER_ELINKNO;                 /**< TCD Beginning Major Loop Count (Minor Loop Channel Linking Disabled), array offset: 0x103E, array step: 0x1000 */
      __IO uint16_t TCD_BITER_ELINKYES;                /**< TCD Beginning Major Loop Count (Minor Loop Channel Linking Enabled), array offset: 0x103E, array step: 0x1000 */
    };
         uint8_t RESERVED_1[4032];
  } CH[8];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name MP_CSR - Management Page Control */
/*! @{ */

#define DMA_MP_CSR_EDBG_MASK                     (0x2U)
#define DMA_MP_CSR_EDBG_SHIFT                    (1U)
/*! EDBG - Enable Debug
 *  0b0..Debug mode disabled
 *  0b1..Debug mode is enabled.
 */
#define DMA_MP_CSR_EDBG(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_EDBG_SHIFT)) & DMA_MP_CSR_EDBG_MASK)

#define DMA_MP_CSR_ERCA_MASK                     (0x4U)
#define DMA_MP_CSR_ERCA_SHIFT                    (2U)
/*! ERCA - Enable Round Robin Channel Arbitration
 *  0b0..Round-robin channel arbitration disabled
 *  0b1..Round-robin channel arbitration enabled
 */
#define DMA_MP_CSR_ERCA(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ERCA_SHIFT)) & DMA_MP_CSR_ERCA_MASK)

#define DMA_MP_CSR_HAE_MASK                      (0x10U)
#define DMA_MP_CSR_HAE_SHIFT                     (4U)
/*! HAE - Halt After Error
 *  0b0..Normal operation
 *  0b1..Any error causes the HALT field to be set to 1
 */
#define DMA_MP_CSR_HAE(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_HAE_SHIFT)) & DMA_MP_CSR_HAE_MASK)

#define DMA_MP_CSR_HALT_MASK                     (0x20U)
#define DMA_MP_CSR_HALT_SHIFT                    (5U)
/*! HALT - Halt DMA Operations
 *  0b0..Normal operation
 *  0b1..Stall the start of any new channels
 */
#define DMA_MP_CSR_HALT(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_HALT_SHIFT)) & DMA_MP_CSR_HALT_MASK)

#define DMA_MP_CSR_GCLC_MASK                     (0x40U)
#define DMA_MP_CSR_GCLC_SHIFT                    (6U)
/*! GCLC - Global Channel Linking Control
 *  0b0..Channel linking disabled for all channels
 *  0b1..Channel linking available and controlled by each channel's link settings
 */
#define DMA_MP_CSR_GCLC(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_GCLC_SHIFT)) & DMA_MP_CSR_GCLC_MASK)

#define DMA_MP_CSR_GMRC_MASK                     (0x80U)
#define DMA_MP_CSR_GMRC_SHIFT                    (7U)
/*! GMRC - Global Master ID Replication Control
 *  0b0..Master ID replication disabled for all channels
 *  0b1..Master ID replication available and controlled by each channel's CHn_SBR[EMI] setting
 */
#define DMA_MP_CSR_GMRC(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_GMRC_SHIFT)) & DMA_MP_CSR_GMRC_MASK)

#define DMA_MP_CSR_ECX_MASK                      (0x100U)
#define DMA_MP_CSR_ECX_SHIFT                     (8U)
/*! ECX - Cancel Transfer With Error
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_MP_CSR_ECX(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ECX_SHIFT)) & DMA_MP_CSR_ECX_MASK)

#define DMA_MP_CSR_CX_MASK                       (0x200U)
#define DMA_MP_CSR_CX_SHIFT                      (9U)
/*! CX - Cancel Transfer
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_MP_CSR_CX(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_CX_SHIFT)) & DMA_MP_CSR_CX_MASK)

#define DMA_MP_CSR_ACTIVE_ID_MASK                (0x7000000U)
#define DMA_MP_CSR_ACTIVE_ID_SHIFT               (24U)
/*! ACTIVE_ID - Active Channel ID */
#define DMA_MP_CSR_ACTIVE_ID(x)                  (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ACTIVE_ID_SHIFT)) & DMA_MP_CSR_ACTIVE_ID_MASK)

#define DMA_MP_CSR_ACTIVE_MASK                   (0x80000000U)
#define DMA_MP_CSR_ACTIVE_SHIFT                  (31U)
/*! ACTIVE - DMA Active Status
 *  0b0..eDMA is idle
 *  0b1..eDMA is executing a channel
 */
#define DMA_MP_CSR_ACTIVE(x)                     (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ACTIVE_SHIFT)) & DMA_MP_CSR_ACTIVE_MASK)
/*! @} */

/*! @name MP_ES - Management Page Error Status */
/*! @{ */

#define DMA_MP_ES_DBE_MASK                       (0x1U)
#define DMA_MP_ES_DBE_SHIFT                      (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..Last recorded error was a bus error on a destination write
 */
#define DMA_MP_ES_DBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DBE_SHIFT)) & DMA_MP_ES_DBE_MASK)

#define DMA_MP_ES_SBE_MASK                       (0x2U)
#define DMA_MP_ES_SBE_SHIFT                      (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error
 *  0b1..Last recorded error was a bus error on a source read
 */
#define DMA_MP_ES_SBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SBE_SHIFT)) & DMA_MP_ES_SBE_MASK)

#define DMA_MP_ES_SGE_MASK                       (0x4U)
#define DMA_MP_ES_SGE_SHIFT                      (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DLAST_SGA field
 */
#define DMA_MP_ES_SGE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SGE_SHIFT)) & DMA_MP_ES_SGE_MASK)

#define DMA_MP_ES_NCE_MASK                       (0x8U)
#define DMA_MP_ES_NCE_SHIFT                      (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error
 *  0b1..The last recorded error was NBYTES equal to zero or a CITER not equal to BITER error
 */
#define DMA_MP_ES_NCE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_NCE_SHIFT)) & DMA_MP_ES_NCE_MASK)

#define DMA_MP_ES_DOE_MASK                       (0x10U)
#define DMA_MP_ES_DOE_SHIFT                      (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DOFF field
 */
#define DMA_MP_ES_DOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DOE_SHIFT)) & DMA_MP_ES_DOE_MASK)

#define DMA_MP_ES_DAE_MASK                       (0x20U)
#define DMA_MP_ES_DAE_SHIFT                      (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DADDR field
 */
#define DMA_MP_ES_DAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DAE_SHIFT)) & DMA_MP_ES_DAE_MASK)

#define DMA_MP_ES_SOE_MASK                       (0x40U)
#define DMA_MP_ES_SOE_SHIFT                      (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SOFF field
 */
#define DMA_MP_ES_SOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SOE_SHIFT)) & DMA_MP_ES_SOE_MASK)

#define DMA_MP_ES_SAE_MASK                       (0x80U)
#define DMA_MP_ES_SAE_SHIFT                      (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SADDR field
 */
#define DMA_MP_ES_SAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SAE_SHIFT)) & DMA_MP_ES_SAE_MASK)

#define DMA_MP_ES_ECX_MASK                       (0x100U)
#define DMA_MP_ES_ECX_SHIFT                      (8U)
/*! ECX - Transfer Canceled
 *  0b0..No canceled transfers
 *  0b1..Last recorded entry was a canceled transfer by the error cancel transfer input
 */
#define DMA_MP_ES_ECX(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_ECX_SHIFT)) & DMA_MP_ES_ECX_MASK)

#define DMA_MP_ES_ERRCHN_MASK                    (0x7000000U)
#define DMA_MP_ES_ERRCHN_SHIFT                   (24U)
/*! ERRCHN - Error Channel Number or Canceled Channel Number */
#define DMA_MP_ES_ERRCHN(x)                      (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_ERRCHN_SHIFT)) & DMA_MP_ES_ERRCHN_MASK)

#define DMA_MP_ES_VLD_MASK                       (0x80000000U)
#define DMA_MP_ES_VLD_SHIFT                      (31U)
/*! VLD - Valid
 *  0b0..No CHn_ES[ERR] fields are set to 1
 *  0b1..At least one CHn_ES[ERR] field is set to 1, indicating a valid error exists that software has not cleared
 */
#define DMA_MP_ES_VLD(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_VLD_SHIFT)) & DMA_MP_ES_VLD_MASK)
/*! @} */

/*! @name MP_INT - Management Page Interrupt Request Status */
/*! @{ */

#define DMA_MP_INT_INT_MASK                      (0xFFU)
#define DMA_MP_INT_INT_SHIFT                     (0U)
/*! INT - Interrupt Request Status */
#define DMA_MP_INT_INT(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_INT_INT_SHIFT)) & DMA_MP_INT_INT_MASK)
/*! @} */

/*! @name MP_HRS - Management Page Hardware Request Status */
/*! @{ */

#define DMA_MP_HRS_HRS_MASK                      (0xFFFFFFFFU)
#define DMA_MP_HRS_HRS_SHIFT                     (0U)
/*! HRS - Hardware Request Status */
#define DMA_MP_HRS_HRS(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_HRS_HRS_SHIFT)) & DMA_MP_HRS_HRS_MASK)
/*! @} */

/*! @name CH_GRPRI - Channel Arbitration Group */
/*! @{ */

#define DMA_CH_GRPRI_GRPRI_MASK                  (0x1FU)
#define DMA_CH_GRPRI_GRPRI_SHIFT                 (0U)
/*! GRPRI - Arbitration Group For Channel n */
#define DMA_CH_GRPRI_GRPRI(x)                    (((uint32_t)(((uint32_t)(x)) << DMA_CH_GRPRI_GRPRI_SHIFT)) & DMA_CH_GRPRI_GRPRI_MASK)
/*! @} */

/* The count of DMA_CH_GRPRI */
#define DMA_CH_GRPRI_COUNT                       (8U)

/*! @name CH_CSR - Channel Control and Status */
/*! @{ */

#define DMA_CH_CSR_ERQ_MASK                      (0x1U)
#define DMA_CH_CSR_ERQ_SHIFT                     (0U)
/*! ERQ - Enable DMA Request
 *  0b0..DMA hardware request signal for corresponding channel disabled
 *  0b1..DMA hardware request signal for corresponding channel enabled
 */
#define DMA_CH_CSR_ERQ(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_ERQ_SHIFT)) & DMA_CH_CSR_ERQ_MASK)

#define DMA_CH_CSR_EARQ_MASK                     (0x2U)
#define DMA_CH_CSR_EARQ_SHIFT                    (1U)
/*! EARQ - Enable Asynchronous DMA Request
 *  0b0..Disable asynchronous DMA request for the channel
 *  0b1..Enable asynchronous DMA request for the channel
 */
#define DMA_CH_CSR_EARQ(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EARQ_SHIFT)) & DMA_CH_CSR_EARQ_MASK)

#define DMA_CH_CSR_EEI_MASK                      (0x4U)
#define DMA_CH_CSR_EEI_SHIFT                     (2U)
/*! EEI - Enable Error Interrupt
 *  0b0..Error signal for corresponding channel does not generate error interrupt
 *  0b1..Assertion of error signal for corresponding channel generates error interrupt request
 */
#define DMA_CH_CSR_EEI(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EEI_SHIFT)) & DMA_CH_CSR_EEI_MASK)

#define DMA_CH_CSR_EBW_MASK                      (0x8U)
#define DMA_CH_CSR_EBW_SHIFT                     (3U)
/*! EBW - Enable Buffered Writes
 *  0b0..Buffered writes on system bus disabled
 *  0b1..Buffered writes on system bus enabled
 */
#define DMA_CH_CSR_EBW(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EBW_SHIFT)) & DMA_CH_CSR_EBW_MASK)

#define DMA_CH_CSR_DONE_MASK                     (0x40000000U)
#define DMA_CH_CSR_DONE_SHIFT                    (30U)
/*! DONE - Channel Done */
#define DMA_CH_CSR_DONE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_DONE_SHIFT)) & DMA_CH_CSR_DONE_MASK)

#define DMA_CH_CSR_ACTIVE_MASK                   (0x80000000U)
#define DMA_CH_CSR_ACTIVE_SHIFT                  (31U)
/*! ACTIVE - Channel Active */
#define DMA_CH_CSR_ACTIVE(x)                     (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_ACTIVE_SHIFT)) & DMA_CH_CSR_ACTIVE_MASK)
/*! @} */

/* The count of DMA_CH_CSR */
#define DMA_CH_CSR_COUNT                         (8U)

/*! @name CH_ES - Channel Error Status */
/*! @{ */

#define DMA_CH_ES_DBE_MASK                       (0x1U)
#define DMA_CH_ES_DBE_SHIFT                      (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..Last recorded error was bus error on destination write
 */
#define DMA_CH_ES_DBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DBE_SHIFT)) & DMA_CH_ES_DBE_MASK)

#define DMA_CH_ES_SBE_MASK                       (0x2U)
#define DMA_CH_ES_SBE_SHIFT                      (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error
 *  0b1..Last recorded error was bus error on source read
 */
#define DMA_CH_ES_SBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SBE_SHIFT)) & DMA_CH_ES_SBE_MASK)

#define DMA_CH_ES_SGE_MASK                       (0x4U)
#define DMA_CH_ES_SGE_SHIFT                      (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DLAST_SGA field
 */
#define DMA_CH_ES_SGE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SGE_SHIFT)) & DMA_CH_ES_SGE_MASK)

#define DMA_CH_ES_NCE_MASK                       (0x8U)
#define DMA_CH_ES_NCE_SHIFT                      (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_NBYTES or TCDn_CITER fields
 */
#define DMA_CH_ES_NCE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_NCE_SHIFT)) & DMA_CH_ES_NCE_MASK)

#define DMA_CH_ES_DOE_MASK                       (0x10U)
#define DMA_CH_ES_DOE_SHIFT                      (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DOFF field
 */
#define DMA_CH_ES_DOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DOE_SHIFT)) & DMA_CH_ES_DOE_MASK)

#define DMA_CH_ES_DAE_MASK                       (0x20U)
#define DMA_CH_ES_DAE_SHIFT                      (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DADDR field
 */
#define DMA_CH_ES_DAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DAE_SHIFT)) & DMA_CH_ES_DAE_MASK)

#define DMA_CH_ES_SOE_MASK                       (0x40U)
#define DMA_CH_ES_SOE_SHIFT                      (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SOFF field
 */
#define DMA_CH_ES_SOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SOE_SHIFT)) & DMA_CH_ES_SOE_MASK)

#define DMA_CH_ES_SAE_MASK                       (0x80U)
#define DMA_CH_ES_SAE_SHIFT                      (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SADDR field
 */
#define DMA_CH_ES_SAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SAE_SHIFT)) & DMA_CH_ES_SAE_MASK)

#define DMA_CH_ES_ERR_MASK                       (0x80000000U)
#define DMA_CH_ES_ERR_SHIFT                      (31U)
/*! ERR - Error In Channel
 *  0b0..An error in this channel has not occurred
 *  0b1..An error in this channel has occurred
 */
#define DMA_CH_ES_ERR(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_ERR_SHIFT)) & DMA_CH_ES_ERR_MASK)
/*! @} */

/* The count of DMA_CH_ES */
#define DMA_CH_ES_COUNT                          (8U)

/*! @name CH_INT - Channel Interrupt Status */
/*! @{ */

#define DMA_CH_INT_INT_MASK                      (0x1U)
#define DMA_CH_INT_INT_SHIFT                     (0U)
/*! INT - Interrupt Request
 *  0b0..Interrupt request for corresponding channel cleared
 *  0b1..Interrupt request for corresponding channel active
 */
#define DMA_CH_INT_INT(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_INT_INT_SHIFT)) & DMA_CH_INT_INT_MASK)
/*! @} */

/* The count of DMA_CH_INT */
#define DMA_CH_INT_COUNT                         (8U)

/*! @name CH_SBR - Channel System Bus */
/*! @{ */

#define DMA_CH_SBR_MID_MASK                      (0xFU)
#define DMA_CH_SBR_MID_SHIFT                     (0U)
/*! MID - Master ID */
#define DMA_CH_SBR_MID(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_MID_SHIFT)) & DMA_CH_SBR_MID_MASK)

#define DMA_CH_SBR_PAL_MASK                      (0x8000U)
#define DMA_CH_SBR_PAL_SHIFT                     (15U)
/*! PAL - Privileged Access Level
 *  0b0..User protection level for DMA transfers
 *  0b1..Privileged protection level for DMA transfers
 */
#define DMA_CH_SBR_PAL(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_PAL_SHIFT)) & DMA_CH_SBR_PAL_MASK)

#define DMA_CH_SBR_EMI_MASK                      (0x10000U)
#define DMA_CH_SBR_EMI_SHIFT                     (16U)
/*! EMI - Enable Master ID Replication
 *  0b0..Master ID replication is disabled
 *  0b1..Master ID replication is enabled
 */
#define DMA_CH_SBR_EMI(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_EMI_SHIFT)) & DMA_CH_SBR_EMI_MASK)
/*! @} */

/* The count of DMA_CH_SBR */
#define DMA_CH_SBR_COUNT                         (8U)

/*! @name CH_PRI - Channel Priority */
/*! @{ */

#define DMA_CH_PRI_APL_MASK                      (0x7U)
#define DMA_CH_PRI_APL_SHIFT                     (0U)
/*! APL - Arbitration Priority Level */
#define DMA_CH_PRI_APL(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_APL_SHIFT)) & DMA_CH_PRI_APL_MASK)

#define DMA_CH_PRI_DPA_MASK                      (0x40000000U)
#define DMA_CH_PRI_DPA_SHIFT                     (30U)
/*! DPA - Disable Preempt Ability
 *  0b0..Channel can suspend a lower-priority channel
 *  0b1..Channel cannot suspend any other channel, regardless of channel priority
 */
#define DMA_CH_PRI_DPA(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_DPA_SHIFT)) & DMA_CH_PRI_DPA_MASK)

#define DMA_CH_PRI_ECP_MASK                      (0x80000000U)
#define DMA_CH_PRI_ECP_SHIFT                     (31U)
/*! ECP - Enable Channel Preemption
 *  0b0..Channel cannot be suspended by a higher-priority channel's service request
 *  0b1..Channel can be temporarily suspended by a higher-priority channel's service request
 */
#define DMA_CH_PRI_ECP(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_ECP_SHIFT)) & DMA_CH_PRI_ECP_MASK)
/*! @} */

/* The count of DMA_CH_PRI */
#define DMA_CH_PRI_COUNT                         (8U)

/*! @name CH_MUX - Channel Multiplexor Configuration */
/*! @{ */

#define DMA_CH_MUX_SRC_MASK                      (0x7FU)
#define DMA_CH_MUX_SRC_SHIFT                     (0U)
/*! SRC - Service Request Source */
#define DMA_CH_MUX_SRC(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_MUX_SRC_SHIFT)) & DMA_CH_MUX_SRC_MASK)
/*! @} */

/* The count of DMA_CH_MUX */
#define DMA_CH_MUX_COUNT                         (8U)

/*! @name TCD_SADDR - TCD Source Address */
/*! @{ */

#define DMA_TCD_SADDR_SADDR_MASK                 (0xFFFFFFFFU)
#define DMA_TCD_SADDR_SADDR_SHIFT                (0U)
/*! SADDR - Source Address */
#define DMA_TCD_SADDR_SADDR(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_TCD_SADDR_SADDR_SHIFT)) & DMA_TCD_SADDR_SADDR_MASK)
/*! @} */

/* The count of DMA_TCD_SADDR */
#define DMA_TCD_SADDR_COUNT                      (8U)

/*! @name TCD_SOFF - TCD Signed Source Address Offset */
/*! @{ */

#define DMA_TCD_SOFF_SOFF_MASK                   (0xFFFFU)
#define DMA_TCD_SOFF_SOFF_SHIFT                  (0U)
/*! SOFF - Source Address Signed Offset */
#define DMA_TCD_SOFF_SOFF(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_SOFF_SOFF_SHIFT)) & DMA_TCD_SOFF_SOFF_MASK)
/*! @} */

/* The count of DMA_TCD_SOFF */
#define DMA_TCD_SOFF_COUNT                       (8U)

/*! @name TCD_ATTR - TCD Transfer Attributes */
/*! @{ */

#define DMA_TCD_ATTR_DSIZE_MASK                  (0x7U)
#define DMA_TCD_ATTR_DSIZE_SHIFT                 (0U)
/*! DSIZE - Destination Data Transfer Size */
#define DMA_TCD_ATTR_DSIZE(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_DSIZE_SHIFT)) & DMA_TCD_ATTR_DSIZE_MASK)

#define DMA_TCD_ATTR_DMOD_MASK                   (0xF8U)
#define DMA_TCD_ATTR_DMOD_SHIFT                  (3U)
/*! DMOD - Destination Address Modulo */
#define DMA_TCD_ATTR_DMOD(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_DMOD_SHIFT)) & DMA_TCD_ATTR_DMOD_MASK)

#define DMA_TCD_ATTR_SSIZE_MASK                  (0x700U)
#define DMA_TCD_ATTR_SSIZE_SHIFT                 (8U)
/*! SSIZE - Source Data Transfer Size
 *  0b000..8-bit
 *  0b001..16-bit
 *  0b010..32-bit
 *  0b011..64-bit
 *  0b100..16-byte
 *  0b101..32-byte
 *  0b110..
 *  0b111..
 */
#define DMA_TCD_ATTR_SSIZE(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_SSIZE_SHIFT)) & DMA_TCD_ATTR_SSIZE_MASK)

#define DMA_TCD_ATTR_SMOD_MASK                   (0xF800U)
#define DMA_TCD_ATTR_SMOD_SHIFT                  (11U)
/*! SMOD - Source Address Modulo
 *  0b00000..Source address modulo feature disabled
 *  0b00001..Source address modulo feature enabled for any non-zero value [1-31]
 */
#define DMA_TCD_ATTR_SMOD(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_SMOD_SHIFT)) & DMA_TCD_ATTR_SMOD_MASK)
/*! @} */

/* The count of DMA_TCD_ATTR */
#define DMA_TCD_ATTR_COUNT                       (8U)

/*! @name TCD_NBYTES_MLOFFNO - TCD Transfer Size Without Minor Loop Offsets */
/*! @{ */

#define DMA_TCD_NBYTES_MLOFFNO_NBYTES_MASK       (0x3FFFFFFFU)
#define DMA_TCD_NBYTES_MLOFFNO_NBYTES_SHIFT      (0U)
/*! NBYTES - Number of Bytes To Transfer Per Service Request */
#define DMA_TCD_NBYTES_MLOFFNO_NBYTES(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_NBYTES_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_NBYTES_MASK)

#define DMA_TCD_NBYTES_MLOFFNO_DMLOE_MASK        (0x40000000U)
#define DMA_TCD_NBYTES_MLOFFNO_DMLOE_SHIFT       (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to DADDR
 *  0b1..Minor loop offset applied to DADDR
 */
#define DMA_TCD_NBYTES_MLOFFNO_DMLOE(x)          (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_DMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_DMLOE_MASK)

#define DMA_TCD_NBYTES_MLOFFNO_SMLOE_MASK        (0x80000000U)
#define DMA_TCD_NBYTES_MLOFFNO_SMLOE_SHIFT       (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to SADDR
 *  0b1..Minor loop offset applied to SADDR
 */
#define DMA_TCD_NBYTES_MLOFFNO_SMLOE(x)          (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_SMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_SMLOE_MASK)
/*! @} */

/* The count of DMA_TCD_NBYTES_MLOFFNO */
#define DMA_TCD_NBYTES_MLOFFNO_COUNT             (8U)

/*! @name TCD_NBYTES_MLOFFYES - TCD Transfer Size with Minor Loop Offsets */
/*! @{ */

#define DMA_TCD_NBYTES_MLOFFYES_NBYTES_MASK      (0x3FFU)
#define DMA_TCD_NBYTES_MLOFFYES_NBYTES_SHIFT     (0U)
/*! NBYTES - Number of Bytes To Transfer Per Service Request */
#define DMA_TCD_NBYTES_MLOFFYES_NBYTES(x)        (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_NBYTES_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_NBYTES_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_MLOFF_MASK       (0x3FFFFC00U)
#define DMA_TCD_NBYTES_MLOFFYES_MLOFF_SHIFT      (10U)
/*! MLOFF - Minor Loop Offset */
#define DMA_TCD_NBYTES_MLOFFYES_MLOFF(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_MLOFF_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_MLOFF_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_DMLOE_MASK       (0x40000000U)
#define DMA_TCD_NBYTES_MLOFFYES_DMLOE_SHIFT      (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to DADDR
 *  0b1..Minor loop offset applied to DADDR
 */
#define DMA_TCD_NBYTES_MLOFFYES_DMLOE(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_DMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_DMLOE_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_SMLOE_MASK       (0x80000000U)
#define DMA_TCD_NBYTES_MLOFFYES_SMLOE_SHIFT      (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to SADDR
 *  0b1..Minor loop offset applied to SADDR
 */
#define DMA_TCD_NBYTES_MLOFFYES_SMLOE(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_SMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_SMLOE_MASK)
/*! @} */

/* The count of DMA_TCD_NBYTES_MLOFFYES */
#define DMA_TCD_NBYTES_MLOFFYES_COUNT            (8U)

/*! @name TCD_SLAST_SDA - TCD Last Source Address Adjustment / Store DADDR Address */
/*! @{ */

#define DMA_TCD_SLAST_SDA_SLAST_SDA_MASK         (0xFFFFFFFFU)
#define DMA_TCD_SLAST_SDA_SLAST_SDA_SHIFT        (0U)
/*! SLAST_SDA - Last Source Address Adjustment / Store DADDR Address */
#define DMA_TCD_SLAST_SDA_SLAST_SDA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_TCD_SLAST_SDA_SLAST_SDA_SHIFT)) & DMA_TCD_SLAST_SDA_SLAST_SDA_MASK)
/*! @} */

/* The count of DMA_TCD_SLAST_SDA */
#define DMA_TCD_SLAST_SDA_COUNT                  (8U)

/*! @name TCD_DADDR - TCD Destination Address */
/*! @{ */

#define DMA_TCD_DADDR_DADDR_MASK                 (0xFFFFFFFFU)
#define DMA_TCD_DADDR_DADDR_SHIFT                (0U)
/*! DADDR - Destination Address */
#define DMA_TCD_DADDR_DADDR(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_TCD_DADDR_DADDR_SHIFT)) & DMA_TCD_DADDR_DADDR_MASK)
/*! @} */

/* The count of DMA_TCD_DADDR */
#define DMA_TCD_DADDR_COUNT                      (8U)

/*! @name TCD_DOFF - TCD Signed Destination Address Offset */
/*! @{ */

#define DMA_TCD_DOFF_DOFF_MASK                   (0xFFFFU)
#define DMA_TCD_DOFF_DOFF_SHIFT                  (0U)
/*! DOFF - Destination Address Signed Offset */
#define DMA_TCD_DOFF_DOFF(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_DOFF_DOFF_SHIFT)) & DMA_TCD_DOFF_DOFF_MASK)
/*! @} */

/* The count of DMA_TCD_DOFF */
#define DMA_TCD_DOFF_COUNT                       (8U)

/*! @name TCD_CITER_ELINKNO - TCD Current Major Loop Count (Minor Loop Channel Linking Disabled) */
/*! @{ */

#define DMA_TCD_CITER_ELINKNO_CITER_MASK         (0x7FFFU)
#define DMA_TCD_CITER_ELINKNO_CITER_SHIFT        (0U)
/*! CITER - Current Major Iteration Count */
#define DMA_TCD_CITER_ELINKNO_CITER(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKNO_CITER_SHIFT)) & DMA_TCD_CITER_ELINKNO_CITER_MASK)

#define DMA_TCD_CITER_ELINKNO_ELINK_MASK         (0x8000U)
#define DMA_TCD_CITER_ELINKNO_ELINK_SHIFT        (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CITER_ELINKNO_ELINK(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKNO_ELINK_SHIFT)) & DMA_TCD_CITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_CITER_ELINKNO */
#define DMA_TCD_CITER_ELINKNO_COUNT              (8U)

/*! @name TCD_CITER_ELINKYES - TCD Current Major Loop Count (Minor Loop Channel Linking Enabled) */
/*! @{ */

#define DMA_TCD_CITER_ELINKYES_CITER_MASK        (0x1FFU)
#define DMA_TCD_CITER_ELINKYES_CITER_SHIFT       (0U)
/*! CITER - Current Major Iteration Count */
#define DMA_TCD_CITER_ELINKYES_CITER(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_CITER_SHIFT)) & DMA_TCD_CITER_ELINKYES_CITER_MASK)

#define DMA_TCD_CITER_ELINKYES_LINKCH_MASK       (0xE00U)
#define DMA_TCD_CITER_ELINKYES_LINKCH_SHIFT      (9U)
/*! LINKCH - Minor Loop Link Channel Number */
#define DMA_TCD_CITER_ELINKYES_LINKCH(x)         (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_LINKCH_SHIFT)) & DMA_TCD_CITER_ELINKYES_LINKCH_MASK)

#define DMA_TCD_CITER_ELINKYES_ELINK_MASK        (0x8000U)
#define DMA_TCD_CITER_ELINKYES_ELINK_SHIFT       (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CITER_ELINKYES_ELINK(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_ELINK_SHIFT)) & DMA_TCD_CITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_CITER_ELINKYES */
#define DMA_TCD_CITER_ELINKYES_COUNT             (8U)

/*! @name TCD_DLAST_SGA - TCD Last Destination Address Adjustment / Scatter Gather Address */
/*! @{ */

#define DMA_TCD_DLAST_SGA_DLAST_SGA_MASK         (0xFFFFFFFFU)
#define DMA_TCD_DLAST_SGA_DLAST_SGA_SHIFT        (0U)
/*! DLAST_SGA - Last Destination Address Adjustment / Scatter Gather Address */
#define DMA_TCD_DLAST_SGA_DLAST_SGA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_TCD_DLAST_SGA_DLAST_SGA_SHIFT)) & DMA_TCD_DLAST_SGA_DLAST_SGA_MASK)
/*! @} */

/* The count of DMA_TCD_DLAST_SGA */
#define DMA_TCD_DLAST_SGA_COUNT                  (8U)

/*! @name TCD_CSR - TCD Control and Status */
/*! @{ */

#define DMA_TCD_CSR_START_MASK                   (0x1U)
#define DMA_TCD_CSR_START_SHIFT                  (0U)
/*! START - Channel Start
 *  0b0..Channel not explicitly started
 *  0b1..Channel explicitly started via a software-initiated service request
 */
#define DMA_TCD_CSR_START(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_START_SHIFT)) & DMA_TCD_CSR_START_MASK)

#define DMA_TCD_CSR_INTMAJOR_MASK                (0x2U)
#define DMA_TCD_CSR_INTMAJOR_SHIFT               (1U)
/*! INTMAJOR - Enable Interrupt If Major count complete
 *  0b0..End-of-major loop interrupt disabled
 *  0b1..End-of-major loop interrupt enabled
 */
#define DMA_TCD_CSR_INTMAJOR(x)                  (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_INTMAJOR_SHIFT)) & DMA_TCD_CSR_INTMAJOR_MASK)

#define DMA_TCD_CSR_INTHALF_MASK                 (0x4U)
#define DMA_TCD_CSR_INTHALF_SHIFT                (2U)
/*! INTHALF - Enable Interrupt If Major Counter Half-complete
 *  0b0..Halfway point interrupt disabled
 *  0b1..Halfway point interrupt enabled
 */
#define DMA_TCD_CSR_INTHALF(x)                   (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_INTHALF_SHIFT)) & DMA_TCD_CSR_INTHALF_MASK)

#define DMA_TCD_CSR_DREQ_MASK                    (0x8U)
#define DMA_TCD_CSR_DREQ_SHIFT                   (3U)
/*! DREQ - Disable Request
 *  0b0..No operation
 *  0b1..Clear the ERQ field to 0 upon major loop completion, thus disabling hardware service requests
 */
#define DMA_TCD_CSR_DREQ(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_DREQ_SHIFT)) & DMA_TCD_CSR_DREQ_MASK)

#define DMA_TCD_CSR_ESG_MASK                     (0x10U)
#define DMA_TCD_CSR_ESG_SHIFT                    (4U)
/*! ESG - Enable Scatter/Gather Processing
 *  0b0..Current channel's TCD is normal format
 *  0b1..Current channel's TCD specifies scatter/gather format.
 */
#define DMA_TCD_CSR_ESG(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_ESG_SHIFT)) & DMA_TCD_CSR_ESG_MASK)

#define DMA_TCD_CSR_MAJORELINK_MASK              (0x20U)
#define DMA_TCD_CSR_MAJORELINK_SHIFT             (5U)
/*! MAJORELINK - Enable Link When Major Loop Complete
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CSR_MAJORELINK(x)                (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_MAJORELINK_SHIFT)) & DMA_TCD_CSR_MAJORELINK_MASK)

#define DMA_TCD_CSR_EEOP_MASK                    (0x40U)
#define DMA_TCD_CSR_EEOP_SHIFT                   (6U)
/*! EEOP - Enable End-Of-Packet Processing
 *  0b0..End-of-packet operation disabled
 *  0b1..End-of-packet hardware input signal enabled
 */
#define DMA_TCD_CSR_EEOP(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_EEOP_SHIFT)) & DMA_TCD_CSR_EEOP_MASK)

#define DMA_TCD_CSR_ESDA_MASK                    (0x80U)
#define DMA_TCD_CSR_ESDA_SHIFT                   (7U)
/*! ESDA - Enable Store Destination Address
 *  0b0..Ability to store destination address to system memory disabled
 *  0b1..Ability to store destination address to system memory enabled
 */
#define DMA_TCD_CSR_ESDA(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_ESDA_SHIFT)) & DMA_TCD_CSR_ESDA_MASK)

#define DMA_TCD_CSR_MAJORLINKCH_MASK             (0x700U)
#define DMA_TCD_CSR_MAJORLINKCH_SHIFT            (8U)
/*! MAJORLINKCH - Major Loop Link Channel Number */
#define DMA_TCD_CSR_MAJORLINKCH(x)               (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_MAJORLINKCH_SHIFT)) & DMA_TCD_CSR_MAJORLINKCH_MASK)

#define DMA_TCD_CSR_BWC_MASK                     (0xC000U)
#define DMA_TCD_CSR_BWC_SHIFT                    (14U)
/*! BWC - Bandwidth Control
 *  0b00..No eDMA engine stalls
 *  0b01..
 *  0b10..eDMA engine stalls for 4 cycles after each R/W
 *  0b11..eDMA engine stalls for 8 cycles after each R/W
 */
#define DMA_TCD_CSR_BWC(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_BWC_SHIFT)) & DMA_TCD_CSR_BWC_MASK)
/*! @} */

/* The count of DMA_TCD_CSR */
#define DMA_TCD_CSR_COUNT                        (8U)

/*! @name TCD_BITER_ELINKNO - TCD Beginning Major Loop Count (Minor Loop Channel Linking Disabled) */
/*! @{ */

#define DMA_TCD_BITER_ELINKNO_BITER_MASK         (0x7FFFU)
#define DMA_TCD_BITER_ELINKNO_BITER_SHIFT        (0U)
/*! BITER - Starting Major Iteration Count */
#define DMA_TCD_BITER_ELINKNO_BITER(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKNO_BITER_SHIFT)) & DMA_TCD_BITER_ELINKNO_BITER_MASK)

#define DMA_TCD_BITER_ELINKNO_ELINK_MASK         (0x8000U)
#define DMA_TCD_BITER_ELINKNO_ELINK_SHIFT        (15U)
/*! ELINK - Enables Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_BITER_ELINKNO_ELINK(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKNO_ELINK_SHIFT)) & DMA_TCD_BITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_BITER_ELINKNO */
#define DMA_TCD_BITER_ELINKNO_COUNT              (8U)

/*! @name TCD_BITER_ELINKYES - TCD Beginning Major Loop Count (Minor Loop Channel Linking Enabled) */
/*! @{ */

#define DMA_TCD_BITER_ELINKYES_BITER_MASK        (0x1FFU)
#define DMA_TCD_BITER_ELINKYES_BITER_SHIFT       (0U)
/*! BITER - Starting Major Iteration Count */
#define DMA_TCD_BITER_ELINKYES_BITER(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_BITER_SHIFT)) & DMA_TCD_BITER_ELINKYES_BITER_MASK)

#define DMA_TCD_BITER_ELINKYES_LINKCH_MASK       (0xE00U)
#define DMA_TCD_BITER_ELINKYES_LINKCH_SHIFT      (9U)
/*! LINKCH - Link Channel Number */
#define DMA_TCD_BITER_ELINKYES_LINKCH(x)         (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_LINKCH_SHIFT)) & DMA_TCD_BITER_ELINKYES_LINKCH_MASK)

#define DMA_TCD_BITER_ELINKYES_ELINK_MASK        (0x8000U)
#define DMA_TCD_BITER_ELINKYES_ELINK_SHIFT       (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_BITER_ELINKYES_ELINK(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_ELINK_SHIFT)) & DMA_TCD_BITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_BITER_ELINKYES */
#define DMA_TCD_BITER_ELINKYES_COUNT             (8U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
/** Peripheral DMA0 base address */
#define DMA0_BASE                                (0x40080000u)
/** Peripheral DMA0 base pointer */
#define DMA0                                     ((DMA_Type *)DMA0_BASE)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS                           { DMA0_BASE }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS                            { DMA0 }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Peripheral_Access_Layer EIM Peripheral Access Layer
 * @{
 */

/** EIM - Register Layout Typedef */
typedef struct {
  __IO uint32_t EIMCR;                             /**< Error Injection Module Configuration Register, offset: 0x0 */
  __IO uint32_t EICHEN;                            /**< Error Injection Channel Enable register, offset: 0x4 */
       uint8_t RESERVED_0[248];
  __IO uint32_t EICHD0_WORD0;                      /**< Error Injection Channel Descriptor 0, Word0, offset: 0x100 */
  __IO uint32_t EICHD0_WORD1;                      /**< Error Injection Channel Descriptor 0, Word1, offset: 0x104 */
} EIM_Type;

/* ----------------------------------------------------------------------------
   -- EIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Register_Masks EIM Register Masks
 * @{
 */

/*! @name EIMCR - Error Injection Module Configuration Register */
/*! @{ */

#define EIM_EIMCR_GEIEN_MASK                     (0x1U)
#define EIM_EIMCR_GEIEN_SHIFT                    (0U)
/*! GEIEN - Global Error Injection Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EIM_EIMCR_GEIEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_EIMCR_GEIEN_SHIFT)) & EIM_EIMCR_GEIEN_MASK)
/*! @} */

/*! @name EICHEN - Error Injection Channel Enable register */
/*! @{ */

#define EIM_EICHEN_EICH0EN_MASK                  (0x80000000U)
#define EIM_EICHEN_EICH0EN_SHIFT                 (31U)
/*! EICH0EN - Error Injection Channel 0 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 0
 *  0b1..Error injection is enabled on Error Injection Channel 0
 */
#define EIM_EICHEN_EICH0EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH0EN_SHIFT)) & EIM_EICHEN_EICH0EN_MASK)
/*! @} */

/*! @name EICHD0_WORD0 - Error Injection Channel Descriptor 0, Word0 */
/*! @{ */

#define EIM_EICHD0_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD0_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD0_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD0_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD0_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD0_WORD1 - Error Injection Channel Descriptor 0, Word1 */
/*! @{ */

#define EIM_EICHD0_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD0_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD0_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD0_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD0_WORD1_B0_3DATA_MASK_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group EIM_Register_Masks */


/* EIM - Peripheral instance base addresses */
/** Peripheral EIM0 base address */
#define EIM0_BASE                                (0x4008C000u)
/** Peripheral EIM0 base pointer */
#define EIM0                                     ((EIM_Type *)EIM0_BASE)
/** Array initializer of EIM peripheral base addresses */
#define EIM_BASE_ADDRS                           { EIM0_BASE }
/** Array initializer of EIM peripheral base pointers */
#define EIM_BASE_PTRS                            { EIM0 }

/*!
 * @}
 */ /* end of group EIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EQDC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EQDC_Peripheral_Access_Layer EQDC Peripheral Access Layer
 * @{
 */

/** EQDC - Register Layout Typedef */
typedef struct {
  __IO uint16_t CTRL;                              /**< Control Register, offset: 0x0 */
  __IO uint16_t CTRL2;                             /**< Control 2 Register, offset: 0x2 */
  __IO uint16_t FILT;                              /**< Input Filter Register, offset: 0x4 */
  __I  uint16_t LASTEDGE;                          /**< Last Edge Time Register, offset: 0x6 */
  __I  uint16_t POSDPER;                           /**< Position Difference Period Counter Register, offset: 0x8 */
  __I  uint16_t POSDPERBFR;                        /**< Position Difference Period Buffer Register, offset: 0xA */
  __IO uint16_t UPOS;                              /**< Upper Position Counter Register, offset: 0xC */
  __IO uint16_t LPOS;                              /**< Lower Position Counter Register, offset: 0xE */
  __IO uint16_t POSD;                              /**< Position Difference Counter Register, offset: 0x10 */
  __I  uint16_t POSDH;                             /**< Position Difference Hold Register, offset: 0x12 */
  __I  uint16_t UPOSH;                             /**< Upper Position Hold Register, offset: 0x14 */
  __I  uint16_t LPOSH;                             /**< Lower Position Hold Register, offset: 0x16 */
  __I  uint16_t LASTEDGEH;                         /**< Last Edge Time Hold Register, offset: 0x18 */
  __I  uint16_t POSDPERH;                          /**< Position Difference Period Hold Register, offset: 0x1A */
  __I  uint16_t REVH;                              /**< Revolution Hold Register, offset: 0x1C */
  __IO uint16_t REV;                               /**< Revolution Counter Register, offset: 0x1E */
  __IO uint16_t UINIT;                             /**< Upper Initialization Register, offset: 0x20 */
  __IO uint16_t LINIT;                             /**< Lower Initialization Register, offset: 0x22 */
  __IO uint16_t UMOD;                              /**< Upper Modulus Register, offset: 0x24 */
  __IO uint16_t LMOD;                              /**< Lower Modulus Register, offset: 0x26 */
  __IO uint16_t UCOMP0;                            /**< Upper Position Compare Register 0, offset: 0x28 */
  __IO uint16_t LCOMP0;                            /**< Lower Position Compare Register 0, offset: 0x2A */
  union {                                          /* offset: 0x2C */
    __O  uint16_t UCOMP1;                            /**< Upper Position Compare 1, offset: 0x2C */
    __I  uint16_t UPOSH1;                            /**< Upper Position Holder Register 1, offset: 0x2C */
  };
  union {                                          /* offset: 0x2E */
    __O  uint16_t LCOMP1;                            /**< Lower Position Compare 1, offset: 0x2E */
    __I  uint16_t LPOSH1;                            /**< Lower Position Holder Register 1, offset: 0x2E */
  };
  union {                                          /* offset: 0x30 */
    __O  uint16_t UCOMP2;                            /**< Upper Position Compare 2, offset: 0x30 */
    __I  uint16_t UPOSH2;                            /**< Upper Position Holder Register 3, offset: 0x30 */
  };
  union {                                          /* offset: 0x32 */
    __O  uint16_t LCOMP2;                            /**< Lower Position Compare 2, offset: 0x32 */
    __I  uint16_t LPOSH2;                            /**< Lower Position Holder Register 2, offset: 0x32 */
  };
  union {                                          /* offset: 0x34 */
    __O  uint16_t UCOMP3;                            /**< Upper Position Compare 3, offset: 0x34 */
    __I  uint16_t UPOSH3;                            /**< Upper Position Holder Register 3, offset: 0x34 */
  };
  union {                                          /* offset: 0x36 */
    __O  uint16_t LCOMP3;                            /**< Lower Position Compare 3, offset: 0x36 */
    __I  uint16_t LPOSH3;                            /**< Lower Position Holder Register 3, offset: 0x36 */
  };
  __IO uint16_t INTCTRL;                           /**< Interrupt Control Register, offset: 0x38 */
  __IO uint16_t WTR;                               /**< Watchdog Timeout Register, offset: 0x3A */
  __IO uint16_t IMR;                               /**< Input Monitor Register, offset: 0x3C */
  __IO uint16_t TST;                               /**< Test Register, offset: 0x3E */
       uint8_t RESERVED_0[16];
  __I  uint16_t UVERID;                            /**< Upper VERID, offset: 0x50 */
  __I  uint16_t LVERID;                            /**< Lower VERID, offset: 0x52 */
} EQDC_Type;

/* ----------------------------------------------------------------------------
   -- EQDC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EQDC_Register_Masks EQDC Register Masks
 * @{
 */

/*! @name CTRL - Control Register */
/*! @{ */

#define EQDC_CTRL_LDOK_MASK                      (0x1U)
#define EQDC_CTRL_LDOK_SHIFT                     (0U)
/*! LDOK - Load Okay
 *  0b0..No loading action taken. Users can write new values to buffered registers (writing into outer-set of these buffered registers)
 *  0b1..Outer-set values are ready to be loaded into inner-set and take effect. The loading time point depends on CTRL2[LDMOD].
 */
#define EQDC_CTRL_LDOK(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_LDOK_SHIFT)) & EQDC_CTRL_LDOK_MASK)

#define EQDC_CTRL_DMAEN_MASK                     (0x2U)
#define EQDC_CTRL_DMAEN_SHIFT                    (1U)
/*! DMAEN - DMA Enable
 *  0b0..DMA is disabled
 *  0b1..DMA is enabled. DMA request asserts automatically when the values in the outer-set of buffered compare
 *       registers (UCOMP0/LCOMP0;UCOMP1/LCOMP1;UCOMP2/LCOMP2;UCOMP3/LCOMP3), initial registers(UINIT/LINIT) and
 *       modulus registers (UMOD/LMOD) are loaded into the inner-set of buffer and then LDOK is cleared automatically.
 *       After the completion of this DMA transfer, LDOK is set automatically, it ensures outer-set values can be
 *       loaded into inner-set which in turn triggers DMA again.
 */
#define EQDC_CTRL_DMAEN(x)                       (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_DMAEN_SHIFT)) & EQDC_CTRL_DMAEN_MASK)

#define EQDC_CTRL_WDE_MASK                       (0x4U)
#define EQDC_CTRL_WDE_SHIFT                      (2U)
/*! WDE - Watchdog Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_CTRL_WDE(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_WDE_SHIFT)) & EQDC_CTRL_WDE_MASK)

#define EQDC_CTRL_WDIE_MASK                      (0x8U)
#define EQDC_CTRL_WDIE_SHIFT                     (3U)
/*! WDIE - Watchdog Timeout Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_CTRL_WDIE(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_WDIE_SHIFT)) & EQDC_CTRL_WDIE_MASK)

#define EQDC_CTRL_WDIRQ_MASK                     (0x10U)
#define EQDC_CTRL_WDIRQ_SHIFT                    (4U)
/*! WDIRQ - Watchdog Timeout Interrupt Request
 *  0b0..No Watchdog timeout interrupt has occurred
 *  0b1..Watchdog timeout interrupt has occurred
 */
#define EQDC_CTRL_WDIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_WDIRQ_SHIFT)) & EQDC_CTRL_WDIRQ_MASK)

#define EQDC_CTRL_XNE_MASK                       (0x20U)
#define EQDC_CTRL_XNE_SHIFT                      (5U)
/*! XNE - Select Positive/Negative Edge of INDEX/PRESET Pulse
 *  0b0..Use positive edge of INDEX/PRESET pulse
 *  0b1..Use negative edge of INDEX/PRESET pulse
 */
#define EQDC_CTRL_XNE(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_XNE_SHIFT)) & EQDC_CTRL_XNE_MASK)

#define EQDC_CTRL_XIP_MASK                       (0x40U)
#define EQDC_CTRL_XIP_SHIFT                      (6U)
/*! XIP - INDEX Triggered Initialization of Position Counters UPOS and LPOS
 *  0b0..INDEX pulse does not initialize the position counter
 *  0b1..INDEX pulse initializes the position counter
 */
#define EQDC_CTRL_XIP(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_XIP_SHIFT)) & EQDC_CTRL_XIP_MASK)

#define EQDC_CTRL_XIE_MASK                       (0x80U)
#define EQDC_CTRL_XIE_SHIFT                      (7U)
/*! XIE - INDEX/PRESET Pulse Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_CTRL_XIE(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_XIE_SHIFT)) & EQDC_CTRL_XIE_MASK)

#define EQDC_CTRL_XIRQ_MASK                      (0x100U)
#define EQDC_CTRL_XIRQ_SHIFT                     (8U)
/*! XIRQ - INDEX/PRESET Pulse Interrupt Request
 *  0b0..INDEX/PRESET pulse has not occurred
 *  0b1..INDEX/PRESET pulse has occurred
 */
#define EQDC_CTRL_XIRQ(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_XIRQ_SHIFT)) & EQDC_CTRL_XIRQ_MASK)

#define EQDC_CTRL_PH1_MASK                       (0x200U)
#define EQDC_CTRL_PH1_SHIFT                      (9U)
/*! PH1 - Enable Single Phase Mode
 *  0b0..Standard quadrature decoder, where PHASEA and PHASEB represent a two-phase quadrature signal.
 *  0b1..Single phase mode, bypass the quadrature decoder, refer to CTRL2[CMODE] description
 */
#define EQDC_CTRL_PH1(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_PH1_SHIFT)) & EQDC_CTRL_PH1_MASK)

#define EQDC_CTRL_REV_MASK                       (0x400U)
#define EQDC_CTRL_REV_SHIFT                      (10U)
/*! REV - Enable Reverse Direction Counting
 *  0b0..Count normally and the position counter initialization uses upper/lower initialization register UINIT/LINIT
 *  0b1..Count in the reverse direction and the position counter initialization uses upper/lower modulus register UMOD/LMOD
 */
#define EQDC_CTRL_REV(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_REV_SHIFT)) & EQDC_CTRL_REV_MASK)

#define EQDC_CTRL_SWIP_MASK                      (0x800U)
#define EQDC_CTRL_SWIP_SHIFT                     (11U)
/*! SWIP - Software-Triggered Initialization of Position Counters UPOS and LPOS
 *  0b0..No action
 *  0b1..Initialize position counter
 */
#define EQDC_CTRL_SWIP(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_SWIP_SHIFT)) & EQDC_CTRL_SWIP_MASK)

#define EQDC_CTRL_HNE_MASK                       (0x1000U)
#define EQDC_CTRL_HNE_SHIFT                      (12U)
/*! HNE - Use Negative Edge of HOME/ENABLE Input
 *  0b0..When CTRL[OPMODE] = 0,use HOME positive edge to trigger initialization of position counters. When
 *       CTRL[OPMODE] = 1,use ENABLE high level to enable POS/POSD/WDG/REV counters
 *  0b1..When CTRL[OPMODE] = 0,use HOME negative edge to trigger initialization of position counters. When
 *       CTRL[OPMODE] = 1,use ENABLE low level to enable POS/POSD/WDG/REV counters
 */
#define EQDC_CTRL_HNE(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_HNE_SHIFT)) & EQDC_CTRL_HNE_MASK)

#define EQDC_CTRL_HIP_MASK                       (0x2000U)
#define EQDC_CTRL_HIP_SHIFT                      (13U)
/*! HIP - Enable HOME to Initialize Position Counter UPOS/LPOS
 *  0b0..No action
 *  0b1..HOME signal initializes the position counter
 */
#define EQDC_CTRL_HIP(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_HIP_SHIFT)) & EQDC_CTRL_HIP_MASK)

#define EQDC_CTRL_HIE_MASK                       (0x4000U)
#define EQDC_CTRL_HIE_SHIFT                      (14U)
/*! HIE - HOME/ENABLE Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_CTRL_HIE(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_HIE_SHIFT)) & EQDC_CTRL_HIE_MASK)

#define EQDC_CTRL_HIRQ_MASK                      (0x8000U)
#define EQDC_CTRL_HIRQ_SHIFT                     (15U)
/*! HIRQ - HOME/ENABLE Signal Transition Interrupt Request
 *  0b0..No transition on the HOME/ENABLE signal has occurred
 *  0b1..A transition on the HOME/ENABLE signal has occurred
 */
#define EQDC_CTRL_HIRQ(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL_HIRQ_SHIFT)) & EQDC_CTRL_HIRQ_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 Register */
/*! @{ */

#define EQDC_CTRL2_UPDHLD_MASK                   (0x1U)
#define EQDC_CTRL2_UPDHLD_SHIFT                  (0U)
/*! UPDHLD - Update Hold Registers */
#define EQDC_CTRL2_UPDHLD(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_UPDHLD_SHIFT)) & EQDC_CTRL2_UPDHLD_MASK)

#define EQDC_CTRL2_UPDPOS_MASK                   (0x2U)
#define EQDC_CTRL2_UPDPOS_SHIFT                  (1U)
/*! UPDPOS - Update Position Registers */
#define EQDC_CTRL2_UPDPOS(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_UPDPOS_SHIFT)) & EQDC_CTRL2_UPDPOS_MASK)

#define EQDC_CTRL2_OPMODE_MASK                   (0x4U)
#define EQDC_CTRL2_OPMODE_SHIFT                  (2U)
/*! OPMODE - Operation Mode Select
 *  0b0..Decode Mode: Input nodes INDEX/PRESET and HOME/ENABLE are assigned to function of INDEX and HOME.
 *  0b1..Count Mode: Input nodes INDEX/PRESET and HOME/ENABLE are assigned to functions of PRESET and ENABLE. In
 *       this mode: (1)only when ENABLE=1, all counters (position/position difference/revolution/watchdog) can run,
 *       when ENABLE=0, all counters (position/position difference/revolution/watchdog) can't run. (2) the rising
 *       edge of PRESET input can initialize position/revolution/watchdog counters (position counter initialization
 *       also need referring to bit CTRL[REV]).
 */
#define EQDC_CTRL2_OPMODE(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_OPMODE_SHIFT)) & EQDC_CTRL2_OPMODE_MASK)

#define EQDC_CTRL2_LDMOD_MASK                    (0x8U)
#define EQDC_CTRL2_LDMOD_SHIFT                   (3U)
/*! LDMOD - Buffered Register Load (Update) Mode Select
 *  0b0..Buffered registers are loaded and take effect immediately upon CTRL[LDOK] is set.
 *  0b1..Buffered registers are loaded and take effect at the next roll-over or roll-under if CTRL[LDOK] is set.
 */
#define EQDC_CTRL2_LDMOD(x)                      (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_LDMOD_SHIFT)) & EQDC_CTRL2_LDMOD_MASK)

#define EQDC_CTRL2_REVMOD_MASK                   (0x100U)
#define EQDC_CTRL2_REVMOD_SHIFT                  (8U)
/*! REVMOD - Revolution Counter Modulus Enable
 *  0b0..Use INDEX pulse to increment/decrement revolution counter (REV)
 *  0b1..Use modulus counting roll-over/under to increment/decrement revolution counter (REV)
 */
#define EQDC_CTRL2_REVMOD(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_REVMOD_SHIFT)) & EQDC_CTRL2_REVMOD_MASK)

#define EQDC_CTRL2_OUTCTL_MASK                   (0x200U)
#define EQDC_CTRL2_OUTCTL_SHIFT                  (9U)
/*! OUTCTL - Output Control
 *  0b0..POS_MATCH[x](x range is 0-3) is asserted when the Position Counter is equal to according compare value
 *       (UCOMPx/LCOMPx)(x range is 0-3), and de-asserted when the Position Counter not equal to the compare value
 *       (UCOMPx/LCOMPx)(x range is 0-3)
 *  0b1..All POS_MATCH[x](x range is 0-3) are asserted a pulse, when the UPOS, LPOS, REV, or POSD registers are read
 */
#define EQDC_CTRL2_OUTCTL(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_OUTCTL_SHIFT)) & EQDC_CTRL2_OUTCTL_MASK)

#define EQDC_CTRL2_PMEN_MASK                     (0x400U)
#define EQDC_CTRL2_PMEN_SHIFT                    (10U)
/*! PMEN - Period measurement function enable
 *  0b0..Period measurement functions are not used. POSD is loaded to POSDH and then cleared whenever POSD, UPOS, LPOS or REV is read.
 *  0b1..Period measurement functions are used. POSD is loaded into POSDH and then cleared only when POSD is read.
 */
#define EQDC_CTRL2_PMEN(x)                       (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_PMEN_SHIFT)) & EQDC_CTRL2_PMEN_MASK)

#define EQDC_CTRL2_EMIP_MASK                     (0x800U)
#define EQDC_CTRL2_EMIP_SHIFT                    (11U)
/*! EMIP - Enables/disables the position counter to be initialized by Index Event Edge Mark
 *  0b0..disables the position counter to be initialized by Index Event Edge Mark
 *  0b1..enables the position counter to be initialized by Index Event Edge Mark.
 */
#define EQDC_CTRL2_EMIP(x)                       (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_EMIP_SHIFT)) & EQDC_CTRL2_EMIP_MASK)

#define EQDC_CTRL2_INITPOS_MASK                  (0x1000U)
#define EQDC_CTRL2_INITPOS_SHIFT                 (12U)
/*! INITPOS - Initial Position Register
 *  0b0..Don't initialize position counter on rising edge of TRIGGER
 *  0b1..Initialize position counter on rising edge of TRIGGER
 */
#define EQDC_CTRL2_INITPOS(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_INITPOS_SHIFT)) & EQDC_CTRL2_INITPOS_MASK)

#define EQDC_CTRL2_ONCE_MASK                     (0x2000U)
#define EQDC_CTRL2_ONCE_SHIFT                    (13U)
/*! ONCE - Count Once
 *  0b0..Position counter counts repeatedly
 *  0b1..Position counter counts until roll-over or roll-under, then stop.
 */
#define EQDC_CTRL2_ONCE(x)                       (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_ONCE_SHIFT)) & EQDC_CTRL2_ONCE_MASK)

#define EQDC_CTRL2_CMODE_MASK                    (0xC000U)
#define EQDC_CTRL2_CMODE_SHIFT                   (14U)
/*! CMODE - Counting Mode */
#define EQDC_CTRL2_CMODE(x)                      (((uint16_t)(((uint16_t)(x)) << EQDC_CTRL2_CMODE_SHIFT)) & EQDC_CTRL2_CMODE_MASK)
/*! @} */

/*! @name FILT - Input Filter Register */
/*! @{ */

#define EQDC_FILT_FILT_PER_MASK                  (0xFFU)
#define EQDC_FILT_FILT_PER_SHIFT                 (0U)
/*! FILT_PER - Input Filter Sample Period */
#define EQDC_FILT_FILT_PER(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_FILT_FILT_PER_SHIFT)) & EQDC_FILT_FILT_PER_MASK)

#define EQDC_FILT_FILT_CNT_MASK                  (0x700U)
#define EQDC_FILT_FILT_CNT_SHIFT                 (8U)
/*! FILT_CNT - Input Filter Sample Count */
#define EQDC_FILT_FILT_CNT(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_FILT_FILT_CNT_SHIFT)) & EQDC_FILT_FILT_CNT_MASK)

#define EQDC_FILT_FILT_CS_MASK                   (0x800U)
#define EQDC_FILT_FILT_CS_SHIFT                  (11U)
/*! FILT_CS - Filter Clock Source selection
 *  0b0..Peripheral Clock
 *  0b1..Prescaled peripheral clock by PRSC
 */
#define EQDC_FILT_FILT_CS(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_FILT_FILT_CS_SHIFT)) & EQDC_FILT_FILT_CS_MASK)

#define EQDC_FILT_PRSC_MASK                      (0xF000U)
#define EQDC_FILT_PRSC_SHIFT                     (12U)
/*! PRSC - Prescaler */
#define EQDC_FILT_PRSC(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_FILT_PRSC_SHIFT)) & EQDC_FILT_PRSC_MASK)
/*! @} */

/*! @name LASTEDGE - Last Edge Time Register */
/*! @{ */

#define EQDC_LASTEDGE_LASTEDGE_MASK              (0xFFFFU)
#define EQDC_LASTEDGE_LASTEDGE_SHIFT             (0U)
/*! LASTEDGE - Last Edge Time Counter */
#define EQDC_LASTEDGE_LASTEDGE(x)                (((uint16_t)(((uint16_t)(x)) << EQDC_LASTEDGE_LASTEDGE_SHIFT)) & EQDC_LASTEDGE_LASTEDGE_MASK)
/*! @} */

/*! @name POSDPER - Position Difference Period Counter Register */
/*! @{ */

#define EQDC_POSDPER_POSDPER_MASK                (0xFFFFU)
#define EQDC_POSDPER_POSDPER_SHIFT               (0U)
/*! POSDPER - Position difference period */
#define EQDC_POSDPER_POSDPER(x)                  (((uint16_t)(((uint16_t)(x)) << EQDC_POSDPER_POSDPER_SHIFT)) & EQDC_POSDPER_POSDPER_MASK)
/*! @} */

/*! @name POSDPERBFR - Position Difference Period Buffer Register */
/*! @{ */

#define EQDC_POSDPERBFR_POSDPERBFR_MASK          (0xFFFFU)
#define EQDC_POSDPERBFR_POSDPERBFR_SHIFT         (0U)
/*! POSDPERBFR - Position difference period buffer */
#define EQDC_POSDPERBFR_POSDPERBFR(x)            (((uint16_t)(((uint16_t)(x)) << EQDC_POSDPERBFR_POSDPERBFR_SHIFT)) & EQDC_POSDPERBFR_POSDPERBFR_MASK)
/*! @} */

/*! @name UPOS - Upper Position Counter Register */
/*! @{ */

#define EQDC_UPOS_POS_MASK                       (0xFFFFU)
#define EQDC_UPOS_POS_SHIFT                      (0U)
/*! POS - POS */
#define EQDC_UPOS_POS(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_UPOS_POS_SHIFT)) & EQDC_UPOS_POS_MASK)
/*! @} */

/*! @name LPOS - Lower Position Counter Register */
/*! @{ */

#define EQDC_LPOS_POS_MASK                       (0xFFFFU)
#define EQDC_LPOS_POS_SHIFT                      (0U)
/*! POS - POS */
#define EQDC_LPOS_POS(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_LPOS_POS_SHIFT)) & EQDC_LPOS_POS_MASK)
/*! @} */

/*! @name POSD - Position Difference Counter Register */
/*! @{ */

#define EQDC_POSD_POSD_MASK                      (0xFFFFU)
#define EQDC_POSD_POSD_SHIFT                     (0U)
/*! POSD - POSD */
#define EQDC_POSD_POSD(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_POSD_POSD_SHIFT)) & EQDC_POSD_POSD_MASK)
/*! @} */

/*! @name POSDH - Position Difference Hold Register */
/*! @{ */

#define EQDC_POSDH_POSDH_MASK                    (0xFFFFU)
#define EQDC_POSDH_POSDH_SHIFT                   (0U)
/*! POSDH - POSDH */
#define EQDC_POSDH_POSDH(x)                      (((uint16_t)(((uint16_t)(x)) << EQDC_POSDH_POSDH_SHIFT)) & EQDC_POSDH_POSDH_MASK)
/*! @} */

/*! @name UPOSH - Upper Position Hold Register */
/*! @{ */

#define EQDC_UPOSH_POSH_MASK                     (0xFFFFU)
#define EQDC_UPOSH_POSH_SHIFT                    (0U)
/*! POSH - POSH */
#define EQDC_UPOSH_POSH(x)                       (((uint16_t)(((uint16_t)(x)) << EQDC_UPOSH_POSH_SHIFT)) & EQDC_UPOSH_POSH_MASK)
/*! @} */

/*! @name LPOSH - Lower Position Hold Register */
/*! @{ */

#define EQDC_LPOSH_LPOSH_MASK                    (0xFFFFU)
#define EQDC_LPOSH_LPOSH_SHIFT                   (0U)
/*! LPOSH - POSH */
#define EQDC_LPOSH_LPOSH(x)                      (((uint16_t)(((uint16_t)(x)) << EQDC_LPOSH_LPOSH_SHIFT)) & EQDC_LPOSH_LPOSH_MASK)
/*! @} */

/*! @name LASTEDGEH - Last Edge Time Hold Register */
/*! @{ */

#define EQDC_LASTEDGEH_LASTEDGEH_MASK            (0xFFFFU)
#define EQDC_LASTEDGEH_LASTEDGEH_SHIFT           (0U)
/*! LASTEDGEH - Last Edge Time Hold */
#define EQDC_LASTEDGEH_LASTEDGEH(x)              (((uint16_t)(((uint16_t)(x)) << EQDC_LASTEDGEH_LASTEDGEH_SHIFT)) & EQDC_LASTEDGEH_LASTEDGEH_MASK)
/*! @} */

/*! @name POSDPERH - Position Difference Period Hold Register */
/*! @{ */

#define EQDC_POSDPERH_POSDPERH_MASK              (0xFFFFU)
#define EQDC_POSDPERH_POSDPERH_SHIFT             (0U)
/*! POSDPERH - Position difference period hold */
#define EQDC_POSDPERH_POSDPERH(x)                (((uint16_t)(((uint16_t)(x)) << EQDC_POSDPERH_POSDPERH_SHIFT)) & EQDC_POSDPERH_POSDPERH_MASK)
/*! @} */

/*! @name REVH - Revolution Hold Register */
/*! @{ */

#define EQDC_REVH_REVH_MASK                      (0xFFFFU)
#define EQDC_REVH_REVH_SHIFT                     (0U)
/*! REVH - REVH */
#define EQDC_REVH_REVH(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_REVH_REVH_SHIFT)) & EQDC_REVH_REVH_MASK)
/*! @} */

/*! @name REV - Revolution Counter Register */
/*! @{ */

#define EQDC_REV_REV_MASK                        (0xFFFFU)
#define EQDC_REV_REV_SHIFT                       (0U)
/*! REV - REV */
#define EQDC_REV_REV(x)                          (((uint16_t)(((uint16_t)(x)) << EQDC_REV_REV_SHIFT)) & EQDC_REV_REV_MASK)
/*! @} */

/*! @name UINIT - Upper Initialization Register */
/*! @{ */

#define EQDC_UINIT_INIT_MASK                     (0xFFFFU)
#define EQDC_UINIT_INIT_SHIFT                    (0U)
/*! INIT - INIT */
#define EQDC_UINIT_INIT(x)                       (((uint16_t)(((uint16_t)(x)) << EQDC_UINIT_INIT_SHIFT)) & EQDC_UINIT_INIT_MASK)
/*! @} */

/*! @name LINIT - Lower Initialization Register */
/*! @{ */

#define EQDC_LINIT_INIT_MASK                     (0xFFFFU)
#define EQDC_LINIT_INIT_SHIFT                    (0U)
/*! INIT - INIT */
#define EQDC_LINIT_INIT(x)                       (((uint16_t)(((uint16_t)(x)) << EQDC_LINIT_INIT_SHIFT)) & EQDC_LINIT_INIT_MASK)
/*! @} */

/*! @name UMOD - Upper Modulus Register */
/*! @{ */

#define EQDC_UMOD_MOD_MASK                       (0xFFFFU)
#define EQDC_UMOD_MOD_SHIFT                      (0U)
/*! MOD - MOD */
#define EQDC_UMOD_MOD(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_UMOD_MOD_SHIFT)) & EQDC_UMOD_MOD_MASK)
/*! @} */

/*! @name LMOD - Lower Modulus Register */
/*! @{ */

#define EQDC_LMOD_MOD_MASK                       (0xFFFFU)
#define EQDC_LMOD_MOD_SHIFT                      (0U)
/*! MOD - MOD */
#define EQDC_LMOD_MOD(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_LMOD_MOD_SHIFT)) & EQDC_LMOD_MOD_MASK)
/*! @} */

/*! @name UCOMP0 - Upper Position Compare Register 0 */
/*! @{ */

#define EQDC_UCOMP0_UCOMP0_MASK                  (0xFFFFU)
#define EQDC_UCOMP0_UCOMP0_SHIFT                 (0U)
/*! UCOMP0 - UCOMP0 */
#define EQDC_UCOMP0_UCOMP0(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_UCOMP0_UCOMP0_SHIFT)) & EQDC_UCOMP0_UCOMP0_MASK)
/*! @} */

/*! @name LCOMP0 - Lower Position Compare Register 0 */
/*! @{ */

#define EQDC_LCOMP0_LCOMP0_MASK                  (0xFFFFU)
#define EQDC_LCOMP0_LCOMP0_SHIFT                 (0U)
/*! LCOMP0 - LCOMP0 */
#define EQDC_LCOMP0_LCOMP0(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_LCOMP0_LCOMP0_SHIFT)) & EQDC_LCOMP0_LCOMP0_MASK)
/*! @} */

/*! @name UCOMP1 - Upper Position Compare 1 */
/*! @{ */

#define EQDC_UCOMP1_UCOMP1_MASK                  (0xFFFFU)
#define EQDC_UCOMP1_UCOMP1_SHIFT                 (0U)
/*! UCOMP1 - UCOMP1 */
#define EQDC_UCOMP1_UCOMP1(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_UCOMP1_UCOMP1_SHIFT)) & EQDC_UCOMP1_UCOMP1_MASK)
/*! @} */

/*! @name UPOSH1 - Upper Position Holder Register 1 */
/*! @{ */

#define EQDC_UPOSH1_UPOSH1_MASK                  (0xFFFFU)
#define EQDC_UPOSH1_UPOSH1_SHIFT                 (0U)
/*! UPOSH1 - UPOSH1 */
#define EQDC_UPOSH1_UPOSH1(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_UPOSH1_UPOSH1_SHIFT)) & EQDC_UPOSH1_UPOSH1_MASK)
/*! @} */

/*! @name LCOMP1 - Lower Position Compare 1 */
/*! @{ */

#define EQDC_LCOMP1_LCOMP1_MASK                  (0xFFFFU)
#define EQDC_LCOMP1_LCOMP1_SHIFT                 (0U)
/*! LCOMP1 - LCOMP1 */
#define EQDC_LCOMP1_LCOMP1(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_LCOMP1_LCOMP1_SHIFT)) & EQDC_LCOMP1_LCOMP1_MASK)
/*! @} */

/*! @name LPOSH1 - Lower Position Holder Register 1 */
/*! @{ */

#define EQDC_LPOSH1_LPOSH1_MASK                  (0xFFFFU)
#define EQDC_LPOSH1_LPOSH1_SHIFT                 (0U)
/*! LPOSH1 - LPOSH1 */
#define EQDC_LPOSH1_LPOSH1(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_LPOSH1_LPOSH1_SHIFT)) & EQDC_LPOSH1_LPOSH1_MASK)
/*! @} */

/*! @name UCOMP2 - Upper Position Compare 2 */
/*! @{ */

#define EQDC_UCOMP2_UCOMP2_MASK                  (0xFFFFU)
#define EQDC_UCOMP2_UCOMP2_SHIFT                 (0U)
/*! UCOMP2 - UCOMP2 */
#define EQDC_UCOMP2_UCOMP2(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_UCOMP2_UCOMP2_SHIFT)) & EQDC_UCOMP2_UCOMP2_MASK)
/*! @} */

/*! @name UPOSH2 - Upper Position Holder Register 3 */
/*! @{ */

#define EQDC_UPOSH2_UPOSH2_MASK                  (0xFFFFU)
#define EQDC_UPOSH2_UPOSH2_SHIFT                 (0U)
/*! UPOSH2 - UPOSH2 */
#define EQDC_UPOSH2_UPOSH2(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_UPOSH2_UPOSH2_SHIFT)) & EQDC_UPOSH2_UPOSH2_MASK)
/*! @} */

/*! @name LCOMP2 - Lower Position Compare 2 */
/*! @{ */

#define EQDC_LCOMP2_LCOMP2_MASK                  (0xFFFFU)
#define EQDC_LCOMP2_LCOMP2_SHIFT                 (0U)
/*! LCOMP2 - LCOMP2 */
#define EQDC_LCOMP2_LCOMP2(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_LCOMP2_LCOMP2_SHIFT)) & EQDC_LCOMP2_LCOMP2_MASK)
/*! @} */

/*! @name LPOSH2 - Lower Position Holder Register 2 */
/*! @{ */

#define EQDC_LPOSH2_LPOSH2_MASK                  (0xFFFFU)
#define EQDC_LPOSH2_LPOSH2_SHIFT                 (0U)
/*! LPOSH2 - LPOSH2 */
#define EQDC_LPOSH2_LPOSH2(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_LPOSH2_LPOSH2_SHIFT)) & EQDC_LPOSH2_LPOSH2_MASK)
/*! @} */

/*! @name UCOMP3 - Upper Position Compare 3 */
/*! @{ */

#define EQDC_UCOMP3_UCOMP3_MASK                  (0xFFFFU)
#define EQDC_UCOMP3_UCOMP3_SHIFT                 (0U)
/*! UCOMP3 - UCOMP3 */
#define EQDC_UCOMP3_UCOMP3(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_UCOMP3_UCOMP3_SHIFT)) & EQDC_UCOMP3_UCOMP3_MASK)
/*! @} */

/*! @name UPOSH3 - Upper Position Holder Register 3 */
/*! @{ */

#define EQDC_UPOSH3_UPOSH3_MASK                  (0xFFFFU)
#define EQDC_UPOSH3_UPOSH3_SHIFT                 (0U)
/*! UPOSH3 - UPOSH3 */
#define EQDC_UPOSH3_UPOSH3(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_UPOSH3_UPOSH3_SHIFT)) & EQDC_UPOSH3_UPOSH3_MASK)
/*! @} */

/*! @name LCOMP3 - Lower Position Compare 3 */
/*! @{ */

#define EQDC_LCOMP3_LCOMP3_MASK                  (0xFFFFU)
#define EQDC_LCOMP3_LCOMP3_SHIFT                 (0U)
/*! LCOMP3 - LCOMP3 */
#define EQDC_LCOMP3_LCOMP3(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_LCOMP3_LCOMP3_SHIFT)) & EQDC_LCOMP3_LCOMP3_MASK)
/*! @} */

/*! @name LPOSH3 - Lower Position Holder Register 3 */
/*! @{ */

#define EQDC_LPOSH3_LPOSH3_MASK                  (0xFFFFU)
#define EQDC_LPOSH3_LPOSH3_SHIFT                 (0U)
/*! LPOSH3 - LPOSH3 */
#define EQDC_LPOSH3_LPOSH3(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_LPOSH3_LPOSH3_SHIFT)) & EQDC_LPOSH3_LPOSH3_MASK)
/*! @} */

/*! @name INTCTRL - Interrupt Control Register */
/*! @{ */

#define EQDC_INTCTRL_SABIE_MASK                  (0x1U)
#define EQDC_INTCTRL_SABIE_SHIFT                 (0U)
/*! SABIE - Simultaneous PHASEA and PHASEB Change Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_INTCTRL_SABIE(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_SABIE_SHIFT)) & EQDC_INTCTRL_SABIE_MASK)

#define EQDC_INTCTRL_SABIRQ_MASK                 (0x2U)
#define EQDC_INTCTRL_SABIRQ_SHIFT                (1U)
/*! SABIRQ - Simultaneous PHASEA and PHASEB Change Interrupt Request
 *  0b0..No simultaneous change of PHASEA and PHASEB has occurred
 *  0b1..A simultaneous change of PHASEA and PHASEB has occurred
 */
#define EQDC_INTCTRL_SABIRQ(x)                   (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_SABIRQ_SHIFT)) & EQDC_INTCTRL_SABIRQ_MASK)

#define EQDC_INTCTRL_DIRIE_MASK                  (0x4U)
#define EQDC_INTCTRL_DIRIE_SHIFT                 (2U)
/*! DIRIE - Count direction change interrupt enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_INTCTRL_DIRIE(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_DIRIE_SHIFT)) & EQDC_INTCTRL_DIRIE_MASK)

#define EQDC_INTCTRL_DIRIRQ_MASK                 (0x8U)
#define EQDC_INTCTRL_DIRIRQ_SHIFT                (3U)
/*! DIRIRQ - Count direction change interrupt
 *  0b0..Count direction unchanged
 *  0b1..Count direction changed
 */
#define EQDC_INTCTRL_DIRIRQ(x)                   (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_DIRIRQ_SHIFT)) & EQDC_INTCTRL_DIRIRQ_MASK)

#define EQDC_INTCTRL_RUIE_MASK                   (0x10U)
#define EQDC_INTCTRL_RUIE_SHIFT                  (4U)
/*! RUIE - Roll-under Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_INTCTRL_RUIE(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_RUIE_SHIFT)) & EQDC_INTCTRL_RUIE_MASK)

#define EQDC_INTCTRL_RUIRQ_MASK                  (0x20U)
#define EQDC_INTCTRL_RUIRQ_SHIFT                 (5U)
/*! RUIRQ - Roll-under Interrupt Request
 *  0b0..No roll-under has occurred
 *  0b1..Roll-under has occurred
 */
#define EQDC_INTCTRL_RUIRQ(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_RUIRQ_SHIFT)) & EQDC_INTCTRL_RUIRQ_MASK)

#define EQDC_INTCTRL_ROIE_MASK                   (0x40U)
#define EQDC_INTCTRL_ROIE_SHIFT                  (6U)
/*! ROIE - Roll-over Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_INTCTRL_ROIE(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_ROIE_SHIFT)) & EQDC_INTCTRL_ROIE_MASK)

#define EQDC_INTCTRL_ROIRQ_MASK                  (0x80U)
#define EQDC_INTCTRL_ROIRQ_SHIFT                 (7U)
/*! ROIRQ - Roll-over Interrupt Request
 *  0b0..No roll-over has occurred
 *  0b1..Roll-over has occurred
 */
#define EQDC_INTCTRL_ROIRQ(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_ROIRQ_SHIFT)) & EQDC_INTCTRL_ROIRQ_MASK)

#define EQDC_INTCTRL_CMP0IE_MASK                 (0x100U)
#define EQDC_INTCTRL_CMP0IE_SHIFT                (8U)
/*! CMP0IE - Compare 0 Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_INTCTRL_CMP0IE(x)                   (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_CMP0IE_SHIFT)) & EQDC_INTCTRL_CMP0IE_MASK)

#define EQDC_INTCTRL_CMP0IRQ_MASK                (0x200U)
#define EQDC_INTCTRL_CMP0IRQ_SHIFT               (9U)
/*! CMP0IRQ - Compare 0 Interrupt Request
 *  0b0..No match has occurred (the position counter does not match the COMP0 value)
 *  0b1..COMP match has occurred (the position counter matches the COMP0 value)
 */
#define EQDC_INTCTRL_CMP0IRQ(x)                  (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_CMP0IRQ_SHIFT)) & EQDC_INTCTRL_CMP0IRQ_MASK)

#define EQDC_INTCTRL_CMP1IE_MASK                 (0x400U)
#define EQDC_INTCTRL_CMP1IE_SHIFT                (10U)
/*! CMP1IE - Compare1 Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_INTCTRL_CMP1IE(x)                   (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_CMP1IE_SHIFT)) & EQDC_INTCTRL_CMP1IE_MASK)

#define EQDC_INTCTRL_CMP1IRQ_MASK                (0x800U)
#define EQDC_INTCTRL_CMP1IRQ_SHIFT               (11U)
/*! CMP1IRQ - Compare1 Interrupt Request
 *  0b0..No match has occurred (the position counter does not match the COMP1 value)
 *  0b1..COMP1 match has occurred (the position counter matches the COMP1 value)
 */
#define EQDC_INTCTRL_CMP1IRQ(x)                  (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_CMP1IRQ_SHIFT)) & EQDC_INTCTRL_CMP1IRQ_MASK)

#define EQDC_INTCTRL_CMP2IE_MASK                 (0x1000U)
#define EQDC_INTCTRL_CMP2IE_SHIFT                (12U)
/*! CMP2IE - Compare2 Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_INTCTRL_CMP2IE(x)                   (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_CMP2IE_SHIFT)) & EQDC_INTCTRL_CMP2IE_MASK)

#define EQDC_INTCTRL_CMP2IRQ_MASK                (0x2000U)
#define EQDC_INTCTRL_CMP2IRQ_SHIFT               (13U)
/*! CMP2IRQ - Compare2 Interrupt Request
 *  0b0..No match has occurred (the position counter does not match the COMP2 value)
 *  0b1..COMP2 match has occurred (the position counter matches the COMP2 value)
 */
#define EQDC_INTCTRL_CMP2IRQ(x)                  (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_CMP2IRQ_SHIFT)) & EQDC_INTCTRL_CMP2IRQ_MASK)

#define EQDC_INTCTRL_CMP3IE_MASK                 (0x4000U)
#define EQDC_INTCTRL_CMP3IE_SHIFT                (14U)
/*! CMP3IE - Compare3 Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_INTCTRL_CMP3IE(x)                   (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_CMP3IE_SHIFT)) & EQDC_INTCTRL_CMP3IE_MASK)

#define EQDC_INTCTRL_CMP3IRQ_MASK                (0x8000U)
#define EQDC_INTCTRL_CMP3IRQ_SHIFT               (15U)
/*! CMP3IRQ - Compare3 Interrupt Request
 *  0b0..No match has occurred (the position counter does not match the COMP3 value)
 *  0b1..COMP3 match has occurred (the position counter matches the COMP3 value)
 */
#define EQDC_INTCTRL_CMP3IRQ(x)                  (((uint16_t)(((uint16_t)(x)) << EQDC_INTCTRL_CMP3IRQ_SHIFT)) & EQDC_INTCTRL_CMP3IRQ_MASK)
/*! @} */

/*! @name WTR - Watchdog Timeout Register */
/*! @{ */

#define EQDC_WTR_WDOG_MASK                       (0xFFFFU)
#define EQDC_WTR_WDOG_SHIFT                      (0U)
/*! WDOG - WDOG */
#define EQDC_WTR_WDOG(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_WTR_WDOG_SHIFT)) & EQDC_WTR_WDOG_MASK)
/*! @} */

/*! @name IMR - Input Monitor Register */
/*! @{ */

#define EQDC_IMR_HOME_ENABLE_MASK                (0x1U)
#define EQDC_IMR_HOME_ENABLE_SHIFT               (0U)
/*! HOME_ENABLE - HOME_ENABLE */
#define EQDC_IMR_HOME_ENABLE(x)                  (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_HOME_ENABLE_SHIFT)) & EQDC_IMR_HOME_ENABLE_MASK)

#define EQDC_IMR_INDEX_PRESET_MASK               (0x2U)
#define EQDC_IMR_INDEX_PRESET_SHIFT              (1U)
/*! INDEX_PRESET - INDEX_PRESET */
#define EQDC_IMR_INDEX_PRESET(x)                 (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_INDEX_PRESET_SHIFT)) & EQDC_IMR_INDEX_PRESET_MASK)

#define EQDC_IMR_PHB_MASK                        (0x4U)
#define EQDC_IMR_PHB_SHIFT                       (2U)
/*! PHB - PHB */
#define EQDC_IMR_PHB(x)                          (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_PHB_SHIFT)) & EQDC_IMR_PHB_MASK)

#define EQDC_IMR_PHA_MASK                        (0x8U)
#define EQDC_IMR_PHA_SHIFT                       (3U)
/*! PHA - PHA */
#define EQDC_IMR_PHA(x)                          (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_PHA_SHIFT)) & EQDC_IMR_PHA_MASK)

#define EQDC_IMR_FHOM_ENA_MASK                   (0x10U)
#define EQDC_IMR_FHOM_ENA_SHIFT                  (4U)
/*! FHOM_ENA - filter operation on HOME/ENABLE input */
#define EQDC_IMR_FHOM_ENA(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_FHOM_ENA_SHIFT)) & EQDC_IMR_FHOM_ENA_MASK)

#define EQDC_IMR_FIND_PRE_MASK                   (0x20U)
#define EQDC_IMR_FIND_PRE_SHIFT                  (5U)
/*! FIND_PRE - filter operation on INDEX/PRESET input */
#define EQDC_IMR_FIND_PRE(x)                     (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_FIND_PRE_SHIFT)) & EQDC_IMR_FIND_PRE_MASK)

#define EQDC_IMR_FPHB_MASK                       (0x40U)
#define EQDC_IMR_FPHB_SHIFT                      (6U)
/*! FPHB - filter operation on PHASEB input */
#define EQDC_IMR_FPHB(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_FPHB_SHIFT)) & EQDC_IMR_FPHB_MASK)

#define EQDC_IMR_FPHA_MASK                       (0x80U)
#define EQDC_IMR_FPHA_SHIFT                      (7U)
/*! FPHA - filter operation on PHASEA input */
#define EQDC_IMR_FPHA(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_FPHA_SHIFT)) & EQDC_IMR_FPHA_MASK)

#define EQDC_IMR_CMPF0_MASK                      (0x100U)
#define EQDC_IMR_CMPF0_SHIFT                     (8U)
/*! CMPF0 - Position Compare 0 Flag Output
 *  0b0..When the position counter is less than value of COMP0 register
 *  0b1..When the position counter is greater or equal than value of COMP0 register
 */
#define EQDC_IMR_CMPF0(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_CMPF0_SHIFT)) & EQDC_IMR_CMPF0_MASK)

#define EQDC_IMR_CMP1F_MASK                      (0x200U)
#define EQDC_IMR_CMP1F_SHIFT                     (9U)
/*! CMP1F - Position Compare1 Flag Output
 *  0b0..When the position counter is less than value of COMP1 register
 *  0b1..When the position counter is greater or equal than value of COMP1 register
 */
#define EQDC_IMR_CMP1F(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_CMP1F_SHIFT)) & EQDC_IMR_CMP1F_MASK)

#define EQDC_IMR_CMP2F_MASK                      (0x400U)
#define EQDC_IMR_CMP2F_SHIFT                     (10U)
/*! CMP2F - Position Compare2 Flag Output
 *  0b0..When the position counter is less than value of COMP2 register
 *  0b1..When the position counter is greater or equal than value of COMP2 register
 */
#define EQDC_IMR_CMP2F(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_CMP2F_SHIFT)) & EQDC_IMR_CMP2F_MASK)

#define EQDC_IMR_CMP3F_MASK                      (0x800U)
#define EQDC_IMR_CMP3F_SHIFT                     (11U)
/*! CMP3F - Position Compare3 Flag Output
 *  0b0..When the position counter value is less than value of COMP3 register
 *  0b1..When the position counter is greater or equal than value of COMP3 register
 */
#define EQDC_IMR_CMP3F(x)                        (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_CMP3F_SHIFT)) & EQDC_IMR_CMP3F_MASK)

#define EQDC_IMR_DIRH_MASK                       (0x4000U)
#define EQDC_IMR_DIRH_SHIFT                      (14U)
/*! DIRH - Count Direction Flag Hold */
#define EQDC_IMR_DIRH(x)                         (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_DIRH_SHIFT)) & EQDC_IMR_DIRH_MASK)

#define EQDC_IMR_DIR_MASK                        (0x8000U)
#define EQDC_IMR_DIR_SHIFT                       (15U)
/*! DIR - Count Direction Flag Output
 *  0b0..Current count was in the down direction
 *  0b1..Current count was in the up direction
 */
#define EQDC_IMR_DIR(x)                          (((uint16_t)(((uint16_t)(x)) << EQDC_IMR_DIR_SHIFT)) & EQDC_IMR_DIR_MASK)
/*! @} */

/*! @name TST - Test Register */
/*! @{ */

#define EQDC_TST_TEST_COUNT_MASK                 (0xFFU)
#define EQDC_TST_TEST_COUNT_SHIFT                (0U)
/*! TEST_COUNT - TEST_COUNT */
#define EQDC_TST_TEST_COUNT(x)                   (((uint16_t)(((uint16_t)(x)) << EQDC_TST_TEST_COUNT_SHIFT)) & EQDC_TST_TEST_COUNT_MASK)

#define EQDC_TST_TEST_PERIOD_MASK                (0x1F00U)
#define EQDC_TST_TEST_PERIOD_SHIFT               (8U)
/*! TEST_PERIOD - TEST_PERIOD */
#define EQDC_TST_TEST_PERIOD(x)                  (((uint16_t)(((uint16_t)(x)) << EQDC_TST_TEST_PERIOD_SHIFT)) & EQDC_TST_TEST_PERIOD_MASK)

#define EQDC_TST_QDN_MASK                        (0x2000U)
#define EQDC_TST_QDN_SHIFT                       (13U)
/*! QDN - Quadrature Decoder Negative Signal
 *  0b0..Generates a positive quadrature decoder signal
 *  0b1..Generates a negative quadrature decoder signal
 */
#define EQDC_TST_QDN(x)                          (((uint16_t)(((uint16_t)(x)) << EQDC_TST_QDN_SHIFT)) & EQDC_TST_QDN_MASK)

#define EQDC_TST_TCE_MASK                        (0x4000U)
#define EQDC_TST_TCE_SHIFT                       (14U)
/*! TCE - Test Counter Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_TST_TCE(x)                          (((uint16_t)(((uint16_t)(x)) << EQDC_TST_TCE_SHIFT)) & EQDC_TST_TCE_MASK)

#define EQDC_TST_TEN_MASK                        (0x8000U)
#define EQDC_TST_TEN_SHIFT                       (15U)
/*! TEN - Test Mode Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EQDC_TST_TEN(x)                          (((uint16_t)(((uint16_t)(x)) << EQDC_TST_TEN_SHIFT)) & EQDC_TST_TEN_MASK)
/*! @} */

/*! @name UVERID - Upper VERID */
/*! @{ */

#define EQDC_UVERID_UVERID_MASK                  (0xFFFFU)
#define EQDC_UVERID_UVERID_SHIFT                 (0U)
/*! UVERID - UVERID */
#define EQDC_UVERID_UVERID(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_UVERID_UVERID_SHIFT)) & EQDC_UVERID_UVERID_MASK)
/*! @} */

/*! @name LVERID - Lower VERID */
/*! @{ */

#define EQDC_LVERID_LVERID_MASK                  (0xFFFFU)
#define EQDC_LVERID_LVERID_SHIFT                 (0U)
/*! LVERID - LVERID */
#define EQDC_LVERID_LVERID(x)                    (((uint16_t)(((uint16_t)(x)) << EQDC_LVERID_LVERID_SHIFT)) & EQDC_LVERID_LVERID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group EQDC_Register_Masks */


/* EQDC - Peripheral instance base addresses */
/** Peripheral QDC0 base address */
#define QDC0_BASE                                (0x400A7000u)
/** Peripheral QDC0 base pointer */
#define QDC0                                     ((EQDC_Type *)QDC0_BASE)
/** Peripheral QDC1 base address */
#define QDC1_BASE                                (0x400A8000u)
/** Peripheral QDC1 base pointer */
#define QDC1                                     ((EQDC_Type *)QDC1_BASE)
/** Array initializer of EQDC peripheral base addresses */
#define EQDC_BASE_ADDRS                          { QDC0_BASE, QDC1_BASE }
/** Array initializer of EQDC peripheral base pointers */
#define EQDC_BASE_PTRS                           { QDC0, QDC1 }
/** Interrupt vectors for the EQDC peripheral type */
#define EQDC_COMPARE_IRQS                        { QDC0_COMPARE_IRQn, QDC1_COMPARE_IRQn }
#define EQDC_HOME_IRQS                           { QDC0_HOME_IRQn, QDC1_HOME_IRQn }
#define EQDC_WDOG_IRQS                           { QDC0_WATCHDOG_IRQn, QDC1_WATCHDOG_IRQn }
#define EQDC_INDEX_IRQS                          { QDC0_INDEX_IRQn, QDC1_INDEX_IRQn }
#define EQDC_INPUT_SWITCH_IRQS                   { QDC0_WATCHDOG_IRQn, QDC1_WATCHDOG_IRQn }

/*!
 * @}
 */ /* end of group EQDC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ERM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ERM_Peripheral_Access_Layer ERM Peripheral Access Layer
 * @{
 */

/** ERM - Register Layout Typedef */
typedef struct {
  __IO uint32_t CR0;                               /**< ERM Configuration Register 0, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t SR0;                               /**< ERM Status Register 0, offset: 0x10 */
       uint8_t RESERVED_1[236];
  __I  uint32_t EAR0;                              /**< ERM Memory 0 Error Address Register, offset: 0x100 */
  __I  uint32_t SYN0;                              /**< ERM Memory 0 Syndrome Register, offset: 0x104 */
  __IO uint32_t CORR_ERR_CNT0;                     /**< ERM Memory 0 Correctable Error Count Register, offset: 0x108 */
       uint8_t RESERVED_2[12];
  __IO uint32_t CORR_ERR_CNT1;                     /**< ERM Memory 1 Correctable Error Count Register, offset: 0x118 */
} ERM_Type;

/* ----------------------------------------------------------------------------
   -- ERM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ERM_Register_Masks ERM Register Masks
 * @{
 */

/*! @name CR0 - ERM Configuration Register 0 */
/*! @{ */

#define ERM_CR0_ENCIE1_MASK                      (0x4000000U)
#define ERM_CR0_ENCIE1_SHIFT                     (26U)
/*! ENCIE1 - ENCIE1
 *  0b0..Interrupt notification of Memory 1 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 1 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE1(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE1_SHIFT)) & ERM_CR0_ENCIE1_MASK)

#define ERM_CR0_ESCIE1_MASK                      (0x8000000U)
#define ERM_CR0_ESCIE1_SHIFT                     (27U)
/*! ESCIE1 - ESCIE1
 *  0b0..Interrupt notification of Memory 1 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 1 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE1(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE1_SHIFT)) & ERM_CR0_ESCIE1_MASK)

#define ERM_CR0_ENCIE0_MASK                      (0x40000000U)
#define ERM_CR0_ENCIE0_SHIFT                     (30U)
/*! ENCIE0 - ENCIE0
 *  0b0..Interrupt notification of Memory 0 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 0 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE0(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE0_SHIFT)) & ERM_CR0_ENCIE0_MASK)

#define ERM_CR0_ESCIE0_MASK                      (0x80000000U)
#define ERM_CR0_ESCIE0_SHIFT                     (31U)
/*! ESCIE0 - ESCIE0
 *  0b0..Interrupt notification of Memory 0 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 0 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE0(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE0_SHIFT)) & ERM_CR0_ESCIE0_MASK)
/*! @} */

/*! @name SR0 - ERM Status Register 0 */
/*! @{ */

#define ERM_SR0_NCE1_MASK                        (0x4000000U)
#define ERM_SR0_NCE1_SHIFT                       (26U)
/*! NCE1 - NCE1
 *  0b0..No non-correctable error event on Memory 1 detected.
 *  0b1..Non-correctable error event on Memory 1 detected.
 */
#define ERM_SR0_NCE1(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE1_SHIFT)) & ERM_SR0_NCE1_MASK)

#define ERM_SR0_SBC1_MASK                        (0x8000000U)
#define ERM_SR0_SBC1_SHIFT                       (27U)
/*! SBC1 - SBC1
 *  0b0..No single-bit correction event on Memory 1 detected.
 *  0b1..Single-bit correction event on Memory 1 detected.
 */
#define ERM_SR0_SBC1(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC1_SHIFT)) & ERM_SR0_SBC1_MASK)

#define ERM_SR0_NCE0_MASK                        (0x40000000U)
#define ERM_SR0_NCE0_SHIFT                       (30U)
/*! NCE0 - NCE0
 *  0b0..No non-correctable error event on Memory 0 detected.
 *  0b1..Non-correctable error event on Memory 0 detected.
 */
#define ERM_SR0_NCE0(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE0_SHIFT)) & ERM_SR0_NCE0_MASK)

#define ERM_SR0_SBC0_MASK                        (0x80000000U)
#define ERM_SR0_SBC0_SHIFT                       (31U)
/*! SBC0 - SBC0
 *  0b0..No single-bit correction event on Memory 0 detected.
 *  0b1..Single-bit correction event on Memory 0 detected.
 */
#define ERM_SR0_SBC0(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC0_SHIFT)) & ERM_SR0_SBC0_MASK)
/*! @} */

/*! @name EAR0 - ERM Memory 0 Error Address Register */
/*! @{ */

#define ERM_EAR0_EAR_MASK                        (0xFFFFFFFFU)
#define ERM_EAR0_EAR_SHIFT                       (0U)
/*! EAR - EAR */
#define ERM_EAR0_EAR(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_EAR0_EAR_SHIFT)) & ERM_EAR0_EAR_MASK)
/*! @} */

/*! @name SYN0 - ERM Memory 0 Syndrome Register */
/*! @{ */

#define ERM_SYN0_SYNDROME_MASK                   (0xFF000000U)
#define ERM_SYN0_SYNDROME_SHIFT                  (24U)
/*! SYNDROME - SYNDROME */
#define ERM_SYN0_SYNDROME(x)                     (((uint32_t)(((uint32_t)(x)) << ERM_SYN0_SYNDROME_SHIFT)) & ERM_SYN0_SYNDROME_MASK)
/*! @} */

/*! @name CORR_ERR_CNT0 - ERM Memory 0 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT0_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT0_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT0_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT0_COUNT_SHIFT)) & ERM_CORR_ERR_CNT0_COUNT_MASK)
/*! @} */

/*! @name CORR_ERR_CNT1 - ERM Memory 1 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT1_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT1_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT1_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT1_COUNT_SHIFT)) & ERM_CORR_ERR_CNT1_COUNT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ERM_Register_Masks */


/* ERM - Peripheral instance base addresses */
/** Peripheral ERM0 base address */
#define ERM0_BASE                                (0x4008D000u)
/** Peripheral ERM0 base pointer */
#define ERM0                                     ((ERM_Type *)ERM0_BASE)
/** Array initializer of ERM peripheral base addresses */
#define ERM_BASE_ADDRS                           { ERM0_BASE }
/** Array initializer of ERM peripheral base pointers */
#define ERM_BASE_PTRS                            { ERM0 }

/*!
 * @}
 */ /* end of group ERM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Peripheral_Access_Layer FLEXIO Peripheral Access Layer
 * @{
 */

/** FLEXIO - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< FLEXIO Control, offset: 0x8 */
  __I  uint32_t PIN;                               /**< Pin State, offset: 0xC */
  __IO uint32_t SHIFTSTAT;                         /**< Shifter Status, offset: 0x10 */
  __IO uint32_t SHIFTERR;                          /**< Shifter Error, offset: 0x14 */
  __IO uint32_t TIMSTAT;                           /**< Timer Status Flag, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t SHIFTSIEN;                         /**< Shifter Status Interrupt Enable, offset: 0x20 */
  __IO uint32_t SHIFTEIEN;                         /**< Shifter Error Interrupt Enable, offset: 0x24 */
  __IO uint32_t TIMIEN;                            /**< Timer Interrupt Enable, offset: 0x28 */
       uint8_t RESERVED_1[4];
  __IO uint32_t SHIFTSDEN;                         /**< Shifter Status DMA Enable, offset: 0x30 */
       uint8_t RESERVED_2[4];
  __IO uint32_t TIMERSDEN;                         /**< Timer Status DMA Enable, offset: 0x38 */
       uint8_t RESERVED_3[4];
  __IO uint32_t SHIFTSTATE;                        /**< Shifter State, offset: 0x40 */
       uint8_t RESERVED_4[4];
  __IO uint32_t TRGSTAT;                           /**< Trigger Status, offset: 0x48 */
  __IO uint32_t TRIGIEN;                           /**< External Trigger Interrupt Enable, offset: 0x4C */
  __IO uint32_t PINSTAT;                           /**< Pin Status, offset: 0x50 */
  __IO uint32_t PINIEN;                            /**< Pin Interrupt Enable, offset: 0x54 */
  __IO uint32_t PINREN;                            /**< Pin Rising Edge Enable, offset: 0x58 */
  __IO uint32_t PINFEN;                            /**< Pin Falling Edge Enable, offset: 0x5C */
  __IO uint32_t PINOUTD;                           /**< Pin Output Data, offset: 0x60 */
  __IO uint32_t PINOUTE;                           /**< Pin Output Enable, offset: 0x64 */
  __O  uint32_t PINOUTDIS;                         /**< Pin Output Disable, offset: 0x68 */
  __O  uint32_t PINOUTCLR;                         /**< Pin Output Clear, offset: 0x6C */
  __O  uint32_t PINOUTSET;                         /**< Pin Output Set, offset: 0x70 */
  __O  uint32_t PINOUTTOG;                         /**< Pin Output Toggle, offset: 0x74 */
       uint8_t RESERVED_5[8];
  __IO uint32_t SHIFTCTL[4];                       /**< Shifter Control, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_6[112];
  __IO uint32_t SHIFTCFG[4];                       /**< Shifter Configuration, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_7[240];
  __IO uint32_t SHIFTBUF[4];                       /**< Shifter Buffer, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_8[112];
  __IO uint32_t SHIFTBUFBIS[4];                    /**< Shifter Buffer Bit Swapped, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_9[112];
  __IO uint32_t SHIFTBUFBYS[4];                    /**< Shifter Buffer Byte Swapped, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_10[112];
  __IO uint32_t SHIFTBUFBBS[4];                    /**< Shifter Buffer Bit Byte Swapped, array offset: 0x380, array step: 0x4 */
       uint8_t RESERVED_11[112];
  __IO uint32_t TIMCTL[4];                         /**< Timer Control, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_12[112];
  __IO uint32_t TIMCFG[4];                         /**< Timer Configuration, array offset: 0x480, array step: 0x4 */
       uint8_t RESERVED_13[112];
  __IO uint32_t TIMCMP[4];                         /**< Timer Compare, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_14[368];
  __IO uint32_t SHIFTBUFNBS[4];                    /**< Shifter Buffer Nibble Byte Swapped, array offset: 0x680, array step: 0x4 */
       uint8_t RESERVED_15[112];
  __IO uint32_t SHIFTBUFHWS[4];                    /**< Shifter Buffer Halfword Swapped, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_16[112];
  __IO uint32_t SHIFTBUFNIS[4];                    /**< Shifter Buffer Nibble Swapped, array offset: 0x780, array step: 0x4 */
       uint8_t RESERVED_17[112];
  __IO uint32_t SHIFTBUFOES[4];                    /**< Shifter Buffer Odd Even Swapped, array offset: 0x800, array step: 0x4 */
       uint8_t RESERVED_18[112];
  __IO uint32_t SHIFTBUFEOS[4];                    /**< Shifter Buffer Even Odd Swapped, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_19[112];
  __IO uint32_t SHIFTBUFHBS[4];                    /**< Shifter Buffer Halfword Byte Swapped, array offset: 0x900, array step: 0x4 */
} FLEXIO_Type;

/* ----------------------------------------------------------------------------
   -- FLEXIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Register_Masks FLEXIO Register Masks
 * @{
 */

/*! @name VERID - Version ID */
/*! @{ */

#define FLEXIO_VERID_FEATURE_MASK                (0xFFFFU)
#define FLEXIO_VERID_FEATURE_SHIFT               (0U)
/*! FEATURE - Feature Specification Number
 *  0b0000000000000000..Standard features implemented
 *  0b0000000000000001..State, logic, and parallel modes supported
 *  0b0000000000000010..Pin control registers supported
 *  0b0000000000000011..State, logic, and parallel modes, plus pin control registers supported
 */
#define FLEXIO_VERID_FEATURE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_FEATURE_SHIFT)) & FLEXIO_VERID_FEATURE_MASK)

#define FLEXIO_VERID_MINOR_MASK                  (0xFF0000U)
#define FLEXIO_VERID_MINOR_SHIFT                 (16U)
/*! MINOR - Minor Version Number */
#define FLEXIO_VERID_MINOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MINOR_SHIFT)) & FLEXIO_VERID_MINOR_MASK)

#define FLEXIO_VERID_MAJOR_MASK                  (0xFF000000U)
#define FLEXIO_VERID_MAJOR_SHIFT                 (24U)
/*! MAJOR - Major Version Number */
#define FLEXIO_VERID_MAJOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MAJOR_SHIFT)) & FLEXIO_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter */
/*! @{ */

#define FLEXIO_PARAM_SHIFTER_MASK                (0xFFU)
#define FLEXIO_PARAM_SHIFTER_SHIFT               (0U)
/*! SHIFTER - Shifter Number */
#define FLEXIO_PARAM_SHIFTER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_SHIFTER_SHIFT)) & FLEXIO_PARAM_SHIFTER_MASK)

#define FLEXIO_PARAM_TIMER_MASK                  (0xFF00U)
#define FLEXIO_PARAM_TIMER_SHIFT                 (8U)
/*! TIMER - Timer Number */
#define FLEXIO_PARAM_TIMER(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TIMER_SHIFT)) & FLEXIO_PARAM_TIMER_MASK)

#define FLEXIO_PARAM_PIN_MASK                    (0xFF0000U)
#define FLEXIO_PARAM_PIN_SHIFT                   (16U)
/*! PIN - Pin Number */
#define FLEXIO_PARAM_PIN(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_PIN_SHIFT)) & FLEXIO_PARAM_PIN_MASK)

#define FLEXIO_PARAM_TRIGGER_MASK                (0xFF000000U)
#define FLEXIO_PARAM_TRIGGER_SHIFT               (24U)
/*! TRIGGER - Trigger Number */
#define FLEXIO_PARAM_TRIGGER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TRIGGER_SHIFT)) & FLEXIO_PARAM_TRIGGER_MASK)
/*! @} */

/*! @name CTRL - FLEXIO Control */
/*! @{ */

#define FLEXIO_CTRL_FLEXEN_MASK                  (0x1U)
#define FLEXIO_CTRL_FLEXEN_SHIFT                 (0U)
/*! FLEXEN - FLEXIO Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLEXIO_CTRL_FLEXEN(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FLEXEN_SHIFT)) & FLEXIO_CTRL_FLEXEN_MASK)

#define FLEXIO_CTRL_SWRST_MASK                   (0x2U)
#define FLEXIO_CTRL_SWRST_SHIFT                  (1U)
/*! SWRST - Software Reset
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FLEXIO_CTRL_SWRST(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_SWRST_SHIFT)) & FLEXIO_CTRL_SWRST_MASK)

#define FLEXIO_CTRL_FASTACC_MASK                 (0x4U)
#define FLEXIO_CTRL_FASTACC_SHIFT                (2U)
/*! FASTACC - Fast Access
 *  0b0..Normal
 *  0b1..Fast
 */
#define FLEXIO_CTRL_FASTACC(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FASTACC_SHIFT)) & FLEXIO_CTRL_FASTACC_MASK)

#define FLEXIO_CTRL_DBGE_MASK                    (0x40000000U)
#define FLEXIO_CTRL_DBGE_SHIFT                   (30U)
/*! DBGE - Debug Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLEXIO_CTRL_DBGE(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DBGE_SHIFT)) & FLEXIO_CTRL_DBGE_MASK)

#define FLEXIO_CTRL_DOZEN_MASK                   (0x80000000U)
#define FLEXIO_CTRL_DOZEN_SHIFT                  (31U)
/*! DOZEN - Doze Enable
 *  0b0..Enable
 *  0b1..Disable
 */
#define FLEXIO_CTRL_DOZEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DOZEN_SHIFT)) & FLEXIO_CTRL_DOZEN_MASK)
/*! @} */

/*! @name PIN - Pin State */
/*! @{ */

#define FLEXIO_PIN_PDI_MASK                      (0xFFFFFFFFU)
#define FLEXIO_PIN_PDI_SHIFT                     (0U)
/*! PDI - Pin Data Input */
#define FLEXIO_PIN_PDI(x)                        (((uint32_t)(((uint32_t)(x)) << FLEXIO_PIN_PDI_SHIFT)) & FLEXIO_PIN_PDI_MASK)
/*! @} */

/*! @name SHIFTSTAT - Shifter Status */
/*! @{ */

#define FLEXIO_SHIFTSTAT_SSF_MASK                (0xFU)
#define FLEXIO_SHIFTSTAT_SSF_SHIFT               (0U)
/*! SSF - Shifter Status Flag
 *  0b0000..Clear
 *  0b0001..Set
 *  0b0000..No effect
 *  0b0001..Clear the flag
 */
#define FLEXIO_SHIFTSTAT_SSF(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTAT_SSF_SHIFT)) & FLEXIO_SHIFTSTAT_SSF_MASK)
/*! @} */

/*! @name SHIFTERR - Shifter Error */
/*! @{ */

#define FLEXIO_SHIFTERR_SEF_MASK                 (0xFU)
#define FLEXIO_SHIFTERR_SEF_SHIFT                (0U)
/*! SEF - Shifter Error Flag
 *  0b0000..Clear
 *  0b0001..Set
 *  0b0000..No effect
 *  0b0001..Clear the flag
 */
#define FLEXIO_SHIFTERR_SEF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTERR_SEF_SHIFT)) & FLEXIO_SHIFTERR_SEF_MASK)
/*! @} */

/*! @name TIMSTAT - Timer Status Flag */
/*! @{ */

#define FLEXIO_TIMSTAT_TSF_MASK                  (0xFU)
#define FLEXIO_TIMSTAT_TSF_SHIFT                 (0U)
/*! TSF - Timer Status Flag
 *  0b0000..Clear
 *  0b0001..Set
 *  0b0000..No effect
 *  0b0001..Clear the flag
 */
#define FLEXIO_TIMSTAT_TSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMSTAT_TSF_SHIFT)) & FLEXIO_TIMSTAT_TSF_MASK)
/*! @} */

/*! @name SHIFTSIEN - Shifter Status Interrupt Enable */
/*! @{ */

#define FLEXIO_SHIFTSIEN_SSIE_MASK               (0xFU)
#define FLEXIO_SHIFTSIEN_SSIE_SHIFT              (0U)
/*! SSIE - Shifter Status Interrupt Enable */
#define FLEXIO_SHIFTSIEN_SSIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSIEN_SSIE_SHIFT)) & FLEXIO_SHIFTSIEN_SSIE_MASK)
/*! @} */

/*! @name SHIFTEIEN - Shifter Error Interrupt Enable */
/*! @{ */

#define FLEXIO_SHIFTEIEN_SEIE_MASK               (0xFU)
#define FLEXIO_SHIFTEIEN_SEIE_SHIFT              (0U)
/*! SEIE - Shifter Error Interrupt Enable */
#define FLEXIO_SHIFTEIEN_SEIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTEIEN_SEIE_SHIFT)) & FLEXIO_SHIFTEIEN_SEIE_MASK)
/*! @} */

/*! @name TIMIEN - Timer Interrupt Enable */
/*! @{ */

#define FLEXIO_TIMIEN_TEIE_MASK                  (0xFU)
#define FLEXIO_TIMIEN_TEIE_SHIFT                 (0U)
/*! TEIE - Timer Status Interrupt Enable */
#define FLEXIO_TIMIEN_TEIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMIEN_TEIE_SHIFT)) & FLEXIO_TIMIEN_TEIE_MASK)
/*! @} */

/*! @name SHIFTSDEN - Shifter Status DMA Enable */
/*! @{ */

#define FLEXIO_SHIFTSDEN_SSDE_MASK               (0xFU)
#define FLEXIO_SHIFTSDEN_SSDE_SHIFT              (0U)
/*! SSDE - Shifter Status DMA Enable */
#define FLEXIO_SHIFTSDEN_SSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSDEN_SSDE_SHIFT)) & FLEXIO_SHIFTSDEN_SSDE_MASK)
/*! @} */

/*! @name TIMERSDEN - Timer Status DMA Enable */
/*! @{ */

#define FLEXIO_TIMERSDEN_TSDE_MASK               (0xFU)
#define FLEXIO_TIMERSDEN_TSDE_SHIFT              (0U)
/*! TSDE - Timer Status DMA Enable */
#define FLEXIO_TIMERSDEN_TSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMERSDEN_TSDE_SHIFT)) & FLEXIO_TIMERSDEN_TSDE_MASK)
/*! @} */

/*! @name SHIFTSTATE - Shifter State */
/*! @{ */

#define FLEXIO_SHIFTSTATE_STATE_MASK             (0x7U)
#define FLEXIO_SHIFTSTATE_STATE_SHIFT            (0U)
/*! STATE - Current State Pointer */
#define FLEXIO_SHIFTSTATE_STATE(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTATE_STATE_SHIFT)) & FLEXIO_SHIFTSTATE_STATE_MASK)
/*! @} */

/*! @name TRGSTAT - Trigger Status */
/*! @{ */

#define FLEXIO_TRGSTAT_ETSF_MASK                 (0xFU)
#define FLEXIO_TRGSTAT_ETSF_SHIFT                (0U)
/*! ETSF - External Trigger Status Flag
 *  0b0000..Clear
 *  0b0001..Set
 *  0b0000..No effect
 *  0b0001..Clear the flag
 */
#define FLEXIO_TRGSTAT_ETSF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRGSTAT_ETSF_SHIFT)) & FLEXIO_TRGSTAT_ETSF_MASK)
/*! @} */

/*! @name TRIGIEN - External Trigger Interrupt Enable */
/*! @{ */

#define FLEXIO_TRIGIEN_TRIE_MASK                 (0xFU)
#define FLEXIO_TRIGIEN_TRIE_SHIFT                (0U)
/*! TRIE - External Trigger Interrupt Enable */
#define FLEXIO_TRIGIEN_TRIE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRIGIEN_TRIE_SHIFT)) & FLEXIO_TRIGIEN_TRIE_MASK)
/*! @} */

/*! @name PINSTAT - Pin Status */
/*! @{ */

#define FLEXIO_PINSTAT_PSF_MASK                  (0xFFFFFFFFU)
#define FLEXIO_PINSTAT_PSF_SHIFT                 (0U)
/*! PSF - Pin Status Flag
 *  0b00000000000000000000000000000000..Clear
 *  0b00000000000000000000000000000001..Set
 *  0b00000000000000000000000000000000..No effect
 *  0b00000000000000000000000000000001..Clear the flag
 */
#define FLEXIO_PINSTAT_PSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINSTAT_PSF_SHIFT)) & FLEXIO_PINSTAT_PSF_MASK)
/*! @} */

/*! @name PINIEN - Pin Interrupt Enable */
/*! @{ */

#define FLEXIO_PINIEN_PSIE_MASK                  (0xFFFFFFFFU)
#define FLEXIO_PINIEN_PSIE_SHIFT                 (0U)
/*! PSIE - Pin Status Interrupt Enable */
#define FLEXIO_PINIEN_PSIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINIEN_PSIE_SHIFT)) & FLEXIO_PINIEN_PSIE_MASK)
/*! @} */

/*! @name PINREN - Pin Rising Edge Enable */
/*! @{ */

#define FLEXIO_PINREN_PRE_MASK                   (0xFFFFFFFFU)
#define FLEXIO_PINREN_PRE_SHIFT                  (0U)
/*! PRE - Pin Rising Edge */
#define FLEXIO_PINREN_PRE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINREN_PRE_SHIFT)) & FLEXIO_PINREN_PRE_MASK)
/*! @} */

/*! @name PINFEN - Pin Falling Edge Enable */
/*! @{ */

#define FLEXIO_PINFEN_PFE_MASK                   (0xFFFFFFFFU)
#define FLEXIO_PINFEN_PFE_SHIFT                  (0U)
/*! PFE - Pin Falling Edge */
#define FLEXIO_PINFEN_PFE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINFEN_PFE_SHIFT)) & FLEXIO_PINFEN_PFE_MASK)
/*! @} */

/*! @name PINOUTD - Pin Output Data */
/*! @{ */

#define FLEXIO_PINOUTD_OUTD_MASK                 (0xFFFFFFFFU)
#define FLEXIO_PINOUTD_OUTD_SHIFT                (0U)
/*! OUTD - Output Data */
#define FLEXIO_PINOUTD_OUTD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTD_OUTD_SHIFT)) & FLEXIO_PINOUTD_OUTD_MASK)
/*! @} */

/*! @name PINOUTE - Pin Output Enable */
/*! @{ */

#define FLEXIO_PINOUTE_OUTE_MASK                 (0xFFFFFFFFU)
#define FLEXIO_PINOUTE_OUTE_SHIFT                (0U)
/*! OUTE - Output Enable */
#define FLEXIO_PINOUTE_OUTE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTE_OUTE_SHIFT)) & FLEXIO_PINOUTE_OUTE_MASK)
/*! @} */

/*! @name PINOUTDIS - Pin Output Disable */
/*! @{ */

#define FLEXIO_PINOUTDIS_OUTDIS_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTDIS_OUTDIS_SHIFT            (0U)
/*! OUTDIS - Output Disable */
#define FLEXIO_PINOUTDIS_OUTDIS(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTDIS_OUTDIS_SHIFT)) & FLEXIO_PINOUTDIS_OUTDIS_MASK)
/*! @} */

/*! @name PINOUTCLR - Pin Output Clear */
/*! @{ */

#define FLEXIO_PINOUTCLR_OUTCLR_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTCLR_OUTCLR_SHIFT            (0U)
/*! OUTCLR - Output Clear */
#define FLEXIO_PINOUTCLR_OUTCLR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTCLR_OUTCLR_SHIFT)) & FLEXIO_PINOUTCLR_OUTCLR_MASK)
/*! @} */

/*! @name PINOUTSET - Pin Output Set */
/*! @{ */

#define FLEXIO_PINOUTSET_OUTSET_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTSET_OUTSET_SHIFT            (0U)
/*! OUTSET - Output Set */
#define FLEXIO_PINOUTSET_OUTSET(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTSET_OUTSET_SHIFT)) & FLEXIO_PINOUTSET_OUTSET_MASK)
/*! @} */

/*! @name PINOUTTOG - Pin Output Toggle */
/*! @{ */

#define FLEXIO_PINOUTTOG_OUTTOG_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTTOG_OUTTOG_SHIFT            (0U)
/*! OUTTOG - Output Toggle */
#define FLEXIO_PINOUTTOG_OUTTOG(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTTOG_OUTTOG_SHIFT)) & FLEXIO_PINOUTTOG_OUTTOG_MASK)
/*! @} */

/*! @name SHIFTCTL - Shifter Control */
/*! @{ */

#define FLEXIO_SHIFTCTL_SMOD_MASK                (0x7U)
#define FLEXIO_SHIFTCTL_SMOD_SHIFT               (0U)
/*! SMOD - Shifter Mode
 *  0b000..Disable
 *  0b001..Receive mode; capture the current shifter content into SHIFTBUF on expiration of the timer
 *  0b010..Transmit mode; load SHIFTBUF contents into the shifter on expiration of the timer
 *  0b011..Reserved
 *  0b100..Match Store mode; shifter data is compared to SHIFTBUF content on expiration of the timer
 *  0b101..Match Continuous mode; shifter data is continuously compared to SHIFTBUF contents
 *  0b110..State mode; SHIFTBUF contents store programmable state attributes
 *  0b111..Logic mode; SHIFTBUF contents implement programmable logic lookup table
 */
#define FLEXIO_SHIFTCTL_SMOD(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_SMOD_SHIFT)) & FLEXIO_SHIFTCTL_SMOD_MASK)

#define FLEXIO_SHIFTCTL_PINPOL_MASK              (0x80U)
#define FLEXIO_SHIFTCTL_PINPOL_SHIFT             (7U)
/*! PINPOL - Shifter Pin Polarity
 *  0b0..Active high
 *  0b1..Active low
 */
#define FLEXIO_SHIFTCTL_PINPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINPOL_SHIFT)) & FLEXIO_SHIFTCTL_PINPOL_MASK)

#define FLEXIO_SHIFTCTL_PINSEL_MASK              (0x1F00U)
#define FLEXIO_SHIFTCTL_PINSEL_SHIFT             (8U)
/*! PINSEL - Shifter Pin Select */
#define FLEXIO_SHIFTCTL_PINSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINSEL_SHIFT)) & FLEXIO_SHIFTCTL_PINSEL_MASK)

#define FLEXIO_SHIFTCTL_PINCFG_MASK              (0x30000U)
#define FLEXIO_SHIFTCTL_PINCFG_SHIFT             (16U)
/*! PINCFG - Shifter Pin Configuration
 *  0b00..Shifter pin output disabled
 *  0b01..Shifter pin open-drain or bidirectional output enable
 *  0b10..Shifter pin bidirectional output data
 *  0b11..Shifter pin output
 */
#define FLEXIO_SHIFTCTL_PINCFG(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINCFG_SHIFT)) & FLEXIO_SHIFTCTL_PINCFG_MASK)

#define FLEXIO_SHIFTCTL_TIMPOL_MASK              (0x800000U)
#define FLEXIO_SHIFTCTL_TIMPOL_SHIFT             (23U)
/*! TIMPOL - Timer Polarity
 *  0b0..Positive edge
 *  0b1..Negative edge
 */
#define FLEXIO_SHIFTCTL_TIMPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMPOL_SHIFT)) & FLEXIO_SHIFTCTL_TIMPOL_MASK)

#define FLEXIO_SHIFTCTL_TIMSEL_MASK              (0x3000000U)
#define FLEXIO_SHIFTCTL_TIMSEL_SHIFT             (24U)
/*! TIMSEL - Timer Select */
#define FLEXIO_SHIFTCTL_TIMSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMSEL_SHIFT)) & FLEXIO_SHIFTCTL_TIMSEL_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCTL */
#define FLEXIO_SHIFTCTL_COUNT                    (4U)

/*! @name SHIFTCFG - Shifter Configuration */
/*! @{ */

#define FLEXIO_SHIFTCFG_SSTART_MASK              (0x3U)
#define FLEXIO_SHIFTCFG_SSTART_SHIFT             (0U)
/*! SSTART - Shifter Start
 *  0b00..Start bit disabled for Transmitter, Receiver, and Match Store modes; Transmitter mode loads data on enable
 *  0b01..Start bit disabled for Transmitter, Receiver, and Match Store modes; Transmitter mode loads data on first shift
 *  0b10..Transmitter mode outputs start bit value 0 before loading data on first shift; if start bit is not 0,
 *        Receiver and Match Store modes set error flag
 *  0b11..Transmitter mode outputs start bit value 1 before loading data on first shift; if start bit is not 1,
 *        Receiver and Match Store modes set error flag
 */
#define FLEXIO_SHIFTCFG_SSTART(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTART_SHIFT)) & FLEXIO_SHIFTCFG_SSTART_MASK)

#define FLEXIO_SHIFTCFG_SSTOP_MASK               (0x30U)
#define FLEXIO_SHIFTCFG_SSTOP_SHIFT              (4U)
/*! SSTOP - Shifter Stop
 *  0b00..Stop bit disabled for Transmitter, Receiver, and Match Store modes
 *  0b01..Stop bit disabled for Transmitter, Receiver, and Match Store modes; when timer is in stop condition,
 *        Receiver and Match Store modes store receive data on the configured shift edge
 *  0b10..Transmitter mode outputs stop bit value 0 in Match Store mode; if stop bit is not 0, Receiver and Match
 *        Store modes set error flag (when timer is in stop condition, these modes also store receive data on the
 *        configured shift edge)
 *  0b11..Transmitter mode outputs stop bit value 1 in Match Store mode; if stop bit is not 1, Receiver and Match
 *        Store modes set error flag (when timer is in stop condition, these modes also store receive data on the
 *        configured shift edge)
 */
#define FLEXIO_SHIFTCFG_SSTOP(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTOP_SHIFT)) & FLEXIO_SHIFTCFG_SSTOP_MASK)

#define FLEXIO_SHIFTCFG_INSRC_MASK               (0x100U)
#define FLEXIO_SHIFTCFG_INSRC_SHIFT              (8U)
/*! INSRC - Input Source
 *  0b0..Pin
 *  0b1..Shifter n+1 output
 */
#define FLEXIO_SHIFTCFG_INSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_INSRC_SHIFT)) & FLEXIO_SHIFTCFG_INSRC_MASK)

#define FLEXIO_SHIFTCFG_LATST_MASK               (0x200U)
#define FLEXIO_SHIFTCFG_LATST_SHIFT              (9U)
/*! LATST - Late Store
 *  0b0..Store the pre-shift register state
 *  0b1..Store the post-shift register state
 */
#define FLEXIO_SHIFTCFG_LATST(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_LATST_SHIFT)) & FLEXIO_SHIFTCFG_LATST_MASK)

#define FLEXIO_SHIFTCFG_SSIZE_MASK               (0x1000U)
#define FLEXIO_SHIFTCFG_SSIZE_SHIFT              (12U)
/*! SSIZE - Shifter Size
 *  0b0..32-bit
 *  0b1..24-bit
 */
#define FLEXIO_SHIFTCFG_SSIZE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSIZE_SHIFT)) & FLEXIO_SHIFTCFG_SSIZE_MASK)

#define FLEXIO_SHIFTCFG_PWIDTH_MASK              (0x1F0000U)
#define FLEXIO_SHIFTCFG_PWIDTH_SHIFT             (16U)
/*! PWIDTH - Parallel Width */
#define FLEXIO_SHIFTCFG_PWIDTH(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_PWIDTH_SHIFT)) & FLEXIO_SHIFTCFG_PWIDTH_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCFG */
#define FLEXIO_SHIFTCFG_COUNT                    (4U)

/*! @name SHIFTBUF - Shifter Buffer */
/*! @{ */

#define FLEXIO_SHIFTBUF_SHIFTBUF_MASK            (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT           (0U)
/*! SHIFTBUF - Shift Buffer */
#define FLEXIO_SHIFTBUF_SHIFTBUF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT)) & FLEXIO_SHIFTBUF_SHIFTBUF_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUF */
#define FLEXIO_SHIFTBUF_COUNT                    (4U)

/*! @name SHIFTBUFBIS - Shifter Buffer Bit Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT     (0U)
/*! SHIFTBUFBIS - Shift Buffer */
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT)) & FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBIS */
#define FLEXIO_SHIFTBUFBIS_COUNT                 (4U)

/*! @name SHIFTBUFBYS - Shifter Buffer Byte Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT     (0U)
/*! SHIFTBUFBYS - Shift Buffer */
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT)) & FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBYS */
#define FLEXIO_SHIFTBUFBYS_COUNT                 (4U)

/*! @name SHIFTBUFBBS - Shifter Buffer Bit Byte Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT     (0U)
/*! SHIFTBUFBBS - Shift Buffer */
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT)) & FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBBS */
#define FLEXIO_SHIFTBUFBBS_COUNT                 (4U)

/*! @name TIMCTL - Timer Control */
/*! @{ */

#define FLEXIO_TIMCTL_TIMOD_MASK                 (0x7U)
#define FLEXIO_TIMCTL_TIMOD_SHIFT                (0U)
/*! TIMOD - Timer Mode
 *  0b000..Timer disabled
 *  0b001..Dual 8-bit counters baud mode
 *  0b010..Dual 8-bit counters PWM high mode
 *  0b011..Single 16-bit counter mode
 *  0b100..Single 16-bit counter disable mode
 *  0b101..Dual 8-bit counters word mode
 *  0b110..Dual 8-bit counters PWM low mode
 *  0b111..Single 16-bit input capture mode
 */
#define FLEXIO_TIMCTL_TIMOD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TIMOD_SHIFT)) & FLEXIO_TIMCTL_TIMOD_MASK)

#define FLEXIO_TIMCTL_ONETIM_MASK                (0x20U)
#define FLEXIO_TIMCTL_ONETIM_SHIFT               (5U)
/*! ONETIM - Timer One Time Operation
 *  0b0..Generate the timer enable event as normal
 *  0b1..Block the timer enable event unless the timer status flag is clear
 */
#define FLEXIO_TIMCTL_ONETIM(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_ONETIM_SHIFT)) & FLEXIO_TIMCTL_ONETIM_MASK)

#define FLEXIO_TIMCTL_PININS_MASK                (0x40U)
#define FLEXIO_TIMCTL_PININS_SHIFT               (6U)
/*! PININS - Timer Pin Input Select
 *  0b0..PINSEL selects timer pin input and output
 *  0b1..PINSEL + 1 selects the timer pin input; timer pin output remains selected by PINSEL
 */
#define FLEXIO_TIMCTL_PININS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PININS_SHIFT)) & FLEXIO_TIMCTL_PININS_MASK)

#define FLEXIO_TIMCTL_PINPOL_MASK                (0x80U)
#define FLEXIO_TIMCTL_PINPOL_SHIFT               (7U)
/*! PINPOL - Timer Pin Polarity
 *  0b0..Active high
 *  0b1..Active low
 */
#define FLEXIO_TIMCTL_PINPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINPOL_SHIFT)) & FLEXIO_TIMCTL_PINPOL_MASK)

#define FLEXIO_TIMCTL_PINSEL_MASK                (0x1F00U)
#define FLEXIO_TIMCTL_PINSEL_SHIFT               (8U)
/*! PINSEL - Timer Pin Select */
#define FLEXIO_TIMCTL_PINSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINSEL_SHIFT)) & FLEXIO_TIMCTL_PINSEL_MASK)

#define FLEXIO_TIMCTL_PINCFG_MASK                (0x30000U)
#define FLEXIO_TIMCTL_PINCFG_SHIFT               (16U)
/*! PINCFG - Timer Pin Configuration
 *  0b00..Timer pin output disabled
 *  0b01..Timer pin open-drain or bidirectional output enable
 *  0b10..Timer pin bidirectional output data
 *  0b11..Timer pin output
 */
#define FLEXIO_TIMCTL_PINCFG(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINCFG_SHIFT)) & FLEXIO_TIMCTL_PINCFG_MASK)

#define FLEXIO_TIMCTL_TRGSRC_MASK                (0x400000U)
#define FLEXIO_TIMCTL_TRGSRC_SHIFT               (22U)
/*! TRGSRC - Trigger Source
 *  0b0..External
 *  0b1..Internal
 */
#define FLEXIO_TIMCTL_TRGSRC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSRC_SHIFT)) & FLEXIO_TIMCTL_TRGSRC_MASK)

#define FLEXIO_TIMCTL_TRGPOL_MASK                (0x800000U)
#define FLEXIO_TIMCTL_TRGPOL_SHIFT               (23U)
/*! TRGPOL - Trigger Polarity
 *  0b0..Active high
 *  0b1..Active low
 */
#define FLEXIO_TIMCTL_TRGPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGPOL_SHIFT)) & FLEXIO_TIMCTL_TRGPOL_MASK)

#define FLEXIO_TIMCTL_TRGSEL_MASK                (0x3F000000U)
#define FLEXIO_TIMCTL_TRGSEL_SHIFT               (24U)
/*! TRGSEL - Trigger Select */
#define FLEXIO_TIMCTL_TRGSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSEL_SHIFT)) & FLEXIO_TIMCTL_TRGSEL_MASK)
/*! @} */

/* The count of FLEXIO_TIMCTL */
#define FLEXIO_TIMCTL_COUNT                      (4U)

/*! @name TIMCFG - Timer Configuration */
/*! @{ */

#define FLEXIO_TIMCFG_TSTART_MASK                (0x2U)
#define FLEXIO_TIMCFG_TSTART_SHIFT               (1U)
/*! TSTART - Timer Start
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FLEXIO_TIMCFG_TSTART(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTART_SHIFT)) & FLEXIO_TIMCFG_TSTART_MASK)

#define FLEXIO_TIMCFG_TSTOP_MASK                 (0x30U)
#define FLEXIO_TIMCFG_TSTOP_SHIFT                (4U)
/*! TSTOP - Timer Stop
 *  0b00..Disabled
 *  0b01..Enabled on timer compare
 *  0b10..Enabled on timer disable
 *  0b11..Enabled on timer compare and timer disable
 */
#define FLEXIO_TIMCFG_TSTOP(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTOP_SHIFT)) & FLEXIO_TIMCFG_TSTOP_MASK)

#define FLEXIO_TIMCFG_TIMENA_MASK                (0x700U)
#define FLEXIO_TIMCFG_TIMENA_SHIFT               (8U)
/*! TIMENA - Timer Enable
 *  0b000..Timer always enabled
 *  0b001..Timer enabled on timer n-1 enable
 *  0b010..Timer enabled on trigger high
 *  0b011..Timer enabled on trigger high and pin high
 *  0b100..Timer enabled on pin rising edge
 *  0b101..Timer enabled on pin rising edge and trigger high
 *  0b110..Timer enabled on trigger rising edge
 *  0b111..Timer enabled on trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMENA(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMENA_SHIFT)) & FLEXIO_TIMCFG_TIMENA_MASK)

#define FLEXIO_TIMCFG_TIMDIS_MASK                (0x7000U)
#define FLEXIO_TIMCFG_TIMDIS_SHIFT               (12U)
/*! TIMDIS - Timer Disable
 *  0b000..Timer never disabled
 *  0b001..Timer disabled on timer n-1 disable
 *  0b010..Timer disabled on timer compare (upper 8 bits match and decrement)
 *  0b011..Timer disabled on timer compare (upper 8 bits match and decrement) and trigger low
 *  0b100..Timer disabled on pin rising or falling edge
 *  0b101..Timer disabled on pin rising or falling edge provided trigger is high
 *  0b110..Timer disabled on trigger falling edge
 *  0b111..Reserved
 */
#define FLEXIO_TIMCFG_TIMDIS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDIS_SHIFT)) & FLEXIO_TIMCFG_TIMDIS_MASK)

#define FLEXIO_TIMCFG_TIMRST_MASK                (0x70000U)
#define FLEXIO_TIMCFG_TIMRST_SHIFT               (16U)
/*! TIMRST - Timer Reset
 *  0b000..Never reset timer
 *  0b001..Timer reset on timer output high.
 *  0b010..Timer reset on timer pin equal to timer output
 *  0b011..Timer reset on timer trigger equal to timer output
 *  0b100..Timer reset on timer pin rising edge
 *  0b101..Reserved
 *  0b110..Timer reset on trigger rising edge
 *  0b111..Timer reset on trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMRST(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMRST_SHIFT)) & FLEXIO_TIMCFG_TIMRST_MASK)

#define FLEXIO_TIMCFG_TIMDEC_MASK                (0x700000U)
#define FLEXIO_TIMCFG_TIMDEC_SHIFT               (20U)
/*! TIMDEC - Timer Decrement
 *  0b000..Decrement counter on FLEXIO clock; shift clock equals timer output
 *  0b001..Decrement counter on trigger input (both edges); shift clock equals timer output
 *  0b010..Decrement counter on pin input (both edges); shift clock equals pin input
 *  0b011..Decrement counter on trigger input (both edges); shift clock equals trigger input
 *  0b100..Decrement counter on FLEXIO clock divided by 16; shift clock equals timer output
 *  0b101..Decrement counter on FLEXIO clock divided by 256; shift clock equals timer output
 *  0b110..Decrement counter on pin input (rising edge); shift clock equals pin input
 *  0b111..Decrement counter on trigger input (rising edge); shift clock equals trigger input
 */
#define FLEXIO_TIMCFG_TIMDEC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDEC_SHIFT)) & FLEXIO_TIMCFG_TIMDEC_MASK)

#define FLEXIO_TIMCFG_TIMOUT_MASK                (0x3000000U)
#define FLEXIO_TIMCFG_TIMOUT_SHIFT               (24U)
/*! TIMOUT - Timer Output
 *  0b00..Logic one when enabled; not affected by timer reset
 *  0b01..Logic zero when enabled; not affected by timer reset
 *  0b10..Logic one when enabled and on timer reset
 *  0b11..Logic zero when enabled and on timer reset
 */
#define FLEXIO_TIMCFG_TIMOUT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMOUT_SHIFT)) & FLEXIO_TIMCFG_TIMOUT_MASK)
/*! @} */

/* The count of FLEXIO_TIMCFG */
#define FLEXIO_TIMCFG_COUNT                      (4U)

/*! @name TIMCMP - Timer Compare */
/*! @{ */

#define FLEXIO_TIMCMP_CMP_MASK                   (0xFFFFU)
#define FLEXIO_TIMCMP_CMP_SHIFT                  (0U)
/*! CMP - Timer Compare Value */
#define FLEXIO_TIMCMP_CMP(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCMP_CMP_SHIFT)) & FLEXIO_TIMCMP_CMP_MASK)
/*! @} */

/* The count of FLEXIO_TIMCMP */
#define FLEXIO_TIMCMP_COUNT                      (4U)

/*! @name SHIFTBUFNBS - Shifter Buffer Nibble Byte Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT     (0U)
/*! SHIFTBUFNBS - Shift Buffer */
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT)) & FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNBS */
#define FLEXIO_SHIFTBUFNBS_COUNT                 (4U)

/*! @name SHIFTBUFHWS - Shifter Buffer Halfword Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT     (0U)
/*! SHIFTBUFHWS - Shift Buffer */
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT)) & FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHWS */
#define FLEXIO_SHIFTBUFHWS_COUNT                 (4U)

/*! @name SHIFTBUFNIS - Shifter Buffer Nibble Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT     (0U)
/*! SHIFTBUFNIS - Shift Buffer */
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT)) & FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNIS */
#define FLEXIO_SHIFTBUFNIS_COUNT                 (4U)

/*! @name SHIFTBUFOES - Shifter Buffer Odd Even Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT     (0U)
/*! SHIFTBUFOES - Shift Buffer */
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT)) & FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFOES */
#define FLEXIO_SHIFTBUFOES_COUNT                 (4U)

/*! @name SHIFTBUFEOS - Shifter Buffer Even Odd Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT     (0U)
/*! SHIFTBUFEOS - Shift Buffer */
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT)) & FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFEOS */
#define FLEXIO_SHIFTBUFEOS_COUNT                 (4U)

/*! @name SHIFTBUFHBS - Shifter Buffer Halfword Byte Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_SHIFT     (0U)
/*! SHIFTBUFHBS - Shift Buffer */
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_SHIFT)) & FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHBS */
#define FLEXIO_SHIFTBUFHBS_COUNT                 (4U)


/*!
 * @}
 */ /* end of group FLEXIO_Register_Masks */


/* FLEXIO - Peripheral instance base addresses */
/** Peripheral FLEXIO0 base address */
#define FLEXIO0_BASE                             (0x40099000u)
/** Peripheral FLEXIO0 base pointer */
#define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
/** Array initializer of FLEXIO peripheral base addresses */
#define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
/** Array initializer of FLEXIO peripheral base pointers */
#define FLEXIO_BASE_PTRS                         { FLEXIO0 }
/** Interrupt vectors for the FLEXIO peripheral type */
#define FLEXIO_IRQS                              { FLEXIO_IRQn }

/*!
 * @}
 */ /* end of group FLEXIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMC_Peripheral_Access_Layer FMC Peripheral Access Layer
 * @{
 */

/** FMC - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[32];
  __IO uint32_t REMAP;                             /**< Data Remap, offset: 0x20 */
} FMC_Type;

/* ----------------------------------------------------------------------------
   -- FMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMC_Register_Masks FMC Register Masks
 * @{
 */

/*! @name REMAP - Data Remap */
/*! @{ */

#define FMC_REMAP_REMAPLK_MASK                   (0x1U)
#define FMC_REMAP_REMAPLK_SHIFT                  (0U)
/*! REMAPLK - Remap Lock Enable
 *  0b1..Lock enabled: cannot write to REMAP
 *  0b0..Lock disabled: can write to REMAP
 */
#define FMC_REMAP_REMAPLK(x)                     (((uint32_t)(((uint32_t)(x)) << FMC_REMAP_REMAPLK_SHIFT)) & FMC_REMAP_REMAPLK_MASK)

#define FMC_REMAP_LIM_MASK                       (0x7F0000U)
#define FMC_REMAP_LIM_SHIFT                      (16U)
/*! LIM - LIM Remapping Address */
#define FMC_REMAP_LIM(x)                         (((uint32_t)(((uint32_t)(x)) << FMC_REMAP_LIM_SHIFT)) & FMC_REMAP_LIM_MASK)

#define FMC_REMAP_LIMDP_MASK                     (0x7F000000U)
#define FMC_REMAP_LIMDP_SHIFT                    (24U)
/*! LIMDP - LIMDP Remapping Address */
#define FMC_REMAP_LIMDP(x)                       (((uint32_t)(((uint32_t)(x)) << FMC_REMAP_LIMDP_SHIFT)) & FMC_REMAP_LIMDP_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FMC_Register_Masks */


/* FMC - Peripheral instance base addresses */
/** Peripheral FMC0 base address */
#define FMC0_BASE                                (0x40094000u)
/** Peripheral FMC0 base pointer */
#define FMC0                                     ((FMC_Type *)FMC0_BASE)
/** Array initializer of FMC peripheral base addresses */
#define FMC_BASE_ADDRS                           { FMC0_BASE }
/** Array initializer of FMC peripheral base pointers */
#define FMC_BASE_PTRS                            { FMC0 }

/*!
 * @}
 */ /* end of group FMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FMU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMU_Peripheral_Access_Layer FMU Peripheral Access Layer
 * @{
 */

/** FMU - Register Layout Typedef */
typedef struct {
  __IO uint32_t FSTAT;                             /**< Flash Status Register, offset: 0x0 */
  __IO uint32_t FCNFG;                             /**< Flash Configuration Register, offset: 0x4 */
  __IO uint32_t FCTRL;                             /**< Flash Control Register, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t FCCOB[8];                          /**< Flash Common Command Object Registers, array offset: 0x10, array step: 0x4 */
} FMU_Type;

/* ----------------------------------------------------------------------------
   -- FMU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMU_Register_Masks FMU Register Masks
 * @{
 */

/*! @name FSTAT - Flash Status Register */
/*! @{ */

#define FMU_FSTAT_FAIL_MASK                      (0x1U)
#define FMU_FSTAT_FAIL_SHIFT                     (0U)
/*! FAIL - Command Fail Flag
 *  0b0..Error not detected
 *  0b1..Error detected
 */
#define FMU_FSTAT_FAIL(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_FAIL_SHIFT)) & FMU_FSTAT_FAIL_MASK)

#define FMU_FSTAT_CMDABT_MASK                    (0x4U)
#define FMU_FSTAT_CMDABT_SHIFT                   (2U)
/*! CMDABT - Command Abort Flag
 *  0b0..No command abort detected
 *  0b1..Command abort detected
 */
#define FMU_FSTAT_CMDABT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDABT_SHIFT)) & FMU_FSTAT_CMDABT_MASK)

#define FMU_FSTAT_PVIOL_MASK                     (0x10U)
#define FMU_FSTAT_PVIOL_SHIFT                    (4U)
/*! PVIOL - Command Protection Violation Flag
 *  0b0..No protection violation detected
 *  0b1..Protection violation detected
 */
#define FMU_FSTAT_PVIOL(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PVIOL_SHIFT)) & FMU_FSTAT_PVIOL_MASK)

#define FMU_FSTAT_ACCERR_MASK                    (0x20U)
#define FMU_FSTAT_ACCERR_SHIFT                   (5U)
/*! ACCERR - Command Access Error Flag
 *  0b0..No access error detected
 *  0b1..Access error detected
 */
#define FMU_FSTAT_ACCERR(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_ACCERR_SHIFT)) & FMU_FSTAT_ACCERR_MASK)

#define FMU_FSTAT_CWSABT_MASK                    (0x40U)
#define FMU_FSTAT_CWSABT_SHIFT                   (6U)
/*! CWSABT - Command Write Sequence Abort Flag
 *  0b0..Command write sequence not aborted
 *  0b1..Command write sequence aborted
 */
#define FMU_FSTAT_CWSABT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CWSABT_SHIFT)) & FMU_FSTAT_CWSABT_MASK)

#define FMU_FSTAT_CCIF_MASK                      (0x80U)
#define FMU_FSTAT_CCIF_SHIFT                     (7U)
/*! CCIF - Command Complete Interrupt Flag
 *  0b0..Flash command, initialization, or power mode recovery in progress
 *  0b1..Flash command, initialization, or power mode recovery has completed
 */
#define FMU_FSTAT_CCIF(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CCIF_SHIFT)) & FMU_FSTAT_CCIF_MASK)

#define FMU_FSTAT_CMDPRT_MASK                    (0x300U)
#define FMU_FSTAT_CMDPRT_SHIFT                   (8U)
/*! CMDPRT - Command protection level
 *  0b00..Secure, normal access
 *  0b01..Secure, privileged access
 *  0b10..Nonsecure, normal access
 *  0b11..Nonsecure, privileged access
 */
#define FMU_FSTAT_CMDPRT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDPRT_SHIFT)) & FMU_FSTAT_CMDPRT_MASK)

#define FMU_FSTAT_CMDP_MASK                      (0x800U)
#define FMU_FSTAT_CMDP_SHIFT                     (11U)
/*! CMDP - Command protection status flag
 *  0b0..Command protection level and domain ID are stale
 *  0b1..Command protection level (CMDPRT) and domain ID (CMDDID) are set
 */
#define FMU_FSTAT_CMDP(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDP_SHIFT)) & FMU_FSTAT_CMDP_MASK)

#define FMU_FSTAT_CMDDID_MASK                    (0xF000U)
#define FMU_FSTAT_CMDDID_SHIFT                   (12U)
/*! CMDDID - Command domain ID */
#define FMU_FSTAT_CMDDID(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDDID_SHIFT)) & FMU_FSTAT_CMDDID_MASK)

#define FMU_FSTAT_DFDIF_MASK                     (0x10000U)
#define FMU_FSTAT_DFDIF_SHIFT                    (16U)
/*! DFDIF - Double Bit Fault Detect Interrupt Flag
 *  0b0..Double bit fault not detected during a valid flash read access
 *  0b1..Double bit fault detected (or FCTRL[FDFD] is set) during a valid flash read access
 */
#define FMU_FSTAT_DFDIF(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_DFDIF_SHIFT)) & FMU_FSTAT_DFDIF_MASK)

#define FMU_FSTAT_SALV_USED_MASK                 (0x20000U)
#define FMU_FSTAT_SALV_USED_SHIFT                (17U)
/*! SALV_USED - Salvage Used for Erase operation
 *  0b0..Salvage not used during last operation
 *  0b1..Salvage used during the last erase operation
 */
#define FMU_FSTAT_SALV_USED(x)                   (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_SALV_USED_SHIFT)) & FMU_FSTAT_SALV_USED_MASK)

#define FMU_FSTAT_PEWEN_MASK                     (0x3000000U)
#define FMU_FSTAT_PEWEN_SHIFT                    (24U)
/*! PEWEN - Program-Erase Write Enable Control
 *  0b00..Writes are not enabled
 *  0b01..Writes are enabled for one flash or IFR phrase (phrase programming, sector erase)
 *  0b10..Writes are enabled for one flash or IFR page (page programming)
 *  0b11..Reserved
 */
#define FMU_FSTAT_PEWEN(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PEWEN_SHIFT)) & FMU_FSTAT_PEWEN_MASK)

#define FMU_FSTAT_PERDY_MASK                     (0x80000000U)
#define FMU_FSTAT_PERDY_SHIFT                    (31U)
/*! PERDY - Program-Erase Ready Control/Status Flag
 *  0b0..Program or sector erase command operation not stalled
 *  0b1..Program or sector erase command operation ready to execute
 */
#define FMU_FSTAT_PERDY(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PERDY_SHIFT)) & FMU_FSTAT_PERDY_MASK)
/*! @} */

/*! @name FCNFG - Flash Configuration Register */
/*! @{ */

#define FMU_FCNFG_CCIE_MASK                      (0x80U)
#define FMU_FCNFG_CCIE_SHIFT                     (7U)
/*! CCIE - Command Complete Interrupt Enable
 *  0b0..Command complete interrupt disabled
 *  0b1..Command complete interrupt enabled
 */
#define FMU_FCNFG_CCIE(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_CCIE_SHIFT)) & FMU_FCNFG_CCIE_MASK)

#define FMU_FCNFG_ERSREQ_MASK                    (0x100U)
#define FMU_FCNFG_ERSREQ_SHIFT                   (8U)
/*! ERSREQ - Mass Erase Request
 *  0b0..No request or request complete
 *  0b1..Request to run the Mass Erase operation
 */
#define FMU_FCNFG_ERSREQ(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSREQ_SHIFT)) & FMU_FCNFG_ERSREQ_MASK)

#define FMU_FCNFG_DFDIE_MASK                     (0x10000U)
#define FMU_FCNFG_DFDIE_SHIFT                    (16U)
/*! DFDIE - Double Bit Fault Detect Interrupt Enable
 *  0b0..Double bit fault detect interrupt disabled
 *  0b1..Double bit fault detect interrupt enabled
 */
#define FMU_FCNFG_DFDIE(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_DFDIE_SHIFT)) & FMU_FCNFG_DFDIE_MASK)

#define FMU_FCNFG_ERSIEN0_MASK                   (0xF000000U)
#define FMU_FCNFG_ERSIEN0_SHIFT                  (24U)
/*! ERSIEN0 - Erase IFR Sector Enable - Block 0
 *  0b0000..Block 0 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 0 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMU_FCNFG_ERSIEN0(x)                     (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSIEN0_SHIFT)) & FMU_FCNFG_ERSIEN0_MASK)

#define FMU_FCNFG_ERSIEN1_MASK                   (0xF0000000U)
#define FMU_FCNFG_ERSIEN1_SHIFT                  (28U)
/*! ERSIEN1 - Erase IFR Sector Enable - Block 1 (for dual block configs)
 *  0b0000..Block 1 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 1 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMU_FCNFG_ERSIEN1(x)                     (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSIEN1_SHIFT)) & FMU_FCNFG_ERSIEN1_MASK)
/*! @} */

/*! @name FCTRL - Flash Control Register */
/*! @{ */

#define FMU_FCTRL_RWSC_MASK                      (0xFU)
#define FMU_FCTRL_RWSC_SHIFT                     (0U)
/*! RWSC - Read Wait-State Control */
#define FMU_FCTRL_RWSC(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_RWSC_SHIFT)) & FMU_FCTRL_RWSC_MASK)

#define FMU_FCTRL_LSACTIVE_MASK                  (0x100U)
#define FMU_FCTRL_LSACTIVE_SHIFT                 (8U)
/*! LSACTIVE - Low speed active mode
 *  0b0..Full speed active mode requested
 *  0b1..Low speed active mode requested
 */
#define FMU_FCTRL_LSACTIVE(x)                    (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_LSACTIVE_SHIFT)) & FMU_FCTRL_LSACTIVE_MASK)

#define FMU_FCTRL_FDFD_MASK                      (0x10000U)
#define FMU_FCTRL_FDFD_SHIFT                     (16U)
/*! FDFD - Force Double Bit Fault Detect
 *  0b0..FSTAT[DFDIF] sets only if a double bit fault is detected during a valid flash read access from the platform flash controller
 *  0b1..FSTAT[DFDIF] sets during any valid flash read access from the platform flash controller. An interrupt
 *       request is generated if the DFDIE bit is set.
 */
#define FMU_FCTRL_FDFD(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_FDFD_SHIFT)) & FMU_FCTRL_FDFD_MASK)

#define FMU_FCTRL_ABTREQ_MASK                    (0x1000000U)
#define FMU_FCTRL_ABTREQ_SHIFT                   (24U)
/*! ABTREQ - Abort Request
 *  0b0..No request to abort a command write sequence
 *  0b1..Request to abort a command write sequence
 */
#define FMU_FCTRL_ABTREQ(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_ABTREQ_SHIFT)) & FMU_FCTRL_ABTREQ_MASK)
/*! @} */

/*! @name FCCOB - Flash Common Command Object Registers */
/*! @{ */

#define FMU_FCCOB_CCOBn_MASK                     (0xFFFFFFFFU)
#define FMU_FCCOB_CCOBn_SHIFT                    (0U)
/*! CCOBn - CCOBn */
#define FMU_FCCOB_CCOBn(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FCCOB_CCOBn_SHIFT)) & FMU_FCCOB_CCOBn_MASK)
/*! @} */

/* The count of FMU_FCCOB */
#define FMU_FCCOB_COUNT                          (8U)


/*!
 * @}
 */ /* end of group FMU_Register_Masks */


/* FMU - Peripheral instance base addresses */
/** Peripheral FMU0 base address */
#define FMU0_BASE                                (0x40095000u)
/** Peripheral FMU0 base pointer */
#define FMU0                                     ((FMU_Type *)FMU0_BASE)
/** Array initializer of FMU peripheral base addresses */
#define FMU_BASE_ADDRS                           { FMU0_BASE }
/** Array initializer of FMU peripheral base pointers */
#define FMU_BASE_PTRS                            { FMU0 }

/*!
 * @}
 */ /* end of group FMU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FMUTEST Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMUTEST_Peripheral_Access_Layer FMUTEST Peripheral Access Layer
 * @{
 */

/** FMUTEST - Register Layout Typedef */
typedef struct {
  __IO uint32_t FSTAT;                             /**< Flash Status Register, offset: 0x0 */
  __IO uint32_t FCNFG;                             /**< Flash Configuration Register, offset: 0x4 */
  __IO uint32_t FCTRL;                             /**< Flash Control Register, offset: 0x8 */
  __I  uint32_t FTEST;                             /**< Flash Test Register, offset: 0xC */
  __IO uint32_t FCCOB0;                            /**< Flash Command Control 0 Register, offset: 0x10 */
  __IO uint32_t FCCOB1;                            /**< Flash Command Control 1 Register, offset: 0x14 */
  __IO uint32_t FCCOB2;                            /**< Flash Command Control 2 Register, offset: 0x18 */
  __IO uint32_t FCCOB3;                            /**< Flash Command Control 3 Register, offset: 0x1C */
  __IO uint32_t FCCOB4;                            /**< Flash Command Control 4 Register, offset: 0x20 */
  __IO uint32_t FCCOB5;                            /**< Flash Command Control 5 Register, offset: 0x24 */
  __IO uint32_t FCCOB6;                            /**< Flash Command Control 6 Register, offset: 0x28 */
  __IO uint32_t FCCOB7;                            /**< Flash Command Control 7 Register, offset: 0x2C */
       uint8_t RESERVED_0[208];
  __IO uint32_t RESET_STATUS;                      /**< FMU Initialization Tracking Register, offset: 0x100 */
  __IO uint32_t MCTL;                              /**< FMU Control Register, offset: 0x104 */
  __I  uint32_t BSEL_GEN;                          /**< FMU Block Select Generation Register, offset: 0x108 */
  __IO uint32_t PWR_OPT;                           /**< Power Mode Options Register, offset: 0x10C */
  __I  uint32_t CMD_CHECK;                         /**< FMU Command Check Register, offset: 0x110 */
       uint8_t RESERVED_1[12];
  __IO uint32_t BSEL;                              /**< FMU Block Select Register, offset: 0x120 */
  __IO uint32_t MSIZE;                             /**< FMU Memory Size Register, offset: 0x124 */
  __IO uint32_t FLASH_RD_ADD;                      /**< Flash Read Address Register, offset: 0x128 */
       uint8_t RESERVED_2[4];
  __IO uint32_t FLASH_STOP_ADD;                    /**< Flash Stop Address Register, offset: 0x130 */
  __IO uint32_t FLASH_RD_CTRL;                     /**< Flash Read Control Register, offset: 0x134 */
  __IO uint32_t MM_ADDR;                           /**< Memory Map Address Register, offset: 0x138 */
       uint8_t RESERVED_3[4];
  __IO uint32_t MM_WDATA;                          /**< Memory Map Write Data Register, offset: 0x140 */
  __IO uint32_t MM_CTL;                            /**< Memory Map Control Register, offset: 0x144 */
  __IO uint32_t UINT_CTL;                          /**< User Interface Control Register, offset: 0x148 */
  __IO uint32_t RD_DATA0;                          /**< Read Data 0 Register, offset: 0x14C */
  __IO uint32_t RD_DATA1;                          /**< Read Data 1 Register, offset: 0x150 */
  __IO uint32_t RD_DATA2;                          /**< Read Data 2 Register, offset: 0x154 */
  __IO uint32_t RD_DATA3;                          /**< Read Data 3 Register, offset: 0x158 */
  __IO uint32_t PARITY;                            /**< Parity Register, offset: 0x15C */
  __IO uint32_t RD_PATH_CTRL_STATUS;               /**< Read Path Control and Status Register, offset: 0x160 */
  __IO uint32_t SMW_DIN0;                          /**< SMW DIN 0 Register, offset: 0x164 */
  __IO uint32_t SMW_DIN1;                          /**< SMW DIN 1 Register, offset: 0x168 */
  __IO uint32_t SMW_DIN2;                          /**< SMW DIN 2 Register, offset: 0x16C */
  __IO uint32_t SMW_DIN3;                          /**< SMW DIN 3 Register, offset: 0x170 */
  __IO uint32_t SMW_ADDR;                          /**< SMW Address Register, offset: 0x174 */
  __IO uint32_t SMW_CMD_WAIT;                      /**< SMW Command and Wait Register, offset: 0x178 */
  __I  uint32_t SMW_STATUS;                        /**< SMW Status Register, offset: 0x17C */
  __IO uint32_t SOCTRIM0_0;                        /**< SoC Trim Phrase 0 Word 0 Register, offset: 0x180 */
  __IO uint32_t SOCTRIM0_1;                        /**< SoC Trim Phrase 0 Word 1 Register, offset: 0x184 */
  __IO uint32_t SOCTRIM0_2;                        /**< SoC Trim Phrase 0 Word 2 Register, offset: 0x188 */
  __IO uint32_t SOCTRIM0_3;                        /**< SoC Trim Phrase 0 Word 3 Register, offset: 0x18C */
  __IO uint32_t SOCTRIM1_0;                        /**< SoC Trim Phrase 1 Word 0 Register, offset: 0x190 */
  __IO uint32_t SOCTRIM1_1;                        /**< SoC Trim Phrase 1 Word 1 Register, offset: 0x194 */
  __IO uint32_t SOCTRIM1_2;                        /**< SoC Trim Phrase 1 Word 2 Register, offset: 0x198 */
  __IO uint32_t SOCTRIM1_3;                        /**< SoC Trim Phrase 1 Word 3 Register, offset: 0x19C */
  __IO uint32_t SOCTRIM2_0;                        /**< SoC Trim Phrase 2 Word 0 Register, offset: 0x1A0 */
  __IO uint32_t SOCTRIM2_1;                        /**< SoC Trim Phrase 2 Word 1 Register, offset: 0x1A4 */
  __IO uint32_t SOCTRIM2_2;                        /**< SoC Trim Phrase 2 Word 2 Register, offset: 0x1A8 */
  __IO uint32_t SOCTRIM2_3;                        /**< SoC Trim Phrase 2 Word 3 Register, offset: 0x1AC */
  __IO uint32_t SOCTRIM3_0;                        /**< SoC Trim Phrase 3 Word 0 Register, offset: 0x1B0 */
  __IO uint32_t SOCTRIM3_1;                        /**< SoC Trim Phrase 3 Word 1 Register, offset: 0x1B4 */
  __IO uint32_t SOCTRIM3_2;                        /**< SoC Trim Phrase 3 Word 2 Register, offset: 0x1B8 */
  __IO uint32_t SOCTRIM3_3;                        /**< SoC Trim Phrase 3 Word 3 Register, offset: 0x1BC */
  __IO uint32_t SOCTRIM4_0;                        /**< SoC Trim Phrase 4 Word 0 Register, offset: 0x1C0 */
  __IO uint32_t SOCTRIM4_1;                        /**< SoC Trim Phrase 4 Word 1 Register, offset: 0x1C4 */
  __IO uint32_t SOCTRIM4_2;                        /**< SoC Trim Phrase 4 Word 2 Register, offset: 0x1C8 */
  __IO uint32_t SOCTRIM4_3;                        /**< SoC Trim Phrase 4 Word 3 Register, offset: 0x1CC */
  __IO uint32_t SOCTRIM5_0;                        /**< SoC Trim Phrase 5 Word 0 Register, offset: 0x1D0 */
  __IO uint32_t SOCTRIM5_1;                        /**< SoC Trim Phrase 5 Word 1 Register, offset: 0x1D4 */
  __IO uint32_t SOCTRIM5_2;                        /**< SoC Trim Phrase 5 Word 2 Register, offset: 0x1D8 */
  __IO uint32_t SOCTRIM5_3;                        /**< SoC Trim Phrase 5 Word 3 Register, offset: 0x1DC */
  __IO uint32_t SOCTRIM6_0;                        /**< SoC Trim Phrase 6 Word 0 Register, offset: 0x1E0 */
  __IO uint32_t SOCTRIM6_1;                        /**< SoC Trim Phrase 6 Word 1 Register, offset: 0x1E4 */
  __IO uint32_t SOCTRIM6_2;                        /**< SoC Trim Phrase 6 Word 2 Register, offset: 0x1E8 */
  __IO uint32_t SOCTRIM6_3;                        /**< SoC Trim Phrase 6 Word 3 Register, offset: 0x1EC */
  __IO uint32_t SOCTRIM7_0;                        /**< SoC Trim Phrase 7 Word 0 Register, offset: 0x1F0 */
  __IO uint32_t SOCTRIM7_1;                        /**< SoC Trim Phrase 7 Word 1 Register, offset: 0x1F4 */
  __IO uint32_t SOCTRIM7_2;                        /**< SoC Trim Phrase 7 Word 2 Register, offset: 0x1F8 */
  __IO uint32_t SOCTRIM7_3;                        /**< SoC Trim Phrase 7 Word 3 Register, offset: 0x1FC */
       uint8_t RESERVED_4[4];
  __IO uint32_t R_IP_CONFIG;                       /**< BIST Configuration Register, offset: 0x204 */
  __IO uint32_t R_TESTCODE;                        /**< BIST Test Code Register, offset: 0x208 */
  __IO uint32_t R_DFT_CTRL;                        /**< BIST DFT Control Register, offset: 0x20C */
  __IO uint32_t R_ADR_CTRL;                        /**< BIST Address Control Register, offset: 0x210 */
  __IO uint32_t R_DATA_CTRL0;                      /**< BIST Data Control 0 Register, offset: 0x214 */
  __IO uint32_t R_PIN_CTRL;                        /**< BIST Pin Control Register, offset: 0x218 */
  __IO uint32_t R_CNT_LOOP_CTRL;                   /**< BIST Loop Count Control Register, offset: 0x21C */
  __IO uint32_t R_TIMER_CTRL;                      /**< BIST Timer Control Register, offset: 0x220 */
  __IO uint32_t R_TEST_CTRL;                       /**< BIST Test Control Register, offset: 0x224 */
  __O  uint32_t R_ABORT_LOOP;                      /**< BIST Abort Loop Register, offset: 0x228 */
  __I  uint32_t R_ADR_QUERY;                       /**< BIST Address Query Register, offset: 0x22C */
  __I  uint32_t R_DOUT_QUERY0;                     /**< BIST DOUT Query 0 Register, offset: 0x230 */
       uint8_t RESERVED_5[8];
  __I  uint32_t R_SMW_QUERY;                       /**< BIST SMW Query Register, offset: 0x23C */
  __IO uint32_t R_SMW_SETTING0;                    /**< BIST SMW Setting 0 Register, offset: 0x240 */
  __IO uint32_t R_SMW_SETTING1;                    /**< BIST SMW Setting 1 Register, offset: 0x244 */
  __IO uint32_t R_SMP_WHV0;                        /**< BIST SMP WHV Setting 0 Register, offset: 0x248 */
  __IO uint32_t R_SMP_WHV1;                        /**< BIST SMP WHV Setting 1 Register, offset: 0x24C */
  __IO uint32_t R_SME_WHV0;                        /**< BIST SME WHV Setting 0 Register, offset: 0x250 */
  __IO uint32_t R_SME_WHV1;                        /**< BIST SME WHV Setting 1 Register, offset: 0x254 */
  __IO uint32_t R_SMW_SETTING2;                    /**< BIST SMW Setting 2 Register, offset: 0x258 */
  __I  uint32_t R_D_MISR0;                         /**< BIST DIN MISR 0 Register, offset: 0x25C */
  __I  uint32_t R_A_MISR0;                         /**< BIST Address MISR 0 Register, offset: 0x260 */
  __I  uint32_t R_C_MISR0;                         /**< BIST Control MISR 0 Register, offset: 0x264 */
  __IO uint32_t R_SMW_SETTING3;                    /**< BIST SMW Setting 3 Register, offset: 0x268 */
  __IO uint32_t R_DATA_CTRL1;                      /**< BIST Data Control 1 Register, offset: 0x26C */
  __IO uint32_t R_DATA_CTRL2;                      /**< BIST Data Control 2 Register, offset: 0x270 */
  __IO uint32_t R_DATA_CTRL3;                      /**< BIST Data Control 3 Register, offset: 0x274 */
       uint8_t RESERVED_6[8];
  __I  uint32_t R_REPAIR0_0;                       /**< BIST Repair 0 for Block 0 Register, offset: 0x280 */
  __I  uint32_t R_REPAIR0_1;                       /**< BIST Repair 1 Block 0 Register, offset: 0x284 */
  __I  uint32_t R_REPAIR1_0;                       /**< BIST Repair 0 Block 1 Register, offset: 0x288 */
  __I  uint32_t R_REPAIR1_1;                       /**< BIST Repair 1 Block 1 Register, offset: 0x28C */
       uint8_t RESERVED_7[132];
  __IO uint32_t R_DATA_CTRL0_EX;                   /**< BIST Data Control 0 Extension Register, offset: 0x314 */
       uint8_t RESERVED_8[8];
  __IO uint32_t R_TIMER_CTRL_EX;                   /**< BIST Timer Control Extension Register, offset: 0x320 */
       uint8_t RESERVED_9[12];
  __I  uint32_t R_DOUT_QUERY1;                     /**< BIST DOUT Query 1 Register, offset: 0x330 */
       uint8_t RESERVED_10[40];
  __I  uint32_t R_D_MISR1;                         /**< BIST DIN MISR 1 Register, offset: 0x35C */
  __I  uint32_t R_A_MISR1;                         /**< BIST Address MISR 1 Register, offset: 0x360 */
  __I  uint32_t R_C_MISR1;                         /**< BIST Control MISR 1 Register, offset: 0x364 */
       uint8_t RESERVED_11[4];
  __IO uint32_t R_DATA_CTRL1_EX;                   /**< BIST Data Control 1 Extension Register, offset: 0x36C */
  __IO uint32_t R_DATA_CTRL2_EX;                   /**< BIST Data Control 2 Extension Register, offset: 0x370 */
  __IO uint32_t R_DATA_CTRL3_EX;                   /**< BIST Data Control 3 Extension Register, offset: 0x374 */
       uint8_t RESERVED_12[136];
  __IO uint32_t SMW_TIMER_OPTION;                  /**< SMW Timer Option Register, offset: 0x400 */
  __IO uint32_t SMW_SETTING_OPTION0;               /**< SMW Setting Option 0 Register, offset: 0x404 */
  __IO uint32_t SMW_SETTING_OPTION2;               /**< SMW Setting Option 2 Register, offset: 0x408 */
  __IO uint32_t SMW_SETTING_OPTION3;               /**< SMW Setting Option 3 Register, offset: 0x40C */
  __IO uint32_t SMW_SMP_WHV_OPTION0;               /**< SMW SMP WHV Option 0 Register, offset: 0x410 */
  __IO uint32_t SMW_SME_WHV_OPTION0;               /**< SMW SME WHV Option 0 Register, offset: 0x414 */
  __IO uint32_t SMW_SETTING_OPTION1;               /**< SMW Setting Option 1 Register, offset: 0x418 */
  __IO uint32_t SMW_SMP_WHV_OPTION1;               /**< SMW SMP WHV Option 1 Register, offset: 0x41C */
  __IO uint32_t SMW_SME_WHV_OPTION1;               /**< SMW SME WHV Option 1 Register, offset: 0x420 */
       uint8_t RESERVED_13[220];
  __IO uint32_t REPAIR0_0;                         /**< FMU Repair 0 Block 0 Register, offset: 0x500 */
  __IO uint32_t REPAIR0_1;                         /**< FMU Repair 1 Block 0 Register, offset: 0x504 */
  __IO uint32_t REPAIR1_0;                         /**< FMU Repair 0 Block 1 Register, offset: 0x508 */
  __IO uint32_t REPAIR1_1;                         /**< FMU Repair 1 Block 1 Register, offset: 0x50C */
       uint8_t RESERVED_14[240];
  __IO uint32_t SMW_HB_SIGNALS;                    /**< SMW HB Signals Register, offset: 0x600 */
  __IO uint32_t BIST_DUMP_CTRL;                    /**< BIST Datadump Control Register, offset: 0x604 */
       uint8_t RESERVED_15[4];
  __IO uint32_t ATX_PIN_CTRL;                      /**< ATX Pin Control Register, offset: 0x60C */
  __IO uint32_t FAILCNT;                           /**< Fail Count Register, offset: 0x610 */
  __IO uint32_t PGM_PULSE_CNT0;                    /**< Block 0 Program Pulse Count Register, offset: 0x614 */
  __IO uint32_t PGM_PULSE_CNT1;                    /**< Block 1 Program Pulse Count Register, offset: 0x618 */
  __IO uint32_t ERS_PULSE_CNT;                     /**< Erase Pulse Count Register, offset: 0x61C */
  __IO uint32_t MAX_PULSE_CNT;                     /**< Maximum Pulse Count Register, offset: 0x620 */
  __IO uint32_t PORT_CTRL;                         /**< Port Control Register, offset: 0x624 */
} FMUTEST_Type;

/* ----------------------------------------------------------------------------
   -- FMUTEST Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMUTEST_Register_Masks FMUTEST Register Masks
 * @{
 */

/*! @name FSTAT - Flash Status Register */
/*! @{ */

#define FMUTEST_FSTAT_FAIL_MASK                  (0x1U)
#define FMUTEST_FSTAT_FAIL_SHIFT                 (0U)
/*! FAIL - Command Fail Flag
 *  0b0..Error not detected
 *  0b1..Error detected
 */
#define FMUTEST_FSTAT_FAIL(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_FAIL_SHIFT)) & FMUTEST_FSTAT_FAIL_MASK)

#define FMUTEST_FSTAT_CMDABT_MASK                (0x4U)
#define FMUTEST_FSTAT_CMDABT_SHIFT               (2U)
/*! CMDABT - Command Abort Flag
 *  0b0..No command abort detected
 *  0b1..Command abort detected
 */
#define FMUTEST_FSTAT_CMDABT(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CMDABT_SHIFT)) & FMUTEST_FSTAT_CMDABT_MASK)

#define FMUTEST_FSTAT_PVIOL_MASK                 (0x10U)
#define FMUTEST_FSTAT_PVIOL_SHIFT                (4U)
/*! PVIOL - Command Protection Violation Flag
 *  0b0..No protection violation detected
 *  0b1..Protection violation detected
 */
#define FMUTEST_FSTAT_PVIOL(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_PVIOL_SHIFT)) & FMUTEST_FSTAT_PVIOL_MASK)

#define FMUTEST_FSTAT_ACCERR_MASK                (0x20U)
#define FMUTEST_FSTAT_ACCERR_SHIFT               (5U)
/*! ACCERR - Command Access Error Flag
 *  0b0..No access error detected
 *  0b1..Access error detected
 */
#define FMUTEST_FSTAT_ACCERR(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_ACCERR_SHIFT)) & FMUTEST_FSTAT_ACCERR_MASK)

#define FMUTEST_FSTAT_CWSABT_MASK                (0x40U)
#define FMUTEST_FSTAT_CWSABT_SHIFT               (6U)
/*! CWSABT - Command Write Sequence Abort Flag
 *  0b0..Command write sequence not aborted
 *  0b1..Command write sequence aborted
 */
#define FMUTEST_FSTAT_CWSABT(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CWSABT_SHIFT)) & FMUTEST_FSTAT_CWSABT_MASK)

#define FMUTEST_FSTAT_CCIF_MASK                  (0x80U)
#define FMUTEST_FSTAT_CCIF_SHIFT                 (7U)
/*! CCIF - Command Complete Interrupt Flag
 *  0b0..Flash command or initialization in progress
 *  0b1..Flash command or initialization has completed
 */
#define FMUTEST_FSTAT_CCIF(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CCIF_SHIFT)) & FMUTEST_FSTAT_CCIF_MASK)

#define FMUTEST_FSTAT_CMDPRT_MASK                (0x300U)
#define FMUTEST_FSTAT_CMDPRT_SHIFT               (8U)
/*! CMDPRT - Command Protection Level
 *  0b00..Secure, normal access
 *  0b01..Secure, privileged access
 *  0b10..Nonsecure, normal access
 *  0b11..Nonsecure, privileged access
 */
#define FMUTEST_FSTAT_CMDPRT(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CMDPRT_SHIFT)) & FMUTEST_FSTAT_CMDPRT_MASK)

#define FMUTEST_FSTAT_CMDP_MASK                  (0x800U)
#define FMUTEST_FSTAT_CMDP_SHIFT                 (11U)
/*! CMDP - Command Protection Status Flag
 *  0b0..Command protection level and domain ID are stale
 *  0b1..Command protection level (CMDPRT) and domain ID (CMDDID) are set
 */
#define FMUTEST_FSTAT_CMDP(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CMDP_SHIFT)) & FMUTEST_FSTAT_CMDP_MASK)

#define FMUTEST_FSTAT_CMDDID_MASK                (0xF000U)
#define FMUTEST_FSTAT_CMDDID_SHIFT               (12U)
/*! CMDDID - Command Domain ID */
#define FMUTEST_FSTAT_CMDDID(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CMDDID_SHIFT)) & FMUTEST_FSTAT_CMDDID_MASK)

#define FMUTEST_FSTAT_DFDIF_MASK                 (0x10000U)
#define FMUTEST_FSTAT_DFDIF_SHIFT                (16U)
/*! DFDIF - Double Bit Fault Detect Interrupt Flag
 *  0b0..Double bit fault not detected during a valid flash read access from the FMC
 *  0b1..Double bit fault detected (or FCTRL[FDFD] is set) during a valid flash read access from the FMC
 */
#define FMUTEST_FSTAT_DFDIF(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_DFDIF_SHIFT)) & FMUTEST_FSTAT_DFDIF_MASK)

#define FMUTEST_FSTAT_SALV_USED_MASK             (0x20000U)
#define FMUTEST_FSTAT_SALV_USED_SHIFT            (17U)
/*! SALV_USED - Salvage Used for Erase operation
 *  0b0..Salvage not used during the last operation
 *  0b1..Salvage used during the last erase operation
 */
#define FMUTEST_FSTAT_SALV_USED(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_SALV_USED_SHIFT)) & FMUTEST_FSTAT_SALV_USED_MASK)

#define FMUTEST_FSTAT_PEWEN_MASK                 (0x3000000U)
#define FMUTEST_FSTAT_PEWEN_SHIFT                (24U)
/*! PEWEN - Program-Erase Write Enable Control
 *  0b00..Writes are not enabled
 *  0b01..Writes are enabled for one flash or IFR phrase (phrase programming, sector erase)
 *  0b10..Writes are enabled for one flash or IFR page (page programming)
 *  0b11..Reserved
 */
#define FMUTEST_FSTAT_PEWEN(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_PEWEN_SHIFT)) & FMUTEST_FSTAT_PEWEN_MASK)

#define FMUTEST_FSTAT_PERDY_MASK                 (0x80000000U)
#define FMUTEST_FSTAT_PERDY_SHIFT                (31U)
/*! PERDY - Program/Erase Ready Control/Status Flag
 *  0b0..Program or sector erase command operation is not stalled
 *  0b1..Program or sector erase command operation is stalled
 */
#define FMUTEST_FSTAT_PERDY(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_PERDY_SHIFT)) & FMUTEST_FSTAT_PERDY_MASK)
/*! @} */

/*! @name FCNFG - Flash Configuration Register */
/*! @{ */

#define FMUTEST_FCNFG_CCIE_MASK                  (0x80U)
#define FMUTEST_FCNFG_CCIE_SHIFT                 (7U)
/*! CCIE - Command Complete Interrupt Enable
 *  0b0..Command complete interrupt disabled
 *  0b1..Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.
 */
#define FMUTEST_FCNFG_CCIE(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_CCIE_SHIFT)) & FMUTEST_FCNFG_CCIE_MASK)

#define FMUTEST_FCNFG_ERSREQ_MASK                (0x100U)
#define FMUTEST_FCNFG_ERSREQ_SHIFT               (8U)
/*! ERSREQ - Mass Erase (Erase All) Request
 *  0b0..No request or request complete
 *  0b1..Request to run the Mass Erase operation
 */
#define FMUTEST_FCNFG_ERSREQ(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_ERSREQ_SHIFT)) & FMUTEST_FCNFG_ERSREQ_MASK)

#define FMUTEST_FCNFG_DFDIE_MASK                 (0x10000U)
#define FMUTEST_FCNFG_DFDIE_SHIFT                (16U)
/*! DFDIE - Double Bit Fault Detect Interrupt Enable
 *  0b0..Double bit fault detect interrupt disabled
 *  0b1..Double bit fault detect interrupt enabled; an interrupt request is generated whenever the FSTAT[DFDIF] flag is set
 */
#define FMUTEST_FCNFG_DFDIE(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_DFDIE_SHIFT)) & FMUTEST_FCNFG_DFDIE_MASK)

#define FMUTEST_FCNFG_ERSIEN0_MASK               (0xF000000U)
#define FMUTEST_FCNFG_ERSIEN0_SHIFT              (24U)
/*! ERSIEN0 - Erase IFR Sector Enable - Block 0
 *  0b0000..Block 0 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 0 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMUTEST_FCNFG_ERSIEN0(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_ERSIEN0_SHIFT)) & FMUTEST_FCNFG_ERSIEN0_MASK)

#define FMUTEST_FCNFG_ERSIEN1_MASK               (0xF0000000U)
#define FMUTEST_FCNFG_ERSIEN1_SHIFT              (28U)
/*! ERSIEN1 - Erase IFR Sector Enable - Block 1 (for dual block configs)
 *  0b0000..Block 1 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 1 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMUTEST_FCNFG_ERSIEN1(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_ERSIEN1_SHIFT)) & FMUTEST_FCNFG_ERSIEN1_MASK)
/*! @} */

/*! @name FCTRL - Flash Control Register */
/*! @{ */

#define FMUTEST_FCTRL_RWSC_MASK                  (0xFU)
#define FMUTEST_FCTRL_RWSC_SHIFT                 (0U)
/*! RWSC - Read Wait-State Control
 *  0b0000..no additional wait-states are added (single cycle access)
 *  0b0001..1 additional wait-state is added
 *  0b0010..2 additional wait-states are added
 *  0b0011..3 additional wait-states are added
 *  0b0100..4 additional wait-states are added
 *  0b0101..5 additional wait-states are added
 *  0b0110..6 additional wait-states are added
 *  0b0111..7 additional wait-states are added
 *  0b1000..8 additional wait-states are added
 *  0b1001..9 additional wait-states are added
 *  0b1010..10 additional wait-states are added
 *  0b1011..11 additional wait-states are added
 *  0b1100..12 additional wait-states are added
 *  0b1101..13 additional wait-states are added
 *  0b1110..14 additional wait-states are added
 *  0b1111..15 additional wait-states are added
 */
#define FMUTEST_FCTRL_RWSC(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCTRL_RWSC_SHIFT)) & FMUTEST_FCTRL_RWSC_MASK)

#define FMUTEST_FCTRL_LSACTIVE_MASK              (0x100U)
#define FMUTEST_FCTRL_LSACTIVE_SHIFT             (8U)
/*! LSACTIVE - Low Speed Active Mode
 *  0b0..Full speed active mode requested
 *  0b1..Low speed active mode requested
 */
#define FMUTEST_FCTRL_LSACTIVE(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCTRL_LSACTIVE_SHIFT)) & FMUTEST_FCTRL_LSACTIVE_MASK)

#define FMUTEST_FCTRL_FDFD_MASK                  (0x10000U)
#define FMUTEST_FCTRL_FDFD_SHIFT                 (16U)
/*! FDFD - Force Double Bit Fault Detect
 *  0b0..FSTAT[DFDIF] sets only if a double bit fault is detected during a valid flash read access from the FMC
 *  0b1..FSTAT[DFDIF] sets during any valid flash read access from the FMC; an interrupt request is generated if the DFDIE bit is set
 */
#define FMUTEST_FCTRL_FDFD(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCTRL_FDFD_SHIFT)) & FMUTEST_FCTRL_FDFD_MASK)

#define FMUTEST_FCTRL_ABTREQ_MASK                (0x1000000U)
#define FMUTEST_FCTRL_ABTREQ_SHIFT               (24U)
/*! ABTREQ - Abort Request
 *  0b0..No request to abort a command write sequence
 *  0b1..Request to abort a command write sequence
 */
#define FMUTEST_FCTRL_ABTREQ(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCTRL_ABTREQ_SHIFT)) & FMUTEST_FCTRL_ABTREQ_MASK)
/*! @} */

/*! @name FTEST - Flash Test Register */
/*! @{ */

#define FMUTEST_FTEST_TMECTL_MASK                (0x1U)
#define FMUTEST_FTEST_TMECTL_SHIFT               (0U)
/*! TMECTL - Test Mode Entry Control
 *  0b0..FTEST register always reads 0 and writes to FTEST are ignored
 *  0b1..FTEST register is readable and can be written to enable writability of TME
 */
#define FMUTEST_FTEST_TMECTL(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TMECTL_SHIFT)) & FMUTEST_FTEST_TMECTL_MASK)

#define FMUTEST_FTEST_TMEWR_MASK                 (0x2U)
#define FMUTEST_FTEST_TMEWR_SHIFT                (1U)
/*! TMEWR - Test Mode Entry Writable
 *  0b0..TME bit is not writable
 *  0b1..TME bit is writable
 */
#define FMUTEST_FTEST_TMEWR(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TMEWR_SHIFT)) & FMUTEST_FTEST_TMEWR_MASK)

#define FMUTEST_FTEST_TME_MASK                   (0x4U)
#define FMUTEST_FTEST_TME_SHIFT                  (2U)
/*! TME - Test Mode Entry
 *  0b0..Test mode entry not requested
 *  0b1..Test mode entry requested
 */
#define FMUTEST_FTEST_TME(x)                     (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TME_SHIFT)) & FMUTEST_FTEST_TME_MASK)

#define FMUTEST_FTEST_TMODE_MASK                 (0x8U)
#define FMUTEST_FTEST_TMODE_SHIFT                (3U)
/*! TMODE - Test Mode Status
 *  0b0..Test mode not active
 *  0b1..Test mode active
 */
#define FMUTEST_FTEST_TMODE(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TMODE_SHIFT)) & FMUTEST_FTEST_TMODE_MASK)

#define FMUTEST_FTEST_TMELOCK_MASK               (0x10U)
#define FMUTEST_FTEST_TMELOCK_SHIFT              (4U)
/*! TMELOCK - Test Mode Entry Lock
 *  0b0..FTEST register not locked from accepting writes
 *  0b1..FTEST register locked from accepting writes
 */
#define FMUTEST_FTEST_TMELOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TMELOCK_SHIFT)) & FMUTEST_FTEST_TMELOCK_MASK)
/*! @} */

/*! @name FCCOB0 - Flash Command Control 0 Register */
/*! @{ */

#define FMUTEST_FCCOB0_CMDCODE_MASK              (0xFFU)
#define FMUTEST_FCCOB0_CMDCODE_SHIFT             (0U)
/*! CMDCODE - Command code */
#define FMUTEST_FCCOB0_CMDCODE(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB0_CMDCODE_SHIFT)) & FMUTEST_FCCOB0_CMDCODE_MASK)
/*! @} */

/*! @name FCCOB1 - Flash Command Control 1 Register */
/*! @{ */

#define FMUTEST_FCCOB1_CMDOPT_MASK               (0xFFU)
#define FMUTEST_FCCOB1_CMDOPT_SHIFT              (0U)
/*! CMDOPT - Command options */
#define FMUTEST_FCCOB1_CMDOPT(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB1_CMDOPT_SHIFT)) & FMUTEST_FCCOB1_CMDOPT_MASK)
/*! @} */

/*! @name FCCOB2 - Flash Command Control 2 Register */
/*! @{ */

#define FMUTEST_FCCOB2_CMDADDR_MASK              (0xFFFFFFFFU)
#define FMUTEST_FCCOB2_CMDADDR_SHIFT             (0U)
/*! CMDADDR - Command starting address */
#define FMUTEST_FCCOB2_CMDADDR(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB2_CMDADDR_SHIFT)) & FMUTEST_FCCOB2_CMDADDR_MASK)
/*! @} */

/*! @name FCCOB3 - Flash Command Control 3 Register */
/*! @{ */

#define FMUTEST_FCCOB3_CMDADDRE_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB3_CMDADDRE_SHIFT            (0U)
/*! CMDADDRE - Command ending address */
#define FMUTEST_FCCOB3_CMDADDRE(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB3_CMDADDRE_SHIFT)) & FMUTEST_FCCOB3_CMDADDRE_MASK)
/*! @} */

/*! @name FCCOB4 - Flash Command Control 4 Register */
/*! @{ */

#define FMUTEST_FCCOB4_CMDDATA0_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB4_CMDDATA0_SHIFT            (0U)
/*! CMDDATA0 - Command data word 0 */
#define FMUTEST_FCCOB4_CMDDATA0(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB4_CMDDATA0_SHIFT)) & FMUTEST_FCCOB4_CMDDATA0_MASK)
/*! @} */

/*! @name FCCOB5 - Flash Command Control 5 Register */
/*! @{ */

#define FMUTEST_FCCOB5_CMDDATA1_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB5_CMDDATA1_SHIFT            (0U)
/*! CMDDATA1 - Command data word 1 */
#define FMUTEST_FCCOB5_CMDDATA1(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB5_CMDDATA1_SHIFT)) & FMUTEST_FCCOB5_CMDDATA1_MASK)
/*! @} */

/*! @name FCCOB6 - Flash Command Control 6 Register */
/*! @{ */

#define FMUTEST_FCCOB6_CMDDATA2_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB6_CMDDATA2_SHIFT            (0U)
/*! CMDDATA2 - Command data word 2 */
#define FMUTEST_FCCOB6_CMDDATA2(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB6_CMDDATA2_SHIFT)) & FMUTEST_FCCOB6_CMDDATA2_MASK)
/*! @} */

/*! @name FCCOB7 - Flash Command Control 7 Register */
/*! @{ */

#define FMUTEST_FCCOB7_CMDDATA3_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB7_CMDDATA3_SHIFT            (0U)
/*! CMDDATA3 - Command data word 3 */
#define FMUTEST_FCCOB7_CMDDATA3(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB7_CMDDATA3_SHIFT)) & FMUTEST_FCCOB7_CMDDATA3_MASK)
/*! @} */

/*! @name RESET_STATUS - FMU Initialization Tracking Register */
/*! @{ */

#define FMUTEST_RESET_STATUS_ARY_TRIM_DONE_MASK  (0x1U)
#define FMUTEST_RESET_STATUS_ARY_TRIM_DONE_SHIFT (0U)
/*! ARY_TRIM_DONE - Array Trim Complete
 *  0b0..Recall register load operation has not been completed
 *  0b1..Recall register load operation has completed
 */
#define FMUTEST_RESET_STATUS_ARY_TRIM_DONE(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_ARY_TRIM_DONE_SHIFT)) & FMUTEST_RESET_STATUS_ARY_TRIM_DONE_MASK)

#define FMUTEST_RESET_STATUS_FMU_PARM_EN_MASK    (0x2U)
#define FMUTEST_RESET_STATUS_FMU_PARM_EN_SHIFT   (1U)
/*! FMU_PARM_EN - Status of the C0DE_C0DEh check to enable loading of the FMU parameters
 *  0b0..C0DE_C0DEh check not attempted
 *  0b1..C0DE_C0DEh check completed
 */
#define FMUTEST_RESET_STATUS_FMU_PARM_EN(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_FMU_PARM_EN_SHIFT)) & FMUTEST_RESET_STATUS_FMU_PARM_EN_MASK)

#define FMUTEST_RESET_STATUS_FMU_PARM_DONE_MASK  (0x4U)
#define FMUTEST_RESET_STATUS_FMU_PARM_DONE_SHIFT (2U)
/*! FMU_PARM_DONE - FMU Register Load Complete
 *  0b0..FMU registers have not been loaded
 *  0b1..FMU registers have been loaded
 */
#define FMUTEST_RESET_STATUS_FMU_PARM_DONE(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_FMU_PARM_DONE_SHIFT)) & FMUTEST_RESET_STATUS_FMU_PARM_DONE_MASK)

#define FMUTEST_RESET_STATUS_SOC_TRIM_EN_MASK    (0x8U)
#define FMUTEST_RESET_STATUS_SOC_TRIM_EN_SHIFT   (3U)
/*! SOC_TRIM_EN - Status of the C0DE_C0DEh check to enable loading of the SoC trim settings
 *  0b0..C0DE_C0DEh check not attempted
 *  0b1..C0DE_C0DEh check completed
 */
#define FMUTEST_RESET_STATUS_SOC_TRIM_EN(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_SOC_TRIM_EN_SHIFT)) & FMUTEST_RESET_STATUS_SOC_TRIM_EN_MASK)

#define FMUTEST_RESET_STATUS_SOC_TRIM_ECC_MASK   (0x10U)
#define FMUTEST_RESET_STATUS_SOC_TRIM_ECC_SHIFT  (4U)
/*! SOC_TRIM_ECC - Status of the C0DE_C0DEh check for enabling ECC decoder during reads of SoC trim settings
 *  0b0..C0DE_C0DEh check failed
 *  0b1..C0DE_C0DEh check passed
 */
#define FMUTEST_RESET_STATUS_SOC_TRIM_ECC(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_SOC_TRIM_ECC_SHIFT)) & FMUTEST_RESET_STATUS_SOC_TRIM_ECC_MASK)

#define FMUTEST_RESET_STATUS_SOC_TRIM_DONE_MASK  (0x20U)
#define FMUTEST_RESET_STATUS_SOC_TRIM_DONE_SHIFT (5U)
/*! SOC_TRIM_DONE - SoC Trim Complete
 *  0b0..SoC Trim registers have not been updated
 *  0b1..All SoC Trim registers have been updated
 */
#define FMUTEST_RESET_STATUS_SOC_TRIM_DONE(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_SOC_TRIM_DONE_SHIFT)) & FMUTEST_RESET_STATUS_SOC_TRIM_DONE_MASK)

#define FMUTEST_RESET_STATUS_RPR_DONE_MASK       (0x40U)
#define FMUTEST_RESET_STATUS_RPR_DONE_SHIFT      (6U)
/*! RPR_DONE - Array Repair Complete
 *  0b0..Repair registers have not been loaded
 *  0b1..Repair registers have been loaded
 */
#define FMUTEST_RESET_STATUS_RPR_DONE(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RPR_DONE_SHIFT)) & FMUTEST_RESET_STATUS_RPR_DONE_MASK)

#define FMUTEST_RESET_STATUS_INIT_DONE_MASK      (0x80U)
#define FMUTEST_RESET_STATUS_INIT_DONE_SHIFT     (7U)
/*! INIT_DONE - Initialization Done
 *  0b0..All initialization steps did not complete
 *  0b1..All initialization steps completed
 */
#define FMUTEST_RESET_STATUS_INIT_DONE(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_INIT_DONE_SHIFT)) & FMUTEST_RESET_STATUS_INIT_DONE_MASK)

#define FMUTEST_RESET_STATUS_RST_SF_ERR_MASK     (0x100U)
#define FMUTEST_RESET_STATUS_RST_SF_ERR_SHIFT    (8U)
/*! RST_SF_ERR - ECC Single Fault during Reset Recovery
 *  0b0..No single-bit faults detected during initialization
 *  0b1..At least one single ECC fault was detected during initialization
 */
#define FMUTEST_RESET_STATUS_RST_SF_ERR(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RST_SF_ERR_SHIFT)) & FMUTEST_RESET_STATUS_RST_SF_ERR_MASK)

#define FMUTEST_RESET_STATUS_RST_DF_ERR_MASK     (0x200U)
#define FMUTEST_RESET_STATUS_RST_DF_ERR_SHIFT    (9U)
/*! RST_DF_ERR - ECC Double Fault during Reset Recovery
 *  0b0..No double-bit faults detected during initialization
 *  0b1..Double-bit ECC fault was detected during initialization
 */
#define FMUTEST_RESET_STATUS_RST_DF_ERR(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RST_DF_ERR_SHIFT)) & FMUTEST_RESET_STATUS_RST_DF_ERR_MASK)

#define FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR_MASK (0x3FC00U)
#define FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR_SHIFT (10U)
/*! SOC_TRIM_DF_ERR - ECC Double Fault during load of SoC Trim phrases */
#define FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR_SHIFT)) & FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR_MASK)

#define FMUTEST_RESET_STATUS_RST_PATCH_LD_MASK   (0x40000U)
#define FMUTEST_RESET_STATUS_RST_PATCH_LD_SHIFT  (18U)
/*! RST_PATCH_LD - Reset Patch Required
 *  0b0..No patch required to be loaded during reset
 *  0b1..Patch loaded during reset
 */
#define FMUTEST_RESET_STATUS_RST_PATCH_LD(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RST_PATCH_LD_SHIFT)) & FMUTEST_RESET_STATUS_RST_PATCH_LD_MASK)

#define FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH_MASK (0x80000U)
#define FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH_SHIFT (19U)
/*! RECALL_DATA_MISMATCH - Recall Data Mismatch
 *  0b0..Data read towards end of reset matched data read for Recall
 *  0b1..Data read towards end of reset did not match data read for recall
 */
#define FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH_SHIFT)) & FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH_MASK)
/*! @} */

/*! @name MCTL - FMU Control Register */
/*! @{ */

#define FMUTEST_MCTL_COREHLD_MASK                (0x1U)
#define FMUTEST_MCTL_COREHLD_SHIFT               (0U)
/*! COREHLD - Core Hold
 *  0b0..CPU access is allowed
 *  0b1..CPU access must be blocked
 */
#define FMUTEST_MCTL_COREHLD(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_COREHLD_SHIFT)) & FMUTEST_MCTL_COREHLD_MASK)

#define FMUTEST_MCTL_LSACT_EN_MASK               (0x4U)
#define FMUTEST_MCTL_LSACT_EN_SHIFT              (2U)
/*! LSACT_EN - LSACTIVE Feature Enable
 *  0b0..LSACTIVE feature disabled completely: FCTRL[LSACTIVE] is forced low and no longer writable, LVE cannot assert at the TSMC array interface.
 *  0b1..LSACTIVE feature fully enabled and controllable by SoC and internal UINT SM.
 */
#define FMUTEST_MCTL_LSACT_EN(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_LSACT_EN_SHIFT)) & FMUTEST_MCTL_LSACT_EN_MASK)

#define FMUTEST_MCTL_LSACTWREN_MASK              (0x8U)
#define FMUTEST_MCTL_LSACTWREN_SHIFT             (3U)
/*! LSACTWREN - LSACTIVE Write Enable
 *  0b0..Unrestricted write access allowed
 *  0b1..Write access while CMP set must match CMDDID and CMDPRT
 */
#define FMUTEST_MCTL_LSACTWREN(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_LSACTWREN_SHIFT)) & FMUTEST_MCTL_LSACTWREN_MASK)

#define FMUTEST_MCTL_MASTER_REPAIR_EN_MASK       (0x10U)
#define FMUTEST_MCTL_MASTER_REPAIR_EN_SHIFT      (4U)
/*! MASTER_REPAIR_EN - Master Repair Enable
 *  0b0..Repair disabled
 *  0b1..Repair enable determined by bit 0 of each REPAIR register
 */
#define FMUTEST_MCTL_MASTER_REPAIR_EN(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_MASTER_REPAIR_EN_SHIFT)) & FMUTEST_MCTL_MASTER_REPAIR_EN_MASK)

#define FMUTEST_MCTL_RFCMDEN_MASK                (0x20U)
#define FMUTEST_MCTL_RFCMDEN_SHIFT               (5U)
/*! RFCMDEN - RF Active Command Enable Control
 *  0b0..Flash commands blocked (CCIF not writable)
 *  0b1..Flash commands allowed
 */
#define FMUTEST_MCTL_RFCMDEN(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_RFCMDEN_SHIFT)) & FMUTEST_MCTL_RFCMDEN_MASK)

#define FMUTEST_MCTL_CWSABTEN_MASK               (0x40U)
#define FMUTEST_MCTL_CWSABTEN_SHIFT              (6U)
/*! CWSABTEN - Command Write Sequence Abort Enable
 *  0b0..CWS abort feature is disabled
 *  0b1..CWS abort feature is enabled
 */
#define FMUTEST_MCTL_CWSABTEN(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_CWSABTEN_SHIFT)) & FMUTEST_MCTL_CWSABTEN_MASK)

#define FMUTEST_MCTL_MRGRDDIS_MASK               (0x80U)
#define FMUTEST_MCTL_MRGRDDIS_SHIFT              (7U)
/*! MRGRDDIS - Margin Read Disable
 *  0b0..Margin Read Settings are enabled
 *  0b1..Margin Read Settings are disabled
 */
#define FMUTEST_MCTL_MRGRDDIS(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_MRGRDDIS_SHIFT)) & FMUTEST_MCTL_MRGRDDIS_MASK)

#define FMUTEST_MCTL_MRGRD0_MASK                 (0xF00U)
#define FMUTEST_MCTL_MRGRD0_SHIFT                (8U)
/*! MRGRD0 - Margin Read Setting for Program */
#define FMUTEST_MCTL_MRGRD0(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_MRGRD0_SHIFT)) & FMUTEST_MCTL_MRGRD0_MASK)

#define FMUTEST_MCTL_MRGRD1_MASK                 (0xF000U)
#define FMUTEST_MCTL_MRGRD1_SHIFT                (12U)
/*! MRGRD1 - Margin Read Setting for Erase */
#define FMUTEST_MCTL_MRGRD1(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_MRGRD1_SHIFT)) & FMUTEST_MCTL_MRGRD1_MASK)

#define FMUTEST_MCTL_ERSAACK_MASK                (0x10000U)
#define FMUTEST_MCTL_ERSAACK_SHIFT               (16U)
/*! ERSAACK - Mass Erase (Erase All) Acknowledge
 *  0b0..Mass Erase operation is not active (operation has completed or has not started)
 *  0b1..Mass Erase operation is active (controller acknowledges that the soc_ersall_req input is asserted and will continue with the operation)
 */
#define FMUTEST_MCTL_ERSAACK(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_ERSAACK_SHIFT)) & FMUTEST_MCTL_ERSAACK_MASK)

#define FMUTEST_MCTL_SCAN_OBS_MASK               (0x80000U)
#define FMUTEST_MCTL_SCAN_OBS_SHIFT              (19U)
/*! SCAN_OBS - Scan Observability Control
 *  0b0..Normal functional behavior
 *  0b1..Enables observation of signals that may otherwise be ATPG untestable
 */
#define FMUTEST_MCTL_SCAN_OBS(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_SCAN_OBS_SHIFT)) & FMUTEST_MCTL_SCAN_OBS_MASK)

#define FMUTEST_MCTL_BIST_CTL_MASK               (0x100000U)
#define FMUTEST_MCTL_BIST_CTL_SHIFT              (20U)
/*! BIST_CTL - BIST IP Control
 *  0b0..BIST IP disabled
 *  0b1..BIST IP enabled
 */
#define FMUTEST_MCTL_BIST_CTL(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_BIST_CTL_SHIFT)) & FMUTEST_MCTL_BIST_CTL_MASK)

#define FMUTEST_MCTL_SMWR_CTL_MASK               (0x200000U)
#define FMUTEST_MCTL_SMWR_CTL_SHIFT              (21U)
/*! SMWR_CTL - SMWR IP Control
 *  0b0..SMWR IP disabled
 *  0b1..SMWR IP enabled
 */
#define FMUTEST_MCTL_SMWR_CTL(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_SMWR_CTL_SHIFT)) & FMUTEST_MCTL_SMWR_CTL_MASK)

#define FMUTEST_MCTL_SALV_DIS_MASK               (0x1000000U)
#define FMUTEST_MCTL_SALV_DIS_SHIFT              (24U)
/*! SALV_DIS - Salvage Disable
 *  0b0..Salvage enabled (ECC used during erase verify)
 *  0b1..Salvage disabled (ECC not used during erase verify)
 */
#define FMUTEST_MCTL_SALV_DIS(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_SALV_DIS_SHIFT)) & FMUTEST_MCTL_SALV_DIS_MASK)

#define FMUTEST_MCTL_SOC_ECC_CTL_MASK            (0x2000000U)
#define FMUTEST_MCTL_SOC_ECC_CTL_SHIFT           (25U)
/*! SOC_ECC_CTL - SOC ECC Control
 *  0b0..ECC is enabled for SOC read access
 *  0b1..ECC is disabled for SOC read access
 */
#define FMUTEST_MCTL_SOC_ECC_CTL(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_SOC_ECC_CTL_SHIFT)) & FMUTEST_MCTL_SOC_ECC_CTL_MASK)

#define FMUTEST_MCTL_FMU_ECC_CTL_MASK            (0x4000000U)
#define FMUTEST_MCTL_FMU_ECC_CTL_SHIFT           (26U)
/*! FMU_ECC_CTL - FMU ECC Control
 *  0b0..ECC is enabled for FMU program operations
 *  0b1..ECC is disabled for FMU program operations
 */
#define FMUTEST_MCTL_FMU_ECC_CTL(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_FMU_ECC_CTL_SHIFT)) & FMUTEST_MCTL_FMU_ECC_CTL_MASK)

#define FMUTEST_MCTL_BIST_PWR_DIS_MASK           (0x20000000U)
#define FMUTEST_MCTL_BIST_PWR_DIS_SHIFT          (29U)
/*! BIST_PWR_DIS - BIST Power Mode Disable
 *  0b0..BIST DFT logic has full control of SLM and LVE when BIST is enabled (including during commands)
 *  0b1..BIST DFT logic has no control of SLM and LVE; power mode RTL is in complete control of SLM and LVE values
 */
#define FMUTEST_MCTL_BIST_PWR_DIS(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_BIST_PWR_DIS_SHIFT)) & FMUTEST_MCTL_BIST_PWR_DIS_MASK)

#define FMUTEST_MCTL_OSC_H_MASK                  (0x80000000U)
#define FMUTEST_MCTL_OSC_H_SHIFT                 (31U)
/*! OSC_H - Oscillator control
 *  0b0..Use APB clock
 *  0b1..Use a known fixed-frequency clock, e.g. 12 MHz
 */
#define FMUTEST_MCTL_OSC_H(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_OSC_H_SHIFT)) & FMUTEST_MCTL_OSC_H_MASK)
/*! @} */

/*! @name BSEL_GEN - FMU Block Select Generation Register */
/*! @{ */

#define FMUTEST_BSEL_GEN_SBSEL_GEN_MASK          (0x3U)
#define FMUTEST_BSEL_GEN_SBSEL_GEN_SHIFT         (0U)
/*! SBSEL_GEN - Generated SBSEL */
#define FMUTEST_BSEL_GEN_SBSEL_GEN(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_BSEL_GEN_SBSEL_GEN_SHIFT)) & FMUTEST_BSEL_GEN_SBSEL_GEN_MASK)

#define FMUTEST_BSEL_GEN_MBSEL_GEN_MASK          (0x300U)
#define FMUTEST_BSEL_GEN_MBSEL_GEN_SHIFT         (8U)
/*! MBSEL_GEN - Generated MBSEL */
#define FMUTEST_BSEL_GEN_MBSEL_GEN(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_BSEL_GEN_MBSEL_GEN_SHIFT)) & FMUTEST_BSEL_GEN_MBSEL_GEN_MASK)
/*! @} */

/*! @name PWR_OPT - Power Mode Options Register */
/*! @{ */

#define FMUTEST_PWR_OPT_PD_CDIV_MASK             (0xFFU)
#define FMUTEST_PWR_OPT_PD_CDIV_SHIFT            (0U)
/*! PD_CDIV - Power Down Clock Divider Setting */
#define FMUTEST_PWR_OPT_PD_CDIV(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_PWR_OPT_PD_CDIV_SHIFT)) & FMUTEST_PWR_OPT_PD_CDIV_MASK)

#define FMUTEST_PWR_OPT_SLM_COUNT_MASK           (0x3FF0000U)
#define FMUTEST_PWR_OPT_SLM_COUNT_SHIFT          (16U)
/*! SLM_COUNT - Sleep Recovery Timer Count */
#define FMUTEST_PWR_OPT_SLM_COUNT(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_PWR_OPT_SLM_COUNT_SHIFT)) & FMUTEST_PWR_OPT_SLM_COUNT_MASK)

#define FMUTEST_PWR_OPT_PD_TIMER_EN_MASK         (0x80000000U)
#define FMUTEST_PWR_OPT_PD_TIMER_EN_SHIFT        (31U)
/*! PD_TIMER_EN - Power Down BIST Timer Enable
 *  0b0..BIST timer is not triggered during Power Down recovery
 *  0b1..BIST timer is triggered during Power Down recovery (default behavior)
 */
#define FMUTEST_PWR_OPT_PD_TIMER_EN(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_PWR_OPT_PD_TIMER_EN_SHIFT)) & FMUTEST_PWR_OPT_PD_TIMER_EN_MASK)
/*! @} */

/*! @name CMD_CHECK - FMU Command Check Register */
/*! @{ */

#define FMUTEST_CMD_CHECK_ALIGNFAIL_PHR_MASK     (0x1U)
#define FMUTEST_CMD_CHECK_ALIGNFAIL_PHR_SHIFT    (0U)
/*! ALIGNFAIL_PHR - Phrase Alignment Fail
 *  0b0..The address is phrase-aligned
 *  0b1..The address is not phrase-aligned
 */
#define FMUTEST_CMD_CHECK_ALIGNFAIL_PHR(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALIGNFAIL_PHR_SHIFT)) & FMUTEST_CMD_CHECK_ALIGNFAIL_PHR_MASK)

#define FMUTEST_CMD_CHECK_ALIGNFAIL_PG_MASK      (0x2U)
#define FMUTEST_CMD_CHECK_ALIGNFAIL_PG_SHIFT     (1U)
/*! ALIGNFAIL_PG - Page Alignment Fail
 *  0b0..The address is page-aligned
 *  0b1..The address is not page-aligned
 */
#define FMUTEST_CMD_CHECK_ALIGNFAIL_PG(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALIGNFAIL_PG_SHIFT)) & FMUTEST_CMD_CHECK_ALIGNFAIL_PG_MASK)

#define FMUTEST_CMD_CHECK_ALIGNFAIL_SCR_MASK     (0x4U)
#define FMUTEST_CMD_CHECK_ALIGNFAIL_SCR_SHIFT    (2U)
/*! ALIGNFAIL_SCR - Sector Alignment Fail
 *  0b0..The address is sector-aligned
 *  0b1..The address is not sector-aligned
 */
#define FMUTEST_CMD_CHECK_ALIGNFAIL_SCR(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALIGNFAIL_SCR_SHIFT)) & FMUTEST_CMD_CHECK_ALIGNFAIL_SCR_MASK)

#define FMUTEST_CMD_CHECK_ALIGNFAIL_BLK_MASK     (0x8U)
#define FMUTEST_CMD_CHECK_ALIGNFAIL_BLK_SHIFT    (3U)
/*! ALIGNFAIL_BLK - Block Alignment Fail
 *  0b0..The address is block-aligned
 *  0b1..The address is not block-aligned
 */
#define FMUTEST_CMD_CHECK_ALIGNFAIL_BLK(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALIGNFAIL_BLK_SHIFT)) & FMUTEST_CMD_CHECK_ALIGNFAIL_BLK_MASK)

#define FMUTEST_CMD_CHECK_ADDR_FAIL_MASK         (0x10U)
#define FMUTEST_CMD_CHECK_ADDR_FAIL_SHIFT        (4U)
/*! ADDR_FAIL - Address Fail
 *  0b0..The address is within the flash or IFR address space
 *  0b1..The address is outside the flash or IFR address space
 */
#define FMUTEST_CMD_CHECK_ADDR_FAIL(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ADDR_FAIL_SHIFT)) & FMUTEST_CMD_CHECK_ADDR_FAIL_MASK)

#define FMUTEST_CMD_CHECK_IFR_CMD_MASK           (0x20U)
#define FMUTEST_CMD_CHECK_IFR_CMD_SHIFT          (5U)
/*! IFR_CMD - IFR Command
 *  0b0..The command operates on a main flash address
 *  0b1..The command operates on an IFR address
 */
#define FMUTEST_CMD_CHECK_IFR_CMD(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_IFR_CMD_SHIFT)) & FMUTEST_CMD_CHECK_IFR_CMD_MASK)

#define FMUTEST_CMD_CHECK_ALL_CMD_MASK           (0x40U)
#define FMUTEST_CMD_CHECK_ALL_CMD_SHIFT          (6U)
/*! ALL_CMD - All Blocks Command
 *  0b0..The command operates on a single flash block
 *  0b1..The command operates on all flash blocks
 */
#define FMUTEST_CMD_CHECK_ALL_CMD(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALL_CMD_SHIFT)) & FMUTEST_CMD_CHECK_ALL_CMD_MASK)

#define FMUTEST_CMD_CHECK_RANGE_FAIL_MASK        (0x80U)
#define FMUTEST_CMD_CHECK_RANGE_FAIL_SHIFT       (7U)
/*! RANGE_FAIL - Address Range Fail
 *  0b0..The address range is valid
 *  0b1..The address range is invalid
 */
#define FMUTEST_CMD_CHECK_RANGE_FAIL(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_RANGE_FAIL_SHIFT)) & FMUTEST_CMD_CHECK_RANGE_FAIL_MASK)

#define FMUTEST_CMD_CHECK_SCR_ALIGN_CHK_MASK     (0x100U)
#define FMUTEST_CMD_CHECK_SCR_ALIGN_CHK_SHIFT    (8U)
/*! SCR_ALIGN_CHK - Sector Alignment Check
 *  0b0..No sector alignment check
 *  0b1..Sector alignment check
 */
#define FMUTEST_CMD_CHECK_SCR_ALIGN_CHK(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_SCR_ALIGN_CHK_SHIFT)) & FMUTEST_CMD_CHECK_SCR_ALIGN_CHK_MASK)

#define FMUTEST_CMD_CHECK_OPTION_FAIL_MASK       (0x200U)
#define FMUTEST_CMD_CHECK_OPTION_FAIL_SHIFT      (9U)
/*! OPTION_FAIL - Option Check Fail
 *  0b0..Option check passes for read command or command is not a read command
 *  0b1..Option check fails for read command
 */
#define FMUTEST_CMD_CHECK_OPTION_FAIL(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_OPTION_FAIL_SHIFT)) & FMUTEST_CMD_CHECK_OPTION_FAIL_MASK)

#define FMUTEST_CMD_CHECK_ILLEGAL_CMD_MASK       (0x400U)
#define FMUTEST_CMD_CHECK_ILLEGAL_CMD_SHIFT      (10U)
/*! ILLEGAL_CMD - Illegal Command
 *  0b0..Command is legal
 *  0b1..Command is illegal
 */
#define FMUTEST_CMD_CHECK_ILLEGAL_CMD(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ILLEGAL_CMD_SHIFT)) & FMUTEST_CMD_CHECK_ILLEGAL_CMD_MASK)
/*! @} */

/*! @name BSEL - FMU Block Select Register */
/*! @{ */

#define FMUTEST_BSEL_SBSEL_MASK                  (0x3U)
#define FMUTEST_BSEL_SBSEL_SHIFT                 (0U)
/*! SBSEL - Slave Block Select */
#define FMUTEST_BSEL_SBSEL(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_BSEL_SBSEL_SHIFT)) & FMUTEST_BSEL_SBSEL_MASK)

#define FMUTEST_BSEL_MBSEL_MASK                  (0x300U)
#define FMUTEST_BSEL_MBSEL_SHIFT                 (8U)
/*! MBSEL - Master Block Select */
#define FMUTEST_BSEL_MBSEL(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_BSEL_MBSEL_SHIFT)) & FMUTEST_BSEL_MBSEL_MASK)
/*! @} */

/*! @name MSIZE - FMU Memory Size Register */
/*! @{ */

#define FMUTEST_MSIZE_MAXADDR0_MASK              (0xFFU)
#define FMUTEST_MSIZE_MAXADDR0_SHIFT             (0U)
/*! MAXADDR0 - Size of Flash Block 0 */
#define FMUTEST_MSIZE_MAXADDR0(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_MSIZE_MAXADDR0_SHIFT)) & FMUTEST_MSIZE_MAXADDR0_MASK)
/*! @} */

/*! @name FLASH_RD_ADD - Flash Read Address Register */
/*! @{ */

#define FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD_MASK   (0xFFFFFFFFU)
#define FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD_SHIFT  (0U)
/*! FLASH_RD_ADD - Flash Read Address */
#define FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD_SHIFT)) & FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD_MASK)
/*! @} */

/*! @name FLASH_STOP_ADD - Flash Stop Address Register */
/*! @{ */

#define FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD_MASK (0xFFFFFFFFU)
#define FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD_SHIFT (0U)
/*! FLASH_STOP_ADD - Flash Stop Address */
#define FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD_SHIFT)) & FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD_MASK)
/*! @} */

/*! @name FLASH_RD_CTRL - Flash Read Control Register */
/*! @{ */

#define FMUTEST_FLASH_RD_CTRL_FLASH_RD_MASK      (0x1U)
#define FMUTEST_FLASH_RD_CTRL_FLASH_RD_SHIFT     (0U)
/*! FLASH_RD - Flash Read Enable
 *  0b0..Manual flash read not enabled.(default)
 *  0b1..Manual flash read enabled
 */
#define FMUTEST_FLASH_RD_CTRL_FLASH_RD(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_RD_CTRL_FLASH_RD_SHIFT)) & FMUTEST_FLASH_RD_CTRL_FLASH_RD_MASK)

#define FMUTEST_FLASH_RD_CTRL_WIDE_LOAD_MASK     (0x2U)
#define FMUTEST_FLASH_RD_CTRL_WIDE_LOAD_SHIFT    (1U)
/*! WIDE_LOAD - Wide Load Enable
 *  0b0..Wide load mode disabled (default)
 *  0b1..Wide load mode enabled
 */
#define FMUTEST_FLASH_RD_CTRL_WIDE_LOAD(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_RD_CTRL_WIDE_LOAD_SHIFT)) & FMUTEST_FLASH_RD_CTRL_WIDE_LOAD_MASK)

#define FMUTEST_FLASH_RD_CTRL_SINGLE_RD_MASK     (0x4U)
#define FMUTEST_FLASH_RD_CTRL_SINGLE_RD_SHIFT    (2U)
/*! SINGLE_RD - Single Flash Read
 *  0b0..Normal UINT operation
 *  0b1..UINT configured for single cycle reads
 */
#define FMUTEST_FLASH_RD_CTRL_SINGLE_RD(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_RD_CTRL_SINGLE_RD_SHIFT)) & FMUTEST_FLASH_RD_CTRL_SINGLE_RD_MASK)
/*! @} */

/*! @name MM_ADDR - Memory Map Address Register */
/*! @{ */

#define FMUTEST_MM_ADDR_MM_ADDR_MASK             (0xFFFFFFFFU)
#define FMUTEST_MM_ADDR_MM_ADDR_SHIFT            (0U)
/*! MM_ADDR - Memory Map Address */
#define FMUTEST_MM_ADDR_MM_ADDR(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_ADDR_MM_ADDR_SHIFT)) & FMUTEST_MM_ADDR_MM_ADDR_MASK)
/*! @} */

/*! @name MM_WDATA - Memory Map Write Data Register */
/*! @{ */

#define FMUTEST_MM_WDATA_MM_WDATA_MASK           (0xFFFFFFFFU)
#define FMUTEST_MM_WDATA_MM_WDATA_SHIFT          (0U)
/*! MM_WDATA - Memory Map Write Data */
#define FMUTEST_MM_WDATA_MM_WDATA(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_WDATA_MM_WDATA_SHIFT)) & FMUTEST_MM_WDATA_MM_WDATA_MASK)
/*! @} */

/*! @name MM_CTL - Memory Map Control Register */
/*! @{ */

#define FMUTEST_MM_CTL_MM_SEL_MASK               (0x1U)
#define FMUTEST_MM_CTL_MM_SEL_SHIFT              (0U)
/*! MM_SEL - Register Access Enable */
#define FMUTEST_MM_CTL_MM_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_CTL_MM_SEL_SHIFT)) & FMUTEST_MM_CTL_MM_SEL_MASK)

#define FMUTEST_MM_CTL_MM_RD_MASK                (0x2U)
#define FMUTEST_MM_CTL_MM_RD_SHIFT               (1U)
/*! MM_RD - Register R/W Control
 *  0b0..Write to register
 *  0b1..Read register
 */
#define FMUTEST_MM_CTL_MM_RD(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_CTL_MM_RD_SHIFT)) & FMUTEST_MM_CTL_MM_RD_MASK)

#define FMUTEST_MM_CTL_BIST_ON_MASK              (0x4U)
#define FMUTEST_MM_CTL_BIST_ON_SHIFT             (2U)
/*! BIST_ON - BIST on
 *  0b0..BIST enable not forced by user interface
 *  0b1..BIST enable control by user interface
 */
#define FMUTEST_MM_CTL_BIST_ON(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_CTL_BIST_ON_SHIFT)) & FMUTEST_MM_CTL_BIST_ON_MASK)

#define FMUTEST_MM_CTL_FORCE_SW_CLK_MASK         (0x8U)
#define FMUTEST_MM_CTL_FORCE_SW_CLK_SHIFT        (3U)
/*! FORCE_SW_CLK - Force Switch Clock
 *  0b0..Switch clock not forced on (gated normally)
 *  0b1..Switch clock forced on
 */
#define FMUTEST_MM_CTL_FORCE_SW_CLK(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_CTL_FORCE_SW_CLK_SHIFT)) & FMUTEST_MM_CTL_FORCE_SW_CLK_MASK)
/*! @} */

/*! @name UINT_CTL - User Interface Control Register */
/*! @{ */

#define FMUTEST_UINT_CTL_SET_FAIL_MASK           (0x1U)
#define FMUTEST_UINT_CTL_SET_FAIL_SHIFT          (0U)
/*! SET_FAIL - Set Fail On Exit
 *  0b0..FAIL flag should not be set on command exit (no failure detected)
 *  0b1..FAIL flag should be set on command exit
 */
#define FMUTEST_UINT_CTL_SET_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_UINT_CTL_SET_FAIL_SHIFT)) & FMUTEST_UINT_CTL_SET_FAIL_MASK)

#define FMUTEST_UINT_CTL_DBERR_MASK              (0x2U)
#define FMUTEST_UINT_CTL_DBERR_SHIFT             (1U)
/*! DBERR - Double-Bit ECC Fault Detect
 *  0b0..No double-bit fault detected during UINT-driven read sequence
 *  0b1..Double-bit fault detected during UINT-driven read sequence
 */
#define FMUTEST_UINT_CTL_DBERR(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_UINT_CTL_DBERR_SHIFT)) & FMUTEST_UINT_CTL_DBERR_MASK)
/*! @} */

/*! @name RD_DATA0 - Read Data 0 Register */
/*! @{ */

#define FMUTEST_RD_DATA0_RD_DATA0_MASK           (0xFFFFFFFFU)
#define FMUTEST_RD_DATA0_RD_DATA0_SHIFT          (0U)
/*! RD_DATA0 - Read Data 0 */
#define FMUTEST_RD_DATA0_RD_DATA0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_DATA0_RD_DATA0_SHIFT)) & FMUTEST_RD_DATA0_RD_DATA0_MASK)
/*! @} */

/*! @name RD_DATA1 - Read Data 1 Register */
/*! @{ */

#define FMUTEST_RD_DATA1_RD_DATA1_MASK           (0xFFFFFFFFU)
#define FMUTEST_RD_DATA1_RD_DATA1_SHIFT          (0U)
/*! RD_DATA1 - Read Data 1 */
#define FMUTEST_RD_DATA1_RD_DATA1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_DATA1_RD_DATA1_SHIFT)) & FMUTEST_RD_DATA1_RD_DATA1_MASK)
/*! @} */

/*! @name RD_DATA2 - Read Data 2 Register */
/*! @{ */

#define FMUTEST_RD_DATA2_RD_DATA2_MASK           (0xFFFFFFFFU)
#define FMUTEST_RD_DATA2_RD_DATA2_SHIFT          (0U)
/*! RD_DATA2 - Read Data 2 */
#define FMUTEST_RD_DATA2_RD_DATA2(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_DATA2_RD_DATA2_SHIFT)) & FMUTEST_RD_DATA2_RD_DATA2_MASK)
/*! @} */

/*! @name RD_DATA3 - Read Data 3 Register */
/*! @{ */

#define FMUTEST_RD_DATA3_RD_DATA3_MASK           (0xFFFFFFFFU)
#define FMUTEST_RD_DATA3_RD_DATA3_SHIFT          (0U)
/*! RD_DATA3 - Read Data 3 */
#define FMUTEST_RD_DATA3_RD_DATA3(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_DATA3_RD_DATA3_SHIFT)) & FMUTEST_RD_DATA3_RD_DATA3_MASK)
/*! @} */

/*! @name PARITY - Parity Register */
/*! @{ */

#define FMUTEST_PARITY_PARITY_MASK               (0x1FFU)
#define FMUTEST_PARITY_PARITY_SHIFT              (0U)
/*! PARITY - Read data [136:128] */
#define FMUTEST_PARITY_PARITY(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_PARITY_PARITY_SHIFT)) & FMUTEST_PARITY_PARITY_MASK)
/*! @} */

/*! @name RD_PATH_CTRL_STATUS - Read Path Control and Status Register */
/*! @{ */

#define FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT_MASK (0xFFU)
#define FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT_SHIFT (0U)
/*! RD_CAPT - Read Capture Clock Periods */
#define FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE_MASK (0xFF00U)
#define FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE_SHIFT (8U)
/*! SE_SIZE - SE Clock Periods */
#define FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB_MASK (0x10000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB_SHIFT (16U)
/*! ECC_ENABLEB - ECC Decoder Control
 *  0b0..ECC decoder enabled (default)
 *  0b1..ECC decoder disabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN_MASK (0x20000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN_SHIFT (17U)
/*! MISR_EN - MISR Enable
 *  0b0..MISR option disabled (default)
 *  0b1..MISR option enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN_MASK (0x40000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN_SHIFT (18U)
/*! CPY_PAR_EN - Copy Parity Enable
 *  0b0..Copy parity disabled
 *  0b1..Copy parity enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW_MASK (0x80000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW_SHIFT (19U)
/*! BIST_MUX_TO_SMW - BIST Mux to SMW
 *  0b0..BIST drives fields
 *  0b1..SMW registers drive fields
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_AD_SET_MASK  (0xF00000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_AD_SET_SHIFT (20U)
/*! AD_SET - Multi-Cycle Address Setup Time */
#define FMUTEST_RD_PATH_CTRL_STATUS_AD_SET(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_AD_SET_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_AD_SET_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN_MASK (0x1000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN_SHIFT (24U)
/*! WR_PATH_EN - Write Path Enable
 *  0b0..Writes to BIST setting registers driven by MM_WDATA
 *  0b1..Writes to BIST setting registers driven by SMW_DIN
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN_MASK (0x2000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN_SHIFT (25U)
/*! WR_PATH_ECC_EN - Write Path ECC Enable
 *  0b0..ECC encoding disabled
 *  0b1..ECC encoding enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG_MASK (0x4000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG_SHIFT (26U)
/*! DBERR_REG - Double-Bit Error
 *  0b0..Double-bit fault not detected
 *  0b1..Double-bit fault detected on previous UINT flash read
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG_MASK (0x8000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG_SHIFT (27U)
/*! SBERR_REG - Single-Bit Error
 *  0b0..Single-bit fault not detected
 *  0b1..Single-bit fault detected on previous UINT flash read
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN_MASK (0x10000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN_SHIFT (28U)
/*! CPY_PHRASE_EN - Copy Phrase Enable
 *  0b0..Copy Flash read data disabled
 *  0b1..Copy Flash read data enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL_MASK (0x20000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL_SHIFT (29U)
/*! SMW_ARRAY1_SMW0_SEL - SMW_ARRAY1_SMW0_SEL
 *  0b0..Select block 0
 *  0b1..Select block 1
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN_MASK (0x40000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN_SHIFT (30U)
/*! BIST_ECC_EN - BIST ECC Enable
 *  0b0..ECC correction disabled
 *  0b1..ECC correction enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ_MASK (0x80000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ_SHIFT (31U)
/*! LAST_READ - Last Read
 *  0b0..Latest read not last in multi-address operation
 *  0b1..Latest read last in multi-address operation
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ_MASK)
/*! @} */

/*! @name SMW_DIN0 - SMW DIN 0 Register */
/*! @{ */

#define FMUTEST_SMW_DIN0_SMW_DIN0_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_DIN0_SMW_DIN0_SHIFT          (0U)
/*! SMW_DIN0 - SMW DIN 0 */
#define FMUTEST_SMW_DIN0_SMW_DIN0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_DIN0_SMW_DIN0_SHIFT)) & FMUTEST_SMW_DIN0_SMW_DIN0_MASK)
/*! @} */

/*! @name SMW_DIN1 - SMW DIN 1 Register */
/*! @{ */

#define FMUTEST_SMW_DIN1_SMW_DIN1_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_DIN1_SMW_DIN1_SHIFT          (0U)
/*! SMW_DIN1 - SMW DIN 1 */
#define FMUTEST_SMW_DIN1_SMW_DIN1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_DIN1_SMW_DIN1_SHIFT)) & FMUTEST_SMW_DIN1_SMW_DIN1_MASK)
/*! @} */

/*! @name SMW_DIN2 - SMW DIN 2 Register */
/*! @{ */

#define FMUTEST_SMW_DIN2_SMW_DIN2_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_DIN2_SMW_DIN2_SHIFT          (0U)
/*! SMW_DIN2 - SMW DIN 2 */
#define FMUTEST_SMW_DIN2_SMW_DIN2(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_DIN2_SMW_DIN2_SHIFT)) & FMUTEST_SMW_DIN2_SMW_DIN2_MASK)
/*! @} */

/*! @name SMW_DIN3 - SMW DIN 3 Register */
/*! @{ */

#define FMUTEST_SMW_DIN3_SMW_DIN3_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_DIN3_SMW_DIN3_SHIFT          (0U)
/*! SMW_DIN3 - SMW DIN 3 */
#define FMUTEST_SMW_DIN3_SMW_DIN3(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_DIN3_SMW_DIN3_SHIFT)) & FMUTEST_SMW_DIN3_SMW_DIN3_MASK)
/*! @} */

/*! @name SMW_ADDR - SMW Address Register */
/*! @{ */

#define FMUTEST_SMW_ADDR_SMW_ADDR_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_ADDR_SMW_ADDR_SHIFT          (0U)
/*! SMW_ADDR - SMW Address */
#define FMUTEST_SMW_ADDR_SMW_ADDR(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_ADDR_SMW_ADDR_SHIFT)) & FMUTEST_SMW_ADDR_SMW_ADDR_MASK)
/*! @} */

/*! @name SMW_CMD_WAIT - SMW Command and Wait Register */
/*! @{ */

#define FMUTEST_SMW_CMD_WAIT_CMD_MASK            (0x7U)
#define FMUTEST_SMW_CMD_WAIT_CMD_SHIFT           (0U)
/*! CMD - SMW Command
 *  0b000..IDLE
 *  0b001..ABORT
 *  0b010..SME2 to one-shot mass erase
 *  0b011..SME3 to sector erase on selected array
 *  0b100..SMP1 to program phrase or page on selected array with shot disabled on previously programmed bit
 *  0b101..Reserved for SME4 (multi-sector erase)
 *  0b110..SMP2 to program phrase or page on selected array to repair cells of weak program after power loss
 *  0b111..Reserved
 */
#define FMUTEST_SMW_CMD_WAIT_CMD(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_CMD_WAIT_CMD_SHIFT)) & FMUTEST_SMW_CMD_WAIT_CMD_MASK)

#define FMUTEST_SMW_CMD_WAIT_WAIT_EN_MASK        (0x8U)
#define FMUTEST_SMW_CMD_WAIT_WAIT_EN_SHIFT       (3U)
/*! WAIT_EN - SMW Wait Enable
 *  0b0..Wait feature disabled
 *  0b1..Wait feature enabled
 */
#define FMUTEST_SMW_CMD_WAIT_WAIT_EN(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_CMD_WAIT_WAIT_EN_SHIFT)) & FMUTEST_SMW_CMD_WAIT_WAIT_EN_MASK)

#define FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET_MASK  (0x10U)
#define FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET_SHIFT (4U)
/*! WAIT_AUTO_SET - SMW Wait Auto Set */
#define FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET_SHIFT)) & FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET_MASK)
/*! @} */

/*! @name SMW_STATUS - SMW Status Register */
/*! @{ */

#define FMUTEST_SMW_STATUS_SMW_ERR_MASK          (0x1U)
#define FMUTEST_SMW_STATUS_SMW_ERR_SHIFT         (0U)
/*! SMW_ERR - SMW Error
 *  0b0..Error not detected
 *  0b1..Error detected
 */
#define FMUTEST_SMW_STATUS_SMW_ERR(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_STATUS_SMW_ERR_SHIFT)) & FMUTEST_SMW_STATUS_SMW_ERR_MASK)

#define FMUTEST_SMW_STATUS_SMW_BUSY_MASK         (0x2U)
#define FMUTEST_SMW_STATUS_SMW_BUSY_SHIFT        (1U)
/*! SMW_BUSY - SMW Busy
 *  0b0..SMW command not active
 *  0b1..SMW command is active
 */
#define FMUTEST_SMW_STATUS_SMW_BUSY(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_STATUS_SMW_BUSY_SHIFT)) & FMUTEST_SMW_STATUS_SMW_BUSY_MASK)

#define FMUTEST_SMW_STATUS_BIST_BUSY_MASK        (0x4U)
#define FMUTEST_SMW_STATUS_BIST_BUSY_SHIFT       (2U)
/*! BIST_BUSY - BIST Busy
 *  0b0..BIST Command not active
 *  0b1..BIST Command is active
 */
#define FMUTEST_SMW_STATUS_BIST_BUSY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_STATUS_BIST_BUSY_SHIFT)) & FMUTEST_SMW_STATUS_BIST_BUSY_MASK)
/*! @} */

/*! @name SOCTRIM0_0 - SoC Trim Phrase 0 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM0_0_TRIM0_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM0_0_TRIM0_0_SHIFT         (0U)
/*! TRIM0_0 - TRIM0_0 */
#define FMUTEST_SOCTRIM0_0_TRIM0_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM0_0_TRIM0_0_SHIFT)) & FMUTEST_SOCTRIM0_0_TRIM0_0_MASK)
/*! @} */

/*! @name SOCTRIM0_1 - SoC Trim Phrase 0 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM0_1_TRIM0_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM0_1_TRIM0_1_SHIFT         (0U)
/*! TRIM0_1 - TRIM0_1 */
#define FMUTEST_SOCTRIM0_1_TRIM0_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM0_1_TRIM0_1_SHIFT)) & FMUTEST_SOCTRIM0_1_TRIM0_1_MASK)
/*! @} */

/*! @name SOCTRIM0_2 - SoC Trim Phrase 0 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM0_2_TRIM0_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM0_2_TRIM0_2_SHIFT         (0U)
/*! TRIM0_2 - TRIM0_2 */
#define FMUTEST_SOCTRIM0_2_TRIM0_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM0_2_TRIM0_2_SHIFT)) & FMUTEST_SOCTRIM0_2_TRIM0_2_MASK)
/*! @} */

/*! @name SOCTRIM0_3 - SoC Trim Phrase 0 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM0_3_TRIM0_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM0_3_TRIM0_3_SHIFT         (0U)
/*! TRIM0_3 - TRIM0_3 */
#define FMUTEST_SOCTRIM0_3_TRIM0_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM0_3_TRIM0_3_SHIFT)) & FMUTEST_SOCTRIM0_3_TRIM0_3_MASK)
/*! @} */

/*! @name SOCTRIM1_0 - SoC Trim Phrase 1 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM1_0_TRIM1_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM1_0_TRIM1_0_SHIFT         (0U)
/*! TRIM1_0 - TRIM1_0 */
#define FMUTEST_SOCTRIM1_0_TRIM1_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM1_0_TRIM1_0_SHIFT)) & FMUTEST_SOCTRIM1_0_TRIM1_0_MASK)
/*! @} */

/*! @name SOCTRIM1_1 - SoC Trim Phrase 1 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM1_1_TRIM1_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM1_1_TRIM1_1_SHIFT         (0U)
/*! TRIM1_1 - TRIM1_1 */
#define FMUTEST_SOCTRIM1_1_TRIM1_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM1_1_TRIM1_1_SHIFT)) & FMUTEST_SOCTRIM1_1_TRIM1_1_MASK)
/*! @} */

/*! @name SOCTRIM1_2 - SoC Trim Phrase 1 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM1_2_TRIM1_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM1_2_TRIM1_2_SHIFT         (0U)
/*! TRIM1_2 - TRIM1_2 */
#define FMUTEST_SOCTRIM1_2_TRIM1_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM1_2_TRIM1_2_SHIFT)) & FMUTEST_SOCTRIM1_2_TRIM1_2_MASK)
/*! @} */

/*! @name SOCTRIM1_3 - SoC Trim Phrase 1 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM1_3_TRIM1_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM1_3_TRIM1_3_SHIFT         (0U)
/*! TRIM1_3 - TRIM1_3 */
#define FMUTEST_SOCTRIM1_3_TRIM1_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM1_3_TRIM1_3_SHIFT)) & FMUTEST_SOCTRIM1_3_TRIM1_3_MASK)
/*! @} */

/*! @name SOCTRIM2_0 - SoC Trim Phrase 2 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM2_0_TRIM2_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM2_0_TRIM2_0_SHIFT         (0U)
/*! TRIM2_0 - TRIM2_0 */
#define FMUTEST_SOCTRIM2_0_TRIM2_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM2_0_TRIM2_0_SHIFT)) & FMUTEST_SOCTRIM2_0_TRIM2_0_MASK)
/*! @} */

/*! @name SOCTRIM2_1 - SoC Trim Phrase 2 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM2_1_TRIM2_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM2_1_TRIM2_1_SHIFT         (0U)
/*! TRIM2_1 - TRIM2_1 */
#define FMUTEST_SOCTRIM2_1_TRIM2_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM2_1_TRIM2_1_SHIFT)) & FMUTEST_SOCTRIM2_1_TRIM2_1_MASK)
/*! @} */

/*! @name SOCTRIM2_2 - SoC Trim Phrase 2 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM2_2_TRIM2_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM2_2_TRIM2_2_SHIFT         (0U)
/*! TRIM2_2 - TRIM2_2 */
#define FMUTEST_SOCTRIM2_2_TRIM2_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM2_2_TRIM2_2_SHIFT)) & FMUTEST_SOCTRIM2_2_TRIM2_2_MASK)
/*! @} */

/*! @name SOCTRIM2_3 - SoC Trim Phrase 2 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM2_3_TRIM2_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM2_3_TRIM2_3_SHIFT         (0U)
/*! TRIM2_3 - TRIM2_3 */
#define FMUTEST_SOCTRIM2_3_TRIM2_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM2_3_TRIM2_3_SHIFT)) & FMUTEST_SOCTRIM2_3_TRIM2_3_MASK)
/*! @} */

/*! @name SOCTRIM3_0 - SoC Trim Phrase 3 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM3_0_TRIM3_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM3_0_TRIM3_0_SHIFT         (0U)
/*! TRIM3_0 - TRIM3_0 */
#define FMUTEST_SOCTRIM3_0_TRIM3_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM3_0_TRIM3_0_SHIFT)) & FMUTEST_SOCTRIM3_0_TRIM3_0_MASK)
/*! @} */

/*! @name SOCTRIM3_1 - SoC Trim Phrase 3 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM3_1_TRIM3_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM3_1_TRIM3_1_SHIFT         (0U)
/*! TRIM3_1 - TRIM3_1 */
#define FMUTEST_SOCTRIM3_1_TRIM3_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM3_1_TRIM3_1_SHIFT)) & FMUTEST_SOCTRIM3_1_TRIM3_1_MASK)
/*! @} */

/*! @name SOCTRIM3_2 - SoC Trim Phrase 3 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM3_2_TRIM3_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM3_2_TRIM3_2_SHIFT         (0U)
/*! TRIM3_2 - TRIM3_2 */
#define FMUTEST_SOCTRIM3_2_TRIM3_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM3_2_TRIM3_2_SHIFT)) & FMUTEST_SOCTRIM3_2_TRIM3_2_MASK)
/*! @} */

/*! @name SOCTRIM3_3 - SoC Trim Phrase 3 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM3_3_TRIM3_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM3_3_TRIM3_3_SHIFT         (0U)
/*! TRIM3_3 - TRIM3_3 */
#define FMUTEST_SOCTRIM3_3_TRIM3_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM3_3_TRIM3_3_SHIFT)) & FMUTEST_SOCTRIM3_3_TRIM3_3_MASK)
/*! @} */

/*! @name SOCTRIM4_0 - SoC Trim Phrase 4 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM4_0_TRIM4_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM4_0_TRIM4_0_SHIFT         (0U)
/*! TRIM4_0 - TRIM4_0 */
#define FMUTEST_SOCTRIM4_0_TRIM4_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM4_0_TRIM4_0_SHIFT)) & FMUTEST_SOCTRIM4_0_TRIM4_0_MASK)
/*! @} */

/*! @name SOCTRIM4_1 - SoC Trim Phrase 4 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM4_1_TRIM4_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM4_1_TRIM4_1_SHIFT         (0U)
/*! TRIM4_1 - TRIM4_1 */
#define FMUTEST_SOCTRIM4_1_TRIM4_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM4_1_TRIM4_1_SHIFT)) & FMUTEST_SOCTRIM4_1_TRIM4_1_MASK)
/*! @} */

/*! @name SOCTRIM4_2 - SoC Trim Phrase 4 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM4_2_TRIM4_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM4_2_TRIM4_2_SHIFT         (0U)
/*! TRIM4_2 - TRIM4_2 */
#define FMUTEST_SOCTRIM4_2_TRIM4_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM4_2_TRIM4_2_SHIFT)) & FMUTEST_SOCTRIM4_2_TRIM4_2_MASK)
/*! @} */

/*! @name SOCTRIM4_3 - SoC Trim Phrase 4 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM4_3_TRIM4_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM4_3_TRIM4_3_SHIFT         (0U)
/*! TRIM4_3 - TRIM4_3 */
#define FMUTEST_SOCTRIM4_3_TRIM4_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM4_3_TRIM4_3_SHIFT)) & FMUTEST_SOCTRIM4_3_TRIM4_3_MASK)
/*! @} */

/*! @name SOCTRIM5_0 - SoC Trim Phrase 5 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM5_0_TRIM5_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM5_0_TRIM5_0_SHIFT         (0U)
/*! TRIM5_0 - TRIM5_0 */
#define FMUTEST_SOCTRIM5_0_TRIM5_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM5_0_TRIM5_0_SHIFT)) & FMUTEST_SOCTRIM5_0_TRIM5_0_MASK)
/*! @} */

/*! @name SOCTRIM5_1 - SoC Trim Phrase 5 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM5_1_TRIM5_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM5_1_TRIM5_1_SHIFT         (0U)
/*! TRIM5_1 - TRIM5_1 */
#define FMUTEST_SOCTRIM5_1_TRIM5_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM5_1_TRIM5_1_SHIFT)) & FMUTEST_SOCTRIM5_1_TRIM5_1_MASK)
/*! @} */

/*! @name SOCTRIM5_2 - SoC Trim Phrase 5 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM5_2_TRIM5_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM5_2_TRIM5_2_SHIFT         (0U)
/*! TRIM5_2 - TRIM5_2 */
#define FMUTEST_SOCTRIM5_2_TRIM5_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM5_2_TRIM5_2_SHIFT)) & FMUTEST_SOCTRIM5_2_TRIM5_2_MASK)
/*! @} */

/*! @name SOCTRIM5_3 - SoC Trim Phrase 5 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM5_3_TRIM5_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM5_3_TRIM5_3_SHIFT         (0U)
/*! TRIM5_3 - TRIM5_3 */
#define FMUTEST_SOCTRIM5_3_TRIM5_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM5_3_TRIM5_3_SHIFT)) & FMUTEST_SOCTRIM5_3_TRIM5_3_MASK)
/*! @} */

/*! @name SOCTRIM6_0 - SoC Trim Phrase 6 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM6_0_TRIM6_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM6_0_TRIM6_0_SHIFT         (0U)
/*! TRIM6_0 - TRIM6_0 */
#define FMUTEST_SOCTRIM6_0_TRIM6_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM6_0_TRIM6_0_SHIFT)) & FMUTEST_SOCTRIM6_0_TRIM6_0_MASK)
/*! @} */

/*! @name SOCTRIM6_1 - SoC Trim Phrase 6 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM6_1_TRIM6_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM6_1_TRIM6_1_SHIFT         (0U)
/*! TRIM6_1 - TRIM6_1 */
#define FMUTEST_SOCTRIM6_1_TRIM6_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM6_1_TRIM6_1_SHIFT)) & FMUTEST_SOCTRIM6_1_TRIM6_1_MASK)
/*! @} */

/*! @name SOCTRIM6_2 - SoC Trim Phrase 6 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM6_2_TRIM6_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM6_2_TRIM6_2_SHIFT         (0U)
/*! TRIM6_2 - TRIM6_2 */
#define FMUTEST_SOCTRIM6_2_TRIM6_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM6_2_TRIM6_2_SHIFT)) & FMUTEST_SOCTRIM6_2_TRIM6_2_MASK)
/*! @} */

/*! @name SOCTRIM6_3 - SoC Trim Phrase 6 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM6_3_TRIM6_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM6_3_TRIM6_3_SHIFT         (0U)
/*! TRIM6_3 - TRIM6_3 */
#define FMUTEST_SOCTRIM6_3_TRIM6_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM6_3_TRIM6_3_SHIFT)) & FMUTEST_SOCTRIM6_3_TRIM6_3_MASK)
/*! @} */

/*! @name SOCTRIM7_0 - SoC Trim Phrase 7 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM7_0_TRIM7_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM7_0_TRIM7_0_SHIFT         (0U)
/*! TRIM7_0 - TRIM7_0 */
#define FMUTEST_SOCTRIM7_0_TRIM7_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM7_0_TRIM7_0_SHIFT)) & FMUTEST_SOCTRIM7_0_TRIM7_0_MASK)
/*! @} */

/*! @name SOCTRIM7_1 - SoC Trim Phrase 7 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM7_1_TRIM7_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM7_1_TRIM7_1_SHIFT         (0U)
/*! TRIM7_1 - TRIM7_1 */
#define FMUTEST_SOCTRIM7_1_TRIM7_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM7_1_TRIM7_1_SHIFT)) & FMUTEST_SOCTRIM7_1_TRIM7_1_MASK)
/*! @} */

/*! @name SOCTRIM7_2 - SoC Trim Phrase 7 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM7_2_TRIM7_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM7_2_TRIM7_2_SHIFT         (0U)
/*! TRIM7_2 - TRIM7_2 */
#define FMUTEST_SOCTRIM7_2_TRIM7_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM7_2_TRIM7_2_SHIFT)) & FMUTEST_SOCTRIM7_2_TRIM7_2_MASK)
/*! @} */

/*! @name SOCTRIM7_3 - SoC Trim Phrase 7 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM7_3_TRIM7_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM7_3_TRIM7_3_SHIFT         (0U)
/*! TRIM7_3 - TRIM7_3 */
#define FMUTEST_SOCTRIM7_3_TRIM7_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM7_3_TRIM7_3_SHIFT)) & FMUTEST_SOCTRIM7_3_TRIM7_3_MASK)
/*! @} */

/*! @name R_IP_CONFIG - BIST Configuration Register */
/*! @{ */

#define FMUTEST_R_IP_CONFIG_IPSEL0_MASK          (0x3U)
#define FMUTEST_R_IP_CONFIG_IPSEL0_SHIFT         (0U)
/*! IPSEL0 - Block 0 Select Control
 *  0b00..Unselect block 0
 *  0b01..not used, reserved
 *  0b10..Enable block 0 test, repair off (default)
 *  0b11..Enable block 0 test, repair on
 */
#define FMUTEST_R_IP_CONFIG_IPSEL0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_IPSEL0_SHIFT)) & FMUTEST_R_IP_CONFIG_IPSEL0_MASK)

#define FMUTEST_R_IP_CONFIG_IPSEL1_MASK          (0xCU)
#define FMUTEST_R_IP_CONFIG_IPSEL1_SHIFT         (2U)
/*! IPSEL1 - Block 1 Select Control
 *  0b00..Unselect block 1
 *  0b01..not used, reserved
 *  0b10..Enable block 1 test, repair off (default)
 *  0b11..Enable block 1 test, repair on
 */
#define FMUTEST_R_IP_CONFIG_IPSEL1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_IPSEL1_SHIFT)) & FMUTEST_R_IP_CONFIG_IPSEL1_MASK)

#define FMUTEST_R_IP_CONFIG_BIST_CDIVL_MASK      (0xFF0U)
#define FMUTEST_R_IP_CONFIG_BIST_CDIVL_SHIFT     (4U)
/*! BIST_CDIVL - Clock Divide Scalar for Long Pulse */
#define FMUTEST_R_IP_CONFIG_BIST_CDIVL(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_BIST_CDIVL_SHIFT)) & FMUTEST_R_IP_CONFIG_BIST_CDIVL_MASK)

#define FMUTEST_R_IP_CONFIG_CDIVS_MASK           (0x7000U)
#define FMUTEST_R_IP_CONFIG_CDIVS_SHIFT          (12U)
/*! CDIVS - Number of clock cycles to generate short pulse */
#define FMUTEST_R_IP_CONFIG_CDIVS(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_CDIVS_SHIFT)) & FMUTEST_R_IP_CONFIG_CDIVS_MASK)

#define FMUTEST_R_IP_CONFIG_BIST_TVFY_MASK       (0xF8000U)
#define FMUTEST_R_IP_CONFIG_BIST_TVFY_SHIFT      (15U)
/*! BIST_TVFY - Timer adjust for verify */
#define FMUTEST_R_IP_CONFIG_BIST_TVFY(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_BIST_TVFY_SHIFT)) & FMUTEST_R_IP_CONFIG_BIST_TVFY_MASK)

#define FMUTEST_R_IP_CONFIG_TSTCTL_MASK          (0x300000U)
#define FMUTEST_R_IP_CONFIG_TSTCTL_SHIFT         (20U)
/*! TSTCTL - BIST self-test control
 *  0b00..Default, disable both BIST self-test and MISR
 *  0b01..Enable BIST self-test mode DOUT from macro will be forced to '0', and disable MISR.
 *  0b10..Enable MISR
 *  0b11..Enable both BIST self-test mode and MISR
 */
#define FMUTEST_R_IP_CONFIG_TSTCTL(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_TSTCTL_SHIFT)) & FMUTEST_R_IP_CONFIG_TSTCTL_MASK)

#define FMUTEST_R_IP_CONFIG_DBGCTL_MASK          (0x400000U)
#define FMUTEST_R_IP_CONFIG_DBGCTL_SHIFT         (22U)
/*! DBGCTL - Debug feature control
 *  0b0..Default
 *  0b1..Enable debug feature to collect failure address and data.
 */
#define FMUTEST_R_IP_CONFIG_DBGCTL(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_DBGCTL_SHIFT)) & FMUTEST_R_IP_CONFIG_DBGCTL_MASK)

#define FMUTEST_R_IP_CONFIG_BIST_CLK_SEL_MASK    (0x800000U)
#define FMUTEST_R_IP_CONFIG_BIST_CLK_SEL_SHIFT   (23U)
/*! BIST_CLK_SEL - BIST Clock Select */
#define FMUTEST_R_IP_CONFIG_BIST_CLK_SEL(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_BIST_CLK_SEL_SHIFT)) & FMUTEST_R_IP_CONFIG_BIST_CLK_SEL_MASK)

#define FMUTEST_R_IP_CONFIG_SMWTST_MASK          (0x3000000U)
#define FMUTEST_R_IP_CONFIG_SMWTST_SHIFT         (24U)
/*! SMWTST - SMWR DOUT Function Control
 *  0b00..Default
 *  0b01..Enable SMWR self-test mode, DOUT from macro will be forced to all 0
 *  0b10..Enable SMWR self-test mode, DOUT from macro will be forced to all 1
 *  0b11..Reserved (unused)
 */
#define FMUTEST_R_IP_CONFIG_SMWTST(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_SMWTST_SHIFT)) & FMUTEST_R_IP_CONFIG_SMWTST_MASK)

#define FMUTEST_R_IP_CONFIG_ECCEN_MASK           (0x4000000U)
#define FMUTEST_R_IP_CONFIG_ECCEN_SHIFT          (26U)
/*! ECCEN - BIST ECC Control
 *  0b0..Default mode (no ECC encode or decode)
 *  0b1..Enable ECC encode/decode
 */
#define FMUTEST_R_IP_CONFIG_ECCEN(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_ECCEN_SHIFT)) & FMUTEST_R_IP_CONFIG_ECCEN_MASK)
/*! @} */

/*! @name R_TESTCODE - BIST Test Code Register */
/*! @{ */

#define FMUTEST_R_TESTCODE_TESTCODE_MASK         (0x3FU)
#define FMUTEST_R_TESTCODE_TESTCODE_SHIFT        (0U)
/*! TESTCODE - Used to store test code information before running TMR-RST/TMRSET BIST command */
#define FMUTEST_R_TESTCODE_TESTCODE(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TESTCODE_TESTCODE_SHIFT)) & FMUTEST_R_TESTCODE_TESTCODE_MASK)
/*! @} */

/*! @name R_DFT_CTRL - BIST DFT Control Register */
/*! @{ */

#define FMUTEST_R_DFT_CTRL_DFT_XADR_MASK         (0xFU)
#define FMUTEST_R_DFT_CTRL_DFT_XADR_SHIFT        (0U)
/*! DFT_XADR - DFT XADR Pattern
 *  0b0000..XADR fixed, no change at all
 *  0b0001..XADR increased by 1 after row. For READ operation, XADR increases by 1 after reading the last word of
 *          row. For PROG operation, XADR increases by 1 after NVSTR falls.
 *  0b0010..XADR increased for diagonal. For PROG-DIAGONAL operation, XADR is increased to create diagonal pattern.
 *  0b0011..XADR increased by sector. During ERASE operation, XADR increased by number of rows in a sector when NVSTR falls.
 *  0b0100..XADR inversed. XADR is inversed after reading one word or after programming one row when NVSTR falls.
 *  0b0101..XADR increased by 2 after row. For READ operation, XADR is increased by 2 after reading the last word
 *          of a row. For PROG operation, XADR is increased by 2 when NVSTR falls.
 *  0b0110..XADR[0] inversed. XADR[0] is inversed after reading one word or after programming one row when NVSTR falls.
 *  0b0111..XADR increased by 1. For READ operations only, XADR increased by 1 after each read cycle.
 *  0b1000..XADR decreased by 1 after row. For READ operations only, XADR is decreased by 1 after YADR decreases to 0.
 *  0b1001..XADR decreased by 1. For READ operations only, XADR is decreased by 1 after each read cycle.
 */
#define FMUTEST_R_DFT_CTRL_DFT_XADR(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_DFT_XADR_SHIFT)) & FMUTEST_R_DFT_CTRL_DFT_XADR_MASK)

#define FMUTEST_R_DFT_CTRL_DFT_YADR_MASK         (0xF0U)
#define FMUTEST_R_DFT_CTRL_DFT_YADR_SHIFT        (4U)
/*! DFT_YADR - DFT YADR Pattern
 *  0b0000..YADR fixed, no change at all
 *  0b0001..YADR for ICKBD. For PROG and READ operations, YADR changed to generate inverse checkerboard pattern.
 *  0b0010..YADR for CKBD. For PROG and READ operations, YADR changed to generate checkerboard pattern.
 *  0b0011..YADR increased by 1. For READ operations, YADR increased by 1 after each read cycle. For PROG
 *          operations, YADR increased by 1 after YE falls.
 *  0b0100..YADR increased for diagonal. For PROG-DIAGONAL operation, YADR is increased to create diagonal pattern.
 *  0b0101..YADR inversed. YADR is inversed after reading one word or after programming one word when YE falls.
 *  0b0110..YADR[0] inversed. YADR[0] is inversed after reading one word or after programming one word when YE falls.
 *  0b0111..YADR increased by 1 after last row. For READ operations only, YADR is increased by 1 after XADR reaches last row.
 *  0b1000..YADR decreased by 1. For READ operations only, YADR is decreased by 1 after each read cycle.
 *  0b1001..YADR decreased by 1 after first row. For READ operations only, YADR is decreased by 1 after XADR decreases to 0.
 */
#define FMUTEST_R_DFT_CTRL_DFT_YADR(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_DFT_YADR_SHIFT)) & FMUTEST_R_DFT_CTRL_DFT_YADR_MASK)

#define FMUTEST_R_DFT_CTRL_DFT_DATA_MASK         (0xF00U)
#define FMUTEST_R_DFT_CTRL_DFT_DATA_SHIFT        (8U)
/*! DFT_DATA - DFT Data Pattern
 *  0b0000..CKBD pattern. For READ operations only, compare DOUT with checkerboard data pattern for each read cycle.
 *  0b0001..ICKBD pattern. For READ operations only, compare DOUT with inverse checkerboard data pattern for each read cycle.
 *  0b0010..Diagonal pattern. Used for READ operations only, compare DOUT to diagonal pattern.
 *  0b0011..Fixed data pattern. For READ operations, comparison to DOUT for selected groups; refer to
 *          R_ADR_CTRL[GRPSEL] for modules with multiple groups.
 *  0b0100..Random data pattern which will be generated based on the initial seed set in R_DATA; for READ
 *          operations, used for DOUT comparison of selected groups. For PROG operations, used to control DIN of selected
 *          groups.
 *  0b0101..DOUT based pattern. For READ operations only, DOUT of selected group will be latched in R_DATA. If
 *          more than one group is selected in R_ADR_CTRL[GRPSEL], the group with the lower index will be latched.
 *  0b0110..R_DATA based pattern. For READ operations, expected DOUT value of selected groups equals to R_DATA
 *          when XADR[0]==YADR[0] or ~R_DATA when XADR[0]!=YADR[0]. For PROG operations, DIN of selected groups equals
 *          R_DATA when XADR[0]==YADR[0] or ~R_DATA when XADR[0]!=YADR[0].
 *  0b0111..SCAN-IO pattern. For READ operations, control expected DOUT value of selected groups to SCAN-IO data
 *          pattern. For PROG operations, control DIN of selected groups to SCAN-IO data pattern.
 *  0b1000..REPAIR set. For PROG operation to IFR1(7,1) and IFR1(7,2), R_REPAIR0_0 and R_REPAIR0_1 or R_REPAIR1_0
 *          and R_REPAIR1_1 will control DIN. For READ operation on IFR1(7,1) and IFR1(7,2), DOUT will be compared
 *          against R_REPAIR0_0 and R_REPAIR0_1 or R_REPAIR1_0 andR_REPAIR1_1. When this option is selected, only
 *          one flash block can be selected.
 *  0b1001..REPAIR load. For READ operation only, DOUT from IFR1(7,1) and IFR1(7,2) is loaded to R_REPAIR0 and R_REPAIR1.
 */
#define FMUTEST_R_DFT_CTRL_DFT_DATA(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_DFT_DATA_SHIFT)) & FMUTEST_R_DFT_CTRL_DFT_DATA_MASK)

#define FMUTEST_R_DFT_CTRL_CMP_MASK_MASK         (0x3000U)
#define FMUTEST_R_DFT_CTRL_CMP_MASK_SHIFT        (12U)
/*! CMP_MASK - Data Compare Mask
 *  0b00..Expected data is compared to DOUT
 *  0b01..Expected data (only 0s are considered) are compared to DOUT
 *  0b10..Expected data (only 1s are considered) are compared to DOUT
 */
#define FMUTEST_R_DFT_CTRL_CMP_MASK(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_CMP_MASK_SHIFT)) & FMUTEST_R_DFT_CTRL_CMP_MASK_MASK)

#define FMUTEST_R_DFT_CTRL_DFT_DATA_SRC_MASK     (0x4000U)
#define FMUTEST_R_DFT_CTRL_DFT_DATA_SRC_SHIFT    (14U)
/*! DFT_DATA_SRC - DFT Data Source
 *  0b0..{R_DATA_CTRL0,R_DATA_CTRL_EX[2:0],R_DATA_CTRL0,R_DATA_CTRL_EX[2:0],R_DATA_CTRL0,R_DATA_CTRL_EX[2:0],R_DATA_CTRL0} is used
 *  0b1..{R_DATA_CTRL3,R_DATA_CTRL2_EX[2:0],R_DATA_CTRL2,R_DATA_CTRL1_EX[2:0],R_DATA_CTRL1,R_DATA_CTRL_EX[2:0],R_DATA_CTRL0} is used
 */
#define FMUTEST_R_DFT_CTRL_DFT_DATA_SRC(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_DFT_DATA_SRC_SHIFT)) & FMUTEST_R_DFT_CTRL_DFT_DATA_SRC_MASK)
/*! @} */

/*! @name R_ADR_CTRL - BIST Address Control Register */
/*! @{ */

#define FMUTEST_R_ADR_CTRL_GRPSEL_MASK           (0xFU)
#define FMUTEST_R_ADR_CTRL_GRPSEL_SHIFT          (0U)
/*! GRPSEL - Data Group Select
 *  0b0000..Select no data
 *  0b0001..Select data slice [34:0]
 *  0b0010..Select data slice [69:35]
 *  0b0100..Select data slice [104:70]
 *  0b1000..Select data slice [136:105]
 *  0b1111..Select data [136:0]
 */
#define FMUTEST_R_ADR_CTRL_GRPSEL(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_CTRL_GRPSEL_SHIFT)) & FMUTEST_R_ADR_CTRL_GRPSEL_MASK)

#define FMUTEST_R_ADR_CTRL_XADR_MASK             (0xFFF0U)
#define FMUTEST_R_ADR_CTRL_XADR_SHIFT            (4U)
/*! XADR - BIST XADR */
#define FMUTEST_R_ADR_CTRL_XADR(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_CTRL_XADR_SHIFT)) & FMUTEST_R_ADR_CTRL_XADR_MASK)

#define FMUTEST_R_ADR_CTRL_YADR_MASK             (0x1F0000U)
#define FMUTEST_R_ADR_CTRL_YADR_SHIFT            (16U)
/*! YADR - BIST YADR */
#define FMUTEST_R_ADR_CTRL_YADR(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_CTRL_YADR_SHIFT)) & FMUTEST_R_ADR_CTRL_YADR_MASK)

#define FMUTEST_R_ADR_CTRL_PROG_ATTR_MASK        (0xE00000U)
#define FMUTEST_R_ADR_CTRL_PROG_ATTR_SHIFT       (21U)
/*! PROG_ATTR - Program Attribute
 *  0b000..One YE pulse will program one data slice group
 *  0b001..One YE pulse will program two data slice groups
 *  0b010..One YE pulse will program three data slice groups (reserved)
 *  0b011..One YE pulse will program four data slice groups
 *  0b100..One YE pulse will program five data slice groups (reserved)
 *  0b101..One YE pulse will program six data slice groups (reserved)
 *  0b110..One YE pulse will program seven data slice groups (reserved)
 *  0b111..One YE pulse will program eight data slice groups (reserved)
 */
#define FMUTEST_R_ADR_CTRL_PROG_ATTR(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_CTRL_PROG_ATTR_SHIFT)) & FMUTEST_R_ADR_CTRL_PROG_ATTR_MASK)
/*! @} */

/*! @name R_DATA_CTRL0 - BIST Data Control 0 Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL0_DATA0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_DATA_CTRL0_DATA0_SHIFT         (0U)
/*! DATA0 - BIST Data 0 Low */
#define FMUTEST_R_DATA_CTRL0_DATA0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL0_DATA0_SHIFT)) & FMUTEST_R_DATA_CTRL0_DATA0_MASK)
/*! @} */

/*! @name R_PIN_CTRL - BIST Pin Control Register */
/*! @{ */

#define FMUTEST_R_PIN_CTRL_MAS1_MASK             (0x1U)
#define FMUTEST_R_PIN_CTRL_MAS1_SHIFT            (0U)
/*! MAS1 - Mass Erase */
#define FMUTEST_R_PIN_CTRL_MAS1(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_MAS1_SHIFT)) & FMUTEST_R_PIN_CTRL_MAS1_MASK)

#define FMUTEST_R_PIN_CTRL_IFREN_MASK            (0x2U)
#define FMUTEST_R_PIN_CTRL_IFREN_SHIFT           (1U)
/*! IFREN - IFR Enable */
#define FMUTEST_R_PIN_CTRL_IFREN(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_IFREN_SHIFT)) & FMUTEST_R_PIN_CTRL_IFREN_MASK)

#define FMUTEST_R_PIN_CTRL_IFREN1_MASK           (0x4U)
#define FMUTEST_R_PIN_CTRL_IFREN1_SHIFT          (2U)
/*! IFREN1 - IFR1 Enable */
#define FMUTEST_R_PIN_CTRL_IFREN1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_IFREN1_SHIFT)) & FMUTEST_R_PIN_CTRL_IFREN1_MASK)

#define FMUTEST_R_PIN_CTRL_REDEN_MASK            (0x8U)
#define FMUTEST_R_PIN_CTRL_REDEN_SHIFT           (3U)
/*! REDEN - Redundancy Block Enable */
#define FMUTEST_R_PIN_CTRL_REDEN(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_REDEN_SHIFT)) & FMUTEST_R_PIN_CTRL_REDEN_MASK)

#define FMUTEST_R_PIN_CTRL_LVE_MASK              (0x10U)
#define FMUTEST_R_PIN_CTRL_LVE_SHIFT             (4U)
/*! LVE - Low Voltage Enable */
#define FMUTEST_R_PIN_CTRL_LVE(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_LVE_SHIFT)) & FMUTEST_R_PIN_CTRL_LVE_MASK)

#define FMUTEST_R_PIN_CTRL_PV_MASK               (0x20U)
#define FMUTEST_R_PIN_CTRL_PV_SHIFT              (5U)
/*! PV - Program Verify Enable */
#define FMUTEST_R_PIN_CTRL_PV(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_PV_SHIFT)) & FMUTEST_R_PIN_CTRL_PV_MASK)

#define FMUTEST_R_PIN_CTRL_EV_MASK               (0x40U)
#define FMUTEST_R_PIN_CTRL_EV_SHIFT              (6U)
/*! EV - Erase Verify Enable */
#define FMUTEST_R_PIN_CTRL_EV(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_EV_SHIFT)) & FMUTEST_R_PIN_CTRL_EV_MASK)

#define FMUTEST_R_PIN_CTRL_WIPGM_MASK            (0x180U)
#define FMUTEST_R_PIN_CTRL_WIPGM_SHIFT           (7U)
/*! WIPGM - Program Current */
#define FMUTEST_R_PIN_CTRL_WIPGM(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_WIPGM_SHIFT)) & FMUTEST_R_PIN_CTRL_WIPGM_MASK)

#define FMUTEST_R_PIN_CTRL_WHV_MASK              (0x1E00U)
#define FMUTEST_R_PIN_CTRL_WHV_SHIFT             (9U)
/*! WHV - High Voltage Level */
#define FMUTEST_R_PIN_CTRL_WHV(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_WHV_SHIFT)) & FMUTEST_R_PIN_CTRL_WHV_MASK)

#define FMUTEST_R_PIN_CTRL_WMV_MASK              (0xE000U)
#define FMUTEST_R_PIN_CTRL_WMV_SHIFT             (13U)
/*! WMV - Medium Voltage Level */
#define FMUTEST_R_PIN_CTRL_WMV(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_WMV_SHIFT)) & FMUTEST_R_PIN_CTRL_WMV_MASK)

#define FMUTEST_R_PIN_CTRL_XE_MASK               (0x10000U)
#define FMUTEST_R_PIN_CTRL_XE_SHIFT              (16U)
/*! XE - X Address Enable */
#define FMUTEST_R_PIN_CTRL_XE(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_XE_SHIFT)) & FMUTEST_R_PIN_CTRL_XE_MASK)

#define FMUTEST_R_PIN_CTRL_YE_MASK               (0x20000U)
#define FMUTEST_R_PIN_CTRL_YE_SHIFT              (17U)
/*! YE - Y Address Enable */
#define FMUTEST_R_PIN_CTRL_YE(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_YE_SHIFT)) & FMUTEST_R_PIN_CTRL_YE_MASK)

#define FMUTEST_R_PIN_CTRL_SE_MASK               (0x40000U)
#define FMUTEST_R_PIN_CTRL_SE_SHIFT              (18U)
/*! SE - Sense Amp Enable */
#define FMUTEST_R_PIN_CTRL_SE(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_SE_SHIFT)) & FMUTEST_R_PIN_CTRL_SE_MASK)

#define FMUTEST_R_PIN_CTRL_ERASE_MASK            (0x80000U)
#define FMUTEST_R_PIN_CTRL_ERASE_SHIFT           (19U)
/*! ERASE - Erase Mode */
#define FMUTEST_R_PIN_CTRL_ERASE(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_ERASE_SHIFT)) & FMUTEST_R_PIN_CTRL_ERASE_MASK)

#define FMUTEST_R_PIN_CTRL_PROG_MASK             (0x100000U)
#define FMUTEST_R_PIN_CTRL_PROG_SHIFT            (20U)
/*! PROG - Program Mode */
#define FMUTEST_R_PIN_CTRL_PROG(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_PROG_SHIFT)) & FMUTEST_R_PIN_CTRL_PROG_MASK)

#define FMUTEST_R_PIN_CTRL_NVSTR_MASK            (0x200000U)
#define FMUTEST_R_PIN_CTRL_NVSTR_SHIFT           (21U)
/*! NVSTR - NVM Store */
#define FMUTEST_R_PIN_CTRL_NVSTR(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_NVSTR_SHIFT)) & FMUTEST_R_PIN_CTRL_NVSTR_MASK)

#define FMUTEST_R_PIN_CTRL_SLM_MASK              (0x400000U)
#define FMUTEST_R_PIN_CTRL_SLM_SHIFT             (22U)
/*! SLM - Sleep Mode Enable */
#define FMUTEST_R_PIN_CTRL_SLM(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_SLM_SHIFT)) & FMUTEST_R_PIN_CTRL_SLM_MASK)

#define FMUTEST_R_PIN_CTRL_RECALL_MASK           (0x800000U)
#define FMUTEST_R_PIN_CTRL_RECALL_SHIFT          (23U)
/*! RECALL - Recall Trim Code */
#define FMUTEST_R_PIN_CTRL_RECALL(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_RECALL_SHIFT)) & FMUTEST_R_PIN_CTRL_RECALL_MASK)

#define FMUTEST_R_PIN_CTRL_HEM_MASK              (0x1000000U)
#define FMUTEST_R_PIN_CTRL_HEM_SHIFT             (24U)
/*! HEM - HEM Control */
#define FMUTEST_R_PIN_CTRL_HEM(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_HEM_SHIFT)) & FMUTEST_R_PIN_CTRL_HEM_MASK)
/*! @} */

/*! @name R_CNT_LOOP_CTRL - BIST Loop Count Control Register */
/*! @{ */

#define FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT_MASK     (0xFFFU)
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT_SHIFT    (0U)
/*! LOOPCNT - Loop Count Control */
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT_SHIFT)) & FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT_MASK)

#define FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT_MASK     (0x7000U)
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT_SHIFT    (12U)
/*! LOOPOPT - Loop Option
 *  0b000..Loop is disabled; selected BIST operation is run once
 *  0b001..Loop is enabled; XADR increments by 1 XADR increments by 1 for each new loop. Stops when total loop count meets LOOPCNT+1.
 *  0b010..Loop is enabled; YADR increments by 1 YADR increments by 1 for each new loop. Stops when total loop count meets LOOPCNT+1.
 *  0b011..Loop is enabled; XADR increments by 2 XADR increments by 2 for each new loop. Stops when total loop count meets LOOPCNT+1.
 *  0b100..Loop is enabled; XADR increments by sector XADR increments by 16 for each new loop. Stops when total loop count meets LOOPCNT+1.
 */
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT_SHIFT)) & FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT_MASK)

#define FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT_MASK    (0x38000U)
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT_SHIFT   (15U)
/*! LOOPUNIT - Loop Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT_SHIFT)) & FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT_MASK)

#define FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY_MASK     (0x1FC0000U)
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY_SHIFT    (18U)
/*! LOOPDLY - Loop Time Delay Scalar */
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY_SHIFT)) & FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY_MASK)
/*! @} */

/*! @name R_TIMER_CTRL - BIST Timer Control Register */
/*! @{ */

#define FMUTEST_R_TIMER_CTRL_TNVSUNIT_MASK       (0x7U)
#define FMUTEST_R_TIMER_CTRL_TNVSUNIT_SHIFT      (0U)
/*! TNVSUNIT - Tnvs Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TNVSUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TNVSUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TNVSUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TNVSDLY_MASK        (0x78U)
#define FMUTEST_R_TIMER_CTRL_TNVSDLY_SHIFT       (3U)
/*! TNVSDLY - Tnvs Time Delay Scalar */
#define FMUTEST_R_TIMER_CTRL_TNVSDLY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TNVSDLY_SHIFT)) & FMUTEST_R_TIMER_CTRL_TNVSDLY_MASK)

#define FMUTEST_R_TIMER_CTRL_TNVHUNIT_MASK       (0x380U)
#define FMUTEST_R_TIMER_CTRL_TNVHUNIT_SHIFT      (7U)
/*! TNVHUNIT - Tnvh Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TNVHUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TNVHUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TNVHUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TNVHDLY_MASK        (0x3C00U)
#define FMUTEST_R_TIMER_CTRL_TNVHDLY_SHIFT       (10U)
/*! TNVHDLY - Tnvh Time Delay Scalar */
#define FMUTEST_R_TIMER_CTRL_TNVHDLY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TNVHDLY_SHIFT)) & FMUTEST_R_TIMER_CTRL_TNVHDLY_MASK)

#define FMUTEST_R_TIMER_CTRL_TPGSUNIT_MASK       (0x1C000U)
#define FMUTEST_R_TIMER_CTRL_TPGSUNIT_SHIFT      (14U)
/*! TPGSUNIT - Tpgs Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TPGSUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TPGSUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TPGSUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TPGSDLY_MASK        (0x1E0000U)
#define FMUTEST_R_TIMER_CTRL_TPGSDLY_SHIFT       (17U)
/*! TPGSDLY - Tpgs Time Delay Scalar */
#define FMUTEST_R_TIMER_CTRL_TPGSDLY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TPGSDLY_SHIFT)) & FMUTEST_R_TIMER_CTRL_TPGSDLY_MASK)

#define FMUTEST_R_TIMER_CTRL_TRCVUNIT_MASK       (0xE00000U)
#define FMUTEST_R_TIMER_CTRL_TRCVUNIT_SHIFT      (21U)
/*! TRCVUNIT - Trcv Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TRCVUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TRCVUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TRCVUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TRCVDLY_MASK        (0xF000000U)
#define FMUTEST_R_TIMER_CTRL_TRCVDLY_SHIFT       (24U)
/*! TRCVDLY - Trcv Time Delay Scalar */
#define FMUTEST_R_TIMER_CTRL_TRCVDLY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TRCVDLY_SHIFT)) & FMUTEST_R_TIMER_CTRL_TRCVDLY_MASK)

#define FMUTEST_R_TIMER_CTRL_TLVSUNIT_MASK       (0x70000000U)
#define FMUTEST_R_TIMER_CTRL_TLVSUNIT_SHIFT      (28U)
/*! TLVSUNIT - Tlvs Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TLVSUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TLVSUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TLVSUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TLVSDLY_L_MASK      (0x80000000U)
#define FMUTEST_R_TIMER_CTRL_TLVSDLY_L_SHIFT     (31U)
/*! TLVSDLY_L - Tlvs Time Delay Scalar Low */
#define FMUTEST_R_TIMER_CTRL_TLVSDLY_L(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TLVSDLY_L_SHIFT)) & FMUTEST_R_TIMER_CTRL_TLVSDLY_L_MASK)
/*! @} */

/*! @name R_TEST_CTRL - BIST Test Control Register */
/*! @{ */

#define FMUTEST_R_TEST_CTRL_BUSY_MASK            (0x1U)
#define FMUTEST_R_TEST_CTRL_BUSY_SHIFT           (0U)
/*! BUSY - BIST Busy Status
 *  0b0..BIST is idle
 *  0b1..BIST is busy
 */
#define FMUTEST_R_TEST_CTRL_BUSY(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_BUSY_SHIFT)) & FMUTEST_R_TEST_CTRL_BUSY_MASK)

#define FMUTEST_R_TEST_CTRL_DEBUG_MASK           (0x2U)
#define FMUTEST_R_TEST_CTRL_DEBUG_SHIFT          (1U)
/*! DEBUG - BIST Debug Status */
#define FMUTEST_R_TEST_CTRL_DEBUG(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_DEBUG_SHIFT)) & FMUTEST_R_TEST_CTRL_DEBUG_MASK)

#define FMUTEST_R_TEST_CTRL_STATUS0_MASK         (0x4U)
#define FMUTEST_R_TEST_CTRL_STATUS0_SHIFT        (2U)
/*! STATUS0 - BIST Status 0
 *  0b0..BIST test passed on flash block 0
 *  0b1..BIST test failed on flash block 0
 */
#define FMUTEST_R_TEST_CTRL_STATUS0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_STATUS0_SHIFT)) & FMUTEST_R_TEST_CTRL_STATUS0_MASK)

#define FMUTEST_R_TEST_CTRL_STATUS1_MASK         (0x8U)
#define FMUTEST_R_TEST_CTRL_STATUS1_SHIFT        (3U)
/*! STATUS1 - BIST status 1
 *  0b0..BIST test passed on flash block 1
 *  0b1..BIST test failed on flash block 1
 */
#define FMUTEST_R_TEST_CTRL_STATUS1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_STATUS1_SHIFT)) & FMUTEST_R_TEST_CTRL_STATUS1_MASK)

#define FMUTEST_R_TEST_CTRL_DEBUGRUN_MASK        (0x10U)
#define FMUTEST_R_TEST_CTRL_DEBUGRUN_SHIFT       (4U)
/*! DEBUGRUN - BIST Continue Debug Run */
#define FMUTEST_R_TEST_CTRL_DEBUGRUN(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_DEBUGRUN_SHIFT)) & FMUTEST_R_TEST_CTRL_DEBUGRUN_MASK)

#define FMUTEST_R_TEST_CTRL_STARTRUN_MASK        (0x20U)
#define FMUTEST_R_TEST_CTRL_STARTRUN_SHIFT       (5U)
/*! STARTRUN - Run New BIST Operation */
#define FMUTEST_R_TEST_CTRL_STARTRUN(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_STARTRUN_SHIFT)) & FMUTEST_R_TEST_CTRL_STARTRUN_MASK)

#define FMUTEST_R_TEST_CTRL_CMDINDEX_MASK        (0xFFC0U)
#define FMUTEST_R_TEST_CTRL_CMDINDEX_SHIFT       (6U)
/*! CMDINDEX - BIST Command Index (code) */
#define FMUTEST_R_TEST_CTRL_CMDINDEX(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_CMDINDEX_SHIFT)) & FMUTEST_R_TEST_CTRL_CMDINDEX_MASK)

#define FMUTEST_R_TEST_CTRL_DISABLE_IP1_MASK     (0x10000U)
#define FMUTEST_R_TEST_CTRL_DISABLE_IP1_SHIFT    (16U)
/*! DISABLE_IP1 - BIST Disable IP1 */
#define FMUTEST_R_TEST_CTRL_DISABLE_IP1(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_DISABLE_IP1_SHIFT)) & FMUTEST_R_TEST_CTRL_DISABLE_IP1_MASK)
/*! @} */

/*! @name R_ABORT_LOOP - BIST Abort Loop Register */
/*! @{ */

#define FMUTEST_R_ABORT_LOOP_ABORT_LOOP_MASK     (0x1U)
#define FMUTEST_R_ABORT_LOOP_ABORT_LOOP_SHIFT    (0U)
/*! ABORT_LOOP - Abort Loop
 *  0b0..No effect
 *  0b1..Abort BIST loop commands and force the loop counter to return to 0x0
 */
#define FMUTEST_R_ABORT_LOOP_ABORT_LOOP(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ABORT_LOOP_ABORT_LOOP_SHIFT)) & FMUTEST_R_ABORT_LOOP_ABORT_LOOP_MASK)
/*! @} */

/*! @name R_ADR_QUERY - BIST Address Query Register */
/*! @{ */

#define FMUTEST_R_ADR_QUERY_YADRFAIL_MASK        (0x1FU)
#define FMUTEST_R_ADR_QUERY_YADRFAIL_SHIFT       (0U)
/*! YADRFAIL - Failing YADR */
#define FMUTEST_R_ADR_QUERY_YADRFAIL(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_QUERY_YADRFAIL_SHIFT)) & FMUTEST_R_ADR_QUERY_YADRFAIL_MASK)

#define FMUTEST_R_ADR_QUERY_XADRFAIL_MASK        (0x1FFE0U)
#define FMUTEST_R_ADR_QUERY_XADRFAIL_SHIFT       (5U)
/*! XADRFAIL - Failing XADR */
#define FMUTEST_R_ADR_QUERY_XADRFAIL(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_QUERY_XADRFAIL_SHIFT)) & FMUTEST_R_ADR_QUERY_XADRFAIL_MASK)
/*! @} */

/*! @name R_DOUT_QUERY0 - BIST DOUT Query 0 Register */
/*! @{ */

#define FMUTEST_R_DOUT_QUERY0_DOUTFAIL_MASK      (0xFFFFFFFFU)
#define FMUTEST_R_DOUT_QUERY0_DOUTFAIL_SHIFT     (0U)
/*! DOUTFAIL - Failing DOUT Low */
#define FMUTEST_R_DOUT_QUERY0_DOUTFAIL(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DOUT_QUERY0_DOUTFAIL_SHIFT)) & FMUTEST_R_DOUT_QUERY0_DOUTFAIL_MASK)
/*! @} */

/*! @name R_SMW_QUERY - BIST SMW Query Register */
/*! @{ */

#define FMUTEST_R_SMW_QUERY_SMWLOOP_MASK         (0x3FFU)
#define FMUTEST_R_SMW_QUERY_SMWLOOP_SHIFT        (0U)
/*! SMWLOOP - SMW Total Loop Count */
#define FMUTEST_R_SMW_QUERY_SMWLOOP(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_QUERY_SMWLOOP_SHIFT)) & FMUTEST_R_SMW_QUERY_SMWLOOP_MASK)

#define FMUTEST_R_SMW_QUERY_SMWLAST_MASK         (0x7FC00U)
#define FMUTEST_R_SMW_QUERY_SMWLAST_SHIFT        (10U)
/*! SMWLAST - SMW Last Voltage Setting */
#define FMUTEST_R_SMW_QUERY_SMWLAST(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_QUERY_SMWLAST_SHIFT)) & FMUTEST_R_SMW_QUERY_SMWLAST_MASK)
/*! @} */

/*! @name R_SMW_SETTING0 - BIST SMW Setting 0 Register */
/*! @{ */

#define FMUTEST_R_SMW_SETTING0_SMWPARM0_MASK     (0x7FFFFFFFU)
#define FMUTEST_R_SMW_SETTING0_SMWPARM0_SHIFT    (0U)
/*! SMWPARM0 - SMW Parameter Set 0 */
#define FMUTEST_R_SMW_SETTING0_SMWPARM0(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_SETTING0_SMWPARM0_SHIFT)) & FMUTEST_R_SMW_SETTING0_SMWPARM0_MASK)
/*! @} */

/*! @name R_SMW_SETTING1 - BIST SMW Setting 1 Register */
/*! @{ */

#define FMUTEST_R_SMW_SETTING1_SMWPARM1_MASK     (0xFFFFFFFU)
#define FMUTEST_R_SMW_SETTING1_SMWPARM1_SHIFT    (0U)
/*! SMWPARM1 - SMW Parameter Set 1 */
#define FMUTEST_R_SMW_SETTING1_SMWPARM1(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_SETTING1_SMWPARM1_SHIFT)) & FMUTEST_R_SMW_SETTING1_SMWPARM1_MASK)
/*! @} */

/*! @name R_SMP_WHV0 - BIST SMP WHV Setting 0 Register */
/*! @{ */

#define FMUTEST_R_SMP_WHV0_SMPWHV0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_SMP_WHV0_SMPWHV0_SHIFT         (0U)
/*! SMPWHV0 - SMP WHV Parameter Set 0 */
#define FMUTEST_R_SMP_WHV0_SMPWHV0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMP_WHV0_SMPWHV0_SHIFT)) & FMUTEST_R_SMP_WHV0_SMPWHV0_MASK)
/*! @} */

/*! @name R_SMP_WHV1 - BIST SMP WHV Setting 1 Register */
/*! @{ */

#define FMUTEST_R_SMP_WHV1_SMPWHV1_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_SMP_WHV1_SMPWHV1_SHIFT         (0U)
/*! SMPWHV1 - SMP WHV Parameter Set 1 */
#define FMUTEST_R_SMP_WHV1_SMPWHV1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMP_WHV1_SMPWHV1_SHIFT)) & FMUTEST_R_SMP_WHV1_SMPWHV1_MASK)
/*! @} */

/*! @name R_SME_WHV0 - BIST SME WHV Setting 0 Register */
/*! @{ */

#define FMUTEST_R_SME_WHV0_SMEWHV0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_SME_WHV0_SMEWHV0_SHIFT         (0U)
/*! SMEWHV0 - SME WHV Parameter Set 0 */
#define FMUTEST_R_SME_WHV0_SMEWHV0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SME_WHV0_SMEWHV0_SHIFT)) & FMUTEST_R_SME_WHV0_SMEWHV0_MASK)
/*! @} */

/*! @name R_SME_WHV1 - BIST SME WHV Setting 1 Register */
/*! @{ */

#define FMUTEST_R_SME_WHV1_SMEWHV1_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_SME_WHV1_SMEWHV1_SHIFT         (0U)
/*! SMEWHV1 - SME WHV Parameter Set 1 */
#define FMUTEST_R_SME_WHV1_SMEWHV1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SME_WHV1_SMEWHV1_SHIFT)) & FMUTEST_R_SME_WHV1_SMEWHV1_MASK)
/*! @} */

/*! @name R_SMW_SETTING2 - BIST SMW Setting 2 Register */
/*! @{ */

#define FMUTEST_R_SMW_SETTING2_SMWPARM2_MASK     (0x1FFFFFFFU)
#define FMUTEST_R_SMW_SETTING2_SMWPARM2_SHIFT    (0U)
/*! SMWPARM2 - SMW Parameter Set 2 */
#define FMUTEST_R_SMW_SETTING2_SMWPARM2(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_SETTING2_SMWPARM2_SHIFT)) & FMUTEST_R_SMW_SETTING2_SMWPARM2_MASK)
/*! @} */

/*! @name R_D_MISR0 - BIST DIN MISR 0 Register */
/*! @{ */

#define FMUTEST_R_D_MISR0_DATASIG0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_D_MISR0_DATASIG0_SHIFT         (0U)
/*! DATASIG0 - Data Signature */
#define FMUTEST_R_D_MISR0_DATASIG0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_D_MISR0_DATASIG0_SHIFT)) & FMUTEST_R_D_MISR0_DATASIG0_MASK)
/*! @} */

/*! @name R_A_MISR0 - BIST Address MISR 0 Register */
/*! @{ */

#define FMUTEST_R_A_MISR0_ADRSIG0_MASK           (0xFFFFFFFFU)
#define FMUTEST_R_A_MISR0_ADRSIG0_SHIFT          (0U)
/*! ADRSIG0 - Address Signature */
#define FMUTEST_R_A_MISR0_ADRSIG0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_A_MISR0_ADRSIG0_SHIFT)) & FMUTEST_R_A_MISR0_ADRSIG0_MASK)
/*! @} */

/*! @name R_C_MISR0 - BIST Control MISR 0 Register */
/*! @{ */

#define FMUTEST_R_C_MISR0_CTRLSIG0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_C_MISR0_CTRLSIG0_SHIFT         (0U)
/*! CTRLSIG0 - Control Signature */
#define FMUTEST_R_C_MISR0_CTRLSIG0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_C_MISR0_CTRLSIG0_SHIFT)) & FMUTEST_R_C_MISR0_CTRLSIG0_MASK)
/*! @} */

/*! @name R_SMW_SETTING3 - BIST SMW Setting 3 Register */
/*! @{ */

#define FMUTEST_R_SMW_SETTING3_SMWPARM3_MASK     (0x1FFFFU)
#define FMUTEST_R_SMW_SETTING3_SMWPARM3_SHIFT    (0U)
/*! SMWPARM3 - SMW Parameter Set 3 */
#define FMUTEST_R_SMW_SETTING3_SMWPARM3(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_SETTING3_SMWPARM3_SHIFT)) & FMUTEST_R_SMW_SETTING3_SMWPARM3_MASK)
/*! @} */

/*! @name R_DATA_CTRL1 - BIST Data Control 1 Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL1_DATA1_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_DATA_CTRL1_DATA1_SHIFT         (0U)
/*! DATA1 - BIST Data 1 Low */
#define FMUTEST_R_DATA_CTRL1_DATA1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL1_DATA1_SHIFT)) & FMUTEST_R_DATA_CTRL1_DATA1_MASK)
/*! @} */

/*! @name R_DATA_CTRL2 - BIST Data Control 2 Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL2_DATA2_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_DATA_CTRL2_DATA2_SHIFT         (0U)
/*! DATA2 - BIST Data 2 Low */
#define FMUTEST_R_DATA_CTRL2_DATA2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL2_DATA2_SHIFT)) & FMUTEST_R_DATA_CTRL2_DATA2_MASK)
/*! @} */

/*! @name R_DATA_CTRL3 - BIST Data Control 3 Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL3_DATA3_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_DATA_CTRL3_DATA3_SHIFT         (0U)
/*! DATA3 - BIST Data 3 Low */
#define FMUTEST_R_DATA_CTRL3_DATA3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL3_DATA3_SHIFT)) & FMUTEST_R_DATA_CTRL3_DATA3_MASK)
/*! @} */

/*! @name R_REPAIR0_0 - BIST Repair 0 for Block 0 Register */
/*! @{ */

#define FMUTEST_R_REPAIR0_0_RDIS0_0_MASK         (0x1U)
#define FMUTEST_R_REPAIR0_0_RDIS0_0_SHIFT        (0U)
/*! RDIS0_0 - Control Repair 0 in Block 0.
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_R_REPAIR0_0_RDIS0_0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR0_0_RDIS0_0_SHIFT)) & FMUTEST_R_REPAIR0_0_RDIS0_0_MASK)

#define FMUTEST_R_REPAIR0_0_RADR0_0_MASK         (0x1FEU)
#define FMUTEST_R_REPAIR0_0_RADR0_0_SHIFT        (1U)
/*! RADR0_0 - XADR for Repair 0 in Block 0 */
#define FMUTEST_R_REPAIR0_0_RADR0_0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR0_0_RADR0_0_SHIFT)) & FMUTEST_R_REPAIR0_0_RADR0_0_MASK)
/*! @} */

/*! @name R_REPAIR0_1 - BIST Repair 1 Block 0 Register */
/*! @{ */

#define FMUTEST_R_REPAIR0_1_RDIS0_1_MASK         (0x1U)
#define FMUTEST_R_REPAIR0_1_RDIS0_1_SHIFT        (0U)
/*! RDIS0_1 - Control Repair 1 in Block 0.
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_R_REPAIR0_1_RDIS0_1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR0_1_RDIS0_1_SHIFT)) & FMUTEST_R_REPAIR0_1_RDIS0_1_MASK)

#define FMUTEST_R_REPAIR0_1_RADR0_1_MASK         (0x1FEU)
#define FMUTEST_R_REPAIR0_1_RADR0_1_SHIFT        (1U)
/*! RADR0_1 - XADR for Repair 1 in Block 0. */
#define FMUTEST_R_REPAIR0_1_RADR0_1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR0_1_RADR0_1_SHIFT)) & FMUTEST_R_REPAIR0_1_RADR0_1_MASK)
/*! @} */

/*! @name R_REPAIR1_0 - BIST Repair 0 Block 1 Register */
/*! @{ */

#define FMUTEST_R_REPAIR1_0_RDIS1_0_MASK         (0x1U)
#define FMUTEST_R_REPAIR1_0_RDIS1_0_SHIFT        (0U)
/*! RDIS1_0 - Control Repair 0 in Block 1.
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_R_REPAIR1_0_RDIS1_0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR1_0_RDIS1_0_SHIFT)) & FMUTEST_R_REPAIR1_0_RDIS1_0_MASK)

#define FMUTEST_R_REPAIR1_0_RADR1_0_MASK         (0x1FEU)
#define FMUTEST_R_REPAIR1_0_RADR1_0_SHIFT        (1U)
/*! RADR1_0 - XADR for Repair 0 in Block 1. */
#define FMUTEST_R_REPAIR1_0_RADR1_0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR1_0_RADR1_0_SHIFT)) & FMUTEST_R_REPAIR1_0_RADR1_0_MASK)
/*! @} */

/*! @name R_REPAIR1_1 - BIST Repair 1 Block 1 Register */
/*! @{ */

#define FMUTEST_R_REPAIR1_1_RDIS1_1_MASK         (0x1U)
#define FMUTEST_R_REPAIR1_1_RDIS1_1_SHIFT        (0U)
/*! RDIS1_1 - Control Repair 1 in Block 1.
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_R_REPAIR1_1_RDIS1_1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR1_1_RDIS1_1_SHIFT)) & FMUTEST_R_REPAIR1_1_RDIS1_1_MASK)

#define FMUTEST_R_REPAIR1_1_RADR1_1_MASK         (0x1FEU)
#define FMUTEST_R_REPAIR1_1_RADR1_1_SHIFT        (1U)
/*! RADR1_1 - XADR for Repair 1 in Block 1. */
#define FMUTEST_R_REPAIR1_1_RADR1_1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR1_1_RADR1_1_SHIFT)) & FMUTEST_R_REPAIR1_1_RADR1_1_MASK)
/*! @} */

/*! @name R_DATA_CTRL0_EX - BIST Data Control 0 Extension Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL0_EX_DATA0X_MASK      (0x7U)
#define FMUTEST_R_DATA_CTRL0_EX_DATA0X_SHIFT     (0U)
/*! DATA0X - BIST Data 0 High */
#define FMUTEST_R_DATA_CTRL0_EX_DATA0X(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL0_EX_DATA0X_SHIFT)) & FMUTEST_R_DATA_CTRL0_EX_DATA0X_MASK)
/*! @} */

/*! @name R_TIMER_CTRL_EX - BIST Timer Control Extension Register */
/*! @{ */

#define FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H_MASK   (0x7U)
#define FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H_SHIFT  (0U)
/*! TLVSDLY_H - Tlvs Time Delay Scalar High */
#define FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H_SHIFT)) & FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H_MASK)
/*! @} */

/*! @name R_DOUT_QUERY1 - BIST DOUT Query 1 Register */
/*! @{ */

#define FMUTEST_R_DOUT_QUERY1_DOUT_MASK          (0x7U)
#define FMUTEST_R_DOUT_QUERY1_DOUT_SHIFT         (0U)
/*! DOUT - Failing DOUT High */
#define FMUTEST_R_DOUT_QUERY1_DOUT(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DOUT_QUERY1_DOUT_SHIFT)) & FMUTEST_R_DOUT_QUERY1_DOUT_MASK)
/*! @} */

/*! @name R_D_MISR1 - BIST DIN MISR 1 Register */
/*! @{ */

#define FMUTEST_R_D_MISR1_DATASIG1_MASK          (0xFFU)
#define FMUTEST_R_D_MISR1_DATASIG1_SHIFT         (0U)
/*! DATASIG1 - MISR Data Signature High */
#define FMUTEST_R_D_MISR1_DATASIG1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_D_MISR1_DATASIG1_SHIFT)) & FMUTEST_R_D_MISR1_DATASIG1_MASK)
/*! @} */

/*! @name R_A_MISR1 - BIST Address MISR 1 Register */
/*! @{ */

#define FMUTEST_R_A_MISR1_ADRSIG1_MASK           (0xFFU)
#define FMUTEST_R_A_MISR1_ADRSIG1_SHIFT          (0U)
/*! ADRSIG1 - MISR Address Signature High */
#define FMUTEST_R_A_MISR1_ADRSIG1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_A_MISR1_ADRSIG1_SHIFT)) & FMUTEST_R_A_MISR1_ADRSIG1_MASK)
/*! @} */

/*! @name R_C_MISR1 - BIST Control MISR 1 Register */
/*! @{ */

#define FMUTEST_R_C_MISR1_CTRLSIG1_MASK          (0xFFU)
#define FMUTEST_R_C_MISR1_CTRLSIG1_SHIFT         (0U)
/*! CTRLSIG1 - MISR Control Signature High */
#define FMUTEST_R_C_MISR1_CTRLSIG1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_C_MISR1_CTRLSIG1_SHIFT)) & FMUTEST_R_C_MISR1_CTRLSIG1_MASK)
/*! @} */

/*! @name R_DATA_CTRL1_EX - BIST Data Control 1 Extension Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL1_EX_DATA1X_MASK      (0x7U)
#define FMUTEST_R_DATA_CTRL1_EX_DATA1X_SHIFT     (0U)
/*! DATA1X - BIST Data 1 High */
#define FMUTEST_R_DATA_CTRL1_EX_DATA1X(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL1_EX_DATA1X_SHIFT)) & FMUTEST_R_DATA_CTRL1_EX_DATA1X_MASK)
/*! @} */

/*! @name R_DATA_CTRL2_EX - BIST Data Control 2 Extension Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL2_EX_DATA2X_MASK      (0x7U)
#define FMUTEST_R_DATA_CTRL2_EX_DATA2X_SHIFT     (0U)
/*! DATA2X - BIST Data 2 High */
#define FMUTEST_R_DATA_CTRL2_EX_DATA2X(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL2_EX_DATA2X_SHIFT)) & FMUTEST_R_DATA_CTRL2_EX_DATA2X_MASK)
/*! @} */

/*! @name R_DATA_CTRL3_EX - BIST Data Control 3 Extension Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL3_EX_DATA3X_MASK      (0x7U)
#define FMUTEST_R_DATA_CTRL3_EX_DATA3X_SHIFT     (0U)
/*! DATA3X - BIST Data 3 High */
#define FMUTEST_R_DATA_CTRL3_EX_DATA3X(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL3_EX_DATA3X_SHIFT)) & FMUTEST_R_DATA_CTRL3_EX_DATA3X_MASK)
/*! @} */

/*! @name SMW_TIMER_OPTION - SMW Timer Option Register */
/*! @{ */

#define FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL_MASK  (0xFFU)
#define FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL_SHIFT (0U)
/*! SMW_CDIVL - Clock Divide Scalar for Long Pulse */
#define FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL_SHIFT)) & FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL_MASK)

#define FMUTEST_SMW_TIMER_OPTION_SMW_TVFY_MASK   (0x1F00U)
#define FMUTEST_SMW_TIMER_OPTION_SMW_TVFY_SHIFT  (8U)
/*! SMW_TVFY - Timer Adjust for Verify */
#define FMUTEST_SMW_TIMER_OPTION_SMW_TVFY(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_TIMER_OPTION_SMW_TVFY_SHIFT)) & FMUTEST_SMW_TIMER_OPTION_SMW_TVFY_MASK)
/*! @} */

/*! @name SMW_SETTING_OPTION0 - SMW Setting Option 0 Register */
/*! @{ */

#define FMUTEST_SMW_SETTING_OPTION0_MV_INIT_MASK (0x1C000U)
#define FMUTEST_SMW_SETTING_OPTION0_MV_INIT_SHIFT (14U)
/*! MV_INIT - Medium Voltage Level Select Initial */
#define FMUTEST_SMW_SETTING_OPTION0_MV_INIT(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_MV_INIT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_MV_INIT_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_MV_END_MASK  (0xE0000U)
#define FMUTEST_SMW_SETTING_OPTION0_MV_END_SHIFT (17U)
/*! MV_END - Medium Voltage Level Select Final */
#define FMUTEST_SMW_SETTING_OPTION0_MV_END(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_MV_END_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_MV_END_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_MV_MISC_MASK (0xF00000U)
#define FMUTEST_SMW_SETTING_OPTION0_MV_MISC_SHIFT (20U)
/*! MV_MISC - Medium Voltage Control Misc */
#define FMUTEST_SMW_SETTING_OPTION0_MV_MISC(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_MV_MISC_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_MV_MISC_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT_MASK (0x3000000U)
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT_SHIFT (24U)
/*! IPGM_INIT - Program Current Control Initial */
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_IPGM_END_MASK (0xC000000U)
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_END_SHIFT (26U)
/*! IPGM_END - Program Current Control Final */
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_END(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_IPGM_END_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_IPGM_END_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC_MASK (0x70000000U)
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC_SHIFT (28U)
/*! IPGM_MISC - Program Current Control Misc */
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC_MASK)
/*! @} */

/*! @name SMW_SETTING_OPTION2 - SMW Setting Option 2 Register */
/*! @{ */

#define FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL_MASK (0x7U)
#define FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL_SHIFT (0U)
/*! THVS_CTRL - Thvs control */
#define FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL_MASK (0x38U)
#define FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL_SHIFT (3U)
/*! TRCV_CTRL - Trcv Control */
#define FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS_MASK (0xC0U)
#define FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS_SHIFT (6U)
/*! XTRA_ERS - Number of Post Shots for SME */
#define FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM_MASK (0x300U)
#define FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM_SHIFT (8U)
/*! XTRA_PGM - Number of Post Shots for SMP */
#define FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR_MASK (0x3FC00U)
#define FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR_SHIFT (10U)
/*! WHV_CNTR - WHV Counter */
#define FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_POST_TERS_MASK (0x1C0000U)
#define FMUTEST_SMW_SETTING_OPTION2_POST_TERS_SHIFT (18U)
/*! POST_TERS - Post Ters Time
 *  0b000..50 usec
 *  0b001..100 usec
 *  0b010..200 usec
 *  0b011..300 usec
 *  0b100..500 usec
 *  0b101..1 msec
 *  0b110..1.5 msec
 *  0b111..2 msec
 */
#define FMUTEST_SMW_SETTING_OPTION2_POST_TERS(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_POST_TERS_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_POST_TERS_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_POST_TPGM_MASK (0x600000U)
#define FMUTEST_SMW_SETTING_OPTION2_POST_TPGM_SHIFT (21U)
/*! POST_TPGM - Post Tpgm Time
 *  0b00..1 usec
 *  0b01..2 usec
 *  0b10..4 usec
 *  0b11..8 usec
 */
#define FMUTEST_SMW_SETTING_OPTION2_POST_TPGM(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_POST_TPGM_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_POST_TPGM_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_VFY_OPT_MASK (0x1800000U)
#define FMUTEST_SMW_SETTING_OPTION2_VFY_OPT_SHIFT (23U)
/*! VFY_OPT - Verify Option
 *  0b00..Skip verify for post shot only, verify for all other shots
 *  0b01..Skip verify for the 1st and post shots
 *  0b10..Skip the 1st, 2nd, and post shots
 *  0b11..Skip verify for all shots
 */
#define FMUTEST_SMW_SETTING_OPTION2_VFY_OPT(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_VFY_OPT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_VFY_OPT_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT_MASK (0x6000000U)
#define FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT_SHIFT (25U)
/*! TPGM_OPT - Tpgm Option
 *  0b00..Fixed Tpgm for all shots, except post shot
 *  0b01..Increase Tpgm option by 1 for each loop until Tpgm reaches 4 usec
 *  0b10..Increase Tpgm option by 1 for each loop until Tpgm reaches 8 usec
 *  0b11..Unused
 */
#define FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT_MASK (0x8000000U)
#define FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT_SHIFT (27U)
/*! MASK0_OPT - MASK0_OPT
 *  0b0..Mask programmed bits passing PV until extra shot
 *  0b1..Always program bits even if they pass PV
 */
#define FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_DIS_PRER_MASK (0x10000000U)
#define FMUTEST_SMW_SETTING_OPTION2_DIS_PRER_SHIFT (28U)
/*! DIS_PRER - Disable pre-PV Read before First Program Shot
 *  0b0..Enable pre-PV read before first program shot
 *  0b1..Disable pre-PV read before first program shot
 */
#define FMUTEST_SMW_SETTING_OPTION2_DIS_PRER(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_DIS_PRER_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_DIS_PRER_MASK)
/*! @} */

/*! @name SMW_SETTING_OPTION3 - SMW Setting Option 3 Register */
/*! @{ */

#define FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR_MASK (0xFFU)
#define FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR_SHIFT (0U)
/*! HEM_WHV_CNTR - WHV_COUNTER for HEM-erase Cycle */
#define FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR_SHIFT)) & FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR_MASK)

#define FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS_MASK (0x1FF00U)
#define FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS_SHIFT (8U)
/*! HEM_MAX_ERS - HEM Max Erase Shot Count */
#define FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS_SHIFT)) & FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS_MASK)
/*! @} */

/*! @name SMW_SMP_WHV_OPTION0 - SMW SMP WHV Option 0 Register */
/*! @{ */

#define FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0_MASK (0xFFFFFFFFU)
#define FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0_SHIFT (0U)
/*! SMP_WHV_OPT0 - Smart Program WHV Option Low */
#define FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0_SHIFT)) & FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0_MASK)
/*! @} */

/*! @name SMW_SME_WHV_OPTION0 - SMW SME WHV Option 0 Register */
/*! @{ */

#define FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0_MASK (0xFFFFFFFFU)
#define FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0_SHIFT (0U)
/*! SME_WHV_OPT0 - Smart Erase WHV Option Low */
#define FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0_SHIFT)) & FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0_MASK)
/*! @} */

/*! @name SMW_SETTING_OPTION1 - SMW Setting Option 1 Register */
/*! @{ */

#define FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0_MASK (0x7U)
#define FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0_SHIFT (0U)
/*! TERS_CTRL0 - Ters Control
 *  0b000..50 usec
 *  0b001..100 usec
 *  0b010..200 usec
 *  0b011..300 usec
 *  0b100..500 usec
 *  0b101..1 msec
 *  0b110..1.5 msec
 *  0b111..2 msec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL_MASK (0x18U)
#define FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL_SHIFT (3U)
/*! TPGM_CTRL - Tpgm Control
 *  0b00..1 usec
 *  0b01..2 usec
 *  0b10..4 usec
 *  0b11..8 usec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL_MASK (0xE0U)
#define FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL_SHIFT (5U)
/*! TNVS_CTRL - Tnvs Control
 *  0b000..5 usec
 *  0b001..8 usec
 *  0b010..11 usec
 *  0b011..14 usec
 *  0b100..17 usec
 *  0b101..20 usec
 *  0b110..23 usec
 *  0b111..26 usec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL_MASK (0x700U)
#define FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL_SHIFT (8U)
/*! TNVH_CTRL - Tnvh Control
 *  0b000..2 usec
 *  0b001..2.5 usec
 *  0b010..3 usec
 *  0b011..3.5 usec
 *  0b100..4 usec
 *  0b101..4.5 usec
 *  0b110..5 usec
 *  0b111..5.5 usec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL_MASK (0x3800U)
#define FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL_SHIFT (11U)
/*! TPGS_CTRL - Tpgs Control
 *  0b000..1 usec
 *  0b001..2 usec
 *  0b010..3 usec
 *  0b011..4 usec
 *  0b100..5 usec
 *  0b101..6 usec
 *  0b110..7 usec
 *  0b111..8 usec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE_MASK (0x7FC000U)
#define FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE_SHIFT (14U)
/*! MAX_ERASE - Number of Erase Shots */
#define FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_MAX_PROG_MASK (0xF800000U)
#define FMUTEST_SMW_SETTING_OPTION1_MAX_PROG_SHIFT (23U)
/*! MAX_PROG - Number of Program Shots */
#define FMUTEST_SMW_SETTING_OPTION1_MAX_PROG(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_MAX_PROG_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_MAX_PROG_MASK)
/*! @} */

/*! @name SMW_SMP_WHV_OPTION1 - SMW SMP WHV Option 1 Register */
/*! @{ */

#define FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1_MASK (0xFFFFFFFFU)
#define FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1_SHIFT (0U)
/*! SMP_WHV_OPT1 - Smart Program WHV Option High */
#define FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1_SHIFT)) & FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1_MASK)
/*! @} */

/*! @name SMW_SME_WHV_OPTION1 - SMW SME WHV Option 1 Register */
/*! @{ */

#define FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1_MASK (0xFFFFFFFFU)
#define FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1_SHIFT (0U)
/*! SME_WHV_OPT1 - Smart Erase WHV Option High */
#define FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1_SHIFT)) & FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1_MASK)
/*! @} */

/*! @name REPAIR0_0 - FMU Repair 0 Block 0 Register */
/*! @{ */

#define FMUTEST_REPAIR0_0_RDIS0_0_MASK           (0x1U)
#define FMUTEST_REPAIR0_0_RDIS0_0_SHIFT          (0U)
/*! RDIS0_0 - RDIS0_0
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_REPAIR0_0_RDIS0_0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR0_0_RDIS0_0_SHIFT)) & FMUTEST_REPAIR0_0_RDIS0_0_MASK)

#define FMUTEST_REPAIR0_0_RADR0_0_MASK           (0x1FEU)
#define FMUTEST_REPAIR0_0_RADR0_0_SHIFT          (1U)
/*! RADR0_0 - RADR0_0 */
#define FMUTEST_REPAIR0_0_RADR0_0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR0_0_RADR0_0_SHIFT)) & FMUTEST_REPAIR0_0_RADR0_0_MASK)
/*! @} */

/*! @name REPAIR0_1 - FMU Repair 1 Block 0 Register */
/*! @{ */

#define FMUTEST_REPAIR0_1_RDIS0_1_MASK           (0x1U)
#define FMUTEST_REPAIR0_1_RDIS0_1_SHIFT          (0U)
/*! RDIS0_1 - RDIS0_1
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_REPAIR0_1_RDIS0_1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR0_1_RDIS0_1_SHIFT)) & FMUTEST_REPAIR0_1_RDIS0_1_MASK)

#define FMUTEST_REPAIR0_1_RADR0_1_MASK           (0x1FEU)
#define FMUTEST_REPAIR0_1_RADR0_1_SHIFT          (1U)
/*! RADR0_1 - RADR0_1 */
#define FMUTEST_REPAIR0_1_RADR0_1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR0_1_RADR0_1_SHIFT)) & FMUTEST_REPAIR0_1_RADR0_1_MASK)
/*! @} */

/*! @name REPAIR1_0 - FMU Repair 0 Block 1 Register */
/*! @{ */

#define FMUTEST_REPAIR1_0_RDIS1_0_MASK           (0x1U)
#define FMUTEST_REPAIR1_0_RDIS1_0_SHIFT          (0U)
/*! RDIS1_0 - RDIS1_0
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_REPAIR1_0_RDIS1_0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR1_0_RDIS1_0_SHIFT)) & FMUTEST_REPAIR1_0_RDIS1_0_MASK)

#define FMUTEST_REPAIR1_0_RADR1_0_MASK           (0x1FEU)
#define FMUTEST_REPAIR1_0_RADR1_0_SHIFT          (1U)
/*! RADR1_0 - RADR1_0 */
#define FMUTEST_REPAIR1_0_RADR1_0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR1_0_RADR1_0_SHIFT)) & FMUTEST_REPAIR1_0_RADR1_0_MASK)
/*! @} */

/*! @name REPAIR1_1 - FMU Repair 1 Block 1 Register */
/*! @{ */

#define FMUTEST_REPAIR1_1_RDIS1_1_MASK           (0x1U)
#define FMUTEST_REPAIR1_1_RDIS1_1_SHIFT          (0U)
/*! RDIS1_1 - RDIS1_1
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_REPAIR1_1_RDIS1_1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR1_1_RDIS1_1_SHIFT)) & FMUTEST_REPAIR1_1_RDIS1_1_MASK)

#define FMUTEST_REPAIR1_1_RADR1_1_MASK           (0x1FEU)
#define FMUTEST_REPAIR1_1_RADR1_1_SHIFT          (1U)
/*! RADR1_1 - RADR1_1 */
#define FMUTEST_REPAIR1_1_RADR1_1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR1_1_RADR1_1_SHIFT)) & FMUTEST_REPAIR1_1_RADR1_1_MASK)
/*! @} */

/*! @name SMW_HB_SIGNALS - SMW HB Signals Register */
/*! @{ */

#define FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY_MASK    (0x7U)
#define FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY_SHIFT   (0U)
/*! SMW_ARRAY - SMW Region Select
 *  0b000..Main array
 *  0b001..IFR space only or main (and REDEN space) with IFR space for mass erase
 *  0b010..IFR1 space
 *  0b100..REDEN space
 */
#define FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN1_MASK  (0x8U)
#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN1_SHIFT (3U)
/*! USER_IFREN1 - IFR1 Enable
 *  0b0..IFREN1 input to the flash array is driven LOW
 *  0b1..IFREN1 input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN1(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_IFREN1_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_IFREN1_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_PV_MASK      (0x10U)
#define FMUTEST_SMW_HB_SIGNALS_USER_PV_SHIFT     (4U)
/*! USER_PV - Program Verify
 *  0b0..PV input to the flash array is driven LOW
 *  0b1..PV input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_PV(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_PV_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_PV_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_EV_MASK      (0x20U)
#define FMUTEST_SMW_HB_SIGNALS_USER_EV_SHIFT     (5U)
/*! USER_EV - Erase Verify
 *  0b0..EV input to the flash array is driven LOW
 *  0b1..EV input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_EV(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_EV_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_EV_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN_MASK   (0x40U)
#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN_SHIFT  (6U)
/*! USER_IFREN - IFR Enable
 *  0b0..IFREN input to the flash array is driven LOW
 *  0b1..IFREN input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_IFREN_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_IFREN_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_REDEN_MASK   (0x80U)
#define FMUTEST_SMW_HB_SIGNALS_USER_REDEN_SHIFT  (7U)
/*! USER_REDEN - Repair Read Enable
 *  0b0..REDEN input to the flash array is driven LOW
 *  0b1..REDEN input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_REDEN(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_REDEN_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_REDEN_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_HEM_MASK     (0x100U)
#define FMUTEST_SMW_HB_SIGNALS_USER_HEM_SHIFT    (8U)
/*! USER_HEM - High Endurance Enable
 *  0b0..HEM input to SMW / BIST PIN_CTRL[24] is driven LOW
 *  0b1..HEM input to SMW / BIST PIN_CTRL[24] is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_HEM(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_HEM_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_HEM_MASK)
/*! @} */

/*! @name BIST_DUMP_CTRL - BIST Datadump Control Register */
/*! @{ */

#define FMUTEST_BIST_DUMP_CTRL_BIST_DONE_MASK    (0x10000U)
#define FMUTEST_BIST_DUMP_CTRL_BIST_DONE_SHIFT   (16U)
/*! BIST_DONE - BIST Done
 *  0b0..The BIST (or data dump) is running
 *  0b1..The BIST (or data dump) has completed
 */
#define FMUTEST_BIST_DUMP_CTRL_BIST_DONE(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_BIST_DONE_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_BIST_DONE_MASK)

#define FMUTEST_BIST_DUMP_CTRL_BIST_FAIL_MASK    (0x20000U)
#define FMUTEST_BIST_DUMP_CTRL_BIST_FAIL_SHIFT   (17U)
/*! BIST_FAIL - BIST Fail
 *  0b0..The last BIST operation completed successfully (or could not fail)
 *  0b1..The last BIST operation failed
 */
#define FMUTEST_BIST_DUMP_CTRL_BIST_FAIL(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_BIST_FAIL_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_BIST_FAIL_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MASK     (0x40000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_SHIFT    (18U)
/*! DATADUMP - Data Dump Enable */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG_MASK (0x80000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG_SHIFT (19U)
/*! DATADUMP_TRIG - Data Dump Trigger */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT_MASK (0x300000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT_SHIFT (20U)
/*! DATADUMP_PATT - Data Dump Pattern Select
 *  0b00..All ones
 *  0b01..All zeroes
 *  0b10..Checkerboard
 *  0b11..Inverse checkerboard
 */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN_MASK (0x400000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN_SHIFT (22U)
/*! DATADUMP_MRGEN - Data Dump Margin Enable
 *  0b0..Normal read pulse shape
 *  0b1..Margin read pulse shape
 */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE_MASK (0x800000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE_SHIFT (23U)
/*! DATADUMP_MRGTYPE - Data Dump Margin Type
 *  0b0..DIN method used
 *  0b1..TM method used
 */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE_MASK)
/*! @} */

/*! @name ATX_PIN_CTRL - ATX Pin Control Register */
/*! @{ */

#define FMUTEST_ATX_PIN_CTRL_TM_TO_ATX_MASK      (0xFFU)
#define FMUTEST_ATX_PIN_CTRL_TM_TO_ATX_SHIFT     (0U)
/*! TM_TO_ATX - TM to ATX
 *  0b00000001..TM[0] to ATX0
 *  0b00000010..TM[1] to ATX0
 *  0b00000100..TM[2] to ATX0
 *  0b00001000..TM[3] to ATX0
 *  0b00010000..TM[0] to ATX1
 *  0b00100000..TM[1] to ATX1
 *  0b01000000..TM[2] to ATX1
 *  0b10000000..TM[3] to ATX1
 */
#define FMUTEST_ATX_PIN_CTRL_TM_TO_ATX(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_ATX_PIN_CTRL_TM_TO_ATX_SHIFT)) & FMUTEST_ATX_PIN_CTRL_TM_TO_ATX_MASK)
/*! @} */

/*! @name FAILCNT - Fail Count Register */
/*! @{ */

#define FMUTEST_FAILCNT_FAILCNT_MASK             (0xFFFFFFFFU)
#define FMUTEST_FAILCNT_FAILCNT_SHIFT            (0U)
/*! FAILCNT - Fail Count */
#define FMUTEST_FAILCNT_FAILCNT(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FAILCNT_FAILCNT_SHIFT)) & FMUTEST_FAILCNT_FAILCNT_MASK)
/*! @} */

/*! @name PGM_PULSE_CNT0 - Block 0 Program Pulse Count Register */
/*! @{ */

#define FMUTEST_PGM_PULSE_CNT0_PGM_CNT0_MASK     (0xFFFFFFFFU)
#define FMUTEST_PGM_PULSE_CNT0_PGM_CNT0_SHIFT    (0U)
/*! PGM_CNT0 - Program Pulse Count */
#define FMUTEST_PGM_PULSE_CNT0_PGM_CNT0(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_PGM_PULSE_CNT0_PGM_CNT0_SHIFT)) & FMUTEST_PGM_PULSE_CNT0_PGM_CNT0_MASK)
/*! @} */

/*! @name PGM_PULSE_CNT1 - Block 1 Program Pulse Count Register */
/*! @{ */

#define FMUTEST_PGM_PULSE_CNT1_PGM_CNT1_MASK     (0xFFFFFFFFU)
#define FMUTEST_PGM_PULSE_CNT1_PGM_CNT1_SHIFT    (0U)
/*! PGM_CNT1 - Program Pulse Count */
#define FMUTEST_PGM_PULSE_CNT1_PGM_CNT1(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_PGM_PULSE_CNT1_PGM_CNT1_SHIFT)) & FMUTEST_PGM_PULSE_CNT1_PGM_CNT1_MASK)
/*! @} */

/*! @name ERS_PULSE_CNT - Erase Pulse Count Register */
/*! @{ */

#define FMUTEST_ERS_PULSE_CNT_ERS_CNT0_MASK      (0xFFFFU)
#define FMUTEST_ERS_PULSE_CNT_ERS_CNT0_SHIFT     (0U)
/*! ERS_CNT0 - Block 0 Erase Pulse Count */
#define FMUTEST_ERS_PULSE_CNT_ERS_CNT0(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_ERS_PULSE_CNT_ERS_CNT0_SHIFT)) & FMUTEST_ERS_PULSE_CNT_ERS_CNT0_MASK)

#define FMUTEST_ERS_PULSE_CNT_ERS_CNT1_MASK      (0xFFFF0000U)
#define FMUTEST_ERS_PULSE_CNT_ERS_CNT1_SHIFT     (16U)
/*! ERS_CNT1 - Block 1 Erase Pulse Count */
#define FMUTEST_ERS_PULSE_CNT_ERS_CNT1(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_ERS_PULSE_CNT_ERS_CNT1_SHIFT)) & FMUTEST_ERS_PULSE_CNT_ERS_CNT1_MASK)
/*! @} */

/*! @name MAX_PULSE_CNT - Maximum Pulse Count Register */
/*! @{ */

#define FMUTEST_MAX_PULSE_CNT_LAST_PCNT_MASK     (0x1FFU)
#define FMUTEST_MAX_PULSE_CNT_LAST_PCNT_SHIFT    (0U)
/*! LAST_PCNT - Last SMW Operation's Pulse Count */
#define FMUTEST_MAX_PULSE_CNT_LAST_PCNT(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_MAX_PULSE_CNT_LAST_PCNT_SHIFT)) & FMUTEST_MAX_PULSE_CNT_LAST_PCNT_MASK)

#define FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT_MASK   (0x1FF0000U)
#define FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT_SHIFT  (16U)
/*! MAX_ERS_CNT - Maximum Erase Pulse Count */
#define FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT_SHIFT)) & FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT_MASK)

#define FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT_MASK   (0xF8000000U)
#define FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT_SHIFT  (27U)
/*! MAX_PGM_CNT - Maximum Program Pulse Count */
#define FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT_SHIFT)) & FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT_MASK)
/*! @} */

/*! @name PORT_CTRL - Port Control Register */
/*! @{ */

#define FMUTEST_PORT_CTRL_BDONE_SEL_MASK         (0x3U)
#define FMUTEST_PORT_CTRL_BDONE_SEL_SHIFT        (0U)
/*! BDONE_SEL - BIST Done Select
 *  0b00..Select internal bist_done signal from current module instantiation
 *  0b01..Select ipt_bist_fail signal from current module instantiation
 *  0b10..Select ipt_bist_done signal from other module instantiation
 *  0b11..Select AND of internal bist_done signal from current module instantiation with ipt_bist_done signal from other module instantiation
 */
#define FMUTEST_PORT_CTRL_BDONE_SEL(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_PORT_CTRL_BDONE_SEL_SHIFT)) & FMUTEST_PORT_CTRL_BDONE_SEL_MASK)

#define FMUTEST_PORT_CTRL_BSDO_SEL_MASK          (0xCU)
#define FMUTEST_PORT_CTRL_BSDO_SEL_SHIFT         (2U)
/*! BSDO_SEL - BIST Serial Data Output Select
 *  0b00..Select internal bist_sdo signal from current module instantiation
 *  0b01..Select ipt_bist_done signal from current module instantiation
 *  0b10..Select ipt_bist_sdo signal from other module instantiation
 *  0b11..Select ipt_bist_done signal from other module instantiation
 */
#define FMUTEST_PORT_CTRL_BSDO_SEL(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_PORT_CTRL_BSDO_SEL_SHIFT)) & FMUTEST_PORT_CTRL_BSDO_SEL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FMUTEST_Register_Masks */


/* FMUTEST - Peripheral instance base addresses */
/** Peripheral FMU0TEST base address */
#define FMU0TEST_BASE                            (0x40096000u)
/** Peripheral FMU0TEST base pointer */
#define FMU0TEST                                 ((FMUTEST_Type *)FMU0TEST_BASE)
/** Array initializer of FMUTEST peripheral base addresses */
#define FMUTEST_BASE_ADDRS                       { FMU0TEST_BASE }
/** Array initializer of FMUTEST peripheral base pointers */
#define FMUTEST_BASE_PTRS                        { FMU0TEST }

/*!
 * @}
 */ /* end of group FMUTEST_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FREQME Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Peripheral_Access_Layer FREQME Peripheral Access Layer
 * @{
 */

/** FREQME - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    __I  uint32_t CTRL_R;                            /**< Control (in Read mode), offset: 0x0 */
    __O  uint32_t CTRL_W;                            /**< Control (in Write mode), offset: 0x0 */
  };
  __IO uint32_t CTRLSTAT;                          /**< Control Status, offset: 0x4 */
  __IO uint32_t MIN;                               /**< Minimum, offset: 0x8 */
  __IO uint32_t MAX;                               /**< Maximum, offset: 0xC */
} FREQME_Type;

/* ----------------------------------------------------------------------------
   -- FREQME Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Register_Masks FREQME Register Masks
 * @{
 */

/*! @name CTRL_R - Control (in Read mode) */
/*! @{ */

#define FREQME_CTRL_R_RESULT_MASK                (0x7FFFFFFFU)
#define FREQME_CTRL_R_RESULT_SHIFT               (0U)
#define FREQME_CTRL_R_RESULT(x)                  (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_R_RESULT_SHIFT)) & FREQME_CTRL_R_RESULT_MASK)

#define FREQME_CTRL_R_MEASURE_IN_PROGRESS_MASK   (0x80000000U)
#define FREQME_CTRL_R_MEASURE_IN_PROGRESS_SHIFT  (31U)
/*! MEASURE_IN_PROGRESS - Measurement In Progress
 *  0b0..Complete
 *  0b1..In progress
 */
#define FREQME_CTRL_R_MEASURE_IN_PROGRESS(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_R_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_CTRL_R_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name CTRL_W - Control (in Write mode) */
/*! @{ */

#define FREQME_CTRL_W_REF_SCALE_MASK             (0x1FU)
#define FREQME_CTRL_W_REF_SCALE_SHIFT            (0U)
/*! REF_SCALE - Reference Clock Scaling Factor */
#define FREQME_CTRL_W_REF_SCALE(x)               (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_REF_SCALE_SHIFT)) & FREQME_CTRL_W_REF_SCALE_MASK)

#define FREQME_CTRL_W_PULSE_MODE_MASK            (0x100U)
#define FREQME_CTRL_W_PULSE_MODE_SHIFT           (8U)
/*! PULSE_MODE - Pulse Width Measurement Mode Select
 *  0b0..Frequency Measurement mode
 *  0b1..Pulse Width Measurement mode
 */
#define FREQME_CTRL_W_PULSE_MODE(x)              (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_PULSE_MODE_SHIFT)) & FREQME_CTRL_W_PULSE_MODE_MASK)

#define FREQME_CTRL_W_PULSE_POL_MASK             (0x200U)
#define FREQME_CTRL_W_PULSE_POL_SHIFT            (9U)
/*! PULSE_POL - Pulse Polarity
 *  0b0..High period
 *  0b1..Low period
 */
#define FREQME_CTRL_W_PULSE_POL(x)               (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_PULSE_POL_SHIFT)) & FREQME_CTRL_W_PULSE_POL_MASK)

#define FREQME_CTRL_W_LT_MIN_INT_EN_MASK         (0x1000U)
#define FREQME_CTRL_W_LT_MIN_INT_EN_SHIFT        (12U)
/*! LT_MIN_INT_EN - Less Than Minimum Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_CTRL_W_LT_MIN_INT_EN(x)           (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_LT_MIN_INT_EN_SHIFT)) & FREQME_CTRL_W_LT_MIN_INT_EN_MASK)

#define FREQME_CTRL_W_GT_MAX_INT_EN_MASK         (0x2000U)
#define FREQME_CTRL_W_GT_MAX_INT_EN_SHIFT        (13U)
/*! GT_MAX_INT_EN - Greater Than Maximum Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_CTRL_W_GT_MAX_INT_EN(x)           (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_GT_MAX_INT_EN_SHIFT)) & FREQME_CTRL_W_GT_MAX_INT_EN_MASK)

#define FREQME_CTRL_W_RESULT_READY_INT_EN_MASK   (0x4000U)
#define FREQME_CTRL_W_RESULT_READY_INT_EN_SHIFT  (14U)
/*! RESULT_READY_INT_EN - Result Ready Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_CTRL_W_RESULT_READY_INT_EN(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_RESULT_READY_INT_EN_SHIFT)) & FREQME_CTRL_W_RESULT_READY_INT_EN_MASK)

#define FREQME_CTRL_W_CONTINUOUS_MODE_EN_MASK    (0x40000000U)
#define FREQME_CTRL_W_CONTINUOUS_MODE_EN_SHIFT   (30U)
/*! CONTINUOUS_MODE_EN - Continuous Mode Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_CTRL_W_CONTINUOUS_MODE_EN(x)      (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_CONTINUOUS_MODE_EN_SHIFT)) & FREQME_CTRL_W_CONTINUOUS_MODE_EN_MASK)

#define FREQME_CTRL_W_MEASURE_IN_PROGRESS_MASK   (0x80000000U)
#define FREQME_CTRL_W_MEASURE_IN_PROGRESS_SHIFT  (31U)
/*! MEASURE_IN_PROGRESS - Measurement In Progress
 *  0b0..Terminates measurement
 *  0b1..Initiates measurement
 */
#define FREQME_CTRL_W_MEASURE_IN_PROGRESS(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_CTRL_W_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name CTRLSTAT - Control Status */
/*! @{ */

#define FREQME_CTRLSTAT_REF_SCALE_MASK           (0x1FU)
#define FREQME_CTRLSTAT_REF_SCALE_SHIFT          (0U)
/*! REF_SCALE - Reference Scale */
#define FREQME_CTRLSTAT_REF_SCALE(x)             (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_REF_SCALE_SHIFT)) & FREQME_CTRLSTAT_REF_SCALE_MASK)

#define FREQME_CTRLSTAT_PULSE_MODE_MASK          (0x100U)
#define FREQME_CTRLSTAT_PULSE_MODE_SHIFT         (8U)
/*! PULSE_MODE - Pulse Mode
 *  0b0..Frequency Measurement mode
 *  0b1..Pulse Width Measurement mode
 */
#define FREQME_CTRLSTAT_PULSE_MODE(x)            (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_PULSE_MODE_SHIFT)) & FREQME_CTRLSTAT_PULSE_MODE_MASK)

#define FREQME_CTRLSTAT_PULSE_POL_MASK           (0x200U)
#define FREQME_CTRLSTAT_PULSE_POL_SHIFT          (9U)
/*! PULSE_POL - Pulse Polarity
 *  0b0..High period
 *  0b1..Low period
 */
#define FREQME_CTRLSTAT_PULSE_POL(x)             (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_PULSE_POL_SHIFT)) & FREQME_CTRLSTAT_PULSE_POL_MASK)

#define FREQME_CTRLSTAT_LT_MIN_INT_EN_MASK       (0x1000U)
#define FREQME_CTRLSTAT_LT_MIN_INT_EN_SHIFT      (12U)
/*! LT_MIN_INT_EN - Less Than Minimum Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FREQME_CTRLSTAT_LT_MIN_INT_EN(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_LT_MIN_INT_EN_SHIFT)) & FREQME_CTRLSTAT_LT_MIN_INT_EN_MASK)

#define FREQME_CTRLSTAT_GT_MAX_INT_EN_MASK       (0x2000U)
#define FREQME_CTRLSTAT_GT_MAX_INT_EN_SHIFT      (13U)
/*! GT_MAX_INT_EN - Greater Than Maximum Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FREQME_CTRLSTAT_GT_MAX_INT_EN(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_GT_MAX_INT_EN_SHIFT)) & FREQME_CTRLSTAT_GT_MAX_INT_EN_MASK)

#define FREQME_CTRLSTAT_RESULT_READY_INT_EN_MASK (0x4000U)
#define FREQME_CTRLSTAT_RESULT_READY_INT_EN_SHIFT (14U)
/*! RESULT_READY_INT_EN - Result Ready Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FREQME_CTRLSTAT_RESULT_READY_INT_EN(x)   (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_RESULT_READY_INT_EN_SHIFT)) & FREQME_CTRLSTAT_RESULT_READY_INT_EN_MASK)

#define FREQME_CTRLSTAT_LT_MIN_STAT_MASK         (0x1000000U)
#define FREQME_CTRLSTAT_LT_MIN_STAT_SHIFT        (24U)
/*! LT_MIN_STAT - Less Than Minimum Results Status
 *  0b0..Greater than MIN[MIN_VALUE]
 *  0b1..Less than MIN[MIN_VALUE]
 */
#define FREQME_CTRLSTAT_LT_MIN_STAT(x)           (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_LT_MIN_STAT_SHIFT)) & FREQME_CTRLSTAT_LT_MIN_STAT_MASK)

#define FREQME_CTRLSTAT_GT_MAX_STAT_MASK         (0x2000000U)
#define FREQME_CTRLSTAT_GT_MAX_STAT_SHIFT        (25U)
/*! GT_MAX_STAT - Greater Than Maximum Result Status
 *  0b0..Less than MAX[MAX_VALUE]
 *  0b1..Greater than MAX[MAX_VALUE]
 */
#define FREQME_CTRLSTAT_GT_MAX_STAT(x)           (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_GT_MAX_STAT_SHIFT)) & FREQME_CTRLSTAT_GT_MAX_STAT_MASK)

#define FREQME_CTRLSTAT_RESULT_READY_STAT_MASK   (0x4000000U)
#define FREQME_CTRLSTAT_RESULT_READY_STAT_SHIFT  (26U)
/*! RESULT_READY_STAT - Result Ready Status
 *  0b0..Not complete
 *  0b1..Complete
 */
#define FREQME_CTRLSTAT_RESULT_READY_STAT(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_RESULT_READY_STAT_SHIFT)) & FREQME_CTRLSTAT_RESULT_READY_STAT_MASK)

#define FREQME_CTRLSTAT_CONTINUOUS_MODE_EN_MASK  (0x40000000U)
#define FREQME_CTRLSTAT_CONTINUOUS_MODE_EN_SHIFT (30U)
/*! CONTINUOUS_MODE_EN - Continuous Mode Enable Status
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FREQME_CTRLSTAT_CONTINUOUS_MODE_EN(x)    (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_CONTINUOUS_MODE_EN_SHIFT)) & FREQME_CTRLSTAT_CONTINUOUS_MODE_EN_MASK)

#define FREQME_CTRLSTAT_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_CTRLSTAT_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measurement in Progress Status
 *  0b0..Not in progress
 *  0b1..In progress
 */
#define FREQME_CTRLSTAT_MEASURE_IN_PROGRESS(x)   (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_CTRLSTAT_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name MIN - Minimum */
/*! @{ */

#define FREQME_MIN_MIN_VALUE_MASK                (0x7FFFFFFFU)
#define FREQME_MIN_MIN_VALUE_SHIFT               (0U)
/*! MIN_VALUE - Minimum Value */
#define FREQME_MIN_MIN_VALUE(x)                  (((uint32_t)(((uint32_t)(x)) << FREQME_MIN_MIN_VALUE_SHIFT)) & FREQME_MIN_MIN_VALUE_MASK)
/*! @} */

/*! @name MAX - Maximum */
/*! @{ */

#define FREQME_MAX_MAX_VALUE_MASK                (0x7FFFFFFFU)
#define FREQME_MAX_MAX_VALUE_SHIFT               (0U)
/*! MAX_VALUE - Maximum Value */
#define FREQME_MAX_MAX_VALUE(x)                  (((uint32_t)(((uint32_t)(x)) << FREQME_MAX_MAX_VALUE_SHIFT)) & FREQME_MAX_MAX_VALUE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FREQME_Register_Masks */


/* FREQME - Peripheral instance base addresses */
/** Peripheral FREQME0 base address */
#define FREQME0_BASE                             (0x40009000u)
/** Peripheral FREQME0 base pointer */
#define FREQME0                                  ((FREQME_Type *)FREQME0_BASE)
/** Array initializer of FREQME peripheral base addresses */
#define FREQME_BASE_ADDRS                        { FREQME0_BASE }
/** Array initializer of FREQME peripheral base pointers */
#define FREQME_BASE_PTRS                         { FREQME0 }

/*!
 * @}
 */ /* end of group FREQME_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GLIKEY Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GLIKEY_Peripheral_Access_Layer GLIKEY Peripheral Access Layer
 * @{
 */

/** GLIKEY - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL_0;                            /**< Control Register 0 SFR, offset: 0x0 */
  __IO uint32_t CTRL_1;                            /**< Control Regsiter 1 SFR, offset: 0x4 */
  __IO uint32_t INTR_CTRL;                         /**< Interrupt Control, offset: 0x8 */
  __I  uint32_t STATUS;                            /**< Status, offset: 0xC */
       uint8_t RESERVED_0[236];
  __I  uint32_t VERSION;                           /**< IP Version, offset: 0xFC */
} GLIKEY_Type;

/* ----------------------------------------------------------------------------
   -- GLIKEY Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GLIKEY_Register_Masks GLIKEY Register Masks
 * @{
 */

/*! @name CTRL_0 - Control Register 0 SFR */
/*! @{ */

#define GLIKEY_CTRL_0_WRITE_INDEX_MASK           (0xFFU)
#define GLIKEY_CTRL_0_WRITE_INDEX_SHIFT          (0U)
/*! WRITE_INDEX - Write Index */
#define GLIKEY_CTRL_0_WRITE_INDEX(x)             (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_0_WRITE_INDEX_SHIFT)) & GLIKEY_CTRL_0_WRITE_INDEX_MASK)

#define GLIKEY_CTRL_0_RESERVED15_MASK            (0xFF00U)
#define GLIKEY_CTRL_0_RESERVED15_SHIFT           (8U)
/*! RESERVED15 - Reserved for Future Use */
#define GLIKEY_CTRL_0_RESERVED15(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_0_RESERVED15_SHIFT)) & GLIKEY_CTRL_0_RESERVED15_MASK)

#define GLIKEY_CTRL_0_WR_EN_0_MASK               (0x30000U)
#define GLIKEY_CTRL_0_WR_EN_0_SHIFT              (16U)
/*! WR_EN_0 - Write Enable 0 */
#define GLIKEY_CTRL_0_WR_EN_0(x)                 (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_0_WR_EN_0_SHIFT)) & GLIKEY_CTRL_0_WR_EN_0_MASK)

#define GLIKEY_CTRL_0_SFT_RST_MASK               (0x40000U)
#define GLIKEY_CTRL_0_SFT_RST_SHIFT              (18U)
/*! SFT_RST - Soft reset for the core reset (SFR configuration will be preseved).This register reads as 0
 *  0b0..No effect
 *  0b1..Triggers the soft reset
 */
#define GLIKEY_CTRL_0_SFT_RST(x)                 (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_0_SFT_RST_SHIFT)) & GLIKEY_CTRL_0_SFT_RST_MASK)

#define GLIKEY_CTRL_0_RESERVED31_MASK            (0xFFF80000U)
#define GLIKEY_CTRL_0_RESERVED31_SHIFT           (19U)
/*! RESERVED31 - Reserved for Future Use */
#define GLIKEY_CTRL_0_RESERVED31(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_0_RESERVED31_SHIFT)) & GLIKEY_CTRL_0_RESERVED31_MASK)
/*! @} */

/*! @name CTRL_1 - Control Regsiter 1 SFR */
/*! @{ */

#define GLIKEY_CTRL_1_READ_INDEX_MASK            (0xFFU)
#define GLIKEY_CTRL_1_READ_INDEX_SHIFT           (0U)
/*! READ_INDEX - Index status, Writing an index value to this register will request the block to return the lock status of this index. */
#define GLIKEY_CTRL_1_READ_INDEX(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_1_READ_INDEX_SHIFT)) & GLIKEY_CTRL_1_READ_INDEX_MASK)

#define GLIKEY_CTRL_1_RESERVED15_MASK            (0xFF00U)
#define GLIKEY_CTRL_1_RESERVED15_SHIFT           (8U)
/*! RESERVED15 - Reserved for Future Use */
#define GLIKEY_CTRL_1_RESERVED15(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_1_RESERVED15_SHIFT)) & GLIKEY_CTRL_1_RESERVED15_MASK)

#define GLIKEY_CTRL_1_WR_EN_1_MASK               (0x30000U)
#define GLIKEY_CTRL_1_WR_EN_1_SHIFT              (16U)
/*! WR_EN_1 - Write Enable One */
#define GLIKEY_CTRL_1_WR_EN_1(x)                 (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_1_WR_EN_1_SHIFT)) & GLIKEY_CTRL_1_WR_EN_1_MASK)

#define GLIKEY_CTRL_1_SFR_LOCK_MASK              (0x3C0000U)
#define GLIKEY_CTRL_1_SFR_LOCK_SHIFT             (18U)
/*! SFR_LOCK - LOCK register for GLIKEY */
#define GLIKEY_CTRL_1_SFR_LOCK(x)                (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_1_SFR_LOCK_SHIFT)) & GLIKEY_CTRL_1_SFR_LOCK_MASK)

#define GLIKEY_CTRL_1_RESERVED31_MASK            (0xFFC00000U)
#define GLIKEY_CTRL_1_RESERVED31_SHIFT           (22U)
/*! RESERVED31 - Reserved for Future Use */
#define GLIKEY_CTRL_1_RESERVED31(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_CTRL_1_RESERVED31_SHIFT)) & GLIKEY_CTRL_1_RESERVED31_MASK)
/*! @} */

/*! @name INTR_CTRL - Interrupt Control */
/*! @{ */

#define GLIKEY_INTR_CTRL_INT_EN_MASK             (0x1U)
#define GLIKEY_INTR_CTRL_INT_EN_SHIFT            (0U)
/*! INT_EN - Interrupt Enable. Writing a 1, Interrupt asserts on Interrupt output port */
#define GLIKEY_INTR_CTRL_INT_EN(x)               (((uint32_t)(((uint32_t)(x)) << GLIKEY_INTR_CTRL_INT_EN_SHIFT)) & GLIKEY_INTR_CTRL_INT_EN_MASK)

#define GLIKEY_INTR_CTRL_INT_CLR_MASK            (0x2U)
#define GLIKEY_INTR_CTRL_INT_CLR_SHIFT           (1U)
/*! INT_CLR - Interrupt Clear. Writing a 1 to this register creates a single interrupt clear pulse. This register reads as 0 */
#define GLIKEY_INTR_CTRL_INT_CLR(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_INTR_CTRL_INT_CLR_SHIFT)) & GLIKEY_INTR_CTRL_INT_CLR_MASK)

#define GLIKEY_INTR_CTRL_INT_SET_MASK            (0x4U)
#define GLIKEY_INTR_CTRL_INT_SET_SHIFT           (2U)
/*! INT_SET - Interrupt Set. Writing a 1 to this register asserts the interrupt. This register reads as 0
 *  0b0..No effect
 *  0b1..Triggers interrupt
 */
#define GLIKEY_INTR_CTRL_INT_SET(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_INTR_CTRL_INT_SET_SHIFT)) & GLIKEY_INTR_CTRL_INT_SET_MASK)

#define GLIKEY_INTR_CTRL_RESERVED31_MASK         (0xFFFFFFF8U)
#define GLIKEY_INTR_CTRL_RESERVED31_SHIFT        (3U)
/*! RESERVED31 - Reserved for Future Use */
#define GLIKEY_INTR_CTRL_RESERVED31(x)           (((uint32_t)(((uint32_t)(x)) << GLIKEY_INTR_CTRL_RESERVED31_SHIFT)) & GLIKEY_INTR_CTRL_RESERVED31_MASK)
/*! @} */

/*! @name STATUS - Status */
/*! @{ */

#define GLIKEY_STATUS_INT_STATUS_MASK            (0x1U)
#define GLIKEY_STATUS_INT_STATUS_SHIFT           (0U)
/*! INT_STATUS - Interrupt Status.
 *  0b0..No effect
 *  0b1..Triggers interrupt
 */
#define GLIKEY_STATUS_INT_STATUS(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_STATUS_INT_STATUS_SHIFT)) & GLIKEY_STATUS_INT_STATUS_MASK)

#define GLIKEY_STATUS_LOCK_STATUS_MASK           (0x2U)
#define GLIKEY_STATUS_LOCK_STATUS_SHIFT          (1U)
/*! LOCK_STATUS - Provides the current lock status of indexes.
 *  0b0..Current read index is not locked
 *  0b1..Current read index is locked
 */
#define GLIKEY_STATUS_LOCK_STATUS(x)             (((uint32_t)(((uint32_t)(x)) << GLIKEY_STATUS_LOCK_STATUS_SHIFT)) & GLIKEY_STATUS_LOCK_STATUS_MASK)

#define GLIKEY_STATUS_ERROR_STATUS_MASK          (0x1CU)
#define GLIKEY_STATUS_ERROR_STATUS_SHIFT         (2U)
/*! ERROR_STATUS - Status of the Error
 *  0b000..No error
 *  0b001..FSM error has occurred
 *  0b010..Write index out of the bound (OOB) error
 *  0b011..Write index OOB and FSM error
 *  0b100..Read index OOB error
 *  0b110..Write index and read index OOB error
 *  0b111..Read index OOB, write index OOB, and FSM error
 */
#define GLIKEY_STATUS_ERROR_STATUS(x)            (((uint32_t)(((uint32_t)(x)) << GLIKEY_STATUS_ERROR_STATUS_SHIFT)) & GLIKEY_STATUS_ERROR_STATUS_MASK)

#define GLIKEY_STATUS_RESERVED18_MASK            (0x7FFE0U)
#define GLIKEY_STATUS_RESERVED18_SHIFT           (5U)
/*! RESERVED18 - Reserved for Future Use */
#define GLIKEY_STATUS_RESERVED18(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_STATUS_RESERVED18_SHIFT)) & GLIKEY_STATUS_RESERVED18_MASK)

#define GLIKEY_STATUS_FSM_STATE_MASK             (0xFFF80000U)
#define GLIKEY_STATUS_FSM_STATE_SHIFT            (19U)
/*! FSM_STATE - Status of FSM */
#define GLIKEY_STATUS_FSM_STATE(x)               (((uint32_t)(((uint32_t)(x)) << GLIKEY_STATUS_FSM_STATE_SHIFT)) & GLIKEY_STATUS_FSM_STATE_MASK)
/*! @} */

/*! @name VERSION - IP Version */
/*! @{ */

#define GLIKEY_VERSION_RESERVED3_MASK            (0xFU)
#define GLIKEY_VERSION_RESERVED3_SHIFT           (0U)
/*! Reserved3 - Reserved */
#define GLIKEY_VERSION_RESERVED3(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_VERSION_RESERVED3_SHIFT)) & GLIKEY_VERSION_RESERVED3_MASK)

#define GLIKEY_VERSION_RESERVED7_MASK            (0xF0U)
#define GLIKEY_VERSION_RESERVED7_SHIFT           (4U)
/*! Reserved7 - Reserved */
#define GLIKEY_VERSION_RESERVED7(x)              (((uint32_t)(((uint32_t)(x)) << GLIKEY_VERSION_RESERVED7_SHIFT)) & GLIKEY_VERSION_RESERVED7_MASK)

#define GLIKEY_VERSION_RESERVED11_MASK           (0xF00U)
#define GLIKEY_VERSION_RESERVED11_SHIFT          (8U)
/*! Reserved11 - Reserved */
#define GLIKEY_VERSION_RESERVED11(x)             (((uint32_t)(((uint32_t)(x)) << GLIKEY_VERSION_RESERVED11_SHIFT)) & GLIKEY_VERSION_RESERVED11_MASK)

#define GLIKEY_VERSION_RESERVED15_MASK           (0xF000U)
#define GLIKEY_VERSION_RESERVED15_SHIFT          (12U)
/*! Reserved15 - Reserved */
#define GLIKEY_VERSION_RESERVED15(x)             (((uint32_t)(((uint32_t)(x)) << GLIKEY_VERSION_RESERVED15_SHIFT)) & GLIKEY_VERSION_RESERVED15_MASK)

#define GLIKEY_VERSION_RESERVED16_MASK           (0x30000U)
#define GLIKEY_VERSION_RESERVED16_SHIFT          (16U)
/*! Reserved16 - Reserved */
#define GLIKEY_VERSION_RESERVED16(x)             (((uint32_t)(((uint32_t)(x)) << GLIKEY_VERSION_RESERVED16_SHIFT)) & GLIKEY_VERSION_RESERVED16_MASK)

#define GLIKEY_VERSION_FSM_CONFIG_MASK           (0x40000U)
#define GLIKEY_VERSION_FSM_CONFIG_SHIFT          (18U)
/*! FSM_CONFIG - 0:4 step, 1:8 step */
#define GLIKEY_VERSION_FSM_CONFIG(x)             (((uint32_t)(((uint32_t)(x)) << GLIKEY_VERSION_FSM_CONFIG_SHIFT)) & GLIKEY_VERSION_FSM_CONFIG_MASK)

#define GLIKEY_VERSION_INDEX_CONFIG_MASK         (0x7F80000U)
#define GLIKEY_VERSION_INDEX_CONFIG_SHIFT        (19U)
/*! INDEX_CONFIG - Configured number of addressable indexes */
#define GLIKEY_VERSION_INDEX_CONFIG(x)           (((uint32_t)(((uint32_t)(x)) << GLIKEY_VERSION_INDEX_CONFIG_SHIFT)) & GLIKEY_VERSION_INDEX_CONFIG_MASK)

#define GLIKEY_VERSION_RESERVED31_MASK           (0xF8000000U)
#define GLIKEY_VERSION_RESERVED31_SHIFT          (27U)
/*! Reserved31 - Reserved for Future Use */
#define GLIKEY_VERSION_RESERVED31(x)             (((uint32_t)(((uint32_t)(x)) << GLIKEY_VERSION_RESERVED31_SHIFT)) & GLIKEY_VERSION_RESERVED31_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group GLIKEY_Register_Masks */


/* GLIKEY - Peripheral instance base addresses */
/** Peripheral GLIKEY0 base address */
#define GLIKEY0_BASE                             (0x40091D00u)
/** Peripheral GLIKEY0 base pointer */
#define GLIKEY0                                  ((GLIKEY_Type *)GLIKEY0_BASE)
/** Array initializer of GLIKEY peripheral base addresses */
#define GLIKEY_BASE_ADDRS                        { GLIKEY0_BASE }
/** Array initializer of GLIKEY peripheral base pointers */
#define GLIKEY_BASE_PTRS                         { GLIKEY0 }

/*!
 * @}
 */ /* end of group GLIKEY_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter, offset: 0x4 */
       uint8_t RESERVED_0[56];
  __IO uint32_t PDOR;                              /**< Port Data Output, offset: 0x40 */
  __O  uint32_t PSOR;                              /**< Port Set Output, offset: 0x44 */
  __O  uint32_t PCOR;                              /**< Port Clear Output, offset: 0x48 */
  __O  uint32_t PTOR;                              /**< Port Toggle Output, offset: 0x4C */
  __I  uint32_t PDIR;                              /**< Port Data Input, offset: 0x50 */
  __IO uint32_t PDDR;                              /**< Port Data Direction, offset: 0x54 */
  __IO uint32_t PIDR;                              /**< Port Input Disable, offset: 0x58 */
       uint8_t RESERVED_1[4];
  __IO uint8_t PDR[32];                            /**< Pin Data, array offset: 0x60, array step: 0x1 */
  __IO uint32_t ICR[32];                           /**< Interrupt Control 0..Interrupt Control 31, array offset: 0x80, array step: 0x4 */
  __O  uint32_t GICLR;                             /**< Global Interrupt Control Low, offset: 0x100 */
  __O  uint32_t GICHR;                             /**< Global Interrupt Control High, offset: 0x104 */
       uint8_t RESERVED_2[24];
  __IO uint32_t ISFR[1];                           /**< Interrupt Status Flag, array offset: 0x120, array step: 0x4 */
} GPIO_Type;

/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name VERID - Version ID */
/*! @{ */

#define GPIO_VERID_FEATURE_MASK                  (0xFFFFU)
#define GPIO_VERID_FEATURE_SHIFT                 (0U)
/*! FEATURE - Feature Specification Number
 *  0b0000000000000000..Basic implementation
 *  0b0000000000000001..Protection registers implemented
 */
#define GPIO_VERID_FEATURE(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_VERID_FEATURE_SHIFT)) & GPIO_VERID_FEATURE_MASK)

#define GPIO_VERID_MINOR_MASK                    (0xFF0000U)
#define GPIO_VERID_MINOR_SHIFT                   (16U)
/*! MINOR - Minor Version Number */
#define GPIO_VERID_MINOR(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_VERID_MINOR_SHIFT)) & GPIO_VERID_MINOR_MASK)

#define GPIO_VERID_MAJOR_MASK                    (0xFF000000U)
#define GPIO_VERID_MAJOR_SHIFT                   (24U)
/*! MAJOR - Major Version Number */
#define GPIO_VERID_MAJOR(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_VERID_MAJOR_SHIFT)) & GPIO_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter */
/*! @{ */

#define GPIO_PARAM_IRQNUM_MASK                   (0xFU)
#define GPIO_PARAM_IRQNUM_SHIFT                  (0U)
/*! IRQNUM - Interrupt Number */
#define GPIO_PARAM_IRQNUM(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_PARAM_IRQNUM_SHIFT)) & GPIO_PARAM_IRQNUM_MASK)
/*! @} */

/*! @name PDOR - Port Data Output */
/*! @{ */

#define GPIO_PDOR_PDO0_MASK                      (0x1U)
#define GPIO_PDOR_PDO0_SHIFT                     (0U)
/*! PDO0 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO0_SHIFT)) & GPIO_PDOR_PDO0_MASK)

#define GPIO_PDOR_PDO1_MASK                      (0x2U)
#define GPIO_PDOR_PDO1_SHIFT                     (1U)
/*! PDO1 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO1_SHIFT)) & GPIO_PDOR_PDO1_MASK)

#define GPIO_PDOR_PDO2_MASK                      (0x4U)
#define GPIO_PDOR_PDO2_SHIFT                     (2U)
/*! PDO2 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO2_SHIFT)) & GPIO_PDOR_PDO2_MASK)

#define GPIO_PDOR_PDO3_MASK                      (0x8U)
#define GPIO_PDOR_PDO3_SHIFT                     (3U)
/*! PDO3 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO3_SHIFT)) & GPIO_PDOR_PDO3_MASK)

#define GPIO_PDOR_PDO4_MASK                      (0x10U)
#define GPIO_PDOR_PDO4_SHIFT                     (4U)
/*! PDO4 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO4_SHIFT)) & GPIO_PDOR_PDO4_MASK)

#define GPIO_PDOR_PDO5_MASK                      (0x20U)
#define GPIO_PDOR_PDO5_SHIFT                     (5U)
/*! PDO5 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO5_SHIFT)) & GPIO_PDOR_PDO5_MASK)

#define GPIO_PDOR_PDO6_MASK                      (0x40U)
#define GPIO_PDOR_PDO6_SHIFT                     (6U)
/*! PDO6 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO6_SHIFT)) & GPIO_PDOR_PDO6_MASK)

#define GPIO_PDOR_PDO7_MASK                      (0x80U)
#define GPIO_PDOR_PDO7_SHIFT                     (7U)
/*! PDO7 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO7_SHIFT)) & GPIO_PDOR_PDO7_MASK)

#define GPIO_PDOR_PDO8_MASK                      (0x100U)
#define GPIO_PDOR_PDO8_SHIFT                     (8U)
/*! PDO8 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO8_SHIFT)) & GPIO_PDOR_PDO8_MASK)

#define GPIO_PDOR_PDO9_MASK                      (0x200U)
#define GPIO_PDOR_PDO9_SHIFT                     (9U)
/*! PDO9 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO9_SHIFT)) & GPIO_PDOR_PDO9_MASK)

#define GPIO_PDOR_PDO10_MASK                     (0x400U)
#define GPIO_PDOR_PDO10_SHIFT                    (10U)
/*! PDO10 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO10_SHIFT)) & GPIO_PDOR_PDO10_MASK)

#define GPIO_PDOR_PDO11_MASK                     (0x800U)
#define GPIO_PDOR_PDO11_SHIFT                    (11U)
/*! PDO11 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO11_SHIFT)) & GPIO_PDOR_PDO11_MASK)

#define GPIO_PDOR_PDO12_MASK                     (0x1000U)
#define GPIO_PDOR_PDO12_SHIFT                    (12U)
/*! PDO12 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO12_SHIFT)) & GPIO_PDOR_PDO12_MASK)

#define GPIO_PDOR_PDO13_MASK                     (0x2000U)
#define GPIO_PDOR_PDO13_SHIFT                    (13U)
/*! PDO13 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO13_SHIFT)) & GPIO_PDOR_PDO13_MASK)

#define GPIO_PDOR_PDO14_MASK                     (0x4000U)
#define GPIO_PDOR_PDO14_SHIFT                    (14U)
/*! PDO14 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO14_SHIFT)) & GPIO_PDOR_PDO14_MASK)

#define GPIO_PDOR_PDO15_MASK                     (0x8000U)
#define GPIO_PDOR_PDO15_SHIFT                    (15U)
/*! PDO15 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO15_SHIFT)) & GPIO_PDOR_PDO15_MASK)

#define GPIO_PDOR_PDO16_MASK                     (0x10000U)
#define GPIO_PDOR_PDO16_SHIFT                    (16U)
/*! PDO16 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO16_SHIFT)) & GPIO_PDOR_PDO16_MASK)

#define GPIO_PDOR_PDO17_MASK                     (0x20000U)
#define GPIO_PDOR_PDO17_SHIFT                    (17U)
/*! PDO17 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO17_SHIFT)) & GPIO_PDOR_PDO17_MASK)

#define GPIO_PDOR_PDO18_MASK                     (0x40000U)
#define GPIO_PDOR_PDO18_SHIFT                    (18U)
/*! PDO18 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO18_SHIFT)) & GPIO_PDOR_PDO18_MASK)

#define GPIO_PDOR_PDO19_MASK                     (0x80000U)
#define GPIO_PDOR_PDO19_SHIFT                    (19U)
/*! PDO19 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO19_SHIFT)) & GPIO_PDOR_PDO19_MASK)

#define GPIO_PDOR_PDO20_MASK                     (0x100000U)
#define GPIO_PDOR_PDO20_SHIFT                    (20U)
/*! PDO20 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO20_SHIFT)) & GPIO_PDOR_PDO20_MASK)

#define GPIO_PDOR_PDO21_MASK                     (0x200000U)
#define GPIO_PDOR_PDO21_SHIFT                    (21U)
/*! PDO21 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO21_SHIFT)) & GPIO_PDOR_PDO21_MASK)

#define GPIO_PDOR_PDO22_MASK                     (0x400000U)
#define GPIO_PDOR_PDO22_SHIFT                    (22U)
/*! PDO22 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO22_SHIFT)) & GPIO_PDOR_PDO22_MASK)

#define GPIO_PDOR_PDO23_MASK                     (0x800000U)
#define GPIO_PDOR_PDO23_SHIFT                    (23U)
/*! PDO23 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO23_SHIFT)) & GPIO_PDOR_PDO23_MASK)

#define GPIO_PDOR_PDO24_MASK                     (0x1000000U)
#define GPIO_PDOR_PDO24_SHIFT                    (24U)
/*! PDO24 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO24_SHIFT)) & GPIO_PDOR_PDO24_MASK)

#define GPIO_PDOR_PDO25_MASK                     (0x2000000U)
#define GPIO_PDOR_PDO25_SHIFT                    (25U)
/*! PDO25 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO25_SHIFT)) & GPIO_PDOR_PDO25_MASK)

#define GPIO_PDOR_PDO26_MASK                     (0x4000000U)
#define GPIO_PDOR_PDO26_SHIFT                    (26U)
/*! PDO26 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO26_SHIFT)) & GPIO_PDOR_PDO26_MASK)

#define GPIO_PDOR_PDO27_MASK                     (0x8000000U)
#define GPIO_PDOR_PDO27_SHIFT                    (27U)
/*! PDO27 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO27_SHIFT)) & GPIO_PDOR_PDO27_MASK)

#define GPIO_PDOR_PDO28_MASK                     (0x10000000U)
#define GPIO_PDOR_PDO28_SHIFT                    (28U)
/*! PDO28 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO28_SHIFT)) & GPIO_PDOR_PDO28_MASK)

#define GPIO_PDOR_PDO29_MASK                     (0x20000000U)
#define GPIO_PDOR_PDO29_SHIFT                    (29U)
/*! PDO29 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO29_SHIFT)) & GPIO_PDOR_PDO29_MASK)

#define GPIO_PDOR_PDO30_MASK                     (0x40000000U)
#define GPIO_PDOR_PDO30_SHIFT                    (30U)
/*! PDO30 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO30_SHIFT)) & GPIO_PDOR_PDO30_MASK)

#define GPIO_PDOR_PDO31_MASK                     (0x80000000U)
#define GPIO_PDOR_PDO31_SHIFT                    (31U)
/*! PDO31 - Port Data Output
 *  0b0..Logic level 0
 *  0b1..Logic level 1
 */
#define GPIO_PDOR_PDO31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO31_SHIFT)) & GPIO_PDOR_PDO31_MASK)
/*! @} */

/*! @name PSOR - Port Set Output */
/*! @{ */

#define GPIO_PSOR_PTSO0_MASK                     (0x1U)
#define GPIO_PSOR_PTSO0_SHIFT                    (0U)
/*! PTSO0 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO0(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO0_SHIFT)) & GPIO_PSOR_PTSO0_MASK)

#define GPIO_PSOR_PTSO1_MASK                     (0x2U)
#define GPIO_PSOR_PTSO1_SHIFT                    (1U)
/*! PTSO1 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO1(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO1_SHIFT)) & GPIO_PSOR_PTSO1_MASK)

#define GPIO_PSOR_PTSO2_MASK                     (0x4U)
#define GPIO_PSOR_PTSO2_SHIFT                    (2U)
/*! PTSO2 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO2(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO2_SHIFT)) & GPIO_PSOR_PTSO2_MASK)

#define GPIO_PSOR_PTSO3_MASK                     (0x8U)
#define GPIO_PSOR_PTSO3_SHIFT                    (3U)
/*! PTSO3 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO3(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO3_SHIFT)) & GPIO_PSOR_PTSO3_MASK)

#define GPIO_PSOR_PTSO4_MASK                     (0x10U)
#define GPIO_PSOR_PTSO4_SHIFT                    (4U)
/*! PTSO4 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO4(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO4_SHIFT)) & GPIO_PSOR_PTSO4_MASK)

#define GPIO_PSOR_PTSO5_MASK                     (0x20U)
#define GPIO_PSOR_PTSO5_SHIFT                    (5U)
/*! PTSO5 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO5(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO5_SHIFT)) & GPIO_PSOR_PTSO5_MASK)

#define GPIO_PSOR_PTSO6_MASK                     (0x40U)
#define GPIO_PSOR_PTSO6_SHIFT                    (6U)
/*! PTSO6 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO6(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO6_SHIFT)) & GPIO_PSOR_PTSO6_MASK)

#define GPIO_PSOR_PTSO7_MASK                     (0x80U)
#define GPIO_PSOR_PTSO7_SHIFT                    (7U)
/*! PTSO7 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO7(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO7_SHIFT)) & GPIO_PSOR_PTSO7_MASK)

#define GPIO_PSOR_PTSO8_MASK                     (0x100U)
#define GPIO_PSOR_PTSO8_SHIFT                    (8U)
/*! PTSO8 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO8(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO8_SHIFT)) & GPIO_PSOR_PTSO8_MASK)

#define GPIO_PSOR_PTSO9_MASK                     (0x200U)
#define GPIO_PSOR_PTSO9_SHIFT                    (9U)
/*! PTSO9 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO9(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO9_SHIFT)) & GPIO_PSOR_PTSO9_MASK)

#define GPIO_PSOR_PTSO10_MASK                    (0x400U)
#define GPIO_PSOR_PTSO10_SHIFT                   (10U)
/*! PTSO10 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO10(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO10_SHIFT)) & GPIO_PSOR_PTSO10_MASK)

#define GPIO_PSOR_PTSO11_MASK                    (0x800U)
#define GPIO_PSOR_PTSO11_SHIFT                   (11U)
/*! PTSO11 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO11(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO11_SHIFT)) & GPIO_PSOR_PTSO11_MASK)

#define GPIO_PSOR_PTSO12_MASK                    (0x1000U)
#define GPIO_PSOR_PTSO12_SHIFT                   (12U)
/*! PTSO12 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO12(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO12_SHIFT)) & GPIO_PSOR_PTSO12_MASK)

#define GPIO_PSOR_PTSO13_MASK                    (0x2000U)
#define GPIO_PSOR_PTSO13_SHIFT                   (13U)
/*! PTSO13 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO13(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO13_SHIFT)) & GPIO_PSOR_PTSO13_MASK)

#define GPIO_PSOR_PTSO14_MASK                    (0x4000U)
#define GPIO_PSOR_PTSO14_SHIFT                   (14U)
/*! PTSO14 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO14(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO14_SHIFT)) & GPIO_PSOR_PTSO14_MASK)

#define GPIO_PSOR_PTSO15_MASK                    (0x8000U)
#define GPIO_PSOR_PTSO15_SHIFT                   (15U)
/*! PTSO15 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO15(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO15_SHIFT)) & GPIO_PSOR_PTSO15_MASK)

#define GPIO_PSOR_PTSO16_MASK                    (0x10000U)
#define GPIO_PSOR_PTSO16_SHIFT                   (16U)
/*! PTSO16 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO16(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO16_SHIFT)) & GPIO_PSOR_PTSO16_MASK)

#define GPIO_PSOR_PTSO17_MASK                    (0x20000U)
#define GPIO_PSOR_PTSO17_SHIFT                   (17U)
/*! PTSO17 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO17(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO17_SHIFT)) & GPIO_PSOR_PTSO17_MASK)

#define GPIO_PSOR_PTSO18_MASK                    (0x40000U)
#define GPIO_PSOR_PTSO18_SHIFT                   (18U)
/*! PTSO18 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO18(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO18_SHIFT)) & GPIO_PSOR_PTSO18_MASK)

#define GPIO_PSOR_PTSO19_MASK                    (0x80000U)
#define GPIO_PSOR_PTSO19_SHIFT                   (19U)
/*! PTSO19 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO19(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO19_SHIFT)) & GPIO_PSOR_PTSO19_MASK)

#define GPIO_PSOR_PTSO20_MASK                    (0x100000U)
#define GPIO_PSOR_PTSO20_SHIFT                   (20U)
/*! PTSO20 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO20(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO20_SHIFT)) & GPIO_PSOR_PTSO20_MASK)

#define GPIO_PSOR_PTSO21_MASK                    (0x200000U)
#define GPIO_PSOR_PTSO21_SHIFT                   (21U)
/*! PTSO21 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO21(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO21_SHIFT)) & GPIO_PSOR_PTSO21_MASK)

#define GPIO_PSOR_PTSO22_MASK                    (0x400000U)
#define GPIO_PSOR_PTSO22_SHIFT                   (22U)
/*! PTSO22 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO22(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO22_SHIFT)) & GPIO_PSOR_PTSO22_MASK)

#define GPIO_PSOR_PTSO23_MASK                    (0x800000U)
#define GPIO_PSOR_PTSO23_SHIFT                   (23U)
/*! PTSO23 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO23(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO23_SHIFT)) & GPIO_PSOR_PTSO23_MASK)

#define GPIO_PSOR_PTSO24_MASK                    (0x1000000U)
#define GPIO_PSOR_PTSO24_SHIFT                   (24U)
/*! PTSO24 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO24(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO24_SHIFT)) & GPIO_PSOR_PTSO24_MASK)

#define GPIO_PSOR_PTSO25_MASK                    (0x2000000U)
#define GPIO_PSOR_PTSO25_SHIFT                   (25U)
/*! PTSO25 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO25(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO25_SHIFT)) & GPIO_PSOR_PTSO25_MASK)

#define GPIO_PSOR_PTSO26_MASK                    (0x4000000U)
#define GPIO_PSOR_PTSO26_SHIFT                   (26U)
/*! PTSO26 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO26(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO26_SHIFT)) & GPIO_PSOR_PTSO26_MASK)

#define GPIO_PSOR_PTSO27_MASK                    (0x8000000U)
#define GPIO_PSOR_PTSO27_SHIFT                   (27U)
/*! PTSO27 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO27(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO27_SHIFT)) & GPIO_PSOR_PTSO27_MASK)

#define GPIO_PSOR_PTSO28_MASK                    (0x10000000U)
#define GPIO_PSOR_PTSO28_SHIFT                   (28U)
/*! PTSO28 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO28(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO28_SHIFT)) & GPIO_PSOR_PTSO28_MASK)

#define GPIO_PSOR_PTSO29_MASK                    (0x20000000U)
#define GPIO_PSOR_PTSO29_SHIFT                   (29U)
/*! PTSO29 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO29(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO29_SHIFT)) & GPIO_PSOR_PTSO29_MASK)

#define GPIO_PSOR_PTSO30_MASK                    (0x40000000U)
#define GPIO_PSOR_PTSO30_SHIFT                   (30U)
/*! PTSO30 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO30(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO30_SHIFT)) & GPIO_PSOR_PTSO30_MASK)

#define GPIO_PSOR_PTSO31_MASK                    (0x80000000U)
#define GPIO_PSOR_PTSO31_SHIFT                   (31U)
/*! PTSO31 - Port Set Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 1
 */
#define GPIO_PSOR_PTSO31(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO31_SHIFT)) & GPIO_PSOR_PTSO31_MASK)
/*! @} */

/*! @name PCOR - Port Clear Output */
/*! @{ */

#define GPIO_PCOR_PTCO0_MASK                     (0x1U)
#define GPIO_PCOR_PTCO0_SHIFT                    (0U)
/*! PTCO0 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO0(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO0_SHIFT)) & GPIO_PCOR_PTCO0_MASK)

#define GPIO_PCOR_PTCO1_MASK                     (0x2U)
#define GPIO_PCOR_PTCO1_SHIFT                    (1U)
/*! PTCO1 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO1(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO1_SHIFT)) & GPIO_PCOR_PTCO1_MASK)

#define GPIO_PCOR_PTCO2_MASK                     (0x4U)
#define GPIO_PCOR_PTCO2_SHIFT                    (2U)
/*! PTCO2 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO2(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO2_SHIFT)) & GPIO_PCOR_PTCO2_MASK)

#define GPIO_PCOR_PTCO3_MASK                     (0x8U)
#define GPIO_PCOR_PTCO3_SHIFT                    (3U)
/*! PTCO3 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO3(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO3_SHIFT)) & GPIO_PCOR_PTCO3_MASK)

#define GPIO_PCOR_PTCO4_MASK                     (0x10U)
#define GPIO_PCOR_PTCO4_SHIFT                    (4U)
/*! PTCO4 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO4(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO4_SHIFT)) & GPIO_PCOR_PTCO4_MASK)

#define GPIO_PCOR_PTCO5_MASK                     (0x20U)
#define GPIO_PCOR_PTCO5_SHIFT                    (5U)
/*! PTCO5 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO5(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO5_SHIFT)) & GPIO_PCOR_PTCO5_MASK)

#define GPIO_PCOR_PTCO6_MASK                     (0x40U)
#define GPIO_PCOR_PTCO6_SHIFT                    (6U)
/*! PTCO6 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO6(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO6_SHIFT)) & GPIO_PCOR_PTCO6_MASK)

#define GPIO_PCOR_PTCO7_MASK                     (0x80U)
#define GPIO_PCOR_PTCO7_SHIFT                    (7U)
/*! PTCO7 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO7(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO7_SHIFT)) & GPIO_PCOR_PTCO7_MASK)

#define GPIO_PCOR_PTCO8_MASK                     (0x100U)
#define GPIO_PCOR_PTCO8_SHIFT                    (8U)
/*! PTCO8 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO8(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO8_SHIFT)) & GPIO_PCOR_PTCO8_MASK)

#define GPIO_PCOR_PTCO9_MASK                     (0x200U)
#define GPIO_PCOR_PTCO9_SHIFT                    (9U)
/*! PTCO9 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO9(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO9_SHIFT)) & GPIO_PCOR_PTCO9_MASK)

#define GPIO_PCOR_PTCO10_MASK                    (0x400U)
#define GPIO_PCOR_PTCO10_SHIFT                   (10U)
/*! PTCO10 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO10(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO10_SHIFT)) & GPIO_PCOR_PTCO10_MASK)

#define GPIO_PCOR_PTCO11_MASK                    (0x800U)
#define GPIO_PCOR_PTCO11_SHIFT                   (11U)
/*! PTCO11 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO11(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO11_SHIFT)) & GPIO_PCOR_PTCO11_MASK)

#define GPIO_PCOR_PTCO12_MASK                    (0x1000U)
#define GPIO_PCOR_PTCO12_SHIFT                   (12U)
/*! PTCO12 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO12(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO12_SHIFT)) & GPIO_PCOR_PTCO12_MASK)

#define GPIO_PCOR_PTCO13_MASK                    (0x2000U)
#define GPIO_PCOR_PTCO13_SHIFT                   (13U)
/*! PTCO13 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO13(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO13_SHIFT)) & GPIO_PCOR_PTCO13_MASK)

#define GPIO_PCOR_PTCO14_MASK                    (0x4000U)
#define GPIO_PCOR_PTCO14_SHIFT                   (14U)
/*! PTCO14 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO14(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO14_SHIFT)) & GPIO_PCOR_PTCO14_MASK)

#define GPIO_PCOR_PTCO15_MASK                    (0x8000U)
#define GPIO_PCOR_PTCO15_SHIFT                   (15U)
/*! PTCO15 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO15(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO15_SHIFT)) & GPIO_PCOR_PTCO15_MASK)

#define GPIO_PCOR_PTCO16_MASK                    (0x10000U)
#define GPIO_PCOR_PTCO16_SHIFT                   (16U)
/*! PTCO16 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO16(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO16_SHIFT)) & GPIO_PCOR_PTCO16_MASK)

#define GPIO_PCOR_PTCO17_MASK                    (0x20000U)
#define GPIO_PCOR_PTCO17_SHIFT                   (17U)
/*! PTCO17 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO17(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO17_SHIFT)) & GPIO_PCOR_PTCO17_MASK)

#define GPIO_PCOR_PTCO18_MASK                    (0x40000U)
#define GPIO_PCOR_PTCO18_SHIFT                   (18U)
/*! PTCO18 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO18(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO18_SHIFT)) & GPIO_PCOR_PTCO18_MASK)

#define GPIO_PCOR_PTCO19_MASK                    (0x80000U)
#define GPIO_PCOR_PTCO19_SHIFT                   (19U)
/*! PTCO19 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO19(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO19_SHIFT)) & GPIO_PCOR_PTCO19_MASK)

#define GPIO_PCOR_PTCO20_MASK                    (0x100000U)
#define GPIO_PCOR_PTCO20_SHIFT                   (20U)
/*! PTCO20 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO20(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO20_SHIFT)) & GPIO_PCOR_PTCO20_MASK)

#define GPIO_PCOR_PTCO21_MASK                    (0x200000U)
#define GPIO_PCOR_PTCO21_SHIFT                   (21U)
/*! PTCO21 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO21(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO21_SHIFT)) & GPIO_PCOR_PTCO21_MASK)

#define GPIO_PCOR_PTCO22_MASK                    (0x400000U)
#define GPIO_PCOR_PTCO22_SHIFT                   (22U)
/*! PTCO22 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO22(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO22_SHIFT)) & GPIO_PCOR_PTCO22_MASK)

#define GPIO_PCOR_PTCO23_MASK                    (0x800000U)
#define GPIO_PCOR_PTCO23_SHIFT                   (23U)
/*! PTCO23 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO23(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO23_SHIFT)) & GPIO_PCOR_PTCO23_MASK)

#define GPIO_PCOR_PTCO24_MASK                    (0x1000000U)
#define GPIO_PCOR_PTCO24_SHIFT                   (24U)
/*! PTCO24 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO24(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO24_SHIFT)) & GPIO_PCOR_PTCO24_MASK)

#define GPIO_PCOR_PTCO25_MASK                    (0x2000000U)
#define GPIO_PCOR_PTCO25_SHIFT                   (25U)
/*! PTCO25 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO25(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO25_SHIFT)) & GPIO_PCOR_PTCO25_MASK)

#define GPIO_PCOR_PTCO26_MASK                    (0x4000000U)
#define GPIO_PCOR_PTCO26_SHIFT                   (26U)
/*! PTCO26 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO26(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO26_SHIFT)) & GPIO_PCOR_PTCO26_MASK)

#define GPIO_PCOR_PTCO27_MASK                    (0x8000000U)
#define GPIO_PCOR_PTCO27_SHIFT                   (27U)
/*! PTCO27 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO27(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO27_SHIFT)) & GPIO_PCOR_PTCO27_MASK)

#define GPIO_PCOR_PTCO28_MASK                    (0x10000000U)
#define GPIO_PCOR_PTCO28_SHIFT                   (28U)
/*! PTCO28 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO28(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO28_SHIFT)) & GPIO_PCOR_PTCO28_MASK)

#define GPIO_PCOR_PTCO29_MASK                    (0x20000000U)
#define GPIO_PCOR_PTCO29_SHIFT                   (29U)
/*! PTCO29 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO29(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO29_SHIFT)) & GPIO_PCOR_PTCO29_MASK)

#define GPIO_PCOR_PTCO30_MASK                    (0x40000000U)
#define GPIO_PCOR_PTCO30_SHIFT                   (30U)
/*! PTCO30 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO30(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO30_SHIFT)) & GPIO_PCOR_PTCO30_MASK)

#define GPIO_PCOR_PTCO31_MASK                    (0x80000000U)
#define GPIO_PCOR_PTCO31_SHIFT                   (31U)
/*! PTCO31 - Port Clear Output
 *  0b0..No change
 *  0b1..Corresponding field in PDOR becomes 0
 */
#define GPIO_PCOR_PTCO31(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO31_SHIFT)) & GPIO_PCOR_PTCO31_MASK)
/*! @} */

/*! @name PTOR - Port Toggle Output */
/*! @{ */

#define GPIO_PTOR_PTTO0_MASK                     (0x1U)
#define GPIO_PTOR_PTTO0_SHIFT                    (0U)
/*! PTTO0 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO0(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO0_SHIFT)) & GPIO_PTOR_PTTO0_MASK)

#define GPIO_PTOR_PTTO1_MASK                     (0x2U)
#define GPIO_PTOR_PTTO1_SHIFT                    (1U)
/*! PTTO1 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO1(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO1_SHIFT)) & GPIO_PTOR_PTTO1_MASK)

#define GPIO_PTOR_PTTO2_MASK                     (0x4U)
#define GPIO_PTOR_PTTO2_SHIFT                    (2U)
/*! PTTO2 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO2(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO2_SHIFT)) & GPIO_PTOR_PTTO2_MASK)

#define GPIO_PTOR_PTTO3_MASK                     (0x8U)
#define GPIO_PTOR_PTTO3_SHIFT                    (3U)
/*! PTTO3 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO3(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO3_SHIFT)) & GPIO_PTOR_PTTO3_MASK)

#define GPIO_PTOR_PTTO4_MASK                     (0x10U)
#define GPIO_PTOR_PTTO4_SHIFT                    (4U)
/*! PTTO4 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO4(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO4_SHIFT)) & GPIO_PTOR_PTTO4_MASK)

#define GPIO_PTOR_PTTO5_MASK                     (0x20U)
#define GPIO_PTOR_PTTO5_SHIFT                    (5U)
/*! PTTO5 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO5(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO5_SHIFT)) & GPIO_PTOR_PTTO5_MASK)

#define GPIO_PTOR_PTTO6_MASK                     (0x40U)
#define GPIO_PTOR_PTTO6_SHIFT                    (6U)
/*! PTTO6 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO6(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO6_SHIFT)) & GPIO_PTOR_PTTO6_MASK)

#define GPIO_PTOR_PTTO7_MASK                     (0x80U)
#define GPIO_PTOR_PTTO7_SHIFT                    (7U)
/*! PTTO7 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO7(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO7_SHIFT)) & GPIO_PTOR_PTTO7_MASK)

#define GPIO_PTOR_PTTO8_MASK                     (0x100U)
#define GPIO_PTOR_PTTO8_SHIFT                    (8U)
/*! PTTO8 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO8(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO8_SHIFT)) & GPIO_PTOR_PTTO8_MASK)

#define GPIO_PTOR_PTTO9_MASK                     (0x200U)
#define GPIO_PTOR_PTTO9_SHIFT                    (9U)
/*! PTTO9 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO9(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO9_SHIFT)) & GPIO_PTOR_PTTO9_MASK)

#define GPIO_PTOR_PTTO10_MASK                    (0x400U)
#define GPIO_PTOR_PTTO10_SHIFT                   (10U)
/*! PTTO10 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO10(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO10_SHIFT)) & GPIO_PTOR_PTTO10_MASK)

#define GPIO_PTOR_PTTO11_MASK                    (0x800U)
#define GPIO_PTOR_PTTO11_SHIFT                   (11U)
/*! PTTO11 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO11(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO11_SHIFT)) & GPIO_PTOR_PTTO11_MASK)

#define GPIO_PTOR_PTTO12_MASK                    (0x1000U)
#define GPIO_PTOR_PTTO12_SHIFT                   (12U)
/*! PTTO12 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO12(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO12_SHIFT)) & GPIO_PTOR_PTTO12_MASK)

#define GPIO_PTOR_PTTO13_MASK                    (0x2000U)
#define GPIO_PTOR_PTTO13_SHIFT                   (13U)
/*! PTTO13 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO13(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO13_SHIFT)) & GPIO_PTOR_PTTO13_MASK)

#define GPIO_PTOR_PTTO14_MASK                    (0x4000U)
#define GPIO_PTOR_PTTO14_SHIFT                   (14U)
/*! PTTO14 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO14(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO14_SHIFT)) & GPIO_PTOR_PTTO14_MASK)

#define GPIO_PTOR_PTTO15_MASK                    (0x8000U)
#define GPIO_PTOR_PTTO15_SHIFT                   (15U)
/*! PTTO15 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO15(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO15_SHIFT)) & GPIO_PTOR_PTTO15_MASK)

#define GPIO_PTOR_PTTO16_MASK                    (0x10000U)
#define GPIO_PTOR_PTTO16_SHIFT                   (16U)
/*! PTTO16 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO16(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO16_SHIFT)) & GPIO_PTOR_PTTO16_MASK)

#define GPIO_PTOR_PTTO17_MASK                    (0x20000U)
#define GPIO_PTOR_PTTO17_SHIFT                   (17U)
/*! PTTO17 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO17(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO17_SHIFT)) & GPIO_PTOR_PTTO17_MASK)

#define GPIO_PTOR_PTTO18_MASK                    (0x40000U)
#define GPIO_PTOR_PTTO18_SHIFT                   (18U)
/*! PTTO18 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO18(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO18_SHIFT)) & GPIO_PTOR_PTTO18_MASK)

#define GPIO_PTOR_PTTO19_MASK                    (0x80000U)
#define GPIO_PTOR_PTTO19_SHIFT                   (19U)
/*! PTTO19 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO19(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO19_SHIFT)) & GPIO_PTOR_PTTO19_MASK)

#define GPIO_PTOR_PTTO20_MASK                    (0x100000U)
#define GPIO_PTOR_PTTO20_SHIFT                   (20U)
/*! PTTO20 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO20(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO20_SHIFT)) & GPIO_PTOR_PTTO20_MASK)

#define GPIO_PTOR_PTTO21_MASK                    (0x200000U)
#define GPIO_PTOR_PTTO21_SHIFT                   (21U)
/*! PTTO21 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO21(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO21_SHIFT)) & GPIO_PTOR_PTTO21_MASK)

#define GPIO_PTOR_PTTO22_MASK                    (0x400000U)
#define GPIO_PTOR_PTTO22_SHIFT                   (22U)
/*! PTTO22 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO22(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO22_SHIFT)) & GPIO_PTOR_PTTO22_MASK)

#define GPIO_PTOR_PTTO23_MASK                    (0x800000U)
#define GPIO_PTOR_PTTO23_SHIFT                   (23U)
/*! PTTO23 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO23(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO23_SHIFT)) & GPIO_PTOR_PTTO23_MASK)

#define GPIO_PTOR_PTTO24_MASK                    (0x1000000U)
#define GPIO_PTOR_PTTO24_SHIFT                   (24U)
/*! PTTO24 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO24(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO24_SHIFT)) & GPIO_PTOR_PTTO24_MASK)

#define GPIO_PTOR_PTTO25_MASK                    (0x2000000U)
#define GPIO_PTOR_PTTO25_SHIFT                   (25U)
/*! PTTO25 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO25(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO25_SHIFT)) & GPIO_PTOR_PTTO25_MASK)

#define GPIO_PTOR_PTTO26_MASK                    (0x4000000U)
#define GPIO_PTOR_PTTO26_SHIFT                   (26U)
/*! PTTO26 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO26(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO26_SHIFT)) & GPIO_PTOR_PTTO26_MASK)

#define GPIO_PTOR_PTTO27_MASK                    (0x8000000U)
#define GPIO_PTOR_PTTO27_SHIFT                   (27U)
/*! PTTO27 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO27(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO27_SHIFT)) & GPIO_PTOR_PTTO27_MASK)

#define GPIO_PTOR_PTTO28_MASK                    (0x10000000U)
#define GPIO_PTOR_PTTO28_SHIFT                   (28U)
/*! PTTO28 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO28(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO28_SHIFT)) & GPIO_PTOR_PTTO28_MASK)

#define GPIO_PTOR_PTTO29_MASK                    (0x20000000U)
#define GPIO_PTOR_PTTO29_SHIFT                   (29U)
/*! PTTO29 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO29(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO29_SHIFT)) & GPIO_PTOR_PTTO29_MASK)

#define GPIO_PTOR_PTTO30_MASK                    (0x40000000U)
#define GPIO_PTOR_PTTO30_SHIFT                   (30U)
/*! PTTO30 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO30(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO30_SHIFT)) & GPIO_PTOR_PTTO30_MASK)

#define GPIO_PTOR_PTTO31_MASK                    (0x80000000U)
#define GPIO_PTOR_PTTO31_SHIFT                   (31U)
/*! PTTO31 - Port Toggle Output
 *  0b0..No change
 *  0b1..Set to the inverse of its current logic state
 */
#define GPIO_PTOR_PTTO31(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO31_SHIFT)) & GPIO_PTOR_PTTO31_MASK)
/*! @} */

/*! @name PDIR - Port Data Input */
/*! @{ */

#define GPIO_PDIR_PDI0_MASK                      (0x1U)
#define GPIO_PDIR_PDI0_SHIFT                     (0U)
/*! PDI0 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI0_SHIFT)) & GPIO_PDIR_PDI0_MASK)

#define GPIO_PDIR_PDI1_MASK                      (0x2U)
#define GPIO_PDIR_PDI1_SHIFT                     (1U)
/*! PDI1 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI1_SHIFT)) & GPIO_PDIR_PDI1_MASK)

#define GPIO_PDIR_PDI2_MASK                      (0x4U)
#define GPIO_PDIR_PDI2_SHIFT                     (2U)
/*! PDI2 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI2_SHIFT)) & GPIO_PDIR_PDI2_MASK)

#define GPIO_PDIR_PDI3_MASK                      (0x8U)
#define GPIO_PDIR_PDI3_SHIFT                     (3U)
/*! PDI3 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI3_SHIFT)) & GPIO_PDIR_PDI3_MASK)

#define GPIO_PDIR_PDI4_MASK                      (0x10U)
#define GPIO_PDIR_PDI4_SHIFT                     (4U)
/*! PDI4 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI4_SHIFT)) & GPIO_PDIR_PDI4_MASK)

#define GPIO_PDIR_PDI5_MASK                      (0x20U)
#define GPIO_PDIR_PDI5_SHIFT                     (5U)
/*! PDI5 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI5_SHIFT)) & GPIO_PDIR_PDI5_MASK)

#define GPIO_PDIR_PDI6_MASK                      (0x40U)
#define GPIO_PDIR_PDI6_SHIFT                     (6U)
/*! PDI6 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI6_SHIFT)) & GPIO_PDIR_PDI6_MASK)

#define GPIO_PDIR_PDI7_MASK                      (0x80U)
#define GPIO_PDIR_PDI7_SHIFT                     (7U)
/*! PDI7 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI7_SHIFT)) & GPIO_PDIR_PDI7_MASK)

#define GPIO_PDIR_PDI8_MASK                      (0x100U)
#define GPIO_PDIR_PDI8_SHIFT                     (8U)
/*! PDI8 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI8_SHIFT)) & GPIO_PDIR_PDI8_MASK)

#define GPIO_PDIR_PDI9_MASK                      (0x200U)
#define GPIO_PDIR_PDI9_SHIFT                     (9U)
/*! PDI9 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI9_SHIFT)) & GPIO_PDIR_PDI9_MASK)

#define GPIO_PDIR_PDI10_MASK                     (0x400U)
#define GPIO_PDIR_PDI10_SHIFT                    (10U)
/*! PDI10 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI10_SHIFT)) & GPIO_PDIR_PDI10_MASK)

#define GPIO_PDIR_PDI11_MASK                     (0x800U)
#define GPIO_PDIR_PDI11_SHIFT                    (11U)
/*! PDI11 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI11_SHIFT)) & GPIO_PDIR_PDI11_MASK)

#define GPIO_PDIR_PDI12_MASK                     (0x1000U)
#define GPIO_PDIR_PDI12_SHIFT                    (12U)
/*! PDI12 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI12_SHIFT)) & GPIO_PDIR_PDI12_MASK)

#define GPIO_PDIR_PDI13_MASK                     (0x2000U)
#define GPIO_PDIR_PDI13_SHIFT                    (13U)
/*! PDI13 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI13_SHIFT)) & GPIO_PDIR_PDI13_MASK)

#define GPIO_PDIR_PDI14_MASK                     (0x4000U)
#define GPIO_PDIR_PDI14_SHIFT                    (14U)
/*! PDI14 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI14_SHIFT)) & GPIO_PDIR_PDI14_MASK)

#define GPIO_PDIR_PDI15_MASK                     (0x8000U)
#define GPIO_PDIR_PDI15_SHIFT                    (15U)
/*! PDI15 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI15_SHIFT)) & GPIO_PDIR_PDI15_MASK)

#define GPIO_PDIR_PDI16_MASK                     (0x10000U)
#define GPIO_PDIR_PDI16_SHIFT                    (16U)
/*! PDI16 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI16_SHIFT)) & GPIO_PDIR_PDI16_MASK)

#define GPIO_PDIR_PDI17_MASK                     (0x20000U)
#define GPIO_PDIR_PDI17_SHIFT                    (17U)
/*! PDI17 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI17_SHIFT)) & GPIO_PDIR_PDI17_MASK)

#define GPIO_PDIR_PDI18_MASK                     (0x40000U)
#define GPIO_PDIR_PDI18_SHIFT                    (18U)
/*! PDI18 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI18_SHIFT)) & GPIO_PDIR_PDI18_MASK)

#define GPIO_PDIR_PDI19_MASK                     (0x80000U)
#define GPIO_PDIR_PDI19_SHIFT                    (19U)
/*! PDI19 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI19_SHIFT)) & GPIO_PDIR_PDI19_MASK)

#define GPIO_PDIR_PDI20_MASK                     (0x100000U)
#define GPIO_PDIR_PDI20_SHIFT                    (20U)
/*! PDI20 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI20_SHIFT)) & GPIO_PDIR_PDI20_MASK)

#define GPIO_PDIR_PDI21_MASK                     (0x200000U)
#define GPIO_PDIR_PDI21_SHIFT                    (21U)
/*! PDI21 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI21_SHIFT)) & GPIO_PDIR_PDI21_MASK)

#define GPIO_PDIR_PDI22_MASK                     (0x400000U)
#define GPIO_PDIR_PDI22_SHIFT                    (22U)
/*! PDI22 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI22_SHIFT)) & GPIO_PDIR_PDI22_MASK)

#define GPIO_PDIR_PDI23_MASK                     (0x800000U)
#define GPIO_PDIR_PDI23_SHIFT                    (23U)
/*! PDI23 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI23_SHIFT)) & GPIO_PDIR_PDI23_MASK)

#define GPIO_PDIR_PDI24_MASK                     (0x1000000U)
#define GPIO_PDIR_PDI24_SHIFT                    (24U)
/*! PDI24 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI24_SHIFT)) & GPIO_PDIR_PDI24_MASK)

#define GPIO_PDIR_PDI25_MASK                     (0x2000000U)
#define GPIO_PDIR_PDI25_SHIFT                    (25U)
/*! PDI25 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI25_SHIFT)) & GPIO_PDIR_PDI25_MASK)

#define GPIO_PDIR_PDI26_MASK                     (0x4000000U)
#define GPIO_PDIR_PDI26_SHIFT                    (26U)
/*! PDI26 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI26_SHIFT)) & GPIO_PDIR_PDI26_MASK)

#define GPIO_PDIR_PDI27_MASK                     (0x8000000U)
#define GPIO_PDIR_PDI27_SHIFT                    (27U)
/*! PDI27 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI27_SHIFT)) & GPIO_PDIR_PDI27_MASK)

#define GPIO_PDIR_PDI28_MASK                     (0x10000000U)
#define GPIO_PDIR_PDI28_SHIFT                    (28U)
/*! PDI28 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI28_SHIFT)) & GPIO_PDIR_PDI28_MASK)

#define GPIO_PDIR_PDI29_MASK                     (0x20000000U)
#define GPIO_PDIR_PDI29_SHIFT                    (29U)
/*! PDI29 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI29_SHIFT)) & GPIO_PDIR_PDI29_MASK)

#define GPIO_PDIR_PDI30_MASK                     (0x40000000U)
#define GPIO_PDIR_PDI30_SHIFT                    (30U)
/*! PDI30 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI30_SHIFT)) & GPIO_PDIR_PDI30_MASK)

#define GPIO_PDIR_PDI31_MASK                     (0x80000000U)
#define GPIO_PDIR_PDI31_SHIFT                    (31U)
/*! PDI31 - Port Data Input
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define GPIO_PDIR_PDI31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI31_SHIFT)) & GPIO_PDIR_PDI31_MASK)
/*! @} */

/*! @name PDDR - Port Data Direction */
/*! @{ */

#define GPIO_PDDR_PDD0_MASK                      (0x1U)
#define GPIO_PDDR_PDD0_SHIFT                     (0U)
/*! PDD0 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD0_SHIFT)) & GPIO_PDDR_PDD0_MASK)

#define GPIO_PDDR_PDD1_MASK                      (0x2U)
#define GPIO_PDDR_PDD1_SHIFT                     (1U)
/*! PDD1 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD1_SHIFT)) & GPIO_PDDR_PDD1_MASK)

#define GPIO_PDDR_PDD2_MASK                      (0x4U)
#define GPIO_PDDR_PDD2_SHIFT                     (2U)
/*! PDD2 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD2_SHIFT)) & GPIO_PDDR_PDD2_MASK)

#define GPIO_PDDR_PDD3_MASK                      (0x8U)
#define GPIO_PDDR_PDD3_SHIFT                     (3U)
/*! PDD3 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD3_SHIFT)) & GPIO_PDDR_PDD3_MASK)

#define GPIO_PDDR_PDD4_MASK                      (0x10U)
#define GPIO_PDDR_PDD4_SHIFT                     (4U)
/*! PDD4 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD4_SHIFT)) & GPIO_PDDR_PDD4_MASK)

#define GPIO_PDDR_PDD5_MASK                      (0x20U)
#define GPIO_PDDR_PDD5_SHIFT                     (5U)
/*! PDD5 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD5_SHIFT)) & GPIO_PDDR_PDD5_MASK)

#define GPIO_PDDR_PDD6_MASK                      (0x40U)
#define GPIO_PDDR_PDD6_SHIFT                     (6U)
/*! PDD6 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD6_SHIFT)) & GPIO_PDDR_PDD6_MASK)

#define GPIO_PDDR_PDD7_MASK                      (0x80U)
#define GPIO_PDDR_PDD7_SHIFT                     (7U)
/*! PDD7 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD7_SHIFT)) & GPIO_PDDR_PDD7_MASK)

#define GPIO_PDDR_PDD8_MASK                      (0x100U)
#define GPIO_PDDR_PDD8_SHIFT                     (8U)
/*! PDD8 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD8_SHIFT)) & GPIO_PDDR_PDD8_MASK)

#define GPIO_PDDR_PDD9_MASK                      (0x200U)
#define GPIO_PDDR_PDD9_SHIFT                     (9U)
/*! PDD9 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD9_SHIFT)) & GPIO_PDDR_PDD9_MASK)

#define GPIO_PDDR_PDD10_MASK                     (0x400U)
#define GPIO_PDDR_PDD10_SHIFT                    (10U)
/*! PDD10 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD10_SHIFT)) & GPIO_PDDR_PDD10_MASK)

#define GPIO_PDDR_PDD11_MASK                     (0x800U)
#define GPIO_PDDR_PDD11_SHIFT                    (11U)
/*! PDD11 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD11_SHIFT)) & GPIO_PDDR_PDD11_MASK)

#define GPIO_PDDR_PDD12_MASK                     (0x1000U)
#define GPIO_PDDR_PDD12_SHIFT                    (12U)
/*! PDD12 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD12_SHIFT)) & GPIO_PDDR_PDD12_MASK)

#define GPIO_PDDR_PDD13_MASK                     (0x2000U)
#define GPIO_PDDR_PDD13_SHIFT                    (13U)
/*! PDD13 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD13_SHIFT)) & GPIO_PDDR_PDD13_MASK)

#define GPIO_PDDR_PDD14_MASK                     (0x4000U)
#define GPIO_PDDR_PDD14_SHIFT                    (14U)
/*! PDD14 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD14_SHIFT)) & GPIO_PDDR_PDD14_MASK)

#define GPIO_PDDR_PDD15_MASK                     (0x8000U)
#define GPIO_PDDR_PDD15_SHIFT                    (15U)
/*! PDD15 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD15_SHIFT)) & GPIO_PDDR_PDD15_MASK)

#define GPIO_PDDR_PDD16_MASK                     (0x10000U)
#define GPIO_PDDR_PDD16_SHIFT                    (16U)
/*! PDD16 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD16_SHIFT)) & GPIO_PDDR_PDD16_MASK)

#define GPIO_PDDR_PDD17_MASK                     (0x20000U)
#define GPIO_PDDR_PDD17_SHIFT                    (17U)
/*! PDD17 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD17_SHIFT)) & GPIO_PDDR_PDD17_MASK)

#define GPIO_PDDR_PDD18_MASK                     (0x40000U)
#define GPIO_PDDR_PDD18_SHIFT                    (18U)
/*! PDD18 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD18_SHIFT)) & GPIO_PDDR_PDD18_MASK)

#define GPIO_PDDR_PDD19_MASK                     (0x80000U)
#define GPIO_PDDR_PDD19_SHIFT                    (19U)
/*! PDD19 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD19_SHIFT)) & GPIO_PDDR_PDD19_MASK)

#define GPIO_PDDR_PDD20_MASK                     (0x100000U)
#define GPIO_PDDR_PDD20_SHIFT                    (20U)
/*! PDD20 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD20_SHIFT)) & GPIO_PDDR_PDD20_MASK)

#define GPIO_PDDR_PDD21_MASK                     (0x200000U)
#define GPIO_PDDR_PDD21_SHIFT                    (21U)
/*! PDD21 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD21_SHIFT)) & GPIO_PDDR_PDD21_MASK)

#define GPIO_PDDR_PDD22_MASK                     (0x400000U)
#define GPIO_PDDR_PDD22_SHIFT                    (22U)
/*! PDD22 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD22_SHIFT)) & GPIO_PDDR_PDD22_MASK)

#define GPIO_PDDR_PDD23_MASK                     (0x800000U)
#define GPIO_PDDR_PDD23_SHIFT                    (23U)
/*! PDD23 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD23_SHIFT)) & GPIO_PDDR_PDD23_MASK)

#define GPIO_PDDR_PDD24_MASK                     (0x1000000U)
#define GPIO_PDDR_PDD24_SHIFT                    (24U)
/*! PDD24 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD24_SHIFT)) & GPIO_PDDR_PDD24_MASK)

#define GPIO_PDDR_PDD25_MASK                     (0x2000000U)
#define GPIO_PDDR_PDD25_SHIFT                    (25U)
/*! PDD25 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD25_SHIFT)) & GPIO_PDDR_PDD25_MASK)

#define GPIO_PDDR_PDD26_MASK                     (0x4000000U)
#define GPIO_PDDR_PDD26_SHIFT                    (26U)
/*! PDD26 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD26_SHIFT)) & GPIO_PDDR_PDD26_MASK)

#define GPIO_PDDR_PDD27_MASK                     (0x8000000U)
#define GPIO_PDDR_PDD27_SHIFT                    (27U)
/*! PDD27 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD27_SHIFT)) & GPIO_PDDR_PDD27_MASK)

#define GPIO_PDDR_PDD28_MASK                     (0x10000000U)
#define GPIO_PDDR_PDD28_SHIFT                    (28U)
/*! PDD28 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD28_SHIFT)) & GPIO_PDDR_PDD28_MASK)

#define GPIO_PDDR_PDD29_MASK                     (0x20000000U)
#define GPIO_PDDR_PDD29_SHIFT                    (29U)
/*! PDD29 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD29_SHIFT)) & GPIO_PDDR_PDD29_MASK)

#define GPIO_PDDR_PDD30_MASK                     (0x40000000U)
#define GPIO_PDDR_PDD30_SHIFT                    (30U)
/*! PDD30 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD30_SHIFT)) & GPIO_PDDR_PDD30_MASK)

#define GPIO_PDDR_PDD31_MASK                     (0x80000000U)
#define GPIO_PDDR_PDD31_SHIFT                    (31U)
/*! PDD31 - Port Data Direction
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_PDDR_PDD31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD31_SHIFT)) & GPIO_PDDR_PDD31_MASK)
/*! @} */

/*! @name PIDR - Port Input Disable */
/*! @{ */

#define GPIO_PIDR_PID0_MASK                      (0x1U)
#define GPIO_PIDR_PID0_SHIFT                     (0U)
/*! PID0 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID0_SHIFT)) & GPIO_PIDR_PID0_MASK)

#define GPIO_PIDR_PID1_MASK                      (0x2U)
#define GPIO_PIDR_PID1_SHIFT                     (1U)
/*! PID1 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID1_SHIFT)) & GPIO_PIDR_PID1_MASK)

#define GPIO_PIDR_PID2_MASK                      (0x4U)
#define GPIO_PIDR_PID2_SHIFT                     (2U)
/*! PID2 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID2_SHIFT)) & GPIO_PIDR_PID2_MASK)

#define GPIO_PIDR_PID3_MASK                      (0x8U)
#define GPIO_PIDR_PID3_SHIFT                     (3U)
/*! PID3 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID3_SHIFT)) & GPIO_PIDR_PID3_MASK)

#define GPIO_PIDR_PID4_MASK                      (0x10U)
#define GPIO_PIDR_PID4_SHIFT                     (4U)
/*! PID4 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID4_SHIFT)) & GPIO_PIDR_PID4_MASK)

#define GPIO_PIDR_PID5_MASK                      (0x20U)
#define GPIO_PIDR_PID5_SHIFT                     (5U)
/*! PID5 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID5_SHIFT)) & GPIO_PIDR_PID5_MASK)

#define GPIO_PIDR_PID6_MASK                      (0x40U)
#define GPIO_PIDR_PID6_SHIFT                     (6U)
/*! PID6 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID6_SHIFT)) & GPIO_PIDR_PID6_MASK)

#define GPIO_PIDR_PID7_MASK                      (0x80U)
#define GPIO_PIDR_PID7_SHIFT                     (7U)
/*! PID7 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID7_SHIFT)) & GPIO_PIDR_PID7_MASK)

#define GPIO_PIDR_PID8_MASK                      (0x100U)
#define GPIO_PIDR_PID8_SHIFT                     (8U)
/*! PID8 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID8_SHIFT)) & GPIO_PIDR_PID8_MASK)

#define GPIO_PIDR_PID9_MASK                      (0x200U)
#define GPIO_PIDR_PID9_SHIFT                     (9U)
/*! PID9 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID9_SHIFT)) & GPIO_PIDR_PID9_MASK)

#define GPIO_PIDR_PID10_MASK                     (0x400U)
#define GPIO_PIDR_PID10_SHIFT                    (10U)
/*! PID10 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID10_SHIFT)) & GPIO_PIDR_PID10_MASK)

#define GPIO_PIDR_PID11_MASK                     (0x800U)
#define GPIO_PIDR_PID11_SHIFT                    (11U)
/*! PID11 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID11_SHIFT)) & GPIO_PIDR_PID11_MASK)

#define GPIO_PIDR_PID12_MASK                     (0x1000U)
#define GPIO_PIDR_PID12_SHIFT                    (12U)
/*! PID12 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID12_SHIFT)) & GPIO_PIDR_PID12_MASK)

#define GPIO_PIDR_PID13_MASK                     (0x2000U)
#define GPIO_PIDR_PID13_SHIFT                    (13U)
/*! PID13 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID13_SHIFT)) & GPIO_PIDR_PID13_MASK)

#define GPIO_PIDR_PID14_MASK                     (0x4000U)
#define GPIO_PIDR_PID14_SHIFT                    (14U)
/*! PID14 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID14_SHIFT)) & GPIO_PIDR_PID14_MASK)

#define GPIO_PIDR_PID15_MASK                     (0x8000U)
#define GPIO_PIDR_PID15_SHIFT                    (15U)
/*! PID15 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID15_SHIFT)) & GPIO_PIDR_PID15_MASK)

#define GPIO_PIDR_PID16_MASK                     (0x10000U)
#define GPIO_PIDR_PID16_SHIFT                    (16U)
/*! PID16 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID16_SHIFT)) & GPIO_PIDR_PID16_MASK)

#define GPIO_PIDR_PID17_MASK                     (0x20000U)
#define GPIO_PIDR_PID17_SHIFT                    (17U)
/*! PID17 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID17_SHIFT)) & GPIO_PIDR_PID17_MASK)

#define GPIO_PIDR_PID18_MASK                     (0x40000U)
#define GPIO_PIDR_PID18_SHIFT                    (18U)
/*! PID18 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID18_SHIFT)) & GPIO_PIDR_PID18_MASK)

#define GPIO_PIDR_PID19_MASK                     (0x80000U)
#define GPIO_PIDR_PID19_SHIFT                    (19U)
/*! PID19 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID19_SHIFT)) & GPIO_PIDR_PID19_MASK)

#define GPIO_PIDR_PID20_MASK                     (0x100000U)
#define GPIO_PIDR_PID20_SHIFT                    (20U)
/*! PID20 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID20_SHIFT)) & GPIO_PIDR_PID20_MASK)

#define GPIO_PIDR_PID21_MASK                     (0x200000U)
#define GPIO_PIDR_PID21_SHIFT                    (21U)
/*! PID21 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID21_SHIFT)) & GPIO_PIDR_PID21_MASK)

#define GPIO_PIDR_PID22_MASK                     (0x400000U)
#define GPIO_PIDR_PID22_SHIFT                    (22U)
/*! PID22 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID22_SHIFT)) & GPIO_PIDR_PID22_MASK)

#define GPIO_PIDR_PID23_MASK                     (0x800000U)
#define GPIO_PIDR_PID23_SHIFT                    (23U)
/*! PID23 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID23_SHIFT)) & GPIO_PIDR_PID23_MASK)

#define GPIO_PIDR_PID24_MASK                     (0x1000000U)
#define GPIO_PIDR_PID24_SHIFT                    (24U)
/*! PID24 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID24_SHIFT)) & GPIO_PIDR_PID24_MASK)

#define GPIO_PIDR_PID25_MASK                     (0x2000000U)
#define GPIO_PIDR_PID25_SHIFT                    (25U)
/*! PID25 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID25_SHIFT)) & GPIO_PIDR_PID25_MASK)

#define GPIO_PIDR_PID26_MASK                     (0x4000000U)
#define GPIO_PIDR_PID26_SHIFT                    (26U)
/*! PID26 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID26_SHIFT)) & GPIO_PIDR_PID26_MASK)

#define GPIO_PIDR_PID27_MASK                     (0x8000000U)
#define GPIO_PIDR_PID27_SHIFT                    (27U)
/*! PID27 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID27_SHIFT)) & GPIO_PIDR_PID27_MASK)

#define GPIO_PIDR_PID28_MASK                     (0x10000000U)
#define GPIO_PIDR_PID28_SHIFT                    (28U)
/*! PID28 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID28_SHIFT)) & GPIO_PIDR_PID28_MASK)

#define GPIO_PIDR_PID29_MASK                     (0x20000000U)
#define GPIO_PIDR_PID29_SHIFT                    (29U)
/*! PID29 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID29_SHIFT)) & GPIO_PIDR_PID29_MASK)

#define GPIO_PIDR_PID30_MASK                     (0x40000000U)
#define GPIO_PIDR_PID30_SHIFT                    (30U)
/*! PID30 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID30_SHIFT)) & GPIO_PIDR_PID30_MASK)

#define GPIO_PIDR_PID31_MASK                     (0x80000000U)
#define GPIO_PIDR_PID31_SHIFT                    (31U)
/*! PID31 - Port Input Disable
 *  0b0..Configured for general-purpose input
 *  0b1..Disabled for general-purpose input
 */
#define GPIO_PIDR_PID31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID31_SHIFT)) & GPIO_PIDR_PID31_MASK)
/*! @} */

/*! @name PDR - Pin Data */
/*! @{ */

#define GPIO_PDR_PD_MASK                         (0x1U)
#define GPIO_PDR_PD_SHIFT                        (0U)
/*! PD - Pin Data (I/O)
 *  0b0..Logic zero
 *  0b1..Logic one
 */
#define GPIO_PDR_PD(x)                           (((uint8_t)(((uint8_t)(x)) << GPIO_PDR_PD_SHIFT)) & GPIO_PDR_PD_MASK)
/*! @} */

/* The count of GPIO_PDR */
#define GPIO_PDR_COUNT                           (32U)

/*! @name ICR - Interrupt Control 0..Interrupt Control 31 */
/*! @{ */

#define GPIO_ICR_IRQC_MASK                       (0xF0000U)
#define GPIO_ICR_IRQC_SHIFT                      (16U)
/*! IRQC - Interrupt Configuration
 *  0b0000..ISF is disabled
 *  0b0001..ISF and DMA request on rising edge
 *  0b0010..ISF and DMA request on falling edge
 *  0b0011..ISF and DMA request on either edge
 *  0b0100..Reserved
 *  0b0101..ISF sets on rising edge
 *  0b0110..ISF sets on falling edge
 *  0b0111..ISF sets on either edge
 *  0b1000..ISF and interrupt when logic 0
 *  0b1001..ISF and interrupt on rising edge
 *  0b1010..ISF and interrupt on falling edge
 *  0b1011..ISF and Interrupt on either edge
 *  0b1100..ISF and interrupt when logic 1
 *  0b1101..Enable active-high trigger output; ISF on rising edge (pin state is ORed with other enabled triggers
 *          to generate the output trigger for use by other peripherals)
 *  0b1110..Enable active-low trigger output; ISF on falling edge (pin state is inverted and ORed with other
 *          enabled triggers to generate the output trigger for use by other peripherals)
 *  0b1111..Reserved
 */
#define GPIO_ICR_IRQC(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_ICR_IRQC_SHIFT)) & GPIO_ICR_IRQC_MASK)

#define GPIO_ICR_ISF_MASK                        (0x1000000U)
#define GPIO_ICR_ISF_SHIFT                       (24U)
/*! ISF - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ICR_ISF(x)                          (((uint32_t)(((uint32_t)(x)) << GPIO_ICR_ISF_SHIFT)) & GPIO_ICR_ISF_MASK)
/*! @} */

/* The count of GPIO_ICR */
#define GPIO_ICR_COUNT                           (32U)

/*! @name GICLR - Global Interrupt Control Low */
/*! @{ */

#define GPIO_GICLR_GIWE0_MASK                    (0x1U)
#define GPIO_GICLR_GIWE0_SHIFT                   (0U)
/*! GIWE0 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE0(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE0_SHIFT)) & GPIO_GICLR_GIWE0_MASK)

#define GPIO_GICLR_GIWE1_MASK                    (0x2U)
#define GPIO_GICLR_GIWE1_SHIFT                   (1U)
/*! GIWE1 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE1(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE1_SHIFT)) & GPIO_GICLR_GIWE1_MASK)

#define GPIO_GICLR_GIWE2_MASK                    (0x4U)
#define GPIO_GICLR_GIWE2_SHIFT                   (2U)
/*! GIWE2 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE2(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE2_SHIFT)) & GPIO_GICLR_GIWE2_MASK)

#define GPIO_GICLR_GIWE3_MASK                    (0x8U)
#define GPIO_GICLR_GIWE3_SHIFT                   (3U)
/*! GIWE3 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE3(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE3_SHIFT)) & GPIO_GICLR_GIWE3_MASK)

#define GPIO_GICLR_GIWE4_MASK                    (0x10U)
#define GPIO_GICLR_GIWE4_SHIFT                   (4U)
/*! GIWE4 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE4(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE4_SHIFT)) & GPIO_GICLR_GIWE4_MASK)

#define GPIO_GICLR_GIWE5_MASK                    (0x20U)
#define GPIO_GICLR_GIWE5_SHIFT                   (5U)
/*! GIWE5 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE5(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE5_SHIFT)) & GPIO_GICLR_GIWE5_MASK)

#define GPIO_GICLR_GIWE6_MASK                    (0x40U)
#define GPIO_GICLR_GIWE6_SHIFT                   (6U)
/*! GIWE6 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE6(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE6_SHIFT)) & GPIO_GICLR_GIWE6_MASK)

#define GPIO_GICLR_GIWE7_MASK                    (0x80U)
#define GPIO_GICLR_GIWE7_SHIFT                   (7U)
/*! GIWE7 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE7(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE7_SHIFT)) & GPIO_GICLR_GIWE7_MASK)

#define GPIO_GICLR_GIWE8_MASK                    (0x100U)
#define GPIO_GICLR_GIWE8_SHIFT                   (8U)
/*! GIWE8 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE8(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE8_SHIFT)) & GPIO_GICLR_GIWE8_MASK)

#define GPIO_GICLR_GIWE9_MASK                    (0x200U)
#define GPIO_GICLR_GIWE9_SHIFT                   (9U)
/*! GIWE9 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE9(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE9_SHIFT)) & GPIO_GICLR_GIWE9_MASK)

#define GPIO_GICLR_GIWE10_MASK                   (0x400U)
#define GPIO_GICLR_GIWE10_SHIFT                  (10U)
/*! GIWE10 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE10(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE10_SHIFT)) & GPIO_GICLR_GIWE10_MASK)

#define GPIO_GICLR_GIWE11_MASK                   (0x800U)
#define GPIO_GICLR_GIWE11_SHIFT                  (11U)
/*! GIWE11 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE11(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE11_SHIFT)) & GPIO_GICLR_GIWE11_MASK)

#define GPIO_GICLR_GIWE12_MASK                   (0x1000U)
#define GPIO_GICLR_GIWE12_SHIFT                  (12U)
/*! GIWE12 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE12(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE12_SHIFT)) & GPIO_GICLR_GIWE12_MASK)

#define GPIO_GICLR_GIWE13_MASK                   (0x2000U)
#define GPIO_GICLR_GIWE13_SHIFT                  (13U)
/*! GIWE13 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE13(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE13_SHIFT)) & GPIO_GICLR_GIWE13_MASK)

#define GPIO_GICLR_GIWE14_MASK                   (0x4000U)
#define GPIO_GICLR_GIWE14_SHIFT                  (14U)
/*! GIWE14 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE14(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE14_SHIFT)) & GPIO_GICLR_GIWE14_MASK)

#define GPIO_GICLR_GIWE15_MASK                   (0x8000U)
#define GPIO_GICLR_GIWE15_SHIFT                  (15U)
/*! GIWE15 - Global Interrupt Write Enable
 *  0b0..Not updated
 *  0b1..Updated
 */
#define GPIO_GICLR_GIWE15(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE15_SHIFT)) & GPIO_GICLR_GIWE15_MASK)

#define GPIO_GICLR_GIWD_MASK                     (0xFFFF0000U)
#define GPIO_GICLR_GIWD_SHIFT                    (16U)
/*! GIWD - Global Interrupt Write Data */
#define GPIO_GICLR_GIWD(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWD_SHIFT)) & GPIO_GICLR_GIWD_MASK)
/*! @} */

/*! @name GICHR - Global Interrupt Control High */
/*! @{ */

#define GPIO_GICHR_GIWE16_MASK                   (0x1U)
#define GPIO_GICHR_GIWE16_SHIFT                  (0U)
/*! GIWE16 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE16(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE16_SHIFT)) & GPIO_GICHR_GIWE16_MASK)

#define GPIO_GICHR_GIWE17_MASK                   (0x2U)
#define GPIO_GICHR_GIWE17_SHIFT                  (1U)
/*! GIWE17 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE17(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE17_SHIFT)) & GPIO_GICHR_GIWE17_MASK)

#define GPIO_GICHR_GIWE18_MASK                   (0x4U)
#define GPIO_GICHR_GIWE18_SHIFT                  (2U)
/*! GIWE18 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE18(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE18_SHIFT)) & GPIO_GICHR_GIWE18_MASK)

#define GPIO_GICHR_GIWE19_MASK                   (0x8U)
#define GPIO_GICHR_GIWE19_SHIFT                  (3U)
/*! GIWE19 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE19(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE19_SHIFT)) & GPIO_GICHR_GIWE19_MASK)

#define GPIO_GICHR_GIWE20_MASK                   (0x10U)
#define GPIO_GICHR_GIWE20_SHIFT                  (4U)
/*! GIWE20 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE20(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE20_SHIFT)) & GPIO_GICHR_GIWE20_MASK)

#define GPIO_GICHR_GIWE21_MASK                   (0x20U)
#define GPIO_GICHR_GIWE21_SHIFT                  (5U)
/*! GIWE21 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE21(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE21_SHIFT)) & GPIO_GICHR_GIWE21_MASK)

#define GPIO_GICHR_GIWE22_MASK                   (0x40U)
#define GPIO_GICHR_GIWE22_SHIFT                  (6U)
/*! GIWE22 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE22(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE22_SHIFT)) & GPIO_GICHR_GIWE22_MASK)

#define GPIO_GICHR_GIWE23_MASK                   (0x80U)
#define GPIO_GICHR_GIWE23_SHIFT                  (7U)
/*! GIWE23 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE23(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE23_SHIFT)) & GPIO_GICHR_GIWE23_MASK)

#define GPIO_GICHR_GIWE24_MASK                   (0x100U)
#define GPIO_GICHR_GIWE24_SHIFT                  (8U)
/*! GIWE24 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE24(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE24_SHIFT)) & GPIO_GICHR_GIWE24_MASK)

#define GPIO_GICHR_GIWE25_MASK                   (0x200U)
#define GPIO_GICHR_GIWE25_SHIFT                  (9U)
/*! GIWE25 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE25(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE25_SHIFT)) & GPIO_GICHR_GIWE25_MASK)

#define GPIO_GICHR_GIWE26_MASK                   (0x400U)
#define GPIO_GICHR_GIWE26_SHIFT                  (10U)
/*! GIWE26 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE26(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE26_SHIFT)) & GPIO_GICHR_GIWE26_MASK)

#define GPIO_GICHR_GIWE27_MASK                   (0x800U)
#define GPIO_GICHR_GIWE27_SHIFT                  (11U)
/*! GIWE27 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE27(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE27_SHIFT)) & GPIO_GICHR_GIWE27_MASK)

#define GPIO_GICHR_GIWE28_MASK                   (0x1000U)
#define GPIO_GICHR_GIWE28_SHIFT                  (12U)
/*! GIWE28 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE28(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE28_SHIFT)) & GPIO_GICHR_GIWE28_MASK)

#define GPIO_GICHR_GIWE29_MASK                   (0x2000U)
#define GPIO_GICHR_GIWE29_SHIFT                  (13U)
/*! GIWE29 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE29(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE29_SHIFT)) & GPIO_GICHR_GIWE29_MASK)

#define GPIO_GICHR_GIWE30_MASK                   (0x4000U)
#define GPIO_GICHR_GIWE30_SHIFT                  (14U)
/*! GIWE30 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE30(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE30_SHIFT)) & GPIO_GICHR_GIWE30_MASK)

#define GPIO_GICHR_GIWE31_MASK                   (0x8000U)
#define GPIO_GICHR_GIWE31_SHIFT                  (15U)
/*! GIWE31 - Global Interrupt Write Enable
 *  0b0..Not updated.
 *  0b1..Updated
 */
#define GPIO_GICHR_GIWE31(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE31_SHIFT)) & GPIO_GICHR_GIWE31_MASK)

#define GPIO_GICHR_GIWD_MASK                     (0xFFFF0000U)
#define GPIO_GICHR_GIWD_SHIFT                    (16U)
/*! GIWD - Global Interrupt Write Data */
#define GPIO_GICHR_GIWD(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWD_SHIFT)) & GPIO_GICHR_GIWD_MASK)
/*! @} */

/*! @name ISFR - Interrupt Status Flag */
/*! @{ */

#define GPIO_ISFR_ISF0_MASK                      (0x1U)
#define GPIO_ISFR_ISF0_SHIFT                     (0U)
/*! ISF0 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF0_SHIFT)) & GPIO_ISFR_ISF0_MASK)

#define GPIO_ISFR_ISF1_MASK                      (0x2U)
#define GPIO_ISFR_ISF1_SHIFT                     (1U)
/*! ISF1 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF1_SHIFT)) & GPIO_ISFR_ISF1_MASK)

#define GPIO_ISFR_ISF2_MASK                      (0x4U)
#define GPIO_ISFR_ISF2_SHIFT                     (2U)
/*! ISF2 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF2_SHIFT)) & GPIO_ISFR_ISF2_MASK)

#define GPIO_ISFR_ISF3_MASK                      (0x8U)
#define GPIO_ISFR_ISF3_SHIFT                     (3U)
/*! ISF3 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF3_SHIFT)) & GPIO_ISFR_ISF3_MASK)

#define GPIO_ISFR_ISF4_MASK                      (0x10U)
#define GPIO_ISFR_ISF4_SHIFT                     (4U)
/*! ISF4 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF4_SHIFT)) & GPIO_ISFR_ISF4_MASK)

#define GPIO_ISFR_ISF5_MASK                      (0x20U)
#define GPIO_ISFR_ISF5_SHIFT                     (5U)
/*! ISF5 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF5_SHIFT)) & GPIO_ISFR_ISF5_MASK)

#define GPIO_ISFR_ISF6_MASK                      (0x40U)
#define GPIO_ISFR_ISF6_SHIFT                     (6U)
/*! ISF6 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF6_SHIFT)) & GPIO_ISFR_ISF6_MASK)

#define GPIO_ISFR_ISF7_MASK                      (0x80U)
#define GPIO_ISFR_ISF7_SHIFT                     (7U)
/*! ISF7 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF7_SHIFT)) & GPIO_ISFR_ISF7_MASK)

#define GPIO_ISFR_ISF8_MASK                      (0x100U)
#define GPIO_ISFR_ISF8_SHIFT                     (8U)
/*! ISF8 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF8_SHIFT)) & GPIO_ISFR_ISF8_MASK)

#define GPIO_ISFR_ISF9_MASK                      (0x200U)
#define GPIO_ISFR_ISF9_SHIFT                     (9U)
/*! ISF9 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF9_SHIFT)) & GPIO_ISFR_ISF9_MASK)

#define GPIO_ISFR_ISF10_MASK                     (0x400U)
#define GPIO_ISFR_ISF10_SHIFT                    (10U)
/*! ISF10 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF10_SHIFT)) & GPIO_ISFR_ISF10_MASK)

#define GPIO_ISFR_ISF11_MASK                     (0x800U)
#define GPIO_ISFR_ISF11_SHIFT                    (11U)
/*! ISF11 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF11_SHIFT)) & GPIO_ISFR_ISF11_MASK)

#define GPIO_ISFR_ISF12_MASK                     (0x1000U)
#define GPIO_ISFR_ISF12_SHIFT                    (12U)
/*! ISF12 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF12_SHIFT)) & GPIO_ISFR_ISF12_MASK)

#define GPIO_ISFR_ISF13_MASK                     (0x2000U)
#define GPIO_ISFR_ISF13_SHIFT                    (13U)
/*! ISF13 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF13_SHIFT)) & GPIO_ISFR_ISF13_MASK)

#define GPIO_ISFR_ISF14_MASK                     (0x4000U)
#define GPIO_ISFR_ISF14_SHIFT                    (14U)
/*! ISF14 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF14_SHIFT)) & GPIO_ISFR_ISF14_MASK)

#define GPIO_ISFR_ISF15_MASK                     (0x8000U)
#define GPIO_ISFR_ISF15_SHIFT                    (15U)
/*! ISF15 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF15_SHIFT)) & GPIO_ISFR_ISF15_MASK)

#define GPIO_ISFR_ISF16_MASK                     (0x10000U)
#define GPIO_ISFR_ISF16_SHIFT                    (16U)
/*! ISF16 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF16_SHIFT)) & GPIO_ISFR_ISF16_MASK)

#define GPIO_ISFR_ISF17_MASK                     (0x20000U)
#define GPIO_ISFR_ISF17_SHIFT                    (17U)
/*! ISF17 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF17_SHIFT)) & GPIO_ISFR_ISF17_MASK)

#define GPIO_ISFR_ISF18_MASK                     (0x40000U)
#define GPIO_ISFR_ISF18_SHIFT                    (18U)
/*! ISF18 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF18_SHIFT)) & GPIO_ISFR_ISF18_MASK)

#define GPIO_ISFR_ISF19_MASK                     (0x80000U)
#define GPIO_ISFR_ISF19_SHIFT                    (19U)
/*! ISF19 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF19_SHIFT)) & GPIO_ISFR_ISF19_MASK)

#define GPIO_ISFR_ISF20_MASK                     (0x100000U)
#define GPIO_ISFR_ISF20_SHIFT                    (20U)
/*! ISF20 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF20_SHIFT)) & GPIO_ISFR_ISF20_MASK)

#define GPIO_ISFR_ISF21_MASK                     (0x200000U)
#define GPIO_ISFR_ISF21_SHIFT                    (21U)
/*! ISF21 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF21_SHIFT)) & GPIO_ISFR_ISF21_MASK)

#define GPIO_ISFR_ISF22_MASK                     (0x400000U)
#define GPIO_ISFR_ISF22_SHIFT                    (22U)
/*! ISF22 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF22_SHIFT)) & GPIO_ISFR_ISF22_MASK)

#define GPIO_ISFR_ISF23_MASK                     (0x800000U)
#define GPIO_ISFR_ISF23_SHIFT                    (23U)
/*! ISF23 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF23_SHIFT)) & GPIO_ISFR_ISF23_MASK)

#define GPIO_ISFR_ISF24_MASK                     (0x1000000U)
#define GPIO_ISFR_ISF24_SHIFT                    (24U)
/*! ISF24 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF24_SHIFT)) & GPIO_ISFR_ISF24_MASK)

#define GPIO_ISFR_ISF25_MASK                     (0x2000000U)
#define GPIO_ISFR_ISF25_SHIFT                    (25U)
/*! ISF25 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF25_SHIFT)) & GPIO_ISFR_ISF25_MASK)

#define GPIO_ISFR_ISF26_MASK                     (0x4000000U)
#define GPIO_ISFR_ISF26_SHIFT                    (26U)
/*! ISF26 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF26_SHIFT)) & GPIO_ISFR_ISF26_MASK)

#define GPIO_ISFR_ISF27_MASK                     (0x8000000U)
#define GPIO_ISFR_ISF27_SHIFT                    (27U)
/*! ISF27 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF27_SHIFT)) & GPIO_ISFR_ISF27_MASK)

#define GPIO_ISFR_ISF28_MASK                     (0x10000000U)
#define GPIO_ISFR_ISF28_SHIFT                    (28U)
/*! ISF28 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF28_SHIFT)) & GPIO_ISFR_ISF28_MASK)

#define GPIO_ISFR_ISF29_MASK                     (0x20000000U)
#define GPIO_ISFR_ISF29_SHIFT                    (29U)
/*! ISF29 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF29_SHIFT)) & GPIO_ISFR_ISF29_MASK)

#define GPIO_ISFR_ISF30_MASK                     (0x40000000U)
#define GPIO_ISFR_ISF30_SHIFT                    (30U)
/*! ISF30 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF30_SHIFT)) & GPIO_ISFR_ISF30_MASK)

#define GPIO_ISFR_ISF31_MASK                     (0x80000000U)
#define GPIO_ISFR_ISF31_SHIFT                    (31U)
/*! ISF31 - Interrupt Status Flag
 *  0b0..Not detected
 *  0b1..Detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define GPIO_ISFR_ISF31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF31_SHIFT)) & GPIO_ISFR_ISF31_MASK)
/*! @} */

/* The count of GPIO_ISFR */
#define GPIO_ISFR_COUNT                          (1U)


/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIO0 base address */
#define GPIO0_BASE                               (0x40102000u)
/** Peripheral GPIO0 base pointer */
#define GPIO0                                    ((GPIO_Type *)GPIO0_BASE)
/** Peripheral GPIO1 base address */
#define GPIO1_BASE                               (0x40103000u)
/** Peripheral GPIO1 base pointer */
#define GPIO1                                    ((GPIO_Type *)GPIO1_BASE)
/** Peripheral GPIO2 base address */
#define GPIO2_BASE                               (0x40104000u)
/** Peripheral GPIO2 base pointer */
#define GPIO2                                    ((GPIO_Type *)GPIO2_BASE)
/** Peripheral GPIO3 base address */
#define GPIO3_BASE                               (0x40105000u)
/** Peripheral GPIO3 base pointer */
#define GPIO3                                    ((GPIO_Type *)GPIO3_BASE)
/** Peripheral GPIO4 base address */
#define GPIO4_BASE                               (0x40106000u)
/** Peripheral GPIO4 base pointer */
#define GPIO4                                    ((GPIO_Type *)GPIO4_BASE)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS                          { GPIO0_BASE, GPIO1_BASE, GPIO2_BASE, GPIO3_BASE, GPIO4_BASE }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIO0, GPIO1, GPIO2, GPIO3, GPIO4 }
/** Interrupt vectors for the GPIO peripheral type */
#define GPIO_IRQS                                { GPIO0_IRQn, GPIO1_IRQn, GPIO2_IRQn, GPIO3_IRQn, GPIO4_IRQn }

/*!
 * @}
 */ /* end of group GPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I3C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I3C_Peripheral_Access_Layer I3C Peripheral Access Layer
 * @{
 */

/** I3C - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCONFIG;                           /**< Controller Configuration, offset: 0x0 */
  __IO uint32_t SCONFIG;                           /**< Target Configuration, offset: 0x4 */
  __IO uint32_t SSTATUS;                           /**< Target Status, offset: 0x8 */
  __IO uint32_t SCTRL;                             /**< Target Control, offset: 0xC */
  __IO uint32_t SINTSET;                           /**< Target Interrupt Set, offset: 0x10 */
  __IO uint32_t SINTCLR;                           /**< Target Interrupt Clear, offset: 0x14 */
  __I  uint32_t SINTMASKED;                        /**< Target Interrupt Mask, offset: 0x18 */
  __IO uint32_t SERRWARN;                          /**< Target Errors and Warnings, offset: 0x1C */
  __IO uint32_t SDMACTRL;                          /**< Target DMA Control, offset: 0x20 */
       uint8_t RESERVED_0[8];
  __IO uint32_t SDATACTRL;                         /**< Target Data Control, offset: 0x2C */
  __O  uint32_t SWDATAB;                           /**< Target Write Data Byte, offset: 0x30 */
  __O  uint32_t SWDATABE;                          /**< Target Write Data Byte End, offset: 0x34 */
  __O  uint32_t SWDATAH;                           /**< Target Write Data Halfword, offset: 0x38 */
  __O  uint32_t SWDATAHE;                          /**< Target Write Data Halfword End, offset: 0x3C */
  __I  uint32_t SRDATAB;                           /**< Target Read Data Byte, offset: 0x40 */
       uint8_t RESERVED_1[4];
  __I  uint32_t SRDATAH;                           /**< Target Read Data Halfword, offset: 0x48 */
       uint8_t RESERVED_2[8];
  union {                                          /* offset: 0x54 */
    __O  uint32_t SWDATAB1;                          /**< Target Write Data Byte, offset: 0x54 */
    __O  uint32_t SWDATAH1;                          /**< Target Write Data Halfword, offset: 0x54 */
  };
       uint8_t RESERVED_3[4];
  __I  uint32_t SCAPABILITIES2;                    /**< Target Capabilities 2, offset: 0x5C */
  __I  uint32_t SCAPABILITIES;                     /**< Target Capabilities, offset: 0x60 */
  __IO uint32_t SDYNADDR;                          /**< Target Dynamic Address, offset: 0x64 */
  __IO uint32_t SMAXLIMITS;                        /**< Target Maximum Limits, offset: 0x68 */
  __IO uint32_t SIDPARTNO;                         /**< Target ID Part Number, offset: 0x6C */
  __IO uint32_t SIDEXT;                            /**< Target ID Extension, offset: 0x70 */
  __IO uint32_t SVENDORID;                         /**< Target Vendor ID, offset: 0x74 */
  __IO uint32_t STCCLOCK;                          /**< Target Time Control Clock, offset: 0x78 */
  __I  uint32_t SMSGMAPADDR;                       /**< Target Message Map Address, offset: 0x7C */
  __IO uint32_t MCONFIG_EXT;                       /**< Controller Extended Configuration, offset: 0x80 */
  __IO uint32_t MCTRL;                             /**< Controller Control, offset: 0x84 */
  __IO uint32_t MSTATUS;                           /**< Controller Status, offset: 0x88 */
  __IO uint32_t MIBIRULES;                         /**< Controller In-band Interrupt Registry and Rules, offset: 0x8C */
  __IO uint32_t MINTSET;                           /**< Controller Interrupt Set, offset: 0x90 */
  __IO uint32_t MINTCLR;                           /**< Controller Interrupt Clear, offset: 0x94 */
  __I  uint32_t MINTMASKED;                        /**< Controller Interrupt Mask, offset: 0x98 */
  __IO uint32_t MERRWARN;                          /**< Controller Errors and Warnings, offset: 0x9C */
  __IO uint32_t MDMACTRL;                          /**< Controller DMA Control, offset: 0xA0 */
       uint8_t RESERVED_4[8];
  __IO uint32_t MDATACTRL;                         /**< Controller Data Control, offset: 0xAC */
  __O  uint32_t MWDATAB;                           /**< Controller Write Data Byte, offset: 0xB0 */
  __O  uint32_t MWDATABE;                          /**< Controller Write Data Byte End, offset: 0xB4 */
  __O  uint32_t MWDATAH;                           /**< Controller Write Data Halfword, offset: 0xB8 */
  __O  uint32_t MWDATAHE;                          /**< Controller Write Data Halfword End, offset: 0xBC */
  __I  uint32_t MRDATAB;                           /**< Controller Read Data Byte, offset: 0xC0 */
       uint8_t RESERVED_5[4];
  __I  uint32_t MRDATAH;                           /**< Controller Read Data Halfword, offset: 0xC8 */
  union {                                          /* offset: 0xCC */
    __O  uint32_t MWDATAB1;                          /**< Controller Write Byte Data 1 (to Bus), offset: 0xCC */
    __O  uint32_t MWDATAH1;                          /**< Controller Write Halfword Data (to Bus), offset: 0xCC */
  };
  union {                                          /* offset: 0xD0 */
    __O  uint32_t MWMSG_SDR_CONTROL;                 /**< Controller Write Message Control in SDR mode, offset: 0xD0 */
    __O  uint32_t MWMSG_SDR_DATA;                    /**< Controller Write Message Data in SDR mode, offset: 0xD0 */
  };
  __I  uint32_t MRMSG_SDR;                         /**< Controller Read Message in SDR mode, offset: 0xD4 */
  union {                                          /* offset: 0xD8 */
    __O  uint32_t MWMSG_DDR_CONTROL;                 /**< Controller Write Message in DDR mode: First Control Word, offset: 0xD8 */
    __O  uint32_t MWMSG_DDR_CONTROL2;                /**< Controller Write Message in DDR Mode Control 2, offset: 0xD8 */
    __O  uint32_t MWMSG_DDR_DATA;                    /**< Controller Write Message Data in DDR mode, offset: 0xD8 */
  };
  __I  uint32_t MRMSG_DDR;                         /**< Controller Read Message in DDR mode, offset: 0xDC */
       uint8_t RESERVED_6[4];
  __IO uint32_t MDYNADDR;                          /**< Controller Dynamic Address, offset: 0xE4 */
       uint8_t RESERVED_7[52];
  __I  uint32_t SMAPCTRL0;                         /**< Map Feature Control 0, offset: 0x11C */
       uint8_t RESERVED_8[32];
  __IO uint32_t IBIEXT1;                           /**< Extended IBI Data 1, offset: 0x140 */
  __IO uint32_t IBIEXT2;                           /**< Extended IBI Data 2, offset: 0x144 */
       uint8_t RESERVED_9[3764];
  __I  uint32_t SID;                               /**< Target Module ID, offset: 0xFFC */
} I3C_Type;

/* ----------------------------------------------------------------------------
   -- I3C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I3C_Register_Masks I3C Register Masks
 * @{
 */

/*! @name MCONFIG - Controller Configuration */
/*! @{ */

#define I3C_MCONFIG_MSTENA_MASK                  (0x3U)
#define I3C_MCONFIG_MSTENA_SHIFT                 (0U)
/*! MSTENA - Controller Enable
 *  0b00..CONTROLLER_OFF
 *  0b01..CONTROLLER_ON
 *  0b10..CONTROLLER_CAPABLE
 *  0b11..I2C_CONTROLLER_MODE
 */
#define I3C_MCONFIG_MSTENA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_MSTENA_SHIFT)) & I3C_MCONFIG_MSTENA_MASK)

#define I3C_MCONFIG_DISTO_MASK                   (0x8U)
#define I3C_MCONFIG_DISTO_SHIFT                  (3U)
/*! DISTO - Disable Timeout
 *  0b1..Disabled, if configured
 *  0b0..Enabled
 */
#define I3C_MCONFIG_DISTO(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_DISTO_SHIFT)) & I3C_MCONFIG_DISTO_MASK)

#define I3C_MCONFIG_HKEEP_MASK                   (0x30U)
#define I3C_MCONFIG_HKEEP_SHIFT                  (4U)
/*! HKEEP - High-Keeper
 *  0b00..None
 *  0b01..WIRED_IN
 *  0b10..PASSIVE_SDA
 *  0b11..PASSIVE_ON_SDA_SCL
 */
#define I3C_MCONFIG_HKEEP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_HKEEP_SHIFT)) & I3C_MCONFIG_HKEEP_MASK)

#define I3C_MCONFIG_ODSTOP_MASK                  (0x40U)
#define I3C_MCONFIG_ODSTOP_SHIFT                 (6U)
/*! ODSTOP - Open Drain Stop
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MCONFIG_ODSTOP(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODSTOP_SHIFT)) & I3C_MCONFIG_ODSTOP_MASK)

#define I3C_MCONFIG_PPBAUD_MASK                  (0xF00U)
#define I3C_MCONFIG_PPBAUD_SHIFT                 (8U)
/*! PPBAUD - Push-Pull Baud Rate */
#define I3C_MCONFIG_PPBAUD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_PPBAUD_SHIFT)) & I3C_MCONFIG_PPBAUD_MASK)

#define I3C_MCONFIG_PPLOW_MASK                   (0xF000U)
#define I3C_MCONFIG_PPLOW_SHIFT                  (12U)
/*! PPLOW - Push-Pull Low */
#define I3C_MCONFIG_PPLOW(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_PPLOW_SHIFT)) & I3C_MCONFIG_PPLOW_MASK)

#define I3C_MCONFIG_ODBAUD_MASK                  (0xFF0000U)
#define I3C_MCONFIG_ODBAUD_SHIFT                 (16U)
/*! ODBAUD - Open Drain Baud Rate */
#define I3C_MCONFIG_ODBAUD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODBAUD_SHIFT)) & I3C_MCONFIG_ODBAUD_MASK)

#define I3C_MCONFIG_ODHPP_MASK                   (0x1000000U)
#define I3C_MCONFIG_ODHPP_SHIFT                  (24U)
/*! ODHPP - Open Drain High Push-Pull
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MCONFIG_ODHPP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODHPP_SHIFT)) & I3C_MCONFIG_ODHPP_MASK)

#define I3C_MCONFIG_SKEW_MASK                    (0xE000000U)
#define I3C_MCONFIG_SKEW_SHIFT                   (25U)
/*! SKEW - Skew */
#define I3C_MCONFIG_SKEW(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_SKEW_SHIFT)) & I3C_MCONFIG_SKEW_MASK)

#define I3C_MCONFIG_I2CBAUD_MASK                 (0xF0000000U)
#define I3C_MCONFIG_I2CBAUD_SHIFT                (28U)
/*! I2CBAUD - I2C Baud Rate */
#define I3C_MCONFIG_I2CBAUD(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_I2CBAUD_SHIFT)) & I3C_MCONFIG_I2CBAUD_MASK)
/*! @} */

/*! @name SCONFIG - Target Configuration */
/*! @{ */

#define I3C_SCONFIG_SLVENA_MASK                  (0x1U)
#define I3C_SCONFIG_SLVENA_SHIFT                 (0U)
/*! SLVENA - Target Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SCONFIG_SLVENA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_SLVENA_SHIFT)) & I3C_SCONFIG_SLVENA_MASK)

#define I3C_SCONFIG_NACK_MASK                    (0x2U)
#define I3C_SCONFIG_NACK_SHIFT                   (1U)
/*! NACK - Not Acknowledge
 *  0b1..Always enable NACK mode (works normally)
 *  0b0..Always disable NACK mode
 */
#define I3C_SCONFIG_NACK(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_NACK_SHIFT)) & I3C_SCONFIG_NACK_MASK)

#define I3C_SCONFIG_MATCHSS_MASK                 (0x4U)
#define I3C_SCONFIG_MATCHSS_SHIFT                (2U)
/*! MATCHSS - Match Start or Stop
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SCONFIG_MATCHSS(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_MATCHSS_SHIFT)) & I3C_SCONFIG_MATCHSS_MASK)

#define I3C_SCONFIG_S0IGNORE_MASK                (0x8U)
#define I3C_SCONFIG_S0IGNORE_SHIFT               (3U)
/*! S0IGNORE - Ignore TE0 or TE1 Errors
 *  0b1..Ignore TE0 or TE1 errors
 *  0b0..Do not ignore TE0 or TE1 errors
 */
#define I3C_SCONFIG_S0IGNORE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_S0IGNORE_SHIFT)) & I3C_SCONFIG_S0IGNORE_MASK)

#define I3C_SCONFIG_HDROK_MASK                   (0x10U)
#define I3C_SCONFIG_HDROK_SHIFT                  (4U)
/*! HDROK - HDR OK
 *  0b1..Enable HDR OK
 *  0b0..Disable HDR OK
 */
#define I3C_SCONFIG_HDROK(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_HDROK_SHIFT)) & I3C_SCONFIG_HDROK_MASK)

#define I3C_SCONFIG_OFFLINE_MASK                 (0x200U)
#define I3C_SCONFIG_OFFLINE_SHIFT                (9U)
/*! OFFLINE - Offline
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SCONFIG_OFFLINE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_OFFLINE_SHIFT)) & I3C_SCONFIG_OFFLINE_MASK)

#define I3C_SCONFIG_BAMATCH_MASK                 (0xFF0000U)
#define I3C_SCONFIG_BAMATCH_SHIFT                (16U)
/*! BAMATCH - Bus Available Match */
#define I3C_SCONFIG_BAMATCH(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_BAMATCH_SHIFT)) & I3C_SCONFIG_BAMATCH_MASK)

#define I3C_SCONFIG_SADDR_MASK                   (0xFE000000U)
#define I3C_SCONFIG_SADDR_SHIFT                  (25U)
/*! SADDR - Static Address */
#define I3C_SCONFIG_SADDR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_SADDR_SHIFT)) & I3C_SCONFIG_SADDR_MASK)
/*! @} */

/*! @name SSTATUS - Target Status */
/*! @{ */

#define I3C_SSTATUS_STNOTSTOP_MASK               (0x1U)
#define I3C_SSTATUS_STNOTSTOP_SHIFT              (0U)
/*! STNOTSTOP - Status not Stop
 *  0b1..Busy
 *  0b0..In STOP condition
 */
#define I3C_SSTATUS_STNOTSTOP(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STNOTSTOP_SHIFT)) & I3C_SSTATUS_STNOTSTOP_MASK)

#define I3C_SSTATUS_STMSG_MASK                   (0x2U)
#define I3C_SSTATUS_STMSG_SHIFT                  (1U)
/*! STMSG - Status Message
 *  0b1..Busy
 *  0b0..Idle
 */
#define I3C_SSTATUS_STMSG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STMSG_SHIFT)) & I3C_SSTATUS_STMSG_MASK)

#define I3C_SSTATUS_STCCCH_MASK                  (0x4U)
#define I3C_SSTATUS_STCCCH_SHIFT                 (2U)
/*! STCCCH - Status Common Command Code Handler
 *  0b1..Handled automatically
 *  0b0..No CCC message handled
 */
#define I3C_SSTATUS_STCCCH(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STCCCH_SHIFT)) & I3C_SSTATUS_STCCCH_MASK)

#define I3C_SSTATUS_STREQRD_MASK                 (0x8U)
#define I3C_SSTATUS_STREQRD_SHIFT                (3U)
/*! STREQRD - Status Request Read
 *  0b1..SDR read from this target or an IBI is being pushed out
 *  0b0..Not an SDR read
 */
#define I3C_SSTATUS_STREQRD(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STREQRD_SHIFT)) & I3C_SSTATUS_STREQRD_MASK)

#define I3C_SSTATUS_STREQWR_MASK                 (0x10U)
#define I3C_SSTATUS_STREQWR_SHIFT                (4U)
/*! STREQWR - Status Request Write
 *  0b1..SDR write data from the controller, but not in ENTDAA mode
 *  0b0..Not an SDR write
 */
#define I3C_SSTATUS_STREQWR(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STREQWR_SHIFT)) & I3C_SSTATUS_STREQWR_MASK)

#define I3C_SSTATUS_STDAA_MASK                   (0x20U)
#define I3C_SSTATUS_STDAA_SHIFT                  (5U)
/*! STDAA - Status Dynamic Address Assignment
 *  0b1..In ENTDAA mode
 *  0b0..Not in ENTDAA mode
 */
#define I3C_SSTATUS_STDAA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STDAA_SHIFT)) & I3C_SSTATUS_STDAA_MASK)

#define I3C_SSTATUS_STHDR_MASK                   (0x40U)
#define I3C_SSTATUS_STHDR_SHIFT                  (6U)
/*! STHDR - Status High Data Rate
 *  0b1..I3C bus in HDR-DDR mode
 *  0b0..I3C bus not in HDR-DDR mode
 */
#define I3C_SSTATUS_STHDR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STHDR_SHIFT)) & I3C_SSTATUS_STHDR_MASK)

#define I3C_SSTATUS_START_MASK                   (0x100U)
#define I3C_SSTATUS_START_SHIFT                  (8U)
/*! START - Start
 *  0b1..Detected
 *  0b0..Not detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SSTATUS_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_START_SHIFT)) & I3C_SSTATUS_START_MASK)

#define I3C_SSTATUS_MATCHED_MASK                 (0x200U)
#define I3C_SSTATUS_MATCHED_SHIFT                (9U)
/*! MATCHED - Matched
 *  0b1..Header matched
 *  0b0..Header not matched
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SSTATUS_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_MATCHED_SHIFT)) & I3C_SSTATUS_MATCHED_MASK)

#define I3C_SSTATUS_STOP_MASK                    (0x400U)
#define I3C_SSTATUS_STOP_SHIFT                   (10U)
/*! STOP - Stop
 *  0b1..Stopped state detected
 *  0b0..No Stopped state detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SSTATUS_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STOP_SHIFT)) & I3C_SSTATUS_STOP_MASK)

#define I3C_SSTATUS_RX_PEND_MASK                 (0x800U)
#define I3C_SSTATUS_RX_PEND_SHIFT                (11U)
/*! RX_PEND - Received Message Pending
 *  0b1..Received message pending
 *  0b0..No received message pending
 */
#define I3C_SSTATUS_RX_PEND(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_RX_PEND_SHIFT)) & I3C_SSTATUS_RX_PEND_MASK)

#define I3C_SSTATUS_TXNOTFULL_MASK               (0x1000U)
#define I3C_SSTATUS_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - Transmit Buffer Not Full
 *  0b1..Transmit buffer not full
 *  0b0..Transmit buffer full
 */
#define I3C_SSTATUS_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_TXNOTFULL_SHIFT)) & I3C_SSTATUS_TXNOTFULL_MASK)

#define I3C_SSTATUS_DACHG_MASK                   (0x2000U)
#define I3C_SSTATUS_DACHG_SHIFT                  (13U)
/*! DACHG - Dynamic Address Change
 *  0b1..DA change detected
 *  0b0..No DA change detected
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SSTATUS_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_DACHG_SHIFT)) & I3C_SSTATUS_DACHG_MASK)

#define I3C_SSTATUS_CCC_MASK                     (0x4000U)
#define I3C_SSTATUS_CCC_SHIFT                    (14U)
/*! CCC - Common Command Code
 *  0b1..CCC received
 *  0b0..CCC not received
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SSTATUS_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_CCC_SHIFT)) & I3C_SSTATUS_CCC_MASK)

#define I3C_SSTATUS_ERRWARN_MASK                 (0x8000U)
#define I3C_SSTATUS_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error Warning */
#define I3C_SSTATUS_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_ERRWARN_SHIFT)) & I3C_SSTATUS_ERRWARN_MASK)

#define I3C_SSTATUS_HDRMATCH_MASK                (0x10000U)
#define I3C_SSTATUS_HDRMATCH_SHIFT               (16U)
/*! HDRMATCH - High Data Rate Command Match
 *  0b1..Matched the I3C dynamic address
 *  0b0..Did not match
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SSTATUS_HDRMATCH(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_HDRMATCH_SHIFT)) & I3C_SSTATUS_HDRMATCH_MASK)

#define I3C_SSTATUS_CHANDLED_MASK                (0x20000U)
#define I3C_SSTATUS_CHANDLED_SHIFT               (17U)
/*! CHANDLED - Common Command Code Handled
 *  0b1..CCC handling in progress
 *  0b0..CCC handling not in progress
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SSTATUS_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_CHANDLED_SHIFT)) & I3C_SSTATUS_CHANDLED_MASK)

#define I3C_SSTATUS_EVENT_MASK                   (0x40000U)
#define I3C_SSTATUS_EVENT_SHIFT                  (18U)
/*! EVENT - Event
 *  0b1..IBI, CR, or HJ occurred
 *  0b0..No event occurred
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SSTATUS_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_EVENT_SHIFT)) & I3C_SSTATUS_EVENT_MASK)

#define I3C_SSTATUS_EVDET_MASK                   (0x300000U)
#define I3C_SSTATUS_EVDET_SHIFT                  (20U)
/*! EVDET - Event Details
 *  0b00..NONE (no event or no pending event)
 *  0b01..NO_REQUEST (request is not sent yet; either there is no START condition yet, or is waiting for Bus-Available or Bus-Idle (HJ))
 *  0b10..NACKed (not acknowledged, request sent and rejected); I3C tries again
 *  0b11..ACKed (acknowledged; request sent and accepted), so done (unless the time control data is still being sent)
 */
#define I3C_SSTATUS_EVDET(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_EVDET_SHIFT)) & I3C_SSTATUS_EVDET_MASK)

#define I3C_SSTATUS_IBIDIS_MASK                  (0x1000000U)
#define I3C_SSTATUS_IBIDIS_SHIFT                 (24U)
/*! IBIDIS - In-Band Interrupts Disable
 *  0b1..Disabled
 *  0b0..Enabled
 */
#define I3C_SSTATUS_IBIDIS(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_IBIDIS_SHIFT)) & I3C_SSTATUS_IBIDIS_MASK)

#define I3C_SSTATUS_MRDIS_MASK                   (0x2000000U)
#define I3C_SSTATUS_MRDIS_SHIFT                  (25U)
/*! MRDIS - Controller Requests Disable
 *  0b1..Disabled
 *  0b0..Enabled
 */
#define I3C_SSTATUS_MRDIS(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_MRDIS_SHIFT)) & I3C_SSTATUS_MRDIS_MASK)

#define I3C_SSTATUS_HJDIS_MASK                   (0x8000000U)
#define I3C_SSTATUS_HJDIS_SHIFT                  (27U)
/*! HJDIS - Hot-Join Disabled
 *  0b1..Disabled
 *  0b0..Enabled
 */
#define I3C_SSTATUS_HJDIS(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_HJDIS_SHIFT)) & I3C_SSTATUS_HJDIS_MASK)

#define I3C_SSTATUS_ACTSTATE_MASK                (0x30000000U)
#define I3C_SSTATUS_ACTSTATE_SHIFT               (28U)
/*! ACTSTATE - Activity State from Common Command Codes (CCC)
 *  0b00..NO_LATENCY (normal bus operations)
 *  0b01..LATENCY_1MS (1 ms of latency)
 *  0b10..LATENCY_100MS (100 ms of latency)
 *  0b11..LATENCY_10S (10 seconds of latency)
 */
#define I3C_SSTATUS_ACTSTATE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_ACTSTATE_SHIFT)) & I3C_SSTATUS_ACTSTATE_MASK)

#define I3C_SSTATUS_TIMECTRL_MASK                (0xC0000000U)
#define I3C_SSTATUS_TIMECTRL_SHIFT               (30U)
/*! TIMECTRL - Time Control
 *  0b00..NO_TIME_CONTROL (no time control is enabled)
 *  0b01..SYNC_MODE (Synchronous mode is enabled)
 *  0b10..ASYNC_MODE (Asynchronous standard mode (0 or 1) is enabled)
 *  0b11..BOTHSYNCASYNC (both Synchronous and Asynchronous modes are enabled)
 */
#define I3C_SSTATUS_TIMECTRL(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_TIMECTRL_SHIFT)) & I3C_SSTATUS_TIMECTRL_MASK)
/*! @} */

/*! @name SCTRL - Target Control */
/*! @{ */

#define I3C_SCTRL_EVENT_MASK                     (0x3U)
#define I3C_SCTRL_EVENT_SHIFT                    (0U)
/*! EVENT - Event
 *  0b00..NORMAL_MODE
 *  0b01..IBI
 *  0b10..CONTROLLER_REQUEST
 *  0b11..HOT_JOIN_REQUEST
 */
#define I3C_SCTRL_EVENT(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_EVENT_SHIFT)) & I3C_SCTRL_EVENT_MASK)

#define I3C_SCTRL_EXTDATA_MASK                   (0x8U)
#define I3C_SCTRL_EXTDATA_SHIFT                  (3U)
/*! EXTDATA - Extended Data
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SCTRL_EXTDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_EXTDATA_SHIFT)) & I3C_SCTRL_EXTDATA_MASK)

#define I3C_SCTRL_IBIDATA_MASK                   (0xFF00U)
#define I3C_SCTRL_IBIDATA_SHIFT                  (8U)
/*! IBIDATA - In-Band Interrupt Data */
#define I3C_SCTRL_IBIDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_IBIDATA_SHIFT)) & I3C_SCTRL_IBIDATA_MASK)

#define I3C_SCTRL_PENDINT_MASK                   (0xF0000U)
#define I3C_SCTRL_PENDINT_SHIFT                  (16U)
/*! PENDINT - Pending Interrupt */
#define I3C_SCTRL_PENDINT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_PENDINT_SHIFT)) & I3C_SCTRL_PENDINT_MASK)

#define I3C_SCTRL_ACTSTATE_MASK                  (0x300000U)
#define I3C_SCTRL_ACTSTATE_SHIFT                 (20U)
/*! ACTSTATE - Activity State of Target */
#define I3C_SCTRL_ACTSTATE(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_ACTSTATE_SHIFT)) & I3C_SCTRL_ACTSTATE_MASK)

#define I3C_SCTRL_VENDINFO_MASK                  (0xFF000000U)
#define I3C_SCTRL_VENDINFO_SHIFT                 (24U)
/*! VENDINFO - Vendor Information */
#define I3C_SCTRL_VENDINFO(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_VENDINFO_SHIFT)) & I3C_SCTRL_VENDINFO_MASK)
/*! @} */

/*! @name SINTSET - Target Interrupt Set */
/*! @{ */

#define I3C_SINTSET_START_MASK                   (0x100U)
#define I3C_SINTSET_START_SHIFT                  (8U)
/*! START - Start Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_START_SHIFT)) & I3C_SINTSET_START_MASK)

#define I3C_SINTSET_MATCHED_MASK                 (0x200U)
#define I3C_SINTSET_MATCHED_SHIFT                (9U)
/*! MATCHED - Match Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_MATCHED_SHIFT)) & I3C_SINTSET_MATCHED_MASK)

#define I3C_SINTSET_STOP_MASK                    (0x400U)
#define I3C_SINTSET_STOP_SHIFT                   (10U)
/*! STOP - Stop Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_STOP_SHIFT)) & I3C_SINTSET_STOP_MASK)

#define I3C_SINTSET_RXPEND_MASK                  (0x800U)
#define I3C_SINTSET_RXPEND_SHIFT                 (11U)
/*! RXPEND - Receive Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_RXPEND_SHIFT)) & I3C_SINTSET_RXPEND_MASK)

#define I3C_SINTSET_TXSEND_MASK                  (0x1000U)
#define I3C_SINTSET_TXSEND_SHIFT                 (12U)
/*! TXSEND - Transmit Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_TXSEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_TXSEND_SHIFT)) & I3C_SINTSET_TXSEND_MASK)

#define I3C_SINTSET_DACHG_MASK                   (0x2000U)
#define I3C_SINTSET_DACHG_SHIFT                  (13U)
/*! DACHG - Dynamic Address Change Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_DACHG_SHIFT)) & I3C_SINTSET_DACHG_MASK)

#define I3C_SINTSET_CCC_MASK                     (0x4000U)
#define I3C_SINTSET_CCC_SHIFT                    (14U)
/*! CCC - Common Command Code (CCC) Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_CCC_SHIFT)) & I3C_SINTSET_CCC_MASK)

#define I3C_SINTSET_ERRWARN_MASK                 (0x8000U)
#define I3C_SINTSET_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error or Warning Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_ERRWARN_SHIFT)) & I3C_SINTSET_ERRWARN_MASK)

#define I3C_SINTSET_DDRMATCHED_MASK              (0x10000U)
#define I3C_SINTSET_DDRMATCHED_SHIFT             (16U)
/*! DDRMATCHED - Double Data Rate Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_DDRMATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_DDRMATCHED_SHIFT)) & I3C_SINTSET_DDRMATCHED_MASK)

#define I3C_SINTSET_CHANDLED_MASK                (0x20000U)
#define I3C_SINTSET_CHANDLED_SHIFT               (17U)
/*! CHANDLED - Common Command Code (CCC) Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_CHANDLED_SHIFT)) & I3C_SINTSET_CHANDLED_MASK)

#define I3C_SINTSET_EVENT_MASK                   (0x40000U)
#define I3C_SINTSET_EVENT_SHIFT                  (18U)
/*! EVENT - Event Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_SINTSET_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_EVENT_SHIFT)) & I3C_SINTSET_EVENT_MASK)
/*! @} */

/*! @name SINTCLR - Target Interrupt Clear */
/*! @{ */

#define I3C_SINTCLR_START_MASK                   (0x100U)
#define I3C_SINTCLR_START_SHIFT                  (8U)
/*! START - START Interrupt Enable Clear */
#define I3C_SINTCLR_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_START_SHIFT)) & I3C_SINTCLR_START_MASK)

#define I3C_SINTCLR_MATCHED_MASK                 (0x200U)
#define I3C_SINTCLR_MATCHED_SHIFT                (9U)
/*! MATCHED - Matched Interrupt Enable Clear */
#define I3C_SINTCLR_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_MATCHED_SHIFT)) & I3C_SINTCLR_MATCHED_MASK)

#define I3C_SINTCLR_STOP_MASK                    (0x400U)
#define I3C_SINTCLR_STOP_SHIFT                   (10U)
/*! STOP - STOP Interrupt Enable Clear */
#define I3C_SINTCLR_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_STOP_SHIFT)) & I3C_SINTCLR_STOP_MASK)

#define I3C_SINTCLR_RXPEND_MASK                  (0x800U)
#define I3C_SINTCLR_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND Interrupt Enable Clear */
#define I3C_SINTCLR_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_RXPEND_SHIFT)) & I3C_SINTCLR_RXPEND_MASK)

#define I3C_SINTCLR_TXSEND_MASK                  (0x1000U)
#define I3C_SINTCLR_TXSEND_SHIFT                 (12U)
/*! TXSEND - TXSEND Interrupt Enable Clear */
#define I3C_SINTCLR_TXSEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_TXSEND_SHIFT)) & I3C_SINTCLR_TXSEND_MASK)

#define I3C_SINTCLR_DACHG_MASK                   (0x2000U)
#define I3C_SINTCLR_DACHG_SHIFT                  (13U)
/*! DACHG - DACHG Interrupt Enable Clear */
#define I3C_SINTCLR_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_DACHG_SHIFT)) & I3C_SINTCLR_DACHG_MASK)

#define I3C_SINTCLR_CCC_MASK                     (0x4000U)
#define I3C_SINTCLR_CCC_SHIFT                    (14U)
/*! CCC - CCC Interrupt Enable Clear */
#define I3C_SINTCLR_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_CCC_SHIFT)) & I3C_SINTCLR_CCC_MASK)

#define I3C_SINTCLR_ERRWARN_MASK                 (0x8000U)
#define I3C_SINTCLR_ERRWARN_SHIFT                (15U)
/*! ERRWARN - ERRWARN Interrupt Enable Clear */
#define I3C_SINTCLR_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_ERRWARN_SHIFT)) & I3C_SINTCLR_ERRWARN_MASK)

#define I3C_SINTCLR_DDRMATCHED_MASK              (0x10000U)
#define I3C_SINTCLR_DDRMATCHED_SHIFT             (16U)
/*! DDRMATCHED - DDRMATCHED Interrupt Enable Clear */
#define I3C_SINTCLR_DDRMATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_DDRMATCHED_SHIFT)) & I3C_SINTCLR_DDRMATCHED_MASK)

#define I3C_SINTCLR_CHANDLED_MASK                (0x20000U)
#define I3C_SINTCLR_CHANDLED_SHIFT               (17U)
/*! CHANDLED - CHANDLED Interrupt Enable Clear */
#define I3C_SINTCLR_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_CHANDLED_SHIFT)) & I3C_SINTCLR_CHANDLED_MASK)

#define I3C_SINTCLR_EVENT_MASK                   (0x40000U)
#define I3C_SINTCLR_EVENT_SHIFT                  (18U)
/*! EVENT - EVENT Interrupt Enable Clear */
#define I3C_SINTCLR_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_EVENT_SHIFT)) & I3C_SINTCLR_EVENT_MASK)
/*! @} */

/*! @name SINTMASKED - Target Interrupt Mask */
/*! @{ */

#define I3C_SINTMASKED_START_MASK                (0x100U)
#define I3C_SINTMASKED_START_SHIFT               (8U)
/*! START - START Interrupt Mask */
#define I3C_SINTMASKED_START(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_START_SHIFT)) & I3C_SINTMASKED_START_MASK)

#define I3C_SINTMASKED_MATCHED_MASK              (0x200U)
#define I3C_SINTMASKED_MATCHED_SHIFT             (9U)
/*! MATCHED - MATCHED Interrupt Mask */
#define I3C_SINTMASKED_MATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_MATCHED_SHIFT)) & I3C_SINTMASKED_MATCHED_MASK)

#define I3C_SINTMASKED_STOP_MASK                 (0x400U)
#define I3C_SINTMASKED_STOP_SHIFT                (10U)
/*! STOP - STOP Interrupt Mask */
#define I3C_SINTMASKED_STOP(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_STOP_SHIFT)) & I3C_SINTMASKED_STOP_MASK)

#define I3C_SINTMASKED_RXPEND_MASK               (0x800U)
#define I3C_SINTMASKED_RXPEND_SHIFT              (11U)
/*! RXPEND - RXPEND Interrupt Mask */
#define I3C_SINTMASKED_RXPEND(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_RXPEND_SHIFT)) & I3C_SINTMASKED_RXPEND_MASK)

#define I3C_SINTMASKED_TXSEND_MASK               (0x1000U)
#define I3C_SINTMASKED_TXSEND_SHIFT              (12U)
/*! TXSEND - TXSEND Interrupt Mask */
#define I3C_SINTMASKED_TXSEND(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_TXSEND_SHIFT)) & I3C_SINTMASKED_TXSEND_MASK)

#define I3C_SINTMASKED_DACHG_MASK                (0x2000U)
#define I3C_SINTMASKED_DACHG_SHIFT               (13U)
/*! DACHG - DACHG Interrupt Mask */
#define I3C_SINTMASKED_DACHG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_DACHG_SHIFT)) & I3C_SINTMASKED_DACHG_MASK)

#define I3C_SINTMASKED_CCC_MASK                  (0x4000U)
#define I3C_SINTMASKED_CCC_SHIFT                 (14U)
/*! CCC - CCC Interrupt Mask */
#define I3C_SINTMASKED_CCC(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_CCC_SHIFT)) & I3C_SINTMASKED_CCC_MASK)

#define I3C_SINTMASKED_ERRWARN_MASK              (0x8000U)
#define I3C_SINTMASKED_ERRWARN_SHIFT             (15U)
/*! ERRWARN - ERRWARN Interrupt Mask */
#define I3C_SINTMASKED_ERRWARN(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_ERRWARN_SHIFT)) & I3C_SINTMASKED_ERRWARN_MASK)

#define I3C_SINTMASKED_DDRMATCHED_MASK           (0x10000U)
#define I3C_SINTMASKED_DDRMATCHED_SHIFT          (16U)
/*! DDRMATCHED - DDRMATCHED Interrupt Mask */
#define I3C_SINTMASKED_DDRMATCHED(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_DDRMATCHED_SHIFT)) & I3C_SINTMASKED_DDRMATCHED_MASK)

#define I3C_SINTMASKED_CHANDLED_MASK             (0x20000U)
#define I3C_SINTMASKED_CHANDLED_SHIFT            (17U)
/*! CHANDLED - CHANDLED Interrupt Mask */
#define I3C_SINTMASKED_CHANDLED(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_CHANDLED_SHIFT)) & I3C_SINTMASKED_CHANDLED_MASK)

#define I3C_SINTMASKED_EVENT_MASK                (0x40000U)
#define I3C_SINTMASKED_EVENT_SHIFT               (18U)
/*! EVENT - EVENT Interrupt Mask */
#define I3C_SINTMASKED_EVENT(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_EVENT_SHIFT)) & I3C_SINTMASKED_EVENT_MASK)
/*! @} */

/*! @name SERRWARN - Target Errors and Warnings */
/*! @{ */

#define I3C_SERRWARN_ORUN_MASK                   (0x1U)
#define I3C_SERRWARN_ORUN_SHIFT                  (0U)
/*! ORUN - Overrun Error
 *  0b1..Overrun error
 *  0b0..No overrun error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_ORUN(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_ORUN_SHIFT)) & I3C_SERRWARN_ORUN_MASK)

#define I3C_SERRWARN_URUN_MASK                   (0x2U)
#define I3C_SERRWARN_URUN_SHIFT                  (1U)
/*! URUN - Underrun Error
 *  0b1..Underrun error
 *  0b0..No underrun error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_URUN(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_URUN_SHIFT)) & I3C_SERRWARN_URUN_MASK)

#define I3C_SERRWARN_URUNNACK_MASK               (0x4U)
#define I3C_SERRWARN_URUNNACK_SHIFT              (2U)
/*! URUNNACK - Underrun and Not Acknowledged (NACKed) Error
 *  0b1..Underrun; not acknowledged error
 *  0b0..No underrun; not acknowledged error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_URUNNACK(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_URUNNACK_SHIFT)) & I3C_SERRWARN_URUNNACK_MASK)

#define I3C_SERRWARN_TERM_MASK                   (0x8U)
#define I3C_SERRWARN_TERM_SHIFT                  (3U)
/*! TERM - Terminated Error
 *  0b1..Terminated error
 *  0b0..No terminated error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_TERM(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_TERM_SHIFT)) & I3C_SERRWARN_TERM_MASK)

#define I3C_SERRWARN_INVSTART_MASK               (0x10U)
#define I3C_SERRWARN_INVSTART_SHIFT              (4U)
/*! INVSTART - Invalid Start Error
 *  0b1..Invalid start error
 *  0b0..No invalid start error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_INVSTART(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_INVSTART_SHIFT)) & I3C_SERRWARN_INVSTART_MASK)

#define I3C_SERRWARN_SPAR_MASK                   (0x100U)
#define I3C_SERRWARN_SPAR_SHIFT                  (8U)
/*! SPAR - SDR Parity Error
 *  0b1..SDR parity error
 *  0b0..No SDR parity error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_SPAR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_SPAR_SHIFT)) & I3C_SERRWARN_SPAR_MASK)

#define I3C_SERRWARN_HPAR_MASK                   (0x200U)
#define I3C_SERRWARN_HPAR_SHIFT                  (9U)
/*! HPAR - HDR Parity Error
 *  0b1..HDR parity error
 *  0b0..No HDR parity error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_HPAR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_HPAR_SHIFT)) & I3C_SERRWARN_HPAR_MASK)

#define I3C_SERRWARN_HCRC_MASK                   (0x400U)
#define I3C_SERRWARN_HCRC_SHIFT                  (10U)
/*! HCRC - HDR-DDR CRC Error
 *  0b1..HDR-DDR CRC error occurred
 *  0b0..No HDR-DDR CRC error occurred
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_HCRC(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_HCRC_SHIFT)) & I3C_SERRWARN_HCRC_MASK)

#define I3C_SERRWARN_S0S1_MASK                   (0x800U)
#define I3C_SERRWARN_S0S1_SHIFT                  (11U)
/*! S0S1 - TE0 or TE1 Error
 *  0b1..TE0 or TE1 error occurred
 *  0b0..No TE0 or TE1 error occurred
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_S0S1(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_S0S1_SHIFT)) & I3C_SERRWARN_S0S1_MASK)

#define I3C_SERRWARN_OREAD_MASK                  (0x10000U)
#define I3C_SERRWARN_OREAD_SHIFT                 (16U)
/*! OREAD - Over-Read Error
 *  0b1..Over-read error
 *  0b0..No over-read error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_OREAD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_OREAD_SHIFT)) & I3C_SERRWARN_OREAD_MASK)

#define I3C_SERRWARN_OWRITE_MASK                 (0x20000U)
#define I3C_SERRWARN_OWRITE_SHIFT                (17U)
/*! OWRITE - Over-Write Error
 *  0b1..Overwrite error
 *  0b0..No overwrite error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_SERRWARN_OWRITE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_OWRITE_SHIFT)) & I3C_SERRWARN_OWRITE_MASK)
/*! @} */

/*! @name SDMACTRL - Target DMA Control */
/*! @{ */

#define I3C_SDMACTRL_DMAFB_MASK                  (0x3U)
#define I3C_SDMACTRL_DMAFB_SHIFT                 (0U)
/*! DMAFB - DMA Read (From-Bus) Trigger
 *  0b00..DMA not used
 *  0b01..DMA enabled for one frame
 *  0b10..DMA enabled until turned off
 *  0b11..
 */
#define I3C_SDMACTRL_DMAFB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMAFB_SHIFT)) & I3C_SDMACTRL_DMAFB_MASK)

#define I3C_SDMACTRL_DMATB_MASK                  (0xCU)
#define I3C_SDMACTRL_DMATB_SHIFT                 (2U)
/*! DMATB - DMA Write (To-Bus) Trigger
 *  0b00..DMA not used
 *  0b01..DMA enabled for one frame
 *  0b10..DMA enabled until turned off
 *  0b11..
 */
#define I3C_SDMACTRL_DMATB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMATB_SHIFT)) & I3C_SDMACTRL_DMATB_MASK)

#define I3C_SDMACTRL_DMAWIDTH_MASK               (0x30U)
#define I3C_SDMACTRL_DMAWIDTH_SHIFT              (4U)
/*! DMAWIDTH - Width of DMA Operations
 *  0b00, 0b01..Byte
 *  0b10..Halfword (16 bits) (this value ensures that two bytes are available in the FIFO)
 *  0b11..
 */
#define I3C_SDMACTRL_DMAWIDTH(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMAWIDTH_SHIFT)) & I3C_SDMACTRL_DMAWIDTH_MASK)
/*! @} */

/*! @name SDATACTRL - Target Data Control */
/*! @{ */

#define I3C_SDATACTRL_FLUSHTB_MASK               (0x1U)
#define I3C_SDATACTRL_FLUSHTB_SHIFT              (0U)
/*! FLUSHTB - Flush To-Bus Buffer or FIFO */
#define I3C_SDATACTRL_FLUSHTB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_FLUSHTB_SHIFT)) & I3C_SDATACTRL_FLUSHTB_MASK)

#define I3C_SDATACTRL_FLUSHFB_MASK               (0x2U)
#define I3C_SDATACTRL_FLUSHFB_SHIFT              (1U)
/*! FLUSHFB - Flush From-Bus Buffer or FIFO */
#define I3C_SDATACTRL_FLUSHFB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_FLUSHFB_SHIFT)) & I3C_SDATACTRL_FLUSHFB_MASK)

#define I3C_SDATACTRL_UNLOCK_MASK                (0x8U)
#define I3C_SDATACTRL_UNLOCK_SHIFT               (3U)
/*! UNLOCK - Unlock
 *  0b0..Cannot be changed
 *  0b1..Can be changed
 */
#define I3C_SDATACTRL_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_UNLOCK_SHIFT)) & I3C_SDATACTRL_UNLOCK_MASK)

#define I3C_SDATACTRL_TXTRIG_MASK                (0x30U)
#define I3C_SDATACTRL_TXTRIG_SHIFT               (4U)
/*! TXTRIG - Transmit Trigger Level
 *  0b00..Trigger when empty
 *  0b01..Trigger when 1/4 full or less
 *  0b10..Trigger when 1/2 full or less
 *  0b11..Default (trigger when 1 less than full or less)
 */
#define I3C_SDATACTRL_TXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXTRIG_SHIFT)) & I3C_SDATACTRL_TXTRIG_MASK)

#define I3C_SDATACTRL_RXTRIG_MASK                (0xC0U)
#define I3C_SDATACTRL_RXTRIG_SHIFT               (6U)
/*! RXTRIG - Receive Trigger Level
 *  0b00..Trigger when not empty
 *  0b01..Trigger when 1/4 or more full
 *  0b10..Trigger when 1/2 or more full
 *  0b11..Trigger when 3/4 or more full
 */
#define I3C_SDATACTRL_RXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXTRIG_SHIFT)) & I3C_SDATACTRL_RXTRIG_MASK)

#define I3C_SDATACTRL_TXCOUNT_MASK               (0x1F0000U)
#define I3C_SDATACTRL_TXCOUNT_SHIFT              (16U)
/*! TXCOUNT - Count of Bytes in Transmit */
#define I3C_SDATACTRL_TXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXCOUNT_SHIFT)) & I3C_SDATACTRL_TXCOUNT_MASK)

#define I3C_SDATACTRL_RXCOUNT_MASK               (0x1F000000U)
#define I3C_SDATACTRL_RXCOUNT_SHIFT              (24U)
/*! RXCOUNT - Count of Bytes in Receive */
#define I3C_SDATACTRL_RXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXCOUNT_SHIFT)) & I3C_SDATACTRL_RXCOUNT_MASK)

#define I3C_SDATACTRL_TXFULL_MASK                (0x40000000U)
#define I3C_SDATACTRL_TXFULL_SHIFT               (30U)
/*! TXFULL - Transmit is Full
 *  0b1..Full
 *  0b0..Not full
 */
#define I3C_SDATACTRL_TXFULL(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXFULL_SHIFT)) & I3C_SDATACTRL_TXFULL_MASK)

#define I3C_SDATACTRL_RXEMPTY_MASK               (0x80000000U)
#define I3C_SDATACTRL_RXEMPTY_SHIFT              (31U)
/*! RXEMPTY - Receive is Empty
 *  0b1..Empty
 *  0b0..Not empty
 */
#define I3C_SDATACTRL_RXEMPTY(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXEMPTY_SHIFT)) & I3C_SDATACTRL_RXEMPTY_MASK)
/*! @} */

/*! @name SWDATAB - Target Write Data Byte */
/*! @{ */

#define I3C_SWDATAB_DATA_MASK                    (0xFFU)
#define I3C_SWDATAB_DATA_SHIFT                   (0U)
/*! DATA - Data */
#define I3C_SWDATAB_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_DATA_SHIFT)) & I3C_SWDATAB_DATA_MASK)

#define I3C_SWDATAB_END_MASK                     (0x100U)
#define I3C_SWDATAB_END_SHIFT                    (8U)
/*! END - End
 *  0b1..End
 *  0b0..Not the end
 */
#define I3C_SWDATAB_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_END_SHIFT)) & I3C_SWDATAB_END_MASK)

#define I3C_SWDATAB_END_ALSO_MASK                (0x10000U)
#define I3C_SWDATAB_END_ALSO_SHIFT               (16U)
/*! END_ALSO - End Also
 *  0b1..End
 *  0b0..Not the end
 */
#define I3C_SWDATAB_END_ALSO(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_END_ALSO_SHIFT)) & I3C_SWDATAB_END_ALSO_MASK)
/*! @} */

/*! @name SWDATABE - Target Write Data Byte End */
/*! @{ */

#define I3C_SWDATABE_DATA_MASK                   (0xFFU)
#define I3C_SWDATABE_DATA_SHIFT                  (0U)
/*! DATA - Data */
#define I3C_SWDATABE_DATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATABE_DATA_SHIFT)) & I3C_SWDATABE_DATA_MASK)
/*! @} */

/*! @name SWDATAH - Target Write Data Halfword */
/*! @{ */

#define I3C_SWDATAH_DATA0_MASK                   (0xFFU)
#define I3C_SWDATAH_DATA0_SHIFT                  (0U)
/*! DATA0 - Data 0 */
#define I3C_SWDATAH_DATA0(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_DATA0_SHIFT)) & I3C_SWDATAH_DATA0_MASK)

#define I3C_SWDATAH_DATA1_MASK                   (0xFF00U)
#define I3C_SWDATAH_DATA1_SHIFT                  (8U)
/*! DATA1 - Data 1 */
#define I3C_SWDATAH_DATA1(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_DATA1_SHIFT)) & I3C_SWDATAH_DATA1_MASK)

#define I3C_SWDATAH_END_MASK                     (0x10000U)
#define I3C_SWDATAH_END_SHIFT                    (16U)
/*! END - End of Message
 *  0b1..End
 *  0b0..Not the end
 */
#define I3C_SWDATAH_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_END_SHIFT)) & I3C_SWDATAH_END_MASK)
/*! @} */

/*! @name SWDATAHE - Target Write Data Halfword End */
/*! @{ */

#define I3C_SWDATAHE_DATA0_MASK                  (0xFFU)
#define I3C_SWDATAHE_DATA0_SHIFT                 (0U)
/*! DATA0 - Data 0 */
#define I3C_SWDATAHE_DATA0(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAHE_DATA0_SHIFT)) & I3C_SWDATAHE_DATA0_MASK)

#define I3C_SWDATAHE_DATA1_MASK                  (0xFF00U)
#define I3C_SWDATAHE_DATA1_SHIFT                 (8U)
/*! DATA1 - Data 1 */
#define I3C_SWDATAHE_DATA1(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAHE_DATA1_SHIFT)) & I3C_SWDATAHE_DATA1_MASK)
/*! @} */

/*! @name SRDATAB - Target Read Data Byte */
/*! @{ */

#define I3C_SRDATAB_DATA0_MASK                   (0xFFU)
#define I3C_SRDATAB_DATA0_SHIFT                  (0U)
/*! DATA0 - Data 0 */
#define I3C_SRDATAB_DATA0(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAB_DATA0_SHIFT)) & I3C_SRDATAB_DATA0_MASK)
/*! @} */

/*! @name SRDATAH - Target Read Data Halfword */
/*! @{ */

#define I3C_SRDATAH_LSB_MASK                     (0xFFU)
#define I3C_SRDATAH_LSB_SHIFT                    (0U)
/*! LSB - Low Byte */
#define I3C_SRDATAH_LSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAH_LSB_SHIFT)) & I3C_SRDATAH_LSB_MASK)

#define I3C_SRDATAH_MSB_MASK                     (0xFF00U)
#define I3C_SRDATAH_MSB_SHIFT                    (8U)
/*! MSB - High Byte */
#define I3C_SRDATAH_MSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAH_MSB_SHIFT)) & I3C_SRDATAH_MSB_MASK)
/*! @} */

/*! @name SWDATAB1 - Target Write Data Byte */
/*! @{ */

#define I3C_SWDATAB1_DATA_MASK                   (0xFFU)
#define I3C_SWDATAB1_DATA_SHIFT                  (0U)
/*! DATA - Data */
#define I3C_SWDATAB1_DATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB1_DATA_SHIFT)) & I3C_SWDATAB1_DATA_MASK)
/*! @} */

/*! @name SWDATAH1 - Target Write Data Halfword */
/*! @{ */

#define I3C_SWDATAH1_DATA_MASK                   (0xFFFFU)
#define I3C_SWDATAH1_DATA_SHIFT                  (0U)
/*! DATA - Data */
#define I3C_SWDATAH1_DATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH1_DATA_SHIFT)) & I3C_SWDATAH1_DATA_MASK)
/*! @} */

/*! @name SCAPABILITIES2 - Target Capabilities 2 */
/*! @{ */

#define I3C_SCAPABILITIES2_MAPCNT_MASK           (0xFU)
#define I3C_SCAPABILITIES2_MAPCNT_SHIFT          (0U)
/*! MAPCNT - Map Count */
#define I3C_SCAPABILITIES2_MAPCNT(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_MAPCNT_SHIFT)) & I3C_SCAPABILITIES2_MAPCNT_MASK)

#define I3C_SCAPABILITIES2_I2C10B_MASK           (0x10U)
#define I3C_SCAPABILITIES2_I2C10B_SHIFT          (4U)
/*! I2C10B - I2C 10-bit Address
 *  0b0..Not supported
 *  0b1..Supported
 */
#define I3C_SCAPABILITIES2_I2C10B(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_I2C10B_SHIFT)) & I3C_SCAPABILITIES2_I2C10B_MASK)

#define I3C_SCAPABILITIES2_I2CRST_MASK           (0x20U)
#define I3C_SCAPABILITIES2_I2CRST_SHIFT          (5U)
/*! I2CRST - I2C Software Reset
 *  0b0..Not supported
 *  0b1..Supported
 */
#define I3C_SCAPABILITIES2_I2CRST(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_I2CRST_SHIFT)) & I3C_SCAPABILITIES2_I2CRST_MASK)

#define I3C_SCAPABILITIES2_I2CDEVID_MASK         (0x40U)
#define I3C_SCAPABILITIES2_I2CDEVID_SHIFT        (6U)
/*! I2CDEVID - I2C Device ID
 *  0b0..Not supported
 *  0b1..Supported
 */
#define I3C_SCAPABILITIES2_I2CDEVID(x)           (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_I2CDEVID_SHIFT)) & I3C_SCAPABILITIES2_I2CDEVID_MASK)

#define I3C_SCAPABILITIES2_IBIEXT_MASK           (0x100U)
#define I3C_SCAPABILITIES2_IBIEXT_SHIFT          (8U)
/*! IBIEXT - In-Band Interrupt EXTDATA
 *  0b0..Not supported
 *  0b1..Supported
 */
#define I3C_SCAPABILITIES2_IBIEXT(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_IBIEXT_SHIFT)) & I3C_SCAPABILITIES2_IBIEXT_MASK)

#define I3C_SCAPABILITIES2_IBIXREG_MASK          (0x200U)
#define I3C_SCAPABILITIES2_IBIXREG_SHIFT         (9U)
/*! IBIXREG - In-Band Interrupt Extended Register
 *  0b0..Not supported
 *  0b1..Supported
 */
#define I3C_SCAPABILITIES2_IBIXREG(x)            (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_IBIXREG_SHIFT)) & I3C_SCAPABILITIES2_IBIXREG_MASK)

#define I3C_SCAPABILITIES2_SLVRST_MASK           (0x20000U)
#define I3C_SCAPABILITIES2_SLVRST_SHIFT          (17U)
/*! SLVRST - Target Reset
 *  0b0..Not supported
 *  0b1..Supported
 */
#define I3C_SCAPABILITIES2_SLVRST(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_SLVRST_SHIFT)) & I3C_SCAPABILITIES2_SLVRST_MASK)

#define I3C_SCAPABILITIES2_GROUP_MASK            (0xC0000U)
#define I3C_SCAPABILITIES2_GROUP_SHIFT           (18U)
/*! GROUP - Group
 *  0b00..v1.1 group addressing not supported
 *  0b01..One group supported
 *  0b10..Two groups supported
 *  0b11..Three groups supported
 */
#define I3C_SCAPABILITIES2_GROUP(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_GROUP_SHIFT)) & I3C_SCAPABILITIES2_GROUP_MASK)

#define I3C_SCAPABILITIES2_AASA_MASK             (0x200000U)
#define I3C_SCAPABILITIES2_AASA_SHIFT            (21U)
/*! AASA - SETAASA
 *  0b1..SETAASA supported
 *  0b0..SETAASA not supported
 */
#define I3C_SCAPABILITIES2_AASA(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_AASA_SHIFT)) & I3C_SCAPABILITIES2_AASA_MASK)

#define I3C_SCAPABILITIES2_SSTSUB_MASK           (0x400000U)
#define I3C_SCAPABILITIES2_SSTSUB_SHIFT          (22U)
/*! SSTSUB - Target-Target(s)-Tunnel Subscriber Capable
 *  0b1..Subscriber capable
 *  0b0..Not subscriber capable
 */
#define I3C_SCAPABILITIES2_SSTSUB(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_SSTSUB_SHIFT)) & I3C_SCAPABILITIES2_SSTSUB_MASK)

#define I3C_SCAPABILITIES2_SSTWR_MASK            (0x800000U)
#define I3C_SCAPABILITIES2_SSTWR_SHIFT           (23U)
/*! SSTWR - Target-Target(s)-Tunnel Write Capable
 *  0b1..Write capable
 *  0b0..Not write capable
 */
#define I3C_SCAPABILITIES2_SSTWR(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES2_SSTWR_SHIFT)) & I3C_SCAPABILITIES2_SSTWR_MASK)
/*! @} */

/*! @name SCAPABILITIES - Target Capabilities */
/*! @{ */

#define I3C_SCAPABILITIES_IDENA_MASK             (0x3U)
#define I3C_SCAPABILITIES_IDENA_SHIFT            (0U)
/*! IDENA - ID 48b Handler
 *  0b00..Application
 *  0b01..Hardware
 *  0b10..Hardware, but the I3C module instance handles ID 48b
 *  0b11..A part number register (PARTNO)
 */
#define I3C_SCAPABILITIES_IDENA(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IDENA_SHIFT)) & I3C_SCAPABILITIES_IDENA_MASK)

#define I3C_SCAPABILITIES_IDREG_MASK             (0x3CU)
#define I3C_SCAPABILITIES_IDREG_SHIFT            (2U)
/*! IDREG - ID Register
 *  0b0000..All ID register features disabled
 *  0bxxx1..ID Instance is a register; used if there is no PARTNO register
 *  0bxx1x..An ID Random field is available
 *  0bx1xx..A Device Characteristic Register (DCR) is available
 *  0b1xxx..A Bus Characteristics Register (BCR) is available
 */
#define I3C_SCAPABILITIES_IDREG(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IDREG_SHIFT)) & I3C_SCAPABILITIES_IDREG_MASK)

#define I3C_SCAPABILITIES_HDRSUPP_MASK           (0xC0U)
#define I3C_SCAPABILITIES_HDRSUPP_SHIFT          (6U)
/*! HDRSUPP - High Data Rate Support
 *  0b00..No HDR modes supported
 *  0b01..DDR mode supported
 *  *..
 */
#define I3C_SCAPABILITIES_HDRSUPP(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_HDRSUPP_SHIFT)) & I3C_SCAPABILITIES_HDRSUPP_MASK)

#define I3C_SCAPABILITIES_MASTER_MASK            (0x200U)
#define I3C_SCAPABILITIES_MASTER_SHIFT           (9U)
/*! MASTER - Controller
 *  0b0..Not supported
 *  0b1..Supported
 */
#define I3C_SCAPABILITIES_MASTER(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_MASTER_SHIFT)) & I3C_SCAPABILITIES_MASTER_MASK)

#define I3C_SCAPABILITIES_SADDR_MASK             (0xC00U)
#define I3C_SCAPABILITIES_SADDR_SHIFT            (10U)
/*! SADDR - Static Address
 *  0b00..No static address
 *  0b01..Static address is fixed in hardware
 *  0b10..Hardware controls the static address dynamically (for example, from the pin strap)
 *  0b11..SCONFIG register supplies the static address
 */
#define I3C_SCAPABILITIES_SADDR(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_SADDR_SHIFT)) & I3C_SCAPABILITIES_SADDR_MASK)

#define I3C_SCAPABILITIES_CCCHANDLE_MASK         (0xF000U)
#define I3C_SCAPABILITIES_CCCHANDLE_SHIFT        (12U)
/*! CCCHANDLE - Common Command Codes Handling
 *  0b0000..All handling features disabled
 *  0bxxx1..The I3C module manages events, activities, status, HDR, and if enabled for it, ID and static-address-related items
 *  0bxx1x..The I3C module manages maximum read and write lengths, and max data speed
 *  0bx1xx..GETSTATUS CCC returns the values of SCTRL[PENDINT] and SCTRL[ACTSTATE]
 *  0b1xxx..GETSTATUS CCC returns the value of SCTRL[VENDINFO]
 */
#define I3C_SCAPABILITIES_CCCHANDLE(x)           (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_CCCHANDLE_SHIFT)) & I3C_SCAPABILITIES_CCCHANDLE_MASK)

#define I3C_SCAPABILITIES_IBI_MR_HJ_MASK         (0x1F0000U)
#define I3C_SCAPABILITIES_IBI_MR_HJ_SHIFT        (16U)
/*! IBI_MR_HJ - In-Band Interrupts, Controller Requests, Hot-Join Events
 *  0b00000..Application cannot generate IBI, CR, or HJ
 *  0bxxxx1..Application can generate an IBI
 *  0bxxx1x..When bit 0 = 1, the IBI has data from the SCTRL register
 *  0bxx1xx..Application can generate a controller request for a secondary controller
 *  0bx1xxx..Application can generate a Hot-Join event
 *  0b1xxxx..Application can use SCONFIG[BAMATCH] for bus-available timing
 */
#define I3C_SCAPABILITIES_IBI_MR_HJ(x)           (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IBI_MR_HJ_SHIFT)) & I3C_SCAPABILITIES_IBI_MR_HJ_MASK)

#define I3C_SCAPABILITIES_TIMECTRL_MASK          (0x200000U)
#define I3C_SCAPABILITIES_TIMECTRL_SHIFT         (21U)
/*! TIMECTRL - Time Control
 *  0b0..No time control supported
 *  0b1..At least one time-control type supported
 */
#define I3C_SCAPABILITIES_TIMECTRL(x)            (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_TIMECTRL_SHIFT)) & I3C_SCAPABILITIES_TIMECTRL_MASK)

#define I3C_SCAPABILITIES_EXTFIFO_MASK           (0x3800000U)
#define I3C_SCAPABILITIES_EXTFIFO_SHIFT          (23U)
/*! EXTFIFO - External FIFO
 *  0b000..No external FIFO available
 *  0b001..Standard available or free external FIFO
 *  0b010..Request track external FIFO
 *  *..
 */
#define I3C_SCAPABILITIES_EXTFIFO(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_EXTFIFO_SHIFT)) & I3C_SCAPABILITIES_EXTFIFO_MASK)

#define I3C_SCAPABILITIES_FIFOTX_MASK            (0xC000000U)
#define I3C_SCAPABILITIES_FIFOTX_SHIFT           (26U)
/*! FIFOTX - FIFO Transmit
 *  0b00..Two
 *  0b01..Four
 *  0b10..Eight
 *  0b11..16 or larger
 */
#define I3C_SCAPABILITIES_FIFOTX(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_FIFOTX_SHIFT)) & I3C_SCAPABILITIES_FIFOTX_MASK)

#define I3C_SCAPABILITIES_FIFORX_MASK            (0x30000000U)
#define I3C_SCAPABILITIES_FIFORX_SHIFT           (28U)
/*! FIFORX - FIFO Receive
 *  0b00..Two or three
 *  0b01..Four
 *  0b10..Eight
 *  0b11..16 or larger
 */
#define I3C_SCAPABILITIES_FIFORX(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_FIFORX_SHIFT)) & I3C_SCAPABILITIES_FIFORX_MASK)

#define I3C_SCAPABILITIES_INT_MASK               (0x40000000U)
#define I3C_SCAPABILITIES_INT_SHIFT              (30U)
/*! INT - Interrupts
 *  0b1..Supported
 *  0b0..Not supported
 */
#define I3C_SCAPABILITIES_INT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_INT_SHIFT)) & I3C_SCAPABILITIES_INT_MASK)

#define I3C_SCAPABILITIES_DMA_MASK               (0x80000000U)
#define I3C_SCAPABILITIES_DMA_SHIFT              (31U)
/*! DMA - Direct Memory Access
 *  0b1..Supported
 *  0b0..Not supported
 */
#define I3C_SCAPABILITIES_DMA(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_DMA_SHIFT)) & I3C_SCAPABILITIES_DMA_MASK)
/*! @} */

/*! @name SDYNADDR - Target Dynamic Address */
/*! @{ */

#define I3C_SDYNADDR_DAVALID_MASK                (0x1U)
#define I3C_SDYNADDR_DAVALID_SHIFT               (0U)
/*! DAVALID - Dynamic Address Valid
 *  0b0..DANOTASSIGNED: a dynamic address is not assigned
 *  0b1..DAASSIGNED: a dynamic address is assigned
 */
#define I3C_SDYNADDR_DAVALID(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_DAVALID_SHIFT)) & I3C_SDYNADDR_DAVALID_MASK)

#define I3C_SDYNADDR_DADDR_MASK                  (0xFEU)
#define I3C_SDYNADDR_DADDR_SHIFT                 (1U)
/*! DADDR - Dynamic Address */
#define I3C_SDYNADDR_DADDR(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_DADDR_SHIFT)) & I3C_SDYNADDR_DADDR_MASK)

#define I3C_SDYNADDR_MAPSA_MASK                  (0x1000U)
#define I3C_SDYNADDR_MAPSA_SHIFT                 (12U)
/*! MAPSA - Map a Static Address */
#define I3C_SDYNADDR_MAPSA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_MAPSA_SHIFT)) & I3C_SDYNADDR_MAPSA_MASK)

#define I3C_SDYNADDR_SA10B_MASK                  (0xE000U)
#define I3C_SDYNADDR_SA10B_SHIFT                 (13U)
/*! SA10B - 10-Bit Static Address */
#define I3C_SDYNADDR_SA10B(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_SA10B_SHIFT)) & I3C_SDYNADDR_SA10B_MASK)

#define I3C_SDYNADDR_KEY_MASK                    (0xFFFF0000U)
#define I3C_SDYNADDR_KEY_SHIFT                   (16U)
/*! KEY - Key */
#define I3C_SDYNADDR_KEY(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_KEY_SHIFT)) & I3C_SDYNADDR_KEY_MASK)
/*! @} */

/*! @name SMAXLIMITS - Target Maximum Limits */
/*! @{ */

#define I3C_SMAXLIMITS_MAXRD_MASK                (0xFFFU)
#define I3C_SMAXLIMITS_MAXRD_SHIFT               (0U)
/*! MAXRD - Maximum Read Length */
#define I3C_SMAXLIMITS_MAXRD(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SMAXLIMITS_MAXRD_SHIFT)) & I3C_SMAXLIMITS_MAXRD_MASK)

#define I3C_SMAXLIMITS_MAXWR_MASK                (0xFFF0000U)
#define I3C_SMAXLIMITS_MAXWR_SHIFT               (16U)
/*! MAXWR - Maximum Write Length */
#define I3C_SMAXLIMITS_MAXWR(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SMAXLIMITS_MAXWR_SHIFT)) & I3C_SMAXLIMITS_MAXWR_MASK)
/*! @} */

/*! @name SIDPARTNO - Target ID Part Number */
/*! @{ */

#define I3C_SIDPARTNO_PARTNO_MASK                (0xFFFFFFFFU)
#define I3C_SIDPARTNO_PARTNO_SHIFT               (0U)
/*! PARTNO - Part Number */
#define I3C_SIDPARTNO_PARTNO(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SIDPARTNO_PARTNO_SHIFT)) & I3C_SIDPARTNO_PARTNO_MASK)
/*! @} */

/*! @name SIDEXT - Target ID Extension */
/*! @{ */

#define I3C_SIDEXT_DCR_MASK                      (0xFF00U)
#define I3C_SIDEXT_DCR_SHIFT                     (8U)
/*! DCR - Device Characteristic Register */
#define I3C_SIDEXT_DCR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_SIDEXT_DCR_SHIFT)) & I3C_SIDEXT_DCR_MASK)

#define I3C_SIDEXT_BCR_MASK                      (0xFF0000U)
#define I3C_SIDEXT_BCR_SHIFT                     (16U)
/*! BCR - Bus Characteristics Register */
#define I3C_SIDEXT_BCR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_SIDEXT_BCR_SHIFT)) & I3C_SIDEXT_BCR_MASK)
/*! @} */

/*! @name SVENDORID - Target Vendor ID */
/*! @{ */

#define I3C_SVENDORID_VID_MASK                   (0x7FFFU)
#define I3C_SVENDORID_VID_SHIFT                  (0U)
/*! VID - Vendor ID */
#define I3C_SVENDORID_VID(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SVENDORID_VID_SHIFT)) & I3C_SVENDORID_VID_MASK)
/*! @} */

/*! @name STCCLOCK - Target Time Control Clock */
/*! @{ */

#define I3C_STCCLOCK_ACCURACY_MASK               (0xFFU)
#define I3C_STCCLOCK_ACCURACY_SHIFT              (0U)
/*! ACCURACY - Clock Accuracy */
#define I3C_STCCLOCK_ACCURACY(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_STCCLOCK_ACCURACY_SHIFT)) & I3C_STCCLOCK_ACCURACY_MASK)

#define I3C_STCCLOCK_FREQ_MASK                   (0xFF00U)
#define I3C_STCCLOCK_FREQ_SHIFT                  (8U)
/*! FREQ - Clock Frequency */
#define I3C_STCCLOCK_FREQ(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_STCCLOCK_FREQ_SHIFT)) & I3C_STCCLOCK_FREQ_MASK)
/*! @} */

/*! @name SMSGMAPADDR - Target Message Map Address */
/*! @{ */

#define I3C_SMSGMAPADDR_MAPLAST_MASK             (0xFU)
#define I3C_SMSGMAPADDR_MAPLAST_SHIFT            (0U)
/*! MAPLAST - Matched Address Index */
#define I3C_SMSGMAPADDR_MAPLAST(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLAST_SHIFT)) & I3C_SMSGMAPADDR_MAPLAST_MASK)

#define I3C_SMSGMAPADDR_LASTSTATIC_MASK          (0x10U)
#define I3C_SMSGMAPADDR_LASTSTATIC_SHIFT         (4U)
/*! LASTSTATIC - Last Static Address Matched
 *  0b1..I2C static address
 *  0b0..I3C dynamic address
 */
#define I3C_SMSGMAPADDR_LASTSTATIC(x)            (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_LASTSTATIC_SHIFT)) & I3C_SMSGMAPADDR_LASTSTATIC_MASK)

#define I3C_SMSGMAPADDR_MAPLASTM1_MASK           (0xF00U)
#define I3C_SMSGMAPADDR_MAPLASTM1_SHIFT          (8U)
/*! MAPLASTM1 - Matched Previous Address Index 1 */
#define I3C_SMSGMAPADDR_MAPLASTM1(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLASTM1_SHIFT)) & I3C_SMSGMAPADDR_MAPLASTM1_MASK)

#define I3C_SMSGMAPADDR_MAPLASTM2_MASK           (0xF0000U)
#define I3C_SMSGMAPADDR_MAPLASTM2_SHIFT          (16U)
/*! MAPLASTM2 - Matched Previous Index 2 */
#define I3C_SMSGMAPADDR_MAPLASTM2(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLASTM2_SHIFT)) & I3C_SMSGMAPADDR_MAPLASTM2_MASK)
/*! @} */

/*! @name MCONFIG_EXT - Controller Extended Configuration */
/*! @{ */

#define I3C_MCONFIG_EXT_I3C_CAS_DEL_MASK         (0x30000U)
#define I3C_MCONFIG_EXT_I3C_CAS_DEL_SHIFT        (16U)
/*! I3C_CAS_DEL - I3C CAS Delay After START
 *  0b00..No delay
 *  0b01..Increases SCL clock period by 1/2
 *  0b10..Increases SCL clock period by 1
 *  0b11..Increases SCL clock period by 3/2
 */
#define I3C_MCONFIG_EXT_I3C_CAS_DEL(x)           (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_EXT_I3C_CAS_DEL_SHIFT)) & I3C_MCONFIG_EXT_I3C_CAS_DEL_MASK)

#define I3C_MCONFIG_EXT_I3C_CASR_DEL_MASK        (0xC0000U)
#define I3C_MCONFIG_EXT_I3C_CASR_DEL_SHIFT       (18U)
/*! I3C_CASR_DEL - I3C CAS Delay After Repeated START
 *  0b00..No delay
 *  0b01..Increases SCL clock period by 1/2
 *  0b10..Increases SCL clock period by 1
 *  0b11..Increases SCL clock period by 1 1/2
 */
#define I3C_MCONFIG_EXT_I3C_CASR_DEL(x)          (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_EXT_I3C_CASR_DEL_SHIFT)) & I3C_MCONFIG_EXT_I3C_CASR_DEL_MASK)
/*! @} */

/*! @name MCTRL - Controller Control */
/*! @{ */

#define I3C_MCTRL_REQUEST_MASK                   (0x7U)
#define I3C_MCTRL_REQUEST_SHIFT                  (0U)
/*! REQUEST - Request
 *  0b000..NONE
 *  0b001..EMITSTARTADDR
 *  0b010..EMITSTOP
 *  0b011..IBIACKNACK
 *  0b100..PROCESSDAA
 *  0b101..
 *  0b110..Force Exit and Target Reset
 *  0b111..AUTOIBI
 */
#define I3C_MCTRL_REQUEST(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_REQUEST_SHIFT)) & I3C_MCTRL_REQUEST_MASK)

#define I3C_MCTRL_TYPE_MASK                      (0x30U)
#define I3C_MCTRL_TYPE_SHIFT                     (4U)
/*! TYPE - Bus Type with EmitStartAddr
 *  0b00..I3C
 *  0b01..I2C
 *  0b10..DDR
 *  0b11..
 */
#define I3C_MCTRL_TYPE(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_TYPE_SHIFT)) & I3C_MCTRL_TYPE_MASK)

#define I3C_MCTRL_IBIRESP_MASK                   (0xC0U)
#define I3C_MCTRL_IBIRESP_SHIFT                  (6U)
/*! IBIRESP - In-Band Interrupt Response
 *  0b00..ACK (acknowledge)
 *  0b01..NACK (reject)
 *  0b10..Acknowledge with mandatory byte
 *  0b11..Manual
 */
#define I3C_MCTRL_IBIRESP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_IBIRESP_SHIFT)) & I3C_MCTRL_IBIRESP_MASK)

#define I3C_MCTRL_DIR_MASK                       (0x100U)
#define I3C_MCTRL_DIR_SHIFT                      (8U)
/*! DIR - Direction
 *  0b0..Write
 *  0b1..Read
 */
#define I3C_MCTRL_DIR(x)                         (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_DIR_SHIFT)) & I3C_MCTRL_DIR_MASK)

#define I3C_MCTRL_ADDR_MASK                      (0xFE00U)
#define I3C_MCTRL_ADDR_SHIFT                     (9U)
/*! ADDR - Address */
#define I3C_MCTRL_ADDR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_ADDR_SHIFT)) & I3C_MCTRL_ADDR_MASK)

#define I3C_MCTRL_RDTERM_MASK                    (0xFF0000U)
#define I3C_MCTRL_RDTERM_SHIFT                   (16U)
/*! RDTERM - Read Terminate Counter */
#define I3C_MCTRL_RDTERM(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_RDTERM_SHIFT)) & I3C_MCTRL_RDTERM_MASK)
/*! @} */

/*! @name MSTATUS - Controller Status */
/*! @{ */

#define I3C_MSTATUS_STATE_MASK                   (0x7U)
#define I3C_MSTATUS_STATE_SHIFT                  (0U)
/*! STATE - State of the Controller
 *  0b000..IDLE (bus has stopped)
 *  0b001..SLVREQ (target request)
 *  0b010..MSGSDR
 *  0b011..NORMACT
 *  0b100..MSGDDR
 *  0b101..DAA
 *  0b110..IBIACK
 *  0b111..IBIRCV
 */
#define I3C_MSTATUS_STATE(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_STATE_SHIFT)) & I3C_MSTATUS_STATE_MASK)

#define I3C_MSTATUS_BETWEEN_MASK                 (0x10U)
#define I3C_MSTATUS_BETWEEN_SHIFT                (4U)
/*! BETWEEN - Between
 *  0b0..Inactive (for other cases)
 *  0b1..Active
 */
#define I3C_MSTATUS_BETWEEN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_BETWEEN_SHIFT)) & I3C_MSTATUS_BETWEEN_MASK)

#define I3C_MSTATUS_NACKED_MASK                  (0x20U)
#define I3C_MSTATUS_NACKED_SHIFT                 (5U)
/*! NACKED - Not Acknowledged
 *  0b1..NACKed (not acknowledged)
 *  0b0..Not NACKed
 */
#define I3C_MSTATUS_NACKED(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_NACKED_SHIFT)) & I3C_MSTATUS_NACKED_MASK)

#define I3C_MSTATUS_IBITYPE_MASK                 (0xC0U)
#define I3C_MSTATUS_IBITYPE_SHIFT                (6U)
/*! IBITYPE - In-Band Interrupt (IBI) Type
 *  0b00..NONE (no IBI: this status occurs when MSTATUS[IBIWON] becomes 0)
 *  0b01..IBI
 *  0b10..CR
 *  0b11..HJ
 */
#define I3C_MSTATUS_IBITYPE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBITYPE_SHIFT)) & I3C_MSTATUS_IBITYPE_MASK)

#define I3C_MSTATUS_SLVSTART_MASK                (0x100U)
#define I3C_MSTATUS_SLVSTART_SHIFT               (8U)
/*! SLVSTART - Target Start
 *  0b1..Target requesting START
 *  0b0..Target not requesting START
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MSTATUS_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_SLVSTART_SHIFT)) & I3C_MSTATUS_SLVSTART_MASK)

#define I3C_MSTATUS_MCTRLDONE_MASK               (0x200U)
#define I3C_MSTATUS_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - Controller Control Done
 *  0b1..Done
 *  0b0..Not done
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MSTATUS_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_MCTRLDONE_SHIFT)) & I3C_MSTATUS_MCTRLDONE_MASK)

#define I3C_MSTATUS_COMPLETE_MASK                (0x400U)
#define I3C_MSTATUS_COMPLETE_SHIFT               (10U)
/*! COMPLETE - Complete
 *  0b1..Complete
 *  0b0..Not complete
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MSTATUS_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_COMPLETE_SHIFT)) & I3C_MSTATUS_COMPLETE_MASK)

#define I3C_MSTATUS_RXPEND_MASK                  (0x800U)
#define I3C_MSTATUS_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND
 *  0b1..Receive message pending
 *  0b0..No receive message pending
 */
#define I3C_MSTATUS_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_RXPEND_SHIFT)) & I3C_MSTATUS_RXPEND_MASK)

#define I3C_MSTATUS_TXNOTFULL_MASK               (0x1000U)
#define I3C_MSTATUS_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - TX Buffer or FIFO Not Full
 *  0b1..Receive buffer or FIFO not full
 *  0b0..Receive buffer or FIFO full
 */
#define I3C_MSTATUS_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_TXNOTFULL_SHIFT)) & I3C_MSTATUS_TXNOTFULL_MASK)

#define I3C_MSTATUS_IBIWON_MASK                  (0x2000U)
#define I3C_MSTATUS_IBIWON_SHIFT                 (13U)
/*! IBIWON - In-Band Interrupt (IBI) Won
 *  0b1..IBI arbitration won
 *  0b0..No IBI arbitration won
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MSTATUS_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBIWON_SHIFT)) & I3C_MSTATUS_IBIWON_MASK)

#define I3C_MSTATUS_ERRWARN_MASK                 (0x8000U)
#define I3C_MSTATUS_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error or Warning
 *  0b1..Error or warning
 *  0b0..No error or warning
 */
#define I3C_MSTATUS_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_ERRWARN_SHIFT)) & I3C_MSTATUS_ERRWARN_MASK)

#define I3C_MSTATUS_NOWMASTER_MASK               (0x80000U)
#define I3C_MSTATUS_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - Module is now Controller
 *  0b1..Controller
 *  0b0..Not a controller
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MSTATUS_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_NOWMASTER_SHIFT)) & I3C_MSTATUS_NOWMASTER_MASK)

#define I3C_MSTATUS_IBIADDR_MASK                 (0x7F000000U)
#define I3C_MSTATUS_IBIADDR_SHIFT                (24U)
/*! IBIADDR - IBI Address */
#define I3C_MSTATUS_IBIADDR(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBIADDR_SHIFT)) & I3C_MSTATUS_IBIADDR_MASK)
/*! @} */

/*! @name MIBIRULES - Controller In-band Interrupt Registry and Rules */
/*! @{ */

#define I3C_MIBIRULES_ADDR0_MASK                 (0x3FU)
#define I3C_MIBIRULES_ADDR0_SHIFT                (0U)
/*! ADDR0 - ADDR0 */
#define I3C_MIBIRULES_ADDR0(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR0_SHIFT)) & I3C_MIBIRULES_ADDR0_MASK)

#define I3C_MIBIRULES_ADDR1_MASK                 (0xFC0U)
#define I3C_MIBIRULES_ADDR1_SHIFT                (6U)
/*! ADDR1 - ADDR1 */
#define I3C_MIBIRULES_ADDR1(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR1_SHIFT)) & I3C_MIBIRULES_ADDR1_MASK)

#define I3C_MIBIRULES_ADDR2_MASK                 (0x3F000U)
#define I3C_MIBIRULES_ADDR2_SHIFT                (12U)
/*! ADDR2 - ADDR2 */
#define I3C_MIBIRULES_ADDR2(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR2_SHIFT)) & I3C_MIBIRULES_ADDR2_MASK)

#define I3C_MIBIRULES_ADDR3_MASK                 (0xFC0000U)
#define I3C_MIBIRULES_ADDR3_SHIFT                (18U)
/*! ADDR3 - ADDR3 */
#define I3C_MIBIRULES_ADDR3(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR3_SHIFT)) & I3C_MIBIRULES_ADDR3_MASK)

#define I3C_MIBIRULES_ADDR4_MASK                 (0x3F000000U)
#define I3C_MIBIRULES_ADDR4_SHIFT                (24U)
/*! ADDR4 - ADDR4 */
#define I3C_MIBIRULES_ADDR4(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR4_SHIFT)) & I3C_MIBIRULES_ADDR4_MASK)

#define I3C_MIBIRULES_MSB0_MASK                  (0x40000000U)
#define I3C_MIBIRULES_MSB0_SHIFT                 (30U)
/*! MSB0 - Most Significant Address Bit is 0
 *  0b1..MSB is 0
 *  0b0..MSB is not 0
 */
#define I3C_MIBIRULES_MSB0(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_MSB0_SHIFT)) & I3C_MIBIRULES_MSB0_MASK)

#define I3C_MIBIRULES_NOBYTE_MASK                (0x80000000U)
#define I3C_MIBIRULES_NOBYTE_SHIFT               (31U)
/*! NOBYTE - No IBI byte
 *  0b1..Without mandatory IBI byte
 *  0b0..With mandatory IBI byte
 */
#define I3C_MIBIRULES_NOBYTE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_NOBYTE_SHIFT)) & I3C_MIBIRULES_NOBYTE_MASK)
/*! @} */

/*! @name MINTSET - Controller Interrupt Set */
/*! @{ */

#define I3C_MINTSET_SLVSTART_MASK                (0x100U)
#define I3C_MINTSET_SLVSTART_SHIFT               (8U)
/*! SLVSTART - Target Start Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MINTSET_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_SLVSTART_SHIFT)) & I3C_MINTSET_SLVSTART_MASK)

#define I3C_MINTSET_MCTRLDONE_MASK               (0x200U)
#define I3C_MINTSET_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - Controller Control Done Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MINTSET_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_MCTRLDONE_SHIFT)) & I3C_MINTSET_MCTRLDONE_MASK)

#define I3C_MINTSET_COMPLETE_MASK                (0x400U)
#define I3C_MINTSET_COMPLETE_SHIFT               (10U)
/*! COMPLETE - Completed Message Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MINTSET_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_COMPLETE_SHIFT)) & I3C_MINTSET_COMPLETE_MASK)

#define I3C_MINTSET_RXPEND_MASK                  (0x800U)
#define I3C_MINTSET_RXPEND_SHIFT                 (11U)
/*! RXPEND - Receive Pending Interrupt Enable */
#define I3C_MINTSET_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_RXPEND_SHIFT)) & I3C_MINTSET_RXPEND_MASK)

#define I3C_MINTSET_TXNOTFULL_MASK               (0x1000U)
#define I3C_MINTSET_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - Transmit Buffer/FIFO Not Full Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MINTSET_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_TXNOTFULL_SHIFT)) & I3C_MINTSET_TXNOTFULL_MASK)

#define I3C_MINTSET_IBIWON_MASK                  (0x2000U)
#define I3C_MINTSET_IBIWON_SHIFT                 (13U)
/*! IBIWON - IBI Won Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MINTSET_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_IBIWON_SHIFT)) & I3C_MINTSET_IBIWON_MASK)

#define I3C_MINTSET_ERRWARN_MASK                 (0x8000U)
#define I3C_MINTSET_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error or Warning (ERRWARN) Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MINTSET_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_ERRWARN_SHIFT)) & I3C_MINTSET_ERRWARN_MASK)

#define I3C_MINTSET_NOWMASTER_MASK               (0x80000U)
#define I3C_MINTSET_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - Now Controller Interrupt Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define I3C_MINTSET_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_NOWMASTER_SHIFT)) & I3C_MINTSET_NOWMASTER_MASK)
/*! @} */

/*! @name MINTCLR - Controller Interrupt Clear */
/*! @{ */

#define I3C_MINTCLR_SLVSTART_MASK                (0x100U)
#define I3C_MINTCLR_SLVSTART_SHIFT               (8U)
/*! SLVSTART - SLVSTART Interrupt Enable Clear
 *  0b1..Interrupt enable cleared
 *  0b0..No effect
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MINTCLR_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_SLVSTART_SHIFT)) & I3C_MINTCLR_SLVSTART_MASK)

#define I3C_MINTCLR_MCTRLDONE_MASK               (0x200U)
#define I3C_MINTCLR_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - MCTRLDONE Interrupt Enable Clear
 *  0b1..Interrupt enable cleared
 *  0b0..No effect
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MINTCLR_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_MCTRLDONE_SHIFT)) & I3C_MINTCLR_MCTRLDONE_MASK)

#define I3C_MINTCLR_COMPLETE_MASK                (0x400U)
#define I3C_MINTCLR_COMPLETE_SHIFT               (10U)
/*! COMPLETE - COMPLETE Interrupt Enable Clear
 *  0b1..Interrupt enable cleared
 *  0b0..No effect
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MINTCLR_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_COMPLETE_SHIFT)) & I3C_MINTCLR_COMPLETE_MASK)

#define I3C_MINTCLR_RXPEND_MASK                  (0x800U)
#define I3C_MINTCLR_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND Interrupt Enable Clear
 *  0b1..Interrupt enable cleared
 *  0b0..No effect
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MINTCLR_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_RXPEND_SHIFT)) & I3C_MINTCLR_RXPEND_MASK)

#define I3C_MINTCLR_TXNOTFULL_MASK               (0x1000U)
#define I3C_MINTCLR_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - TXNOTFULL Interrupt Enable Clear
 *  0b1..Interrupt enable cleared
 *  0b0..No effect
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MINTCLR_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_TXNOTFULL_SHIFT)) & I3C_MINTCLR_TXNOTFULL_MASK)

#define I3C_MINTCLR_IBIWON_MASK                  (0x2000U)
#define I3C_MINTCLR_IBIWON_SHIFT                 (13U)
/*! IBIWON - IBIWON Interrupt Enable Clear
 *  0b1..Interrupt enable cleared
 *  0b0..No effect
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MINTCLR_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_IBIWON_SHIFT)) & I3C_MINTCLR_IBIWON_MASK)

#define I3C_MINTCLR_ERRWARN_MASK                 (0x8000U)
#define I3C_MINTCLR_ERRWARN_SHIFT                (15U)
/*! ERRWARN - ERRWARN Interrupt Enable Clear
 *  0b1..Interrupt enable cleared
 *  0b0..No effect
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MINTCLR_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_ERRWARN_SHIFT)) & I3C_MINTCLR_ERRWARN_MASK)

#define I3C_MINTCLR_NOWMASTER_MASK               (0x80000U)
#define I3C_MINTCLR_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - NOWCONTROLLER Interrupt Enable Clear
 *  0b1..Interrupt enable cleared
 *  0b0..No effect
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MINTCLR_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_NOWMASTER_SHIFT)) & I3C_MINTCLR_NOWMASTER_MASK)
/*! @} */

/*! @name MINTMASKED - Controller Interrupt Mask */
/*! @{ */

#define I3C_MINTMASKED_SLVSTART_MASK             (0x100U)
#define I3C_MINTMASKED_SLVSTART_SHIFT            (8U)
/*! SLVSTART - SLVSTART Interrupt Mask
 *  0b1..Enabled
 *  0b0..Disabled
 */
#define I3C_MINTMASKED_SLVSTART(x)               (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_SLVSTART_SHIFT)) & I3C_MINTMASKED_SLVSTART_MASK)

#define I3C_MINTMASKED_MCTRLDONE_MASK            (0x200U)
#define I3C_MINTMASKED_MCTRLDONE_SHIFT           (9U)
/*! MCTRLDONE - MCTRLDONE Interrupt Mask
 *  0b1..Enabled
 *  0b0..Disabled
 */
#define I3C_MINTMASKED_MCTRLDONE(x)              (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_MCTRLDONE_SHIFT)) & I3C_MINTMASKED_MCTRLDONE_MASK)

#define I3C_MINTMASKED_COMPLETE_MASK             (0x400U)
#define I3C_MINTMASKED_COMPLETE_SHIFT            (10U)
/*! COMPLETE - COMPLETE Interrupt Mask
 *  0b1..Enabled
 *  0b0..Disabled
 */
#define I3C_MINTMASKED_COMPLETE(x)               (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_COMPLETE_SHIFT)) & I3C_MINTMASKED_COMPLETE_MASK)

#define I3C_MINTMASKED_RXPEND_MASK               (0x800U)
#define I3C_MINTMASKED_RXPEND_SHIFT              (11U)
/*! RXPEND - RXPEND Interrupt Mask */
#define I3C_MINTMASKED_RXPEND(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_RXPEND_SHIFT)) & I3C_MINTMASKED_RXPEND_MASK)

#define I3C_MINTMASKED_TXNOTFULL_MASK            (0x1000U)
#define I3C_MINTMASKED_TXNOTFULL_SHIFT           (12U)
/*! TXNOTFULL - TXNOTFULL Interrupt Mask
 *  0b1..Enabled
 *  0b0..Disabled
 */
#define I3C_MINTMASKED_TXNOTFULL(x)              (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_TXNOTFULL_SHIFT)) & I3C_MINTMASKED_TXNOTFULL_MASK)

#define I3C_MINTMASKED_IBIWON_MASK               (0x2000U)
#define I3C_MINTMASKED_IBIWON_SHIFT              (13U)
/*! IBIWON - IBIWON Interrupt Mask
 *  0b1..Enabled
 *  0b0..Disabled
 */
#define I3C_MINTMASKED_IBIWON(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_IBIWON_SHIFT)) & I3C_MINTMASKED_IBIWON_MASK)

#define I3C_MINTMASKED_ERRWARN_MASK              (0x8000U)
#define I3C_MINTMASKED_ERRWARN_SHIFT             (15U)
/*! ERRWARN - ERRWARN Interrupt Mask
 *  0b1..Enabled
 *  0b0..Disabled
 */
#define I3C_MINTMASKED_ERRWARN(x)                (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_ERRWARN_SHIFT)) & I3C_MINTMASKED_ERRWARN_MASK)

#define I3C_MINTMASKED_NOWMASTER_MASK            (0x80000U)
#define I3C_MINTMASKED_NOWMASTER_SHIFT           (19U)
/*! NOWMASTER - NOWCONTROLLER Interrupt Mask
 *  0b1..Enabled
 *  0b0..Disabled
 */
#define I3C_MINTMASKED_NOWMASTER(x)              (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_NOWMASTER_SHIFT)) & I3C_MINTMASKED_NOWMASTER_MASK)
/*! @} */

/*! @name MERRWARN - Controller Errors and Warnings */
/*! @{ */

#define I3C_MERRWARN_URUN_MASK                   (0x2U)
#define I3C_MERRWARN_URUN_SHIFT                  (1U)
/*! URUN - Underrun Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_URUN(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_URUN_SHIFT)) & I3C_MERRWARN_URUN_MASK)

#define I3C_MERRWARN_NACK_MASK                   (0x4U)
#define I3C_MERRWARN_NACK_SHIFT                  (2U)
/*! NACK - Not Acknowledge Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_NACK(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_NACK_SHIFT)) & I3C_MERRWARN_NACK_MASK)

#define I3C_MERRWARN_WRABT_MASK                  (0x8U)
#define I3C_MERRWARN_WRABT_SHIFT                 (3U)
/*! WRABT - Write Abort Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_WRABT(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_WRABT_SHIFT)) & I3C_MERRWARN_WRABT_MASK)

#define I3C_MERRWARN_TERM_MASK                   (0x10U)
#define I3C_MERRWARN_TERM_SHIFT                  (4U)
/*! TERM - Terminate Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_TERM(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_TERM_SHIFT)) & I3C_MERRWARN_TERM_MASK)

#define I3C_MERRWARN_HPAR_MASK                   (0x200U)
#define I3C_MERRWARN_HPAR_SHIFT                  (9U)
/*! HPAR - High Data Rate Parity
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_HPAR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_HPAR_SHIFT)) & I3C_MERRWARN_HPAR_MASK)

#define I3C_MERRWARN_HCRC_MASK                   (0x400U)
#define I3C_MERRWARN_HCRC_SHIFT                  (10U)
/*! HCRC - High Data Rate CRC Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_HCRC(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_HCRC_SHIFT)) & I3C_MERRWARN_HCRC_MASK)

#define I3C_MERRWARN_OREAD_MASK                  (0x10000U)
#define I3C_MERRWARN_OREAD_SHIFT                 (16U)
/*! OREAD - Overread Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_OREAD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_OREAD_SHIFT)) & I3C_MERRWARN_OREAD_MASK)

#define I3C_MERRWARN_OWRITE_MASK                 (0x20000U)
#define I3C_MERRWARN_OWRITE_SHIFT                (17U)
/*! OWRITE - Overwrite Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_OWRITE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_OWRITE_SHIFT)) & I3C_MERRWARN_OWRITE_MASK)

#define I3C_MERRWARN_MSGERR_MASK                 (0x40000U)
#define I3C_MERRWARN_MSGERR_SHIFT                (18U)
/*! MSGERR - Message Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_MSGERR(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_MSGERR_SHIFT)) & I3C_MERRWARN_MSGERR_MASK)

#define I3C_MERRWARN_INVREQ_MASK                 (0x80000U)
#define I3C_MERRWARN_INVREQ_SHIFT                (19U)
/*! INVREQ - Invalid Request Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_INVREQ(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_INVREQ_SHIFT)) & I3C_MERRWARN_INVREQ_MASK)

#define I3C_MERRWARN_TIMEOUT_MASK                (0x100000U)
#define I3C_MERRWARN_TIMEOUT_SHIFT               (20U)
/*! TIMEOUT - Timeout Error
 *  0b1..Error
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Clear the flag
 */
#define I3C_MERRWARN_TIMEOUT(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_TIMEOUT_SHIFT)) & I3C_MERRWARN_TIMEOUT_MASK)
/*! @} */

/*! @name MDMACTRL - Controller DMA Control */
/*! @{ */

#define I3C_MDMACTRL_DMAFB_MASK                  (0x3U)
#define I3C_MDMACTRL_DMAFB_SHIFT                 (0U)
/*! DMAFB - DMA from Bus
 *  0b00..DMA not used
 *  0b01..Enable DMA for one frame
 *  0b10..Enable DMA until DMA is turned off
 *  0b11..
 */
#define I3C_MDMACTRL_DMAFB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MDMACTRL_DMAFB_SHIFT)) & I3C_MDMACTRL_DMAFB_MASK)

#define I3C_MDMACTRL_DMATB_MASK                  (0xCU)
#define I3C_MDMACTRL_DMATB_SHIFT                 (2U)
/*! DMATB - DMA to Bus
 *  0b00..DMA not used
 *  0b01..Enable DMA for one frame (ended by DMA or terminated)
 *  0b10..Enable DMA until DMA is turned off
 *  0b11..
 */
#define I3C_MDMACTRL_DMATB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MDMACTRL_DMATB_SHIFT)) & I3C_MDMACTRL_DMATB_MASK)

#define I3C_MDMACTRL_DMAWIDTH_MASK               (0x30U)
#define I3C_MDMACTRL_DMAWIDTH_SHIFT              (4U)
/*! DMAWIDTH - DMA Width
 *  0b00, 0b01..Byte
 *  0b10..Halfword (16 bits)
 *  0b11..
 */
#define I3C_MDMACTRL_DMAWIDTH(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDMACTRL_DMAWIDTH_SHIFT)) & I3C_MDMACTRL_DMAWIDTH_MASK)
/*! @} */

/*! @name MDATACTRL - Controller Data Control */
/*! @{ */

#define I3C_MDATACTRL_FLUSHTB_MASK               (0x1U)
#define I3C_MDATACTRL_FLUSHTB_SHIFT              (0U)
/*! FLUSHTB - Flush To-Bus Buffer or FIFO
 *  0b1..Flush the buffer
 *  0b0..No action
 */
#define I3C_MDATACTRL_FLUSHTB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_FLUSHTB_SHIFT)) & I3C_MDATACTRL_FLUSHTB_MASK)

#define I3C_MDATACTRL_FLUSHFB_MASK               (0x2U)
#define I3C_MDATACTRL_FLUSHFB_SHIFT              (1U)
/*! FLUSHFB - Flush From-Bus Buffer or FIFO
 *  0b1..Flush the buffer
 *  0b0..No action
 */
#define I3C_MDATACTRL_FLUSHFB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_FLUSHFB_SHIFT)) & I3C_MDATACTRL_FLUSHFB_MASK)

#define I3C_MDATACTRL_UNLOCK_MASK                (0x8U)
#define I3C_MDATACTRL_UNLOCK_SHIFT               (3U)
/*! UNLOCK - Unlock
 *  0b0..Locked
 *  0b1..Unlocked
 */
#define I3C_MDATACTRL_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_UNLOCK_SHIFT)) & I3C_MDATACTRL_UNLOCK_MASK)

#define I3C_MDATACTRL_TXTRIG_MASK                (0x30U)
#define I3C_MDATACTRL_TXTRIG_SHIFT               (4U)
/*! TXTRIG - Transmit Trigger Level
 *  0b00..Trigger when empty
 *  0b01..Trigger when 1/4 full or less
 *  0b10..Trigger when 1/2 full or less
 *  0b11..Trigger when 1 less than full or less (default)
 */
#define I3C_MDATACTRL_TXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_TXTRIG_SHIFT)) & I3C_MDATACTRL_TXTRIG_MASK)

#define I3C_MDATACTRL_RXTRIG_MASK                (0xC0U)
#define I3C_MDATACTRL_RXTRIG_SHIFT               (6U)
/*! RXTRIG - Receive Trigger Level
 *  0b00..Trigger when not empty
 *  0b01..Trigger when 1/4 full or more
 *  0b10..Trigger when 1/2 full or more
 *  0b11..Trigger when 3/4 full or more
 */
#define I3C_MDATACTRL_RXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_RXTRIG_SHIFT)) & I3C_MDATACTRL_RXTRIG_MASK)

#define I3C_MDATACTRL_TXCOUNT_MASK               (0x1F0000U)
#define I3C_MDATACTRL_TXCOUNT_SHIFT              (16U)
/*! TXCOUNT - Transmit Byte Count */
#define I3C_MDATACTRL_TXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_TXCOUNT_SHIFT)) & I3C_MDATACTRL_TXCOUNT_MASK)

#define I3C_MDATACTRL_RXCOUNT_MASK               (0x1F000000U)
#define I3C_MDATACTRL_RXCOUNT_SHIFT              (24U)
/*! RXCOUNT - Receive Byte Count */
#define I3C_MDATACTRL_RXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_RXCOUNT_SHIFT)) & I3C_MDATACTRL_RXCOUNT_MASK)

#define I3C_MDATACTRL_TXFULL_MASK                (0x40000000U)
#define I3C_MDATACTRL_TXFULL_SHIFT               (30U)
/*! TXFULL - Transmit is Full
 *  0b0..Not full
 *  0b1..Full
 */
#define I3C_MDATACTRL_TXFULL(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_TXFULL_SHIFT)) & I3C_MDATACTRL_TXFULL_MASK)

#define I3C_MDATACTRL_RXEMPTY_MASK               (0x80000000U)
#define I3C_MDATACTRL_RXEMPTY_SHIFT              (31U)
/*! RXEMPTY - Receive is Empty
 *  0b0..Not empty
 *  0b1..Empty
 */
#define I3C_MDATACTRL_RXEMPTY(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_RXEMPTY_SHIFT)) & I3C_MDATACTRL_RXEMPTY_MASK)
/*! @} */

/*! @name MWDATAB - Controller Write Data Byte */
/*! @{ */

#define I3C_MWDATAB_VALUE_MASK                   (0xFFU)
#define I3C_MWDATAB_VALUE_SHIFT                  (0U)
/*! VALUE - Data Byte */
#define I3C_MWDATAB_VALUE(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAB_VALUE_SHIFT)) & I3C_MWDATAB_VALUE_MASK)

#define I3C_MWDATAB_END_MASK                     (0x100U)
#define I3C_MWDATAB_END_SHIFT                    (8U)
/*! END - End of Message
 *  0b0..Not the end
 *  0b1..End
 */
#define I3C_MWDATAB_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAB_END_SHIFT)) & I3C_MWDATAB_END_MASK)

#define I3C_MWDATAB_END_ALSO_MASK                (0x10000U)
#define I3C_MWDATAB_END_ALSO_SHIFT               (16U)
/*! END_ALSO - End of Message ALSO
 *  0b0..Not the end
 *  0b1..End
 */
#define I3C_MWDATAB_END_ALSO(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAB_END_ALSO_SHIFT)) & I3C_MWDATAB_END_ALSO_MASK)
/*! @} */

/*! @name MWDATABE - Controller Write Data Byte End */
/*! @{ */

#define I3C_MWDATABE_VALUE_MASK                  (0xFFU)
#define I3C_MWDATABE_VALUE_SHIFT                 (0U)
/*! VALUE - Data */
#define I3C_MWDATABE_VALUE(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MWDATABE_VALUE_SHIFT)) & I3C_MWDATABE_VALUE_MASK)
/*! @} */

/*! @name MWDATAH - Controller Write Data Halfword */
/*! @{ */

#define I3C_MWDATAH_DATA0_MASK                   (0xFFU)
#define I3C_MWDATAH_DATA0_SHIFT                  (0U)
/*! DATA0 - Data Byte 0 */
#define I3C_MWDATAH_DATA0(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAH_DATA0_SHIFT)) & I3C_MWDATAH_DATA0_MASK)

#define I3C_MWDATAH_DATA1_MASK                   (0xFF00U)
#define I3C_MWDATAH_DATA1_SHIFT                  (8U)
/*! DATA1 - Data Byte 1 */
#define I3C_MWDATAH_DATA1(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAH_DATA1_SHIFT)) & I3C_MWDATAH_DATA1_MASK)

#define I3C_MWDATAH_END_MASK                     (0x10000U)
#define I3C_MWDATAH_END_SHIFT                    (16U)
/*! END - End of Message
 *  0b0..Not the end
 *  0b1..End
 */
#define I3C_MWDATAH_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAH_END_SHIFT)) & I3C_MWDATAH_END_MASK)
/*! @} */

/*! @name MWDATAHE - Controller Write Data Halfword End */
/*! @{ */

#define I3C_MWDATAHE_DATA0_MASK                  (0xFFU)
#define I3C_MWDATAHE_DATA0_SHIFT                 (0U)
/*! DATA0 - Data Byte 0 */
#define I3C_MWDATAHE_DATA0(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAHE_DATA0_SHIFT)) & I3C_MWDATAHE_DATA0_MASK)

#define I3C_MWDATAHE_DATA1_MASK                  (0xFF00U)
#define I3C_MWDATAHE_DATA1_SHIFT                 (8U)
/*! DATA1 - Data Byte 1 */
#define I3C_MWDATAHE_DATA1(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAHE_DATA1_SHIFT)) & I3C_MWDATAHE_DATA1_MASK)
/*! @} */

/*! @name MRDATAB - Controller Read Data Byte */
/*! @{ */

#define I3C_MRDATAB_VALUE_MASK                   (0xFFU)
#define I3C_MRDATAB_VALUE_SHIFT                  (0U)
/*! VALUE - Value */
#define I3C_MRDATAB_VALUE(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MRDATAB_VALUE_SHIFT)) & I3C_MRDATAB_VALUE_MASK)
/*! @} */

/*! @name MRDATAH - Controller Read Data Halfword */
/*! @{ */

#define I3C_MRDATAH_LSB_MASK                     (0xFFU)
#define I3C_MRDATAH_LSB_SHIFT                    (0U)
/*! LSB - Low Byte */
#define I3C_MRDATAH_LSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_MRDATAH_LSB_SHIFT)) & I3C_MRDATAH_LSB_MASK)

#define I3C_MRDATAH_MSB_MASK                     (0xFF00U)
#define I3C_MRDATAH_MSB_SHIFT                    (8U)
/*! MSB - High Byte */
#define I3C_MRDATAH_MSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_MRDATAH_MSB_SHIFT)) & I3C_MRDATAH_MSB_MASK)
/*! @} */

/*! @name MWDATAB1 - Controller Write Byte Data 1 (to Bus) */
/*! @{ */

#define I3C_MWDATAB1_VALUE_MASK                  (0xFFU)
#define I3C_MWDATAB1_VALUE_SHIFT                 (0U)
/*! VALUE - Value */
#define I3C_MWDATAB1_VALUE(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAB1_VALUE_SHIFT)) & I3C_MWDATAB1_VALUE_MASK)
/*! @} */

/*! @name MWDATAH1 - Controller Write Halfword Data (to Bus) */
/*! @{ */

#define I3C_MWDATAH1_VALUE_MASK                  (0xFFFFU)
#define I3C_MWDATAH1_VALUE_SHIFT                 (0U)
/*! VALUE - Value */
#define I3C_MWDATAH1_VALUE(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAH1_VALUE_SHIFT)) & I3C_MWDATAH1_VALUE_MASK)
/*! @} */

/*! @name MWMSG_SDR_CONTROL - Controller Write Message Control in SDR mode */
/*! @{ */

#define I3C_MWMSG_SDR_CONTROL_DIR_MASK           (0x1U)
#define I3C_MWMSG_SDR_CONTROL_DIR_SHIFT          (0U)
/*! DIR - Direction
 *  0b0..Write
 *  0b1..Read
 */
#define I3C_MWMSG_SDR_CONTROL_DIR(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_DIR_SHIFT)) & I3C_MWMSG_SDR_CONTROL_DIR_MASK)

#define I3C_MWMSG_SDR_CONTROL_ADDR_MASK          (0xFEU)
#define I3C_MWMSG_SDR_CONTROL_ADDR_SHIFT         (1U)
/*! ADDR - Address */
#define I3C_MWMSG_SDR_CONTROL_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_ADDR_SHIFT)) & I3C_MWMSG_SDR_CONTROL_ADDR_MASK)

#define I3C_MWMSG_SDR_CONTROL_END_MASK           (0x100U)
#define I3C_MWMSG_SDR_CONTROL_END_SHIFT          (8U)
/*! END - End of SDR Message
 *  0b0..Not the end
 *  0b1..End
 */
#define I3C_MWMSG_SDR_CONTROL_END(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_END_SHIFT)) & I3C_MWMSG_SDR_CONTROL_END_MASK)

#define I3C_MWMSG_SDR_CONTROL_I2C_MASK           (0x400U)
#define I3C_MWMSG_SDR_CONTROL_I2C_SHIFT          (10U)
/*! I2C - I2C
 *  0b0..I3C message
 *  0b1..I2C message
 */
#define I3C_MWMSG_SDR_CONTROL_I2C(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_I2C_SHIFT)) & I3C_MWMSG_SDR_CONTROL_I2C_MASK)

#define I3C_MWMSG_SDR_CONTROL_LEN_MASK           (0xF800U)
#define I3C_MWMSG_SDR_CONTROL_LEN_SHIFT          (11U)
/*! LEN - Length */
#define I3C_MWMSG_SDR_CONTROL_LEN(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_LEN_SHIFT)) & I3C_MWMSG_SDR_CONTROL_LEN_MASK)
/*! @} */

/*! @name MWMSG_SDR_DATA - Controller Write Message Data in SDR mode */
/*! @{ */

#define I3C_MWMSG_SDR_DATA_DATA16B_MASK          (0xFFFFU)
#define I3C_MWMSG_SDR_DATA_DATA16B_SHIFT         (0U)
/*! DATA16B - Data */
#define I3C_MWMSG_SDR_DATA_DATA16B(x)            (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_DATA_DATA16B_SHIFT)) & I3C_MWMSG_SDR_DATA_DATA16B_MASK)
/*! @} */

/*! @name MRMSG_SDR - Controller Read Message in SDR mode */
/*! @{ */

#define I3C_MRMSG_SDR_DATA_MASK                  (0xFFFFU)
#define I3C_MRMSG_SDR_DATA_SHIFT                 (0U)
/*! DATA - Data */
#define I3C_MRMSG_SDR_DATA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MRMSG_SDR_DATA_SHIFT)) & I3C_MRMSG_SDR_DATA_MASK)
/*! @} */

/*! @name MWMSG_DDR_CONTROL - Controller Write Message in DDR mode: First Control Word */
/*! @{ */

#define I3C_MWMSG_DDR_CONTROL_ADDRCMD_MASK       (0xFFFFU)
#define I3C_MWMSG_DDR_CONTROL_ADDRCMD_SHIFT      (0U)
/*! ADDRCMD - Address Command */
#define I3C_MWMSG_DDR_CONTROL_ADDRCMD(x)         (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_DDR_CONTROL_ADDRCMD_SHIFT)) & I3C_MWMSG_DDR_CONTROL_ADDRCMD_MASK)
/*! @} */

/*! @name MWMSG_DDR_CONTROL2 - Controller Write Message in DDR Mode Control 2 */
/*! @{ */

#define I3C_MWMSG_DDR_CONTROL2_LEN_MASK          (0x3FFU)
#define I3C_MWMSG_DDR_CONTROL2_LEN_SHIFT         (0U)
/*! LEN - Length of Message */
#define I3C_MWMSG_DDR_CONTROL2_LEN(x)            (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_DDR_CONTROL2_LEN_SHIFT)) & I3C_MWMSG_DDR_CONTROL2_LEN_MASK)

#define I3C_MWMSG_DDR_CONTROL2_END_MASK          (0x4000U)
#define I3C_MWMSG_DDR_CONTROL2_END_SHIFT         (14U)
/*! END - End of Message
 *  0b1..End
 *  0b0..Not the end
 */
#define I3C_MWMSG_DDR_CONTROL2_END(x)            (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_DDR_CONTROL2_END_SHIFT)) & I3C_MWMSG_DDR_CONTROL2_END_MASK)
/*! @} */

/*! @name MWMSG_DDR_DATA - Controller Write Message Data in DDR mode */
/*! @{ */

#define I3C_MWMSG_DDR_DATA_DATA16B_MASK          (0xFFFFU)
#define I3C_MWMSG_DDR_DATA_DATA16B_SHIFT         (0U)
/*! DATA16B - Data */
#define I3C_MWMSG_DDR_DATA_DATA16B(x)            (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_DDR_DATA_DATA16B_SHIFT)) & I3C_MWMSG_DDR_DATA_DATA16B_MASK)
/*! @} */

/*! @name MRMSG_DDR - Controller Read Message in DDR mode */
/*! @{ */

#define I3C_MRMSG_DDR_DATA_MASK                  (0xFFFFU)
#define I3C_MRMSG_DDR_DATA_SHIFT                 (0U)
/*! DATA - Data */
#define I3C_MRMSG_DDR_DATA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MRMSG_DDR_DATA_SHIFT)) & I3C_MRMSG_DDR_DATA_MASK)
/*! @} */

/*! @name MDYNADDR - Controller Dynamic Address */
/*! @{ */

#define I3C_MDYNADDR_DAVALID_MASK                (0x1U)
#define I3C_MDYNADDR_DAVALID_SHIFT               (0U)
/*! DAVALID - Dynamic Address Valid
 *  0b1..Valid DA assigned
 *  0b0..No valid DA assigned
 */
#define I3C_MDYNADDR_DAVALID(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDYNADDR_DAVALID_SHIFT)) & I3C_MDYNADDR_DAVALID_MASK)

#define I3C_MDYNADDR_DADDR_MASK                  (0xFEU)
#define I3C_MDYNADDR_DADDR_SHIFT                 (1U)
/*! DADDR - Dynamic Address */
#define I3C_MDYNADDR_DADDR(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MDYNADDR_DADDR_SHIFT)) & I3C_MDYNADDR_DADDR_MASK)
/*! @} */

/*! @name SMAPCTRL0 - Map Feature Control 0 */
/*! @{ */

#define I3C_SMAPCTRL0_ENA_MASK                   (0x1U)
#define I3C_SMAPCTRL0_ENA_SHIFT                  (0U)
/*! ENA - Enable Primary Dynamic Address
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define I3C_SMAPCTRL0_ENA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SMAPCTRL0_ENA_SHIFT)) & I3C_SMAPCTRL0_ENA_MASK)

#define I3C_SMAPCTRL0_DA_MASK                    (0xFEU)
#define I3C_SMAPCTRL0_DA_SHIFT                   (1U)
/*! DA - Dynamic Address */
#define I3C_SMAPCTRL0_DA(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SMAPCTRL0_DA_SHIFT)) & I3C_SMAPCTRL0_DA_MASK)

#define I3C_SMAPCTRL0_CAUSE_MASK                 (0x700U)
#define I3C_SMAPCTRL0_CAUSE_SHIFT                (8U)
/*! CAUSE - Cause
 *  0b000..No information (this value occurs when not configured to write DA)
 *  0b001..Set using ENTDAA
 *  0b010..Set using SETDASA, SETAASA, or SETNEWDA
 *  0b011..Cleared using RSTDAA
 *  0b100..Auto MAP change happened last
 *  *..
 */
#define I3C_SMAPCTRL0_CAUSE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SMAPCTRL0_CAUSE_SHIFT)) & I3C_SMAPCTRL0_CAUSE_MASK)
/*! @} */

/*! @name IBIEXT1 - Extended IBI Data 1 */
/*! @{ */

#define I3C_IBIEXT1_CNT_MASK                     (0x7U)
#define I3C_IBIEXT1_CNT_SHIFT                    (0U)
/*! CNT - Count */
#define I3C_IBIEXT1_CNT(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT1_CNT_SHIFT)) & I3C_IBIEXT1_CNT_MASK)

#define I3C_IBIEXT1_MAX_MASK                     (0x70U)
#define I3C_IBIEXT1_MAX_SHIFT                    (4U)
/*! MAX - Maximum */
#define I3C_IBIEXT1_MAX(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT1_MAX_SHIFT)) & I3C_IBIEXT1_MAX_MASK)

#define I3C_IBIEXT1_EXT1_MASK                    (0xFF00U)
#define I3C_IBIEXT1_EXT1_SHIFT                   (8U)
/*! EXT1 - Extra Byte 1 */
#define I3C_IBIEXT1_EXT1(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT1_EXT1_SHIFT)) & I3C_IBIEXT1_EXT1_MASK)

#define I3C_IBIEXT1_EXT2_MASK                    (0xFF0000U)
#define I3C_IBIEXT1_EXT2_SHIFT                   (16U)
/*! EXT2 - Extra Byte 2 */
#define I3C_IBIEXT1_EXT2(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT1_EXT2_SHIFT)) & I3C_IBIEXT1_EXT2_MASK)

#define I3C_IBIEXT1_EXT3_MASK                    (0xFF000000U)
#define I3C_IBIEXT1_EXT3_SHIFT                   (24U)
/*! EXT3 - Extra Byte 3 */
#define I3C_IBIEXT1_EXT3(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT1_EXT3_SHIFT)) & I3C_IBIEXT1_EXT3_MASK)
/*! @} */

/*! @name IBIEXT2 - Extended IBI Data 2 */
/*! @{ */

#define I3C_IBIEXT2_EXT4_MASK                    (0xFFU)
#define I3C_IBIEXT2_EXT4_SHIFT                   (0U)
/*! EXT4 - Extra Byte 4 */
#define I3C_IBIEXT2_EXT4(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT2_EXT4_SHIFT)) & I3C_IBIEXT2_EXT4_MASK)

#define I3C_IBIEXT2_EXT5_MASK                    (0xFF00U)
#define I3C_IBIEXT2_EXT5_SHIFT                   (8U)
/*! EXT5 - Extra Byte 5 */
#define I3C_IBIEXT2_EXT5(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT2_EXT5_SHIFT)) & I3C_IBIEXT2_EXT5_MASK)

#define I3C_IBIEXT2_EXT6_MASK                    (0xFF0000U)
#define I3C_IBIEXT2_EXT6_SHIFT                   (16U)
/*! EXT6 - Extra Byte 6 */
#define I3C_IBIEXT2_EXT6(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT2_EXT6_SHIFT)) & I3C_IBIEXT2_EXT6_MASK)

#define I3C_IBIEXT2_EXT7_MASK                    (0xFF000000U)
#define I3C_IBIEXT2_EXT7_SHIFT                   (24U)
/*! EXT7 - Extra Byte 7 */
#define I3C_IBIEXT2_EXT7(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_IBIEXT2_EXT7_SHIFT)) & I3C_IBIEXT2_EXT7_MASK)
/*! @} */

/*! @name SID - Target Module ID */
/*! @{ */

#define I3C_SID_ID_MASK                          (0xFFFFFFFFU)
#define I3C_SID_ID_SHIFT                         (0U)
/*! ID - ID */
#define I3C_SID_ID(x)                            (((uint32_t)(((uint32_t)(x)) << I3C_SID_ID_SHIFT)) & I3C_SID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I3C_Register_Masks */


/* I3C - Peripheral instance base addresses */
/** Peripheral I3C0 base address */
#define I3C0_BASE                                (0x40002000u)
/** Peripheral I3C0 base pointer */
#define I3C0                                     ((I3C_Type *)I3C0_BASE)
/** Array initializer of I3C peripheral base addresses */
#define I3C_BASE_ADDRS                           { I3C0_BASE }
/** Array initializer of I3C peripheral base pointers */
#define I3C_BASE_PTRS                            { I3C0 }
/** Interrupt vectors for the I3C peripheral type */
#define I3C_IRQS                                 { I3C0_IRQn }

/*!
 * @}
 */ /* end of group I3C_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- INPUTMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Peripheral_Access_Layer INPUTMUX Peripheral Access Layer
 * @{
 */

/** INPUTMUX - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[32];
  __IO uint32_t CTIMER0CAP[4];                     /**< Capture select register for CTIMER inputs, array offset: 0x20, array step: 0x4 */
  __IO uint32_t TIMER0TRIG;                        /**< Trigger register for TIMER0, offset: 0x30 */
       uint8_t RESERVED_1[12];
  __IO uint32_t CTIMER1CAP[4];                     /**< Capture select register for CTIMER inputs, array offset: 0x40, array step: 0x4 */
  __IO uint32_t TIMER1TRIG;                        /**< Trigger register for TIMER1, offset: 0x50 */
       uint8_t RESERVED_2[12];
  __IO uint32_t CTIMER2CAP[4];                     /**< Capture select register for CTIMER inputs, array offset: 0x60, array step: 0x4 */
  __IO uint32_t TIMER2TRIG;                        /**< Trigger register for TIMER2 inputs, offset: 0x70 */
       uint8_t RESERVED_3[268];
  __IO uint32_t FREQMEAS_REF;                      /**< Selection for frequency measurement reference clock, offset: 0x180 */
  __IO uint32_t FREQMEAS_TAR;                      /**< Selection for frequency measurement reference clock, offset: 0x184 */
       uint8_t RESERVED_4[24];
  __IO uint32_t CTIMER3CAP[4];                     /**< Capture select register for CTIMER inputs, array offset: 0x1A0, array step: 0x4 */
  __IO uint32_t TIMER3TRIG;                        /**< Trigger register for TIMER3, offset: 0x1B0 */
       uint8_t RESERVED_5[12];
  __IO uint32_t CTIMER4CAP[4];                     /**< Capture select register for CTIMER inputs, array offset: 0x1C0, array step: 0x4 */
  __IO uint32_t TIMER4TRIG;                        /**< Trigger register for TIMER4, offset: 0x1D0 */
       uint8_t RESERVED_6[44];
  __IO uint32_t AOI1_INPUT[16];                    /**< AOI1 trigger input connections 0, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_7[32];
  __IO uint32_t CMP0_TRIG;                         /**< CMP0 input connections, offset: 0x260 */
       uint8_t RESERVED_8[28];
  __IO uint32_t ADC0_TRIG[4];                      /**< ADC Trigger input connections, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_9[48];
  __IO uint32_t ADC1_TRIG[4];                      /**< ADC Trigger input connections, array offset: 0x2C0, array step: 0x4 */
       uint8_t RESERVED_10[48];
  __IO uint32_t DAC0_TRIG;                         /**< This register selects the DAC0 trigger inputs., offset: 0x300 */
       uint8_t RESERVED_11[92];
  __IO uint32_t QDC0_TRIG;                         /**< QDC0 Trigger Input Connections, offset: 0x360 */
  __IO uint32_t QDC0_HOME;                         /**< QDC0 Trigger Input Connections, offset: 0x364 */
  __IO uint32_t QDC0_INDEX;                        /**< QDC0 Trigger Input Connections, offset: 0x368 */
  __IO uint32_t QDC0_PHASEB;                       /**< QDC0 Trigger Input Connections, offset: 0x36C */
  __IO uint32_t QDC0_PHASEA;                       /**< QDC0 Trigger Input Connections, offset: 0x370 */
  __IO uint32_t QDC0_ICAP1;                        /**< QDC0 Trigger Input Connections, offset: 0x374 */
  __IO uint32_t QDC0_ICAP2;                        /**< QDC0 Trigger Input Connections, offset: 0x378 */
  __IO uint32_t QDC0_ICAP3;                        /**< QDC0 Trigger Input Connections, offset: 0x37C */
  __IO uint32_t QDC1_TRIG;                         /**< QDC1 Trigger Input Connections, offset: 0x380 */
  __IO uint32_t QDC1_HOME;                         /**< QDC1 Trigger Input Connections, offset: 0x384 */
  __IO uint32_t QDC1_INDEX;                        /**< QDC1 Trigger Input Connections, offset: 0x388 */
  __IO uint32_t QDC1_PHASEB;                       /**< QDC1 Trigger Input Connections, offset: 0x38C */
  __IO uint32_t QDC1_PHASEA;                       /**< QDC1 Trigger Input Connections, offset: 0x390 */
  __IO uint32_t QDC1_ICAP1;                        /**< QDC1 Trigger Input Connections, offset: 0x394 */
  __IO uint32_t QDC1_ICAP2;                        /**< QDC1 Trigger Input Connections, offset: 0x398 */
  __IO uint32_t QDC1_ICAP3;                        /**< QDC1 Trigger Input Connections, offset: 0x39C */
  __IO uint32_t FLEXPWM0_SM0_EXTA0;                /**< PWM0 input trigger connections, offset: 0x3A0 */
  __IO uint32_t FLEXPWM0_SM0_EXTSYNC;              /**< PWM0 input trigger connections, offset: 0x3A4 */
  __IO uint32_t FLEXPWM0_SM1_EXTA;                 /**< PWM0 input trigger connections, offset: 0x3A8 */
  __IO uint32_t FLEXPWM0_SM1_EXTSYNC;              /**< PWM0 input trigger connections, offset: 0x3AC */
  __IO uint32_t FLEXPWM0_SM2_EXTA;                 /**< PWM0 input trigger connections, offset: 0x3B0 */
  __IO uint32_t FLEXPWM0_SM2_EXTSYNC;              /**< PWM0 input trigger connections, offset: 0x3B4 */
       uint8_t RESERVED_12[8];
  __IO uint32_t FLEXPWM0_FAULT[4];                 /**< PWM0 Fault Input Trigger Connections, array offset: 0x3C0, array step: 0x4 */
  __IO uint32_t FLEXPWM0_FORCE;                    /**< PWM0 input trigger connections, offset: 0x3D0 */
       uint8_t RESERVED_13[12];
  __IO uint32_t FLEXPWM1_SM0_EXTA0;                /**< PWM1 input trigger connections, offset: 0x3E0 */
  __IO uint32_t FLEXPWM1_SM0_EXTSYNC;              /**< PWM1 input trigger connections, offset: 0x3E4 */
  __IO uint32_t FLEXPWM1_SM1_EXTA;                 /**< PWM1 input trigger connections, offset: 0x3E8 */
  __IO uint32_t FLEXPWM1_SM1_EXTSYNC;              /**< PWM1 input trigger connections, offset: 0x3EC */
  __IO uint32_t FLEXPWM1_SM2_EXTA;                 /**< PWM1 input trigger connections, offset: 0x3F0 */
  __IO uint32_t FLEXPWM1_SM2_EXTSYNC;              /**< PWM1 input trigger connections, offset: 0x3F4 */
       uint8_t RESERVED_14[8];
  __IO uint32_t FLEXPWM1_FAULT[4];                 /**< PWM1 Fault Input Trigger Connections, array offset: 0x400, array step: 0x4 */
  __IO uint32_t FLEXPWM1_FORCE;                    /**< PWM1 input trigger connections, offset: 0x410 */
       uint8_t RESERVED_15[12];
  __IO uint32_t PWM0_EXT_CLK;                      /**< PWM0 external clock trigger, offset: 0x420 */
  __IO uint32_t PWM1_EXT_CLK;                      /**< PWM1 external clock trigger, offset: 0x424 */
       uint8_t RESERVED_16[24];
  __IO uint32_t AOI0_INPUT[16];                    /**< AOI0 trigger input connections 0, array offset: 0x440, array step: 0x4 */
  __IO uint32_t USBFS_TRIG;                        /**< USB-FS trigger input connections, offset: 0x480 */
       uint8_t RESERVED_17[60];
  __IO uint32_t EXT_TRIG0;                         /**< EXT trigger connections 0, offset: 0x4C0 */
       uint8_t RESERVED_18[28];
  __IO uint32_t CMP1_TRIG;                         /**< CMP1 input connections, offset: 0x4E0 */
       uint8_t RESERVED_19[92];
  __IO uint32_t LPI2C2_TRIG;                       /**< LPI2C2 trigger input connections, offset: 0x540 */
       uint8_t RESERVED_20[60];
  __IO uint32_t OPAMP0_TRIG;                       /**< OPAMP0 Trigger Input Connections, offset: 0x580 */
       uint8_t RESERVED_21[28];
  __IO uint32_t LPI2C0_TRIG;                       /**< LPI2C0 trigger input connections, offset: 0x5A0 */
       uint8_t RESERVED_22[28];
  __IO uint32_t LPI2C1_TRIG;                       /**< LPI2C1 trigger input connections, offset: 0x5C0 */
       uint8_t RESERVED_23[28];
  __IO uint32_t LPSPI0_TRIG;                       /**< LPSPI0 trigger input connections, offset: 0x5E0 */
       uint8_t RESERVED_24[28];
  __IO uint32_t LPSPI1_TRIG;                       /**< LPSPI1 trigger input connections, offset: 0x600 */
       uint8_t RESERVED_25[28];
  __IO uint32_t LPUART0r;                          /**< LPUART0 trigger input connections, offset: 0x620, 'r' suffix has been added to avoid a clash with peripheral base pointer macro 'LPUART0' */
       uint8_t RESERVED_26[28];
  __IO uint32_t LPUART1r;                          /**< LPUART1 trigger input connections, offset: 0x640, 'r' suffix has been added to avoid a clash with peripheral base pointer macro 'LPUART1' */
       uint8_t RESERVED_27[28];
  __IO uint32_t LPUART2r;                          /**< LPUART2 trigger input connections, offset: 0x660, 'r' suffix has been added to avoid a clash with peripheral base pointer macro 'LPUART2' */
       uint8_t RESERVED_28[28];
  __IO uint32_t LPUART3r;                          /**< LPUART3 trigger input connections, offset: 0x680, 'r' suffix has been added to avoid a clash with peripheral base pointer macro 'LPUART3' */
       uint8_t RESERVED_29[28];
  __IO uint32_t LPUART4r;                          /**< LPUART4 trigger input connections, offset: 0x6A0, 'r' suffix has been added to avoid a clash with peripheral base pointer macro 'LPUART4' */
       uint8_t RESERVED_30[60];
  __IO uint32_t FLEXIO_TRIG[4];                    /**< FlexIO Trigger Input Connections, array offset: 0x6E0, array step: 0x4 */
} INPUTMUX_Type;

/* ----------------------------------------------------------------------------
   -- INPUTMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Register_Masks INPUTMUX Register Masks
 * @{
 */

/*! @name CTIMERA_CTIMER0CAP - Capture select register for CTIMER inputs */
/*! @{ */

#define INPUTMUX_CTIMERA_CTIMER0CAP_INP_MASK     (0x7FU)
#define INPUTMUX_CTIMERA_CTIMER0CAP_INP_SHIFT    (0U)
/*! INP - Input number for CTIMER0
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer1_MAT1 input is selected
 *  0b0100010..CTimer1_MAT2 input is selected
 *  0b0100011..CTimer1_MAT3 input is selected
 *  0b0100100..CTimer2_MAT1 input is selected
 *  0b0100101..CTimer2_MAT2 input is selected
 *  0b0100110..CTimer2_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer3_MAT1 input is selected
 *  0b1010000..CTimer3_MAT2 input is selected
 *  0b1010001..CTimer3_MAT3 input is selected
 *  0b1010010..CTimer4_MAT1 input is selected
 *  0b1010011..CTimer4_MAT2 input is selected
 *  0b1010100..CTimer4_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_CTIMERA_CTIMER0CAP_INP(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CTIMERA_CTIMER0CAP_INP_SHIFT)) & INPUTMUX_CTIMERA_CTIMER0CAP_INP_MASK)
/*! @} */

/* The count of INPUTMUX_CTIMERA_CTIMER0CAP */
#define INPUTMUX_CTIMERA_CTIMER0CAP_COUNT        (4U)

/*! @name TIMER0TRIG - Trigger register for TIMER0 */
/*! @{ */

#define INPUTMUX_TIMER0TRIG_INP_MASK             (0x7FU)
#define INPUTMUX_TIMER0TRIG_INP_SHIFT            (0U)
/*! INP - Input number for CTIMER0
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer1_MAT1 input is selected
 *  0b0100010..CTimer1_MAT2 input is selected
 *  0b0100011..CTimer1_MAT3 input is selected
 *  0b0100100..CTimer2_MAT1 input is selected
 *  0b0100101..CTimer2_MAT2 input is selected
 *  0b0100110..CTimer2_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer3_MAT1 input is selected
 *  0b1010000..CTimer3_MAT2 input is selected
 *  0b1010001..CTimer3_MAT3 input is selected
 *  0b1010010..CTimer4_MAT1 input is selected
 *  0b1010011..CTimer4_MAT2 input is selected
 *  0b1010100..CTimer4_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_TIMER0TRIG_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER0TRIG_INP_SHIFT)) & INPUTMUX_TIMER0TRIG_INP_MASK)
/*! @} */

/*! @name CTIMERB_CTIMER1CAP - Capture select register for CTIMER inputs */
/*! @{ */

#define INPUTMUX_CTIMERB_CTIMER1CAP_INP_MASK     (0x7FU)
#define INPUTMUX_CTIMERB_CTIMER1CAP_INP_SHIFT    (0U)
/*! INP - Input number for CTIMER1
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer0_MAT1 input is selected
 *  0b0100010..CTimer0_MAT2 input is selected
 *  0b0100011..CTimer0_MAT3 input is selected
 *  0b0100100..CTimer2_MAT1 input is selected
 *  0b0100101..CTimer2_MAT2 input is selected
 *  0b0100110..CTimer2_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer3_MAT1 input is selected
 *  0b1010000..CTimer3_MAT2 input is selected
 *  0b1010001..CTimer3_MAT3 input is selected
 *  0b1010010..CTimer4_MAT1 input is selected
 *  0b1010011..CTimer4_MAT2 input is selected
 *  0b1010100..CTimer4_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_CTIMERB_CTIMER1CAP_INP(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CTIMERB_CTIMER1CAP_INP_SHIFT)) & INPUTMUX_CTIMERB_CTIMER1CAP_INP_MASK)
/*! @} */

/* The count of INPUTMUX_CTIMERB_CTIMER1CAP */
#define INPUTMUX_CTIMERB_CTIMER1CAP_COUNT        (4U)

/*! @name TIMER1TRIG - Trigger register for TIMER1 */
/*! @{ */

#define INPUTMUX_TIMER1TRIG_INP_MASK             (0x7FU)
#define INPUTMUX_TIMER1TRIG_INP_SHIFT            (0U)
/*! INP - Input number for CTIMER1
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer0_MAT1 input is selected
 *  0b0100010..CTimer0_MAT2 input is selected
 *  0b0100011..CTimer0_MAT3 input is selected
 *  0b0100100..CTimer2_MAT1 input is selected
 *  0b0100101..CTimer2_MAT2 input is selected
 *  0b0100110..CTimer2_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer3_MAT1 input is selected
 *  0b1010000..CTimer3_MAT2 input is selected
 *  0b1010001..CTimer3_MAT3 input is selected
 *  0b1010010..CTimer4_MAT1 input is selected
 *  0b1010011..CTimer4_MAT2 input is selected
 *  0b1010100..CTimer4_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_TIMER1TRIG_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER1TRIG_INP_SHIFT)) & INPUTMUX_TIMER1TRIG_INP_MASK)
/*! @} */

/*! @name CTIMERC_CTIMER2CAP - Capture select register for CTIMER inputs */
/*! @{ */

#define INPUTMUX_CTIMERC_CTIMER2CAP_INP_MASK     (0x7FU)
#define INPUTMUX_CTIMERC_CTIMER2CAP_INP_SHIFT    (0U)
/*! INP - Input number for CTIMER2
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer0_MAT1 input is selected
 *  0b0100010..CTimer0_MAT2 input is selected
 *  0b0100011..CTimer0_MAT3 input is selected
 *  0b0100100..CTimer1_MAT1 input is selected
 *  0b0100101..CTimer1_MAT2 input is selected
 *  0b0100110..CTimer1_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer3_MAT1 input is selected
 *  0b1010000..CTimer3_MAT2 input is selected
 *  0b1010001..CTimer3_MAT3 input is selected
 *  0b1010010..CTimer4_MAT1 input is selected
 *  0b1010011..CTimer4_MAT2 input is selected
 *  0b1010100..CTimer4_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_CTIMERC_CTIMER2CAP_INP(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CTIMERC_CTIMER2CAP_INP_SHIFT)) & INPUTMUX_CTIMERC_CTIMER2CAP_INP_MASK)
/*! @} */

/* The count of INPUTMUX_CTIMERC_CTIMER2CAP */
#define INPUTMUX_CTIMERC_CTIMER2CAP_COUNT        (4U)

/*! @name TIMER2TRIG - Trigger register for TIMER2 inputs */
/*! @{ */

#define INPUTMUX_TIMER2TRIG_INP_MASK             (0x7FU)
#define INPUTMUX_TIMER2TRIG_INP_SHIFT            (0U)
/*! INP - Input number for CTIMER2
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer0_MAT1 input is selected
 *  0b0100010..CTimer0_MAT2 input is selected
 *  0b0100011..CTimer0_MAT3 input is selected
 *  0b0100100..CTimer1_MAT1 input is selected
 *  0b0100101..CTimer1_MAT2 input is selected
 *  0b0100110..CTimer1_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer3_MAT1 input is selected
 *  0b1010000..CTimer3_MAT2 input is selected
 *  0b1010001..CTimer3_MAT3 input is selected
 *  0b1010010..CTimer4_MAT1 input is selected
 *  0b1010011..CTimer4_MAT2 input is selected
 *  0b1010100..CTimer4_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_TIMER2TRIG_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER2TRIG_INP_SHIFT)) & INPUTMUX_TIMER2TRIG_INP_MASK)
/*! @} */

/*! @name FREQMEAS_REF - Selection for frequency measurement reference clock */
/*! @{ */

#define INPUTMUX_FREQMEAS_REF_INP_MASK           (0x7FU)
#define INPUTMUX_FREQMEAS_REF_INP_SHIFT          (0U)
/*! INP - Clock source number (binary value) for frequency measure function target clock.
 *  0b0000000..Reserved
 *  0b0000001..clk_in input is selected
 *  0b0000010..FRO_OSC_12M input is selected
 *  0b0000011..fro_hf_div input is selected
 *  0b0000100..Reserved
 *  0b0000101..clk_16k[1] input is selected
 *  0b0000110..SLOW_CLK input is selected
 *  0b0000111..FREQME_CLK_IN0 input is selected
 *  0b0001000..FREQME_CLK_IN1 input is selected input is selected
 *  0b0001001..AOI0_OUT0 input is selected
 *  0b0001010..AOI0_OUT1
 *  0b0001011..PWM0_SM0_MUX_TRIG0
 *  0b0001100..PWM0_SM0_MUX_TRIG1
 *  0b0001101..PWM0_SM1_MUX_TRIG0
 *  0b0001110..PWM0_SM1_MUX_TRIG1
 *  0b0001111..PWM0_SM2_MUX_TRIG0
 *  0b0010000..PWM0_SM2_MUX_TRIG1
 *  0b0010001..Reserved
 *  0b0010010..Reserved
 *  0b0010011..Reserved
 *  0b0010100..Reserved
 *  0b0010101..Reserved
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..Reserved
 *  0b0011001..Reserved
 *  0b0011010..Reserved
 *  0b0011011..Reserved
 *  0b0011100..Reserved
 *  0b0011101..Reserved
 *  0b0011110..Reserved
 *  0b0011111..Reserved
 *  0b0100000..AOI1_OUT0 input is selected
 *  0b0100001..AOI1_OUT1 input is selected
 *  0b0100010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b0100011..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b0100100..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b0100101..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b0100110..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b0100111..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b0101000..Reserved
 *  0b0101001..Reserved
 *  *..
 */
#define INPUTMUX_FREQMEAS_REF_INP(x)             (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FREQMEAS_REF_INP_SHIFT)) & INPUTMUX_FREQMEAS_REF_INP_MASK)
/*! @} */

/*! @name FREQMEAS_TAR - Selection for frequency measurement reference clock */
/*! @{ */

#define INPUTMUX_FREQMEAS_TAR_INP_MASK           (0x7FU)
#define INPUTMUX_FREQMEAS_TAR_INP_SHIFT          (0U)
/*! INP - Clock source number (binary value) for frequency measure function target clock.
 *  0b0000000..Reserved
 *  0b0000001..clk_in input is selected
 *  0b0000010..FRO_OSC_12M input is selected
 *  0b0000011..fro_hf_div input is selected
 *  0b0000100..Reserved
 *  0b0000101..clk_16k[1] input is selected
 *  0b0000110..SLOW_CLK input is selected
 *  0b0000111..FREQME_CLK_IN0 input is selected
 *  0b0001000..FREQME_CLK_IN1 input is selected input is selected
 *  0b0001001..AOI0_OUT0 input is selected
 *  0b0001010..AOI0_OUT1
 *  0b0001011..PWM0_SM0_MUX_TRIG0
 *  0b0001100..PWM0_SM0_MUX_TRIG1
 *  0b0001101..PWM0_SM1_MUX_TRIG0
 *  0b0001110..PWM0_SM1_MUX_TRIG1
 *  0b0001111..PWM0_SM2_MUX_TRIG0
 *  0b0010000..PWM0_SM2_MUX_TRIG1
 *  0b0010001..Reserved
 *  0b0010010..Reserved
 *  0b0010011..Reserved
 *  0b0010100..Reserved
 *  0b0010101..Reserved
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..Reserved
 *  0b0011001..Reserved
 *  0b0011010..Reserved
 *  0b0011011..Reserved
 *  0b0011100..Reserved
 *  0b0011101..Reserved
 *  0b0011110..Reserved
 *  0b0011111..Reserved
 *  0b0100000..AOI1_OUT0 input is selected
 *  0b0100001..AOI1_OUT1 input is selected
 *  0b0100010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b0100011..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b0100100..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b0100101..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b0100110..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b0100111..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b0101000..Reserved
 *  0b0101001..Reserved
 *  *..
 */
#define INPUTMUX_FREQMEAS_TAR_INP(x)             (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FREQMEAS_TAR_INP_SHIFT)) & INPUTMUX_FREQMEAS_TAR_INP_MASK)
/*! @} */

/*! @name CTIMERD_CTIMER3CAP - Capture select register for CTIMER inputs */
/*! @{ */

#define INPUTMUX_CTIMERD_CTIMER3CAP_INP_MASK     (0x7FU)
#define INPUTMUX_CTIMERD_CTIMER3CAP_INP_SHIFT    (0U)
/*! INP - Input number for CTIMER3
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer0_MAT1 input is selected
 *  0b0100010..CTimer0_MAT2 input is selected
 *  0b0100011..CTimer0_MAT3 input is selected
 *  0b0100100..CTimer1_MAT1 input is selected
 *  0b0100101..CTimer1_MAT2 input is selected
 *  0b0100110..CTimer1_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer2_MAT1 input is selected
 *  0b1010000..CTimer2_MAT2 input is selected
 *  0b1010001..CTimer2_MAT3 input is selected
 *  0b1010010..CTimer4_MAT1 input is selected
 *  0b1010011..CTimer4_MAT2 input is selected
 *  0b1010100..CTimer4_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_CTIMERD_CTIMER3CAP_INP(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CTIMERD_CTIMER3CAP_INP_SHIFT)) & INPUTMUX_CTIMERD_CTIMER3CAP_INP_MASK)
/*! @} */

/* The count of INPUTMUX_CTIMERD_CTIMER3CAP */
#define INPUTMUX_CTIMERD_CTIMER3CAP_COUNT        (4U)

/*! @name TIMER3TRIG - Trigger register for TIMER3 */
/*! @{ */

#define INPUTMUX_TIMER3TRIG_INP_MASK             (0x7FU)
#define INPUTMUX_TIMER3TRIG_INP_SHIFT            (0U)
/*! INP - Input number for CTIMER3
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer0_MAT1 input is selected
 *  0b0100010..CTimer0_MAT2 input is selected
 *  0b0100011..CTimer0_MAT3 input is selected
 *  0b0100100..CTimer1_MAT1 input is selected
 *  0b0100101..CTimer1_MAT2 input is selected
 *  0b0100110..CTimer1_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer2_MAT1 input is selected
 *  0b1010000..CTimer2_MAT2 input is selected
 *  0b1010001..CTimer2_MAT3 input is selected
 *  0b1010010..CTimer4_MAT1 input is selected
 *  0b1010011..CTimer4_MAT2 input is selected
 *  0b1010100..CTimer4_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_TIMER3TRIG_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER3TRIG_INP_SHIFT)) & INPUTMUX_TIMER3TRIG_INP_MASK)
/*! @} */

/*! @name CTIMERE_CTIMER4CAP - Capture select register for CTIMER inputs */
/*! @{ */

#define INPUTMUX_CTIMERE_CTIMER4CAP_INP_MASK     (0x7FU)
#define INPUTMUX_CTIMERE_CTIMER4CAP_INP_SHIFT    (0U)
/*! INP - Input number for CTIMER4
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer0_MAT1 input is selected
 *  0b0100010..CTimer0_MAT2 input is selected
 *  0b0100011..CTimer0_MAT3 input is selected
 *  0b0100100..CTimer1_MAT1 input is selected
 *  0b0100101..CTimer1_MAT2 input is selected
 *  0b0100110..CTimer1_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer2_MAT1 input is selected
 *  0b1010000..CTimer2_MAT2 input is selected
 *  0b1010001..CTimer2_MAT3 input is selected
 *  0b1010010..CTimer3_MAT1 input is selected
 *  0b1010011..CTimer3_MAT2 input is selected
 *  0b1010100..CTimer3_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_CTIMERE_CTIMER4CAP_INP(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CTIMERE_CTIMER4CAP_INP_SHIFT)) & INPUTMUX_CTIMERE_CTIMER4CAP_INP_MASK)
/*! @} */

/* The count of INPUTMUX_CTIMERE_CTIMER4CAP */
#define INPUTMUX_CTIMERE_CTIMER4CAP_COUNT        (4U)

/*! @name TIMER4TRIG - Trigger register for TIMER4 */
/*! @{ */

#define INPUTMUX_TIMER4TRIG_INP_MASK             (0x7FU)
#define INPUTMUX_TIMER4TRIG_INP_SHIFT            (0U)
/*! INP - Input number for CTIMER4
 *  0b0000000..Reserved
 *  0b0000001..CT_IPN0 input is selected
 *  0b0000010..CT_IPN1 input is selected
 *  0b0000011..CT_IPN2 input is selected
 *  0b0000100..CT_IPN3 input is selected
 *  0b0000101..CT_IPN4 input is selected
 *  0b0000110..CT_IPN5 input is selected
 *  0b0000111..CT_IPN6 input is selected
 *  0b0001000..CT_IPN7 input is selected
 *  0b0001001..CT_IPN8 input is selected
 *  0b0001010..CT_IPN9 input is selected
 *  0b0001011..CT_IPN10 input is selected
 *  0b0001100..CT_IPN11 input is selected
 *  0b0001101..CT_IPN12 input is selected
 *  0b0001110..CT_IPN13 input is selected
 *  0b0001111..CT_IPN14 input is selected
 *  0b0010000..CT_IPN15 input is selected
 *  0b0010001..CT_IPN16 input is selected
 *  0b0010010..CT_IPN17 input is selected
 *  0b0010011..CT_IPN18 input is selected
 *  0b0010100..CT_IPN19 input is selected
 *  0b0010101..USB0 usb0 start of frame input is selected
 *  0b0010110..AOI0_OUT0 input is selected
 *  0b0010111..AOI0_OUT1 input is selected
 *  0b0011000..AOI0_OUT2 input is selected
 *  0b0011001..AOI0_OUT3 input is selected
 *  0b0011010..ADC0_tcomp[0]
 *  0b0011011..ADC0_tcomp[1]
 *  0b0011100..ADC0_tcomp[2]
 *  0b0011101..ADC0_tcomp[3] input is selected
 *  0b0011110..CMP0_OUT is selected
 *  0b0011111..CMP1_OUT is selected
 *  0b0100000..Reserved
 *  0b0100001..CTimer0_MAT1 input is selected
 *  0b0100010..CTimer0_MAT2 input is selected
 *  0b0100011..CTimer0_MAT3 input is selected
 *  0b0100100..CTimer1_MAT1 input is selected
 *  0b0100101..CTimer1_MAT2 input is selected
 *  0b0100110..CTimer1_MAT3 input is selected
 *  0b0100111..QDC0_CMP_FLAG0 is selected
 *  0b0101000..QDC0_CMP_FLAG1 input is selected
 *  0b0101001..QDC0_CMP_FLAG2 input is selected
 *  0b0101010..QDC0_CMP_FLAG3 input is selected
 *  0b0101011..QDC0_POS_MATCH0 input is selected
 *  0b0101100..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0101101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0101110..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0101111..Reserved
 *  0b0110000..LPI2C0 Master End of Packet input is selected
 *  0b0110001..LPI2C0 Slave End of Packet input is selected
 *  0b0110010..LPI2C1 Master End of Packet input is selected
 *  0b0110011..LPI2C1 Slave End of Packet input is selected
 *  0b0110100..LPSPI0 End of Frame input is selected
 *  0b0110101..LPSPI0 Received Data Word input is selected
 *  0b0110110..LPSPI1 End of Frame input is selected
 *  0b0110111..LPSPI1 Received Data Word input is selected
 *  0b0111000..LPUART0 Received Data Word input is selected
 *  0b0111001..LPUART0 Transmitted Data Word input is selected
 *  0b0111010..LPUART0 Receive Line Idle input is selected
 *  0b0111011..LPUART1 Received Data Word input is selected
 *  0b0111100..LPUART1 Transmitted Data Word input is selected
 *  0b0111101..LPUART1 Receive Line Idle input is selected
 *  0b0111110..LPUART2 Received Data Word input is selected
 *  0b0111111..LPUART2 Transmitted Data Word input is selected
 *  0b1000000..LPUART2 Receive Line Idle input is selected
 *  0b1000001..LPUART3 Received Data Word input is selected
 *  0b1000010..LPUART3 Transmitted Data Word input is selected
 *  0b1000011..LPUART3 Receive Line Idle input is selected
 *  0b1000100..LPUART4 Received Data Word input is selected
 *  0b1000101..LPUART4 Transmitted Data Word input is selected
 *  0b1000110..LPUART4 Receive Line Idle input is selected
 *  0b1000111..AOI1_OUT0 input is selected
 *  0b1001000..AOI1_OUT1 input is selected
 *  0b1001001..AOI1_OUT2 input is selected
 *  0b1001010..AOI1_OUT3 input is selected
 *  0b1001011..ADC1_tcomp[0] input is selected
 *  0b1001100..ADC1_tcomp[1] input is selected
 *  0b1001101..ADC1_tcomp[2] input is selected
 *  0b1001110..ADC1_tcomp[3] input is selected
 *  0b1001111..CTimer2_MAT1 input is selected
 *  0b1010000..CTimer2_MAT2 input is selected
 *  0b1010001..CTimer2_MAT3 input is selected
 *  0b1010010..CTimer3_MAT1 input is selected
 *  0b1010011..CTimer3_MAT2 input is selected
 *  0b1010100..CTimer3_MAT3 input is selected
 *  0b1010101..QDC1_CMP_FLAG0 input is selected
 *  0b1010110..QDC1_CMP_FLAG1 input is selected
 *  0b1010111..QDC1_CMP_FLAG2 input is selected
 *  0b1011000..QDC1_CMP_FLAG3 input is selected
 *  0b1011001..QDC1_POS_MATCH0 input is selected
 *  0b1011010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1011011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1011100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1011101..Reserved
 *  0b1011110..LPI2C2 Master End of Packet input is selected
 *  0b1011111..LPI2C2 Slave End of Packet input is selected
 *  0b1100000..LPI2C3 Master End of Packet input is selected
 *  0b1100001..LPI2C3 Slave End of Packet input is selected
 *  *..
 */
#define INPUTMUX_TIMER4TRIG_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER4TRIG_INP_SHIFT)) & INPUTMUX_TIMER4TRIG_INP_MASK)
/*! @} */

/*! @name AOI1_INPUTM_AOI1_INPUT - AOI1 trigger input connections 0 */
/*! @{ */

#define INPUTMUX_AOI1_INPUTM_AOI1_INPUT_INP_MASK (0x7FU)
#define INPUTMUX_AOI1_INPUTM_AOI1_INPUT_INP_SHIFT (0U)
/*! INP - AOI0 trigger input connections
 *  0b0000000..Reserved
 *  0b0000001..ADC0_tcomp[0] input is selected
 *  0b0000010..ADC0_tcomp[1] input is selected
 *  0b0000011..ADC0_tcomp[2] input is selected
 *  0b0000100..ADC0_tcomp[3] input is selected
 *  0b0000101..CMP0_OUT input is selected
 *  0b0000110..CMP1_OUT input is selected
 *  0b0000111..Reserved
 *  0b0001000..CTimer0_MAT0 input is selected
 *  0b0001001..CTimer0_MAT1 input is selected
 *  0b0001010..CTimer0_MAT2 input is selected
 *  0b0001011..CTimer0_MAT3 input is selected
 *  0b0001100..CTimer1_MAT0
 *  0b0001101..CTimer1_MAT1 input is selected
 *  0b0001110..CTimer1_MAT2 input is selected
 *  0b0001111..CTimer1_MAT3 input is selected
 *  0b0010000..CTimer2_MAT0 input is selected
 *  0b0010001..CTimer2_MAT1 input is selected
 *  0b0010010..CTimer2_MAT2 input is selected
 *  0b0010011..CTimer2_MAT3 input is selected
 *  0b0010100..LPTMR0 input is selected
 *  0b0010101..Reserved
 *  0b0010110..QDC0_CMP_FLAG0 input is selected
 *  0b0010111..QDC0_CMP_FLAG1 input is selected
 *  0b0011000..QDC0_CMP_FLAG2 input is selected
 *  0b0011001..QDC0_CMP_FLAG3 input is selected
 *  0b0011010..QDC0_POS_MATCH input is selected
 *  0b0011011..PWM0_SM0_MUX_TRIG0 0 input is selected
 *  0b0011100..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0011101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0011110..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0011111..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0100000..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0100001..Reserved
 *  0b0100010..Reserved
 *  0b0100011..TRIG_IN0 input is selected
 *  0b0100100..TRIG_IN1 input is selected
 *  0b0100101..TRIG_IN2 input is selected
 *  0b0100110..TRIG_IN3 input is selected
 *  0b0100111..TRIG_IN4 input is selected
 *  0b0101000..TRIG_IN5 input is selected
 *  0b0101001..TRIG_IN6 input is selected
 *  0b0101010..TRIG_IN7 input is selected
 *  0b0101011..TRIG_IN8 input is selected
 *  0b0101100..TRIG_IN9 input is selected
 *  0b0101101..TRIG_IN10 input is selected
 *  0b0101110..TRIG_IN11 input is selected
 *  0b0101111..GPIO0 Pin Event Trig 0 input is selected
 *  0b0110000..GPIO1 Pin Event Trig 0 input is selected
 *  0b0110001..GPIO2 Pin Event Trig 0 input is selected
 *  0b0110010..GPIO3 Pin Event Trig 0 input is selected
 *  0b0110011..GPIO4 Pin Event Trig 0 input is selected
 *  0b0110100..ADC1_tcomp[0] input is selected
 *  0b0110101..ADC1_tcomp[1] input is selected
 *  0b0110110..ADC1_tcomp[2] input is selected
 *  0b0110111..ADC1_tcomp[3] input is selected
 *  0b0111000..CTimer3_MAT0 input is selected
 *  0b0111001..CTimer3_MAT1 input is selected
 *  0b0111010..CTimer3_MAT2 input is selected
 *  0b0111011..CTimer3_MAT3 input is selected
 *  0b0111100..CTimer4_MAT0 input is selected
 *  0b0111101..CTimer4_MAT1 input is selected
 *  0b0111110..CTimer4_MAT2 input is selected
 *  0b0111111..CTimer4_MAT3 input is selected
 *  0b1000000..FlexIO CH0 input is selected
 *  0b1000001..FlexIO CH1 input is selected
 *  0b1000010..FlexIO CH2 input is selected
 *  0b1000011..FlexIO CH3 input is selected
 *  0b1000100..QDC1_CMP_FLAG0 input is selected
 *  0b1000101..QDC1_CMP_FLAG1 input is selected
 *  0b1000110..QDC1_CMP_FLAG2 input is selected
 *  0b1000111..QDC1_CMP_FLAG3 input is selected
 *  0b1001000..QDC1_POS_MATCH0 input is selected
 *  0b1001001..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1001010..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b1001011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1001100..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b1001101..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1001110..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b1001111..Reserved
 *  0b1010000..Reserved
 *  *..
 */
#define INPUTMUX_AOI1_INPUTM_AOI1_INPUT_INP(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_AOI1_INPUTM_AOI1_INPUT_INP_SHIFT)) & INPUTMUX_AOI1_INPUTM_AOI1_INPUT_INP_MASK)
/*! @} */

/* The count of INPUTMUX_AOI1_INPUTM_AOI1_INPUT */
#define INPUTMUX_AOI1_INPUTM_AOI1_INPUT_COUNT    (16U)

/*! @name CMP0_TRIG - CMP0 input connections */
/*! @{ */

#define INPUTMUX_CMP0_TRIG_TRIGIN_MASK           (0x3FU)
#define INPUTMUX_CMP0_TRIG_TRIGIN_SHIFT          (0U)
/*! TRIGIN - CMP0 input trigger
 *  0b000000..Reserved
 *  0b000001..Reserved
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP1_OUT input is selected
 *  0b000111..Reserved
 *  0b001000..CTimer0_MAT0 input is selected
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer1_MAT0
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer2_MAT0 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..LPTMR0 input is selected
 *  0b001111..Reserved
 *  0b010000..QDC0_POS_MATCH0
 *  0b010001..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b010010..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b010011..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b010100..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b010101..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b010110..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b010111..Reserved
 *  0b011000..Reserved
 *  0b011001..GPIO0 Pin Event Trig 0 input is selected
 *  0b011010..GPIO1 Pin Event Trig 0 input is selected
 *  0b011011..GPIO2 Pin Event Trig 0 input is selected
 *  0b011100..GPIO3 Pin Event Trig 0 input is selected
 *  0b011101..GPIO4 Pin Event Trig 0 input is selected
 *  0b011110..WUU input is selected
 *  0b011111..AOI1_OUT0 input is selected
 *  0b100000..AOI1_OUT1 input is selected
 *  0b100001..AOI1_OUT2 input is selected
 *  0b100010..AOI1_OUT3 input is selected
 *  0b100011..Reserved
 *  0b100100..Reserved
 *  0b100101..Reserved
 *  0b100110..Reserved
 *  0b100111..CTimer3_MAT0
 *  0b101000..CTimer3_MAT1
 *  0b101001..CTimer4_MAT0 input is selected
 *  0b101010..CTimer4_MAT1 input is selected
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..Reserved
 *  0b101110..Reserved
 *  0b101111..QDC1_POS_MATCH0 input is selected
 *  0b110000..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110001..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b110010..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b110011..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b110100..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b110101..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b110110..Reserved
 *  0b110111..Reserved
 *  *..
 */
#define INPUTMUX_CMP0_TRIG_TRIGIN(x)             (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CMP0_TRIG_TRIGIN_SHIFT)) & INPUTMUX_CMP0_TRIG_TRIGIN_MASK)
/*! @} */

/*! @name ADC0_TRIGM_ADC0_TRIG - ADC Trigger input connections */
/*! @{ */

#define INPUTMUX_ADC0_TRIGM_ADC0_TRIG_TRIGIN_MASK (0x3FU)
#define INPUTMUX_ADC0_TRIGM_ADC0_TRIG_TRIGIN_SHIFT (0U)
/*! TRIGIN - ADC0 trigger inputs
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT0 input is selected
 *  0b001010..CTimer0_MAT1 input is selected
 *  0b001011..CTimer1_MAT0 input is selected
 *  0b001100..CTimer1_MAT1 input is selected
 *  0b001101..CTimer2_MAT0 input is selected
 *  0b001110..CTimer2_MAT1 input is selected
 *  0b001111..LPTMR0 input is selected
 *  0b010000..Reserved
 *  0b010001..QDC0_POS_MATCH0 input is selected
 *  0b010010..PWM0_SM0_OUT_TRIG0 input is selected
 *  0b010011..PWM0_SM0_OUT_TRIG1 input is selected
 *  0b010100..PWM0_SM1_OUT_TRIG0 input is selected
 *  0b010101..PWM0_SM1_OUT_TRIG1 input is selected
 *  0b010110..PWM0_SM2_OUT_TRIG0 input is selected
 *  0b010111..PWM0_SM2_OUT_TRIG1 input is selected
 *  0b011000..Reserved
 *  0b011001..Reserved
 *  0b011010..GPIO0 Pin Event Trig 0 input is selected
 *  0b011011..GPIO1 Pin Event Trig 0 input is selected
 *  0b011100..GPIO2 Pin Event Trig 0 input is selected
 *  0b011101..GPIO3 Pin Event Trig 0 input is selected
 *  0b011110..GPIO4 Pin Event Trig 0 input is selected
 *  0b011111..WUU
 *  0b100000..Reserved
 *  0b100001..AOI1_OUT0 input is selected
 *  0b100010..AOI1_OUT1 input is selected
 *  0b100011..AOI1_OUT2 input is selected
 *  0b100100..AOI1_OUT3 input is selected
 *  0b100101..ADC1_tcomp[0] input is selected
 *  0b100110..ADC1_tcomp[1] input is selected
 *  0b100111..ADC1_tcomp[2] input is selected
 *  0b101000..ADC1_tcomp[3] input is selected
 *  0b101001..CTimer3_MAT0 input is selected
 *  0b101010..CTimer3_MAT1 input is selected
 *  0b101011..CTimer4_MAT0 input is selected
 *  0b101100..CTimer4_MAT1 input is selected
 *  0b101101..FlexIO CH0 input is selected
 *  0b101110..FlexIO CH1 input is selected
 *  0b101111..FlexIO CH2 input is selected
 *  0b110000..FlexIO CH3 input is selected
 *  0b110001..QDC1_POS_MATCH0 input is selected
 *  0b110010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110011..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b110100..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b110101..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b110110..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111000..Reserved
 *  0b111001..Reserved
 *  *..
 */
#define INPUTMUX_ADC0_TRIGM_ADC0_TRIG_TRIGIN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_ADC0_TRIGM_ADC0_TRIG_TRIGIN_SHIFT)) & INPUTMUX_ADC0_TRIGM_ADC0_TRIG_TRIGIN_MASK)
/*! @} */

/* The count of INPUTMUX_ADC0_TRIGM_ADC0_TRIG */
#define INPUTMUX_ADC0_TRIGM_ADC0_TRIG_COUNT      (4U)

/*! @name ADC1_TRIGM_ADC1_TRIG - ADC Trigger input connections */
/*! @{ */

#define INPUTMUX_ADC1_TRIGM_ADC1_TRIG_TRIGIN_MASK (0x3FU)
#define INPUTMUX_ADC1_TRIGM_ADC1_TRIG_TRIGIN_SHIFT (0U)
/*! TRIGIN - ADC0 trigger inputs
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT0 input is selected
 *  0b001010..CTimer0_MAT1 input is selected
 *  0b001011..CTimer1_MAT0 input is selected
 *  0b001100..CTimer1_MAT1 input is selected
 *  0b001101..CTimer2_MAT0 input is selected
 *  0b001110..CTimer2_MAT1 input is selected
 *  0b001111..LPTMR0 input is selected
 *  0b010000..Reserved
 *  0b010001..QDC0_POS_MATCH0 input is selected
 *  0b010010..PWM0_SM0_OUT_TRIG0 input is selected
 *  0b010011..PWM0_SM0_OUT_TRIG1 input is selected
 *  0b010100..PWM0_SM1_OUT_TRIG0 input is selected
 *  0b010101..PWM0_SM1_OUT_TRIG1 input is selected
 *  0b010110..PWM0_SM2_OUT_TRIG0 input is selected
 *  0b010111..PWM0_SM2_OUT_TRIG1 input is selected
 *  0b011000..Reserved
 *  0b011001..Reserved
 *  0b011010..GPIO0 Pin Event Trig 0 input is selected
 *  0b011011..GPIO1 Pin Event Trig 0 input is selected
 *  0b011100..GPIO2 Pin Event Trig 0 input is selected
 *  0b011101..GPIO3 Pin Event Trig 0 input is selected
 *  0b011110..GPIO4 Pin Event Trig 0 input is selected
 *  0b011111..WUU
 *  0b100000..Reserved
 *  0b100001..AOI1_OUT0 input is selected
 *  0b100010..AOI1_OUT1 input is selected
 *  0b100011..AOI1_OUT2 input is selected
 *  0b100100..AOI1_OUT3 input is selected
 *  0b100101..ADC0_tcomp[0] input is selected
 *  0b100110..ADC0_tcomp[1] input is selected
 *  0b100111..ADC0_tcomp[2] input is selected
 *  0b101000..ADC0_tcomp[3] input is selected
 *  0b101001..CTimer3_MAT0 input is selected
 *  0b101010..CTimer3_MAT1 input is selected
 *  0b101011..CTimer4_MAT0 input is selected
 *  0b101100..CTimer4_MAT1 input is selected
 *  0b101101..FlexIO CH0 input is selected
 *  0b101110..FlexIO CH1 input is selected
 *  0b101111..FlexIO CH2 input is selected
 *  0b110000..FlexIO CH3 input is selected
 *  0b110001..QDC1_POS_MATCH0 input is selected
 *  0b110010..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110011..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b110100..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b110101..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b110110..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111000..Reserved
 *  0b111001..Reserved
 *  *..
 */
#define INPUTMUX_ADC1_TRIGM_ADC1_TRIG_TRIGIN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_ADC1_TRIGM_ADC1_TRIG_TRIGIN_SHIFT)) & INPUTMUX_ADC1_TRIGM_ADC1_TRIG_TRIGIN_MASK)
/*! @} */

/* The count of INPUTMUX_ADC1_TRIGM_ADC1_TRIG */
#define INPUTMUX_ADC1_TRIGM_ADC1_TRIG_COUNT      (4U)

/*! @name DAC0_TRIG - This register selects the DAC0 trigger inputs. */
/*! @{ */

#define INPUTMUX_DAC0_TRIG_TRIGIN_MASK           (0x3FU)
#define INPUTMUX_DAC0_TRIG_TRIGIN_SHIFT          (0U)
/*! TRIGIN - DAC0 trigger input
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT0 input is selected
 *  0b001010..CTimer0_MAT1 input is selected
 *  0b001011..CTimer1_MAT0 input is selected
 *  0b001100..CTimer1_MAT1 input is selected
 *  0b001101..CTimer2_MAT0 input is selected
 *  0b001110..CTimer2_MAT1 input is selected
 *  0b001111..LPTMR0 input is selected
 *  0b010000..Reserved
 *  0b010001..Reserved
 *  0b010010..Reserved
 *  0b010011..Reserved
 *  0b010100..Reserved
 *  0b010101..Reserved
 *  0b010110..Reserved
 *  0b010111..Reserved
 *  0b011000..Reserved
 *  0b011001..Reserved
 *  0b011010..GPIO0 Pin Event Trig 0 input is selected
 *  0b011011..GPIO1 Pin Event Trig 0 input is selected
 *  0b011100..GPIO2 Pin Event Trig 0 input is selected
 *  0b011101..GPIO3 Pin Event Trig 0 input is selected
 *  0b011110..GPIO4 Pin Event Trig 0 input is selected
 *  0b011111..WUU input is selected
 *  0b100000..Reserved
 *  0b100001..AOI1_OUT0 input is selected
 *  0b100010..AOI1_OUT1 input is selected
 *  0b100011..AOI1_OUT2 input is selected
 *  0b100100..AOI1_OUT3 input is selected
 *  0b100101..ADC0_tcomp[0] input is selected
 *  0b100110..ADC0_tcomp[1] input is selected
 *  0b100111..ADC1_tcomp[0] input is selected
 *  0b101000..ADC1_tcomp[1] input is selected
 *  0b101001..CTimer3_MAT0 input is selected
 *  0b101010..CTimer3_MAT1 input is selected
 *  0b101011..CTimer4_MAT0 input is selected
 *  0b101100..CTimer4_MAT1 input is selected
 *  0b101101..Reserved
 *  0b101110..Reserved
 *  0b101111..Reserved
 *  0b110000..Reserved
 *  0b110001..Reserved
 *  0b110010..Reserved
 *  0b110011..Reserved
 *  0b110100..Reserved
 *  0b110101..Reserved
 *  0b110110..Reserved
 *  0b110111..Reserved
 *  0b111000..Reserved
 *  0b111001..Reserved
 *  *..
 */
#define INPUTMUX_DAC0_TRIG_TRIGIN(x)             (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DAC0_TRIG_TRIGIN_SHIFT)) & INPUTMUX_DAC0_TRIG_TRIGIN_MASK)
/*! @} */

/*! @name QDC0_TRIG - QDC0 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC0_TRIG_INP_MASK              (0x7FU)
#define INPUTMUX_QDC0_TRIG_INP_SHIFT             (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC0_TRIG_INP(x)                (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC0_TRIG_INP_SHIFT)) & INPUTMUX_QDC0_TRIG_INP_MASK)
/*! @} */

/*! @name QDC0_HOME - QDC0 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC0_HOME_INP_MASK              (0x7FU)
#define INPUTMUX_QDC0_HOME_INP_SHIFT             (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC0_HOME_INP(x)                (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC0_HOME_INP_SHIFT)) & INPUTMUX_QDC0_HOME_INP_MASK)
/*! @} */

/*! @name QDC0_INDEX - QDC0 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC0_INDEX_INP_MASK             (0x7FU)
#define INPUTMUX_QDC0_INDEX_INP_SHIFT            (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC0_INDEX_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC0_INDEX_INP_SHIFT)) & INPUTMUX_QDC0_INDEX_INP_MASK)
/*! @} */

/*! @name QDC0_PHASEB - QDC0 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC0_PHASEB_INP_MASK            (0x7FU)
#define INPUTMUX_QDC0_PHASEB_INP_SHIFT           (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC0_PHASEB_INP(x)              (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC0_PHASEB_INP_SHIFT)) & INPUTMUX_QDC0_PHASEB_INP_MASK)
/*! @} */

/*! @name QDC0_PHASEA - QDC0 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC0_PHASEA_INP_MASK            (0x7FU)
#define INPUTMUX_QDC0_PHASEA_INP_SHIFT           (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC0_PHASEA_INP(x)              (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC0_PHASEA_INP_SHIFT)) & INPUTMUX_QDC0_PHASEA_INP_MASK)
/*! @} */

/*! @name QDC0_ICAP1 - QDC0 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC0_ICAP1_INP_MASK             (0x7FU)
#define INPUTMUX_QDC0_ICAP1_INP_SHIFT            (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC0_ICAP1_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC0_ICAP1_INP_SHIFT)) & INPUTMUX_QDC0_ICAP1_INP_MASK)
/*! @} */

/*! @name QDC0_ICAP2 - QDC0 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC0_ICAP2_INP_MASK             (0x7FU)
#define INPUTMUX_QDC0_ICAP2_INP_SHIFT            (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC0_ICAP2_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC0_ICAP2_INP_SHIFT)) & INPUTMUX_QDC0_ICAP2_INP_MASK)
/*! @} */

/*! @name QDC0_ICAP3 - QDC0 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC0_ICAP3_INP_MASK             (0x7FU)
#define INPUTMUX_QDC0_ICAP3_INP_SHIFT            (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC0_ICAP3_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC0_ICAP3_INP_SHIFT)) & INPUTMUX_QDC0_ICAP3_INP_MASK)
/*! @} */

/*! @name QDC1_TRIG - QDC1 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC1_TRIG_INP_MASK              (0x7FU)
#define INPUTMUX_QDC1_TRIG_INP_SHIFT             (0U)
/*! INP - QDC1 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC1_TRIG_INP(x)                (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC1_TRIG_INP_SHIFT)) & INPUTMUX_QDC1_TRIG_INP_MASK)
/*! @} */

/*! @name QDC1_HOME - QDC1 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC1_HOME_INP_MASK              (0x7FU)
#define INPUTMUX_QDC1_HOME_INP_SHIFT             (0U)
/*! INP - QDC1 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC1_HOME_INP(x)                (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC1_HOME_INP_SHIFT)) & INPUTMUX_QDC1_HOME_INP_MASK)
/*! @} */

/*! @name QDC1_INDEX - QDC1 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC1_INDEX_INP_MASK             (0x7FU)
#define INPUTMUX_QDC1_INDEX_INP_SHIFT            (0U)
/*! INP - QDC1 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC1_INDEX_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC1_INDEX_INP_SHIFT)) & INPUTMUX_QDC1_INDEX_INP_MASK)
/*! @} */

/*! @name QDC1_PHASEB - QDC1 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC1_PHASEB_INP_MASK            (0x7FU)
#define INPUTMUX_QDC1_PHASEB_INP_SHIFT           (0U)
/*! INP - QDC1 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC1_PHASEB_INP(x)              (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC1_PHASEB_INP_SHIFT)) & INPUTMUX_QDC1_PHASEB_INP_MASK)
/*! @} */

/*! @name QDC1_PHASEA - QDC1 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC1_PHASEA_INP_MASK            (0x7FU)
#define INPUTMUX_QDC1_PHASEA_INP_SHIFT           (0U)
/*! INP - QDC0 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC1_PHASEA_INP(x)              (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC1_PHASEA_INP_SHIFT)) & INPUTMUX_QDC1_PHASEA_INP_MASK)
/*! @} */

/*! @name QDC1_ICAP1 - QDC1 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC1_ICAP1_INP_MASK             (0x7FU)
#define INPUTMUX_QDC1_ICAP1_INP_SHIFT            (0U)
/*! INP - QDC1 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC1_ICAP1_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC1_ICAP1_INP_SHIFT)) & INPUTMUX_QDC1_ICAP1_INP_MASK)
/*! @} */

/*! @name QDC1_ICAP2 - QDC1 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC1_ICAP2_INP_MASK             (0x7FU)
#define INPUTMUX_QDC1_ICAP2_INP_SHIFT            (0U)
/*! INP - QDC1 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC1_ICAP2_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC1_ICAP2_INP_SHIFT)) & INPUTMUX_QDC1_ICAP2_INP_MASK)
/*! @} */

/*! @name QDC1_ICAP3 - QDC1 Trigger Input Connections */
/*! @{ */

#define INPUTMUX_QDC1_ICAP3_INP_MASK             (0x7FU)
#define INPUTMUX_QDC1_ICAP3_INP_SHIFT            (0U)
/*! INP - QDC1 input connections
 *  0b0000000..Reserved
 *  0b0000001..ARM_TXEV input is selected
 *  0b0000010..AOI0_OUT0 input is selected
 *  0b0000011..AOI0_OUT1 input is selected
 *  0b0000100..AOI0_OUT2 input is selected
 *  0b0000101..AOI0_OUT3 input is selected
 *  0b0000110..CMP0_OUT input is selected
 *  0b0000111..CMP1_OUT input is selected
 *  0b0001000..Reserved
 *  0b0001001..CTimer0_MAT2 input is selected
 *  0b0001010..CTimer0_MAT3
 *  0b0001011..CTimer1_MAT2 input is selected
 *  0b0001100..CTimer1_MAT3 input is selected
 *  0b0001101..CTimer2_MAT2 input is selected
 *  0b0001110..CTimer2_MAT3 input is selected
 *  0b0001111..Reserved
 *  0b0010000..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b0010001..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0010010..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0010011..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0010100..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0010101..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0010110..Reserved
 *  0b0010111..Reserved
 *  0b0011000..TRIG_IN0 input is selected
 *  0b0011001..TRIG_IN1 input is selected
 *  0b0011010..TRIG_IN2 input is selected
 *  0b0011011..TRIG_IN3 input is selected
 *  0b0011100..TRIG_IN4 input is selected
 *  0b0011101..TRIG_IN5 input is selected
 *  0b0011110..TRIG_IN6 input is selected
 *  0b0011111..TRIG_IN7 input is selected
 *  0b0100000..TRIG_IN8 input is selected
 *  0b0100001..TRIG_IN9 input is selected
 *  0b0100010..TRIG_IN10 input is selected
 *  0b0100011..TRIG_IN11 input is selected
 *  0b0100100..GPIO0 Pin Event Trig 0 is selected
 *  0b0100101..GPIO1 Pin Event Trig 0 input is selected
 *  0b0100110..GPIO2 Pin Event Trig 0 input is selected
 *  0b0100111..GPIO3 Pin Event Trig 0 input is selected
 *  0b0101000..GPIO4 Pin Event Trig 0 input is selected
 *  0b0101001..AOI1_OUT0 input is selected
 *  0b0101010..AOI1_OUT1 input is selected
 *  0b0101011..AOI1_OUT2 input is selected
 *  0b0101100..AOI1_OUT3 input is selected
 *  0b0101101..Reserved
 *  0b0101110..Reserved
 *  0b0101111..Reserved
 *  0b0110000..Reserved
 *  0b0110001..CTimer3_MAT2 input is selected
 *  0b0110010..CTimer3_MAT3 input is selected
 *  0b0110011..CTimer4_MAT2 input is selected
 *  0b0110100..CTimer4_MAT3 End of Frame input is selected
 *  0b0110101..Reserved
 *  0b0110110..Reserved
 *  0b0110111..Reserved
 *  0b0111000..Reserved
 *  0b0111001..Reserved
 *  0b0111010..Reserved
 *  0b0111011..Reserved
 *  0b0111100..Reserved
 *  0b0111101..Reserved
 *  0b0111110..PWM1_SM0_OUT_TRIG0 input is selected
 *  0b0111111..PWM1_SM0_OUT_TRIG1 input is selected
 *  0b1000000..PWM1_SM1_OUT_TRIG0 input is selected
 *  0b1000001..PWM1_SM1_OUT_TRIG1 input is selected
 *  0b1000010..PWM1_SM2_OUT_TRIG0 input is selected
 *  0b1000011..PWM1_SM2_OUT_TRIG1 input is selected
 *  0b1000100..Reserved
 *  0b1000101..Reserved
 *  *..
 */
#define INPUTMUX_QDC1_ICAP3_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_QDC1_ICAP3_INP_SHIFT)) & INPUTMUX_QDC1_ICAP3_INP_MASK)
/*! @} */

/*! @name FLEXPWM0_SM0_EXTA0 - PWM0 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM0_SM0_EXTA0_TRIGIN_MASK  (0x3FU)
#define INPUTMUX_FLEXPWM0_SM0_EXTA0_TRIGIN_SHIFT (0U)
/*! TRIGIN - EXTA input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM0_SM0_EXTA0_TRIGIN(x)    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM0_SM0_EXTA0_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM0_SM0_EXTA0_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM0_SM0_EXTSYNC - PWM0 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM0_SM0_EXTSYNC_TRIGIN_MASK (0x3FU)
#define INPUTMUX_FLEXPWM0_SM0_EXTSYNC_TRIGIN_SHIFT (0U)
/*! TRIGIN - EXTSYNC input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM0_SM0_EXTSYNC_TRIGIN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM0_SM0_EXTSYNC_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM0_SM0_EXTSYNC_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM0_SM1_EXTA - PWM0 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM0_SM1_EXTA_TRIGIN_MASK   (0x3FU)
#define INPUTMUX_FLEXPWM0_SM1_EXTA_TRIGIN_SHIFT  (0U)
/*! TRIGIN - EXTA input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM0_SM1_EXTA_TRIGIN(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM0_SM1_EXTA_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM0_SM1_EXTA_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM0_SM1_EXTSYNC - PWM0 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM0_SM1_EXTSYNC_TRIGIN_MASK (0x3FU)
#define INPUTMUX_FLEXPWM0_SM1_EXTSYNC_TRIGIN_SHIFT (0U)
/*! TRIGIN - EXTSYNC input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM0_SM1_EXTSYNC_TRIGIN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM0_SM1_EXTSYNC_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM0_SM1_EXTSYNC_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM0_SM2_EXTA - PWM0 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM0_SM2_EXTA_TRIGIN_MASK   (0x3FU)
#define INPUTMUX_FLEXPWM0_SM2_EXTA_TRIGIN_SHIFT  (0U)
/*! TRIGIN - EXTA input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM0_SM2_EXTA_TRIGIN(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM0_SM2_EXTA_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM0_SM2_EXTA_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM0_SM2_EXTSYNC - PWM0 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM0_SM2_EXTSYNC_TRIGIN_MASK (0x3FU)
#define INPUTMUX_FLEXPWM0_SM2_EXTSYNC_TRIGIN_SHIFT (0U)
/*! TRIGIN - EXTSYNC input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM0_SM2_EXTSYNC_TRIGIN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM0_SM2_EXTSYNC_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM0_SM2_EXTSYNC_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM0_FAULT - PWM0 Fault Input Trigger Connections */
/*! @{ */

#define INPUTMUX_FLEXPWM0_FAULT_TRIGIN_MASK      (0x3FU)
#define INPUTMUX_FLEXPWM0_FAULT_TRIGIN_SHIFT     (0U)
/*! TRIGIN - FAULT input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM0_FAULT_TRIGIN(x)        (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM0_FAULT_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM0_FAULT_TRIGIN_MASK)
/*! @} */

/* The count of INPUTMUX_FLEXPWM0_FAULT */
#define INPUTMUX_FLEXPWM0_FAULT_COUNT            (4U)

/*! @name FLEXPWM0_FORCE - PWM0 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM0_FORCE_TRIGIN_MASK      (0x3FU)
#define INPUTMUX_FLEXPWM0_FORCE_TRIGIN_SHIFT     (0U)
/*! TRIGIN - Trigger input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM0_FORCE_TRIGIN(x)        (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM0_FORCE_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM0_FORCE_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM1_SM0_EXTA0 - PWM1 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM1_SM0_EXTA0_TRIGIN_MASK  (0x3FU)
#define INPUTMUX_FLEXPWM1_SM0_EXTA0_TRIGIN_SHIFT (0U)
/*! TRIGIN - EXTA input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM1_SM0_EXTA0_TRIGIN(x)    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM1_SM0_EXTA0_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM1_SM0_EXTA0_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM1_SM0_EXTSYNC - PWM1 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM1_SM0_EXTSYNC_TRIGIN_MASK (0x3FU)
#define INPUTMUX_FLEXPWM1_SM0_EXTSYNC_TRIGIN_SHIFT (0U)
/*! TRIGIN - EXTSYNC input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM1_SM0_EXTSYNC_TRIGIN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM1_SM0_EXTSYNC_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM1_SM0_EXTSYNC_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM1_SM1_EXTA - PWM1 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM1_SM1_EXTA_TRIGIN_MASK   (0x3FU)
#define INPUTMUX_FLEXPWM1_SM1_EXTA_TRIGIN_SHIFT  (0U)
/*! TRIGIN - EXTA input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM1_SM1_EXTA_TRIGIN(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM1_SM1_EXTA_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM1_SM1_EXTA_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM1_SM1_EXTSYNC - PWM1 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM1_SM1_EXTSYNC_TRIGIN_MASK (0x3FU)
#define INPUTMUX_FLEXPWM1_SM1_EXTSYNC_TRIGIN_SHIFT (0U)
/*! TRIGIN - EXTSYNC input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM1_SM1_EXTSYNC_TRIGIN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM1_SM1_EXTSYNC_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM1_SM1_EXTSYNC_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM1_SM2_EXTA - PWM1 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM1_SM2_EXTA_TRIGIN_MASK   (0x3FU)
#define INPUTMUX_FLEXPWM1_SM2_EXTA_TRIGIN_SHIFT  (0U)
/*! TRIGIN - EXTA input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM1_SM2_EXTA_TRIGIN(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM1_SM2_EXTA_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM1_SM2_EXTA_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM1_SM2_EXTSYNC - PWM1 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM1_SM2_EXTSYNC_TRIGIN_MASK (0x3FU)
#define INPUTMUX_FLEXPWM1_SM2_EXTSYNC_TRIGIN_SHIFT (0U)
/*! TRIGIN - EXTSYNC input connections for PWM0
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM1_SM2_EXTSYNC_TRIGIN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM1_SM2_EXTSYNC_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM1_SM2_EXTSYNC_TRIGIN_MASK)
/*! @} */

/*! @name FLEXPWM1_FAULT - PWM1 Fault Input Trigger Connections */
/*! @{ */

#define INPUTMUX_FLEXPWM1_FAULT_TRIGIN_MASK      (0x3FU)
#define INPUTMUX_FLEXPWM1_FAULT_TRIGIN_SHIFT     (0U)
/*! TRIGIN - FAULT input connections for PWM1
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM1_FAULT_TRIGIN(x)        (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM1_FAULT_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM1_FAULT_TRIGIN_MASK)
/*! @} */

/* The count of INPUTMUX_FLEXPWM1_FAULT */
#define INPUTMUX_FLEXPWM1_FAULT_COUNT            (4U)

/*! @name FLEXPWM1_FORCE - PWM1 input trigger connections */
/*! @{ */

#define INPUTMUX_FLEXPWM1_FORCE_TRIGIN_MASK      (0x3FU)
#define INPUTMUX_FLEXPWM1_FORCE_TRIGIN_SHIFT     (0U)
/*! TRIGIN - Trigger input connections for PWM1
 *  0b000000..Reserved
 *  0b000001..ARM_TXEV input is selected
 *  0b000010..AOI0_OUT0 input is selected
 *  0b000011..AOI0_OUT1 input is selected
 *  0b000100..AOI0_OUT2 input is selected
 *  0b000101..AOI0_OUT3 input is selected
 *  0b000110..CMP0_OUT input is selected
 *  0b000111..CMP1_OUT input is selected
 *  0b001000..Reserved
 *  0b001001..CTimer0_MAT2 input is selected
 *  0b001010..CTimer0_MAT3 input is selected
 *  0b001011..CTimer1_MAT2 input is selected
 *  0b001100..CTimer1_MAT3 input is selected
 *  0b001101..CTimer2_MAT2 input is selected
 *  0b001110..CTimer2_MAT3 input is selected
 *  0b001111..QDC0_CMP_FLAG0 input is selected
 *  0b010000..QDC0_CMP_FLAG1 input is selected
 *  0b010001..QDC0_CMP_FLAG2 input is selected
 *  0b010010..QDC0_CMP_FLAG3 input is selected
 *  0b010011..QDC0_POS_MATCH0 input is selected
 *  0b010100..TRIG_IN0 input is selected
 *  0b010101..TRIG_IN1 input is selected
 *  0b010110..TRIG_IN2 input is selected
 *  0b010111..TRIG_IN3 input is selected
 *  0b011000..TRIG_IN4 input is selected
 *  0b011001..TRIG_IN5 input is selected
 *  0b011010..TRIG_IN6 input is selected
 *  0b011011..TRIG_IN7 input is selected
 *  0b011100..TRIG_IN8 input is selected
 *  0b011101..TRIG_IN9 input is selected
 *  0b011110..TRIG_IN10 input is selected
 *  0b011111..TRIG_IN11 input is selected
 *  0b100000..GPIO0 Pin Event Trig 0 input is selected
 *  0b100001..GPIO1 Pin Event Trig 0 input is selected
 *  0b100010..GPIO2 Pin Event Trig 0 input is selected
 *  0b100011..GPIO3 Pin Event Trig 0 input is selected
 *  0b100100..GPIO4 Pin Event Trig 0 input is selected
 *  0b100101..AOI1_OUT0 input is selected
 *  0b100110..AOI1_OUT1 input is selected
 *  0b100111..AOI1_OUT2 input is selected
 *  0b101000..AOI1_OUT3 input is selected
 *  0b101001..Reserved
 *  0b101010..Reserved
 *  0b101011..Reserved
 *  0b101100..Reserved
 *  0b101101..CTimer3_MAT2 input is selected
 *  0b101110..CTimer3_MAT3 input is selected
 *  0b101111..CTimer4_MAT2 input is selected
 *  0b110000..CTimer4_MAT3 input is selected
 *  0b110001..QDC1_CMP_FLAG0 input is selected
 *  0b110010..QDC1_CMP_FLAG1 input is selected
 *  0b110011..QDC1_CMP_FLAG2 input is selected
 *  0b110100..QDC1_CMP_FLAG3 input is selected
 *  0b110101..QDC1_POS_MATCH0 input is selected
 *  0b110110..PWM0_SM0_MUX_TRIG0 input is selected
 *  0b110111..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b111000..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b111001..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b111010..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b111011..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b111100..Reserved
 *  0b111101..Reserved
 *  *..
 */
#define INPUTMUX_FLEXPWM1_FORCE_TRIGIN(x)        (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FLEXPWM1_FORCE_TRIGIN_SHIFT)) & INPUTMUX_FLEXPWM1_FORCE_TRIGIN_MASK)
/*! @} */

/*! @name PWM0_EXT_CLK - PWM0 external clock trigger */
/*! @{ */

#define INPUTMUX_PWM0_EXT_CLK_TRIGIN_MASK        (0xFU)
#define INPUTMUX_PWM0_EXT_CLK_TRIGIN_SHIFT       (0U)
/*! TRIGIN - Trigger input connections for PWM
 *  0b0000..Reserved
 *  0b0001..clk_16k[1] input is selected
 *  0b0010..clk_in input is selected
 *  0b0011..AOI0_OUT0 input is selected
 *  0b0100..AOI0_OUT1 input is selected
 *  0b0101..EXTTRIG_IN0 input is selected
 *  0b0110..EXTTRIG_IN7 input is selected
 *  0b0111..AOI1_OUT0 input is selected
 *  0b1000..AOI1_OUT1 input is selected
 *  *..
 */
#define INPUTMUX_PWM0_EXT_CLK_TRIGIN(x)          (((uint32_t)(((uint32_t)(x)) << INPUTMUX_PWM0_EXT_CLK_TRIGIN_SHIFT)) & INPUTMUX_PWM0_EXT_CLK_TRIGIN_MASK)
/*! @} */

/*! @name PWM1_EXT_CLK - PWM1 external clock trigger */
/*! @{ */

#define INPUTMUX_PWM1_EXT_CLK_TRIGIN_MASK        (0xFU)
#define INPUTMUX_PWM1_EXT_CLK_TRIGIN_SHIFT       (0U)
/*! TRIGIN - Trigger input connections for PWM
 *  0b0000..Reserved
 *  0b0001..clk_16k[1] input is selected
 *  0b0010..clk_in input is selected
 *  0b0011..AOI0_OUT0 input is selected
 *  0b0100..AOI0_OUT1 input is selected
 *  0b0101..EXTTRIG_IN0 input is selected
 *  0b0110..EXTTRIG_IN7 input is selected
 *  0b0111..AOI1_OUT0 input is selected
 *  0b1000..AOI1_OUT1 input is selected
 *  *..
 */
#define INPUTMUX_PWM1_EXT_CLK_TRIGIN(x)          (((uint32_t)(((uint32_t)(x)) << INPUTMUX_PWM1_EXT_CLK_TRIGIN_SHIFT)) & INPUTMUX_PWM1_EXT_CLK_TRIGIN_MASK)
/*! @} */

/*! @name AOI0_INPUTK_AOI0_INPUT - AOI0 trigger input connections 0 */
/*! @{ */

#define INPUTMUX_AOI0_INPUTK_AOI0_INPUT_INP_MASK (0x7FU)
#define INPUTMUX_AOI0_INPUTK_AOI0_INPUT_INP_SHIFT (0U)
/*! INP - AOI0 trigger input connections
 *  0b0000000..Reserved
 *  0b0000001..ADC0_tcomp[0] input is selected
 *  0b0000010..ADC0_tcomp[1] input is selected
 *  0b0000011..ADC0_tcomp[2] input is selected
 *  0b0000100..ADC0_tcomp[3] input is selected
 *  0b0000101..CMP0_OUT input is selected
 *  0b0000110..CMP1_OUT input is selected
 *  0b0000111..Reserved
 *  0b0001000..CTimer0_MAT0 input is selected
 *  0b0001001..CTimer0_MAT1 input is selected
 *  0b0001010..CTimer0_MAT2 input is selected
 *  0b0001011..CTimer0_MAT3 input is selected
 *  0b0001100..CTimer1_MAT0
 *  0b0001101..CTimer1_MAT1 input is selected
 *  0b0001110..CTimer1_MAT2 input is selected
 *  0b0001111..CTimer1_MAT3 input is selected
 *  0b0010000..CTimer2_MAT0 input is selected
 *  0b0010001..CTimer2_MAT1 input is selected
 *  0b0010010..CTimer2_MAT2 input is selected
 *  0b0010011..CTimer2_MAT3 input is selected
 *  0b0010100..LPTMR0 input is selected
 *  0b0010101..Reserved
 *  0b0010110..QDC0_CMP_FLAG0 input is selected
 *  0b0010111..QDC0_CMP_FLAG1 input is selected
 *  0b0011000..QDC0_CMP_FLAG2 input is selected
 *  0b0011001..QDC0_CMP_FLAG3 input is selected
 *  0b0011010..QDC0_POS_MATCH input is selected
 *  0b0011011..PWM0_SM0_MUX_TRIG0 0 input is selected
 *  0b0011100..PWM0_SM0_MUX_TRIG1 input is selected
 *  0b0011101..PWM0_SM1_MUX_TRIG0 input is selected
 *  0b0011110..PWM0_SM1_MUX_TRIG1 input is selected
 *  0b0011111..PWM0_SM2_MUX_TRIG0 input is selected
 *  0b0100000..PWM0_SM2_MUX_TRIG1 input is selected
 *  0b0100001..Reserved
 *  0b0100010..Reserved
 *  0b0100011..TRIG_IN0 input is selected
 *  0b0100100..TRIG_IN1 input is selected
 *  0b0100101..TRIG_IN2 input is selected
 *  0b0100110..TRIG_IN3 input is selected
 *  0b0100111..TRIG_IN4 input is selected
 *  0b0101000..TRIG_IN5 input is selected
 *  0b0101001..TRIG_IN6 input is selected
 *  0b0101010..TRIG_IN7 input is selected
 *  0b0101011..TRIG_IN8 input is selected
 *  0b0101100..TRIG_IN9 input is selected
 *  0b0101101..TRIG_IN10 input is selected
 *  0b0101110..TRIG_IN11 input is selected
 *  0b0101111..GPIO0 Pin Event Trig 0 input is selected
 *  0b0110000..GPIO1 Pin Event Trig 0 input is selected
 *  0b0110001..GPIO2 Pin Event Trig 0 input is selected
 *  0b0110010..GPIO3 Pin Event Trig 0 input is selected
 *  0b0110011..GPIO4 Pin Event Trig 0 input is selected
 *  0b0110100..ADC1_tcomp[0] input is selected
 *  0b0110101..ADC1_tcomp[1] input is selected
 *  0b0110110..ADC1_tcomp[2] input is selected
 *  0b0110111..ADC1_tcomp[3] input is selected
 *  0b0111000..CTimer3_MAT0 input is selected
 *  0b0111001..CTimer3_MAT1 input is selected
 *  0b0111010..CTimer3_MAT2 input is selected
 *  0b0111011..CTimer3_MAT3 input is selected
 *  0b0111100..CTimer4_MAT0 input is selected
 *  0b0111101..CTimer4_MAT1 input is selected
 *  0b0111110..CTimer4_MAT2 input is selected
 *  0b0111111..CTimer4_MAT3 input is selected
 *  0b1000000..FlexIO CH0 input is selected
 *  0b1000001..FlexIO CH1 input is selected
 *  0b1000010..FlexIO CH2 input is selected
 *  0b1000011..FlexIO CH3 input is selected
 *  0b1000100..QDC1_CMP_FLAG0 input is selected
 *  0b1000101..QDC1_CMP_FLAG1 input is selected
 *  0b1000110..QDC1_CMP_FLAG2 input is selected
 *  0b1000111..QDC1_CMP_FLAG3 input is selected
 *  0b1001000..QDC1_POS_MATCH0 input is selected
 *  0b1001001..PWM1_SM0_MUX_TRIG0 input is selected
 *  0b1001010..PWM1_SM0_MUX_TRIG1 input is selected
 *  0b1001011..PWM1_SM1_MUX_TRIG0 input is selected
 *  0b1001100..PWM1_SM1_MUX_TRIG1 input is selected
 *  0b1001101..PWM1_SM2_MUX_TRIG0 input is selected
 *  0b1001110..PWM1_SM2_MUX_TRIG1 input is selected
 *  0b1001111..Reserved
 *  0b1010000..Reserved
 *  *..
 */
#define INPUTMUX_AOI0_INPUTK_AOI0_INPUT_INP(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_AOI0_INPUTK_AOI0_INPUT_INP_SHIFT)) & INPUTMUX_AOI0_INPUTK_AOI0_INPUT_INP_MASK)
/*! @} */

/* The count of INPUTMUX_AOI0_INPUTK_AOI0_INPUT */
#define INPUTMUX_AOI0_INPUTK_AOI0_INPUT_COUNT    (16U)

/*! @name USBFS_TRIG - USB-FS trigger input connections */
/*! @{ */

#define INPUTMUX_USBFS_TRIG_INP_MASK             (0xFU)
#define INPUTMUX_USBFS_TRIG_INP_SHIFT            (0U)
/*! INP - USB-FS trigger input connections.
 *  0b0000..Reserved
 *  0b0001..LPUART0 lpuart_trg_txdata input is selected
 *  0b0010..LPUART1 lpuart_trg_txdata input is selected
 *  0b0011..LPUART2 lpuart_trg_txdata input is selected
 *  0b0100..LPUART3 lpuart_trg_txdata input is selected
 *  0b0101..LPUART4 lpuart_trg_txda input is selected
 *  *..
 */
#define INPUTMUX_USBFS_TRIG_INP(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_USBFS_TRIG_INP_SHIFT)) & INPUTMUX_USBFS_TRIG_INP_MASK)
/*! @} */

/*! @name EXT_TRIG0 - EXT trigger connections 0 */
/*! @{ */

#define INPUTMUX_EXT_TRIG0_INP_MASK              (0x1FU)
#define INPUTMUX_EXT_TRIG0_INP_SHIFT             (0U)
/*! INP - EXT trigger input connections
 *  0b00000..Reserved
 *  0b00001..Reserved
 *  0b00010..AOI0_OUT0 input is selected
 *  0b00011..AOI0_OUT1 input is selected
 *  0b00100..AOI0_OUT2 input is selected
 *  0b00101..AOI0_OUT3 input is selected
 *  0b00110..CMP0_OUT input is selected
 *  0b00111..CMP1_OUT input is selected
 *  0b01000..Reserved
 *  0b01001..LPUART0 input is selected
 *  0b01010..LPUART1 input is selected
 *  0b01011..LPUART2 input is selected
 *  0b01100..LPUART3 input is selected
 *  0b01101..LPUART4 input is selected
 *  0b01110..AOI1_OUT0 input is selected
 *  0b01111..AOI1_OUT1 input is selected
 *  0b10000..AOI1_OUT2 input is selected
 *  0b10001..AOI1_OUT3 input is selected
 *  *..
 */
#define INPUTMUX_EXT_TRIG0_INP