/*
 * Copyright 2022 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 /***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v13.0
processor: MCXN947
package_id: MCXN947VDF
mcu_data: ksdk2_0
processor_version: 0.13.2
pin_labels:
- {pin_num: B12, pin_signal: PIO0_10/FC0_P6/CT0_MAT0/FLEXIO0_D2/ADC0_B10, label: EZH_CAM_VSYNC, identifier: EZH_CAM_VSYNC}
- {pin_num: B11, pin_signal: PIO0_11/CT0_MAT1/FLEXIO0_D3/HSCMP2_OUT/ADC0_B11, label: EZH_CAM_HSYNC, identifier: EZH_CAM_HSYNC}
- {pin_num: E11, pin_signal: PIO0_14/FC1_P6/FC0_P2/CT_INP2/UTICK_CAP0/FLEXIO0_D6/ADC0_B14, label: EZH_CAM_PLCK, identifier: EZH_CAM_PLCK}
- {pin_num: A17, pin_signal: PIO0_0/TMS/SWDIO/FC1_P0/CT_INP0, label: EZH_CAM_D0, identifier: EZH_CAM_D0}
- {pin_num: A16, pin_signal: PIO0_1/TCLK/SWCLK/FC1_P1/CT_INP1, label: EZH_CAM_D1, identifier: EZH_CAM_D1}
- {pin_num: B16, pin_signal: PIO0_2/TDO/SWO/FC1_P2/CT0_MAT0/UTICK_CAP0/I3C0_PUR, label: EZH_CAM_D2, identifier: EZH_CAM_D2}
- {pin_num: B15, pin_signal: PIO0_3/TDI/FC1_P3/CT0_MAT1/UTICK_CAP1/HSCMP0_OUT/CMP1_IN1, label: EZH_CAM_D3, identifier: EZH_CAM_D3}
- {pin_num: B14, pin_signal: PIO0_4/WUU0_IN0/EWM0_IN/FC0_P0/FC1_P4/CT0_MAT2/UTICK_CAP2/HSCMP1_OUT/PDM0_CLK/TSI0_CH8, label: EZH_CAM_D4, identifier: EZH_CAM_D4}
- {pin_num: A14, pin_signal: PIO0_5/EWM0_OUT_b/FC0_P1/FC1_P5/CT0_MAT3/UTICK_CAP3/PDM0_DATA0/TSI0_CH9, label: EZH_CAM_D5, identifier: EZH_CAM_D5}
- {pin_num: C13, pin_signal: PIO0_7/WUU0_IN1/FC0_P3/CT_INP3/CMP2_IN1, label: EZH_CAM_D7, identifier: EZH_CAM_D7}
- {pin_num: A4, pin_signal: PIO1_4/WUU0_IN8/FREQME_CLK_IN0/FC3_P4/FC5_P0/CT1_MAT2/SCT0_OUT0/FLEXIO0_D12/ENET0_TX_CLK/SAI0_TXD1/TSI0_CH4/ADC0_A20/CMP0_IN2, label: EZH_CAM_D0,
  identifier: EZH_CAM_D0}
- {pin_num: B3, pin_signal: PIO1_5/FREQME_CLK_IN1/FC3_P5/FC5_P1/CT1_MAT3/SCT0_OUT1/FLEXIO0_D13/ENET0_TXEN/SAI0_RXD1/TSI0_CH5/ADC0_A21/CMP0_IN3, label: EZH_CAM_D1,
  identifier: EZH_CAM_D1}
- {pin_num: B2, pin_signal: PIO1_6/TRIG_IN2/FC3_P6/FC5_P2/CT_INP6/SCT0_IN0/FLEXIO0_D14/ENET0_TXD0/SAI1_RX_BCLK/CAN1_TXD/TSI0_CH6/ADC0_A22, label: EZH_CAM_D2, identifier: EZH_CAM_D2}
- {pin_num: A2, pin_signal: PIO1_7/WUU0_IN9/TRIG_OUT2/FC5_P3/CT_INP7/SCT0_IN1/FLEXIO0_D15/PLU_CLK/ENET0_TXD1/SAI1_RX_FS/CAN1_RXD/TSI0_CH7/ADC0_A23, label: EZH_CAM_D3,
  identifier: EZH_CAM_D3}
- {pin_num: A1, pin_signal: PIO1_8/WUU0_IN10/LPTMR1_ALT3/TRACE_DATA0/FC4_P0/FC5_P4/CT_INP8/SCT0_OUT2/FLEXIO0_D16/PLU_OUT0/ENET0_TXD2/I3C1_SDA/TSI0_CH17/ADC1_A8, label: EZH_CAM_D4,
  identifier: EZH_CAM_D4}
- {pin_num: B1, pin_signal: PIO1_9/TRACE_DATA1/FC4_P1/FC5_P5/CT_INP9/SCT0_OUT3/FLEXIO0_D17/PLU_OUT1/ENET0_TXD3/I3C1_SCL/TSI0_CH18/ADC1_A9, label: EZH_CAM_D5, identifier: EZH_CAM_D5}
- {pin_num: C3, pin_signal: PIO1_10/TRACE_DATA2/FC4_P2/FC5_P6/CT2_MAT0/SCT0_IN2/FLEXIO0_D18/PLU_IN0/ENET0_TXER/CAN0_TXD/TSI0_CH19/ADC1_A10, label: EZH_CAM_D6, identifier: EZH_CAM_D6}
- {pin_num: D3, pin_signal: PIO1_11/WUU0_IN11/TRACE_DATA3/FC4_P3/CT2_MAT1/SCT0_IN3/FLEXIO0_D19/PLU_IN1/ENET0_RX_CLK/I3C1_PUR/CAN0_RXD/TSI0_CH20/ADC1_A11, label: EZH_CAM_D7,
  identifier: EZH_CAM_D7}
- {pin_num: G4, pin_signal: PIO1_18/FREQME_CLK_IN0/FC5_P2/FC3_P6/CT3_MAT0/SCT0_IN6/FLEXIO0_D26/PLU_IN4/ENET0_COL/CAN0_TXD/ADC1_A18, label: EZH_CAM_PDWN, identifier: EZH_CAM_PDWN}
- {pin_num: G5, pin_signal: PIO1_19/WUU0_IN15/FREQME_CLK_IN1/FC5_P3/CT3_MAT1/SCT0_IN7/FLEXIO0_D27/PLU_IN5/ENET0_CRS/CAN0_RXD/ADC1_A19, label: EZH_CAM_RST, identifier: EZH_CAM_RST}
- {pin_num: B10, pin_signal: PIO0_16/WUU0_IN2/FC0_P0/CT0_MAT0/UTICK_CAP2/FLEXIO0_D0/PDM0_CLK/I3C0_SDA/TSI0_CH11/ADC0_A8, label: FC0_I2C_SDA, identifier: FC0_I2C_SDA}
- {pin_num: A10, pin_signal: PIO0_17/FC0_P1/CT0_MAT1/UTICK_CAP3/FLEXIO0_D1/PDM0_DATA0/I3C0_SCL/TSI0_CH12/ADC0_A9, label: FC0_I2C_SCL, identifier: FC0_I2C_SCL}
- {pin_num: C14, pin_signal: PIO0_6/ISPMODE_N/FC0_P2/FC1_P6/CT_INP2/HSCMP2_OUT/PDM0_DATA1/CLKOUT/TSI0_CH10, label: CLKOUT, identifier: CLKOUT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "fsl_gpio.h"
#include "fsl_inputmux.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
		BOARD_InitLCDFXIOPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: C14, peripheral: GPIO0, signal: 'GPIO, 6', pin_signal: PIO0_6/ISPMODE_N/FC0_P2/FC1_P6/CT_INP2/HSCMP2_OUT/PDM0_DATA1/CLKOUT/TSI0_CH10}
  - {pin_num: B12, peripheral: SmartDMA0, signal: 'TRIG, 0', pin_signal: PIO0_10/FC0_P6/CT0_MAT0/FLEXIO0_D2/ADC0_B10}
  - {pin_num: B11, peripheral: SmartDMA0, signal: 'TRIG, 1', pin_signal: PIO0_11/CT0_MAT1/FLEXIO0_D3/HSCMP2_OUT/ADC0_B11}
  - {pin_num: E11, peripheral: SmartDMA0, signal: 'TRIG, 2', pin_signal: PIO0_14/FC1_P6/FC0_P2/CT_INP2/UTICK_CAP0/FLEXIO0_D6/ADC0_B14}
  - {pin_num: A4, peripheral: GPIO1, signal: 'GPIO, 4', pin_signal: PIO1_4/WUU0_IN8/FREQME_CLK_IN0/FC3_P4/FC5_P0/CT1_MAT2/SCT0_OUT0/FLEXIO0_D12/ENET0_TX_CLK/SAI0_TXD1/TSI0_CH4/ADC0_A20/CMP0_IN2,
    slew_rate: fast}
  - {pin_num: B3, peripheral: GPIO1, signal: 'GPIO, 5', pin_signal: PIO1_5/FREQME_CLK_IN1/FC3_P5/FC5_P1/CT1_MAT3/SCT0_OUT1/FLEXIO0_D13/ENET0_TXEN/SAI0_RXD1/TSI0_CH5/ADC0_A21/CMP0_IN3,
    slew_rate: fast}
  - {pin_num: B2, peripheral: GPIO1, signal: 'GPIO, 6', pin_signal: PIO1_6/TRIG_IN2/FC3_P6/FC5_P2/CT_INP6/SCT0_IN0/FLEXIO0_D14/ENET0_TXD0/SAI1_RX_BCLK/CAN1_TXD/TSI0_CH6/ADC0_A22,
    slew_rate: fast}
  - {pin_num: A2, peripheral: GPIO1, signal: 'GPIO, 7', pin_signal: PIO1_7/WUU0_IN9/TRIG_OUT2/FC5_P3/CT_INP7/SCT0_IN1/FLEXIO0_D15/PLU_CLK/ENET0_TXD1/SAI1_RX_FS/CAN1_RXD/TSI0_CH7/ADC0_A23,
    slew_rate: fast}
  - {pin_num: A1, peripheral: GPIO1, signal: 'GPIO, 8', pin_signal: PIO1_8/WUU0_IN10/LPTMR1_ALT3/TRACE_DATA0/FC4_P0/FC5_P4/CT_INP8/SCT0_OUT2/FLEXIO0_D16/PLU_OUT0/ENET0_TXD2/I3C1_SDA/TSI0_CH17/ADC1_A8,
    slew_rate: fast}
  - {pin_num: B1, peripheral: GPIO1, signal: 'GPIO, 9', pin_signal: PIO1_9/TRACE_DATA1/FC4_P1/FC5_P5/CT_INP9/SCT0_OUT3/FLEXIO0_D17/PLU_OUT1/ENET0_TXD3/I3C1_SCL/TSI0_CH18/ADC1_A9,
    slew_rate: fast}
  - {pin_num: C3, peripheral: GPIO1, signal: 'GPIO, 10', pin_signal: PIO1_10/TRACE_DATA2/FC4_P2/FC5_P6/CT2_MAT0/SCT0_IN2/FLEXIO0_D18/PLU_IN0/ENET0_TXER/CAN0_TXD/TSI0_CH19/ADC1_A10,
    slew_rate: fast}
  - {pin_num: D3, peripheral: GPIO1, signal: 'GPIO, 11', pin_signal: PIO1_11/WUU0_IN11/TRACE_DATA3/FC4_P3/CT2_MAT1/SCT0_IN3/FLEXIO0_D19/PLU_IN1/ENET0_RX_CLK/I3C1_PUR/CAN0_RXD/TSI0_CH20/ADC1_A11,
    slew_rate: fast}
  - {pin_num: G4, peripheral: GPIO1, signal: 'GPIO, 18', pin_signal: PIO1_18/FREQME_CLK_IN0/FC5_P2/FC3_P6/CT3_MAT0/SCT0_IN6/FLEXIO0_D26/PLU_IN4/ENET0_COL/CAN0_TXD/ADC1_A18,
    direction: OUTPUT, gpio_init_state: 'false', slew_rate: fast}
  - {pin_num: G5, peripheral: GPIO1, signal: 'GPIO, 19', pin_signal: PIO1_19/WUU0_IN15/FREQME_CLK_IN1/FC5_P3/CT3_MAT1/SCT0_IN7/FLEXIO0_D27/PLU_IN5/ENET0_CRS/CAN0_RXD/ADC1_A19,
    direction: OUTPUT, gpio_init_state: 'true', slew_rate: fast}
  - {pin_num: B10, peripheral: LPFlexcomm0, signal: LPFLEXCOMM_P0, pin_signal: PIO0_16/WUU0_IN2/FC0_P0/CT0_MAT0/UTICK_CAP2/FLEXIO0_D0/PDM0_CLK/I3C0_SDA/TSI0_CH11/ADC0_A8,
    open_drain: enable}
  - {pin_num: A10, peripheral: LPFlexcomm0, signal: LPFLEXCOMM_P1, pin_signal: PIO0_17/FC0_P1/CT0_MAT1/UTICK_CAP3/FLEXIO0_D1/PDM0_DATA0/I3C0_SCL/TSI0_CH12/ADC0_A9,
    open_drain: enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void)
{
    /* Enables the clock for GPIO1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio1);
    /* Enables the clock for INPUTMUX: Enables clock */
    CLOCK_EnableClock(kCLOCK_InputMux0);
    /* Enables the clock for PORT0 controller: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port0);
    /* Enables the clock for PORT1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port1);
    /* Enables the clock for PORT2: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port2);
    /* Enables the clock for PORT3: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port3);
    gpio_pin_config_t gpio1_pinG4_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_18 (pin G4)  */
    GPIO_PinInit(GPIO1, 18U, &gpio1_pinG4_config);

    gpio_pin_config_t gpio1_pinG5_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_19 (pin G5)  */
    GPIO_PinInit(GPIO1, 19U, &gpio1_pinG5_config);
    /* P0_4 is selected for SMARTDMA arch B 0 */
    INPUTMUX_AttachSignal(INPUTMUX0, 0U, kINPUTMUX_GpioPort0Pin4ToSmartDma);
    /* P0_11 is selected for SMARTDMA arch B 1 */
    INPUTMUX_AttachSignal(INPUTMUX0, 1U, kINPUTMUX_GpioPort0Pin11ToSmartDma);
    /* P0_5 is selected for SMARTDMA arch B 2 */
    INPUTMUX_AttachSignal(INPUTMUX0, 2U, kINPUTMUX_GpioPort0Pin5ToSmartDma);

    /* PORT0_11 (pin B11) is configured as PIO0_11 */
    PORT_SetPinMux(PORT0, 11U, kPORT_MuxAlt0);

    PORT0->PCR[11] = ((PORT0->PCR[11] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_4 (pin B14) is configured as PIO0_4 */
    PORT_SetPinMux(PORT0, 4U, kPORT_MuxAlt0);

    PORT0->PCR[4] = ((PORT0->PCR[4] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_5 (pin A14) is configured as PIO0_5 */
    PORT_SetPinMux(PORT0, 5U, kPORT_MuxAlt0);

    PORT0->PCR[5] = ((PORT0->PCR[5] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_16 (pin B10) is configured as FC0_P0 */
    PORT_SetPinMux(PORT0, 16U, kPORT_MuxAlt2);

    PORT0->PCR[16] = ((PORT0->PCR[16] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_ODE_MASK | PORT_PCR_IBE_MASK)))

                      /* Open Drain Enable: Enables. */
                      | PORT_PCR_ODE(PCR_ODE_ode1)

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_17 (pin A10) is configured as FC0_P1 */
    PORT_SetPinMux(PORT0, 17U, kPORT_MuxAlt2);

    PORT0->PCR[17] = ((PORT0->PCR[17] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_ODE_MASK | PORT_PCR_IBE_MASK)))

                      /* Open Drain Enable: Enables. */
                      | PORT_PCR_ODE(PCR_ODE_ode1)

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_6 (pin C14) is configured as clkout */
    PORT_SetPinMux(PORT0, 6U, kPORT_MuxAlt12);

    PORT0->PCR[6] = ((PORT0->PCR[6] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));
    /* PORT2_2 (pin H3) is configured as CLKOUT */
     PORT_SetPinMux(PORT2, 2U, kPORT_MuxAlt1);

     PORT2->PCR[2] = ((PORT2->PCR[2] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));
    /* PORT1_10 (pin C3) is configured as PIO1_10 */
    PORT_SetPinMux(PORT1, 10U, kPORT_MuxAlt7);

    PORT1->PCR[10] = ((PORT1->PCR[10] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                      /* Slew Rate Enable: Fast. */
                      | PORT_PCR_SRE(PCR_SRE_sre0)

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_11 (pin D3) is configured as PIO1_11 */
    PORT_SetPinMux(PORT1, 11U, kPORT_MuxAlt7);

    PORT1->PCR[11] = ((PORT1->PCR[11] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                      /* Slew Rate Enable: Fast. */
                      | PORT_PCR_SRE(PCR_SRE_sre0)

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));


    /* PORT1_4 (pin A4) is configured as PIO1_4 */
    PORT_SetPinMux(PORT1, 4U, kPORT_MuxAlt7);

    PORT1->PCR[4] = ((PORT1->PCR[4] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Slew Rate Enable: Fast. */
                     | PORT_PCR_SRE(PCR_SRE_sre0)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_5 (pin B3) is configured as PIO1_5 */
    PORT_SetPinMux(PORT1, 5U, kPORT_MuxAlt7);

    PORT1->PCR[5] = ((PORT1->PCR[5] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Slew Rate Enable: Fast. */
                     | PORT_PCR_SRE(PCR_SRE_sre0)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_6 (pin B2) is configured as PIO1_6 */
    PORT_SetPinMux(PORT1, 6U, kPORT_MuxAlt7);

    PORT1->PCR[6] = ((PORT1->PCR[6] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Slew Rate Enable: Fast. */
                     | PORT_PCR_SRE(PCR_SRE_sre0)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_7 (pin A2) is configured as PIO1_7 */
    PORT_SetPinMux(PORT1, 7U, kPORT_MuxAlt7);

    PORT1->PCR[7] = ((PORT1->PCR[7] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Slew Rate Enable: Fast. */
                     | PORT_PCR_SRE(PCR_SRE_sre0)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_8 (pin A1) is configured as PIO1_8 */
    PORT_SetPinMux(PORT1, 8U, kPORT_MuxAlt2);

    PORT1->PCR[8] = ((PORT1->PCR[8] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Slew Rate Enable: Fast. */
                     | PORT_PCR_SRE(PCR_SRE_sre0)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_9 (pin B1) is configured as PIO1_9 */
    PORT_SetPinMux(PORT1, 9U, kPORT_MuxAlt2);

    PORT1->PCR[9] = ((PORT1->PCR[9] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Slew Rate Enable: Fast. */
                     | PORT_PCR_SRE(PCR_SRE_sre0)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));
    /* PORT3_4 (pin F14) is configured as PIO3_4 */
    PORT_SetPinMux(PORT3, 4U, kPORT_MuxAlt7);

    PORT3->PCR[4] = ((PORT3->PCR[4] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT3_5 (pin G14) is configured as PIO3_5 */
    PORT_SetPinMux(PORT3, 5U, kPORT_MuxAlt7);

    PORT3->PCR[5] = ((PORT3->PCR[5] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));
    /* PORT0_6 (pin B1) is configured as CLKOUT*/
    PORT_SetPinMux(PORT0, 6U, kPORT_MuxAlt12);										 
    PORT0->PCR[6] = ((PORT0->PCR[6] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Slew Rate Enable: Fast. */
                     | PORT_PCR_SRE(PCR_SRE_sre0)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));
										 
										 
										     /* PORT1_4 (pin A4) is configured as PIO1_4 */
    PORT_SetPinMux(PORT1, 22U, kPORT_MuxAlt7);

    PORT1->PCR[22] = ((PORT1->PCR[22] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Slew Rate Enable: Fast. */
                     | PORT_PCR_SRE(PCR_SRE_sre0)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));
    /* PORT3_2 (pin D15) is configured as FC7_P0 */
      PORT_SetPinMux(PORT3, 2U, kPORT_MuxAlt2);

      PORT3->PCR[2] = ((PORT3->PCR[2] &
                        /* Mask bits to zero which are setting */
                        (~(PORT_PCR_PS_MASK | PORT_PCR_PE_MASK | PORT_PCR_IBE_MASK)))

                       /* Pull Select: Enables internal pullup resistor. */
                       | PORT_PCR_PS(PCR_PS_ps1)

                       /* Pull Enable: Enables. */
                       | PORT_PCR_PE(PCR_PE_pe1)

                       /* Input Buffer Enable: Enables. */
                       | PORT_PCR_IBE(PCR_IBE_ibe1));

      /* PORT3_3 (pin D16) is configured as FC7_P1 */
      PORT_SetPinMux(PORT3, 3U, kPORT_MuxAlt2);

      PORT3->PCR[3] = ((PORT3->PCR[3] &
                        /* Mask bits to zero which are setting */
                        (~(PORT_PCR_PS_MASK | PORT_PCR_PE_MASK | PORT_PCR_IBE_MASK)))

                       /* Pull Select: Enables internal pullup resistor. */
                       | PORT_PCR_PS(PCR_PS_ps1)

                       /* Pull Enable: Enables. */
                       | PORT_PCR_PE(PCR_PE_pe1)

                       /* Input Buffer Enable: Enables. */
                       | PORT_PCR_IBE(PCR_IBE_ibe1));

      /* PORT3_18 (pin K16) is configured as PIO3_18 */
        PORT_SetPinMux(PORT3, 18U, kPORT_MuxAlt7);

        PORT3->PCR[18] = ((PORT3->PCR[18] &
                           /* Mask bits to zero which are setting */
                           (~(PORT_PCR_IBE_MASK)))

                          /* Input Buffer Enable: Enables. */
                          | PORT_PCR_IBE(PCR_IBE_ibe1));
}

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitLCDFXIOPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitLCDFXIOPins(void)
{
    /* Enables the clock for GPIO0: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio0);
    /* Enables the clock for GPIO1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio1);
    /* Enables the clock for GPIO4: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio4);
    /* Enables the clock for PORT0 controller: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port0);
    /* Enables the clock for PORT1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port1);
    /* Enables the clock for PORT2: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port2);
    /* Enables the clock for PORT4: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port4);

    gpio_pin_config_t gpio0_pinC13_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO0_7 (pin C13)  */
    GPIO_PinInit(GPIO0, 7U, &gpio0_pinC13_config);

    gpio_pin_config_t gpio0_pinD11_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO0_12 (pin D11)  */
    GPIO_PinInit(GPIO0, 12U, &gpio0_pinD11_config);

    gpio_pin_config_t gpio1_pinD3_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_11 (pin D3)  */
    GPIO_PinInit(GPIO1, 11U, &gpio1_pinD3_config);

    gpio_pin_config_t gpio4_pinT4_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO4_7 (pin T4)  */
    GPIO_PinInit(GPIO4, 7U, &gpio4_pinT4_config);

    /* PORT0_12 (pin D11) is configured as PIO0_12 */
    PORT_SetPinMux(PORT0, 12U, kPORT_MuxAlt0);

    PORT0->PCR[12] = ((PORT0->PCR[12] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_7 (pin C13) is configured as PIO0_7 */
    PORT_SetPinMux(PORT0, 7U, kPORT_MuxAlt0);

    PORT0->PCR[7] = ((PORT0->PCR[7] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_8 (pin C12) is configured as FLEXIO0_D0 */
    PORT_SetPinMux(PORT0, 8U, kPORT_MuxAlt6);

    PORT0->PCR[8] = ((PORT0->PCR[8] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_PS_MASK | PORT_PCR_PE_MASK | PORT_PCR_IBE_MASK)))

                     /* Pull Select: Enables internal pullup resistor. */
                     | PORT_PCR_PS(PCR_PS_ps1)

                     /* Pull Enable: Enables. */
                     | PORT_PCR_PE(PCR_PE_pe1)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_9 (pin A12) is configured as FLEXIO0_D1 */
    PORT_SetPinMux(PORT0, 9U, kPORT_MuxAlt6);

    PORT0->PCR[9] = ((PORT0->PCR[9] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_PS_MASK | PORT_PCR_PE_MASK | PORT_PCR_SRE_MASK | PORT_PCR_IBE_MASK)))

                     /* Pull Select: Enables internal pullup resistor. */
                     | PORT_PCR_PS(PCR_PS_ps1)

                     /* Pull Enable: Enables. */
                     | PORT_PCR_PE(PCR_PE_pe1)

                     /* Slew Rate Enable: Slow. */
                     | PORT_PCR_SRE(PCR_SRE_sre1)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

//    /* PORT1_11 (pin D3) is configured as PIO1_11 */
//    PORT_SetPinMux(PORT1, 11U, kPORT_MuxAlt0);

//    PORT1->PCR[11] = ((PORT1->PCR[11] &
//                       /* Mask bits to zero which are setting */
//                       (~(PORT_PCR_IBE_MASK)))

//                      /* Input Buffer Enable: Enables. */
//                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT2_10 (pin M3) is configured as FLEXIO0_D18 */
    PORT_SetPinMux(PORT2, 10U, kPORT_MuxAlt6);

    PORT2->PCR[10] = ((PORT2->PCR[10] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT2_11 (pin N4) is configured as FLEXIO0_D19 */
    PORT_SetPinMux(PORT2, 11U, kPORT_MuxAlt6);

    PORT2->PCR[11] = ((PORT2->PCR[11] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT2_8 (pin M2) is configured as FLEXIO0_D16 */
    PORT_SetPinMux(PORT2, 8U, kPORT_MuxAlt6);

    PORT2->PCR[8] = ((PORT2->PCR[8] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT2_9 (pin M1) is configured as FLEXIO0_D17 */
    PORT_SetPinMux(PORT2, 9U, kPORT_MuxAlt6);

    PORT2->PCR[9] = ((PORT2->PCR[9] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_12 (pin T6) is configured as FLEXIO0_D20 */
    PORT_SetPinMux(PORT4, 12U, kPORT_MuxAlt6);

    PORT4->PCR[12] = ((PORT4->PCR[12] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_13 (pin T7) is configured as FLEXIO0_D21 */
    PORT_SetPinMux(PORT4, 13U, kPORT_MuxAlt6);

    PORT4->PCR[13] = ((PORT4->PCR[13] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_14 (pin N8) is configured as FLEXIO0_D22 */
    PORT_SetPinMux(PORT4, 14U, kPORT_MuxAlt6);

    PORT4->PCR[14] = ((PORT4->PCR[14] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_15 (pin T8) is configured as FLEXIO0_D23 */
    PORT_SetPinMux(PORT4, 15U, kPORT_MuxAlt6);

    PORT4->PCR[15] = ((PORT4->PCR[15] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_16 (pin R8) is configured as FLEXIO0_D24 */
    PORT_SetPinMux(PORT4, 16U, kPORT_MuxAlt6);

    PORT4->PCR[16] = ((PORT4->PCR[16] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_17 (pin R9) is configured as FLEXIO0_D25 */
    PORT_SetPinMux(PORT4, 17U, kPORT_MuxAlt6);

    PORT4->PCR[17] = ((PORT4->PCR[17] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_18 (pin N10) is configured as FLEXIO0_D26 */
    PORT_SetPinMux(PORT4, 18U, kPORT_MuxAlt6);

    PORT4->PCR[18] = ((PORT4->PCR[18] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_19 (pin R10) is configured as FLEXIO0_D27 */
    PORT_SetPinMux(PORT4, 19U, kPORT_MuxAlt6);

    PORT4->PCR[19] = ((PORT4->PCR[19] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_20 (pin T10) is configured as FLEXIO0_D28 */
    PORT_SetPinMux(PORT4, 20U, kPORT_MuxAlt6);

    PORT4->PCR[20] = ((PORT4->PCR[20] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_21 (pin T11) is configured as FLEXIO0_D29 */
    PORT_SetPinMux(PORT4, 21U, kPORT_MuxAlt6);

    PORT4->PCR[21] = ((PORT4->PCR[21] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_22 (pin T12) is configured as FLEXIO0_D30 */
    PORT_SetPinMux(PORT4, 22U, kPORT_MuxAlt6);

    PORT4->PCR[22] = ((PORT4->PCR[22] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_23 (pin U12) is configured as FLEXIO0_D31 */
    PORT_SetPinMux(PORT4, 23U, kPORT_MuxAlt6);

    PORT4->PCR[23] = ((PORT4->PCR[23] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_7 (pin T4) is configured as PIO4_7 */
    PORT_SetPinMux(PORT4, 7U, kPORT_MuxAlt0);

    PORT4->PCR[7] = ((PORT4->PCR[7] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
