/*
 * Copyright 2022-2023 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 /***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v14.0
processor: MCXN947
package_id: MCXN947VDF
mcu_data: ksdk2_0
processor_version: 0.14.17
board: FRDM-MCXN947
pin_labels:
- {pin_num: L4, pin_signal: PIO1_22/TRIG_IN3/FC5_P6/FC4_P2/CT_INP14/SCT0_OUT4/FLEXIO0_D30/ADC1_A22, label: 'P1_22/J11[24]/J3[3]/SJ9[3]', identifier: EZH_DEBUGIO}
- {pin_num: C8, pin_signal: PIO0_20/WUU0_IN4/FC0_P4/FC1_P0/CT_INP0/FLEXIO0_D4/I3C0_SDA/TSI0_CH15/ADC0_A12, label: 'P0_20/R186[3]/J16[2]', identifier: ROW4}
- {pin_num: C9, pin_signal: PIO0_19/WUU0_IN3/EWM0_OUT_b/FC0_P3/CT0_MAT3/FLEXIO0_D3/HSCMP1_OUT/TSI0_CH14/ADC0_A11, label: 'P0_19/J2[13]/J16[1]', identifier: COL4}
- {pin_num: A10, pin_signal: PIO0_17/FC0_P1/CT0_MAT1/UTICK_CAP3/FLEXIO0_D1/PDM0_DATA0/I3C0_SCL/TSI0_CH12/ADC0_A9, label: 'P0_17/J16[7]', identifier: COL1}
- {pin_num: B10, pin_signal: PIO0_16/WUU0_IN2/FC0_P0/CT0_MAT0/UTICK_CAP2/FLEXIO0_D0/PDM0_CLK/I3C0_SDA/TSI0_CH11/ADC0_A8, label: 'P0_16/J16[3]', identifier: COL3}
- {pin_num: C10, pin_signal: PIO0_18/EWM0_IN/FC0_P2/CT0_MAT2/FLEXIO0_D2/HSCMP0_OUT/PDM0_DATA1/TSI0_CH13/ADC0_A10, label: 'P0_18/J2[11]/J16[5]', identifier: COL2}
- {pin_num: K13, pin_signal: PIO5_6/TRIG_OUT6/LPTMR1_ALT2/TAMPER4/ADC1_B14, label: 'P5_6/SJ13[1]', identifier: ROW3}
- {pin_num: D15, pin_signal: PIO3_2/FC7_P0/CT4_MAT0/PWM0_X0/FLEXIO0_D10/SIM1_PD, label: 'P3_2/J11[20]/J16[8]', identifier: ROW1}
- {pin_num: D16, pin_signal: PIO3_3/FC7_P1/CT4_MAT1/PWM0_X1/FLEXIO0_D11/SIM1_RST, label: 'P3_3/J11[19]/SJ12[1]', identifier: ROW2}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "fsl_gpio.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: A1, peripheral: LP_FLEXCOMM4, signal: LPFLEXCOMM_P0, pin_signal: PIO1_8/WUU0_IN10/LPTMR1_ALT3/TRACE_DATA0/FC4_P0/FC5_P4/CT_INP8/SCT0_OUT2/FLEXIO0_D16/PLU_OUT0/ENET0_TXD2/I3C1_SDA/TSI0_CH17/ADC1_A8,
    slew_rate: fast, open_drain: disable, drive_strength: low, pull_select: down, pull_enable: disable, passive_filter: disable, pull_value: low, input_buffer: enable,
    invert_input: normal}
  - {pin_num: B1, peripheral: LP_FLEXCOMM4, signal: LPFLEXCOMM_P1, pin_signal: PIO1_9/TRACE_DATA1/FC4_P1/FC5_P5/CT_INP9/SCT0_OUT3/FLEXIO0_D17/PLU_OUT1/ENET0_TXD3/I3C1_SCL/TSI0_CH18/ADC1_A9,
    slew_rate: fast, open_drain: disable, drive_strength: low, pull_select: down, pull_enable: disable, passive_filter: disable, input_buffer: enable, invert_input: normal}
  - {pin_num: C14, peripheral: GPIO0, signal: 'GPIO, 6', pin_signal: PIO0_6/ISPMODE_N/FC0_P2/FC1_P6/CT_INP2/HSCMP2_OUT/PDM0_DATA1/CLKOUT/TSI0_CH10, slew_rate: fast,
    open_drain: disable, drive_strength: low, pull_select: up, pull_enable: enable, input_buffer: enable, invert_input: normal}
  - {pin_num: B12, peripheral: GPIO0, signal: 'GPIO, 10', pin_signal: PIO0_10/FC0_P6/CT0_MAT0/FLEXIO0_D2/ADC0_B10, slew_rate: fast, open_drain: disable, drive_strength: low,
    pull_select: down, pull_enable: disable, input_buffer: enable, invert_input: normal}
  - {pin_num: A10, peripheral: GPIO0, signal: 'GPIO, 17', pin_signal: PIO0_17/FC0_P1/CT0_MAT1/UTICK_CAP3/FLEXIO0_D1/PDM0_DATA0/I3C0_SCL/TSI0_CH12/ADC0_A9, direction: OUTPUT,
    gpio_init_state: 'true'}
  - {pin_num: C10, peripheral: GPIO0, signal: 'GPIO, 18', pin_signal: PIO0_18/EWM0_IN/FC0_P2/CT0_MAT2/FLEXIO0_D2/HSCMP0_OUT/PDM0_DATA1/TSI0_CH13/ADC0_A10, direction: OUTPUT,
    gpio_init_state: 'true'}
  - {pin_num: B10, peripheral: GPIO0, signal: 'GPIO, 16', pin_signal: PIO0_16/WUU0_IN2/FC0_P0/CT0_MAT0/UTICK_CAP2/FLEXIO0_D0/PDM0_CLK/I3C0_SDA/TSI0_CH11/ADC0_A8,
    direction: OUTPUT, gpio_init_state: 'true'}
  - {pin_num: C9, peripheral: GPIO0, signal: 'GPIO, 19', pin_signal: PIO0_19/WUU0_IN3/EWM0_OUT_b/FC0_P3/CT0_MAT3/FLEXIO0_D3/HSCMP1_OUT/TSI0_CH14/ADC0_A11, direction: OUTPUT,
    gpio_init_state: 'true'}
  - {pin_num: D15, peripheral: GPIO3, signal: 'GPIO, 2', pin_signal: PIO3_2/FC7_P0/CT4_MAT0/PWM0_X0/FLEXIO0_D10/SIM1_PD, direction: INPUT, gpio_per_interrupt_sel: no_init}
  - {pin_num: D16, peripheral: GPIO3, signal: 'GPIO, 3', pin_signal: PIO3_3/FC7_P1/CT4_MAT1/PWM0_X1/FLEXIO0_D11/SIM1_RST, direction: INPUT, gpio_per_interrupt_sel: no_init}
  - {pin_num: K13, peripheral: GPIO5, signal: 'GPIO, 6', pin_signal: PIO5_6/TRIG_OUT6/LPTMR1_ALT2/TAMPER4/ADC1_B14, direction: INPUT, gpio_per_interrupt_sel: no_init}
  - {pin_num: C8, peripheral: GPIO0, signal: 'GPIO, 20', pin_signal: PIO0_20/WUU0_IN4/FC0_P4/FC1_P0/CT_INP0/FLEXIO0_D4/I3C0_SDA/TSI0_CH15/ADC0_A12, direction: INPUT,
    gpio_per_interrupt_sel: no_init}
  - {pin_num: L4, peripheral: GPIO1, signal: 'GPIO, 22', pin_signal: PIO1_22/TRIG_IN3/FC5_P6/FC4_P2/CT_INP14/SCT0_OUT4/FLEXIO0_D30/ADC1_A22, direction: INPUT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void)
{
    /* Enables the clock for GPIO0: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio0);
    /* Enables the clock for GPIO1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio1);
    /* Enables the clock for GPIO3: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio3);
    /* Enables the clock for PORT0 controller: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port0);
    /* Enables the clock for PORT1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port1);
    /* Enables the clock for PORT3: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port3);

    gpio_pin_config_t COL3_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO0_16 (pin B10)  */
    GPIO_PinInit(BOARD_INITPINS_COL3_GPIO, BOARD_INITPINS_COL3_PIN, &COL3_config);

    gpio_pin_config_t COL1_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO0_17 (pin A10)  */
    GPIO_PinInit(BOARD_INITPINS_COL1_GPIO, BOARD_INITPINS_COL1_PIN, &COL1_config);

    gpio_pin_config_t COL2_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO0_18 (pin C10)  */
    GPIO_PinInit(BOARD_INITPINS_COL2_GPIO, BOARD_INITPINS_COL2_PIN, &COL2_config);

    gpio_pin_config_t COL4_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO0_19 (pin C9)  */
    GPIO_PinInit(BOARD_INITPINS_COL4_GPIO, BOARD_INITPINS_COL4_PIN, &COL4_config);

    gpio_pin_config_t ROW4_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_20 (pin C8)  */
    GPIO_PinInit(BOARD_INITPINS_ROW4_GPIO, BOARD_INITPINS_ROW4_PIN, &ROW4_config);

    gpio_pin_config_t EZH_DEBUGIO_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_22 (pin L4)  */
    GPIO_PinInit(BOARD_INITPINS_EZH_DEBUGIO_GPIO, BOARD_INITPINS_EZH_DEBUGIO_PIN, &EZH_DEBUGIO_config);

    gpio_pin_config_t ROW1_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO3_2 (pin D15)  */
    GPIO_PinInit(BOARD_INITPINS_ROW1_GPIO, BOARD_INITPINS_ROW1_PIN, &ROW1_config);

    gpio_pin_config_t ROW2_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO3_3 (pin D16)  */
    GPIO_PinInit(BOARD_INITPINS_ROW2_GPIO, BOARD_INITPINS_ROW2_PIN, &ROW2_config);

    gpio_pin_config_t ROW3_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO5_6 (pin K13)  */
    GPIO_PinInit(BOARD_INITPINS_ROW3_GPIO, BOARD_INITPINS_ROW3_PIN, &ROW3_config);

    const port_pin_config_t LED_RED = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Low internal pull resistor value is selected. */
                                       kPORT_LowPullResistor,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Passive input filter is disabled */
                                       kPORT_PassiveFilterDisable,
                                       /* Open drain output is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Low drive strength is configured */
                                       kPORT_LowDriveStrength,
                                       /* Pin is configured as PIO0_10 */
                                       kPORT_MuxAlt0,
                                       /* Digital input enabled */
                                       kPORT_InputBufferEnable,
                                       /* Digital input is not inverted */
                                       kPORT_InputNormal,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORT0_10 (pin B12) is configured as PIO0_10 */
    PORT_SetPinConfig(BOARD_INITPINS_LED_RED_PORT, BOARD_INITPINS_LED_RED_PIN, &LED_RED);

    /* PORT0_16 (pin B10) is configured as PIO0_16 */
    PORT_SetPinMux(BOARD_INITPINS_COL3_PORT, BOARD_INITPINS_COL3_PIN, kPORT_MuxAlt0);

    PORT0->PCR[16] = ((PORT0->PCR[16] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_17 (pin A10) is configured as PIO0_17 */
    PORT_SetPinMux(BOARD_INITPINS_COL1_PORT, BOARD_INITPINS_COL1_PIN, kPORT_MuxAlt0);

    PORT0->PCR[17] = ((PORT0->PCR[17] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_18 (pin C10) is configured as PIO0_18 */
    PORT_SetPinMux(BOARD_INITPINS_COL2_PORT, BOARD_INITPINS_COL2_PIN, kPORT_MuxAlt0);

    PORT0->PCR[18] = ((PORT0->PCR[18] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_19 (pin C9) is configured as PIO0_19 */
    PORT_SetPinMux(BOARD_INITPINS_COL4_PORT, BOARD_INITPINS_COL4_PIN, kPORT_MuxAlt0);

    PORT0->PCR[19] = ((PORT0->PCR[19] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_20 (pin C8) is configured as PIO0_20 */
    PORT_SetPinMux(BOARD_INITPINS_ROW4_PORT, BOARD_INITPINS_ROW4_PIN, kPORT_MuxAlt0);

    PORT0->PCR[20] = ((PORT0->PCR[20] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    const port_pin_config_t SW1 = {/* Internal pull-up resistor is enabled */
                                   kPORT_PullUp,
                                   /* Low internal pull resistor value is selected. */
                                   kPORT_LowPullResistor,
                                   /* Fast slew rate is configured */
                                   kPORT_FastSlewRate,
                                   /* Passive input filter is disabled */
                                   kPORT_PassiveFilterDisable,
                                   /* Open drain output is disabled */
                                   kPORT_OpenDrainDisable,
                                   /* Low drive strength is configured */
                                   kPORT_LowDriveStrength,
                                   /* Pin is configured as PIO0_6 */
                                   kPORT_MuxAlt0,
                                   /* Digital input enabled */
                                   kPORT_InputBufferEnable,
                                   /* Digital input is not inverted */
                                   kPORT_InputNormal,
                                   /* Pin Control Register fields [15:0] are not locked */
                                   kPORT_UnlockRegister};
    /* PORT0_6 (pin C14) is configured as PIO0_6 */
    PORT_SetPinConfig(BOARD_INITPINS_SW1_PORT, BOARD_INITPINS_SW1_PIN, &SW1);

    /* PORT1_22 (pin L4) is configured as PIO1_22 */
    PORT_SetPinMux(BOARD_INITPINS_EZH_DEBUGIO_PORT, BOARD_INITPINS_EZH_DEBUGIO_PIN, kPORT_MuxAlt0);

    PORT1->PCR[22] = ((PORT1->PCR[22] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    const port_pin_config_t DEBUG_UART_RX = {/* Internal pull-up/down resistor is disabled */
                                             kPORT_PullDisable,
                                             /* Low internal pull resistor value is selected. */
                                             kPORT_LowPullResistor,
                                             /* Fast slew rate is configured */
                                             kPORT_FastSlewRate,
                                             /* Passive input filter is disabled */
                                             kPORT_PassiveFilterDisable,
                                             /* Open drain output is disabled */
                                             kPORT_OpenDrainDisable,
                                             /* Low drive strength is configured */
                                             kPORT_LowDriveStrength,
                                             /* Pin is configured as FC4_P0 */
                                             kPORT_MuxAlt2,
                                             /* Digital input enabled */
                                             kPORT_InputBufferEnable,
                                             /* Digital input is not inverted */
                                             kPORT_InputNormal,
                                             /* Pin Control Register fields [15:0] are not locked */
                                             kPORT_UnlockRegister};
    /* PORT1_8 (pin A1) is configured as FC4_P0 */
    PORT_SetPinConfig(BOARD_INITPINS_DEBUG_UART_RX_PORT, BOARD_INITPINS_DEBUG_UART_RX_PIN, &DEBUG_UART_RX);

    const port_pin_config_t DEBUG_UART_TX = {/* Internal pull-up/down resistor is disabled */
                                             kPORT_PullDisable,
                                             /* Low internal pull resistor value is selected. */
                                             kPORT_LowPullResistor,
                                             /* Fast slew rate is configured */
                                             kPORT_FastSlewRate,
                                             /* Passive input filter is disabled */
                                             kPORT_PassiveFilterDisable,
                                             /* Open drain output is disabled */
                                             kPORT_OpenDrainDisable,
                                             /* Low drive strength is configured */
                                             kPORT_LowDriveStrength,
                                             /* Pin is configured as FC4_P1 */
                                             kPORT_MuxAlt2,
                                             /* Digital input enabled */
                                             kPORT_InputBufferEnable,
                                             /* Digital input is not inverted */
                                             kPORT_InputNormal,
                                             /* Pin Control Register fields [15:0] are not locked */
                                             kPORT_UnlockRegister};
    /* PORT1_9 (pin B1) is configured as FC4_P1 */
    PORT_SetPinConfig(BOARD_INITPINS_DEBUG_UART_TX_PORT, BOARD_INITPINS_DEBUG_UART_TX_PIN, &DEBUG_UART_TX);

    /* PORT3_2 (pin D15) is configured as PIO3_2 */
    PORT_SetPinMux(BOARD_INITPINS_ROW1_PORT, BOARD_INITPINS_ROW1_PIN, kPORT_MuxAlt0);

    PORT3->PCR[2] = ((PORT3->PCR[2] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT3_3 (pin D16) is configured as PIO3_3 */
    PORT_SetPinMux(BOARD_INITPINS_ROW2_PORT, BOARD_INITPINS_ROW2_PIN, kPORT_MuxAlt0);

    PORT3->PCR[3] = ((PORT3->PCR[3] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    PORT5->PCR[6] = ((PORT5->PCR[6] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_MUX_MASK | PORT_PCR_IBE_MASK)))

                     /* Pin Multiplex Control: PORT5_6 (pin K13) is configured as PIO5_6. */
                     | PORT_PCR_MUX(PORT5_PCR_MUX_mux00)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
