/*
	* Copyright 2021 NXP
	*
	* SPDX-License-Identifier: BSD-3-Clause
*/

/*
    * FILE NAME: ../boards/lpcxpresso55s36/mc_pmsm/pmsm_enc_dual/m1_pmsm_appconfig.h
    * DATE: Fri Dec 10 2021, 13:32:00
*/

#ifndef __M1_PMSM_APPCONFIG_H
#define __M1_PMSM_APPCONFIG_H

/********************************************************************************
 * Motor Connector 1 config
 ********************************************************************************/
#define M1_MOTOR_LINIX				(0)		// Set to 1 to use Linix
#define M1_MOTOR_TEKNIC				(1)		// Set to 1 to use Teknic

#define M1_USE_INTERNAL_OPAMPS		(1)		// Set to 1 to use LPC5536 internal opamps to process the current shunt signals.
											// Please note that the FRDM-MC-PMSM board has to be modified according to the
											// attached document.

#if ( (0 != M1_MOTOR_TEKNIC) == (0 != M1_MOTOR_LINIX) )
#error Incorrect configuration, select either Linix or Teknic motor.
#endif

#if M1_MOTOR_TEKNIC

/* PARAMETERS*/
#define M1_MOTOR_PP (4)
#define M1_I_PH_NOM (2.0F)
#define M1_N_NOM (1675.52F)

#if M1_USE_INTERNAL_OPAMPS
	#define M1_I_MAX (11.25F)
#else
	#define M1_I_MAX (8.25F)
#endif	/* #if M1_USE_INTERNAL_OPAMPS */

#define M1_U_DCB_MAX (60.8F)
#define M1_U_DCB_TRIP (28.0F)
#define M1_U_DCB_UNDERVOLTAGE (16.0F)
#define M1_U_DCB_OVERVOLTAGE (30.0F)
#define M1_N_OVERSPEED (1842.65F)
#define M1_N_MIN (125.664F)
#define M1_E_BLOCK_TRH (0.7F)
#define M1_E_BLOCK_PER (2000)
#define M1_N_MAX (1843.07F)
#define M1_CALIB_DURATION (200)
#define M1_FAULT_DURATION (6000)
#define M1_FREEWHEEL_DURATION (1500)
#define M1_SCALAR_UQ_MIN (1.0F)
#define M1_ALIGN_VOLTAGE (1.2F)
#define M1_ALIGN_DURATION (1000)
#define M1_U_MAX (35.1029F)
#define M1_FREQ_MAX (293.333F)
#define M1_N_ANGULAR_MAX (2.38732F)
#define M1_UDCB_IIR_B0 (0.0304590F)
#define M1_UDCB_IIR_B1 (0.0304590F)
#define M1_UDCB_IIR_A1 (0.939082F)
#define M1_SCALAR_VHZ_FACTOR_GAIN (0.0562500F)
#define M1_SCALAR_INTEG_GAIN ACC32(0.0586667)
#define M1_SCALAR_RAMP_UP (0.0666667F)
#define M1_SCALAR_RAMP_DOWN (0.0666667F)
/* CURRENTLOOP*/
#define M1_D_KP_GAIN (0.459831F)
#define M1_D_KI_GAIN (0.106749F)
#define M1_Q_KP_GAIN (0.344020F)
#define M1_Q_KI_GAIN (0.0962702F)
#define M1_CLOOP_LIMIT (0.519615F)
/* SPEEDLOOP*/
#define M1_SPEED_RAMP_UP (4.18879F)
#define M1_SPEED_RAMP_DOWN (4.18879F)
#define M1_SPEED_LOOP_HIGH_LIMIT (2.0F)
#define M1_SPEED_LOOP_LOW_LIMIT (-2.0F)
#define M1_SPEED_PI_PROP_GAIN (0.00920221F)
#define M1_SPEED_PI_INTEG_GAIN (0.0000809469F)
#define M1_POS_P_PROP_GAIN FRAC16(0.12)
#define M1_SPEED_IIR_B0 (0.0304590F)
#define M1_SPEED_IIR_B1 (0.0304590F)
#define M1_SPEED_IIR_A1 (0.939082F)
/* SENSORS*/
#define M1_POSPE_ENC_PULSES (1000)
#define M1_POSPE_ENC_DIRECTION (0)
#define M1_POSPE_ENC_N_MIN (0.0F)
#define M1_POSPE_MECH_POS_GAIN ACC32(16.384)
#define M1_POSPE_KP_GAIN (1256.64F)
#define M1_POSPE_KI_GAIN (39.4784F)
#define M1_POSPE_INTEG_GAIN (0.0000318310F)
/* SENSORLESS*/
#define M1_OL_START_RAMP_INC (0.125664F)
#define M1_OL_START_I (0.65F)
#define M1_MERG_SPEED_TRH (209.440F)
#define M1_MERG_COEFF FRAC16(0.00457764)
#define M1_I_SCALE (0.819095F)
#define M1_U_SCALE (0.251256F)
#define M1_E_SCALE (0.251256F)
#define M1_WI_SCALE (0.0000738693F)
#define M1_BEMF_DQ_KP_GAIN (0.508991F)
#define M1_BEMF_DQ_KI_GAIN (0.115830F)
#define M1_TO_KP_GAIN (879.646F)
#define M1_TO_KI_GAIN (19.3444F)
#define M1_TO_THETA_GAIN (0.0000318310F)
#define M1_TO_SPEED_IIR_B0 (0.111635F)
#define M1_TO_SPEED_IIR_B1 (0.111635F)
#define M1_TO_SPEED_IIR_A1 (0.776730F)

#else

/* PARAMETERS*/
#define M1_MOTOR_PP (2)
#define M1_I_PH_NOM (2.0F)
#define M1_N_NOM (837.758F)

#if M1_USE_INTERNAL_OPAMPS
	#define M1_I_MAX (11.25F)
#else
	#define M1_I_MAX (8.25F)
#endif	/* #if M1_USE_INTERNAL_OPAMPS */

#define M1_U_DCB_MAX (60.8F)
#define M1_U_DCB_TRIP (29.0F)
#define M1_U_DCB_UNDERVOLTAGE (16.0F)
#define M1_U_DCB_OVERVOLTAGE (32.0F)
#define M1_N_OVERSPEED (921.324F)
#define M1_N_MIN (62.8319F)
#define M1_E_BLOCK_TRH (1.4F)
#define M1_E_BLOCK_PER (2000)
#define M1_N_MAX (921.534F)
#define M1_CALIB_DURATION (200)
#define M1_FAULT_DURATION (6000)
#define M1_FREEWHEEL_DURATION (1500)
#define M1_SCALAR_UQ_MIN (1.0F)
#define M1_ALIGN_VOLTAGE (1.2F)
#define M1_ALIGN_DURATION (400)
#define M1_U_MAX (35.1029F)
#define M1_FREQ_MAX (146.667F)
#define M1_N_ANGULAR_MAX (4.77465F)
#define M1_UDCB_IIR_B0 (0.0304590F)
#define M1_UDCB_IIR_B1 (0.0304590F)
#define M1_UDCB_IIR_A1 (0.939082F)
#define M1_SCALAR_VHZ_FACTOR_GAIN (0.112500F)
#define M1_SCALAR_INTEG_GAIN ACC32(0.0293333)
#define M1_SCALAR_RAMP_UP (0.0333333F)
#define M1_SCALAR_RAMP_DOWN (0.0333333F)
/* CURRENTLOOP*/
#define M1_D_KP_GAIN (0.907168F)
#define M1_D_KI_GAIN (0.122794F)
#define M1_Q_KP_GAIN (1.10260F)
#define M1_Q_KI_GAIN (0.140476F)
#define M1_CLOOP_LIMIT (0.519615F)
/* SPEEDLOOP*/
#define M1_SPEED_RAMP_UP (2.09440F)
#define M1_SPEED_RAMP_DOWN (2.09440F)
#define M1_SPEED_LOOP_HIGH_LIMIT (2.0F)
#define M1_SPEED_LOOP_LOW_LIMIT (-2.0F)
#define M1_SPEED_PI_PROP_GAIN (0.00246648F)
#define M1_SPEED_PI_INTEG_GAIN (0.0000216963F)
#define M1_POS_P_PROP_GAIN FRAC16(0.12)
#define M1_SPEED_IIR_B0 (0.0304590F)
#define M1_SPEED_IIR_B1 (0.0304590F)
#define M1_SPEED_IIR_A1 (0.939082F)
/* SENSORS*/
#define M1_POSPE_ENC_PULSES (1000)
#define M1_POSPE_ENC_DIRECTION (0)
#define M1_POSPE_ENC_N_MIN (0.0F)
#define M1_POSPE_MECH_POS_GAIN ACC32(16.384)
#define M1_POSPE_KP_GAIN (1256.64F)
#define M1_POSPE_KI_GAIN (39.4784F)
#define M1_POSPE_INTEG_GAIN (0.0000318310F)
/* SENSORLESS*/
#define M1_OL_START_RAMP_INC (0.0628319F)
#define M1_OL_START_I (0.65F)
#define M1_MERG_SPEED_TRH (104.720F)
#define M1_MERG_COEFF FRAC16(0.00915527)
#define M1_I_SCALE (0.892857F)
#define M1_U_SCALE (0.238095F)
#define M1_E_SCALE (0.238095F)
#define M1_WI_SCALE (0.000102143F)
#define M1_BEMF_DQ_KP_GAIN (0.963717F)
#define M1_BEMF_DQ_KI_GAIN (0.133240F)
#define M1_TO_KP_GAIN (879.646F)
#define M1_TO_KI_GAIN (19.3444F)
#define M1_TO_THETA_GAIN (0.0000318310F)
#define M1_TO_SPEED_IIR_B0 (0.111635F)
#define M1_TO_SPEED_IIR_B1 (0.111635F)
#define M1_TO_SPEED_IIR_A1 (0.776730F)

#endif	/* #if M1_USE_TEKNIC */

/* USER INPUT START */
#define AA 1
#define BB 3
#define CC 4
#define DD 2
/* USER INPUT END */
#endif /* __M1_PMSM_APPCONFIG_H */
