/*! *********************************************************************************
* Copyright 2021-2022 NXP
* All rights reserved.
*
* \file
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */
#ifndef __PHY_PACKET_H__
#define __PHY_PACKET_H__

#include "EmbeddedTypes.h"

#define MAC_FRAME_TYPE_ACK          0x2
#define MAC_FRAME_TYPE_CMD          0x3

#define HDR_IE_ID_HT1               0x7e
#define HDR_IE_ID_HT2               0x7f

typedef struct  {
    uint8_t frameType:3;
    uint8_t securityEnabled:1;
    uint8_t framePending:1;
    uint8_t ackRequest:1;
    uint8_t panIdCompression:1;
    uint8_t reserved:1;
    uint8_t snSupression:1;
    uint8_t iePresent:1;
    uint8_t dstAddressingMode:2;
    uint8_t frameVersion:2;
    uint8_t srcAddressingMode:2;
} phyFcf_t;

typedef struct __attribute__((__packed__)) {
    uint8_t length: 7;
    uint8_t id: 8;
    uint8_t type: 1;
} HdrIe_t;

uint8_t  PhyPacket_GetHdrLength(const uint8_t *packet);
uint8_t *PhyPacket_GetSecurityHeader(const uint8_t *packet);
uint8_t  PhyPacket_GetKeyIdMode(const uint8_t *secHeader);
uint8_t  PhyPacket_GetKeyIndex(const uint8_t *packet);
void     PhyPacket_SetKeyIndex(uint8_t *packet, uint8_t keyIndex);
uint8_t  PhyPacket_GetSecurityLevel(const uint8_t *packet);
uint8_t  PhyPacket_ComputeMicLength(const uint8_t secLevel);
void     PhyPacket_SetFrameCounter(uint8_t *packet, uint32_t frameCounter);
void     PhyPacket_GetFrameCounter(uint8_t *packet, uint32_t *frameCounter);
uint8_t  PhyPacket_GetSecurityHeaderLength(uint8_t *packet);
uint8_t  PhyPacket_GetMacHdrLength(uint8_t *packet, uint8_t packetLength);

#endif /* __PHY_PACKET_H__ */