/*
 * FreeRTOS PKCS #11 V2.1.0
 * Copyright (C) 2019 Amazon.com, Inc. or its affiliates.  All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * http://aws.amazon.com/freertos
 * http://www.FreeRTOS.org
 */

/*------------------------------------------------------------------------------ */
/* */
/* This code was auto-generated by a tool. */
/* */
/* Changes to this file may cause incorrect behavior and will be */
/* lost if the code is regenerated. */
/* */
/*----------------------------------------------------------------------------- */

#include "iot_test_pkcs11_globals.h"

TEST_GROUP( Full_PKCS11_ModelBased_SessionMachine );

TEST_SETUP( Full_PKCS11_ModelBased_SessionMachine )
{
    xGlobalSlotId = 1;
}

TEST_TEAR_DOWN( Full_PKCS11_ModelBased_SessionMachine )
{
    pxGlobalFunctionList->C_Finalize( NULL_PTR );
}

void runAllSessionTestCases()
{
    pxGlobalFunctionList->C_Finalize( NULL_PTR );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_0 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_1 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_2 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_3 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_4 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_5 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_6 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_7 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_8 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_9 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_10 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_11 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_12 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_13 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_14 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_15 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_16 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_17 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_18 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_19 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_20 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_21 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_22 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_23 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_24 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_25 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_26 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_27 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_28 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_29 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_30 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_31 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_33 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_33 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_34 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_35 );
    RUN_TEST_CASE( Full_PKCS11_ModelBased_SessionMachine, path_36 );
}

TEST_GROUP_RUNNER( Full_PKCS11_ModelBased_SessionMachine )
{
    xGlobalSlotId = 1;

    CK_RV rv = prvBeforeRunningTests();

    if( rv == CKR_CRYPTOKI_NOT_INITIALIZED )
    {
        rv = CKR_OK;
    }

    TEST_ASSERT_EQUAL_MESSAGE( CKR_OK, rv, "Setup for the PKCS #11 routine failed.  Test module will start in an unknown state." );

    runAllSessionTestCases();
    prvAfterRunningTests_Object();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_0 )
{
    C_Initialize_normal_behavior();
    C_Initialize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_1 )
{
    C_Initialize_normal_behavior();
    C_Finalize_normal_behavior();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_2 )
{
    C_Initialize_normal_behavior();
    C_Finalize_normal_behavior();
    C_Finalize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_3 )
{
    C_Initialize_normal_behavior();
    C_Finalize_exceptional_behavior_1();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_4 )
{
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_Initialize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_5 )
{
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_Finalize_normal_behavior();
    C_Finalize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_6 )
{
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_Finalize_exceptional_behavior_1();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_7 )
{
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_CloseSession_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_8 )
{
    C_Initialize_normal_behavior();
    C_OpenSession_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_9 )
{
    C_Initialize_normal_behavior();
    C_OpenSession_exceptional_behavior_1();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_10 )
{
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_CloseSession_normal_behavior();
    C_Initialize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_11 )
{
    C_Initialize_normal_behavior();
    C_CloseSession_normal_behavior();
    C_Finalize_normal_behavior();
    C_Finalize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_12 )
{
    C_Initialize_normal_behavior();
    C_CloseSession_normal_behavior();
    C_Finalize_exceptional_behavior_1();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_13 )
{
    C_Initialize_normal_behavior();
    C_CloseSession_normal_behavior();
    C_CloseSession_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_14 )
{
    C_Initialize_normal_behavior();
    C_CloseSession_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_15 )
{
    C_Finalize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_16 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_Initialize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_17 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_Finalize_normal_behavior();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_18 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_Finalize_exceptional_behavior_1();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_19 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_Initialize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_20 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_Finalize_exceptional_behavior_1();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_21 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_CloseSession_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_22 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_OpenSession_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_23 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_OpenSession_exceptional_behavior_1();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_24 )
{
    C_Finalize_exceptional_behavior_0();
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_CloseSession_normal_behavior();
    C_Initialize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_25 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_CloseSession_normal_behavior();
    C_Finalize_exceptional_behavior_1();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_26 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_CloseSession_normal_behavior();
    C_CloseSession_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_27 )
{
    C_Finalize_exceptional_behavior_0();
    C_Initialize_normal_behavior();
    C_CloseSession_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_28 )
{
    C_Finalize_exceptional_behavior_0();
    C_Finalize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_29 )
{
    C_Finalize_exceptional_behavior_0();
    C_Finalize_exceptional_behavior_0();
    C_Finalize_exceptional_behavior_0();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_30 )
{
    C_Initialize_normal_behavior();
    C_OpenSession_normal_behavior();
    C_Finalize_normal_behavior();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_31 )
{
    C_SignInit_exceptional_behavior_9();
    C_Sign_exceptional_behavior_4();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_32 )
{
    C_VerifyInit_exceptional_behavior_8();
    C_Verify_exceptional_behavior_6();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_33 )
{
    C_DigestInit_exceptional_behavior_4();
    C_DigestUpdate_exceptional_behavior_3();
    C_DigestFinal_exceptional_behavior_4();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_34 )
{
    C_GenerateRandom_exceptional_behavior_0();
    C_GenerateKeyPair_exceptional_behavior_5();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_35 )
{
    C_FindObjectsInit_exceptional_behavior_3();
    C_FindObjects_exceptional_behavior_3();
    C_FindObjectsFinal_exceptional_behavior_2();
    C_GetAttributeValue_exceptional_behavior_5();
}

TEST( Full_PKCS11_ModelBased_SessionMachine, path_36 )
{
    C_FindObjectsFinal_exceptional_behavior_2();
    C_GetAttributeValue_exceptional_behavior_5();
}
