;/*
; * Copyright (c) 2009-2021 Arm Limited
; *
; * Licensed under the Apache License, Version 2.0 (the "License");
; * you may not use this file except in compliance with the License.
; * You may obtain a copy of the License at
; *
; *     http://www.apache.org/licenses/LICENSE-2.0
; *
; * Unless required by applicable law or agreed to in writing, software
; * distributed under the License is distributed on an "AS IS" BASIS,
; * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; * See the License for the specific language governing permissions and
; * limitations under the License.
; *
; *
; * This file is derivative of CMSIS V5.00 gcc_arm.ld
; */

/* Linker script to configure memory regions. */
/* This file will be run trough the pre-processor. */

#include "region_defs.h"

MEMORY
{
#ifdef M_BOOT_FLASH_CONF_START             //NXP
/* Flash configuration block(FCB) is used to configure the FlexSPI interface during the boot process. */
  m_flash_config        (RX)  : ORIGIN = M_BOOT_FLASH_CONF_START, LENGTH = M_BOOT_FLASH_CONF_SIZE     //NXP
#endif
  FLASH    (rx)  : ORIGIN = S_CODE_START, LENGTH = S_CODE_SIZE
  RAM      (rwx) : ORIGIN = S_DATA_START, LENGTH = S_DATA_SIZE
#if defined(S_CODE_SRAM_ALIAS_BASE)
  CODE_RAM (rwx) : ORIGIN = S_CODE_SRAM_ALIAS_BASE, LENGTH = TOTAL_CODE_SRAM_SIZE
#endif
#ifndef TFM_MULTI_CORE_TOPOLOGY
  VENEERS  (rx)  : ORIGIN = CMSE_VENEER_REGION_START, LENGTH = CMSE_VENEER_REGION_SIZE
#endif

#if defined(PSA_PROXY_SHARED_MEMORY_BASE)
  PSA_PROXY_SHARED_MEMORY_RAM (rw) : ORIGIN = PSA_PROXY_SHARED_MEMORY_BASE, LENGTH = PSA_PROXY_SHARED_MEMORY_SIZE
#endif

}

__heap_size__  = S_HEAP_SIZE;
__psp_stack_size__ = S_PSP_STACK_SIZE;
__msp_init_stack_size__ = S_MSP_STACK_SIZE; //NXP S_MSP_STACK_SIZE_INIT

/* Library configurations */
GROUP(libgcc.a libc.a libm.a libnosys.a libc_nano.a)

ENTRY(Reset_Handler)

SECTIONS
{
// --------- NXP --------------
#ifdef M_BOOT_FLASH_CONF_START
    .flash_config :
    {
      . = ALIGN(4);
      __FLASH_BASE = .;
      KEEP(* (.flash_conf))     /* flash config section */
      . = ALIGN(4);
    } > m_flash_config
#endif
// --------- NXP end --------------

    .TFM_VECTORS : ALIGN(4)
    {
        __vectors_start__ = .;
        KEEP(*(.vectors))
        __vectors_end__ = .;
        *startup*(.text*)
        . = ALIGN(4);
    } > FLASH

    .copy.table : ALIGN(4)
    {
        __copy_table_start__ = .;
#ifdef RAM_VECTORS_SUPPORT
        /* Copy interrupt vectors from flash to RAM */
        LONG (__vectors_start__)                            /* From */
        LONG (__ram_vectors_start__)                        /* To   */
        LONG (__vectors_end__ - __vectors_start__)          /* Size */
#endif
        LONG (LOADADDR(.TFM_DATA))
        LONG (ADDR(.TFM_DATA))
        LONG (SIZEOF(.TFM_DATA))

        LONG (LOADADDR(.TFM_PSA_ROT_LINKER_DATA))
        LONG (ADDR(.TFM_PSA_ROT_LINKER_DATA))
        LONG (SIZEOF(.TFM_PSA_ROT_LINKER_DATA))

        LONG (LOADADDR(.TFM_APP_ROT_LINKER_DATA))
        LONG (ADDR(.TFM_APP_ROT_LINKER_DATA))
        LONG (SIZEOF(.TFM_APP_ROT_LINKER_DATA))

#if defined (S_RAM_CODE_START)
        LONG (LOADADDR(.TFM_RAM_CODE))
        LONG (ADDR(.TFM_RAM_CODE))
        LONG (SIZEOF(.TFM_RAM_CODE))
#endif
#if defined(S_CODE_SRAM_ALIAS_BASE)
        LONG (LOADADDR(.ER_CODE_SRAM))
        LONG (ADDR(.ER_CODE_SRAM))
        LONG (SIZEOF(.ER_CODE_SRAM))
#endif
        __copy_table_end__ = .;
    } > FLASH

    .zero.table : ALIGN(4)
    {
        __zero_table_start__ = .;
        LONG (ADDR(.TFM_BSS))
        LONG (SIZEOF(.TFM_BSS))
#if !defined(TFM_PSA_API)
        LONG (ADDR(.TFM_SECURE_STACK))
        LONG (SIZEOF(.TFM_SECURE_STACK))
#endif /* !defined(TFM_PSA_API) */
        LONG (ADDR(.TFM_PSA_ROT_LINKER_BSS))
        LONG (SIZEOF(.TFM_PSA_ROT_LINKER_BSS))

        LONG (ADDR(.TFM_APP_ROT_LINKER_BSS))
        LONG (SIZEOF(.TFM_APP_ROT_LINKER_BSS))
#if defined(PSA_PROXY_SHARED_MEMORY_BASE)
        LONG (PSA_PROXY_SHARED_MEMORY_BASE)
        LONG (PSA_PROXY_SHARED_MEMORY_SIZE)
#endif
#if defined(TFM_SP_META_PTR_ENABLE)
        LONG (LOADADDR(.TFM_SP_META_PTR))
        LONG (ADDR(.TFM_SP_META_PTR))
        LONG (SIZEOF(.TFM_SP_META_PTR))
#endif
        __zero_table_end__ = .;
    } > FLASH

    .TFM_UNPRIV_CODE : ALIGN(32)
    {
        *libc_nano*:*(.text*)
        *libc_nano*:*(.rodata*)
        *(SFN)
        *libgcc*:*(.text*)
        *libgcc*:*(.rodata*)
	
        *libtfm_sprt*:*(.text*)
        *libtfm_sprt*:*(.rodata*)
        *tfm_sprt.*(.text*)                   //NXP
        *tfm_sprt.*(.rodata*)                 //NXP
        *service_api.*(.text*)                //NXP
        *service_api.*(.rodata*)              //NXP
        *tfm_crypto_secure_api.*(.text*)      //NXP
        *tfm_crypto_secure_api.*(.rodata*)    //NXP
        *tfm_audit_secure_api.*(.text*)       //NXP
        *tfm_audit_secure_api.*(.rodata*)     //NXP
        *tfm_its_secure_api.*(.text*)         //NXP
        *tfm_its_secure_api.*(.rodata*)       //NXP
        *tfm_platform_secure_api.*(.text*)    //NXP
        *tfm_platform_secure_api.*(.rodata*)  //NXP
        *tfm_ps_secure_api.*(.text*)          //NXP
        *tfm_ps_secure_api.*(.rodata*)        //NXP
        *tfm_ps_test_service_api.*(.text*)    //NXP
        *tfm_ps_test_service_api.*(.rodata*)  //NXP
        *tfm_secure_client_2_api.*(.text*)    //NXP
        *tfm_secure_client_2_api.*(.rodata*)  //NXP
        *tfm_attest_secure_api.*(.text*)      //NXP
        *tfm_attest_secure_api.*(.rodata*)    //NXP
        *sprt_partition_metadata_indicator.*(.text*)      //NXP
        *sprt_partition_metadata_indicator.*(.rodata*)    //NXP

        *psa_client.*(.text*)                 //NXP
        *psa_client.*(.rodata*)               //NXP
        *psa_service.*(.text*)                //NXP
        *psa_service.*(.rodata*)              //NXP
        *psa_lifecycle.*(.text*)              //NXP
        *psa_lifecycle.*(.rodata*)            //NXP
        *tfm_log_raw.*(.text*)                //NXP
        *tfm_log_raw.*(.rodata*)              //NXP
        *tfm_sp_log_raw.*(.text*)             //NXP
        *tfm_sp_log_raw.*(.rodata*)           //NXP
        *tfm_hal_sp_logdev_periph.*(.text*)   //NXP
        *tfm_hal_sp_logdev_periph.*(.rodata*) //NXP
        . = ALIGN(32);
    } > FLASH
    Image$$TFM_UNPRIV_CODE$$RO$$Base = ADDR(.TFM_UNPRIV_CODE);
    Image$$TFM_UNPRIV_CODE$$RO$$Limit = ADDR(.TFM_UNPRIV_CODE) + SIZEOF(.TFM_UNPRIV_CODE);

    /**** PSA RoT RO part (CODE + RODATA) start here */
    Image$$TFM_PSA_CODE_START$$Base = .;

    .TFM_PSA_ROT_LINKER : ALIGN(32)
    {
        *tfm_psa_rot_partition*:*(.text*)
        *tfm_psa_rot_partition*:*(.rodata*)
        *(TFM_*_PSA-ROT_ATTR_FN)
        . = ALIGN(32);
    } > FLASH

    Image$$TFM_PSA_ROT_LINKER$$RO$$Base = ADDR(.TFM_PSA_ROT_LINKER);
    Image$$TFM_PSA_ROT_LINKER$$RO$$Limit = ADDR(.TFM_PSA_ROT_LINKER) + SIZEOF(.TFM_PSA_ROT_LINKER);
    Image$$TFM_PSA_ROT_LINKER$$Base = ADDR(.TFM_PSA_ROT_LINKER);
    Image$$TFM_PSA_ROT_LINKER$$Limit = ADDR(.TFM_PSA_ROT_LINKER) + SIZEOF(.TFM_PSA_ROT_LINKER);

    /**** PSA RoT RO part (CODE + RODATA) end here */
    Image$$TFM_PSA_CODE_END$$Base = .;

    /**** APPLICATION RoT RO part (CODE + RODATA) start here */
    Image$$TFM_APP_CODE_START$$Base = .;

    .TFM_APP_ROT_LINKER : ALIGN(32)
    {
        *tfm_app_rot_partition*:*(.text*)
        *tfm_app_rot_partition*:*(.rodata*)
        *(TFM_*_APP-ROT_ATTR_FN)
// --------- NXP --------------
// #ifdef TFM_PARTITION_PROTECTED_STORAGE
        *tfm_partition_ps.*:*(.text*)
        *tfm_partition_ps.*:*(.rodata*)
        *test_ps_nv_counters.*(.text*)
        *test_ps_nv_counters.*(.rodata*)
        *(TFM_SP_PS_ATTR_FN)
	
        *ps_encrypted_object.*(.text*)               //NXP
        *ps_encrypted_object.*(.rodata*)             //NXP
        *ps_object_system.*(.text*)                  //NXP
        *ps_object_system.*(.rodata*)                //NXP
        *ps_object_table.*(.text*)                   //NXP
        *ps_object_table.*(.rodata*)                 //NXP	
        *ps_utils.*(.text*)                          //NXP
        *ps_utils.*(.rodata*)                        //NXP
        *tfm_protected_storage.*(.text*)             //NXP
        *tfm_protected_storage.*(.rodata*)           //NXP
        *tfm_ps_req_mngr.*(.text*)                   //NXP
        *tfm_ps_req_mngr.*(.rodata*)                 //NXP
        *ps_crypto_interface.*(.text*)               //NXP
        *ps_crypto_interface.*(.rodata*)             //NXP
        *ps_nv_counters.*(.text*)                    //NXP
        *ps_nv_counters.*(.rodata*)                  //NXP

// #ifdef TFM_PARTITION_TEST_CORE
        *tfm_ss_core_test_2.*(.text*)
        *tfm_ss_core_test_2.*(.rodata*)
        *(TFM_SP_CORE_TEST_2_ATTR_FN)

// #ifdef TFM_PARTITION_TEST_CORE_IPC
        *tfm_ipc_client_test.*(.text*)
        *tfm_ipc_client_test.*(.rodata*)
        *(TFM_SP_IPC_CLIENT_TEST_ATTR_FN)

// #ifdef TFM_ENABLE_IRQ_TEST
        *tfm_irq_test_service_1.*(.text*)
        *tfm_irq_test_service_1.*(.rodata*)
        *timer_cmsdk*(.text*)
        *timer_cmsdk*(.rodata*)
        *(TFM_IRQ_TEST_1_ATTR_FN)

// #ifdef TFM_PARTITION_TEST_SECURE_SERVICES
        *tfm_secure_client_2.*(.text*)
        *tfm_secure_client_2.*(.rodata*)
        *(TFM_SP_SECURE_CLIENT_2_ATTR_FN)
// --------- NXP end --------------
        . = ALIGN(32);
    } > FLASH

    Image$$TFM_APP_ROT_LINKER$$RO$$Base = ADDR(.TFM_APP_ROT_LINKER);
    Image$$TFM_APP_ROT_LINKER$$RO$$Limit = ADDR(.TFM_APP_ROT_LINKER) + SIZEOF(.TFM_APP_ROT_LINKER);
    Image$$TFM_APP_ROT_LINKER$$Base = ADDR(.TFM_APP_ROT_LINKER);
    Image$$TFM_APP_ROT_LINKER$$Limit = ADDR(.TFM_APP_ROT_LINKER) + SIZEOF(.TFM_APP_ROT_LINKER);

    /**** APPLICATION RoT RO part (CODE + RODATA) end here */
    Image$$TFM_APP_CODE_END$$Base = .;

#if defined(S_CODE_SRAM_ALIAS_BASE)
    .ER_CODE_SRAM : ALIGN(4)
    {
        *Driver_GFC100_EFlash.o(.text*)
        *Driver_GFC100_EFlash.o(.rodata*)
        *gfc100_eflash_drv.o(.text*)
        *gfc100_eflash_drv.o(.rodata*)
        *musca_b1_eflash_drv.o(.text*)
        *musca_b1_eflash_drv.o(.rodata*)
        . = ALIGN(4); /* This alignment is needed to make the section size 4 bytes aligned */
    } > CODE_RAM AT > FLASH
    Image$$ER_CODE_SRAM$$RO$$Base = ADDR(.ER_CODE_SRAM);
    Image$$ER_CODE_SRAM$$RO$$Limit = ADDR(.ER_CODE_SRAM) + SIZEOF(.ER_CODE_SRAM);
    Image$$ER_CODE_SRAM$$Base = ADDR(.ER_CODE_SRAM);
    Image$$ER_CODE_SRAM$$Limit = ADDR(.ER_CODE_SRAM) + SIZEOF(.ER_CODE_SRAM);
#endif

#if TFM_LVL != 1
    .ARM.extab :
    {
        *(.ARM.extab* .gnu.linkonce.armextab.*)
    } > FLASH

    __exidx_start = .;
    .ARM.exidx :
    {
        *(.ARM.exidx* .gnu.linkonce.armexidx.*)
    } > FLASH
    __exidx_end = .;

#endif /* TFM_LVL != 1 */

    .ER_TFM_CODE : ALIGN(4)
    {
        *(.text*)

        KEEP(*(.init))
        KEEP(*(.fini))


        /* .ctors */
        *crtbegin.o(.ctors)
        *crtbegin?.o(.ctors)
        *(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors)
        *(SORT(.ctors.*))
        *(.ctors)

        /* .dtors */
         *crtbegin.o(.dtors)
         *crtbegin?.o(.dtors)
         *(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors)
         *(SORT(.dtors.*))
         *(.dtors)

        *(.rodata*)

        KEEP(*(.eh_frame*))
    } > FLASH

    /**** Base address of secure data area */
    .tfm_secure_data_start :
    {
        . = ABSOLUTE(S_DATA_START) ;
    } > RAM

    /*
     * MPU on Armv6-M/v7-M core in multi-core topology may require more strict
     * alignment that MPU region base address must align with the MPU region
     * size.
     * As a result, in multi-core topology, to save memory resource and MPU
     * regions, unprivileged data sections and privileged data sections are
     * separated and gathered in unprivileged/privileged data area respectively.
     * Keep BL2 shared data and MSP stack at the beginning of the secure data
     * area in single Armv8-M topology, while move the two areas to the
     * beginning of privileged data region in multi-core topology.
     */
#ifndef TFM_MULTI_CORE_TOPOLOGY
#ifdef CODE_SHARING
    /* The code sharing between bootloader and runtime requires to share the
     * global variables.
     */
    .TFM_SHARED_SYMBOLS : ALIGN(32)
    {
        . += SHARED_SYMBOL_AREA_SIZE;
    } > RAM
#endif

    /* shared_data and msp_stack are overlapping on purpose when
     * msp_stack is extended until the beginning of RAM, when shared_date
     * was read out by partitions
     */
    .tfm_bl2_shared_data : ALIGN(32)
    {
        . += BOOT_TFM_SHARED_DATA_SIZE;
    } > RAM

    .msp_stack : ALIGN(32)
    {
        . += __msp_init_stack_size__;
    } > RAM
    Image$$ARM_LIB_STACK_MSP$$ZI$$Base = ADDR(.msp_stack);
    Image$$ARM_LIB_STACK_MSP$$ZI$$Limit = ADDR(.msp_stack) + SIZEOF(.msp_stack);

    /* PSP is unprivileged in single-core topology */
    .psp_stack : ALIGN(32)
    {
# if !defined(TFM_PSA_API)
        . += (__psp_stack_size__ - 0x8); // reserve space for stack seal (8 bytes)
# else
        . += (__psp_stack_size__);
# endif
    } > RAM
    Image$$ARM_LIB_STACK$$ZI$$Base = ADDR(.psp_stack);
    Image$$ARM_LIB_STACK$$ZI$$Limit = ADDR(.psp_stack) + SIZEOF(.psp_stack);

# if !defined(TFM_PSA_API)
    .psp_stack_seal_res :
    {
        . += 0x8;
    } > RAM
    Image$$ARM_LIB_STACK_SEAL$$ZI$$Base = ADDR(.psp_stack_seal_res);
    Image$$ARM_LIB_STACK_SEAL$$ZI$$Limit = ADDR(.psp_stack_seal_res) + SIZEOF(.psp_stack_seal_res);
# endif
#endif

#if !defined(TFM_PSA_API)
    .TFM_SECURE_STACK : ALIGN(128)
    {
        . += 0x2000;
    } > RAM
    Image$$TFM_SECURE_STACK$$ZI$$Base = ADDR(.TFM_SECURE_STACK);
    Image$$TFM_SECURE_STACK$$ZI$$Limit = ADDR(.TFM_SECURE_STACK) + SIZEOF(.TFM_SECURE_STACK);
#endif /* !defined(TFM_PSA_API) */

#if (TFM_LVL == 1)
    .heap : ALIGN(8)
    {
        __end__ = .;
        PROVIDE(end = .);
        __HeapBase = .;
        . += __heap_size__;
        __HeapLimit = .;
        __heap_limit = .; /* Add for _sbrk */
    } > RAM
#endif /* TFM_LVL == 1 */

#if defined(TFM_SP_META_PTR_ENABLE)
    .TFM_SP_META_PTR : ALIGN(32)
    {
        *(SP_META_PTR_SPRTL_INST)
    } > RAM
    Image$$TFM_SP_META_PTR$$RW$$Base = ADDR(.TFM_SP_META_PTR);
    Image$$TFM_SP_META_PTR$$RW$$Limit = ADDR(.TFM_SP_META_PTR) + SIZEOF(.TFM_SP_META_PTR);
#endif

    /**** APPLICATION RoT DATA start here */
    Image$$TFM_APP_RW_STACK_START$$Base = .;

    .TFM_APP_ROT_LINKER_DATA : ALIGN(32)
    {
        *tfm_app_rot_partition*:*(.data*)
        *(TFM_*_APP-ROT_ATTR_RW)
// --------- NXP --------------
//#ifdef TFM_PARTITION_PROTECTED_STORAGE
        *tfm_partition_ps.*:*(.data*)
        *test_ps_nv_counters.*(.data*)
        *(TFM_SP_PS_ATTR_RW)
	
        *ps_encrypted_object.*(.data*)              //NXP
        *ps_object_system.*(.data*)                 //NXP
        *ps_object_table.*(.data*)                  //NXP
        *ps_utils.*(.data*)                         //NXP
        *tfm_protected_storage.*(.data*)            //NXP
        *tfm_ps_req_mngr.*(.data*)                  //NXP
        *ps_crypto_interface.*(.data*)              //NXP
        *ps_nv_counters.*(.data*)                   //NXP
        *intermedia_tfm_protected_storage.*(.data*) //NXP

//#ifdef TFM_PARTITION_TEST_CORE
        *tfm_ss_core_test_2.*(.data*)
        *(TFM_SP_CORE_TEST_2_ATTR_RW)

//#ifdef TFM_PARTITION_TEST_CORE_IPC
        *tfm_ipc_client_test.*(.data*)
        *(TFM_SP_IPC_CLIENT_TEST_ATTR_RW)

//#ifdef TFM_ENABLE_IRQ_TEST
        *tfm_irq_test_service_1.*(.data*)
        *timer_cmsdk*(.data*)

//#ifdef TFM_PARTITION_TEST_SECURE_SERVICES
        *tfm_secure_client_2.*(.data*)
        *(TFM_SP_SECURE_CLIENT_2_ATTR_RW)
// --------- NXP end --------------
        . = ALIGN(32);
    } > RAM AT> FLASH
    Image$$TFM_APP_ROT_LINKER_DATA$$RW$$Base = ADDR(.TFM_APP_ROT_LINKER_DATA);
    Image$$TFM_APP_ROT_LINKER_DATA$$RW$$Limit = ADDR(.TFM_APP_ROT_LINKER_DATA) + SIZEOF(.TFM_APP_ROT_LINKER_DATA);

    .TFM_APP_ROT_LINKER_BSS : ALIGN(32)
    {
        start_of_TFM_APP_ROT_LINKER = .;
        *tfm_app_rot_partition*:*(.bss*)
        *tfm_app_rot_partition*:*(COMMON)
        *(TFM_*_APP-ROT_ATTR_ZI)
// --------- NXP --------------
//#ifdef TFM_PARTITION_PROTECTED_STORAGE
        *tfm_partition_ps.*:*(.bss*)
        *tfm_partition_ps.*:*(COMMON)
        *test_ps_nv_counters.*(.bss*)
        *test_ps_nv_counters.*(COMMON)
        *(TFM_SP_PS_ATTR_ZI)
	
        *ps_encrypted_object.*(.bss*)              //NXP
        *ps_encrypted_object.*(COMMON)             //NXP
        *ps_object_system.*(.bss*)                 //NXP
        *ps_object_system.*(COMMON)                //NXP
        *ps_object_table.*(.bss*)                  //NXP
        *ps_object_table.*(COMMON)                 //NXP	
        *ps_utils.*(.bss*)                         //NXP
        *ps_utils.*(COMMON)                        //NXP
        *tfm_protected_storage.*(.bss*)            //NXP
        *tfm_protected_storage.*(COMMON)           //NXP
        *tfm_ps_req_mngr.*(.bss*)                  //NXP
        *tfm_ps_req_mngr.*(COMMON)                 //NXP
        *ps_crypto_interface.*(.bss*)              //NXP
        *ps_crypto_interface.*(COMMON)             //NXP
        *ps_nv_counters.*(.bss*)                   //NXP
        *ps_nv_counters.*(COMMON)                  //NXP
        *intermedia_tfm_protected_storage.*(.bss*) //NXP
        *intermedia_tfm_protected_storage.*(COMMON)//NXP
	
//#ifdef TFM_PARTITION_TEST_CORE
        *tfm_ss_core_test_2.*(.bss*)
        *tfm_ss_core_test_2.*(COMMON)
        *(TFM_SP_CORE_TEST_2_ATTR_ZI)

//#ifdef TFM_PARTITION_TEST_CORE_IPC
        *tfm_ipc_client_test.*(.bss*)
        *tfm_ipc_client_test.*(COMMON)
        *(TFM_SP_IPC_CLIENT_TEST_ATTR_ZI)

//#ifdef TFM_ENABLE_IRQ_TEST
        *tfm_irq_test_service_1.*(.bss*)
        *tfm_irq_test_service_1.*(COMMON)
        *timer_cmsdk*(.bss*)
        *timer_cmsdk*(COMMON)
        *(TFM_IRQ_TEST_1_ATTR_ZI)

//#ifdef TFM_PARTITION_TEST_SECURE_SERVICES
        *tfm_secure_client_2.*(.bss*)
        *tfm_secure_client_2.*(COMMON)
        *(TFM_SP_SECURE_CLIENT_2_ATTR_ZI)
// --------- NXP end--------------
        . += (. - start_of_TFM_APP_ROT_LINKER) ? 0 : 4;
        . = ALIGN(32);
    } > RAM AT> RAM
    Image$$TFM_APP_ROT_LINKER_DATA$$ZI$$Base = ADDR(.TFM_APP_ROT_LINKER_BSS);
    Image$$TFM_APP_ROT_LINKER_DATA$$ZI$$Limit = ADDR(.TFM_APP_ROT_LINKER_BSS) + SIZEOF(.TFM_APP_ROT_LINKER_BSS);

    /**** APPLICATION RoT DATA end here */
    Image$$TFM_APP_RW_STACK_END$$Base = .;

#if TFM_LVL != 1
#ifdef TFM_PARTITION_TEST_SECURE_SERVICES
    .TFM_SP_SECURE_TEST_PARTITION_LINKER_DATA : ALIGN(32)
    {
        *libc_nano*:*(.data*)
        . = ALIGN(32);
    } > RAM AT> FLASH

    .TFM_SP_SECURE_TEST_PARTITION_LINKER_BSS : ALIGN(32)
    {
        /* FixMe:
         * Test framework use printf to print out test result. Implementation of
         * printf in GCC libc use static data and heap as well. To be able to
         * execute test suites with TFM_LVL=3 this workaround is needed to
         * allocate libc static data and heap within the data section of secure
         * test partition. This can be removed if test service will be executed
         * in privileged mode.
         */
        *libc_nano*:*(.bss*)
        *libc_nano*:*(COMMON)

        __end__ = .;
        PROVIDE(end = .);
        __HeapBase = .;
        . += __heap_size__;
        __HeapLimit = .;
        __heap_limit = .; /* Add for _sbrk */

        . = ALIGN(32);
    } > RAM AT> RAM
#else /* TFM_PARTITION_TEST_SECURE_SERVICES */
    .heap : ALIGN(8)
    {
        __end__ = .;
        PROVIDE(end = .);
        __HeapBase = .;
        . += __heap_size__;
        __HeapLimit = .;
        __heap_limit = .; /* Add for _sbrk */
    } > RAM AT> RAM
#endif /* TFM_PARTITION_TEST_SECURE_SERVICES */
#endif /* TFM_LVL != 1 */

#ifdef TFM_MULTI_CORE_TOPOLOGY
#ifdef S_DATA_PRIV_START
    /**** Privileged data area base address specified by multi-core platform */
    .tfm_secure_priv_data_boundary :
    {
        . = ABSOLUTE(S_DATA_PRIV_START) ;
    } > RAM
#endif

    /*
     * Move BL2 shared area and MSP stack to the beginning of privileged data
     * area in multi-core topology.
     */

    /* shared_data and msp_stack are overlapping on purpose when
     * msp_stack is extended until the beginning of RAM, when shared_date
     * was read out by partitions
     */
    .tfm_bl2_shared_data : ALIGN(32)
    {
        . += BOOT_TFM_SHARED_DATA_SIZE;
    } > RAM AT> RAM

    .msp_stack : ALIGN(32)
    {
        . += __msp_init_stack_size__;
    } > RAM
    Image$$ARM_LIB_STACK_MSP$$ZI$$Base = ADDR(.msp_stack);
    Image$$ARM_LIB_STACK_MSP$$ZI$$Limit = ADDR(.msp_stack) + SIZEOF(.msp_stack);

    /* PSP is privileged in multi-core topology */
    .psp_stack : ALIGN(32)
    {
        . += __psp_stack_size__;
    } > RAM
    Image$$ARM_LIB_STACK$$ZI$$Base = ADDR(.psp_stack);
    Image$$ARM_LIB_STACK$$ZI$$Limit = ADDR(.psp_stack) + SIZEOF(.psp_stack);
#endif

    /**** PSA RoT DATA start here */

    Image$$TFM_PSA_RW_STACK_START$$Base = .;

    .TFM_PSA_ROT_LINKER_DATA : ALIGN(32)
    {
        *tfm_psa_rot_partition*:*(.data*)
        *(TFM_*_PSA-ROT_ATTR_RW)
        . = ALIGN(32);
    } > RAM AT> FLASH
    Image$$TFM_PSA_ROT_LINKER_DATA$$RW$$Base = ADDR(.TFM_PSA_ROT_LINKER_DATA);
    Image$$TFM_PSA_ROT_LINKER_DATA$$RW$$Limit = ADDR(.TFM_PSA_ROT_LINKER_DATA) + SIZEOF(.TFM_PSA_ROT_LINKER_DATA);

    .TFM_PSA_ROT_LINKER_BSS : ALIGN(32)
    {
        start_of_TFM_PSA_ROT_LINKER = .;
        *tfm_psa_rot_partition*:*(.bss*)
        *tfm_psa_rot_partition*:*(COMMON)
        *(TFM_*_PSA-ROT_ATTR_ZI)
        . += (. - start_of_TFM_PSA_ROT_LINKER) ? 0 : 4;
        . = ALIGN(32);
    } > RAM AT> RAM
    Image$$TFM_PSA_ROT_LINKER_DATA$$ZI$$Base = ADDR(.TFM_PSA_ROT_LINKER_BSS);
    Image$$TFM_PSA_ROT_LINKER_DATA$$ZI$$Limit = ADDR(.TFM_PSA_ROT_LINKER_BSS) + SIZEOF(.TFM_PSA_ROT_LINKER_BSS);

    /**** PSA RoT DATA end here */
    Image$$TFM_PSA_RW_STACK_END$$Base = .;

#ifdef RAM_VECTORS_SUPPORT
    .ramVectors (NOLOAD) : ALIGN(256)
    {
        __ram_vectors_start__ = .;
        KEEP(*(.ram_vectors))
        __ram_vectors_end__   = .;
    } > RAM
    .TFM_DATA __ram_vectors_end__ : ALIGN(4)
#else

     .TFM_DATA : ALIGN(4)
#endif
    {
        *(CodeQuickAccess)       /* CodeQuickAccess sections */ //NXP
        *(DataQuickAccess)       /* DataQuickAccess sections */ //NXP

        *(.data*)

        . = ALIGN(4);
        /* preinit data */
        PROVIDE_HIDDEN (__preinit_array_start = .);
        KEEP(*(.preinit_array))
        PROVIDE_HIDDEN (__preinit_array_end = .);

        . = ALIGN(4);
        /* init data */
        PROVIDE_HIDDEN (__init_array_start = .);
        KEEP(*(SORT(.init_array.*)))
        KEEP(*(.init_array))
        PROVIDE_HIDDEN (__init_array_end = .);

        . = ALIGN(4);
        /* finit data */
        PROVIDE_HIDDEN (__fini_array_start = .);
        KEEP(*(SORT(.fini_array.*)))
        KEEP(*(.fini_array))
        PROVIDE_HIDDEN (__fini_array_end = .);

        KEEP(*(.jcr*))
        . = ALIGN(4);

    } > RAM AT> FLASH
    Image$$ER_TFM_DATA$$RW$$Base = ADDR(.TFM_DATA);
    Image$$ER_TFM_DATA$$RW$$Limit = ADDR(.TFM_DATA) + SIZEOF(.TFM_DATA);

    .TFM_BSS : ALIGN(4)
    {
        __bss_start__ = .;
        *(.bss*)
        *(COMMON)
        . = ALIGN(4);
        __bss_end__ = .;
    } > RAM AT> RAM
    Image$$ER_TFM_DATA$$ZI$$Base = ADDR(.TFM_BSS);
    Image$$ER_TFM_DATA$$ZI$$Limit = ADDR(.TFM_BSS) + SIZEOF(.TFM_BSS);

    Image$$ER_TFM_DATA$$Base = ADDR(.TFM_DATA);
    Image$$ER_TFM_DATA$$Limit = ADDR(.TFM_DATA) + SIZEOF(.TFM_DATA) + SIZEOF(.TFM_BSS);

#if defined(PSA_PROXY_SHARED_MEMORY_BASE)
    /* If a variable defined with __attribute__((section())) keyword the
     * variable is treated like an initialized variable. To not waste memory
     * NOLOAD attribute used here. The whole section is zero initialized by
     * adding section information to .zero.table */
    .PSA_PROXY_SHARED_MEMORY (NOLOAD) :
    {
        KEEP(*(PSA_PROXY_SHARED_MEMORY_SECTION))
    } > PSA_PROXY_SHARED_MEMORY_RAM
#endif

#if defined (S_RAM_CODE_START)
    /* Code executed from RAM */
    .TFM_RAM_CODE S_RAM_CODE_START :
    {
        KEEP(*(.ramfunc))
    } > RAM AT> FLASH
#endif

#ifndef TFM_MULTI_CORE_TOPOLOGY
    /*
     * Place the CMSE Veneers (containing the SG instruction) after the code, in a
     * separate 32 bytes aligned region so that the SAU can programmed to just set
     * this region as Non-Secure Callable.
     */
    .gnu.sgstubs : ALIGN(32)
    {
        *(.gnu.sgstubs*)
        . = ALIGN(32);
    } > VENEERS AT> VENEERS
    Load$$LR$$LR_VENEER$$Base = ADDR(.gnu.sgstubs);
    Load$$LR$$LR_VENEER$$Limit = ADDR(.gnu.sgstubs) + SIZEOF(.gnu.sgstubs);
#endif

    Load$$LR$$LR_NS_PARTITION$$Base = NS_PARTITION_START;

#ifdef BL2
    Load$$LR$$LR_SECONDARY_PARTITION$$Base = SECONDARY_PARTITION_START;
#endif /* BL2 */

    PROVIDE(__stack = Image$$ARM_LIB_STACK$$ZI$$Limit);
}
