/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _FSL_INPUTMUX_CONNECTIONS_
#define _FSL_INPUTMUX_CONNECTIONS_

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* Component ID definition, used by tools. */
#ifndef FSL_COMPONENT_ID
#define FSL_COMPONENT_ID "platform.drivers.inputmux_connections"
#endif

/*!
 * @addtogroup inputmux_driver
 * @{
 */

/*!
 * @name Input multiplexing connections
 * @{
 */

/*! @brief Periphinmux IDs */
#define SCT0_INMUX0         0x00U
#define TIMER0CAPTSEL0      0x20U
#define TIMER0TRIGIN        0x30U
#define TIMER1CAPTSEL0      0x40U
#define TIMER1TRIGIN        0x50U
#define TIMER2CAPTSEL0      0x60U
#define TIMER2TRIGIN        0x70U
#define PINTSEL_PMUX_ID     0xC0U
#define PINTSEL0            0xC0U
#define DMA0_ITRIG_INMUX0   0xE0U
#define DMA0_OTRIG_INMUX0   0x160U
#define FREQMEAS_REF_REG    0x180U
#define FREQMEAS_TARGET_REG 0x184U
#define TIMER3CAPTSEL0      0x1A0U
#define TIMER3TRIGIN        0x1B0U
#define TIMER4CAPTSEL0      0x1C0U
#define TIMER4TRIGIN        0x1D0U
#define PINTSECSEL0         0x1E0U
#define DMA1_ITRIG_INMUX0   0x200U
#define DMA1_OTRIG_INMUX0   0x240U
#define HSCMP0_TRIGIN       0x260U
#define ADC0_TRIG0          0x280U
#define ADC1_TRIG0          0x2C0U
#define DAC0_TRIGIN         0x300U
#define DAC1_TRIGIN         0x320U
#define DAC2_TRIGIN         0x340U
#define ENC0TRIG            0x360U
#define ENC0HOME            0x364U
#define ENC0INDEX           0x368U
#define ENC0PHASEB          0x36CU
#define ENC0PHASEA          0x370U
#define ENC1TRIG            0x380U
#define ENC1HOME            0x384U
#define ENC1INDEX           0x388U
#define ENC1PHASEB          0x38CU
#define ENC1PHASEA          0x390U
#define PWM0_EXTSYNC0       0x3A0U
#define PWM0_EXTA0          0x3B0U
#define PWM0_EXTFORCETRIG   0x3C0U
#define PWM0_FAULT0         0x3C4U
#define PWM1_EXTSYNC0       0x3E0U
#define PWM1_EXTA0          0x3F0U
#define PWM1_EXTFORCETRIG   0x400U
#define PWM1_FAULT0         0x404U
#define PWM0_EXTCLKTRIG     0x420U
#define PWM1_EXTCLKTRIG     0x424U
#define AOI0_IN0            0x440U
#define AOI1_IN0            0x480U
#define AOI_EXT_TRIG0       0x4C0U
#define HSCMP1_TRIGIN       0x4E0U
#define HSCMP2_TRIGIN       0x500U
#define DMA0_ITRIG_INMUX_32 0x520U

#define DMA0_REQ_EN0_ID   0x740U
#define DMA0_REQ_EN1_ID   0x744U
#define DMA1_REQ_EN_ID    0x760U
#define DMA0_ITRIG_EN0_ID 0x780U
#define DMA0_ITRIG_EN1_ID 0x784U
#define DMA1_ITRIG_EN_ID  0x7A0U
#define ENA_SHIFT         8U
#define PMUX_SHIFT        20U

/*! @brief INPUTMUX connections type */
typedef enum _inputmux_connection_t
{
    /*!< SCT0 INMUX. */
    kINPUTMUX_SctGpioInAToSct0        = 0U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctGpioInBToSct0        = 1U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctGpioInCToSct0        = 2U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctGpioInDToSct0        = 3U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctGpioInEToSct0        = 4U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctGpioInFToSct0        = 5U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctGpioInGToSct0        = 6U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctGpioInHToSct0        = 7U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToSct0         = 8U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToSct0         = 9U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToSct0         = 10U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToSct0         = 11U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToSct0         = 12U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToSct0           = 13U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToSct0     = 14U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToSct0   = 15U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToSct0           = 17U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedSck0ToSct0     = 18U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedSck1ToSct0     = 19U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToSct0      = 20U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToSct0      = 21U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToSct0           = 22U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_DebugHaltedToSct0       = 23U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToSct0           = 24U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0tcomp0ToSct0        = 25U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0tcomp1ToSct0        = 26U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0tcomp2ToSct0        = 27U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0tcomp3ToSct0        = 28U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1tcomp0ToSct0        = 29U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1tcomp1ToSct0        = 30U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1tcomp2ToSct0        = 31U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1tcomp3ToSct0        = 32U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToSct0         = 33U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToSct0         = 34U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToSct0         = 35U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToSct0  = 36U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToSct0  = 37U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToSct0  = 38U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToSct0  = 39U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToSct0  = 40U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToSct0  = 41U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToSct0  = 42U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToSct0  = 43U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToSct0   = 44U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToSct0   = 45U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToSct0          = 46U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToSct0          = 47U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToSct0          = 48U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToSct0          = 49U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToSct0          = 50U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToSct0          = 51U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToSct0          = 52U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToSct0          = 53U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Fc3SckToSct0            = 54U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Fc3RxdSdaMosiDataToSct0 = 55U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Fc3TxdSclMisoWsToSct0   = 55U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Fc3CtsDsaSsel0ToSct0    = 57U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToSct0           = 58U + (SCT0_INMUX0 << PMUX_SHIFT),

    /*!< TIMER0 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer0Captsel       = 0U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer0Captsel       = 1U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer0Captsel       = 2U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer0Captsel       = 3U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer0Captsel       = 4U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer0Captsel       = 5U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer0Captsel       = 6U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer0Captsel       = 7U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer0Captsel       = 8U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer0Captsel       = 9U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer0Captsel      = 10U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer0Captsel      = 11U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer0Captsel      = 12U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer0Captsel      = 13U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer0Captsel      = 14U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer0Captsel      = 15U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer0Captsel      = 16U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer0Captsel      = 17U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer0Captsel      = 18U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer0Captsel      = 19U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer0Captsel  = 20U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer0Captsel          = 22U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer0Captsel     = 23U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer0Captsel     = 24U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer0Captsel          = 25U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer0Captsel          = 26U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer0Captsel        = 27U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer0Captsel        = 28U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer0Captsel        = 29U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer0Captsel = 30U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer0Captsel = 31U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer0Captsel = 32U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer0Captsel = 33U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer0Captsel = 34U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer0Captsel = 35U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer0Captsel = 36U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer0Captsel = 37U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer0Captsel  = 38U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer0Captsel  = 39U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer0Captsel         = 40U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer0Captsel         = 41U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer0Captsel         = 42U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer0Captsel         = 43U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer0Captsel         = 44U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer0Captsel         = 45U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer0Captsel         = 46U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer0Captsel         = 47U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer0Captsel          = 48U + (TIMER0CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER0 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer0Trigger       = 0U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer0Trigger       = 1U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer0Trigger       = 2U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer0Trigger       = 3U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer0Trigger       = 4U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer0Trigger       = 5U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer0Trigger       = 6U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer0Trigger       = 7U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer0Trigger       = 8U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer0Trigger       = 9U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer0Trigger      = 10U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer0Trigger      = 11U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer0Trigger      = 12U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer0Trigger      = 13U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer0Trigger      = 14U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer0Trigger      = 15U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer0Trigger      = 16U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer0Trigger      = 17U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer0Trigger      = 18U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer0Trigger      = 19U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer0Trigger  = 20U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer0Trigger          = 22U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer0Trigger     = 23U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer0Trigger     = 24U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer0Trigger          = 25U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer0Trigger          = 26U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer0Trigger        = 27U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer0Trigger        = 28U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer0Trigger        = 29U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer0Trigger = 30U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer0Trigger = 31U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer0Trigger = 32U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer0Trigger = 33U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer0Trigger = 34U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer0Trigger = 35U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer0Trigger = 36U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer0Trigger = 37U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer0Trigger  = 38U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer0Trigger  = 39U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer0Trigger         = 40U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer0Trigger         = 41U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer0Trigger         = 42U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer0Trigger         = 43U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer0Trigger         = 44U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer0Trigger         = 45U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer0Trigger         = 46U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer0Trigger         = 47U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer0Trigger          = 48U + (TIMER0TRIGIN << PMUX_SHIFT),

    /*!< TIMER1 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer1Captsel       = 0U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer1Captsel       = 1U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer1Captsel       = 2U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer1Captsel       = 3U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer1Captsel       = 4U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer1Captsel       = 5U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer1Captsel       = 6U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer1Captsel       = 7U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer1Captsel       = 8U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer1Captsel       = 9U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer1Captsel      = 10U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer1Captsel      = 11U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer1Captsel      = 12U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer1Captsel      = 13U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer1Captsel      = 14U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer1Captsel      = 15U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer1Captsel      = 16U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer1Captsel      = 17U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer1Captsel      = 18U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer1Captsel      = 19U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer1Captsel  = 20U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer1Captsel          = 22U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer1Captsel     = 23U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer1Captsel     = 24U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer1Captsel          = 25U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer1Captsel          = 26U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer1Captsel        = 27U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer1Captsel        = 28U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer1Captsel        = 29U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer1Captsel = 30U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer1Captsel = 31U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer1Captsel = 32U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer1Captsel = 33U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer1Captsel = 34U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer1Captsel = 35U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer1Captsel = 36U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer1Captsel = 37U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer1Captsel  = 38U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer1Captsel  = 39U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer1Captsel         = 40U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer1Captsel         = 41U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer1Captsel         = 42U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer1Captsel         = 43U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer1Captsel         = 44U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer1Captsel         = 45U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer1Captsel         = 46U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer1Captsel         = 47U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer1Captsel          = 48U + (TIMER1CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER1 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer1Trigger       = 0U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer1Trigger       = 1U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer1Trigger       = 2U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer1Trigger       = 3U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer1Trigger       = 4U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer1Trigger       = 5U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer1Trigger       = 6U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer1Trigger       = 7U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer1Trigger       = 8U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer1Trigger       = 9U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer1Trigger      = 10U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer1Trigger      = 11U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer1Trigger      = 12U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer1Trigger      = 13U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer1Trigger      = 14U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer1Trigger      = 15U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer1Trigger      = 16U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer1Trigger      = 17U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer1Trigger      = 18U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer1Trigger      = 19U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer1Trigger  = 20U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer1Trigger          = 22U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer1Trigger     = 23U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer1Trigger     = 24U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer1Trigger          = 25U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer1Trigger          = 26U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer1Trigger        = 27U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer1Trigger        = 28U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer1Trigger        = 29U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer1Trigger = 30U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer1Trigger = 31U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer1Trigger = 32U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer1Trigger = 33U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer1Trigger = 34U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer1Trigger = 35U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer1Trigger = 36U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer1Trigger = 37U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer1Trigger  = 38U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer1Trigger  = 39U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer1Trigger         = 40U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer1Trigger         = 41U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer1Trigger         = 42U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer1Trigger         = 43U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer1Trigger         = 44U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer1Trigger         = 45U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer1Trigger         = 46U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer1Trigger         = 47U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer1Trigger          = 48U + (TIMER1TRIGIN << PMUX_SHIFT),

    /*!< TIMER2 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer2Captsel       = 0U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer2Captsel       = 1U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer2Captsel       = 2U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer2Captsel       = 3U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer2Captsel       = 4U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer2Captsel       = 5U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer2Captsel       = 6U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer2Captsel       = 7U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer2Captsel       = 8U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer2Captsel       = 9U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer2Captsel      = 10U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer2Captsel      = 11U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer2Captsel      = 12U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer2Captsel      = 13U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer2Captsel      = 14U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer2Captsel      = 15U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer2Captsel      = 16U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer2Captsel      = 17U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer2Captsel      = 18U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer2Captsel      = 19U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer2Captsel  = 20U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer2Captsel          = 22U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer2Captsel     = 23U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer2Captsel     = 24U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer2Captsel          = 25U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer2Captsel          = 26U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer2Captsel        = 27U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer2Captsel        = 28U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer2Captsel        = 29U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer2Captsel = 30U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer2Captsel = 31U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer2Captsel = 32U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer2Captsel = 33U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer2Captsel = 34U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer2Captsel = 35U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer2Captsel = 36U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer2Captsel = 37U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer2Captsel  = 38U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer2Captsel  = 39U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer2Captsel         = 40U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer2Captsel         = 41U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer2Captsel         = 42U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer2Captsel         = 43U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer2Captsel         = 44U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer2Captsel         = 45U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer2Captsel         = 46U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer2Captsel         = 47U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer2Captsel          = 48U + (TIMER2CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER2 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer2Trigger       = 0U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer2Trigger       = 1U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer2Trigger       = 2U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer2Trigger       = 3U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer2Trigger       = 4U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer2Trigger       = 5U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer2Trigger       = 6U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer2Trigger       = 7U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer2Trigger       = 8U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer2Trigger       = 9U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer2Trigger      = 10U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer2Trigger      = 11U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer2Trigger      = 12U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer2Trigger      = 13U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer2Trigger      = 14U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer2Trigger      = 15U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer2Trigger      = 16U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer2Trigger      = 17U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer2Trigger      = 18U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer2Trigger      = 19U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer2Trigger  = 20U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer2Trigger          = 22U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer2Trigger     = 23U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer2Trigger     = 24U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer2Trigger          = 25U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer2Trigger          = 26U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer2Trigger        = 27U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer2Trigger        = 28U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer2Trigger        = 29U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer2Trigger = 30U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer2Trigger = 31U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer2Trigger = 32U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer2Trigger = 33U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer2Trigger = 34U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer2Trigger = 35U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer2Trigger = 36U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer2Trigger = 37U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer2Trigger  = 38U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer2Trigger  = 39U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer2Trigger         = 40U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer2Trigger         = 41U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer2Trigger         = 42U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer2Trigger         = 43U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer2Trigger         = 44U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer2Trigger         = 45U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer2Trigger         = 46U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer2Trigger         = 47U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer2Trigger          = 48U + (TIMER2TRIGIN << PMUX_SHIFT),

    /*!< Pin interrupt select. */
    kINPUTMUX_GpioPort0Pin0ToPintsel  = 0U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin1ToPintsel  = 1U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin2ToPintsel  = 2U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin3ToPintsel  = 3U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin4ToPintsel  = 4U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin5ToPintsel  = 5U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin6ToPintsel  = 6U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin7ToPintsel  = 7U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin8ToPintsel  = 8U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin9ToPintsel  = 9U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin10ToPintsel = 10U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin11ToPintsel = 11U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin12ToPintsel = 12U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin13ToPintsel = 13U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin14ToPintsel = 14U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin15ToPintsel = 15U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin16ToPintsel = 16U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin17ToPintsel = 17U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin18ToPintsel = 18U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin19ToPintsel = 19U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin20ToPintsel = 20U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin21ToPintsel = 21U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin22ToPintsel = 22U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin23ToPintsel = 23U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin24ToPintsel = 24U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin25ToPintsel = 25U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin26ToPintsel = 26U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin27ToPintsel = 27U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin28ToPintsel = 28U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin29ToPintsel = 29U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin30ToPintsel = 30U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin31ToPintsel = 31U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin0ToPintsel  = 32U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin1ToPintsel  = 33U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin2ToPintsel  = 34U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin3ToPintsel  = 35U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin4ToPintsel  = 36U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin5ToPintsel  = 37U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin6ToPintsel  = 38U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin7ToPintsel  = 39U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin8ToPintsel  = 40U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin9ToPintsel  = 41U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin10ToPintsel = 42U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin11ToPintsel = 43U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin12ToPintsel = 44U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin13ToPintsel = 45U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin14ToPintsel = 46U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin15ToPintsel = 47U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin16ToPintsel = 48U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin17ToPintsel = 49U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin18ToPintsel = 50U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin19ToPintsel = 51U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin20ToPintsel = 52U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin21ToPintsel = 53U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin22ToPintsel = 54U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin23ToPintsel = 55U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin24ToPintsel = 56U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin25ToPintsel = 57U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin26ToPintsel = 58U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin27ToPintsel = 59U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin28ToPintsel = 60U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin29ToPintsel = 61U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin30ToPintsel = 62U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin31ToPintsel = 63U + (PINTSEL0 << PMUX_SHIFT),

    /*!< DMA0 Input trigger. */
    kINPUTMUX_FlexSpiRxToDma0        = 0U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexSpiTxToDma0        = 1U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_PinInt0ToDma0          = 2U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToDma0          = 3U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToDma0          = 4U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_PinInt3ToDma0          = 5U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToDma0        = 6U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToDma0        = 7U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToDma0        = 8U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToDma0        = 9U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToDma0        = 10U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToDma0        = 11U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToDma0        = 12U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToDma0        = 13U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToDma0        = 14U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToDma0        = 15U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToDma0          = 16U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OtrigAToDma0           = 17U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OtrigBToDma0           = 18U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OtrigCToDma0           = 19U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OtrigDToDma0           = 20U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctDma0ToDma0          = 21U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctDma1ToDma0          = 22U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToDma0       = 23U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToDma0       = 24U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0ToDma0           = 25U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1ToDma0           = 26U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2ToDma0           = 27U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToDma0         = 28U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToDma0         = 29U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToDma0         = 30U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToDma0         = 31U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToDma0         = 32U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToDma0         = 33U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToDma0         = 34U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToDma0         = 35U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt0ToDma0 = 36U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt1ToDma0 = 37U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt2ToDma0 = 38U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt3ToDma0 = 39U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal0ToDma0  = 40U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal1ToDma0  = 41U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal2ToDma0  = 42U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal3ToDma0  = 43U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt0ToDma0 = 44U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt1ToDma0 = 45U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt2ToDma0 = 46U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt3ToDma0 = 47U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal0ToDma0  = 48U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal1ToDma0  = 49U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal2ToDma0  = 50U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal3ToDma0  = 51U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToDma0          = 52U + (DMA0_ITRIG_INMUX0 << PMUX_SHIFT),

    /*!< DMA0 output trigger. */
    kINPUTMUX_Dma0FlexSpiRxTrigoutToTriginChannels        = 0U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexSpiTxTrigoutToTriginChannels        = 1U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0PinInt0TrigoutToTriginChannels          = 2U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0PinInt1TrigoutToTriginChannels          = 3U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0PinInt2TrigoutToTriginChannels          = 4U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0PinInt3TrigoutToTriginChannels          = 5U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer0M0TrigoutToTriginChannels        = 6U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer0M1TrigoutToTriginChannels        = 7U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer1M0TrigoutToTriginChannels        = 8U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer1M1TrigoutToTriginChannels        = 9U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer2M0TrigoutToTriginChannels        = 10U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer2M1TrigoutToTriginChannels        = 11U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer3M0TrigoutToTriginChannels        = 12U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer3M1TrigoutToTriginChannels        = 13U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer4M0TrigoutToTriginChannels        = 14U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Ctimer4M1TrigoutToTriginChannels        = 15U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0CompOutTrigoutToTriginChannels          = 16U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigATrigoutToTriginChannels           = 17U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigBTrigoutToTriginChannels           = 18U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigCTrigoutToTriginChannels           = 19U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigDTrigoutToTriginChannels           = 20U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0SctDma0TrigoutToTriginChannels          = 21U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0SctDma1TrigoutToTriginChannels          = 22U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Adc0Tcomp0TrigoutToTriginChannels       = 23U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Adc1Tcomp0TrigoutToTriginChannels       = 24U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Hscmp0TrigoutToTriginChannels           = 25U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Hscmp1TrigoutToTriginChannels           = 26U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Hscmp2TrigoutToTriginChannels           = 27U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Aoi0Out0TrigoutToTriginChannels         = 28U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Aoi0Out1TrigoutToTriginChannels         = 29U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Aoi0Out2TrigoutToTriginChannels         = 30U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Aoi0Out3TrigoutToTriginChannels         = 31U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Aoi1Out0TrigoutToTriginChannels         = 32U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Aoi1Out1TrigoutToTriginChannels         = 33U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Aoi1Out2TrigoutToTriginChannels         = 34U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Aoi1Out3TrigoutToTriginChannels         = 35U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm0ReqCapt0TrigoutToTriginChannels = 36U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm0ReqCapt1TrigoutToTriginChannels = 37U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm0ReqCapt2TrigoutToTriginChannels = 38U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm0ReqCapt3TrigoutToTriginChannels = 39U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm0ReqVal0TrigoutToTriginChannels  = 40U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm0ReqVal1TrigoutToTriginChannels  = 41U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm0ReqVal2TrigoutToTriginChannels  = 42U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm0ReqVal3TrigoutToTriginChannels  = 43U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm1ReqCapt0TrigoutToTriginChannels = 44U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm1ReqCapt1TrigoutToTriginChannels = 45U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm1ReqCapt2TrigoutToTriginChannels = 46U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm1ReqCapt3TrigoutToTriginChannels = 47U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm1ReqVal0TrigoutToTriginChannels  = 48U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm1ReqVal1TrigoutToTriginChannels  = 49U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm1ReqVal2TrigoutToTriginChannels  = 50U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0FlexPwm1ReqVal3TrigoutToTriginChannels  = 51U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutTrigoutToTriginChannels              = 52U + (DMA0_OTRIG_INMUX0 << PMUX_SHIFT),

    /*!< Selection for frequency measurement reference clock. */
    kINPUTMUX_Xtal32MhzToFreqmeasRef      = 0U + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_FroOsc12MhzToFreqmeasRef    = 1u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_FroOsc96MhzToFreqmeasRef    = 2u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_WdoscToFreqmeasRef          = 3u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_32KhzOscToFreqmeasRef       = 4u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_MainSysClockToFreqmeasRef   = 5u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_FreqmeGpioClkAToFreqmeasRef = 6u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_FreqmeGpioClkBToFreqmeasRef = 7u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToFreqmeasRef       = 8u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToFreqmeasRef       = 9u + (FREQMEAS_REF_REG << PMUX_SHIFT),

    /*!< Selection for frequency measurement target clock. */
    kINPUTMUX_Xtal32MhzToFreqmeasTarget      = 0U + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_FroOsc12MhzToFreqmeasTarget    = 1u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_FroOsc96MhzToFreqmeasTarget    = 2u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_WdoscToFreqmeasTarget          = 3u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_32KhzOscToFreqmeasTarget       = 4u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_MainSysClockToFreqmeasTarget   = 5u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_FreqmeGpioClkAToFreqmeasTarget = 6u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_FreqmeGpioClkBToFreqmeasTarget = 7u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToFreqmeasTarget       = 8u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToFreqmeasTarget       = 9u + (FREQMEAS_TARGET_REG << PMUX_SHIFT),

    /*!< TIMER3 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer3Captsel       = 0U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer3Captsel       = 1U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer3Captsel       = 2U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer3Captsel       = 3U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer3Captsel       = 4U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer3Captsel       = 5U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer3Captsel       = 6U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer3Captsel       = 7U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer3Captsel       = 8U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer3Captsel       = 9U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer3Captsel      = 10U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer3Captsel      = 11U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer3Captsel      = 12U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer3Captsel      = 13U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer3Captsel      = 14U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer3Captsel      = 15U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer3Captsel      = 16U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer3Captsel      = 17U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer3Captsel      = 18U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer3Captsel      = 19U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer3Captsel  = 20U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer3Captsel          = 22U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer3Captsel     = 23U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer3Captsel     = 24U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer3Captsel          = 25U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer3Captsel          = 26U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer3Captsel        = 27U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer3Captsel        = 28U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer3Captsel        = 29U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer3Captsel = 30U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer3Captsel = 31U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer3Captsel = 32U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer3Captsel = 33U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer3Captsel = 34U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer3Captsel = 35U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer3Captsel = 36U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer3Captsel = 37U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer3Captsel  = 38U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer3Captsel  = 39U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer3Captsel         = 40U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer3Captsel         = 41U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer3Captsel         = 42U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer3Captsel         = 43U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer3Captsel         = 44U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer3Captsel         = 45U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer3Captsel         = 46U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer3Captsel         = 47U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer3Captsel          = 48U + (TIMER3CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER3 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer3Trigger       = 0U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer3Trigger       = 1U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer3Trigger       = 2U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer3Trigger       = 3U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer3Trigger       = 4U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer3Trigger       = 5U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer3Trigger       = 6U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer3Trigger       = 7U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer3Trigger       = 8U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer3Trigger       = 9U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer3Trigger      = 10U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer3Trigger      = 11U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer3Trigger      = 12U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer3Trigger      = 13U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer3Trigger      = 14U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer3Trigger      = 15U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer3Trigger      = 16U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer3Trigger      = 17U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer3Trigger      = 18U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer3Trigger      = 19U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer3Trigger  = 20U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer3Trigger          = 22U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer3Trigger     = 23U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer3Trigger     = 24U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer3Trigger          = 25U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer3Trigger          = 26U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer3Trigger        = 27U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer3Trigger        = 28U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer3Trigger        = 29U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer3Trigger = 30U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer3Trigger = 31U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer3Trigger = 32U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer3Trigger = 33U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer3Trigger = 34U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer3Trigger = 35U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer3Trigger = 36U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer3Trigger = 37U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer3Trigger  = 38U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer3Trigger  = 39U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer3Trigger         = 40U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer3Trigger         = 41U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer3Trigger         = 42U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer3Trigger         = 43U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer3Trigger         = 44U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer3Trigger         = 45U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer3Trigger         = 46U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer3Trigger         = 47U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer3Trigger          = 48U + (TIMER3TRIGIN << PMUX_SHIFT),

    /*!< Timer4 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer4Captsel       = 0U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer4Captsel       = 1U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer4Captsel       = 2U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer4Captsel       = 3U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer4Captsel       = 4U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer4Captsel       = 5U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer4Captsel       = 6U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer4Captsel       = 7U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer4Captsel       = 8U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer4Captsel       = 9U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer4Captsel      = 10U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer4Captsel      = 11U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer4Captsel      = 12U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer4Captsel      = 13U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer4Captsel      = 14U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer4Captsel      = 15U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer4Captsel      = 16U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer4Captsel      = 17U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer4Captsel      = 18U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer4Captsel      = 19U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer4Captsel  = 20U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer4Captsel          = 22U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer4Captsel     = 23U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer4Captsel     = 24U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer4Captsel          = 25U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer4Captsel          = 26U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer4Captsel        = 27U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer4Captsel        = 28U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer4Captsel        = 29U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer4Captsel = 30U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer4Captsel = 31U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer4Captsel = 32U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer4Captsel = 33U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer4Captsel = 34U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer4Captsel = 35U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer4Captsel = 36U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer4Captsel = 37U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer4Captsel  = 38U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer4Captsel  = 39U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer4Captsel         = 40U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer4Captsel         = 41U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer4Captsel         = 42U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer4Captsel         = 43U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer4Captsel         = 44U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer4Captsel         = 45U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer4Captsel         = 46U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer4Captsel         = 47U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer4Captsel          = 48U + (TIMER4CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER4 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer4Trigger       = 0U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer4Trigger       = 1U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer4Trigger       = 2U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer4Trigger       = 3U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer4Trigger       = 4U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer4Trigger       = 5U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer4Trigger       = 6U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer4Trigger       = 7U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer4Trigger       = 8U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer4Trigger       = 9U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer4Trigger      = 10U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer4Trigger      = 11U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer4Trigger      = 12U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer4Trigger      = 13U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer4Trigger      = 14U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer4Trigger      = 15U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer4Trigger      = 16U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer4Trigger      = 17U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer4Trigger      = 18U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer4Trigger      = 19U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0FrameToggleToTimer4Trigger  = 20U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CompOutToTimer4Trigger          = 22U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs0ToTimer4Trigger     = 23U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_I2sSharedWs1ToTimer4Trigger     = 24U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer4Trigger          = 25U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer4Trigger          = 26U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToTimer4Trigger        = 27U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToTimer4Trigger        = 28U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToTimer4Trigger        = 29U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToTimer4Trigger = 30U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToTimer4Trigger = 31U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToTimer4Trigger = 32U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToTimer4Trigger = 33U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToTimer4Trigger = 34U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToTimer4Trigger = 35U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToTimer4Trigger = 36U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToTimer4Trigger = 37U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer4Trigger  = 38U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer4Trigger  = 39U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToTimer4Trigger         = 40U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToTimer4Trigger         = 41U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToTimer4Trigger         = 42U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToTimer4Trigger         = 43U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToTimer4Trigger         = 44U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToTimer4Trigger         = 45U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToTimer4Trigger         = 46U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToTimer4Trigger         = 47U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_TmprOutToTimer4Trigger          = 48U + (TIMER4TRIGIN << PMUX_SHIFT),

    /*Pin interrupt secure select */
    kINPUTMUX_GpioPort0Pin0ToPintSecsel  = 0U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin1ToPintSecsel  = 1U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin2ToPintSecsel  = 2U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin3ToPintSecsel  = 3U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin4ToPintSecsel  = 4U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin5ToPintSecsel  = 5U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin6ToPintSecsel  = 6U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin7ToPintSecsel  = 7U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin8ToPintSecsel  = 8U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin9ToPintSecsel  = 9U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin10ToPintSecsel = 10U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin11ToPintSecsel = 11U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin12ToPintSecsel = 12U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin13ToPintSecsel = 13U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin14ToPintSecsel = 14U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin15ToPintSecsel = 15U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin16ToPintSecsel = 16U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin17ToPintSecsel = 17U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin18ToPintSecsel = 18U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin19ToPintSecsel = 19U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin20ToPintSecsel = 20U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin21ToPintSecsel = 21U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin22ToPintSecsel = 22U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin23ToPintSecsel = 23U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin24ToPintSecsel = 24U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin25ToPintSecsel = 25U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin26ToPintSecsel = 26U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin27ToPintSecsel = 27U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin28ToPintSecsel = 28U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin29ToPintSecsel = 29U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin30ToPintSecsel = 30U + (PINTSECSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin31ToPintSecsel = 31U + (PINTSECSEL0 << PMUX_SHIFT),

    /*!< DMA1 Input trigger. */
    kINPUTMUX_PinInt0ToDma1     = 0U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToDma1     = 1U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToDma1     = 2U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_PinInt3ToDma1     = 3U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToDma1   = 4U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToDma1   = 5U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToDma1   = 6U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToDma1   = 7U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OtrigAToDma1      = 8U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OtrigBToDma1      = 9U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OtrigCToDma1      = 10U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OtrigDToDma1      = 11U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0DmaReq0ToDma1 = 12U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0DmaReq1ToDma1 = 13U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexSpiRxToDma1   = 14U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_FlexSpiTxToDma1   = 15U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToDma1    = 16U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToDma1    = 17U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToDma1    = 18U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToDma1    = 19U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToDma1    = 20U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToDma1    = 21U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToDma1    = 22U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToDma1    = 23U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToDma1     = 24U + (DMA1_ITRIG_INMUX0 << PMUX_SHIFT),

    /*!< DMA1 output trigger. */
    kINPUTMUX_Dma1HsLspiRxTrigoutToTriginChannels   = 2U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1HsLspiTxTrigoutToTriginChannels   = 3U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Flexcom0RxTrigoutToTriginChannels = 4U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Flexcom0TxTrigoutToTriginChannels = 5U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Flexcom1RxTrigoutToTriginChannels = 6U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Flexcom1TxTrigoutToTriginChannels = 7U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Flexcom3RxTrigoutToTriginChannels = 8U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Flexcom3TxTrigoutToTriginChannels = 9U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Dmic0Ch0TrigoutToTriginChannels   = 10U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Dmic0Ch1TrigoutToTriginChannels   = 11U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1I3c0RxTrigoutToTriginChannels     = 12U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1I3c0TxTrigoutToTriginChannels     = 13U + (DMA1_OTRIG_INMUX0 << PMUX_SHIFT),

    /*!< HSCMP0 trigger. */
    kINPUTMUX_PinInt0ToHscmp0Trigger          = 0U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_PinInt6ToHscmp0Trigger          = 1U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToHscmp0Trigger          = 2U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToHscmp0Trigger          = 3U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut6ToHscmp0Trigger          = 4U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToHscmp0Trigger        = 5U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToHscmp0Trigger        = 6U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToHscmp0Trigger        = 7U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToHscmp0Trigger        = 8U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToHscmp0Trigger        = 9U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToHscmp0Trigger          = 11U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToHscmp0Trigger    = 12U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToHscmp0Trigger       = 13U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToHscmp0Trigger       = 14U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToHscmp0Trigger = 17U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToHscmp0Trigger = 18U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToHscmp0Trigger = 19U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToHscmp0Trigger = 20U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToHscmp0Trigger = 21U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToHscmp0Trigger = 22U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToHscmp0Trigger = 23U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToHscmp0Trigger = 24U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToHscmp0Trigger  = 25U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToHscmp0Trigger  = 26U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToHscmp0Trigger         = 27U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToHscmp0Trigger         = 28U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToHscmp0Trigger         = 29U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToHscmp0Trigger         = 30U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToHscmp0Trigger         = 31U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToHscmp0Trigger         = 32U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToHscmp0Trigger         = 33U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToHscmp0Trigger         = 34U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToHscmp0Trigger     = 35U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToHscmp0Trigger     = 36U + (HSCMP0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToHscmp0Trigger     = 37U + (HSCMP0_TRIGIN << PMUX_SHIFT),

    /*!< ADC0 trigger. */
    kINPUTMUX_PinInt0ToAdc0Trigger         = 0U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToAdc0Trigger         = 1U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToAdc0Trigger         = 2U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToAdc0Trigger         = 3U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut9ToAdc0Trigger         = 4U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToAdc0Trigger       = 5U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToAdc0Trigger       = 6U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToAdc0Trigger       = 7U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToAdc0Trigger       = 8U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToAdc0Trigger       = 9U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToAdc0Trigger         = 10U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToAdc0Trigger         = 11U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToAdc0Trigger   = 12U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToAdc0Trigger      = 13U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToAdc0Trigger      = 14U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToAdc0Trigger      = 15U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToAdc0Trigger      = 16U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToAdc0Trigger      = 17U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToAdc0Trigger      = 18U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToAdc0Trigger      = 19U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToAdc0Trigger      = 20U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToAdc0Trigger       = 21U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToAdc0Trigger       = 22U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToAdc0Trigger       = 23U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToAdc0Trigger = 24U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToAdc0Trigger = 25U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToAdc0Trigger = 26U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToAdc0Trigger = 27U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToAdc0Trigger = 28U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToAdc0Trigger = 29U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToAdc0Trigger = 30U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToAdc0Trigger = 31U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToAdc0Trigger = 32U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToAdc0Trigger = 33U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToAdc0Trigger = 34U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToAdc0Trigger = 35U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToAdc0Trigger = 36U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToAdc0Trigger = 37U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToAdc0Trigger = 38U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToAdc0Trigger = 39U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToAdc0Trigger = 40U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToAdc0Trigger = 41U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToAdc0Trigger        = 42U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToAdc0Trigger        = 43U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToAdc0Trigger        = 44U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToAdc0Trigger        = 45U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToAdc0Trigger        = 46U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToAdc0Trigger        = 47U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToAdc0Trigger        = 48U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToAdc0Trigger        = 49U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToAdc0Trigger    = 50U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToAdc0Trigger    = 51U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToAdc0Trigger    = 52U + (ADC0_TRIG0 << PMUX_SHIFT),

    /*!< ADC1 trigger. */
    kINPUTMUX_PinInt0ToAdc1Trigger         = 0U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToAdc1Trigger         = 1U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToAdc1Trigger         = 2U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToAdc1Trigger         = 3U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToAdc1Trigger         = 4U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToAdc1Trigger       = 5U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToAdc1Trigger       = 6U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToAdc1Trigger       = 7U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToAdc1Trigger       = 8U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToAdc1Trigger       = 9U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToAdc1Trigger         = 10U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToAdc1Trigger         = 11U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToAdc1Trigger   = 12U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToAdc1Trigger      = 13U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToAdc1Trigger      = 14U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToAdc1Trigger      = 15U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToAdc1Trigger      = 16U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToAdc1Trigger      = 17U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToAdc1Trigger      = 18U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToAdc1Trigger      = 19U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToAdc1Trigger      = 20U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToAdc1Trigger       = 21U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToAdc1Trigger       = 22U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToAdc1Trigger       = 23U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToAdc1Trigger = 24U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToAdc1Trigger = 25U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToAdc1Trigger = 26U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToAdc1Trigger = 27U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToAdc1Trigger = 28U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToAdc1Trigger = 29U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToAdc1Trigger = 30U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToAdc1Trigger = 31U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToAdc1Trigger = 32U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToAdc1Trigger = 33U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToAdc1Trigger = 34U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToAdc1Trigger = 35U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToAdc1Trigger = 36U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToAdc1Trigger = 37U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToAdc1Trigger = 38U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToAdc1Trigger = 39U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToAdc1Trigger = 40U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToAdc1Trigger = 41U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToAdc1Trigger        = 42U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToAdc1Trigger        = 43U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToAdc1Trigger        = 44U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToAdc1Trigger        = 45U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToAdc1Trigger        = 46U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToAdc1Trigger        = 47U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToAdc1Trigger        = 48U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToAdc1Trigger        = 49U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToAdc1Trigger    = 50U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToAdc1Trigger    = 51U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToAdc1Trigger    = 52U + (ADC1_TRIG0 << PMUX_SHIFT),

    /*!< DAC0 trigger. */
    kINPUTMUX_PinInt0ToDac0Trigger       = 0U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_PinInt3ToDac0Trigger       = 1U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToDac0Trigger       = 2U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToDac0Trigger       = 3U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToDac0Trigger       = 4U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToDac0Trigger     = 5U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToDac0Trigger     = 6U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToDac0Trigger     = 7U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToDac0Trigger     = 8U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToDac0Trigger     = 9U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CompOutToDac0Trigger       = 10U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToDac0Trigger       = 11U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToDac0Trigger = 12U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToDac0Trigger    = 13U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToDac0Trigger    = 14U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToDac0Trigger     = 15U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToDac0Trigger     = 16U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToDac0Trigger     = 17U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToDac0Trigger      = 18U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToDac0Trigger      = 19U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToDac0Trigger      = 20U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToDac0Trigger      = 21U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToDac0Trigger      = 22U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToDac0Trigger      = 23U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToDac0Trigger      = 24U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToDac0Trigger      = 25U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToDac0Trigger  = 26U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToDac0Trigger  = 27U + (DAC0_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToDac0Trigger  = 28U + (DAC0_TRIGIN << PMUX_SHIFT),

    /*!< DAC1 trigger. */
    kINPUTMUX_PinInt0ToDac1Trigger       = 0U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToDac1Trigger       = 1U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToDac1Trigger       = 2U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToDac1Trigger       = 3U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToDac1Trigger       = 4U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToDac1Trigger     = 5U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToDac1Trigger     = 6U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToDac1Trigger     = 7U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToDac1Trigger     = 8U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToDac1Trigger     = 9U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CompOutToDac1Trigger       = 10U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToDac1Trigger       = 11U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToDac1Trigger = 12U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToDac1Trigger    = 13U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToDac1Trigger    = 14U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToDac1Trigger     = 15U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToDac1Trigger     = 16U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToDac1Trigger     = 17U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToDac1Trigger      = 18U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToDac1Trigger      = 19U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToDac1Trigger      = 20U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToDac1Trigger      = 21U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToDac1Trigger      = 22U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToDac1Trigger      = 23U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToDac1Trigger      = 24U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToDac1Trigger      = 25U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToDac1Trigger  = 26U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToDac1Trigger  = 27U + (DAC1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToDac1Trigger  = 28U + (DAC1_TRIGIN << PMUX_SHIFT),

    /*!< DAC2 trigger. */
    kINPUTMUX_PinInt0ToDac2Trigger       = 0U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToDac2Trigger       = 1U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToDac2Trigger       = 2U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToDac2Trigger       = 3U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToDac2Trigger       = 4U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToDac2Trigger     = 5U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToDac2Trigger     = 6U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToDac2Trigger     = 7U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M2ToDac2Trigger     = 8U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToDac2Trigger     = 9U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CompOutToDac2Trigger       = 10U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToDac2Trigger       = 11U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToDac2Trigger = 12U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToDac2Trigger    = 13U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToDac2Trigger    = 14U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToDac2Trigger     = 15U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToDac2Trigger     = 16U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToDac2Trigger     = 17U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToDac2Trigger      = 18U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToDac2Trigger      = 19U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToDac2Trigger      = 20U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToDac2Trigger      = 21U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToDac2Trigger      = 22U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToDac2Trigger      = 23U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToDac2Trigger      = 24U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToDac2Trigger      = 25U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToDac2Trigger  = 26U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToDac2Trigger  = 27U + (DAC2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToDac2Trigger  = 28U + (DAC2_TRIGIN << PMUX_SHIFT),

    /*!< ENC0 TRIG. */
    kINPUTMUX_PinInt0ToEnc0Trigger         = 0U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Trigger         = 1U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Trigger         = 2U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Trigger         = 3U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Trigger         = 4U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Trigger       = 5U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Trigger       = 6U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Trigger       = 7U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Trigger       = 8U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Trigger       = 9U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc0Trigger         = 10U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Trigger         = 11U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc0Trigger   = 12U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Trigger      = 13U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Trigger      = 14U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Trigger      = 15U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Trigger      = 16U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Trigger      = 17U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Trigger      = 18U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Trigger      = 19U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Trigger      = 20U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc0Trigger       = 21U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc0Trigger       = 22U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc0Trigger       = 23U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc0Trigger = 24U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc0Trigger = 25U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc0Trigger = 26U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc0Trigger = 27U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc0Trigger = 28U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc0Trigger = 29U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc0Trigger = 30U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc0Trigger = 31U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Trigger = 32U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Trigger = 33U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc0Trigger        = 34U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc0Trigger        = 35U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc0Trigger        = 36U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc0Trigger        = 37U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc0Trigger        = 38U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc0Trigger        = 39U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc0Trigger        = 40U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc0Trigger        = 41U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc0Trigger      = 42U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc0Trigger      = 43U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc0Trigger      = 44U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc0Trigger      = 45U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc0Trigger      = 46U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc0Trigger      = 47U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc0Trigger      = 48U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc0Trigger      = 49U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc0Trigger      = 50U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc0Trigger      = 51U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc0Trigger    = 52U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc0Trigger    = 53U + (ENC0TRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc0Trigger    = 54U + (ENC0TRIG << PMUX_SHIFT),

    /*!< ENC0 HOME. */
    kINPUTMUX_PinInt0ToEnc0Home         = 0U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Home         = 1U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Home         = 2U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Home         = 3U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Home         = 4U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Home       = 5U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Home       = 6U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Home       = 7U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Home       = 8U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Home       = 9U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc0Home         = 10U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Home         = 11U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc0Home   = 12U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Home      = 13U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Home      = 14U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Home      = 15U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Home      = 16U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Home      = 17U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Home      = 18U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Home      = 19U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Home      = 20U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc0Home       = 21U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc0Home       = 22U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc0Home       = 23U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc0Home = 24U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc0Home = 25U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc0Home = 26U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc0Home = 27U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc0Home = 28U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc0Home = 29U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc0Home = 30U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc0Home = 31U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Home = 32U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Home = 33U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc0Home        = 34U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc0Home        = 35U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc0Home        = 36U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc0Home        = 37U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc0Home        = 38U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc0Home        = 39U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc0Home        = 40U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc0Home        = 41U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc0Home      = 42U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc0Home      = 43U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc0Home      = 44U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc0Home      = 45U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc0Home      = 46U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc0Home      = 47U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc0Home      = 48U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc0Home      = 49U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc0Home      = 50U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc0Home      = 51U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc0Home    = 52U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc0Home    = 53U + (ENC0HOME << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc0Home    = 54U + (ENC0HOME << PMUX_SHIFT),

    /*!< ENC0 INDEX. */
    kINPUTMUX_PinInt0ToEnc0Index         = 0U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Index         = 1U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Index         = 2U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Index         = 3U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Index         = 4U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Index       = 5U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Index       = 6U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Index       = 7U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Index       = 8U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Index       = 9U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc0Index         = 10U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Index         = 11U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc0Index   = 12U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Index      = 13U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Index      = 14U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Index      = 15U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Index      = 16U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Index      = 17U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Index      = 18U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Index      = 19U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Index      = 20U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc0Index       = 21U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc0Index       = 22U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc0Index       = 23U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc0Index = 24U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc0Index = 25U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc0Index = 26U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc0Index = 27U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc0Index = 28U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc0Index = 29U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc0Index = 30U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc0Index = 31U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Index = 32U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Index = 33U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc0Index        = 34U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc0Index        = 35U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc0Index        = 36U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc0Index        = 37U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc0Index        = 38U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc0Index        = 39U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc0Index        = 40U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc0Index        = 41U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc0Index      = 42U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc0Index      = 43U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc0Index      = 44U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc0Index      = 45U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc0Index      = 46U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc0Index      = 47U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc0Index      = 48U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc0Index      = 49U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc0Index      = 50U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc0Index      = 51U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc0Index    = 52U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc0Index    = 53U + (ENC0INDEX << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc0Index    = 54U + (ENC0INDEX << PMUX_SHIFT),

    /*!< ENC0 PHASEB. */
    kINPUTMUX_PinInt0ToEnc0Phaseb         = 0U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Phaseb         = 1U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Phaseb         = 2U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Phaseb         = 3U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Phaseb         = 4U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Phaseb       = 5U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Phaseb       = 6U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Phaseb       = 7U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Phaseb       = 8U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Phaseb       = 9U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc0Phaseb         = 10U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Phaseb         = 11U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc0Phaseb   = 12U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Phaseb      = 13U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Phaseb      = 14U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Phaseb      = 15U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Phaseb      = 16U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Phaseb      = 17U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Phaseb      = 18U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Phaseb      = 19U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Phaseb      = 20U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc0Phaseb       = 21U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc0Phaseb       = 22U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc0Phaseb       = 23U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc0Phaseb = 24U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc0Phaseb = 25U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc0Phaseb = 26U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc0Phaseb = 27U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc0Phaseb = 28U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc0Phaseb = 29U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc0Phaseb = 30U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc0Phaseb = 31U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Phaseb = 32U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Phaseb = 33U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc0Phaseb        = 34U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc0Phaseb        = 35U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc0Phaseb        = 36U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc0Phaseb        = 37U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc0Phaseb        = 38U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc0Phaseb        = 39U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc0Phaseb        = 40U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc0Phaseb        = 41U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc0Phaseb      = 42U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc0Phaseb      = 43U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc0Phaseb      = 44U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc0Phaseb      = 45U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc0Phaseb      = 46U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc0Phaseb      = 47U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc0Phaseb      = 48U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc0Phaseb      = 49U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc0Phaseb      = 50U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc0Phaseb      = 51U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc0Phaseb    = 52U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc0Phaseb    = 53U + (ENC0PHASEB << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc0Phaseb    = 54U + (ENC0PHASEB << PMUX_SHIFT),

    /*!< ENC0 PHASEA. */
    kINPUTMUX_PinInt0ToEnc0Phasea         = 0U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Phasea         = 1U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Phasea         = 2U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Phasea         = 3U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Phasea         = 4U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Phasea       = 5U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Phasea       = 6U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Phasea       = 7U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Phasea       = 8U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Phasea       = 9U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc0Phasea         = 10U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Phasea         = 11U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc0Phasea   = 12U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Phasea      = 13U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Phasea      = 14U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Phasea      = 15U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Phasea      = 16U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Phasea      = 17U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Phasea      = 18U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Phasea      = 19U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Phasea      = 20U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc0Phasea       = 21U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc0Phasea       = 22U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc0Phasea       = 23U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc0Phasea = 24U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc0Phasea = 25U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc0Phasea = 26U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc0Phasea = 27U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc0Phasea = 28U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc0Phasea = 29U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc0Phasea = 30U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc0Phasea = 31U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Phasea = 32U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Phasea = 33U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc0Phasea        = 34U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc0Phasea        = 35U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc0Phasea        = 36U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc0Phasea        = 37U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc0Phasea        = 38U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc0Phasea        = 39U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc0Phasea        = 40U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc0Phasea        = 41U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc0Phasea      = 42U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc0Phasea      = 43U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc0Phasea      = 44U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc0Phasea      = 45U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc0Phasea      = 46U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc0Phasea      = 47U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc0Phasea      = 48U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc0Phasea      = 49U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc0Phasea      = 50U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc0Phasea      = 51U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc0Phasea    = 52U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc0Phasea    = 53U + (ENC0PHASEA << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc0Phasea    = 54U + (ENC0PHASEA << PMUX_SHIFT),

    /*!< ENC1 TRIG. */
    kINPUTMUX_PinInt0ToEnc1Trigger         = 0U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Trigger         = 1U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Trigger         = 2U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Trigger         = 3U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToEnc1Trigger         = 4U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Trigger       = 5U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Trigger       = 6U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Trigger       = 7U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Trigger       = 8U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Trigger       = 9U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc1Trigger         = 10U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Trigger         = 11U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc1Trigger   = 12U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Trigger      = 13U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Trigger      = 14U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Trigger      = 15U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Trigger      = 16U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Trigger      = 17U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Trigger      = 18U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Trigger      = 19U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Trigger      = 20U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc1Trigger       = 21U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc1Trigger       = 22U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc1Trigger       = 23U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc1Trigger = 24U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc1Trigger = 25U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc1Trigger = 26U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc1Trigger = 27U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc1Trigger = 28U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc1Trigger = 29U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc1Trigger = 30U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc1Trigger = 31U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Trigger = 32U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Trigger = 33U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc1Trigger        = 34U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc1Trigger        = 35U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc1Trigger        = 36U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc1Trigger        = 37U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc1Trigger        = 38U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc1Trigger        = 39U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc1Trigger        = 40U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc1Trigger        = 41U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc1Trigger      = 42U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc1Trigger      = 43U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc1Trigger      = 44U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc1Trigger      = 45U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc1Trigger      = 46U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc1Trigger      = 47U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc1Trigger      = 48U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc1Trigger      = 49U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc1Trigger      = 50U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc1Trigger      = 51U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc1Trigger    = 52U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc1Trigger    = 53U + (ENC1TRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc1Trigger    = 54U + (ENC1TRIG << PMUX_SHIFT),

    /*!< ENC1 HOME. */
    kINPUTMUX_PinInt0ToEnc1Home         = 0U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Home         = 1U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Home         = 2U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Home         = 3U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToEnc1Home         = 4U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Home       = 5U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Home       = 6U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Home       = 7U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Home       = 8U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Home       = 9U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc1Home         = 10U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Home         = 11U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc1Home   = 12U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Home      = 13U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Home      = 14U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Home      = 15U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Home      = 16U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Home      = 17U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Home      = 18U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Home      = 19U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Home      = 20U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc1Home       = 21U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc1Home       = 22U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc1Home       = 23U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc1Home = 24U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc1Home = 25U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc1Home = 26U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc1Home = 27U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc1Home = 28U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc1Home = 29U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc1Home = 30U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc1Home = 31U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Home = 32U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Home = 33U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc1Home        = 34U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc1Home        = 35U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc1Home        = 36U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc1Home        = 37U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc1Home        = 38U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc1Home        = 39U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc1Home        = 40U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc1Home        = 41U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc1Home      = 42U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc1Home      = 43U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc1Home      = 44U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc1Home      = 45U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc1Home      = 46U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc1Home      = 47U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc1Home      = 48U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc1Home      = 49U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc1Home      = 50U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc1Home      = 51U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc1Home    = 52U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc1Home    = 53U + (ENC1HOME << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc1Home    = 54U + (ENC1HOME << PMUX_SHIFT),

    /*!< ENC1 INDEX. */
    kINPUTMUX_PinInt0ToEnc1Index         = 0U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Index         = 1U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Index         = 2U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Index         = 3U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToEnc1Index         = 4U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Index       = 5U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Index       = 6U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Index       = 7U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Index       = 8U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Index       = 9U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc1Index         = 10U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Index         = 11U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc1Index   = 12U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Index      = 13U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Index      = 14U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Index      = 15U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Index      = 16U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Index      = 17U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Index      = 18U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Index      = 19U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Index      = 20U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc1Index       = 21U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc1Index       = 22U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc1Index       = 23U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc1Index = 24U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc1Index = 25U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc1Index = 26U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc1Index = 27U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc1Index = 28U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc1Index = 29U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc1Index = 30U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc1Index = 31U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Index = 32U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Index = 33U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc1Index        = 34U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc1Index        = 35U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc1Index        = 36U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc1Index        = 37U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc1Index        = 38U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc1Index        = 39U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc1Index        = 40U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc1Index        = 41U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc1Index      = 42U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc1Index      = 43U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc1Index      = 44U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc1Index      = 45U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc1Index      = 46U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc1Index      = 47U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc1Index      = 48U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc1Index      = 49U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc1Index      = 50U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc1Index      = 51U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc1Index    = 52U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc1Index    = 53U + (ENC1INDEX << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc1Index    = 54U + (ENC1INDEX << PMUX_SHIFT),

    /*!< ENC1 PHASEB. */
    kINPUTMUX_PinInt0ToEnc1Phaseb         = 0U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Phaseb         = 1U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Phaseb         = 2U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Phaseb         = 3U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToEnc1Phaseb         = 4U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Phaseb       = 5U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Phaseb       = 6U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Phaseb       = 7U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Phaseb       = 8U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Phaseb       = 9U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc1Phaseb         = 10U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Phaseb         = 11U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc1Phaseb   = 12U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Phaseb      = 13U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Phaseb      = 14U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Phaseb      = 15U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Phaseb      = 16U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Phaseb      = 17U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Phaseb      = 18U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Phaseb      = 19U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Phaseb      = 20U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc1Phaseb       = 21U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc1Phaseb       = 22U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc1Phaseb       = 23U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc1Phaseb = 24U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc1Phaseb = 25U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc1Phaseb = 26U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc1Phaseb = 27U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc1Phaseb = 28U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc1Phaseb = 29U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc1Phaseb = 30U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc1Phaseb = 31U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Phaseb = 32U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Phaseb = 33U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc1Phaseb        = 34U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc1Phaseb        = 35U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc1Phaseb        = 36U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc1Phaseb        = 37U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc1Phaseb        = 38U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc1Phaseb        = 39U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc1Phaseb        = 40U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc1Phaseb        = 41U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc1Phaseb      = 42U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc1Phaseb      = 43U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc1Phaseb      = 44U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc1Phaseb      = 45U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc1Phaseb      = 46U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc1Phaseb      = 47U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc1Phaseb      = 48U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc1Phaseb      = 49U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc1Phaseb      = 50U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc1Phaseb      = 51U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc1Phaseb    = 52U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc1Phaseb    = 53U + (ENC1PHASEB << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc1Phaseb    = 54U + (ENC1PHASEB << PMUX_SHIFT),

    /*!< ENC1 PHASEA. */
    kINPUTMUX_PinInt0ToEnc1Phasea         = 0U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Phasea         = 1U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Phasea         = 2U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Phasea         = 3U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToEnc1Phasea         = 4U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Phasea       = 5U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Phasea       = 6U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Phasea       = 7U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Phasea       = 8U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Phasea       = 9U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_CompOutToEnc1Phasea         = 10U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Phasea         = 11U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToEnc1Phasea   = 12U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Phasea      = 13U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Phasea      = 14U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Phasea      = 15U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Phasea      = 16U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Phasea      = 17U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Phasea      = 18U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Phasea      = 19U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Phasea      = 20U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToEnc1Phasea       = 21U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToEnc1Phasea       = 22U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToEnc1Phasea       = 23U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToEnc1Phasea = 24U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToEnc1Phasea = 25U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToEnc1Phasea = 26U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToEnc1Phasea = 27U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToEnc1Phasea = 28U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToEnc1Phasea = 29U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToEnc1Phasea = 30U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToEnc1Phasea = 31U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Phasea = 32U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Phasea = 33U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToEnc1Phasea        = 34U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToEnc1Phasea        = 35U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToEnc1Phasea        = 36U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToEnc1Phasea        = 37U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToEnc1Phasea        = 38U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToEnc1Phasea        = 39U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToEnc1Phasea        = 40U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToEnc1Phasea        = 41U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToEnc1Phasea      = 42U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToEnc1Phasea      = 43U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToEnc1Phasea      = 44U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToEnc1Phasea      = 45U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToEnc1Phasea      = 46U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToEnc1Phasea      = 47U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToEnc1Phasea      = 48U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToEnc1Phasea      = 49U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToEnc1Phasea      = 50U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToEnc1Phasea      = 51U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToEnc1Phasea    = 52U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToEnc1Phasea    = 53U + (ENC1PHASEA << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToEnc1Phasea    = 54U + (ENC1PHASEA << PMUX_SHIFT),

    /*!< PWM0 external synchronization trigger. */
    kINPUTMUX_PinInt0ToPwm0ExtSyncTrigger         = 0U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToPwm0ExtSyncTrigger         = 1U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm0ExtSyncTrigger         = 2U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm0ExtSyncTrigger         = 3U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToPwm0ExtSyncTrigger         = 4U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm0ExtSyncTrigger       = 5U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm0ExtSyncTrigger       = 6U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm0ExtSyncTrigger       = 7U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToPwm0ExtSyncTrigger       = 8U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToPwm0ExtSyncTrigger       = 9U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm0ExtSyncTrigger         = 10U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm0ExtSyncTrigger         = 11U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm0ExtSyncTrigger   = 12U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm0ExtSyncTrigger      = 13U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm0ExtSyncTrigger      = 14U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm0ExtSyncTrigger      = 15U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm0ExtSyncTrigger      = 16U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm0ExtSyncTrigger      = 17U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm0ExtSyncTrigger      = 18U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm0ExtSyncTrigger      = 19U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm0ExtSyncTrigger      = 20U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm0ExtSyncTrigger       = 21U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm0ExtSyncTrigger       = 22U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm0ExtSyncTrigger       = 23U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToPwm0ExtSyncTrigger = 24U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToPwm0ExtSyncTrigger = 25U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToPwm0ExtSyncTrigger = 26U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToPwm0ExtSyncTrigger = 27U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToPwm0ExtSyncTrigger = 28U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToPwm0ExtSyncTrigger = 29U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToPwm0ExtSyncTrigger = 30U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToPwm0ExtSyncTrigger = 31U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm0ExtSyncTrigger = 32U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm0ExtSyncTrigger = 33U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm0ExtSyncTrigger        = 34U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm0ExtSyncTrigger        = 35U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm0ExtSyncTrigger        = 36U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm0ExtSyncTrigger        = 37U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm0ExtSyncTrigger        = 38U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm0ExtSyncTrigger        = 39U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm0ExtSyncTrigger        = 40U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm0ExtSyncTrigger        = 41U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm0ExtSyncTrigger      = 42U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm0ExtSyncTrigger      = 43U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm0ExtSyncTrigger      = 44U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm0ExtSyncTrigger      = 45U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm0ExtSyncTrigger      = 46U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm0ExtSyncTrigger      = 47U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm0ExtSyncTrigger      = 48U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm0ExtSyncTrigger      = 49U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm0ExtSyncTrigger      = 50U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm0ExtSyncTrigger      = 51U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm0ExtSyncTrigger    = 52U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm0ExtSyncTrigger    = 53U + (PWM0_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm0ExtSyncTrigger    = 54U + (PWM0_EXTSYNC0 << PMUX_SHIFT),

    /*!< PWM0 input trigger connections trigger. */
    kINPUTMUX_PinInt0ToPwm0ExtATrigger         = 0U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToPwm0ExtATrigger         = 1U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm0ExtATrigger         = 2U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm0ExtATrigger         = 3U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToPwm0ExtATrigger         = 4U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm0ExtATrigger       = 5U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm0ExtATrigger       = 6U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm0ExtATrigger       = 7U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToPwm0ExtATrigger       = 8U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToPwm0ExtATrigger       = 9U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm0ExtATrigger         = 10U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm0ExtATrigger         = 11U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm0ExtATrigger   = 12U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm0ExtATrigger      = 13U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm0ExtATrigger      = 14U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm0ExtATrigger      = 15U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm0ExtATrigger      = 16U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm0ExtATrigger      = 17U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm0ExtATrigger      = 18U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm0ExtATrigger      = 19U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm0ExtATrigger      = 20U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm0ExtATrigger       = 21U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm0ExtATrigger       = 22U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm0ExtATrigger       = 23U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToPwm0ExtATrigger = 24U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToPwm0ExtATrigger = 25U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToPwm0ExtATrigger = 26U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToPwm0ExtATrigger = 27U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToPwm0ExtATrigger = 28U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToPwm0ExtATrigger = 29U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToPwm0ExtATrigger = 30U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToPwm0ExtATrigger = 31U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm0ExtATrigger = 32U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm0ExtATrigger = 33U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm0ExtATrigger        = 34U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm0ExtATrigger        = 35U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm0ExtATrigger        = 36U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm0ExtATrigger        = 37U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm0ExtATrigger        = 38U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm0ExtATrigger        = 39U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm0ExtATrigger        = 40U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm0ExtATrigger        = 41U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm0ExtATrigger      = 42U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm0ExtATrigger      = 43U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm0ExtATrigger      = 44U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm0ExtATrigger      = 45U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm0ExtATrigger      = 46U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm0ExtATrigger      = 47U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm0ExtATrigger      = 48U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm0ExtATrigger      = 49U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm0ExtATrigger      = 50U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm0ExtATrigger      = 51U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm0ExtATrigger    = 52U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm0ExtATrigger    = 53U + (PWM0_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm0ExtATrigger    = 54U + (PWM0_EXTA0 << PMUX_SHIFT),

    /*!< PWM0 external force trigger connections trigger. */
    kINPUTMUX_PinInt0ToPwm0ExtForceTrigger         = 0U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToPwm0ExtForceTrigger         = 1U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm0ExtForceTrigger         = 2U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm0ExtForceTrigger         = 3U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToPwm0ExtForceTrigger         = 4U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm0ExtForceTrigger       = 5U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm0ExtForceTrigger       = 6U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm0ExtForceTrigger       = 7U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToPwm0ExtForceTrigger       = 8U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToPwm0ExtForceTrigger       = 9U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm0ExtForceTrigger         = 10U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm0ExtForceTrigger         = 11U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm0ExtForceTrigger   = 12U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm0ExtForceTrigger      = 13U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm0ExtForceTrigger      = 14U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm0ExtForceTrigger      = 15U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm0ExtForceTrigger      = 16U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm0ExtForceTrigger      = 17U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm0ExtForceTrigger      = 18U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm0ExtForceTrigger      = 19U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm0ExtForceTrigger      = 20U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm0ExtForceTrigger       = 21U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm0ExtForceTrigger       = 22U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm0ExtForceTrigger       = 23U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToPwm0ExtForceTrigger = 24U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToPwm0ExtForceTrigger = 25U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToPwm0ExtForceTrigger = 26U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToPwm0ExtForceTrigger = 27U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToPwm0ExtForceTrigger = 28U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToPwm0ExtForceTrigger = 29U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToPwm0ExtForceTrigger = 30U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToPwm0ExtForceTrigger = 31U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm0ExtForceTrigger = 32U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm0ExtForceTrigger = 33U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm0ExtForceTrigger        = 34U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm0ExtForceTrigger        = 35U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm0ExtForceTrigger        = 36U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm0ExtForceTrigger        = 37U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm0ExtForceTrigger        = 38U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm0ExtForceTrigger        = 39U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm0ExtForceTrigger        = 40U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm0ExtForceTrigger        = 41U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm0ExtForceTrigger      = 42U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm0ExtForceTrigger      = 43U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm0ExtForceTrigger      = 44U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm0ExtForceTrigger      = 45U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm0ExtForceTrigger      = 46U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm0ExtForceTrigger      = 47U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm0ExtForceTrigger      = 48U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm0ExtForceTrigger      = 49U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm0ExtForceTrigger      = 50U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm0ExtForceTrigger      = 51U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm0ExtForceTrigger    = 52U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm0ExtForceTrigger    = 53U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm0ExtForceTrigger    = 54U + (PWM0_EXTFORCETRIG << PMUX_SHIFT),

    /*!< PWM0 fault input trigger connections trigger. */
    kINPUTMUX_PinInt0ToPwm0FaultTrigger         = 0U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToPwm0FaultTrigger         = 1U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm0FaultTrigger         = 2U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm0FaultTrigger         = 3U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToPwm0FaultTrigger         = 4U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm0FaultTrigger       = 5U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm0FaultTrigger       = 6U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm0FaultTrigger       = 7U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToPwm0FaultTrigger       = 8U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToPwm0FaultTrigger       = 9U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm0FaultTrigger         = 10U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm0FaultTrigger         = 11U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm0FaultTrigger   = 12U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm0FaultTrigger      = 13U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm0FaultTrigger      = 14U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm0FaultTrigger      = 15U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm0FaultTrigger      = 16U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm0FaultTrigger      = 17U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm0FaultTrigger      = 18U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm0FaultTrigger      = 19U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm0FaultTrigger      = 20U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm0FaultTrigger       = 21U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm0FaultTrigger       = 22U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm0FaultTrigger       = 23U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToPwm0FaultTrigger = 24U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToPwm0FaultTrigger = 25U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToPwm0FaultTrigger = 26U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToPwm0FaultTrigger = 27U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToPwm0FaultTrigger = 28U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToPwm0FaultTrigger = 29U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToPwm0FaultTrigger = 30U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToPwm0FaultTrigger = 31U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm0FaultTrigger = 32U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm0FaultTrigger = 33U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm0FaultTrigger        = 34U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm0FaultTrigger        = 35U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm0FaultTrigger        = 36U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm0FaultTrigger        = 37U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm0FaultTrigger        = 38U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm0FaultTrigger        = 39U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm0FaultTrigger        = 40U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm0FaultTrigger        = 41U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm0FaultTrigger      = 42U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm0FaultTrigger      = 43U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm0FaultTrigger      = 44U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm0FaultTrigger      = 45U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm0FaultTrigger      = 46U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm0FaultTrigger      = 47U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm0FaultTrigger      = 48U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm0FaultTrigger      = 49U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm0FaultTrigger      = 50U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm0FaultTrigger      = 51U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm0FaultTrigger    = 52U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm0FaultTrigger    = 53U + (PWM0_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm0FaultTrigger    = 54U + (PWM0_FAULT0 << PMUX_SHIFT),

    /*!< PWM0 extclk input trigger connections trigger. */
    kINPUTMUX_PinInt0ToPwm0ExtClkTrigger         = 0U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToPwm0ExtClkTrigger         = 1U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm0ExtClkTrigger         = 2U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm0ExtClkTrigger         = 3U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToPwm0ExtClkTrigger         = 4U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm0ExtClkTrigger       = 5U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm0ExtClkTrigger       = 6U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm0ExtClkTrigger       = 7U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToPwm0ExtClkTrigger       = 8U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToPwm0ExtClkTrigger       = 9U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm0ExtClkTrigger         = 10U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm0ExtClkTrigger         = 11U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm0ExtClkTrigger   = 12U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm0ExtClkTrigger      = 13U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm0ExtClkTrigger      = 14U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm0ExtClkTrigger      = 15U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm0ExtClkTrigger      = 16U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm0ExtClkTrigger      = 17U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm0ExtClkTrigger      = 18U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm0ExtClkTrigger      = 19U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm0ExtClkTrigger      = 20U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm0ExtClkTrigger       = 21U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm0ExtClkTrigger       = 22U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm0ExtClkTrigger       = 23U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToPwm0ExtClkTrigger = 24U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToPwm0ExtClkTrigger = 25U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToPwm0ExtClkTrigger = 26U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToPwm0ExtClkTrigger = 27U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToPwm0ExtClkTrigger = 28U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToPwm0ExtClkTrigger = 29U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToPwm0ExtClkTrigger = 30U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToPwm0ExtClkTrigger = 31U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm0ExtClkTrigger = 32U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm0ExtClkTrigger = 33U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm0ExtClkTrigger        = 34U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm0ExtClkTrigger        = 35U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm0ExtClkTrigger        = 36U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm0ExtClkTrigger        = 37U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm0ExtClkTrigger        = 38U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm0ExtClkTrigger        = 39U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm0ExtClkTrigger        = 40U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm0ExtClkTrigger        = 41U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm0ExtClkTrigger      = 42U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm0ExtClkTrigger      = 43U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm0ExtClkTrigger      = 44U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm0ExtClkTrigger      = 45U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm0ExtClkTrigger      = 46U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm0ExtClkTrigger      = 47U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm0ExtClkTrigger      = 48U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm0ExtClkTrigger      = 49U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm0ExtClkTrigger      = 50U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm0ExtClkTrigger      = 51U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm0ExtClkTrigger    = 52U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm0ExtClkTrigger    = 53U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm0ExtClkTrigger    = 54U + (PWM0_EXTCLKTRIG << PMUX_SHIFT),

    /*!< PWM1 external synchronization trigger. */
    kINPUTMUX_PinInt0ToPwm1ExtSyncTrigger         = 0U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToPwm1ExtSyncTrigger         = 1U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm1ExtSyncTrigger         = 2U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm1ExtSyncTrigger         = 3U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToPwm1ExtSyncTrigger         = 4U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm1ExtSyncTrigger       = 5U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm1ExtSyncTrigger       = 6U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm1ExtSyncTrigger       = 7U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToPwm1ExtSyncTrigger       = 8U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToPwm1ExtSyncTrigger       = 9U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm1ExtSyncTrigger         = 10U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm1ExtSyncTrigger         = 11U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm1ExtSyncTrigger   = 12U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm1ExtSyncTrigger      = 13U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm1ExtSyncTrigger      = 14U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm1ExtSyncTrigger      = 15U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm1ExtSyncTrigger      = 16U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm1ExtSyncTrigger      = 17U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm1ExtSyncTrigger      = 18U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm1ExtSyncTrigger      = 19U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm1ExtSyncTrigger      = 20U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm1ExtSyncTrigger       = 21U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm1ExtSyncTrigger       = 22U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm1ExtSyncTrigger       = 23U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToPwm1ExtSyncTrigger = 24U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToPwm1ExtSyncTrigger = 25U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToPwm1ExtSyncTrigger = 26U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToPwm1ExtSyncTrigger = 27U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToPwm1ExtSyncTrigger = 28U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToPwm1ExtSyncTrigger = 29U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToPwm1ExtSyncTrigger = 30U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToPwm1ExtSyncTrigger = 31U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm1ExtSyncTrigger = 32U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm1ExtSyncTrigger = 33U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm1ExtSyncTrigger        = 34U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm1ExtSyncTrigger        = 35U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm1ExtSyncTrigger        = 36U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm1ExtSyncTrigger        = 37U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm1ExtSyncTrigger        = 38U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm1ExtSyncTrigger        = 39U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm1ExtSyncTrigger        = 40U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm1ExtSyncTrigger        = 41U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm1ExtSyncTrigger      = 42U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm1ExtSyncTrigger      = 43U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm1ExtSyncTrigger      = 44U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm1ExtSyncTrigger      = 45U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm1ExtSyncTrigger      = 46U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm1ExtSyncTrigger      = 47U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm1ExtSyncTrigger      = 48U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm1ExtSyncTrigger      = 49U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm1ExtSyncTrigger      = 50U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm1ExtSyncTrigger      = 51U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm1ExtSyncTrigger    = 52U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm1ExtSyncTrigger    = 53U + (PWM1_EXTSYNC0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm1ExtSyncTrigger    = 54U + (PWM1_EXTSYNC0 << PMUX_SHIFT),

    /*!< PWM1 input trigger connections trigger. */
    kINPUTMUX_PinInt0ToPwm1ExtATrigger         = 0U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToPwm1ExtATrigger         = 1U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm1ExtATrigger         = 2U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm1ExtATrigger         = 3U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToPwm1ExtATrigger         = 4U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm1ExtATrigger       = 5U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm1ExtATrigger       = 6U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm1ExtATrigger       = 7U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToPwm1ExtATrigger       = 8U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToPwm1ExtATrigger       = 9U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm1ExtATrigger         = 10U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm1ExtATrigger         = 11U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm1ExtATrigger   = 12U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm1ExtATrigger      = 13U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm1ExtATrigger      = 14U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm1ExtATrigger      = 15U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm1ExtATrigger      = 16U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm1ExtATrigger      = 17U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm1ExtATrigger      = 18U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm1ExtATrigger      = 19U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm1ExtATrigger      = 20U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm1ExtATrigger       = 21U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm1ExtATrigger       = 22U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm1ExtATrigger       = 23U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToPwm1ExtATrigger = 24U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToPwm1ExtATrigger = 25U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToPwm1ExtATrigger = 26U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToPwm1ExtATrigger = 27U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToPwm1ExtATrigger = 28U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToPwm1ExtATrigger = 29U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToPwm1ExtATrigger = 30U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToPwm1ExtATrigger = 31U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm1ExtATrigger = 32U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm1ExtATrigger = 33U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm1ExtATrigger        = 34U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm1ExtATrigger        = 35U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm1ExtATrigger        = 36U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm1ExtATrigger        = 37U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm1ExtATrigger        = 38U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm1ExtATrigger        = 39U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm1ExtATrigger        = 40U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm1ExtATrigger        = 41U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm1ExtATrigger      = 42U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm1ExtATrigger      = 43U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm1ExtATrigger      = 44U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm1ExtATrigger      = 45U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm1ExtATrigger      = 46U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm1ExtATrigger      = 47U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm1ExtATrigger      = 48U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm1ExtATrigger      = 49U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm1ExtATrigger      = 50U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm1ExtATrigger      = 51U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm1ExtATrigger    = 52U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm1ExtATrigger    = 53U + (PWM1_EXTA0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm1ExtATrigger    = 54U + (PWM1_EXTA0 << PMUX_SHIFT),

    /*!< PWM1 external force trigger connections. */
    kINPUTMUX_PinInt0ToPwm1ExtForceTrigger         = 0U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToPwm1ExtForceTrigger         = 1U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm1ExtForceTrigger         = 2U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm1ExtForceTrigger         = 3U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToPwm1ExtForceTrigger         = 4U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm1ExtForceTrigger       = 5U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm1ExtForceTrigger       = 6U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm1ExtForceTrigger       = 7U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToPwm1ExtForceTrigger       = 8U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToPwm1ExtForceTrigger       = 9U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm1ExtForceTrigger         = 10U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm1ExtForceTrigger         = 11U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm1ExtForceTrigger   = 12U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm1ExtForceTrigger      = 13U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm1ExtForceTrigger      = 14U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm1ExtForceTrigger      = 15U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm1ExtForceTrigger      = 16U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm1ExtForceTrigger      = 17U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm1ExtForceTrigger      = 18U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm1ExtForceTrigger      = 19U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm1ExtForceTrigger      = 20U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm1ExtForceTrigger       = 21U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm1ExtForceTrigger       = 22U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm1ExtForceTrigger       = 23U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToPwm1ExtForceTrigger = 24U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToPwm1ExtForceTrigger = 25U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToPwm1ExtForceTrigger = 26U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToPwm1ExtForceTrigger = 27U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToPwm1ExtForceTrigger = 28U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToPwm1ExtForceTrigger = 29U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToPwm1ExtForceTrigger = 30U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToPwm1ExtForceTrigger = 31U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm1ExtForceTrigger = 32U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm1ExtForceTrigger = 33U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm1ExtForceTrigger        = 34U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm1ExtForceTrigger        = 35U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm1ExtForceTrigger        = 36U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm1ExtForceTrigger        = 37U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm1ExtForceTrigger        = 38U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm1ExtForceTrigger        = 39U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm1ExtForceTrigger        = 40U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm1ExtForceTrigger        = 41U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm1ExtForceTrigger      = 42U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm1ExtForceTrigger      = 43U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm1ExtForceTrigger      = 44U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm1ExtForceTrigger      = 45U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm1ExtForceTrigger      = 46U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm1ExtForceTrigger      = 47U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm1ExtForceTrigger      = 48U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm1ExtForceTrigger      = 49U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm1ExtForceTrigger      = 50U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm1ExtForceTrigger      = 51U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm1ExtForceTrigger    = 52U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm1ExtForceTrigger    = 53U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm1ExtForceTrigger    = 54U + (PWM1_EXTFORCETRIG << PMUX_SHIFT),

    /*!< PWM1 fault input trigger connections trigger. */
    kINPUTMUX_PinInt0ToPwm1FaultTrigger         = 0U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToPwm1FaultTrigger         = 1U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm1FaultTrigger         = 2U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm1FaultTrigger         = 3U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToPwm1FaultTrigger         = 4U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm1FaultTrigger       = 5U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm1FaultTrigger       = 6U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm1FaultTrigger       = 7U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToPwm1FaultTrigger       = 8U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToPwm1FaultTrigger       = 9U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm1FaultTrigger         = 10U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm1FaultTrigger         = 11U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm1FaultTrigger   = 12U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm1FaultTrigger      = 13U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm1FaultTrigger      = 14U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm1FaultTrigger      = 15U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm1FaultTrigger      = 16U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm1FaultTrigger      = 17U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm1FaultTrigger      = 18U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm1FaultTrigger      = 19U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm1FaultTrigger      = 20U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm1FaultTrigger       = 21U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm1FaultTrigger       = 22U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm1FaultTrigger       = 23U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToPwm1FaultTrigger = 24U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToPwm1FaultTrigger = 25U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToPwm1FaultTrigger = 26U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToPwm1FaultTrigger = 27U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToPwm1FaultTrigger = 28U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToPwm1FaultTrigger = 29U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToPwm1FaultTrigger = 30U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToPwm1FaultTrigger = 31U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm1FaultTrigger = 32U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm1FaultTrigger = 33U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm1FaultTrigger        = 34U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm1FaultTrigger        = 35U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm1FaultTrigger        = 36U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm1FaultTrigger        = 37U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm1FaultTrigger        = 38U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm1FaultTrigger        = 39U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm1FaultTrigger        = 40U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm1FaultTrigger        = 41U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm1FaultTrigger      = 42U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm1FaultTrigger      = 43U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm1FaultTrigger      = 44U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm1FaultTrigger      = 45U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm1FaultTrigger      = 46U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm1FaultTrigger      = 47U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm1FaultTrigger      = 48U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm1FaultTrigger      = 49U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm1FaultTrigger      = 50U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm1FaultTrigger      = 51U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm1FaultTrigger    = 52U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm1FaultTrigger    = 53U + (PWM1_FAULT0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm1FaultTrigger    = 54U + (PWM1_FAULT0 << PMUX_SHIFT),

    /*!< PWM1 extclk input trigger connections trigger. */
    kINPUTMUX_PinInt0ToPwm1ExtClkTrigger         = 0U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToPwm1ExtClkTrigger         = 1U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToPwm1ExtClkTrigger         = 2U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToPwm1ExtClkTrigger         = 3U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToPwm1ExtClkTrigger         = 4U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToPwm1ExtClkTrigger       = 5U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToPwm1ExtClkTrigger       = 6U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToPwm1ExtClkTrigger       = 7U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToPwm1ExtClkTrigger       = 8U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToPwm1ExtClkTrigger       = 9U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_CompOutToPwm1ExtClkTrigger         = 10U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToPwm1ExtClkTrigger         = 11U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToPwm1ExtClkTrigger   = 12U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToPwm1ExtClkTrigger      = 13U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToPwm1ExtClkTrigger      = 14U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToPwm1ExtClkTrigger      = 15U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToPwm1ExtClkTrigger      = 16U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToPwm1ExtClkTrigger      = 17U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToPwm1ExtClkTrigger      = 18U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToPwm1ExtClkTrigger      = 19U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToPwm1ExtClkTrigger      = 20U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToPwm1ExtClkTrigger       = 21U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToPwm1ExtClkTrigger       = 22U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToPwm1ExtClkTrigger       = 23U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToPwm1ExtClkTrigger = 24U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToPwm1ExtClkTrigger = 25U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToPwm1ExtClkTrigger = 26U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToPwm1ExtClkTrigger = 27U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToPwm1ExtClkTrigger = 28U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToPwm1ExtClkTrigger = 29U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToPwm1ExtClkTrigger = 30U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToPwm1ExtClkTrigger = 31U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToPwm1ExtClkTrigger = 32U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToPwm1ExtClkTrigger = 33U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToPwm1ExtClkTrigger        = 34U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToPwm1ExtClkTrigger        = 35U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToPwm1ExtClkTrigger        = 36U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToPwm1ExtClkTrigger        = 37U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToPwm1ExtClkTrigger        = 38U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToPwm1ExtClkTrigger        = 39U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToPwm1ExtClkTrigger        = 40U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToPwm1ExtClkTrigger        = 41U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToPwm1ExtClkTrigger      = 42U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToPwm1ExtClkTrigger      = 43U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToPwm1ExtClkTrigger      = 44U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToPwm1ExtClkTrigger      = 45U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn4ToPwm1ExtClkTrigger      = 46U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn5ToPwm1ExtClkTrigger      = 47U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn6ToPwm1ExtClkTrigger      = 48U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn7ToPwm1ExtClkTrigger      = 49U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn8ToPwm1ExtClkTrigger      = 50U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn9ToPwm1ExtClkTrigger      = 51U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToPwm1ExtClkTrigger    = 52U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToPwm1ExtClkTrigger    = 53U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToPwm1ExtClkTrigger    = 54U + (PWM1_EXTCLKTRIG << PMUX_SHIFT),

    /*!< AOI0 trigger. */
    kINPUTMUX_PinInt0ToAoi0InTrigger         = 0U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToAoi0InTrigger         = 1U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToAoi0InTrigger         = 2U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToAoi0InTrigger         = 3U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToAoi0InTrigger         = 4U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToAoi0InTrigger         = 5U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToAoi0InTrigger       = 6U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToAoi0InTrigger       = 7U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToAoi0InTrigger       = 8U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M2ToAoi0InTrigger       = 9U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToAoi0InTrigger       = 10U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M2ToAoi0InTrigger       = 11U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToAoi0InTrigger         = 12U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToAoi0InTrigger   = 13U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToAoi0InTrigger         = 14U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToAoi0InTrigger         = 15U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToAoi0InTrigger      = 16U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToAoi0InTrigger      = 17U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToAoi0InTrigger      = 18U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToAoi0InTrigger      = 19U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToAoi0InTrigger      = 20U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToAoi0InTrigger      = 21U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToAoi0InTrigger      = 22U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToAoi0InTrigger      = 23U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToAoi0InTrigger       = 24U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToAoi0InTrigger       = 25U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToAoi0InTrigger       = 26U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToAoi0InTrigger = 27U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToAoi0InTrigger = 28U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToAoi0InTrigger = 29U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToAoi0InTrigger = 30U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToAoi0InTrigger = 31U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToAoi0InTrigger = 32U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToAoi0InTrigger = 33U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToAoi0InTrigger = 34U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToAoi0InTrigger = 35U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToAoi0InTrigger = 36U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToAoi0InTrigger = 37U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToAoi0InTrigger = 38U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToAoi0InTrigger = 39U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToAoi0InTrigger = 40U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToAoi0InTrigger = 41U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToAoi0InTrigger = 42U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToAoi0InTrigger = 43U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToAoi0InTrigger = 44U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToAoi0InTrigger      = 45U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToAoi0InTrigger      = 46U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToAoi0InTrigger      = 47U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToAoi0InTrigger      = 48U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToAoi0InTrigger    = 51U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToAoi0InTrigger    = 52U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToAoi0InTrigger    = 53U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout3ToAoi0InTrigger    = 54U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout4ToAoi0InTrigger    = 55U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout5ToAoi0InTrigger    = 56U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout6ToAoi0InTrigger    = 57U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Trigout0ToAoi0InTrigger    = 58U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Trigout1ToAoi0InTrigger    = 59U + (AOI0_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Trigout2ToAoi0InTrigger    = 60U + (AOI0_IN0 << PMUX_SHIFT),

    /*!< AOI1 trigger. */
    kINPUTMUX_PinInt0ToAoi1InTrigger         = 0U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToAoi1InTrigger         = 1U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToAoi1InTrigger         = 2U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToAoi1InTrigger         = 3U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToAoi1InTrigger         = 4U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToAoi1InTrigger         = 5U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToAoi1InTrigger       = 6U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToAoi1InTrigger       = 7U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToAoi1InTrigger       = 8U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M2ToAoi1InTrigger       = 9U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToAoi1InTrigger       = 10U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M2ToAoi1InTrigger       = 11U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_CompOutToAoi1InTrigger         = 12U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToAoi1InTrigger   = 13U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToAoi1InTrigger         = 14U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToAoi1InTrigger         = 15U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToAoi1InTrigger      = 16U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToAoi1InTrigger      = 17U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToAoi1InTrigger      = 18U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToAoi1InTrigger      = 19U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToAoi1InTrigger      = 20U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToAoi1InTrigger      = 21U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToAoi1InTrigger      = 22U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToAoi1InTrigger      = 23U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp0OutToAoi1InTrigger       = 24U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp1OutToAoi1InTrigger       = 25U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Hscmp2OutToAoi1InTrigger       = 26U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig0ToAoi1InTrigger = 27U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig1ToAoi1InTrigger = 28U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig0ToAoi1InTrigger = 29U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig1ToAoi1InTrigger = 30U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig0ToAoi1InTrigger = 31U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig1ToAoi1InTrigger = 32U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig0ToAoi1InTrigger = 33U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig1ToAoi1InTrigger = 34U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig0ToAoi1InTrigger = 35U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig1ToAoi1InTrigger = 36U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig0ToAoi1InTrigger = 37U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig1ToAoi1InTrigger = 38U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig0ToAoi1InTrigger = 39U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig1ToAoi1InTrigger = 40U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig0ToAoi1InTrigger = 41U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig1ToAoi1InTrigger = 42U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToAoi1InTrigger = 43U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToAoi1InTrigger = 44U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn0ToAoi1InTrigger      = 45U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn1ToAoi1InTrigger      = 46U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn2ToAoi1InTrigger      = 47U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_ExtTrigIn3ToAoi1InTrigger      = 48U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToAoi1InTrigger    = 51U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToAoi1InTrigger    = 52U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToAoi1InTrigger    = 53U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout3ToAoi1InTrigger    = 54U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout4ToAoi1InTrigger    = 55U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout5ToAoi1InTrigger    = 56U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout6ToAoi1InTrigger    = 57U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Trigout0ToAoi1InTrigger    = 58U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Trigout1ToAoi1InTrigger    = 59U + (AOI1_IN0 << PMUX_SHIFT),
    kINPUTMUX_Dma1Trigout2ToAoi1InTrigger    = 60U + (AOI1_IN0 << PMUX_SHIFT),

    /*!< AOI External trigger. */
    kINPUTMUX_PinInt0ToAoiExtTrigger          = 0U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToAoiExtTrigger          = 1U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToAoiExtTrigger          = 2U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToAoiExtTrigger          = 3U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToAoiExtTrigger       = 4U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToAoiExtTrigger       = 5U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToAoiExtTrigger = 6U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToAoiExtTrigger = 7U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToAoiExtTrigger = 8U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToAoiExtTrigger = 9U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToAoiExtTrigger = 10U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToAoiExtTrigger = 11U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToAoiExtTrigger = 12U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToAoiExtTrigger = 13U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToAoiExtTrigger  = 14U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToAoiExtTrigger  = 15U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToAoiExtTrigger         = 16U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToAoiExtTrigger         = 17U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToAoiExtTrigger         = 18U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToAoiExtTrigger         = 19U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToAoiExtTrigger         = 20U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToAoiExtTrigger         = 21U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToAoiExtTrigger         = 22U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToAoiExtTrigger         = 23U + (AOI_EXT_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_TmprOutToAoiExtTrigger          = 24U + (AOI_EXT_TRIG0 << PMUX_SHIFT),

    /*!< HSCMP1 trigger. */
    kINPUTMUX_PinInt0ToHscmp1Trigger          = 0U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToHscmp1Trigger          = 1U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToHscmp1Trigger          = 2U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToHscmp1Trigger          = 3U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToHscmp1Trigger          = 4U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToHscmp1Trigger        = 5U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToHscmp1Trigger        = 6U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToHscmp1Trigger        = 7U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToHscmp1Trigger        = 8U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToHscmp1Trigger        = 9U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToHscmp1Trigger          = 11U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToHscmp1Trigger    = 12U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToHscmp1Trigger       = 13U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToHscmp1Trigger       = 14U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToHscmp1Trigger = 17U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToHscmp1Trigger = 18U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToHscmp1Trigger = 19U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToHscmp1Trigger = 20U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToHscmp1Trigger = 21U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToHscmp1Trigger = 22U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToHscmp1Trigger = 23U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToHscmp1Trigger = 24U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToHscmp1Trigger  = 25U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToHscmp1Trigger  = 26U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToHscmp1Trigger         = 27U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToHscmp1Trigger         = 28U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToHscmp1Trigger         = 29U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToHscmp1Trigger         = 30U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToHscmp1Trigger         = 31U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToHscmp1Trigger         = 32U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToHscmp1Trigger         = 33U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToHscmp1Trigger         = 34U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToHscmp1Trigger     = 35U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToHscmp1Trigger     = 36U + (HSCMP1_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToHscmp1Trigger     = 37U + (HSCMP1_TRIGIN << PMUX_SHIFT),

    /*!< HSCMP2 trigger. */
    kINPUTMUX_PinInt0ToHscmp2Trigger          = 0U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToHscmp2Trigger          = 1U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToHscmp2Trigger          = 2U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToHscmp2Trigger          = 3U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToHscmp2Trigger          = 4U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToHscmp2Trigger        = 5U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToHscmp2Trigger        = 6U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToHscmp2Trigger        = 7U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M2ToHscmp2Trigger        = 8U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M2ToHscmp2Trigger        = 9U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToHscmp2Trigger          = 11U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_GpiointBmatchToHscmp2Trigger    = 12U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToHscmp2Trigger       = 13U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToHscmp2Trigger       = 14U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm0MuxTrig01ToHscmp2Trigger = 17U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm1MuxTrig01ToHscmp2Trigger = 18U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm2MuxTrig01ToHscmp2Trigger = 19U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0Sm3MuxTrig01ToHscmp2Trigger = 20U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm0MuxTrig01ToHscmp2Trigger = 21U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm1MuxTrig01ToHscmp2Trigger = 22U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm2MuxTrig01ToHscmp2Trigger = 23U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1Sm3MuxTrig01ToHscmp2Trigger = 24U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToHscmp2Trigger  = 25U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToHscmp2Trigger  = 26U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out0ToHscmp2Trigger         = 27U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out1ToHscmp2Trigger         = 28U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out2ToHscmp2Trigger         = 29U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi0Out3ToHscmp2Trigger         = 30U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out0ToHscmp2Trigger         = 31U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out1ToHscmp2Trigger         = 32U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out2ToHscmp2Trigger         = 33U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Aoi1Out3ToHscmp2Trigger         = 34U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout0ToHscmp2Trigger     = 35U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout1ToHscmp2Trigger     = 36U + (HSCMP2_TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Dma0Trigout2ToHscmp2Trigger     = 37U + (HSCMP2_TRIGIN << PMUX_SHIFT),

} inputmux_connection_t;

/*! @brief INPUTMUX signal enable/disable type */
typedef enum _inputmux_signal_t
{
    /*!< DMA0 REQ(DMA0_REQEN0) signal. */
    kINPUTMUX_FlexSpiRxToDmac0Ch0RequestEna   = 0U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_FlexSpiTxToDmac0Ch1RequestEna   = 1U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_PinInt0ToDmac0Ch2RequestEna     = 2U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_PinInt1ToDmac0Ch3RequestEna     = 3U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_PinInt2ToDmac0Ch4RequestEna     = 4U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_PinInt3ToDmac0Ch5RequestEna     = 5U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer0M0ToDmac0Ch6RequestEna   = 6U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer0M1ToDmac0Ch7RequestEna   = 7U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer1M0ToDmac0Ch8RequestEna   = 8U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer1M1ToDmac0Ch9RequestEna   = 9U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer2M0ToDmac0Ch10RequestEna  = 10U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer2M1ToDmac0Ch11RequestEna  = 11U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer3M0ToDmac0Ch12RequestEna  = 12U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer3M1ToDmac0Ch13RequestEna  = 13U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer4M0ToDmac0Ch14RequestEna  = 14U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Ctimer4M1ToDmac0Ch15RequestEna  = 15U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_CompOutToDmac0Ch16RequestEna    = 16U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_OtrigAToDmac0Ch17RequestEna     = 17U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_OtrigBToDmac0Ch18RequestEna     = 18U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_OtrigCToDmac0Ch19RequestEna     = 19U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_OtrigDToDmac0Ch20RequestEna     = 20U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_SctDma0ToDmac0Ch21RequestEna    = 21U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_SctDma1ToDmac0Ch22RequestEna    = 22U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToDmac23Ch0RequestEna = 23U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToDmac24Ch0RequestEna = 24U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Hscmp0ToDmac0Ch25RequestEna     = 25U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Hscmp1ToDmac0Ch26RequestEna     = 26U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Hscmp2ToDmac0Ch27RequestEna     = 27U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Aoi0Out0ToDmac0Ch28RequestEna   = 28U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Aoi0Out1ToDmac0Ch29RequestEna   = 29U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Aoi0Out2ToDmac0Ch30RequestEna   = 30U + (DMA0_REQ_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Aoi0Out3ToDmac0Ch31RequestEna   = 31U + (DMA0_REQ_EN0_ID << ENA_SHIFT),

    /*!< DMA0 REQ(DMA0_REQEN0) signal. */
    kINPUTMUX_Aoi1Out0ToDmac0Ch32RequestEna         = 0U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Aoi1Out1ToDmac0Ch33RequestEna         = 1U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Aoi1Out2ToDmac0Ch34RequestEna         = 2U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Aoi1Out3ToDmac0Ch35RequestEna         = 3U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt0ToDmac0Ch36RequestEna = 4U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt1ToDmac0Ch37RequestEna = 5U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt2ToDmac0Ch38RequestEna = 6U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt3ToDmac0Ch39RequestEna = 7U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal0ToDmac0Ch40RequestEna  = 8U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal1ToDmac0Ch41RequestEna  = 9U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal2ToDmac0Ch42RequestEna  = 10U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal3ToDmac0Ch43RequestEna  = 11U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt0ToDmac0Ch44RequestEna = 12U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt1ToDmac0Ch45RequestEna = 13U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt2ToDmac0Ch46RequestEna = 14U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt3ToDmac0Ch47RequestEna = 15U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal0ToDmac0Ch48RequestEna  = 16U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal1ToDmac0Ch49RequestEna  = 17U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal2ToDmac0Ch50RequestEna  = 18U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal3ToDmac0Ch51RequestEna  = 19U + (DMA0_REQ_EN1_ID << ENA_SHIFT),
    kINPUTMUX_TmprOutToDmac0Ch52RequestEna          = 20U + (DMA0_REQ_EN1_ID << ENA_SHIFT),

    /*!< DMA1 REQ(DMA1_REQEN) signal. */
    kINPUTMUX_HsLspiRxToDmac1Ch2RequestEna   = 2U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_HsLspiTxToDmac1Ch3RequestEna   = 3U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_Flexcom0RxToDmac1Ch4RequestEna = 4U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_Flexcom0TxToDmac1Ch5RequestEna = 5U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_Flexcom1RxToDmac1Ch6RequestEna = 6U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_Flexcom1TxToDmac1Ch7RequestEna = 7U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_Flexcom3RxToDmac1Ch8RequestEna = 8U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_Flexcom3TxToDmac1Ch9RequestEna = 9U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch0ToDmac1Ch10RequestEna  = 10U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch1ToDmac1Ch11RequestEna  = 11U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_I3c0RxToDmac1Ch12RequestEna    = 12U + (DMA1_REQ_EN_ID << ENA_SHIFT),
    kINPUTMUX_I3c0TxToDmac1Ch13RequestEna    = 13U + (DMA1_REQ_EN_ID << ENA_SHIFT),

    /*!< DMA0 input trigger(DMA0_ITRIGEN0) source enable. */
    kINPUTMUX_Dmac0InputTriggerFlexSpiRxEna  = 0U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexSpiTxEna  = 1U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPinInt0Ena    = 2U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPinInt1Ena    = 3U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPinInt2Ena    = 4U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPinInt3Ena    = 5U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer0M0Ena  = 6U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer0M1Ena  = 7U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer1M0Ena  = 8U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer1M1Ena  = 9U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer2M0Ena  = 10U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer2M1Ena  = 11U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer3M0Ena  = 12U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer3M1Ena  = 13U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer4M0Ena  = 14U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer4M1Ena  = 15U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCompOutEna    = 16U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerOtrigAEna     = 17U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerOtrigBEna     = 18U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerOtrigCEna     = 19U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerOtrigDEna     = 20U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerSctDma0Ena    = 21U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerSctDma1Ena    = 22U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAdc0Tcomp0Ena = 23U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAdc1Tcomp0Ena = 24U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerHscmp0Ena     = 25U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerHscmp1Ena     = 26U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerHscmp2Ena     = 27U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAoi0Out0Ena   = 28U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAoi0Out1Ena   = 29U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAoi0Out2Ena   = 30U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAoi0Out3Ena   = 31U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),

    /*!< DMA0 input trigger(DMA0_ITRIGEN1) source enable. */
    kINPUTMUX_Dmac0InputTriggerAoi1Out0Ena         = 0U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAoi1Out1Ena         = 1U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAoi1Out2Ena         = 2U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAoi1Out3Ena         = 3U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm0ReqCapt0Ena = 4U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm0ReqCapt1Ena = 5U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm0ReqCapt2Ena = 6U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm0ReqCapt3Ena = 7U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm0ReqVal0Ena  = 8U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm0ReqVal1Ena  = 9U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm0ReqVal2Ena  = 10U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm0ReqVal3Ena  = 11U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm1ReqCapt0Ena = 12U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm1ReqCapt1Ena = 13U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm1ReqCapt2Ena = 14U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm1ReqCapt3Ena = 15U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm1ReqVal0Ena  = 16U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm1ReqVal1Ena  = 17U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm1ReqVal2Ena  = 18U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexPwm1ReqVal3Ena  = 19U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerTmprOutEna          = 20U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),

    /*!< DMA1 input trigger(DMA1_ITRIGEN) source enable. */
    kINPUTMUX_Dmac1InputTriggerHsLspiRxEna   = 2U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerHsLspiTxEna   = 3U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexcom0RxEna = 4U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexcom0TxEna = 5U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexcom1RxEna = 6U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexcom1TxEna = 7U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexcom3RxEna = 8U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexcom3TxEna = 9U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDmic0Ch0Ena   = 10U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDmic0Ch1Ena   = 11U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerI3c0RxEna     = 12U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerI3c0TxEna     = 13U + (DMA1_ITRIG_EN_ID << ENA_SHIFT),
} inputmux_signal_t;

/*@}*/

/*@}*/

#endif /* _FSL_INPUTMUX_CONNECTIONS_ */
