/*
 * Boilerplate Stuff (BS) goes here
 */

#include "mc_dcvfd.h"

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"
#include "pin_mux.h"
#include "clock_config.h"

#include "fsl_power.h"
#include "fsl_inputmux.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>



/*******************************************************************************
 * Macros
 ******************************************************************************/


/*******************************************************************************
 * Forward declarations
 ******************************************************************************/


/*******************************************************************************
 * Globals
 ******************************************************************************/

unsigned int            minsp_ramp_val;
unsigned int            maxsp_ramp_val;
unsigned int            sp_ramp_val;
unsigned int            incr;
unsigned int            deadTimeVal;
unsigned int            pwmSourceClockInHz;
unsigned int            pwmSourceClockPrescaler;
unsigned int            PWMCLKInHz;
unsigned int            pwmReloadFreqInHz;
unsigned int            samplingFreqInHz;
unsigned int            pwm_reload_val;
unsigned int            sampling_reload_val;
unsigned int            zeroErrorCalcSamples;
unsigned int            Sirhowlongisit, Thatsarpqdythink;
unsigned int            save_this, save_that;
unsigned int            this_dividend, that_dividend;
float                   gain_const;
float                   flotsom, jetsom;
float                   george,jetson,harry,johnson;
volatile unsigned int   loop_cntr;
volatile float          accumulator;
volatile float          fnew_duty_actual;
volatile float          fnew_duty_limited;
volatile long           inew_duty_rounded;
volatile unsigned int   y_t;
volatile float          r_t;
volatile float          fnew_u_t_actual;
volatile float          fnew_u_t_limited;
volatile float          fnew_u_t_scaled;
volatile long           inew_u_t_rounded;
volatile unsigned int   u_t;
volatile float          e_t;
volatile float          e_tm1;
volatile float          e_t_minus_e_tm1;
volatile float          P, I, D, P_t, I_t, D_t;
volatile float          Kp;
volatile float          Kd;
volatile float          Ki;
volatile float          zero_psig_offset;
volatile unsigned char  adc1_flag;
volatile float          dt;
volatile float          e_t_times_dt;
volatile float          I_tm1;
volatile float          movavg;
volatile float          movavg_old;
volatile float          movavg_temp;
volatile float          new_in;
volatile float          L_movavg;
volatile float          envfollow;
volatile float          envfollow_old;
volatile float          filtered_y_t;
volatile float          pid_input_variable;
float                   temp1,temp2,temp3;
long unsigned int       ZeroPsigCnt;
float                   Slope;
float                   YInt;
float                   SPpsig;
float                   PIDInPSIG;
float                   PsigPerCnt;
float                   ErrPSIG;


/*******************************************************************************
 * Code
 ******************************************************************************/

int main(void)
{
    gain_const = 131072;
    adc1_flag = 0;


    /* Init. board hardware. */
    /* attach main clock divide to FLEXCOMM0 (debug console) */
    CLOCK_SetClkDiv(kCLOCK_DivFlexcom0Clk, 0u, false);
    CLOCK_SetClkDiv(kCLOCK_DivFlexcom0Clk, 1u, true);
    CLOCK_AttachClk(BOARD_DEBUG_UART_CLK_ATTACH);

    BOARD_InitPins();
    BOARD_BootClockPLL150M();
    BOARD_InitDebugConsole();

 

    ////////////////////////////////////////////////////////////////////////////
    // Take VREF module out of power down
    ////////////////////////////////////////////////////////////////////////////
    POWER_DisablePD(kPDRUNCFG_PD_VREF);


    ////////////////////////////////////////////////////////////////////////////
    // Program up the ADC
    ////////////////////////////////////////////////////////////////////////////
    CLOCK_EnableClock(kCLOCK_Adc1);				// Enable the bus clock to ADC, i.e. main_clk
    RESET_PeripheralReset(kADC1_RST_SHIFT_RSTn);		// Take ADC out of reset
    SYSCON->ADC1CLKSEL = 2;					// Selects FRO96 as ADCK
    SYSCON->ADC1CLKDIV = ((96/2)-1)<<0;				// Actual divider == DIV + 1. This is for 2 MSPS
    SYSCON->CLKUNLOCK = 0xffffffff;				// wHO ORDERED this mISHMOSH? Neil Birns?


    // Prepare to calibrate
    ADC1->CFG  |= 0xFF << pudly_shift;				// 0x80 is the reset value = (0x80)*4 ADCK cycles power-up delay
    ADC1->CFG  |= vdda_pin << refsel_shift;			// vrefp_pin is the reset value 
    ADC1->CFG  |= hipower << pwrsel_shift;			// lopower is the reset value
    ADC1->CFG  |= 1 << pwren_shift;				// Analog stays on
    SDK_DelayAtLeastUs(5, CLOCK_GetFreq(kCLOCK_BusClk));	// VREF and ADC startup time is 5 us as per data sheet
    ADC1->CTRL |= (0x7<<cal_avgs_shift) | (1<<adcen_shift);	// 128 conversions are averaged during calibrations


    // Associate TRIGGER[0] with COMMAND BUFFER[1]. Don't forget to enable hw triggers (1<<hw_trig_en_shift) later
    ADC1->TCTRL[0] |= 1<<tcmd_shift;


    // Configure COMMAND BUFFER[1]
    // Stupidly, CMD[0].CMDL and CMD[0].CMDH refer to COMMAND BUFFER 1, CMD[14].CMDL and CMD[14].CMDH refer to COMMAND BUFFER 15, as advertised in the RM. 
    // PLEASE COMPLAIN to the CEO of NXP, kurt.sievers@nxp.com (I have, and look where it got me).
    ADC1->CMD[0].CMDL |= (1<<altben_shift)            | (8<<altb_adch_shift);                      // altb enabled, B-side CH8 (P1.24 Pad #6 for LPC55s36)
    ADC1->CMD[0].CMDL |= (twelve_bit<<adc_mode_shift) | (single_b_only<<adc_ctype_shift);


    ////////////////////////////////////////////////////////////////////////////
    //
    // In order to use a pin that has an analog I/O (ADC, Comparator, and so on) option for that purpose, select GPIO function (FUNC
    // bit set to 0 in IOCON Control register) and the corresponding DIR bit set to 0 (See GPIO); disable the digital pin function (DIGIMODE bit
    // set to 0) and enable the analog switches, as appopriate, if they exist (ASW bits set to 1).
    // In analog mode, the MODE field should be set to 0. The INVERT, FILTEROFF, and OD settings have no effect. For an
    // unconnected pin that has an analog signal, the ASW bit(s) should be set to 0 (analog I/O disabled), DIGIMODE bit should be set to
    // 0 (digital input disabled)
    //
    ////////////////////////////////////////////////////////////////////////////

    // Program up the pads being used for ADC analog inputz:
    // digimode=0, highspeed(slew)=0, func=GPIO (0 that is), 
    // mode=0 (pullups and panties-down disabled), invert=0, 
    // OD = 0.
    IOCON->PIO[1][24] = 1<<analog_switch0_shift;		// P1.24 (Pad 6 wITH analog switch0 only), enabled for use as ADC input (ADC1_1B if I recall)


    ////////////////////////////////////////////////////////////////////////////
    // Run ADC calibration
    ////////////////////////////////////////////////////////////////////////////
    CalADC1();

    ////////////////////////////////////////////////////////////////////////////
    // Enable Trig0 in the interrupt enable register.
    // Absolutely RETARDED that this is necessary in order for HW flags to 
    // function even for polling! But that's the truth, so don't forget it. 
    ////////////////////////////////////////////////////////////////////////////
    //ADC1->IE = 1<<16;                                           // Trig0 set to interrupt
    ADC1->IE = 1<<tcomp_ie_shift;                                 // Trig0 set to interrupt



    
    ////////////////////////////////////////////////////////////////////////////
    // 
    // Now, the PWM setup
    //
    ////////////////////////////////////////////////////////////////////////////

    // Firstly, in IOCON, program up the pads being used for PWM digital outputs 
    IOCON->PIO[1][20] = digenable | highspeed | func_pwm;       // N4a EVK J10[15]  P1.20  PWM0_A0
    IOCON->PIO[1][17] = digenable | highspeed | func_pwm;       //   "  "  J10[13]  P1.17  PWM0_B0
    IOCON->PIO[1][6]  = digenable | highspeed | func_pwm;       // N4a EVK J10[11]  P1.6   PWM0_A1
    IOCON->PIO[1][22] = digenable | highspeed | func_pwm;       //   "  "  J10[9]   P1.22  PWM0_B1
    IOCON->PIO[1][8]  = digenable | highspeed | func_pwm;       // N4a EVK J10[7]   P1.08  PWM0_A2
    IOCON->PIO[1][4]  = digenable | highspeed | func_pwm;       //   "  "  J10[5]   P1.04  PWM0_B2
    
    ////////////////////////////////////////////////////////////////////////////
    // The PWM itself
    ////////////////////////////////////////////////////////////////////////////
    CLOCK_EnableClock(kCLOCK_Pwm0);
    RESET_PeripheralReset(kPWM0_RST_SHIFT_RSTn);
    
    // Enable submodule clocks [3:0]
    SYSCON->PWM0SUBCTL |= 0xF;


    //
    // Make some calculations, and initialize variables for later
    // 
#define deadTimeInNSec 650
#define zeroErrorCalcSeconds 1
    pwmSourceClockInHz  = PWM_SRC_CLK_FREQ;
    pwmReloadFreqInHz   = 1000;
    samplingFreqInHz    = 1000;
    pwmSourceClockPrescaler = 1<<prescale16;
    PWMCLKInHz          = pwmSourceClockInHz / pwmSourceClockPrescaler;
    pwm_reload_val      = (PWMCLKInHz / pwmReloadFreqInHz);
    sampling_reload_val = (PWMCLKInHz / samplingFreqInHz);
    deadTimeVal         = ((uint64_t)pwmSourceClockInHz * deadTimeInNSec) / 1000000000;
    zeroErrorCalcSamples= samplingFreqInHz * zeroErrorCalcSeconds;
    // Next is delta(t) for the pidal(), not anything to do with dead time! Sorry about that.
    dt                  = (1/(float)sampling_reload_val);

    ////////////////////////////////////////////////////////////////////////////
    // First, we setup the waveform generators SM[0], SM[1], and SM[2]. 
    // In this application all three phases are identical, and all three operate
    // in complementary mode.
    ////////////////////////////////////////////////////////////////////////////
    for (uint8_t indx=0; indx!=3; indx++) {
       PWM0->SM[indx].CTRL2      |= ipbusclk         << clk_sel_shift;
       PWM0->SM[indx].CTRL2      |= 0                << indep_shift;
       PWM0->SM[indx].CTRL2      |= local_sync       << init_sel_shift;
       PWM0->SM[indx].CTRL2      |= 1                << dbgen_shift;
       PWM0->SM[indx].CTRL       |= prescale16       << prsc_shift;
       PWM0->SM[indx].CTRL       |= 1                << full_shift;
       PWM0->SM[indx].CTRL       |= gthan_or_eq_to   <<	compmode_shift;
     //PWM0->SM[indx].OCTRL      |= 1                << polb_shift;     // Not needed in complementary operation

       // Let the PWM waveform be edge-aligned.
       // Period determined by SM[indx].INIT, SM[indx].VAL1 (SM[indx].VAL0 not used).
       // (150,000,000 busclks/sec) / (16 busclks/pwmclk) = 9.375 MHz -> pwmclks/sec = 1,066.667 ns per pwmclk
       PWM0->SM[indx].INIT = 0;
       PWM0->SM[indx].VAL0 = 0;
       PWM0->SM[indx].VAL1 = pwm_reload_val;
       
       // VAL2,4 = INIT = turn on point. VAL3,5 = turn off point
       // Can we assume that if VAL3 = VAL2 the turn-off wins? Same with 5 and 4? Gosh-darn, I really hope so.
       // Ask the tech. writer.
       PWM0->SM[indx].VAL2 = 0;
       PWM0->SM[indx].VAL3 = 0;
       PWM0->SM[indx].VAL4 = 0;
       PWM0->SM[indx].VAL5 = 0;
       
       // Write the dead time registers
       PWM0->SM[indx].DTCNT0 = deadTimeVal;
       PWM0->SM[indx].DTCNT1 = deadTimeVal;
       
       // PWM0 SM[indx] PWMA output unmasked from fault inputs (impertenantly, an array[1], so must be spelled like it (Stupis Tomato strikes again!)).
       PWM0->SM[indx].DISMAP[0] &= 0xF000;
    };


#define SAMP 3
    ////////////////////////////////////////////////////////////////////////
    // PWM0 Sub Module [3] is for generating triggers for the ADC.
    // Let the SM[3] waVEFORM ALSO BE EDGE ALIGNED, SaME everything as SM[0, 1, 2].
    // The rising edge of the trigger signal must be at least two ADCKs in duration in order not to be
    // missed by the ADCK synchronizer circuit. Therefore we program the SM3 PWMA signal to go
    // high at the reload point of the SM3 count, and low the half-way point of the SM3 count (50% duty cycle).
    // This will maximize the setup and hold times regardless of the freq. relationship of BusClk to ADCK.
    // Of course, if you still violate this, you have bigger fish to fry in your system.
    // We then use the SM3 PWMA signal as the SM3_trig0 signal.
    ////////////////////////////////////////////////////////////////////////
    PWM0->SM[SAMP].CTRL2     |= ipbusclk        << clk_sel_shift;
    PWM0->SM[SAMP].CTRL2     |= 1               << indep_shift;
    PWM0->SM[SAMP].CTRL2     |= local_sync      << init_sel_shift;
    PWM0->SM[SAMP].CTRL2     |= 1               << dbgen_shift;
    PWM0->SM[SAMP].CTRL      |= prescale16      << prsc_shift;
    PWM0->SM[SAMP].CTRL      |= 1               << full_shift;
    PWM0->SM[SAMP].CTRL      |= gthan_or_eq_to  << compmode_shift;
    PWM0->SM[SAMP].DISMAP[0] &= 0xF000;
    
    PWM0->SM[SAMP].INIT = 0;
    PWM0->SM[SAMP].VAL0 = 0;
    PWM0->SM[SAMP].VAL1 = sampling_reload_val;
    PWM0->SM[SAMP].VAL2 = 0;                                    // Trigger output high
    PWM0->SM[SAMP].VAL3 = sampling_reload_val/2;                // Trigger output low ... make duty cycle 1/2 to maximize setup and hold

    // Route the SM[3] PWMA output to the SM[3] PWM_MUX_TRIG0 port.
    PWM0->SM[SAMP].TCTRL = 1<<pwaot0_shift;

    // PWM0 all outputs enabled
    PWM0->OUTEN  |= 0xFFF;

    // Use PWM23 to feed the complementary pairs 
    PWM0->MCTRL  &= 0x0FFF;


    // Program up the pee-INMUX module to connect the PWM triggers to the ADC trigger inputs.
    // If anybody cares, they can shut off clocks to the pee-INMUX module after setting the muxes.
    // This anybody doesn't care very much. Left as an exercise pour le corps de l'etudiante.
    CLOCK_EnableClock(kCLOCK_InputMux);
    RESET_PeripheralReset(kMUX_RST_SHIFT_RSTn);
    INPUTMUX->ADC1_TRIG[0] = pwm0_sm3_mux_trig0;
    
    // Ignite the PWM
    PWM0->MCTRL   |= 0xF   << ldok_shift;
    PWM0->MCTRL   |= 0xF   << run_shift;
    
    
    // Enable ADC1 HW triggers, for God's sake! (No, Zeljko, not the Japanese rice liquor)
    ADC1->TCTRL[0] |= 1    << hw_trig_en_shift;

    ////////////////////////////////////////////////////////////////////////////
    //
    // Find the 0 PSIG offset of the pressure transducer as a 12 bit positive integer
    // This function should only be called when the PSIG is zero.
    // Since the pressure transducer generates 0.004 Amps at 0 PSIG, this is the 
    // calibration step for the main loop calculations.
    //
    ////////////////////////////////////////////////////////////////////////////
    Caltrans();

    // Some initial values
#define PSIGMax  PSIGmaxval
#define ADCMax   ADCmaxval
#define SETPoint 20.0    // In PSIG
    ZeroPsigCnt = lroundf((float)accumulator/(float)zeroErrorCalcSamples);
    Slope = PSIGMax/(ADCMax-ZeroPsigCnt);
    YInt = -(Slope*ZeroPsigCnt);
    PsigPerCnt = Slope;
    SPpsig = SETPoint;
    r_t = (SPpsig-YInt)*(1/Slope);                              // The setpoint r_t in counts based on a specified PSIG between 0 and 100 : x=(y-b)/m
    loop_cntr = 0;
    adc1_flag = 0;
#define minduty 0.0                                             // E.g., to limit the RAMP_UPDOWN testmode to between 4.5% - 95.5% duty cycle, use #define minduty 4.5
#define maxduty 100.0 - minduty 
    minsp_ramp_val = (unsigned int)((pwm_reload_val * minduty)/100.0);
    maxsp_ramp_val = (unsigned int)((pwm_reload_val * maxduty)/100.0);
    incr = 1;
    sp_ramp_val = 0;
    e_t = 0.0;
    e_tm1 = 0.0;
    P = 0.0;
    I = 0.0;
    D = 0.0;
    I_tm1 = 0.0;
    fnew_duty_actual = 0.0;
    inew_duty_rounded = 0;
    movavg_old = zero_psig_offset;
    envfollow_old = zero_psig_offset;
    L_movavg = L_MOVAVG;
    filtered_y_t = zero_psig_offset;
    pid_input_variable = zero_psig_offset;

    ///////////////////////////////////////////////////////////////////////////
    // Print the column headers to the console or terminal
    ///////////////////////////////////////////////////////////////////////////
    PRINTF("\tSP(psig)\tOutput(psig)\tError(psig)\tDuty Cycle\n\r");
    PRINTF("\t--------\t------------\t-----------\t----------\n\r");

    // Enable ADC interrupt which will happen at the sampling frequency 'samplingFreqInHz'
    EnableIRQ(ADC1_IRQn);    // Enable ADC IRQ.

    ////////////////////////////////////////////////////////////////////////////
    // The Final SoLOOPtion! (scary music here)
    ////////////////////////////////////////////////////////////////////////////
    while (2) {

       // Wait for the next output sample to be available
       while (!adc1_flag);
       
#if (!RAMP_UPDOWN)
       // RAMPUP_DOWN == 0 is the closed loop normal mode of operation
       // User can change the setpoint variable SPpsig at any time, so
       // recalculate the r_t variable on every iteration.
       // The setpoint r_t in counts, based on a specified PSIG between
       // 0 and 100, is calculated using the line equation x=(y-b)/m
       r_t = (SPpsig-YInt)*(1/Slope);
       
       // Plant output y_t = the actual sampled value, read it in from ADC
       y_t = (ADC1->RESFIFO[0]&0xFFFF)>>3; // Format for 12 bits resolution

       // Apply a time domain digital fiter to the new sample.
       // Choose one of two filter types, or none, in mc_dcvfd.h
#if (PFILT)
       pfilt();
       pid_input_variable = filtered_y_t;
#else
       pid_input_variable = (float)y_t;
#endif
       // Recalculate the loop variables, producing the new u(t)
       pidal();

#if (ENABLE_SERIAL_OUT == 1)
       // SPpsig = (Slope*r_t) + YInt; // The line equation in the form y = mx + b
       PIDInPSIG = (Slope*pid_input_variable) + YInt;
       ErrPSIG = (r_t - pid_input_variable)*PsigPerCnt;

       PRINTF("\t%d       \t%d          \t%d          \t%d%%\r", \
          (int)SPpsig, \
          (int)PIDInPSIG, \
          (int)(ErrPSIG), \
          (inew_duty_rounded) \
       );
#endif
       // Deposit new duty-cycle into PWM0->SM[WAVE]
       PWM0->SM[0].VAL3 = u_t;
       PWM0->SM[1].VAL3 = u_t;
       PWM0->SM[2].VAL3 = u_t;
       PWM0->MCTRL |= 0xF<<ldok_shift;

#else
       // RAMPUP_DOWN == 1 is the open-loop test mode to make sure the motor
       // driver board doesn't explode when the PID controller goes to
       // maximum warp speed with feedback.
       PWM0->SM[0].VAL3 = sp_ramp_val;
       PWM0->SM[1].VAL3 = sp_ramp_val;
       PWM0->SM[2].VAL3 = sp_ramp_val;
       PWM0->MCTRL |= 0xF<<ldok_shift;
#if (ENABLE_SERIAL_OUT == 1)
       temp1 = (float)(sp_ramp_val)/(float)(pwm_reload_val) * (100.0);
       temp2 = modff(temp1,&temp3);
       PRINTF("\t\t\t\t\t\t\t%4d.%d%%\r", (unsigned int)temp3, (unsigned int)((temp2*10)));
#endif
       sp_ramp_val += incr;
       if (sp_ramp_val == maxsp_ramp_val+1) {
       	  incr = -1;
       	  sp_ramp_val--;
       }
       else
       if (sp_ramp_val == 0) {
          incr = 1;
       }
#endif
       adc1_flag = 0;

    };  // end of while(2) (aka The Final SoLOOPtion)


  // Don't EVER let me catch you down here again, BOY!
  while(1);

}; // end of int main(void)

