/*
 * mc_dcvfd.h
 *
 */

#ifndef MC_DCVFD_H_
#define MC_DCVFD_H_


// IOCON and IOCTRL
#define func_gpio		(0<<0)
#define func_pwm		(11<<0)
#define highspeed		(1<<6)
#define digenable		(1<<8)



// PWM 
#define PWM_SRC_CLK_FREQ	CLOCK_GetFreq(kCLOCK_BusClk)
// CTRL2 register
#define ipbusclk		0
#define local_sync		0x0
#define clk_sel_shift		0
#define indep_shift		13
#define init_sel_shift		8
#define dbgen_shift		15
// CTRL register
#define prescale128		0x7
#define prescale64		0x6
#define prescale32		0x5
#define prescale16		0x4
#define prescale8		0x3
#define prescale4		0x2
#define prescale2		0x1
#define prescale1		0x0
#define divby128		(1<<prescale128)
#define divby64			(1<<prescale64)
#define divby32			(1<<prescale32)
#define divby16			(1<<prescale16)
#define divby8			(1<<prescale8)
#define divby4			(1<<prescale4)
#define divby2			(1<<prescale2)
#define divby1			(1<<prescale1)
#define eq_to			0
#define gthan_or_eq_to		1
#define prsc_shift		0x4
#define full_shift		10
#define half_shift		11
#define compmode_shift		7
// OCTRL register 
#define pola_shift		10
#define polb_shift		9
#define polx_shift		8
// OUTEN register crap
#define pwma_en_shift		8
#define pwmb_en_shift		4
#define pwmx_en_shift		0
// TCTRL register merde
#define pwaot0_shift		15
#define pwaot1_shift		14
// MCTRL register crepe
#define ipol_shift		12
#define run_shift		8
#define cldok_shift		4
#define ldok_shift		0



// ADC crepe suzette
#define halt_shift		30
#define reset_shift		29
#define pudly_shift		16
#define refsel_shift		6
#define vrefp_pin		0
#define vref_out_pin		1
#define vdda_pin		2
#define pwrsel_shift		4
#define hipower			1
#define lowpower		0
#define adch_shift		0
#define altb_adch_shift		16
#define altben_shift		21
#define calofs_shift		4
#define adcen_shift		0
#define cal_req_shift		3
#define cal_rdy_shift		10
#define cal_avgs_shift		16
#define pwren_shift		28
#define gcc_rdy_shift		24
#define adc_mode_shift		7
#define sixteen_bit		1
#define twelve_bit		0
#define adc_ctype_shift		5
#define single_a_only		0x0
#define single_b_only		0x1
#define differential_ab		0x2
#define dual_single_ab		0x3
#define hw_trig_en_shift	0
#define tcmd_shift		24
#define tcomp_int_shift		9
#define tcomp_flag_shift	16
#define tcomp_ie_shift		16
#define analog_switch0_shift	10
#define analog_switch1_shift	11



// Pee-inmux crud
#define PWM0_SM0_MUX_TRIG0	0x18
#define PWM0_SM0_MUX_TRIG1	0x19
#define pwm0_sm1_mux_trig0	0x1A
#define PWM0_SM1_MUX_TRIG1	0x1B
#define PWM0_SM2_MUX_TRIG0	0x1C
#define PWM0_SM2_MUX_TRIG1	0x1D
#define pwm0_sm3_mux_trig0	0x1E
#define PWM0_SM3_MUX_TRIG1	0x1F
#define PWM1_SM0_MUX_TRIG0	0x20
#define PWM1_SM0_MUX_TRIG1	0x21
#define PWM1_SM1_MUX_TRIG0	0x22
#define PWM1_SM1_MUX_TRIG1	0x23
#define PWM1_SM2_MUX_TRIG0	0x24
#define PWM1_SM2_MUX_TRIG1	0x25
#define PWM1_SM3_MUX_TRIG0	0x26
#define PWM1_SM3_MUX_TRIG1	0x27



// Crap-for-this-App crap
#define ADCmaxval		4095.0     // For 12 bits
#define PSIGmaxval		100.0
#define ENABLE_SERIAL_OUT	1
#define RAMP_UPDOWN		1
#define PFILT			1
#define FILT_MOVAVG		1
#define FILT_ENVFOLLOW		0
#define L_MOVAVG		32.0
#define EnIntCntr		0



// Function Forward Declarations
void CalADC1(void);
void Caltrans(void);
void pfilt(void);
void pidal(void);
void Hell(void);
void delay(unsigned int cnt);
void ADC0_IRQHandler(void);
void ADC1_IRQHandler(void);


#endif /* MC_DCVFD_H_ */
