/** @file
 * Copyright (c) 2019-2021, Arm Limited or its affiliates. All rights reserved.
 * SPDX-License-Identifier : Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**/

#ifndef _PAL_CRYPTO_INTF_H_
#define _PAL_CRYPTO_INTF_H_

#include "pal_common.h"

enum crypto_function_code {
    PAL_CRYPTO_AEAD_ABORT                        = 0x1,
    PAL_CRYPTO_AEAD_DECRYPT,
    PAL_CRYPTO_AEAD_DECRYPT_SETUP,
    PAL_CRYPTO_AEAD_ENCRYPT,
    PAL_CRYPTO_AEAD_ENCRYPT_SETUP,
    PAL_CRYPTO_AEAD_FINISH,
    PAL_CRYPTO_AEAD_GENERATE_NONCE,
    PAL_CRYPTO_AEAD_OPERATION_INIT,
    PAL_CRYPTO_AEAD_SET_LENGTHS,
    PAL_CRYPTO_AEAD_SET_NONCE,
    PAL_CRYPTO_AEAD_UPDATE,
    PAL_CRYPTO_AEAD_UPDATE_AD,
    PAL_CRYPTO_AEAD_VERIFY,
    PAL_CRYPTO_ASYMMETRIC_DECRYPT,
    PAL_CRYPTO_ASYMMETRIC_ENCRYPT,
    PAL_CRYPTO_CIPHER_ABORT,
    PAL_CRYPTO_CIPHER_DECRYPT,
    PAL_CRYPTO_CIPHER_DECRYPT_SETUP,
    PAL_CRYPTO_CIPHER_ENCRYPT,
    PAL_CRYPTO_CIPHER_ENCRYPT_SETUP,
    PAL_CRYPTO_CIPHER_FINISH,
    PAL_CRYPTO_CIPHER_GENERATE_IV,
    PAL_CRYPTO_CIPHER_OPERATION_INIT,
    PAL_CRYPTO_CIPHER_SET_IV,
    PAL_CRYPTO_CIPHER_UPDATE,
    PAL_CRYPTO_COPY_KEY,
    PAL_CRYPTO_INIT,
    PAL_CRYPTO_DESTROY_KEY,
    PAL_CRYPTO_EXPORT_KEY,
    PAL_CRYPTO_EXPORT_PUBLIC_KEY,
    PAL_CRYPTO_GENERATE_KEY,
    PAL_CRYPTO_GENERATE_RANDOM,
    PAL_CRYPTO_GET_KEY_ALGORITHM,
    PAL_CRYPTO_GET_KEY_ATTRIBUTES,
    PAL_CRYPTO_GET_KEY_BITS,
    PAL_CRYPTO_GET_KEY_ID,
    PAL_CRYPTO_GET_KEY_LIFETIME,
    PAL_CRYPTO_GET_KEY_TYPE,
    PAL_CRYPTO_GET_KEY_USAGE_FLAGS,
    PAL_CRYPTO_HASH_ABORT,
    PAL_CRYPTO_HASH_CLONE,
    PAL_CRYPTO_HASH_COMPARE,
    PAL_CRYPTO_HASH_COMPUTE,
    PAL_CRYPTO_HASH_FINISH,
    PAL_CRYPTO_HASH_OPERATION_INIT,
    PAL_CRYPTO_HASH_RESUME,
    PAL_CRYPTO_HASH_SETUP,
    PAL_CRYPTO_HASH_SUSPEND,
    PAL_CRYPTO_HASH_UPDATE,
    PAL_CRYPTO_HASH_VERIFY,
    PAL_CRYPTO_IMPORT_KEY,
    PAL_CRYPTO_KEY_ATTRIBUTES_INIT,
    PAL_CRYPTO_KEY_DERIVATION_ABORT,
    PAL_CRYPTO_KEY_DERIVATION_GET_CAPACITY,
    PAL_CRYPTO_KEY_DERIVATION_INPUT_BYTES,
    PAL_CRYPTO_KEY_DERIVATION_INPUT_KEY,
    PAL_CRYPTO_KEY_DERIVATION_KEY_AGREEMENT,
    PAL_CRYPTO_KEY_DERIVATION_OPERATION_INIT,
    PAL_CRYPTO_KEY_DERIVATION_OUTPUT_BYTES,
    PAL_CRYPTO_KEY_DERIVATION_OUTPUT_KEY,
    PAL_CRYPTO_KEY_DERIVATION_SET_CAPACITY,
    PAL_CRYPTO_KEY_DERIVATION_SETUP,
    PAL_CRYPTO_MAC_ABORT,
    PAL_CRYPTO_MAC_COMPUTE,
    PAL_CRYPTO_MAC_OPERATION_INIT,
    PAL_CRYPTO_MAC_SIGN_FINISH,
    PAL_CRYPTO_MAC_SIGN_SETUP,
    PAL_CRYPTO_MAC_UPDATE,
    PAL_CRYPTO_MAC_VERIFY,
    PAL_CRYPTO_MAC_VERIFY_FINISH,
    PAL_CRYPTO_MAC_VERIFY_SETUP,
    PAL_CRYPTO_PURGE_KEY,
    PAL_CRYPTO_RAW_KEY_AGREEMENT,
    PAL_CRYPTO_RESET_KEY_ATTRIBUTES,
    PAL_CRYPTO_SET_KEY_ALGORITHM,
    PAL_CRYPTO_SET_KEY_BITS,
    PAL_CRYPTO_SET_KEY_ID,
    PAL_CRYPTO_SET_KEY_LIFETIME,
    PAL_CRYPTO_SET_KEY_TYPE,
    PAL_CRYPTO_SET_KEY_USAGE_FLAGS,
    PAL_CRYPTO_SIGN_HASH,
    PAL_CRYPTO_SIGN_MESSAGE,
    PAL_CRYPTO_VERIFY_HASH,
    PAL_CRYPTO_VERIFY_MESSAGE,
    PAL_CRYPTO_RESET                            = 0xF0,
    PAL_CRYPTO_FREE                             = 0xFE,
};

int32_t pal_crypto_function(int type, va_list valist);
#endif /* _PAL_CRYPTO_INTF_H_ */
