/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2022  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V6.32 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  NXP Semiconductors USA, Inc.  whose
registered  office  is  situated  at 411 E. Plumeria Drive, San  Jose,
CA 95134, USA  solely for  the  purposes  of  creating  libraries  for
NXPs M0, M3/M4 and  ARM7/9 processor-based  devices,  sublicensed  and
distributed under the terms and conditions of the NXP End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              NXP Semiconductors, 1109 McKay Dr, M/S 76, San Jose, CA 95131, USA
Licensed SEGGER software: emWin
License number:           GUI-00186
License model:            emWin License Agreement, dated August 20th 2011 and Amendment No. 1, dated October 17th 2017 and Amendment No. 2, dated December 18th 2018
Licensed platform:        NXP's ARM 7/9, Cortex-M0, M3, M4, M7, A7, M33
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2011-08-19 - 2023-09-03
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : GUI__BiDi2_Types_800.h
Purpose     : Bidi types according to Unicode V8.0.0

            ( !!! Basic  Multilingual  Plane Only !!! )

---------------------------END-OF-HEADER------------------------------
*/

#ifdef GUI__BIDI2

#ifndef   GUI_BIDI_SUPPORT_RANGE_0
  #define GUI_BIDI_SUPPORT_RANGE_0 1
#endif
#ifndef   GUI_BIDI_SUPPORT_RANGE_1
  #define GUI_BIDI_SUPPORT_RANGE_1 1
#endif
#ifndef   GUI_BIDI_SUPPORT_RANGE_2
  #define GUI_BIDI_SUPPORT_RANGE_2 1
#endif
#ifndef   GUI_BIDI_SUPPORT_RANGE_3
  #define GUI_BIDI_SUPPORT_RANGE_3 1
#endif
#ifndef   GUI_BIDI_SUPPORT_RANGE_4
  #define GUI_BIDI_SUPPORT_RANGE_4 1
#endif
#ifndef   GUI_BIDI_SUPPORT_RANGE_A
  #define GUI_BIDI_SUPPORT_RANGE_A 1
#endif
#ifndef   GUI_BIDI_SUPPORT_RANGE_D
  #define GUI_BIDI_SUPPORT_RANGE_D 1
#endif
#ifndef   GUI_BIDI_SUPPORT_RANGE_F
  #define GUI_BIDI_SUPPORT_RANGE_F 1
#endif

#if (GUI_BIDI_SUPPORT_RANGE_0 == 1)

//  CodePoint
//  |       BiDi category
//  |       |               Unicode name
//  |       |               |
//  V       V               V
  { 0x0000, BIDI_BN  },  // <control>
  { 0x0001, BIDI_BN  },  // <control>
  { 0x0002, BIDI_BN  },  // <control>
  { 0x0003, BIDI_BN  },  // <control>
  { 0x0004, BIDI_BN  },  // <control>
  { 0x0005, BIDI_BN  },  // <control>
  { 0x0006, BIDI_BN  },  // <control>
  { 0x0007, BIDI_BN  },  // <control>
  { 0x0008, BIDI_BN  },  // <control>
  { 0x0009, BIDI_S   },  // <control>
  { 0x000A, BIDI_B   },  // <control>
  { 0x000B, BIDI_S   },  // <control>
  { 0x000C, BIDI_WS  },  // <control>
  { 0x000D, BIDI_B   },  // <control>
  { 0x000E, BIDI_BN  },  // <control>
  { 0x000F, BIDI_BN  },  // <control>
  { 0x0010, BIDI_BN  },  // <control>
  { 0x0011, BIDI_BN  },  // <control>
  { 0x0012, BIDI_BN  },  // <control>
  { 0x0013, BIDI_BN  },  // <control>
  { 0x0014, BIDI_BN  },  // <control>
  { 0x0015, BIDI_BN  },  // <control>
  { 0x0016, BIDI_BN  },  // <control>
  { 0x0017, BIDI_BN  },  // <control>
  { 0x0018, BIDI_BN  },  // <control>
  { 0x0019, BIDI_BN  },  // <control>
  { 0x001A, BIDI_BN  },  // <control>
  { 0x001B, BIDI_BN  },  // <control>
  { 0x001C, BIDI_B   },  // <control>
  { 0x001D, BIDI_B   },  // <control>
  { 0x001E, BIDI_B   },  // <control>
  { 0x001F, BIDI_S   },  // <control>
  { 0x0020, BIDI_WS  },  // SPACE
  { 0x0021, BIDI_ON  },  // EXCLAMATION MARK
  { 0x0022, BIDI_ON  },  // QUOTATION MARK
  { 0x0023, BIDI_ET  },  // NUMBER SIGN
  { 0x0024, BIDI_ET  },  // DOLLAR SIGN
  { 0x0025, BIDI_ET  },  // PERCENT SIGN
  { 0x0026, BIDI_ON  },  // AMPERSAND
  { 0x0027, BIDI_ON  },  // APOSTROPHE
  { 0x0028, BIDI_ON  },  // LEFT PARENTHESIS
  { 0x0029, BIDI_ON  },  // RIGHT PARENTHESIS
  { 0x002A, BIDI_ON  },  // ASTERISK
  { 0x002B, BIDI_ES  },  // PLUS SIGN
  { 0x002C, BIDI_CS  },  // COMMA
  { 0x002D, BIDI_ES  },  // HYPHEN-MINUS
  { 0x002E, BIDI_CS  },  // FULL STOP
  { 0x002F, BIDI_CS  },  // SOLIDUS
  { 0x0030, BIDI_EN  },  // DIGIT ZERO
  { 0x0031, BIDI_EN  },  // DIGIT ONE
  { 0x0032, BIDI_EN  },  // DIGIT TWO
  { 0x0033, BIDI_EN  },  // DIGIT THREE
  { 0x0034, BIDI_EN  },  // DIGIT FOUR
  { 0x0035, BIDI_EN  },  // DIGIT FIVE
  { 0x0036, BIDI_EN  },  // DIGIT SIX
  { 0x0037, BIDI_EN  },  // DIGIT SEVEN
  { 0x0038, BIDI_EN  },  // DIGIT EIGHT
  { 0x0039, BIDI_EN  },  // DIGIT NINE
  { 0x003A, BIDI_CS  },  // COLON
  { 0x003B, BIDI_ON  },  // SEMICOLON
  { 0x003C, BIDI_ON  },  // LESS-THAN SIGN
  { 0x003D, BIDI_ON  },  // EQUALS SIGN
  { 0x003E, BIDI_ON  },  // GREATER-THAN SIGN
  { 0x003F, BIDI_ON  },  // QUESTION MARK
  { 0x0040, BIDI_ON  },  // COMMERCIAL AT
  { 0x0041, BIDI_L   },  // LATIN CAPITAL LETTER A
  { 0x0042, BIDI_L   },  // LATIN CAPITAL LETTER B
  { 0x0043, BIDI_L   },  // LATIN CAPITAL LETTER C
  { 0x0044, BIDI_L   },  // LATIN CAPITAL LETTER D
  { 0x0045, BIDI_L   },  // LATIN CAPITAL LETTER E
  { 0x0046, BIDI_L   },  // LATIN CAPITAL LETTER F
  { 0x0047, BIDI_L   },  // LATIN CAPITAL LETTER G
  { 0x0048, BIDI_L   },  // LATIN CAPITAL LETTER H
  { 0x0049, BIDI_L   },  // LATIN CAPITAL LETTER I
  { 0x004A, BIDI_L   },  // LATIN CAPITAL LETTER J
  { 0x004B, BIDI_L   },  // LATIN CAPITAL LETTER K
  { 0x004C, BIDI_L   },  // LATIN CAPITAL LETTER L
  { 0x004D, BIDI_L   },  // LATIN CAPITAL LETTER M
  { 0x004E, BIDI_L   },  // LATIN CAPITAL LETTER N
  { 0x004F, BIDI_L   },  // LATIN CAPITAL LETTER O
  { 0x0050, BIDI_L   },  // LATIN CAPITAL LETTER P
  { 0x0051, BIDI_L   },  // LATIN CAPITAL LETTER Q
  { 0x0052, BIDI_L   },  // LATIN CAPITAL LETTER R
  { 0x0053, BIDI_L   },  // LATIN CAPITAL LETTER S
  { 0x0054, BIDI_L   },  // LATIN CAPITAL LETTER T
  { 0x0055, BIDI_L   },  // LATIN CAPITAL LETTER U
  { 0x0056, BIDI_L   },  // LATIN CAPITAL LETTER V
  { 0x0057, BIDI_L   },  // LATIN CAPITAL LETTER W
  { 0x0058, BIDI_L   },  // LATIN CAPITAL LETTER X
  { 0x0059, BIDI_L   },  // LATIN CAPITAL LETTER Y
  { 0x005A, BIDI_L   },  // LATIN CAPITAL LETTER Z
  { 0x005B, BIDI_ON  },  // LEFT SQUARE BRACKET
  { 0x005C, BIDI_ON  },  // REVERSE SOLIDUS
  { 0x005D, BIDI_ON  },  // RIGHT SQUARE BRACKET
  { 0x005E, BIDI_ON  },  // CIRCUMFLEX ACCENT
  { 0x005F, BIDI_ON  },  // LOW LINE
  { 0x0060, BIDI_ON  },  // GRAVE ACCENT
  { 0x0061, BIDI_L   },  // LATIN SMALL LETTER A
  { 0x0062, BIDI_L   },  // LATIN SMALL LETTER B
  { 0x0063, BIDI_L   },  // LATIN SMALL LETTER C
  { 0x0064, BIDI_L   },  // LATIN SMALL LETTER D
  { 0x0065, BIDI_L   },  // LATIN SMALL LETTER E
  { 0x0066, BIDI_L   },  // LATIN SMALL LETTER F
  { 0x0067, BIDI_L   },  // LATIN SMALL LETTER G
  { 0x0068, BIDI_L   },  // LATIN SMALL LETTER H
  { 0x0069, BIDI_L   },  // LATIN SMALL LETTER I
  { 0x006A, BIDI_L   },  // LATIN SMALL LETTER J
  { 0x006B, BIDI_L   },  // LATIN SMALL LETTER K
  { 0x006C, BIDI_L   },  // LATIN SMALL LETTER L
  { 0x006D, BIDI_L   },  // LATIN SMALL LETTER M
  { 0x006E, BIDI_L   },  // LATIN SMALL LETTER N
  { 0x006F, BIDI_L   },  // LATIN SMALL LETTER O
  { 0x0070, BIDI_L   },  // LATIN SMALL LETTER P
  { 0x0071, BIDI_L   },  // LATIN SMALL LETTER Q
  { 0x0072, BIDI_L   },  // LATIN SMALL LETTER R
  { 0x0073, BIDI_L   },  // LATIN SMALL LETTER S
  { 0x0074, BIDI_L   },  // LATIN SMALL LETTER T
  { 0x0075, BIDI_L   },  // LATIN SMALL LETTER U
  { 0x0076, BIDI_L   },  // LATIN SMALL LETTER V
  { 0x0077, BIDI_L   },  // LATIN SMALL LETTER W
  { 0x0078, BIDI_L   },  // LATIN SMALL LETTER X
  { 0x0079, BIDI_L   },  // LATIN SMALL LETTER Y
  { 0x007A, BIDI_L   },  // LATIN SMALL LETTER Z
  { 0x007B, BIDI_ON  },  // LEFT CURLY BRACKET
  { 0x007C, BIDI_ON  },  // VERTICAL LINE
  { 0x007D, BIDI_ON  },  // RIGHT CURLY BRACKET
  { 0x007E, BIDI_ON  },  // TILDE
  { 0x007F, BIDI_BN  },  // <control>
  { 0x0080, BIDI_BN  },  // <control>
  { 0x0081, BIDI_BN  },  // <control>
  { 0x0082, BIDI_BN  },  // <control>
  { 0x0083, BIDI_BN  },  // <control>
  { 0x0084, BIDI_BN  },  // <control>
  { 0x0085, BIDI_B   },  // <control>
  { 0x0086, BIDI_BN  },  // <control>
  { 0x0087, BIDI_BN  },  // <control>
  { 0x0088, BIDI_BN  },  // <control>
  { 0x0089, BIDI_BN  },  // <control>
  { 0x008A, BIDI_BN  },  // <control>
  { 0x008B, BIDI_BN  },  // <control>
  { 0x008C, BIDI_BN  },  // <control>
  { 0x008D, BIDI_BN  },  // <control>
  { 0x008E, BIDI_BN  },  // <control>
  { 0x008F, BIDI_BN  },  // <control>
  { 0x0090, BIDI_BN  },  // <control>
  { 0x0091, BIDI_BN  },  // <control>
  { 0x0092, BIDI_BN  },  // <control>
  { 0x0093, BIDI_BN  },  // <control>
  { 0x0094, BIDI_BN  },  // <control>
  { 0x0095, BIDI_BN  },  // <control>
  { 0x0096, BIDI_BN  },  // <control>
  { 0x0097, BIDI_BN  },  // <control>
  { 0x0098, BIDI_BN  },  // <control>
  { 0x0099, BIDI_BN  },  // <control>
  { 0x009A, BIDI_BN  },  // <control>
  { 0x009B, BIDI_BN  },  // <control>
  { 0x009C, BIDI_BN  },  // <control>
  { 0x009D, BIDI_BN  },  // <control>
  { 0x009E, BIDI_BN  },  // <control>
  { 0x009F, BIDI_BN  },  // <control>
  { 0x00A0, BIDI_CS  },  // NO-BREAK SPACE
  { 0x00A1, BIDI_ON  },  // INVERTED EXCLAMATION MARK
  { 0x00A2, BIDI_ET  },  // CENT SIGN
  { 0x00A3, BIDI_ET  },  // POUND SIGN
  { 0x00A4, BIDI_ET  },  // CURRENCY SIGN
  { 0x00A5, BIDI_ET  },  // YEN SIGN
  { 0x00A6, BIDI_ON  },  // BROKEN BAR
  { 0x00A7, BIDI_ON  },  // SECTION SIGN
  { 0x00A8, BIDI_ON  },  // DIAERESIS
  { 0x00A9, BIDI_ON  },  // COPYRIGHT SIGN
  { 0x00AA, BIDI_L   },  // FEMININE ORDINAL INDICATOR
  { 0x00AB, BIDI_ON  },  // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
  { 0x00AC, BIDI_ON  },  // NOT SIGN
  { 0x00AD, BIDI_BN  },  // SOFT HYPHEN
  { 0x00AE, BIDI_ON  },  // REGISTERED SIGN
  { 0x00AF, BIDI_ON  },  // MACRON
  { 0x00B0, BIDI_ET  },  // DEGREE SIGN
  { 0x00B1, BIDI_ET  },  // PLUS-MINUS SIGN
  { 0x00B2, BIDI_EN  },  // SUPERSCRIPT TWO
  { 0x00B3, BIDI_EN  },  // SUPERSCRIPT THREE
  { 0x00B4, BIDI_ON  },  // ACUTE ACCENT
  { 0x00B5, BIDI_L   },  // MICRO SIGN
  { 0x00B6, BIDI_ON  },  // PILCROW SIGN
  { 0x00B7, BIDI_ON  },  // MIDDLE DOT
  { 0x00B8, BIDI_ON  },  // CEDILLA
  { 0x00B9, BIDI_EN  },  // SUPERSCRIPT ONE
  { 0x00BA, BIDI_L   },  // MASCULINE ORDINAL INDICATOR
  { 0x00BB, BIDI_ON  },  // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
  { 0x00BC, BIDI_ON  },  // VULGAR FRACTION ONE QUARTER
  { 0x00BD, BIDI_ON  },  // VULGAR FRACTION ONE HALF
  { 0x00BE, BIDI_ON  },  // VULGAR FRACTION THREE QUARTERS
  { 0x00BF, BIDI_ON  },  // INVERTED QUESTION MARK
  { 0x00C0, BIDI_L   },  // LATIN CAPITAL LETTER A WITH GRAVE
  { 0x00C1, BIDI_L   },  // LATIN CAPITAL LETTER A WITH ACUTE
  { 0x00C2, BIDI_L   },  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
  { 0x00C3, BIDI_L   },  // LATIN CAPITAL LETTER A WITH TILDE
  { 0x00C4, BIDI_L   },  // LATIN CAPITAL LETTER A WITH DIAERESIS
  { 0x00C5, BIDI_L   },  // LATIN CAPITAL LETTER A WITH RING ABOVE
  { 0x00C6, BIDI_L   },  // LATIN CAPITAL LETTER AE
  { 0x00C7, BIDI_L   },  // LATIN CAPITAL LETTER C WITH CEDILLA
  { 0x00C8, BIDI_L   },  // LATIN CAPITAL LETTER E WITH GRAVE
  { 0x00C9, BIDI_L   },  // LATIN CAPITAL LETTER E WITH ACUTE
  { 0x00CA, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
  { 0x00CB, BIDI_L   },  // LATIN CAPITAL LETTER E WITH DIAERESIS
  { 0x00CC, BIDI_L   },  // LATIN CAPITAL LETTER I WITH GRAVE
  { 0x00CD, BIDI_L   },  // LATIN CAPITAL LETTER I WITH ACUTE
  { 0x00CE, BIDI_L   },  // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
  { 0x00CF, BIDI_L   },  // LATIN CAPITAL LETTER I WITH DIAERESIS
  { 0x00D0, BIDI_L   },  // LATIN CAPITAL LETTER ETH
  { 0x00D1, BIDI_L   },  // LATIN CAPITAL LETTER N WITH TILDE
  { 0x00D2, BIDI_L   },  // LATIN CAPITAL LETTER O WITH GRAVE
  { 0x00D3, BIDI_L   },  // LATIN CAPITAL LETTER O WITH ACUTE
  { 0x00D4, BIDI_L   },  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
  { 0x00D5, BIDI_L   },  // LATIN CAPITAL LETTER O WITH TILDE
  { 0x00D6, BIDI_L   },  // LATIN CAPITAL LETTER O WITH DIAERESIS
  { 0x00D7, BIDI_ON  },  // MULTIPLICATION SIGN
  { 0x00D8, BIDI_L   },  // LATIN CAPITAL LETTER O WITH STROKE
  { 0x00D9, BIDI_L   },  // LATIN CAPITAL LETTER U WITH GRAVE
  { 0x00DA, BIDI_L   },  // LATIN CAPITAL LETTER U WITH ACUTE
  { 0x00DB, BIDI_L   },  // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
  { 0x00DC, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DIAERESIS
  { 0x00DD, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH ACUTE
  { 0x00DE, BIDI_L   },  // LATIN CAPITAL LETTER THORN
  { 0x00DF, BIDI_L   },  // LATIN SMALL LETTER SHARP S
  { 0x00E0, BIDI_L   },  // LATIN SMALL LETTER A WITH GRAVE
  { 0x00E1, BIDI_L   },  // LATIN SMALL LETTER A WITH ACUTE
  { 0x00E2, BIDI_L   },  // LATIN SMALL LETTER A WITH CIRCUMFLEX
  { 0x00E3, BIDI_L   },  // LATIN SMALL LETTER A WITH TILDE
  { 0x00E4, BIDI_L   },  // LATIN SMALL LETTER A WITH DIAERESIS
  { 0x00E5, BIDI_L   },  // LATIN SMALL LETTER A WITH RING ABOVE
  { 0x00E6, BIDI_L   },  // LATIN SMALL LETTER AE
  { 0x00E7, BIDI_L   },  // LATIN SMALL LETTER C WITH CEDILLA
  { 0x00E8, BIDI_L   },  // LATIN SMALL LETTER E WITH GRAVE
  { 0x00E9, BIDI_L   },  // LATIN SMALL LETTER E WITH ACUTE
  { 0x00EA, BIDI_L   },  // LATIN SMALL LETTER E WITH CIRCUMFLEX
  { 0x00EB, BIDI_L   },  // LATIN SMALL LETTER E WITH DIAERESIS
  { 0x00EC, BIDI_L   },  // LATIN SMALL LETTER I WITH GRAVE
  { 0x00ED, BIDI_L   },  // LATIN SMALL LETTER I WITH ACUTE
  { 0x00EE, BIDI_L   },  // LATIN SMALL LETTER I WITH CIRCUMFLEX
  { 0x00EF, BIDI_L   },  // LATIN SMALL LETTER I WITH DIAERESIS
  { 0x00F0, BIDI_L   },  // LATIN SMALL LETTER ETH
  { 0x00F1, BIDI_L   },  // LATIN SMALL LETTER N WITH TILDE
  { 0x00F2, BIDI_L   },  // LATIN SMALL LETTER O WITH GRAVE
  { 0x00F3, BIDI_L   },  // LATIN SMALL LETTER O WITH ACUTE
  { 0x00F4, BIDI_L   },  // LATIN SMALL LETTER O WITH CIRCUMFLEX
  { 0x00F5, BIDI_L   },  // LATIN SMALL LETTER O WITH TILDE
  { 0x00F6, BIDI_L   },  // LATIN SMALL LETTER O WITH DIAERESIS
  { 0x00F7, BIDI_ON  },  // DIVISION SIGN
  { 0x00F8, BIDI_L   },  // LATIN SMALL LETTER O WITH STROKE
  { 0x00F9, BIDI_L   },  // LATIN SMALL LETTER U WITH GRAVE
  { 0x00FA, BIDI_L   },  // LATIN SMALL LETTER U WITH ACUTE
  { 0x00FB, BIDI_L   },  // LATIN SMALL LETTER U WITH CIRCUMFLEX
  { 0x00FC, BIDI_L   },  // LATIN SMALL LETTER U WITH DIAERESIS
  { 0x00FD, BIDI_L   },  // LATIN SMALL LETTER Y WITH ACUTE
  { 0x00FE, BIDI_L   },  // LATIN SMALL LETTER THORN
  { 0x00FF, BIDI_L   },  // LATIN SMALL LETTER Y WITH DIAERESIS
  { 0x0100, BIDI_L   },  // LATIN CAPITAL LETTER A WITH MACRON
  { 0x0101, BIDI_L   },  // LATIN SMALL LETTER A WITH MACRON
  { 0x0102, BIDI_L   },  // LATIN CAPITAL LETTER A WITH BREVE
  { 0x0103, BIDI_L   },  // LATIN SMALL LETTER A WITH BREVE
  { 0x0104, BIDI_L   },  // LATIN CAPITAL LETTER A WITH OGONEK
  { 0x0105, BIDI_L   },  // LATIN SMALL LETTER A WITH OGONEK
  { 0x0106, BIDI_L   },  // LATIN CAPITAL LETTER C WITH ACUTE
  { 0x0107, BIDI_L   },  // LATIN SMALL LETTER C WITH ACUTE
  { 0x0108, BIDI_L   },  // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
  { 0x0109, BIDI_L   },  // LATIN SMALL LETTER C WITH CIRCUMFLEX
  { 0x010A, BIDI_L   },  // LATIN CAPITAL LETTER C WITH DOT ABOVE
  { 0x010B, BIDI_L   },  // LATIN SMALL LETTER C WITH DOT ABOVE
  { 0x010C, BIDI_L   },  // LATIN CAPITAL LETTER C WITH CARON
  { 0x010D, BIDI_L   },  // LATIN SMALL LETTER C WITH CARON
  { 0x010E, BIDI_L   },  // LATIN CAPITAL LETTER D WITH CARON
  { 0x010F, BIDI_L   },  // LATIN SMALL LETTER D WITH CARON
  { 0x0110, BIDI_L   },  // LATIN CAPITAL LETTER D WITH STROKE
  { 0x0111, BIDI_L   },  // LATIN SMALL LETTER D WITH STROKE
  { 0x0112, BIDI_L   },  // LATIN CAPITAL LETTER E WITH MACRON
  { 0x0113, BIDI_L   },  // LATIN SMALL LETTER E WITH MACRON
  { 0x0114, BIDI_L   },  // LATIN CAPITAL LETTER E WITH BREVE
  { 0x0115, BIDI_L   },  // LATIN SMALL LETTER E WITH BREVE
  { 0x0116, BIDI_L   },  // LATIN CAPITAL LETTER E WITH DOT ABOVE
  { 0x0117, BIDI_L   },  // LATIN SMALL LETTER E WITH DOT ABOVE
  { 0x0118, BIDI_L   },  // LATIN CAPITAL LETTER E WITH OGONEK
  { 0x0119, BIDI_L   },  // LATIN SMALL LETTER E WITH OGONEK
  { 0x011A, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CARON
  { 0x011B, BIDI_L   },  // LATIN SMALL LETTER E WITH CARON
  { 0x011C, BIDI_L   },  // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
  { 0x011D, BIDI_L   },  // LATIN SMALL LETTER G WITH CIRCUMFLEX
  { 0x011E, BIDI_L   },  // LATIN CAPITAL LETTER G WITH BREVE
  { 0x011F, BIDI_L   },  // LATIN SMALL LETTER G WITH BREVE
  { 0x0120, BIDI_L   },  // LATIN CAPITAL LETTER G WITH DOT ABOVE
  { 0x0121, BIDI_L   },  // LATIN SMALL LETTER G WITH DOT ABOVE
  { 0x0122, BIDI_L   },  // LATIN CAPITAL LETTER G WITH CEDILLA
  { 0x0123, BIDI_L   },  // LATIN SMALL LETTER G WITH CEDILLA
  { 0x0124, BIDI_L   },  // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
  { 0x0125, BIDI_L   },  // LATIN SMALL LETTER H WITH CIRCUMFLEX
  { 0x0126, BIDI_L   },  // LATIN CAPITAL LETTER H WITH STROKE
  { 0x0127, BIDI_L   },  // LATIN SMALL LETTER H WITH STROKE
  { 0x0128, BIDI_L   },  // LATIN CAPITAL LETTER I WITH TILDE
  { 0x0129, BIDI_L   },  // LATIN SMALL LETTER I WITH TILDE
  { 0x012A, BIDI_L   },  // LATIN CAPITAL LETTER I WITH MACRON
  { 0x012B, BIDI_L   },  // LATIN SMALL LETTER I WITH MACRON
  { 0x012C, BIDI_L   },  // LATIN CAPITAL LETTER I WITH BREVE
  { 0x012D, BIDI_L   },  // LATIN SMALL LETTER I WITH BREVE
  { 0x012E, BIDI_L   },  // LATIN CAPITAL LETTER I WITH OGONEK
  { 0x012F, BIDI_L   },  // LATIN SMALL LETTER I WITH OGONEK
  { 0x0130, BIDI_L   },  // LATIN CAPITAL LETTER I WITH DOT ABOVE
  { 0x0131, BIDI_L   },  // LATIN SMALL LETTER DOTLESS I
  { 0x0132, BIDI_L   },  // LATIN CAPITAL LIGATURE IJ
  { 0x0133, BIDI_L   },  // LATIN SMALL LIGATURE IJ
  { 0x0134, BIDI_L   },  // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
  { 0x0135, BIDI_L   },  // LATIN SMALL LETTER J WITH CIRCUMFLEX
  { 0x0136, BIDI_L   },  // LATIN CAPITAL LETTER K WITH CEDILLA
  { 0x0137, BIDI_L   },  // LATIN SMALL LETTER K WITH CEDILLA
  { 0x0138, BIDI_L   },  // LATIN SMALL LETTER KRA
  { 0x0139, BIDI_L   },  // LATIN CAPITAL LETTER L WITH ACUTE
  { 0x013A, BIDI_L   },  // LATIN SMALL LETTER L WITH ACUTE
  { 0x013B, BIDI_L   },  // LATIN CAPITAL LETTER L WITH CEDILLA
  { 0x013C, BIDI_L   },  // LATIN SMALL LETTER L WITH CEDILLA
  { 0x013D, BIDI_L   },  // LATIN CAPITAL LETTER L WITH CARON
  { 0x013E, BIDI_L   },  // LATIN SMALL LETTER L WITH CARON
  { 0x013F, BIDI_L   },  // LATIN CAPITAL LETTER L WITH MIDDLE DOT
  { 0x0140, BIDI_L   },  // LATIN SMALL LETTER L WITH MIDDLE DOT
  { 0x0141, BIDI_L   },  // LATIN CAPITAL LETTER L WITH STROKE
  { 0x0142, BIDI_L   },  // LATIN SMALL LETTER L WITH STROKE
  { 0x0143, BIDI_L   },  // LATIN CAPITAL LETTER N WITH ACUTE
  { 0x0144, BIDI_L   },  // LATIN SMALL LETTER N WITH ACUTE
  { 0x0145, BIDI_L   },  // LATIN CAPITAL LETTER N WITH CEDILLA
  { 0x0146, BIDI_L   },  // LATIN SMALL LETTER N WITH CEDILLA
  { 0x0147, BIDI_L   },  // LATIN CAPITAL LETTER N WITH CARON
  { 0x0148, BIDI_L   },  // LATIN SMALL LETTER N WITH CARON
  { 0x0149, BIDI_L   },  // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
  { 0x014A, BIDI_L   },  // LATIN CAPITAL LETTER ENG
  { 0x014B, BIDI_L   },  // LATIN SMALL LETTER ENG
  { 0x014C, BIDI_L   },  // LATIN CAPITAL LETTER O WITH MACRON
  { 0x014D, BIDI_L   },  // LATIN SMALL LETTER O WITH MACRON
  { 0x014E, BIDI_L   },  // LATIN CAPITAL LETTER O WITH BREVE
  { 0x014F, BIDI_L   },  // LATIN SMALL LETTER O WITH BREVE
  { 0x0150, BIDI_L   },  // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
  { 0x0151, BIDI_L   },  // LATIN SMALL LETTER O WITH DOUBLE ACUTE
  { 0x0152, BIDI_L   },  // LATIN CAPITAL LIGATURE OE
  { 0x0153, BIDI_L   },  // LATIN SMALL LIGATURE OE
  { 0x0154, BIDI_L   },  // LATIN CAPITAL LETTER R WITH ACUTE
  { 0x0155, BIDI_L   },  // LATIN SMALL LETTER R WITH ACUTE
  { 0x0156, BIDI_L   },  // LATIN CAPITAL LETTER R WITH CEDILLA
  { 0x0157, BIDI_L   },  // LATIN SMALL LETTER R WITH CEDILLA
  { 0x0158, BIDI_L   },  // LATIN CAPITAL LETTER R WITH CARON
  { 0x0159, BIDI_L   },  // LATIN SMALL LETTER R WITH CARON
  { 0x015A, BIDI_L   },  // LATIN CAPITAL LETTER S WITH ACUTE
  { 0x015B, BIDI_L   },  // LATIN SMALL LETTER S WITH ACUTE
  { 0x015C, BIDI_L   },  // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
  { 0x015D, BIDI_L   },  // LATIN SMALL LETTER S WITH CIRCUMFLEX
  { 0x015E, BIDI_L   },  // LATIN CAPITAL LETTER S WITH CEDILLA
  { 0x015F, BIDI_L   },  // LATIN SMALL LETTER S WITH CEDILLA
  { 0x0160, BIDI_L   },  // LATIN CAPITAL LETTER S WITH CARON
  { 0x0161, BIDI_L   },  // LATIN SMALL LETTER S WITH CARON
  { 0x0162, BIDI_L   },  // LATIN CAPITAL LETTER T WITH CEDILLA
  { 0x0163, BIDI_L   },  // LATIN SMALL LETTER T WITH CEDILLA
  { 0x0164, BIDI_L   },  // LATIN CAPITAL LETTER T WITH CARON
  { 0x0165, BIDI_L   },  // LATIN SMALL LETTER T WITH CARON
  { 0x0166, BIDI_L   },  // LATIN CAPITAL LETTER T WITH STROKE
  { 0x0167, BIDI_L   },  // LATIN SMALL LETTER T WITH STROKE
  { 0x0168, BIDI_L   },  // LATIN CAPITAL LETTER U WITH TILDE
  { 0x0169, BIDI_L   },  // LATIN SMALL LETTER U WITH TILDE
  { 0x016A, BIDI_L   },  // LATIN CAPITAL LETTER U WITH MACRON
  { 0x016B, BIDI_L   },  // LATIN SMALL LETTER U WITH MACRON
  { 0x016C, BIDI_L   },  // LATIN CAPITAL LETTER U WITH BREVE
  { 0x016D, BIDI_L   },  // LATIN SMALL LETTER U WITH BREVE
  { 0x016E, BIDI_L   },  // LATIN CAPITAL LETTER U WITH RING ABOVE
  { 0x016F, BIDI_L   },  // LATIN SMALL LETTER U WITH RING ABOVE
  { 0x0170, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
  { 0x0171, BIDI_L   },  // LATIN SMALL LETTER U WITH DOUBLE ACUTE
  { 0x0172, BIDI_L   },  // LATIN CAPITAL LETTER U WITH OGONEK
  { 0x0173, BIDI_L   },  // LATIN SMALL LETTER U WITH OGONEK
  { 0x0174, BIDI_L   },  // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
  { 0x0175, BIDI_L   },  // LATIN SMALL LETTER W WITH CIRCUMFLEX
  { 0x0176, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
  { 0x0177, BIDI_L   },  // LATIN SMALL LETTER Y WITH CIRCUMFLEX
  { 0x0178, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH DIAERESIS
  { 0x0179, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH ACUTE
  { 0x017A, BIDI_L   },  // LATIN SMALL LETTER Z WITH ACUTE
  { 0x017B, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH DOT ABOVE
  { 0x017C, BIDI_L   },  // LATIN SMALL LETTER Z WITH DOT ABOVE
  { 0x017D, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH CARON
  { 0x017E, BIDI_L   },  // LATIN SMALL LETTER Z WITH CARON
  { 0x017F, BIDI_L   },  // LATIN SMALL LETTER LONG S
  { 0x0180, BIDI_L   },  // LATIN SMALL LETTER B WITH STROKE
  { 0x0181, BIDI_L   },  // LATIN CAPITAL LETTER B WITH HOOK
  { 0x0182, BIDI_L   },  // LATIN CAPITAL LETTER B WITH TOPBAR
  { 0x0183, BIDI_L   },  // LATIN SMALL LETTER B WITH TOPBAR
  { 0x0184, BIDI_L   },  // LATIN CAPITAL LETTER TONE SIX
  { 0x0185, BIDI_L   },  // LATIN SMALL LETTER TONE SIX
  { 0x0186, BIDI_L   },  // LATIN CAPITAL LETTER OPEN O
  { 0x0187, BIDI_L   },  // LATIN CAPITAL LETTER C WITH HOOK
  { 0x0188, BIDI_L   },  // LATIN SMALL LETTER C WITH HOOK
  { 0x0189, BIDI_L   },  // LATIN CAPITAL LETTER AFRICAN D
  { 0x018A, BIDI_L   },  // LATIN CAPITAL LETTER D WITH HOOK
  { 0x018B, BIDI_L   },  // LATIN CAPITAL LETTER D WITH TOPBAR
  { 0x018C, BIDI_L   },  // LATIN SMALL LETTER D WITH TOPBAR
  { 0x018D, BIDI_L   },  // LATIN SMALL LETTER TURNED DELTA
  { 0x018E, BIDI_L   },  // LATIN CAPITAL LETTER REVERSED E
  { 0x018F, BIDI_L   },  // LATIN CAPITAL LETTER SCHWA
  { 0x0190, BIDI_L   },  // LATIN CAPITAL LETTER OPEN E
  { 0x0191, BIDI_L   },  // LATIN CAPITAL LETTER F WITH HOOK
  { 0x0192, BIDI_L   },  // LATIN SMALL LETTER F WITH HOOK
  { 0x0193, BIDI_L   },  // LATIN CAPITAL LETTER G WITH HOOK
  { 0x0194, BIDI_L   },  // LATIN CAPITAL LETTER GAMMA
  { 0x0195, BIDI_L   },  // LATIN SMALL LETTER HV
  { 0x0196, BIDI_L   },  // LATIN CAPITAL LETTER IOTA
  { 0x0197, BIDI_L   },  // LATIN CAPITAL LETTER I WITH STROKE
  { 0x0198, BIDI_L   },  // LATIN CAPITAL LETTER K WITH HOOK
  { 0x0199, BIDI_L   },  // LATIN SMALL LETTER K WITH HOOK
  { 0x019A, BIDI_L   },  // LATIN SMALL LETTER L WITH BAR
  { 0x019B, BIDI_L   },  // LATIN SMALL LETTER LAMBDA WITH STROKE
  { 0x019C, BIDI_L   },  // LATIN CAPITAL LETTER TURNED M
  { 0x019D, BIDI_L   },  // LATIN CAPITAL LETTER N WITH LEFT HOOK
  { 0x019E, BIDI_L   },  // LATIN SMALL LETTER N WITH LONG RIGHT LEG
  { 0x019F, BIDI_L   },  // LATIN CAPITAL LETTER O WITH MIDDLE TILDE
  { 0x01A0, BIDI_L   },  // LATIN CAPITAL LETTER O WITH HORN
  { 0x01A1, BIDI_L   },  // LATIN SMALL LETTER O WITH HORN
  { 0x01A2, BIDI_L   },  // LATIN CAPITAL LETTER OI
  { 0x01A3, BIDI_L   },  // LATIN SMALL LETTER OI
  { 0x01A4, BIDI_L   },  // LATIN CAPITAL LETTER P WITH HOOK
  { 0x01A5, BIDI_L   },  // LATIN SMALL LETTER P WITH HOOK
  { 0x01A6, BIDI_L   },  // LATIN LETTER YR
  { 0x01A7, BIDI_L   },  // LATIN CAPITAL LETTER TONE TWO
  { 0x01A8, BIDI_L   },  // LATIN SMALL LETTER TONE TWO
  { 0x01A9, BIDI_L   },  // LATIN CAPITAL LETTER ESH
  { 0x01AA, BIDI_L   },  // LATIN LETTER REVERSED ESH LOOP
  { 0x01AB, BIDI_L   },  // LATIN SMALL LETTER T WITH PALATAL HOOK
  { 0x01AC, BIDI_L   },  // LATIN CAPITAL LETTER T WITH HOOK
  { 0x01AD, BIDI_L   },  // LATIN SMALL LETTER T WITH HOOK
  { 0x01AE, BIDI_L   },  // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
  { 0x01AF, BIDI_L   },  // LATIN CAPITAL LETTER U WITH HORN
  { 0x01B0, BIDI_L   },  // LATIN SMALL LETTER U WITH HORN
  { 0x01B1, BIDI_L   },  // LATIN CAPITAL LETTER UPSILON
  { 0x01B2, BIDI_L   },  // LATIN CAPITAL LETTER V WITH HOOK
  { 0x01B3, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH HOOK
  { 0x01B4, BIDI_L   },  // LATIN SMALL LETTER Y WITH HOOK
  { 0x01B5, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH STROKE
  { 0x01B6, BIDI_L   },  // LATIN SMALL LETTER Z WITH STROKE
  { 0x01B7, BIDI_L   },  // LATIN CAPITAL LETTER EZH
  { 0x01B8, BIDI_L   },  // LATIN CAPITAL LETTER EZH REVERSED
  { 0x01B9, BIDI_L   },  // LATIN SMALL LETTER EZH REVERSED
  { 0x01BA, BIDI_L   },  // LATIN SMALL LETTER EZH WITH TAIL
  { 0x01BB, BIDI_L   },  // LATIN LETTER TWO WITH STROKE
  { 0x01BC, BIDI_L   },  // LATIN CAPITAL LETTER TONE FIVE
  { 0x01BD, BIDI_L   },  // LATIN SMALL LETTER TONE FIVE
  { 0x01BE, BIDI_L   },  // LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE
  { 0x01BF, BIDI_L   },  // LATIN LETTER WYNN
  { 0x01C0, BIDI_L   },  // LATIN LETTER DENTAL CLICK
  { 0x01C1, BIDI_L   },  // LATIN LETTER LATERAL CLICK
  { 0x01C2, BIDI_L   },  // LATIN LETTER ALVEOLAR CLICK
  { 0x01C3, BIDI_L   },  // LATIN LETTER RETROFLEX CLICK
  { 0x01C4, BIDI_L   },  // LATIN CAPITAL LETTER DZ WITH CARON
  { 0x01C5, BIDI_L   },  // LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
  { 0x01C6, BIDI_L   },  // LATIN SMALL LETTER DZ WITH CARON
  { 0x01C7, BIDI_L   },  // LATIN CAPITAL LETTER LJ
  { 0x01C8, BIDI_L   },  // LATIN CAPITAL LETTER L WITH SMALL LETTER J
  { 0x01C9, BIDI_L   },  // LATIN SMALL LETTER LJ
  { 0x01CA, BIDI_L   },  // LATIN CAPITAL LETTER NJ
  { 0x01CB, BIDI_L   },  // LATIN CAPITAL LETTER N WITH SMALL LETTER J
  { 0x01CC, BIDI_L   },  // LATIN SMALL LETTER NJ
  { 0x01CD, BIDI_L   },  // LATIN CAPITAL LETTER A WITH CARON
  { 0x01CE, BIDI_L   },  // LATIN SMALL LETTER A WITH CARON
  { 0x01CF, BIDI_L   },  // LATIN CAPITAL LETTER I WITH CARON
  { 0x01D0, BIDI_L   },  // LATIN SMALL LETTER I WITH CARON
  { 0x01D1, BIDI_L   },  // LATIN CAPITAL LETTER O WITH CARON
  { 0x01D2, BIDI_L   },  // LATIN SMALL LETTER O WITH CARON
  { 0x01D3, BIDI_L   },  // LATIN CAPITAL LETTER U WITH CARON
  { 0x01D4, BIDI_L   },  // LATIN SMALL LETTER U WITH CARON
  { 0x01D5, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
  { 0x01D6, BIDI_L   },  // LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
  { 0x01D7, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
  { 0x01D8, BIDI_L   },  // LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
  { 0x01D9, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
  { 0x01DA, BIDI_L   },  // LATIN SMALL LETTER U WITH DIAERESIS AND CARON
  { 0x01DB, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
  { 0x01DC, BIDI_L   },  // LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
  { 0x01DD, BIDI_L   },  // LATIN SMALL LETTER TURNED E
  { 0x01DE, BIDI_L   },  // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
  { 0x01DF, BIDI_L   },  // LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
  { 0x01E0, BIDI_L   },  // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
  { 0x01E1, BIDI_L   },  // LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
  { 0x01E2, BIDI_L   },  // LATIN CAPITAL LETTER AE WITH MACRON
  { 0x01E3, BIDI_L   },  // LATIN SMALL LETTER AE WITH MACRON
  { 0x01E4, BIDI_L   },  // LATIN CAPITAL LETTER G WITH STROKE
  { 0x01E5, BIDI_L   },  // LATIN SMALL LETTER G WITH STROKE
  { 0x01E6, BIDI_L   },  // LATIN CAPITAL LETTER G WITH CARON
  { 0x01E7, BIDI_L   },  // LATIN SMALL LETTER G WITH CARON
  { 0x01E8, BIDI_L   },  // LATIN CAPITAL LETTER K WITH CARON
  { 0x01E9, BIDI_L   },  // LATIN SMALL LETTER K WITH CARON
  { 0x01EA, BIDI_L   },  // LATIN CAPITAL LETTER O WITH OGONEK
  { 0x01EB, BIDI_L   },  // LATIN SMALL LETTER O WITH OGONEK
  { 0x01EC, BIDI_L   },  // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
  { 0x01ED, BIDI_L   },  // LATIN SMALL LETTER O WITH OGONEK AND MACRON
  { 0x01EE, BIDI_L   },  // LATIN CAPITAL LETTER EZH WITH CARON
  { 0x01EF, BIDI_L   },  // LATIN SMALL LETTER EZH WITH CARON
  { 0x01F0, BIDI_L   },  // LATIN SMALL LETTER J WITH CARON
  { 0x01F1, BIDI_L   },  // LATIN CAPITAL LETTER DZ
  { 0x01F2, BIDI_L   },  // LATIN CAPITAL LETTER D WITH SMALL LETTER Z
  { 0x01F3, BIDI_L   },  // LATIN SMALL LETTER DZ
  { 0x01F4, BIDI_L   },  // LATIN CAPITAL LETTER G WITH ACUTE
  { 0x01F5, BIDI_L   },  // LATIN SMALL LETTER G WITH ACUTE
  { 0x01F6, BIDI_L   },  // LATIN CAPITAL LETTER HWAIR
  { 0x01F7, BIDI_L   },  // LATIN CAPITAL LETTER WYNN
  { 0x01F8, BIDI_L   },  // LATIN CAPITAL LETTER N WITH GRAVE
  { 0x01F9, BIDI_L   },  // LATIN SMALL LETTER N WITH GRAVE
  { 0x01FA, BIDI_L   },  // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
  { 0x01FB, BIDI_L   },  // LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
  { 0x01FC, BIDI_L   },  // LATIN CAPITAL LETTER AE WITH ACUTE
  { 0x01FD, BIDI_L   },  // LATIN SMALL LETTER AE WITH ACUTE
  { 0x01FE, BIDI_L   },  // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
  { 0x01FF, BIDI_L   },  // LATIN SMALL LETTER O WITH STROKE AND ACUTE
  { 0x0200, BIDI_L   },  // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
  { 0x0201, BIDI_L   },  // LATIN SMALL LETTER A WITH DOUBLE GRAVE
  { 0x0202, BIDI_L   },  // LATIN CAPITAL LETTER A WITH INVERTED BREVE
  { 0x0203, BIDI_L   },  // LATIN SMALL LETTER A WITH INVERTED BREVE
  { 0x0204, BIDI_L   },  // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
  { 0x0205, BIDI_L   },  // LATIN SMALL LETTER E WITH DOUBLE GRAVE
  { 0x0206, BIDI_L   },  // LATIN CAPITAL LETTER E WITH INVERTED BREVE
  { 0x0207, BIDI_L   },  // LATIN SMALL LETTER E WITH INVERTED BREVE
  { 0x0208, BIDI_L   },  // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
  { 0x0209, BIDI_L   },  // LATIN SMALL LETTER I WITH DOUBLE GRAVE
  { 0x020A, BIDI_L   },  // LATIN CAPITAL LETTER I WITH INVERTED BREVE
  { 0x020B, BIDI_L   },  // LATIN SMALL LETTER I WITH INVERTED BREVE
  { 0x020C, BIDI_L   },  // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
  { 0x020D, BIDI_L   },  // LATIN SMALL LETTER O WITH DOUBLE GRAVE
  { 0x020E, BIDI_L   },  // LATIN CAPITAL LETTER O WITH INVERTED BREVE
  { 0x020F, BIDI_L   },  // LATIN SMALL LETTER O WITH INVERTED BREVE
  { 0x0210, BIDI_L   },  // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
  { 0x0211, BIDI_L   },  // LATIN SMALL LETTER R WITH DOUBLE GRAVE
  { 0x0212, BIDI_L   },  // LATIN CAPITAL LETTER R WITH INVERTED BREVE
  { 0x0213, BIDI_L   },  // LATIN SMALL LETTER R WITH INVERTED BREVE
  { 0x0214, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
  { 0x0215, BIDI_L   },  // LATIN SMALL LETTER U WITH DOUBLE GRAVE
  { 0x0216, BIDI_L   },  // LATIN CAPITAL LETTER U WITH INVERTED BREVE
  { 0x0217, BIDI_L   },  // LATIN SMALL LETTER U WITH INVERTED BREVE
  { 0x0218, BIDI_L   },  // LATIN CAPITAL LETTER S WITH COMMA BELOW
  { 0x0219, BIDI_L   },  // LATIN SMALL LETTER S WITH COMMA BELOW
  { 0x021A, BIDI_L   },  // LATIN CAPITAL LETTER T WITH COMMA BELOW
  { 0x021B, BIDI_L   },  // LATIN SMALL LETTER T WITH COMMA BELOW
  { 0x021C, BIDI_L   },  // LATIN CAPITAL LETTER YOGH
  { 0x021D, BIDI_L   },  // LATIN SMALL LETTER YOGH
  { 0x021E, BIDI_L   },  // LATIN CAPITAL LETTER H WITH CARON
  { 0x021F, BIDI_L   },  // LATIN SMALL LETTER H WITH CARON
  { 0x0220, BIDI_L   },  // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
  { 0x0221, BIDI_L   },  // LATIN SMALL LETTER D WITH CURL
  { 0x0222, BIDI_L   },  // LATIN CAPITAL LETTER OU
  { 0x0223, BIDI_L   },  // LATIN SMALL LETTER OU
  { 0x0224, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH HOOK
  { 0x0225, BIDI_L   },  // LATIN SMALL LETTER Z WITH HOOK
  { 0x0226, BIDI_L   },  // LATIN CAPITAL LETTER A WITH DOT ABOVE
  { 0x0227, BIDI_L   },  // LATIN SMALL LETTER A WITH DOT ABOVE
  { 0x0228, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CEDILLA
  { 0x0229, BIDI_L   },  // LATIN SMALL LETTER E WITH CEDILLA
  { 0x022A, BIDI_L   },  // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
  { 0x022B, BIDI_L   },  // LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
  { 0x022C, BIDI_L   },  // LATIN CAPITAL LETTER O WITH TILDE AND MACRON
  { 0x022D, BIDI_L   },  // LATIN SMALL LETTER O WITH TILDE AND MACRON
  { 0x022E, BIDI_L   },  // LATIN CAPITAL LETTER O WITH DOT ABOVE
  { 0x022F, BIDI_L   },  // LATIN SMALL LETTER O WITH DOT ABOVE
  { 0x0230, BIDI_L   },  // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
  { 0x0231, BIDI_L   },  // LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
  { 0x0232, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH MACRON
  { 0x0233, BIDI_L   },  // LATIN SMALL LETTER Y WITH MACRON
  { 0x0234, BIDI_L   },  // LATIN SMALL LETTER L WITH CURL
  { 0x0235, BIDI_L   },  // LATIN SMALL LETTER N WITH CURL
  { 0x0236, BIDI_L   },  // LATIN SMALL LETTER T WITH CURL
  { 0x0237, BIDI_L   },  // LATIN SMALL LETTER DOTLESS J
  { 0x0238, BIDI_L   },  // LATIN SMALL LETTER DB DIGRAPH
  { 0x0239, BIDI_L   },  // LATIN SMALL LETTER QP DIGRAPH
  { 0x023A, BIDI_L   },  // LATIN CAPITAL LETTER A WITH STROKE
  { 0x023B, BIDI_L   },  // LATIN CAPITAL LETTER C WITH STROKE
  { 0x023C, BIDI_L   },  // LATIN SMALL LETTER C WITH STROKE
  { 0x023D, BIDI_L   },  // LATIN CAPITAL LETTER L WITH BAR
  { 0x023E, BIDI_L   },  // LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
  { 0x023F, BIDI_L   },  // LATIN SMALL LETTER S WITH SWASH TAIL
  { 0x0240, BIDI_L   },  // LATIN SMALL LETTER Z WITH SWASH TAIL
  { 0x0241, BIDI_L   },  // LATIN CAPITAL LETTER GLOTTAL STOP
  { 0x0242, BIDI_L   },  // LATIN SMALL LETTER GLOTTAL STOP
  { 0x0243, BIDI_L   },  // LATIN CAPITAL LETTER B WITH STROKE
  { 0x0244, BIDI_L   },  // LATIN CAPITAL LETTER U BAR
  { 0x0245, BIDI_L   },  // LATIN CAPITAL LETTER TURNED V
  { 0x0246, BIDI_L   },  // LATIN CAPITAL LETTER E WITH STROKE
  { 0x0247, BIDI_L   },  // LATIN SMALL LETTER E WITH STROKE
  { 0x0248, BIDI_L   },  // LATIN CAPITAL LETTER J WITH STROKE
  { 0x0249, BIDI_L   },  // LATIN SMALL LETTER J WITH STROKE
  { 0x024A, BIDI_L   },  // LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
  { 0x024B, BIDI_L   },  // LATIN SMALL LETTER Q WITH HOOK TAIL
  { 0x024C, BIDI_L   },  // LATIN CAPITAL LETTER R WITH STROKE
  { 0x024D, BIDI_L   },  // LATIN SMALL LETTER R WITH STROKE
  { 0x024E, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH STROKE
  { 0x024F, BIDI_L   },  // LATIN SMALL LETTER Y WITH STROKE
  { 0x0250, BIDI_L   },  // LATIN SMALL LETTER TURNED A
  { 0x0251, BIDI_L   },  // LATIN SMALL LETTER ALPHA
  { 0x0252, BIDI_L   },  // LATIN SMALL LETTER TURNED ALPHA
  { 0x0253, BIDI_L   },  // LATIN SMALL LETTER B WITH HOOK
  { 0x0254, BIDI_L   },  // LATIN SMALL LETTER OPEN O
  { 0x0255, BIDI_L   },  // LATIN SMALL LETTER C WITH CURL
  { 0x0256, BIDI_L   },  // LATIN SMALL LETTER D WITH TAIL
  { 0x0257, BIDI_L   },  // LATIN SMALL LETTER D WITH HOOK
  { 0x0258, BIDI_L   },  // LATIN SMALL LETTER REVERSED E
  { 0x0259, BIDI_L   },  // LATIN SMALL LETTER SCHWA
  { 0x025A, BIDI_L   },  // LATIN SMALL LETTER SCHWA WITH HOOK
  { 0x025B, BIDI_L   },  // LATIN SMALL LETTER OPEN E
  { 0x025C, BIDI_L   },  // LATIN SMALL LETTER REVERSED OPEN E
  { 0x025D, BIDI_L   },  // LATIN SMALL LETTER REVERSED OPEN E WITH HOOK
  { 0x025E, BIDI_L   },  // LATIN SMALL LETTER CLOSED REVERSED OPEN E
  { 0x025F, BIDI_L   },  // LATIN SMALL LETTER DOTLESS J WITH STROKE
  { 0x0260, BIDI_L   },  // LATIN SMALL LETTER G WITH HOOK
  { 0x0261, BIDI_L   },  // LATIN SMALL LETTER SCRIPT G
  { 0x0262, BIDI_L   },  // LATIN LETTER SMALL CAPITAL G
  { 0x0263, BIDI_L   },  // LATIN SMALL LETTER GAMMA
  { 0x0264, BIDI_L   },  // LATIN SMALL LETTER RAMS HORN
  { 0x0265, BIDI_L   },  // LATIN SMALL LETTER TURNED H
  { 0x0266, BIDI_L   },  // LATIN SMALL LETTER H WITH HOOK
  { 0x0267, BIDI_L   },  // LATIN SMALL LETTER HENG WITH HOOK
  { 0x0268, BIDI_L   },  // LATIN SMALL LETTER I WITH STROKE
  { 0x0269, BIDI_L   },  // LATIN SMALL LETTER IOTA
  { 0x026A, BIDI_L   },  // LATIN LETTER SMALL CAPITAL I
  { 0x026B, BIDI_L   },  // LATIN SMALL LETTER L WITH MIDDLE TILDE
  { 0x026C, BIDI_L   },  // LATIN SMALL LETTER L WITH BELT
  { 0x026D, BIDI_L   },  // LATIN SMALL LETTER L WITH RETROFLEX HOOK
  { 0x026E, BIDI_L   },  // LATIN SMALL LETTER LEZH
  { 0x026F, BIDI_L   },  // LATIN SMALL LETTER TURNED M
  { 0x0270, BIDI_L   },  // LATIN SMALL LETTER TURNED M WITH LONG LEG
  { 0x0271, BIDI_L   },  // LATIN SMALL LETTER M WITH HOOK
  { 0x0272, BIDI_L   },  // LATIN SMALL LETTER N WITH LEFT HOOK
  { 0x0273, BIDI_L   },  // LATIN SMALL LETTER N WITH RETROFLEX HOOK
  { 0x0274, BIDI_L   },  // LATIN LETTER SMALL CAPITAL N
  { 0x0275, BIDI_L   },  // LATIN SMALL LETTER BARRED O
  { 0x0276, BIDI_L   },  // LATIN LETTER SMALL CAPITAL OE
  { 0x0277, BIDI_L   },  // LATIN SMALL LETTER CLOSED OMEGA
  { 0x0278, BIDI_L   },  // LATIN SMALL LETTER PHI
  { 0x0279, BIDI_L   },  // LATIN SMALL LETTER TURNED R
  { 0x027A, BIDI_L   },  // LATIN SMALL LETTER TURNED R WITH LONG LEG
  { 0x027B, BIDI_L   },  // LATIN SMALL LETTER TURNED R WITH HOOK
  { 0x027C, BIDI_L   },  // LATIN SMALL LETTER R WITH LONG LEG
  { 0x027D, BIDI_L   },  // LATIN SMALL LETTER R WITH TAIL
  { 0x027E, BIDI_L   },  // LATIN SMALL LETTER R WITH FISHHOOK
  { 0x027F, BIDI_L   },  // LATIN SMALL LETTER REVERSED R WITH FISHHOOK
  { 0x0280, BIDI_L   },  // LATIN LETTER SMALL CAPITAL R
  { 0x0281, BIDI_L   },  // LATIN LETTER SMALL CAPITAL INVERTED R
  { 0x0282, BIDI_L   },  // LATIN SMALL LETTER S WITH HOOK
  { 0x0283, BIDI_L   },  // LATIN SMALL LETTER ESH
  { 0x0284, BIDI_L   },  // LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK
  { 0x0285, BIDI_L   },  // LATIN SMALL LETTER SQUAT REVERSED ESH
  { 0x0286, BIDI_L   },  // LATIN SMALL LETTER ESH WITH CURL
  { 0x0287, BIDI_L   },  // LATIN SMALL LETTER TURNED T
  { 0x0288, BIDI_L   },  // LATIN SMALL LETTER T WITH RETROFLEX HOOK
  { 0x0289, BIDI_L   },  // LATIN SMALL LETTER U BAR
  { 0x028A, BIDI_L   },  // LATIN SMALL LETTER UPSILON
  { 0x028B, BIDI_L   },  // LATIN SMALL LETTER V WITH HOOK
  { 0x028C, BIDI_L   },  // LATIN SMALL LETTER TURNED V
  { 0x028D, BIDI_L   },  // LATIN SMALL LETTER TURNED W
  { 0x028E, BIDI_L   },  // LATIN SMALL LETTER TURNED Y
  { 0x028F, BIDI_L   },  // LATIN LETTER SMALL CAPITAL Y
  { 0x0290, BIDI_L   },  // LATIN SMALL LETTER Z WITH RETROFLEX HOOK
  { 0x0291, BIDI_L   },  // LATIN SMALL LETTER Z WITH CURL
  { 0x0292, BIDI_L   },  // LATIN SMALL LETTER EZH
  { 0x0293, BIDI_L   },  // LATIN SMALL LETTER EZH WITH CURL
  { 0x0294, BIDI_L   },  // LATIN LETTER GLOTTAL STOP
  { 0x0295, BIDI_L   },  // LATIN LETTER PHARYNGEAL VOICED FRICATIVE
  { 0x0296, BIDI_L   },  // LATIN LETTER INVERTED GLOTTAL STOP
  { 0x0297, BIDI_L   },  // LATIN LETTER STRETCHED C
  { 0x0298, BIDI_L   },  // LATIN LETTER BILABIAL CLICK
  { 0x0299, BIDI_L   },  // LATIN LETTER SMALL CAPITAL B
  { 0x029A, BIDI_L   },  // LATIN SMALL LETTER CLOSED OPEN E
  { 0x029B, BIDI_L   },  // LATIN LETTER SMALL CAPITAL G WITH HOOK
  { 0x029C, BIDI_L   },  // LATIN LETTER SMALL CAPITAL H
  { 0x029D, BIDI_L   },  // LATIN SMALL LETTER J WITH CROSSED-TAIL
  { 0x029E, BIDI_L   },  // LATIN SMALL LETTER TURNED K
  { 0x029F, BIDI_L   },  // LATIN LETTER SMALL CAPITAL L
  { 0x02A0, BIDI_L   },  // LATIN SMALL LETTER Q WITH HOOK
  { 0x02A1, BIDI_L   },  // LATIN LETTER GLOTTAL STOP WITH STROKE
  { 0x02A2, BIDI_L   },  // LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE
  { 0x02A3, BIDI_L   },  // LATIN SMALL LETTER DZ DIGRAPH
  { 0x02A4, BIDI_L   },  // LATIN SMALL LETTER DEZH DIGRAPH
  { 0x02A5, BIDI_L   },  // LATIN SMALL LETTER DZ DIGRAPH WITH CURL
  { 0x02A6, BIDI_L   },  // LATIN SMALL LETTER TS DIGRAPH
  { 0x02A7, BIDI_L   },  // LATIN SMALL LETTER TESH DIGRAPH
  { 0x02A8, BIDI_L   },  // LATIN SMALL LETTER TC DIGRAPH WITH CURL
  { 0x02A9, BIDI_L   },  // LATIN SMALL LETTER FENG DIGRAPH
  { 0x02AA, BIDI_L   },  // LATIN SMALL LETTER LS DIGRAPH
  { 0x02AB, BIDI_L   },  // LATIN SMALL LETTER LZ DIGRAPH
  { 0x02AC, BIDI_L   },  // LATIN LETTER BILABIAL PERCUSSIVE
  { 0x02AD, BIDI_L   },  // LATIN LETTER BIDENTAL PERCUSSIVE
  { 0x02AE, BIDI_L   },  // LATIN SMALL LETTER TURNED H WITH FISHHOOK
  { 0x02AF, BIDI_L   },  // LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
  { 0x02B0, BIDI_L   },  // MODIFIER LETTER SMALL H
  { 0x02B1, BIDI_L   },  // MODIFIER LETTER SMALL H WITH HOOK
  { 0x02B2, BIDI_L   },  // MODIFIER LETTER SMALL J
  { 0x02B3, BIDI_L   },  // MODIFIER LETTER SMALL R
  { 0x02B4, BIDI_L   },  // MODIFIER LETTER SMALL TURNED R
  { 0x02B5, BIDI_L   },  // MODIFIER LETTER SMALL TURNED R WITH HOOK
  { 0x02B6, BIDI_L   },  // MODIFIER LETTER SMALL CAPITAL INVERTED R
  { 0x02B7, BIDI_L   },  // MODIFIER LETTER SMALL W
  { 0x02B8, BIDI_L   },  // MODIFIER LETTER SMALL Y
  { 0x02B9, BIDI_ON  },  // MODIFIER LETTER PRIME
  { 0x02BA, BIDI_ON  },  // MODIFIER LETTER DOUBLE PRIME
  { 0x02BB, BIDI_L   },  // MODIFIER LETTER TURNED COMMA
  { 0x02BC, BIDI_L   },  // MODIFIER LETTER APOSTROPHE
  { 0x02BD, BIDI_L   },  // MODIFIER LETTER REVERSED COMMA
  { 0x02BE, BIDI_L   },  // MODIFIER LETTER RIGHT HALF RING
  { 0x02BF, BIDI_L   },  // MODIFIER LETTER LEFT HALF RING
  { 0x02C0, BIDI_L   },  // MODIFIER LETTER GLOTTAL STOP
  { 0x02C1, BIDI_L   },  // MODIFIER LETTER REVERSED GLOTTAL STOP
  { 0x02C2, BIDI_ON  },  // MODIFIER LETTER LEFT ARROWHEAD
  { 0x02C3, BIDI_ON  },  // MODIFIER LETTER RIGHT ARROWHEAD
  { 0x02C4, BIDI_ON  },  // MODIFIER LETTER UP ARROWHEAD
  { 0x02C5, BIDI_ON  },  // MODIFIER LETTER DOWN ARROWHEAD
  { 0x02C6, BIDI_ON  },  // MODIFIER LETTER CIRCUMFLEX ACCENT
  { 0x02C7, BIDI_ON  },  // CARON
  { 0x02C8, BIDI_ON  },  // MODIFIER LETTER VERTICAL LINE
  { 0x02C9, BIDI_ON  },  // MODIFIER LETTER MACRON
  { 0x02CA, BIDI_ON  },  // MODIFIER LETTER ACUTE ACCENT
  { 0x02CB, BIDI_ON  },  // MODIFIER LETTER GRAVE ACCENT
  { 0x02CC, BIDI_ON  },  // MODIFIER LETTER LOW VERTICAL LINE
  { 0x02CD, BIDI_ON  },  // MODIFIER LETTER LOW MACRON
  { 0x02CE, BIDI_ON  },  // MODIFIER LETTER LOW GRAVE ACCENT
  { 0x02CF, BIDI_ON  },  // MODIFIER LETTER LOW ACUTE ACCENT
  { 0x02D0, BIDI_L   },  // MODIFIER LETTER TRIANGULAR COLON
  { 0x02D1, BIDI_L   },  // MODIFIER LETTER HALF TRIANGULAR COLON
  { 0x02D2, BIDI_ON  },  // MODIFIER LETTER CENTRED RIGHT HALF RING
  { 0x02D3, BIDI_ON  },  // MODIFIER LETTER CENTRED LEFT HALF RING
  { 0x02D4, BIDI_ON  },  // MODIFIER LETTER UP TACK
  { 0x02D5, BIDI_ON  },  // MODIFIER LETTER DOWN TACK
  { 0x02D6, BIDI_ON  },  // MODIFIER LETTER PLUS SIGN
  { 0x02D7, BIDI_ON  },  // MODIFIER LETTER MINUS SIGN
  { 0x02D8, BIDI_ON  },  // BREVE
  { 0x02D9, BIDI_ON  },  // DOT ABOVE
  { 0x02DA, BIDI_ON  },  // RING ABOVE
  { 0x02DB, BIDI_ON  },  // OGONEK
  { 0x02DC, BIDI_ON  },  // SMALL TILDE
  { 0x02DD, BIDI_ON  },  // DOUBLE ACUTE ACCENT
  { 0x02DE, BIDI_ON  },  // MODIFIER LETTER RHOTIC HOOK
  { 0x02DF, BIDI_ON  },  // MODIFIER LETTER CROSS ACCENT
  { 0x02E0, BIDI_L   },  // MODIFIER LETTER SMALL GAMMA
  { 0x02E1, BIDI_L   },  // MODIFIER LETTER SMALL L
  { 0x02E2, BIDI_L   },  // MODIFIER LETTER SMALL S
  { 0x02E3, BIDI_L   },  // MODIFIER LETTER SMALL X
  { 0x02E4, BIDI_L   },  // MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
  { 0x02E5, BIDI_ON  },  // MODIFIER LETTER EXTRA-HIGH TONE BAR
  { 0x02E6, BIDI_ON  },  // MODIFIER LETTER HIGH TONE BAR
  { 0x02E7, BIDI_ON  },  // MODIFIER LETTER MID TONE BAR
  { 0x02E8, BIDI_ON  },  // MODIFIER LETTER LOW TONE BAR
  { 0x02E9, BIDI_ON  },  // MODIFIER LETTER EXTRA-LOW TONE BAR
  { 0x02EA, BIDI_ON  },  // MODIFIER LETTER YIN DEPARTING TONE MARK
  { 0x02EB, BIDI_ON  },  // MODIFIER LETTER YANG DEPARTING TONE MARK
  { 0x02EC, BIDI_ON  },  // MODIFIER LETTER VOICING
  { 0x02ED, BIDI_ON  },  // MODIFIER LETTER UNASPIRATED
  { 0x02EE, BIDI_L   },  // MODIFIER LETTER DOUBLE APOSTROPHE
  { 0x02EF, BIDI_ON  },  // MODIFIER LETTER LOW DOWN ARROWHEAD
  { 0x02F0, BIDI_ON  },  // MODIFIER LETTER LOW UP ARROWHEAD
  { 0x02F1, BIDI_ON  },  // MODIFIER LETTER LOW LEFT ARROWHEAD
  { 0x02F2, BIDI_ON  },  // MODIFIER LETTER LOW RIGHT ARROWHEAD
  { 0x02F3, BIDI_ON  },  // MODIFIER LETTER LOW RING
  { 0x02F4, BIDI_ON  },  // MODIFIER LETTER MIDDLE GRAVE ACCENT
  { 0x02F5, BIDI_ON  },  // MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT
  { 0x02F6, BIDI_ON  },  // MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT
  { 0x02F7, BIDI_ON  },  // MODIFIER LETTER LOW TILDE
  { 0x02F8, BIDI_ON  },  // MODIFIER LETTER RAISED COLON
  { 0x02F9, BIDI_ON  },  // MODIFIER LETTER BEGIN HIGH TONE
  { 0x02FA, BIDI_ON  },  // MODIFIER LETTER END HIGH TONE
  { 0x02FB, BIDI_ON  },  // MODIFIER LETTER BEGIN LOW TONE
  { 0x02FC, BIDI_ON  },  // MODIFIER LETTER END LOW TONE
  { 0x02FD, BIDI_ON  },  // MODIFIER LETTER SHELF
  { 0x02FE, BIDI_ON  },  // MODIFIER LETTER OPEN SHELF
  { 0x02FF, BIDI_ON  },  // MODIFIER LETTER LOW LEFT ARROW
  { 0x0300, BIDI_NSM },  // COMBINING GRAVE ACCENT
  { 0x0301, BIDI_NSM },  // COMBINING ACUTE ACCENT
  { 0x0302, BIDI_NSM },  // COMBINING CIRCUMFLEX ACCENT
  { 0x0303, BIDI_NSM },  // COMBINING TILDE
  { 0x0304, BIDI_NSM },  // COMBINING MACRON
  { 0x0305, BIDI_NSM },  // COMBINING OVERLINE
  { 0x0306, BIDI_NSM },  // COMBINING BREVE
  { 0x0307, BIDI_NSM },  // COMBINING DOT ABOVE
  { 0x0308, BIDI_NSM },  // COMBINING DIAERESIS
  { 0x0309, BIDI_NSM },  // COMBINING HOOK ABOVE
  { 0x030A, BIDI_NSM },  // COMBINING RING ABOVE
  { 0x030B, BIDI_NSM },  // COMBINING DOUBLE ACUTE ACCENT
  { 0x030C, BIDI_NSM },  // COMBINING CARON
  { 0x030D, BIDI_NSM },  // COMBINING VERTICAL LINE ABOVE
  { 0x030E, BIDI_NSM },  // COMBINING DOUBLE VERTICAL LINE ABOVE
  { 0x030F, BIDI_NSM },  // COMBINING DOUBLE GRAVE ACCENT
  { 0x0310, BIDI_NSM },  // COMBINING CANDRABINDU
  { 0x0311, BIDI_NSM },  // COMBINING INVERTED BREVE
  { 0x0312, BIDI_NSM },  // COMBINING TURNED COMMA ABOVE
  { 0x0313, BIDI_NSM },  // COMBINING COMMA ABOVE
  { 0x0314, BIDI_NSM },  // COMBINING REVERSED COMMA ABOVE
  { 0x0315, BIDI_NSM },  // COMBINING COMMA ABOVE RIGHT
  { 0x0316, BIDI_NSM },  // COMBINING GRAVE ACCENT BELOW
  { 0x0317, BIDI_NSM },  // COMBINING ACUTE ACCENT BELOW
  { 0x0318, BIDI_NSM },  // COMBINING LEFT TACK BELOW
  { 0x0319, BIDI_NSM },  // COMBINING RIGHT TACK BELOW
  { 0x031A, BIDI_NSM },  // COMBINING LEFT ANGLE ABOVE
  { 0x031B, BIDI_NSM },  // COMBINING HORN
  { 0x031C, BIDI_NSM },  // COMBINING LEFT HALF RING BELOW
  { 0x031D, BIDI_NSM },  // COMBINING UP TACK BELOW
  { 0x031E, BIDI_NSM },  // COMBINING DOWN TACK BELOW
  { 0x031F, BIDI_NSM },  // COMBINING PLUS SIGN BELOW
  { 0x0320, BIDI_NSM },  // COMBINING MINUS SIGN BELOW
  { 0x0321, BIDI_NSM },  // COMBINING PALATALIZED HOOK BELOW
  { 0x0322, BIDI_NSM },  // COMBINING RETROFLEX HOOK BELOW
  { 0x0323, BIDI_NSM },  // COMBINING DOT BELOW
  { 0x0324, BIDI_NSM },  // COMBINING DIAERESIS BELOW
  { 0x0325, BIDI_NSM },  // COMBINING RING BELOW
  { 0x0326, BIDI_NSM },  // COMBINING COMMA BELOW
  { 0x0327, BIDI_NSM },  // COMBINING CEDILLA
  { 0x0328, BIDI_NSM },  // COMBINING OGONEK
  { 0x0329, BIDI_NSM },  // COMBINING VERTICAL LINE BELOW
  { 0x032A, BIDI_NSM },  // COMBINING BRIDGE BELOW
  { 0x032B, BIDI_NSM },  // COMBINING INVERTED DOUBLE ARCH BELOW
  { 0x032C, BIDI_NSM },  // COMBINING CARON BELOW
  { 0x032D, BIDI_NSM },  // COMBINING CIRCUMFLEX ACCENT BELOW
  { 0x032E, BIDI_NSM },  // COMBINING BREVE BELOW
  { 0x032F, BIDI_NSM },  // COMBINING INVERTED BREVE BELOW
  { 0x0330, BIDI_NSM },  // COMBINING TILDE BELOW
  { 0x0331, BIDI_NSM },  // COMBINING MACRON BELOW
  { 0x0332, BIDI_NSM },  // COMBINING LOW LINE
  { 0x0333, BIDI_NSM },  // COMBINING DOUBLE LOW LINE
  { 0x0334, BIDI_NSM },  // COMBINING TILDE OVERLAY
  { 0x0335, BIDI_NSM },  // COMBINING SHORT STROKE OVERLAY
  { 0x0336, BIDI_NSM },  // COMBINING LONG STROKE OVERLAY
  { 0x0337, BIDI_NSM },  // COMBINING SHORT SOLIDUS OVERLAY
  { 0x0338, BIDI_NSM },  // COMBINING LONG SOLIDUS OVERLAY
  { 0x0339, BIDI_NSM },  // COMBINING RIGHT HALF RING BELOW
  { 0x033A, BIDI_NSM },  // COMBINING INVERTED BRIDGE BELOW
  { 0x033B, BIDI_NSM },  // COMBINING SQUARE BELOW
  { 0x033C, BIDI_NSM },  // COMBINING SEAGULL BELOW
  { 0x033D, BIDI_NSM },  // COMBINING X ABOVE
  { 0x033E, BIDI_NSM },  // COMBINING VERTICAL TILDE
  { 0x033F, BIDI_NSM },  // COMBINING DOUBLE OVERLINE
  { 0x0340, BIDI_NSM },  // COMBINING GRAVE TONE MARK
  { 0x0341, BIDI_NSM },  // COMBINING ACUTE TONE MARK
  { 0x0342, BIDI_NSM },  // COMBINING GREEK PERISPOMENI
  { 0x0343, BIDI_NSM },  // COMBINING GREEK KORONIS
  { 0x0344, BIDI_NSM },  // COMBINING GREEK DIALYTIKA TONOS
  { 0x0345, BIDI_NSM },  // COMBINING GREEK YPOGEGRAMMENI
  { 0x0346, BIDI_NSM },  // COMBINING BRIDGE ABOVE
  { 0x0347, BIDI_NSM },  // COMBINING EQUALS SIGN BELOW
  { 0x0348, BIDI_NSM },  // COMBINING DOUBLE VERTICAL LINE BELOW
  { 0x0349, BIDI_NSM },  // COMBINING LEFT ANGLE BELOW
  { 0x034A, BIDI_NSM },  // COMBINING NOT TILDE ABOVE
  { 0x034B, BIDI_NSM },  // COMBINING HOMOTHETIC ABOVE
  { 0x034C, BIDI_NSM },  // COMBINING ALMOST EQUAL TO ABOVE
  { 0x034D, BIDI_NSM },  // COMBINING LEFT RIGHT ARROW BELOW
  { 0x034E, BIDI_NSM },  // COMBINING UPWARDS ARROW BELOW
  { 0x034F, BIDI_NSM },  // COMBINING GRAPHEME JOINER
  { 0x0350, BIDI_NSM },  // COMBINING RIGHT ARROWHEAD ABOVE
  { 0x0351, BIDI_NSM },  // COMBINING LEFT HALF RING ABOVE
  { 0x0352, BIDI_NSM },  // COMBINING FERMATA
  { 0x0353, BIDI_NSM },  // COMBINING X BELOW
  { 0x0354, BIDI_NSM },  // COMBINING LEFT ARROWHEAD BELOW
  { 0x0355, BIDI_NSM },  // COMBINING RIGHT ARROWHEAD BELOW
  { 0x0356, BIDI_NSM },  // COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW
  { 0x0357, BIDI_NSM },  // COMBINING RIGHT HALF RING ABOVE
  { 0x0358, BIDI_NSM },  // COMBINING DOT ABOVE RIGHT
  { 0x0359, BIDI_NSM },  // COMBINING ASTERISK BELOW
  { 0x035A, BIDI_NSM },  // COMBINING DOUBLE RING BELOW
  { 0x035B, BIDI_NSM },  // COMBINING ZIGZAG ABOVE
  { 0x035C, BIDI_NSM },  // COMBINING DOUBLE BREVE BELOW
  { 0x035D, BIDI_NSM },  // COMBINING DOUBLE BREVE
  { 0x035E, BIDI_NSM },  // COMBINING DOUBLE MACRON
  { 0x035F, BIDI_NSM },  // COMBINING DOUBLE MACRON BELOW
  { 0x0360, BIDI_NSM },  // COMBINING DOUBLE TILDE
  { 0x0361, BIDI_NSM },  // COMBINING DOUBLE INVERTED BREVE
  { 0x0362, BIDI_NSM },  // COMBINING DOUBLE RIGHTWARDS ARROW BELOW
  { 0x0363, BIDI_NSM },  // COMBINING LATIN SMALL LETTER A
  { 0x0364, BIDI_NSM },  // COMBINING LATIN SMALL LETTER E
  { 0x0365, BIDI_NSM },  // COMBINING LATIN SMALL LETTER I
  { 0x0366, BIDI_NSM },  // COMBINING LATIN SMALL LETTER O
  { 0x0367, BIDI_NSM },  // COMBINING LATIN SMALL LETTER U
  { 0x0368, BIDI_NSM },  // COMBINING LATIN SMALL LETTER C
  { 0x0369, BIDI_NSM },  // COMBINING LATIN SMALL LETTER D
  { 0x036A, BIDI_NSM },  // COMBINING LATIN SMALL LETTER H
  { 0x036B, BIDI_NSM },  // COMBINING LATIN SMALL LETTER M
  { 0x036C, BIDI_NSM },  // COMBINING LATIN SMALL LETTER R
  { 0x036D, BIDI_NSM },  // COMBINING LATIN SMALL LETTER T
  { 0x036E, BIDI_NSM },  // COMBINING LATIN SMALL LETTER V
  { 0x036F, BIDI_NSM },  // COMBINING LATIN SMALL LETTER X
  { 0x0370, BIDI_L   },  // GREEK CAPITAL LETTER HETA
  { 0x0371, BIDI_L   },  // GREEK SMALL LETTER HETA
  { 0x0372, BIDI_L   },  // GREEK CAPITAL LETTER ARCHAIC SAMPI
  { 0x0373, BIDI_L   },  // GREEK SMALL LETTER ARCHAIC SAMPI
  { 0x0374, BIDI_ON  },  // GREEK NUMERAL SIGN
  { 0x0375, BIDI_ON  },  // GREEK LOWER NUMERAL SIGN
  { 0x0376, BIDI_L   },  // GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
  { 0x0377, BIDI_L   },  // GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
  { 0x037A, BIDI_L   },  // GREEK YPOGEGRAMMENI
  { 0x037B, BIDI_L   },  // GREEK SMALL REVERSED LUNATE SIGMA SYMBOL
  { 0x037C, BIDI_L   },  // GREEK SMALL DOTTED LUNATE SIGMA SYMBOL
  { 0x037D, BIDI_L   },  // GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
  { 0x037E, BIDI_ON  },  // GREEK QUESTION MARK
  { 0x037F, BIDI_L   },  // GREEK CAPITAL LETTER YOT
  { 0x0384, BIDI_ON  },  // GREEK TONOS
  { 0x0385, BIDI_ON  },  // GREEK DIALYTIKA TONOS
  { 0x0386, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH TONOS
  { 0x0387, BIDI_ON  },  // GREEK ANO TELEIA
  { 0x0388, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH TONOS
  { 0x0389, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH TONOS
  { 0x038A, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH TONOS
  { 0x038C, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH TONOS
  { 0x038E, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH TONOS
  { 0x038F, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH TONOS
  { 0x0390, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
  { 0x0391, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA
  { 0x0392, BIDI_L   },  // GREEK CAPITAL LETTER BETA
  { 0x0393, BIDI_L   },  // GREEK CAPITAL LETTER GAMMA
  { 0x0394, BIDI_L   },  // GREEK CAPITAL LETTER DELTA
  { 0x0395, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON
  { 0x0396, BIDI_L   },  // GREEK CAPITAL LETTER ZETA
  { 0x0397, BIDI_L   },  // GREEK CAPITAL LETTER ETA
  { 0x0398, BIDI_L   },  // GREEK CAPITAL LETTER THETA
  { 0x0399, BIDI_L   },  // GREEK CAPITAL LETTER IOTA
  { 0x039A, BIDI_L   },  // GREEK CAPITAL LETTER KAPPA
  { 0x039B, BIDI_L   },  // GREEK CAPITAL LETTER LAMDA
  { 0x039C, BIDI_L   },  // GREEK CAPITAL LETTER MU
  { 0x039D, BIDI_L   },  // GREEK CAPITAL LETTER NU
  { 0x039E, BIDI_L   },  // GREEK CAPITAL LETTER XI
  { 0x039F, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON
  { 0x03A0, BIDI_L   },  // GREEK CAPITAL LETTER PI
  { 0x03A1, BIDI_L   },  // GREEK CAPITAL LETTER RHO
  { 0x03A3, BIDI_L   },  // GREEK CAPITAL LETTER SIGMA
  { 0x03A4, BIDI_L   },  // GREEK CAPITAL LETTER TAU
  { 0x03A5, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON
  { 0x03A6, BIDI_L   },  // GREEK CAPITAL LETTER PHI
  { 0x03A7, BIDI_L   },  // GREEK CAPITAL LETTER CHI
  { 0x03A8, BIDI_L   },  // GREEK CAPITAL LETTER PSI
  { 0x03A9, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA
  { 0x03AA, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
  { 0x03AB, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
  { 0x03AC, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH TONOS
  { 0x03AD, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH TONOS
  { 0x03AE, BIDI_L   },  // GREEK SMALL LETTER ETA WITH TONOS
  { 0x03AF, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH TONOS
  { 0x03B0, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
  { 0x03B1, BIDI_L   },  // GREEK SMALL LETTER ALPHA
  { 0x03B2, BIDI_L   },  // GREEK SMALL LETTER BETA
  { 0x03B3, BIDI_L   },  // GREEK SMALL LETTER GAMMA
  { 0x03B4, BIDI_L   },  // GREEK SMALL LETTER DELTA
  { 0x03B5, BIDI_L   },  // GREEK SMALL LETTER EPSILON
  { 0x03B6, BIDI_L   },  // GREEK SMALL LETTER ZETA
  { 0x03B7, BIDI_L   },  // GREEK SMALL LETTER ETA
  { 0x03B8, BIDI_L   },  // GREEK SMALL LETTER THETA
  { 0x03B9, BIDI_L   },  // GREEK SMALL LETTER IOTA
  { 0x03BA, BIDI_L   },  // GREEK SMALL LETTER KAPPA
  { 0x03BB, BIDI_L   },  // GREEK SMALL LETTER LAMDA
  { 0x03BC, BIDI_L   },  // GREEK SMALL LETTER MU
  { 0x03BD, BIDI_L   },  // GREEK SMALL LETTER NU
  { 0x03BE, BIDI_L   },  // GREEK SMALL LETTER XI
  { 0x03BF, BIDI_L   },  // GREEK SMALL LETTER OMICRON
  { 0x03C0, BIDI_L   },  // GREEK SMALL LETTER PI
  { 0x03C1, BIDI_L   },  // GREEK SMALL LETTER RHO
  { 0x03C2, BIDI_L   },  // GREEK SMALL LETTER FINAL SIGMA
  { 0x03C3, BIDI_L   },  // GREEK SMALL LETTER SIGMA
  { 0x03C4, BIDI_L   },  // GREEK SMALL LETTER TAU
  { 0x03C5, BIDI_L   },  // GREEK SMALL LETTER UPSILON
  { 0x03C6, BIDI_L   },  // GREEK SMALL LETTER PHI
  { 0x03C7, BIDI_L   },  // GREEK SMALL LETTER CHI
  { 0x03C8, BIDI_L   },  // GREEK SMALL LETTER PSI
  { 0x03C9, BIDI_L   },  // GREEK SMALL LETTER OMEGA
  { 0x03CA, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DIALYTIKA
  { 0x03CB, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DIALYTIKA
  { 0x03CC, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH TONOS
  { 0x03CD, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH TONOS
  { 0x03CE, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH TONOS
  { 0x03CF, BIDI_L   },  // GREEK CAPITAL KAI SYMBOL
  { 0x03D0, BIDI_L   },  // GREEK BETA SYMBOL
  { 0x03D1, BIDI_L   },  // GREEK THETA SYMBOL
  { 0x03D2, BIDI_L   },  // GREEK UPSILON WITH HOOK SYMBOL
  { 0x03D3, BIDI_L   },  // GREEK UPSILON WITH ACUTE AND HOOK SYMBOL
  { 0x03D4, BIDI_L   },  // GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
  { 0x03D5, BIDI_L   },  // GREEK PHI SYMBOL
  { 0x03D6, BIDI_L   },  // GREEK PI SYMBOL
  { 0x03D7, BIDI_L   },  // GREEK KAI SYMBOL
  { 0x03D8, BIDI_L   },  // GREEK LETTER ARCHAIC KOPPA
  { 0x03D9, BIDI_L   },  // GREEK SMALL LETTER ARCHAIC KOPPA
  { 0x03DA, BIDI_L   },  // GREEK LETTER STIGMA
  { 0x03DB, BIDI_L   },  // GREEK SMALL LETTER STIGMA
  { 0x03DC, BIDI_L   },  // GREEK LETTER DIGAMMA
  { 0x03DD, BIDI_L   },  // GREEK SMALL LETTER DIGAMMA
  { 0x03DE, BIDI_L   },  // GREEK LETTER KOPPA
  { 0x03DF, BIDI_L   },  // GREEK SMALL LETTER KOPPA
  { 0x03E0, BIDI_L   },  // GREEK LETTER SAMPI
  { 0x03E1, BIDI_L   },  // GREEK SMALL LETTER SAMPI
  { 0x03E2, BIDI_L   },  // COPTIC CAPITAL LETTER SHEI
  { 0x03E3, BIDI_L   },  // COPTIC SMALL LETTER SHEI
  { 0x03E4, BIDI_L   },  // COPTIC CAPITAL LETTER FEI
  { 0x03E5, BIDI_L   },  // COPTIC SMALL LETTER FEI
  { 0x03E6, BIDI_L   },  // COPTIC CAPITAL LETTER KHEI
  { 0x03E7, BIDI_L   },  // COPTIC SMALL LETTER KHEI
  { 0x03E8, BIDI_L   },  // COPTIC CAPITAL LETTER HORI
  { 0x03E9, BIDI_L   },  // COPTIC SMALL LETTER HORI
  { 0x03EA, BIDI_L   },  // COPTIC CAPITAL LETTER GANGIA
  { 0x03EB, BIDI_L   },  // COPTIC SMALL LETTER GANGIA
  { 0x03EC, BIDI_L   },  // COPTIC CAPITAL LETTER SHIMA
  { 0x03ED, BIDI_L   },  // COPTIC SMALL LETTER SHIMA
  { 0x03EE, BIDI_L   },  // COPTIC CAPITAL LETTER DEI
  { 0x03EF, BIDI_L   },  // COPTIC SMALL LETTER DEI
  { 0x03F0, BIDI_L   },  // GREEK KAPPA SYMBOL
  { 0x03F1, BIDI_L   },  // GREEK RHO SYMBOL
  { 0x03F2, BIDI_L   },  // GREEK LUNATE SIGMA SYMBOL
  { 0x03F3, BIDI_L   },  // GREEK LETTER YOT
  { 0x03F4, BIDI_L   },  // GREEK CAPITAL THETA SYMBOL
  { 0x03F5, BIDI_L   },  // GREEK LUNATE EPSILON SYMBOL
  { 0x03F6, BIDI_ON  },  // GREEK REVERSED LUNATE EPSILON SYMBOL
  { 0x03F7, BIDI_L   },  // GREEK CAPITAL LETTER SHO
  { 0x03F8, BIDI_L   },  // GREEK SMALL LETTER SHO
  { 0x03F9, BIDI_L   },  // GREEK CAPITAL LUNATE SIGMA SYMBOL
  { 0x03FA, BIDI_L   },  // GREEK CAPITAL LETTER SAN
  { 0x03FB, BIDI_L   },  // GREEK SMALL LETTER SAN
  { 0x03FC, BIDI_L   },  // GREEK RHO WITH STROKE SYMBOL
  { 0x03FD, BIDI_L   },  // GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL
  { 0x03FE, BIDI_L   },  // GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL
  { 0x03FF, BIDI_L   },  // GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL
  { 0x0400, BIDI_L   },  // CYRILLIC CAPITAL LETTER IE WITH GRAVE
  { 0x0401, BIDI_L   },  // CYRILLIC CAPITAL LETTER IO
  { 0x0402, BIDI_L   },  // CYRILLIC CAPITAL LETTER DJE
  { 0x0403, BIDI_L   },  // CYRILLIC CAPITAL LETTER GJE
  { 0x0404, BIDI_L   },  // CYRILLIC CAPITAL LETTER UKRAINIAN IE
  { 0x0405, BIDI_L   },  // CYRILLIC CAPITAL LETTER DZE
  { 0x0406, BIDI_L   },  // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
  { 0x0407, BIDI_L   },  // CYRILLIC CAPITAL LETTER YI
  { 0x0408, BIDI_L   },  // CYRILLIC CAPITAL LETTER JE
  { 0x0409, BIDI_L   },  // CYRILLIC CAPITAL LETTER LJE
  { 0x040A, BIDI_L   },  // CYRILLIC CAPITAL LETTER NJE
  { 0x040B, BIDI_L   },  // CYRILLIC CAPITAL LETTER TSHE
  { 0x040C, BIDI_L   },  // CYRILLIC CAPITAL LETTER KJE
  { 0x040D, BIDI_L   },  // CYRILLIC CAPITAL LETTER I WITH GRAVE
  { 0x040E, BIDI_L   },  // CYRILLIC CAPITAL LETTER SHORT U
  { 0x040F, BIDI_L   },  // CYRILLIC CAPITAL LETTER DZHE
  { 0x0410, BIDI_L   },  // CYRILLIC CAPITAL LETTER A
  { 0x0411, BIDI_L   },  // CYRILLIC CAPITAL LETTER BE
  { 0x0412, BIDI_L   },  // CYRILLIC CAPITAL LETTER VE
  { 0x0413, BIDI_L   },  // CYRILLIC CAPITAL LETTER GHE
  { 0x0414, BIDI_L   },  // CYRILLIC CAPITAL LETTER DE
  { 0x0415, BIDI_L   },  // CYRILLIC CAPITAL LETTER IE
  { 0x0416, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZHE
  { 0x0417, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZE
  { 0x0418, BIDI_L   },  // CYRILLIC CAPITAL LETTER I
  { 0x0419, BIDI_L   },  // CYRILLIC CAPITAL LETTER SHORT I
  { 0x041A, BIDI_L   },  // CYRILLIC CAPITAL LETTER KA
  { 0x041B, BIDI_L   },  // CYRILLIC CAPITAL LETTER EL
  { 0x041C, BIDI_L   },  // CYRILLIC CAPITAL LETTER EM
  { 0x041D, BIDI_L   },  // CYRILLIC CAPITAL LETTER EN
  { 0x041E, BIDI_L   },  // CYRILLIC CAPITAL LETTER O
  { 0x041F, BIDI_L   },  // CYRILLIC CAPITAL LETTER PE
  { 0x0420, BIDI_L   },  // CYRILLIC CAPITAL LETTER ER
  { 0x0421, BIDI_L   },  // CYRILLIC CAPITAL LETTER ES
  { 0x0422, BIDI_L   },  // CYRILLIC CAPITAL LETTER TE
  { 0x0423, BIDI_L   },  // CYRILLIC CAPITAL LETTER U
  { 0x0424, BIDI_L   },  // CYRILLIC CAPITAL LETTER EF
  { 0x0425, BIDI_L   },  // CYRILLIC CAPITAL LETTER HA
  { 0x0426, BIDI_L   },  // CYRILLIC CAPITAL LETTER TSE
  { 0x0427, BIDI_L   },  // CYRILLIC CAPITAL LETTER CHE
  { 0x0428, BIDI_L   },  // CYRILLIC CAPITAL LETTER SHA
  { 0x0429, BIDI_L   },  // CYRILLIC CAPITAL LETTER SHCHA
  { 0x042A, BIDI_L   },  // CYRILLIC CAPITAL LETTER HARD SIGN
  { 0x042B, BIDI_L   },  // CYRILLIC CAPITAL LETTER YERU
  { 0x042C, BIDI_L   },  // CYRILLIC CAPITAL LETTER SOFT SIGN
  { 0x042D, BIDI_L   },  // CYRILLIC CAPITAL LETTER E
  { 0x042E, BIDI_L   },  // CYRILLIC CAPITAL LETTER YU
  { 0x042F, BIDI_L   },  // CYRILLIC CAPITAL LETTER YA
  { 0x0430, BIDI_L   },  // CYRILLIC SMALL LETTER A
  { 0x0431, BIDI_L   },  // CYRILLIC SMALL LETTER BE
  { 0x0432, BIDI_L   },  // CYRILLIC SMALL LETTER VE
  { 0x0433, BIDI_L   },  // CYRILLIC SMALL LETTER GHE
  { 0x0434, BIDI_L   },  // CYRILLIC SMALL LETTER DE
  { 0x0435, BIDI_L   },  // CYRILLIC SMALL LETTER IE
  { 0x0436, BIDI_L   },  // CYRILLIC SMALL LETTER ZHE
  { 0x0437, BIDI_L   },  // CYRILLIC SMALL LETTER ZE
  { 0x0438, BIDI_L   },  // CYRILLIC SMALL LETTER I
  { 0x0439, BIDI_L   },  // CYRILLIC SMALL LETTER SHORT I
  { 0x043A, BIDI_L   },  // CYRILLIC SMALL LETTER KA
  { 0x043B, BIDI_L   },  // CYRILLIC SMALL LETTER EL
  { 0x043C, BIDI_L   },  // CYRILLIC SMALL LETTER EM
  { 0x043D, BIDI_L   },  // CYRILLIC SMALL LETTER EN
  { 0x043E, BIDI_L   },  // CYRILLIC SMALL LETTER O
  { 0x043F, BIDI_L   },  // CYRILLIC SMALL LETTER PE
  { 0x0440, BIDI_L   },  // CYRILLIC SMALL LETTER ER
  { 0x0441, BIDI_L   },  // CYRILLIC SMALL LETTER ES
  { 0x0442, BIDI_L   },  // CYRILLIC SMALL LETTER TE
  { 0x0443, BIDI_L   },  // CYRILLIC SMALL LETTER U
  { 0x0444, BIDI_L   },  // CYRILLIC SMALL LETTER EF
  { 0x0445, BIDI_L   },  // CYRILLIC SMALL LETTER HA
  { 0x0446, BIDI_L   },  // CYRILLIC SMALL LETTER TSE
  { 0x0447, BIDI_L   },  // CYRILLIC SMALL LETTER CHE
  { 0x0448, BIDI_L   },  // CYRILLIC SMALL LETTER SHA
  { 0x0449, BIDI_L   },  // CYRILLIC SMALL LETTER SHCHA
  { 0x044A, BIDI_L   },  // CYRILLIC SMALL LETTER HARD SIGN
  { 0x044B, BIDI_L   },  // CYRILLIC SMALL LETTER YERU
  { 0x044C, BIDI_L   },  // CYRILLIC SMALL LETTER SOFT SIGN
  { 0x044D, BIDI_L   },  // CYRILLIC SMALL LETTER E
  { 0x044E, BIDI_L   },  // CYRILLIC SMALL LETTER YU
  { 0x044F, BIDI_L   },  // CYRILLIC SMALL LETTER YA
  { 0x0450, BIDI_L   },  // CYRILLIC SMALL LETTER IE WITH GRAVE
  { 0x0451, BIDI_L   },  // CYRILLIC SMALL LETTER IO
  { 0x0452, BIDI_L   },  // CYRILLIC SMALL LETTER DJE
  { 0x0453, BIDI_L   },  // CYRILLIC SMALL LETTER GJE
  { 0x0454, BIDI_L   },  // CYRILLIC SMALL LETTER UKRAINIAN IE
  { 0x0455, BIDI_L   },  // CYRILLIC SMALL LETTER DZE
  { 0x0456, BIDI_L   },  // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
  { 0x0457, BIDI_L   },  // CYRILLIC SMALL LETTER YI
  { 0x0458, BIDI_L   },  // CYRILLIC SMALL LETTER JE
  { 0x0459, BIDI_L   },  // CYRILLIC SMALL LETTER LJE
  { 0x045A, BIDI_L   },  // CYRILLIC SMALL LETTER NJE
  { 0x045B, BIDI_L   },  // CYRILLIC SMALL LETTER TSHE
  { 0x045C, BIDI_L   },  // CYRILLIC SMALL LETTER KJE
  { 0x045D, BIDI_L   },  // CYRILLIC SMALL LETTER I WITH GRAVE
  { 0x045E, BIDI_L   },  // CYRILLIC SMALL LETTER SHORT U
  { 0x045F, BIDI_L   },  // CYRILLIC SMALL LETTER DZHE
  { 0x0460, BIDI_L   },  // CYRILLIC CAPITAL LETTER OMEGA
  { 0x0461, BIDI_L   },  // CYRILLIC SMALL LETTER OMEGA
  { 0x0462, BIDI_L   },  // CYRILLIC CAPITAL LETTER YAT
  { 0x0463, BIDI_L   },  // CYRILLIC SMALL LETTER YAT
  { 0x0464, BIDI_L   },  // CYRILLIC CAPITAL LETTER IOTIFIED E
  { 0x0465, BIDI_L   },  // CYRILLIC SMALL LETTER IOTIFIED E
  { 0x0466, BIDI_L   },  // CYRILLIC CAPITAL LETTER LITTLE YUS
  { 0x0467, BIDI_L   },  // CYRILLIC SMALL LETTER LITTLE YUS
  { 0x0468, BIDI_L   },  // CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
  { 0x0469, BIDI_L   },  // CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
  { 0x046A, BIDI_L   },  // CYRILLIC CAPITAL LETTER BIG YUS
  { 0x046B, BIDI_L   },  // CYRILLIC SMALL LETTER BIG YUS
  { 0x046C, BIDI_L   },  // CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
  { 0x046D, BIDI_L   },  // CYRILLIC SMALL LETTER IOTIFIED BIG YUS
  { 0x046E, BIDI_L   },  // CYRILLIC CAPITAL LETTER KSI
  { 0x046F, BIDI_L   },  // CYRILLIC SMALL LETTER KSI
  { 0x0470, BIDI_L   },  // CYRILLIC CAPITAL LETTER PSI
  { 0x0471, BIDI_L   },  // CYRILLIC SMALL LETTER PSI
  { 0x0472, BIDI_L   },  // CYRILLIC CAPITAL LETTER FITA
  { 0x0473, BIDI_L   },  // CYRILLIC SMALL LETTER FITA
  { 0x0474, BIDI_L   },  // CYRILLIC CAPITAL LETTER IZHITSA
  { 0x0475, BIDI_L   },  // CYRILLIC SMALL LETTER IZHITSA
  { 0x0476, BIDI_L   },  // CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
  { 0x0477, BIDI_L   },  // CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
  { 0x0478, BIDI_L   },  // CYRILLIC CAPITAL LETTER UK
  { 0x0479, BIDI_L   },  // CYRILLIC SMALL LETTER UK
  { 0x047A, BIDI_L   },  // CYRILLIC CAPITAL LETTER ROUND OMEGA
  { 0x047B, BIDI_L   },  // CYRILLIC SMALL LETTER ROUND OMEGA
  { 0x047C, BIDI_L   },  // CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
  { 0x047D, BIDI_L   },  // CYRILLIC SMALL LETTER OMEGA WITH TITLO
  { 0x047E, BIDI_L   },  // CYRILLIC CAPITAL LETTER OT
  { 0x047F, BIDI_L   },  // CYRILLIC SMALL LETTER OT
  { 0x0480, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOPPA
  { 0x0481, BIDI_L   },  // CYRILLIC SMALL LETTER KOPPA
  { 0x0482, BIDI_L   },  // CYRILLIC THOUSANDS SIGN
  { 0x0483, BIDI_NSM },  // COMBINING CYRILLIC TITLO
  { 0x0484, BIDI_NSM },  // COMBINING CYRILLIC PALATALIZATION
  { 0x0485, BIDI_NSM },  // COMBINING CYRILLIC DASIA PNEUMATA
  { 0x0486, BIDI_NSM },  // COMBINING CYRILLIC PSILI PNEUMATA
  { 0x0487, BIDI_NSM },  // COMBINING CYRILLIC POKRYTIE
  { 0x0488, BIDI_NSM },  // COMBINING CYRILLIC HUNDRED THOUSANDS SIGN
  { 0x0489, BIDI_NSM },  // COMBINING CYRILLIC MILLIONS SIGN
  { 0x048A, BIDI_L   },  // CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
  { 0x048B, BIDI_L   },  // CYRILLIC SMALL LETTER SHORT I WITH TAIL
  { 0x048C, BIDI_L   },  // CYRILLIC CAPITAL LETTER SEMISOFT SIGN
  { 0x048D, BIDI_L   },  // CYRILLIC SMALL LETTER SEMISOFT SIGN
  { 0x048E, BIDI_L   },  // CYRILLIC CAPITAL LETTER ER WITH TICK
  { 0x048F, BIDI_L   },  // CYRILLIC SMALL LETTER ER WITH TICK
  { 0x0490, BIDI_L   },  // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
  { 0x0491, BIDI_L   },  // CYRILLIC SMALL LETTER GHE WITH UPTURN
  { 0x0492, BIDI_L   },  // CYRILLIC CAPITAL LETTER GHE WITH STROKE
  { 0x0493, BIDI_L   },  // CYRILLIC SMALL LETTER GHE WITH STROKE
  { 0x0494, BIDI_L   },  // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
  { 0x0495, BIDI_L   },  // CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
  { 0x0496, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
  { 0x0497, BIDI_L   },  // CYRILLIC SMALL LETTER ZHE WITH DESCENDER
  { 0x0498, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
  { 0x0499, BIDI_L   },  // CYRILLIC SMALL LETTER ZE WITH DESCENDER
  { 0x049A, BIDI_L   },  // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
  { 0x049B, BIDI_L   },  // CYRILLIC SMALL LETTER KA WITH DESCENDER
  { 0x049C, BIDI_L   },  // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
  { 0x049D, BIDI_L   },  // CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
  { 0x049E, BIDI_L   },  // CYRILLIC CAPITAL LETTER KA WITH STROKE
  { 0x049F, BIDI_L   },  // CYRILLIC SMALL LETTER KA WITH STROKE
  { 0x04A0, BIDI_L   },  // CYRILLIC CAPITAL LETTER BASHKIR KA
  { 0x04A1, BIDI_L   },  // CYRILLIC SMALL LETTER BASHKIR KA
  { 0x04A2, BIDI_L   },  // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
  { 0x04A3, BIDI_L   },  // CYRILLIC SMALL LETTER EN WITH DESCENDER
  { 0x04A4, BIDI_L   },  // CYRILLIC CAPITAL LIGATURE EN GHE
  { 0x04A5, BIDI_L   },  // CYRILLIC SMALL LIGATURE EN GHE
  { 0x04A6, BIDI_L   },  // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
  { 0x04A7, BIDI_L   },  // CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
  { 0x04A8, BIDI_L   },  // CYRILLIC CAPITAL LETTER ABKHASIAN HA
  { 0x04A9, BIDI_L   },  // CYRILLIC SMALL LETTER ABKHASIAN HA
  { 0x04AA, BIDI_L   },  // CYRILLIC CAPITAL LETTER ES WITH DESCENDER
  { 0x04AB, BIDI_L   },  // CYRILLIC SMALL LETTER ES WITH DESCENDER
  { 0x04AC, BIDI_L   },  // CYRILLIC CAPITAL LETTER TE WITH DESCENDER
  { 0x04AD, BIDI_L   },  // CYRILLIC SMALL LETTER TE WITH DESCENDER
  { 0x04AE, BIDI_L   },  // CYRILLIC CAPITAL LETTER STRAIGHT U
  { 0x04AF, BIDI_L   },  // CYRILLIC SMALL LETTER STRAIGHT U
  { 0x04B0, BIDI_L   },  // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
  { 0x04B1, BIDI_L   },  // CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
  { 0x04B2, BIDI_L   },  // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
  { 0x04B3, BIDI_L   },  // CYRILLIC SMALL LETTER HA WITH DESCENDER
  { 0x04B4, BIDI_L   },  // CYRILLIC CAPITAL LIGATURE TE TSE
  { 0x04B5, BIDI_L   },  // CYRILLIC SMALL LIGATURE TE TSE
  { 0x04B6, BIDI_L   },  // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
  { 0x04B7, BIDI_L   },  // CYRILLIC SMALL LETTER CHE WITH DESCENDER
  { 0x04B8, BIDI_L   },  // CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
  { 0x04B9, BIDI_L   },  // CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
  { 0x04BA, BIDI_L   },  // CYRILLIC CAPITAL LETTER SHHA
  { 0x04BB, BIDI_L   },  // CYRILLIC SMALL LETTER SHHA
  { 0x04BC, BIDI_L   },  // CYRILLIC CAPITAL LETTER ABKHASIAN CHE
  { 0x04BD, BIDI_L   },  // CYRILLIC SMALL LETTER ABKHASIAN CHE
  { 0x04BE, BIDI_L   },  // CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
  { 0x04BF, BIDI_L   },  // CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
  { 0x04C0, BIDI_L   },  // CYRILLIC LETTER PALOCHKA
  { 0x04C1, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZHE WITH BREVE
  { 0x04C2, BIDI_L   },  // CYRILLIC SMALL LETTER ZHE WITH BREVE
  { 0x04C3, BIDI_L   },  // CYRILLIC CAPITAL LETTER KA WITH HOOK
  { 0x04C4, BIDI_L   },  // CYRILLIC SMALL LETTER KA WITH HOOK
  { 0x04C5, BIDI_L   },  // CYRILLIC CAPITAL LETTER EL WITH TAIL
  { 0x04C6, BIDI_L   },  // CYRILLIC SMALL LETTER EL WITH TAIL
  { 0x04C7, BIDI_L   },  // CYRILLIC CAPITAL LETTER EN WITH HOOK
  { 0x04C8, BIDI_L   },  // CYRILLIC SMALL LETTER EN WITH HOOK
  { 0x04C9, BIDI_L   },  // CYRILLIC CAPITAL LETTER EN WITH TAIL
  { 0x04CA, BIDI_L   },  // CYRILLIC SMALL LETTER EN WITH TAIL
  { 0x04CB, BIDI_L   },  // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
  { 0x04CC, BIDI_L   },  // CYRILLIC SMALL LETTER KHAKASSIAN CHE
  { 0x04CD, BIDI_L   },  // CYRILLIC CAPITAL LETTER EM WITH TAIL
  { 0x04CE, BIDI_L   },  // CYRILLIC SMALL LETTER EM WITH TAIL
  { 0x04CF, BIDI_L   },  // CYRILLIC SMALL LETTER PALOCHKA
  { 0x04D0, BIDI_L   },  // CYRILLIC CAPITAL LETTER A WITH BREVE
  { 0x04D1, BIDI_L   },  // CYRILLIC SMALL LETTER A WITH BREVE
  { 0x04D2, BIDI_L   },  // CYRILLIC CAPITAL LETTER A WITH DIAERESIS
  { 0x04D3, BIDI_L   },  // CYRILLIC SMALL LETTER A WITH DIAERESIS
  { 0x04D4, BIDI_L   },  // CYRILLIC CAPITAL LIGATURE A IE
  { 0x04D5, BIDI_L   },  // CYRILLIC SMALL LIGATURE A IE
  { 0x04D6, BIDI_L   },  // CYRILLIC CAPITAL LETTER IE WITH BREVE
  { 0x04D7, BIDI_L   },  // CYRILLIC SMALL LETTER IE WITH BREVE
  { 0x04D8, BIDI_L   },  // CYRILLIC CAPITAL LETTER SCHWA
  { 0x04D9, BIDI_L   },  // CYRILLIC SMALL LETTER SCHWA
  { 0x04DA, BIDI_L   },  // CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
  { 0x04DB, BIDI_L   },  // CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
  { 0x04DC, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
  { 0x04DD, BIDI_L   },  // CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
  { 0x04DE, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
  { 0x04DF, BIDI_L   },  // CYRILLIC SMALL LETTER ZE WITH DIAERESIS
  { 0x04E0, BIDI_L   },  // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
  { 0x04E1, BIDI_L   },  // CYRILLIC SMALL LETTER ABKHASIAN DZE
  { 0x04E2, BIDI_L   },  // CYRILLIC CAPITAL LETTER I WITH MACRON
  { 0x04E3, BIDI_L   },  // CYRILLIC SMALL LETTER I WITH MACRON
  { 0x04E4, BIDI_L   },  // CYRILLIC CAPITAL LETTER I WITH DIAERESIS
  { 0x04E5, BIDI_L   },  // CYRILLIC SMALL LETTER I WITH DIAERESIS
  { 0x04E6, BIDI_L   },  // CYRILLIC CAPITAL LETTER O WITH DIAERESIS
  { 0x04E7, BIDI_L   },  // CYRILLIC SMALL LETTER O WITH DIAERESIS
  { 0x04E8, BIDI_L   },  // CYRILLIC CAPITAL LETTER BARRED O
  { 0x04E9, BIDI_L   },  // CYRILLIC SMALL LETTER BARRED O
  { 0x04EA, BIDI_L   },  // CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
  { 0x04EB, BIDI_L   },  // CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
  { 0x04EC, BIDI_L   },  // CYRILLIC CAPITAL LETTER E WITH DIAERESIS
  { 0x04ED, BIDI_L   },  // CYRILLIC SMALL LETTER E WITH DIAERESIS
  { 0x04EE, BIDI_L   },  // CYRILLIC CAPITAL LETTER U WITH MACRON
  { 0x04EF, BIDI_L   },  // CYRILLIC SMALL LETTER U WITH MACRON
  { 0x04F0, BIDI_L   },  // CYRILLIC CAPITAL LETTER U WITH DIAERESIS
  { 0x04F1, BIDI_L   },  // CYRILLIC SMALL LETTER U WITH DIAERESIS
  { 0x04F2, BIDI_L   },  // CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
  { 0x04F3, BIDI_L   },  // CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
  { 0x04F4, BIDI_L   },  // CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
  { 0x04F5, BIDI_L   },  // CYRILLIC SMALL LETTER CHE WITH DIAERESIS
  { 0x04F6, BIDI_L   },  // CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
  { 0x04F7, BIDI_L   },  // CYRILLIC SMALL LETTER GHE WITH DESCENDER
  { 0x04F8, BIDI_L   },  // CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
  { 0x04F9, BIDI_L   },  // CYRILLIC SMALL LETTER YERU WITH DIAERESIS
  { 0x04FA, BIDI_L   },  // CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
  { 0x04FB, BIDI_L   },  // CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK
  { 0x04FC, BIDI_L   },  // CYRILLIC CAPITAL LETTER HA WITH HOOK
  { 0x04FD, BIDI_L   },  // CYRILLIC SMALL LETTER HA WITH HOOK
  { 0x04FE, BIDI_L   },  // CYRILLIC CAPITAL LETTER HA WITH STROKE
  { 0x04FF, BIDI_L   },  // CYRILLIC SMALL LETTER HA WITH STROKE
  { 0x0500, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOMI DE
  { 0x0501, BIDI_L   },  // CYRILLIC SMALL LETTER KOMI DE
  { 0x0502, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOMI DJE
  { 0x0503, BIDI_L   },  // CYRILLIC SMALL LETTER KOMI DJE
  { 0x0504, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOMI ZJE
  { 0x0505, BIDI_L   },  // CYRILLIC SMALL LETTER KOMI ZJE
  { 0x0506, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOMI DZJE
  { 0x0507, BIDI_L   },  // CYRILLIC SMALL LETTER KOMI DZJE
  { 0x0508, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOMI LJE
  { 0x0509, BIDI_L   },  // CYRILLIC SMALL LETTER KOMI LJE
  { 0x050A, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOMI NJE
  { 0x050B, BIDI_L   },  // CYRILLIC SMALL LETTER KOMI NJE
  { 0x050C, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOMI SJE
  { 0x050D, BIDI_L   },  // CYRILLIC SMALL LETTER KOMI SJE
  { 0x050E, BIDI_L   },  // CYRILLIC CAPITAL LETTER KOMI TJE
  { 0x050F, BIDI_L   },  // CYRILLIC SMALL LETTER KOMI TJE
  { 0x0510, BIDI_L   },  // CYRILLIC CAPITAL LETTER REVERSED ZE
  { 0x0511, BIDI_L   },  // CYRILLIC SMALL LETTER REVERSED ZE
  { 0x0512, BIDI_L   },  // CYRILLIC CAPITAL LETTER EL WITH HOOK
  { 0x0513, BIDI_L   },  // CYRILLIC SMALL LETTER EL WITH HOOK
  { 0x0514, BIDI_L   },  // CYRILLIC CAPITAL LETTER LHA
  { 0x0515, BIDI_L   },  // CYRILLIC SMALL LETTER LHA
  { 0x0516, BIDI_L   },  // CYRILLIC CAPITAL LETTER RHA
  { 0x0517, BIDI_L   },  // CYRILLIC SMALL LETTER RHA
  { 0x0518, BIDI_L   },  // CYRILLIC CAPITAL LETTER YAE
  { 0x0519, BIDI_L   },  // CYRILLIC SMALL LETTER YAE
  { 0x051A, BIDI_L   },  // CYRILLIC CAPITAL LETTER QA
  { 0x051B, BIDI_L   },  // CYRILLIC SMALL LETTER QA
  { 0x051C, BIDI_L   },  // CYRILLIC CAPITAL LETTER WE
  { 0x051D, BIDI_L   },  // CYRILLIC SMALL LETTER WE
  { 0x051E, BIDI_L   },  // CYRILLIC CAPITAL LETTER ALEUT KA
  { 0x051F, BIDI_L   },  // CYRILLIC SMALL LETTER ALEUT KA
  { 0x0520, BIDI_L   },  // CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
  { 0x0521, BIDI_L   },  // CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK
  { 0x0522, BIDI_L   },  // CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
  { 0x0523, BIDI_L   },  // CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK
  { 0x0524, BIDI_L   },  // CYRILLIC CAPITAL LETTER PE WITH DESCENDER
  { 0x0525, BIDI_L   },  // CYRILLIC SMALL LETTER PE WITH DESCENDER
  { 0x0526, BIDI_L   },  // CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER
  { 0x0527, BIDI_L   },  // CYRILLIC SMALL LETTER SHHA WITH DESCENDER
  { 0x0528, BIDI_L   },  // CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK
  { 0x0529, BIDI_L   },  // CYRILLIC SMALL LETTER EN WITH LEFT HOOK
  { 0x052A, BIDI_L   },  // CYRILLIC CAPITAL LETTER DZZHE
  { 0x052B, BIDI_L   },  // CYRILLIC SMALL LETTER DZZHE
  { 0x052C, BIDI_L   },  // CYRILLIC CAPITAL LETTER DCHE
  { 0x052D, BIDI_L   },  // CYRILLIC SMALL LETTER DCHE
  { 0x052E, BIDI_L   },  // CYRILLIC CAPITAL LETTER EL WITH DESCENDER
  { 0x052F, BIDI_L   },  // CYRILLIC SMALL LETTER EL WITH DESCENDER
  { 0x0531, BIDI_L   },  // ARMENIAN CAPITAL LETTER AYB
  { 0x0532, BIDI_L   },  // ARMENIAN CAPITAL LETTER BEN
  { 0x0533, BIDI_L   },  // ARMENIAN CAPITAL LETTER GIM
  { 0x0534, BIDI_L   },  // ARMENIAN CAPITAL LETTER DA
  { 0x0535, BIDI_L   },  // ARMENIAN CAPITAL LETTER ECH
  { 0x0536, BIDI_L   },  // ARMENIAN CAPITAL LETTER ZA
  { 0x0537, BIDI_L   },  // ARMENIAN CAPITAL LETTER EH
  { 0x0538, BIDI_L   },  // ARMENIAN CAPITAL LETTER ET
  { 0x0539, BIDI_L   },  // ARMENIAN CAPITAL LETTER TO
  { 0x053A, BIDI_L   },  // ARMENIAN CAPITAL LETTER ZHE
  { 0x053B, BIDI_L   },  // ARMENIAN CAPITAL LETTER INI
  { 0x053C, BIDI_L   },  // ARMENIAN CAPITAL LETTER LIWN
  { 0x053D, BIDI_L   },  // ARMENIAN CAPITAL LETTER XEH
  { 0x053E, BIDI_L   },  // ARMENIAN CAPITAL LETTER CA
  { 0x053F, BIDI_L   },  // ARMENIAN CAPITAL LETTER KEN
  { 0x0540, BIDI_L   },  // ARMENIAN CAPITAL LETTER HO
  { 0x0541, BIDI_L   },  // ARMENIAN CAPITAL LETTER JA
  { 0x0542, BIDI_L   },  // ARMENIAN CAPITAL LETTER GHAD
  { 0x0543, BIDI_L   },  // ARMENIAN CAPITAL LETTER CHEH
  { 0x0544, BIDI_L   },  // ARMENIAN CAPITAL LETTER MEN
  { 0x0545, BIDI_L   },  // ARMENIAN CAPITAL LETTER YI
  { 0x0546, BIDI_L   },  // ARMENIAN CAPITAL LETTER NOW
  { 0x0547, BIDI_L   },  // ARMENIAN CAPITAL LETTER SHA
  { 0x0548, BIDI_L   },  // ARMENIAN CAPITAL LETTER VO
  { 0x0549, BIDI_L   },  // ARMENIAN CAPITAL LETTER CHA
  { 0x054A, BIDI_L   },  // ARMENIAN CAPITAL LETTER PEH
  { 0x054B, BIDI_L   },  // ARMENIAN CAPITAL LETTER JHEH
  { 0x054C, BIDI_L   },  // ARMENIAN CAPITAL LETTER RA
  { 0x054D, BIDI_L   },  // ARMENIAN CAPITAL LETTER SEH
  { 0x054E, BIDI_L   },  // ARMENIAN CAPITAL LETTER VEW
  { 0x054F, BIDI_L   },  // ARMENIAN CAPITAL LETTER TIWN
  { 0x0550, BIDI_L   },  // ARMENIAN CAPITAL LETTER REH
  { 0x0551, BIDI_L   },  // ARMENIAN CAPITAL LETTER CO
  { 0x0552, BIDI_L   },  // ARMENIAN CAPITAL LETTER YIWN
  { 0x0553, BIDI_L   },  // ARMENIAN CAPITAL LETTER PIWR
  { 0x0554, BIDI_L   },  // ARMENIAN CAPITAL LETTER KEH
  { 0x0555, BIDI_L   },  // ARMENIAN CAPITAL LETTER OH
  { 0x0556, BIDI_L   },  // ARMENIAN CAPITAL LETTER FEH
  { 0x0559, BIDI_L   },  // ARMENIAN MODIFIER LETTER LEFT HALF RING
  { 0x055A, BIDI_L   },  // ARMENIAN APOSTROPHE
  { 0x055B, BIDI_L   },  // ARMENIAN EMPHASIS MARK
  { 0x055C, BIDI_L   },  // ARMENIAN EXCLAMATION MARK
  { 0x055D, BIDI_L   },  // ARMENIAN COMMA
  { 0x055E, BIDI_L   },  // ARMENIAN QUESTION MARK
  { 0x055F, BIDI_L   },  // ARMENIAN ABBREVIATION MARK
  { 0x0561, BIDI_L   },  // ARMENIAN SMALL LETTER AYB
  { 0x0562, BIDI_L   },  // ARMENIAN SMALL LETTER BEN
  { 0x0563, BIDI_L   },  // ARMENIAN SMALL LETTER GIM
  { 0x0564, BIDI_L   },  // ARMENIAN SMALL LETTER DA
  { 0x0565, BIDI_L   },  // ARMENIAN SMALL LETTER ECH
  { 0x0566, BIDI_L   },  // ARMENIAN SMALL LETTER ZA
  { 0x0567, BIDI_L   },  // ARMENIAN SMALL LETTER EH
  { 0x0568, BIDI_L   },  // ARMENIAN SMALL LETTER ET
  { 0x0569, BIDI_L   },  // ARMENIAN SMALL LETTER TO
  { 0x056A, BIDI_L   },  // ARMENIAN SMALL LETTER ZHE
  { 0x056B, BIDI_L   },  // ARMENIAN SMALL LETTER INI
  { 0x056C, BIDI_L   },  // ARMENIAN SMALL LETTER LIWN
  { 0x056D, BIDI_L   },  // ARMENIAN SMALL LETTER XEH
  { 0x056E, BIDI_L   },  // ARMENIAN SMALL LETTER CA
  { 0x056F, BIDI_L   },  // ARMENIAN SMALL LETTER KEN
  { 0x0570, BIDI_L   },  // ARMENIAN SMALL LETTER HO
  { 0x0571, BIDI_L   },  // ARMENIAN SMALL LETTER JA
  { 0x0572, BIDI_L   },  // ARMENIAN SMALL LETTER GHAD
  { 0x0573, BIDI_L   },  // ARMENIAN SMALL LETTER CHEH
  { 0x0574, BIDI_L   },  // ARMENIAN SMALL LETTER MEN
  { 0x0575, BIDI_L   },  // ARMENIAN SMALL LETTER YI
  { 0x0576, BIDI_L   },  // ARMENIAN SMALL LETTER NOW
  { 0x0577, BIDI_L   },  // ARMENIAN SMALL LETTER SHA
  { 0x0578, BIDI_L   },  // ARMENIAN SMALL LETTER VO
  { 0x0579, BIDI_L   },  // ARMENIAN SMALL LETTER CHA
  { 0x057A, BIDI_L   },  // ARMENIAN SMALL LETTER PEH
  { 0x057B, BIDI_L   },  // ARMENIAN SMALL LETTER JHEH
  { 0x057C, BIDI_L   },  // ARMENIAN SMALL LETTER RA
  { 0x057D, BIDI_L   },  // ARMENIAN SMALL LETTER SEH
  { 0x057E, BIDI_L   },  // ARMENIAN SMALL LETTER VEW
  { 0x057F, BIDI_L   },  // ARMENIAN SMALL LETTER TIWN
  { 0x0580, BIDI_L   },  // ARMENIAN SMALL LETTER REH
  { 0x0581, BIDI_L   },  // ARMENIAN SMALL LETTER CO
  { 0x0582, BIDI_L   },  // ARMENIAN SMALL LETTER YIWN
  { 0x0583, BIDI_L   },  // ARMENIAN SMALL LETTER PIWR
  { 0x0584, BIDI_L   },  // ARMENIAN SMALL LETTER KEH
  { 0x0585, BIDI_L   },  // ARMENIAN SMALL LETTER OH
  { 0x0586, BIDI_L   },  // ARMENIAN SMALL LETTER FEH
  { 0x0587, BIDI_L   },  // ARMENIAN SMALL LIGATURE ECH YIWN
  { 0x0589, BIDI_L   },  // ARMENIAN FULL STOP
  { 0x058A, BIDI_ON  },  // ARMENIAN HYPHEN
  { 0x058D, BIDI_ON  },  // RIGHT-FACING ARMENIAN ETERNITY SIGN
  { 0x058E, BIDI_ON  },  // LEFT-FACING ARMENIAN ETERNITY SIGN
  { 0x058F, BIDI_ET  },  // ARMENIAN DRAM SIGN
  { 0x0591, BIDI_NSM },  // HEBREW ACCENT ETNAHTA
  { 0x0592, BIDI_NSM },  // HEBREW ACCENT SEGOL
  { 0x0593, BIDI_NSM },  // HEBREW ACCENT SHALSHELET
  { 0x0594, BIDI_NSM },  // HEBREW ACCENT ZAQEF QATAN
  { 0x0595, BIDI_NSM },  // HEBREW ACCENT ZAQEF GADOL
  { 0x0596, BIDI_NSM },  // HEBREW ACCENT TIPEHA
  { 0x0597, BIDI_NSM },  // HEBREW ACCENT REVIA
  { 0x0598, BIDI_NSM },  // HEBREW ACCENT ZARQA
  { 0x0599, BIDI_NSM },  // HEBREW ACCENT PASHTA
  { 0x059A, BIDI_NSM },  // HEBREW ACCENT YETIV
  { 0x059B, BIDI_NSM },  // HEBREW ACCENT TEVIR
  { 0x059C, BIDI_NSM },  // HEBREW ACCENT GERESH
  { 0x059D, BIDI_NSM },  // HEBREW ACCENT GERESH MUQDAM
  { 0x059E, BIDI_NSM },  // HEBREW ACCENT GERSHAYIM
  { 0x059F, BIDI_NSM },  // HEBREW ACCENT QARNEY PARA
  { 0x05A0, BIDI_NSM },  // HEBREW ACCENT TELISHA GEDOLA
  { 0x05A1, BIDI_NSM },  // HEBREW ACCENT PAZER
  { 0x05A2, BIDI_NSM },  // HEBREW ACCENT ATNAH HAFUKH
  { 0x05A3, BIDI_NSM },  // HEBREW ACCENT MUNAH
  { 0x05A4, BIDI_NSM },  // HEBREW ACCENT MAHAPAKH
  { 0x05A5, BIDI_NSM },  // HEBREW ACCENT MERKHA
  { 0x05A6, BIDI_NSM },  // HEBREW ACCENT MERKHA KEFULA
  { 0x05A7, BIDI_NSM },  // HEBREW ACCENT DARGA
  { 0x05A8, BIDI_NSM },  // HEBREW ACCENT QADMA
  { 0x05A9, BIDI_NSM },  // HEBREW ACCENT TELISHA QETANA
  { 0x05AA, BIDI_NSM },  // HEBREW ACCENT YERAH BEN YOMO
  { 0x05AB, BIDI_NSM },  // HEBREW ACCENT OLE
  { 0x05AC, BIDI_NSM },  // HEBREW ACCENT ILUY
  { 0x05AD, BIDI_NSM },  // HEBREW ACCENT DEHI
  { 0x05AE, BIDI_NSM },  // HEBREW ACCENT ZINOR
  { 0x05AF, BIDI_NSM },  // HEBREW MARK MASORA CIRCLE
  { 0x05B0, BIDI_NSM },  // HEBREW POINT SHEVA
  { 0x05B1, BIDI_NSM },  // HEBREW POINT HATAF SEGOL
  { 0x05B2, BIDI_NSM },  // HEBREW POINT HATAF PATAH
  { 0x05B3, BIDI_NSM },  // HEBREW POINT HATAF QAMATS
  { 0x05B4, BIDI_NSM },  // HEBREW POINT HIRIQ
  { 0x05B5, BIDI_NSM },  // HEBREW POINT TSERE
  { 0x05B6, BIDI_NSM },  // HEBREW POINT SEGOL
  { 0x05B7, BIDI_NSM },  // HEBREW POINT PATAH
  { 0x05B8, BIDI_NSM },  // HEBREW POINT QAMATS
  { 0x05B9, BIDI_NSM },  // HEBREW POINT HOLAM
  { 0x05BA, BIDI_NSM },  // HEBREW POINT HOLAM HASER FOR VAV
  { 0x05BB, BIDI_NSM },  // HEBREW POINT QUBUTS
  { 0x05BC, BIDI_NSM },  // HEBREW POINT DAGESH OR MAPIQ
  { 0x05BD, BIDI_NSM },  // HEBREW POINT METEG
  { 0x05BE, BIDI_R   },  // HEBREW PUNCTUATION MAQAF
  { 0x05BF, BIDI_NSM },  // HEBREW POINT RAFE
  { 0x05C0, BIDI_R   },  // HEBREW PUNCTUATION PASEQ
  { 0x05C1, BIDI_NSM },  // HEBREW POINT SHIN DOT
  { 0x05C2, BIDI_NSM },  // HEBREW POINT SIN DOT
  { 0x05C3, BIDI_R   },  // HEBREW PUNCTUATION SOF PASUQ
  { 0x05C4, BIDI_NSM },  // HEBREW MARK UPPER DOT
  { 0x05C5, BIDI_NSM },  // HEBREW MARK LOWER DOT
  { 0x05C6, BIDI_R   },  // HEBREW PUNCTUATION NUN HAFUKHA
  { 0x05C7, BIDI_NSM },  // HEBREW POINT QAMATS QATAN
  { 0x05D0, BIDI_R   },  // HEBREW LETTER ALEF
  { 0x05D1, BIDI_R   },  // HEBREW LETTER BET
  { 0x05D2, BIDI_R   },  // HEBREW LETTER GIMEL
  { 0x05D3, BIDI_R   },  // HEBREW LETTER DALET
  { 0x05D4, BIDI_R   },  // HEBREW LETTER HE
  { 0x05D5, BIDI_R   },  // HEBREW LETTER VAV
  { 0x05D6, BIDI_R   },  // HEBREW LETTER ZAYIN
  { 0x05D7, BIDI_R   },  // HEBREW LETTER HET
  { 0x05D8, BIDI_R   },  // HEBREW LETTER TET
  { 0x05D9, BIDI_R   },  // HEBREW LETTER YOD
  { 0x05DA, BIDI_R   },  // HEBREW LETTER FINAL KAF
  { 0x05DB, BIDI_R   },  // HEBREW LETTER KAF
  { 0x05DC, BIDI_R   },  // HEBREW LETTER LAMED
  { 0x05DD, BIDI_R   },  // HEBREW LETTER FINAL MEM
  { 0x05DE, BIDI_R   },  // HEBREW LETTER MEM
  { 0x05DF, BIDI_R   },  // HEBREW LETTER FINAL NUN
  { 0x05E0, BIDI_R   },  // HEBREW LETTER NUN
  { 0x05E1, BIDI_R   },  // HEBREW LETTER SAMEKH
  { 0x05E2, BIDI_R   },  // HEBREW LETTER AYIN
  { 0x05E3, BIDI_R   },  // HEBREW LETTER FINAL PE
  { 0x05E4, BIDI_R   },  // HEBREW LETTER PE
  { 0x05E5, BIDI_R   },  // HEBREW LETTER FINAL TSADI
  { 0x05E6, BIDI_R   },  // HEBREW LETTER TSADI
  { 0x05E7, BIDI_R   },  // HEBREW LETTER QOF
  { 0x05E8, BIDI_R   },  // HEBREW LETTER RESH
  { 0x05E9, BIDI_R   },  // HEBREW LETTER SHIN
  { 0x05EA, BIDI_R   },  // HEBREW LETTER TAV
  { 0x05F0, BIDI_R   },  // HEBREW LIGATURE YIDDISH DOUBLE VAV
  { 0x05F1, BIDI_R   },  // HEBREW LIGATURE YIDDISH VAV YOD
  { 0x05F2, BIDI_R   },  // HEBREW LIGATURE YIDDISH DOUBLE YOD
  { 0x05F3, BIDI_R   },  // HEBREW PUNCTUATION GERESH
  { 0x05F4, BIDI_R   },  // HEBREW PUNCTUATION GERSHAYIM
  { 0x0600, BIDI_AN  },  // ARABIC NUMBER SIGN
  { 0x0601, BIDI_AN  },  // ARABIC SIGN SANAH
  { 0x0602, BIDI_AN  },  // ARABIC FOOTNOTE MARKER
  { 0x0603, BIDI_AN  },  // ARABIC SIGN SAFHA
  { 0x0604, BIDI_AN  },  // ARABIC SIGN SAMVAT
  { 0x0605, BIDI_AN  },  // ARABIC NUMBER MARK ABOVE
  { 0x0606, BIDI_ON  },  // ARABIC-INDIC CUBE ROOT
  { 0x0607, BIDI_ON  },  // ARABIC-INDIC FOURTH ROOT
  { 0x0608, BIDI_AL  },  // ARABIC RAY
  { 0x0609, BIDI_ET  },  // ARABIC-INDIC PER MILLE SIGN
  { 0x060A, BIDI_ET  },  // ARABIC-INDIC PER TEN THOUSAND SIGN
  { 0x060B, BIDI_AL  },  // AFGHANI SIGN
  { 0x060C, BIDI_CS  },  // ARABIC COMMA
  { 0x060D, BIDI_AL  },  // ARABIC DATE SEPARATOR
  { 0x060E, BIDI_ON  },  // ARABIC POETIC VERSE SIGN
  { 0x060F, BIDI_ON  },  // ARABIC SIGN MISRA
  { 0x0610, BIDI_NSM },  // ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM
  { 0x0611, BIDI_NSM },  // ARABIC SIGN ALAYHE ASSALLAM
  { 0x0612, BIDI_NSM },  // ARABIC SIGN RAHMATULLAH ALAYHE
  { 0x0613, BIDI_NSM },  // ARABIC SIGN RADI ALLAHOU ANHU
  { 0x0614, BIDI_NSM },  // ARABIC SIGN TAKHALLUS
  { 0x0615, BIDI_NSM },  // ARABIC SMALL HIGH TAH
  { 0x0616, BIDI_NSM },  // ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH
  { 0x0617, BIDI_NSM },  // ARABIC SMALL HIGH ZAIN
  { 0x0618, BIDI_NSM },  // ARABIC SMALL FATHA
  { 0x0619, BIDI_NSM },  // ARABIC SMALL DAMMA
  { 0x061A, BIDI_NSM },  // ARABIC SMALL KASRA
  { 0x061B, BIDI_AL  },  // ARABIC SEMICOLON
  { 0x061C, BIDI_AL  },  // ARABIC LETTER MARK
  { 0x061E, BIDI_AL  },  // ARABIC TRIPLE DOT PUNCTUATION MARK
  { 0x061F, BIDI_AL  },  // ARABIC QUESTION MARK
  { 0x0620, BIDI_AL  },  // ARABIC LETTER KASHMIRI YEH
  { 0x0621, BIDI_AL  },  // ARABIC LETTER HAMZA
  { 0x0622, BIDI_AL  },  // ARABIC LETTER ALEF WITH MADDA ABOVE
  { 0x0623, BIDI_AL  },  // ARABIC LETTER ALEF WITH HAMZA ABOVE
  { 0x0624, BIDI_AL  },  // ARABIC LETTER WAW WITH HAMZA ABOVE
  { 0x0625, BIDI_AL  },  // ARABIC LETTER ALEF WITH HAMZA BELOW
  { 0x0626, BIDI_AL  },  // ARABIC LETTER YEH WITH HAMZA ABOVE
  { 0x0627, BIDI_AL  },  // ARABIC LETTER ALEF
  { 0x0628, BIDI_AL  },  // ARABIC LETTER BEH
  { 0x0629, BIDI_AL  },  // ARABIC LETTER TEH MARBUTA
  { 0x062A, BIDI_AL  },  // ARABIC LETTER TEH
  { 0x062B, BIDI_AL  },  // ARABIC LETTER THEH
  { 0x062C, BIDI_AL  },  // ARABIC LETTER JEEM
  { 0x062D, BIDI_AL  },  // ARABIC LETTER HAH
  { 0x062E, BIDI_AL  },  // ARABIC LETTER KHAH
  { 0x062F, BIDI_AL  },  // ARABIC LETTER DAL
  { 0x0630, BIDI_AL  },  // ARABIC LETTER THAL
  { 0x0631, BIDI_AL  },  // ARABIC LETTER REH
  { 0x0632, BIDI_AL  },  // ARABIC LETTER ZAIN
  { 0x0633, BIDI_AL  },  // ARABIC LETTER SEEN
  { 0x0634, BIDI_AL  },  // ARABIC LETTER SHEEN
  { 0x0635, BIDI_AL  },  // ARABIC LETTER SAD
  { 0x0636, BIDI_AL  },  // ARABIC LETTER DAD
  { 0x0637, BIDI_AL  },  // ARABIC LETTER TAH
  { 0x0638, BIDI_AL  },  // ARABIC LETTER ZAH
  { 0x0639, BIDI_AL  },  // ARABIC LETTER AIN
  { 0x063A, BIDI_AL  },  // ARABIC LETTER GHAIN
  { 0x063B, BIDI_AL  },  // ARABIC LETTER KEHEH WITH TWO DOTS ABOVE
  { 0x063C, BIDI_AL  },  // ARABIC LETTER KEHEH WITH THREE DOTS BELOW
  { 0x063D, BIDI_AL  },  // ARABIC LETTER FARSI YEH WITH INVERTED V
  { 0x063E, BIDI_AL  },  // ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE
  { 0x063F, BIDI_AL  },  // ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
  { 0x0640, BIDI_AL  },  // ARABIC TATWEEL
  { 0x0641, BIDI_AL  },  // ARABIC LETTER FEH
  { 0x0642, BIDI_AL  },  // ARABIC LETTER QAF
  { 0x0643, BIDI_AL  },  // ARABIC LETTER KAF
  { 0x0644, BIDI_AL  },  // ARABIC LETTER LAM
  { 0x0645, BIDI_AL  },  // ARABIC LETTER MEEM
  { 0x0646, BIDI_AL  },  // ARABIC LETTER NOON
  { 0x0647, BIDI_AL  },  // ARABIC LETTER HEH
  { 0x0648, BIDI_AL  },  // ARABIC LETTER WAW
  { 0x0649, BIDI_AL  },  // ARABIC LETTER ALEF MAKSURA
  { 0x064A, BIDI_AL  },  // ARABIC LETTER YEH
  { 0x064B, BIDI_NSM },  // ARABIC FATHATAN
  { 0x064C, BIDI_NSM },  // ARABIC DAMMATAN
  { 0x064D, BIDI_NSM },  // ARABIC KASRATAN
  { 0x064E, BIDI_NSM },  // ARABIC FATHA
  { 0x064F, BIDI_NSM },  // ARABIC DAMMA
  { 0x0650, BIDI_NSM },  // ARABIC KASRA
  { 0x0651, BIDI_NSM },  // ARABIC SHADDA
  { 0x0652, BIDI_NSM },  // ARABIC SUKUN
  { 0x0653, BIDI_NSM },  // ARABIC MADDAH ABOVE
  { 0x0654, BIDI_NSM },  // ARABIC HAMZA ABOVE
  { 0x0655, BIDI_NSM },  // ARABIC HAMZA BELOW
  { 0x0656, BIDI_NSM },  // ARABIC SUBSCRIPT ALEF
  { 0x0657, BIDI_NSM },  // ARABIC INVERTED DAMMA
  { 0x0658, BIDI_NSM },  // ARABIC MARK NOON GHUNNA
  { 0x0659, BIDI_NSM },  // ARABIC ZWARAKAY
  { 0x065A, BIDI_NSM },  // ARABIC VOWEL SIGN SMALL V ABOVE
  { 0x065B, BIDI_NSM },  // ARABIC VOWEL SIGN INVERTED SMALL V ABOVE
  { 0x065C, BIDI_NSM },  // ARABIC VOWEL SIGN DOT BELOW
  { 0x065D, BIDI_NSM },  // ARABIC REVERSED DAMMA
  { 0x065E, BIDI_NSM },  // ARABIC FATHA WITH TWO DOTS
  { 0x065F, BIDI_NSM },  // ARABIC WAVY HAMZA BELOW
  { 0x0660, BIDI_AN  },  // ARABIC-INDIC DIGIT ZERO
  { 0x0661, BIDI_AN  },  // ARABIC-INDIC DIGIT ONE
  { 0x0662, BIDI_AN  },  // ARABIC-INDIC DIGIT TWO
  { 0x0663, BIDI_AN  },  // ARABIC-INDIC DIGIT THREE
  { 0x0664, BIDI_AN  },  // ARABIC-INDIC DIGIT FOUR
  { 0x0665, BIDI_AN  },  // ARABIC-INDIC DIGIT FIVE
  { 0x0666, BIDI_AN  },  // ARABIC-INDIC DIGIT SIX
  { 0x0667, BIDI_AN  },  // ARABIC-INDIC DIGIT SEVEN
  { 0x0668, BIDI_AN  },  // ARABIC-INDIC DIGIT EIGHT
  { 0x0669, BIDI_AN  },  // ARABIC-INDIC DIGIT NINE
  { 0x066A, BIDI_ET  },  // ARABIC PERCENT SIGN
  { 0x066B, BIDI_AN  },  // ARABIC DECIMAL SEPARATOR
  { 0x066C, BIDI_AN  },  // ARABIC THOUSANDS SEPARATOR
  { 0x066D, BIDI_AL  },  // ARABIC FIVE POINTED STAR
  { 0x066E, BIDI_AL  },  // ARABIC LETTER DOTLESS BEH
  { 0x066F, BIDI_AL  },  // ARABIC LETTER DOTLESS QAF
  { 0x0670, BIDI_NSM },  // ARABIC LETTER SUPERSCRIPT ALEF
  { 0x0671, BIDI_AL  },  // ARABIC LETTER ALEF WASLA
  { 0x0672, BIDI_AL  },  // ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE
  { 0x0673, BIDI_AL  },  // ARABIC LETTER ALEF WITH WAVY HAMZA BELOW
  { 0x0674, BIDI_AL  },  // ARABIC LETTER HIGH HAMZA
  { 0x0675, BIDI_AL  },  // ARABIC LETTER HIGH HAMZA ALEF
  { 0x0676, BIDI_AL  },  // ARABIC LETTER HIGH HAMZA WAW
  { 0x0677, BIDI_AL  },  // ARABIC LETTER U WITH HAMZA ABOVE
  { 0x0678, BIDI_AL  },  // ARABIC LETTER HIGH HAMZA YEH
  { 0x0679, BIDI_AL  },  // ARABIC LETTER TTEH
  { 0x067A, BIDI_AL  },  // ARABIC LETTER TTEHEH
  { 0x067B, BIDI_AL  },  // ARABIC LETTER BEEH
  { 0x067C, BIDI_AL  },  // ARABIC LETTER TEH WITH RING
  { 0x067D, BIDI_AL  },  // ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS
  { 0x067E, BIDI_AL  },  // ARABIC LETTER PEH
  { 0x067F, BIDI_AL  },  // ARABIC LETTER TEHEH
  { 0x0680, BIDI_AL  },  // ARABIC LETTER BEHEH
  { 0x0681, BIDI_AL  },  // ARABIC LETTER HAH WITH HAMZA ABOVE
  { 0x0682, BIDI_AL  },  // ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE
  { 0x0683, BIDI_AL  },  // ARABIC LETTER NYEH
  { 0x0684, BIDI_AL  },  // ARABIC LETTER DYEH
  { 0x0685, BIDI_AL  },  // ARABIC LETTER HAH WITH THREE DOTS ABOVE
  { 0x0686, BIDI_AL  },  // ARABIC LETTER TCHEH
  { 0x0687, BIDI_AL  },  // ARABIC LETTER TCHEHEH
  { 0x0688, BIDI_AL  },  // ARABIC LETTER DDAL
  { 0x0689, BIDI_AL  },  // ARABIC LETTER DAL WITH RING
  { 0x068A, BIDI_AL  },  // ARABIC LETTER DAL WITH DOT BELOW
  { 0x068B, BIDI_AL  },  // ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH
  { 0x068C, BIDI_AL  },  // ARABIC LETTER DAHAL
  { 0x068D, BIDI_AL  },  // ARABIC LETTER DDAHAL
  { 0x068E, BIDI_AL  },  // ARABIC LETTER DUL
  { 0x068F, BIDI_AL  },  // ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS
  { 0x0690, BIDI_AL  },  // ARABIC LETTER DAL WITH FOUR DOTS ABOVE
  { 0x0691, BIDI_AL  },  // ARABIC LETTER RREH
  { 0x0692, BIDI_AL  },  // ARABIC LETTER REH WITH SMALL V
  { 0x0693, BIDI_AL  },  // ARABIC LETTER REH WITH RING
  { 0x0694, BIDI_AL  },  // ARABIC LETTER REH WITH DOT BELOW
  { 0x0695, BIDI_AL  },  // ARABIC LETTER REH WITH SMALL V BELOW
  { 0x0696, BIDI_AL  },  // ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE
  { 0x0697, BIDI_AL  },  // ARABIC LETTER REH WITH TWO DOTS ABOVE
  { 0x0698, BIDI_AL  },  // ARABIC LETTER JEH
  { 0x0699, BIDI_AL  },  // ARABIC LETTER REH WITH FOUR DOTS ABOVE
  { 0x069A, BIDI_AL  },  // ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE
  { 0x069B, BIDI_AL  },  // ARABIC LETTER SEEN WITH THREE DOTS BELOW
  { 0x069C, BIDI_AL  },  // ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE
  { 0x069D, BIDI_AL  },  // ARABIC LETTER SAD WITH TWO DOTS BELOW
  { 0x069E, BIDI_AL  },  // ARABIC LETTER SAD WITH THREE DOTS ABOVE
  { 0x069F, BIDI_AL  },  // ARABIC LETTER TAH WITH THREE DOTS ABOVE
  { 0x06A0, BIDI_AL  },  // ARABIC LETTER AIN WITH THREE DOTS ABOVE
  { 0x06A1, BIDI_AL  },  // ARABIC LETTER DOTLESS FEH
  { 0x06A2, BIDI_AL  },  // ARABIC LETTER FEH WITH DOT MOVED BELOW
  { 0x06A3, BIDI_AL  },  // ARABIC LETTER FEH WITH DOT BELOW
  { 0x06A4, BIDI_AL  },  // ARABIC LETTER VEH
  { 0x06A5, BIDI_AL  },  // ARABIC LETTER FEH WITH THREE DOTS BELOW
  { 0x06A6, BIDI_AL  },  // ARABIC LETTER PEHEH
  { 0x06A7, BIDI_AL  },  // ARABIC LETTER QAF WITH DOT ABOVE
  { 0x06A8, BIDI_AL  },  // ARABIC LETTER QAF WITH THREE DOTS ABOVE
  { 0x06A9, BIDI_AL  },  // ARABIC LETTER KEHEH
  { 0x06AA, BIDI_AL  },  // ARABIC LETTER SWASH KAF
  { 0x06AB, BIDI_AL  },  // ARABIC LETTER KAF WITH RING
  { 0x06AC, BIDI_AL  },  // ARABIC LETTER KAF WITH DOT ABOVE
  { 0x06AD, BIDI_AL  },  // ARABIC LETTER NG
  { 0x06AE, BIDI_AL  },  // ARABIC LETTER KAF WITH THREE DOTS BELOW
  { 0x06AF, BIDI_AL  },  // ARABIC LETTER GAF
  { 0x06B0, BIDI_AL  },  // ARABIC LETTER GAF WITH RING
  { 0x06B1, BIDI_AL  },  // ARABIC LETTER NGOEH
  { 0x06B2, BIDI_AL  },  // ARABIC LETTER GAF WITH TWO DOTS BELOW
  { 0x06B3, BIDI_AL  },  // ARABIC LETTER GUEH
  { 0x06B4, BIDI_AL  },  // ARABIC LETTER GAF WITH THREE DOTS ABOVE
  { 0x06B5, BIDI_AL  },  // ARABIC LETTER LAM WITH SMALL V
  { 0x06B6, BIDI_AL  },  // ARABIC LETTER LAM WITH DOT ABOVE
  { 0x06B7, BIDI_AL  },  // ARABIC LETTER LAM WITH THREE DOTS ABOVE
  { 0x06B8, BIDI_AL  },  // ARABIC LETTER LAM WITH THREE DOTS BELOW
  { 0x06B9, BIDI_AL  },  // ARABIC LETTER NOON WITH DOT BELOW
  { 0x06BA, BIDI_AL  },  // ARABIC LETTER NOON GHUNNA
  { 0x06BB, BIDI_AL  },  // ARABIC LETTER RNOON
  { 0x06BC, BIDI_AL  },  // ARABIC LETTER NOON WITH RING
  { 0x06BD, BIDI_AL  },  // ARABIC LETTER NOON WITH THREE DOTS ABOVE
  { 0x06BE, BIDI_AL  },  // ARABIC LETTER HEH DOACHASHMEE
  { 0x06BF, BIDI_AL  },  // ARABIC LETTER TCHEH WITH DOT ABOVE
  { 0x06C0, BIDI_AL  },  // ARABIC LETTER HEH WITH YEH ABOVE
  { 0x06C1, BIDI_AL  },  // ARABIC LETTER HEH GOAL
  { 0x06C2, BIDI_AL  },  // ARABIC LETTER HEH GOAL WITH HAMZA ABOVE
  { 0x06C3, BIDI_AL  },  // ARABIC LETTER TEH MARBUTA GOAL
  { 0x06C4, BIDI_AL  },  // ARABIC LETTER WAW WITH RING
  { 0x06C5, BIDI_AL  },  // ARABIC LETTER KIRGHIZ OE
  { 0x06C6, BIDI_AL  },  // ARABIC LETTER OE
  { 0x06C7, BIDI_AL  },  // ARABIC LETTER U
  { 0x06C8, BIDI_AL  },  // ARABIC LETTER YU
  { 0x06C9, BIDI_AL  },  // ARABIC LETTER KIRGHIZ YU
  { 0x06CA, BIDI_AL  },  // ARABIC LETTER WAW WITH TWO DOTS ABOVE
  { 0x06CB, BIDI_AL  },  // ARABIC LETTER VE
  { 0x06CC, BIDI_AL  },  // ARABIC LETTER FARSI YEH
  { 0x06CD, BIDI_AL  },  // ARABIC LETTER YEH WITH TAIL
  { 0x06CE, BIDI_AL  },  // ARABIC LETTER YEH WITH SMALL V
  { 0x06CF, BIDI_AL  },  // ARABIC LETTER WAW WITH DOT ABOVE
  { 0x06D0, BIDI_AL  },  // ARABIC LETTER E
  { 0x06D1, BIDI_AL  },  // ARABIC LETTER YEH WITH THREE DOTS BELOW
  { 0x06D2, BIDI_AL  },  // ARABIC LETTER YEH BARREE
  { 0x06D3, BIDI_AL  },  // ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
  { 0x06D4, BIDI_AL  },  // ARABIC FULL STOP
  { 0x06D5, BIDI_AL  },  // ARABIC LETTER AE
  { 0x06D6, BIDI_NSM },  // ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA
  { 0x06D7, BIDI_NSM },  // ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA
  { 0x06D8, BIDI_NSM },  // ARABIC SMALL HIGH MEEM INITIAL FORM
  { 0x06D9, BIDI_NSM },  // ARABIC SMALL HIGH LAM ALEF
  { 0x06DA, BIDI_NSM },  // ARABIC SMALL HIGH JEEM
  { 0x06DB, BIDI_NSM },  // ARABIC SMALL HIGH THREE DOTS
  { 0x06DC, BIDI_NSM },  // ARABIC SMALL HIGH SEEN
  { 0x06DD, BIDI_AN  },  // ARABIC END OF AYAH
  { 0x06DE, BIDI_ON  },  // ARABIC START OF RUB EL HIZB
  { 0x06DF, BIDI_NSM },  // ARABIC SMALL HIGH ROUNDED ZERO
  { 0x06E0, BIDI_NSM },  // ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO
  { 0x06E1, BIDI_NSM },  // ARABIC SMALL HIGH DOTLESS HEAD OF KHAH
  { 0x06E2, BIDI_NSM },  // ARABIC SMALL HIGH MEEM ISOLATED FORM
  { 0x06E3, BIDI_NSM },  // ARABIC SMALL LOW SEEN
  { 0x06E4, BIDI_NSM },  // ARABIC SMALL HIGH MADDA
  { 0x06E5, BIDI_AL  },  // ARABIC SMALL WAW
  { 0x06E6, BIDI_AL  },  // ARABIC SMALL YEH
  { 0x06E7, BIDI_NSM },  // ARABIC SMALL HIGH YEH
  { 0x06E8, BIDI_NSM },  // ARABIC SMALL HIGH NOON
  { 0x06E9, BIDI_ON  },  // ARABIC PLACE OF SAJDAH
  { 0x06EA, BIDI_NSM },  // ARABIC EMPTY CENTRE LOW STOP
  { 0x06EB, BIDI_NSM },  // ARABIC EMPTY CENTRE HIGH STOP
  { 0x06EC, BIDI_NSM },  // ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE
  { 0x06ED, BIDI_NSM },  // ARABIC SMALL LOW MEEM
  { 0x06EE, BIDI_AL  },  // ARABIC LETTER DAL WITH INVERTED V
  { 0x06EF, BIDI_AL  },  // ARABIC LETTER REH WITH INVERTED V
  { 0x06F0, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT ZERO
  { 0x06F1, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT ONE
  { 0x06F2, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT TWO
  { 0x06F3, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT THREE
  { 0x06F4, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT FOUR
  { 0x06F5, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT FIVE
  { 0x06F6, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT SIX
  { 0x06F7, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT SEVEN
  { 0x06F8, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT EIGHT
  { 0x06F9, BIDI_EN  },  // EXTENDED ARABIC-INDIC DIGIT NINE
  { 0x06FA, BIDI_AL  },  // ARABIC LETTER SHEEN WITH DOT BELOW
  { 0x06FB, BIDI_AL  },  // ARABIC LETTER DAD WITH DOT BELOW
  { 0x06FC, BIDI_AL  },  // ARABIC LETTER GHAIN WITH DOT BELOW
  { 0x06FD, BIDI_AL  },  // ARABIC SIGN SINDHI AMPERSAND
  { 0x06FE, BIDI_AL  },  // ARABIC SIGN SINDHI POSTPOSITION MEN
  { 0x06FF, BIDI_AL  },  // ARABIC LETTER HEH WITH INVERTED V
  { 0x0700, BIDI_AL  },  // SYRIAC END OF PARAGRAPH
  { 0x0701, BIDI_AL  },  // SYRIAC SUPRALINEAR FULL STOP
  { 0x0702, BIDI_AL  },  // SYRIAC SUBLINEAR FULL STOP
  { 0x0703, BIDI_AL  },  // SYRIAC SUPRALINEAR COLON
  { 0x0704, BIDI_AL  },  // SYRIAC SUBLINEAR COLON
  { 0x0705, BIDI_AL  },  // SYRIAC HORIZONTAL COLON
  { 0x0706, BIDI_AL  },  // SYRIAC COLON SKEWED LEFT
  { 0x0707, BIDI_AL  },  // SYRIAC COLON SKEWED RIGHT
  { 0x0708, BIDI_AL  },  // SYRIAC SUPRALINEAR COLON SKEWED LEFT
  { 0x0709, BIDI_AL  },  // SYRIAC SUBLINEAR COLON SKEWED RIGHT
  { 0x070A, BIDI_AL  },  // SYRIAC CONTRACTION
  { 0x070B, BIDI_AL  },  // SYRIAC HARKLEAN OBELUS
  { 0x070C, BIDI_AL  },  // SYRIAC HARKLEAN METOBELUS
  { 0x070D, BIDI_AL  },  // SYRIAC HARKLEAN ASTERISCUS
  { 0x070F, BIDI_AL  },  // SYRIAC ABBREVIATION MARK
  { 0x0710, BIDI_AL  },  // SYRIAC LETTER ALAPH
  { 0x0711, BIDI_NSM },  // SYRIAC LETTER SUPERSCRIPT ALAPH
  { 0x0712, BIDI_AL  },  // SYRIAC LETTER BETH
  { 0x0713, BIDI_AL  },  // SYRIAC LETTER GAMAL
  { 0x0714, BIDI_AL  },  // SYRIAC LETTER GAMAL GARSHUNI
  { 0x0715, BIDI_AL  },  // SYRIAC LETTER DALATH
  { 0x0716, BIDI_AL  },  // SYRIAC LETTER DOTLESS DALATH RISH
  { 0x0717, BIDI_AL  },  // SYRIAC LETTER HE
  { 0x0718, BIDI_AL  },  // SYRIAC LETTER WAW
  { 0x0719, BIDI_AL  },  // SYRIAC LETTER ZAIN
  { 0x071A, BIDI_AL  },  // SYRIAC LETTER HETH
  { 0x071B, BIDI_AL  },  // SYRIAC LETTER TETH
  { 0x071C, BIDI_AL  },  // SYRIAC LETTER TETH GARSHUNI
  { 0x071D, BIDI_AL  },  // SYRIAC LETTER YUDH
  { 0x071E, BIDI_AL  },  // SYRIAC LETTER YUDH HE
  { 0x071F, BIDI_AL  },  // SYRIAC LETTER KAPH
  { 0x0720, BIDI_AL  },  // SYRIAC LETTER LAMADH
  { 0x0721, BIDI_AL  },  // SYRIAC LETTER MIM
  { 0x0722, BIDI_AL  },  // SYRIAC LETTER NUN
  { 0x0723, BIDI_AL  },  // SYRIAC LETTER SEMKATH
  { 0x0724, BIDI_AL  },  // SYRIAC LETTER FINAL SEMKATH
  { 0x0725, BIDI_AL  },  // SYRIAC LETTER E
  { 0x0726, BIDI_AL  },  // SYRIAC LETTER PE
  { 0x0727, BIDI_AL  },  // SYRIAC LETTER REVERSED PE
  { 0x0728, BIDI_AL  },  // SYRIAC LETTER SADHE
  { 0x0729, BIDI_AL  },  // SYRIAC LETTER QAPH
  { 0x072A, BIDI_AL  },  // SYRIAC LETTER RISH
  { 0x072B, BIDI_AL  },  // SYRIAC LETTER SHIN
  { 0x072C, BIDI_AL  },  // SYRIAC LETTER TAW
  { 0x072D, BIDI_AL  },  // SYRIAC LETTER PERSIAN BHETH
  { 0x072E, BIDI_AL  },  // SYRIAC LETTER PERSIAN GHAMAL
  { 0x072F, BIDI_AL  },  // SYRIAC LETTER PERSIAN DHALATH
  { 0x0730, BIDI_NSM },  // SYRIAC PTHAHA ABOVE
  { 0x0731, BIDI_NSM },  // SYRIAC PTHAHA BELOW
  { 0x0732, BIDI_NSM },  // SYRIAC PTHAHA DOTTED
  { 0x0733, BIDI_NSM },  // SYRIAC ZQAPHA ABOVE
  { 0x0734, BIDI_NSM },  // SYRIAC ZQAPHA BELOW
  { 0x0735, BIDI_NSM },  // SYRIAC ZQAPHA DOTTED
  { 0x0736, BIDI_NSM },  // SYRIAC RBASA ABOVE
  { 0x0737, BIDI_NSM },  // SYRIAC RBASA BELOW
  { 0x0738, BIDI_NSM },  // SYRIAC DOTTED ZLAMA HORIZONTAL
  { 0x0739, BIDI_NSM },  // SYRIAC DOTTED ZLAMA ANGULAR
  { 0x073A, BIDI_NSM },  // SYRIAC HBASA ABOVE
  { 0x073B, BIDI_NSM },  // SYRIAC HBASA BELOW
  { 0x073C, BIDI_NSM },  // SYRIAC HBASA-ESASA DOTTED
  { 0x073D, BIDI_NSM },  // SYRIAC ESASA ABOVE
  { 0x073E, BIDI_NSM },  // SYRIAC ESASA BELOW
  { 0x073F, BIDI_NSM },  // SYRIAC RWAHA
  { 0x0740, BIDI_NSM },  // SYRIAC FEMININE DOT
  { 0x0741, BIDI_NSM },  // SYRIAC QUSHSHAYA
  { 0x0742, BIDI_NSM },  // SYRIAC RUKKAKHA
  { 0x0743, BIDI_NSM },  // SYRIAC TWO VERTICAL DOTS ABOVE
  { 0x0744, BIDI_NSM },  // SYRIAC TWO VERTICAL DOTS BELOW
  { 0x0745, BIDI_NSM },  // SYRIAC THREE DOTS ABOVE
  { 0x0746, BIDI_NSM },  // SYRIAC THREE DOTS BELOW
  { 0x0747, BIDI_NSM },  // SYRIAC OBLIQUE LINE ABOVE
  { 0x0748, BIDI_NSM },  // SYRIAC OBLIQUE LINE BELOW
  { 0x0749, BIDI_NSM },  // SYRIAC MUSIC
  { 0x074A, BIDI_NSM },  // SYRIAC BARREKH
  { 0x074D, BIDI_AL  },  // SYRIAC LETTER SOGDIAN ZHAIN
  { 0x074E, BIDI_AL  },  // SYRIAC LETTER SOGDIAN KHAPH
  { 0x074F, BIDI_AL  },  // SYRIAC LETTER SOGDIAN FE
  { 0x0750, BIDI_AL  },  // ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW
  { 0x0751, BIDI_AL  },  // ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE
  { 0x0752, BIDI_AL  },  // ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW
  { 0x0753, BIDI_AL  },  // ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE
  { 0x0754, BIDI_AL  },  // ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE
  { 0x0755, BIDI_AL  },  // ARABIC LETTER BEH WITH INVERTED SMALL V BELOW
  { 0x0756, BIDI_AL  },  // ARABIC LETTER BEH WITH SMALL V
  { 0x0757, BIDI_AL  },  // ARABIC LETTER HAH WITH TWO DOTS ABOVE
  { 0x0758, BIDI_AL  },  // ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW
  { 0x0759, BIDI_AL  },  // ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH
  { 0x075A, BIDI_AL  },  // ARABIC LETTER DAL WITH INVERTED SMALL V BELOW
  { 0x075B, BIDI_AL  },  // ARABIC LETTER REH WITH STROKE
  { 0x075C, BIDI_AL  },  // ARABIC LETTER SEEN WITH FOUR DOTS ABOVE
  { 0x075D, BIDI_AL  },  // ARABIC LETTER AIN WITH TWO DOTS ABOVE
  { 0x075E, BIDI_AL  },  // ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE
  { 0x075F, BIDI_AL  },  // ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE
  { 0x0760, BIDI_AL  },  // ARABIC LETTER FEH WITH TWO DOTS BELOW
  { 0x0761, BIDI_AL  },  // ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW
  { 0x0762, BIDI_AL  },  // ARABIC LETTER KEHEH WITH DOT ABOVE
  { 0x0763, BIDI_AL  },  // ARABIC LETTER KEHEH WITH THREE DOTS ABOVE
  { 0x0764, BIDI_AL  },  // ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW
  { 0x0765, BIDI_AL  },  // ARABIC LETTER MEEM WITH DOT ABOVE
  { 0x0766, BIDI_AL  },  // ARABIC LETTER MEEM WITH DOT BELOW
  { 0x0767, BIDI_AL  },  // ARABIC LETTER NOON WITH TWO DOTS BELOW
  { 0x0768, BIDI_AL  },  // ARABIC LETTER NOON WITH SMALL TAH
  { 0x0769, BIDI_AL  },  // ARABIC LETTER NOON WITH SMALL V
  { 0x076A, BIDI_AL  },  // ARABIC LETTER LAM WITH BAR
  { 0x076B, BIDI_AL  },  // ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE
  { 0x076C, BIDI_AL  },  // ARABIC LETTER REH WITH HAMZA ABOVE
  { 0x076D, BIDI_AL  },  // ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE
  { 0x076E, BIDI_AL  },  // ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW
  { 0x076F, BIDI_AL  },  // ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS
  { 0x0770, BIDI_AL  },  // ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS
  { 0x0771, BIDI_AL  },  // ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS
  { 0x0772, BIDI_AL  },  // ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE
  { 0x0773, BIDI_AL  },  // ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE
  { 0x0774, BIDI_AL  },  // ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE
  { 0x0775, BIDI_AL  },  // ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE
  { 0x0776, BIDI_AL  },  // ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE
  { 0x0777, BIDI_AL  },  // ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW
  { 0x0778, BIDI_AL  },  // ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE
  { 0x0779, BIDI_AL  },  // ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE
  { 0x077A, BIDI_AL  },  // ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE
  { 0x077B, BIDI_AL  },  // ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE
  { 0x077C, BIDI_AL  },  // ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW
  { 0x077D, BIDI_AL  },  // ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE
  { 0x077E, BIDI_AL  },  // ARABIC LETTER SEEN WITH INVERTED V
  { 0x077F, BIDI_AL  },  // ARABIC LETTER KAF WITH TWO DOTS ABOVE
  { 0x0780, BIDI_AL  },  // THAANA LETTER HAA
  { 0x0781, BIDI_AL  },  // THAANA LETTER SHAVIYANI
  { 0x0782, BIDI_AL  },  // THAANA LETTER NOONU
  { 0x0783, BIDI_AL  },  // THAANA LETTER RAA
  { 0x0784, BIDI_AL  },  // THAANA LETTER BAA
  { 0x0785, BIDI_AL  },  // THAANA LETTER LHAVIYANI
  { 0x0786, BIDI_AL  },  // THAANA LETTER KAAFU
  { 0x0787, BIDI_AL  },  // THAANA LETTER ALIFU
  { 0x0788, BIDI_AL  },  // THAANA LETTER VAAVU
  { 0x0789, BIDI_AL  },  // THAANA LETTER MEEMU
  { 0x078A, BIDI_AL  },  // THAANA LETTER FAAFU
  { 0x078B, BIDI_AL  },  // THAANA LETTER DHAALU
  { 0x078C, BIDI_AL  },  // THAANA LETTER THAA
  { 0x078D, BIDI_AL  },  // THAANA LETTER LAAMU
  { 0x078E, BIDI_AL  },  // THAANA LETTER GAAFU
  { 0x078F, BIDI_AL  },  // THAANA LETTER GNAVIYANI
  { 0x0790, BIDI_AL  },  // THAANA LETTER SEENU
  { 0x0791, BIDI_AL  },  // THAANA LETTER DAVIYANI
  { 0x0792, BIDI_AL  },  // THAANA LETTER ZAVIYANI
  { 0x0793, BIDI_AL  },  // THAANA LETTER TAVIYANI
  { 0x0794, BIDI_AL  },  // THAANA LETTER YAA
  { 0x0795, BIDI_AL  },  // THAANA LETTER PAVIYANI
  { 0x0796, BIDI_AL  },  // THAANA LETTER JAVIYANI
  { 0x0797, BIDI_AL  },  // THAANA LETTER CHAVIYANI
  { 0x0798, BIDI_AL  },  // THAANA LETTER TTAA
  { 0x0799, BIDI_AL  },  // THAANA LETTER HHAA
  { 0x079A, BIDI_AL  },  // THAANA LETTER KHAA
  { 0x079B, BIDI_AL  },  // THAANA LETTER THAALU
  { 0x079C, BIDI_AL  },  // THAANA LETTER ZAA
  { 0x079D, BIDI_AL  },  // THAANA LETTER SHEENU
  { 0x079E, BIDI_AL  },  // THAANA LETTER SAADHU
  { 0x079F, BIDI_AL  },  // THAANA LETTER DAADHU
  { 0x07A0, BIDI_AL  },  // THAANA LETTER TO
  { 0x07A1, BIDI_AL  },  // THAANA LETTER ZO
  { 0x07A2, BIDI_AL  },  // THAANA LETTER AINU
  { 0x07A3, BIDI_AL  },  // THAANA LETTER GHAINU
  { 0x07A4, BIDI_AL  },  // THAANA LETTER QAAFU
  { 0x07A5, BIDI_AL  },  // THAANA LETTER WAAVU
  { 0x07A6, BIDI_NSM },  // THAANA ABAFILI
  { 0x07A7, BIDI_NSM },  // THAANA AABAAFILI
  { 0x07A8, BIDI_NSM },  // THAANA IBIFILI
  { 0x07A9, BIDI_NSM },  // THAANA EEBEEFILI
  { 0x07AA, BIDI_NSM },  // THAANA UBUFILI
  { 0x07AB, BIDI_NSM },  // THAANA OOBOOFILI
  { 0x07AC, BIDI_NSM },  // THAANA EBEFILI
  { 0x07AD, BIDI_NSM },  // THAANA EYBEYFILI
  { 0x07AE, BIDI_NSM },  // THAANA OBOFILI
  { 0x07AF, BIDI_NSM },  // THAANA OABOAFILI
  { 0x07B0, BIDI_NSM },  // THAANA SUKUN
  { 0x07B1, BIDI_AL  },  // THAANA LETTER NAA
  { 0x07C0, BIDI_R   },  // NKO DIGIT ZERO
  { 0x07C1, BIDI_R   },  // NKO DIGIT ONE
  { 0x07C2, BIDI_R   },  // NKO DIGIT TWO
  { 0x07C3, BIDI_R   },  // NKO DIGIT THREE
  { 0x07C4, BIDI_R   },  // NKO DIGIT FOUR
  { 0x07C5, BIDI_R   },  // NKO DIGIT FIVE
  { 0x07C6, BIDI_R   },  // NKO DIGIT SIX
  { 0x07C7, BIDI_R   },  // NKO DIGIT SEVEN
  { 0x07C8, BIDI_R   },  // NKO DIGIT EIGHT
  { 0x07C9, BIDI_R   },  // NKO DIGIT NINE
  { 0x07CA, BIDI_R   },  // NKO LETTER A
  { 0x07CB, BIDI_R   },  // NKO LETTER EE
  { 0x07CC, BIDI_R   },  // NKO LETTER I
  { 0x07CD, BIDI_R   },  // NKO LETTER E
  { 0x07CE, BIDI_R   },  // NKO LETTER U
  { 0x07CF, BIDI_R   },  // NKO LETTER OO
  { 0x07D0, BIDI_R   },  // NKO LETTER O
  { 0x07D1, BIDI_R   },  // NKO LETTER DAGBASINNA
  { 0x07D2, BIDI_R   },  // NKO LETTER N
  { 0x07D3, BIDI_R   },  // NKO LETTER BA
  { 0x07D4, BIDI_R   },  // NKO LETTER PA
  { 0x07D5, BIDI_R   },  // NKO LETTER TA
  { 0x07D6, BIDI_R   },  // NKO LETTER JA
  { 0x07D7, BIDI_R   },  // NKO LETTER CHA
  { 0x07D8, BIDI_R   },  // NKO LETTER DA
  { 0x07D9, BIDI_R   },  // NKO LETTER RA
  { 0x07DA, BIDI_R   },  // NKO LETTER RRA
  { 0x07DB, BIDI_R   },  // NKO LETTER SA
  { 0x07DC, BIDI_R   },  // NKO LETTER GBA
  { 0x07DD, BIDI_R   },  // NKO LETTER FA
  { 0x07DE, BIDI_R   },  // NKO LETTER KA
  { 0x07DF, BIDI_R   },  // NKO LETTER LA
  { 0x07E0, BIDI_R   },  // NKO LETTER NA WOLOSO
  { 0x07E1, BIDI_R   },  // NKO LETTER MA
  { 0x07E2, BIDI_R   },  // NKO LETTER NYA
  { 0x07E3, BIDI_R   },  // NKO LETTER NA
  { 0x07E4, BIDI_R   },  // NKO LETTER HA
  { 0x07E5, BIDI_R   },  // NKO LETTER WA
  { 0x07E6, BIDI_R   },  // NKO LETTER YA
  { 0x07E7, BIDI_R   },  // NKO LETTER NYA WOLOSO
  { 0x07E8, BIDI_R   },  // NKO LETTER JONA JA
  { 0x07E9, BIDI_R   },  // NKO LETTER JONA CHA
  { 0x07EA, BIDI_R   },  // NKO LETTER JONA RA
  { 0x07EB, BIDI_NSM },  // NKO COMBINING SHORT HIGH TONE
  { 0x07EC, BIDI_NSM },  // NKO COMBINING SHORT LOW TONE
  { 0x07ED, BIDI_NSM },  // NKO COMBINING SHORT RISING TONE
  { 0x07EE, BIDI_NSM },  // NKO COMBINING LONG DESCENDING TONE
  { 0x07EF, BIDI_NSM },  // NKO COMBINING LONG HIGH TONE
  { 0x07F0, BIDI_NSM },  // NKO COMBINING LONG LOW TONE
  { 0x07F1, BIDI_NSM },  // NKO COMBINING LONG RISING TONE
  { 0x07F2, BIDI_NSM },  // NKO COMBINING NASALIZATION MARK
  { 0x07F3, BIDI_NSM },  // NKO COMBINING DOUBLE DOT ABOVE
  { 0x07F4, BIDI_R   },  // NKO HIGH TONE APOSTROPHE
  { 0x07F5, BIDI_R   },  // NKO LOW TONE APOSTROPHE
  { 0x07F6, BIDI_ON  },  // NKO SYMBOL OO DENNEN
  { 0x07F7, BIDI_ON  },  // NKO SYMBOL GBAKURUNEN
  { 0x07F8, BIDI_ON  },  // NKO COMMA
  { 0x07F9, BIDI_ON  },  // NKO EXCLAMATION MARK
  { 0x07FA, BIDI_R   },  // NKO LAJANYALAN
  { 0x0800, BIDI_R   },  // SAMARITAN LETTER ALAF
  { 0x0801, BIDI_R   },  // SAMARITAN LETTER BIT
  { 0x0802, BIDI_R   },  // SAMARITAN LETTER GAMAN
  { 0x0803, BIDI_R   },  // SAMARITAN LETTER DALAT
  { 0x0804, BIDI_R   },  // SAMARITAN LETTER IY
  { 0x0805, BIDI_R   },  // SAMARITAN LETTER BAA
  { 0x0806, BIDI_R   },  // SAMARITAN LETTER ZEN
  { 0x0807, BIDI_R   },  // SAMARITAN LETTER IT
  { 0x0808, BIDI_R   },  // SAMARITAN LETTER TIT
  { 0x0809, BIDI_R   },  // SAMARITAN LETTER YUT
  { 0x080A, BIDI_R   },  // SAMARITAN LETTER KAAF
  { 0x080B, BIDI_R   },  // SAMARITAN LETTER LABAT
  { 0x080C, BIDI_R   },  // SAMARITAN LETTER MIM
  { 0x080D, BIDI_R   },  // SAMARITAN LETTER NUN
  { 0x080E, BIDI_R   },  // SAMARITAN LETTER SINGAAT
  { 0x080F, BIDI_R   },  // SAMARITAN LETTER IN
  { 0x0810, BIDI_R   },  // SAMARITAN LETTER FI
  { 0x0811, BIDI_R   },  // SAMARITAN LETTER TSAADIY
  { 0x0812, BIDI_R   },  // SAMARITAN LETTER QUF
  { 0x0813, BIDI_R   },  // SAMARITAN LETTER RISH
  { 0x0814, BIDI_R   },  // SAMARITAN LETTER SHAN
  { 0x0815, BIDI_R   },  // SAMARITAN LETTER TAAF
  { 0x0816, BIDI_NSM },  // SAMARITAN MARK IN
  { 0x0817, BIDI_NSM },  // SAMARITAN MARK IN-ALAF
  { 0x0818, BIDI_NSM },  // SAMARITAN MARK OCCLUSION
  { 0x0819, BIDI_NSM },  // SAMARITAN MARK DAGESH
  { 0x081A, BIDI_R   },  // SAMARITAN MODIFIER LETTER EPENTHETIC YUT
  { 0x081B, BIDI_NSM },  // SAMARITAN MARK EPENTHETIC YUT
  { 0x081C, BIDI_NSM },  // SAMARITAN VOWEL SIGN LONG E
  { 0x081D, BIDI_NSM },  // SAMARITAN VOWEL SIGN E
  { 0x081E, BIDI_NSM },  // SAMARITAN VOWEL SIGN OVERLONG AA
  { 0x081F, BIDI_NSM },  // SAMARITAN VOWEL SIGN LONG AA
  { 0x0820, BIDI_NSM },  // SAMARITAN VOWEL SIGN AA
  { 0x0821, BIDI_NSM },  // SAMARITAN VOWEL SIGN OVERLONG A
  { 0x0822, BIDI_NSM },  // SAMARITAN VOWEL SIGN LONG A
  { 0x0823, BIDI_NSM },  // SAMARITAN VOWEL SIGN A
  { 0x0824, BIDI_R   },  // SAMARITAN MODIFIER LETTER SHORT A
  { 0x0825, BIDI_NSM },  // SAMARITAN VOWEL SIGN SHORT A
  { 0x0826, BIDI_NSM },  // SAMARITAN VOWEL SIGN LONG U
  { 0x0827, BIDI_NSM },  // SAMARITAN VOWEL SIGN U
  { 0x0828, BIDI_R   },  // SAMARITAN MODIFIER LETTER I
  { 0x0829, BIDI_NSM },  // SAMARITAN VOWEL SIGN LONG I
  { 0x082A, BIDI_NSM },  // SAMARITAN VOWEL SIGN I
  { 0x082B, BIDI_NSM },  // SAMARITAN VOWEL SIGN O
  { 0x082C, BIDI_NSM },  // SAMARITAN VOWEL SIGN SUKUN
  { 0x082D, BIDI_NSM },  // SAMARITAN MARK NEQUDAA
  { 0x0830, BIDI_R   },  // SAMARITAN PUNCTUATION NEQUDAA
  { 0x0831, BIDI_R   },  // SAMARITAN PUNCTUATION AFSAAQ
  { 0x0832, BIDI_R   },  // SAMARITAN PUNCTUATION ANGED
  { 0x0833, BIDI_R   },  // SAMARITAN PUNCTUATION BAU
  { 0x0834, BIDI_R   },  // SAMARITAN PUNCTUATION ATMAAU
  { 0x0835, BIDI_R   },  // SAMARITAN PUNCTUATION SHIYYAALAA
  { 0x0836, BIDI_R   },  // SAMARITAN ABBREVIATION MARK
  { 0x0837, BIDI_R   },  // SAMARITAN PUNCTUATION MELODIC QITSA
  { 0x0838, BIDI_R   },  // SAMARITAN PUNCTUATION ZIQAA
  { 0x0839, BIDI_R   },  // SAMARITAN PUNCTUATION QITSA
  { 0x083A, BIDI_R   },  // SAMARITAN PUNCTUATION ZAEF
  { 0x083B, BIDI_R   },  // SAMARITAN PUNCTUATION TURU
  { 0x083C, BIDI_R   },  // SAMARITAN PUNCTUATION ARKAANU
  { 0x083D, BIDI_R   },  // SAMARITAN PUNCTUATION SOF MASHFAAT
  { 0x083E, BIDI_R   },  // SAMARITAN PUNCTUATION ANNAAU
  { 0x0840, BIDI_R   },  // MANDAIC LETTER HALQA
  { 0x0841, BIDI_R   },  // MANDAIC LETTER AB
  { 0x0842, BIDI_R   },  // MANDAIC LETTER AG
  { 0x0843, BIDI_R   },  // MANDAIC LETTER AD
  { 0x0844, BIDI_R   },  // MANDAIC LETTER AH
  { 0x0845, BIDI_R   },  // MANDAIC LETTER USHENNA
  { 0x0846, BIDI_R   },  // MANDAIC LETTER AZ
  { 0x0847, BIDI_R   },  // MANDAIC LETTER IT
  { 0x0848, BIDI_R   },  // MANDAIC LETTER ATT
  { 0x0849, BIDI_R   },  // MANDAIC LETTER AKSA
  { 0x084A, BIDI_R   },  // MANDAIC LETTER AK
  { 0x084B, BIDI_R   },  // MANDAIC LETTER AL
  { 0x084C, BIDI_R   },  // MANDAIC LETTER AM
  { 0x084D, BIDI_R   },  // MANDAIC LETTER AN
  { 0x084E, BIDI_R   },  // MANDAIC LETTER AS
  { 0x084F, BIDI_R   },  // MANDAIC LETTER IN
  { 0x0850, BIDI_R   },  // MANDAIC LETTER AP
  { 0x0851, BIDI_R   },  // MANDAIC LETTER ASZ
  { 0x0852, BIDI_R   },  // MANDAIC LETTER AQ
  { 0x0853, BIDI_R   },  // MANDAIC LETTER AR
  { 0x0854, BIDI_R   },  // MANDAIC LETTER ASH
  { 0x0855, BIDI_R   },  // MANDAIC LETTER AT
  { 0x0856, BIDI_R   },  // MANDAIC LETTER DUSHENNA
  { 0x0857, BIDI_R   },  // MANDAIC LETTER KAD
  { 0x0858, BIDI_R   },  // MANDAIC LETTER AIN
  { 0x0859, BIDI_NSM },  // MANDAIC AFFRICATION MARK
  { 0x085A, BIDI_NSM },  // MANDAIC VOCALIZATION MARK
  { 0x085B, BIDI_NSM },  // MANDAIC GEMINATION MARK
  { 0x085E, BIDI_R   },  // MANDAIC PUNCTUATION
  { 0x08A0, BIDI_AL  },  // ARABIC LETTER BEH WITH SMALL V BELOW
  { 0x08A1, BIDI_AL  },  // ARABIC LETTER BEH WITH HAMZA ABOVE
  { 0x08A2, BIDI_AL  },  // ARABIC LETTER JEEM WITH TWO DOTS ABOVE
  { 0x08A3, BIDI_AL  },  // ARABIC LETTER TAH WITH TWO DOTS ABOVE
  { 0x08A4, BIDI_AL  },  // ARABIC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVE
  { 0x08A5, BIDI_AL  },  // ARABIC LETTER QAF WITH DOT BELOW
  { 0x08A6, BIDI_AL  },  // ARABIC LETTER LAM WITH DOUBLE BAR
  { 0x08A7, BIDI_AL  },  // ARABIC LETTER MEEM WITH THREE DOTS ABOVE
  { 0x08A8, BIDI_AL  },  // ARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVE
  { 0x08A9, BIDI_AL  },  // ARABIC LETTER YEH WITH TWO DOTS BELOW AND DOT ABOVE
  { 0x08AA, BIDI_AL  },  // ARABIC LETTER REH WITH LOOP
  { 0x08AB, BIDI_AL  },  // ARABIC LETTER WAW WITH DOT WITHIN
  { 0x08AC, BIDI_AL  },  // ARABIC LETTER ROHINGYA YEH
  { 0x08AD, BIDI_AL  },  // ARABIC LETTER LOW ALEF
  { 0x08AE, BIDI_AL  },  // ARABIC LETTER DAL WITH THREE DOTS BELOW
  { 0x08AF, BIDI_AL  },  // ARABIC LETTER SAD WITH THREE DOTS BELOW
  { 0x08B0, BIDI_AL  },  // ARABIC LETTER GAF WITH INVERTED STROKE
  { 0x08B1, BIDI_AL  },  // ARABIC LETTER STRAIGHT WAW
  { 0x08B2, BIDI_AL  },  // ARABIC LETTER ZAIN WITH INVERTED V ABOVE
  { 0x08B3, BIDI_AL  },  // ARABIC LETTER AIN WITH THREE DOTS BELOW
  { 0x08B4, BIDI_AL  },  // ARABIC LETTER KAF WITH DOT BELOW
  { 0x08E3, BIDI_NSM },  // ARABIC TURNED DAMMA BELOW
  { 0x08E4, BIDI_NSM },  // ARABIC CURLY FATHA
  { 0x08E5, BIDI_NSM },  // ARABIC CURLY DAMMA
  { 0x08E6, BIDI_NSM },  // ARABIC CURLY KASRA
  { 0x08E7, BIDI_NSM },  // ARABIC CURLY FATHATAN
  { 0x08E8, BIDI_NSM },  // ARABIC CURLY DAMMATAN
  { 0x08E9, BIDI_NSM },  // ARABIC CURLY KASRATAN
  { 0x08EA, BIDI_NSM },  // ARABIC TONE ONE DOT ABOVE
  { 0x08EB, BIDI_NSM },  // ARABIC TONE TWO DOTS ABOVE
  { 0x08EC, BIDI_NSM },  // ARABIC TONE LOOP ABOVE
  { 0x08ED, BIDI_NSM },  // ARABIC TONE ONE DOT BELOW
  { 0x08EE, BIDI_NSM },  // ARABIC TONE TWO DOTS BELOW
  { 0x08EF, BIDI_NSM },  // ARABIC TONE LOOP BELOW
  { 0x08F0, BIDI_NSM },  // ARABIC OPEN FATHATAN
  { 0x08F1, BIDI_NSM },  // ARABIC OPEN DAMMATAN
  { 0x08F2, BIDI_NSM },  // ARABIC OPEN KASRATAN
  { 0x08F3, BIDI_NSM },  // ARABIC SMALL HIGH WAW
  { 0x08F4, BIDI_NSM },  // ARABIC FATHA WITH RING
  { 0x08F5, BIDI_NSM },  // ARABIC FATHA WITH DOT ABOVE
  { 0x08F6, BIDI_NSM },  // ARABIC KASRA WITH DOT BELOW
  { 0x08F7, BIDI_NSM },  // ARABIC LEFT ARROWHEAD ABOVE
  { 0x08F8, BIDI_NSM },  // ARABIC RIGHT ARROWHEAD ABOVE
  { 0x08F9, BIDI_NSM },  // ARABIC LEFT ARROWHEAD BELOW
  { 0x08FA, BIDI_NSM },  // ARABIC RIGHT ARROWHEAD BELOW
  { 0x08FB, BIDI_NSM },  // ARABIC DOUBLE RIGHT ARROWHEAD ABOVE
  { 0x08FC, BIDI_NSM },  // ARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOT
  { 0x08FD, BIDI_NSM },  // ARABIC RIGHT ARROWHEAD ABOVE WITH DOT
  { 0x08FE, BIDI_NSM },  // ARABIC DAMMA WITH DOT
  { 0x08FF, BIDI_NSM },  // ARABIC MARK SIDEWAYS NOON GHUNNA
  { 0x0900, BIDI_NSM },  // DEVANAGARI SIGN INVERTED CANDRABINDU
  { 0x0901, BIDI_NSM },  // DEVANAGARI SIGN CANDRABINDU
  { 0x0902, BIDI_NSM },  // DEVANAGARI SIGN ANUSVARA
  { 0x0903, BIDI_L   },  // DEVANAGARI SIGN VISARGA
  { 0x0904, BIDI_L   },  // DEVANAGARI LETTER SHORT A
  { 0x0905, BIDI_L   },  // DEVANAGARI LETTER A
  { 0x0906, BIDI_L   },  // DEVANAGARI LETTER AA
  { 0x0907, BIDI_L   },  // DEVANAGARI LETTER I
  { 0x0908, BIDI_L   },  // DEVANAGARI LETTER II
  { 0x0909, BIDI_L   },  // DEVANAGARI LETTER U
  { 0x090A, BIDI_L   },  // DEVANAGARI LETTER UU
  { 0x090B, BIDI_L   },  // DEVANAGARI LETTER VOCALIC R
  { 0x090C, BIDI_L   },  // DEVANAGARI LETTER VOCALIC L
  { 0x090D, BIDI_L   },  // DEVANAGARI LETTER CANDRA E
  { 0x090E, BIDI_L   },  // DEVANAGARI LETTER SHORT E
  { 0x090F, BIDI_L   },  // DEVANAGARI LETTER E
  { 0x0910, BIDI_L   },  // DEVANAGARI LETTER AI
  { 0x0911, BIDI_L   },  // DEVANAGARI LETTER CANDRA O
  { 0x0912, BIDI_L   },  // DEVANAGARI LETTER SHORT O
  { 0x0913, BIDI_L   },  // DEVANAGARI LETTER O
  { 0x0914, BIDI_L   },  // DEVANAGARI LETTER AU
  { 0x0915, BIDI_L   },  // DEVANAGARI LETTER KA
  { 0x0916, BIDI_L   },  // DEVANAGARI LETTER KHA
  { 0x0917, BIDI_L   },  // DEVANAGARI LETTER GA
  { 0x0918, BIDI_L   },  // DEVANAGARI LETTER GHA
  { 0x0919, BIDI_L   },  // DEVANAGARI LETTER NGA
  { 0x091A, BIDI_L   },  // DEVANAGARI LETTER CA
  { 0x091B, BIDI_L   },  // DEVANAGARI LETTER CHA
  { 0x091C, BIDI_L   },  // DEVANAGARI LETTER JA
  { 0x091D, BIDI_L   },  // DEVANAGARI LETTER JHA
  { 0x091E, BIDI_L   },  // DEVANAGARI LETTER NYA
  { 0x091F, BIDI_L   },  // DEVANAGARI LETTER TTA
  { 0x0920, BIDI_L   },  // DEVANAGARI LETTER TTHA
  { 0x0921, BIDI_L   },  // DEVANAGARI LETTER DDA
  { 0x0922, BIDI_L   },  // DEVANAGARI LETTER DDHA
  { 0x0923, BIDI_L   },  // DEVANAGARI LETTER NNA
  { 0x0924, BIDI_L   },  // DEVANAGARI LETTER TA
  { 0x0925, BIDI_L   },  // DEVANAGARI LETTER THA
  { 0x0926, BIDI_L   },  // DEVANAGARI LETTER DA
  { 0x0927, BIDI_L   },  // DEVANAGARI LETTER DHA
  { 0x0928, BIDI_L   },  // DEVANAGARI LETTER NA
  { 0x0929, BIDI_L   },  // DEVANAGARI LETTER NNNA
  { 0x092A, BIDI_L   },  // DEVANAGARI LETTER PA
  { 0x092B, BIDI_L   },  // DEVANAGARI LETTER PHA
  { 0x092C, BIDI_L   },  // DEVANAGARI LETTER BA
  { 0x092D, BIDI_L   },  // DEVANAGARI LETTER BHA
  { 0x092E, BIDI_L   },  // DEVANAGARI LETTER MA
  { 0x092F, BIDI_L   },  // DEVANAGARI LETTER YA
  { 0x0930, BIDI_L   },  // DEVANAGARI LETTER RA
  { 0x0931, BIDI_L   },  // DEVANAGARI LETTER RRA
  { 0x0932, BIDI_L   },  // DEVANAGARI LETTER LA
  { 0x0933, BIDI_L   },  // DEVANAGARI LETTER LLA
  { 0x0934, BIDI_L   },  // DEVANAGARI LETTER LLLA
  { 0x0935, BIDI_L   },  // DEVANAGARI LETTER VA
  { 0x0936, BIDI_L   },  // DEVANAGARI LETTER SHA
  { 0x0937, BIDI_L   },  // DEVANAGARI LETTER SSA
  { 0x0938, BIDI_L   },  // DEVANAGARI LETTER SA
  { 0x0939, BIDI_L   },  // DEVANAGARI LETTER HA
  { 0x093A, BIDI_NSM },  // DEVANAGARI VOWEL SIGN OE
  { 0x093B, BIDI_L   },  // DEVANAGARI VOWEL SIGN OOE
  { 0x093C, BIDI_NSM },  // DEVANAGARI SIGN NUKTA
  { 0x093D, BIDI_L   },  // DEVANAGARI SIGN AVAGRAHA
  { 0x093E, BIDI_L   },  // DEVANAGARI VOWEL SIGN AA
  { 0x093F, BIDI_L   },  // DEVANAGARI VOWEL SIGN I
  { 0x0940, BIDI_L   },  // DEVANAGARI VOWEL SIGN II
  { 0x0941, BIDI_NSM },  // DEVANAGARI VOWEL SIGN U
  { 0x0942, BIDI_NSM },  // DEVANAGARI VOWEL SIGN UU
  { 0x0943, BIDI_NSM },  // DEVANAGARI VOWEL SIGN VOCALIC R
  { 0x0944, BIDI_NSM },  // DEVANAGARI VOWEL SIGN VOCALIC RR
  { 0x0945, BIDI_NSM },  // DEVANAGARI VOWEL SIGN CANDRA E
  { 0x0946, BIDI_NSM },  // DEVANAGARI VOWEL SIGN SHORT E
  { 0x0947, BIDI_NSM },  // DEVANAGARI VOWEL SIGN E
  { 0x0948, BIDI_NSM },  // DEVANAGARI VOWEL SIGN AI
  { 0x0949, BIDI_L   },  // DEVANAGARI VOWEL SIGN CANDRA O
  { 0x094A, BIDI_L   },  // DEVANAGARI VOWEL SIGN SHORT O
  { 0x094B, BIDI_L   },  // DEVANAGARI VOWEL SIGN O
  { 0x094C, BIDI_L   },  // DEVANAGARI VOWEL SIGN AU
  { 0x094D, BIDI_NSM },  // DEVANAGARI SIGN VIRAMA
  { 0x094E, BIDI_L   },  // DEVANAGARI VOWEL SIGN PRISHTHAMATRA E
  { 0x094F, BIDI_L   },  // DEVANAGARI VOWEL SIGN AW
  { 0x0950, BIDI_L   },  // DEVANAGARI OM
  { 0x0951, BIDI_NSM },  // DEVANAGARI STRESS SIGN UDATTA
  { 0x0952, BIDI_NSM },  // DEVANAGARI STRESS SIGN ANUDATTA
  { 0x0953, BIDI_NSM },  // DEVANAGARI GRAVE ACCENT
  { 0x0954, BIDI_NSM },  // DEVANAGARI ACUTE ACCENT
  { 0x0955, BIDI_NSM },  // DEVANAGARI VOWEL SIGN CANDRA LONG E
  { 0x0956, BIDI_NSM },  // DEVANAGARI VOWEL SIGN UE
  { 0x0957, BIDI_NSM },  // DEVANAGARI VOWEL SIGN UUE
  { 0x0958, BIDI_L   },  // DEVANAGARI LETTER QA
  { 0x0959, BIDI_L   },  // DEVANAGARI LETTER KHHA
  { 0x095A, BIDI_L   },  // DEVANAGARI LETTER GHHA
  { 0x095B, BIDI_L   },  // DEVANAGARI LETTER ZA
  { 0x095C, BIDI_L   },  // DEVANAGARI LETTER DDDHA
  { 0x095D, BIDI_L   },  // DEVANAGARI LETTER RHA
  { 0x095E, BIDI_L   },  // DEVANAGARI LETTER FA
  { 0x095F, BIDI_L   },  // DEVANAGARI LETTER YYA
  { 0x0960, BIDI_L   },  // DEVANAGARI LETTER VOCALIC RR
  { 0x0961, BIDI_L   },  // DEVANAGARI LETTER VOCALIC LL
  { 0x0962, BIDI_NSM },  // DEVANAGARI VOWEL SIGN VOCALIC L
  { 0x0963, BIDI_NSM },  // DEVANAGARI VOWEL SIGN VOCALIC LL
  { 0x0964, BIDI_L   },  // DEVANAGARI DANDA
  { 0x0965, BIDI_L   },  // DEVANAGARI DOUBLE DANDA
  { 0x0966, BIDI_L   },  // DEVANAGARI DIGIT ZERO
  { 0x0967, BIDI_L   },  // DEVANAGARI DIGIT ONE
  { 0x0968, BIDI_L   },  // DEVANAGARI DIGIT TWO
  { 0x0969, BIDI_L   },  // DEVANAGARI DIGIT THREE
  { 0x096A, BIDI_L   },  // DEVANAGARI DIGIT FOUR
  { 0x096B, BIDI_L   },  // DEVANAGARI DIGIT FIVE
  { 0x096C, BIDI_L   },  // DEVANAGARI DIGIT SIX
  { 0x096D, BIDI_L   },  // DEVANAGARI DIGIT SEVEN
  { 0x096E, BIDI_L   },  // DEVANAGARI DIGIT EIGHT
  { 0x096F, BIDI_L   },  // DEVANAGARI DIGIT NINE
  { 0x0970, BIDI_L   },  // DEVANAGARI ABBREVIATION SIGN
  { 0x0971, BIDI_L   },  // DEVANAGARI SIGN HIGH SPACING DOT
  { 0x0972, BIDI_L   },  // DEVANAGARI LETTER CANDRA A
  { 0x0973, BIDI_L   },  // DEVANAGARI LETTER OE
  { 0x0974, BIDI_L   },  // DEVANAGARI LETTER OOE
  { 0x0975, BIDI_L   },  // DEVANAGARI LETTER AW
  { 0x0976, BIDI_L   },  // DEVANAGARI LETTER UE
  { 0x0977, BIDI_L   },  // DEVANAGARI LETTER UUE
  { 0x0978, BIDI_L   },  // DEVANAGARI LETTER MARWARI DDA
  { 0x0979, BIDI_L   },  // DEVANAGARI LETTER ZHA
  { 0x097A, BIDI_L   },  // DEVANAGARI LETTER HEAVY YA
  { 0x097B, BIDI_L   },  // DEVANAGARI LETTER GGA
  { 0x097C, BIDI_L   },  // DEVANAGARI LETTER JJA
  { 0x097D, BIDI_L   },  // DEVANAGARI LETTER GLOTTAL STOP
  { 0x097E, BIDI_L   },  // DEVANAGARI LETTER DDDA
  { 0x097F, BIDI_L   },  // DEVANAGARI LETTER BBA
  { 0x0980, BIDI_L   },  // BENGALI ANJI
  { 0x0981, BIDI_NSM },  // BENGALI SIGN CANDRABINDU
  { 0x0982, BIDI_L   },  // BENGALI SIGN ANUSVARA
  { 0x0983, BIDI_L   },  // BENGALI SIGN VISARGA
  { 0x0985, BIDI_L   },  // BENGALI LETTER A
  { 0x0986, BIDI_L   },  // BENGALI LETTER AA
  { 0x0987, BIDI_L   },  // BENGALI LETTER I
  { 0x0988, BIDI_L   },  // BENGALI LETTER II
  { 0x0989, BIDI_L   },  // BENGALI LETTER U
  { 0x098A, BIDI_L   },  // BENGALI LETTER UU
  { 0x098B, BIDI_L   },  // BENGALI LETTER VOCALIC R
  { 0x098C, BIDI_L   },  // BENGALI LETTER VOCALIC L
  { 0x098F, BIDI_L   },  // BENGALI LETTER E
  { 0x0990, BIDI_L   },  // BENGALI LETTER AI
  { 0x0993, BIDI_L   },  // BENGALI LETTER O
  { 0x0994, BIDI_L   },  // BENGALI LETTER AU
  { 0x0995, BIDI_L   },  // BENGALI LETTER KA
  { 0x0996, BIDI_L   },  // BENGALI LETTER KHA
  { 0x0997, BIDI_L   },  // BENGALI LETTER GA
  { 0x0998, BIDI_L   },  // BENGALI LETTER GHA
  { 0x0999, BIDI_L   },  // BENGALI LETTER NGA
  { 0x099A, BIDI_L   },  // BENGALI LETTER CA
  { 0x099B, BIDI_L   },  // BENGALI LETTER CHA
  { 0x099C, BIDI_L   },  // BENGALI LETTER JA
  { 0x099D, BIDI_L   },  // BENGALI LETTER JHA
  { 0x099E, BIDI_L   },  // BENGALI LETTER NYA
  { 0x099F, BIDI_L   },  // BENGALI LETTER TTA
  { 0x09A0, BIDI_L   },  // BENGALI LETTER TTHA
  { 0x09A1, BIDI_L   },  // BENGALI LETTER DDA
  { 0x09A2, BIDI_L   },  // BENGALI LETTER DDHA
  { 0x09A3, BIDI_L   },  // BENGALI LETTER NNA
  { 0x09A4, BIDI_L   },  // BENGALI LETTER TA
  { 0x09A5, BIDI_L   },  // BENGALI LETTER THA
  { 0x09A6, BIDI_L   },  // BENGALI LETTER DA
  { 0x09A7, BIDI_L   },  // BENGALI LETTER DHA
  { 0x09A8, BIDI_L   },  // BENGALI LETTER NA
  { 0x09AA, BIDI_L   },  // BENGALI LETTER PA
  { 0x09AB, BIDI_L   },  // BENGALI LETTER PHA
  { 0x09AC, BIDI_L   },  // BENGALI LETTER BA
  { 0x09AD, BIDI_L   },  // BENGALI LETTER BHA
  { 0x09AE, BIDI_L   },  // BENGALI LETTER MA
  { 0x09AF, BIDI_L   },  // BENGALI LETTER YA
  { 0x09B0, BIDI_L   },  // BENGALI LETTER RA
  { 0x09B2, BIDI_L   },  // BENGALI LETTER LA
  { 0x09B6, BIDI_L   },  // BENGALI LETTER SHA
  { 0x09B7, BIDI_L   },  // BENGALI LETTER SSA
  { 0x09B8, BIDI_L   },  // BENGALI LETTER SA
  { 0x09B9, BIDI_L   },  // BENGALI LETTER HA
  { 0x09BC, BIDI_NSM },  // BENGALI SIGN NUKTA
  { 0x09BD, BIDI_L   },  // BENGALI SIGN AVAGRAHA
  { 0x09BE, BIDI_L   },  // BENGALI VOWEL SIGN AA
  { 0x09BF, BIDI_L   },  // BENGALI VOWEL SIGN I
  { 0x09C0, BIDI_L   },  // BENGALI VOWEL SIGN II
  { 0x09C1, BIDI_NSM },  // BENGALI VOWEL SIGN U
  { 0x09C2, BIDI_NSM },  // BENGALI VOWEL SIGN UU
  { 0x09C3, BIDI_NSM },  // BENGALI VOWEL SIGN VOCALIC R
  { 0x09C4, BIDI_NSM },  // BENGALI VOWEL SIGN VOCALIC RR
  { 0x09C7, BIDI_L   },  // BENGALI VOWEL SIGN E
  { 0x09C8, BIDI_L   },  // BENGALI VOWEL SIGN AI
  { 0x09CB, BIDI_L   },  // BENGALI VOWEL SIGN O
  { 0x09CC, BIDI_L   },  // BENGALI VOWEL SIGN AU
  { 0x09CD, BIDI_NSM },  // BENGALI SIGN VIRAMA
  { 0x09CE, BIDI_L   },  // BENGALI LETTER KHANDA TA
  { 0x09D7, BIDI_L   },  // BENGALI AU LENGTH MARK
  { 0x09DC, BIDI_L   },  // BENGALI LETTER RRA
  { 0x09DD, BIDI_L   },  // BENGALI LETTER RHA
  { 0x09DF, BIDI_L   },  // BENGALI LETTER YYA
  { 0x09E0, BIDI_L   },  // BENGALI LETTER VOCALIC RR
  { 0x09E1, BIDI_L   },  // BENGALI LETTER VOCALIC LL
  { 0x09E2, BIDI_NSM },  // BENGALI VOWEL SIGN VOCALIC L
  { 0x09E3, BIDI_NSM },  // BENGALI VOWEL SIGN VOCALIC LL
  { 0x09E6, BIDI_L   },  // BENGALI DIGIT ZERO
  { 0x09E7, BIDI_L   },  // BENGALI DIGIT ONE
  { 0x09E8, BIDI_L   },  // BENGALI DIGIT TWO
  { 0x09E9, BIDI_L   },  // BENGALI DIGIT THREE
  { 0x09EA, BIDI_L   },  // BENGALI DIGIT FOUR
  { 0x09EB, BIDI_L   },  // BENGALI DIGIT FIVE
  { 0x09EC, BIDI_L   },  // BENGALI DIGIT SIX
  { 0x09ED, BIDI_L   },  // BENGALI DIGIT SEVEN
  { 0x09EE, BIDI_L   },  // BENGALI DIGIT EIGHT
  { 0x09EF, BIDI_L   },  // BENGALI DIGIT NINE
  { 0x09F0, BIDI_L   },  // BENGALI LETTER RA WITH MIDDLE DIAGONAL
  { 0x09F1, BIDI_L   },  // BENGALI LETTER RA WITH LOWER DIAGONAL
  { 0x09F2, BIDI_ET  },  // BENGALI RUPEE MARK
  { 0x09F3, BIDI_ET  },  // BENGALI RUPEE SIGN
  { 0x09F4, BIDI_L   },  // BENGALI CURRENCY NUMERATOR ONE
  { 0x09F5, BIDI_L   },  // BENGALI CURRENCY NUMERATOR TWO
  { 0x09F6, BIDI_L   },  // BENGALI CURRENCY NUMERATOR THREE
  { 0x09F7, BIDI_L   },  // BENGALI CURRENCY NUMERATOR FOUR
  { 0x09F8, BIDI_L   },  // BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR
  { 0x09F9, BIDI_L   },  // BENGALI CURRENCY DENOMINATOR SIXTEEN
  { 0x09FA, BIDI_L   },  // BENGALI ISSHAR
  { 0x09FB, BIDI_ET  },  // BENGALI GANDA MARK
  { 0x0A01, BIDI_NSM },  // GURMUKHI SIGN ADAK BINDI
  { 0x0A02, BIDI_NSM },  // GURMUKHI SIGN BINDI
  { 0x0A03, BIDI_L   },  // GURMUKHI SIGN VISARGA
  { 0x0A05, BIDI_L   },  // GURMUKHI LETTER A
  { 0x0A06, BIDI_L   },  // GURMUKHI LETTER AA
  { 0x0A07, BIDI_L   },  // GURMUKHI LETTER I
  { 0x0A08, BIDI_L   },  // GURMUKHI LETTER II
  { 0x0A09, BIDI_L   },  // GURMUKHI LETTER U
  { 0x0A0A, BIDI_L   },  // GURMUKHI LETTER UU
  { 0x0A0F, BIDI_L   },  // GURMUKHI LETTER EE
  { 0x0A10, BIDI_L   },  // GURMUKHI LETTER AI
  { 0x0A13, BIDI_L   },  // GURMUKHI LETTER OO
  { 0x0A14, BIDI_L   },  // GURMUKHI LETTER AU
  { 0x0A15, BIDI_L   },  // GURMUKHI LETTER KA
  { 0x0A16, BIDI_L   },  // GURMUKHI LETTER KHA
  { 0x0A17, BIDI_L   },  // GURMUKHI LETTER GA
  { 0x0A18, BIDI_L   },  // GURMUKHI LETTER GHA
  { 0x0A19, BIDI_L   },  // GURMUKHI LETTER NGA
  { 0x0A1A, BIDI_L   },  // GURMUKHI LETTER CA
  { 0x0A1B, BIDI_L   },  // GURMUKHI LETTER CHA
  { 0x0A1C, BIDI_L   },  // GURMUKHI LETTER JA
  { 0x0A1D, BIDI_L   },  // GURMUKHI LETTER JHA
  { 0x0A1E, BIDI_L   },  // GURMUKHI LETTER NYA
  { 0x0A1F, BIDI_L   },  // GURMUKHI LETTER TTA
  { 0x0A20, BIDI_L   },  // GURMUKHI LETTER TTHA
  { 0x0A21, BIDI_L   },  // GURMUKHI LETTER DDA
  { 0x0A22, BIDI_L   },  // GURMUKHI LETTER DDHA
  { 0x0A23, BIDI_L   },  // GURMUKHI LETTER NNA
  { 0x0A24, BIDI_L   },  // GURMUKHI LETTER TA
  { 0x0A25, BIDI_L   },  // GURMUKHI LETTER THA
  { 0x0A26, BIDI_L   },  // GURMUKHI LETTER DA
  { 0x0A27, BIDI_L   },  // GURMUKHI LETTER DHA
  { 0x0A28, BIDI_L   },  // GURMUKHI LETTER NA
  { 0x0A2A, BIDI_L   },  // GURMUKHI LETTER PA
  { 0x0A2B, BIDI_L   },  // GURMUKHI LETTER PHA
  { 0x0A2C, BIDI_L   },  // GURMUKHI LETTER BA
  { 0x0A2D, BIDI_L   },  // GURMUKHI LETTER BHA
  { 0x0A2E, BIDI_L   },  // GURMUKHI LETTER MA
  { 0x0A2F, BIDI_L   },  // GURMUKHI LETTER YA
  { 0x0A30, BIDI_L   },  // GURMUKHI LETTER RA
  { 0x0A32, BIDI_L   },  // GURMUKHI LETTER LA
  { 0x0A33, BIDI_L   },  // GURMUKHI LETTER LLA
  { 0x0A35, BIDI_L   },  // GURMUKHI LETTER VA
  { 0x0A36, BIDI_L   },  // GURMUKHI LETTER SHA
  { 0x0A38, BIDI_L   },  // GURMUKHI LETTER SA
  { 0x0A39, BIDI_L   },  // GURMUKHI LETTER HA
  { 0x0A3C, BIDI_NSM },  // GURMUKHI SIGN NUKTA
  { 0x0A3E, BIDI_L   },  // GURMUKHI VOWEL SIGN AA
  { 0x0A3F, BIDI_L   },  // GURMUKHI VOWEL SIGN I
  { 0x0A40, BIDI_L   },  // GURMUKHI VOWEL SIGN II
  { 0x0A41, BIDI_NSM },  // GURMUKHI VOWEL SIGN U
  { 0x0A42, BIDI_NSM },  // GURMUKHI VOWEL SIGN UU
  { 0x0A47, BIDI_NSM },  // GURMUKHI VOWEL SIGN EE
  { 0x0A48, BIDI_NSM },  // GURMUKHI VOWEL SIGN AI
  { 0x0A4B, BIDI_NSM },  // GURMUKHI VOWEL SIGN OO
  { 0x0A4C, BIDI_NSM },  // GURMUKHI VOWEL SIGN AU
  { 0x0A4D, BIDI_NSM },  // GURMUKHI SIGN VIRAMA
  { 0x0A51, BIDI_NSM },  // GURMUKHI SIGN UDAAT
  { 0x0A59, BIDI_L   },  // GURMUKHI LETTER KHHA
  { 0x0A5A, BIDI_L   },  // GURMUKHI LETTER GHHA
  { 0x0A5B, BIDI_L   },  // GURMUKHI LETTER ZA
  { 0x0A5C, BIDI_L   },  // GURMUKHI LETTER RRA
  { 0x0A5E, BIDI_L   },  // GURMUKHI LETTER FA
  { 0x0A66, BIDI_L   },  // GURMUKHI DIGIT ZERO
  { 0x0A67, BIDI_L   },  // GURMUKHI DIGIT ONE
  { 0x0A68, BIDI_L   },  // GURMUKHI DIGIT TWO
  { 0x0A69, BIDI_L   },  // GURMUKHI DIGIT THREE
  { 0x0A6A, BIDI_L   },  // GURMUKHI DIGIT FOUR
  { 0x0A6B, BIDI_L   },  // GURMUKHI DIGIT FIVE
  { 0x0A6C, BIDI_L   },  // GURMUKHI DIGIT SIX
  { 0x0A6D, BIDI_L   },  // GURMUKHI DIGIT SEVEN
  { 0x0A6E, BIDI_L   },  // GURMUKHI DIGIT EIGHT
  { 0x0A6F, BIDI_L   },  // GURMUKHI DIGIT NINE
  { 0x0A70, BIDI_NSM },  // GURMUKHI TIPPI
  { 0x0A71, BIDI_NSM },  // GURMUKHI ADDAK
  { 0x0A72, BIDI_L   },  // GURMUKHI IRI
  { 0x0A73, BIDI_L   },  // GURMUKHI URA
  { 0x0A74, BIDI_L   },  // GURMUKHI EK ONKAR
  { 0x0A75, BIDI_NSM },  // GURMUKHI SIGN YAKASH
  { 0x0A81, BIDI_NSM },  // GUJARATI SIGN CANDRABINDU
  { 0x0A82, BIDI_NSM },  // GUJARATI SIGN ANUSVARA
  { 0x0A83, BIDI_L   },  // GUJARATI SIGN VISARGA
  { 0x0A85, BIDI_L   },  // GUJARATI LETTER A
  { 0x0A86, BIDI_L   },  // GUJARATI LETTER AA
  { 0x0A87, BIDI_L   },  // GUJARATI LETTER I
  { 0x0A88, BIDI_L   },  // GUJARATI LETTER II
  { 0x0A89, BIDI_L   },  // GUJARATI LETTER U
  { 0x0A8A, BIDI_L   },  // GUJARATI LETTER UU
  { 0x0A8B, BIDI_L   },  // GUJARATI LETTER VOCALIC R
  { 0x0A8C, BIDI_L   },  // GUJARATI LETTER VOCALIC L
  { 0x0A8D, BIDI_L   },  // GUJARATI VOWEL CANDRA E
  { 0x0A8F, BIDI_L   },  // GUJARATI LETTER E
  { 0x0A90, BIDI_L   },  // GUJARATI LETTER AI
  { 0x0A91, BIDI_L   },  // GUJARATI VOWEL CANDRA O
  { 0x0A93, BIDI_L   },  // GUJARATI LETTER O
  { 0x0A94, BIDI_L   },  // GUJARATI LETTER AU
  { 0x0A95, BIDI_L   },  // GUJARATI LETTER KA
  { 0x0A96, BIDI_L   },  // GUJARATI LETTER KHA
  { 0x0A97, BIDI_L   },  // GUJARATI LETTER GA
  { 0x0A98, BIDI_L   },  // GUJARATI LETTER GHA
  { 0x0A99, BIDI_L   },  // GUJARATI LETTER NGA
  { 0x0A9A, BIDI_L   },  // GUJARATI LETTER CA
  { 0x0A9B, BIDI_L   },  // GUJARATI LETTER CHA
  { 0x0A9C, BIDI_L   },  // GUJARATI LETTER JA
  { 0x0A9D, BIDI_L   },  // GUJARATI LETTER JHA
  { 0x0A9E, BIDI_L   },  // GUJARATI LETTER NYA
  { 0x0A9F, BIDI_L   },  // GUJARATI LETTER TTA
  { 0x0AA0, BIDI_L   },  // GUJARATI LETTER TTHA
  { 0x0AA1, BIDI_L   },  // GUJARATI LETTER DDA
  { 0x0AA2, BIDI_L   },  // GUJARATI LETTER DDHA
  { 0x0AA3, BIDI_L   },  // GUJARATI LETTER NNA
  { 0x0AA4, BIDI_L   },  // GUJARATI LETTER TA
  { 0x0AA5, BIDI_L   },  // GUJARATI LETTER THA
  { 0x0AA6, BIDI_L   },  // GUJARATI LETTER DA
  { 0x0AA7, BIDI_L   },  // GUJARATI LETTER DHA
  { 0x0AA8, BIDI_L   },  // GUJARATI LETTER NA
  { 0x0AAA, BIDI_L   },  // GUJARATI LETTER PA
  { 0x0AAB, BIDI_L   },  // GUJARATI LETTER PHA
  { 0x0AAC, BIDI_L   },  // GUJARATI LETTER BA
  { 0x0AAD, BIDI_L   },  // GUJARATI LETTER BHA
  { 0x0AAE, BIDI_L   },  // GUJARATI LETTER MA
  { 0x0AAF, BIDI_L   },  // GUJARATI LETTER YA
  { 0x0AB0, BIDI_L   },  // GUJARATI LETTER RA
  { 0x0AB2, BIDI_L   },  // GUJARATI LETTER LA
  { 0x0AB3, BIDI_L   },  // GUJARATI LETTER LLA
  { 0x0AB5, BIDI_L   },  // GUJARATI LETTER VA
  { 0x0AB6, BIDI_L   },  // GUJARATI LETTER SHA
  { 0x0AB7, BIDI_L   },  // GUJARATI LETTER SSA
  { 0x0AB8, BIDI_L   },  // GUJARATI LETTER SA
  { 0x0AB9, BIDI_L   },  // GUJARATI LETTER HA
  { 0x0ABC, BIDI_NSM },  // GUJARATI SIGN NUKTA
  { 0x0ABD, BIDI_L   },  // GUJARATI SIGN AVAGRAHA
  { 0x0ABE, BIDI_L   },  // GUJARATI VOWEL SIGN AA
  { 0x0ABF, BIDI_L   },  // GUJARATI VOWEL SIGN I
  { 0x0AC0, BIDI_L   },  // GUJARATI VOWEL SIGN II
  { 0x0AC1, BIDI_NSM },  // GUJARATI VOWEL SIGN U
  { 0x0AC2, BIDI_NSM },  // GUJARATI VOWEL SIGN UU
  { 0x0AC3, BIDI_NSM },  // GUJARATI VOWEL SIGN VOCALIC R
  { 0x0AC4, BIDI_NSM },  // GUJARATI VOWEL SIGN VOCALIC RR
  { 0x0AC5, BIDI_NSM },  // GUJARATI VOWEL SIGN CANDRA E
  { 0x0AC7, BIDI_NSM },  // GUJARATI VOWEL SIGN E
  { 0x0AC8, BIDI_NSM },  // GUJARATI VOWEL SIGN AI
  { 0x0AC9, BIDI_L   },  // GUJARATI VOWEL SIGN CANDRA O
  { 0x0ACB, BIDI_L   },  // GUJARATI VOWEL SIGN O
  { 0x0ACC, BIDI_L   },  // GUJARATI VOWEL SIGN AU
  { 0x0ACD, BIDI_NSM },  // GUJARATI SIGN VIRAMA
  { 0x0AD0, BIDI_L   },  // GUJARATI OM
  { 0x0AE0, BIDI_L   },  // GUJARATI LETTER VOCALIC RR
  { 0x0AE1, BIDI_L   },  // GUJARATI LETTER VOCALIC LL
  { 0x0AE2, BIDI_NSM },  // GUJARATI VOWEL SIGN VOCALIC L
  { 0x0AE3, BIDI_NSM },  // GUJARATI VOWEL SIGN VOCALIC LL
  { 0x0AE6, BIDI_L   },  // GUJARATI DIGIT ZERO
  { 0x0AE7, BIDI_L   },  // GUJARATI DIGIT ONE
  { 0x0AE8, BIDI_L   },  // GUJARATI DIGIT TWO
  { 0x0AE9, BIDI_L   },  // GUJARATI DIGIT THREE
  { 0x0AEA, BIDI_L   },  // GUJARATI DIGIT FOUR
  { 0x0AEB, BIDI_L   },  // GUJARATI DIGIT FIVE
  { 0x0AEC, BIDI_L   },  // GUJARATI DIGIT SIX
  { 0x0AED, BIDI_L   },  // GUJARATI DIGIT SEVEN
  { 0x0AEE, BIDI_L   },  // GUJARATI DIGIT EIGHT
  { 0x0AEF, BIDI_L   },  // GUJARATI DIGIT NINE
  { 0x0AF0, BIDI_L   },  // GUJARATI ABBREVIATION SIGN
  { 0x0AF1, BIDI_ET  },  // GUJARATI RUPEE SIGN
  { 0x0AF9, BIDI_L   },  // GUJARATI LETTER ZHA
  { 0x0B01, BIDI_NSM },  // ORIYA SIGN CANDRABINDU
  { 0x0B02, BIDI_L   },  // ORIYA SIGN ANUSVARA
  { 0x0B03, BIDI_L   },  // ORIYA SIGN VISARGA
  { 0x0B05, BIDI_L   },  // ORIYA LETTER A
  { 0x0B06, BIDI_L   },  // ORIYA LETTER AA
  { 0x0B07, BIDI_L   },  // ORIYA LETTER I
  { 0x0B08, BIDI_L   },  // ORIYA LETTER II
  { 0x0B09, BIDI_L   },  // ORIYA LETTER U
  { 0x0B0A, BIDI_L   },  // ORIYA LETTER UU
  { 0x0B0B, BIDI_L   },  // ORIYA LETTER VOCALIC R
  { 0x0B0C, BIDI_L   },  // ORIYA LETTER VOCALIC L
  { 0x0B0F, BIDI_L   },  // ORIYA LETTER E
  { 0x0B10, BIDI_L   },  // ORIYA LETTER AI
  { 0x0B13, BIDI_L   },  // ORIYA LETTER O
  { 0x0B14, BIDI_L   },  // ORIYA LETTER AU
  { 0x0B15, BIDI_L   },  // ORIYA LETTER KA
  { 0x0B16, BIDI_L   },  // ORIYA LETTER KHA
  { 0x0B17, BIDI_L   },  // ORIYA LETTER GA
  { 0x0B18, BIDI_L   },  // ORIYA LETTER GHA
  { 0x0B19, BIDI_L   },  // ORIYA LETTER NGA
  { 0x0B1A, BIDI_L   },  // ORIYA LETTER CA
  { 0x0B1B, BIDI_L   },  // ORIYA LETTER CHA
  { 0x0B1C, BIDI_L   },  // ORIYA LETTER JA
  { 0x0B1D, BIDI_L   },  // ORIYA LETTER JHA
  { 0x0B1E, BIDI_L   },  // ORIYA LETTER NYA
  { 0x0B1F, BIDI_L   },  // ORIYA LETTER TTA
  { 0x0B20, BIDI_L   },  // ORIYA LETTER TTHA
  { 0x0B21, BIDI_L   },  // ORIYA LETTER DDA
  { 0x0B22, BIDI_L   },  // ORIYA LETTER DDHA
  { 0x0B23, BIDI_L   },  // ORIYA LETTER NNA
  { 0x0B24, BIDI_L   },  // ORIYA LETTER TA
  { 0x0B25, BIDI_L   },  // ORIYA LETTER THA
  { 0x0B26, BIDI_L   },  // ORIYA LETTER DA
  { 0x0B27, BIDI_L   },  // ORIYA LETTER DHA
  { 0x0B28, BIDI_L   },  // ORIYA LETTER NA
  { 0x0B2A, BIDI_L   },  // ORIYA LETTER PA
  { 0x0B2B, BIDI_L   },  // ORIYA LETTER PHA
  { 0x0B2C, BIDI_L   },  // ORIYA LETTER BA
  { 0x0B2D, BIDI_L   },  // ORIYA LETTER BHA
  { 0x0B2E, BIDI_L   },  // ORIYA LETTER MA
  { 0x0B2F, BIDI_L   },  // ORIYA LETTER YA
  { 0x0B30, BIDI_L   },  // ORIYA LETTER RA
  { 0x0B32, BIDI_L   },  // ORIYA LETTER LA
  { 0x0B33, BIDI_L   },  // ORIYA LETTER LLA
  { 0x0B35, BIDI_L   },  // ORIYA LETTER VA
  { 0x0B36, BIDI_L   },  // ORIYA LETTER SHA
  { 0x0B37, BIDI_L   },  // ORIYA LETTER SSA
  { 0x0B38, BIDI_L   },  // ORIYA LETTER SA
  { 0x0B39, BIDI_L   },  // ORIYA LETTER HA
  { 0x0B3C, BIDI_NSM },  // ORIYA SIGN NUKTA
  { 0x0B3D, BIDI_L   },  // ORIYA SIGN AVAGRAHA
  { 0x0B3E, BIDI_L   },  // ORIYA VOWEL SIGN AA
  { 0x0B3F, BIDI_NSM },  // ORIYA VOWEL SIGN I
  { 0x0B40, BIDI_L   },  // ORIYA VOWEL SIGN II
  { 0x0B41, BIDI_NSM },  // ORIYA VOWEL SIGN U
  { 0x0B42, BIDI_NSM },  // ORIYA VOWEL SIGN UU
  { 0x0B43, BIDI_NSM },  // ORIYA VOWEL SIGN VOCALIC R
  { 0x0B44, BIDI_NSM },  // ORIYA VOWEL SIGN VOCALIC RR
  { 0x0B47, BIDI_L   },  // ORIYA VOWEL SIGN E
  { 0x0B48, BIDI_L   },  // ORIYA VOWEL SIGN AI
  { 0x0B4B, BIDI_L   },  // ORIYA VOWEL SIGN O
  { 0x0B4C, BIDI_L   },  // ORIYA VOWEL SIGN AU
  { 0x0B4D, BIDI_NSM },  // ORIYA SIGN VIRAMA
  { 0x0B56, BIDI_NSM },  // ORIYA AI LENGTH MARK
  { 0x0B57, BIDI_L   },  // ORIYA AU LENGTH MARK
  { 0x0B5C, BIDI_L   },  // ORIYA LETTER RRA
  { 0x0B5D, BIDI_L   },  // ORIYA LETTER RHA
  { 0x0B5F, BIDI_L   },  // ORIYA LETTER YYA
  { 0x0B60, BIDI_L   },  // ORIYA LETTER VOCALIC RR
  { 0x0B61, BIDI_L   },  // ORIYA LETTER VOCALIC LL
  { 0x0B62, BIDI_NSM },  // ORIYA VOWEL SIGN VOCALIC L
  { 0x0B63, BIDI_NSM },  // ORIYA VOWEL SIGN VOCALIC LL
  { 0x0B66, BIDI_L   },  // ORIYA DIGIT ZERO
  { 0x0B67, BIDI_L   },  // ORIYA DIGIT ONE
  { 0x0B68, BIDI_L   },  // ORIYA DIGIT TWO
  { 0x0B69, BIDI_L   },  // ORIYA DIGIT THREE
  { 0x0B6A, BIDI_L   },  // ORIYA DIGIT FOUR
  { 0x0B6B, BIDI_L   },  // ORIYA DIGIT FIVE
  { 0x0B6C, BIDI_L   },  // ORIYA DIGIT SIX
  { 0x0B6D, BIDI_L   },  // ORIYA DIGIT SEVEN
  { 0x0B6E, BIDI_L   },  // ORIYA DIGIT EIGHT
  { 0x0B6F, BIDI_L   },  // ORIYA DIGIT NINE
  { 0x0B70, BIDI_L   },  // ORIYA ISSHAR
  { 0x0B71, BIDI_L   },  // ORIYA LETTER WA
  { 0x0B72, BIDI_L   },  // ORIYA FRACTION ONE QUARTER
  { 0x0B73, BIDI_L   },  // ORIYA FRACTION ONE HALF
  { 0x0B74, BIDI_L   },  // ORIYA FRACTION THREE QUARTERS
  { 0x0B75, BIDI_L   },  // ORIYA FRACTION ONE SIXTEENTH
  { 0x0B76, BIDI_L   },  // ORIYA FRACTION ONE EIGHTH
  { 0x0B77, BIDI_L   },  // ORIYA FRACTION THREE SIXTEENTHS
  { 0x0B82, BIDI_NSM },  // TAMIL SIGN ANUSVARA
  { 0x0B83, BIDI_L   },  // TAMIL SIGN VISARGA
  { 0x0B85, BIDI_L   },  // TAMIL LETTER A
  { 0x0B86, BIDI_L   },  // TAMIL LETTER AA
  { 0x0B87, BIDI_L   },  // TAMIL LETTER I
  { 0x0B88, BIDI_L   },  // TAMIL LETTER II
  { 0x0B89, BIDI_L   },  // TAMIL LETTER U
  { 0x0B8A, BIDI_L   },  // TAMIL LETTER UU
  { 0x0B8E, BIDI_L   },  // TAMIL LETTER E
  { 0x0B8F, BIDI_L   },  // TAMIL LETTER EE
  { 0x0B90, BIDI_L   },  // TAMIL LETTER AI
  { 0x0B92, BIDI_L   },  // TAMIL LETTER O
  { 0x0B93, BIDI_L   },  // TAMIL LETTER OO
  { 0x0B94, BIDI_L   },  // TAMIL LETTER AU
  { 0x0B95, BIDI_L   },  // TAMIL LETTER KA
  { 0x0B99, BIDI_L   },  // TAMIL LETTER NGA
  { 0x0B9A, BIDI_L   },  // TAMIL LETTER CA
  { 0x0B9C, BIDI_L   },  // TAMIL LETTER JA
  { 0x0B9E, BIDI_L   },  // TAMIL LETTER NYA
  { 0x0B9F, BIDI_L   },  // TAMIL LETTER TTA
  { 0x0BA3, BIDI_L   },  // TAMIL LETTER NNA
  { 0x0BA4, BIDI_L   },  // TAMIL LETTER TA
  { 0x0BA8, BIDI_L   },  // TAMIL LETTER NA
  { 0x0BA9, BIDI_L   },  // TAMIL LETTER NNNA
  { 0x0BAA, BIDI_L   },  // TAMIL LETTER PA
  { 0x0BAE, BIDI_L   },  // TAMIL LETTER MA
  { 0x0BAF, BIDI_L   },  // TAMIL LETTER YA
  { 0x0BB0, BIDI_L   },  // TAMIL LETTER RA
  { 0x0BB1, BIDI_L   },  // TAMIL LETTER RRA
  { 0x0BB2, BIDI_L   },  // TAMIL LETTER LA
  { 0x0BB3, BIDI_L   },  // TAMIL LETTER LLA
  { 0x0BB4, BIDI_L   },  // TAMIL LETTER LLLA
  { 0x0BB5, BIDI_L   },  // TAMIL LETTER VA
  { 0x0BB6, BIDI_L   },  // TAMIL LETTER SHA
  { 0x0BB7, BIDI_L   },  // TAMIL LETTER SSA
  { 0x0BB8, BIDI_L   },  // TAMIL LETTER SA
  { 0x0BB9, BIDI_L   },  // TAMIL LETTER HA
  { 0x0BBE, BIDI_L   },  // TAMIL VOWEL SIGN AA
  { 0x0BBF, BIDI_L   },  // TAMIL VOWEL SIGN I
  { 0x0BC0, BIDI_NSM },  // TAMIL VOWEL SIGN II
  { 0x0BC1, BIDI_L   },  // TAMIL VOWEL SIGN U
  { 0x0BC2, BIDI_L   },  // TAMIL VOWEL SIGN UU
  { 0x0BC6, BIDI_L   },  // TAMIL VOWEL SIGN E
  { 0x0BC7, BIDI_L   },  // TAMIL VOWEL SIGN EE
  { 0x0BC8, BIDI_L   },  // TAMIL VOWEL SIGN AI
  { 0x0BCA, BIDI_L   },  // TAMIL VOWEL SIGN O
  { 0x0BCB, BIDI_L   },  // TAMIL VOWEL SIGN OO
  { 0x0BCC, BIDI_L   },  // TAMIL VOWEL SIGN AU
  { 0x0BCD, BIDI_NSM },  // TAMIL SIGN VIRAMA
  { 0x0BD0, BIDI_L   },  // TAMIL OM
  { 0x0BD7, BIDI_L   },  // TAMIL AU LENGTH MARK
  { 0x0BE6, BIDI_L   },  // TAMIL DIGIT ZERO
  { 0x0BE7, BIDI_L   },  // TAMIL DIGIT ONE
  { 0x0BE8, BIDI_L   },  // TAMIL DIGIT TWO
  { 0x0BE9, BIDI_L   },  // TAMIL DIGIT THREE
  { 0x0BEA, BIDI_L   },  // TAMIL DIGIT FOUR
  { 0x0BEB, BIDI_L   },  // TAMIL DIGIT FIVE
  { 0x0BEC, BIDI_L   },  // TAMIL DIGIT SIX
  { 0x0BED, BIDI_L   },  // TAMIL DIGIT SEVEN
  { 0x0BEE, BIDI_L   },  // TAMIL DIGIT EIGHT
  { 0x0BEF, BIDI_L   },  // TAMIL DIGIT NINE
  { 0x0BF0, BIDI_L   },  // TAMIL NUMBER TEN
  { 0x0BF1, BIDI_L   },  // TAMIL NUMBER ONE HUNDRED
  { 0x0BF2, BIDI_L   },  // TAMIL NUMBER ONE THOUSAND
  { 0x0BF3, BIDI_ON  },  // TAMIL DAY SIGN
  { 0x0BF4, BIDI_ON  },  // TAMIL MONTH SIGN
  { 0x0BF5, BIDI_ON  },  // TAMIL YEAR SIGN
  { 0x0BF6, BIDI_ON  },  // TAMIL DEBIT SIGN
  { 0x0BF7, BIDI_ON  },  // TAMIL CREDIT SIGN
  { 0x0BF8, BIDI_ON  },  // TAMIL AS ABOVE SIGN
  { 0x0BF9, BIDI_ET  },  // TAMIL RUPEE SIGN
  { 0x0BFA, BIDI_ON  },  // TAMIL NUMBER SIGN
  { 0x0C00, BIDI_NSM },  // TELUGU SIGN COMBINING CANDRABINDU ABOVE
  { 0x0C01, BIDI_L   },  // TELUGU SIGN CANDRABINDU
  { 0x0C02, BIDI_L   },  // TELUGU SIGN ANUSVARA
  { 0x0C03, BIDI_L   },  // TELUGU SIGN VISARGA
  { 0x0C05, BIDI_L   },  // TELUGU LETTER A
  { 0x0C06, BIDI_L   },  // TELUGU LETTER AA
  { 0x0C07, BIDI_L   },  // TELUGU LETTER I
  { 0x0C08, BIDI_L   },  // TELUGU LETTER II
  { 0x0C09, BIDI_L   },  // TELUGU LETTER U
  { 0x0C0A, BIDI_L   },  // TELUGU LETTER UU
  { 0x0C0B, BIDI_L   },  // TELUGU LETTER VOCALIC R
  { 0x0C0C, BIDI_L   },  // TELUGU LETTER VOCALIC L
  { 0x0C0E, BIDI_L   },  // TELUGU LETTER E
  { 0x0C0F, BIDI_L   },  // TELUGU LETTER EE
  { 0x0C10, BIDI_L   },  // TELUGU LETTER AI
  { 0x0C12, BIDI_L   },  // TELUGU LETTER O
  { 0x0C13, BIDI_L   },  // TELUGU LETTER OO
  { 0x0C14, BIDI_L   },  // TELUGU LETTER AU
  { 0x0C15, BIDI_L   },  // TELUGU LETTER KA
  { 0x0C16, BIDI_L   },  // TELUGU LETTER KHA
  { 0x0C17, BIDI_L   },  // TELUGU LETTER GA
  { 0x0C18, BIDI_L   },  // TELUGU LETTER GHA
  { 0x0C19, BIDI_L   },  // TELUGU LETTER NGA
  { 0x0C1A, BIDI_L   },  // TELUGU LETTER CA
  { 0x0C1B, BIDI_L   },  // TELUGU LETTER CHA
  { 0x0C1C, BIDI_L   },  // TELUGU LETTER JA
  { 0x0C1D, BIDI_L   },  // TELUGU LETTER JHA
  { 0x0C1E, BIDI_L   },  // TELUGU LETTER NYA
  { 0x0C1F, BIDI_L   },  // TELUGU LETTER TTA
  { 0x0C20, BIDI_L   },  // TELUGU LETTER TTHA
  { 0x0C21, BIDI_L   },  // TELUGU LETTER DDA
  { 0x0C22, BIDI_L   },  // TELUGU LETTER DDHA
  { 0x0C23, BIDI_L   },  // TELUGU LETTER NNA
  { 0x0C24, BIDI_L   },  // TELUGU LETTER TA
  { 0x0C25, BIDI_L   },  // TELUGU LETTER THA
  { 0x0C26, BIDI_L   },  // TELUGU LETTER DA
  { 0x0C27, BIDI_L   },  // TELUGU LETTER DHA
  { 0x0C28, BIDI_L   },  // TELUGU LETTER NA
  { 0x0C2A, BIDI_L   },  // TELUGU LETTER PA
  { 0x0C2B, BIDI_L   },  // TELUGU LETTER PHA
  { 0x0C2C, BIDI_L   },  // TELUGU LETTER BA
  { 0x0C2D, BIDI_L   },  // TELUGU LETTER BHA
  { 0x0C2E, BIDI_L   },  // TELUGU LETTER MA
  { 0x0C2F, BIDI_L   },  // TELUGU LETTER YA
  { 0x0C30, BIDI_L   },  // TELUGU LETTER RA
  { 0x0C31, BIDI_L   },  // TELUGU LETTER RRA
  { 0x0C32, BIDI_L   },  // TELUGU LETTER LA
  { 0x0C33, BIDI_L   },  // TELUGU LETTER LLA
  { 0x0C34, BIDI_L   },  // TELUGU LETTER LLLA
  { 0x0C35, BIDI_L   },  // TELUGU LETTER VA
  { 0x0C36, BIDI_L   },  // TELUGU LETTER SHA
  { 0x0C37, BIDI_L   },  // TELUGU LETTER SSA
  { 0x0C38, BIDI_L   },  // TELUGU LETTER SA
  { 0x0C39, BIDI_L   },  // TELUGU LETTER HA
  { 0x0C3D, BIDI_L   },  // TELUGU SIGN AVAGRAHA
  { 0x0C3E, BIDI_NSM },  // TELUGU VOWEL SIGN AA
  { 0x0C3F, BIDI_NSM },  // TELUGU VOWEL SIGN I
  { 0x0C40, BIDI_NSM },  // TELUGU VOWEL SIGN II
  { 0x0C41, BIDI_L   },  // TELUGU VOWEL SIGN U
  { 0x0C42, BIDI_L   },  // TELUGU VOWEL SIGN UU
  { 0x0C43, BIDI_L   },  // TELUGU VOWEL SIGN VOCALIC R
  { 0x0C44, BIDI_L   },  // TELUGU VOWEL SIGN VOCALIC RR
  { 0x0C46, BIDI_NSM },  // TELUGU VOWEL SIGN E
  { 0x0C47, BIDI_NSM },  // TELUGU VOWEL SIGN EE
  { 0x0C48, BIDI_NSM },  // TELUGU VOWEL SIGN AI
  { 0x0C4A, BIDI_NSM },  // TELUGU VOWEL SIGN O
  { 0x0C4B, BIDI_NSM },  // TELUGU VOWEL SIGN OO
  { 0x0C4C, BIDI_NSM },  // TELUGU VOWEL SIGN AU
  { 0x0C4D, BIDI_NSM },  // TELUGU SIGN VIRAMA
  { 0x0C55, BIDI_NSM },  // TELUGU LENGTH MARK
  { 0x0C56, BIDI_NSM },  // TELUGU AI LENGTH MARK
  { 0x0C58, BIDI_L   },  // TELUGU LETTER TSA
  { 0x0C59, BIDI_L   },  // TELUGU LETTER DZA
  { 0x0C5A, BIDI_L   },  // TELUGU LETTER RRRA
  { 0x0C60, BIDI_L   },  // TELUGU LETTER VOCALIC RR
  { 0x0C61, BIDI_L   },  // TELUGU LETTER VOCALIC LL
  { 0x0C62, BIDI_NSM },  // TELUGU VOWEL SIGN VOCALIC L
  { 0x0C63, BIDI_NSM },  // TELUGU VOWEL SIGN VOCALIC LL
  { 0x0C66, BIDI_L   },  // TELUGU DIGIT ZERO
  { 0x0C67, BIDI_L   },  // TELUGU DIGIT ONE
  { 0x0C68, BIDI_L   },  // TELUGU DIGIT TWO
  { 0x0C69, BIDI_L   },  // TELUGU DIGIT THREE
  { 0x0C6A, BIDI_L   },  // TELUGU DIGIT FOUR
  { 0x0C6B, BIDI_L   },  // TELUGU DIGIT FIVE
  { 0x0C6C, BIDI_L   },  // TELUGU DIGIT SIX
  { 0x0C6D, BIDI_L   },  // TELUGU DIGIT SEVEN
  { 0x0C6E, BIDI_L   },  // TELUGU DIGIT EIGHT
  { 0x0C6F, BIDI_L   },  // TELUGU DIGIT NINE
  { 0x0C78, BIDI_ON  },  // TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR
  { 0x0C79, BIDI_ON  },  // TELUGU FRACTION DIGIT ONE FOR ODD POWERS OF FOUR
  { 0x0C7A, BIDI_ON  },  // TELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOUR
  { 0x0C7B, BIDI_ON  },  // TELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOUR
  { 0x0C7C, BIDI_ON  },  // TELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF FOUR
  { 0x0C7D, BIDI_ON  },  // TELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOUR
  { 0x0C7E, BIDI_ON  },  // TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR
  { 0x0C7F, BIDI_L   },  // TELUGU SIGN TUUMU
  { 0x0C81, BIDI_NSM },  // KANNADA SIGN CANDRABINDU
  { 0x0C82, BIDI_L   },  // KANNADA SIGN ANUSVARA
  { 0x0C83, BIDI_L   },  // KANNADA SIGN VISARGA
  { 0x0C85, BIDI_L   },  // KANNADA LETTER A
  { 0x0C86, BIDI_L   },  // KANNADA LETTER AA
  { 0x0C87, BIDI_L   },  // KANNADA LETTER I
  { 0x0C88, BIDI_L   },  // KANNADA LETTER II
  { 0x0C89, BIDI_L   },  // KANNADA LETTER U
  { 0x0C8A, BIDI_L   },  // KANNADA LETTER UU
  { 0x0C8B, BIDI_L   },  // KANNADA LETTER VOCALIC R
  { 0x0C8C, BIDI_L   },  // KANNADA LETTER VOCALIC L
  { 0x0C8E, BIDI_L   },  // KANNADA LETTER E
  { 0x0C8F, BIDI_L   },  // KANNADA LETTER EE
  { 0x0C90, BIDI_L   },  // KANNADA LETTER AI
  { 0x0C92, BIDI_L   },  // KANNADA LETTER O
  { 0x0C93, BIDI_L   },  // KANNADA LETTER OO
  { 0x0C94, BIDI_L   },  // KANNADA LETTER AU
  { 0x0C95, BIDI_L   },  // KANNADA LETTER KA
  { 0x0C96, BIDI_L   },  // KANNADA LETTER KHA
  { 0x0C97, BIDI_L   },  // KANNADA LETTER GA
  { 0x0C98, BIDI_L   },  // KANNADA LETTER GHA
  { 0x0C99, BIDI_L   },  // KANNADA LETTER NGA
  { 0x0C9A, BIDI_L   },  // KANNADA LETTER CA
  { 0x0C9B, BIDI_L   },  // KANNADA LETTER CHA
  { 0x0C9C, BIDI_L   },  // KANNADA LETTER JA
  { 0x0C9D, BIDI_L   },  // KANNADA LETTER JHA
  { 0x0C9E, BIDI_L   },  // KANNADA LETTER NYA
  { 0x0C9F, BIDI_L   },  // KANNADA LETTER TTA
  { 0x0CA0, BIDI_L   },  // KANNADA LETTER TTHA
  { 0x0CA1, BIDI_L   },  // KANNADA LETTER DDA
  { 0x0CA2, BIDI_L   },  // KANNADA LETTER DDHA
  { 0x0CA3, BIDI_L   },  // KANNADA LETTER NNA
  { 0x0CA4, BIDI_L   },  // KANNADA LETTER TA
  { 0x0CA5, BIDI_L   },  // KANNADA LETTER THA
  { 0x0CA6, BIDI_L   },  // KANNADA LETTER DA
  { 0x0CA7, BIDI_L   },  // KANNADA LETTER DHA
  { 0x0CA8, BIDI_L   },  // KANNADA LETTER NA
  { 0x0CAA, BIDI_L   },  // KANNADA LETTER PA
  { 0x0CAB, BIDI_L   },  // KANNADA LETTER PHA
  { 0x0CAC, BIDI_L   },  // KANNADA LETTER BA
  { 0x0CAD, BIDI_L   },  // KANNADA LETTER BHA
  { 0x0CAE, BIDI_L   },  // KANNADA LETTER MA
  { 0x0CAF, BIDI_L   },  // KANNADA LETTER YA
  { 0x0CB0, BIDI_L   },  // KANNADA LETTER RA
  { 0x0CB1, BIDI_L   },  // KANNADA LETTER RRA
  { 0x0CB2, BIDI_L   },  // KANNADA LETTER LA
  { 0x0CB3, BIDI_L   },  // KANNADA LETTER LLA
  { 0x0CB5, BIDI_L   },  // KANNADA LETTER VA
  { 0x0CB6, BIDI_L   },  // KANNADA LETTER SHA
  { 0x0CB7, BIDI_L   },  // KANNADA LETTER SSA
  { 0x0CB8, BIDI_L   },  // KANNADA LETTER SA
  { 0x0CB9, BIDI_L   },  // KANNADA LETTER HA
  { 0x0CBC, BIDI_NSM },  // KANNADA SIGN NUKTA
  { 0x0CBD, BIDI_L   },  // KANNADA SIGN AVAGRAHA
  { 0x0CBE, BIDI_L   },  // KANNADA VOWEL SIGN AA
  { 0x0CBF, BIDI_L   },  // KANNADA VOWEL SIGN I
  { 0x0CC0, BIDI_L   },  // KANNADA VOWEL SIGN II
  { 0x0CC1, BIDI_L   },  // KANNADA VOWEL SIGN U
  { 0x0CC2, BIDI_L   },  // KANNADA VOWEL SIGN UU
  { 0x0CC3, BIDI_L   },  // KANNADA VOWEL SIGN VOCALIC R
  { 0x0CC4, BIDI_L   },  // KANNADA VOWEL SIGN VOCALIC RR
  { 0x0CC6, BIDI_L   },  // KANNADA VOWEL SIGN E
  { 0x0CC7, BIDI_L   },  // KANNADA VOWEL SIGN EE
  { 0x0CC8, BIDI_L   },  // KANNADA VOWEL SIGN AI
  { 0x0CCA, BIDI_L   },  // KANNADA VOWEL SIGN O
  { 0x0CCB, BIDI_L   },  // KANNADA VOWEL SIGN OO
  { 0x0CCC, BIDI_NSM },  // KANNADA VOWEL SIGN AU
  { 0x0CCD, BIDI_NSM },  // KANNADA SIGN VIRAMA
  { 0x0CD5, BIDI_L   },  // KANNADA LENGTH MARK
  { 0x0CD6, BIDI_L   },  // KANNADA AI LENGTH MARK
  { 0x0CDE, BIDI_L   },  // KANNADA LETTER FA
  { 0x0CE0, BIDI_L   },  // KANNADA LETTER VOCALIC RR
  { 0x0CE1, BIDI_L   },  // KANNADA LETTER VOCALIC LL
  { 0x0CE2, BIDI_NSM },  // KANNADA VOWEL SIGN VOCALIC L
  { 0x0CE3, BIDI_NSM },  // KANNADA VOWEL SIGN VOCALIC LL
  { 0x0CE6, BIDI_L   },  // KANNADA DIGIT ZERO
  { 0x0CE7, BIDI_L   },  // KANNADA DIGIT ONE
  { 0x0CE8, BIDI_L   },  // KANNADA DIGIT TWO
  { 0x0CE9, BIDI_L   },  // KANNADA DIGIT THREE
  { 0x0CEA, BIDI_L   },  // KANNADA DIGIT FOUR
  { 0x0CEB, BIDI_L   },  // KANNADA DIGIT FIVE
  { 0x0CEC, BIDI_L   },  // KANNADA DIGIT SIX
  { 0x0CED, BIDI_L   },  // KANNADA DIGIT SEVEN
  { 0x0CEE, BIDI_L   },  // KANNADA DIGIT EIGHT
  { 0x0CEF, BIDI_L   },  // KANNADA DIGIT NINE
  { 0x0CF1, BIDI_L   },  // KANNADA SIGN JIHVAMULIYA
  { 0x0CF2, BIDI_L   },  // KANNADA SIGN UPADHMANIYA
  { 0x0D01, BIDI_NSM },  // MALAYALAM SIGN CANDRABINDU
  { 0x0D02, BIDI_L   },  // MALAYALAM SIGN ANUSVARA
  { 0x0D03, BIDI_L   },  // MALAYALAM SIGN VISARGA
  { 0x0D05, BIDI_L   },  // MALAYALAM LETTER A
  { 0x0D06, BIDI_L   },  // MALAYALAM LETTER AA
  { 0x0D07, BIDI_L   },  // MALAYALAM LETTER I
  { 0x0D08, BIDI_L   },  // MALAYALAM LETTER II
  { 0x0D09, BIDI_L   },  // MALAYALAM LETTER U
  { 0x0D0A, BIDI_L   },  // MALAYALAM LETTER UU
  { 0x0D0B, BIDI_L   },  // MALAYALAM LETTER VOCALIC R
  { 0x0D0C, BIDI_L   },  // MALAYALAM LETTER VOCALIC L
  { 0x0D0E, BIDI_L   },  // MALAYALAM LETTER E
  { 0x0D0F, BIDI_L   },  // MALAYALAM LETTER EE
  { 0x0D10, BIDI_L   },  // MALAYALAM LETTER AI
  { 0x0D12, BIDI_L   },  // MALAYALAM LETTER O
  { 0x0D13, BIDI_L   },  // MALAYALAM LETTER OO
  { 0x0D14, BIDI_L   },  // MALAYALAM LETTER AU
  { 0x0D15, BIDI_L   },  // MALAYALAM LETTER KA
  { 0x0D16, BIDI_L   },  // MALAYALAM LETTER KHA
  { 0x0D17, BIDI_L   },  // MALAYALAM LETTER GA
  { 0x0D18, BIDI_L   },  // MALAYALAM LETTER GHA
  { 0x0D19, BIDI_L   },  // MALAYALAM LETTER NGA
  { 0x0D1A, BIDI_L   },  // MALAYALAM LETTER CA
  { 0x0D1B, BIDI_L   },  // MALAYALAM LETTER CHA
  { 0x0D1C, BIDI_L   },  // MALAYALAM LETTER JA
  { 0x0D1D, BIDI_L   },  // MALAYALAM LETTER JHA
  { 0x0D1E, BIDI_L   },  // MALAYALAM LETTER NYA
  { 0x0D1F, BIDI_L   },  // MALAYALAM LETTER TTA
  { 0x0D20, BIDI_L   },  // MALAYALAM LETTER TTHA
  { 0x0D21, BIDI_L   },  // MALAYALAM LETTER DDA
  { 0x0D22, BIDI_L   },  // MALAYALAM LETTER DDHA
  { 0x0D23, BIDI_L   },  // MALAYALAM LETTER NNA
  { 0x0D24, BIDI_L   },  // MALAYALAM LETTER TA
  { 0x0D25, BIDI_L   },  // MALAYALAM LETTER THA
  { 0x0D26, BIDI_L   },  // MALAYALAM LETTER DA
  { 0x0D27, BIDI_L   },  // MALAYALAM LETTER DHA
  { 0x0D28, BIDI_L   },  // MALAYALAM LETTER NA
  { 0x0D29, BIDI_L   },  // MALAYALAM LETTER NNNA
  { 0x0D2A, BIDI_L   },  // MALAYALAM LETTER PA
  { 0x0D2B, BIDI_L   },  // MALAYALAM LETTER PHA
  { 0x0D2C, BIDI_L   },  // MALAYALAM LETTER BA
  { 0x0D2D, BIDI_L   },  // MALAYALAM LETTER BHA
  { 0x0D2E, BIDI_L   },  // MALAYALAM LETTER MA
  { 0x0D2F, BIDI_L   },  // MALAYALAM LETTER YA
  { 0x0D30, BIDI_L   },  // MALAYALAM LETTER RA
  { 0x0D31, BIDI_L   },  // MALAYALAM LETTER RRA
  { 0x0D32, BIDI_L   },  // MALAYALAM LETTER LA
  { 0x0D33, BIDI_L   },  // MALAYALAM LETTER LLA
  { 0x0D34, BIDI_L   },  // MALAYALAM LETTER LLLA
  { 0x0D35, BIDI_L   },  // MALAYALAM LETTER VA
  { 0x0D36, BIDI_L   },  // MALAYALAM LETTER SHA
  { 0x0D37, BIDI_L   },  // MALAYALAM LETTER SSA
  { 0x0D38, BIDI_L   },  // MALAYALAM LETTER SA
  { 0x0D39, BIDI_L   },  // MALAYALAM LETTER HA
  { 0x0D3A, BIDI_L   },  // MALAYALAM LETTER TTTA
  { 0x0D3D, BIDI_L   },  // MALAYALAM SIGN AVAGRAHA
  { 0x0D3E, BIDI_L   },  // MALAYALAM VOWEL SIGN AA
  { 0x0D3F, BIDI_L   },  // MALAYALAM VOWEL SIGN I
  { 0x0D40, BIDI_L   },  // MALAYALAM VOWEL SIGN II
  { 0x0D41, BIDI_NSM },  // MALAYALAM VOWEL SIGN U
  { 0x0D42, BIDI_NSM },  // MALAYALAM VOWEL SIGN UU
  { 0x0D43, BIDI_NSM },  // MALAYALAM VOWEL SIGN VOCALIC R
  { 0x0D44, BIDI_NSM },  // MALAYALAM VOWEL SIGN VOCALIC RR
  { 0x0D46, BIDI_L   },  // MALAYALAM VOWEL SIGN E
  { 0x0D47, BIDI_L   },  // MALAYALAM VOWEL SIGN EE
  { 0x0D48, BIDI_L   },  // MALAYALAM VOWEL SIGN AI
  { 0x0D4A, BIDI_L   },  // MALAYALAM VOWEL SIGN O
  { 0x0D4B, BIDI_L   },  // MALAYALAM VOWEL SIGN OO
  { 0x0D4C, BIDI_L   },  // MALAYALAM VOWEL SIGN AU
  { 0x0D4D, BIDI_NSM },  // MALAYALAM SIGN VIRAMA
  { 0x0D4E, BIDI_L   },  // MALAYALAM LETTER DOT REPH
  { 0x0D57, BIDI_L   },  // MALAYALAM AU LENGTH MARK
  { 0x0D5F, BIDI_L   },  // MALAYALAM LETTER ARCHAIC II
  { 0x0D60, BIDI_L   },  // MALAYALAM LETTER VOCALIC RR
  { 0x0D61, BIDI_L   },  // MALAYALAM LETTER VOCALIC LL
  { 0x0D62, BIDI_NSM },  // MALAYALAM VOWEL SIGN VOCALIC L
  { 0x0D63, BIDI_NSM },  // MALAYALAM VOWEL SIGN VOCALIC LL
  { 0x0D66, BIDI_L   },  // MALAYALAM DIGIT ZERO
  { 0x0D67, BIDI_L   },  // MALAYALAM DIGIT ONE
  { 0x0D68, BIDI_L   },  // MALAYALAM DIGIT TWO
  { 0x0D69, BIDI_L   },  // MALAYALAM DIGIT THREE
  { 0x0D6A, BIDI_L   },  // MALAYALAM DIGIT FOUR
  { 0x0D6B, BIDI_L   },  // MALAYALAM DIGIT FIVE
  { 0x0D6C, BIDI_L   },  // MALAYALAM DIGIT SIX
  { 0x0D6D, BIDI_L   },  // MALAYALAM DIGIT SEVEN
  { 0x0D6E, BIDI_L   },  // MALAYALAM DIGIT EIGHT
  { 0x0D6F, BIDI_L   },  // MALAYALAM DIGIT NINE
  { 0x0D70, BIDI_L   },  // MALAYALAM NUMBER TEN
  { 0x0D71, BIDI_L   },  // MALAYALAM NUMBER ONE HUNDRED
  { 0x0D72, BIDI_L   },  // MALAYALAM NUMBER ONE THOUSAND
  { 0x0D73, BIDI_L   },  // MALAYALAM FRACTION ONE QUARTER
  { 0x0D74, BIDI_L   },  // MALAYALAM FRACTION ONE HALF
  { 0x0D75, BIDI_L   },  // MALAYALAM FRACTION THREE QUARTERS
  { 0x0D79, BIDI_L   },  // MALAYALAM DATE MARK
  { 0x0D7A, BIDI_L   },  // MALAYALAM LETTER CHILLU NN
  { 0x0D7B, BIDI_L   },  // MALAYALAM LETTER CHILLU N
  { 0x0D7C, BIDI_L   },  // MALAYALAM LETTER CHILLU RR
  { 0x0D7D, BIDI_L   },  // MALAYALAM LETTER CHILLU L
  { 0x0D7E, BIDI_L   },  // MALAYALAM LETTER CHILLU LL
  { 0x0D7F, BIDI_L   },  // MALAYALAM LETTER CHILLU K
  { 0x0D82, BIDI_L   },  // SINHALA SIGN ANUSVARAYA
  { 0x0D83, BIDI_L   },  // SINHALA SIGN VISARGAYA
  { 0x0D85, BIDI_L   },  // SINHALA LETTER AYANNA
  { 0x0D86, BIDI_L   },  // SINHALA LETTER AAYANNA
  { 0x0D87, BIDI_L   },  // SINHALA LETTER AEYANNA
  { 0x0D88, BIDI_L   },  // SINHALA LETTER AEEYANNA
  { 0x0D89, BIDI_L   },  // SINHALA LETTER IYANNA
  { 0x0D8A, BIDI_L   },  // SINHALA LETTER IIYANNA
  { 0x0D8B, BIDI_L   },  // SINHALA LETTER UYANNA
  { 0x0D8C, BIDI_L   },  // SINHALA LETTER UUYANNA
  { 0x0D8D, BIDI_L   },  // SINHALA LETTER IRUYANNA
  { 0x0D8E, BIDI_L   },  // SINHALA LETTER IRUUYANNA
  { 0x0D8F, BIDI_L   },  // SINHALA LETTER ILUYANNA
  { 0x0D90, BIDI_L   },  // SINHALA LETTER ILUUYANNA
  { 0x0D91, BIDI_L   },  // SINHALA LETTER EYANNA
  { 0x0D92, BIDI_L   },  // SINHALA LETTER EEYANNA
  { 0x0D93, BIDI_L   },  // SINHALA LETTER AIYANNA
  { 0x0D94, BIDI_L   },  // SINHALA LETTER OYANNA
  { 0x0D95, BIDI_L   },  // SINHALA LETTER OOYANNA
  { 0x0D96, BIDI_L   },  // SINHALA LETTER AUYANNA
  { 0x0D9A, BIDI_L   },  // SINHALA LETTER ALPAPRAANA KAYANNA
  { 0x0D9B, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA KAYANNA
  { 0x0D9C, BIDI_L   },  // SINHALA LETTER ALPAPRAANA GAYANNA
  { 0x0D9D, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA GAYANNA
  { 0x0D9E, BIDI_L   },  // SINHALA LETTER KANTAJA NAASIKYAYA
  { 0x0D9F, BIDI_L   },  // SINHALA LETTER SANYAKA GAYANNA
  { 0x0DA0, BIDI_L   },  // SINHALA LETTER ALPAPRAANA CAYANNA
  { 0x0DA1, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA CAYANNA
  { 0x0DA2, BIDI_L   },  // SINHALA LETTER ALPAPRAANA JAYANNA
  { 0x0DA3, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA JAYANNA
  { 0x0DA4, BIDI_L   },  // SINHALA LETTER TAALUJA NAASIKYAYA
  { 0x0DA5, BIDI_L   },  // SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA
  { 0x0DA6, BIDI_L   },  // SINHALA LETTER SANYAKA JAYANNA
  { 0x0DA7, BIDI_L   },  // SINHALA LETTER ALPAPRAANA TTAYANNA
  { 0x0DA8, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA TTAYANNA
  { 0x0DA9, BIDI_L   },  // SINHALA LETTER ALPAPRAANA DDAYANNA
  { 0x0DAA, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA DDAYANNA
  { 0x0DAB, BIDI_L   },  // SINHALA LETTER MUURDHAJA NAYANNA
  { 0x0DAC, BIDI_L   },  // SINHALA LETTER SANYAKA DDAYANNA
  { 0x0DAD, BIDI_L   },  // SINHALA LETTER ALPAPRAANA TAYANNA
  { 0x0DAE, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA TAYANNA
  { 0x0DAF, BIDI_L   },  // SINHALA LETTER ALPAPRAANA DAYANNA
  { 0x0DB0, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA DAYANNA
  { 0x0DB1, BIDI_L   },  // SINHALA LETTER DANTAJA NAYANNA
  { 0x0DB3, BIDI_L   },  // SINHALA LETTER SANYAKA DAYANNA
  { 0x0DB4, BIDI_L   },  // SINHALA LETTER ALPAPRAANA PAYANNA
  { 0x0DB5, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA PAYANNA
  { 0x0DB6, BIDI_L   },  // SINHALA LETTER ALPAPRAANA BAYANNA
  { 0x0DB7, BIDI_L   },  // SINHALA LETTER MAHAAPRAANA BAYANNA
  { 0x0DB8, BIDI_L   },  // SINHALA LETTER MAYANNA
  { 0x0DB9, BIDI_L   },  // SINHALA LETTER AMBA BAYANNA
  { 0x0DBA, BIDI_L   },  // SINHALA LETTER YAYANNA
  { 0x0DBB, BIDI_L   },  // SINHALA LETTER RAYANNA
  { 0x0DBD, BIDI_L   },  // SINHALA LETTER DANTAJA LAYANNA
  { 0x0DC0, BIDI_L   },  // SINHALA LETTER VAYANNA
  { 0x0DC1, BIDI_L   },  // SINHALA LETTER TAALUJA SAYANNA
  { 0x0DC2, BIDI_L   },  // SINHALA LETTER MUURDHAJA SAYANNA
  { 0x0DC3, BIDI_L   },  // SINHALA LETTER DANTAJA SAYANNA
  { 0x0DC4, BIDI_L   },  // SINHALA LETTER HAYANNA
  { 0x0DC5, BIDI_L   },  // SINHALA LETTER MUURDHAJA LAYANNA
  { 0x0DC6, BIDI_L   },  // SINHALA LETTER FAYANNA
  { 0x0DCA, BIDI_NSM },  // SINHALA SIGN AL-LAKUNA
  { 0x0DCF, BIDI_L   },  // SINHALA VOWEL SIGN AELA-PILLA
  { 0x0DD0, BIDI_L   },  // SINHALA VOWEL SIGN KETTI AEDA-PILLA
  { 0x0DD1, BIDI_L   },  // SINHALA VOWEL SIGN DIGA AEDA-PILLA
  { 0x0DD2, BIDI_NSM },  // SINHALA VOWEL SIGN KETTI IS-PILLA
  { 0x0DD3, BIDI_NSM },  // SINHALA VOWEL SIGN DIGA IS-PILLA
  { 0x0DD4, BIDI_NSM },  // SINHALA VOWEL SIGN KETTI PAA-PILLA
  { 0x0DD6, BIDI_NSM },  // SINHALA VOWEL SIGN DIGA PAA-PILLA
  { 0x0DD8, BIDI_L   },  // SINHALA VOWEL SIGN GAETTA-PILLA
  { 0x0DD9, BIDI_L   },  // SINHALA VOWEL SIGN KOMBUVA
  { 0x0DDA, BIDI_L   },  // SINHALA VOWEL SIGN DIGA KOMBUVA
  { 0x0DDB, BIDI_L   },  // SINHALA VOWEL SIGN KOMBU DEKA
  { 0x0DDC, BIDI_L   },  // SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA
  { 0x0DDD, BIDI_L   },  // SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA
  { 0x0DDE, BIDI_L   },  // SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA
  { 0x0DDF, BIDI_L   },  // SINHALA VOWEL SIGN GAYANUKITTA
  { 0x0DE6, BIDI_L   },  // SINHALA LITH DIGIT ZERO
  { 0x0DE7, BIDI_L   },  // SINHALA LITH DIGIT ONE
  { 0x0DE8, BIDI_L   },  // SINHALA LITH DIGIT TWO
  { 0x0DE9, BIDI_L   },  // SINHALA LITH DIGIT THREE
  { 0x0DEA, BIDI_L   },  // SINHALA LITH DIGIT FOUR
  { 0x0DEB, BIDI_L   },  // SINHALA LITH DIGIT FIVE
  { 0x0DEC, BIDI_L   },  // SINHALA LITH DIGIT SIX
  { 0x0DED, BIDI_L   },  // SINHALA LITH DIGIT SEVEN
  { 0x0DEE, BIDI_L   },  // SINHALA LITH DIGIT EIGHT
  { 0x0DEF, BIDI_L   },  // SINHALA LITH DIGIT NINE
  { 0x0DF2, BIDI_L   },  // SINHALA VOWEL SIGN DIGA GAETTA-PILLA
  { 0x0DF3, BIDI_L   },  // SINHALA VOWEL SIGN DIGA GAYANUKITTA
  { 0x0DF4, BIDI_L   },  // SINHALA PUNCTUATION KUNDDALIYA
  { 0x0E01, BIDI_L   },  // THAI CHARACTER KO KAI
  { 0x0E02, BIDI_L   },  // THAI CHARACTER KHO KHAI
  { 0x0E03, BIDI_L   },  // THAI CHARACTER KHO KHUAT
  { 0x0E04, BIDI_L   },  // THAI CHARACTER KHO KHWAI
  { 0x0E05, BIDI_L   },  // THAI CHARACTER KHO KHON
  { 0x0E06, BIDI_L   },  // THAI CHARACTER KHO RAKHANG
  { 0x0E07, BIDI_L   },  // THAI CHARACTER NGO NGU
  { 0x0E08, BIDI_L   },  // THAI CHARACTER CHO CHAN
  { 0x0E09, BIDI_L   },  // THAI CHARACTER CHO CHING
  { 0x0E0A, BIDI_L   },  // THAI CHARACTER CHO CHANG
  { 0x0E0B, BIDI_L   },  // THAI CHARACTER SO SO
  { 0x0E0C, BIDI_L   },  // THAI CHARACTER CHO CHOE
  { 0x0E0D, BIDI_L   },  // THAI CHARACTER YO YING
  { 0x0E0E, BIDI_L   },  // THAI CHARACTER DO CHADA
  { 0x0E0F, BIDI_L   },  // THAI CHARACTER TO PATAK
  { 0x0E10, BIDI_L   },  // THAI CHARACTER THO THAN
  { 0x0E11, BIDI_L   },  // THAI CHARACTER THO NANGMONTHO
  { 0x0E12, BIDI_L   },  // THAI CHARACTER THO PHUTHAO
  { 0x0E13, BIDI_L   },  // THAI CHARACTER NO NEN
  { 0x0E14, BIDI_L   },  // THAI CHARACTER DO DEK
  { 0x0E15, BIDI_L   },  // THAI CHARACTER TO TAO
  { 0x0E16, BIDI_L   },  // THAI CHARACTER THO THUNG
  { 0x0E17, BIDI_L   },  // THAI CHARACTER THO THAHAN
  { 0x0E18, BIDI_L   },  // THAI CHARACTER THO THONG
  { 0x0E19, BIDI_L   },  // THAI CHARACTER NO NU
  { 0x0E1A, BIDI_L   },  // THAI CHARACTER BO BAIMAI
  { 0x0E1B, BIDI_L   },  // THAI CHARACTER PO PLA
  { 0x0E1C, BIDI_L   },  // THAI CHARACTER PHO PHUNG
  { 0x0E1D, BIDI_L   },  // THAI CHARACTER FO FA
  { 0x0E1E, BIDI_L   },  // THAI CHARACTER PHO PHAN
  { 0x0E1F, BIDI_L   },  // THAI CHARACTER FO FAN
  { 0x0E20, BIDI_L   },  // THAI CHARACTER PHO SAMPHAO
  { 0x0E21, BIDI_L   },  // THAI CHARACTER MO MA
  { 0x0E22, BIDI_L   },  // THAI CHARACTER YO YAK
  { 0x0E23, BIDI_L   },  // THAI CHARACTER RO RUA
  { 0x0E24, BIDI_L   },  // THAI CHARACTER RU
  { 0x0E25, BIDI_L   },  // THAI CHARACTER LO LING
  { 0x0E26, BIDI_L   },  // THAI CHARACTER LU
  { 0x0E27, BIDI_L   },  // THAI CHARACTER WO WAEN
  { 0x0E28, BIDI_L   },  // THAI CHARACTER SO SALA
  { 0x0E29, BIDI_L   },  // THAI CHARACTER SO RUSI
  { 0x0E2A, BIDI_L   },  // THAI CHARACTER SO SUA
  { 0x0E2B, BIDI_L   },  // THAI CHARACTER HO HIP
  { 0x0E2C, BIDI_L   },  // THAI CHARACTER LO CHULA
  { 0x0E2D, BIDI_L   },  // THAI CHARACTER O ANG
  { 0x0E2E, BIDI_L   },  // THAI CHARACTER HO NOKHUK
  { 0x0E2F, BIDI_L   },  // THAI CHARACTER PAIYANNOI
  { 0x0E30, BIDI_L   },  // THAI CHARACTER SARA A
  { 0x0E31, BIDI_NSM },  // THAI CHARACTER MAI HAN-AKAT
  { 0x0E32, BIDI_L   },  // THAI CHARACTER SARA AA
  { 0x0E33, BIDI_L   },  // THAI CHARACTER SARA AM
  { 0x0E34, BIDI_NSM },  // THAI CHARACTER SARA I
  { 0x0E35, BIDI_NSM },  // THAI CHARACTER SARA II
  { 0x0E36, BIDI_NSM },  // THAI CHARACTER SARA UE
  { 0x0E37, BIDI_NSM },  // THAI CHARACTER SARA UEE
  { 0x0E38, BIDI_NSM },  // THAI CHARACTER SARA U
  { 0x0E39, BIDI_NSM },  // THAI CHARACTER SARA UU
  { 0x0E3A, BIDI_NSM },  // THAI CHARACTER PHINTHU
  { 0x0E3F, BIDI_ET  },  // THAI CURRENCY SYMBOL BAHT
  { 0x0E40, BIDI_L   },  // THAI CHARACTER SARA E
  { 0x0E41, BIDI_L   },  // THAI CHARACTER SARA AE
  { 0x0E42, BIDI_L   },  // THAI CHARACTER SARA O
  { 0x0E43, BIDI_L   },  // THAI CHARACTER SARA AI MAIMUAN
  { 0x0E44, BIDI_L   },  // THAI CHARACTER SARA AI MAIMALAI
  { 0x0E45, BIDI_L   },  // THAI CHARACTER LAKKHANGYAO
  { 0x0E46, BIDI_L   },  // THAI CHARACTER MAIYAMOK
  { 0x0E47, BIDI_NSM },  // THAI CHARACTER MAITAIKHU
  { 0x0E48, BIDI_NSM },  // THAI CHARACTER MAI EK
  { 0x0E49, BIDI_NSM },  // THAI CHARACTER MAI THO
  { 0x0E4A, BIDI_NSM },  // THAI CHARACTER MAI TRI
  { 0x0E4B, BIDI_NSM },  // THAI CHARACTER MAI CHATTAWA
  { 0x0E4C, BIDI_NSM },  // THAI CHARACTER THANTHAKHAT
  { 0x0E4D, BIDI_NSM },  // THAI CHARACTER NIKHAHIT
  { 0x0E4E, BIDI_NSM },  // THAI CHARACTER YAMAKKAN
  { 0x0E4F, BIDI_L   },  // THAI CHARACTER FONGMAN
  { 0x0E50, BIDI_L   },  // THAI DIGIT ZERO
  { 0x0E51, BIDI_L   },  // THAI DIGIT ONE
  { 0x0E52, BIDI_L   },  // THAI DIGIT TWO
  { 0x0E53, BIDI_L   },  // THAI DIGIT THREE
  { 0x0E54, BIDI_L   },  // THAI DIGIT FOUR
  { 0x0E55, BIDI_L   },  // THAI DIGIT FIVE
  { 0x0E56, BIDI_L   },  // THAI DIGIT SIX
  { 0x0E57, BIDI_L   },  // THAI DIGIT SEVEN
  { 0x0E58, BIDI_L   },  // THAI DIGIT EIGHT
  { 0x0E59, BIDI_L   },  // THAI DIGIT NINE
  { 0x0E5A, BIDI_L   },  // THAI CHARACTER ANGKHANKHU
  { 0x0E5B, BIDI_L   },  // THAI CHARACTER KHOMUT
  { 0x0E81, BIDI_L   },  // LAO LETTER KO
  { 0x0E82, BIDI_L   },  // LAO LETTER KHO SUNG
  { 0x0E84, BIDI_L   },  // LAO LETTER KHO TAM
  { 0x0E87, BIDI_L   },  // LAO LETTER NGO
  { 0x0E88, BIDI_L   },  // LAO LETTER CO
  { 0x0E8A, BIDI_L   },  // LAO LETTER SO TAM
  { 0x0E8D, BIDI_L   },  // LAO LETTER NYO
  { 0x0E94, BIDI_L   },  // LAO LETTER DO
  { 0x0E95, BIDI_L   },  // LAO LETTER TO
  { 0x0E96, BIDI_L   },  // LAO LETTER THO SUNG
  { 0x0E97, BIDI_L   },  // LAO LETTER THO TAM
  { 0x0E99, BIDI_L   },  // LAO LETTER NO
  { 0x0E9A, BIDI_L   },  // LAO LETTER BO
  { 0x0E9B, BIDI_L   },  // LAO LETTER PO
  { 0x0E9C, BIDI_L   },  // LAO LETTER PHO SUNG
  { 0x0E9D, BIDI_L   },  // LAO LETTER FO TAM
  { 0x0E9E, BIDI_L   },  // LAO LETTER PHO TAM
  { 0x0E9F, BIDI_L   },  // LAO LETTER FO SUNG
  { 0x0EA1, BIDI_L   },  // LAO LETTER MO
  { 0x0EA2, BIDI_L   },  // LAO LETTER YO
  { 0x0EA3, BIDI_L   },  // LAO LETTER LO LING
  { 0x0EA5, BIDI_L   },  // LAO LETTER LO LOOT
  { 0x0EA7, BIDI_L   },  // LAO LETTER WO
  { 0x0EAA, BIDI_L   },  // LAO LETTER SO SUNG
  { 0x0EAB, BIDI_L   },  // LAO LETTER HO SUNG
  { 0x0EAD, BIDI_L   },  // LAO LETTER O
  { 0x0EAE, BIDI_L   },  // LAO LETTER HO TAM
  { 0x0EAF, BIDI_L   },  // LAO ELLIPSIS
  { 0x0EB0, BIDI_L   },  // LAO VOWEL SIGN A
  { 0x0EB1, BIDI_NSM },  // LAO VOWEL SIGN MAI KAN
  { 0x0EB2, BIDI_L   },  // LAO VOWEL SIGN AA
  { 0x0EB3, BIDI_L   },  // LAO VOWEL SIGN AM
  { 0x0EB4, BIDI_NSM },  // LAO VOWEL SIGN I
  { 0x0EB5, BIDI_NSM },  // LAO VOWEL SIGN II
  { 0x0EB6, BIDI_NSM },  // LAO VOWEL SIGN Y
  { 0x0EB7, BIDI_NSM },  // LAO VOWEL SIGN YY
  { 0x0EB8, BIDI_NSM },  // LAO VOWEL SIGN U
  { 0x0EB9, BIDI_NSM },  // LAO VOWEL SIGN UU
  { 0x0EBB, BIDI_NSM },  // LAO VOWEL SIGN MAI KON
  { 0x0EBC, BIDI_NSM },  // LAO SEMIVOWEL SIGN LO
  { 0x0EBD, BIDI_L   },  // LAO SEMIVOWEL SIGN NYO
  { 0x0EC0, BIDI_L   },  // LAO VOWEL SIGN E
  { 0x0EC1, BIDI_L   },  // LAO VOWEL SIGN EI
  { 0x0EC2, BIDI_L   },  // LAO VOWEL SIGN O
  { 0x0EC3, BIDI_L   },  // LAO VOWEL SIGN AY
  { 0x0EC4, BIDI_L   },  // LAO VOWEL SIGN AI
  { 0x0EC6, BIDI_L   },  // LAO KO LA
  { 0x0EC8, BIDI_NSM },  // LAO TONE MAI EK
  { 0x0EC9, BIDI_NSM },  // LAO TONE MAI THO
  { 0x0ECA, BIDI_NSM },  // LAO TONE MAI TI
  { 0x0ECB, BIDI_NSM },  // LAO TONE MAI CATAWA
  { 0x0ECC, BIDI_NSM },  // LAO CANCELLATION MARK
  { 0x0ECD, BIDI_NSM },  // LAO NIGGAHITA
  { 0x0ED0, BIDI_L   },  // LAO DIGIT ZERO
  { 0x0ED1, BIDI_L   },  // LAO DIGIT ONE
  { 0x0ED2, BIDI_L   },  // LAO DIGIT TWO
  { 0x0ED3, BIDI_L   },  // LAO DIGIT THREE
  { 0x0ED4, BIDI_L   },  // LAO DIGIT FOUR
  { 0x0ED5, BIDI_L   },  // LAO DIGIT FIVE
  { 0x0ED6, BIDI_L   },  // LAO DIGIT SIX
  { 0x0ED7, BIDI_L   },  // LAO DIGIT SEVEN
  { 0x0ED8, BIDI_L   },  // LAO DIGIT EIGHT
  { 0x0ED9, BIDI_L   },  // LAO DIGIT NINE
  { 0x0EDC, BIDI_L   },  // LAO HO NO
  { 0x0EDD, BIDI_L   },  // LAO HO MO
  { 0x0EDE, BIDI_L   },  // LAO LETTER KHMU GO
  { 0x0EDF, BIDI_L   },  // LAO LETTER KHMU NYO
  { 0x0F00, BIDI_L   },  // TIBETAN SYLLABLE OM
  { 0x0F01, BIDI_L   },  // TIBETAN MARK GTER YIG MGO TRUNCATED A
  { 0x0F02, BIDI_L   },  // TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA
  { 0x0F03, BIDI_L   },  // TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA
  { 0x0F04, BIDI_L   },  // TIBETAN MARK INITIAL YIG MGO MDUN MA
  { 0x0F05, BIDI_L   },  // TIBETAN MARK CLOSING YIG MGO SGAB MA
  { 0x0F06, BIDI_L   },  // TIBETAN MARK CARET YIG MGO PHUR SHAD MA
  { 0x0F07, BIDI_L   },  // TIBETAN MARK YIG MGO TSHEG SHAD MA
  { 0x0F08, BIDI_L   },  // TIBETAN MARK SBRUL SHAD
  { 0x0F09, BIDI_L   },  // TIBETAN MARK BSKUR YIG MGO
  { 0x0F0A, BIDI_L   },  // TIBETAN MARK BKA- SHOG YIG MGO
  { 0x0F0B, BIDI_L   },  // TIBETAN MARK INTERSYLLABIC TSHEG
  { 0x0F0C, BIDI_L   },  // TIBETAN MARK DELIMITER TSHEG BSTAR
  { 0x0F0D, BIDI_L   },  // TIBETAN MARK SHAD
  { 0x0F0E, BIDI_L   },  // TIBETAN MARK NYIS SHAD
  { 0x0F0F, BIDI_L   },  // TIBETAN MARK TSHEG SHAD
  { 0x0F10, BIDI_L   },  // TIBETAN MARK NYIS TSHEG SHAD
  { 0x0F11, BIDI_L   },  // TIBETAN MARK RIN CHEN SPUNGS SHAD
  { 0x0F12, BIDI_L   },  // TIBETAN MARK RGYA GRAM SHAD
  { 0x0F13, BIDI_L   },  // TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN
  { 0x0F14, BIDI_L   },  // TIBETAN MARK GTER TSHEG
  { 0x0F15, BIDI_L   },  // TIBETAN LOGOTYPE SIGN CHAD RTAGS
  { 0x0F16, BIDI_L   },  // TIBETAN LOGOTYPE SIGN LHAG RTAGS
  { 0x0F17, BIDI_L   },  // TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS
  { 0x0F18, BIDI_NSM },  // TIBETAN ASTROLOGICAL SIGN -KHYUD PA
  { 0x0F19, BIDI_NSM },  // TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
  { 0x0F1A, BIDI_L   },  // TIBETAN SIGN RDEL DKAR GCIG
  { 0x0F1B, BIDI_L   },  // TIBETAN SIGN RDEL DKAR GNYIS
  { 0x0F1C, BIDI_L   },  // TIBETAN SIGN RDEL DKAR GSUM
  { 0x0F1D, BIDI_L   },  // TIBETAN SIGN RDEL NAG GCIG
  { 0x0F1E, BIDI_L   },  // TIBETAN SIGN RDEL NAG GNYIS
  { 0x0F1F, BIDI_L   },  // TIBETAN SIGN RDEL DKAR RDEL NAG
  { 0x0F20, BIDI_L   },  // TIBETAN DIGIT ZERO
  { 0x0F21, BIDI_L   },  // TIBETAN DIGIT ONE
  { 0x0F22, BIDI_L   },  // TIBETAN DIGIT TWO
  { 0x0F23, BIDI_L   },  // TIBETAN DIGIT THREE
  { 0x0F24, BIDI_L   },  // TIBETAN DIGIT FOUR
  { 0x0F25, BIDI_L   },  // TIBETAN DIGIT FIVE
  { 0x0F26, BIDI_L   },  // TIBETAN DIGIT SIX
  { 0x0F27, BIDI_L   },  // TIBETAN DIGIT SEVEN
  { 0x0F28, BIDI_L   },  // TIBETAN DIGIT EIGHT
  { 0x0F29, BIDI_L   },  // TIBETAN DIGIT NINE
  { 0x0F2A, BIDI_L   },  // TIBETAN DIGIT HALF ONE
  { 0x0F2B, BIDI_L   },  // TIBETAN DIGIT HALF TWO
  { 0x0F2C, BIDI_L   },  // TIBETAN DIGIT HALF THREE
  { 0x0F2D, BIDI_L   },  // TIBETAN DIGIT HALF FOUR
  { 0x0F2E, BIDI_L   },  // TIBETAN DIGIT HALF FIVE
  { 0x0F2F, BIDI_L   },  // TIBETAN DIGIT HALF SIX
  { 0x0F30, BIDI_L   },  // TIBETAN DIGIT HALF SEVEN
  { 0x0F31, BIDI_L   },  // TIBETAN DIGIT HALF EIGHT
  { 0x0F32, BIDI_L   },  // TIBETAN DIGIT HALF NINE
  { 0x0F33, BIDI_L   },  // TIBETAN DIGIT HALF ZERO
  { 0x0F34, BIDI_L   },  // TIBETAN MARK BSDUS RTAGS
  { 0x0F35, BIDI_NSM },  // TIBETAN MARK NGAS BZUNG NYI ZLA
  { 0x0F36, BIDI_L   },  // TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN
  { 0x0F37, BIDI_NSM },  // TIBETAN MARK NGAS BZUNG SGOR RTAGS
  { 0x0F38, BIDI_L   },  // TIBETAN MARK CHE MGO
  { 0x0F39, BIDI_NSM },  // TIBETAN MARK TSA -PHRU
  { 0x0F3A, BIDI_ON  },  // TIBETAN MARK GUG RTAGS GYON
  { 0x0F3B, BIDI_ON  },  // TIBETAN MARK GUG RTAGS GYAS
  { 0x0F3C, BIDI_ON  },  // TIBETAN MARK ANG KHANG GYON
  { 0x0F3D, BIDI_ON  },  // TIBETAN MARK ANG KHANG GYAS
  { 0x0F3E, BIDI_L   },  // TIBETAN SIGN YAR TSHES
  { 0x0F3F, BIDI_L   },  // TIBETAN SIGN MAR TSHES
  { 0x0F40, BIDI_L   },  // TIBETAN LETTER KA
  { 0x0F41, BIDI_L   },  // TIBETAN LETTER KHA
  { 0x0F42, BIDI_L   },  // TIBETAN LETTER GA
  { 0x0F43, BIDI_L   },  // TIBETAN LETTER GHA
  { 0x0F44, BIDI_L   },  // TIBETAN LETTER NGA
  { 0x0F45, BIDI_L   },  // TIBETAN LETTER CA
  { 0x0F46, BIDI_L   },  // TIBETAN LETTER CHA
  { 0x0F47, BIDI_L   },  // TIBETAN LETTER JA
  { 0x0F49, BIDI_L   },  // TIBETAN LETTER NYA
  { 0x0F4A, BIDI_L   },  // TIBETAN LETTER TTA
  { 0x0F4B, BIDI_L   },  // TIBETAN LETTER TTHA
  { 0x0F4C, BIDI_L   },  // TIBETAN LETTER DDA
  { 0x0F4D, BIDI_L   },  // TIBETAN LETTER DDHA
  { 0x0F4E, BIDI_L   },  // TIBETAN LETTER NNA
  { 0x0F4F, BIDI_L   },  // TIBETAN LETTER TA
  { 0x0F50, BIDI_L   },  // TIBETAN LETTER THA
  { 0x0F51, BIDI_L   },  // TIBETAN LETTER DA
  { 0x0F52, BIDI_L   },  // TIBETAN LETTER DHA
  { 0x0F53, BIDI_L   },  // TIBETAN LETTER NA
  { 0x0F54, BIDI_L   },  // TIBETAN LETTER PA
  { 0x0F55, BIDI_L   },  // TIBETAN LETTER PHA
  { 0x0F56, BIDI_L   },  // TIBETAN LETTER BA
  { 0x0F57, BIDI_L   },  // TIBETAN LETTER BHA
  { 0x0F58, BIDI_L   },  // TIBETAN LETTER MA
  { 0x0F59, BIDI_L   },  // TIBETAN LETTER TSA
  { 0x0F5A, BIDI_L   },  // TIBETAN LETTER TSHA
  { 0x0F5B, BIDI_L   },  // TIBETAN LETTER DZA
  { 0x0F5C, BIDI_L   },  // TIBETAN LETTER DZHA
  { 0x0F5D, BIDI_L   },  // TIBETAN LETTER WA
  { 0x0F5E, BIDI_L   },  // TIBETAN LETTER ZHA
  { 0x0F5F, BIDI_L   },  // TIBETAN LETTER ZA
  { 0x0F60, BIDI_L   },  // TIBETAN LETTER -A
  { 0x0F61, BIDI_L   },  // TIBETAN LETTER YA
  { 0x0F62, BIDI_L   },  // TIBETAN LETTER RA
  { 0x0F63, BIDI_L   },  // TIBETAN LETTER LA
  { 0x0F64, BIDI_L   },  // TIBETAN LETTER SHA
  { 0x0F65, BIDI_L   },  // TIBETAN LETTER SSA
  { 0x0F66, BIDI_L   },  // TIBETAN LETTER SA
  { 0x0F67, BIDI_L   },  // TIBETAN LETTER HA
  { 0x0F68, BIDI_L   },  // TIBETAN LETTER A
  { 0x0F69, BIDI_L   },  // TIBETAN LETTER KSSA
  { 0x0F6A, BIDI_L   },  // TIBETAN LETTER FIXED-FORM RA
  { 0x0F6B, BIDI_L   },  // TIBETAN LETTER KKA
  { 0x0F6C, BIDI_L   },  // TIBETAN LETTER RRA
  { 0x0F71, BIDI_NSM },  // TIBETAN VOWEL SIGN AA
  { 0x0F72, BIDI_NSM },  // TIBETAN VOWEL SIGN I
  { 0x0F73, BIDI_NSM },  // TIBETAN VOWEL SIGN II
  { 0x0F74, BIDI_NSM },  // TIBETAN VOWEL SIGN U
  { 0x0F75, BIDI_NSM },  // TIBETAN VOWEL SIGN UU
  { 0x0F76, BIDI_NSM },  // TIBETAN VOWEL SIGN VOCALIC R
  { 0x0F77, BIDI_NSM },  // TIBETAN VOWEL SIGN VOCALIC RR
  { 0x0F78, BIDI_NSM },  // TIBETAN VOWEL SIGN VOCALIC L
  { 0x0F79, BIDI_NSM },  // TIBETAN VOWEL SIGN VOCALIC LL
  { 0x0F7A, BIDI_NSM },  // TIBETAN VOWEL SIGN E
  { 0x0F7B, BIDI_NSM },  // TIBETAN VOWEL SIGN EE
  { 0x0F7C, BIDI_NSM },  // TIBETAN VOWEL SIGN O
  { 0x0F7D, BIDI_NSM },  // TIBETAN VOWEL SIGN OO
  { 0x0F7E, BIDI_NSM },  // TIBETAN SIGN RJES SU NGA RO
  { 0x0F7F, BIDI_L   },  // TIBETAN SIGN RNAM BCAD
  { 0x0F80, BIDI_NSM },  // TIBETAN VOWEL SIGN REVERSED I
  { 0x0F81, BIDI_NSM },  // TIBETAN VOWEL SIGN REVERSED II
  { 0x0F82, BIDI_NSM },  // TIBETAN SIGN NYI ZLA NAA DA
  { 0x0F83, BIDI_NSM },  // TIBETAN SIGN SNA LDAN
  { 0x0F84, BIDI_NSM },  // TIBETAN MARK HALANTA
  { 0x0F85, BIDI_L   },  // TIBETAN MARK PALUTA
  { 0x0F86, BIDI_NSM },  // TIBETAN SIGN LCI RTAGS
  { 0x0F87, BIDI_NSM },  // TIBETAN SIGN YANG RTAGS
  { 0x0F88, BIDI_L   },  // TIBETAN SIGN LCE TSA CAN
  { 0x0F89, BIDI_L   },  // TIBETAN SIGN MCHU CAN
  { 0x0F8A, BIDI_L   },  // TIBETAN SIGN GRU CAN RGYINGS
  { 0x0F8B, BIDI_L   },  // TIBETAN SIGN GRU MED RGYINGS
  { 0x0F8C, BIDI_L   },  // TIBETAN SIGN INVERTED MCHU CAN
  { 0x0F8D, BIDI_NSM },  // TIBETAN SUBJOINED SIGN LCE TSA CAN
  { 0x0F8E, BIDI_NSM },  // TIBETAN SUBJOINED SIGN MCHU CAN
  { 0x0F8F, BIDI_NSM },  // TIBETAN SUBJOINED SIGN INVERTED MCHU CAN
  { 0x0F90, BIDI_NSM },  // TIBETAN SUBJOINED LETTER KA
  { 0x0F91, BIDI_NSM },  // TIBETAN SUBJOINED LETTER KHA
  { 0x0F92, BIDI_NSM },  // TIBETAN SUBJOINED LETTER GA
  { 0x0F93, BIDI_NSM },  // TIBETAN SUBJOINED LETTER GHA
  { 0x0F94, BIDI_NSM },  // TIBETAN SUBJOINED LETTER NGA
  { 0x0F95, BIDI_NSM },  // TIBETAN SUBJOINED LETTER CA
  { 0x0F96, BIDI_NSM },  // TIBETAN SUBJOINED LETTER CHA
  { 0x0F97, BIDI_NSM },  // TIBETAN SUBJOINED LETTER JA
  { 0x0F99, BIDI_NSM },  // TIBETAN SUBJOINED LETTER NYA
  { 0x0F9A, BIDI_NSM },  // TIBETAN SUBJOINED LETTER TTA
  { 0x0F9B, BIDI_NSM },  // TIBETAN SUBJOINED LETTER TTHA
  { 0x0F9C, BIDI_NSM },  // TIBETAN SUBJOINED LETTER DDA
  { 0x0F9D, BIDI_NSM },  // TIBETAN SUBJOINED LETTER DDHA
  { 0x0F9E, BIDI_NSM },  // TIBETAN SUBJOINED LETTER NNA
  { 0x0F9F, BIDI_NSM },  // TIBETAN SUBJOINED LETTER TA
  { 0x0FA0, BIDI_NSM },  // TIBETAN SUBJOINED LETTER THA
  { 0x0FA1, BIDI_NSM },  // TIBETAN SUBJOINED LETTER DA
  { 0x0FA2, BIDI_NSM },  // TIBETAN SUBJOINED LETTER DHA
  { 0x0FA3, BIDI_NSM },  // TIBETAN SUBJOINED LETTER NA
  { 0x0FA4, BIDI_NSM },  // TIBETAN SUBJOINED LETTER PA
  { 0x0FA5, BIDI_NSM },  // TIBETAN SUBJOINED LETTER PHA
  { 0x0FA6, BIDI_NSM },  // TIBETAN SUBJOINED LETTER BA
  { 0x0FA7, BIDI_NSM },  // TIBETAN SUBJOINED LETTER BHA
  { 0x0FA8, BIDI_NSM },  // TIBETAN SUBJOINED LETTER MA
  { 0x0FA9, BIDI_NSM },  // TIBETAN SUBJOINED LETTER TSA
  { 0x0FAA, BIDI_NSM },  // TIBETAN SUBJOINED LETTER TSHA
  { 0x0FAB, BIDI_NSM },  // TIBETAN SUBJOINED LETTER DZA
  { 0x0FAC, BIDI_NSM },  // TIBETAN SUBJOINED LETTER DZHA
  { 0x0FAD, BIDI_NSM },  // TIBETAN SUBJOINED LETTER WA
  { 0x0FAE, BIDI_NSM },  // TIBETAN SUBJOINED LETTER ZHA
  { 0x0FAF, BIDI_NSM },  // TIBETAN SUBJOINED LETTER ZA
  { 0x0FB0, BIDI_NSM },  // TIBETAN SUBJOINED LETTER -A
  { 0x0FB1, BIDI_NSM },  // TIBETAN SUBJOINED LETTER YA
  { 0x0FB2, BIDI_NSM },  // TIBETAN SUBJOINED LETTER RA
  { 0x0FB3, BIDI_NSM },  // TIBETAN SUBJOINED LETTER LA
  { 0x0FB4, BIDI_NSM },  // TIBETAN SUBJOINED LETTER SHA
  { 0x0FB5, BIDI_NSM },  // TIBETAN SUBJOINED LETTER SSA
  { 0x0FB6, BIDI_NSM },  // TIBETAN SUBJOINED LETTER SA
  { 0x0FB7, BIDI_NSM },  // TIBETAN SUBJOINED LETTER HA
  { 0x0FB8, BIDI_NSM },  // TIBETAN SUBJOINED LETTER A
  { 0x0FB9, BIDI_NSM },  // TIBETAN SUBJOINED LETTER KSSA
  { 0x0FBA, BIDI_NSM },  // TIBETAN SUBJOINED LETTER FIXED-FORM WA
  { 0x0FBB, BIDI_NSM },  // TIBETAN SUBJOINED LETTER FIXED-FORM YA
  { 0x0FBC, BIDI_NSM },  // TIBETAN SUBJOINED LETTER FIXED-FORM RA
  { 0x0FBE, BIDI_L   },  // TIBETAN KU RU KHA
  { 0x0FBF, BIDI_L   },  // TIBETAN KU RU KHA BZHI MIG CAN
  { 0x0FC0, BIDI_L   },  // TIBETAN CANTILLATION SIGN HEAVY BEAT
  { 0x0FC1, BIDI_L   },  // TIBETAN CANTILLATION SIGN LIGHT BEAT
  { 0x0FC2, BIDI_L   },  // TIBETAN CANTILLATION SIGN CANG TE-U
  { 0x0FC3, BIDI_L   },  // TIBETAN CANTILLATION SIGN SBUB -CHAL
  { 0x0FC4, BIDI_L   },  // TIBETAN SYMBOL DRIL BU
  { 0x0FC5, BIDI_L   },  // TIBETAN SYMBOL RDO RJE
  { 0x0FC6, BIDI_NSM },  // TIBETAN SYMBOL PADMA GDAN
  { 0x0FC7, BIDI_L   },  // TIBETAN SYMBOL RDO RJE RGYA GRAM
  { 0x0FC8, BIDI_L   },  // TIBETAN SYMBOL PHUR PA
  { 0x0FC9, BIDI_L   },  // TIBETAN SYMBOL NOR BU
  { 0x0FCA, BIDI_L   },  // TIBETAN SYMBOL NOR BU NYIS -KHYIL
  { 0x0FCB, BIDI_L   },  // TIBETAN SYMBOL NOR BU GSUM -KHYIL
  { 0x0FCC, BIDI_L   },  // TIBETAN SYMBOL NOR BU BZHI -KHYIL
  { 0x0FCE, BIDI_L   },  // TIBETAN SIGN RDEL NAG RDEL DKAR
  { 0x0FCF, BIDI_L   },  // TIBETAN SIGN RDEL NAG GSUM
  { 0x0FD0, BIDI_L   },  // TIBETAN MARK BSKA- SHOG GI MGO RGYAN
  { 0x0FD1, BIDI_L   },  // TIBETAN MARK MNYAM YIG GI MGO RGYAN
  { 0x0FD2, BIDI_L   },  // TIBETAN MARK NYIS TSHEG
  { 0x0FD3, BIDI_L   },  // TIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MA
  { 0x0FD4, BIDI_L   },  // TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA
  { 0x0FD5, BIDI_L   },  // RIGHT-FACING SVASTI SIGN
  { 0x0FD6, BIDI_L   },  // LEFT-FACING SVASTI SIGN
  { 0x0FD7, BIDI_L   },  // RIGHT-FACING SVASTI SIGN WITH DOTS
  { 0x0FD8, BIDI_L   },  // LEFT-FACING SVASTI SIGN WITH DOTS
  { 0x0FD9, BIDI_L   },  // TIBETAN MARK LEADING MCHAN RTAGS
  { 0x0FDA, BIDI_L   },  // TIBETAN MARK TRAILING MCHAN RTAGS

#endif
#if (GUI_BIDI_SUPPORT_RANGE_1 == 1)

  { 0x1000, BIDI_L   },  // MYANMAR LETTER KA
  { 0x1001, BIDI_L   },  // MYANMAR LETTER KHA
  { 0x1002, BIDI_L   },  // MYANMAR LETTER GA
  { 0x1003, BIDI_L   },  // MYANMAR LETTER GHA
  { 0x1004, BIDI_L   },  // MYANMAR LETTER NGA
  { 0x1005, BIDI_L   },  // MYANMAR LETTER CA
  { 0x1006, BIDI_L   },  // MYANMAR LETTER CHA
  { 0x1007, BIDI_L   },  // MYANMAR LETTER JA
  { 0x1008, BIDI_L   },  // MYANMAR LETTER JHA
  { 0x1009, BIDI_L   },  // MYANMAR LETTER NYA
  { 0x100A, BIDI_L   },  // MYANMAR LETTER NNYA
  { 0x100B, BIDI_L   },  // MYANMAR LETTER TTA
  { 0x100C, BIDI_L   },  // MYANMAR LETTER TTHA
  { 0x100D, BIDI_L   },  // MYANMAR LETTER DDA
  { 0x100E, BIDI_L   },  // MYANMAR LETTER DDHA
  { 0x100F, BIDI_L   },  // MYANMAR LETTER NNA
  { 0x1010, BIDI_L   },  // MYANMAR LETTER TA
  { 0x1011, BIDI_L   },  // MYANMAR LETTER THA
  { 0x1012, BIDI_L   },  // MYANMAR LETTER DA
  { 0x1013, BIDI_L   },  // MYANMAR LETTER DHA
  { 0x1014, BIDI_L   },  // MYANMAR LETTER NA
  { 0x1015, BIDI_L   },  // MYANMAR LETTER PA
  { 0x1016, BIDI_L   },  // MYANMAR LETTER PHA
  { 0x1017, BIDI_L   },  // MYANMAR LETTER BA
  { 0x1018, BIDI_L   },  // MYANMAR LETTER BHA
  { 0x1019, BIDI_L   },  // MYANMAR LETTER MA
  { 0x101A, BIDI_L   },  // MYANMAR LETTER YA
  { 0x101B, BIDI_L   },  // MYANMAR LETTER RA
  { 0x101C, BIDI_L   },  // MYANMAR LETTER LA
  { 0x101D, BIDI_L   },  // MYANMAR LETTER WA
  { 0x101E, BIDI_L   },  // MYANMAR LETTER SA
  { 0x101F, BIDI_L   },  // MYANMAR LETTER HA
  { 0x1020, BIDI_L   },  // MYANMAR LETTER LLA
  { 0x1021, BIDI_L   },  // MYANMAR LETTER A
  { 0x1022, BIDI_L   },  // MYANMAR LETTER SHAN A
  { 0x1023, BIDI_L   },  // MYANMAR LETTER I
  { 0x1024, BIDI_L   },  // MYANMAR LETTER II
  { 0x1025, BIDI_L   },  // MYANMAR LETTER U
  { 0x1026, BIDI_L   },  // MYANMAR LETTER UU
  { 0x1027, BIDI_L   },  // MYANMAR LETTER E
  { 0x1028, BIDI_L   },  // MYANMAR LETTER MON E
  { 0x1029, BIDI_L   },  // MYANMAR LETTER O
  { 0x102A, BIDI_L   },  // MYANMAR LETTER AU
  { 0x102B, BIDI_L   },  // MYANMAR VOWEL SIGN TALL AA
  { 0x102C, BIDI_L   },  // MYANMAR VOWEL SIGN AA
  { 0x102D, BIDI_NSM },  // MYANMAR VOWEL SIGN I
  { 0x102E, BIDI_NSM },  // MYANMAR VOWEL SIGN II
  { 0x102F, BIDI_NSM },  // MYANMAR VOWEL SIGN U
  { 0x1030, BIDI_NSM },  // MYANMAR VOWEL SIGN UU
  { 0x1031, BIDI_L   },  // MYANMAR VOWEL SIGN E
  { 0x1032, BIDI_NSM },  // MYANMAR VOWEL SIGN AI
  { 0x1033, BIDI_NSM },  // MYANMAR VOWEL SIGN MON II
  { 0x1034, BIDI_NSM },  // MYANMAR VOWEL SIGN MON O
  { 0x1035, BIDI_NSM },  // MYANMAR VOWEL SIGN E ABOVE
  { 0x1036, BIDI_NSM },  // MYANMAR SIGN ANUSVARA
  { 0x1037, BIDI_NSM },  // MYANMAR SIGN DOT BELOW
  { 0x1038, BIDI_L   },  // MYANMAR SIGN VISARGA
  { 0x1039, BIDI_NSM },  // MYANMAR SIGN VIRAMA
  { 0x103A, BIDI_NSM },  // MYANMAR SIGN ASAT
  { 0x103B, BIDI_L   },  // MYANMAR CONSONANT SIGN MEDIAL YA
  { 0x103C, BIDI_L   },  // MYANMAR CONSONANT SIGN MEDIAL RA
  { 0x103D, BIDI_NSM },  // MYANMAR CONSONANT SIGN MEDIAL WA
  { 0x103E, BIDI_NSM },  // MYANMAR CONSONANT SIGN MEDIAL HA
  { 0x103F, BIDI_L   },  // MYANMAR LETTER GREAT SA
  { 0x1040, BIDI_L   },  // MYANMAR DIGIT ZERO
  { 0x1041, BIDI_L   },  // MYANMAR DIGIT ONE
  { 0x1042, BIDI_L   },  // MYANMAR DIGIT TWO
  { 0x1043, BIDI_L   },  // MYANMAR DIGIT THREE
  { 0x1044, BIDI_L   },  // MYANMAR DIGIT FOUR
  { 0x1045, BIDI_L   },  // MYANMAR DIGIT FIVE
  { 0x1046, BIDI_L   },  // MYANMAR DIGIT SIX
  { 0x1047, BIDI_L   },  // MYANMAR DIGIT SEVEN
  { 0x1048, BIDI_L   },  // MYANMAR DIGIT EIGHT
  { 0x1049, BIDI_L   },  // MYANMAR DIGIT NINE
  { 0x104A, BIDI_L   },  // MYANMAR SIGN LITTLE SECTION
  { 0x104B, BIDI_L   },  // MYANMAR SIGN SECTION
  { 0x104C, BIDI_L   },  // MYANMAR SYMBOL LOCATIVE
  { 0x104D, BIDI_L   },  // MYANMAR SYMBOL COMPLETED
  { 0x104E, BIDI_L   },  // MYANMAR SYMBOL AFOREMENTIONED
  { 0x104F, BIDI_L   },  // MYANMAR SYMBOL GENITIVE
  { 0x1050, BIDI_L   },  // MYANMAR LETTER SHA
  { 0x1051, BIDI_L   },  // MYANMAR LETTER SSA
  { 0x1052, BIDI_L   },  // MYANMAR LETTER VOCALIC R
  { 0x1053, BIDI_L   },  // MYANMAR LETTER VOCALIC RR
  { 0x1054, BIDI_L   },  // MYANMAR LETTER VOCALIC L
  { 0x1055, BIDI_L   },  // MYANMAR LETTER VOCALIC LL
  { 0x1056, BIDI_L   },  // MYANMAR VOWEL SIGN VOCALIC R
  { 0x1057, BIDI_L   },  // MYANMAR VOWEL SIGN VOCALIC RR
  { 0x1058, BIDI_NSM },  // MYANMAR VOWEL SIGN VOCALIC L
  { 0x1059, BIDI_NSM },  // MYANMAR VOWEL SIGN VOCALIC LL
  { 0x105A, BIDI_L   },  // MYANMAR LETTER MON NGA
  { 0x105B, BIDI_L   },  // MYANMAR LETTER MON JHA
  { 0x105C, BIDI_L   },  // MYANMAR LETTER MON BBA
  { 0x105D, BIDI_L   },  // MYANMAR LETTER MON BBE
  { 0x105E, BIDI_NSM },  // MYANMAR CONSONANT SIGN MON MEDIAL NA
  { 0x105F, BIDI_NSM },  // MYANMAR CONSONANT SIGN MON MEDIAL MA
  { 0x1060, BIDI_NSM },  // MYANMAR CONSONANT SIGN MON MEDIAL LA
  { 0x1061, BIDI_L   },  // MYANMAR LETTER SGAW KAREN SHA
  { 0x1062, BIDI_L   },  // MYANMAR VOWEL SIGN SGAW KAREN EU
  { 0x1063, BIDI_L   },  // MYANMAR TONE MARK SGAW KAREN HATHI
  { 0x1064, BIDI_L   },  // MYANMAR TONE MARK SGAW KAREN KE PHO
  { 0x1065, BIDI_L   },  // MYANMAR LETTER WESTERN PWO KAREN THA
  { 0x1066, BIDI_L   },  // MYANMAR LETTER WESTERN PWO KAREN PWA
  { 0x1067, BIDI_L   },  // MYANMAR VOWEL SIGN WESTERN PWO KAREN EU
  { 0x1068, BIDI_L   },  // MYANMAR VOWEL SIGN WESTERN PWO KAREN UE
  { 0x1069, BIDI_L   },  // MYANMAR SIGN WESTERN PWO KAREN TONE-1
  { 0x106A, BIDI_L   },  // MYANMAR SIGN WESTERN PWO KAREN TONE-2
  { 0x106B, BIDI_L   },  // MYANMAR SIGN WESTERN PWO KAREN TONE-3
  { 0x106C, BIDI_L   },  // MYANMAR SIGN WESTERN PWO KAREN TONE-4
  { 0x106D, BIDI_L   },  // MYANMAR SIGN WESTERN PWO KAREN TONE-5
  { 0x106E, BIDI_L   },  // MYANMAR LETTER EASTERN PWO KAREN NNA
  { 0x106F, BIDI_L   },  // MYANMAR LETTER EASTERN PWO KAREN YWA
  { 0x1070, BIDI_L   },  // MYANMAR LETTER EASTERN PWO KAREN GHWA
  { 0x1071, BIDI_NSM },  // MYANMAR VOWEL SIGN GEBA KAREN I
  { 0x1072, BIDI_NSM },  // MYANMAR VOWEL SIGN KAYAH OE
  { 0x1073, BIDI_NSM },  // MYANMAR VOWEL SIGN KAYAH U
  { 0x1074, BIDI_NSM },  // MYANMAR VOWEL SIGN KAYAH EE
  { 0x1075, BIDI_L   },  // MYANMAR LETTER SHAN KA
  { 0x1076, BIDI_L   },  // MYANMAR LETTER SHAN KHA
  { 0x1077, BIDI_L   },  // MYANMAR LETTER SHAN GA
  { 0x1078, BIDI_L   },  // MYANMAR LETTER SHAN CA
  { 0x1079, BIDI_L   },  // MYANMAR LETTER SHAN ZA
  { 0x107A, BIDI_L   },  // MYANMAR LETTER SHAN NYA
  { 0x107B, BIDI_L   },  // MYANMAR LETTER SHAN DA
  { 0x107C, BIDI_L   },  // MYANMAR LETTER SHAN NA
  { 0x107D, BIDI_L   },  // MYANMAR LETTER SHAN PHA
  { 0x107E, BIDI_L   },  // MYANMAR LETTER SHAN FA
  { 0x107F, BIDI_L   },  // MYANMAR LETTER SHAN BA
  { 0x1080, BIDI_L   },  // MYANMAR LETTER SHAN THA
  { 0x1081, BIDI_L   },  // MYANMAR LETTER SHAN HA
  { 0x1082, BIDI_NSM },  // MYANMAR CONSONANT SIGN SHAN MEDIAL WA
  { 0x1083, BIDI_L   },  // MYANMAR VOWEL SIGN SHAN AA
  { 0x1084, BIDI_L   },  // MYANMAR VOWEL SIGN SHAN E
  { 0x1085, BIDI_NSM },  // MYANMAR VOWEL SIGN SHAN E ABOVE
  { 0x1086, BIDI_NSM },  // MYANMAR VOWEL SIGN SHAN FINAL Y
  { 0x1087, BIDI_L   },  // MYANMAR SIGN SHAN TONE-2
  { 0x1088, BIDI_L   },  // MYANMAR SIGN SHAN TONE-3
  { 0x1089, BIDI_L   },  // MYANMAR SIGN SHAN TONE-5
  { 0x108A, BIDI_L   },  // MYANMAR SIGN SHAN TONE-6
  { 0x108B, BIDI_L   },  // MYANMAR SIGN SHAN COUNCIL TONE-2
  { 0x108C, BIDI_L   },  // MYANMAR SIGN SHAN COUNCIL TONE-3
  { 0x108D, BIDI_NSM },  // MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
  { 0x108E, BIDI_L   },  // MYANMAR LETTER RUMAI PALAUNG FA
  { 0x108F, BIDI_L   },  // MYANMAR SIGN RUMAI PALAUNG TONE-5
  { 0x1090, BIDI_L   },  // MYANMAR SHAN DIGIT ZERO
  { 0x1091, BIDI_L   },  // MYANMAR SHAN DIGIT ONE
  { 0x1092, BIDI_L   },  // MYANMAR SHAN DIGIT TWO
  { 0x1093, BIDI_L   },  // MYANMAR SHAN DIGIT THREE
  { 0x1094, BIDI_L   },  // MYANMAR SHAN DIGIT FOUR
  { 0x1095, BIDI_L   },  // MYANMAR SHAN DIGIT FIVE
  { 0x1096, BIDI_L   },  // MYANMAR SHAN DIGIT SIX
  { 0x1097, BIDI_L   },  // MYANMAR SHAN DIGIT SEVEN
  { 0x1098, BIDI_L   },  // MYANMAR SHAN DIGIT EIGHT
  { 0x1099, BIDI_L   },  // MYANMAR SHAN DIGIT NINE
  { 0x109A, BIDI_L   },  // MYANMAR SIGN KHAMTI TONE-1
  { 0x109B, BIDI_L   },  // MYANMAR SIGN KHAMTI TONE-3
  { 0x109C, BIDI_L   },  // MYANMAR VOWEL SIGN AITON A
  { 0x109D, BIDI_NSM },  // MYANMAR VOWEL SIGN AITON AI
  { 0x109E, BIDI_L   },  // MYANMAR SYMBOL SHAN ONE
  { 0x109F, BIDI_L   },  // MYANMAR SYMBOL SHAN EXCLAMATION
  { 0x10A0, BIDI_L   },  // GEORGIAN CAPITAL LETTER AN
  { 0x10A1, BIDI_L   },  // GEORGIAN CAPITAL LETTER BAN
  { 0x10A2, BIDI_L   },  // GEORGIAN CAPITAL LETTER GAN
  { 0x10A3, BIDI_L   },  // GEORGIAN CAPITAL LETTER DON
  { 0x10A4, BIDI_L   },  // GEORGIAN CAPITAL LETTER EN
  { 0x10A5, BIDI_L   },  // GEORGIAN CAPITAL LETTER VIN
  { 0x10A6, BIDI_L   },  // GEORGIAN CAPITAL LETTER ZEN
  { 0x10A7, BIDI_L   },  // GEORGIAN CAPITAL LETTER TAN
  { 0x10A8, BIDI_L   },  // GEORGIAN CAPITAL LETTER IN
  { 0x10A9, BIDI_L   },  // GEORGIAN CAPITAL LETTER KAN
  { 0x10AA, BIDI_L   },  // GEORGIAN CAPITAL LETTER LAS
  { 0x10AB, BIDI_L   },  // GEORGIAN CAPITAL LETTER MAN
  { 0x10AC, BIDI_L   },  // GEORGIAN CAPITAL LETTER NAR
  { 0x10AD, BIDI_L   },  // GEORGIAN CAPITAL LETTER ON
  { 0x10AE, BIDI_L   },  // GEORGIAN CAPITAL LETTER PAR
  { 0x10AF, BIDI_L   },  // GEORGIAN CAPITAL LETTER ZHAR
  { 0x10B0, BIDI_L   },  // GEORGIAN CAPITAL LETTER RAE
  { 0x10B1, BIDI_L   },  // GEORGIAN CAPITAL LETTER SAN
  { 0x10B2, BIDI_L   },  // GEORGIAN CAPITAL LETTER TAR
  { 0x10B3, BIDI_L   },  // GEORGIAN CAPITAL LETTER UN
  { 0x10B4, BIDI_L   },  // GEORGIAN CAPITAL LETTER PHAR
  { 0x10B5, BIDI_L   },  // GEORGIAN CAPITAL LETTER KHAR
  { 0x10B6, BIDI_L   },  // GEORGIAN CAPITAL LETTER GHAN
  { 0x10B7, BIDI_L   },  // GEORGIAN CAPITAL LETTER QAR
  { 0x10B8, BIDI_L   },  // GEORGIAN CAPITAL LETTER SHIN
  { 0x10B9, BIDI_L   },  // GEORGIAN CAPITAL LETTER CHIN
  { 0x10BA, BIDI_L   },  // GEORGIAN CAPITAL LETTER CAN
  { 0x10BB, BIDI_L   },  // GEORGIAN CAPITAL LETTER JIL
  { 0x10BC, BIDI_L   },  // GEORGIAN CAPITAL LETTER CIL
  { 0x10BD, BIDI_L   },  // GEORGIAN CAPITAL LETTER CHAR
  { 0x10BE, BIDI_L   },  // GEORGIAN CAPITAL LETTER XAN
  { 0x10BF, BIDI_L   },  // GEORGIAN CAPITAL LETTER JHAN
  { 0x10C0, BIDI_L   },  // GEORGIAN CAPITAL LETTER HAE
  { 0x10C1, BIDI_L   },  // GEORGIAN CAPITAL LETTER HE
  { 0x10C2, BIDI_L   },  // GEORGIAN CAPITAL LETTER HIE
  { 0x10C3, BIDI_L   },  // GEORGIAN CAPITAL LETTER WE
  { 0x10C4, BIDI_L   },  // GEORGIAN CAPITAL LETTER HAR
  { 0x10C5, BIDI_L   },  // GEORGIAN CAPITAL LETTER HOE
  { 0x10C7, BIDI_L   },  // GEORGIAN CAPITAL LETTER YN
  { 0x10CD, BIDI_L   },  // GEORGIAN CAPITAL LETTER AEN
  { 0x10D0, BIDI_L   },  // GEORGIAN LETTER AN
  { 0x10D1, BIDI_L   },  // GEORGIAN LETTER BAN
  { 0x10D2, BIDI_L   },  // GEORGIAN LETTER GAN
  { 0x10D3, BIDI_L   },  // GEORGIAN LETTER DON
  { 0x10D4, BIDI_L   },  // GEORGIAN LETTER EN
  { 0x10D5, BIDI_L   },  // GEORGIAN LETTER VIN
  { 0x10D6, BIDI_L   },  // GEORGIAN LETTER ZEN
  { 0x10D7, BIDI_L   },  // GEORGIAN LETTER TAN
  { 0x10D8, BIDI_L   },  // GEORGIAN LETTER IN
  { 0x10D9, BIDI_L   },  // GEORGIAN LETTER KAN
  { 0x10DA, BIDI_L   },  // GEORGIAN LETTER LAS
  { 0x10DB, BIDI_L   },  // GEORGIAN LETTER MAN
  { 0x10DC, BIDI_L   },  // GEORGIAN LETTER NAR
  { 0x10DD, BIDI_L   },  // GEORGIAN LETTER ON
  { 0x10DE, BIDI_L   },  // GEORGIAN LETTER PAR
  { 0x10DF, BIDI_L   },  // GEORGIAN LETTER ZHAR
  { 0x10E0, BIDI_L   },  // GEORGIAN LETTER RAE
  { 0x10E1, BIDI_L   },  // GEORGIAN LETTER SAN
  { 0x10E2, BIDI_L   },  // GEORGIAN LETTER TAR
  { 0x10E3, BIDI_L   },  // GEORGIAN LETTER UN
  { 0x10E4, BIDI_L   },  // GEORGIAN LETTER PHAR
  { 0x10E5, BIDI_L   },  // GEORGIAN LETTER KHAR
  { 0x10E6, BIDI_L   },  // GEORGIAN LETTER GHAN
  { 0x10E7, BIDI_L   },  // GEORGIAN LETTER QAR
  { 0x10E8, BIDI_L   },  // GEORGIAN LETTER SHIN
  { 0x10E9, BIDI_L   },  // GEORGIAN LETTER CHIN
  { 0x10EA, BIDI_L   },  // GEORGIAN LETTER CAN
  { 0x10EB, BIDI_L   },  // GEORGIAN LETTER JIL
  { 0x10EC, BIDI_L   },  // GEORGIAN LETTER CIL
  { 0x10ED, BIDI_L   },  // GEORGIAN LETTER CHAR
  { 0x10EE, BIDI_L   },  // GEORGIAN LETTER XAN
  { 0x10EF, BIDI_L   },  // GEORGIAN LETTER JHAN
  { 0x10F0, BIDI_L   },  // GEORGIAN LETTER HAE
  { 0x10F1, BIDI_L   },  // GEORGIAN LETTER HE
  { 0x10F2, BIDI_L   },  // GEORGIAN LETTER HIE
  { 0x10F3, BIDI_L   },  // GEORGIAN LETTER WE
  { 0x10F4, BIDI_L   },  // GEORGIAN LETTER HAR
  { 0x10F5, BIDI_L   },  // GEORGIAN LETTER HOE
  { 0x10F6, BIDI_L   },  // GEORGIAN LETTER FI
  { 0x10F7, BIDI_L   },  // GEORGIAN LETTER YN
  { 0x10F8, BIDI_L   },  // GEORGIAN LETTER ELIFI
  { 0x10F9, BIDI_L   },  // GEORGIAN LETTER TURNED GAN
  { 0x10FA, BIDI_L   },  // GEORGIAN LETTER AIN
  { 0x10FB, BIDI_L   },  // GEORGIAN PARAGRAPH SEPARATOR
  { 0x10FC, BIDI_L   },  // MODIFIER LETTER GEORGIAN NAR
  { 0x10FD, BIDI_L   },  // GEORGIAN LETTER AEN
  { 0x10FE, BIDI_L   },  // GEORGIAN LETTER HARD SIGN
  { 0x10FF, BIDI_L   },  // GEORGIAN LETTER LABIAL SIGN
  { 0x1100, BIDI_L   },  // HANGUL CHOSEONG KIYEOK
  { 0x1101, BIDI_L   },  // HANGUL CHOSEONG SSANGKIYEOK
  { 0x1102, BIDI_L   },  // HANGUL CHOSEONG NIEUN
  { 0x1103, BIDI_L   },  // HANGUL CHOSEONG TIKEUT
  { 0x1104, BIDI_L   },  // HANGUL CHOSEONG SSANGTIKEUT
  { 0x1105, BIDI_L   },  // HANGUL CHOSEONG RIEUL
  { 0x1106, BIDI_L   },  // HANGUL CHOSEONG MIEUM
  { 0x1107, BIDI_L   },  // HANGUL CHOSEONG PIEUP
  { 0x1108, BIDI_L   },  // HANGUL CHOSEONG SSANGPIEUP
  { 0x1109, BIDI_L   },  // HANGUL CHOSEONG SIOS
  { 0x110A, BIDI_L   },  // HANGUL CHOSEONG SSANGSIOS
  { 0x110B, BIDI_L   },  // HANGUL CHOSEONG IEUNG
  { 0x110C, BIDI_L   },  // HANGUL CHOSEONG CIEUC
  { 0x110D, BIDI_L   },  // HANGUL CHOSEONG SSANGCIEUC
  { 0x110E, BIDI_L   },  // HANGUL CHOSEONG CHIEUCH
  { 0x110F, BIDI_L   },  // HANGUL CHOSEONG KHIEUKH
  { 0x1110, BIDI_L   },  // HANGUL CHOSEONG THIEUTH
  { 0x1111, BIDI_L   },  // HANGUL CHOSEONG PHIEUPH
  { 0x1112, BIDI_L   },  // HANGUL CHOSEONG HIEUH
  { 0x1113, BIDI_L   },  // HANGUL CHOSEONG NIEUN-KIYEOK
  { 0x1114, BIDI_L   },  // HANGUL CHOSEONG SSANGNIEUN
  { 0x1115, BIDI_L   },  // HANGUL CHOSEONG NIEUN-TIKEUT
  { 0x1116, BIDI_L   },  // HANGUL CHOSEONG NIEUN-PIEUP
  { 0x1117, BIDI_L   },  // HANGUL CHOSEONG TIKEUT-KIYEOK
  { 0x1118, BIDI_L   },  // HANGUL CHOSEONG RIEUL-NIEUN
  { 0x1119, BIDI_L   },  // HANGUL CHOSEONG SSANGRIEUL
  { 0x111A, BIDI_L   },  // HANGUL CHOSEONG RIEUL-HIEUH
  { 0x111B, BIDI_L   },  // HANGUL CHOSEONG KAPYEOUNRIEUL
  { 0x111C, BIDI_L   },  // HANGUL CHOSEONG MIEUM-PIEUP
  { 0x111D, BIDI_L   },  // HANGUL CHOSEONG KAPYEOUNMIEUM
  { 0x111E, BIDI_L   },  // HANGUL CHOSEONG PIEUP-KIYEOK
  { 0x111F, BIDI_L   },  // HANGUL CHOSEONG PIEUP-NIEUN
  { 0x1120, BIDI_L   },  // HANGUL CHOSEONG PIEUP-TIKEUT
  { 0x1121, BIDI_L   },  // HANGUL CHOSEONG PIEUP-SIOS
  { 0x1122, BIDI_L   },  // HANGUL CHOSEONG PIEUP-SIOS-KIYEOK
  { 0x1123, BIDI_L   },  // HANGUL CHOSEONG PIEUP-SIOS-TIKEUT
  { 0x1124, BIDI_L   },  // HANGUL CHOSEONG PIEUP-SIOS-PIEUP
  { 0x1125, BIDI_L   },  // HANGUL CHOSEONG PIEUP-SSANGSIOS
  { 0x1126, BIDI_L   },  // HANGUL CHOSEONG PIEUP-SIOS-CIEUC
  { 0x1127, BIDI_L   },  // HANGUL CHOSEONG PIEUP-CIEUC
  { 0x1128, BIDI_L   },  // HANGUL CHOSEONG PIEUP-CHIEUCH
  { 0x1129, BIDI_L   },  // HANGUL CHOSEONG PIEUP-THIEUTH
  { 0x112A, BIDI_L   },  // HANGUL CHOSEONG PIEUP-PHIEUPH
  { 0x112B, BIDI_L   },  // HANGUL CHOSEONG KAPYEOUNPIEUP
  { 0x112C, BIDI_L   },  // HANGUL CHOSEONG KAPYEOUNSSANGPIEUP
  { 0x112D, BIDI_L   },  // HANGUL CHOSEONG SIOS-KIYEOK
  { 0x112E, BIDI_L   },  // HANGUL CHOSEONG SIOS-NIEUN
  { 0x112F, BIDI_L   },  // HANGUL CHOSEONG SIOS-TIKEUT
  { 0x1130, BIDI_L   },  // HANGUL CHOSEONG SIOS-RIEUL
  { 0x1131, BIDI_L   },  // HANGUL CHOSEONG SIOS-MIEUM
  { 0x1132, BIDI_L   },  // HANGUL CHOSEONG SIOS-PIEUP
  { 0x1133, BIDI_L   },  // HANGUL CHOSEONG SIOS-PIEUP-KIYEOK
  { 0x1134, BIDI_L   },  // HANGUL CHOSEONG SIOS-SSANGSIOS
  { 0x1135, BIDI_L   },  // HANGUL CHOSEONG SIOS-IEUNG
  { 0x1136, BIDI_L   },  // HANGUL CHOSEONG SIOS-CIEUC
  { 0x1137, BIDI_L   },  // HANGUL CHOSEONG SIOS-CHIEUCH
  { 0x1138, BIDI_L   },  // HANGUL CHOSEONG SIOS-KHIEUKH
  { 0x1139, BIDI_L   },  // HANGUL CHOSEONG SIOS-THIEUTH
  { 0x113A, BIDI_L   },  // HANGUL CHOSEONG SIOS-PHIEUPH
  { 0x113B, BIDI_L   },  // HANGUL CHOSEONG SIOS-HIEUH
  { 0x113C, BIDI_L   },  // HANGUL CHOSEONG CHITUEUMSIOS
  { 0x113D, BIDI_L   },  // HANGUL CHOSEONG CHITUEUMSSANGSIOS
  { 0x113E, BIDI_L   },  // HANGUL CHOSEONG CEONGCHIEUMSIOS
  { 0x113F, BIDI_L   },  // HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS
  { 0x1140, BIDI_L   },  // HANGUL CHOSEONG PANSIOS
  { 0x1141, BIDI_L   },  // HANGUL CHOSEONG IEUNG-KIYEOK
  { 0x1142, BIDI_L   },  // HANGUL CHOSEONG IEUNG-TIKEUT
  { 0x1143, BIDI_L   },  // HANGUL CHOSEONG IEUNG-MIEUM
  { 0x1144, BIDI_L   },  // HANGUL CHOSEONG IEUNG-PIEUP
  { 0x1145, BIDI_L   },  // HANGUL CHOSEONG IEUNG-SIOS
  { 0x1146, BIDI_L   },  // HANGUL CHOSEONG IEUNG-PANSIOS
  { 0x1147, BIDI_L   },  // HANGUL CHOSEONG SSANGIEUNG
  { 0x1148, BIDI_L   },  // HANGUL CHOSEONG IEUNG-CIEUC
  { 0x1149, BIDI_L   },  // HANGUL CHOSEONG IEUNG-CHIEUCH
  { 0x114A, BIDI_L   },  // HANGUL CHOSEONG IEUNG-THIEUTH
  { 0x114B, BIDI_L   },  // HANGUL CHOSEONG IEUNG-PHIEUPH
  { 0x114C, BIDI_L   },  // HANGUL CHOSEONG YESIEUNG
  { 0x114D, BIDI_L   },  // HANGUL CHOSEONG CIEUC-IEUNG
  { 0x114E, BIDI_L   },  // HANGUL CHOSEONG CHITUEUMCIEUC
  { 0x114F, BIDI_L   },  // HANGUL CHOSEONG CHITUEUMSSANGCIEUC
  { 0x1150, BIDI_L   },  // HANGUL CHOSEONG CEONGCHIEUMCIEUC
  { 0x1151, BIDI_L   },  // HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC
  { 0x1152, BIDI_L   },  // HANGUL CHOSEONG CHIEUCH-KHIEUKH
  { 0x1153, BIDI_L   },  // HANGUL CHOSEONG CHIEUCH-HIEUH
  { 0x1154, BIDI_L   },  // HANGUL CHOSEONG CHITUEUMCHIEUCH
  { 0x1155, BIDI_L   },  // HANGUL CHOSEONG CEONGCHIEUMCHIEUCH
  { 0x1156, BIDI_L   },  // HANGUL CHOSEONG PHIEUPH-PIEUP
  { 0x1157, BIDI_L   },  // HANGUL CHOSEONG KAPYEOUNPHIEUPH
  { 0x1158, BIDI_L   },  // HANGUL CHOSEONG SSANGHIEUH
  { 0x1159, BIDI_L   },  // HANGUL CHOSEONG YEORINHIEUH
  { 0x115A, BIDI_L   },  // HANGUL CHOSEONG KIYEOK-TIKEUT
  { 0x115B, BIDI_L   },  // HANGUL CHOSEONG NIEUN-SIOS
  { 0x115C, BIDI_L   },  // HANGUL CHOSEONG NIEUN-CIEUC
  { 0x115D, BIDI_L   },  // HANGUL CHOSEONG NIEUN-HIEUH
  { 0x115E, BIDI_L   },  // HANGUL CHOSEONG TIKEUT-RIEUL
  { 0x115F, BIDI_L   },  // HANGUL CHOSEONG FILLER
  { 0x1160, BIDI_L   },  // HANGUL JUNGSEONG FILLER
  { 0x1161, BIDI_L   },  // HANGUL JUNGSEONG A
  { 0x1162, BIDI_L   },  // HANGUL JUNGSEONG AE
  { 0x1163, BIDI_L   },  // HANGUL JUNGSEONG YA
  { 0x1164, BIDI_L   },  // HANGUL JUNGSEONG YAE
  { 0x1165, BIDI_L   },  // HANGUL JUNGSEONG EO
  { 0x1166, BIDI_L   },  // HANGUL JUNGSEONG E
  { 0x1167, BIDI_L   },  // HANGUL JUNGSEONG YEO
  { 0x1168, BIDI_L   },  // HANGUL JUNGSEONG YE
  { 0x1169, BIDI_L   },  // HANGUL JUNGSEONG O
  { 0x116A, BIDI_L   },  // HANGUL JUNGSEONG WA
  { 0x116B, BIDI_L   },  // HANGUL JUNGSEONG WAE
  { 0x116C, BIDI_L   },  // HANGUL JUNGSEONG OE
  { 0x116D, BIDI_L   },  // HANGUL JUNGSEONG YO
  { 0x116E, BIDI_L   },  // HANGUL JUNGSEONG U
  { 0x116F, BIDI_L   },  // HANGUL JUNGSEONG WEO
  { 0x1170, BIDI_L   },  // HANGUL JUNGSEONG WE
  { 0x1171, BIDI_L   },  // HANGUL JUNGSEONG WI
  { 0x1172, BIDI_L   },  // HANGUL JUNGSEONG YU
  { 0x1173, BIDI_L   },  // HANGUL JUNGSEONG EU
  { 0x1174, BIDI_L   },  // HANGUL JUNGSEONG YI
  { 0x1175, BIDI_L   },  // HANGUL JUNGSEONG I
  { 0x1176, BIDI_L   },  // HANGUL JUNGSEONG A-O
  { 0x1177, BIDI_L   },  // HANGUL JUNGSEONG A-U
  { 0x1178, BIDI_L   },  // HANGUL JUNGSEONG YA-O
  { 0x1179, BIDI_L   },  // HANGUL JUNGSEONG YA-YO
  { 0x117A, BIDI_L   },  // HANGUL JUNGSEONG EO-O
  { 0x117B, BIDI_L   },  // HANGUL JUNGSEONG EO-U
  { 0x117C, BIDI_L   },  // HANGUL JUNGSEONG EO-EU
  { 0x117D, BIDI_L   },  // HANGUL JUNGSEONG YEO-O
  { 0x117E, BIDI_L   },  // HANGUL JUNGSEONG YEO-U
  { 0x117F, BIDI_L   },  // HANGUL JUNGSEONG O-EO
  { 0x1180, BIDI_L   },  // HANGUL JUNGSEONG O-E
  { 0x1181, BIDI_L   },  // HANGUL JUNGSEONG O-YE
  { 0x1182, BIDI_L   },  // HANGUL JUNGSEONG O-O
  { 0x1183, BIDI_L   },  // HANGUL JUNGSEONG O-U
  { 0x1184, BIDI_L   },  // HANGUL JUNGSEONG YO-YA
  { 0x1185, BIDI_L   },  // HANGUL JUNGSEONG YO-YAE
  { 0x1186, BIDI_L   },  // HANGUL JUNGSEONG YO-YEO
  { 0x1187, BIDI_L   },  // HANGUL JUNGSEONG YO-O
  { 0x1188, BIDI_L   },  // HANGUL JUNGSEONG YO-I
  { 0x1189, BIDI_L   },  // HANGUL JUNGSEONG U-A
  { 0x118A, BIDI_L   },  // HANGUL JUNGSEONG U-AE
  { 0x118B, BIDI_L   },  // HANGUL JUNGSEONG U-EO-EU
  { 0x118C, BIDI_L   },  // HANGUL JUNGSEONG U-YE
  { 0x118D, BIDI_L   },  // HANGUL JUNGSEONG U-U
  { 0x118E, BIDI_L   },  // HANGUL JUNGSEONG YU-A
  { 0x118F, BIDI_L   },  // HANGUL JUNGSEONG YU-EO
  { 0x1190, BIDI_L   },  // HANGUL JUNGSEONG YU-E
  { 0x1191, BIDI_L   },  // HANGUL JUNGSEONG YU-YEO
  { 0x1192, BIDI_L   },  // HANGUL JUNGSEONG YU-YE
  { 0x1193, BIDI_L   },  // HANGUL JUNGSEONG YU-U
  { 0x1194, BIDI_L   },  // HANGUL JUNGSEONG YU-I
  { 0x1195, BIDI_L   },  // HANGUL JUNGSEONG EU-U
  { 0x1196, BIDI_L   },  // HANGUL JUNGSEONG EU-EU
  { 0x1197, BIDI_L   },  // HANGUL JUNGSEONG YI-U
  { 0x1198, BIDI_L   },  // HANGUL JUNGSEONG I-A
  { 0x1199, BIDI_L   },  // HANGUL JUNGSEONG I-YA
  { 0x119A, BIDI_L   },  // HANGUL JUNGSEONG I-O
  { 0x119B, BIDI_L   },  // HANGUL JUNGSEONG I-U
  { 0x119C, BIDI_L   },  // HANGUL JUNGSEONG I-EU
  { 0x119D, BIDI_L   },  // HANGUL JUNGSEONG I-ARAEA
  { 0x119E, BIDI_L   },  // HANGUL JUNGSEONG ARAEA
  { 0x119F, BIDI_L   },  // HANGUL JUNGSEONG ARAEA-EO
  { 0x11A0, BIDI_L   },  // HANGUL JUNGSEONG ARAEA-U
  { 0x11A1, BIDI_L   },  // HANGUL JUNGSEONG ARAEA-I
  { 0x11A2, BIDI_L   },  // HANGUL JUNGSEONG SSANGARAEA
  { 0x11A3, BIDI_L   },  // HANGUL JUNGSEONG A-EU
  { 0x11A4, BIDI_L   },  // HANGUL JUNGSEONG YA-U
  { 0x11A5, BIDI_L   },  // HANGUL JUNGSEONG YEO-YA
  { 0x11A6, BIDI_L   },  // HANGUL JUNGSEONG O-YA
  { 0x11A7, BIDI_L   },  // HANGUL JUNGSEONG O-YAE
  { 0x11A8, BIDI_L   },  // HANGUL JONGSEONG KIYEOK
  { 0x11A9, BIDI_L   },  // HANGUL JONGSEONG SSANGKIYEOK
  { 0x11AA, BIDI_L   },  // HANGUL JONGSEONG KIYEOK-SIOS
  { 0x11AB, BIDI_L   },  // HANGUL JONGSEONG NIEUN
  { 0x11AC, BIDI_L   },  // HANGUL JONGSEONG NIEUN-CIEUC
  { 0x11AD, BIDI_L   },  // HANGUL JONGSEONG NIEUN-HIEUH
  { 0x11AE, BIDI_L   },  // HANGUL JONGSEONG TIKEUT
  { 0x11AF, BIDI_L   },  // HANGUL JONGSEONG RIEUL
  { 0x11B0, BIDI_L   },  // HANGUL JONGSEONG RIEUL-KIYEOK
  { 0x11B1, BIDI_L   },  // HANGUL JONGSEONG RIEUL-MIEUM
  { 0x11B2, BIDI_L   },  // HANGUL JONGSEONG RIEUL-PIEUP
  { 0x11B3, BIDI_L   },  // HANGUL JONGSEONG RIEUL-SIOS
  { 0x11B4, BIDI_L   },  // HANGUL JONGSEONG RIEUL-THIEUTH
  { 0x11B5, BIDI_L   },  // HANGUL JONGSEONG RIEUL-PHIEUPH
  { 0x11B6, BIDI_L   },  // HANGUL JONGSEONG RIEUL-HIEUH
  { 0x11B7, BIDI_L   },  // HANGUL JONGSEONG MIEUM
  { 0x11B8, BIDI_L   },  // HANGUL JONGSEONG PIEUP
  { 0x11B9, BIDI_L   },  // HANGUL JONGSEONG PIEUP-SIOS
  { 0x11BA, BIDI_L   },  // HANGUL JONGSEONG SIOS
  { 0x11BB, BIDI_L   },  // HANGUL JONGSEONG SSANGSIOS
  { 0x11BC, BIDI_L   },  // HANGUL JONGSEONG IEUNG
  { 0x11BD, BIDI_L   },  // HANGUL JONGSEONG CIEUC
  { 0x11BE, BIDI_L   },  // HANGUL JONGSEONG CHIEUCH
  { 0x11BF, BIDI_L   },  // HANGUL JONGSEONG KHIEUKH
  { 0x11C0, BIDI_L   },  // HANGUL JONGSEONG THIEUTH
  { 0x11C1, BIDI_L   },  // HANGUL JONGSEONG PHIEUPH
  { 0x11C2, BIDI_L   },  // HANGUL JONGSEONG HIEUH
  { 0x11C3, BIDI_L   },  // HANGUL JONGSEONG KIYEOK-RIEUL
  { 0x11C4, BIDI_L   },  // HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK
  { 0x11C5, BIDI_L   },  // HANGUL JONGSEONG NIEUN-KIYEOK
  { 0x11C6, BIDI_L   },  // HANGUL JONGSEONG NIEUN-TIKEUT
  { 0x11C7, BIDI_L   },  // HANGUL JONGSEONG NIEUN-SIOS
  { 0x11C8, BIDI_L   },  // HANGUL JONGSEONG NIEUN-PANSIOS
  { 0x11C9, BIDI_L   },  // HANGUL JONGSEONG NIEUN-THIEUTH
  { 0x11CA, BIDI_L   },  // HANGUL JONGSEONG TIKEUT-KIYEOK
  { 0x11CB, BIDI_L   },  // HANGUL JONGSEONG TIKEUT-RIEUL
  { 0x11CC, BIDI_L   },  // HANGUL JONGSEONG RIEUL-KIYEOK-SIOS
  { 0x11CD, BIDI_L   },  // HANGUL JONGSEONG RIEUL-NIEUN
  { 0x11CE, BIDI_L   },  // HANGUL JONGSEONG RIEUL-TIKEUT
  { 0x11CF, BIDI_L   },  // HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH
  { 0x11D0, BIDI_L   },  // HANGUL JONGSEONG SSANGRIEUL
  { 0x11D1, BIDI_L   },  // HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK
  { 0x11D2, BIDI_L   },  // HANGUL JONGSEONG RIEUL-MIEUM-SIOS
  { 0x11D3, BIDI_L   },  // HANGUL JONGSEONG RIEUL-PIEUP-SIOS
  { 0x11D4, BIDI_L   },  // HANGUL JONGSEONG RIEUL-PIEUP-HIEUH
  { 0x11D5, BIDI_L   },  // HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP
  { 0x11D6, BIDI_L   },  // HANGUL JONGSEONG RIEUL-SSANGSIOS
  { 0x11D7, BIDI_L   },  // HANGUL JONGSEONG RIEUL-PANSIOS
  { 0x11D8, BIDI_L   },  // HANGUL JONGSEONG RIEUL-KHIEUKH
  { 0x11D9, BIDI_L   },  // HANGUL JONGSEONG RIEUL-YEORINHIEUH
  { 0x11DA, BIDI_L   },  // HANGUL JONGSEONG MIEUM-KIYEOK
  { 0x11DB, BIDI_L   },  // HANGUL JONGSEONG MIEUM-RIEUL
  { 0x11DC, BIDI_L   },  // HANGUL JONGSEONG MIEUM-PIEUP
  { 0x11DD, BIDI_L   },  // HANGUL JONGSEONG MIEUM-SIOS
  { 0x11DE, BIDI_L   },  // HANGUL JONGSEONG MIEUM-SSANGSIOS
  { 0x11DF, BIDI_L   },  // HANGUL JONGSEONG MIEUM-PANSIOS
  { 0x11E0, BIDI_L   },  // HANGUL JONGSEONG MIEUM-CHIEUCH
  { 0x11E1, BIDI_L   },  // HANGUL JONGSEONG MIEUM-HIEUH
  { 0x11E2, BIDI_L   },  // HANGUL JONGSEONG KAPYEOUNMIEUM
  { 0x11E3, BIDI_L   },  // HANGUL JONGSEONG PIEUP-RIEUL
  { 0x11E4, BIDI_L   },  // HANGUL JONGSEONG PIEUP-PHIEUPH
  { 0x11E5, BIDI_L   },  // HANGUL JONGSEONG PIEUP-HIEUH
  { 0x11E6, BIDI_L   },  // HANGUL JONGSEONG KAPYEOUNPIEUP
  { 0x11E7, BIDI_L   },  // HANGUL JONGSEONG SIOS-KIYEOK
  { 0x11E8, BIDI_L   },  // HANGUL JONGSEONG SIOS-TIKEUT
  { 0x11E9, BIDI_L   },  // HANGUL JONGSEONG SIOS-RIEUL
  { 0x11EA, BIDI_L   },  // HANGUL JONGSEONG SIOS-PIEUP
  { 0x11EB, BIDI_L   },  // HANGUL JONGSEONG PANSIOS
  { 0x11EC, BIDI_L   },  // HANGUL JONGSEONG IEUNG-KIYEOK
  { 0x11ED, BIDI_L   },  // HANGUL JONGSEONG IEUNG-SSANGKIYEOK
  { 0x11EE, BIDI_L   },  // HANGUL JONGSEONG SSANGIEUNG
  { 0x11EF, BIDI_L   },  // HANGUL JONGSEONG IEUNG-KHIEUKH
  { 0x11F0, BIDI_L   },  // HANGUL JONGSEONG YESIEUNG
  { 0x11F1, BIDI_L   },  // HANGUL JONGSEONG YESIEUNG-SIOS
  { 0x11F2, BIDI_L   },  // HANGUL JONGSEONG YESIEUNG-PANSIOS
  { 0x11F3, BIDI_L   },  // HANGUL JONGSEONG PHIEUPH-PIEUP
  { 0x11F4, BIDI_L   },  // HANGUL JONGSEONG KAPYEOUNPHIEUPH
  { 0x11F5, BIDI_L   },  // HANGUL JONGSEONG HIEUH-NIEUN
  { 0x11F6, BIDI_L   },  // HANGUL JONGSEONG HIEUH-RIEUL
  { 0x11F7, BIDI_L   },  // HANGUL JONGSEONG HIEUH-MIEUM
  { 0x11F8, BIDI_L   },  // HANGUL JONGSEONG HIEUH-PIEUP
  { 0x11F9, BIDI_L   },  // HANGUL JONGSEONG YEORINHIEUH
  { 0x11FA, BIDI_L   },  // HANGUL JONGSEONG KIYEOK-NIEUN
  { 0x11FB, BIDI_L   },  // HANGUL JONGSEONG KIYEOK-PIEUP
  { 0x11FC, BIDI_L   },  // HANGUL JONGSEONG KIYEOK-CHIEUCH
  { 0x11FD, BIDI_L   },  // HANGUL JONGSEONG KIYEOK-KHIEUKH
  { 0x11FE, BIDI_L   },  // HANGUL JONGSEONG KIYEOK-HIEUH
  { 0x11FF, BIDI_L   },  // HANGUL JONGSEONG SSANGNIEUN
  { 0x1200, BIDI_L   },  // ETHIOPIC SYLLABLE HA
  { 0x1201, BIDI_L   },  // ETHIOPIC SYLLABLE HU
  { 0x1202, BIDI_L   },  // ETHIOPIC SYLLABLE HI
  { 0x1203, BIDI_L   },  // ETHIOPIC SYLLABLE HAA
  { 0x1204, BIDI_L   },  // ETHIOPIC SYLLABLE HEE
  { 0x1205, BIDI_L   },  // ETHIOPIC SYLLABLE HE
  { 0x1206, BIDI_L   },  // ETHIOPIC SYLLABLE HO
  { 0x1207, BIDI_L   },  // ETHIOPIC SYLLABLE HOA
  { 0x1208, BIDI_L   },  // ETHIOPIC SYLLABLE LA
  { 0x1209, BIDI_L   },  // ETHIOPIC SYLLABLE LU
  { 0x120A, BIDI_L   },  // ETHIOPIC SYLLABLE LI
  { 0x120B, BIDI_L   },  // ETHIOPIC SYLLABLE LAA
  { 0x120C, BIDI_L   },  // ETHIOPIC SYLLABLE LEE
  { 0x120D, BIDI_L   },  // ETHIOPIC SYLLABLE LE
  { 0x120E, BIDI_L   },  // ETHIOPIC SYLLABLE LO
  { 0x120F, BIDI_L   },  // ETHIOPIC SYLLABLE LWA
  { 0x1210, BIDI_L   },  // ETHIOPIC SYLLABLE HHA
  { 0x1211, BIDI_L   },  // ETHIOPIC SYLLABLE HHU
  { 0x1212, BIDI_L   },  // ETHIOPIC SYLLABLE HHI
  { 0x1213, BIDI_L   },  // ETHIOPIC SYLLABLE HHAA
  { 0x1214, BIDI_L   },  // ETHIOPIC SYLLABLE HHEE
  { 0x1215, BIDI_L   },  // ETHIOPIC SYLLABLE HHE
  { 0x1216, BIDI_L   },  // ETHIOPIC SYLLABLE HHO
  { 0x1217, BIDI_L   },  // ETHIOPIC SYLLABLE HHWA
  { 0x1218, BIDI_L   },  // ETHIOPIC SYLLABLE MA
  { 0x1219, BIDI_L   },  // ETHIOPIC SYLLABLE MU
  { 0x121A, BIDI_L   },  // ETHIOPIC SYLLABLE MI
  { 0x121B, BIDI_L   },  // ETHIOPIC SYLLABLE MAA
  { 0x121C, BIDI_L   },  // ETHIOPIC SYLLABLE MEE
  { 0x121D, BIDI_L   },  // ETHIOPIC SYLLABLE ME
  { 0x121E, BIDI_L   },  // ETHIOPIC SYLLABLE MO
  { 0x121F, BIDI_L   },  // ETHIOPIC SYLLABLE MWA
  { 0x1220, BIDI_L   },  // ETHIOPIC SYLLABLE SZA
  { 0x1221, BIDI_L   },  // ETHIOPIC SYLLABLE SZU
  { 0x1222, BIDI_L   },  // ETHIOPIC SYLLABLE SZI
  { 0x1223, BIDI_L   },  // ETHIOPIC SYLLABLE SZAA
  { 0x1224, BIDI_L   },  // ETHIOPIC SYLLABLE SZEE
  { 0x1225, BIDI_L   },  // ETHIOPIC SYLLABLE SZE
  { 0x1226, BIDI_L   },  // ETHIOPIC SYLLABLE SZO
  { 0x1227, BIDI_L   },  // ETHIOPIC SYLLABLE SZWA
  { 0x1228, BIDI_L   },  // ETHIOPIC SYLLABLE RA
  { 0x1229, BIDI_L   },  // ETHIOPIC SYLLABLE RU
  { 0x122A, BIDI_L   },  // ETHIOPIC SYLLABLE RI
  { 0x122B, BIDI_L   },  // ETHIOPIC SYLLABLE RAA
  { 0x122C, BIDI_L   },  // ETHIOPIC SYLLABLE REE
  { 0x122D, BIDI_L   },  // ETHIOPIC SYLLABLE RE
  { 0x122E, BIDI_L   },  // ETHIOPIC SYLLABLE RO
  { 0x122F, BIDI_L   },  // ETHIOPIC SYLLABLE RWA
  { 0x1230, BIDI_L   },  // ETHIOPIC SYLLABLE SA
  { 0x1231, BIDI_L   },  // ETHIOPIC SYLLABLE SU
  { 0x1232, BIDI_L   },  // ETHIOPIC SYLLABLE SI
  { 0x1233, BIDI_L   },  // ETHIOPIC SYLLABLE SAA
  { 0x1234, BIDI_L   },  // ETHIOPIC SYLLABLE SEE
  { 0x1235, BIDI_L   },  // ETHIOPIC SYLLABLE SE
  { 0x1236, BIDI_L   },  // ETHIOPIC SYLLABLE SO
  { 0x1237, BIDI_L   },  // ETHIOPIC SYLLABLE SWA
  { 0x1238, BIDI_L   },  // ETHIOPIC SYLLABLE SHA
  { 0x1239, BIDI_L   },  // ETHIOPIC SYLLABLE SHU
  { 0x123A, BIDI_L   },  // ETHIOPIC SYLLABLE SHI
  { 0x123B, BIDI_L   },  // ETHIOPIC SYLLABLE SHAA
  { 0x123C, BIDI_L   },  // ETHIOPIC SYLLABLE SHEE
  { 0x123D, BIDI_L   },  // ETHIOPIC SYLLABLE SHE
  { 0x123E, BIDI_L   },  // ETHIOPIC SYLLABLE SHO
  { 0x123F, BIDI_L   },  // ETHIOPIC SYLLABLE SHWA
  { 0x1240, BIDI_L   },  // ETHIOPIC SYLLABLE QA
  { 0x1241, BIDI_L   },  // ETHIOPIC SYLLABLE QU
  { 0x1242, BIDI_L   },  // ETHIOPIC SYLLABLE QI
  { 0x1243, BIDI_L   },  // ETHIOPIC SYLLABLE QAA
  { 0x1244, BIDI_L   },  // ETHIOPIC SYLLABLE QEE
  { 0x1245, BIDI_L   },  // ETHIOPIC SYLLABLE QE
  { 0x1246, BIDI_L   },  // ETHIOPIC SYLLABLE QO
  { 0x1247, BIDI_L   },  // ETHIOPIC SYLLABLE QOA
  { 0x1248, BIDI_L   },  // ETHIOPIC SYLLABLE QWA
  { 0x124A, BIDI_L   },  // ETHIOPIC SYLLABLE QWI
  { 0x124B, BIDI_L   },  // ETHIOPIC SYLLABLE QWAA
  { 0x124C, BIDI_L   },  // ETHIOPIC SYLLABLE QWEE
  { 0x124D, BIDI_L   },  // ETHIOPIC SYLLABLE QWE
  { 0x1250, BIDI_L   },  // ETHIOPIC SYLLABLE QHA
  { 0x1251, BIDI_L   },  // ETHIOPIC SYLLABLE QHU
  { 0x1252, BIDI_L   },  // ETHIOPIC SYLLABLE QHI
  { 0x1253, BIDI_L   },  // ETHIOPIC SYLLABLE QHAA
  { 0x1254, BIDI_L   },  // ETHIOPIC SYLLABLE QHEE
  { 0x1255, BIDI_L   },  // ETHIOPIC SYLLABLE QHE
  { 0x1256, BIDI_L   },  // ETHIOPIC SYLLABLE QHO
  { 0x1258, BIDI_L   },  // ETHIOPIC SYLLABLE QHWA
  { 0x125A, BIDI_L   },  // ETHIOPIC SYLLABLE QHWI
  { 0x125B, BIDI_L   },  // ETHIOPIC SYLLABLE QHWAA
  { 0x125C, BIDI_L   },  // ETHIOPIC SYLLABLE QHWEE
  { 0x125D, BIDI_L   },  // ETHIOPIC SYLLABLE QHWE
  { 0x1260, BIDI_L   },  // ETHIOPIC SYLLABLE BA
  { 0x1261, BIDI_L   },  // ETHIOPIC SYLLABLE BU
  { 0x1262, BIDI_L   },  // ETHIOPIC SYLLABLE BI
  { 0x1263, BIDI_L   },  // ETHIOPIC SYLLABLE BAA
  { 0x1264, BIDI_L   },  // ETHIOPIC SYLLABLE BEE
  { 0x1265, BIDI_L   },  // ETHIOPIC SYLLABLE BE
  { 0x1266, BIDI_L   },  // ETHIOPIC SYLLABLE BO
  { 0x1267, BIDI_L   },  // ETHIOPIC SYLLABLE BWA
  { 0x1268, BIDI_L   },  // ETHIOPIC SYLLABLE VA
  { 0x1269, BIDI_L   },  // ETHIOPIC SYLLABLE VU
  { 0x126A, BIDI_L   },  // ETHIOPIC SYLLABLE VI
  { 0x126B, BIDI_L   },  // ETHIOPIC SYLLABLE VAA
  { 0x126C, BIDI_L   },  // ETHIOPIC SYLLABLE VEE
  { 0x126D, BIDI_L   },  // ETHIOPIC SYLLABLE VE
  { 0x126E, BIDI_L   },  // ETHIOPIC SYLLABLE VO
  { 0x126F, BIDI_L   },  // ETHIOPIC SYLLABLE VWA
  { 0x1270, BIDI_L   },  // ETHIOPIC SYLLABLE TA
  { 0x1271, BIDI_L   },  // ETHIOPIC SYLLABLE TU
  { 0x1272, BIDI_L   },  // ETHIOPIC SYLLABLE TI
  { 0x1273, BIDI_L   },  // ETHIOPIC SYLLABLE TAA
  { 0x1274, BIDI_L   },  // ETHIOPIC SYLLABLE TEE
  { 0x1275, BIDI_L   },  // ETHIOPIC SYLLABLE TE
  { 0x1276, BIDI_L   },  // ETHIOPIC SYLLABLE TO
  { 0x1277, BIDI_L   },  // ETHIOPIC SYLLABLE TWA
  { 0x1278, BIDI_L   },  // ETHIOPIC SYLLABLE CA
  { 0x1279, BIDI_L   },  // ETHIOPIC SYLLABLE CU
  { 0x127A, BIDI_L   },  // ETHIOPIC SYLLABLE CI
  { 0x127B, BIDI_L   },  // ETHIOPIC SYLLABLE CAA
  { 0x127C, BIDI_L   },  // ETHIOPIC SYLLABLE CEE
  { 0x127D, BIDI_L   },  // ETHIOPIC SYLLABLE CE
  { 0x127E, BIDI_L   },  // ETHIOPIC SYLLABLE CO
  { 0x127F, BIDI_L   },  // ETHIOPIC SYLLABLE CWA
  { 0x1280, BIDI_L   },  // ETHIOPIC SYLLABLE XA
  { 0x1281, BIDI_L   },  // ETHIOPIC SYLLABLE XU
  { 0x1282, BIDI_L   },  // ETHIOPIC SYLLABLE XI
  { 0x1283, BIDI_L   },  // ETHIOPIC SYLLABLE XAA
  { 0x1284, BIDI_L   },  // ETHIOPIC SYLLABLE XEE
  { 0x1285, BIDI_L   },  // ETHIOPIC SYLLABLE XE
  { 0x1286, BIDI_L   },  // ETHIOPIC SYLLABLE XO
  { 0x1287, BIDI_L   },  // ETHIOPIC SYLLABLE XOA
  { 0x1288, BIDI_L   },  // ETHIOPIC SYLLABLE XWA
  { 0x128A, BIDI_L   },  // ETHIOPIC SYLLABLE XWI
  { 0x128B, BIDI_L   },  // ETHIOPIC SYLLABLE XWAA
  { 0x128C, BIDI_L   },  // ETHIOPIC SYLLABLE XWEE
  { 0x128D, BIDI_L   },  // ETHIOPIC SYLLABLE XWE
  { 0x1290, BIDI_L   },  // ETHIOPIC SYLLABLE NA
  { 0x1291, BIDI_L   },  // ETHIOPIC SYLLABLE NU
  { 0x1292, BIDI_L   },  // ETHIOPIC SYLLABLE NI
  { 0x1293, BIDI_L   },  // ETHIOPIC SYLLABLE NAA
  { 0x1294, BIDI_L   },  // ETHIOPIC SYLLABLE NEE
  { 0x1295, BIDI_L   },  // ETHIOPIC SYLLABLE NE
  { 0x1296, BIDI_L   },  // ETHIOPIC SYLLABLE NO
  { 0x1297, BIDI_L   },  // ETHIOPIC SYLLABLE NWA
  { 0x1298, BIDI_L   },  // ETHIOPIC SYLLABLE NYA
  { 0x1299, BIDI_L   },  // ETHIOPIC SYLLABLE NYU
  { 0x129A, BIDI_L   },  // ETHIOPIC SYLLABLE NYI
  { 0x129B, BIDI_L   },  // ETHIOPIC SYLLABLE NYAA
  { 0x129C, BIDI_L   },  // ETHIOPIC SYLLABLE NYEE
  { 0x129D, BIDI_L   },  // ETHIOPIC SYLLABLE NYE
  { 0x129E, BIDI_L   },  // ETHIOPIC SYLLABLE NYO
  { 0x129F, BIDI_L   },  // ETHIOPIC SYLLABLE NYWA
  { 0x12A0, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL A
  { 0x12A1, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL U
  { 0x12A2, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL I
  { 0x12A3, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL AA
  { 0x12A4, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL EE
  { 0x12A5, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL E
  { 0x12A6, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL O
  { 0x12A7, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL WA
  { 0x12A8, BIDI_L   },  // ETHIOPIC SYLLABLE KA
  { 0x12A9, BIDI_L   },  // ETHIOPIC SYLLABLE KU
  { 0x12AA, BIDI_L   },  // ETHIOPIC SYLLABLE KI
  { 0x12AB, BIDI_L   },  // ETHIOPIC SYLLABLE KAA
  { 0x12AC, BIDI_L   },  // ETHIOPIC SYLLABLE KEE
  { 0x12AD, BIDI_L   },  // ETHIOPIC SYLLABLE KE
  { 0x12AE, BIDI_L   },  // ETHIOPIC SYLLABLE KO
  { 0x12AF, BIDI_L   },  // ETHIOPIC SYLLABLE KOA
  { 0x12B0, BIDI_L   },  // ETHIOPIC SYLLABLE KWA
  { 0x12B2, BIDI_L   },  // ETHIOPIC SYLLABLE KWI
  { 0x12B3, BIDI_L   },  // ETHIOPIC SYLLABLE KWAA
  { 0x12B4, BIDI_L   },  // ETHIOPIC SYLLABLE KWEE
  { 0x12B5, BIDI_L   },  // ETHIOPIC SYLLABLE KWE
  { 0x12B8, BIDI_L   },  // ETHIOPIC SYLLABLE KXA
  { 0x12B9, BIDI_L   },  // ETHIOPIC SYLLABLE KXU
  { 0x12BA, BIDI_L   },  // ETHIOPIC SYLLABLE KXI
  { 0x12BB, BIDI_L   },  // ETHIOPIC SYLLABLE KXAA
  { 0x12BC, BIDI_L   },  // ETHIOPIC SYLLABLE KXEE
  { 0x12BD, BIDI_L   },  // ETHIOPIC SYLLABLE KXE
  { 0x12BE, BIDI_L   },  // ETHIOPIC SYLLABLE KXO
  { 0x12C0, BIDI_L   },  // ETHIOPIC SYLLABLE KXWA
  { 0x12C2, BIDI_L   },  // ETHIOPIC SYLLABLE KXWI
  { 0x12C3, BIDI_L   },  // ETHIOPIC SYLLABLE KXWAA
  { 0x12C4, BIDI_L   },  // ETHIOPIC SYLLABLE KXWEE
  { 0x12C5, BIDI_L   },  // ETHIOPIC SYLLABLE KXWE
  { 0x12C8, BIDI_L   },  // ETHIOPIC SYLLABLE WA
  { 0x12C9, BIDI_L   },  // ETHIOPIC SYLLABLE WU
  { 0x12CA, BIDI_L   },  // ETHIOPIC SYLLABLE WI
  { 0x12CB, BIDI_L   },  // ETHIOPIC SYLLABLE WAA
  { 0x12CC, BIDI_L   },  // ETHIOPIC SYLLABLE WEE
  { 0x12CD, BIDI_L   },  // ETHIOPIC SYLLABLE WE
  { 0x12CE, BIDI_L   },  // ETHIOPIC SYLLABLE WO
  { 0x12CF, BIDI_L   },  // ETHIOPIC SYLLABLE WOA
  { 0x12D0, BIDI_L   },  // ETHIOPIC SYLLABLE PHARYNGEAL A
  { 0x12D1, BIDI_L   },  // ETHIOPIC SYLLABLE PHARYNGEAL U
  { 0x12D2, BIDI_L   },  // ETHIOPIC SYLLABLE PHARYNGEAL I
  { 0x12D3, BIDI_L   },  // ETHIOPIC SYLLABLE PHARYNGEAL AA
  { 0x12D4, BIDI_L   },  // ETHIOPIC SYLLABLE PHARYNGEAL EE
  { 0x12D5, BIDI_L   },  // ETHIOPIC SYLLABLE PHARYNGEAL E
  { 0x12D6, BIDI_L   },  // ETHIOPIC SYLLABLE PHARYNGEAL O
  { 0x12D8, BIDI_L   },  // ETHIOPIC SYLLABLE ZA
  { 0x12D9, BIDI_L   },  // ETHIOPIC SYLLABLE ZU
  { 0x12DA, BIDI_L   },  // ETHIOPIC SYLLABLE ZI
  { 0x12DB, BIDI_L   },  // ETHIOPIC SYLLABLE ZAA
  { 0x12DC, BIDI_L   },  // ETHIOPIC SYLLABLE ZEE
  { 0x12DD, BIDI_L   },  // ETHIOPIC SYLLABLE ZE
  { 0x12DE, BIDI_L   },  // ETHIOPIC SYLLABLE ZO
  { 0x12DF, BIDI_L   },  // ETHIOPIC SYLLABLE ZWA
  { 0x12E0, BIDI_L   },  // ETHIOPIC SYLLABLE ZHA
  { 0x12E1, BIDI_L   },  // ETHIOPIC SYLLABLE ZHU
  { 0x12E2, BIDI_L   },  // ETHIOPIC SYLLABLE ZHI
  { 0x12E3, BIDI_L   },  // ETHIOPIC SYLLABLE ZHAA
  { 0x12E4, BIDI_L   },  // ETHIOPIC SYLLABLE ZHEE
  { 0x12E5, BIDI_L   },  // ETHIOPIC SYLLABLE ZHE
  { 0x12E6, BIDI_L   },  // ETHIOPIC SYLLABLE ZHO
  { 0x12E7, BIDI_L   },  // ETHIOPIC SYLLABLE ZHWA
  { 0x12E8, BIDI_L   },  // ETHIOPIC SYLLABLE YA
  { 0x12E9, BIDI_L   },  // ETHIOPIC SYLLABLE YU
  { 0x12EA, BIDI_L   },  // ETHIOPIC SYLLABLE YI
  { 0x12EB, BIDI_L   },  // ETHIOPIC SYLLABLE YAA
  { 0x12EC, BIDI_L   },  // ETHIOPIC SYLLABLE YEE
  { 0x12ED, BIDI_L   },  // ETHIOPIC SYLLABLE YE
  { 0x12EE, BIDI_L   },  // ETHIOPIC SYLLABLE YO
  { 0x12EF, BIDI_L   },  // ETHIOPIC SYLLABLE YOA
  { 0x12F0, BIDI_L   },  // ETHIOPIC SYLLABLE DA
  { 0x12F1, BIDI_L   },  // ETHIOPIC SYLLABLE DU
  { 0x12F2, BIDI_L   },  // ETHIOPIC SYLLABLE DI
  { 0x12F3, BIDI_L   },  // ETHIOPIC SYLLABLE DAA
  { 0x12F4, BIDI_L   },  // ETHIOPIC SYLLABLE DEE
  { 0x12F5, BIDI_L   },  // ETHIOPIC SYLLABLE DE
  { 0x12F6, BIDI_L   },  // ETHIOPIC SYLLABLE DO
  { 0x12F7, BIDI_L   },  // ETHIOPIC SYLLABLE DWA
  { 0x12F8, BIDI_L   },  // ETHIOPIC SYLLABLE DDA
  { 0x12F9, BIDI_L   },  // ETHIOPIC SYLLABLE DDU
  { 0x12FA, BIDI_L   },  // ETHIOPIC SYLLABLE DDI
  { 0x12FB, BIDI_L   },  // ETHIOPIC SYLLABLE DDAA
  { 0x12FC, BIDI_L   },  // ETHIOPIC SYLLABLE DDEE
  { 0x12FD, BIDI_L   },  // ETHIOPIC SYLLABLE DDE
  { 0x12FE, BIDI_L   },  // ETHIOPIC SYLLABLE DDO
  { 0x12FF, BIDI_L   },  // ETHIOPIC SYLLABLE DDWA
  { 0x1300, BIDI_L   },  // ETHIOPIC SYLLABLE JA
  { 0x1301, BIDI_L   },  // ETHIOPIC SYLLABLE JU
  { 0x1302, BIDI_L   },  // ETHIOPIC SYLLABLE JI
  { 0x1303, BIDI_L   },  // ETHIOPIC SYLLABLE JAA
  { 0x1304, BIDI_L   },  // ETHIOPIC SYLLABLE JEE
  { 0x1305, BIDI_L   },  // ETHIOPIC SYLLABLE JE
  { 0x1306, BIDI_L   },  // ETHIOPIC SYLLABLE JO
  { 0x1307, BIDI_L   },  // ETHIOPIC SYLLABLE JWA
  { 0x1308, BIDI_L   },  // ETHIOPIC SYLLABLE GA
  { 0x1309, BIDI_L   },  // ETHIOPIC SYLLABLE GU
  { 0x130A, BIDI_L   },  // ETHIOPIC SYLLABLE GI
  { 0x130B, BIDI_L   },  // ETHIOPIC SYLLABLE GAA
  { 0x130C, BIDI_L   },  // ETHIOPIC SYLLABLE GEE
  { 0x130D, BIDI_L   },  // ETHIOPIC SYLLABLE GE
  { 0x130E, BIDI_L   },  // ETHIOPIC SYLLABLE GO
  { 0x130F, BIDI_L   },  // ETHIOPIC SYLLABLE GOA
  { 0x1310, BIDI_L   },  // ETHIOPIC SYLLABLE GWA
  { 0x1312, BIDI_L   },  // ETHIOPIC SYLLABLE GWI
  { 0x1313, BIDI_L   },  // ETHIOPIC SYLLABLE GWAA
  { 0x1314, BIDI_L   },  // ETHIOPIC SYLLABLE GWEE
  { 0x1315, BIDI_L   },  // ETHIOPIC SYLLABLE GWE
  { 0x1318, BIDI_L   },  // ETHIOPIC SYLLABLE GGA
  { 0x1319, BIDI_L   },  // ETHIOPIC SYLLABLE GGU
  { 0x131A, BIDI_L   },  // ETHIOPIC SYLLABLE GGI
  { 0x131B, BIDI_L   },  // ETHIOPIC SYLLABLE GGAA
  { 0x131C, BIDI_L   },  // ETHIOPIC SYLLABLE GGEE
  { 0x131D, BIDI_L   },  // ETHIOPIC SYLLABLE GGE
  { 0x131E, BIDI_L   },  // ETHIOPIC SYLLABLE GGO
  { 0x131F, BIDI_L   },  // ETHIOPIC SYLLABLE GGWAA
  { 0x1320, BIDI_L   },  // ETHIOPIC SYLLABLE THA
  { 0x1321, BIDI_L   },  // ETHIOPIC SYLLABLE THU
  { 0x1322, BIDI_L   },  // ETHIOPIC SYLLABLE THI
  { 0x1323, BIDI_L   },  // ETHIOPIC SYLLABLE THAA
  { 0x1324, BIDI_L   },  // ETHIOPIC SYLLABLE THEE
  { 0x1325, BIDI_L   },  // ETHIOPIC SYLLABLE THE
  { 0x1326, BIDI_L   },  // ETHIOPIC SYLLABLE THO
  { 0x1327, BIDI_L   },  // ETHIOPIC SYLLABLE THWA
  { 0x1328, BIDI_L   },  // ETHIOPIC SYLLABLE CHA
  { 0x1329, BIDI_L   },  // ETHIOPIC SYLLABLE CHU
  { 0x132A, BIDI_L   },  // ETHIOPIC SYLLABLE CHI
  { 0x132B, BIDI_L   },  // ETHIOPIC SYLLABLE CHAA
  { 0x132C, BIDI_L   },  // ETHIOPIC SYLLABLE CHEE
  { 0x132D, BIDI_L   },  // ETHIOPIC SYLLABLE CHE
  { 0x132E, BIDI_L   },  // ETHIOPIC SYLLABLE CHO
  { 0x132F, BIDI_L   },  // ETHIOPIC SYLLABLE CHWA
  { 0x1330, BIDI_L   },  // ETHIOPIC SYLLABLE PHA
  { 0x1331, BIDI_L   },  // ETHIOPIC SYLLABLE PHU
  { 0x1332, BIDI_L   },  // ETHIOPIC SYLLABLE PHI
  { 0x1333, BIDI_L   },  // ETHIOPIC SYLLABLE PHAA
  { 0x1334, BIDI_L   },  // ETHIOPIC SYLLABLE PHEE
  { 0x1335, BIDI_L   },  // ETHIOPIC SYLLABLE PHE
  { 0x1336, BIDI_L   },  // ETHIOPIC SYLLABLE PHO
  { 0x1337, BIDI_L   },  // ETHIOPIC SYLLABLE PHWA
  { 0x1338, BIDI_L   },  // ETHIOPIC SYLLABLE TSA
  { 0x1339, BIDI_L   },  // ETHIOPIC SYLLABLE TSU
  { 0x133A, BIDI_L   },  // ETHIOPIC SYLLABLE TSI
  { 0x133B, BIDI_L   },  // ETHIOPIC SYLLABLE TSAA
  { 0x133C, BIDI_L   },  // ETHIOPIC SYLLABLE TSEE
  { 0x133D, BIDI_L   },  // ETHIOPIC SYLLABLE TSE
  { 0x133E, BIDI_L   },  // ETHIOPIC SYLLABLE TSO
  { 0x133F, BIDI_L   },  // ETHIOPIC SYLLABLE TSWA
  { 0x1340, BIDI_L   },  // ETHIOPIC SYLLABLE TZA
  { 0x1341, BIDI_L   },  // ETHIOPIC SYLLABLE TZU
  { 0x1342, BIDI_L   },  // ETHIOPIC SYLLABLE TZI
  { 0x1343, BIDI_L   },  // ETHIOPIC SYLLABLE TZAA
  { 0x1344, BIDI_L   },  // ETHIOPIC SYLLABLE TZEE
  { 0x1345, BIDI_L   },  // ETHIOPIC SYLLABLE TZE
  { 0x1346, BIDI_L   },  // ETHIOPIC SYLLABLE TZO
  { 0x1347, BIDI_L   },  // ETHIOPIC SYLLABLE TZOA
  { 0x1348, BIDI_L   },  // ETHIOPIC SYLLABLE FA
  { 0x1349, BIDI_L   },  // ETHIOPIC SYLLABLE FU
  { 0x134A, BIDI_L   },  // ETHIOPIC SYLLABLE FI
  { 0x134B, BIDI_L   },  // ETHIOPIC SYLLABLE FAA
  { 0x134C, BIDI_L   },  // ETHIOPIC SYLLABLE FEE
  { 0x134D, BIDI_L   },  // ETHIOPIC SYLLABLE FE
  { 0x134E, BIDI_L   },  // ETHIOPIC SYLLABLE FO
  { 0x134F, BIDI_L   },  // ETHIOPIC SYLLABLE FWA
  { 0x1350, BIDI_L   },  // ETHIOPIC SYLLABLE PA
  { 0x1351, BIDI_L   },  // ETHIOPIC SYLLABLE PU
  { 0x1352, BIDI_L   },  // ETHIOPIC SYLLABLE PI
  { 0x1353, BIDI_L   },  // ETHIOPIC SYLLABLE PAA
  { 0x1354, BIDI_L   },  // ETHIOPIC SYLLABLE PEE
  { 0x1355, BIDI_L   },  // ETHIOPIC SYLLABLE PE
  { 0x1356, BIDI_L   },  // ETHIOPIC SYLLABLE PO
  { 0x1357, BIDI_L   },  // ETHIOPIC SYLLABLE PWA
  { 0x1358, BIDI_L   },  // ETHIOPIC SYLLABLE RYA
  { 0x1359, BIDI_L   },  // ETHIOPIC SYLLABLE MYA
  { 0x135A, BIDI_L   },  // ETHIOPIC SYLLABLE FYA
  { 0x135D, BIDI_NSM },  // ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK
  { 0x135E, BIDI_NSM },  // ETHIOPIC COMBINING VOWEL LENGTH MARK
  { 0x135F, BIDI_NSM },  // ETHIOPIC COMBINING GEMINATION MARK
  { 0x1360, BIDI_L   },  // ETHIOPIC SECTION MARK
  { 0x1361, BIDI_L   },  // ETHIOPIC WORDSPACE
  { 0x1362, BIDI_L   },  // ETHIOPIC FULL STOP
  { 0x1363, BIDI_L   },  // ETHIOPIC COMMA
  { 0x1364, BIDI_L   },  // ETHIOPIC SEMICOLON
  { 0x1365, BIDI_L   },  // ETHIOPIC COLON
  { 0x1366, BIDI_L   },  // ETHIOPIC PREFACE COLON
  { 0x1367, BIDI_L   },  // ETHIOPIC QUESTION MARK
  { 0x1368, BIDI_L   },  // ETHIOPIC PARAGRAPH SEPARATOR
  { 0x1369, BIDI_L   },  // ETHIOPIC DIGIT ONE
  { 0x136A, BIDI_L   },  // ETHIOPIC DIGIT TWO
  { 0x136B, BIDI_L   },  // ETHIOPIC DIGIT THREE
  { 0x136C, BIDI_L   },  // ETHIOPIC DIGIT FOUR
  { 0x136D, BIDI_L   },  // ETHIOPIC DIGIT FIVE
  { 0x136E, BIDI_L   },  // ETHIOPIC DIGIT SIX
  { 0x136F, BIDI_L   },  // ETHIOPIC DIGIT SEVEN
  { 0x1370, BIDI_L   },  // ETHIOPIC DIGIT EIGHT
  { 0x1371, BIDI_L   },  // ETHIOPIC DIGIT NINE
  { 0x1372, BIDI_L   },  // ETHIOPIC NUMBER TEN
  { 0x1373, BIDI_L   },  // ETHIOPIC NUMBER TWENTY
  { 0x1374, BIDI_L   },  // ETHIOPIC NUMBER THIRTY
  { 0x1375, BIDI_L   },  // ETHIOPIC NUMBER FORTY
  { 0x1376, BIDI_L   },  // ETHIOPIC NUMBER FIFTY
  { 0x1377, BIDI_L   },  // ETHIOPIC NUMBER SIXTY
  { 0x1378, BIDI_L   },  // ETHIOPIC NUMBER SEVENTY
  { 0x1379, BIDI_L   },  // ETHIOPIC NUMBER EIGHTY
  { 0x137A, BIDI_L   },  // ETHIOPIC NUMBER NINETY
  { 0x137B, BIDI_L   },  // ETHIOPIC NUMBER HUNDRED
  { 0x137C, BIDI_L   },  // ETHIOPIC NUMBER TEN THOUSAND
  { 0x1380, BIDI_L   },  // ETHIOPIC SYLLABLE SEBATBEIT MWA
  { 0x1381, BIDI_L   },  // ETHIOPIC SYLLABLE MWI
  { 0x1382, BIDI_L   },  // ETHIOPIC SYLLABLE MWEE
  { 0x1383, BIDI_L   },  // ETHIOPIC SYLLABLE MWE
  { 0x1384, BIDI_L   },  // ETHIOPIC SYLLABLE SEBATBEIT BWA
  { 0x1385, BIDI_L   },  // ETHIOPIC SYLLABLE BWI
  { 0x1386, BIDI_L   },  // ETHIOPIC SYLLABLE BWEE
  { 0x1387, BIDI_L   },  // ETHIOPIC SYLLABLE BWE
  { 0x1388, BIDI_L   },  // ETHIOPIC SYLLABLE SEBATBEIT FWA
  { 0x1389, BIDI_L   },  // ETHIOPIC SYLLABLE FWI
  { 0x138A, BIDI_L   },  // ETHIOPIC SYLLABLE FWEE
  { 0x138B, BIDI_L   },  // ETHIOPIC SYLLABLE FWE
  { 0x138C, BIDI_L   },  // ETHIOPIC SYLLABLE SEBATBEIT PWA
  { 0x138D, BIDI_L   },  // ETHIOPIC SYLLABLE PWI
  { 0x138E, BIDI_L   },  // ETHIOPIC SYLLABLE PWEE
  { 0x138F, BIDI_L   },  // ETHIOPIC SYLLABLE PWE
  { 0x1390, BIDI_ON  },  // ETHIOPIC TONAL MARK YIZET
  { 0x1391, BIDI_ON  },  // ETHIOPIC TONAL MARK DERET
  { 0x1392, BIDI_ON  },  // ETHIOPIC TONAL MARK RIKRIK
  { 0x1393, BIDI_ON  },  // ETHIOPIC TONAL MARK SHORT RIKRIK
  { 0x1394, BIDI_ON  },  // ETHIOPIC TONAL MARK DIFAT
  { 0x1395, BIDI_ON  },  // ETHIOPIC TONAL MARK KENAT
  { 0x1396, BIDI_ON  },  // ETHIOPIC TONAL MARK CHIRET
  { 0x1397, BIDI_ON  },  // ETHIOPIC TONAL MARK HIDET
  { 0x1398, BIDI_ON  },  // ETHIOPIC TONAL MARK DERET-HIDET
  { 0x1399, BIDI_ON  },  // ETHIOPIC TONAL MARK KURT
  { 0x13A0, BIDI_L   },  // CHEROKEE LETTER A
  { 0x13A1, BIDI_L   },  // CHEROKEE LETTER E
  { 0x13A2, BIDI_L   },  // CHEROKEE LETTER I
  { 0x13A3, BIDI_L   },  // CHEROKEE LETTER O
  { 0x13A4, BIDI_L   },  // CHEROKEE LETTER U
  { 0x13A5, BIDI_L   },  // CHEROKEE LETTER V
  { 0x13A6, BIDI_L   },  // CHEROKEE LETTER GA
  { 0x13A7, BIDI_L   },  // CHEROKEE LETTER KA
  { 0x13A8, BIDI_L   },  // CHEROKEE LETTER GE
  { 0x13A9, BIDI_L   },  // CHEROKEE LETTER GI
  { 0x13AA, BIDI_L   },  // CHEROKEE LETTER GO
  { 0x13AB, BIDI_L   },  // CHEROKEE LETTER GU
  { 0x13AC, BIDI_L   },  // CHEROKEE LETTER GV
  { 0x13AD, BIDI_L   },  // CHEROKEE LETTER HA
  { 0x13AE, BIDI_L   },  // CHEROKEE LETTER HE
  { 0x13AF, BIDI_L   },  // CHEROKEE LETTER HI
  { 0x13B0, BIDI_L   },  // CHEROKEE LETTER HO
  { 0x13B1, BIDI_L   },  // CHEROKEE LETTER HU
  { 0x13B2, BIDI_L   },  // CHEROKEE LETTER HV
  { 0x13B3, BIDI_L   },  // CHEROKEE LETTER LA
  { 0x13B4, BIDI_L   },  // CHEROKEE LETTER LE
  { 0x13B5, BIDI_L   },  // CHEROKEE LETTER LI
  { 0x13B6, BIDI_L   },  // CHEROKEE LETTER LO
  { 0x13B7, BIDI_L   },  // CHEROKEE LETTER LU
  { 0x13B8, BIDI_L   },  // CHEROKEE LETTER LV
  { 0x13B9, BIDI_L   },  // CHEROKEE LETTER MA
  { 0x13BA, BIDI_L   },  // CHEROKEE LETTER ME
  { 0x13BB, BIDI_L   },  // CHEROKEE LETTER MI
  { 0x13BC, BIDI_L   },  // CHEROKEE LETTER MO
  { 0x13BD, BIDI_L   },  // CHEROKEE LETTER MU
  { 0x13BE, BIDI_L   },  // CHEROKEE LETTER NA
  { 0x13BF, BIDI_L   },  // CHEROKEE LETTER HNA
  { 0x13C0, BIDI_L   },  // CHEROKEE LETTER NAH
  { 0x13C1, BIDI_L   },  // CHEROKEE LETTER NE
  { 0x13C2, BIDI_L   },  // CHEROKEE LETTER NI
  { 0x13C3, BIDI_L   },  // CHEROKEE LETTER NO
  { 0x13C4, BIDI_L   },  // CHEROKEE LETTER NU
  { 0x13C5, BIDI_L   },  // CHEROKEE LETTER NV
  { 0x13C6, BIDI_L   },  // CHEROKEE LETTER QUA
  { 0x13C7, BIDI_L   },  // CHEROKEE LETTER QUE
  { 0x13C8, BIDI_L   },  // CHEROKEE LETTER QUI
  { 0x13C9, BIDI_L   },  // CHEROKEE LETTER QUO
  { 0x13CA, BIDI_L   },  // CHEROKEE LETTER QUU
  { 0x13CB, BIDI_L   },  // CHEROKEE LETTER QUV
  { 0x13CC, BIDI_L   },  // CHEROKEE LETTER SA
  { 0x13CD, BIDI_L   },  // CHEROKEE LETTER S
  { 0x13CE, BIDI_L   },  // CHEROKEE LETTER SE
  { 0x13CF, BIDI_L   },  // CHEROKEE LETTER SI
  { 0x13D0, BIDI_L   },  // CHEROKEE LETTER SO
  { 0x13D1, BIDI_L   },  // CHEROKEE LETTER SU
  { 0x13D2, BIDI_L   },  // CHEROKEE LETTER SV
  { 0x13D3, BIDI_L   },  // CHEROKEE LETTER DA
  { 0x13D4, BIDI_L   },  // CHEROKEE LETTER TA
  { 0x13D5, BIDI_L   },  // CHEROKEE LETTER DE
  { 0x13D6, BIDI_L   },  // CHEROKEE LETTER TE
  { 0x13D7, BIDI_L   },  // CHEROKEE LETTER DI
  { 0x13D8, BIDI_L   },  // CHEROKEE LETTER TI
  { 0x13D9, BIDI_L   },  // CHEROKEE LETTER DO
  { 0x13DA, BIDI_L   },  // CHEROKEE LETTER DU
  { 0x13DB, BIDI_L   },  // CHEROKEE LETTER DV
  { 0x13DC, BIDI_L   },  // CHEROKEE LETTER DLA
  { 0x13DD, BIDI_L   },  // CHEROKEE LETTER TLA
  { 0x13DE, BIDI_L   },  // CHEROKEE LETTER TLE
  { 0x13DF, BIDI_L   },  // CHEROKEE LETTER TLI
  { 0x13E0, BIDI_L   },  // CHEROKEE LETTER TLO
  { 0x13E1, BIDI_L   },  // CHEROKEE LETTER TLU
  { 0x13E2, BIDI_L   },  // CHEROKEE LETTER TLV
  { 0x13E3, BIDI_L   },  // CHEROKEE LETTER TSA
  { 0x13E4, BIDI_L   },  // CHEROKEE LETTER TSE
  { 0x13E5, BIDI_L   },  // CHEROKEE LETTER TSI
  { 0x13E6, BIDI_L   },  // CHEROKEE LETTER TSO
  { 0x13E7, BIDI_L   },  // CHEROKEE LETTER TSU
  { 0x13E8, BIDI_L   },  // CHEROKEE LETTER TSV
  { 0x13E9, BIDI_L   },  // CHEROKEE LETTER WA
  { 0x13EA, BIDI_L   },  // CHEROKEE LETTER WE
  { 0x13EB, BIDI_L   },  // CHEROKEE LETTER WI
  { 0x13EC, BIDI_L   },  // CHEROKEE LETTER WO
  { 0x13ED, BIDI_L   },  // CHEROKEE LETTER WU
  { 0x13EE, BIDI_L   },  // CHEROKEE LETTER WV
  { 0x13EF, BIDI_L   },  // CHEROKEE LETTER YA
  { 0x13F0, BIDI_L   },  // CHEROKEE LETTER YE
  { 0x13F1, BIDI_L   },  // CHEROKEE LETTER YI
  { 0x13F2, BIDI_L   },  // CHEROKEE LETTER YO
  { 0x13F3, BIDI_L   },  // CHEROKEE LETTER YU
  { 0x13F4, BIDI_L   },  // CHEROKEE LETTER YV
  { 0x13F5, BIDI_L   },  // CHEROKEE LETTER MV
  { 0x13F8, BIDI_L   },  // CHEROKEE SMALL LETTER YE
  { 0x13F9, BIDI_L   },  // CHEROKEE SMALL LETTER YI
  { 0x13FA, BIDI_L   },  // CHEROKEE SMALL LETTER YO
  { 0x13FB, BIDI_L   },  // CHEROKEE SMALL LETTER YU
  { 0x13FC, BIDI_L   },  // CHEROKEE SMALL LETTER YV
  { 0x13FD, BIDI_L   },  // CHEROKEE SMALL LETTER MV
  { 0x1400, BIDI_ON  },  // CANADIAN SYLLABICS HYPHEN
  { 0x1401, BIDI_L   },  // CANADIAN SYLLABICS E
  { 0x1402, BIDI_L   },  // CANADIAN SYLLABICS AAI
  { 0x1403, BIDI_L   },  // CANADIAN SYLLABICS I
  { 0x1404, BIDI_L   },  // CANADIAN SYLLABICS II
  { 0x1405, BIDI_L   },  // CANADIAN SYLLABICS O
  { 0x1406, BIDI_L   },  // CANADIAN SYLLABICS OO
  { 0x1407, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE OO
  { 0x1408, BIDI_L   },  // CANADIAN SYLLABICS CARRIER EE
  { 0x1409, BIDI_L   },  // CANADIAN SYLLABICS CARRIER I
  { 0x140A, BIDI_L   },  // CANADIAN SYLLABICS A
  { 0x140B, BIDI_L   },  // CANADIAN SYLLABICS AA
  { 0x140C, BIDI_L   },  // CANADIAN SYLLABICS WE
  { 0x140D, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE WE
  { 0x140E, BIDI_L   },  // CANADIAN SYLLABICS WI
  { 0x140F, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE WI
  { 0x1410, BIDI_L   },  // CANADIAN SYLLABICS WII
  { 0x1411, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE WII
  { 0x1412, BIDI_L   },  // CANADIAN SYLLABICS WO
  { 0x1413, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE WO
  { 0x1414, BIDI_L   },  // CANADIAN SYLLABICS WOO
  { 0x1415, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE WOO
  { 0x1416, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI WOO
  { 0x1417, BIDI_L   },  // CANADIAN SYLLABICS WA
  { 0x1418, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE WA
  { 0x1419, BIDI_L   },  // CANADIAN SYLLABICS WAA
  { 0x141A, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE WAA
  { 0x141B, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI WAA
  { 0x141C, BIDI_L   },  // CANADIAN SYLLABICS AI
  { 0x141D, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE W
  { 0x141E, BIDI_L   },  // CANADIAN SYLLABICS GLOTTAL STOP
  { 0x141F, BIDI_L   },  // CANADIAN SYLLABICS FINAL ACUTE
  { 0x1420, BIDI_L   },  // CANADIAN SYLLABICS FINAL GRAVE
  { 0x1421, BIDI_L   },  // CANADIAN SYLLABICS FINAL BOTTOM HALF RING
  { 0x1422, BIDI_L   },  // CANADIAN SYLLABICS FINAL TOP HALF RING
  { 0x1423, BIDI_L   },  // CANADIAN SYLLABICS FINAL RIGHT HALF RING
  { 0x1424, BIDI_L   },  // CANADIAN SYLLABICS FINAL RING
  { 0x1425, BIDI_L   },  // CANADIAN SYLLABICS FINAL DOUBLE ACUTE
  { 0x1426, BIDI_L   },  // CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES
  { 0x1427, BIDI_L   },  // CANADIAN SYLLABICS FINAL MIDDLE DOT
  { 0x1428, BIDI_L   },  // CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE
  { 0x1429, BIDI_L   },  // CANADIAN SYLLABICS FINAL PLUS
  { 0x142A, BIDI_L   },  // CANADIAN SYLLABICS FINAL DOWN TACK
  { 0x142B, BIDI_L   },  // CANADIAN SYLLABICS EN
  { 0x142C, BIDI_L   },  // CANADIAN SYLLABICS IN
  { 0x142D, BIDI_L   },  // CANADIAN SYLLABICS ON
  { 0x142E, BIDI_L   },  // CANADIAN SYLLABICS AN
  { 0x142F, BIDI_L   },  // CANADIAN SYLLABICS PE
  { 0x1430, BIDI_L   },  // CANADIAN SYLLABICS PAAI
  { 0x1431, BIDI_L   },  // CANADIAN SYLLABICS PI
  { 0x1432, BIDI_L   },  // CANADIAN SYLLABICS PII
  { 0x1433, BIDI_L   },  // CANADIAN SYLLABICS PO
  { 0x1434, BIDI_L   },  // CANADIAN SYLLABICS POO
  { 0x1435, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE POO
  { 0x1436, BIDI_L   },  // CANADIAN SYLLABICS CARRIER HEE
  { 0x1437, BIDI_L   },  // CANADIAN SYLLABICS CARRIER HI
  { 0x1438, BIDI_L   },  // CANADIAN SYLLABICS PA
  { 0x1439, BIDI_L   },  // CANADIAN SYLLABICS PAA
  { 0x143A, BIDI_L   },  // CANADIAN SYLLABICS PWE
  { 0x143B, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE PWE
  { 0x143C, BIDI_L   },  // CANADIAN SYLLABICS PWI
  { 0x143D, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE PWI
  { 0x143E, BIDI_L   },  // CANADIAN SYLLABICS PWII
  { 0x143F, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE PWII
  { 0x1440, BIDI_L   },  // CANADIAN SYLLABICS PWO
  { 0x1441, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE PWO
  { 0x1442, BIDI_L   },  // CANADIAN SYLLABICS PWOO
  { 0x1443, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE PWOO
  { 0x1444, BIDI_L   },  // CANADIAN SYLLABICS PWA
  { 0x1445, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE PWA
  { 0x1446, BIDI_L   },  // CANADIAN SYLLABICS PWAA
  { 0x1447, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE PWAA
  { 0x1448, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE PWAA
  { 0x1449, BIDI_L   },  // CANADIAN SYLLABICS P
  { 0x144A, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE P
  { 0x144B, BIDI_L   },  // CANADIAN SYLLABICS CARRIER H
  { 0x144C, BIDI_L   },  // CANADIAN SYLLABICS TE
  { 0x144D, BIDI_L   },  // CANADIAN SYLLABICS TAAI
  { 0x144E, BIDI_L   },  // CANADIAN SYLLABICS TI
  { 0x144F, BIDI_L   },  // CANADIAN SYLLABICS TII
  { 0x1450, BIDI_L   },  // CANADIAN SYLLABICS TO
  { 0x1451, BIDI_L   },  // CANADIAN SYLLABICS TOO
  { 0x1452, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE TOO
  { 0x1453, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DEE
  { 0x1454, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DI
  { 0x1455, BIDI_L   },  // CANADIAN SYLLABICS TA
  { 0x1456, BIDI_L   },  // CANADIAN SYLLABICS TAA
  { 0x1457, BIDI_L   },  // CANADIAN SYLLABICS TWE
  { 0x1458, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE TWE
  { 0x1459, BIDI_L   },  // CANADIAN SYLLABICS TWI
  { 0x145A, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE TWI
  { 0x145B, BIDI_L   },  // CANADIAN SYLLABICS TWII
  { 0x145C, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE TWII
  { 0x145D, BIDI_L   },  // CANADIAN SYLLABICS TWO
  { 0x145E, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE TWO
  { 0x145F, BIDI_L   },  // CANADIAN SYLLABICS TWOO
  { 0x1460, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE TWOO
  { 0x1461, BIDI_L   },  // CANADIAN SYLLABICS TWA
  { 0x1462, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE TWA
  { 0x1463, BIDI_L   },  // CANADIAN SYLLABICS TWAA
  { 0x1464, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE TWAA
  { 0x1465, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI TWAA
  { 0x1466, BIDI_L   },  // CANADIAN SYLLABICS T
  { 0x1467, BIDI_L   },  // CANADIAN SYLLABICS TTE
  { 0x1468, BIDI_L   },  // CANADIAN SYLLABICS TTI
  { 0x1469, BIDI_L   },  // CANADIAN SYLLABICS TTO
  { 0x146A, BIDI_L   },  // CANADIAN SYLLABICS TTA
  { 0x146B, BIDI_L   },  // CANADIAN SYLLABICS KE
  { 0x146C, BIDI_L   },  // CANADIAN SYLLABICS KAAI
  { 0x146D, BIDI_L   },  // CANADIAN SYLLABICS KI
  { 0x146E, BIDI_L   },  // CANADIAN SYLLABICS KII
  { 0x146F, BIDI_L   },  // CANADIAN SYLLABICS KO
  { 0x1470, BIDI_L   },  // CANADIAN SYLLABICS KOO
  { 0x1471, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE KOO
  { 0x1472, BIDI_L   },  // CANADIAN SYLLABICS KA
  { 0x1473, BIDI_L   },  // CANADIAN SYLLABICS KAA
  { 0x1474, BIDI_L   },  // CANADIAN SYLLABICS KWE
  { 0x1475, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE KWE
  { 0x1476, BIDI_L   },  // CANADIAN SYLLABICS KWI
  { 0x1477, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE KWI
  { 0x1478, BIDI_L   },  // CANADIAN SYLLABICS KWII
  { 0x1479, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE KWII
  { 0x147A, BIDI_L   },  // CANADIAN SYLLABICS KWO
  { 0x147B, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE KWO
  { 0x147C, BIDI_L   },  // CANADIAN SYLLABICS KWOO
  { 0x147D, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE KWOO
  { 0x147E, BIDI_L   },  // CANADIAN SYLLABICS KWA
  { 0x147F, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE KWA
  { 0x1480, BIDI_L   },  // CANADIAN SYLLABICS KWAA
  { 0x1481, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE KWAA
  { 0x1482, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI KWAA
  { 0x1483, BIDI_L   },  // CANADIAN SYLLABICS K
  { 0x1484, BIDI_L   },  // CANADIAN SYLLABICS KW
  { 0x1485, BIDI_L   },  // CANADIAN SYLLABICS SOUTH-SLAVEY KEH
  { 0x1486, BIDI_L   },  // CANADIAN SYLLABICS SOUTH-SLAVEY KIH
  { 0x1487, BIDI_L   },  // CANADIAN SYLLABICS SOUTH-SLAVEY KOH
  { 0x1488, BIDI_L   },  // CANADIAN SYLLABICS SOUTH-SLAVEY KAH
  { 0x1489, BIDI_L   },  // CANADIAN SYLLABICS CE
  { 0x148A, BIDI_L   },  // CANADIAN SYLLABICS CAAI
  { 0x148B, BIDI_L   },  // CANADIAN SYLLABICS CI
  { 0x148C, BIDI_L   },  // CANADIAN SYLLABICS CII
  { 0x148D, BIDI_L   },  // CANADIAN SYLLABICS CO
  { 0x148E, BIDI_L   },  // CANADIAN SYLLABICS COO
  { 0x148F, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE COO
  { 0x1490, BIDI_L   },  // CANADIAN SYLLABICS CA
  { 0x1491, BIDI_L   },  // CANADIAN SYLLABICS CAA
  { 0x1492, BIDI_L   },  // CANADIAN SYLLABICS CWE
  { 0x1493, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE CWE
  { 0x1494, BIDI_L   },  // CANADIAN SYLLABICS CWI
  { 0x1495, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE CWI
  { 0x1496, BIDI_L   },  // CANADIAN SYLLABICS CWII
  { 0x1497, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE CWII
  { 0x1498, BIDI_L   },  // CANADIAN SYLLABICS CWO
  { 0x1499, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE CWO
  { 0x149A, BIDI_L   },  // CANADIAN SYLLABICS CWOO
  { 0x149B, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE CWOO
  { 0x149C, BIDI_L   },  // CANADIAN SYLLABICS CWA
  { 0x149D, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE CWA
  { 0x149E, BIDI_L   },  // CANADIAN SYLLABICS CWAA
  { 0x149F, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE CWAA
  { 0x14A0, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI CWAA
  { 0x14A1, BIDI_L   },  // CANADIAN SYLLABICS C
  { 0x14A2, BIDI_L   },  // CANADIAN SYLLABICS SAYISI TH
  { 0x14A3, BIDI_L   },  // CANADIAN SYLLABICS ME
  { 0x14A4, BIDI_L   },  // CANADIAN SYLLABICS MAAI
  { 0x14A5, BIDI_L   },  // CANADIAN SYLLABICS MI
  { 0x14A6, BIDI_L   },  // CANADIAN SYLLABICS MII
  { 0x14A7, BIDI_L   },  // CANADIAN SYLLABICS MO
  { 0x14A8, BIDI_L   },  // CANADIAN SYLLABICS MOO
  { 0x14A9, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE MOO
  { 0x14AA, BIDI_L   },  // CANADIAN SYLLABICS MA
  { 0x14AB, BIDI_L   },  // CANADIAN SYLLABICS MAA
  { 0x14AC, BIDI_L   },  // CANADIAN SYLLABICS MWE
  { 0x14AD, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE MWE
  { 0x14AE, BIDI_L   },  // CANADIAN SYLLABICS MWI
  { 0x14AF, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE MWI
  { 0x14B0, BIDI_L   },  // CANADIAN SYLLABICS MWII
  { 0x14B1, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE MWII
  { 0x14B2, BIDI_L   },  // CANADIAN SYLLABICS MWO
  { 0x14B3, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE MWO
  { 0x14B4, BIDI_L   },  // CANADIAN SYLLABICS MWOO
  { 0x14B5, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE MWOO
  { 0x14B6, BIDI_L   },  // CANADIAN SYLLABICS MWA
  { 0x14B7, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE MWA
  { 0x14B8, BIDI_L   },  // CANADIAN SYLLABICS MWAA
  { 0x14B9, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE MWAA
  { 0x14BA, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI MWAA
  { 0x14BB, BIDI_L   },  // CANADIAN SYLLABICS M
  { 0x14BC, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE M
  { 0x14BD, BIDI_L   },  // CANADIAN SYLLABICS MH
  { 0x14BE, BIDI_L   },  // CANADIAN SYLLABICS ATHAPASCAN M
  { 0x14BF, BIDI_L   },  // CANADIAN SYLLABICS SAYISI M
  { 0x14C0, BIDI_L   },  // CANADIAN SYLLABICS NE
  { 0x14C1, BIDI_L   },  // CANADIAN SYLLABICS NAAI
  { 0x14C2, BIDI_L   },  // CANADIAN SYLLABICS NI
  { 0x14C3, BIDI_L   },  // CANADIAN SYLLABICS NII
  { 0x14C4, BIDI_L   },  // CANADIAN SYLLABICS NO
  { 0x14C5, BIDI_L   },  // CANADIAN SYLLABICS NOO
  { 0x14C6, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE NOO
  { 0x14C7, BIDI_L   },  // CANADIAN SYLLABICS NA
  { 0x14C8, BIDI_L   },  // CANADIAN SYLLABICS NAA
  { 0x14C9, BIDI_L   },  // CANADIAN SYLLABICS NWE
  { 0x14CA, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE NWE
  { 0x14CB, BIDI_L   },  // CANADIAN SYLLABICS NWA
  { 0x14CC, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE NWA
  { 0x14CD, BIDI_L   },  // CANADIAN SYLLABICS NWAA
  { 0x14CE, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE NWAA
  { 0x14CF, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI NWAA
  { 0x14D0, BIDI_L   },  // CANADIAN SYLLABICS N
  { 0x14D1, BIDI_L   },  // CANADIAN SYLLABICS CARRIER NG
  { 0x14D2, BIDI_L   },  // CANADIAN SYLLABICS NH
  { 0x14D3, BIDI_L   },  // CANADIAN SYLLABICS LE
  { 0x14D4, BIDI_L   },  // CANADIAN SYLLABICS LAAI
  { 0x14D5, BIDI_L   },  // CANADIAN SYLLABICS LI
  { 0x14D6, BIDI_L   },  // CANADIAN SYLLABICS LII
  { 0x14D7, BIDI_L   },  // CANADIAN SYLLABICS LO
  { 0x14D8, BIDI_L   },  // CANADIAN SYLLABICS LOO
  { 0x14D9, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE LOO
  { 0x14DA, BIDI_L   },  // CANADIAN SYLLABICS LA
  { 0x14DB, BIDI_L   },  // CANADIAN SYLLABICS LAA
  { 0x14DC, BIDI_L   },  // CANADIAN SYLLABICS LWE
  { 0x14DD, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LWE
  { 0x14DE, BIDI_L   },  // CANADIAN SYLLABICS LWI
  { 0x14DF, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LWI
  { 0x14E0, BIDI_L   },  // CANADIAN SYLLABICS LWII
  { 0x14E1, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LWII
  { 0x14E2, BIDI_L   },  // CANADIAN SYLLABICS LWO
  { 0x14E3, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LWO
  { 0x14E4, BIDI_L   },  // CANADIAN SYLLABICS LWOO
  { 0x14E5, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LWOO
  { 0x14E6, BIDI_L   },  // CANADIAN SYLLABICS LWA
  { 0x14E7, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LWA
  { 0x14E8, BIDI_L   },  // CANADIAN SYLLABICS LWAA
  { 0x14E9, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LWAA
  { 0x14EA, BIDI_L   },  // CANADIAN SYLLABICS L
  { 0x14EB, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE L
  { 0x14EC, BIDI_L   },  // CANADIAN SYLLABICS MEDIAL L
  { 0x14ED, BIDI_L   },  // CANADIAN SYLLABICS SE
  { 0x14EE, BIDI_L   },  // CANADIAN SYLLABICS SAAI
  { 0x14EF, BIDI_L   },  // CANADIAN SYLLABICS SI
  { 0x14F0, BIDI_L   },  // CANADIAN SYLLABICS SII
  { 0x14F1, BIDI_L   },  // CANADIAN SYLLABICS SO
  { 0x14F2, BIDI_L   },  // CANADIAN SYLLABICS SOO
  { 0x14F3, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE SOO
  { 0x14F4, BIDI_L   },  // CANADIAN SYLLABICS SA
  { 0x14F5, BIDI_L   },  // CANADIAN SYLLABICS SAA
  { 0x14F6, BIDI_L   },  // CANADIAN SYLLABICS SWE
  { 0x14F7, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SWE
  { 0x14F8, BIDI_L   },  // CANADIAN SYLLABICS SWI
  { 0x14F9, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SWI
  { 0x14FA, BIDI_L   },  // CANADIAN SYLLABICS SWII
  { 0x14FB, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SWII
  { 0x14FC, BIDI_L   },  // CANADIAN SYLLABICS SWO
  { 0x14FD, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SWO
  { 0x14FE, BIDI_L   },  // CANADIAN SYLLABICS SWOO
  { 0x14FF, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SWOO
  { 0x1500, BIDI_L   },  // CANADIAN SYLLABICS SWA
  { 0x1501, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SWA
  { 0x1502, BIDI_L   },  // CANADIAN SYLLABICS SWAA
  { 0x1503, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SWAA
  { 0x1504, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI SWAA
  { 0x1505, BIDI_L   },  // CANADIAN SYLLABICS S
  { 0x1506, BIDI_L   },  // CANADIAN SYLLABICS ATHAPASCAN S
  { 0x1507, BIDI_L   },  // CANADIAN SYLLABICS SW
  { 0x1508, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT S
  { 0x1509, BIDI_L   },  // CANADIAN SYLLABICS MOOSE-CREE SK
  { 0x150A, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI SKW
  { 0x150B, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI S-W
  { 0x150C, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI SPWA
  { 0x150D, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI STWA
  { 0x150E, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI SKWA
  { 0x150F, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI SCWA
  { 0x1510, BIDI_L   },  // CANADIAN SYLLABICS SHE
  { 0x1511, BIDI_L   },  // CANADIAN SYLLABICS SHI
  { 0x1512, BIDI_L   },  // CANADIAN SYLLABICS SHII
  { 0x1513, BIDI_L   },  // CANADIAN SYLLABICS SHO
  { 0x1514, BIDI_L   },  // CANADIAN SYLLABICS SHOO
  { 0x1515, BIDI_L   },  // CANADIAN SYLLABICS SHA
  { 0x1516, BIDI_L   },  // CANADIAN SYLLABICS SHAA
  { 0x1517, BIDI_L   },  // CANADIAN SYLLABICS SHWE
  { 0x1518, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SHWE
  { 0x1519, BIDI_L   },  // CANADIAN SYLLABICS SHWI
  { 0x151A, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SHWI
  { 0x151B, BIDI_L   },  // CANADIAN SYLLABICS SHWII
  { 0x151C, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SHWII
  { 0x151D, BIDI_L   },  // CANADIAN SYLLABICS SHWO
  { 0x151E, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SHWO
  { 0x151F, BIDI_L   },  // CANADIAN SYLLABICS SHWOO
  { 0x1520, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SHWOO
  { 0x1521, BIDI_L   },  // CANADIAN SYLLABICS SHWA
  { 0x1522, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SHWA
  { 0x1523, BIDI_L   },  // CANADIAN SYLLABICS SHWAA
  { 0x1524, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE SHWAA
  { 0x1525, BIDI_L   },  // CANADIAN SYLLABICS SH
  { 0x1526, BIDI_L   },  // CANADIAN SYLLABICS YE
  { 0x1527, BIDI_L   },  // CANADIAN SYLLABICS YAAI
  { 0x1528, BIDI_L   },  // CANADIAN SYLLABICS YI
  { 0x1529, BIDI_L   },  // CANADIAN SYLLABICS YII
  { 0x152A, BIDI_L   },  // CANADIAN SYLLABICS YO
  { 0x152B, BIDI_L   },  // CANADIAN SYLLABICS YOO
  { 0x152C, BIDI_L   },  // CANADIAN SYLLABICS Y-CREE YOO
  { 0x152D, BIDI_L   },  // CANADIAN SYLLABICS YA
  { 0x152E, BIDI_L   },  // CANADIAN SYLLABICS YAA
  { 0x152F, BIDI_L   },  // CANADIAN SYLLABICS YWE
  { 0x1530, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE YWE
  { 0x1531, BIDI_L   },  // CANADIAN SYLLABICS YWI
  { 0x1532, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE YWI
  { 0x1533, BIDI_L   },  // CANADIAN SYLLABICS YWII
  { 0x1534, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE YWII
  { 0x1535, BIDI_L   },  // CANADIAN SYLLABICS YWO
  { 0x1536, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE YWO
  { 0x1537, BIDI_L   },  // CANADIAN SYLLABICS YWOO
  { 0x1538, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE YWOO
  { 0x1539, BIDI_L   },  // CANADIAN SYLLABICS YWA
  { 0x153A, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE YWA
  { 0x153B, BIDI_L   },  // CANADIAN SYLLABICS YWAA
  { 0x153C, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE YWAA
  { 0x153D, BIDI_L   },  // CANADIAN SYLLABICS NASKAPI YWAA
  { 0x153E, BIDI_L   },  // CANADIAN SYLLABICS Y
  { 0x153F, BIDI_L   },  // CANADIAN SYLLABICS BIBLE-CREE Y
  { 0x1540, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE Y
  { 0x1541, BIDI_L   },  // CANADIAN SYLLABICS SAYISI YI
  { 0x1542, BIDI_L   },  // CANADIAN SYLLABICS RE
  { 0x1543, BIDI_L   },  // CANADIAN SYLLABICS R-CREE RE
  { 0x1544, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LE
  { 0x1545, BIDI_L   },  // CANADIAN SYLLABICS RAAI
  { 0x1546, BIDI_L   },  // CANADIAN SYLLABICS RI
  { 0x1547, BIDI_L   },  // CANADIAN SYLLABICS RII
  { 0x1548, BIDI_L   },  // CANADIAN SYLLABICS RO
  { 0x1549, BIDI_L   },  // CANADIAN SYLLABICS ROO
  { 0x154A, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LO
  { 0x154B, BIDI_L   },  // CANADIAN SYLLABICS RA
  { 0x154C, BIDI_L   },  // CANADIAN SYLLABICS RAA
  { 0x154D, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LA
  { 0x154E, BIDI_L   },  // CANADIAN SYLLABICS RWAA
  { 0x154F, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE RWAA
  { 0x1550, BIDI_L   },  // CANADIAN SYLLABICS R
  { 0x1551, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE R
  { 0x1552, BIDI_L   },  // CANADIAN SYLLABICS MEDIAL R
  { 0x1553, BIDI_L   },  // CANADIAN SYLLABICS FE
  { 0x1554, BIDI_L   },  // CANADIAN SYLLABICS FAAI
  { 0x1555, BIDI_L   },  // CANADIAN SYLLABICS FI
  { 0x1556, BIDI_L   },  // CANADIAN SYLLABICS FII
  { 0x1557, BIDI_L   },  // CANADIAN SYLLABICS FO
  { 0x1558, BIDI_L   },  // CANADIAN SYLLABICS FOO
  { 0x1559, BIDI_L   },  // CANADIAN SYLLABICS FA
  { 0x155A, BIDI_L   },  // CANADIAN SYLLABICS FAA
  { 0x155B, BIDI_L   },  // CANADIAN SYLLABICS FWAA
  { 0x155C, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE FWAA
  { 0x155D, BIDI_L   },  // CANADIAN SYLLABICS F
  { 0x155E, BIDI_L   },  // CANADIAN SYLLABICS THE
  { 0x155F, BIDI_L   },  // CANADIAN SYLLABICS N-CREE THE
  { 0x1560, BIDI_L   },  // CANADIAN SYLLABICS THI
  { 0x1561, BIDI_L   },  // CANADIAN SYLLABICS N-CREE THI
  { 0x1562, BIDI_L   },  // CANADIAN SYLLABICS THII
  { 0x1563, BIDI_L   },  // CANADIAN SYLLABICS N-CREE THII
  { 0x1564, BIDI_L   },  // CANADIAN SYLLABICS THO
  { 0x1565, BIDI_L   },  // CANADIAN SYLLABICS THOO
  { 0x1566, BIDI_L   },  // CANADIAN SYLLABICS THA
  { 0x1567, BIDI_L   },  // CANADIAN SYLLABICS THAA
  { 0x1568, BIDI_L   },  // CANADIAN SYLLABICS THWAA
  { 0x1569, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE THWAA
  { 0x156A, BIDI_L   },  // CANADIAN SYLLABICS TH
  { 0x156B, BIDI_L   },  // CANADIAN SYLLABICS TTHE
  { 0x156C, BIDI_L   },  // CANADIAN SYLLABICS TTHI
  { 0x156D, BIDI_L   },  // CANADIAN SYLLABICS TTHO
  { 0x156E, BIDI_L   },  // CANADIAN SYLLABICS TTHA
  { 0x156F, BIDI_L   },  // CANADIAN SYLLABICS TTH
  { 0x1570, BIDI_L   },  // CANADIAN SYLLABICS TYE
  { 0x1571, BIDI_L   },  // CANADIAN SYLLABICS TYI
  { 0x1572, BIDI_L   },  // CANADIAN SYLLABICS TYO
  { 0x1573, BIDI_L   },  // CANADIAN SYLLABICS TYA
  { 0x1574, BIDI_L   },  // CANADIAN SYLLABICS NUNAVIK HE
  { 0x1575, BIDI_L   },  // CANADIAN SYLLABICS NUNAVIK HI
  { 0x1576, BIDI_L   },  // CANADIAN SYLLABICS NUNAVIK HII
  { 0x1577, BIDI_L   },  // CANADIAN SYLLABICS NUNAVIK HO
  { 0x1578, BIDI_L   },  // CANADIAN SYLLABICS NUNAVIK HOO
  { 0x1579, BIDI_L   },  // CANADIAN SYLLABICS NUNAVIK HA
  { 0x157A, BIDI_L   },  // CANADIAN SYLLABICS NUNAVIK HAA
  { 0x157B, BIDI_L   },  // CANADIAN SYLLABICS NUNAVIK H
  { 0x157C, BIDI_L   },  // CANADIAN SYLLABICS NUNAVUT H
  { 0x157D, BIDI_L   },  // CANADIAN SYLLABICS HK
  { 0x157E, BIDI_L   },  // CANADIAN SYLLABICS QAAI
  { 0x157F, BIDI_L   },  // CANADIAN SYLLABICS QI
  { 0x1580, BIDI_L   },  // CANADIAN SYLLABICS QII
  { 0x1581, BIDI_L   },  // CANADIAN SYLLABICS QO
  { 0x1582, BIDI_L   },  // CANADIAN SYLLABICS QOO
  { 0x1583, BIDI_L   },  // CANADIAN SYLLABICS QA
  { 0x1584, BIDI_L   },  // CANADIAN SYLLABICS QAA
  { 0x1585, BIDI_L   },  // CANADIAN SYLLABICS Q
  { 0x1586, BIDI_L   },  // CANADIAN SYLLABICS TLHE
  { 0x1587, BIDI_L   },  // CANADIAN SYLLABICS TLHI
  { 0x1588, BIDI_L   },  // CANADIAN SYLLABICS TLHO
  { 0x1589, BIDI_L   },  // CANADIAN SYLLABICS TLHA
  { 0x158A, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE RE
  { 0x158B, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE RI
  { 0x158C, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE RO
  { 0x158D, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE RA
  { 0x158E, BIDI_L   },  // CANADIAN SYLLABICS NGAAI
  { 0x158F, BIDI_L   },  // CANADIAN SYLLABICS NGI
  { 0x1590, BIDI_L   },  // CANADIAN SYLLABICS NGII
  { 0x1591, BIDI_L   },  // CANADIAN SYLLABICS NGO
  { 0x1592, BIDI_L   },  // CANADIAN SYLLABICS NGOO
  { 0x1593, BIDI_L   },  // CANADIAN SYLLABICS NGA
  { 0x1594, BIDI_L   },  // CANADIAN SYLLABICS NGAA
  { 0x1595, BIDI_L   },  // CANADIAN SYLLABICS NG
  { 0x1596, BIDI_L   },  // CANADIAN SYLLABICS NNG
  { 0x1597, BIDI_L   },  // CANADIAN SYLLABICS SAYISI SHE
  { 0x1598, BIDI_L   },  // CANADIAN SYLLABICS SAYISI SHI
  { 0x1599, BIDI_L   },  // CANADIAN SYLLABICS SAYISI SHO
  { 0x159A, BIDI_L   },  // CANADIAN SYLLABICS SAYISI SHA
  { 0x159B, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THE
  { 0x159C, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THI
  { 0x159D, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THO
  { 0x159E, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THA
  { 0x159F, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE TH
  { 0x15A0, BIDI_L   },  // CANADIAN SYLLABICS LHI
  { 0x15A1, BIDI_L   },  // CANADIAN SYLLABICS LHII
  { 0x15A2, BIDI_L   },  // CANADIAN SYLLABICS LHO
  { 0x15A3, BIDI_L   },  // CANADIAN SYLLABICS LHOO
  { 0x15A4, BIDI_L   },  // CANADIAN SYLLABICS LHA
  { 0x15A5, BIDI_L   },  // CANADIAN SYLLABICS LHAA
  { 0x15A6, BIDI_L   },  // CANADIAN SYLLABICS LH
  { 0x15A7, BIDI_L   },  // CANADIAN SYLLABICS TH-CREE THE
  { 0x15A8, BIDI_L   },  // CANADIAN SYLLABICS TH-CREE THI
  { 0x15A9, BIDI_L   },  // CANADIAN SYLLABICS TH-CREE THII
  { 0x15AA, BIDI_L   },  // CANADIAN SYLLABICS TH-CREE THO
  { 0x15AB, BIDI_L   },  // CANADIAN SYLLABICS TH-CREE THOO
  { 0x15AC, BIDI_L   },  // CANADIAN SYLLABICS TH-CREE THA
  { 0x15AD, BIDI_L   },  // CANADIAN SYLLABICS TH-CREE THAA
  { 0x15AE, BIDI_L   },  // CANADIAN SYLLABICS TH-CREE TH
  { 0x15AF, BIDI_L   },  // CANADIAN SYLLABICS AIVILIK B
  { 0x15B0, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT E
  { 0x15B1, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT I
  { 0x15B2, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT O
  { 0x15B3, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT A
  { 0x15B4, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT WE
  { 0x15B5, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT WI
  { 0x15B6, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT WO
  { 0x15B7, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT WA
  { 0x15B8, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT NE
  { 0x15B9, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT NI
  { 0x15BA, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT NO
  { 0x15BB, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT NA
  { 0x15BC, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT KE
  { 0x15BD, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT KI
  { 0x15BE, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT KO
  { 0x15BF, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT KA
  { 0x15C0, BIDI_L   },  // CANADIAN SYLLABICS SAYISI HE
  { 0x15C1, BIDI_L   },  // CANADIAN SYLLABICS SAYISI HI
  { 0x15C2, BIDI_L   },  // CANADIAN SYLLABICS SAYISI HO
  { 0x15C3, BIDI_L   },  // CANADIAN SYLLABICS SAYISI HA
  { 0x15C4, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GHU
  { 0x15C5, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GHO
  { 0x15C6, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GHE
  { 0x15C7, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GHEE
  { 0x15C8, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GHI
  { 0x15C9, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GHA
  { 0x15CA, BIDI_L   },  // CANADIAN SYLLABICS CARRIER RU
  { 0x15CB, BIDI_L   },  // CANADIAN SYLLABICS CARRIER RO
  { 0x15CC, BIDI_L   },  // CANADIAN SYLLABICS CARRIER RE
  { 0x15CD, BIDI_L   },  // CANADIAN SYLLABICS CARRIER REE
  { 0x15CE, BIDI_L   },  // CANADIAN SYLLABICS CARRIER RI
  { 0x15CF, BIDI_L   },  // CANADIAN SYLLABICS CARRIER RA
  { 0x15D0, BIDI_L   },  // CANADIAN SYLLABICS CARRIER WU
  { 0x15D1, BIDI_L   },  // CANADIAN SYLLABICS CARRIER WO
  { 0x15D2, BIDI_L   },  // CANADIAN SYLLABICS CARRIER WE
  { 0x15D3, BIDI_L   },  // CANADIAN SYLLABICS CARRIER WEE
  { 0x15D4, BIDI_L   },  // CANADIAN SYLLABICS CARRIER WI
  { 0x15D5, BIDI_L   },  // CANADIAN SYLLABICS CARRIER WA
  { 0x15D6, BIDI_L   },  // CANADIAN SYLLABICS CARRIER HWU
  { 0x15D7, BIDI_L   },  // CANADIAN SYLLABICS CARRIER HWO
  { 0x15D8, BIDI_L   },  // CANADIAN SYLLABICS CARRIER HWE
  { 0x15D9, BIDI_L   },  // CANADIAN SYLLABICS CARRIER HWEE
  { 0x15DA, BIDI_L   },  // CANADIAN SYLLABICS CARRIER HWI
  { 0x15DB, BIDI_L   },  // CANADIAN SYLLABICS CARRIER HWA
  { 0x15DC, BIDI_L   },  // CANADIAN SYLLABICS CARRIER THU
  { 0x15DD, BIDI_L   },  // CANADIAN SYLLABICS CARRIER THO
  { 0x15DE, BIDI_L   },  // CANADIAN SYLLABICS CARRIER THE
  { 0x15DF, BIDI_L   },  // CANADIAN SYLLABICS CARRIER THEE
  { 0x15E0, BIDI_L   },  // CANADIAN SYLLABICS CARRIER THI
  { 0x15E1, BIDI_L   },  // CANADIAN SYLLABICS CARRIER THA
  { 0x15E2, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTU
  { 0x15E3, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTO
  { 0x15E4, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTE
  { 0x15E5, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTEE
  { 0x15E6, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTI
  { 0x15E7, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTA
  { 0x15E8, BIDI_L   },  // CANADIAN SYLLABICS CARRIER PU
  { 0x15E9, BIDI_L   },  // CANADIAN SYLLABICS CARRIER PO
  { 0x15EA, BIDI_L   },  // CANADIAN SYLLABICS CARRIER PE
  { 0x15EB, BIDI_L   },  // CANADIAN SYLLABICS CARRIER PEE
  { 0x15EC, BIDI_L   },  // CANADIAN SYLLABICS CARRIER PI
  { 0x15ED, BIDI_L   },  // CANADIAN SYLLABICS CARRIER PA
  { 0x15EE, BIDI_L   },  // CANADIAN SYLLABICS CARRIER P
  { 0x15EF, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GU
  { 0x15F0, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GO
  { 0x15F1, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GE
  { 0x15F2, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GEE
  { 0x15F3, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GI
  { 0x15F4, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GA
  { 0x15F5, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KHU
  { 0x15F6, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KHO
  { 0x15F7, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KHE
  { 0x15F8, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KHEE
  { 0x15F9, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KHI
  { 0x15FA, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KHA
  { 0x15FB, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KKU
  { 0x15FC, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KKO
  { 0x15FD, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KKE
  { 0x15FE, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KKEE
  { 0x15FF, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KKI
  { 0x1600, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KKA
  { 0x1601, BIDI_L   },  // CANADIAN SYLLABICS CARRIER KK
  { 0x1602, BIDI_L   },  // CANADIAN SYLLABICS CARRIER NU
  { 0x1603, BIDI_L   },  // CANADIAN SYLLABICS CARRIER NO
  { 0x1604, BIDI_L   },  // CANADIAN SYLLABICS CARRIER NE
  { 0x1605, BIDI_L   },  // CANADIAN SYLLABICS CARRIER NEE
  { 0x1606, BIDI_L   },  // CANADIAN SYLLABICS CARRIER NI
  { 0x1607, BIDI_L   },  // CANADIAN SYLLABICS CARRIER NA
  { 0x1608, BIDI_L   },  // CANADIAN SYLLABICS CARRIER MU
  { 0x1609, BIDI_L   },  // CANADIAN SYLLABICS CARRIER MO
  { 0x160A, BIDI_L   },  // CANADIAN SYLLABICS CARRIER ME
  { 0x160B, BIDI_L   },  // CANADIAN SYLLABICS CARRIER MEE
  { 0x160C, BIDI_L   },  // CANADIAN SYLLABICS CARRIER MI
  { 0x160D, BIDI_L   },  // CANADIAN SYLLABICS CARRIER MA
  { 0x160E, BIDI_L   },  // CANADIAN SYLLABICS CARRIER YU
  { 0x160F, BIDI_L   },  // CANADIAN SYLLABICS CARRIER YO
  { 0x1610, BIDI_L   },  // CANADIAN SYLLABICS CARRIER YE
  { 0x1611, BIDI_L   },  // CANADIAN SYLLABICS CARRIER YEE
  { 0x1612, BIDI_L   },  // CANADIAN SYLLABICS CARRIER YI
  { 0x1613, BIDI_L   },  // CANADIAN SYLLABICS CARRIER YA
  { 0x1614, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JU
  { 0x1615, BIDI_L   },  // CANADIAN SYLLABICS SAYISI JU
  { 0x1616, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JO
  { 0x1617, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JE
  { 0x1618, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JEE
  { 0x1619, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JI
  { 0x161A, BIDI_L   },  // CANADIAN SYLLABICS SAYISI JI
  { 0x161B, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JA
  { 0x161C, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JJU
  { 0x161D, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JJO
  { 0x161E, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JJE
  { 0x161F, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JJEE
  { 0x1620, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JJI
  { 0x1621, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JJA
  { 0x1622, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LU
  { 0x1623, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LO
  { 0x1624, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LE
  { 0x1625, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LEE
  { 0x1626, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LI
  { 0x1627, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LA
  { 0x1628, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DLU
  { 0x1629, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DLO
  { 0x162A, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DLE
  { 0x162B, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DLEE
  { 0x162C, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DLI
  { 0x162D, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DLA
  { 0x162E, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LHU
  { 0x162F, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LHO
  { 0x1630, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LHE
  { 0x1631, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LHEE
  { 0x1632, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LHI
  { 0x1633, BIDI_L   },  // CANADIAN SYLLABICS CARRIER LHA
  { 0x1634, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLHU
  { 0x1635, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLHO
  { 0x1636, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLHE
  { 0x1637, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLHEE
  { 0x1638, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLHI
  { 0x1639, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLHA
  { 0x163A, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLU
  { 0x163B, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLO
  { 0x163C, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLE
  { 0x163D, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLEE
  { 0x163E, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLI
  { 0x163F, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TLA
  { 0x1640, BIDI_L   },  // CANADIAN SYLLABICS CARRIER ZU
  { 0x1641, BIDI_L   },  // CANADIAN SYLLABICS CARRIER ZO
  { 0x1642, BIDI_L   },  // CANADIAN SYLLABICS CARRIER ZE
  { 0x1643, BIDI_L   },  // CANADIAN SYLLABICS CARRIER ZEE
  { 0x1644, BIDI_L   },  // CANADIAN SYLLABICS CARRIER ZI
  { 0x1645, BIDI_L   },  // CANADIAN SYLLABICS CARRIER ZA
  { 0x1646, BIDI_L   },  // CANADIAN SYLLABICS CARRIER Z
  { 0x1647, BIDI_L   },  // CANADIAN SYLLABICS CARRIER INITIAL Z
  { 0x1648, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DZU
  { 0x1649, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DZO
  { 0x164A, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DZE
  { 0x164B, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DZEE
  { 0x164C, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DZI
  { 0x164D, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DZA
  { 0x164E, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SU
  { 0x164F, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SO
  { 0x1650, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SE
  { 0x1651, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SEE
  { 0x1652, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SI
  { 0x1653, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SA
  { 0x1654, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SHU
  { 0x1655, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SHO
  { 0x1656, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SHE
  { 0x1657, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SHEE
  { 0x1658, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SHI
  { 0x1659, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SHA
  { 0x165A, BIDI_L   },  // CANADIAN SYLLABICS CARRIER SH
  { 0x165B, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TSU
  { 0x165C, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TSO
  { 0x165D, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TSE
  { 0x165E, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TSEE
  { 0x165F, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TSI
  { 0x1660, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TSA
  { 0x1661, BIDI_L   },  // CANADIAN SYLLABICS CARRIER CHU
  { 0x1662, BIDI_L   },  // CANADIAN SYLLABICS CARRIER CHO
  { 0x1663, BIDI_L   },  // CANADIAN SYLLABICS CARRIER CHE
  { 0x1664, BIDI_L   },  // CANADIAN SYLLABICS CARRIER CHEE
  { 0x1665, BIDI_L   },  // CANADIAN SYLLABICS CARRIER CHI
  { 0x1666, BIDI_L   },  // CANADIAN SYLLABICS CARRIER CHA
  { 0x1667, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTSU
  { 0x1668, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTSO
  { 0x1669, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTSE
  { 0x166A, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTSEE
  { 0x166B, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTSI
  { 0x166C, BIDI_L   },  // CANADIAN SYLLABICS CARRIER TTSA
  { 0x166D, BIDI_L   },  // CANADIAN SYLLABICS CHI SIGN
  { 0x166E, BIDI_L   },  // CANADIAN SYLLABICS FULL STOP
  { 0x166F, BIDI_L   },  // CANADIAN SYLLABICS QAI
  { 0x1670, BIDI_L   },  // CANADIAN SYLLABICS NGAI
  { 0x1671, BIDI_L   },  // CANADIAN SYLLABICS NNGI
  { 0x1672, BIDI_L   },  // CANADIAN SYLLABICS NNGII
  { 0x1673, BIDI_L   },  // CANADIAN SYLLABICS NNGO
  { 0x1674, BIDI_L   },  // CANADIAN SYLLABICS NNGOO
  { 0x1675, BIDI_L   },  // CANADIAN SYLLABICS NNGA
  { 0x1676, BIDI_L   },  // CANADIAN SYLLABICS NNGAA
  { 0x1677, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THWEE
  { 0x1678, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THWI
  { 0x1679, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THWII
  { 0x167A, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THWO
  { 0x167B, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THWOO
  { 0x167C, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THWA
  { 0x167D, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE THWAA
  { 0x167E, BIDI_L   },  // CANADIAN SYLLABICS WOODS-CREE FINAL TH
  { 0x167F, BIDI_L   },  // CANADIAN SYLLABICS BLACKFOOT W
  { 0x1680, BIDI_WS  },  // OGHAM SPACE MARK
  { 0x1681, BIDI_L   },  // OGHAM LETTER BEITH
  { 0x1682, BIDI_L   },  // OGHAM LETTER LUIS
  { 0x1683, BIDI_L   },  // OGHAM LETTER FEARN
  { 0x1684, BIDI_L   },  // OGHAM LETTER SAIL
  { 0x1685, BIDI_L   },  // OGHAM LETTER NION
  { 0x1686, BIDI_L   },  // OGHAM LETTER UATH
  { 0x1687, BIDI_L   },  // OGHAM LETTER DAIR
  { 0x1688, BIDI_L   },  // OGHAM LETTER TINNE
  { 0x1689, BIDI_L   },  // OGHAM LETTER COLL
  { 0x168A, BIDI_L   },  // OGHAM LETTER CEIRT
  { 0x168B, BIDI_L   },  // OGHAM LETTER MUIN
  { 0x168C, BIDI_L   },  // OGHAM LETTER GORT
  { 0x168D, BIDI_L   },  // OGHAM LETTER NGEADAL
  { 0x168E, BIDI_L   },  // OGHAM LETTER STRAIF
  { 0x168F, BIDI_L   },  // OGHAM LETTER RUIS
  { 0x1690, BIDI_L   },  // OGHAM LETTER AILM
  { 0x1691, BIDI_L   },  // OGHAM LETTER ONN
  { 0x1692, BIDI_L   },  // OGHAM LETTER UR
  { 0x1693, BIDI_L   },  // OGHAM LETTER EADHADH
  { 0x1694, BIDI_L   },  // OGHAM LETTER IODHADH
  { 0x1695, BIDI_L   },  // OGHAM LETTER EABHADH
  { 0x1696, BIDI_L   },  // OGHAM LETTER OR
  { 0x1697, BIDI_L   },  // OGHAM LETTER UILLEANN
  { 0x1698, BIDI_L   },  // OGHAM LETTER IFIN
  { 0x1699, BIDI_L   },  // OGHAM LETTER EAMHANCHOLL
  { 0x169A, BIDI_L   },  // OGHAM LETTER PEITH
  { 0x169B, BIDI_ON  },  // OGHAM FEATHER MARK
  { 0x169C, BIDI_ON  },  // OGHAM REVERSED FEATHER MARK
  { 0x16A0, BIDI_L   },  // RUNIC LETTER FEHU FEOH FE F
  { 0x16A1, BIDI_L   },  // RUNIC LETTER V
  { 0x16A2, BIDI_L   },  // RUNIC LETTER URUZ UR U
  { 0x16A3, BIDI_L   },  // RUNIC LETTER YR
  { 0x16A4, BIDI_L   },  // RUNIC LETTER Y
  { 0x16A5, BIDI_L   },  // RUNIC LETTER W
  { 0x16A6, BIDI_L   },  // RUNIC LETTER THURISAZ THURS THORN
  { 0x16A7, BIDI_L   },  // RUNIC LETTER ETH
  { 0x16A8, BIDI_L   },  // RUNIC LETTER ANSUZ A
  { 0x16A9, BIDI_L   },  // RUNIC LETTER OS O
  { 0x16AA, BIDI_L   },  // RUNIC LETTER AC A
  { 0x16AB, BIDI_L   },  // RUNIC LETTER AESC
  { 0x16AC, BIDI_L   },  // RUNIC LETTER LONG-BRANCH-OSS O
  { 0x16AD, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-OSS O
  { 0x16AE, BIDI_L   },  // RUNIC LETTER O
  { 0x16AF, BIDI_L   },  // RUNIC LETTER OE
  { 0x16B0, BIDI_L   },  // RUNIC LETTER ON
  { 0x16B1, BIDI_L   },  // RUNIC LETTER RAIDO RAD REID R
  { 0x16B2, BIDI_L   },  // RUNIC LETTER KAUNA
  { 0x16B3, BIDI_L   },  // RUNIC LETTER CEN
  { 0x16B4, BIDI_L   },  // RUNIC LETTER KAUN K
  { 0x16B5, BIDI_L   },  // RUNIC LETTER G
  { 0x16B6, BIDI_L   },  // RUNIC LETTER ENG
  { 0x16B7, BIDI_L   },  // RUNIC LETTER GEBO GYFU G
  { 0x16B8, BIDI_L   },  // RUNIC LETTER GAR
  { 0x16B9, BIDI_L   },  // RUNIC LETTER WUNJO WYNN W
  { 0x16BA, BIDI_L   },  // RUNIC LETTER HAGLAZ H
  { 0x16BB, BIDI_L   },  // RUNIC LETTER HAEGL H
  { 0x16BC, BIDI_L   },  // RUNIC LETTER LONG-BRANCH-HAGALL H
  { 0x16BD, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-HAGALL H
  { 0x16BE, BIDI_L   },  // RUNIC LETTER NAUDIZ NYD NAUD N
  { 0x16BF, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-NAUD N
  { 0x16C0, BIDI_L   },  // RUNIC LETTER DOTTED-N
  { 0x16C1, BIDI_L   },  // RUNIC LETTER ISAZ IS ISS I
  { 0x16C2, BIDI_L   },  // RUNIC LETTER E
  { 0x16C3, BIDI_L   },  // RUNIC LETTER JERAN J
  { 0x16C4, BIDI_L   },  // RUNIC LETTER GER
  { 0x16C5, BIDI_L   },  // RUNIC LETTER LONG-BRANCH-AR AE
  { 0x16C6, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-AR A
  { 0x16C7, BIDI_L   },  // RUNIC LETTER IWAZ EOH
  { 0x16C8, BIDI_L   },  // RUNIC LETTER PERTHO PEORTH P
  { 0x16C9, BIDI_L   },  // RUNIC LETTER ALGIZ EOLHX
  { 0x16CA, BIDI_L   },  // RUNIC LETTER SOWILO S
  { 0x16CB, BIDI_L   },  // RUNIC LETTER SIGEL LONG-BRANCH-SOL S
  { 0x16CC, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-SOL S
  { 0x16CD, BIDI_L   },  // RUNIC LETTER C
  { 0x16CE, BIDI_L   },  // RUNIC LETTER Z
  { 0x16CF, BIDI_L   },  // RUNIC LETTER TIWAZ TIR TYR T
  { 0x16D0, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-TYR T
  { 0x16D1, BIDI_L   },  // RUNIC LETTER D
  { 0x16D2, BIDI_L   },  // RUNIC LETTER BERKANAN BEORC BJARKAN B
  { 0x16D3, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-BJARKAN B
  { 0x16D4, BIDI_L   },  // RUNIC LETTER DOTTED-P
  { 0x16D5, BIDI_L   },  // RUNIC LETTER OPEN-P
  { 0x16D6, BIDI_L   },  // RUNIC LETTER EHWAZ EH E
  { 0x16D7, BIDI_L   },  // RUNIC LETTER MANNAZ MAN M
  { 0x16D8, BIDI_L   },  // RUNIC LETTER LONG-BRANCH-MADR M
  { 0x16D9, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-MADR M
  { 0x16DA, BIDI_L   },  // RUNIC LETTER LAUKAZ LAGU LOGR L
  { 0x16DB, BIDI_L   },  // RUNIC LETTER DOTTED-L
  { 0x16DC, BIDI_L   },  // RUNIC LETTER INGWAZ
  { 0x16DD, BIDI_L   },  // RUNIC LETTER ING
  { 0x16DE, BIDI_L   },  // RUNIC LETTER DAGAZ DAEG D
  { 0x16DF, BIDI_L   },  // RUNIC LETTER OTHALAN ETHEL O
  { 0x16E0, BIDI_L   },  // RUNIC LETTER EAR
  { 0x16E1, BIDI_L   },  // RUNIC LETTER IOR
  { 0x16E2, BIDI_L   },  // RUNIC LETTER CWEORTH
  { 0x16E3, BIDI_L   },  // RUNIC LETTER CALC
  { 0x16E4, BIDI_L   },  // RUNIC LETTER CEALC
  { 0x16E5, BIDI_L   },  // RUNIC LETTER STAN
  { 0x16E6, BIDI_L   },  // RUNIC LETTER LONG-BRANCH-YR
  { 0x16E7, BIDI_L   },  // RUNIC LETTER SHORT-TWIG-YR
  { 0x16E8, BIDI_L   },  // RUNIC LETTER ICELANDIC-YR
  { 0x16E9, BIDI_L   },  // RUNIC LETTER Q
  { 0x16EA, BIDI_L   },  // RUNIC LETTER X
  { 0x16EB, BIDI_L   },  // RUNIC SINGLE PUNCTUATION
  { 0x16EC, BIDI_L   },  // RUNIC MULTIPLE PUNCTUATION
  { 0x16ED, BIDI_L   },  // RUNIC CROSS PUNCTUATION
  { 0x16EE, BIDI_L   },  // RUNIC ARLAUG SYMBOL
  { 0x16EF, BIDI_L   },  // RUNIC TVIMADUR SYMBOL
  { 0x16F0, BIDI_L   },  // RUNIC BELGTHOR SYMBOL
  { 0x16F1, BIDI_L   },  // RUNIC LETTER K
  { 0x16F2, BIDI_L   },  // RUNIC LETTER SH
  { 0x16F3, BIDI_L   },  // RUNIC LETTER OO
  { 0x16F4, BIDI_L   },  // RUNIC LETTER FRANKS CASKET OS
  { 0x16F5, BIDI_L   },  // RUNIC LETTER FRANKS CASKET IS
  { 0x16F6, BIDI_L   },  // RUNIC LETTER FRANKS CASKET EH
  { 0x16F7, BIDI_L   },  // RUNIC LETTER FRANKS CASKET AC
  { 0x16F8, BIDI_L   },  // RUNIC LETTER FRANKS CASKET AESC
  { 0x1700, BIDI_L   },  // TAGALOG LETTER A
  { 0x1701, BIDI_L   },  // TAGALOG LETTER I
  { 0x1702, BIDI_L   },  // TAGALOG LETTER U
  { 0x1703, BIDI_L   },  // TAGALOG LETTER KA
  { 0x1704, BIDI_L   },  // TAGALOG LETTER GA
  { 0x1705, BIDI_L   },  // TAGALOG LETTER NGA
  { 0x1706, BIDI_L   },  // TAGALOG LETTER TA
  { 0x1707, BIDI_L   },  // TAGALOG LETTER DA
  { 0x1708, BIDI_L   },  // TAGALOG LETTER NA
  { 0x1709, BIDI_L   },  // TAGALOG LETTER PA
  { 0x170A, BIDI_L   },  // TAGALOG LETTER BA
  { 0x170B, BIDI_L   },  // TAGALOG LETTER MA
  { 0x170C, BIDI_L   },  // TAGALOG LETTER YA
  { 0x170E, BIDI_L   },  // TAGALOG LETTER LA
  { 0x170F, BIDI_L   },  // TAGALOG LETTER WA
  { 0x1710, BIDI_L   },  // TAGALOG LETTER SA
  { 0x1711, BIDI_L   },  // TAGALOG LETTER HA
  { 0x1712, BIDI_NSM },  // TAGALOG VOWEL SIGN I
  { 0x1713, BIDI_NSM },  // TAGALOG VOWEL SIGN U
  { 0x1714, BIDI_NSM },  // TAGALOG SIGN VIRAMA
  { 0x1720, BIDI_L   },  // HANUNOO LETTER A
  { 0x1721, BIDI_L   },  // HANUNOO LETTER I
  { 0x1722, BIDI_L   },  // HANUNOO LETTER U
  { 0x1723, BIDI_L   },  // HANUNOO LETTER KA
  { 0x1724, BIDI_L   },  // HANUNOO LETTER GA
  { 0x1725, BIDI_L   },  // HANUNOO LETTER NGA
  { 0x1726, BIDI_L   },  // HANUNOO LETTER TA
  { 0x1727, BIDI_L   },  // HANUNOO LETTER DA
  { 0x1728, BIDI_L   },  // HANUNOO LETTER NA
  { 0x1729, BIDI_L   },  // HANUNOO LETTER PA
  { 0x172A, BIDI_L   },  // HANUNOO LETTER BA
  { 0x172B, BIDI_L   },  // HANUNOO LETTER MA
  { 0x172C, BIDI_L   },  // HANUNOO LETTER YA
  { 0x172D, BIDI_L   },  // HANUNOO LETTER RA
  { 0x172E, BIDI_L   },  // HANUNOO LETTER LA
  { 0x172F, BIDI_L   },  // HANUNOO LETTER WA
  { 0x1730, BIDI_L   },  // HANUNOO LETTER SA
  { 0x1731, BIDI_L   },  // HANUNOO LETTER HA
  { 0x1732, BIDI_NSM },  // HANUNOO VOWEL SIGN I
  { 0x1733, BIDI_NSM },  // HANUNOO VOWEL SIGN U
  { 0x1734, BIDI_NSM },  // HANUNOO SIGN PAMUDPOD
  { 0x1735, BIDI_L   },  // PHILIPPINE SINGLE PUNCTUATION
  { 0x1736, BIDI_L   },  // PHILIPPINE DOUBLE PUNCTUATION
  { 0x1740, BIDI_L   },  // BUHID LETTER A
  { 0x1741, BIDI_L   },  // BUHID LETTER I
  { 0x1742, BIDI_L   },  // BUHID LETTER U
  { 0x1743, BIDI_L   },  // BUHID LETTER KA
  { 0x1744, BIDI_L   },  // BUHID LETTER GA
  { 0x1745, BIDI_L   },  // BUHID LETTER NGA
  { 0x1746, BIDI_L   },  // BUHID LETTER TA
  { 0x1747, BIDI_L   },  // BUHID LETTER DA
  { 0x1748, BIDI_L   },  // BUHID LETTER NA
  { 0x1749, BIDI_L   },  // BUHID LETTER PA
  { 0x174A, BIDI_L   },  // BUHID LETTER BA
  { 0x174B, BIDI_L   },  // BUHID LETTER MA
  { 0x174C, BIDI_L   },  // BUHID LETTER YA
  { 0x174D, BIDI_L   },  // BUHID LETTER RA
  { 0x174E, BIDI_L   },  // BUHID LETTER LA
  { 0x174F, BIDI_L   },  // BUHID LETTER WA
  { 0x1750, BIDI_L   },  // BUHID LETTER SA
  { 0x1751, BIDI_L   },  // BUHID LETTER HA
  { 0x1752, BIDI_NSM },  // BUHID VOWEL SIGN I
  { 0x1753, BIDI_NSM },  // BUHID VOWEL SIGN U
  { 0x1760, BIDI_L   },  // TAGBANWA LETTER A
  { 0x1761, BIDI_L   },  // TAGBANWA LETTER I
  { 0x1762, BIDI_L   },  // TAGBANWA LETTER U
  { 0x1763, BIDI_L   },  // TAGBANWA LETTER KA
  { 0x1764, BIDI_L   },  // TAGBANWA LETTER GA
  { 0x1765, BIDI_L   },  // TAGBANWA LETTER NGA
  { 0x1766, BIDI_L   },  // TAGBANWA LETTER TA
  { 0x1767, BIDI_L   },  // TAGBANWA LETTER DA
  { 0x1768, BIDI_L   },  // TAGBANWA LETTER NA
  { 0x1769, BIDI_L   },  // TAGBANWA LETTER PA
  { 0x176A, BIDI_L   },  // TAGBANWA LETTER BA
  { 0x176B, BIDI_L   },  // TAGBANWA LETTER MA
  { 0x176C, BIDI_L   },  // TAGBANWA LETTER YA
  { 0x176E, BIDI_L   },  // TAGBANWA LETTER LA
  { 0x176F, BIDI_L   },  // TAGBANWA LETTER WA
  { 0x1770, BIDI_L   },  // TAGBANWA LETTER SA
  { 0x1772, BIDI_NSM },  // TAGBANWA VOWEL SIGN I
  { 0x1773, BIDI_NSM },  // TAGBANWA VOWEL SIGN U
  { 0x1780, BIDI_L   },  // KHMER LETTER KA
  { 0x1781, BIDI_L   },  // KHMER LETTER KHA
  { 0x1782, BIDI_L   },  // KHMER LETTER KO
  { 0x1783, BIDI_L   },  // KHMER LETTER KHO
  { 0x1784, BIDI_L   },  // KHMER LETTER NGO
  { 0x1785, BIDI_L   },  // KHMER LETTER CA
  { 0x1786, BIDI_L   },  // KHMER LETTER CHA
  { 0x1787, BIDI_L   },  // KHMER LETTER CO
  { 0x1788, BIDI_L   },  // KHMER LETTER CHO
  { 0x1789, BIDI_L   },  // KHMER LETTER NYO
  { 0x178A, BIDI_L   },  // KHMER LETTER DA
  { 0x178B, BIDI_L   },  // KHMER LETTER TTHA
  { 0x178C, BIDI_L   },  // KHMER LETTER DO
  { 0x178D, BIDI_L   },  // KHMER LETTER TTHO
  { 0x178E, BIDI_L   },  // KHMER LETTER NNO
  { 0x178F, BIDI_L   },  // KHMER LETTER TA
  { 0x1790, BIDI_L   },  // KHMER LETTER THA
  { 0x1791, BIDI_L   },  // KHMER LETTER TO
  { 0x1792, BIDI_L   },  // KHMER LETTER THO
  { 0x1793, BIDI_L   },  // KHMER LETTER NO
  { 0x1794, BIDI_L   },  // KHMER LETTER BA
  { 0x1795, BIDI_L   },  // KHMER LETTER PHA
  { 0x1796, BIDI_L   },  // KHMER LETTER PO
  { 0x1797, BIDI_L   },  // KHMER LETTER PHO
  { 0x1798, BIDI_L   },  // KHMER LETTER MO
  { 0x1799, BIDI_L   },  // KHMER LETTER YO
  { 0x179A, BIDI_L   },  // KHMER LETTER RO
  { 0x179B, BIDI_L   },  // KHMER LETTER LO
  { 0x179C, BIDI_L   },  // KHMER LETTER VO
  { 0x179D, BIDI_L   },  // KHMER LETTER SHA
  { 0x179E, BIDI_L   },  // KHMER LETTER SSO
  { 0x179F, BIDI_L   },  // KHMER LETTER SA
  { 0x17A0, BIDI_L   },  // KHMER LETTER HA
  { 0x17A1, BIDI_L   },  // KHMER LETTER LA
  { 0x17A2, BIDI_L   },  // KHMER LETTER QA
  { 0x17A3, BIDI_L   },  // KHMER INDEPENDENT VOWEL QAQ
  { 0x17A4, BIDI_L   },  // KHMER INDEPENDENT VOWEL QAA
  { 0x17A5, BIDI_L   },  // KHMER INDEPENDENT VOWEL QI
  { 0x17A6, BIDI_L   },  // KHMER INDEPENDENT VOWEL QII
  { 0x17A7, BIDI_L   },  // KHMER INDEPENDENT VOWEL QU
  { 0x17A8, BIDI_L   },  // KHMER INDEPENDENT VOWEL QUK
  { 0x17A9, BIDI_L   },  // KHMER INDEPENDENT VOWEL QUU
  { 0x17AA, BIDI_L   },  // KHMER INDEPENDENT VOWEL QUUV
  { 0x17AB, BIDI_L   },  // KHMER INDEPENDENT VOWEL RY
  { 0x17AC, BIDI_L   },  // KHMER INDEPENDENT VOWEL RYY
  { 0x17AD, BIDI_L   },  // KHMER INDEPENDENT VOWEL LY
  { 0x17AE, BIDI_L   },  // KHMER INDEPENDENT VOWEL LYY
  { 0x17AF, BIDI_L   },  // KHMER INDEPENDENT VOWEL QE
  { 0x17B0, BIDI_L   },  // KHMER INDEPENDENT VOWEL QAI
  { 0x17B1, BIDI_L   },  // KHMER INDEPENDENT VOWEL QOO TYPE ONE
  { 0x17B2, BIDI_L   },  // KHMER INDEPENDENT VOWEL QOO TYPE TWO
  { 0x17B3, BIDI_L   },  // KHMER INDEPENDENT VOWEL QAU
  { 0x17B4, BIDI_NSM },  // KHMER VOWEL INHERENT AQ
  { 0x17B5, BIDI_NSM },  // KHMER VOWEL INHERENT AA
  { 0x17B6, BIDI_L   },  // KHMER VOWEL SIGN AA
  { 0x17B7, BIDI_NSM },  // KHMER VOWEL SIGN I
  { 0x17B8, BIDI_NSM },  // KHMER VOWEL SIGN II
  { 0x17B9, BIDI_NSM },  // KHMER VOWEL SIGN Y
  { 0x17BA, BIDI_NSM },  // KHMER VOWEL SIGN YY
  { 0x17BB, BIDI_NSM },  // KHMER VOWEL SIGN U
  { 0x17BC, BIDI_NSM },  // KHMER VOWEL SIGN UU
  { 0x17BD, BIDI_NSM },  // KHMER VOWEL SIGN UA
  { 0x17BE, BIDI_L   },  // KHMER VOWEL SIGN OE
  { 0x17BF, BIDI_L   },  // KHMER VOWEL SIGN YA
  { 0x17C0, BIDI_L   },  // KHMER VOWEL SIGN IE
  { 0x17C1, BIDI_L   },  // KHMER VOWEL SIGN E
  { 0x17C2, BIDI_L   },  // KHMER VOWEL SIGN AE
  { 0x17C3, BIDI_L   },  // KHMER VOWEL SIGN AI
  { 0x17C4, BIDI_L   },  // KHMER VOWEL SIGN OO
  { 0x17C5, BIDI_L   },  // KHMER VOWEL SIGN AU
  { 0x17C6, BIDI_NSM },  // KHMER SIGN NIKAHIT
  { 0x17C7, BIDI_L   },  // KHMER SIGN REAHMUK
  { 0x17C8, BIDI_L   },  // KHMER SIGN YUUKALEAPINTU
  { 0x17C9, BIDI_NSM },  // KHMER SIGN MUUSIKATOAN
  { 0x17CA, BIDI_NSM },  // KHMER SIGN TRIISAP
  { 0x17CB, BIDI_NSM },  // KHMER SIGN BANTOC
  { 0x17CC, BIDI_NSM },  // KHMER SIGN ROBAT
  { 0x17CD, BIDI_NSM },  // KHMER SIGN TOANDAKHIAT
  { 0x17CE, BIDI_NSM },  // KHMER SIGN KAKABAT
  { 0x17CF, BIDI_NSM },  // KHMER SIGN AHSDA
  { 0x17D0, BIDI_NSM },  // KHMER SIGN SAMYOK SANNYA
  { 0x17D1, BIDI_NSM },  // KHMER SIGN VIRIAM
  { 0x17D2, BIDI_NSM },  // KHMER SIGN COENG
  { 0x17D3, BIDI_NSM },  // KHMER SIGN BATHAMASAT
  { 0x17D4, BIDI_L   },  // KHMER SIGN KHAN
  { 0x17D5, BIDI_L   },  // KHMER SIGN BARIYOOSAN
  { 0x17D6, BIDI_L   },  // KHMER SIGN CAMNUC PII KUUH
  { 0x17D7, BIDI_L   },  // KHMER SIGN LEK TOO
  { 0x17D8, BIDI_L   },  // KHMER SIGN BEYYAL
  { 0x17D9, BIDI_L   },  // KHMER SIGN PHNAEK MUAN
  { 0x17DA, BIDI_L   },  // KHMER SIGN KOOMUUT
  { 0x17DB, BIDI_ET  },  // KHMER CURRENCY SYMBOL RIEL
  { 0x17DC, BIDI_L   },  // KHMER SIGN AVAKRAHASANYA
  { 0x17DD, BIDI_NSM },  // KHMER SIGN ATTHACAN
  { 0x17E0, BIDI_L   },  // KHMER DIGIT ZERO
  { 0x17E1, BIDI_L   },  // KHMER DIGIT ONE
  { 0x17E2, BIDI_L   },  // KHMER DIGIT TWO
  { 0x17E3, BIDI_L   },  // KHMER DIGIT THREE
  { 0x17E4, BIDI_L   },  // KHMER DIGIT FOUR
  { 0x17E5, BIDI_L   },  // KHMER DIGIT FIVE
  { 0x17E6, BIDI_L   },  // KHMER DIGIT SIX
  { 0x17E7, BIDI_L   },  // KHMER DIGIT SEVEN
  { 0x17E8, BIDI_L   },  // KHMER DIGIT EIGHT
  { 0x17E9, BIDI_L   },  // KHMER DIGIT NINE
  { 0x17F0, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK SON
  { 0x17F1, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK MUOY
  { 0x17F2, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK PII
  { 0x17F3, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK BEI
  { 0x17F4, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK BUON
  { 0x17F5, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK PRAM
  { 0x17F6, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK PRAM-MUOY
  { 0x17F7, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK PRAM-PII
  { 0x17F8, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK PRAM-BEI
  { 0x17F9, BIDI_ON  },  // KHMER SYMBOL LEK ATTAK PRAM-BUON
  { 0x1800, BIDI_ON  },  // MONGOLIAN BIRGA
  { 0x1801, BIDI_ON  },  // MONGOLIAN ELLIPSIS
  { 0x1802, BIDI_ON  },  // MONGOLIAN COMMA
  { 0x1803, BIDI_ON  },  // MONGOLIAN FULL STOP
  { 0x1804, BIDI_ON  },  // MONGOLIAN COLON
  { 0x1805, BIDI_ON  },  // MONGOLIAN FOUR DOTS
  { 0x1806, BIDI_ON  },  // MONGOLIAN TODO SOFT HYPHEN
  { 0x1807, BIDI_ON  },  // MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER
  { 0x1808, BIDI_ON  },  // MONGOLIAN MANCHU COMMA
  { 0x1809, BIDI_ON  },  // MONGOLIAN MANCHU FULL STOP
  { 0x180A, BIDI_ON  },  // MONGOLIAN NIRUGU
  { 0x180B, BIDI_NSM },  // MONGOLIAN FREE VARIATION SELECTOR ONE
  { 0x180C, BIDI_NSM },  // MONGOLIAN FREE VARIATION SELECTOR TWO
  { 0x180D, BIDI_NSM },  // MONGOLIAN FREE VARIATION SELECTOR THREE
  { 0x180E, BIDI_BN  },  // MONGOLIAN VOWEL SEPARATOR
  { 0x1810, BIDI_L   },  // MONGOLIAN DIGIT ZERO
  { 0x1811, BIDI_L   },  // MONGOLIAN DIGIT ONE
  { 0x1812, BIDI_L   },  // MONGOLIAN DIGIT TWO
  { 0x1813, BIDI_L   },  // MONGOLIAN DIGIT THREE
  { 0x1814, BIDI_L   },  // MONGOLIAN DIGIT FOUR
  { 0x1815, BIDI_L   },  // MONGOLIAN DIGIT FIVE
  { 0x1816, BIDI_L   },  // MONGOLIAN DIGIT SIX
  { 0x1817, BIDI_L   },  // MONGOLIAN DIGIT SEVEN
  { 0x1818, BIDI_L   },  // MONGOLIAN DIGIT EIGHT
  { 0x1819, BIDI_L   },  // MONGOLIAN DIGIT NINE
  { 0x1820, BIDI_L   },  // MONGOLIAN LETTER A
  { 0x1821, BIDI_L   },  // MONGOLIAN LETTER E
  { 0x1822, BIDI_L   },  // MONGOLIAN LETTER I
  { 0x1823, BIDI_L   },  // MONGOLIAN LETTER O
  { 0x1824, BIDI_L   },  // MONGOLIAN LETTER U
  { 0x1825, BIDI_L   },  // MONGOLIAN LETTER OE
  { 0x1826, BIDI_L   },  // MONGOLIAN LETTER UE
  { 0x1827, BIDI_L   },  // MONGOLIAN LETTER EE
  { 0x1828, BIDI_L   },  // MONGOLIAN LETTER NA
  { 0x1829, BIDI_L   },  // MONGOLIAN LETTER ANG
  { 0x182A, BIDI_L   },  // MONGOLIAN LETTER BA
  { 0x182B, BIDI_L   },  // MONGOLIAN LETTER PA
  { 0x182C, BIDI_L   },  // MONGOLIAN LETTER QA
  { 0x182D, BIDI_L   },  // MONGOLIAN LETTER GA
  { 0x182E, BIDI_L   },  // MONGOLIAN LETTER MA
  { 0x182F, BIDI_L   },  // MONGOLIAN LETTER LA
  { 0x1830, BIDI_L   },  // MONGOLIAN LETTER SA
  { 0x1831, BIDI_L   },  // MONGOLIAN LETTER SHA
  { 0x1832, BIDI_L   },  // MONGOLIAN LETTER TA
  { 0x1833, BIDI_L   },  // MONGOLIAN LETTER DA
  { 0x1834, BIDI_L   },  // MONGOLIAN LETTER CHA
  { 0x1835, BIDI_L   },  // MONGOLIAN LETTER JA
  { 0x1836, BIDI_L   },  // MONGOLIAN LETTER YA
  { 0x1837, BIDI_L   },  // MONGOLIAN LETTER RA
  { 0x1838, BIDI_L   },  // MONGOLIAN LETTER WA
  { 0x1839, BIDI_L   },  // MONGOLIAN LETTER FA
  { 0x183A, BIDI_L   },  // MONGOLIAN LETTER KA
  { 0x183B, BIDI_L   },  // MONGOLIAN LETTER KHA
  { 0x183C, BIDI_L   },  // MONGOLIAN LETTER TSA
  { 0x183D, BIDI_L   },  // MONGOLIAN LETTER ZA
  { 0x183E, BIDI_L   },  // MONGOLIAN LETTER HAA
  { 0x183F, BIDI_L   },  // MONGOLIAN LETTER ZRA
  { 0x1840, BIDI_L   },  // MONGOLIAN LETTER LHA
  { 0x1841, BIDI_L   },  // MONGOLIAN LETTER ZHI
  { 0x1842, BIDI_L   },  // MONGOLIAN LETTER CHI
  { 0x1843, BIDI_L   },  // MONGOLIAN LETTER TODO LONG VOWEL SIGN
  { 0x1844, BIDI_L   },  // MONGOLIAN LETTER TODO E
  { 0x1845, BIDI_L   },  // MONGOLIAN LETTER TODO I
  { 0x1846, BIDI_L   },  // MONGOLIAN LETTER TODO O
  { 0x1847, BIDI_L   },  // MONGOLIAN LETTER TODO U
  { 0x1848, BIDI_L   },  // MONGOLIAN LETTER TODO OE
  { 0x1849, BIDI_L   },  // MONGOLIAN LETTER TODO UE
  { 0x184A, BIDI_L   },  // MONGOLIAN LETTER TODO ANG
  { 0x184B, BIDI_L   },  // MONGOLIAN LETTER TODO BA
  { 0x184C, BIDI_L   },  // MONGOLIAN LETTER TODO PA
  { 0x184D, BIDI_L   },  // MONGOLIAN LETTER TODO QA
  { 0x184E, BIDI_L   },  // MONGOLIAN LETTER TODO GA
  { 0x184F, BIDI_L   },  // MONGOLIAN LETTER TODO MA
  { 0x1850, BIDI_L   },  // MONGOLIAN LETTER TODO TA
  { 0x1851, BIDI_L   },  // MONGOLIAN LETTER TODO DA
  { 0x1852, BIDI_L   },  // MONGOLIAN LETTER TODO CHA
  { 0x1853, BIDI_L   },  // MONGOLIAN LETTER TODO JA
  { 0x1854, BIDI_L   },  // MONGOLIAN LETTER TODO TSA
  { 0x1855, BIDI_L   },  // MONGOLIAN LETTER TODO YA
  { 0x1856, BIDI_L   },  // MONGOLIAN LETTER TODO WA
  { 0x1857, BIDI_L   },  // MONGOLIAN LETTER TODO KA
  { 0x1858, BIDI_L   },  // MONGOLIAN LETTER TODO GAA
  { 0x1859, BIDI_L   },  // MONGOLIAN LETTER TODO HAA
  { 0x185A, BIDI_L   },  // MONGOLIAN LETTER TODO JIA
  { 0x185B, BIDI_L   },  // MONGOLIAN LETTER TODO NIA
  { 0x185C, BIDI_L   },  // MONGOLIAN LETTER TODO DZA
  { 0x185D, BIDI_L   },  // MONGOLIAN LETTER SIBE E
  { 0x185E, BIDI_L   },  // MONGOLIAN LETTER SIBE I
  { 0x185F, BIDI_L   },  // MONGOLIAN LETTER SIBE IY
  { 0x1860, BIDI_L   },  // MONGOLIAN LETTER SIBE UE
  { 0x1861, BIDI_L   },  // MONGOLIAN LETTER SIBE U
  { 0x1862, BIDI_L   },  // MONGOLIAN LETTER SIBE ANG
  { 0x1863, BIDI_L   },  // MONGOLIAN LETTER SIBE KA
  { 0x1864, BIDI_L   },  // MONGOLIAN LETTER SIBE GA
  { 0x1865, BIDI_L   },  // MONGOLIAN LETTER SIBE HA
  { 0x1866, BIDI_L   },  // MONGOLIAN LETTER SIBE PA
  { 0x1867, BIDI_L   },  // MONGOLIAN LETTER SIBE SHA
  { 0x1868, BIDI_L   },  // MONGOLIAN LETTER SIBE TA
  { 0x1869, BIDI_L   },  // MONGOLIAN LETTER SIBE DA
  { 0x186A, BIDI_L   },  // MONGOLIAN LETTER SIBE JA
  { 0x186B, BIDI_L   },  // MONGOLIAN LETTER SIBE FA
  { 0x186C, BIDI_L   },  // MONGOLIAN LETTER SIBE GAA
  { 0x186D, BIDI_L   },  // MONGOLIAN LETTER SIBE HAA
  { 0x186E, BIDI_L   },  // MONGOLIAN LETTER SIBE TSA
  { 0x186F, BIDI_L   },  // MONGOLIAN LETTER SIBE ZA
  { 0x1870, BIDI_L   },  // MONGOLIAN LETTER SIBE RAA
  { 0x1871, BIDI_L   },  // MONGOLIAN LETTER SIBE CHA
  { 0x1872, BIDI_L   },  // MONGOLIAN LETTER SIBE ZHA
  { 0x1873, BIDI_L   },  // MONGOLIAN LETTER MANCHU I
  { 0x1874, BIDI_L   },  // MONGOLIAN LETTER MANCHU KA
  { 0x1875, BIDI_L   },  // MONGOLIAN LETTER MANCHU RA
  { 0x1876, BIDI_L   },  // MONGOLIAN LETTER MANCHU FA
  { 0x1877, BIDI_L   },  // MONGOLIAN LETTER MANCHU ZHA
  { 0x1880, BIDI_L   },  // MONGOLIAN LETTER ALI GALI ANUSVARA ONE
  { 0x1881, BIDI_L   },  // MONGOLIAN LETTER ALI GALI VISARGA ONE
  { 0x1882, BIDI_L   },  // MONGOLIAN LETTER ALI GALI DAMARU
  { 0x1883, BIDI_L   },  // MONGOLIAN LETTER ALI GALI UBADAMA
  { 0x1884, BIDI_L   },  // MONGOLIAN LETTER ALI GALI INVERTED UBADAMA
  { 0x1885, BIDI_L   },  // MONGOLIAN LETTER ALI GALI BALUDA
  { 0x1886, BIDI_L   },  // MONGOLIAN LETTER ALI GALI THREE BALUDA
  { 0x1887, BIDI_L   },  // MONGOLIAN LETTER ALI GALI A
  { 0x1888, BIDI_L   },  // MONGOLIAN LETTER ALI GALI I
  { 0x1889, BIDI_L   },  // MONGOLIAN LETTER ALI GALI KA
  { 0x188A, BIDI_L   },  // MONGOLIAN LETTER ALI GALI NGA
  { 0x188B, BIDI_L   },  // MONGOLIAN LETTER ALI GALI CA
  { 0x188C, BIDI_L   },  // MONGOLIAN LETTER ALI GALI TTA
  { 0x188D, BIDI_L   },  // MONGOLIAN LETTER ALI GALI TTHA
  { 0x188E, BIDI_L   },  // MONGOLIAN LETTER ALI GALI DDA
  { 0x188F, BIDI_L   },  // MONGOLIAN LETTER ALI GALI NNA
  { 0x1890, BIDI_L   },  // MONGOLIAN LETTER ALI GALI TA
  { 0x1891, BIDI_L   },  // MONGOLIAN LETTER ALI GALI DA
  { 0x1892, BIDI_L   },  // MONGOLIAN LETTER ALI GALI PA
  { 0x1893, BIDI_L   },  // MONGOLIAN LETTER ALI GALI PHA
  { 0x1894, BIDI_L   },  // MONGOLIAN LETTER ALI GALI SSA
  { 0x1895, BIDI_L   },  // MONGOLIAN LETTER ALI GALI ZHA
  { 0x1896, BIDI_L   },  // MONGOLIAN LETTER ALI GALI ZA
  { 0x1897, BIDI_L   },  // MONGOLIAN LETTER ALI GALI AH
  { 0x1898, BIDI_L   },  // MONGOLIAN LETTER TODO ALI GALI TA
  { 0x1899, BIDI_L   },  // MONGOLIAN LETTER TODO ALI GALI ZHA
  { 0x189A, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI GHA
  { 0x189B, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI NGA
  { 0x189C, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI CA
  { 0x189D, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI JHA
  { 0x189E, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI TTA
  { 0x189F, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI DDHA
  { 0x18A0, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI TA
  { 0x18A1, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI DHA
  { 0x18A2, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI SSA
  { 0x18A3, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI CYA
  { 0x18A4, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI ZHA
  { 0x18A5, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI ZA
  { 0x18A6, BIDI_L   },  // MONGOLIAN LETTER ALI GALI HALF U
  { 0x18A7, BIDI_L   },  // MONGOLIAN LETTER ALI GALI HALF YA
  { 0x18A8, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI BHA
  { 0x18A9, BIDI_NSM },  // MONGOLIAN LETTER ALI GALI DAGALGA
  { 0x18AA, BIDI_L   },  // MONGOLIAN LETTER MANCHU ALI GALI LHA
  { 0x18B0, BIDI_L   },  // CANADIAN SYLLABICS OY
  { 0x18B1, BIDI_L   },  // CANADIAN SYLLABICS AY
  { 0x18B2, BIDI_L   },  // CANADIAN SYLLABICS AAY
  { 0x18B3, BIDI_L   },  // CANADIAN SYLLABICS WAY
  { 0x18B4, BIDI_L   },  // CANADIAN SYLLABICS POY
  { 0x18B5, BIDI_L   },  // CANADIAN SYLLABICS PAY
  { 0x18B6, BIDI_L   },  // CANADIAN SYLLABICS PWOY
  { 0x18B7, BIDI_L   },  // CANADIAN SYLLABICS TAY
  { 0x18B8, BIDI_L   },  // CANADIAN SYLLABICS KAY
  { 0x18B9, BIDI_L   },  // CANADIAN SYLLABICS KWAY
  { 0x18BA, BIDI_L   },  // CANADIAN SYLLABICS MAY
  { 0x18BB, BIDI_L   },  // CANADIAN SYLLABICS NOY
  { 0x18BC, BIDI_L   },  // CANADIAN SYLLABICS NAY
  { 0x18BD, BIDI_L   },  // CANADIAN SYLLABICS LAY
  { 0x18BE, BIDI_L   },  // CANADIAN SYLLABICS SOY
  { 0x18BF, BIDI_L   },  // CANADIAN SYLLABICS SAY
  { 0x18C0, BIDI_L   },  // CANADIAN SYLLABICS SHOY
  { 0x18C1, BIDI_L   },  // CANADIAN SYLLABICS SHAY
  { 0x18C2, BIDI_L   },  // CANADIAN SYLLABICS SHWOY
  { 0x18C3, BIDI_L   },  // CANADIAN SYLLABICS YOY
  { 0x18C4, BIDI_L   },  // CANADIAN SYLLABICS YAY
  { 0x18C5, BIDI_L   },  // CANADIAN SYLLABICS RAY
  { 0x18C6, BIDI_L   },  // CANADIAN SYLLABICS NWI
  { 0x18C7, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY NWI
  { 0x18C8, BIDI_L   },  // CANADIAN SYLLABICS NWII
  { 0x18C9, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY NWII
  { 0x18CA, BIDI_L   },  // CANADIAN SYLLABICS NWO
  { 0x18CB, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY NWO
  { 0x18CC, BIDI_L   },  // CANADIAN SYLLABICS NWOO
  { 0x18CD, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY NWOO
  { 0x18CE, BIDI_L   },  // CANADIAN SYLLABICS RWEE
  { 0x18CF, BIDI_L   },  // CANADIAN SYLLABICS RWI
  { 0x18D0, BIDI_L   },  // CANADIAN SYLLABICS RWII
  { 0x18D1, BIDI_L   },  // CANADIAN SYLLABICS RWO
  { 0x18D2, BIDI_L   },  // CANADIAN SYLLABICS RWOO
  { 0x18D3, BIDI_L   },  // CANADIAN SYLLABICS RWA
  { 0x18D4, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY P
  { 0x18D5, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY T
  { 0x18D6, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY K
  { 0x18D7, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY C
  { 0x18D8, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY M
  { 0x18D9, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY N
  { 0x18DA, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY S
  { 0x18DB, BIDI_L   },  // CANADIAN SYLLABICS OJIBWAY SH
  { 0x18DC, BIDI_L   },  // CANADIAN SYLLABICS EASTERN W
  { 0x18DD, BIDI_L   },  // CANADIAN SYLLABICS WESTERN W
  { 0x18DE, BIDI_L   },  // CANADIAN SYLLABICS FINAL SMALL RING
  { 0x18DF, BIDI_L   },  // CANADIAN SYLLABICS FINAL RAISED DOT
  { 0x18E0, BIDI_L   },  // CANADIAN SYLLABICS R-CREE RWE
  { 0x18E1, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LOO
  { 0x18E2, BIDI_L   },  // CANADIAN SYLLABICS WEST-CREE LAA
  { 0x18E3, BIDI_L   },  // CANADIAN SYLLABICS THWE
  { 0x18E4, BIDI_L   },  // CANADIAN SYLLABICS THWA
  { 0x18E5, BIDI_L   },  // CANADIAN SYLLABICS TTHWE
  { 0x18E6, BIDI_L   },  // CANADIAN SYLLABICS TTHOO
  { 0x18E7, BIDI_L   },  // CANADIAN SYLLABICS TTHAA
  { 0x18E8, BIDI_L   },  // CANADIAN SYLLABICS TLHWE
  { 0x18E9, BIDI_L   },  // CANADIAN SYLLABICS TLHOO
  { 0x18EA, BIDI_L   },  // CANADIAN SYLLABICS SAYISI SHWE
  { 0x18EB, BIDI_L   },  // CANADIAN SYLLABICS SAYISI SHOO
  { 0x18EC, BIDI_L   },  // CANADIAN SYLLABICS SAYISI HOO
  { 0x18ED, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GWU
  { 0x18EE, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DENE GEE
  { 0x18EF, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GAA
  { 0x18F0, BIDI_L   },  // CANADIAN SYLLABICS CARRIER GWA
  { 0x18F1, BIDI_L   },  // CANADIAN SYLLABICS SAYISI JUU
  { 0x18F2, BIDI_L   },  // CANADIAN SYLLABICS CARRIER JWA
  { 0x18F3, BIDI_L   },  // CANADIAN SYLLABICS BEAVER DENE L
  { 0x18F4, BIDI_L   },  // CANADIAN SYLLABICS BEAVER DENE R
  { 0x18F5, BIDI_L   },  // CANADIAN SYLLABICS CARRIER DENTAL S
  { 0x1900, BIDI_L   },  // LIMBU VOWEL-CARRIER LETTER
  { 0x1901, BIDI_L   },  // LIMBU LETTER KA
  { 0x1902, BIDI_L   },  // LIMBU LETTER KHA
  { 0x1903, BIDI_L   },  // LIMBU LETTER GA
  { 0x1904, BIDI_L   },  // LIMBU LETTER GHA
  { 0x1905, BIDI_L   },  // LIMBU LETTER NGA
  { 0x1906, BIDI_L   },  // LIMBU LETTER CA
  { 0x1907, BIDI_L   },  // LIMBU LETTER CHA
  { 0x1908, BIDI_L   },  // LIMBU LETTER JA
  { 0x1909, BIDI_L   },  // LIMBU LETTER JHA
  { 0x190A, BIDI_L   },  // LIMBU LETTER YAN
  { 0x190B, BIDI_L   },  // LIMBU LETTER TA
  { 0x190C, BIDI_L   },  // LIMBU LETTER THA
  { 0x190D, BIDI_L   },  // LIMBU LETTER DA
  { 0x190E, BIDI_L   },  // LIMBU LETTER DHA
  { 0x190F, BIDI_L   },  // LIMBU LETTER NA
  { 0x1910, BIDI_L   },  // LIMBU LETTER PA
  { 0x1911, BIDI_L   },  // LIMBU LETTER PHA
  { 0x1912, BIDI_L   },  // LIMBU LETTER BA
  { 0x1913, BIDI_L   },  // LIMBU LETTER BHA
  { 0x1914, BIDI_L   },  // LIMBU LETTER MA
  { 0x1915, BIDI_L   },  // LIMBU LETTER YA
  { 0x1916, BIDI_L   },  // LIMBU LETTER RA
  { 0x1917, BIDI_L   },  // LIMBU LETTER LA
  { 0x1918, BIDI_L   },  // LIMBU LETTER WA
  { 0x1919, BIDI_L   },  // LIMBU LETTER SHA
  { 0x191A, BIDI_L   },  // LIMBU LETTER SSA
  { 0x191B, BIDI_L   },  // LIMBU LETTER SA
  { 0x191C, BIDI_L   },  // LIMBU LETTER HA
  { 0x191D, BIDI_L   },  // LIMBU LETTER GYAN
  { 0x191E, BIDI_L   },  // LIMBU LETTER TRA
  { 0x1920, BIDI_NSM },  // LIMBU VOWEL SIGN A
  { 0x1921, BIDI_NSM },  // LIMBU VOWEL SIGN I
  { 0x1922, BIDI_NSM },  // LIMBU VOWEL SIGN U
  { 0x1923, BIDI_L   },  // LIMBU VOWEL SIGN EE
  { 0x1924, BIDI_L   },  // LIMBU VOWEL SIGN AI
  { 0x1925, BIDI_L   },  // LIMBU VOWEL SIGN OO
  { 0x1926, BIDI_L   },  // LIMBU VOWEL SIGN AU
  { 0x1927, BIDI_NSM },  // LIMBU VOWEL SIGN E
  { 0x1928, BIDI_NSM },  // LIMBU VOWEL SIGN O
  { 0x1929, BIDI_L   },  // LIMBU SUBJOINED LETTER YA
  { 0x192A, BIDI_L   },  // LIMBU SUBJOINED LETTER RA
  { 0x192B, BIDI_L   },  // LIMBU SUBJOINED LETTER WA
  { 0x1930, BIDI_L   },  // LIMBU SMALL LETTER KA
  { 0x1931, BIDI_L   },  // LIMBU SMALL LETTER NGA
  { 0x1932, BIDI_NSM },  // LIMBU SMALL LETTER ANUSVARA
  { 0x1933, BIDI_L   },  // LIMBU SMALL LETTER TA
  { 0x1934, BIDI_L   },  // LIMBU SMALL LETTER NA
  { 0x1935, BIDI_L   },  // LIMBU SMALL LETTER PA
  { 0x1936, BIDI_L   },  // LIMBU SMALL LETTER MA
  { 0x1937, BIDI_L   },  // LIMBU SMALL LETTER RA
  { 0x1938, BIDI_L   },  // LIMBU SMALL LETTER LA
  { 0x1939, BIDI_NSM },  // LIMBU SIGN MUKPHRENG
  { 0x193A, BIDI_NSM },  // LIMBU SIGN KEMPHRENG
  { 0x193B, BIDI_NSM },  // LIMBU SIGN SA-I
  { 0x1940, BIDI_ON  },  // LIMBU SIGN LOO
  { 0x1944, BIDI_ON  },  // LIMBU EXCLAMATION MARK
  { 0x1945, BIDI_ON  },  // LIMBU QUESTION MARK
  { 0x1946, BIDI_L   },  // LIMBU DIGIT ZERO
  { 0x1947, BIDI_L   },  // LIMBU DIGIT ONE
  { 0x1948, BIDI_L   },  // LIMBU DIGIT TWO
  { 0x1949, BIDI_L   },  // LIMBU DIGIT THREE
  { 0x194A, BIDI_L   },  // LIMBU DIGIT FOUR
  { 0x194B, BIDI_L   },  // LIMBU DIGIT FIVE
  { 0x194C, BIDI_L   },  // LIMBU DIGIT SIX
  { 0x194D, BIDI_L   },  // LIMBU DIGIT SEVEN
  { 0x194E, BIDI_L   },  // LIMBU DIGIT EIGHT
  { 0x194F, BIDI_L   },  // LIMBU DIGIT NINE
  { 0x1950, BIDI_L   },  // TAI LE LETTER KA
  { 0x1951, BIDI_L   },  // TAI LE LETTER XA
  { 0x1952, BIDI_L   },  // TAI LE LETTER NGA
  { 0x1953, BIDI_L   },  // TAI LE LETTER TSA
  { 0x1954, BIDI_L   },  // TAI LE LETTER SA
  { 0x1955, BIDI_L   },  // TAI LE LETTER YA
  { 0x1956, BIDI_L   },  // TAI LE LETTER TA
  { 0x1957, BIDI_L   },  // TAI LE LETTER THA
  { 0x1958, BIDI_L   },  // TAI LE LETTER LA
  { 0x1959, BIDI_L   },  // TAI LE LETTER PA
  { 0x195A, BIDI_L   },  // TAI LE LETTER PHA
  { 0x195B, BIDI_L   },  // TAI LE LETTER MA
  { 0x195C, BIDI_L   },  // TAI LE LETTER FA
  { 0x195D, BIDI_L   },  // TAI LE LETTER VA
  { 0x195E, BIDI_L   },  // TAI LE LETTER HA
  { 0x195F, BIDI_L   },  // TAI LE LETTER QA
  { 0x1960, BIDI_L   },  // TAI LE LETTER KHA
  { 0x1961, BIDI_L   },  // TAI LE LETTER TSHA
  { 0x1962, BIDI_L   },  // TAI LE LETTER NA
  { 0x1963, BIDI_L   },  // TAI LE LETTER A
  { 0x1964, BIDI_L   },  // TAI LE LETTER I
  { 0x1965, BIDI_L   },  // TAI LE LETTER EE
  { 0x1966, BIDI_L   },  // TAI LE LETTER EH
  { 0x1967, BIDI_L   },  // TAI LE LETTER U
  { 0x1968, BIDI_L   },  // TAI LE LETTER OO
  { 0x1969, BIDI_L   },  // TAI LE LETTER O
  { 0x196A, BIDI_L   },  // TAI LE LETTER UE
  { 0x196B, BIDI_L   },  // TAI LE LETTER E
  { 0x196C, BIDI_L   },  // TAI LE LETTER AUE
  { 0x196D, BIDI_L   },  // TAI LE LETTER AI
  { 0x1970, BIDI_L   },  // TAI LE LETTER TONE-2
  { 0x1971, BIDI_L   },  // TAI LE LETTER TONE-3
  { 0x1972, BIDI_L   },  // TAI LE LETTER TONE-4
  { 0x1973, BIDI_L   },  // TAI LE LETTER TONE-5
  { 0x1974, BIDI_L   },  // TAI LE LETTER TONE-6
  { 0x1980, BIDI_L   },  // NEW TAI LUE LETTER HIGH QA
  { 0x1981, BIDI_L   },  // NEW TAI LUE LETTER LOW QA
  { 0x1982, BIDI_L   },  // NEW TAI LUE LETTER HIGH KA
  { 0x1983, BIDI_L   },  // NEW TAI LUE LETTER HIGH XA
  { 0x1984, BIDI_L   },  // NEW TAI LUE LETTER HIGH NGA
  { 0x1985, BIDI_L   },  // NEW TAI LUE LETTER LOW KA
  { 0x1986, BIDI_L   },  // NEW TAI LUE LETTER LOW XA
  { 0x1987, BIDI_L   },  // NEW TAI LUE LETTER LOW NGA
  { 0x1988, BIDI_L   },  // NEW TAI LUE LETTER HIGH TSA
  { 0x1989, BIDI_L   },  // NEW TAI LUE LETTER HIGH SA
  { 0x198A, BIDI_L   },  // NEW TAI LUE LETTER HIGH YA
  { 0x198B, BIDI_L   },  // NEW TAI LUE LETTER LOW TSA
  { 0x198C, BIDI_L   },  // NEW TAI LUE LETTER LOW SA
  { 0x198D, BIDI_L   },  // NEW TAI LUE LETTER LOW YA
  { 0x198E, BIDI_L   },  // NEW TAI LUE LETTER HIGH TA
  { 0x198F, BIDI_L   },  // NEW TAI LUE LETTER HIGH THA
  { 0x1990, BIDI_L   },  // NEW TAI LUE LETTER HIGH NA
  { 0x1991, BIDI_L   },  // NEW TAI LUE LETTER LOW TA
  { 0x1992, BIDI_L   },  // NEW TAI LUE LETTER LOW THA
  { 0x1993, BIDI_L   },  // NEW TAI LUE LETTER LOW NA
  { 0x1994, BIDI_L   },  // NEW TAI LUE LETTER HIGH PA
  { 0x1995, BIDI_L   },  // NEW TAI LUE LETTER HIGH PHA
  { 0x1996, BIDI_L   },  // NEW TAI LUE LETTER HIGH MA
  { 0x1997, BIDI_L   },  // NEW TAI LUE LETTER LOW PA
  { 0x1998, BIDI_L   },  // NEW TAI LUE LETTER LOW PHA
  { 0x1999, BIDI_L   },  // NEW TAI LUE LETTER LOW MA
  { 0x199A, BIDI_L   },  // NEW TAI LUE LETTER HIGH FA
  { 0x199B, BIDI_L   },  // NEW TAI LUE LETTER HIGH VA
  { 0x199C, BIDI_L   },  // NEW TAI LUE LETTER HIGH LA
  { 0x199D, BIDI_L   },  // NEW TAI LUE LETTER LOW FA
  { 0x199E, BIDI_L   },  // NEW TAI LUE LETTER LOW VA
  { 0x199F, BIDI_L   },  // NEW TAI LUE LETTER LOW LA
  { 0x19A0, BIDI_L   },  // NEW TAI LUE LETTER HIGH HA
  { 0x19A1, BIDI_L   },  // NEW TAI LUE LETTER HIGH DA
  { 0x19A2, BIDI_L   },  // NEW TAI LUE LETTER HIGH BA
  { 0x19A3, BIDI_L   },  // NEW TAI LUE LETTER LOW HA
  { 0x19A4, BIDI_L   },  // NEW TAI LUE LETTER LOW DA
  { 0x19A5, BIDI_L   },  // NEW TAI LUE LETTER LOW BA
  { 0x19A6, BIDI_L   },  // NEW TAI LUE LETTER HIGH KVA
  { 0x19A7, BIDI_L   },  // NEW TAI LUE LETTER HIGH XVA
  { 0x19A8, BIDI_L   },  // NEW TAI LUE LETTER LOW KVA
  { 0x19A9, BIDI_L   },  // NEW TAI LUE LETTER LOW XVA
  { 0x19AA, BIDI_L   },  // NEW TAI LUE LETTER HIGH SUA
  { 0x19AB, BIDI_L   },  // NEW TAI LUE LETTER LOW SUA
  { 0x19B0, BIDI_L   },  // NEW TAI LUE VOWEL SIGN VOWEL SHORTENER
  { 0x19B1, BIDI_L   },  // NEW TAI LUE VOWEL SIGN AA
  { 0x19B2, BIDI_L   },  // NEW TAI LUE VOWEL SIGN II
  { 0x19B3, BIDI_L   },  // NEW TAI LUE VOWEL SIGN U
  { 0x19B4, BIDI_L   },  // NEW TAI LUE VOWEL SIGN UU
  { 0x19B5, BIDI_L   },  // NEW TAI LUE VOWEL SIGN E
  { 0x19B6, BIDI_L   },  // NEW TAI LUE VOWEL SIGN AE
  { 0x19B7, BIDI_L   },  // NEW TAI LUE VOWEL SIGN O
  { 0x19B8, BIDI_L   },  // NEW TAI LUE VOWEL SIGN OA
  { 0x19B9, BIDI_L   },  // NEW TAI LUE VOWEL SIGN UE
  { 0x19BA, BIDI_L   },  // NEW TAI LUE VOWEL SIGN AY
  { 0x19BB, BIDI_L   },  // NEW TAI LUE VOWEL SIGN AAY
  { 0x19BC, BIDI_L   },  // NEW TAI LUE VOWEL SIGN UY
  { 0x19BD, BIDI_L   },  // NEW TAI LUE VOWEL SIGN OY
  { 0x19BE, BIDI_L   },  // NEW TAI LUE VOWEL SIGN OAY
  { 0x19BF, BIDI_L   },  // NEW TAI LUE VOWEL SIGN UEY
  { 0x19C0, BIDI_L   },  // NEW TAI LUE VOWEL SIGN IY
  { 0x19C1, BIDI_L   },  // NEW TAI LUE LETTER FINAL V
  { 0x19C2, BIDI_L   },  // NEW TAI LUE LETTER FINAL NG
  { 0x19C3, BIDI_L   },  // NEW TAI LUE LETTER FINAL N
  { 0x19C4, BIDI_L   },  // NEW TAI LUE LETTER FINAL M
  { 0x19C5, BIDI_L   },  // NEW TAI LUE LETTER FINAL K
  { 0x19C6, BIDI_L   },  // NEW TAI LUE LETTER FINAL D
  { 0x19C7, BIDI_L   },  // NEW TAI LUE LETTER FINAL B
  { 0x19C8, BIDI_L   },  // NEW TAI LUE TONE MARK-1
  { 0x19C9, BIDI_L   },  // NEW TAI LUE TONE MARK-2
  { 0x19D0, BIDI_L   },  // NEW TAI LUE DIGIT ZERO
  { 0x19D1, BIDI_L   },  // NEW TAI LUE DIGIT ONE
  { 0x19D2, BIDI_L   },  // NEW TAI LUE DIGIT TWO
  { 0x19D3, BIDI_L   },  // NEW TAI LUE DIGIT THREE
  { 0x19D4, BIDI_L   },  // NEW TAI LUE DIGIT FOUR
  { 0x19D5, BIDI_L   },  // NEW TAI LUE DIGIT FIVE
  { 0x19D6, BIDI_L   },  // NEW TAI LUE DIGIT SIX
  { 0x19D7, BIDI_L   },  // NEW TAI LUE DIGIT SEVEN
  { 0x19D8, BIDI_L   },  // NEW TAI LUE DIGIT EIGHT
  { 0x19D9, BIDI_L   },  // NEW TAI LUE DIGIT NINE
  { 0x19DA, BIDI_L   },  // NEW TAI LUE THAM DIGIT ONE
  { 0x19DE, BIDI_ON  },  // NEW TAI LUE SIGN LAE
  { 0x19DF, BIDI_ON  },  // NEW TAI LUE SIGN LAEV
  { 0x19E0, BIDI_ON  },  // KHMER SYMBOL PATHAMASAT
  { 0x19E1, BIDI_ON  },  // KHMER SYMBOL MUOY KOET
  { 0x19E2, BIDI_ON  },  // KHMER SYMBOL PII KOET
  { 0x19E3, BIDI_ON  },  // KHMER SYMBOL BEI KOET
  { 0x19E4, BIDI_ON  },  // KHMER SYMBOL BUON KOET
  { 0x19E5, BIDI_ON  },  // KHMER SYMBOL PRAM KOET
  { 0x19E6, BIDI_ON  },  // KHMER SYMBOL PRAM-MUOY KOET
  { 0x19E7, BIDI_ON  },  // KHMER SYMBOL PRAM-PII KOET
  { 0x19E8, BIDI_ON  },  // KHMER SYMBOL PRAM-BEI KOET
  { 0x19E9, BIDI_ON  },  // KHMER SYMBOL PRAM-BUON KOET
  { 0x19EA, BIDI_ON  },  // KHMER SYMBOL DAP KOET
  { 0x19EB, BIDI_ON  },  // KHMER SYMBOL DAP-MUOY KOET
  { 0x19EC, BIDI_ON  },  // KHMER SYMBOL DAP-PII KOET
  { 0x19ED, BIDI_ON  },  // KHMER SYMBOL DAP-BEI KOET
  { 0x19EE, BIDI_ON  },  // KHMER SYMBOL DAP-BUON KOET
  { 0x19EF, BIDI_ON  },  // KHMER SYMBOL DAP-PRAM KOET
  { 0x19F0, BIDI_ON  },  // KHMER SYMBOL TUTEYASAT
  { 0x19F1, BIDI_ON  },  // KHMER SYMBOL MUOY ROC
  { 0x19F2, BIDI_ON  },  // KHMER SYMBOL PII ROC
  { 0x19F3, BIDI_ON  },  // KHMER SYMBOL BEI ROC
  { 0x19F4, BIDI_ON  },  // KHMER SYMBOL BUON ROC
  { 0x19F5, BIDI_ON  },  // KHMER SYMBOL PRAM ROC
  { 0x19F6, BIDI_ON  },  // KHMER SYMBOL PRAM-MUOY ROC
  { 0x19F7, BIDI_ON  },  // KHMER SYMBOL PRAM-PII ROC
  { 0x19F8, BIDI_ON  },  // KHMER SYMBOL PRAM-BEI ROC
  { 0x19F9, BIDI_ON  },  // KHMER SYMBOL PRAM-BUON ROC
  { 0x19FA, BIDI_ON  },  // KHMER SYMBOL DAP ROC
  { 0x19FB, BIDI_ON  },  // KHMER SYMBOL DAP-MUOY ROC
  { 0x19FC, BIDI_ON  },  // KHMER SYMBOL DAP-PII ROC
  { 0x19FD, BIDI_ON  },  // KHMER SYMBOL DAP-BEI ROC
  { 0x19FE, BIDI_ON  },  // KHMER SYMBOL DAP-BUON ROC
  { 0x19FF, BIDI_ON  },  // KHMER SYMBOL DAP-PRAM ROC
  { 0x1A00, BIDI_L   },  // BUGINESE LETTER KA
  { 0x1A01, BIDI_L   },  // BUGINESE LETTER GA
  { 0x1A02, BIDI_L   },  // BUGINESE LETTER NGA
  { 0x1A03, BIDI_L   },  // BUGINESE LETTER NGKA
  { 0x1A04, BIDI_L   },  // BUGINESE LETTER PA
  { 0x1A05, BIDI_L   },  // BUGINESE LETTER BA
  { 0x1A06, BIDI_L   },  // BUGINESE LETTER MA
  { 0x1A07, BIDI_L   },  // BUGINESE LETTER MPA
  { 0x1A08, BIDI_L   },  // BUGINESE LETTER TA
  { 0x1A09, BIDI_L   },  // BUGINESE LETTER DA
  { 0x1A0A, BIDI_L   },  // BUGINESE LETTER NA
  { 0x1A0B, BIDI_L   },  // BUGINESE LETTER NRA
  { 0x1A0C, BIDI_L   },  // BUGINESE LETTER CA
  { 0x1A0D, BIDI_L   },  // BUGINESE LETTER JA
  { 0x1A0E, BIDI_L   },  // BUGINESE LETTER NYA
  { 0x1A0F, BIDI_L   },  // BUGINESE LETTER NYCA
  { 0x1A10, BIDI_L   },  // BUGINESE LETTER YA
  { 0x1A11, BIDI_L   },  // BUGINESE LETTER RA
  { 0x1A12, BIDI_L   },  // BUGINESE LETTER LA
  { 0x1A13, BIDI_L   },  // BUGINESE LETTER VA
  { 0x1A14, BIDI_L   },  // BUGINESE LETTER SA
  { 0x1A15, BIDI_L   },  // BUGINESE LETTER A
  { 0x1A16, BIDI_L   },  // BUGINESE LETTER HA
  { 0x1A17, BIDI_NSM },  // BUGINESE VOWEL SIGN I
  { 0x1A18, BIDI_NSM },  // BUGINESE VOWEL SIGN U
  { 0x1A19, BIDI_L   },  // BUGINESE VOWEL SIGN E
  { 0x1A1A, BIDI_L   },  // BUGINESE VOWEL SIGN O
  { 0x1A1B, BIDI_NSM },  // BUGINESE VOWEL SIGN AE
  { 0x1A1E, BIDI_L   },  // BUGINESE PALLAWA
  { 0x1A1F, BIDI_L   },  // BUGINESE END OF SECTION
  { 0x1A20, BIDI_L   },  // TAI THAM LETTER HIGH KA
  { 0x1A21, BIDI_L   },  // TAI THAM LETTER HIGH KHA
  { 0x1A22, BIDI_L   },  // TAI THAM LETTER HIGH KXA
  { 0x1A23, BIDI_L   },  // TAI THAM LETTER LOW KA
  { 0x1A24, BIDI_L   },  // TAI THAM LETTER LOW KXA
  { 0x1A25, BIDI_L   },  // TAI THAM LETTER LOW KHA
  { 0x1A26, BIDI_L   },  // TAI THAM LETTER NGA
  { 0x1A27, BIDI_L   },  // TAI THAM LETTER HIGH CA
  { 0x1A28, BIDI_L   },  // TAI THAM LETTER HIGH CHA
  { 0x1A29, BIDI_L   },  // TAI THAM LETTER LOW CA
  { 0x1A2A, BIDI_L   },  // TAI THAM LETTER LOW SA
  { 0x1A2B, BIDI_L   },  // TAI THAM LETTER LOW CHA
  { 0x1A2C, BIDI_L   },  // TAI THAM LETTER NYA
  { 0x1A2D, BIDI_L   },  // TAI THAM LETTER RATA
  { 0x1A2E, BIDI_L   },  // TAI THAM LETTER HIGH RATHA
  { 0x1A2F, BIDI_L   },  // TAI THAM LETTER DA
  { 0x1A30, BIDI_L   },  // TAI THAM LETTER LOW RATHA
  { 0x1A31, BIDI_L   },  // TAI THAM LETTER RANA
  { 0x1A32, BIDI_L   },  // TAI THAM LETTER HIGH TA
  { 0x1A33, BIDI_L   },  // TAI THAM LETTER HIGH THA
  { 0x1A34, BIDI_L   },  // TAI THAM LETTER LOW TA
  { 0x1A35, BIDI_L   },  // TAI THAM LETTER LOW THA
  { 0x1A36, BIDI_L   },  // TAI THAM LETTER NA
  { 0x1A37, BIDI_L   },  // TAI THAM LETTER BA
  { 0x1A38, BIDI_L   },  // TAI THAM LETTER HIGH PA
  { 0x1A39, BIDI_L   },  // TAI THAM LETTER HIGH PHA
  { 0x1A3A, BIDI_L   },  // TAI THAM LETTER HIGH FA
  { 0x1A3B, BIDI_L   },  // TAI THAM LETTER LOW PA
  { 0x1A3C, BIDI_L   },  // TAI THAM LETTER LOW FA
  { 0x1A3D, BIDI_L   },  // TAI THAM LETTER LOW PHA
  { 0x1A3E, BIDI_L   },  // TAI THAM LETTER MA
  { 0x1A3F, BIDI_L   },  // TAI THAM LETTER LOW YA
  { 0x1A40, BIDI_L   },  // TAI THAM LETTER HIGH YA
  { 0x1A41, BIDI_L   },  // TAI THAM LETTER RA
  { 0x1A42, BIDI_L   },  // TAI THAM LETTER RUE
  { 0x1A43, BIDI_L   },  // TAI THAM LETTER LA
  { 0x1A44, BIDI_L   },  // TAI THAM LETTER LUE
  { 0x1A45, BIDI_L   },  // TAI THAM LETTER WA
  { 0x1A46, BIDI_L   },  // TAI THAM LETTER HIGH SHA
  { 0x1A47, BIDI_L   },  // TAI THAM LETTER HIGH SSA
  { 0x1A48, BIDI_L   },  // TAI THAM LETTER HIGH SA
  { 0x1A49, BIDI_L   },  // TAI THAM LETTER HIGH HA
  { 0x1A4A, BIDI_L   },  // TAI THAM LETTER LLA
  { 0x1A4B, BIDI_L   },  // TAI THAM LETTER A
  { 0x1A4C, BIDI_L   },  // TAI THAM LETTER LOW HA
  { 0x1A4D, BIDI_L   },  // TAI THAM LETTER I
  { 0x1A4E, BIDI_L   },  // TAI THAM LETTER II
  { 0x1A4F, BIDI_L   },  // TAI THAM LETTER U
  { 0x1A50, BIDI_L   },  // TAI THAM LETTER UU
  { 0x1A51, BIDI_L   },  // TAI THAM LETTER EE
  { 0x1A52, BIDI_L   },  // TAI THAM LETTER OO
  { 0x1A53, BIDI_L   },  // TAI THAM LETTER LAE
  { 0x1A54, BIDI_L   },  // TAI THAM LETTER GREAT SA
  { 0x1A55, BIDI_L   },  // TAI THAM CONSONANT SIGN MEDIAL RA
  { 0x1A56, BIDI_NSM },  // TAI THAM CONSONANT SIGN MEDIAL LA
  { 0x1A57, BIDI_L   },  // TAI THAM CONSONANT SIGN LA TANG LAI
  { 0x1A58, BIDI_NSM },  // TAI THAM SIGN MAI KANG LAI
  { 0x1A59, BIDI_NSM },  // TAI THAM CONSONANT SIGN FINAL NGA
  { 0x1A5A, BIDI_NSM },  // TAI THAM CONSONANT SIGN LOW PA
  { 0x1A5B, BIDI_NSM },  // TAI THAM CONSONANT SIGN HIGH RATHA OR LOW PA
  { 0x1A5C, BIDI_NSM },  // TAI THAM CONSONANT SIGN MA
  { 0x1A5D, BIDI_NSM },  // TAI THAM CONSONANT SIGN BA
  { 0x1A5E, BIDI_NSM },  // TAI THAM CONSONANT SIGN SA
  { 0x1A60, BIDI_NSM },  // TAI THAM SIGN SAKOT
  { 0x1A61, BIDI_L   },  // TAI THAM VOWEL SIGN A
  { 0x1A62, BIDI_NSM },  // TAI THAM VOWEL SIGN MAI SAT
  { 0x1A63, BIDI_L   },  // TAI THAM VOWEL SIGN AA
  { 0x1A64, BIDI_L   },  // TAI THAM VOWEL SIGN TALL AA
  { 0x1A65, BIDI_NSM },  // TAI THAM VOWEL SIGN I
  { 0x1A66, BIDI_NSM },  // TAI THAM VOWEL SIGN II
  { 0x1A67, BIDI_NSM },  // TAI THAM VOWEL SIGN UE
  { 0x1A68, BIDI_NSM },  // TAI THAM VOWEL SIGN UUE
  { 0x1A69, BIDI_NSM },  // TAI THAM VOWEL SIGN U
  { 0x1A6A, BIDI_NSM },  // TAI THAM VOWEL SIGN UU
  { 0x1A6B, BIDI_NSM },  // TAI THAM VOWEL SIGN O
  { 0x1A6C, BIDI_NSM },  // TAI THAM VOWEL SIGN OA BELOW
  { 0x1A6D, BIDI_L   },  // TAI THAM VOWEL SIGN OY
  { 0x1A6E, BIDI_L   },  // TAI THAM VOWEL SIGN E
  { 0x1A6F, BIDI_L   },  // TAI THAM VOWEL SIGN AE
  { 0x1A70, BIDI_L   },  // TAI THAM VOWEL SIGN OO
  { 0x1A71, BIDI_L   },  // TAI THAM VOWEL SIGN AI
  { 0x1A72, BIDI_L   },  // TAI THAM VOWEL SIGN THAM AI
  { 0x1A73, BIDI_NSM },  // TAI THAM VOWEL SIGN OA ABOVE
  { 0x1A74, BIDI_NSM },  // TAI THAM SIGN MAI KANG
  { 0x1A75, BIDI_NSM },  // TAI THAM SIGN TONE-1
  { 0x1A76, BIDI_NSM },  // TAI THAM SIGN TONE-2
  { 0x1A77, BIDI_NSM },  // TAI THAM SIGN KHUEN TONE-3
  { 0x1A78, BIDI_NSM },  // TAI THAM SIGN KHUEN TONE-4
  { 0x1A79, BIDI_NSM },  // TAI THAM SIGN KHUEN TONE-5
  { 0x1A7A, BIDI_NSM },  // TAI THAM SIGN RA HAAM
  { 0x1A7B, BIDI_NSM },  // TAI THAM SIGN MAI SAM
  { 0x1A7C, BIDI_NSM },  // TAI THAM SIGN KHUEN-LUE KARAN
  { 0x1A7F, BIDI_NSM },  // TAI THAM COMBINING CRYPTOGRAMMIC DOT
  { 0x1A80, BIDI_L   },  // TAI THAM HORA DIGIT ZERO
  { 0x1A81, BIDI_L   },  // TAI THAM HORA DIGIT ONE
  { 0x1A82, BIDI_L   },  // TAI THAM HORA DIGIT TWO
  { 0x1A83, BIDI_L   },  // TAI THAM HORA DIGIT THREE
  { 0x1A84, BIDI_L   },  // TAI THAM HORA DIGIT FOUR
  { 0x1A85, BIDI_L   },  // TAI THAM HORA DIGIT FIVE
  { 0x1A86, BIDI_L   },  // TAI THAM HORA DIGIT SIX
  { 0x1A87, BIDI_L   },  // TAI THAM HORA DIGIT SEVEN
  { 0x1A88, BIDI_L   },  // TAI THAM HORA DIGIT EIGHT
  { 0x1A89, BIDI_L   },  // TAI THAM HORA DIGIT NINE
  { 0x1A90, BIDI_L   },  // TAI THAM THAM DIGIT ZERO
  { 0x1A91, BIDI_L   },  // TAI THAM THAM DIGIT ONE
  { 0x1A92, BIDI_L   },  // TAI THAM THAM DIGIT TWO
  { 0x1A93, BIDI_L   },  // TAI THAM THAM DIGIT THREE
  { 0x1A94, BIDI_L   },  // TAI THAM THAM DIGIT FOUR
  { 0x1A95, BIDI_L   },  // TAI THAM THAM DIGIT FIVE
  { 0x1A96, BIDI_L   },  // TAI THAM THAM DIGIT SIX
  { 0x1A97, BIDI_L   },  // TAI THAM THAM DIGIT SEVEN
  { 0x1A98, BIDI_L   },  // TAI THAM THAM DIGIT EIGHT
  { 0x1A99, BIDI_L   },  // TAI THAM THAM DIGIT NINE
  { 0x1AA0, BIDI_L   },  // TAI THAM SIGN WIANG
  { 0x1AA1, BIDI_L   },  // TAI THAM SIGN WIANGWAAK
  { 0x1AA2, BIDI_L   },  // TAI THAM SIGN SAWAN
  { 0x1AA3, BIDI_L   },  // TAI THAM SIGN KEOW
  { 0x1AA4, BIDI_L   },  // TAI THAM SIGN HOY
  { 0x1AA5, BIDI_L   },  // TAI THAM SIGN DOKMAI
  { 0x1AA6, BIDI_L   },  // TAI THAM SIGN REVERSED ROTATED RANA
  { 0x1AA7, BIDI_L   },  // TAI THAM SIGN MAI YAMOK
  { 0x1AA8, BIDI_L   },  // TAI THAM SIGN KAAN
  { 0x1AA9, BIDI_L   },  // TAI THAM SIGN KAANKUU
  { 0x1AAA, BIDI_L   },  // TAI THAM SIGN SATKAAN
  { 0x1AAB, BIDI_L   },  // TAI THAM SIGN SATKAANKUU
  { 0x1AAC, BIDI_L   },  // TAI THAM SIGN HANG
  { 0x1AAD, BIDI_L   },  // TAI THAM SIGN CAANG
  { 0x1AB0, BIDI_NSM },  // COMBINING DOUBLED CIRCUMFLEX ACCENT
  { 0x1AB1, BIDI_NSM },  // COMBINING DIAERESIS-RING
  { 0x1AB2, BIDI_NSM },  // COMBINING INFINITY
  { 0x1AB3, BIDI_NSM },  // COMBINING DOWNWARDS ARROW
  { 0x1AB4, BIDI_NSM },  // COMBINING TRIPLE DOT
  { 0x1AB5, BIDI_NSM },  // COMBINING X-X BELOW
  { 0x1AB6, BIDI_NSM },  // COMBINING WIGGLY LINE BELOW
  { 0x1AB7, BIDI_NSM },  // COMBINING OPEN MARK BELOW
  { 0x1AB8, BIDI_NSM },  // COMBINING DOUBLE OPEN MARK BELOW
  { 0x1AB9, BIDI_NSM },  // COMBINING LIGHT CENTRALIZATION STROKE BELOW
  { 0x1ABA, BIDI_NSM },  // COMBINING STRONG CENTRALIZATION STROKE BELOW
  { 0x1ABB, BIDI_NSM },  // COMBINING PARENTHESES ABOVE
  { 0x1ABC, BIDI_NSM },  // COMBINING DOUBLE PARENTHESES ABOVE
  { 0x1ABD, BIDI_NSM },  // COMBINING PARENTHESES BELOW
  { 0x1ABE, BIDI_NSM },  // COMBINING PARENTHESES OVERLAY
  { 0x1B00, BIDI_NSM },  // BALINESE SIGN ULU RICEM
  { 0x1B01, BIDI_NSM },  // BALINESE SIGN ULU CANDRA
  { 0x1B02, BIDI_NSM },  // BALINESE SIGN CECEK
  { 0x1B03, BIDI_NSM },  // BALINESE SIGN SURANG
  { 0x1B04, BIDI_L   },  // BALINESE SIGN BISAH
  { 0x1B05, BIDI_L   },  // BALINESE LETTER AKARA
  { 0x1B06, BIDI_L   },  // BALINESE LETTER AKARA TEDUNG
  { 0x1B07, BIDI_L   },  // BALINESE LETTER IKARA
  { 0x1B08, BIDI_L   },  // BALINESE LETTER IKARA TEDUNG
  { 0x1B09, BIDI_L   },  // BALINESE LETTER UKARA
  { 0x1B0A, BIDI_L   },  // BALINESE LETTER UKARA TEDUNG
  { 0x1B0B, BIDI_L   },  // BALINESE LETTER RA REPA
  { 0x1B0C, BIDI_L   },  // BALINESE LETTER RA REPA TEDUNG
  { 0x1B0D, BIDI_L   },  // BALINESE LETTER LA LENGA
  { 0x1B0E, BIDI_L   },  // BALINESE LETTER LA LENGA TEDUNG
  { 0x1B0F, BIDI_L   },  // BALINESE LETTER EKARA
  { 0x1B10, BIDI_L   },  // BALINESE LETTER AIKARA
  { 0x1B11, BIDI_L   },  // BALINESE LETTER OKARA
  { 0x1B12, BIDI_L   },  // BALINESE LETTER OKARA TEDUNG
  { 0x1B13, BIDI_L   },  // BALINESE LETTER KA
  { 0x1B14, BIDI_L   },  // BALINESE LETTER KA MAHAPRANA
  { 0x1B15, BIDI_L   },  // BALINESE LETTER GA
  { 0x1B16, BIDI_L   },  // BALINESE LETTER GA GORA
  { 0x1B17, BIDI_L   },  // BALINESE LETTER NGA
  { 0x1B18, BIDI_L   },  // BALINESE LETTER CA
  { 0x1B19, BIDI_L   },  // BALINESE LETTER CA LACA
  { 0x1B1A, BIDI_L   },  // BALINESE LETTER JA
  { 0x1B1B, BIDI_L   },  // BALINESE LETTER JA JERA
  { 0x1B1C, BIDI_L   },  // BALINESE LETTER NYA
  { 0x1B1D, BIDI_L   },  // BALINESE LETTER TA LATIK
  { 0x1B1E, BIDI_L   },  // BALINESE LETTER TA MURDA MAHAPRANA
  { 0x1B1F, BIDI_L   },  // BALINESE LETTER DA MURDA ALPAPRANA
  { 0x1B20, BIDI_L   },  // BALINESE LETTER DA MURDA MAHAPRANA
  { 0x1B21, BIDI_L   },  // BALINESE LETTER NA RAMBAT
  { 0x1B22, BIDI_L   },  // BALINESE LETTER TA
  { 0x1B23, BIDI_L   },  // BALINESE LETTER TA TAWA
  { 0x1B24, BIDI_L   },  // BALINESE LETTER DA
  { 0x1B25, BIDI_L   },  // BALINESE LETTER DA MADU
  { 0x1B26, BIDI_L   },  // BALINESE LETTER NA
  { 0x1B27, BIDI_L   },  // BALINESE LETTER PA
  { 0x1B28, BIDI_L   },  // BALINESE LETTER PA KAPAL
  { 0x1B29, BIDI_L   },  // BALINESE LETTER BA
  { 0x1B2A, BIDI_L   },  // BALINESE LETTER BA KEMBANG
  { 0x1B2B, BIDI_L   },  // BALINESE LETTER MA
  { 0x1B2C, BIDI_L   },  // BALINESE LETTER YA
  { 0x1B2D, BIDI_L   },  // BALINESE LETTER RA
  { 0x1B2E, BIDI_L   },  // BALINESE LETTER LA
  { 0x1B2F, BIDI_L   },  // BALINESE LETTER WA
  { 0x1B30, BIDI_L   },  // BALINESE LETTER SA SAGA
  { 0x1B31, BIDI_L   },  // BALINESE LETTER SA SAPA
  { 0x1B32, BIDI_L   },  // BALINESE LETTER SA
  { 0x1B33, BIDI_L   },  // BALINESE LETTER HA
  { 0x1B34, BIDI_NSM },  // BALINESE SIGN REREKAN
  { 0x1B35, BIDI_L   },  // BALINESE VOWEL SIGN TEDUNG
  { 0x1B36, BIDI_NSM },  // BALINESE VOWEL SIGN ULU
  { 0x1B37, BIDI_NSM },  // BALINESE VOWEL SIGN ULU SARI
  { 0x1B38, BIDI_NSM },  // BALINESE VOWEL SIGN SUKU
  { 0x1B39, BIDI_NSM },  // BALINESE VOWEL SIGN SUKU ILUT
  { 0x1B3A, BIDI_NSM },  // BALINESE VOWEL SIGN RA REPA
  { 0x1B3B, BIDI_L   },  // BALINESE VOWEL SIGN RA REPA TEDUNG
  { 0x1B3C, BIDI_NSM },  // BALINESE VOWEL SIGN LA LENGA
  { 0x1B3D, BIDI_L   },  // BALINESE VOWEL SIGN LA LENGA TEDUNG
  { 0x1B3E, BIDI_L   },  // BALINESE VOWEL SIGN TALING
  { 0x1B3F, BIDI_L   },  // BALINESE VOWEL SIGN TALING REPA
  { 0x1B40, BIDI_L   },  // BALINESE VOWEL SIGN TALING TEDUNG
  { 0x1B41, BIDI_L   },  // BALINESE VOWEL SIGN TALING REPA TEDUNG
  { 0x1B42, BIDI_NSM },  // BALINESE VOWEL SIGN PEPET
  { 0x1B43, BIDI_L   },  // BALINESE VOWEL SIGN PEPET TEDUNG
  { 0x1B44, BIDI_L   },  // BALINESE ADEG ADEG
  { 0x1B45, BIDI_L   },  // BALINESE LETTER KAF SASAK
  { 0x1B46, BIDI_L   },  // BALINESE LETTER KHOT SASAK
  { 0x1B47, BIDI_L   },  // BALINESE LETTER TZIR SASAK
  { 0x1B48, BIDI_L   },  // BALINESE LETTER EF SASAK
  { 0x1B49, BIDI_L   },  // BALINESE LETTER VE SASAK
  { 0x1B4A, BIDI_L   },  // BALINESE LETTER ZAL SASAK
  { 0x1B4B, BIDI_L   },  // BALINESE LETTER ASYURA SASAK
  { 0x1B50, BIDI_L   },  // BALINESE DIGIT ZERO
  { 0x1B51, BIDI_L   },  // BALINESE DIGIT ONE
  { 0x1B52, BIDI_L   },  // BALINESE DIGIT TWO
  { 0x1B53, BIDI_L   },  // BALINESE DIGIT THREE
  { 0x1B54, BIDI_L   },  // BALINESE DIGIT FOUR
  { 0x1B55, BIDI_L   },  // BALINESE DIGIT FIVE
  { 0x1B56, BIDI_L   },  // BALINESE DIGIT SIX
  { 0x1B57, BIDI_L   },  // BALINESE DIGIT SEVEN
  { 0x1B58, BIDI_L   },  // BALINESE DIGIT EIGHT
  { 0x1B59, BIDI_L   },  // BALINESE DIGIT NINE
  { 0x1B5A, BIDI_L   },  // BALINESE PANTI
  { 0x1B5B, BIDI_L   },  // BALINESE PAMADA
  { 0x1B5C, BIDI_L   },  // BALINESE WINDU
  { 0x1B5D, BIDI_L   },  // BALINESE CARIK PAMUNGKAH
  { 0x1B5E, BIDI_L   },  // BALINESE CARIK SIKI
  { 0x1B5F, BIDI_L   },  // BALINESE CARIK PAREREN
  { 0x1B60, BIDI_L   },  // BALINESE PAMENENG
  { 0x1B61, BIDI_L   },  // BALINESE MUSICAL SYMBOL DONG
  { 0x1B62, BIDI_L   },  // BALINESE MUSICAL SYMBOL DENG
  { 0x1B63, BIDI_L   },  // BALINESE MUSICAL SYMBOL DUNG
  { 0x1B64, BIDI_L   },  // BALINESE MUSICAL SYMBOL DANG
  { 0x1B65, BIDI_L   },  // BALINESE MUSICAL SYMBOL DANG SURANG
  { 0x1B66, BIDI_L   },  // BALINESE MUSICAL SYMBOL DING
  { 0x1B67, BIDI_L   },  // BALINESE MUSICAL SYMBOL DAENG
  { 0x1B68, BIDI_L   },  // BALINESE MUSICAL SYMBOL DEUNG
  { 0x1B69, BIDI_L   },  // BALINESE MUSICAL SYMBOL DAING
  { 0x1B6A, BIDI_L   },  // BALINESE MUSICAL SYMBOL DANG GEDE
  { 0x1B6B, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING TEGEH
  { 0x1B6C, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING ENDEP
  { 0x1B6D, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING KEMPUL
  { 0x1B6E, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING KEMPLI
  { 0x1B6F, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING JEGOGAN
  { 0x1B70, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN
  { 0x1B71, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN
  { 0x1B72, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING BENDE
  { 0x1B73, BIDI_NSM },  // BALINESE MUSICAL SYMBOL COMBINING GONG
  { 0x1B74, BIDI_L   },  // BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG
  { 0x1B75, BIDI_L   },  // BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG
  { 0x1B76, BIDI_L   },  // BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK
  { 0x1B77, BIDI_L   },  // BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK
  { 0x1B78, BIDI_L   },  // BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG
  { 0x1B79, BIDI_L   },  // BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG
  { 0x1B7A, BIDI_L   },  // BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK
  { 0x1B7B, BIDI_L   },  // BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK
  { 0x1B7C, BIDI_L   },  // BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING
  { 0x1B80, BIDI_NSM },  // SUNDANESE SIGN PANYECEK
  { 0x1B81, BIDI_NSM },  // SUNDANESE SIGN PANGLAYAR
  { 0x1B82, BIDI_L   },  // SUNDANESE SIGN PANGWISAD
  { 0x1B83, BIDI_L   },  // SUNDANESE LETTER A
  { 0x1B84, BIDI_L   },  // SUNDANESE LETTER I
  { 0x1B85, BIDI_L   },  // SUNDANESE LETTER U
  { 0x1B86, BIDI_L   },  // SUNDANESE LETTER AE
  { 0x1B87, BIDI_L   },  // SUNDANESE LETTER O
  { 0x1B88, BIDI_L   },  // SUNDANESE LETTER E
  { 0x1B89, BIDI_L   },  // SUNDANESE LETTER EU
  { 0x1B8A, BIDI_L   },  // SUNDANESE LETTER KA
  { 0x1B8B, BIDI_L   },  // SUNDANESE LETTER QA
  { 0x1B8C, BIDI_L   },  // SUNDANESE LETTER GA
  { 0x1B8D, BIDI_L   },  // SUNDANESE LETTER NGA
  { 0x1B8E, BIDI_L   },  // SUNDANESE LETTER CA
  { 0x1B8F, BIDI_L   },  // SUNDANESE LETTER JA
  { 0x1B90, BIDI_L   },  // SUNDANESE LETTER ZA
  { 0x1B91, BIDI_L   },  // SUNDANESE LETTER NYA
  { 0x1B92, BIDI_L   },  // SUNDANESE LETTER TA
  { 0x1B93, BIDI_L   },  // SUNDANESE LETTER DA
  { 0x1B94, BIDI_L   },  // SUNDANESE LETTER NA
  { 0x1B95, BIDI_L   },  // SUNDANESE LETTER PA
  { 0x1B96, BIDI_L   },  // SUNDANESE LETTER FA
  { 0x1B97, BIDI_L   },  // SUNDANESE LETTER VA
  { 0x1B98, BIDI_L   },  // SUNDANESE LETTER BA
  { 0x1B99, BIDI_L   },  // SUNDANESE LETTER MA
  { 0x1B9A, BIDI_L   },  // SUNDANESE LETTER YA
  { 0x1B9B, BIDI_L   },  // SUNDANESE LETTER RA
  { 0x1B9C, BIDI_L   },  // SUNDANESE LETTER LA
  { 0x1B9D, BIDI_L   },  // SUNDANESE LETTER WA
  { 0x1B9E, BIDI_L   },  // SUNDANESE LETTER SA
  { 0x1B9F, BIDI_L   },  // SUNDANESE LETTER XA
  { 0x1BA0, BIDI_L   },  // SUNDANESE LETTER HA
  { 0x1BA1, BIDI_L   },  // SUNDANESE CONSONANT SIGN PAMINGKAL
  { 0x1BA2, BIDI_NSM },  // SUNDANESE CONSONANT SIGN PANYAKRA
  { 0x1BA3, BIDI_NSM },  // SUNDANESE CONSONANT SIGN PANYIKU
  { 0x1BA4, BIDI_NSM },  // SUNDANESE VOWEL SIGN PANGHULU
  { 0x1BA5, BIDI_NSM },  // SUNDANESE VOWEL SIGN PANYUKU
  { 0x1BA6, BIDI_L   },  // SUNDANESE VOWEL SIGN PANAELAENG
  { 0x1BA7, BIDI_L   },  // SUNDANESE VOWEL SIGN PANOLONG
  { 0x1BA8, BIDI_NSM },  // SUNDANESE VOWEL SIGN PAMEPET
  { 0x1BA9, BIDI_NSM },  // SUNDANESE VOWEL SIGN PANEULEUNG
  { 0x1BAA, BIDI_L   },  // SUNDANESE SIGN PAMAAEH
  { 0x1BAB, BIDI_NSM },  // SUNDANESE SIGN VIRAMA
  { 0x1BAC, BIDI_NSM },  // SUNDANESE CONSONANT SIGN PASANGAN MA
  { 0x1BAD, BIDI_NSM },  // SUNDANESE CONSONANT SIGN PASANGAN WA
  { 0x1BAE, BIDI_L   },  // SUNDANESE LETTER KHA
  { 0x1BAF, BIDI_L   },  // SUNDANESE LETTER SYA
  { 0x1BB0, BIDI_L   },  // SUNDANESE DIGIT ZERO
  { 0x1BB1, BIDI_L   },  // SUNDANESE DIGIT ONE
  { 0x1BB2, BIDI_L   },  // SUNDANESE DIGIT TWO
  { 0x1BB3, BIDI_L   },  // SUNDANESE DIGIT THREE
  { 0x1BB4, BIDI_L   },  // SUNDANESE DIGIT FOUR
  { 0x1BB5, BIDI_L   },  // SUNDANESE DIGIT FIVE
  { 0x1BB6, BIDI_L   },  // SUNDANESE DIGIT SIX
  { 0x1BB7, BIDI_L   },  // SUNDANESE DIGIT SEVEN
  { 0x1BB8, BIDI_L   },  // SUNDANESE DIGIT EIGHT
  { 0x1BB9, BIDI_L   },  // SUNDANESE DIGIT NINE
  { 0x1BBA, BIDI_L   },  // SUNDANESE AVAGRAHA
  { 0x1BBB, BIDI_L   },  // SUNDANESE LETTER REU
  { 0x1BBC, BIDI_L   },  // SUNDANESE LETTER LEU
  { 0x1BBD, BIDI_L   },  // SUNDANESE LETTER BHA
  { 0x1BBE, BIDI_L   },  // SUNDANESE LETTER FINAL K
  { 0x1BBF, BIDI_L   },  // SUNDANESE LETTER FINAL M
  { 0x1BC0, BIDI_L   },  // BATAK LETTER A
  { 0x1BC1, BIDI_L   },  // BATAK LETTER SIMALUNGUN A
  { 0x1BC2, BIDI_L   },  // BATAK LETTER HA
  { 0x1BC3, BIDI_L   },  // BATAK LETTER SIMALUNGUN HA
  { 0x1BC4, BIDI_L   },  // BATAK LETTER MANDAILING HA
  { 0x1BC5, BIDI_L   },  // BATAK LETTER BA
  { 0x1BC6, BIDI_L   },  // BATAK LETTER KARO BA
  { 0x1BC7, BIDI_L   },  // BATAK LETTER PA
  { 0x1BC8, BIDI_L   },  // BATAK LETTER SIMALUNGUN PA
  { 0x1BC9, BIDI_L   },  // BATAK LETTER NA
  { 0x1BCA, BIDI_L   },  // BATAK LETTER MANDAILING NA
  { 0x1BCB, BIDI_L   },  // BATAK LETTER WA
  { 0x1BCC, BIDI_L   },  // BATAK LETTER SIMALUNGUN WA
  { 0x1BCD, BIDI_L   },  // BATAK LETTER PAKPAK WA
  { 0x1BCE, BIDI_L   },  // BATAK LETTER GA
  { 0x1BCF, BIDI_L   },  // BATAK LETTER SIMALUNGUN GA
  { 0x1BD0, BIDI_L   },  // BATAK LETTER JA
  { 0x1BD1, BIDI_L   },  // BATAK LETTER DA
  { 0x1BD2, BIDI_L   },  // BATAK LETTER RA
  { 0x1BD3, BIDI_L   },  // BATAK LETTER SIMALUNGUN RA
  { 0x1BD4, BIDI_L   },  // BATAK LETTER MA
  { 0x1BD5, BIDI_L   },  // BATAK LETTER SIMALUNGUN MA
  { 0x1BD6, BIDI_L   },  // BATAK LETTER SOUTHERN TA
  { 0x1BD7, BIDI_L   },  // BATAK LETTER NORTHERN TA
  { 0x1BD8, BIDI_L   },  // BATAK LETTER SA
  { 0x1BD9, BIDI_L   },  // BATAK LETTER SIMALUNGUN SA
  { 0x1BDA, BIDI_L   },  // BATAK LETTER MANDAILING SA
  { 0x1BDB, BIDI_L   },  // BATAK LETTER YA
  { 0x1BDC, BIDI_L   },  // BATAK LETTER SIMALUNGUN YA
  { 0x1BDD, BIDI_L   },  // BATAK LETTER NGA
  { 0x1BDE, BIDI_L   },  // BATAK LETTER LA
  { 0x1BDF, BIDI_L   },  // BATAK LETTER SIMALUNGUN LA
  { 0x1BE0, BIDI_L   },  // BATAK LETTER NYA
  { 0x1BE1, BIDI_L   },  // BATAK LETTER CA
  { 0x1BE2, BIDI_L   },  // BATAK LETTER NDA
  { 0x1BE3, BIDI_L   },  // BATAK LETTER MBA
  { 0x1BE4, BIDI_L   },  // BATAK LETTER I
  { 0x1BE5, BIDI_L   },  // BATAK LETTER U
  { 0x1BE6, BIDI_NSM },  // BATAK SIGN TOMPI
  { 0x1BE7, BIDI_L   },  // BATAK VOWEL SIGN E
  { 0x1BE8, BIDI_NSM },  // BATAK VOWEL SIGN PAKPAK E
  { 0x1BE9, BIDI_NSM },  // BATAK VOWEL SIGN EE
  { 0x1BEA, BIDI_L   },  // BATAK VOWEL SIGN I
  { 0x1BEB, BIDI_L   },  // BATAK VOWEL SIGN KARO I
  { 0x1BEC, BIDI_L   },  // BATAK VOWEL SIGN O
  { 0x1BED, BIDI_NSM },  // BATAK VOWEL SIGN KARO O
  { 0x1BEE, BIDI_L   },  // BATAK VOWEL SIGN U
  { 0x1BEF, BIDI_NSM },  // BATAK VOWEL SIGN U FOR SIMALUNGUN SA
  { 0x1BF0, BIDI_NSM },  // BATAK CONSONANT SIGN NG
  { 0x1BF1, BIDI_NSM },  // BATAK CONSONANT SIGN H
  { 0x1BF2, BIDI_L   },  // BATAK PANGOLAT
  { 0x1BF3, BIDI_L   },  // BATAK PANONGONAN
  { 0x1BFC, BIDI_L   },  // BATAK SYMBOL BINDU NA METEK
  { 0x1BFD, BIDI_L   },  // BATAK SYMBOL BINDU PINARBORAS
  { 0x1BFE, BIDI_L   },  // BATAK SYMBOL BINDU JUDUL
  { 0x1BFF, BIDI_L   },  // BATAK SYMBOL BINDU PANGOLAT
  { 0x1C00, BIDI_L   },  // LEPCHA LETTER KA
  { 0x1C01, BIDI_L   },  // LEPCHA LETTER KLA
  { 0x1C02, BIDI_L   },  // LEPCHA LETTER KHA
  { 0x1C03, BIDI_L   },  // LEPCHA LETTER GA
  { 0x1C04, BIDI_L   },  // LEPCHA LETTER GLA
  { 0x1C05, BIDI_L   },  // LEPCHA LETTER NGA
  { 0x1C06, BIDI_L   },  // LEPCHA LETTER CA
  { 0x1C07, BIDI_L   },  // LEPCHA LETTER CHA
  { 0x1C08, BIDI_L   },  // LEPCHA LETTER JA
  { 0x1C09, BIDI_L   },  // LEPCHA LETTER NYA
  { 0x1C0A, BIDI_L   },  // LEPCHA LETTER TA
  { 0x1C0B, BIDI_L   },  // LEPCHA LETTER THA
  { 0x1C0C, BIDI_L   },  // LEPCHA LETTER DA
  { 0x1C0D, BIDI_L   },  // LEPCHA LETTER NA
  { 0x1C0E, BIDI_L   },  // LEPCHA LETTER PA
  { 0x1C0F, BIDI_L   },  // LEPCHA LETTER PLA
  { 0x1C10, BIDI_L   },  // LEPCHA LETTER PHA
  { 0x1C11, BIDI_L   },  // LEPCHA LETTER FA
  { 0x1C12, BIDI_L   },  // LEPCHA LETTER FLA
  { 0x1C13, BIDI_L   },  // LEPCHA LETTER BA
  { 0x1C14, BIDI_L   },  // LEPCHA LETTER BLA
  { 0x1C15, BIDI_L   },  // LEPCHA LETTER MA
  { 0x1C16, BIDI_L   },  // LEPCHA LETTER MLA
  { 0x1C17, BIDI_L   },  // LEPCHA LETTER TSA
  { 0x1C18, BIDI_L   },  // LEPCHA LETTER TSHA
  { 0x1C19, BIDI_L   },  // LEPCHA LETTER DZA
  { 0x1C1A, BIDI_L   },  // LEPCHA LETTER YA
  { 0x1C1B, BIDI_L   },  // LEPCHA LETTER RA
  { 0x1C1C, BIDI_L   },  // LEPCHA LETTER LA
  { 0x1C1D, BIDI_L   },  // LEPCHA LETTER HA
  { 0x1C1E, BIDI_L   },  // LEPCHA LETTER HLA
  { 0x1C1F, BIDI_L   },  // LEPCHA LETTER VA
  { 0x1C20, BIDI_L   },  // LEPCHA LETTER SA
  { 0x1C21, BIDI_L   },  // LEPCHA LETTER SHA
  { 0x1C22, BIDI_L   },  // LEPCHA LETTER WA
  { 0x1C23, BIDI_L   },  // LEPCHA LETTER A
  { 0x1C24, BIDI_L   },  // LEPCHA SUBJOINED LETTER YA
  { 0x1C25, BIDI_L   },  // LEPCHA SUBJOINED LETTER RA
  { 0x1C26, BIDI_L   },  // LEPCHA VOWEL SIGN AA
  { 0x1C27, BIDI_L   },  // LEPCHA VOWEL SIGN I
  { 0x1C28, BIDI_L   },  // LEPCHA VOWEL SIGN O
  { 0x1C29, BIDI_L   },  // LEPCHA VOWEL SIGN OO
  { 0x1C2A, BIDI_L   },  // LEPCHA VOWEL SIGN U
  { 0x1C2B, BIDI_L   },  // LEPCHA VOWEL SIGN UU
  { 0x1C2C, BIDI_NSM },  // LEPCHA VOWEL SIGN E
  { 0x1C2D, BIDI_NSM },  // LEPCHA CONSONANT SIGN K
  { 0x1C2E, BIDI_NSM },  // LEPCHA CONSONANT SIGN M
  { 0x1C2F, BIDI_NSM },  // LEPCHA CONSONANT SIGN L
  { 0x1C30, BIDI_NSM },  // LEPCHA CONSONANT SIGN N
  { 0x1C31, BIDI_NSM },  // LEPCHA CONSONANT SIGN P
  { 0x1C32, BIDI_NSM },  // LEPCHA CONSONANT SIGN R
  { 0x1C33, BIDI_NSM },  // LEPCHA CONSONANT SIGN T
  { 0x1C34, BIDI_L   },  // LEPCHA CONSONANT SIGN NYIN-DO
  { 0x1C35, BIDI_L   },  // LEPCHA CONSONANT SIGN KANG
  { 0x1C36, BIDI_NSM },  // LEPCHA SIGN RAN
  { 0x1C37, BIDI_NSM },  // LEPCHA SIGN NUKTA
  { 0x1C3B, BIDI_L   },  // LEPCHA PUNCTUATION TA-ROL
  { 0x1C3C, BIDI_L   },  // LEPCHA PUNCTUATION NYET THYOOM TA-ROL
  { 0x1C3D, BIDI_L   },  // LEPCHA PUNCTUATION CER-WA
  { 0x1C3E, BIDI_L   },  // LEPCHA PUNCTUATION TSHOOK CER-WA
  { 0x1C3F, BIDI_L   },  // LEPCHA PUNCTUATION TSHOOK
  { 0x1C40, BIDI_L   },  // LEPCHA DIGIT ZERO
  { 0x1C41, BIDI_L   },  // LEPCHA DIGIT ONE
  { 0x1C42, BIDI_L   },  // LEPCHA DIGIT TWO
  { 0x1C43, BIDI_L   },  // LEPCHA DIGIT THREE
  { 0x1C44, BIDI_L   },  // LEPCHA DIGIT FOUR
  { 0x1C45, BIDI_L   },  // LEPCHA DIGIT FIVE
  { 0x1C46, BIDI_L   },  // LEPCHA DIGIT SIX
  { 0x1C47, BIDI_L   },  // LEPCHA DIGIT SEVEN
  { 0x1C48, BIDI_L   },  // LEPCHA DIGIT EIGHT
  { 0x1C49, BIDI_L   },  // LEPCHA DIGIT NINE
  { 0x1C4D, BIDI_L   },  // LEPCHA LETTER TTA
  { 0x1C4E, BIDI_L   },  // LEPCHA LETTER TTHA
  { 0x1C4F, BIDI_L   },  // LEPCHA LETTER DDA
  { 0x1C50, BIDI_L   },  // OL CHIKI DIGIT ZERO
  { 0x1C51, BIDI_L   },  // OL CHIKI DIGIT ONE
  { 0x1C52, BIDI_L   },  // OL CHIKI DIGIT TWO
  { 0x1C53, BIDI_L   },  // OL CHIKI DIGIT THREE
  { 0x1C54, BIDI_L   },  // OL CHIKI DIGIT FOUR
  { 0x1C55, BIDI_L   },  // OL CHIKI DIGIT FIVE
  { 0x1C56, BIDI_L   },  // OL CHIKI DIGIT SIX
  { 0x1C57, BIDI_L   },  // OL CHIKI DIGIT SEVEN
  { 0x1C58, BIDI_L   },  // OL CHIKI DIGIT EIGHT
  { 0x1C59, BIDI_L   },  // OL CHIKI DIGIT NINE
  { 0x1C5A, BIDI_L   },  // OL CHIKI LETTER LA
  { 0x1C5B, BIDI_L   },  // OL CHIKI LETTER AT
  { 0x1C5C, BIDI_L   },  // OL CHIKI LETTER AG
  { 0x1C5D, BIDI_L   },  // OL CHIKI LETTER ANG
  { 0x1C5E, BIDI_L   },  // OL CHIKI LETTER AL
  { 0x1C5F, BIDI_L   },  // OL CHIKI LETTER LAA
  { 0x1C60, BIDI_L   },  // OL CHIKI LETTER AAK
  { 0x1C61, BIDI_L   },  // OL CHIKI LETTER AAJ
  { 0x1C62, BIDI_L   },  // OL CHIKI LETTER AAM
  { 0x1C63, BIDI_L   },  // OL CHIKI LETTER AAW
  { 0x1C64, BIDI_L   },  // OL CHIKI LETTER LI
  { 0x1C65, BIDI_L   },  // OL CHIKI LETTER IS
  { 0x1C66, BIDI_L   },  // OL CHIKI LETTER IH
  { 0x1C67, BIDI_L   },  // OL CHIKI LETTER INY
  { 0x1C68, BIDI_L   },  // OL CHIKI LETTER IR
  { 0x1C69, BIDI_L   },  // OL CHIKI LETTER LU
  { 0x1C6A, BIDI_L   },  // OL CHIKI LETTER UC
  { 0x1C6B, BIDI_L   },  // OL CHIKI LETTER UD
  { 0x1C6C, BIDI_L   },  // OL CHIKI LETTER UNN
  { 0x1C6D, BIDI_L   },  // OL CHIKI LETTER UY
  { 0x1C6E, BIDI_L   },  // OL CHIKI LETTER LE
  { 0x1C6F, BIDI_L   },  // OL CHIKI LETTER EP
  { 0x1C70, BIDI_L   },  // OL CHIKI LETTER EDD
  { 0x1C71, BIDI_L   },  // OL CHIKI LETTER EN
  { 0x1C72, BIDI_L   },  // OL CHIKI LETTER ERR
  { 0x1C73, BIDI_L   },  // OL CHIKI LETTER LO
  { 0x1C74, BIDI_L   },  // OL CHIKI LETTER OTT
  { 0x1C75, BIDI_L   },  // OL CHIKI LETTER OB
  { 0x1C76, BIDI_L   },  // OL CHIKI LETTER OV
  { 0x1C77, BIDI_L   },  // OL CHIKI LETTER OH
  { 0x1C78, BIDI_L   },  // OL CHIKI MU TTUDDAG
  { 0x1C79, BIDI_L   },  // OL CHIKI GAAHLAA TTUDDAAG
  { 0x1C7A, BIDI_L   },  // OL CHIKI MU-GAAHLAA TTUDDAAG
  { 0x1C7B, BIDI_L   },  // OL CHIKI RELAA
  { 0x1C7C, BIDI_L   },  // OL CHIKI PHAARKAA
  { 0x1C7D, BIDI_L   },  // OL CHIKI AHAD
  { 0x1C7E, BIDI_L   },  // OL CHIKI PUNCTUATION MUCAAD
  { 0x1C7F, BIDI_L   },  // OL CHIKI PUNCTUATION DOUBLE MUCAAD
  { 0x1CC0, BIDI_L   },  // SUNDANESE PUNCTUATION BINDU SURYA
  { 0x1CC1, BIDI_L   },  // SUNDANESE PUNCTUATION BINDU PANGLONG
  { 0x1CC2, BIDI_L   },  // SUNDANESE PUNCTUATION BINDU PURNAMA
  { 0x1CC3, BIDI_L   },  // SUNDANESE PUNCTUATION BINDU CAKRA
  { 0x1CC4, BIDI_L   },  // SUNDANESE PUNCTUATION BINDU LEU SATANGA
  { 0x1CC5, BIDI_L   },  // SUNDANESE PUNCTUATION BINDU KA SATANGA
  { 0x1CC6, BIDI_L   },  // SUNDANESE PUNCTUATION BINDU DA SATANGA
  { 0x1CC7, BIDI_L   },  // SUNDANESE PUNCTUATION BINDU BA SATANGA
  { 0x1CD0, BIDI_NSM },  // VEDIC TONE KARSHANA
  { 0x1CD1, BIDI_NSM },  // VEDIC TONE SHARA
  { 0x1CD2, BIDI_NSM },  // VEDIC TONE PRENKHA
  { 0x1CD3, BIDI_L   },  // VEDIC SIGN NIHSHVASA
  { 0x1CD4, BIDI_NSM },  // VEDIC SIGN YAJURVEDIC MIDLINE SVARITA
  { 0x1CD5, BIDI_NSM },  // VEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITA
  { 0x1CD6, BIDI_NSM },  // VEDIC TONE YAJURVEDIC INDEPENDENT SVARITA
  { 0x1CD7, BIDI_NSM },  // VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA
  { 0x1CD8, BIDI_NSM },  // VEDIC TONE CANDRA BELOW
  { 0x1CD9, BIDI_NSM },  // VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDER
  { 0x1CDA, BIDI_NSM },  // VEDIC TONE DOUBLE SVARITA
  { 0x1CDB, BIDI_NSM },  // VEDIC TONE TRIPLE SVARITA
  { 0x1CDC, BIDI_NSM },  // VEDIC TONE KATHAKA ANUDATTA
  { 0x1CDD, BIDI_NSM },  // VEDIC TONE DOT BELOW
  { 0x1CDE, BIDI_NSM },  // VEDIC TONE TWO DOTS BELOW
  { 0x1CDF, BIDI_NSM },  // VEDIC TONE THREE DOTS BELOW
  { 0x1CE0, BIDI_NSM },  // VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
  { 0x1CE1, BIDI_L   },  // VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
  { 0x1CE2, BIDI_NSM },  // VEDIC SIGN VISARGA SVARITA
  { 0x1CE3, BIDI_NSM },  // VEDIC SIGN VISARGA UDATTA
  { 0x1CE4, BIDI_NSM },  // VEDIC SIGN REVERSED VISARGA UDATTA
  { 0x1CE5, BIDI_NSM },  // VEDIC SIGN VISARGA ANUDATTA
  { 0x1CE6, BIDI_NSM },  // VEDIC SIGN REVERSED VISARGA ANUDATTA
  { 0x1CE7, BIDI_NSM },  // VEDIC SIGN VISARGA UDATTA WITH TAIL
  { 0x1CE8, BIDI_NSM },  // VEDIC SIGN VISARGA ANUDATTA WITH TAIL
  { 0x1CE9, BIDI_L   },  // VEDIC SIGN ANUSVARA ANTARGOMUKHA
  { 0x1CEA, BIDI_L   },  // VEDIC SIGN ANUSVARA BAHIRGOMUKHA
  { 0x1CEB, BIDI_L   },  // VEDIC SIGN ANUSVARA VAMAGOMUKHA
  { 0x1CEC, BIDI_L   },  // VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
  { 0x1CED, BIDI_NSM },  // VEDIC SIGN TIRYAK
  { 0x1CEE, BIDI_L   },  // VEDIC SIGN HEXIFORM LONG ANUSVARA
  { 0x1CEF, BIDI_L   },  // VEDIC SIGN LONG ANUSVARA
  { 0x1CF0, BIDI_L   },  // VEDIC SIGN RTHANG LONG ANUSVARA
  { 0x1CF1, BIDI_L   },  // VEDIC SIGN ANUSVARA UBHAYATO MUKHA
  { 0x1CF2, BIDI_L   },  // VEDIC SIGN ARDHAVISARGA
  { 0x1CF3, BIDI_L   },  // VEDIC SIGN ROTATED ARDHAVISARGA
  { 0x1CF4, BIDI_NSM },  // VEDIC TONE CANDRA ABOVE
  { 0x1CF5, BIDI_L   },  // VEDIC SIGN JIHVAMULIYA
  { 0x1CF6, BIDI_L   },  // VEDIC SIGN UPADHMANIYA
  { 0x1CF8, BIDI_NSM },  // VEDIC TONE RING ABOVE
  { 0x1CF9, BIDI_NSM },  // VEDIC TONE DOUBLE RING ABOVE
  { 0x1D00, BIDI_L   },  // LATIN LETTER SMALL CAPITAL A
  { 0x1D01, BIDI_L   },  // LATIN LETTER SMALL CAPITAL AE
  { 0x1D02, BIDI_L   },  // LATIN SMALL LETTER TURNED AE
  { 0x1D03, BIDI_L   },  // LATIN LETTER SMALL CAPITAL BARRED B
  { 0x1D04, BIDI_L   },  // LATIN LETTER SMALL CAPITAL C
  { 0x1D05, BIDI_L   },  // LATIN LETTER SMALL CAPITAL D
  { 0x1D06, BIDI_L   },  // LATIN LETTER SMALL CAPITAL ETH
  { 0x1D07, BIDI_L   },  // LATIN LETTER SMALL CAPITAL E
  { 0x1D08, BIDI_L   },  // LATIN SMALL LETTER TURNED OPEN E
  { 0x1D09, BIDI_L   },  // LATIN SMALL LETTER TURNED I
  { 0x1D0A, BIDI_L   },  // LATIN LETTER SMALL CAPITAL J
  { 0x1D0B, BIDI_L   },  // LATIN LETTER SMALL CAPITAL K
  { 0x1D0C, BIDI_L   },  // LATIN LETTER SMALL CAPITAL L WITH STROKE
  { 0x1D0D, BIDI_L   },  // LATIN LETTER SMALL CAPITAL M
  { 0x1D0E, BIDI_L   },  // LATIN LETTER SMALL CAPITAL REVERSED N
  { 0x1D0F, BIDI_L   },  // LATIN LETTER SMALL CAPITAL O
  { 0x1D10, BIDI_L   },  // LATIN LETTER SMALL CAPITAL OPEN O
  { 0x1D11, BIDI_L   },  // LATIN SMALL LETTER SIDEWAYS O
  { 0x1D12, BIDI_L   },  // LATIN SMALL LETTER SIDEWAYS OPEN O
  { 0x1D13, BIDI_L   },  // LATIN SMALL LETTER SIDEWAYS O WITH STROKE
  { 0x1D14, BIDI_L   },  // LATIN SMALL LETTER TURNED OE
  { 0x1D15, BIDI_L   },  // LATIN LETTER SMALL CAPITAL OU
  { 0x1D16, BIDI_L   },  // LATIN SMALL LETTER TOP HALF O
  { 0x1D17, BIDI_L   },  // LATIN SMALL LETTER BOTTOM HALF O
  { 0x1D18, BIDI_L   },  // LATIN LETTER SMALL CAPITAL P
  { 0x1D19, BIDI_L   },  // LATIN LETTER SMALL CAPITAL REVERSED R
  { 0x1D1A, BIDI_L   },  // LATIN LETTER SMALL CAPITAL TURNED R
  { 0x1D1B, BIDI_L   },  // LATIN LETTER SMALL CAPITAL T
  { 0x1D1C, BIDI_L   },  // LATIN LETTER SMALL CAPITAL U
  { 0x1D1D, BIDI_L   },  // LATIN SMALL LETTER SIDEWAYS U
  { 0x1D1E, BIDI_L   },  // LATIN SMALL LETTER SIDEWAYS DIAERESIZED U
  { 0x1D1F, BIDI_L   },  // LATIN SMALL LETTER SIDEWAYS TURNED M
  { 0x1D20, BIDI_L   },  // LATIN LETTER SMALL CAPITAL V
  { 0x1D21, BIDI_L   },  // LATIN LETTER SMALL CAPITAL W
  { 0x1D22, BIDI_L   },  // LATIN LETTER SMALL CAPITAL Z
  { 0x1D23, BIDI_L   },  // LATIN LETTER SMALL CAPITAL EZH
  { 0x1D24, BIDI_L   },  // LATIN LETTER VOICED LARYNGEAL SPIRANT
  { 0x1D25, BIDI_L   },  // LATIN LETTER AIN
  { 0x1D26, BIDI_L   },  // GREEK LETTER SMALL CAPITAL GAMMA
  { 0x1D27, BIDI_L   },  // GREEK LETTER SMALL CAPITAL LAMDA
  { 0x1D28, BIDI_L   },  // GREEK LETTER SMALL CAPITAL PI
  { 0x1D29, BIDI_L   },  // GREEK LETTER SMALL CAPITAL RHO
  { 0x1D2A, BIDI_L   },  // GREEK LETTER SMALL CAPITAL PSI
  { 0x1D2B, BIDI_L   },  // CYRILLIC LETTER SMALL CAPITAL EL
  { 0x1D2C, BIDI_L   },  // MODIFIER LETTER CAPITAL A
  { 0x1D2D, BIDI_L   },  // MODIFIER LETTER CAPITAL AE
  { 0x1D2E, BIDI_L   },  // MODIFIER LETTER CAPITAL B
  { 0x1D2F, BIDI_L   },  // MODIFIER LETTER CAPITAL BARRED B
  { 0x1D30, BIDI_L   },  // MODIFIER LETTER CAPITAL D
  { 0x1D31, BIDI_L   },  // MODIFIER LETTER CAPITAL E
  { 0x1D32, BIDI_L   },  // MODIFIER LETTER CAPITAL REVERSED E
  { 0x1D33, BIDI_L   },  // MODIFIER LETTER CAPITAL G
  { 0x1D34, BIDI_L   },  // MODIFIER LETTER CAPITAL H
  { 0x1D35, BIDI_L   },  // MODIFIER LETTER CAPITAL I
  { 0x1D36, BIDI_L   },  // MODIFIER LETTER CAPITAL J
  { 0x1D37, BIDI_L   },  // MODIFIER LETTER CAPITAL K
  { 0x1D38, BIDI_L   },  // MODIFIER LETTER CAPITAL L
  { 0x1D39, BIDI_L   },  // MODIFIER LETTER CAPITAL M
  { 0x1D3A, BIDI_L   },  // MODIFIER LETTER CAPITAL N
  { 0x1D3B, BIDI_L   },  // MODIFIER LETTER CAPITAL REVERSED N
  { 0x1D3C, BIDI_L   },  // MODIFIER LETTER CAPITAL O
  { 0x1D3D, BIDI_L   },  // MODIFIER LETTER CAPITAL OU
  { 0x1D3E, BIDI_L   },  // MODIFIER LETTER CAPITAL P
  { 0x1D3F, BIDI_L   },  // MODIFIER LETTER CAPITAL R
  { 0x1D40, BIDI_L   },  // MODIFIER LETTER CAPITAL T
  { 0x1D41, BIDI_L   },  // MODIFIER LETTER CAPITAL U
  { 0x1D42, BIDI_L   },  // MODIFIER LETTER CAPITAL W
  { 0x1D43, BIDI_L   },  // MODIFIER LETTER SMALL A
  { 0x1D44, BIDI_L   },  // MODIFIER LETTER SMALL TURNED A
  { 0x1D45, BIDI_L   },  // MODIFIER LETTER SMALL ALPHA
  { 0x1D46, BIDI_L   },  // MODIFIER LETTER SMALL TURNED AE
  { 0x1D47, BIDI_L   },  // MODIFIER LETTER SMALL B
  { 0x1D48, BIDI_L   },  // MODIFIER LETTER SMALL D
  { 0x1D49, BIDI_L   },  // MODIFIER LETTER SMALL E
  { 0x1D4A, BIDI_L   },  // MODIFIER LETTER SMALL SCHWA
  { 0x1D4B, BIDI_L   },  // MODIFIER LETTER SMALL OPEN E
  { 0x1D4C, BIDI_L   },  // MODIFIER LETTER SMALL TURNED OPEN E
  { 0x1D4D, BIDI_L   },  // MODIFIER LETTER SMALL G
  { 0x1D4E, BIDI_L   },  // MODIFIER LETTER SMALL TURNED I
  { 0x1D4F, BIDI_L   },  // MODIFIER LETTER SMALL K
  { 0x1D50, BIDI_L   },  // MODIFIER LETTER SMALL M
  { 0x1D51, BIDI_L   },  // MODIFIER LETTER SMALL ENG
  { 0x1D52, BIDI_L   },  // MODIFIER LETTER SMALL O
  { 0x1D53, BIDI_L   },  // MODIFIER LETTER SMALL OPEN O
  { 0x1D54, BIDI_L   },  // MODIFIER LETTER SMALL TOP HALF O
  { 0x1D55, BIDI_L   },  // MODIFIER LETTER SMALL BOTTOM HALF O
  { 0x1D56, BIDI_L   },  // MODIFIER LETTER SMALL P
  { 0x1D57, BIDI_L   },  // MODIFIER LETTER SMALL T
  { 0x1D58, BIDI_L   },  // MODIFIER LETTER SMALL U
  { 0x1D59, BIDI_L   },  // MODIFIER LETTER SMALL SIDEWAYS U
  { 0x1D5A, BIDI_L   },  // MODIFIER LETTER SMALL TURNED M
  { 0x1D5B, BIDI_L   },  // MODIFIER LETTER SMALL V
  { 0x1D5C, BIDI_L   },  // MODIFIER LETTER SMALL AIN
  { 0x1D5D, BIDI_L   },  // MODIFIER LETTER SMALL BETA
  { 0x1D5E, BIDI_L   },  // MODIFIER LETTER SMALL GREEK GAMMA
  { 0x1D5F, BIDI_L   },  // MODIFIER LETTER SMALL DELTA
  { 0x1D60, BIDI_L   },  // MODIFIER LETTER SMALL GREEK PHI
  { 0x1D61, BIDI_L   },  // MODIFIER LETTER SMALL CHI
  { 0x1D62, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER I
  { 0x1D63, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER R
  { 0x1D64, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER U
  { 0x1D65, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER V
  { 0x1D66, BIDI_L   },  // GREEK SUBSCRIPT SMALL LETTER BETA
  { 0x1D67, BIDI_L   },  // GREEK SUBSCRIPT SMALL LETTER GAMMA
  { 0x1D68, BIDI_L   },  // GREEK SUBSCRIPT SMALL LETTER RHO
  { 0x1D69, BIDI_L   },  // GREEK SUBSCRIPT SMALL LETTER PHI
  { 0x1D6A, BIDI_L   },  // GREEK SUBSCRIPT SMALL LETTER CHI
  { 0x1D6B, BIDI_L   },  // LATIN SMALL LETTER UE
  { 0x1D6C, BIDI_L   },  // LATIN SMALL LETTER B WITH MIDDLE TILDE
  { 0x1D6D, BIDI_L   },  // LATIN SMALL LETTER D WITH MIDDLE TILDE
  { 0x1D6E, BIDI_L   },  // LATIN SMALL LETTER F WITH MIDDLE TILDE
  { 0x1D6F, BIDI_L   },  // LATIN SMALL LETTER M WITH MIDDLE TILDE
  { 0x1D70, BIDI_L   },  // LATIN SMALL LETTER N WITH MIDDLE TILDE
  { 0x1D71, BIDI_L   },  // LATIN SMALL LETTER P WITH MIDDLE TILDE
  { 0x1D72, BIDI_L   },  // LATIN SMALL LETTER R WITH MIDDLE TILDE
  { 0x1D73, BIDI_L   },  // LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE
  { 0x1D74, BIDI_L   },  // LATIN SMALL LETTER S WITH MIDDLE TILDE
  { 0x1D75, BIDI_L   },  // LATIN SMALL LETTER T WITH MIDDLE TILDE
  { 0x1D76, BIDI_L   },  // LATIN SMALL LETTER Z WITH MIDDLE TILDE
  { 0x1D77, BIDI_L   },  // LATIN SMALL LETTER TURNED G
  { 0x1D78, BIDI_L   },  // MODIFIER LETTER CYRILLIC EN
  { 0x1D79, BIDI_L   },  // LATIN SMALL LETTER INSULAR G
  { 0x1D7A, BIDI_L   },  // LATIN SMALL LETTER TH WITH STRIKETHROUGH
  { 0x1D7B, BIDI_L   },  // LATIN SMALL CAPITAL LETTER I WITH STROKE
  { 0x1D7C, BIDI_L   },  // LATIN SMALL LETTER IOTA WITH STROKE
  { 0x1D7D, BIDI_L   },  // LATIN SMALL LETTER P WITH STROKE
  { 0x1D7E, BIDI_L   },  // LATIN SMALL CAPITAL LETTER U WITH STROKE
  { 0x1D7F, BIDI_L   },  // LATIN SMALL LETTER UPSILON WITH STROKE
  { 0x1D80, BIDI_L   },  // LATIN SMALL LETTER B WITH PALATAL HOOK
  { 0x1D81, BIDI_L   },  // LATIN SMALL LETTER D WITH PALATAL HOOK
  { 0x1D82, BIDI_L   },  // LATIN SMALL LETTER F WITH PALATAL HOOK
  { 0x1D83, BIDI_L   },  // LATIN SMALL LETTER G WITH PALATAL HOOK
  { 0x1D84, BIDI_L   },  // LATIN SMALL LETTER K WITH PALATAL HOOK
  { 0x1D85, BIDI_L   },  // LATIN SMALL LETTER L WITH PALATAL HOOK
  { 0x1D86, BIDI_L   },  // LATIN SMALL LETTER M WITH PALATAL HOOK
  { 0x1D87, BIDI_L   },  // LATIN SMALL LETTER N WITH PALATAL HOOK
  { 0x1D88, BIDI_L   },  // LATIN SMALL LETTER P WITH PALATAL HOOK
  { 0x1D89, BIDI_L   },  // LATIN SMALL LETTER R WITH PALATAL HOOK
  { 0x1D8A, BIDI_L   },  // LATIN SMALL LETTER S WITH PALATAL HOOK
  { 0x1D8B, BIDI_L   },  // LATIN SMALL LETTER ESH WITH PALATAL HOOK
  { 0x1D8C, BIDI_L   },  // LATIN SMALL LETTER V WITH PALATAL HOOK
  { 0x1D8D, BIDI_L   },  // LATIN SMALL LETTER X WITH PALATAL HOOK
  { 0x1D8E, BIDI_L   },  // LATIN SMALL LETTER Z WITH PALATAL HOOK
  { 0x1D8F, BIDI_L   },  // LATIN SMALL LETTER A WITH RETROFLEX HOOK
  { 0x1D90, BIDI_L   },  // LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK
  { 0x1D91, BIDI_L   },  // LATIN SMALL LETTER D WITH HOOK AND TAIL
  { 0x1D92, BIDI_L   },  // LATIN SMALL LETTER E WITH RETROFLEX HOOK
  { 0x1D93, BIDI_L   },  // LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK
  { 0x1D94, BIDI_L   },  // LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK
  { 0x1D95, BIDI_L   },  // LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK
  { 0x1D96, BIDI_L   },  // LATIN SMALL LETTER I WITH RETROFLEX HOOK
  { 0x1D97, BIDI_L   },  // LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK
  { 0x1D98, BIDI_L   },  // LATIN SMALL LETTER ESH WITH RETROFLEX HOOK
  { 0x1D99, BIDI_L   },  // LATIN SMALL LETTER U WITH RETROFLEX HOOK
  { 0x1D9A, BIDI_L   },  // LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
  { 0x1D9B, BIDI_L   },  // MODIFIER LETTER SMALL TURNED ALPHA
  { 0x1D9C, BIDI_L   },  // MODIFIER LETTER SMALL C
  { 0x1D9D, BIDI_L   },  // MODIFIER LETTER SMALL C WITH CURL
  { 0x1D9E, BIDI_L   },  // MODIFIER LETTER SMALL ETH
  { 0x1D9F, BIDI_L   },  // MODIFIER LETTER SMALL REVERSED OPEN E
  { 0x1DA0, BIDI_L   },  // MODIFIER LETTER SMALL F
  { 0x1DA1, BIDI_L   },  // MODIFIER LETTER SMALL DOTLESS J WITH STROKE
  { 0x1DA2, BIDI_L   },  // MODIFIER LETTER SMALL SCRIPT G
  { 0x1DA3, BIDI_L   },  // MODIFIER LETTER SMALL TURNED H
  { 0x1DA4, BIDI_L   },  // MODIFIER LETTER SMALL I WITH STROKE
  { 0x1DA5, BIDI_L   },  // MODIFIER LETTER SMALL IOTA
  { 0x1DA6, BIDI_L   },  // MODIFIER LETTER SMALL CAPITAL I
  { 0x1DA7, BIDI_L   },  // MODIFIER LETTER SMALL CAPITAL I WITH STROKE
  { 0x1DA8, BIDI_L   },  // MODIFIER LETTER SMALL J WITH CROSSED-TAIL
  { 0x1DA9, BIDI_L   },  // MODIFIER LETTER SMALL L WITH RETROFLEX HOOK
  { 0x1DAA, BIDI_L   },  // MODIFIER LETTER SMALL L WITH PALATAL HOOK
  { 0x1DAB, BIDI_L   },  // MODIFIER LETTER SMALL CAPITAL L
  { 0x1DAC, BIDI_L   },  // MODIFIER LETTER SMALL M WITH HOOK
  { 0x1DAD, BIDI_L   },  // MODIFIER LETTER SMALL TURNED M WITH LONG LEG
  { 0x1DAE, BIDI_L   },  // MODIFIER LETTER SMALL N WITH LEFT HOOK
  { 0x1DAF, BIDI_L   },  // MODIFIER LETTER SMALL N WITH RETROFLEX HOOK
  { 0x1DB0, BIDI_L   },  // MODIFIER LETTER SMALL CAPITAL N
  { 0x1DB1, BIDI_L   },  // MODIFIER LETTER SMALL BARRED O
  { 0x1DB2, BIDI_L   },  // MODIFIER LETTER SMALL PHI
  { 0x1DB3, BIDI_L   },  // MODIFIER LETTER SMALL S WITH HOOK
  { 0x1DB4, BIDI_L   },  // MODIFIER LETTER SMALL ESH
  { 0x1DB5, BIDI_L   },  // MODIFIER LETTER SMALL T WITH PALATAL HOOK
  { 0x1DB6, BIDI_L   },  // MODIFIER LETTER SMALL U BAR
  { 0x1DB7, BIDI_L   },  // MODIFIER LETTER SMALL UPSILON
  { 0x1DB8, BIDI_L   },  // MODIFIER LETTER SMALL CAPITAL U
  { 0x1DB9, BIDI_L   },  // MODIFIER LETTER SMALL V WITH HOOK
  { 0x1DBA, BIDI_L   },  // MODIFIER LETTER SMALL TURNED V
  { 0x1DBB, BIDI_L   },  // MODIFIER LETTER SMALL Z
  { 0x1DBC, BIDI_L   },  // MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK
  { 0x1DBD, BIDI_L   },  // MODIFIER LETTER SMALL Z WITH CURL
  { 0x1DBE, BIDI_L   },  // MODIFIER LETTER SMALL EZH
  { 0x1DBF, BIDI_L   },  // MODIFIER LETTER SMALL THETA
  { 0x1DC0, BIDI_NSM },  // COMBINING DOTTED GRAVE ACCENT
  { 0x1DC1, BIDI_NSM },  // COMBINING DOTTED ACUTE ACCENT
  { 0x1DC2, BIDI_NSM },  // COMBINING SNAKE BELOW
  { 0x1DC3, BIDI_NSM },  // COMBINING SUSPENSION MARK
  { 0x1DC4, BIDI_NSM },  // COMBINING MACRON-ACUTE
  { 0x1DC5, BIDI_NSM },  // COMBINING GRAVE-MACRON
  { 0x1DC6, BIDI_NSM },  // COMBINING MACRON-GRAVE
  { 0x1DC7, BIDI_NSM },  // COMBINING ACUTE-MACRON
  { 0x1DC8, BIDI_NSM },  // COMBINING GRAVE-ACUTE-GRAVE
  { 0x1DC9, BIDI_NSM },  // COMBINING ACUTE-GRAVE-ACUTE
  { 0x1DCA, BIDI_NSM },  // COMBINING LATIN SMALL LETTER R BELOW
  { 0x1DCB, BIDI_NSM },  // COMBINING BREVE-MACRON
  { 0x1DCC, BIDI_NSM },  // COMBINING MACRON-BREVE
  { 0x1DCD, BIDI_NSM },  // COMBINING DOUBLE CIRCUMFLEX ABOVE
  { 0x1DCE, BIDI_NSM },  // COMBINING OGONEK ABOVE
  { 0x1DCF, BIDI_NSM },  // COMBINING ZIGZAG BELOW
  { 0x1DD0, BIDI_NSM },  // COMBINING IS BELOW
  { 0x1DD1, BIDI_NSM },  // COMBINING UR ABOVE
  { 0x1DD2, BIDI_NSM },  // COMBINING US ABOVE
  { 0x1DD3, BIDI_NSM },  // COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE
  { 0x1DD4, BIDI_NSM },  // COMBINING LATIN SMALL LETTER AE
  { 0x1DD5, BIDI_NSM },  // COMBINING LATIN SMALL LETTER AO
  { 0x1DD6, BIDI_NSM },  // COMBINING LATIN SMALL LETTER AV
  { 0x1DD7, BIDI_NSM },  // COMBINING LATIN SMALL LETTER C CEDILLA
  { 0x1DD8, BIDI_NSM },  // COMBINING LATIN SMALL LETTER INSULAR D
  { 0x1DD9, BIDI_NSM },  // COMBINING LATIN SMALL LETTER ETH
  { 0x1DDA, BIDI_NSM },  // COMBINING LATIN SMALL LETTER G
  { 0x1DDB, BIDI_NSM },  // COMBINING LATIN LETTER SMALL CAPITAL G
  { 0x1DDC, BIDI_NSM },  // COMBINING LATIN SMALL LETTER K
  { 0x1DDD, BIDI_NSM },  // COMBINING LATIN SMALL LETTER L
  { 0x1DDE, BIDI_NSM },  // COMBINING LATIN LETTER SMALL CAPITAL L
  { 0x1DDF, BIDI_NSM },  // COMBINING LATIN LETTER SMALL CAPITAL M
  { 0x1DE0, BIDI_NSM },  // COMBINING LATIN SMALL LETTER N
  { 0x1DE1, BIDI_NSM },  // COMBINING LATIN LETTER SMALL CAPITAL N
  { 0x1DE2, BIDI_NSM },  // COMBINING LATIN LETTER SMALL CAPITAL R
  { 0x1DE3, BIDI_NSM },  // COMBINING LATIN SMALL LETTER R ROTUNDA
  { 0x1DE4, BIDI_NSM },  // COMBINING LATIN SMALL LETTER S
  { 0x1DE5, BIDI_NSM },  // COMBINING LATIN SMALL LETTER LONG S
  { 0x1DE6, BIDI_NSM },  // COMBINING LATIN SMALL LETTER Z
  { 0x1DE7, BIDI_NSM },  // COMBINING LATIN SMALL LETTER ALPHA
  { 0x1DE8, BIDI_NSM },  // COMBINING LATIN SMALL LETTER B
  { 0x1DE9, BIDI_NSM },  // COMBINING LATIN SMALL LETTER BETA
  { 0x1DEA, BIDI_NSM },  // COMBINING LATIN SMALL LETTER SCHWA
  { 0x1DEB, BIDI_NSM },  // COMBINING LATIN SMALL LETTER F
  { 0x1DEC, BIDI_NSM },  // COMBINING LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE
  { 0x1DED, BIDI_NSM },  // COMBINING LATIN SMALL LETTER O WITH LIGHT CENTRALIZATION STROKE
  { 0x1DEE, BIDI_NSM },  // COMBINING LATIN SMALL LETTER P
  { 0x1DEF, BIDI_NSM },  // COMBINING LATIN SMALL LETTER ESH
  { 0x1DF0, BIDI_NSM },  // COMBINING LATIN SMALL LETTER U WITH LIGHT CENTRALIZATION STROKE
  { 0x1DF1, BIDI_NSM },  // COMBINING LATIN SMALL LETTER W
  { 0x1DF2, BIDI_NSM },  // COMBINING LATIN SMALL LETTER A WITH DIAERESIS
  { 0x1DF3, BIDI_NSM },  // COMBINING LATIN SMALL LETTER O WITH DIAERESIS
  { 0x1DF4, BIDI_NSM },  // COMBINING LATIN SMALL LETTER U WITH DIAERESIS
  { 0x1DF5, BIDI_NSM },  // COMBINING UP TACK ABOVE
  { 0x1DFC, BIDI_NSM },  // COMBINING DOUBLE INVERTED BREVE BELOW
  { 0x1DFD, BIDI_NSM },  // COMBINING ALMOST EQUAL TO BELOW
  { 0x1DFE, BIDI_NSM },  // COMBINING LEFT ARROWHEAD ABOVE
  { 0x1DFF, BIDI_NSM },  // COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
  { 0x1E00, BIDI_L   },  // LATIN CAPITAL LETTER A WITH RING BELOW
  { 0x1E01, BIDI_L   },  // LATIN SMALL LETTER A WITH RING BELOW
  { 0x1E02, BIDI_L   },  // LATIN CAPITAL LETTER B WITH DOT ABOVE
  { 0x1E03, BIDI_L   },  // LATIN SMALL LETTER B WITH DOT ABOVE
  { 0x1E04, BIDI_L   },  // LATIN CAPITAL LETTER B WITH DOT BELOW
  { 0x1E05, BIDI_L   },  // LATIN SMALL LETTER B WITH DOT BELOW
  { 0x1E06, BIDI_L   },  // LATIN CAPITAL LETTER B WITH LINE BELOW
  { 0x1E07, BIDI_L   },  // LATIN SMALL LETTER B WITH LINE BELOW
  { 0x1E08, BIDI_L   },  // LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
  { 0x1E09, BIDI_L   },  // LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
  { 0x1E0A, BIDI_L   },  // LATIN CAPITAL LETTER D WITH DOT ABOVE
  { 0x1E0B, BIDI_L   },  // LATIN SMALL LETTER D WITH DOT ABOVE
  { 0x1E0C, BIDI_L   },  // LATIN CAPITAL LETTER D WITH DOT BELOW
  { 0x1E0D, BIDI_L   },  // LATIN SMALL LETTER D WITH DOT BELOW
  { 0x1E0E, BIDI_L   },  // LATIN CAPITAL LETTER D WITH LINE BELOW
  { 0x1E0F, BIDI_L   },  // LATIN SMALL LETTER D WITH LINE BELOW
  { 0x1E10, BIDI_L   },  // LATIN CAPITAL LETTER D WITH CEDILLA
  { 0x1E11, BIDI_L   },  // LATIN SMALL LETTER D WITH CEDILLA
  { 0x1E12, BIDI_L   },  // LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
  { 0x1E13, BIDI_L   },  // LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
  { 0x1E14, BIDI_L   },  // LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
  { 0x1E15, BIDI_L   },  // LATIN SMALL LETTER E WITH MACRON AND GRAVE
  { 0x1E16, BIDI_L   },  // LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
  { 0x1E17, BIDI_L   },  // LATIN SMALL LETTER E WITH MACRON AND ACUTE
  { 0x1E18, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
  { 0x1E19, BIDI_L   },  // LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
  { 0x1E1A, BIDI_L   },  // LATIN CAPITAL LETTER E WITH TILDE BELOW
  { 0x1E1B, BIDI_L   },  // LATIN SMALL LETTER E WITH TILDE BELOW
  { 0x1E1C, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
  { 0x1E1D, BIDI_L   },  // LATIN SMALL LETTER E WITH CEDILLA AND BREVE
  { 0x1E1E, BIDI_L   },  // LATIN CAPITAL LETTER F WITH DOT ABOVE
  { 0x1E1F, BIDI_L   },  // LATIN SMALL LETTER F WITH DOT ABOVE
  { 0x1E20, BIDI_L   },  // LATIN CAPITAL LETTER G WITH MACRON
  { 0x1E21, BIDI_L   },  // LATIN SMALL LETTER G WITH MACRON
  { 0x1E22, BIDI_L   },  // LATIN CAPITAL LETTER H WITH DOT ABOVE
  { 0x1E23, BIDI_L   },  // LATIN SMALL LETTER H WITH DOT ABOVE
  { 0x1E24, BIDI_L   },  // LATIN CAPITAL LETTER H WITH DOT BELOW
  { 0x1E25, BIDI_L   },  // LATIN SMALL LETTER H WITH DOT BELOW
  { 0x1E26, BIDI_L   },  // LATIN CAPITAL LETTER H WITH DIAERESIS
  { 0x1E27, BIDI_L   },  // LATIN SMALL LETTER H WITH DIAERESIS
  { 0x1E28, BIDI_L   },  // LATIN CAPITAL LETTER H WITH CEDILLA
  { 0x1E29, BIDI_L   },  // LATIN SMALL LETTER H WITH CEDILLA
  { 0x1E2A, BIDI_L   },  // LATIN CAPITAL LETTER H WITH BREVE BELOW
  { 0x1E2B, BIDI_L   },  // LATIN SMALL LETTER H WITH BREVE BELOW
  { 0x1E2C, BIDI_L   },  // LATIN CAPITAL LETTER I WITH TILDE BELOW
  { 0x1E2D, BIDI_L   },  // LATIN SMALL LETTER I WITH TILDE BELOW
  { 0x1E2E, BIDI_L   },  // LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
  { 0x1E2F, BIDI_L   },  // LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
  { 0x1E30, BIDI_L   },  // LATIN CAPITAL LETTER K WITH ACUTE
  { 0x1E31, BIDI_L   },  // LATIN SMALL LETTER K WITH ACUTE
  { 0x1E32, BIDI_L   },  // LATIN CAPITAL LETTER K WITH DOT BELOW
  { 0x1E33, BIDI_L   },  // LATIN SMALL LETTER K WITH DOT BELOW
  { 0x1E34, BIDI_L   },  // LATIN CAPITAL LETTER K WITH LINE BELOW
  { 0x1E35, BIDI_L   },  // LATIN SMALL LETTER K WITH LINE BELOW
  { 0x1E36, BIDI_L   },  // LATIN CAPITAL LETTER L WITH DOT BELOW
  { 0x1E37, BIDI_L   },  // LATIN SMALL LETTER L WITH DOT BELOW
  { 0x1E38, BIDI_L   },  // LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
  { 0x1E39, BIDI_L   },  // LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
  { 0x1E3A, BIDI_L   },  // LATIN CAPITAL LETTER L WITH LINE BELOW
  { 0x1E3B, BIDI_L   },  // LATIN SMALL LETTER L WITH LINE BELOW
  { 0x1E3C, BIDI_L   },  // LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
  { 0x1E3D, BIDI_L   },  // LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
  { 0x1E3E, BIDI_L   },  // LATIN CAPITAL LETTER M WITH ACUTE
  { 0x1E3F, BIDI_L   },  // LATIN SMALL LETTER M WITH ACUTE
  { 0x1E40, BIDI_L   },  // LATIN CAPITAL LETTER M WITH DOT ABOVE
  { 0x1E41, BIDI_L   },  // LATIN SMALL LETTER M WITH DOT ABOVE
  { 0x1E42, BIDI_L   },  // LATIN CAPITAL LETTER M WITH DOT BELOW
  { 0x1E43, BIDI_L   },  // LATIN SMALL LETTER M WITH DOT BELOW
  { 0x1E44, BIDI_L   },  // LATIN CAPITAL LETTER N WITH DOT ABOVE
  { 0x1E45, BIDI_L   },  // LATIN SMALL LETTER N WITH DOT ABOVE
  { 0x1E46, BIDI_L   },  // LATIN CAPITAL LETTER N WITH DOT BELOW
  { 0x1E47, BIDI_L   },  // LATIN SMALL LETTER N WITH DOT BELOW
  { 0x1E48, BIDI_L   },  // LATIN CAPITAL LETTER N WITH LINE BELOW
  { 0x1E49, BIDI_L   },  // LATIN SMALL LETTER N WITH LINE BELOW
  { 0x1E4A, BIDI_L   },  // LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
  { 0x1E4B, BIDI_L   },  // LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
  { 0x1E4C, BIDI_L   },  // LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
  { 0x1E4D, BIDI_L   },  // LATIN SMALL LETTER O WITH TILDE AND ACUTE
  { 0x1E4E, BIDI_L   },  // LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
  { 0x1E4F, BIDI_L   },  // LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
  { 0x1E50, BIDI_L   },  // LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
  { 0x1E51, BIDI_L   },  // LATIN SMALL LETTER O WITH MACRON AND GRAVE
  { 0x1E52, BIDI_L   },  // LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
  { 0x1E53, BIDI_L   },  // LATIN SMALL LETTER O WITH MACRON AND ACUTE
  { 0x1E54, BIDI_L   },  // LATIN CAPITAL LETTER P WITH ACUTE
  { 0x1E55, BIDI_L   },  // LATIN SMALL LETTER P WITH ACUTE
  { 0x1E56, BIDI_L   },  // LATIN CAPITAL LETTER P WITH DOT ABOVE
  { 0x1E57, BIDI_L   },  // LATIN SMALL LETTER P WITH DOT ABOVE
  { 0x1E58, BIDI_L   },  // LATIN CAPITAL LETTER R WITH DOT ABOVE
  { 0x1E59, BIDI_L   },  // LATIN SMALL LETTER R WITH DOT ABOVE
  { 0x1E5A, BIDI_L   },  // LATIN CAPITAL LETTER R WITH DOT BELOW
  { 0x1E5B, BIDI_L   },  // LATIN SMALL LETTER R WITH DOT BELOW
  { 0x1E5C, BIDI_L   },  // LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
  { 0x1E5D, BIDI_L   },  // LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
  { 0x1E5E, BIDI_L   },  // LATIN CAPITAL LETTER R WITH LINE BELOW
  { 0x1E5F, BIDI_L   },  // LATIN SMALL LETTER R WITH LINE BELOW
  { 0x1E60, BIDI_L   },  // LATIN CAPITAL LETTER S WITH DOT ABOVE
  { 0x1E61, BIDI_L   },  // LATIN SMALL LETTER S WITH DOT ABOVE
  { 0x1E62, BIDI_L   },  // LATIN CAPITAL LETTER S WITH DOT BELOW
  { 0x1E63, BIDI_L   },  // LATIN SMALL LETTER S WITH DOT BELOW
  { 0x1E64, BIDI_L   },  // LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
  { 0x1E65, BIDI_L   },  // LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
  { 0x1E66, BIDI_L   },  // LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
  { 0x1E67, BIDI_L   },  // LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
  { 0x1E68, BIDI_L   },  // LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
  { 0x1E69, BIDI_L   },  // LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
  { 0x1E6A, BIDI_L   },  // LATIN CAPITAL LETTER T WITH DOT ABOVE
  { 0x1E6B, BIDI_L   },  // LATIN SMALL LETTER T WITH DOT ABOVE
  { 0x1E6C, BIDI_L   },  // LATIN CAPITAL LETTER T WITH DOT BELOW
  { 0x1E6D, BIDI_L   },  // LATIN SMALL LETTER T WITH DOT BELOW
  { 0x1E6E, BIDI_L   },  // LATIN CAPITAL LETTER T WITH LINE BELOW
  { 0x1E6F, BIDI_L   },  // LATIN SMALL LETTER T WITH LINE BELOW
  { 0x1E70, BIDI_L   },  // LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
  { 0x1E71, BIDI_L   },  // LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
  { 0x1E72, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
  { 0x1E73, BIDI_L   },  // LATIN SMALL LETTER U WITH DIAERESIS BELOW
  { 0x1E74, BIDI_L   },  // LATIN CAPITAL LETTER U WITH TILDE BELOW
  { 0x1E75, BIDI_L   },  // LATIN SMALL LETTER U WITH TILDE BELOW
  { 0x1E76, BIDI_L   },  // LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
  { 0x1E77, BIDI_L   },  // LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
  { 0x1E78, BIDI_L   },  // LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
  { 0x1E79, BIDI_L   },  // LATIN SMALL LETTER U WITH TILDE AND ACUTE
  { 0x1E7A, BIDI_L   },  // LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
  { 0x1E7B, BIDI_L   },  // LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
  { 0x1E7C, BIDI_L   },  // LATIN CAPITAL LETTER V WITH TILDE
  { 0x1E7D, BIDI_L   },  // LATIN SMALL LETTER V WITH TILDE
  { 0x1E7E, BIDI_L   },  // LATIN CAPITAL LETTER V WITH DOT BELOW
  { 0x1E7F, BIDI_L   },  // LATIN SMALL LETTER V WITH DOT BELOW
  { 0x1E80, BIDI_L   },  // LATIN CAPITAL LETTER W WITH GRAVE
  { 0x1E81, BIDI_L   },  // LATIN SMALL LETTER W WITH GRAVE
  { 0x1E82, BIDI_L   },  // LATIN CAPITAL LETTER W WITH ACUTE
  { 0x1E83, BIDI_L   },  // LATIN SMALL LETTER W WITH ACUTE
  { 0x1E84, BIDI_L   },  // LATIN CAPITAL LETTER W WITH DIAERESIS
  { 0x1E85, BIDI_L   },  // LATIN SMALL LETTER W WITH DIAERESIS
  { 0x1E86, BIDI_L   },  // LATIN CAPITAL LETTER W WITH DOT ABOVE
  { 0x1E87, BIDI_L   },  // LATIN SMALL LETTER W WITH DOT ABOVE
  { 0x1E88, BIDI_L   },  // LATIN CAPITAL LETTER W WITH DOT BELOW
  { 0x1E89, BIDI_L   },  // LATIN SMALL LETTER W WITH DOT BELOW
  { 0x1E8A, BIDI_L   },  // LATIN CAPITAL LETTER X WITH DOT ABOVE
  { 0x1E8B, BIDI_L   },  // LATIN SMALL LETTER X WITH DOT ABOVE
  { 0x1E8C, BIDI_L   },  // LATIN CAPITAL LETTER X WITH DIAERESIS
  { 0x1E8D, BIDI_L   },  // LATIN SMALL LETTER X WITH DIAERESIS
  { 0x1E8E, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH DOT ABOVE
  { 0x1E8F, BIDI_L   },  // LATIN SMALL LETTER Y WITH DOT ABOVE
  { 0x1E90, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
  { 0x1E91, BIDI_L   },  // LATIN SMALL LETTER Z WITH CIRCUMFLEX
  { 0x1E92, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH DOT BELOW
  { 0x1E93, BIDI_L   },  // LATIN SMALL LETTER Z WITH DOT BELOW
  { 0x1E94, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH LINE BELOW
  { 0x1E95, BIDI_L   },  // LATIN SMALL LETTER Z WITH LINE BELOW
  { 0x1E96, BIDI_L   },  // LATIN SMALL LETTER H WITH LINE BELOW
  { 0x1E97, BIDI_L   },  // LATIN SMALL LETTER T WITH DIAERESIS
  { 0x1E98, BIDI_L   },  // LATIN SMALL LETTER W WITH RING ABOVE
  { 0x1E99, BIDI_L   },  // LATIN SMALL LETTER Y WITH RING ABOVE
  { 0x1E9A, BIDI_L   },  // LATIN SMALL LETTER A WITH RIGHT HALF RING
  { 0x1E9B, BIDI_L   },  // LATIN SMALL LETTER LONG S WITH DOT ABOVE
  { 0x1E9C, BIDI_L   },  // LATIN SMALL LETTER LONG S WITH DIAGONAL STROKE
  { 0x1E9D, BIDI_L   },  // LATIN SMALL LETTER LONG S WITH HIGH STROKE
  { 0x1E9E, BIDI_L   },  // LATIN CAPITAL LETTER SHARP S
  { 0x1E9F, BIDI_L   },  // LATIN SMALL LETTER DELTA
  { 0x1EA0, BIDI_L   },  // LATIN CAPITAL LETTER A WITH DOT BELOW
  { 0x1EA1, BIDI_L   },  // LATIN SMALL LETTER A WITH DOT BELOW
  { 0x1EA2, BIDI_L   },  // LATIN CAPITAL LETTER A WITH HOOK ABOVE
  { 0x1EA3, BIDI_L   },  // LATIN SMALL LETTER A WITH HOOK ABOVE
  { 0x1EA4, BIDI_L   },  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
  { 0x1EA5, BIDI_L   },  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
  { 0x1EA6, BIDI_L   },  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
  { 0x1EA7, BIDI_L   },  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
  { 0x1EA8, BIDI_L   },  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x1EA9, BIDI_L   },  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x1EAA, BIDI_L   },  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
  { 0x1EAB, BIDI_L   },  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
  { 0x1EAC, BIDI_L   },  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
  { 0x1EAD, BIDI_L   },  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
  { 0x1EAE, BIDI_L   },  // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
  { 0x1EAF, BIDI_L   },  // LATIN SMALL LETTER A WITH BREVE AND ACUTE
  { 0x1EB0, BIDI_L   },  // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
  { 0x1EB1, BIDI_L   },  // LATIN SMALL LETTER A WITH BREVE AND GRAVE
  { 0x1EB2, BIDI_L   },  // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
  { 0x1EB3, BIDI_L   },  // LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
  { 0x1EB4, BIDI_L   },  // LATIN CAPITAL LETTER A WITH BREVE AND TILDE
  { 0x1EB5, BIDI_L   },  // LATIN SMALL LETTER A WITH BREVE AND TILDE
  { 0x1EB6, BIDI_L   },  // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
  { 0x1EB7, BIDI_L   },  // LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
  { 0x1EB8, BIDI_L   },  // LATIN CAPITAL LETTER E WITH DOT BELOW
  { 0x1EB9, BIDI_L   },  // LATIN SMALL LETTER E WITH DOT BELOW
  { 0x1EBA, BIDI_L   },  // LATIN CAPITAL LETTER E WITH HOOK ABOVE
  { 0x1EBB, BIDI_L   },  // LATIN SMALL LETTER E WITH HOOK ABOVE
  { 0x1EBC, BIDI_L   },  // LATIN CAPITAL LETTER E WITH TILDE
  { 0x1EBD, BIDI_L   },  // LATIN SMALL LETTER E WITH TILDE
  { 0x1EBE, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
  { 0x1EBF, BIDI_L   },  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
  { 0x1EC0, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
  { 0x1EC1, BIDI_L   },  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
  { 0x1EC2, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x1EC3, BIDI_L   },  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x1EC4, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
  { 0x1EC5, BIDI_L   },  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
  { 0x1EC6, BIDI_L   },  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
  { 0x1EC7, BIDI_L   },  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
  { 0x1EC8, BIDI_L   },  // LATIN CAPITAL LETTER I WITH HOOK ABOVE
  { 0x1EC9, BIDI_L   },  // LATIN SMALL LETTER I WITH HOOK ABOVE
  { 0x1ECA, BIDI_L   },  // LATIN CAPITAL LETTER I WITH DOT BELOW
  { 0x1ECB, BIDI_L   },  // LATIN SMALL LETTER I WITH DOT BELOW
  { 0x1ECC, BIDI_L   },  // LATIN CAPITAL LETTER O WITH DOT BELOW
  { 0x1ECD, BIDI_L   },  // LATIN SMALL LETTER O WITH DOT BELOW
  { 0x1ECE, BIDI_L   },  // LATIN CAPITAL LETTER O WITH HOOK ABOVE
  { 0x1ECF, BIDI_L   },  // LATIN SMALL LETTER O WITH HOOK ABOVE
  { 0x1ED0, BIDI_L   },  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
  { 0x1ED1, BIDI_L   },  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
  { 0x1ED2, BIDI_L   },  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
  { 0x1ED3, BIDI_L   },  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
  { 0x1ED4, BIDI_L   },  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x1ED5, BIDI_L   },  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
  { 0x1ED6, BIDI_L   },  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
  { 0x1ED7, BIDI_L   },  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
  { 0x1ED8, BIDI_L   },  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
  { 0x1ED9, BIDI_L   },  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
  { 0x1EDA, BIDI_L   },  // LATIN CAPITAL LETTER O WITH HORN AND ACUTE
  { 0x1EDB, BIDI_L   },  // LATIN SMALL LETTER O WITH HORN AND ACUTE
  { 0x1EDC, BIDI_L   },  // LATIN CAPITAL LETTER O WITH HORN AND GRAVE
  { 0x1EDD, BIDI_L   },  // LATIN SMALL LETTER O WITH HORN AND GRAVE
  { 0x1EDE, BIDI_L   },  // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
  { 0x1EDF, BIDI_L   },  // LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
  { 0x1EE0, BIDI_L   },  // LATIN CAPITAL LETTER O WITH HORN AND TILDE
  { 0x1EE1, BIDI_L   },  // LATIN SMALL LETTER O WITH HORN AND TILDE
  { 0x1EE2, BIDI_L   },  // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
  { 0x1EE3, BIDI_L   },  // LATIN SMALL LETTER O WITH HORN AND DOT BELOW
  { 0x1EE4, BIDI_L   },  // LATIN CAPITAL LETTER U WITH DOT BELOW
  { 0x1EE5, BIDI_L   },  // LATIN SMALL LETTER U WITH DOT BELOW
  { 0x1EE6, BIDI_L   },  // LATIN CAPITAL LETTER U WITH HOOK ABOVE
  { 0x1EE7, BIDI_L   },  // LATIN SMALL LETTER U WITH HOOK ABOVE
  { 0x1EE8, BIDI_L   },  // LATIN CAPITAL LETTER U WITH HORN AND ACUTE
  { 0x1EE9, BIDI_L   },  // LATIN SMALL LETTER U WITH HORN AND ACUTE
  { 0x1EEA, BIDI_L   },  // LATIN CAPITAL LETTER U WITH HORN AND GRAVE
  { 0x1EEB, BIDI_L   },  // LATIN SMALL LETTER U WITH HORN AND GRAVE
  { 0x1EEC, BIDI_L   },  // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
  { 0x1EED, BIDI_L   },  // LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
  { 0x1EEE, BIDI_L   },  // LATIN CAPITAL LETTER U WITH HORN AND TILDE
  { 0x1EEF, BIDI_L   },  // LATIN SMALL LETTER U WITH HORN AND TILDE
  { 0x1EF0, BIDI_L   },  // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
  { 0x1EF1, BIDI_L   },  // LATIN SMALL LETTER U WITH HORN AND DOT BELOW
  { 0x1EF2, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH GRAVE
  { 0x1EF3, BIDI_L   },  // LATIN SMALL LETTER Y WITH GRAVE
  { 0x1EF4, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH DOT BELOW
  { 0x1EF5, BIDI_L   },  // LATIN SMALL LETTER Y WITH DOT BELOW
  { 0x1EF6, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH HOOK ABOVE
  { 0x1EF7, BIDI_L   },  // LATIN SMALL LETTER Y WITH HOOK ABOVE
  { 0x1EF8, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH TILDE
  { 0x1EF9, BIDI_L   },  // LATIN SMALL LETTER Y WITH TILDE
  { 0x1EFA, BIDI_L   },  // LATIN CAPITAL LETTER MIDDLE-WELSH LL
  { 0x1EFB, BIDI_L   },  // LATIN SMALL LETTER MIDDLE-WELSH LL
  { 0x1EFC, BIDI_L   },  // LATIN CAPITAL LETTER MIDDLE-WELSH V
  { 0x1EFD, BIDI_L   },  // LATIN SMALL LETTER MIDDLE-WELSH V
  { 0x1EFE, BIDI_L   },  // LATIN CAPITAL LETTER Y WITH LOOP
  { 0x1EFF, BIDI_L   },  // LATIN SMALL LETTER Y WITH LOOP
  { 0x1F00, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PSILI
  { 0x1F01, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH DASIA
  { 0x1F02, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
  { 0x1F03, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
  { 0x1F04, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
  { 0x1F05, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
  { 0x1F06, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
  { 0x1F07, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
  { 0x1F08, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PSILI
  { 0x1F09, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH DASIA
  { 0x1F0A, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
  { 0x1F0B, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
  { 0x1F0C, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
  { 0x1F0D, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
  { 0x1F0E, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
  { 0x1F0F, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
  { 0x1F10, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH PSILI
  { 0x1F11, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH DASIA
  { 0x1F12, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA
  { 0x1F13, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA
  { 0x1F14, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA
  { 0x1F15, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
  { 0x1F18, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH PSILI
  { 0x1F19, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH DASIA
  { 0x1F1A, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
  { 0x1F1B, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
  { 0x1F1C, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
  { 0x1F1D, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
  { 0x1F20, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PSILI
  { 0x1F21, BIDI_L   },  // GREEK SMALL LETTER ETA WITH DASIA
  { 0x1F22, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PSILI AND VARIA
  { 0x1F23, BIDI_L   },  // GREEK SMALL LETTER ETA WITH DASIA AND VARIA
  { 0x1F24, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PSILI AND OXIA
  { 0x1F25, BIDI_L   },  // GREEK SMALL LETTER ETA WITH DASIA AND OXIA
  { 0x1F26, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI
  { 0x1F27, BIDI_L   },  // GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
  { 0x1F28, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PSILI
  { 0x1F29, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH DASIA
  { 0x1F2A, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
  { 0x1F2B, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
  { 0x1F2C, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
  { 0x1F2D, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
  { 0x1F2E, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
  { 0x1F2F, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
  { 0x1F30, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH PSILI
  { 0x1F31, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DASIA
  { 0x1F32, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH PSILI AND VARIA
  { 0x1F33, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DASIA AND VARIA
  { 0x1F34, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH PSILI AND OXIA
  { 0x1F35, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DASIA AND OXIA
  { 0x1F36, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI
  { 0x1F37, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
  { 0x1F38, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH PSILI
  { 0x1F39, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH DASIA
  { 0x1F3A, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
  { 0x1F3B, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
  { 0x1F3C, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
  { 0x1F3D, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
  { 0x1F3E, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
  { 0x1F3F, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
  { 0x1F40, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH PSILI
  { 0x1F41, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH DASIA
  { 0x1F42, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA
  { 0x1F43, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA
  { 0x1F44, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA
  { 0x1F45, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
  { 0x1F48, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH PSILI
  { 0x1F49, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH DASIA
  { 0x1F4A, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
  { 0x1F4B, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
  { 0x1F4C, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
  { 0x1F4D, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
  { 0x1F50, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH PSILI
  { 0x1F51, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DASIA
  { 0x1F52, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
  { 0x1F53, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
  { 0x1F54, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
  { 0x1F55, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
  { 0x1F56, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
  { 0x1F57, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
  { 0x1F59, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH DASIA
  { 0x1F5B, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
  { 0x1F5D, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
  { 0x1F5F, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
  { 0x1F60, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PSILI
  { 0x1F61, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH DASIA
  { 0x1F62, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA
  { 0x1F63, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA
  { 0x1F64, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA
  { 0x1F65, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA
  { 0x1F66, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI
  { 0x1F67, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
  { 0x1F68, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PSILI
  { 0x1F69, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH DASIA
  { 0x1F6A, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
  { 0x1F6B, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
  { 0x1F6C, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
  { 0x1F6D, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
  { 0x1F6E, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
  { 0x1F6F, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
  { 0x1F70, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH VARIA
  { 0x1F71, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH OXIA
  { 0x1F72, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH VARIA
  { 0x1F73, BIDI_L   },  // GREEK SMALL LETTER EPSILON WITH OXIA
  { 0x1F74, BIDI_L   },  // GREEK SMALL LETTER ETA WITH VARIA
  { 0x1F75, BIDI_L   },  // GREEK SMALL LETTER ETA WITH OXIA
  { 0x1F76, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH VARIA
  { 0x1F77, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH OXIA
  { 0x1F78, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH VARIA
  { 0x1F79, BIDI_L   },  // GREEK SMALL LETTER OMICRON WITH OXIA
  { 0x1F7A, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH VARIA
  { 0x1F7B, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH OXIA
  { 0x1F7C, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH VARIA
  { 0x1F7D, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH OXIA
  { 0x1F80, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
  { 0x1F81, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
  { 0x1F82, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
  { 0x1F83, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
  { 0x1F84, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
  { 0x1F85, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
  { 0x1F86, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
  { 0x1F87, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
  { 0x1F88, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
  { 0x1F89, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
  { 0x1F8A, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x1F8B, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x1F8C, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x1F8D, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x1F8E, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x1F8F, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x1F90, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
  { 0x1F91, BIDI_L   },  // GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
  { 0x1F92, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
  { 0x1F93, BIDI_L   },  // GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
  { 0x1F94, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
  { 0x1F95, BIDI_L   },  // GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
  { 0x1F96, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
  { 0x1F97, BIDI_L   },  // GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
  { 0x1F98, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
  { 0x1F99, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
  { 0x1F9A, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x1F9B, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x1F9C, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x1F9D, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x1F9E, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x1F9F, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x1FA0, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
  { 0x1FA1, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
  { 0x1FA2, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
  { 0x1FA3, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
  { 0x1FA4, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
  { 0x1FA5, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
  { 0x1FA6, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
  { 0x1FA7, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
  { 0x1FA8, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
  { 0x1FA9, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
  { 0x1FAA, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
  { 0x1FAB, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
  { 0x1FAC, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
  { 0x1FAD, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
  { 0x1FAE, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x1FAF, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
  { 0x1FB0, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH VRACHY
  { 0x1FB1, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH MACRON
  { 0x1FB2, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
  { 0x1FB3, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
  { 0x1FB4, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
  { 0x1FB6, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PERISPOMENI
  { 0x1FB7, BIDI_L   },  // GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
  { 0x1FB8, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH VRACHY
  { 0x1FB9, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH MACRON
  { 0x1FBA, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH VARIA
  { 0x1FBB, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH OXIA
  { 0x1FBC, BIDI_L   },  // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
  { 0x1FBD, BIDI_ON  },  // GREEK KORONIS
  { 0x1FBE, BIDI_L   },  // GREEK PROSGEGRAMMENI
  { 0x1FBF, BIDI_ON  },  // GREEK PSILI
  { 0x1FC0, BIDI_ON  },  // GREEK PERISPOMENI
  { 0x1FC1, BIDI_ON  },  // GREEK DIALYTIKA AND PERISPOMENI
  { 0x1FC2, BIDI_L   },  // GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
  { 0x1FC3, BIDI_L   },  // GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
  { 0x1FC4, BIDI_L   },  // GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
  { 0x1FC6, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PERISPOMENI
  { 0x1FC7, BIDI_L   },  // GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
  { 0x1FC8, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH VARIA
  { 0x1FC9, BIDI_L   },  // GREEK CAPITAL LETTER EPSILON WITH OXIA
  { 0x1FCA, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH VARIA
  { 0x1FCB, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH OXIA
  { 0x1FCC, BIDI_L   },  // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
  { 0x1FCD, BIDI_ON  },  // GREEK PSILI AND VARIA
  { 0x1FCE, BIDI_ON  },  // GREEK PSILI AND OXIA
  { 0x1FCF, BIDI_ON  },  // GREEK PSILI AND PERISPOMENI
  { 0x1FD0, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH VRACHY
  { 0x1FD1, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH MACRON
  { 0x1FD2, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
  { 0x1FD3, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
  { 0x1FD6, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH PERISPOMENI
  { 0x1FD7, BIDI_L   },  // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
  { 0x1FD8, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH VRACHY
  { 0x1FD9, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH MACRON
  { 0x1FDA, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH VARIA
  { 0x1FDB, BIDI_L   },  // GREEK CAPITAL LETTER IOTA WITH OXIA
  { 0x1FDD, BIDI_ON  },  // GREEK DASIA AND VARIA
  { 0x1FDE, BIDI_ON  },  // GREEK DASIA AND OXIA
  { 0x1FDF, BIDI_ON  },  // GREEK DASIA AND PERISPOMENI
  { 0x1FE0, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH VRACHY
  { 0x1FE1, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH MACRON
  { 0x1FE2, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
  { 0x1FE3, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
  { 0x1FE4, BIDI_L   },  // GREEK SMALL LETTER RHO WITH PSILI
  { 0x1FE5, BIDI_L   },  // GREEK SMALL LETTER RHO WITH DASIA
  { 0x1FE6, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH PERISPOMENI
  { 0x1FE7, BIDI_L   },  // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
  { 0x1FE8, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH VRACHY
  { 0x1FE9, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH MACRON
  { 0x1FEA, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH VARIA
  { 0x1FEB, BIDI_L   },  // GREEK CAPITAL LETTER UPSILON WITH OXIA
  { 0x1FEC, BIDI_L   },  // GREEK CAPITAL LETTER RHO WITH DASIA
  { 0x1FED, BIDI_ON  },  // GREEK DIALYTIKA AND VARIA
  { 0x1FEE, BIDI_ON  },  // GREEK DIALYTIKA AND OXIA
  { 0x1FEF, BIDI_ON  },  // GREEK VARIA
  { 0x1FF2, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
  { 0x1FF3, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
  { 0x1FF4, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
  { 0x1FF6, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PERISPOMENI
  { 0x1FF7, BIDI_L   },  // GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
  { 0x1FF8, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH VARIA
  { 0x1FF9, BIDI_L   },  // GREEK CAPITAL LETTER OMICRON WITH OXIA
  { 0x1FFA, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH VARIA
  { 0x1FFB, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH OXIA
  { 0x1FFC, BIDI_L   },  // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
  { 0x1FFD, BIDI_ON  },  // GREEK OXIA
  { 0x1FFE, BIDI_ON  },  // GREEK DASIA

#endif
#if (GUI_BIDI_SUPPORT_RANGE_2 == 1)

  { 0x2000, BIDI_WS  },  // EN QUAD
  { 0x2001, BIDI_WS  },  // EM QUAD
  { 0x2002, BIDI_WS  },  // EN SPACE
  { 0x2003, BIDI_WS  },  // EM SPACE
  { 0x2004, BIDI_WS  },  // THREE-PER-EM SPACE
  { 0x2005, BIDI_WS  },  // FOUR-PER-EM SPACE
  { 0x2006, BIDI_WS  },  // SIX-PER-EM SPACE
  { 0x2007, BIDI_WS  },  // FIGURE SPACE
  { 0x2008, BIDI_WS  },  // PUNCTUATION SPACE
  { 0x2009, BIDI_WS  },  // THIN SPACE
  { 0x200A, BIDI_WS  },  // HAIR SPACE
  { 0x200B, BIDI_BN  },  // ZERO WIDTH SPACE
  { 0x200C, BIDI_BN  },  // ZERO WIDTH NON-JOINER
  { 0x200D, BIDI_BN  },  // ZERO WIDTH JOINER
  { 0x200E, BIDI_L   },  // LEFT-TO-RIGHT MARK
  { 0x200F, BIDI_R   },  // RIGHT-TO-LEFT MARK
  { 0x2010, BIDI_ON  },  // HYPHEN
  { 0x2011, BIDI_ON  },  // NON-BREAKING HYPHEN
  { 0x2012, BIDI_ON  },  // FIGURE DASH
  { 0x2013, BIDI_ON  },  // EN DASH
  { 0x2014, BIDI_ON  },  // EM DASH
  { 0x2015, BIDI_ON  },  // HORIZONTAL BAR
  { 0x2016, BIDI_ON  },  // DOUBLE VERTICAL LINE
  { 0x2017, BIDI_ON  },  // DOUBLE LOW LINE
  { 0x2018, BIDI_ON  },  // LEFT SINGLE QUOTATION MARK
  { 0x2019, BIDI_ON  },  // RIGHT SINGLE QUOTATION MARK
  { 0x201A, BIDI_ON  },  // SINGLE LOW-9 QUOTATION MARK
  { 0x201B, BIDI_ON  },  // SINGLE HIGH-REVERSED-9 QUOTATION MARK
  { 0x201C, BIDI_ON  },  // LEFT DOUBLE QUOTATION MARK
  { 0x201D, BIDI_ON  },  // RIGHT DOUBLE QUOTATION MARK
  { 0x201E, BIDI_ON  },  // DOUBLE LOW-9 QUOTATION MARK
  { 0x201F, BIDI_ON  },  // DOUBLE HIGH-REVERSED-9 QUOTATION MARK
  { 0x2020, BIDI_ON  },  // DAGGER
  { 0x2021, BIDI_ON  },  // DOUBLE DAGGER
  { 0x2022, BIDI_ON  },  // BULLET
  { 0x2023, BIDI_ON  },  // TRIANGULAR BULLET
  { 0x2024, BIDI_ON  },  // ONE DOT LEADER
  { 0x2025, BIDI_ON  },  // TWO DOT LEADER
  { 0x2026, BIDI_ON  },  // HORIZONTAL ELLIPSIS
  { 0x2027, BIDI_ON  },  // HYPHENATION POINT
  { 0x2028, BIDI_WS  },  // LINE SEPARATOR
  { 0x2029, BIDI_B   },  // PARAGRAPH SEPARATOR
  { 0x202A, BIDI_LRE },  // LEFT-TO-RIGHT EMBEDDING
  { 0x202B, BIDI_RLE },  // RIGHT-TO-LEFT EMBEDDING
  { 0x202C, BIDI_PDF },  // POP DIRECTIONAL FORMATTING
  { 0x202D, BIDI_LRO },  // LEFT-TO-RIGHT OVERRIDE
  { 0x202E, BIDI_RLO },  // RIGHT-TO-LEFT OVERRIDE
  { 0x202F, BIDI_CS  },  // NARROW NO-BREAK SPACE
  { 0x2030, BIDI_ET  },  // PER MILLE SIGN
  { 0x2031, BIDI_ET  },  // PER TEN THOUSAND SIGN
  { 0x2032, BIDI_ET  },  // PRIME
  { 0x2033, BIDI_ET  },  // DOUBLE PRIME
  { 0x2034, BIDI_ET  },  // TRIPLE PRIME
  { 0x2035, BIDI_ON  },  // REVERSED PRIME
  { 0x2036, BIDI_ON  },  // REVERSED DOUBLE PRIME
  { 0x2037, BIDI_ON  },  // REVERSED TRIPLE PRIME
  { 0x2038, BIDI_ON  },  // CARET
  { 0x2039, BIDI_ON  },  // SINGLE LEFT-POINTING ANGLE QUOTATION MARK
  { 0x203A, BIDI_ON  },  // SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
  { 0x203B, BIDI_ON  },  // REFERENCE MARK
  { 0x203C, BIDI_ON  },  // DOUBLE EXCLAMATION MARK
  { 0x203D, BIDI_ON  },  // INTERROBANG
  { 0x203E, BIDI_ON  },  // OVERLINE
  { 0x203F, BIDI_ON  },  // UNDERTIE
  { 0x2040, BIDI_ON  },  // CHARACTER TIE
  { 0x2041, BIDI_ON  },  // CARET INSERTION POINT
  { 0x2042, BIDI_ON  },  // ASTERISM
  { 0x2043, BIDI_ON  },  // HYPHEN BULLET
  { 0x2044, BIDI_CS  },  // FRACTION SLASH
  { 0x2045, BIDI_ON  },  // LEFT SQUARE BRACKET WITH QUILL
  { 0x2046, BIDI_ON  },  // RIGHT SQUARE BRACKET WITH QUILL
  { 0x2047, BIDI_ON  },  // DOUBLE QUESTION MARK
  { 0x2048, BIDI_ON  },  // QUESTION EXCLAMATION MARK
  { 0x2049, BIDI_ON  },  // EXCLAMATION QUESTION MARK
  { 0x204A, BIDI_ON  },  // TIRONIAN SIGN ET
  { 0x204B, BIDI_ON  },  // REVERSED PILCROW SIGN
  { 0x204C, BIDI_ON  },  // BLACK LEFTWARDS BULLET
  { 0x204D, BIDI_ON  },  // BLACK RIGHTWARDS BULLET
  { 0x204E, BIDI_ON  },  // LOW ASTERISK
  { 0x204F, BIDI_ON  },  // REVERSED SEMICOLON
  { 0x2050, BIDI_ON  },  // CLOSE UP
  { 0x2051, BIDI_ON  },  // TWO ASTERISKS ALIGNED VERTICALLY
  { 0x2052, BIDI_ON  },  // COMMERCIAL MINUS SIGN
  { 0x2053, BIDI_ON  },  // SWUNG DASH
  { 0x2054, BIDI_ON  },  // INVERTED UNDERTIE
  { 0x2055, BIDI_ON  },  // FLOWER PUNCTUATION MARK
  { 0x2056, BIDI_ON  },  // THREE DOT PUNCTUATION
  { 0x2057, BIDI_ON  },  // QUADRUPLE PRIME
  { 0x2058, BIDI_ON  },  // FOUR DOT PUNCTUATION
  { 0x2059, BIDI_ON  },  // FIVE DOT PUNCTUATION
  { 0x205A, BIDI_ON  },  // TWO DOT PUNCTUATION
  { 0x205B, BIDI_ON  },  // FOUR DOT MARK
  { 0x205C, BIDI_ON  },  // DOTTED CROSS
  { 0x205D, BIDI_ON  },  // TRICOLON
  { 0x205E, BIDI_ON  },  // VERTICAL FOUR DOTS
  { 0x205F, BIDI_WS  },  // MEDIUM MATHEMATICAL SPACE
  { 0x2060, BIDI_BN  },  // WORD JOINER
  { 0x2061, BIDI_BN  },  // FUNCTION APPLICATION
  { 0x2062, BIDI_BN  },  // INVISIBLE TIMES
  { 0x2063, BIDI_BN  },  // INVISIBLE SEPARATOR
  { 0x2064, BIDI_BN  },  // INVISIBLE PLUS
  { 0x2066, BIDI_LRI },  // LEFT-TO-RIGHT ISOLATE
  { 0x2067, BIDI_RLI },  // RIGHT-TO-LEFT ISOLATE
  { 0x2068, BIDI_FSI },  // FIRST STRONG ISOLATE
  { 0x2069, BIDI_PDI },  // POP DIRECTIONAL ISOLATE
  { 0x206A, BIDI_BN  },  // INHIBIT SYMMETRIC SWAPPING
  { 0x206B, BIDI_BN  },  // ACTIVATE SYMMETRIC SWAPPING
  { 0x206C, BIDI_BN  },  // INHIBIT ARABIC FORM SHAPING
  { 0x206D, BIDI_BN  },  // ACTIVATE ARABIC FORM SHAPING
  { 0x206E, BIDI_BN  },  // NATIONAL DIGIT SHAPES
  { 0x206F, BIDI_BN  },  // NOMINAL DIGIT SHAPES
  { 0x2070, BIDI_EN  },  // SUPERSCRIPT ZERO
  { 0x2071, BIDI_L   },  // SUPERSCRIPT LATIN SMALL LETTER I
  { 0x2074, BIDI_EN  },  // SUPERSCRIPT FOUR
  { 0x2075, BIDI_EN  },  // SUPERSCRIPT FIVE
  { 0x2076, BIDI_EN  },  // SUPERSCRIPT SIX
  { 0x2077, BIDI_EN  },  // SUPERSCRIPT SEVEN
  { 0x2078, BIDI_EN  },  // SUPERSCRIPT EIGHT
  { 0x2079, BIDI_EN  },  // SUPERSCRIPT NINE
  { 0x207A, BIDI_ES  },  // SUPERSCRIPT PLUS SIGN
  { 0x207B, BIDI_ES  },  // SUPERSCRIPT MINUS
  { 0x207C, BIDI_ON  },  // SUPERSCRIPT EQUALS SIGN
  { 0x207D, BIDI_ON  },  // SUPERSCRIPT LEFT PARENTHESIS
  { 0x207E, BIDI_ON  },  // SUPERSCRIPT RIGHT PARENTHESIS
  { 0x207F, BIDI_L   },  // SUPERSCRIPT LATIN SMALL LETTER N
  { 0x2080, BIDI_EN  },  // SUBSCRIPT ZERO
  { 0x2081, BIDI_EN  },  // SUBSCRIPT ONE
  { 0x2082, BIDI_EN  },  // SUBSCRIPT TWO
  { 0x2083, BIDI_EN  },  // SUBSCRIPT THREE
  { 0x2084, BIDI_EN  },  // SUBSCRIPT FOUR
  { 0x2085, BIDI_EN  },  // SUBSCRIPT FIVE
  { 0x2086, BIDI_EN  },  // SUBSCRIPT SIX
  { 0x2087, BIDI_EN  },  // SUBSCRIPT SEVEN
  { 0x2088, BIDI_EN  },  // SUBSCRIPT EIGHT
  { 0x2089, BIDI_EN  },  // SUBSCRIPT NINE
  { 0x208A, BIDI_ES  },  // SUBSCRIPT PLUS SIGN
  { 0x208B, BIDI_ES  },  // SUBSCRIPT MINUS
  { 0x208C, BIDI_ON  },  // SUBSCRIPT EQUALS SIGN
  { 0x208D, BIDI_ON  },  // SUBSCRIPT LEFT PARENTHESIS
  { 0x208E, BIDI_ON  },  // SUBSCRIPT RIGHT PARENTHESIS
  { 0x2090, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER A
  { 0x2091, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER E
  { 0x2092, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER O
  { 0x2093, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER X
  { 0x2094, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER SCHWA
  { 0x2095, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER H
  { 0x2096, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER K
  { 0x2097, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER L
  { 0x2098, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER M
  { 0x2099, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER N
  { 0x209A, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER P
  { 0x209B, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER S
  { 0x209C, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER T
  { 0x20A0, BIDI_ET  },  // EURO-CURRENCY SIGN
  { 0x20A1, BIDI_ET  },  // COLON SIGN
  { 0x20A2, BIDI_ET  },  // CRUZEIRO SIGN
  { 0x20A3, BIDI_ET  },  // FRENCH FRANC SIGN
  { 0x20A4, BIDI_ET  },  // LIRA SIGN
  { 0x20A5, BIDI_ET  },  // MILL SIGN
  { 0x20A6, BIDI_ET  },  // NAIRA SIGN
  { 0x20A7, BIDI_ET  },  // PESETA SIGN
  { 0x20A8, BIDI_ET  },  // RUPEE SIGN
  { 0x20A9, BIDI_ET  },  // WON SIGN
  { 0x20AA, BIDI_ET  },  // NEW SHEQEL SIGN
  { 0x20AB, BIDI_ET  },  // DONG SIGN
  { 0x20AC, BIDI_ET  },  // EURO SIGN
  { 0x20AD, BIDI_ET  },  // KIP SIGN
  { 0x20AE, BIDI_ET  },  // TUGRIK SIGN
  { 0x20AF, BIDI_ET  },  // DRACHMA SIGN
  { 0x20B0, BIDI_ET  },  // GERMAN PENNY SIGN
  { 0x20B1, BIDI_ET  },  // PESO SIGN
  { 0x20B2, BIDI_ET  },  // GUARANI SIGN
  { 0x20B3, BIDI_ET  },  // AUSTRAL SIGN
  { 0x20B4, BIDI_ET  },  // HRYVNIA SIGN
  { 0x20B5, BIDI_ET  },  // CEDI SIGN
  { 0x20B6, BIDI_ET  },  // LIVRE TOURNOIS SIGN
  { 0x20B7, BIDI_ET  },  // SPESMILO SIGN
  { 0x20B8, BIDI_ET  },  // TENGE SIGN
  { 0x20B9, BIDI_ET  },  // INDIAN RUPEE SIGN
  { 0x20BA, BIDI_ET  },  // TURKISH LIRA SIGN
  { 0x20BB, BIDI_ET  },  // NORDIC MARK SIGN
  { 0x20BC, BIDI_ET  },  // MANAT SIGN
  { 0x20BD, BIDI_ET  },  // RUBLE SIGN
  { 0x20BE, BIDI_ET  },  // LARI SIGN
  { 0x20D0, BIDI_NSM },  // COMBINING LEFT HARPOON ABOVE
  { 0x20D1, BIDI_NSM },  // COMBINING RIGHT HARPOON ABOVE
  { 0x20D2, BIDI_NSM },  // COMBINING LONG VERTICAL LINE OVERLAY
  { 0x20D3, BIDI_NSM },  // COMBINING SHORT VERTICAL LINE OVERLAY
  { 0x20D4, BIDI_NSM },  // COMBINING ANTICLOCKWISE ARROW ABOVE
  { 0x20D5, BIDI_NSM },  // COMBINING CLOCKWISE ARROW ABOVE
  { 0x20D6, BIDI_NSM },  // COMBINING LEFT ARROW ABOVE
  { 0x20D7, BIDI_NSM },  // COMBINING RIGHT ARROW ABOVE
  { 0x20D8, BIDI_NSM },  // COMBINING RING OVERLAY
  { 0x20D9, BIDI_NSM },  // COMBINING CLOCKWISE RING OVERLAY
  { 0x20DA, BIDI_NSM },  // COMBINING ANTICLOCKWISE RING OVERLAY
  { 0x20DB, BIDI_NSM },  // COMBINING THREE DOTS ABOVE
  { 0x20DC, BIDI_NSM },  // COMBINING FOUR DOTS ABOVE
  { 0x20DD, BIDI_NSM },  // COMBINING ENCLOSING CIRCLE
  { 0x20DE, BIDI_NSM },  // COMBINING ENCLOSING SQUARE
  { 0x20DF, BIDI_NSM },  // COMBINING ENCLOSING DIAMOND
  { 0x20E0, BIDI_NSM },  // COMBINING ENCLOSING CIRCLE BACKSLASH
  { 0x20E1, BIDI_NSM },  // COMBINING LEFT RIGHT ARROW ABOVE
  { 0x20E2, BIDI_NSM },  // COMBINING ENCLOSING SCREEN
  { 0x20E3, BIDI_NSM },  // COMBINING ENCLOSING KEYCAP
  { 0x20E4, BIDI_NSM },  // COMBINING ENCLOSING UPWARD POINTING TRIANGLE
  { 0x20E5, BIDI_NSM },  // COMBINING REVERSE SOLIDUS OVERLAY
  { 0x20E6, BIDI_NSM },  // COMBINING DOUBLE VERTICAL STROKE OVERLAY
  { 0x20E7, BIDI_NSM },  // COMBINING ANNUITY SYMBOL
  { 0x20E8, BIDI_NSM },  // COMBINING TRIPLE UNDERDOT
  { 0x20E9, BIDI_NSM },  // COMBINING WIDE BRIDGE ABOVE
  { 0x20EA, BIDI_NSM },  // COMBINING LEFTWARDS ARROW OVERLAY
  { 0x20EB, BIDI_NSM },  // COMBINING LONG DOUBLE SOLIDUS OVERLAY
  { 0x20EC, BIDI_NSM },  // COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS
  { 0x20ED, BIDI_NSM },  // COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS
  { 0x20EE, BIDI_NSM },  // COMBINING LEFT ARROW BELOW
  { 0x20EF, BIDI_NSM },  // COMBINING RIGHT ARROW BELOW
  { 0x20F0, BIDI_NSM },  // COMBINING ASTERISK ABOVE
  { 0x2100, BIDI_ON  },  // ACCOUNT OF
  { 0x2101, BIDI_ON  },  // ADDRESSED TO THE SUBJECT
  { 0x2102, BIDI_L   },  // DOUBLE-STRUCK CAPITAL C
  { 0x2103, BIDI_ON  },  // DEGREE CELSIUS
  { 0x2104, BIDI_ON  },  // CENTRE LINE SYMBOL
  { 0x2105, BIDI_ON  },  // CARE OF
  { 0x2106, BIDI_ON  },  // CADA UNA
  { 0x2107, BIDI_L   },  // EULER CONSTANT
  { 0x2108, BIDI_ON  },  // SCRUPLE
  { 0x2109, BIDI_ON  },  // DEGREE FAHRENHEIT
  { 0x210A, BIDI_L   },  // SCRIPT SMALL G
  { 0x210B, BIDI_L   },  // SCRIPT CAPITAL H
  { 0x210C, BIDI_L   },  // BLACK-LETTER CAPITAL H
  { 0x210D, BIDI_L   },  // DOUBLE-STRUCK CAPITAL H
  { 0x210E, BIDI_L   },  // PLANCK CONSTANT
  { 0x210F, BIDI_L   },  // PLANCK CONSTANT OVER TWO PI
  { 0x2110, BIDI_L   },  // SCRIPT CAPITAL I
  { 0x2111, BIDI_L   },  // BLACK-LETTER CAPITAL I
  { 0x2112, BIDI_L   },  // SCRIPT CAPITAL L
  { 0x2113, BIDI_L   },  // SCRIPT SMALL L
  { 0x2114, BIDI_ON  },  // L B BAR SYMBOL
  { 0x2115, BIDI_L   },  // DOUBLE-STRUCK CAPITAL N
  { 0x2116, BIDI_ON  },  // NUMERO SIGN
  { 0x2117, BIDI_ON  },  // SOUND RECORDING COPYRIGHT
  { 0x2118, BIDI_ON  },  // SCRIPT CAPITAL P
  { 0x2119, BIDI_L   },  // DOUBLE-STRUCK CAPITAL P
  { 0x211A, BIDI_L   },  // DOUBLE-STRUCK CAPITAL Q
  { 0x211B, BIDI_L   },  // SCRIPT CAPITAL R
  { 0x211C, BIDI_L   },  // BLACK-LETTER CAPITAL R
  { 0x211D, BIDI_L   },  // DOUBLE-STRUCK CAPITAL R
  { 0x211E, BIDI_ON  },  // PRESCRIPTION TAKE
  { 0x211F, BIDI_ON  },  // RESPONSE
  { 0x2120, BIDI_ON  },  // SERVICE MARK
  { 0x2121, BIDI_ON  },  // TELEPHONE SIGN
  { 0x2122, BIDI_ON  },  // TRADE MARK SIGN
  { 0x2123, BIDI_ON  },  // VERSICLE
  { 0x2124, BIDI_L   },  // DOUBLE-STRUCK CAPITAL Z
  { 0x2125, BIDI_ON  },  // OUNCE SIGN
  { 0x2126, BIDI_L   },  // OHM SIGN
  { 0x2127, BIDI_ON  },  // INVERTED OHM SIGN
  { 0x2128, BIDI_L   },  // BLACK-LETTER CAPITAL Z
  { 0x2129, BIDI_ON  },  // TURNED GREEK SMALL LETTER IOTA
  { 0x212A, BIDI_L   },  // KELVIN SIGN
  { 0x212B, BIDI_L   },  // ANGSTROM SIGN
  { 0x212C, BIDI_L   },  // SCRIPT CAPITAL B
  { 0x212D, BIDI_L   },  // BLACK-LETTER CAPITAL C
  { 0x212E, BIDI_ET  },  // ESTIMATED SYMBOL
  { 0x212F, BIDI_L   },  // SCRIPT SMALL E
  { 0x2130, BIDI_L   },  // SCRIPT CAPITAL E
  { 0x2131, BIDI_L   },  // SCRIPT CAPITAL F
  { 0x2132, BIDI_L   },  // TURNED CAPITAL F
  { 0x2133, BIDI_L   },  // SCRIPT CAPITAL M
  { 0x2134, BIDI_L   },  // SCRIPT SMALL O
  { 0x2135, BIDI_L   },  // ALEF SYMBOL
  { 0x2136, BIDI_L   },  // BET SYMBOL
  { 0x2137, BIDI_L   },  // GIMEL SYMBOL
  { 0x2138, BIDI_L   },  // DALET SYMBOL
  { 0x2139, BIDI_L   },  // INFORMATION SOURCE
  { 0x213A, BIDI_ON  },  // ROTATED CAPITAL Q
  { 0x213B, BIDI_ON  },  // FACSIMILE SIGN
  { 0x213C, BIDI_L   },  // DOUBLE-STRUCK SMALL PI
  { 0x213D, BIDI_L   },  // DOUBLE-STRUCK SMALL GAMMA
  { 0x213E, BIDI_L   },  // DOUBLE-STRUCK CAPITAL GAMMA
  { 0x213F, BIDI_L   },  // DOUBLE-STRUCK CAPITAL PI
  { 0x2140, BIDI_ON  },  // DOUBLE-STRUCK N-ARY SUMMATION
  { 0x2141, BIDI_ON  },  // TURNED SANS-SERIF CAPITAL G
  { 0x2142, BIDI_ON  },  // TURNED SANS-SERIF CAPITAL L
  { 0x2143, BIDI_ON  },  // REVERSED SANS-SERIF CAPITAL L
  { 0x2144, BIDI_ON  },  // TURNED SANS-SERIF CAPITAL Y
  { 0x2145, BIDI_L   },  // DOUBLE-STRUCK ITALIC CAPITAL D
  { 0x2146, BIDI_L   },  // DOUBLE-STRUCK ITALIC SMALL D
  { 0x2147, BIDI_L   },  // DOUBLE-STRUCK ITALIC SMALL E
  { 0x2148, BIDI_L   },  // DOUBLE-STRUCK ITALIC SMALL I
  { 0x2149, BIDI_L   },  // DOUBLE-STRUCK ITALIC SMALL J
  { 0x214A, BIDI_ON  },  // PROPERTY LINE
  { 0x214B, BIDI_ON  },  // TURNED AMPERSAND
  { 0x214C, BIDI_ON  },  // PER SIGN
  { 0x214D, BIDI_ON  },  // AKTIESELSKAB
  { 0x214E, BIDI_L   },  // TURNED SMALL F
  { 0x214F, BIDI_L   },  // SYMBOL FOR SAMARITAN SOURCE
  { 0x2150, BIDI_ON  },  // VULGAR FRACTION ONE SEVENTH
  { 0x2151, BIDI_ON  },  // VULGAR FRACTION ONE NINTH
  { 0x2152, BIDI_ON  },  // VULGAR FRACTION ONE TENTH
  { 0x2153, BIDI_ON  },  // VULGAR FRACTION ONE THIRD
  { 0x2154, BIDI_ON  },  // VULGAR FRACTION TWO THIRDS
  { 0x2155, BIDI_ON  },  // VULGAR FRACTION ONE FIFTH
  { 0x2156, BIDI_ON  },  // VULGAR FRACTION TWO FIFTHS
  { 0x2157, BIDI_ON  },  // VULGAR FRACTION THREE FIFTHS
  { 0x2158, BIDI_ON  },  // VULGAR FRACTION FOUR FIFTHS
  { 0x2159, BIDI_ON  },  // VULGAR FRACTION ONE SIXTH
  { 0x215A, BIDI_ON  },  // VULGAR FRACTION FIVE SIXTHS
  { 0x215B, BIDI_ON  },  // VULGAR FRACTION ONE EIGHTH
  { 0x215C, BIDI_ON  },  // VULGAR FRACTION THREE EIGHTHS
  { 0x215D, BIDI_ON  },  // VULGAR FRACTION FIVE EIGHTHS
  { 0x215E, BIDI_ON  },  // VULGAR FRACTION SEVEN EIGHTHS
  { 0x215F, BIDI_ON  },  // FRACTION NUMERATOR ONE
  { 0x2160, BIDI_L   },  // ROMAN NUMERAL ONE
  { 0x2161, BIDI_L   },  // ROMAN NUMERAL TWO
  { 0x2162, BIDI_L   },  // ROMAN NUMERAL THREE
  { 0x2163, BIDI_L   },  // ROMAN NUMERAL FOUR
  { 0x2164, BIDI_L   },  // ROMAN NUMERAL FIVE
  { 0x2165, BIDI_L   },  // ROMAN NUMERAL SIX
  { 0x2166, BIDI_L   },  // ROMAN NUMERAL SEVEN
  { 0x2167, BIDI_L   },  // ROMAN NUMERAL EIGHT
  { 0x2168, BIDI_L   },  // ROMAN NUMERAL NINE
  { 0x2169, BIDI_L   },  // ROMAN NUMERAL TEN
  { 0x216A, BIDI_L   },  // ROMAN NUMERAL ELEVEN
  { 0x216B, BIDI_L   },  // ROMAN NUMERAL TWELVE
  { 0x216C, BIDI_L   },  // ROMAN NUMERAL FIFTY
  { 0x216D, BIDI_L   },  // ROMAN NUMERAL ONE HUNDRED
  { 0x216E, BIDI_L   },  // ROMAN NUMERAL FIVE HUNDRED
  { 0x216F, BIDI_L   },  // ROMAN NUMERAL ONE THOUSAND
  { 0x2170, BIDI_L   },  // SMALL ROMAN NUMERAL ONE
  { 0x2171, BIDI_L   },  // SMALL ROMAN NUMERAL TWO
  { 0x2172, BIDI_L   },  // SMALL ROMAN NUMERAL THREE
  { 0x2173, BIDI_L   },  // SMALL ROMAN NUMERAL FOUR
  { 0x2174, BIDI_L   },  // SMALL ROMAN NUMERAL FIVE
  { 0x2175, BIDI_L   },  // SMALL ROMAN NUMERAL SIX
  { 0x2176, BIDI_L   },  // SMALL ROMAN NUMERAL SEVEN
  { 0x2177, BIDI_L   },  // SMALL ROMAN NUMERAL EIGHT
  { 0x2178, BIDI_L   },  // SMALL ROMAN NUMERAL NINE
  { 0x2179, BIDI_L   },  // SMALL ROMAN NUMERAL TEN
  { 0x217A, BIDI_L   },  // SMALL ROMAN NUMERAL ELEVEN
  { 0x217B, BIDI_L   },  // SMALL ROMAN NUMERAL TWELVE
  { 0x217C, BIDI_L   },  // SMALL ROMAN NUMERAL FIFTY
  { 0x217D, BIDI_L   },  // SMALL ROMAN NUMERAL ONE HUNDRED
  { 0x217E, BIDI_L   },  // SMALL ROMAN NUMERAL FIVE HUNDRED
  { 0x217F, BIDI_L   },  // SMALL ROMAN NUMERAL ONE THOUSAND
  { 0x2180, BIDI_L   },  // ROMAN NUMERAL ONE THOUSAND C D
  { 0x2181, BIDI_L   },  // ROMAN NUMERAL FIVE THOUSAND
  { 0x2182, BIDI_L   },  // ROMAN NUMERAL TEN THOUSAND
  { 0x2183, BIDI_L   },  // ROMAN NUMERAL REVERSED ONE HUNDRED
  { 0x2184, BIDI_L   },  // LATIN SMALL LETTER REVERSED C
  { 0x2185, BIDI_L   },  // ROMAN NUMERAL SIX LATE FORM
  { 0x2186, BIDI_L   },  // ROMAN NUMERAL FIFTY EARLY FORM
  { 0x2187, BIDI_L   },  // ROMAN NUMERAL FIFTY THOUSAND
  { 0x2188, BIDI_L   },  // ROMAN NUMERAL ONE HUNDRED THOUSAND
  { 0x2189, BIDI_ON  },  // VULGAR FRACTION ZERO THIRDS
  { 0x218A, BIDI_ON  },  // TURNED DIGIT TWO
  { 0x218B, BIDI_ON  },  // TURNED DIGIT THREE
  { 0x2190, BIDI_ON  },  // LEFTWARDS ARROW
  { 0x2191, BIDI_ON  },  // UPWARDS ARROW
  { 0x2192, BIDI_ON  },  // RIGHTWARDS ARROW
  { 0x2193, BIDI_ON  },  // DOWNWARDS ARROW
  { 0x2194, BIDI_ON  },  // LEFT RIGHT ARROW
  { 0x2195, BIDI_ON  },  // UP DOWN ARROW
  { 0x2196, BIDI_ON  },  // NORTH WEST ARROW
  { 0x2197, BIDI_ON  },  // NORTH EAST ARROW
  { 0x2198, BIDI_ON  },  // SOUTH EAST ARROW
  { 0x2199, BIDI_ON  },  // SOUTH WEST ARROW
  { 0x219A, BIDI_ON  },  // LEFTWARDS ARROW WITH STROKE
  { 0x219B, BIDI_ON  },  // RIGHTWARDS ARROW WITH STROKE
  { 0x219C, BIDI_ON  },  // LEFTWARDS WAVE ARROW
  { 0x219D, BIDI_ON  },  // RIGHTWARDS WAVE ARROW
  { 0x219E, BIDI_ON  },  // LEFTWARDS TWO HEADED ARROW
  { 0x219F, BIDI_ON  },  // UPWARDS TWO HEADED ARROW
  { 0x21A0, BIDI_ON  },  // RIGHTWARDS TWO HEADED ARROW
  { 0x21A1, BIDI_ON  },  // DOWNWARDS TWO HEADED ARROW
  { 0x21A2, BIDI_ON  },  // LEFTWARDS ARROW WITH TAIL
  { 0x21A3, BIDI_ON  },  // RIGHTWARDS ARROW WITH TAIL
  { 0x21A4, BIDI_ON  },  // LEFTWARDS ARROW FROM BAR
  { 0x21A5, BIDI_ON  },  // UPWARDS ARROW FROM BAR
  { 0x21A6, BIDI_ON  },  // RIGHTWARDS ARROW FROM BAR
  { 0x21A7, BIDI_ON  },  // DOWNWARDS ARROW FROM BAR
  { 0x21A8, BIDI_ON  },  // UP DOWN ARROW WITH BASE
  { 0x21A9, BIDI_ON  },  // LEFTWARDS ARROW WITH HOOK
  { 0x21AA, BIDI_ON  },  // RIGHTWARDS ARROW WITH HOOK
  { 0x21AB, BIDI_ON  },  // LEFTWARDS ARROW WITH LOOP
  { 0x21AC, BIDI_ON  },  // RIGHTWARDS ARROW WITH LOOP
  { 0x21AD, BIDI_ON  },  // LEFT RIGHT WAVE ARROW
  { 0x21AE, BIDI_ON  },  // LEFT RIGHT ARROW WITH STROKE
  { 0x21AF, BIDI_ON  },  // DOWNWARDS ZIGZAG ARROW
  { 0x21B0, BIDI_ON  },  // UPWARDS ARROW WITH TIP LEFTWARDS
  { 0x21B1, BIDI_ON  },  // UPWARDS ARROW WITH TIP RIGHTWARDS
  { 0x21B2, BIDI_ON  },  // DOWNWARDS ARROW WITH TIP LEFTWARDS
  { 0x21B3, BIDI_ON  },  // DOWNWARDS ARROW WITH TIP RIGHTWARDS
  { 0x21B4, BIDI_ON  },  // RIGHTWARDS ARROW WITH CORNER DOWNWARDS
  { 0x21B5, BIDI_ON  },  // DOWNWARDS ARROW WITH CORNER LEFTWARDS
  { 0x21B6, BIDI_ON  },  // ANTICLOCKWISE TOP SEMICIRCLE ARROW
  { 0x21B7, BIDI_ON  },  // CLOCKWISE TOP SEMICIRCLE ARROW
  { 0x21B8, BIDI_ON  },  // NORTH WEST ARROW TO LONG BAR
  { 0x21B9, BIDI_ON  },  // LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR
  { 0x21BA, BIDI_ON  },  // ANTICLOCKWISE OPEN CIRCLE ARROW
  { 0x21BB, BIDI_ON  },  // CLOCKWISE OPEN CIRCLE ARROW
  { 0x21BC, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB UPWARDS
  { 0x21BD, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB DOWNWARDS
  { 0x21BE, BIDI_ON  },  // UPWARDS HARPOON WITH BARB RIGHTWARDS
  { 0x21BF, BIDI_ON  },  // UPWARDS HARPOON WITH BARB LEFTWARDS
  { 0x21C0, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB UPWARDS
  { 0x21C1, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB DOWNWARDS
  { 0x21C2, BIDI_ON  },  // DOWNWARDS HARPOON WITH BARB RIGHTWARDS
  { 0x21C3, BIDI_ON  },  // DOWNWARDS HARPOON WITH BARB LEFTWARDS
  { 0x21C4, BIDI_ON  },  // RIGHTWARDS ARROW OVER LEFTWARDS ARROW
  { 0x21C5, BIDI_ON  },  // UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW
  { 0x21C6, BIDI_ON  },  // LEFTWARDS ARROW OVER RIGHTWARDS ARROW
  { 0x21C7, BIDI_ON  },  // LEFTWARDS PAIRED ARROWS
  { 0x21C8, BIDI_ON  },  // UPWARDS PAIRED ARROWS
  { 0x21C9, BIDI_ON  },  // RIGHTWARDS PAIRED ARROWS
  { 0x21CA, BIDI_ON  },  // DOWNWARDS PAIRED ARROWS
  { 0x21CB, BIDI_ON  },  // LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON
  { 0x21CC, BIDI_ON  },  // RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
  { 0x21CD, BIDI_ON  },  // LEFTWARDS DOUBLE ARROW WITH STROKE
  { 0x21CE, BIDI_ON  },  // LEFT RIGHT DOUBLE ARROW WITH STROKE
  { 0x21CF, BIDI_ON  },  // RIGHTWARDS DOUBLE ARROW WITH STROKE
  { 0x21D0, BIDI_ON  },  // LEFTWARDS DOUBLE ARROW
  { 0x21D1, BIDI_ON  },  // UPWARDS DOUBLE ARROW
  { 0x21D2, BIDI_ON  },  // RIGHTWARDS DOUBLE ARROW
  { 0x21D3, BIDI_ON  },  // DOWNWARDS DOUBLE ARROW
  { 0x21D4, BIDI_ON  },  // LEFT RIGHT DOUBLE ARROW
  { 0x21D5, BIDI_ON  },  // UP DOWN DOUBLE ARROW
  { 0x21D6, BIDI_ON  },  // NORTH WEST DOUBLE ARROW
  { 0x21D7, BIDI_ON  },  // NORTH EAST DOUBLE ARROW
  { 0x21D8, BIDI_ON  },  // SOUTH EAST DOUBLE ARROW
  { 0x21D9, BIDI_ON  },  // SOUTH WEST DOUBLE ARROW
  { 0x21DA, BIDI_ON  },  // LEFTWARDS TRIPLE ARROW
  { 0x21DB, BIDI_ON  },  // RIGHTWARDS TRIPLE ARROW
  { 0x21DC, BIDI_ON  },  // LEFTWARDS SQUIGGLE ARROW
  { 0x21DD, BIDI_ON  },  // RIGHTWARDS SQUIGGLE ARROW
  { 0x21DE, BIDI_ON  },  // UPWARDS ARROW WITH DOUBLE STROKE
  { 0x21DF, BIDI_ON  },  // DOWNWARDS ARROW WITH DOUBLE STROKE
  { 0x21E0, BIDI_ON  },  // LEFTWARDS DASHED ARROW
  { 0x21E1, BIDI_ON  },  // UPWARDS DASHED ARROW
  { 0x21E2, BIDI_ON  },  // RIGHTWARDS DASHED ARROW
  { 0x21E3, BIDI_ON  },  // DOWNWARDS DASHED ARROW
  { 0x21E4, BIDI_ON  },  // LEFTWARDS ARROW TO BAR
  { 0x21E5, BIDI_ON  },  // RIGHTWARDS ARROW TO BAR
  { 0x21E6, BIDI_ON  },  // LEFTWARDS WHITE ARROW
  { 0x21E7, BIDI_ON  },  // UPWARDS WHITE ARROW
  { 0x21E8, BIDI_ON  },  // RIGHTWARDS WHITE ARROW
  { 0x21E9, BIDI_ON  },  // DOWNWARDS WHITE ARROW
  { 0x21EA, BIDI_ON  },  // UPWARDS WHITE ARROW FROM BAR
  { 0x21EB, BIDI_ON  },  // UPWARDS WHITE ARROW ON PEDESTAL
  { 0x21EC, BIDI_ON  },  // UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR
  { 0x21ED, BIDI_ON  },  // UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR
  { 0x21EE, BIDI_ON  },  // UPWARDS WHITE DOUBLE ARROW
  { 0x21EF, BIDI_ON  },  // UPWARDS WHITE DOUBLE ARROW ON PEDESTAL
  { 0x21F0, BIDI_ON  },  // RIGHTWARDS WHITE ARROW FROM WALL
  { 0x21F1, BIDI_ON  },  // NORTH WEST ARROW TO CORNER
  { 0x21F2, BIDI_ON  },  // SOUTH EAST ARROW TO CORNER
  { 0x21F3, BIDI_ON  },  // UP DOWN WHITE ARROW
  { 0x21F4, BIDI_ON  },  // RIGHT ARROW WITH SMALL CIRCLE
  { 0x21F5, BIDI_ON  },  // DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW
  { 0x21F6, BIDI_ON  },  // THREE RIGHTWARDS ARROWS
  { 0x21F7, BIDI_ON  },  // LEFTWARDS ARROW WITH VERTICAL STROKE
  { 0x21F8, BIDI_ON  },  // RIGHTWARDS ARROW WITH VERTICAL STROKE
  { 0x21F9, BIDI_ON  },  // LEFT RIGHT ARROW WITH VERTICAL STROKE
  { 0x21FA, BIDI_ON  },  // LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE
  { 0x21FB, BIDI_ON  },  // RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE
  { 0x21FC, BIDI_ON  },  // LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE
  { 0x21FD, BIDI_ON  },  // LEFTWARDS OPEN-HEADED ARROW
  { 0x21FE, BIDI_ON  },  // RIGHTWARDS OPEN-HEADED ARROW
  { 0x21FF, BIDI_ON  },  // LEFT RIGHT OPEN-HEADED ARROW
  { 0x2200, BIDI_ON  },  // FOR ALL
  { 0x2201, BIDI_ON  },  // COMPLEMENT
  { 0x2202, BIDI_ON  },  // PARTIAL DIFFERENTIAL
  { 0x2203, BIDI_ON  },  // THERE EXISTS
  { 0x2204, BIDI_ON  },  // THERE DOES NOT EXIST
  { 0x2205, BIDI_ON  },  // EMPTY SET
  { 0x2206, BIDI_ON  },  // INCREMENT
  { 0x2207, BIDI_ON  },  // NABLA
  { 0x2208, BIDI_ON  },  // ELEMENT OF
  { 0x2209, BIDI_ON  },  // NOT AN ELEMENT OF
  { 0x220A, BIDI_ON  },  // SMALL ELEMENT OF
  { 0x220B, BIDI_ON  },  // CONTAINS AS MEMBER
  { 0x220C, BIDI_ON  },  // DOES NOT CONTAIN AS MEMBER
  { 0x220D, BIDI_ON  },  // SMALL CONTAINS AS MEMBER
  { 0x220E, BIDI_ON  },  // END OF PROOF
  { 0x220F, BIDI_ON  },  // N-ARY PRODUCT
  { 0x2210, BIDI_ON  },  // N-ARY COPRODUCT
  { 0x2211, BIDI_ON  },  // N-ARY SUMMATION
  { 0x2212, BIDI_ES  },  // MINUS SIGN
  { 0x2213, BIDI_ET  },  // MINUS-OR-PLUS SIGN
  { 0x2214, BIDI_ON  },  // DOT PLUS
  { 0x2215, BIDI_ON  },  // DIVISION SLASH
  { 0x2216, BIDI_ON  },  // SET MINUS
  { 0x2217, BIDI_ON  },  // ASTERISK OPERATOR
  { 0x2218, BIDI_ON  },  // RING OPERATOR
  { 0x2219, BIDI_ON  },  // BULLET OPERATOR
  { 0x221A, BIDI_ON  },  // SQUARE ROOT
  { 0x221B, BIDI_ON  },  // CUBE ROOT
  { 0x221C, BIDI_ON  },  // FOURTH ROOT
  { 0x221D, BIDI_ON  },  // PROPORTIONAL TO
  { 0x221E, BIDI_ON  },  // INFINITY
  { 0x221F, BIDI_ON  },  // RIGHT ANGLE
  { 0x2220, BIDI_ON  },  // ANGLE
  { 0x2221, BIDI_ON  },  // MEASURED ANGLE
  { 0x2222, BIDI_ON  },  // SPHERICAL ANGLE
  { 0x2223, BIDI_ON  },  // DIVIDES
  { 0x2224, BIDI_ON  },  // DOES NOT DIVIDE
  { 0x2225, BIDI_ON  },  // PARALLEL TO
  { 0x2226, BIDI_ON  },  // NOT PARALLEL TO
  { 0x2227, BIDI_ON  },  // LOGICAL AND
  { 0x2228, BIDI_ON  },  // LOGICAL OR
  { 0x2229, BIDI_ON  },  // INTERSECTION
  { 0x222A, BIDI_ON  },  // UNION
  { 0x222B, BIDI_ON  },  // INTEGRAL
  { 0x222C, BIDI_ON  },  // DOUBLE INTEGRAL
  { 0x222D, BIDI_ON  },  // TRIPLE INTEGRAL
  { 0x222E, BIDI_ON  },  // CONTOUR INTEGRAL
  { 0x222F, BIDI_ON  },  // SURFACE INTEGRAL
  { 0x2230, BIDI_ON  },  // VOLUME INTEGRAL
  { 0x2231, BIDI_ON  },  // CLOCKWISE INTEGRAL
  { 0x2232, BIDI_ON  },  // CLOCKWISE CONTOUR INTEGRAL
  { 0x2233, BIDI_ON  },  // ANTICLOCKWISE CONTOUR INTEGRAL
  { 0x2234, BIDI_ON  },  // THEREFORE
  { 0x2235, BIDI_ON  },  // BECAUSE
  { 0x2236, BIDI_ON  },  // RATIO
  { 0x2237, BIDI_ON  },  // PROPORTION
  { 0x2238, BIDI_ON  },  // DOT MINUS
  { 0x2239, BIDI_ON  },  // EXCESS
  { 0x223A, BIDI_ON  },  // GEOMETRIC PROPORTION
  { 0x223B, BIDI_ON  },  // HOMOTHETIC
  { 0x223C, BIDI_ON  },  // TILDE OPERATOR
  { 0x223D, BIDI_ON  },  // REVERSED TILDE
  { 0x223E, BIDI_ON  },  // INVERTED LAZY S
  { 0x223F, BIDI_ON  },  // SINE WAVE
  { 0x2240, BIDI_ON  },  // WREATH PRODUCT
  { 0x2241, BIDI_ON  },  // NOT TILDE
  { 0x2242, BIDI_ON  },  // MINUS TILDE
  { 0x2243, BIDI_ON  },  // ASYMPTOTICALLY EQUAL TO
  { 0x2244, BIDI_ON  },  // NOT ASYMPTOTICALLY EQUAL TO
  { 0x2245, BIDI_ON  },  // APPROXIMATELY EQUAL TO
  { 0x2246, BIDI_ON  },  // APPROXIMATELY BUT NOT ACTUALLY EQUAL TO
  { 0x2247, BIDI_ON  },  // NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
  { 0x2248, BIDI_ON  },  // ALMOST EQUAL TO
  { 0x2249, BIDI_ON  },  // NOT ALMOST EQUAL TO
  { 0x224A, BIDI_ON  },  // ALMOST EQUAL OR EQUAL TO
  { 0x224B, BIDI_ON  },  // TRIPLE TILDE
  { 0x224C, BIDI_ON  },  // ALL EQUAL TO
  { 0x224D, BIDI_ON  },  // EQUIVALENT TO
  { 0x224E, BIDI_ON  },  // GEOMETRICALLY EQUIVALENT TO
  { 0x224F, BIDI_ON  },  // DIFFERENCE BETWEEN
  { 0x2250, BIDI_ON  },  // APPROACHES THE LIMIT
  { 0x2251, BIDI_ON  },  // GEOMETRICALLY EQUAL TO
  { 0x2252, BIDI_ON  },  // APPROXIMATELY EQUAL TO OR THE IMAGE OF
  { 0x2253, BIDI_ON  },  // IMAGE OF OR APPROXIMATELY EQUAL TO
  { 0x2254, BIDI_ON  },  // COLON EQUALS
  { 0x2255, BIDI_ON  },  // EQUALS COLON
  { 0x2256, BIDI_ON  },  // RING IN EQUAL TO
  { 0x2257, BIDI_ON  },  // RING EQUAL TO
  { 0x2258, BIDI_ON  },  // CORRESPONDS TO
  { 0x2259, BIDI_ON  },  // ESTIMATES
  { 0x225A, BIDI_ON  },  // EQUIANGULAR TO
  { 0x225B, BIDI_ON  },  // STAR EQUALS
  { 0x225C, BIDI_ON  },  // DELTA EQUAL TO
  { 0x225D, BIDI_ON  },  // EQUAL TO BY DEFINITION
  { 0x225E, BIDI_ON  },  // MEASURED BY
  { 0x225F, BIDI_ON  },  // QUESTIONED EQUAL TO
  { 0x2260, BIDI_ON  },  // NOT EQUAL TO
  { 0x2261, BIDI_ON  },  // IDENTICAL TO
  { 0x2262, BIDI_ON  },  // NOT IDENTICAL TO
  { 0x2263, BIDI_ON  },  // STRICTLY EQUIVALENT TO
  { 0x2264, BIDI_ON  },  // LESS-THAN OR EQUAL TO
  { 0x2265, BIDI_ON  },  // GREATER-THAN OR EQUAL TO
  { 0x2266, BIDI_ON  },  // LESS-THAN OVER EQUAL TO
  { 0x2267, BIDI_ON  },  // GREATER-THAN OVER EQUAL TO
  { 0x2268, BIDI_ON  },  // LESS-THAN BUT NOT EQUAL TO
  { 0x2269, BIDI_ON  },  // GREATER-THAN BUT NOT EQUAL TO
  { 0x226A, BIDI_ON  },  // MUCH LESS-THAN
  { 0x226B, BIDI_ON  },  // MUCH GREATER-THAN
  { 0x226C, BIDI_ON  },  // BETWEEN
  { 0x226D, BIDI_ON  },  // NOT EQUIVALENT TO
  { 0x226E, BIDI_ON  },  // NOT LESS-THAN
  { 0x226F, BIDI_ON  },  // NOT GREATER-THAN
  { 0x2270, BIDI_ON  },  // NEITHER LESS-THAN NOR EQUAL TO
  { 0x2271, BIDI_ON  },  // NEITHER GREATER-THAN NOR EQUAL TO
  { 0x2272, BIDI_ON  },  // LESS-THAN OR EQUIVALENT TO
  { 0x2273, BIDI_ON  },  // GREATER-THAN OR EQUIVALENT TO
  { 0x2274, BIDI_ON  },  // NEITHER LESS-THAN NOR EQUIVALENT TO
  { 0x2275, BIDI_ON  },  // NEITHER GREATER-THAN NOR EQUIVALENT TO
  { 0x2276, BIDI_ON  },  // LESS-THAN OR GREATER-THAN
  { 0x2277, BIDI_ON  },  // GREATER-THAN OR LESS-THAN
  { 0x2278, BIDI_ON  },  // NEITHER LESS-THAN NOR GREATER-THAN
  { 0x2279, BIDI_ON  },  // NEITHER GREATER-THAN NOR LESS-THAN
  { 0x227A, BIDI_ON  },  // PRECEDES
  { 0x227B, BIDI_ON  },  // SUCCEEDS
  { 0x227C, BIDI_ON  },  // PRECEDES OR EQUAL TO
  { 0x227D, BIDI_ON  },  // SUCCEEDS OR EQUAL TO
  { 0x227E, BIDI_ON  },  // PRECEDES OR EQUIVALENT TO
  { 0x227F, BIDI_ON  },  // SUCCEEDS OR EQUIVALENT TO
  { 0x2280, BIDI_ON  },  // DOES NOT PRECEDE
  { 0x2281, BIDI_ON  },  // DOES NOT SUCCEED
  { 0x2282, BIDI_ON  },  // SUBSET OF
  { 0x2283, BIDI_ON  },  // SUPERSET OF
  { 0x2284, BIDI_ON  },  // NOT A SUBSET OF
  { 0x2285, BIDI_ON  },  // NOT A SUPERSET OF
  { 0x2286, BIDI_ON  },  // SUBSET OF OR EQUAL TO
  { 0x2287, BIDI_ON  },  // SUPERSET OF OR EQUAL TO
  { 0x2288, BIDI_ON  },  // NEITHER A SUBSET OF NOR EQUAL TO
  { 0x2289, BIDI_ON  },  // NEITHER A SUPERSET OF NOR EQUAL TO
  { 0x228A, BIDI_ON  },  // SUBSET OF WITH NOT EQUAL TO
  { 0x228B, BIDI_ON  },  // SUPERSET OF WITH NOT EQUAL TO
  { 0x228C, BIDI_ON  },  // MULTISET
  { 0x228D, BIDI_ON  },  // MULTISET MULTIPLICATION
  { 0x228E, BIDI_ON  },  // MULTISET UNION
  { 0x228F, BIDI_ON  },  // SQUARE IMAGE OF
  { 0x2290, BIDI_ON  },  // SQUARE ORIGINAL OF
  { 0x2291, BIDI_ON  },  // SQUARE IMAGE OF OR EQUAL TO
  { 0x2292, BIDI_ON  },  // SQUARE ORIGINAL OF OR EQUAL TO
  { 0x2293, BIDI_ON  },  // SQUARE CAP
  { 0x2294, BIDI_ON  },  // SQUARE CUP
  { 0x2295, BIDI_ON  },  // CIRCLED PLUS
  { 0x2296, BIDI_ON  },  // CIRCLED MINUS
  { 0x2297, BIDI_ON  },  // CIRCLED TIMES
  { 0x2298, BIDI_ON  },  // CIRCLED DIVISION SLASH
  { 0x2299, BIDI_ON  },  // CIRCLED DOT OPERATOR
  { 0x229A, BIDI_ON  },  // CIRCLED RING OPERATOR
  { 0x229B, BIDI_ON  },  // CIRCLED ASTERISK OPERATOR
  { 0x229C, BIDI_ON  },  // CIRCLED EQUALS
  { 0x229D, BIDI_ON  },  // CIRCLED DASH
  { 0x229E, BIDI_ON  },  // SQUARED PLUS
  { 0x229F, BIDI_ON  },  // SQUARED MINUS
  { 0x22A0, BIDI_ON  },  // SQUARED TIMES
  { 0x22A1, BIDI_ON  },  // SQUARED DOT OPERATOR
  { 0x22A2, BIDI_ON  },  // RIGHT TACK
  { 0x22A3, BIDI_ON  },  // LEFT TACK
  { 0x22A4, BIDI_ON  },  // DOWN TACK
  { 0x22A5, BIDI_ON  },  // UP TACK
  { 0x22A6, BIDI_ON  },  // ASSERTION
  { 0x22A7, BIDI_ON  },  // MODELS
  { 0x22A8, BIDI_ON  },  // TRUE
  { 0x22A9, BIDI_ON  },  // FORCES
  { 0x22AA, BIDI_ON  },  // TRIPLE VERTICAL BAR RIGHT TURNSTILE
  { 0x22AB, BIDI_ON  },  // DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
  { 0x22AC, BIDI_ON  },  // DOES NOT PROVE
  { 0x22AD, BIDI_ON  },  // NOT TRUE
  { 0x22AE, BIDI_ON  },  // DOES NOT FORCE
  { 0x22AF, BIDI_ON  },  // NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
  { 0x22B0, BIDI_ON  },  // PRECEDES UNDER RELATION
  { 0x22B1, BIDI_ON  },  // SUCCEEDS UNDER RELATION
  { 0x22B2, BIDI_ON  },  // NORMAL SUBGROUP OF
  { 0x22B3, BIDI_ON  },  // CONTAINS AS NORMAL SUBGROUP
  { 0x22B4, BIDI_ON  },  // NORMAL SUBGROUP OF OR EQUAL TO
  { 0x22B5, BIDI_ON  },  // CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
  { 0x22B6, BIDI_ON  },  // ORIGINAL OF
  { 0x22B7, BIDI_ON  },  // IMAGE OF
  { 0x22B8, BIDI_ON  },  // MULTIMAP
  { 0x22B9, BIDI_ON  },  // HERMITIAN CONJUGATE MATRIX
  { 0x22BA, BIDI_ON  },  // INTERCALATE
  { 0x22BB, BIDI_ON  },  // XOR
  { 0x22BC, BIDI_ON  },  // NAND
  { 0x22BD, BIDI_ON  },  // NOR
  { 0x22BE, BIDI_ON  },  // RIGHT ANGLE WITH ARC
  { 0x22BF, BIDI_ON  },  // RIGHT TRIANGLE
  { 0x22C0, BIDI_ON  },  // N-ARY LOGICAL AND
  { 0x22C1, BIDI_ON  },  // N-ARY LOGICAL OR
  { 0x22C2, BIDI_ON  },  // N-ARY INTERSECTION
  { 0x22C3, BIDI_ON  },  // N-ARY UNION
  { 0x22C4, BIDI_ON  },  // DIAMOND OPERATOR
  { 0x22C5, BIDI_ON  },  // DOT OPERATOR
  { 0x22C6, BIDI_ON  },  // STAR OPERATOR
  { 0x22C7, BIDI_ON  },  // DIVISION TIMES
  { 0x22C8, BIDI_ON  },  // BOWTIE
  { 0x22C9, BIDI_ON  },  // LEFT NORMAL FACTOR SEMIDIRECT PRODUCT
  { 0x22CA, BIDI_ON  },  // RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT
  { 0x22CB, BIDI_ON  },  // LEFT SEMIDIRECT PRODUCT
  { 0x22CC, BIDI_ON  },  // RIGHT SEMIDIRECT PRODUCT
  { 0x22CD, BIDI_ON  },  // REVERSED TILDE EQUALS
  { 0x22CE, BIDI_ON  },  // CURLY LOGICAL OR
  { 0x22CF, BIDI_ON  },  // CURLY LOGICAL AND
  { 0x22D0, BIDI_ON  },  // DOUBLE SUBSET
  { 0x22D1, BIDI_ON  },  // DOUBLE SUPERSET
  { 0x22D2, BIDI_ON  },  // DOUBLE INTERSECTION
  { 0x22D3, BIDI_ON  },  // DOUBLE UNION
  { 0x22D4, BIDI_ON  },  // PITCHFORK
  { 0x22D5, BIDI_ON  },  // EQUAL AND PARALLEL TO
  { 0x22D6, BIDI_ON  },  // LESS-THAN WITH DOT
  { 0x22D7, BIDI_ON  },  // GREATER-THAN WITH DOT
  { 0x22D8, BIDI_ON  },  // VERY MUCH LESS-THAN
  { 0x22D9, BIDI_ON  },  // VERY MUCH GREATER-THAN
  { 0x22DA, BIDI_ON  },  // LESS-THAN EQUAL TO OR GREATER-THAN
  { 0x22DB, BIDI_ON  },  // GREATER-THAN EQUAL TO OR LESS-THAN
  { 0x22DC, BIDI_ON  },  // EQUAL TO OR LESS-THAN
  { 0x22DD, BIDI_ON  },  // EQUAL TO OR GREATER-THAN
  { 0x22DE, BIDI_ON  },  // EQUAL TO OR PRECEDES
  { 0x22DF, BIDI_ON  },  // EQUAL TO OR SUCCEEDS
  { 0x22E0, BIDI_ON  },  // DOES NOT PRECEDE OR EQUAL
  { 0x22E1, BIDI_ON  },  // DOES NOT SUCCEED OR EQUAL
  { 0x22E2, BIDI_ON  },  // NOT SQUARE IMAGE OF OR EQUAL TO
  { 0x22E3, BIDI_ON  },  // NOT SQUARE ORIGINAL OF OR EQUAL TO
  { 0x22E4, BIDI_ON  },  // SQUARE IMAGE OF OR NOT EQUAL TO
  { 0x22E5, BIDI_ON  },  // SQUARE ORIGINAL OF OR NOT EQUAL TO
  { 0x22E6, BIDI_ON  },  // LESS-THAN BUT NOT EQUIVALENT TO
  { 0x22E7, BIDI_ON  },  // GREATER-THAN BUT NOT EQUIVALENT TO
  { 0x22E8, BIDI_ON  },  // PRECEDES BUT NOT EQUIVALENT TO
  { 0x22E9, BIDI_ON  },  // SUCCEEDS BUT NOT EQUIVALENT TO
  { 0x22EA, BIDI_ON  },  // NOT NORMAL SUBGROUP OF
  { 0x22EB, BIDI_ON  },  // DOES NOT CONTAIN AS NORMAL SUBGROUP
  { 0x22EC, BIDI_ON  },  // NOT NORMAL SUBGROUP OF OR EQUAL TO
  { 0x22ED, BIDI_ON  },  // DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
  { 0x22EE, BIDI_ON  },  // VERTICAL ELLIPSIS
  { 0x22EF, BIDI_ON  },  // MIDLINE HORIZONTAL ELLIPSIS
  { 0x22F0, BIDI_ON  },  // UP RIGHT DIAGONAL ELLIPSIS
  { 0x22F1, BIDI_ON  },  // DOWN RIGHT DIAGONAL ELLIPSIS
  { 0x22F2, BIDI_ON  },  // ELEMENT OF WITH LONG HORIZONTAL STROKE
  { 0x22F3, BIDI_ON  },  // ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
  { 0x22F4, BIDI_ON  },  // SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
  { 0x22F5, BIDI_ON  },  // ELEMENT OF WITH DOT ABOVE
  { 0x22F6, BIDI_ON  },  // ELEMENT OF WITH OVERBAR
  { 0x22F7, BIDI_ON  },  // SMALL ELEMENT OF WITH OVERBAR
  { 0x22F8, BIDI_ON  },  // ELEMENT OF WITH UNDERBAR
  { 0x22F9, BIDI_ON  },  // ELEMENT OF WITH TWO HORIZONTAL STROKES
  { 0x22FA, BIDI_ON  },  // CONTAINS WITH LONG HORIZONTAL STROKE
  { 0x22FB, BIDI_ON  },  // CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
  { 0x22FC, BIDI_ON  },  // SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
  { 0x22FD, BIDI_ON  },  // CONTAINS WITH OVERBAR
  { 0x22FE, BIDI_ON  },  // SMALL CONTAINS WITH OVERBAR
  { 0x22FF, BIDI_ON  },  // Z NOTATION BAG MEMBERSHIP
  { 0x2300, BIDI_ON  },  // DIAMETER SIGN
  { 0x2301, BIDI_ON  },  // ELECTRIC ARROW
  { 0x2302, BIDI_ON  },  // HOUSE
  { 0x2303, BIDI_ON  },  // UP ARROWHEAD
  { 0x2304, BIDI_ON  },  // DOWN ARROWHEAD
  { 0x2305, BIDI_ON  },  // PROJECTIVE
  { 0x2306, BIDI_ON  },  // PERSPECTIVE
  { 0x2307, BIDI_ON  },  // WAVY LINE
  { 0x2308, BIDI_ON  },  // LEFT CEILING
  { 0x2309, BIDI_ON  },  // RIGHT CEILING
  { 0x230A, BIDI_ON  },  // LEFT FLOOR
  { 0x230B, BIDI_ON  },  // RIGHT FLOOR
  { 0x230C, BIDI_ON  },  // BOTTOM RIGHT CROP
  { 0x230D, BIDI_ON  },  // BOTTOM LEFT CROP
  { 0x230E, BIDI_ON  },  // TOP RIGHT CROP
  { 0x230F, BIDI_ON  },  // TOP LEFT CROP
  { 0x2310, BIDI_ON  },  // REVERSED NOT SIGN
  { 0x2311, BIDI_ON  },  // SQUARE LOZENGE
  { 0x2312, BIDI_ON  },  // ARC
  { 0x2313, BIDI_ON  },  // SEGMENT
  { 0x2314, BIDI_ON  },  // SECTOR
  { 0x2315, BIDI_ON  },  // TELEPHONE RECORDER
  { 0x2316, BIDI_ON  },  // POSITION INDICATOR
  { 0x2317, BIDI_ON  },  // VIEWDATA SQUARE
  { 0x2318, BIDI_ON  },  // PLACE OF INTEREST SIGN
  { 0x2319, BIDI_ON  },  // TURNED NOT SIGN
  { 0x231A, BIDI_ON  },  // WATCH
  { 0x231B, BIDI_ON  },  // HOURGLASS
  { 0x231C, BIDI_ON  },  // TOP LEFT CORNER
  { 0x231D, BIDI_ON  },  // TOP RIGHT CORNER
  { 0x231E, BIDI_ON  },  // BOTTOM LEFT CORNER
  { 0x231F, BIDI_ON  },  // BOTTOM RIGHT CORNER
  { 0x2320, BIDI_ON  },  // TOP HALF INTEGRAL
  { 0x2321, BIDI_ON  },  // BOTTOM HALF INTEGRAL
  { 0x2322, BIDI_ON  },  // FROWN
  { 0x2323, BIDI_ON  },  // SMILE
  { 0x2324, BIDI_ON  },  // UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS
  { 0x2325, BIDI_ON  },  // OPTION KEY
  { 0x2326, BIDI_ON  },  // ERASE TO THE RIGHT
  { 0x2327, BIDI_ON  },  // X IN A RECTANGLE BOX
  { 0x2328, BIDI_ON  },  // KEYBOARD
  { 0x2329, BIDI_ON  },  // LEFT-POINTING ANGLE BRACKET
  { 0x232A, BIDI_ON  },  // RIGHT-POINTING ANGLE BRACKET
  { 0x232B, BIDI_ON  },  // ERASE TO THE LEFT
  { 0x232C, BIDI_ON  },  // BENZENE RING
  { 0x232D, BIDI_ON  },  // CYLINDRICITY
  { 0x232E, BIDI_ON  },  // ALL AROUND-PROFILE
  { 0x232F, BIDI_ON  },  // SYMMETRY
  { 0x2330, BIDI_ON  },  // TOTAL RUNOUT
  { 0x2331, BIDI_ON  },  // DIMENSION ORIGIN
  { 0x2332, BIDI_ON  },  // CONICAL TAPER
  { 0x2333, BIDI_ON  },  // SLOPE
  { 0x2334, BIDI_ON  },  // COUNTERBORE
  { 0x2335, BIDI_ON  },  // COUNTERSINK
  { 0x2336, BIDI_L   },  // APL FUNCTIONAL SYMBOL I-BEAM
  { 0x2337, BIDI_L   },  // APL FUNCTIONAL SYMBOL SQUISH QUAD
  { 0x2338, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD EQUAL
  { 0x2339, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD DIVIDE
  { 0x233A, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD DIAMOND
  { 0x233B, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD JOT
  { 0x233C, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD CIRCLE
  { 0x233D, BIDI_L   },  // APL FUNCTIONAL SYMBOL CIRCLE STILE
  { 0x233E, BIDI_L   },  // APL FUNCTIONAL SYMBOL CIRCLE JOT
  { 0x233F, BIDI_L   },  // APL FUNCTIONAL SYMBOL SLASH BAR
  { 0x2340, BIDI_L   },  // APL FUNCTIONAL SYMBOL BACKSLASH BAR
  { 0x2341, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD SLASH
  { 0x2342, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD BACKSLASH
  { 0x2343, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD LESS-THAN
  { 0x2344, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD GREATER-THAN
  { 0x2345, BIDI_L   },  // APL FUNCTIONAL SYMBOL LEFTWARDS VANE
  { 0x2346, BIDI_L   },  // APL FUNCTIONAL SYMBOL RIGHTWARDS VANE
  { 0x2347, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW
  { 0x2348, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW
  { 0x2349, BIDI_L   },  // APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH
  { 0x234A, BIDI_L   },  // APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR
  { 0x234B, BIDI_L   },  // APL FUNCTIONAL SYMBOL DELTA STILE
  { 0x234C, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD DOWN CARET
  { 0x234D, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD DELTA
  { 0x234E, BIDI_L   },  // APL FUNCTIONAL SYMBOL DOWN TACK JOT
  { 0x234F, BIDI_L   },  // APL FUNCTIONAL SYMBOL UPWARDS VANE
  { 0x2350, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW
  { 0x2351, BIDI_L   },  // APL FUNCTIONAL SYMBOL UP TACK OVERBAR
  { 0x2352, BIDI_L   },  // APL FUNCTIONAL SYMBOL DEL STILE
  { 0x2353, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD UP CARET
  { 0x2354, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD DEL
  { 0x2355, BIDI_L   },  // APL FUNCTIONAL SYMBOL UP TACK JOT
  { 0x2356, BIDI_L   },  // APL FUNCTIONAL SYMBOL DOWNWARDS VANE
  { 0x2357, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW
  { 0x2358, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUOTE UNDERBAR
  { 0x2359, BIDI_L   },  // APL FUNCTIONAL SYMBOL DELTA UNDERBAR
  { 0x235A, BIDI_L   },  // APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR
  { 0x235B, BIDI_L   },  // APL FUNCTIONAL SYMBOL JOT UNDERBAR
  { 0x235C, BIDI_L   },  // APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR
  { 0x235D, BIDI_L   },  // APL FUNCTIONAL SYMBOL UP SHOE JOT
  { 0x235E, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUOTE QUAD
  { 0x235F, BIDI_L   },  // APL FUNCTIONAL SYMBOL CIRCLE STAR
  { 0x2360, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD COLON
  { 0x2361, BIDI_L   },  // APL FUNCTIONAL SYMBOL UP TACK DIAERESIS
  { 0x2362, BIDI_L   },  // APL FUNCTIONAL SYMBOL DEL DIAERESIS
  { 0x2363, BIDI_L   },  // APL FUNCTIONAL SYMBOL STAR DIAERESIS
  { 0x2364, BIDI_L   },  // APL FUNCTIONAL SYMBOL JOT DIAERESIS
  { 0x2365, BIDI_L   },  // APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS
  { 0x2366, BIDI_L   },  // APL FUNCTIONAL SYMBOL DOWN SHOE STILE
  { 0x2367, BIDI_L   },  // APL FUNCTIONAL SYMBOL LEFT SHOE STILE
  { 0x2368, BIDI_L   },  // APL FUNCTIONAL SYMBOL TILDE DIAERESIS
  { 0x2369, BIDI_L   },  // APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS
  { 0x236A, BIDI_L   },  // APL FUNCTIONAL SYMBOL COMMA BAR
  { 0x236B, BIDI_L   },  // APL FUNCTIONAL SYMBOL DEL TILDE
  { 0x236C, BIDI_L   },  // APL FUNCTIONAL SYMBOL ZILDE
  { 0x236D, BIDI_L   },  // APL FUNCTIONAL SYMBOL STILE TILDE
  { 0x236E, BIDI_L   },  // APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR
  { 0x236F, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD NOT EQUAL
  { 0x2370, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD QUESTION
  { 0x2371, BIDI_L   },  // APL FUNCTIONAL SYMBOL DOWN CARET TILDE
  { 0x2372, BIDI_L   },  // APL FUNCTIONAL SYMBOL UP CARET TILDE
  { 0x2373, BIDI_L   },  // APL FUNCTIONAL SYMBOL IOTA
  { 0x2374, BIDI_L   },  // APL FUNCTIONAL SYMBOL RHO
  { 0x2375, BIDI_L   },  // APL FUNCTIONAL SYMBOL OMEGA
  { 0x2376, BIDI_L   },  // APL FUNCTIONAL SYMBOL ALPHA UNDERBAR
  { 0x2377, BIDI_L   },  // APL FUNCTIONAL SYMBOL EPSILON UNDERBAR
  { 0x2378, BIDI_L   },  // APL FUNCTIONAL SYMBOL IOTA UNDERBAR
  { 0x2379, BIDI_L   },  // APL FUNCTIONAL SYMBOL OMEGA UNDERBAR
  { 0x237A, BIDI_L   },  // APL FUNCTIONAL SYMBOL ALPHA
  { 0x237B, BIDI_ON  },  // NOT CHECK MARK
  { 0x237C, BIDI_ON  },  // RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
  { 0x237D, BIDI_ON  },  // SHOULDERED OPEN BOX
  { 0x237E, BIDI_ON  },  // BELL SYMBOL
  { 0x237F, BIDI_ON  },  // VERTICAL LINE WITH MIDDLE DOT
  { 0x2380, BIDI_ON  },  // INSERTION SYMBOL
  { 0x2381, BIDI_ON  },  // CONTINUOUS UNDERLINE SYMBOL
  { 0x2382, BIDI_ON  },  // DISCONTINUOUS UNDERLINE SYMBOL
  { 0x2383, BIDI_ON  },  // EMPHASIS SYMBOL
  { 0x2384, BIDI_ON  },  // COMPOSITION SYMBOL
  { 0x2385, BIDI_ON  },  // WHITE SQUARE WITH CENTRE VERTICAL LINE
  { 0x2386, BIDI_ON  },  // ENTER SYMBOL
  { 0x2387, BIDI_ON  },  // ALTERNATIVE KEY SYMBOL
  { 0x2388, BIDI_ON  },  // HELM SYMBOL
  { 0x2389, BIDI_ON  },  // CIRCLED HORIZONTAL BAR WITH NOTCH
  { 0x238A, BIDI_ON  },  // CIRCLED TRIANGLE DOWN
  { 0x238B, BIDI_ON  },  // BROKEN CIRCLE WITH NORTHWEST ARROW
  { 0x238C, BIDI_ON  },  // UNDO SYMBOL
  { 0x238D, BIDI_ON  },  // MONOSTABLE SYMBOL
  { 0x238E, BIDI_ON  },  // HYSTERESIS SYMBOL
  { 0x238F, BIDI_ON  },  // OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL
  { 0x2390, BIDI_ON  },  // OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL
  { 0x2391, BIDI_ON  },  // PASSIVE-PULL-DOWN-OUTPUT SYMBOL
  { 0x2392, BIDI_ON  },  // PASSIVE-PULL-UP-OUTPUT SYMBOL
  { 0x2393, BIDI_ON  },  // DIRECT CURRENT SYMBOL FORM TWO
  { 0x2394, BIDI_ON  },  // SOFTWARE-FUNCTION SYMBOL
  { 0x2395, BIDI_L   },  // APL FUNCTIONAL SYMBOL QUAD
  { 0x2396, BIDI_ON  },  // DECIMAL SEPARATOR KEY SYMBOL
  { 0x2397, BIDI_ON  },  // PREVIOUS PAGE
  { 0x2398, BIDI_ON  },  // NEXT PAGE
  { 0x2399, BIDI_ON  },  // PRINT SCREEN SYMBOL
  { 0x239A, BIDI_ON  },  // CLEAR SCREEN SYMBOL
  { 0x239B, BIDI_ON  },  // LEFT PARENTHESIS UPPER HOOK
  { 0x239C, BIDI_ON  },  // LEFT PARENTHESIS EXTENSION
  { 0x239D, BIDI_ON  },  // LEFT PARENTHESIS LOWER HOOK
  { 0x239E, BIDI_ON  },  // RIGHT PARENTHESIS UPPER HOOK
  { 0x239F, BIDI_ON  },  // RIGHT PARENTHESIS EXTENSION
  { 0x23A0, BIDI_ON  },  // RIGHT PARENTHESIS LOWER HOOK
  { 0x23A1, BIDI_ON  },  // LEFT SQUARE BRACKET UPPER CORNER
  { 0x23A2, BIDI_ON  },  // LEFT SQUARE BRACKET EXTENSION
  { 0x23A3, BIDI_ON  },  // LEFT SQUARE BRACKET LOWER CORNER
  { 0x23A4, BIDI_ON  },  // RIGHT SQUARE BRACKET UPPER CORNER
  { 0x23A5, BIDI_ON  },  // RIGHT SQUARE BRACKET EXTENSION
  { 0x23A6, BIDI_ON  },  // RIGHT SQUARE BRACKET LOWER CORNER
  { 0x23A7, BIDI_ON  },  // LEFT CURLY BRACKET UPPER HOOK
  { 0x23A8, BIDI_ON  },  // LEFT CURLY BRACKET MIDDLE PIECE
  { 0x23A9, BIDI_ON  },  // LEFT CURLY BRACKET LOWER HOOK
  { 0x23AA, BIDI_ON  },  // CURLY BRACKET EXTENSION
  { 0x23AB, BIDI_ON  },  // RIGHT CURLY BRACKET UPPER HOOK
  { 0x23AC, BIDI_ON  },  // RIGHT CURLY BRACKET MIDDLE PIECE
  { 0x23AD, BIDI_ON  },  // RIGHT CURLY BRACKET LOWER HOOK
  { 0x23AE, BIDI_ON  },  // INTEGRAL EXTENSION
  { 0x23AF, BIDI_ON  },  // HORIZONTAL LINE EXTENSION
  { 0x23B0, BIDI_ON  },  // UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
  { 0x23B1, BIDI_ON  },  // UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
  { 0x23B2, BIDI_ON  },  // SUMMATION TOP
  { 0x23B3, BIDI_ON  },  // SUMMATION BOTTOM
  { 0x23B4, BIDI_ON  },  // TOP SQUARE BRACKET
  { 0x23B5, BIDI_ON  },  // BOTTOM SQUARE BRACKET
  { 0x23B6, BIDI_ON  },  // BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET
  { 0x23B7, BIDI_ON  },  // RADICAL SYMBOL BOTTOM
  { 0x23B8, BIDI_ON  },  // LEFT VERTICAL BOX LINE
  { 0x23B9, BIDI_ON  },  // RIGHT VERTICAL BOX LINE
  { 0x23BA, BIDI_ON  },  // HORIZONTAL SCAN LINE-1
  { 0x23BB, BIDI_ON  },  // HORIZONTAL SCAN LINE-3
  { 0x23BC, BIDI_ON  },  // HORIZONTAL SCAN LINE-7
  { 0x23BD, BIDI_ON  },  // HORIZONTAL SCAN LINE-9
  { 0x23BE, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT
  { 0x23BF, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT
  { 0x23C0, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE
  { 0x23C1, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE
  { 0x23C2, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE
  { 0x23C3, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE
  { 0x23C4, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE
  { 0x23C5, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE
  { 0x23C6, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE
  { 0x23C7, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE
  { 0x23C8, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE
  { 0x23C9, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL
  { 0x23CA, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL
  { 0x23CB, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT
  { 0x23CC, BIDI_ON  },  // DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT
  { 0x23CD, BIDI_ON  },  // SQUARE FOOT
  { 0x23CE, BIDI_ON  },  // RETURN SYMBOL
  { 0x23CF, BIDI_ON  },  // EJECT SYMBOL
  { 0x23D0, BIDI_ON  },  // VERTICAL LINE EXTENSION
  { 0x23D1, BIDI_ON  },  // METRICAL BREVE
  { 0x23D2, BIDI_ON  },  // METRICAL LONG OVER SHORT
  { 0x23D3, BIDI_ON  },  // METRICAL SHORT OVER LONG
  { 0x23D4, BIDI_ON  },  // METRICAL LONG OVER TWO SHORTS
  { 0x23D5, BIDI_ON  },  // METRICAL TWO SHORTS OVER LONG
  { 0x23D6, BIDI_ON  },  // METRICAL TWO SHORTS JOINED
  { 0x23D7, BIDI_ON  },  // METRICAL TRISEME
  { 0x23D8, BIDI_ON  },  // METRICAL TETRASEME
  { 0x23D9, BIDI_ON  },  // METRICAL PENTASEME
  { 0x23DA, BIDI_ON  },  // EARTH GROUND
  { 0x23DB, BIDI_ON  },  // FUSE
  { 0x23DC, BIDI_ON  },  // TOP PARENTHESIS
  { 0x23DD, BIDI_ON  },  // BOTTOM PARENTHESIS
  { 0x23DE, BIDI_ON  },  // TOP CURLY BRACKET
  { 0x23DF, BIDI_ON  },  // BOTTOM CURLY BRACKET
  { 0x23E0, BIDI_ON  },  // TOP TORTOISE SHELL BRACKET
  { 0x23E1, BIDI_ON  },  // BOTTOM TORTOISE SHELL BRACKET
  { 0x23E2, BIDI_ON  },  // WHITE TRAPEZIUM
  { 0x23E3, BIDI_ON  },  // BENZENE RING WITH CIRCLE
  { 0x23E4, BIDI_ON  },  // STRAIGHTNESS
  { 0x23E5, BIDI_ON  },  // FLATNESS
  { 0x23E6, BIDI_ON  },  // AC CURRENT
  { 0x23E7, BIDI_ON  },  // ELECTRICAL INTERSECTION
  { 0x23E8, BIDI_ON  },  // DECIMAL EXPONENT SYMBOL
  { 0x23E9, BIDI_ON  },  // BLACK RIGHT-POINTING DOUBLE TRIANGLE
  { 0x23EA, BIDI_ON  },  // BLACK LEFT-POINTING DOUBLE TRIANGLE
  { 0x23EB, BIDI_ON  },  // BLACK UP-POINTING DOUBLE TRIANGLE
  { 0x23EC, BIDI_ON  },  // BLACK DOWN-POINTING DOUBLE TRIANGLE
  { 0x23ED, BIDI_ON  },  // BLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR
  { 0x23EE, BIDI_ON  },  // BLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR
  { 0x23EF, BIDI_ON  },  // BLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BAR
  { 0x23F0, BIDI_ON  },  // ALARM CLOCK
  { 0x23F1, BIDI_ON  },  // STOPWATCH
  { 0x23F2, BIDI_ON  },  // TIMER CLOCK
  { 0x23F3, BIDI_ON  },  // HOURGLASS WITH FLOWING SAND
  { 0x23F4, BIDI_ON  },  // BLACK MEDIUM LEFT-POINTING TRIANGLE
  { 0x23F5, BIDI_ON  },  // BLACK MEDIUM RIGHT-POINTING TRIANGLE
  { 0x23F6, BIDI_ON  },  // BLACK MEDIUM UP-POINTING TRIANGLE
  { 0x23F7, BIDI_ON  },  // BLACK MEDIUM DOWN-POINTING TRIANGLE
  { 0x23F8, BIDI_ON  },  // DOUBLE VERTICAL BAR
  { 0x23F9, BIDI_ON  },  // BLACK SQUARE FOR STOP
  { 0x23FA, BIDI_ON  },  // BLACK CIRCLE FOR RECORD
  { 0x2400, BIDI_ON  },  // SYMBOL FOR NULL
  { 0x2401, BIDI_ON  },  // SYMBOL FOR START OF HEADING
  { 0x2402, BIDI_ON  },  // SYMBOL FOR START OF TEXT
  { 0x2403, BIDI_ON  },  // SYMBOL FOR END OF TEXT
  { 0x2404, BIDI_ON  },  // SYMBOL FOR END OF TRANSMISSION
  { 0x2405, BIDI_ON  },  // SYMBOL FOR ENQUIRY
  { 0x2406, BIDI_ON  },  // SYMBOL FOR ACKNOWLEDGE
  { 0x2407, BIDI_ON  },  // SYMBOL FOR BELL
  { 0x2408, BIDI_ON  },  // SYMBOL FOR BACKSPACE
  { 0x2409, BIDI_ON  },  // SYMBOL FOR HORIZONTAL TABULATION
  { 0x240A, BIDI_ON  },  // SYMBOL FOR LINE FEED
  { 0x240B, BIDI_ON  },  // SYMBOL FOR VERTICAL TABULATION
  { 0x240C, BIDI_ON  },  // SYMBOL FOR FORM FEED
  { 0x240D, BIDI_ON  },  // SYMBOL FOR CARRIAGE RETURN
  { 0x240E, BIDI_ON  },  // SYMBOL FOR SHIFT OUT
  { 0x240F, BIDI_ON  },  // SYMBOL FOR SHIFT IN
  { 0x2410, BIDI_ON  },  // SYMBOL FOR DATA LINK ESCAPE
  { 0x2411, BIDI_ON  },  // SYMBOL FOR DEVICE CONTROL ONE
  { 0x2412, BIDI_ON  },  // SYMBOL FOR DEVICE CONTROL TWO
  { 0x2413, BIDI_ON  },  // SYMBOL FOR DEVICE CONTROL THREE
  { 0x2414, BIDI_ON  },  // SYMBOL FOR DEVICE CONTROL FOUR
  { 0x2415, BIDI_ON  },  // SYMBOL FOR NEGATIVE ACKNOWLEDGE
  { 0x2416, BIDI_ON  },  // SYMBOL FOR SYNCHRONOUS IDLE
  { 0x2417, BIDI_ON  },  // SYMBOL FOR END OF TRANSMISSION BLOCK
  { 0x2418, BIDI_ON  },  // SYMBOL FOR CANCEL
  { 0x2419, BIDI_ON  },  // SYMBOL FOR END OF MEDIUM
  { 0x241A, BIDI_ON  },  // SYMBOL FOR SUBSTITUTE
  { 0x241B, BIDI_ON  },  // SYMBOL FOR ESCAPE
  { 0x241C, BIDI_ON  },  // SYMBOL FOR FILE SEPARATOR
  { 0x241D, BIDI_ON  },  // SYMBOL FOR GROUP SEPARATOR
  { 0x241E, BIDI_ON  },  // SYMBOL FOR RECORD SEPARATOR
  { 0x241F, BIDI_ON  },  // SYMBOL FOR UNIT SEPARATOR
  { 0x2420, BIDI_ON  },  // SYMBOL FOR SPACE
  { 0x2421, BIDI_ON  },  // SYMBOL FOR DELETE
  { 0x2422, BIDI_ON  },  // BLANK SYMBOL
  { 0x2423, BIDI_ON  },  // OPEN BOX
  { 0x2424, BIDI_ON  },  // SYMBOL FOR NEWLINE
  { 0x2425, BIDI_ON  },  // SYMBOL FOR DELETE FORM TWO
  { 0x2426, BIDI_ON  },  // SYMBOL FOR SUBSTITUTE FORM TWO
  { 0x2440, BIDI_ON  },  // OCR HOOK
  { 0x2441, BIDI_ON  },  // OCR CHAIR
  { 0x2442, BIDI_ON  },  // OCR FORK
  { 0x2443, BIDI_ON  },  // OCR INVERTED FORK
  { 0x2444, BIDI_ON  },  // OCR BELT BUCKLE
  { 0x2445, BIDI_ON  },  // OCR BOW TIE
  { 0x2446, BIDI_ON  },  // OCR BRANCH BANK IDENTIFICATION
  { 0x2447, BIDI_ON  },  // OCR AMOUNT OF CHECK
  { 0x2448, BIDI_ON  },  // OCR DASH
  { 0x2449, BIDI_ON  },  // OCR CUSTOMER ACCOUNT NUMBER
  { 0x244A, BIDI_ON  },  // OCR DOUBLE BACKSLASH
  { 0x2460, BIDI_ON  },  // CIRCLED DIGIT ONE
  { 0x2461, BIDI_ON  },  // CIRCLED DIGIT TWO
  { 0x2462, BIDI_ON  },  // CIRCLED DIGIT THREE
  { 0x2463, BIDI_ON  },  // CIRCLED DIGIT FOUR
  { 0x2464, BIDI_ON  },  // CIRCLED DIGIT FIVE
  { 0x2465, BIDI_ON  },  // CIRCLED DIGIT SIX
  { 0x2466, BIDI_ON  },  // CIRCLED DIGIT SEVEN
  { 0x2467, BIDI_ON  },  // CIRCLED DIGIT EIGHT
  { 0x2468, BIDI_ON  },  // CIRCLED DIGIT NINE
  { 0x2469, BIDI_ON  },  // CIRCLED NUMBER TEN
  { 0x246A, BIDI_ON  },  // CIRCLED NUMBER ELEVEN
  { 0x246B, BIDI_ON  },  // CIRCLED NUMBER TWELVE
  { 0x246C, BIDI_ON  },  // CIRCLED NUMBER THIRTEEN
  { 0x246D, BIDI_ON  },  // CIRCLED NUMBER FOURTEEN
  { 0x246E, BIDI_ON  },  // CIRCLED NUMBER FIFTEEN
  { 0x246F, BIDI_ON  },  // CIRCLED NUMBER SIXTEEN
  { 0x2470, BIDI_ON  },  // CIRCLED NUMBER SEVENTEEN
  { 0x2471, BIDI_ON  },  // CIRCLED NUMBER EIGHTEEN
  { 0x2472, BIDI_ON  },  // CIRCLED NUMBER NINETEEN
  { 0x2473, BIDI_ON  },  // CIRCLED NUMBER TWENTY
  { 0x2474, BIDI_ON  },  // PARENTHESIZED DIGIT ONE
  { 0x2475, BIDI_ON  },  // PARENTHESIZED DIGIT TWO
  { 0x2476, BIDI_ON  },  // PARENTHESIZED DIGIT THREE
  { 0x2477, BIDI_ON  },  // PARENTHESIZED DIGIT FOUR
  { 0x2478, BIDI_ON  },  // PARENTHESIZED DIGIT FIVE
  { 0x2479, BIDI_ON  },  // PARENTHESIZED DIGIT SIX
  { 0x247A, BIDI_ON  },  // PARENTHESIZED DIGIT SEVEN
  { 0x247B, BIDI_ON  },  // PARENTHESIZED DIGIT EIGHT
  { 0x247C, BIDI_ON  },  // PARENTHESIZED DIGIT NINE
  { 0x247D, BIDI_ON  },  // PARENTHESIZED NUMBER TEN
  { 0x247E, BIDI_ON  },  // PARENTHESIZED NUMBER ELEVEN
  { 0x247F, BIDI_ON  },  // PARENTHESIZED NUMBER TWELVE
  { 0x2480, BIDI_ON  },  // PARENTHESIZED NUMBER THIRTEEN
  { 0x2481, BIDI_ON  },  // PARENTHESIZED NUMBER FOURTEEN
  { 0x2482, BIDI_ON  },  // PARENTHESIZED NUMBER FIFTEEN
  { 0x2483, BIDI_ON  },  // PARENTHESIZED NUMBER SIXTEEN
  { 0x2484, BIDI_ON  },  // PARENTHESIZED NUMBER SEVENTEEN
  { 0x2485, BIDI_ON  },  // PARENTHESIZED NUMBER EIGHTEEN
  { 0x2486, BIDI_ON  },  // PARENTHESIZED NUMBER NINETEEN
  { 0x2487, BIDI_ON  },  // PARENTHESIZED NUMBER TWENTY
  { 0x2488, BIDI_EN  },  // DIGIT ONE FULL STOP
  { 0x2489, BIDI_EN  },  // DIGIT TWO FULL STOP
  { 0x248A, BIDI_EN  },  // DIGIT THREE FULL STOP
  { 0x248B, BIDI_EN  },  // DIGIT FOUR FULL STOP
  { 0x248C, BIDI_EN  },  // DIGIT FIVE FULL STOP
  { 0x248D, BIDI_EN  },  // DIGIT SIX FULL STOP
  { 0x248E, BIDI_EN  },  // DIGIT SEVEN FULL STOP
  { 0x248F, BIDI_EN  },  // DIGIT EIGHT FULL STOP
  { 0x2490, BIDI_EN  },  // DIGIT NINE FULL STOP
  { 0x2491, BIDI_EN  },  // NUMBER TEN FULL STOP
  { 0x2492, BIDI_EN  },  // NUMBER ELEVEN FULL STOP
  { 0x2493, BIDI_EN  },  // NUMBER TWELVE FULL STOP
  { 0x2494, BIDI_EN  },  // NUMBER THIRTEEN FULL STOP
  { 0x2495, BIDI_EN  },  // NUMBER FOURTEEN FULL STOP
  { 0x2496, BIDI_EN  },  // NUMBER FIFTEEN FULL STOP
  { 0x2497, BIDI_EN  },  // NUMBER SIXTEEN FULL STOP
  { 0x2498, BIDI_EN  },  // NUMBER SEVENTEEN FULL STOP
  { 0x2499, BIDI_EN  },  // NUMBER EIGHTEEN FULL STOP
  { 0x249A, BIDI_EN  },  // NUMBER NINETEEN FULL STOP
  { 0x249B, BIDI_EN  },  // NUMBER TWENTY FULL STOP
  { 0x249C, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER A
  { 0x249D, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER B
  { 0x249E, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER C
  { 0x249F, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER D
  { 0x24A0, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER E
  { 0x24A1, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER F
  { 0x24A2, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER G
  { 0x24A3, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER H
  { 0x24A4, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER I
  { 0x24A5, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER J
  { 0x24A6, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER K
  { 0x24A7, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER L
  { 0x24A8, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER M
  { 0x24A9, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER N
  { 0x24AA, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER O
  { 0x24AB, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER P
  { 0x24AC, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER Q
  { 0x24AD, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER R
  { 0x24AE, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER S
  { 0x24AF, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER T
  { 0x24B0, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER U
  { 0x24B1, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER V
  { 0x24B2, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER W
  { 0x24B3, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER X
  { 0x24B4, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER Y
  { 0x24B5, BIDI_L   },  // PARENTHESIZED LATIN SMALL LETTER Z
  { 0x24B6, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER A
  { 0x24B7, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER B
  { 0x24B8, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER C
  { 0x24B9, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER D
  { 0x24BA, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER E
  { 0x24BB, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER F
  { 0x24BC, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER G
  { 0x24BD, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER H
  { 0x24BE, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER I
  { 0x24BF, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER J
  { 0x24C0, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER K
  { 0x24C1, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER L
  { 0x24C2, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER M
  { 0x24C3, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER N
  { 0x24C4, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER O
  { 0x24C5, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER P
  { 0x24C6, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER Q
  { 0x24C7, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER R
  { 0x24C8, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER S
  { 0x24C9, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER T
  { 0x24CA, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER U
  { 0x24CB, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER V
  { 0x24CC, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER W
  { 0x24CD, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER X
  { 0x24CE, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER Y
  { 0x24CF, BIDI_L   },  // CIRCLED LATIN CAPITAL LETTER Z
  { 0x24D0, BIDI_L   },  // CIRCLED LATIN SMALL LETTER A
  { 0x24D1, BIDI_L   },  // CIRCLED LATIN SMALL LETTER B
  { 0x24D2, BIDI_L   },  // CIRCLED LATIN SMALL LETTER C
  { 0x24D3, BIDI_L   },  // CIRCLED LATIN SMALL LETTER D
  { 0x24D4, BIDI_L   },  // CIRCLED LATIN SMALL LETTER E
  { 0x24D5, BIDI_L   },  // CIRCLED LATIN SMALL LETTER F
  { 0x24D6, BIDI_L   },  // CIRCLED LATIN SMALL LETTER G
  { 0x24D7, BIDI_L   },  // CIRCLED LATIN SMALL LETTER H
  { 0x24D8, BIDI_L   },  // CIRCLED LATIN SMALL LETTER I
  { 0x24D9, BIDI_L   },  // CIRCLED LATIN SMALL LETTER J
  { 0x24DA, BIDI_L   },  // CIRCLED LATIN SMALL LETTER K
  { 0x24DB, BIDI_L   },  // CIRCLED LATIN SMALL LETTER L
  { 0x24DC, BIDI_L   },  // CIRCLED LATIN SMALL LETTER M
  { 0x24DD, BIDI_L   },  // CIRCLED LATIN SMALL LETTER N
  { 0x24DE, BIDI_L   },  // CIRCLED LATIN SMALL LETTER O
  { 0x24DF, BIDI_L   },  // CIRCLED LATIN SMALL LETTER P
  { 0x24E0, BIDI_L   },  // CIRCLED LATIN SMALL LETTER Q
  { 0x24E1, BIDI_L   },  // CIRCLED LATIN SMALL LETTER R
  { 0x24E2, BIDI_L   },  // CIRCLED LATIN SMALL LETTER S
  { 0x24E3, BIDI_L   },  // CIRCLED LATIN SMALL LETTER T
  { 0x24E4, BIDI_L   },  // CIRCLED LATIN SMALL LETTER U
  { 0x24E5, BIDI_L   },  // CIRCLED LATIN SMALL LETTER V
  { 0x24E6, BIDI_L   },  // CIRCLED LATIN SMALL LETTER W
  { 0x24E7, BIDI_L   },  // CIRCLED LATIN SMALL LETTER X
  { 0x24E8, BIDI_L   },  // CIRCLED LATIN SMALL LETTER Y
  { 0x24E9, BIDI_L   },  // CIRCLED LATIN SMALL LETTER Z
  { 0x24EA, BIDI_ON  },  // CIRCLED DIGIT ZERO
  { 0x24EB, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER ELEVEN
  { 0x24EC, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER TWELVE
  { 0x24ED, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER THIRTEEN
  { 0x24EE, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER FOURTEEN
  { 0x24EF, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER FIFTEEN
  { 0x24F0, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER SIXTEEN
  { 0x24F1, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER SEVENTEEN
  { 0x24F2, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER EIGHTEEN
  { 0x24F3, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER NINETEEN
  { 0x24F4, BIDI_ON  },  // NEGATIVE CIRCLED NUMBER TWENTY
  { 0x24F5, BIDI_ON  },  // DOUBLE CIRCLED DIGIT ONE
  { 0x24F6, BIDI_ON  },  // DOUBLE CIRCLED DIGIT TWO
  { 0x24F7, BIDI_ON  },  // DOUBLE CIRCLED DIGIT THREE
  { 0x24F8, BIDI_ON  },  // DOUBLE CIRCLED DIGIT FOUR
  { 0x24F9, BIDI_ON  },  // DOUBLE CIRCLED DIGIT FIVE
  { 0x24FA, BIDI_ON  },  // DOUBLE CIRCLED DIGIT SIX
  { 0x24FB, BIDI_ON  },  // DOUBLE CIRCLED DIGIT SEVEN
  { 0x24FC, BIDI_ON  },  // DOUBLE CIRCLED DIGIT EIGHT
  { 0x24FD, BIDI_ON  },  // DOUBLE CIRCLED DIGIT NINE
  { 0x24FE, BIDI_ON  },  // DOUBLE CIRCLED NUMBER TEN
  { 0x24FF, BIDI_ON  },  // NEGATIVE CIRCLED DIGIT ZERO
  { 0x2500, BIDI_ON  },  // BOX DRAWINGS LIGHT HORIZONTAL
  { 0x2501, BIDI_ON  },  // BOX DRAWINGS HEAVY HORIZONTAL
  { 0x2502, BIDI_ON  },  // BOX DRAWINGS LIGHT VERTICAL
  { 0x2503, BIDI_ON  },  // BOX DRAWINGS HEAVY VERTICAL
  { 0x2504, BIDI_ON  },  // BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
  { 0x2505, BIDI_ON  },  // BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
  { 0x2506, BIDI_ON  },  // BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
  { 0x2507, BIDI_ON  },  // BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
  { 0x2508, BIDI_ON  },  // BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
  { 0x2509, BIDI_ON  },  // BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
  { 0x250A, BIDI_ON  },  // BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
  { 0x250B, BIDI_ON  },  // BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
  { 0x250C, BIDI_ON  },  // BOX DRAWINGS LIGHT DOWN AND RIGHT
  { 0x250D, BIDI_ON  },  // BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
  { 0x250E, BIDI_ON  },  // BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
  { 0x250F, BIDI_ON  },  // BOX DRAWINGS HEAVY DOWN AND RIGHT
  { 0x2510, BIDI_ON  },  // BOX DRAWINGS LIGHT DOWN AND LEFT
  { 0x2511, BIDI_ON  },  // BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
  { 0x2512, BIDI_ON  },  // BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
  { 0x2513, BIDI_ON  },  // BOX DRAWINGS HEAVY DOWN AND LEFT
  { 0x2514, BIDI_ON  },  // BOX DRAWINGS LIGHT UP AND RIGHT
  { 0x2515, BIDI_ON  },  // BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
  { 0x2516, BIDI_ON  },  // BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
  { 0x2517, BIDI_ON  },  // BOX DRAWINGS HEAVY UP AND RIGHT
  { 0x2518, BIDI_ON  },  // BOX DRAWINGS LIGHT UP AND LEFT
  { 0x2519, BIDI_ON  },  // BOX DRAWINGS UP LIGHT AND LEFT HEAVY
  { 0x251A, BIDI_ON  },  // BOX DRAWINGS UP HEAVY AND LEFT LIGHT
  { 0x251B, BIDI_ON  },  // BOX DRAWINGS HEAVY UP AND LEFT
  { 0x251C, BIDI_ON  },  // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
  { 0x251D, BIDI_ON  },  // BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
  { 0x251E, BIDI_ON  },  // BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
  { 0x251F, BIDI_ON  },  // BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
  { 0x2520, BIDI_ON  },  // BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
  { 0x2521, BIDI_ON  },  // BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
  { 0x2522, BIDI_ON  },  // BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
  { 0x2523, BIDI_ON  },  // BOX DRAWINGS HEAVY VERTICAL AND RIGHT
  { 0x2524, BIDI_ON  },  // BOX DRAWINGS LIGHT VERTICAL AND LEFT
  { 0x2525, BIDI_ON  },  // BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
  { 0x2526, BIDI_ON  },  // BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
  { 0x2527, BIDI_ON  },  // BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
  { 0x2528, BIDI_ON  },  // BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
  { 0x2529, BIDI_ON  },  // BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
  { 0x252A, BIDI_ON  },  // BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
  { 0x252B, BIDI_ON  },  // BOX DRAWINGS HEAVY VERTICAL AND LEFT
  { 0x252C, BIDI_ON  },  // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
  { 0x252D, BIDI_ON  },  // BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
  { 0x252E, BIDI_ON  },  // BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
  { 0x252F, BIDI_ON  },  // BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
  { 0x2530, BIDI_ON  },  // BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
  { 0x2531, BIDI_ON  },  // BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
  { 0x2532, BIDI_ON  },  // BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
  { 0x2533, BIDI_ON  },  // BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
  { 0x2534, BIDI_ON  },  // BOX DRAWINGS LIGHT UP AND HORIZONTAL
  { 0x2535, BIDI_ON  },  // BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
  { 0x2536, BIDI_ON  },  // BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
  { 0x2537, BIDI_ON  },  // BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
  { 0x2538, BIDI_ON  },  // BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
  { 0x2539, BIDI_ON  },  // BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
  { 0x253A, BIDI_ON  },  // BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
  { 0x253B, BIDI_ON  },  // BOX DRAWINGS HEAVY UP AND HORIZONTAL
  { 0x253C, BIDI_ON  },  // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
  { 0x253D, BIDI_ON  },  // BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
  { 0x253E, BIDI_ON  },  // BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
  { 0x253F, BIDI_ON  },  // BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
  { 0x2540, BIDI_ON  },  // BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
  { 0x2541, BIDI_ON  },  // BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
  { 0x2542, BIDI_ON  },  // BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
  { 0x2543, BIDI_ON  },  // BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
  { 0x2544, BIDI_ON  },  // BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
  { 0x2545, BIDI_ON  },  // BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
  { 0x2546, BIDI_ON  },  // BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
  { 0x2547, BIDI_ON  },  // BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
  { 0x2548, BIDI_ON  },  // BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
  { 0x2549, BIDI_ON  },  // BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
  { 0x254A, BIDI_ON  },  // BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
  { 0x254B, BIDI_ON  },  // BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
  { 0x254C, BIDI_ON  },  // BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL
  { 0x254D, BIDI_ON  },  // BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL
  { 0x254E, BIDI_ON  },  // BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL
  { 0x254F, BIDI_ON  },  // BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL
  { 0x2550, BIDI_ON  },  // BOX DRAWINGS DOUBLE HORIZONTAL
  { 0x2551, BIDI_ON  },  // BOX DRAWINGS DOUBLE VERTICAL
  { 0x2552, BIDI_ON  },  // BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
  { 0x2553, BIDI_ON  },  // BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
  { 0x2554, BIDI_ON  },  // BOX DRAWINGS DOUBLE DOWN AND RIGHT
  { 0x2555, BIDI_ON  },  // BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
  { 0x2556, BIDI_ON  },  // BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
  { 0x2557, BIDI_ON  },  // BOX DRAWINGS DOUBLE DOWN AND LEFT
  { 0x2558, BIDI_ON  },  // BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
  { 0x2559, BIDI_ON  },  // BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
  { 0x255A, BIDI_ON  },  // BOX DRAWINGS DOUBLE UP AND RIGHT
  { 0x255B, BIDI_ON  },  // BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
  { 0x255C, BIDI_ON  },  // BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
  { 0x255D, BIDI_ON  },  // BOX DRAWINGS DOUBLE UP AND LEFT
  { 0x255E, BIDI_ON  },  // BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
  { 0x255F, BIDI_ON  },  // BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
  { 0x2560, BIDI_ON  },  // BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
  { 0x2561, BIDI_ON  },  // BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
  { 0x2562, BIDI_ON  },  // BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
  { 0x2563, BIDI_ON  },  // BOX DRAWINGS DOUBLE VERTICAL AND LEFT
  { 0x2564, BIDI_ON  },  // BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
  { 0x2565, BIDI_ON  },  // BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
  { 0x2566, BIDI_ON  },  // BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
  { 0x2567, BIDI_ON  },  // BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
  { 0x2568, BIDI_ON  },  // BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
  { 0x2569, BIDI_ON  },  // BOX DRAWINGS DOUBLE UP AND HORIZONTAL
  { 0x256A, BIDI_ON  },  // BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
  { 0x256B, BIDI_ON  },  // BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
  { 0x256C, BIDI_ON  },  // BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
  { 0x256D, BIDI_ON  },  // BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
  { 0x256E, BIDI_ON  },  // BOX DRAWINGS LIGHT ARC DOWN AND LEFT
  { 0x256F, BIDI_ON  },  // BOX DRAWINGS LIGHT ARC UP AND LEFT
  { 0x2570, BIDI_ON  },  // BOX DRAWINGS LIGHT ARC UP AND RIGHT
  { 0x2571, BIDI_ON  },  // BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
  { 0x2572, BIDI_ON  },  // BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
  { 0x2573, BIDI_ON  },  // BOX DRAWINGS LIGHT DIAGONAL CROSS
  { 0x2574, BIDI_ON  },  // BOX DRAWINGS LIGHT LEFT
  { 0x2575, BIDI_ON  },  // BOX DRAWINGS LIGHT UP
  { 0x2576, BIDI_ON  },  // BOX DRAWINGS LIGHT RIGHT
  { 0x2577, BIDI_ON  },  // BOX DRAWINGS LIGHT DOWN
  { 0x2578, BIDI_ON  },  // BOX DRAWINGS HEAVY LEFT
  { 0x2579, BIDI_ON  },  // BOX DRAWINGS HEAVY UP
  { 0x257A, BIDI_ON  },  // BOX DRAWINGS HEAVY RIGHT
  { 0x257B, BIDI_ON  },  // BOX DRAWINGS HEAVY DOWN
  { 0x257C, BIDI_ON  },  // BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT
  { 0x257D, BIDI_ON  },  // BOX DRAWINGS LIGHT UP AND HEAVY DOWN
  { 0x257E, BIDI_ON  },  // BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT
  { 0x257F, BIDI_ON  },  // BOX DRAWINGS HEAVY UP AND LIGHT DOWN
  { 0x2580, BIDI_ON  },  // UPPER HALF BLOCK
  { 0x2581, BIDI_ON  },  // LOWER ONE EIGHTH BLOCK
  { 0x2582, BIDI_ON  },  // LOWER ONE QUARTER BLOCK
  { 0x2583, BIDI_ON  },  // LOWER THREE EIGHTHS BLOCK
  { 0x2584, BIDI_ON  },  // LOWER HALF BLOCK
  { 0x2585, BIDI_ON  },  // LOWER FIVE EIGHTHS BLOCK
  { 0x2586, BIDI_ON  },  // LOWER THREE QUARTERS BLOCK
  { 0x2587, BIDI_ON  },  // LOWER SEVEN EIGHTHS BLOCK
  { 0x2588, BIDI_ON  },  // FULL BLOCK
  { 0x2589, BIDI_ON  },  // LEFT SEVEN EIGHTHS BLOCK
  { 0x258A, BIDI_ON  },  // LEFT THREE QUARTERS BLOCK
  { 0x258B, BIDI_ON  },  // LEFT FIVE EIGHTHS BLOCK
  { 0x258C, BIDI_ON  },  // LEFT HALF BLOCK
  { 0x258D, BIDI_ON  },  // LEFT THREE EIGHTHS BLOCK
  { 0x258E, BIDI_ON  },  // LEFT ONE QUARTER BLOCK
  { 0x258F, BIDI_ON  },  // LEFT ONE EIGHTH BLOCK
  { 0x2590, BIDI_ON  },  // RIGHT HALF BLOCK
  { 0x2591, BIDI_ON  },  // LIGHT SHADE
  { 0x2592, BIDI_ON  },  // MEDIUM SHADE
  { 0x2593, BIDI_ON  },  // DARK SHADE
  { 0x2594, BIDI_ON  },  // UPPER ONE EIGHTH BLOCK
  { 0x2595, BIDI_ON  },  // RIGHT ONE EIGHTH BLOCK
  { 0x2596, BIDI_ON  },  // QUADRANT LOWER LEFT
  { 0x2597, BIDI_ON  },  // QUADRANT LOWER RIGHT
  { 0x2598, BIDI_ON  },  // QUADRANT UPPER LEFT
  { 0x2599, BIDI_ON  },  // QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT
  { 0x259A, BIDI_ON  },  // QUADRANT UPPER LEFT AND LOWER RIGHT
  { 0x259B, BIDI_ON  },  // QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT
  { 0x259C, BIDI_ON  },  // QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT
  { 0x259D, BIDI_ON  },  // QUADRANT UPPER RIGHT
  { 0x259E, BIDI_ON  },  // QUADRANT UPPER RIGHT AND LOWER LEFT
  { 0x259F, BIDI_ON  },  // QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT
  { 0x25A0, BIDI_ON  },  // BLACK SQUARE
  { 0x25A1, BIDI_ON  },  // WHITE SQUARE
  { 0x25A2, BIDI_ON  },  // WHITE SQUARE WITH ROUNDED CORNERS
  { 0x25A3, BIDI_ON  },  // WHITE SQUARE CONTAINING BLACK SMALL SQUARE
  { 0x25A4, BIDI_ON  },  // SQUARE WITH HORIZONTAL FILL
  { 0x25A5, BIDI_ON  },  // SQUARE WITH VERTICAL FILL
  { 0x25A6, BIDI_ON  },  // SQUARE WITH ORTHOGONAL CROSSHATCH FILL
  { 0x25A7, BIDI_ON  },  // SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
  { 0x25A8, BIDI_ON  },  // SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
  { 0x25A9, BIDI_ON  },  // SQUARE WITH DIAGONAL CROSSHATCH FILL
  { 0x25AA, BIDI_ON  },  // BLACK SMALL SQUARE
  { 0x25AB, BIDI_ON  },  // WHITE SMALL SQUARE
  { 0x25AC, BIDI_ON  },  // BLACK RECTANGLE
  { 0x25AD, BIDI_ON  },  // WHITE RECTANGLE
  { 0x25AE, BIDI_ON  },  // BLACK VERTICAL RECTANGLE
  { 0x25AF, BIDI_ON  },  // WHITE VERTICAL RECTANGLE
  { 0x25B0, BIDI_ON  },  // BLACK PARALLELOGRAM
  { 0x25B1, BIDI_ON  },  // WHITE PARALLELOGRAM
  { 0x25B2, BIDI_ON  },  // BLACK UP-POINTING TRIANGLE
  { 0x25B3, BIDI_ON  },  // WHITE UP-POINTING TRIANGLE
  { 0x25B4, BIDI_ON  },  // BLACK UP-POINTING SMALL TRIANGLE
  { 0x25B5, BIDI_ON  },  // WHITE UP-POINTING SMALL TRIANGLE
  { 0x25B6, BIDI_ON  },  // BLACK RIGHT-POINTING TRIANGLE
  { 0x25B7, BIDI_ON  },  // WHITE RIGHT-POINTING TRIANGLE
  { 0x25B8, BIDI_ON  },  // BLACK RIGHT-POINTING SMALL TRIANGLE
  { 0x25B9, BIDI_ON  },  // WHITE RIGHT-POINTING SMALL TRIANGLE
  { 0x25BA, BIDI_ON  },  // BLACK RIGHT-POINTING POINTER
  { 0x25BB, BIDI_ON  },  // WHITE RIGHT-POINTING POINTER
  { 0x25BC, BIDI_ON  },  // BLACK DOWN-POINTING TRIANGLE
  { 0x25BD, BIDI_ON  },  // WHITE DOWN-POINTING TRIANGLE
  { 0x25BE, BIDI_ON  },  // BLACK DOWN-POINTING SMALL TRIANGLE
  { 0x25BF, BIDI_ON  },  // WHITE DOWN-POINTING SMALL TRIANGLE
  { 0x25C0, BIDI_ON  },  // BLACK LEFT-POINTING TRIANGLE
  { 0x25C1, BIDI_ON  },  // WHITE LEFT-POINTING TRIANGLE
  { 0x25C2, BIDI_ON  },  // BLACK LEFT-POINTING SMALL TRIANGLE
  { 0x25C3, BIDI_ON  },  // WHITE LEFT-POINTING SMALL TRIANGLE
  { 0x25C4, BIDI_ON  },  // BLACK LEFT-POINTING POINTER
  { 0x25C5, BIDI_ON  },  // WHITE LEFT-POINTING POINTER
  { 0x25C6, BIDI_ON  },  // BLACK DIAMOND
  { 0x25C7, BIDI_ON  },  // WHITE DIAMOND
  { 0x25C8, BIDI_ON  },  // WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
  { 0x25C9, BIDI_ON  },  // FISHEYE
  { 0x25CA, BIDI_ON  },  // LOZENGE
  { 0x25CB, BIDI_ON  },  // WHITE CIRCLE
  { 0x25CC, BIDI_ON  },  // DOTTED CIRCLE
  { 0x25CD, BIDI_ON  },  // CIRCLE WITH VERTICAL FILL
  { 0x25CE, BIDI_ON  },  // BULLSEYE
  { 0x25CF, BIDI_ON  },  // BLACK CIRCLE
  { 0x25D0, BIDI_ON  },  // CIRCLE WITH LEFT HALF BLACK
  { 0x25D1, BIDI_ON  },  // CIRCLE WITH RIGHT HALF BLACK
  { 0x25D2, BIDI_ON  },  // CIRCLE WITH LOWER HALF BLACK
  { 0x25D3, BIDI_ON  },  // CIRCLE WITH UPPER HALF BLACK
  { 0x25D4, BIDI_ON  },  // CIRCLE WITH UPPER RIGHT QUADRANT BLACK
  { 0x25D5, BIDI_ON  },  // CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK
  { 0x25D6, BIDI_ON  },  // LEFT HALF BLACK CIRCLE
  { 0x25D7, BIDI_ON  },  // RIGHT HALF BLACK CIRCLE
  { 0x25D8, BIDI_ON  },  // INVERSE BULLET
  { 0x25D9, BIDI_ON  },  // INVERSE WHITE CIRCLE
  { 0x25DA, BIDI_ON  },  // UPPER HALF INVERSE WHITE CIRCLE
  { 0x25DB, BIDI_ON  },  // LOWER HALF INVERSE WHITE CIRCLE
  { 0x25DC, BIDI_ON  },  // UPPER LEFT QUADRANT CIRCULAR ARC
  { 0x25DD, BIDI_ON  },  // UPPER RIGHT QUADRANT CIRCULAR ARC
  { 0x25DE, BIDI_ON  },  // LOWER RIGHT QUADRANT CIRCULAR ARC
  { 0x25DF, BIDI_ON  },  // LOWER LEFT QUADRANT CIRCULAR ARC
  { 0x25E0, BIDI_ON  },  // UPPER HALF CIRCLE
  { 0x25E1, BIDI_ON  },  // LOWER HALF CIRCLE
  { 0x25E2, BIDI_ON  },  // BLACK LOWER RIGHT TRIANGLE
  { 0x25E3, BIDI_ON  },  // BLACK LOWER LEFT TRIANGLE
  { 0x25E4, BIDI_ON  },  // BLACK UPPER LEFT TRIANGLE
  { 0x25E5, BIDI_ON  },  // BLACK UPPER RIGHT TRIANGLE
  { 0x25E6, BIDI_ON  },  // WHITE BULLET
  { 0x25E7, BIDI_ON  },  // SQUARE WITH LEFT HALF BLACK
  { 0x25E8, BIDI_ON  },  // SQUARE WITH RIGHT HALF BLACK
  { 0x25E9, BIDI_ON  },  // SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK
  { 0x25EA, BIDI_ON  },  // SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK
  { 0x25EB, BIDI_ON  },  // WHITE SQUARE WITH VERTICAL BISECTING LINE
  { 0x25EC, BIDI_ON  },  // WHITE UP-POINTING TRIANGLE WITH DOT
  { 0x25ED, BIDI_ON  },  // UP-POINTING TRIANGLE WITH LEFT HALF BLACK
  { 0x25EE, BIDI_ON  },  // UP-POINTING TRIANGLE WITH RIGHT HALF BLACK
  { 0x25EF, BIDI_ON  },  // LARGE CIRCLE
  { 0x25F0, BIDI_ON  },  // WHITE SQUARE WITH UPPER LEFT QUADRANT
  { 0x25F1, BIDI_ON  },  // WHITE SQUARE WITH LOWER LEFT QUADRANT
  { 0x25F2, BIDI_ON  },  // WHITE SQUARE WITH LOWER RIGHT QUADRANT
  { 0x25F3, BIDI_ON  },  // WHITE SQUARE WITH UPPER RIGHT QUADRANT
  { 0x25F4, BIDI_ON  },  // WHITE CIRCLE WITH UPPER LEFT QUADRANT
  { 0x25F5, BIDI_ON  },  // WHITE CIRCLE WITH LOWER LEFT QUADRANT
  { 0x25F6, BIDI_ON  },  // WHITE CIRCLE WITH LOWER RIGHT QUADRANT
  { 0x25F7, BIDI_ON  },  // WHITE CIRCLE WITH UPPER RIGHT QUADRANT
  { 0x25F8, BIDI_ON  },  // UPPER LEFT TRIANGLE
  { 0x25F9, BIDI_ON  },  // UPPER RIGHT TRIANGLE
  { 0x25FA, BIDI_ON  },  // LOWER LEFT TRIANGLE
  { 0x25FB, BIDI_ON  },  // WHITE MEDIUM SQUARE
  { 0x25FC, BIDI_ON  },  // BLACK MEDIUM SQUARE
  { 0x25FD, BIDI_ON  },  // WHITE MEDIUM SMALL SQUARE
  { 0x25FE, BIDI_ON  },  // BLACK MEDIUM SMALL SQUARE
  { 0x25FF, BIDI_ON  },  // LOWER RIGHT TRIANGLE
  { 0x2600, BIDI_ON  },  // BLACK SUN WITH RAYS
  { 0x2601, BIDI_ON  },  // CLOUD
  { 0x2602, BIDI_ON  },  // UMBRELLA
  { 0x2603, BIDI_ON  },  // SNOWMAN
  { 0x2604, BIDI_ON  },  // COMET
  { 0x2605, BIDI_ON  },  // BLACK STAR
  { 0x2606, BIDI_ON  },  // WHITE STAR
  { 0x2607, BIDI_ON  },  // LIGHTNING
  { 0x2608, BIDI_ON  },  // THUNDERSTORM
  { 0x2609, BIDI_ON  },  // SUN
  { 0x260A, BIDI_ON  },  // ASCENDING NODE
  { 0x260B, BIDI_ON  },  // DESCENDING NODE
  { 0x260C, BIDI_ON  },  // CONJUNCTION
  { 0x260D, BIDI_ON  },  // OPPOSITION
  { 0x260E, BIDI_ON  },  // BLACK TELEPHONE
  { 0x260F, BIDI_ON  },  // WHITE TELEPHONE
  { 0x2610, BIDI_ON  },  // BALLOT BOX
  { 0x2611, BIDI_ON  },  // BALLOT BOX WITH CHECK
  { 0x2612, BIDI_ON  },  // BALLOT BOX WITH X
  { 0x2613, BIDI_ON  },  // SALTIRE
  { 0x2614, BIDI_ON  },  // UMBRELLA WITH RAIN DROPS
  { 0x2615, BIDI_ON  },  // HOT BEVERAGE
  { 0x2616, BIDI_ON  },  // WHITE SHOGI PIECE
  { 0x2617, BIDI_ON  },  // BLACK SHOGI PIECE
  { 0x2618, BIDI_ON  },  // SHAMROCK
  { 0x2619, BIDI_ON  },  // REVERSED ROTATED FLORAL HEART BULLET
  { 0x261A, BIDI_ON  },  // BLACK LEFT POINTING INDEX
  { 0x261B, BIDI_ON  },  // BLACK RIGHT POINTING INDEX
  { 0x261C, BIDI_ON  },  // WHITE LEFT POINTING INDEX
  { 0x261D, BIDI_ON  },  // WHITE UP POINTING INDEX
  { 0x261E, BIDI_ON  },  // WHITE RIGHT POINTING INDEX
  { 0x261F, BIDI_ON  },  // WHITE DOWN POINTING INDEX
  { 0x2620, BIDI_ON  },  // SKULL AND CROSSBONES
  { 0x2621, BIDI_ON  },  // CAUTION SIGN
  { 0x2622, BIDI_ON  },  // RADIOACTIVE SIGN
  { 0x2623, BIDI_ON  },  // BIOHAZARD SIGN
  { 0x2624, BIDI_ON  },  // CADUCEUS
  { 0x2625, BIDI_ON  },  // ANKH
  { 0x2626, BIDI_ON  },  // ORTHODOX CROSS
  { 0x2627, BIDI_ON  },  // CHI RHO
  { 0x2628, BIDI_ON  },  // CROSS OF LORRAINE
  { 0x2629, BIDI_ON  },  // CROSS OF JERUSALEM
  { 0x262A, BIDI_ON  },  // STAR AND CRESCENT
  { 0x262B, BIDI_ON  },  // FARSI SYMBOL
  { 0x262C, BIDI_ON  },  // ADI SHAKTI
  { 0x262D, BIDI_ON  },  // HAMMER AND SICKLE
  { 0x262E, BIDI_ON  },  // PEACE SYMBOL
  { 0x262F, BIDI_ON  },  // YIN YANG
  { 0x2630, BIDI_ON  },  // TRIGRAM FOR HEAVEN
  { 0x2631, BIDI_ON  },  // TRIGRAM FOR LAKE
  { 0x2632, BIDI_ON  },  // TRIGRAM FOR FIRE
  { 0x2633, BIDI_ON  },  // TRIGRAM FOR THUNDER
  { 0x2634, BIDI_ON  },  // TRIGRAM FOR WIND
  { 0x2635, BIDI_ON  },  // TRIGRAM FOR WATER
  { 0x2636, BIDI_ON  },  // TRIGRAM FOR MOUNTAIN
  { 0x2637, BIDI_ON  },  // TRIGRAM FOR EARTH
  { 0x2638, BIDI_ON  },  // WHEEL OF DHARMA
  { 0x2639, BIDI_ON  },  // WHITE FROWNING FACE
  { 0x263A, BIDI_ON  },  // WHITE SMILING FACE
  { 0x263B, BIDI_ON  },  // BLACK SMILING FACE
  { 0x263C, BIDI_ON  },  // WHITE SUN WITH RAYS
  { 0x263D, BIDI_ON  },  // FIRST QUARTER MOON
  { 0x263E, BIDI_ON  },  // LAST QUARTER MOON
  { 0x263F, BIDI_ON  },  // MERCURY
  { 0x2640, BIDI_ON  },  // FEMALE SIGN
  { 0x2641, BIDI_ON  },  // EARTH
  { 0x2642, BIDI_ON  },  // MALE SIGN
  { 0x2643, BIDI_ON  },  // JUPITER
  { 0x2644, BIDI_ON  },  // SATURN
  { 0x2645, BIDI_ON  },  // URANUS
  { 0x2646, BIDI_ON  },  // NEPTUNE
  { 0x2647, BIDI_ON  },  // PLUTO
  { 0x2648, BIDI_ON  },  // ARIES
  { 0x2649, BIDI_ON  },  // TAURUS
  { 0x264A, BIDI_ON  },  // GEMINI
  { 0x264B, BIDI_ON  },  // CANCER
  { 0x264C, BIDI_ON  },  // LEO
  { 0x264D, BIDI_ON  },  // VIRGO
  { 0x264E, BIDI_ON  },  // LIBRA
  { 0x264F, BIDI_ON  },  // SCORPIUS
  { 0x2650, BIDI_ON  },  // SAGITTARIUS
  { 0x2651, BIDI_ON  },  // CAPRICORN
  { 0x2652, BIDI_ON  },  // AQUARIUS
  { 0x2653, BIDI_ON  },  // PISCES
  { 0x2654, BIDI_ON  },  // WHITE CHESS KING
  { 0x2655, BIDI_ON  },  // WHITE CHESS QUEEN
  { 0x2656, BIDI_ON  },  // WHITE CHESS ROOK
  { 0x2657, BIDI_ON  },  // WHITE CHESS BISHOP
  { 0x2658, BIDI_ON  },  // WHITE CHESS KNIGHT
  { 0x2659, BIDI_ON  },  // WHITE CHESS PAWN
  { 0x265A, BIDI_ON  },  // BLACK CHESS KING
  { 0x265B, BIDI_ON  },  // BLACK CHESS QUEEN
  { 0x265C, BIDI_ON  },  // BLACK CHESS ROOK
  { 0x265D, BIDI_ON  },  // BLACK CHESS BISHOP
  { 0x265E, BIDI_ON  },  // BLACK CHESS KNIGHT
  { 0x265F, BIDI_ON  },  // BLACK CHESS PAWN
  { 0x2660, BIDI_ON  },  // BLACK SPADE SUIT
  { 0x2661, BIDI_ON  },  // WHITE HEART SUIT
  { 0x2662, BIDI_ON  },  // WHITE DIAMOND SUIT
  { 0x2663, BIDI_ON  },  // BLACK CLUB SUIT
  { 0x2664, BIDI_ON  },  // WHITE SPADE SUIT
  { 0x2665, BIDI_ON  },  // BLACK HEART SUIT
  { 0x2666, BIDI_ON  },  // BLACK DIAMOND SUIT
  { 0x2667, BIDI_ON  },  // WHITE CLUB SUIT
  { 0x2668, BIDI_ON  },  // HOT SPRINGS
  { 0x2669, BIDI_ON  },  // QUARTER NOTE
  { 0x266A, BIDI_ON  },  // EIGHTH NOTE
  { 0x266B, BIDI_ON  },  // BEAMED EIGHTH NOTES
  { 0x266C, BIDI_ON  },  // BEAMED SIXTEENTH NOTES
  { 0x266D, BIDI_ON  },  // MUSIC FLAT SIGN
  { 0x266E, BIDI_ON  },  // MUSIC NATURAL SIGN
  { 0x266F, BIDI_ON  },  // MUSIC SHARP SIGN
  { 0x2670, BIDI_ON  },  // WEST SYRIAC CROSS
  { 0x2671, BIDI_ON  },  // EAST SYRIAC CROSS
  { 0x2672, BIDI_ON  },  // UNIVERSAL RECYCLING SYMBOL
  { 0x2673, BIDI_ON  },  // RECYCLING SYMBOL FOR TYPE-1 PLASTICS
  { 0x2674, BIDI_ON  },  // RECYCLING SYMBOL FOR TYPE-2 PLASTICS
  { 0x2675, BIDI_ON  },  // RECYCLING SYMBOL FOR TYPE-3 PLASTICS
  { 0x2676, BIDI_ON  },  // RECYCLING SYMBOL FOR TYPE-4 PLASTICS
  { 0x2677, BIDI_ON  },  // RECYCLING SYMBOL FOR TYPE-5 PLASTICS
  { 0x2678, BIDI_ON  },  // RECYCLING SYMBOL FOR TYPE-6 PLASTICS
  { 0x2679, BIDI_ON  },  // RECYCLING SYMBOL FOR TYPE-7 PLASTICS
  { 0x267A, BIDI_ON  },  // RECYCLING SYMBOL FOR GENERIC MATERIALS
  { 0x267B, BIDI_ON  },  // BLACK UNIVERSAL RECYCLING SYMBOL
  { 0x267C, BIDI_ON  },  // RECYCLED PAPER SYMBOL
  { 0x267D, BIDI_ON  },  // PARTIALLY-RECYCLED PAPER SYMBOL
  { 0x267E, BIDI_ON  },  // PERMANENT PAPER SIGN
  { 0x267F, BIDI_ON  },  // WHEELCHAIR SYMBOL
  { 0x2680, BIDI_ON  },  // DIE FACE-1
  { 0x2681, BIDI_ON  },  // DIE FACE-2
  { 0x2682, BIDI_ON  },  // DIE FACE-3
  { 0x2683, BIDI_ON  },  // DIE FACE-4
  { 0x2684, BIDI_ON  },  // DIE FACE-5
  { 0x2685, BIDI_ON  },  // DIE FACE-6
  { 0x2686, BIDI_ON  },  // WHITE CIRCLE WITH DOT RIGHT
  { 0x2687, BIDI_ON  },  // WHITE CIRCLE WITH TWO DOTS
  { 0x2688, BIDI_ON  },  // BLACK CIRCLE WITH WHITE DOT RIGHT
  { 0x2689, BIDI_ON  },  // BLACK CIRCLE WITH TWO WHITE DOTS
  { 0x268A, BIDI_ON  },  // MONOGRAM FOR YANG
  { 0x268B, BIDI_ON  },  // MONOGRAM FOR YIN
  { 0x268C, BIDI_ON  },  // DIGRAM FOR GREATER YANG
  { 0x268D, BIDI_ON  },  // DIGRAM FOR LESSER YIN
  { 0x268E, BIDI_ON  },  // DIGRAM FOR LESSER YANG
  { 0x268F, BIDI_ON  },  // DIGRAM FOR GREATER YIN
  { 0x2690, BIDI_ON  },  // WHITE FLAG
  { 0x2691, BIDI_ON  },  // BLACK FLAG
  { 0x2692, BIDI_ON  },  // HAMMER AND PICK
  { 0x2693, BIDI_ON  },  // ANCHOR
  { 0x2694, BIDI_ON  },  // CROSSED SWORDS
  { 0x2695, BIDI_ON  },  // STAFF OF AESCULAPIUS
  { 0x2696, BIDI_ON  },  // SCALES
  { 0x2697, BIDI_ON  },  // ALEMBIC
  { 0x2698, BIDI_ON  },  // FLOWER
  { 0x2699, BIDI_ON  },  // GEAR
  { 0x269A, BIDI_ON  },  // STAFF OF HERMES
  { 0x269B, BIDI_ON  },  // ATOM SYMBOL
  { 0x269C, BIDI_ON  },  // FLEUR-DE-LIS
  { 0x269D, BIDI_ON  },  // OUTLINED WHITE STAR
  { 0x269E, BIDI_ON  },  // THREE LINES CONVERGING RIGHT
  { 0x269F, BIDI_ON  },  // THREE LINES CONVERGING LEFT
  { 0x26A0, BIDI_ON  },  // WARNING SIGN
  { 0x26A1, BIDI_ON  },  // HIGH VOLTAGE SIGN
  { 0x26A2, BIDI_ON  },  // DOUBLED FEMALE SIGN
  { 0x26A3, BIDI_ON  },  // DOUBLED MALE SIGN
  { 0x26A4, BIDI_ON  },  // INTERLOCKED FEMALE AND MALE SIGN
  { 0x26A5, BIDI_ON  },  // MALE AND FEMALE SIGN
  { 0x26A6, BIDI_ON  },  // MALE WITH STROKE SIGN
  { 0x26A7, BIDI_ON  },  // MALE WITH STROKE AND MALE AND FEMALE SIGN
  { 0x26A8, BIDI_ON  },  // VERTICAL MALE WITH STROKE SIGN
  { 0x26A9, BIDI_ON  },  // HORIZONTAL MALE WITH STROKE SIGN
  { 0x26AA, BIDI_ON  },  // MEDIUM WHITE CIRCLE
  { 0x26AB, BIDI_ON  },  // MEDIUM BLACK CIRCLE
  { 0x26AC, BIDI_L   },  // MEDIUM SMALL WHITE CIRCLE
  { 0x26AD, BIDI_ON  },  // MARRIAGE SYMBOL
  { 0x26AE, BIDI_ON  },  // DIVORCE SYMBOL
  { 0x26AF, BIDI_ON  },  // UNMARRIED PARTNERSHIP SYMBOL
  { 0x26B0, BIDI_ON  },  // COFFIN
  { 0x26B1, BIDI_ON  },  // FUNERAL URN
  { 0x26B2, BIDI_ON  },  // NEUTER
  { 0x26B3, BIDI_ON  },  // CERES
  { 0x26B4, BIDI_ON  },  // PALLAS
  { 0x26B5, BIDI_ON  },  // JUNO
  { 0x26B6, BIDI_ON  },  // VESTA
  { 0x26B7, BIDI_ON  },  // CHIRON
  { 0x26B8, BIDI_ON  },  // BLACK MOON LILITH
  { 0x26B9, BIDI_ON  },  // SEXTILE
  { 0x26BA, BIDI_ON  },  // SEMISEXTILE
  { 0x26BB, BIDI_ON  },  // QUINCUNX
  { 0x26BC, BIDI_ON  },  // SESQUIQUADRATE
  { 0x26BD, BIDI_ON  },  // SOCCER BALL
  { 0x26BE, BIDI_ON  },  // BASEBALL
  { 0x26BF, BIDI_ON  },  // SQUARED KEY
  { 0x26C0, BIDI_ON  },  // WHITE DRAUGHTS MAN
  { 0x26C1, BIDI_ON  },  // WHITE DRAUGHTS KING
  { 0x26C2, BIDI_ON  },  // BLACK DRAUGHTS MAN
  { 0x26C3, BIDI_ON  },  // BLACK DRAUGHTS KING
  { 0x26C4, BIDI_ON  },  // SNOWMAN WITHOUT SNOW
  { 0x26C5, BIDI_ON  },  // SUN BEHIND CLOUD
  { 0x26C6, BIDI_ON  },  // RAIN
  { 0x26C7, BIDI_ON  },  // BLACK SNOWMAN
  { 0x26C8, BIDI_ON  },  // THUNDER CLOUD AND RAIN
  { 0x26C9, BIDI_ON  },  // TURNED WHITE SHOGI PIECE
  { 0x26CA, BIDI_ON  },  // TURNED BLACK SHOGI PIECE
  { 0x26CB, BIDI_ON  },  // WHITE DIAMOND IN SQUARE
  { 0x26CC, BIDI_ON  },  // CROSSING LANES
  { 0x26CD, BIDI_ON  },  // DISABLED CAR
  { 0x26CE, BIDI_ON  },  // OPHIUCHUS
  { 0x26CF, BIDI_ON  },  // PICK
  { 0x26D0, BIDI_ON  },  // CAR SLIDING
  { 0x26D1, BIDI_ON  },  // HELMET WITH WHITE CROSS
  { 0x26D2, BIDI_ON  },  // CIRCLED CROSSING LANES
  { 0x26D3, BIDI_ON  },  // CHAINS
  { 0x26D4, BIDI_ON  },  // NO ENTRY
  { 0x26D5, BIDI_ON  },  // ALTERNATE ONE-WAY LEFT WAY TRAFFIC
  { 0x26D6, BIDI_ON  },  // BLACK TWO-WAY LEFT WAY TRAFFIC
  { 0x26D7, BIDI_ON  },  // WHITE TWO-WAY LEFT WAY TRAFFIC
  { 0x26D8, BIDI_ON  },  // BLACK LEFT LANE MERGE
  { 0x26D9, BIDI_ON  },  // WHITE LEFT LANE MERGE
  { 0x26DA, BIDI_ON  },  // DRIVE SLOW SIGN
  { 0x26DB, BIDI_ON  },  // HEAVY WHITE DOWN-POINTING TRIANGLE
  { 0x26DC, BIDI_ON  },  // LEFT CLOSED ENTRY
  { 0x26DD, BIDI_ON  },  // SQUARED SALTIRE
  { 0x26DE, BIDI_ON  },  // FALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE
  { 0x26DF, BIDI_ON  },  // BLACK TRUCK
  { 0x26E0, BIDI_ON  },  // RESTRICTED LEFT ENTRY-1
  { 0x26E1, BIDI_ON  },  // RESTRICTED LEFT ENTRY-2
  { 0x26E2, BIDI_ON  },  // ASTRONOMICAL SYMBOL FOR URANUS
  { 0x26E3, BIDI_ON  },  // HEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVE
  { 0x26E4, BIDI_ON  },  // PENTAGRAM
  { 0x26E5, BIDI_ON  },  // RIGHT-HANDED INTERLACED PENTAGRAM
  { 0x26E6, BIDI_ON  },  // LEFT-HANDED INTERLACED PENTAGRAM
  { 0x26E7, BIDI_ON  },  // INVERTED PENTAGRAM
  { 0x26E8, BIDI_ON  },  // BLACK CROSS ON SHIELD
  { 0x26E9, BIDI_ON  },  // SHINTO SHRINE
  { 0x26EA, BIDI_ON  },  // CHURCH
  { 0x26EB, BIDI_ON  },  // CASTLE
  { 0x26EC, BIDI_ON  },  // HISTORIC SITE
  { 0x26ED, BIDI_ON  },  // GEAR WITHOUT HUB
  { 0x26EE, BIDI_ON  },  // GEAR WITH HANDLES
  { 0x26EF, BIDI_ON  },  // MAP SYMBOL FOR LIGHTHOUSE
  { 0x26F0, BIDI_ON  },  // MOUNTAIN
  { 0x26F1, BIDI_ON  },  // UMBRELLA ON GROUND
  { 0x26F2, BIDI_ON  },  // FOUNTAIN
  { 0x26F3, BIDI_ON  },  // FLAG IN HOLE
  { 0x26F4, BIDI_ON  },  // FERRY
  { 0x26F5, BIDI_ON  },  // SAILBOAT
  { 0x26F6, BIDI_ON  },  // SQUARE FOUR CORNERS
  { 0x26F7, BIDI_ON  },  // SKIER
  { 0x26F8, BIDI_ON  },  // ICE SKATE
  { 0x26F9, BIDI_ON  },  // PERSON WITH BALL
  { 0x26FA, BIDI_ON  },  // TENT
  { 0x26FB, BIDI_ON  },  // JAPANESE BANK SYMBOL
  { 0x26FC, BIDI_ON  },  // HEADSTONE GRAVEYARD SYMBOL
  { 0x26FD, BIDI_ON  },  // FUEL PUMP
  { 0x26FE, BIDI_ON  },  // CUP ON BLACK SQUARE
  { 0x26FF, BIDI_ON  },  // WHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPE
  { 0x2700, BIDI_ON  },  // BLACK SAFETY SCISSORS
  { 0x2701, BIDI_ON  },  // UPPER BLADE SCISSORS
  { 0x2702, BIDI_ON  },  // BLACK SCISSORS
  { 0x2703, BIDI_ON  },  // LOWER BLADE SCISSORS
  { 0x2704, BIDI_ON  },  // WHITE SCISSORS
  { 0x2705, BIDI_ON  },  // WHITE HEAVY CHECK MARK
  { 0x2706, BIDI_ON  },  // TELEPHONE LOCATION SIGN
  { 0x2707, BIDI_ON  },  // TAPE DRIVE
  { 0x2708, BIDI_ON  },  // AIRPLANE
  { 0x2709, BIDI_ON  },  // ENVELOPE
  { 0x270A, BIDI_ON  },  // RAISED FIST
  { 0x270B, BIDI_ON  },  // RAISED HAND
  { 0x270C, BIDI_ON  },  // VICTORY HAND
  { 0x270D, BIDI_ON  },  // WRITING HAND
  { 0x270E, BIDI_ON  },  // LOWER RIGHT PENCIL
  { 0x270F, BIDI_ON  },  // PENCIL
  { 0x2710, BIDI_ON  },  // UPPER RIGHT PENCIL
  { 0x2711, BIDI_ON  },  // WHITE NIB
  { 0x2712, BIDI_ON  },  // BLACK NIB
  { 0x2713, BIDI_ON  },  // CHECK MARK
  { 0x2714, BIDI_ON  },  // HEAVY CHECK MARK
  { 0x2715, BIDI_ON  },  // MULTIPLICATION X
  { 0x2716, BIDI_ON  },  // HEAVY MULTIPLICATION X
  { 0x2717, BIDI_ON  },  // BALLOT X
  { 0x2718, BIDI_ON  },  // HEAVY BALLOT X
  { 0x2719, BIDI_ON  },  // OUTLINED GREEK CROSS
  { 0x271A, BIDI_ON  },  // HEAVY GREEK CROSS
  { 0x271B, BIDI_ON  },  // OPEN CENTRE CROSS
  { 0x271C, BIDI_ON  },  // HEAVY OPEN CENTRE CROSS
  { 0x271D, BIDI_ON  },  // LATIN CROSS
  { 0x271E, BIDI_ON  },  // SHADOWED WHITE LATIN CROSS
  { 0x271F, BIDI_ON  },  // OUTLINED LATIN CROSS
  { 0x2720, BIDI_ON  },  // MALTESE CROSS
  { 0x2721, BIDI_ON  },  // STAR OF DAVID
  { 0x2722, BIDI_ON  },  // FOUR TEARDROP-SPOKED ASTERISK
  { 0x2723, BIDI_ON  },  // FOUR BALLOON-SPOKED ASTERISK
  { 0x2724, BIDI_ON  },  // HEAVY FOUR BALLOON-SPOKED ASTERISK
  { 0x2725, BIDI_ON  },  // FOUR CLUB-SPOKED ASTERISK
  { 0x2726, BIDI_ON  },  // BLACK FOUR POINTED STAR
  { 0x2727, BIDI_ON  },  // WHITE FOUR POINTED STAR
  { 0x2728, BIDI_ON  },  // SPARKLES
  { 0x2729, BIDI_ON  },  // STRESS OUTLINED WHITE STAR
  { 0x272A, BIDI_ON  },  // CIRCLED WHITE STAR
  { 0x272B, BIDI_ON  },  // OPEN CENTRE BLACK STAR
  { 0x272C, BIDI_ON  },  // BLACK CENTRE WHITE STAR
  { 0x272D, BIDI_ON  },  // OUTLINED BLACK STAR
  { 0x272E, BIDI_ON  },  // HEAVY OUTLINED BLACK STAR
  { 0x272F, BIDI_ON  },  // PINWHEEL STAR
  { 0x2730, BIDI_ON  },  // SHADOWED WHITE STAR
  { 0x2731, BIDI_ON  },  // HEAVY ASTERISK
  { 0x2732, BIDI_ON  },  // OPEN CENTRE ASTERISK
  { 0x2733, BIDI_ON  },  // EIGHT SPOKED ASTERISK
  { 0x2734, BIDI_ON  },  // EIGHT POINTED BLACK STAR
  { 0x2735, BIDI_ON  },  // EIGHT POINTED PINWHEEL STAR
  { 0x2736, BIDI_ON  },  // SIX POINTED BLACK STAR
  { 0x2737, BIDI_ON  },  // EIGHT POINTED RECTILINEAR BLACK STAR
  { 0x2738, BIDI_ON  },  // HEAVY EIGHT POINTED RECTILINEAR BLACK STAR
  { 0x2739, BIDI_ON  },  // TWELVE POINTED BLACK STAR
  { 0x273A, BIDI_ON  },  // SIXTEEN POINTED ASTERISK
  { 0x273B, BIDI_ON  },  // TEARDROP-SPOKED ASTERISK
  { 0x273C, BIDI_ON  },  // OPEN CENTRE TEARDROP-SPOKED ASTERISK
  { 0x273D, BIDI_ON  },  // HEAVY TEARDROP-SPOKED ASTERISK
  { 0x273E, BIDI_ON  },  // SIX PETALLED BLACK AND WHITE FLORETTE
  { 0x273F, BIDI_ON  },  // BLACK FLORETTE
  { 0x2740, BIDI_ON  },  // WHITE FLORETTE
  { 0x2741, BIDI_ON  },  // EIGHT PETALLED OUTLINED BLACK FLORETTE
  { 0x2742, BIDI_ON  },  // CIRCLED OPEN CENTRE EIGHT POINTED STAR
  { 0x2743, BIDI_ON  },  // HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK
  { 0x2744, BIDI_ON  },  // SNOWFLAKE
  { 0x2745, BIDI_ON  },  // TIGHT TRIFOLIATE SNOWFLAKE
  { 0x2746, BIDI_ON  },  // HEAVY CHEVRON SNOWFLAKE
  { 0x2747, BIDI_ON  },  // SPARKLE
  { 0x2748, BIDI_ON  },  // HEAVY SPARKLE
  { 0x2749, BIDI_ON  },  // BALLOON-SPOKED ASTERISK
  { 0x274A, BIDI_ON  },  // EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
  { 0x274B, BIDI_ON  },  // HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
  { 0x274C, BIDI_ON  },  // CROSS MARK
  { 0x274D, BIDI_ON  },  // SHADOWED WHITE CIRCLE
  { 0x274E, BIDI_ON  },  // NEGATIVE SQUARED CROSS MARK
  { 0x274F, BIDI_ON  },  // LOWER RIGHT DROP-SHADOWED WHITE SQUARE
  { 0x2750, BIDI_ON  },  // UPPER RIGHT DROP-SHADOWED WHITE SQUARE
  { 0x2751, BIDI_ON  },  // LOWER RIGHT SHADOWED WHITE SQUARE
  { 0x2752, BIDI_ON  },  // UPPER RIGHT SHADOWED WHITE SQUARE
  { 0x2753, BIDI_ON  },  // BLACK QUESTION MARK ORNAMENT
  { 0x2754, BIDI_ON  },  // WHITE QUESTION MARK ORNAMENT
  { 0x2755, BIDI_ON  },  // WHITE EXCLAMATION MARK ORNAMENT
  { 0x2756, BIDI_ON  },  // BLACK DIAMOND MINUS WHITE X
  { 0x2757, BIDI_ON  },  // HEAVY EXCLAMATION MARK SYMBOL
  { 0x2758, BIDI_ON  },  // LIGHT VERTICAL BAR
  { 0x2759, BIDI_ON  },  // MEDIUM VERTICAL BAR
  { 0x275A, BIDI_ON  },  // HEAVY VERTICAL BAR
  { 0x275B, BIDI_ON  },  // HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT
  { 0x275C, BIDI_ON  },  // HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT
  { 0x275D, BIDI_ON  },  // HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT
  { 0x275E, BIDI_ON  },  // HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT
  { 0x275F, BIDI_ON  },  // HEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENT
  { 0x2760, BIDI_ON  },  // HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT
  { 0x2761, BIDI_ON  },  // CURVED STEM PARAGRAPH SIGN ORNAMENT
  { 0x2762, BIDI_ON  },  // HEAVY EXCLAMATION MARK ORNAMENT
  { 0x2763, BIDI_ON  },  // HEAVY HEART EXCLAMATION MARK ORNAMENT
  { 0x2764, BIDI_ON  },  // HEAVY BLACK HEART
  { 0x2765, BIDI_ON  },  // ROTATED HEAVY BLACK HEART BULLET
  { 0x2766, BIDI_ON  },  // FLORAL HEART
  { 0x2767, BIDI_ON  },  // ROTATED FLORAL HEART BULLET
  { 0x2768, BIDI_ON  },  // MEDIUM LEFT PARENTHESIS ORNAMENT
  { 0x2769, BIDI_ON  },  // MEDIUM RIGHT PARENTHESIS ORNAMENT
  { 0x276A, BIDI_ON  },  // MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
  { 0x276B, BIDI_ON  },  // MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
  { 0x276C, BIDI_ON  },  // MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
  { 0x276D, BIDI_ON  },  // MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
  { 0x276E, BIDI_ON  },  // HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
  { 0x276F, BIDI_ON  },  // HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
  { 0x2770, BIDI_ON  },  // HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
  { 0x2771, BIDI_ON  },  // HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
  { 0x2772, BIDI_ON  },  // LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
  { 0x2773, BIDI_ON  },  // LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
  { 0x2774, BIDI_ON  },  // MEDIUM LEFT CURLY BRACKET ORNAMENT
  { 0x2775, BIDI_ON  },  // MEDIUM RIGHT CURLY BRACKET ORNAMENT
  { 0x2776, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT ONE
  { 0x2777, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT TWO
  { 0x2778, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT THREE
  { 0x2779, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT FOUR
  { 0x277A, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT FIVE
  { 0x277B, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT SIX
  { 0x277C, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT SEVEN
  { 0x277D, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT EIGHT
  { 0x277E, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED DIGIT NINE
  { 0x277F, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED NUMBER TEN
  { 0x2780, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT ONE
  { 0x2781, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT TWO
  { 0x2782, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT THREE
  { 0x2783, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT FOUR
  { 0x2784, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT FIVE
  { 0x2785, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT SIX
  { 0x2786, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN
  { 0x2787, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT
  { 0x2788, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF DIGIT NINE
  { 0x2789, BIDI_ON  },  // DINGBAT CIRCLED SANS-SERIF NUMBER TEN
  { 0x278A, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE
  { 0x278B, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO
  { 0x278C, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE
  { 0x278D, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR
  { 0x278E, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE
  { 0x278F, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX
  { 0x2790, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN
  { 0x2791, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT
  { 0x2792, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE
  { 0x2793, BIDI_ON  },  // DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN
  { 0x2794, BIDI_ON  },  // HEAVY WIDE-HEADED RIGHTWARDS ARROW
  { 0x2795, BIDI_ON  },  // HEAVY PLUS SIGN
  { 0x2796, BIDI_ON  },  // HEAVY MINUS SIGN
  { 0x2797, BIDI_ON  },  // HEAVY DIVISION SIGN
  { 0x2798, BIDI_ON  },  // HEAVY SOUTH EAST ARROW
  { 0x2799, BIDI_ON  },  // HEAVY RIGHTWARDS ARROW
  { 0x279A, BIDI_ON  },  // HEAVY NORTH EAST ARROW
  { 0x279B, BIDI_ON  },  // DRAFTING POINT RIGHTWARDS ARROW
  { 0x279C, BIDI_ON  },  // HEAVY ROUND-TIPPED RIGHTWARDS ARROW
  { 0x279D, BIDI_ON  },  // TRIANGLE-HEADED RIGHTWARDS ARROW
  { 0x279E, BIDI_ON  },  // HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW
  { 0x279F, BIDI_ON  },  // DASHED TRIANGLE-HEADED RIGHTWARDS ARROW
  { 0x27A0, BIDI_ON  },  // HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW
  { 0x27A1, BIDI_ON  },  // BLACK RIGHTWARDS ARROW
  { 0x27A2, BIDI_ON  },  // THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD
  { 0x27A3, BIDI_ON  },  // THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD
  { 0x27A4, BIDI_ON  },  // BLACK RIGHTWARDS ARROWHEAD
  { 0x27A5, BIDI_ON  },  // HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW
  { 0x27A6, BIDI_ON  },  // HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW
  { 0x27A7, BIDI_ON  },  // SQUAT BLACK RIGHTWARDS ARROW
  { 0x27A8, BIDI_ON  },  // HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW
  { 0x27A9, BIDI_ON  },  // RIGHT-SHADED WHITE RIGHTWARDS ARROW
  { 0x27AA, BIDI_ON  },  // LEFT-SHADED WHITE RIGHTWARDS ARROW
  { 0x27AB, BIDI_ON  },  // BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW
  { 0x27AC, BIDI_ON  },  // FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW
  { 0x27AD, BIDI_ON  },  // HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
  { 0x27AE, BIDI_ON  },  // HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
  { 0x27AF, BIDI_ON  },  // NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
  { 0x27B0, BIDI_ON  },  // CURLY LOOP
  { 0x27B1, BIDI_ON  },  // NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
  { 0x27B2, BIDI_ON  },  // CIRCLED HEAVY WHITE RIGHTWARDS ARROW
  { 0x27B3, BIDI_ON  },  // WHITE-FEATHERED RIGHTWARDS ARROW
  { 0x27B4, BIDI_ON  },  // BLACK-FEATHERED SOUTH EAST ARROW
  { 0x27B5, BIDI_ON  },  // BLACK-FEATHERED RIGHTWARDS ARROW
  { 0x27B6, BIDI_ON  },  // BLACK-FEATHERED NORTH EAST ARROW
  { 0x27B7, BIDI_ON  },  // HEAVY BLACK-FEATHERED SOUTH EAST ARROW
  { 0x27B8, BIDI_ON  },  // HEAVY BLACK-FEATHERED RIGHTWARDS ARROW
  { 0x27B9, BIDI_ON  },  // HEAVY BLACK-FEATHERED NORTH EAST ARROW
  { 0x27BA, BIDI_ON  },  // TEARDROP-BARBED RIGHTWARDS ARROW
  { 0x27BB, BIDI_ON  },  // HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW
  { 0x27BC, BIDI_ON  },  // WEDGE-TAILED RIGHTWARDS ARROW
  { 0x27BD, BIDI_ON  },  // HEAVY WEDGE-TAILED RIGHTWARDS ARROW
  { 0x27BE, BIDI_ON  },  // OPEN-OUTLINED RIGHTWARDS ARROW
  { 0x27BF, BIDI_ON  },  // DOUBLE CURLY LOOP
  { 0x27C0, BIDI_ON  },  // THREE DIMENSIONAL ANGLE
  { 0x27C1, BIDI_ON  },  // WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE
  { 0x27C2, BIDI_ON  },  // PERPENDICULAR
  { 0x27C3, BIDI_ON  },  // OPEN SUBSET
  { 0x27C4, BIDI_ON  },  // OPEN SUPERSET
  { 0x27C5, BIDI_ON  },  // LEFT S-SHAPED BAG DELIMITER
  { 0x27C6, BIDI_ON  },  // RIGHT S-SHAPED BAG DELIMITER
  { 0x27C7, BIDI_ON  },  // OR WITH DOT INSIDE
  { 0x27C8, BIDI_ON  },  // REVERSE SOLIDUS PRECEDING SUBSET
  { 0x27C9, BIDI_ON  },  // SUPERSET PRECEDING SOLIDUS
  { 0x27CA, BIDI_ON  },  // VERTICAL BAR WITH HORIZONTAL STROKE
  { 0x27CB, BIDI_ON  },  // MATHEMATICAL RISING DIAGONAL
  { 0x27CC, BIDI_ON  },  // LONG DIVISION
  { 0x27CD, BIDI_ON  },  // MATHEMATICAL FALLING DIAGONAL
  { 0x27CE, BIDI_ON  },  // SQUARED LOGICAL AND
  { 0x27CF, BIDI_ON  },  // SQUARED LOGICAL OR
  { 0x27D0, BIDI_ON  },  // WHITE DIAMOND WITH CENTRED DOT
  { 0x27D1, BIDI_ON  },  // AND WITH DOT
  { 0x27D2, BIDI_ON  },  // ELEMENT OF OPENING UPWARDS
  { 0x27D3, BIDI_ON  },  // LOWER RIGHT CORNER WITH DOT
  { 0x27D4, BIDI_ON  },  // UPPER LEFT CORNER WITH DOT
  { 0x27D5, BIDI_ON  },  // LEFT OUTER JOIN
  { 0x27D6, BIDI_ON  },  // RIGHT OUTER JOIN
  { 0x27D7, BIDI_ON  },  // FULL OUTER JOIN
  { 0x27D8, BIDI_ON  },  // LARGE UP TACK
  { 0x27D9, BIDI_ON  },  // LARGE DOWN TACK
  { 0x27DA, BIDI_ON  },  // LEFT AND RIGHT DOUBLE TURNSTILE
  { 0x27DB, BIDI_ON  },  // LEFT AND RIGHT TACK
  { 0x27DC, BIDI_ON  },  // LEFT MULTIMAP
  { 0x27DD, BIDI_ON  },  // LONG RIGHT TACK
  { 0x27DE, BIDI_ON  },  // LONG LEFT TACK
  { 0x27DF, BIDI_ON  },  // UP TACK WITH CIRCLE ABOVE
  { 0x27E0, BIDI_ON  },  // LOZENGE DIVIDED BY HORIZONTAL RULE
  { 0x27E1, BIDI_ON  },  // WHITE CONCAVE-SIDED DIAMOND
  { 0x27E2, BIDI_ON  },  // WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK
  { 0x27E3, BIDI_ON  },  // WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK
  { 0x27E4, BIDI_ON  },  // WHITE SQUARE WITH LEFTWARDS TICK
  { 0x27E5, BIDI_ON  },  // WHITE SQUARE WITH RIGHTWARDS TICK
  { 0x27E6, BIDI_ON  },  // MATHEMATICAL LEFT WHITE SQUARE BRACKET
  { 0x27E7, BIDI_ON  },  // MATHEMATICAL RIGHT WHITE SQUARE BRACKET
  { 0x27E8, BIDI_ON  },  // MATHEMATICAL LEFT ANGLE BRACKET
  { 0x27E9, BIDI_ON  },  // MATHEMATICAL RIGHT ANGLE BRACKET
  { 0x27EA, BIDI_ON  },  // MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
  { 0x27EB, BIDI_ON  },  // MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
  { 0x27EC, BIDI_ON  },  // MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET
  { 0x27ED, BIDI_ON  },  // MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET
  { 0x27EE, BIDI_ON  },  // MATHEMATICAL LEFT FLATTENED PARENTHESIS
  { 0x27EF, BIDI_ON  },  // MATHEMATICAL RIGHT FLATTENED PARENTHESIS
  { 0x27F0, BIDI_ON  },  // UPWARDS QUADRUPLE ARROW
  { 0x27F1, BIDI_ON  },  // DOWNWARDS QUADRUPLE ARROW
  { 0x27F2, BIDI_ON  },  // ANTICLOCKWISE GAPPED CIRCLE ARROW
  { 0x27F3, BIDI_ON  },  // CLOCKWISE GAPPED CIRCLE ARROW
  { 0x27F4, BIDI_ON  },  // RIGHT ARROW WITH CIRCLED PLUS
  { 0x27F5, BIDI_ON  },  // LONG LEFTWARDS ARROW
  { 0x27F6, BIDI_ON  },  // LONG RIGHTWARDS ARROW
  { 0x27F7, BIDI_ON  },  // LONG LEFT RIGHT ARROW
  { 0x27F8, BIDI_ON  },  // LONG LEFTWARDS DOUBLE ARROW
  { 0x27F9, BIDI_ON  },  // LONG RIGHTWARDS DOUBLE ARROW
  { 0x27FA, BIDI_ON  },  // LONG LEFT RIGHT DOUBLE ARROW
  { 0x27FB, BIDI_ON  },  // LONG LEFTWARDS ARROW FROM BAR
  { 0x27FC, BIDI_ON  },  // LONG RIGHTWARDS ARROW FROM BAR
  { 0x27FD, BIDI_ON  },  // LONG LEFTWARDS DOUBLE ARROW FROM BAR
  { 0x27FE, BIDI_ON  },  // LONG RIGHTWARDS DOUBLE ARROW FROM BAR
  { 0x27FF, BIDI_ON  },  // LONG RIGHTWARDS SQUIGGLE ARROW
  { 0x2800, BIDI_L   },  // BRAILLE PATTERN BLANK
  { 0x2801, BIDI_L   },  // BRAILLE PATTERN DOTS-1
  { 0x2802, BIDI_L   },  // BRAILLE PATTERN DOTS-2
  { 0x2803, BIDI_L   },  // BRAILLE PATTERN DOTS-12
  { 0x2804, BIDI_L   },  // BRAILLE PATTERN DOTS-3
  { 0x2805, BIDI_L   },  // BRAILLE PATTERN DOTS-13
  { 0x2806, BIDI_L   },  // BRAILLE PATTERN DOTS-23
  { 0x2807, BIDI_L   },  // BRAILLE PATTERN DOTS-123
  { 0x2808, BIDI_L   },  // BRAILLE PATTERN DOTS-4
  { 0x2809, BIDI_L   },  // BRAILLE PATTERN DOTS-14
  { 0x280A, BIDI_L   },  // BRAILLE PATTERN DOTS-24
  { 0x280B, BIDI_L   },  // BRAILLE PATTERN DOTS-124
  { 0x280C, BIDI_L   },  // BRAILLE PATTERN DOTS-34
  { 0x280D, BIDI_L   },  // BRAILLE PATTERN DOTS-134
  { 0x280E, BIDI_L   },  // BRAILLE PATTERN DOTS-234
  { 0x280F, BIDI_L   },  // BRAILLE PATTERN DOTS-1234
  { 0x2810, BIDI_L   },  // BRAILLE PATTERN DOTS-5
  { 0x2811, BIDI_L   },  // BRAILLE PATTERN DOTS-15
  { 0x2812, BIDI_L   },  // BRAILLE PATTERN DOTS-25
  { 0x2813, BIDI_L   },  // BRAILLE PATTERN DOTS-125
  { 0x2814, BIDI_L   },  // BRAILLE PATTERN DOTS-35
  { 0x2815, BIDI_L   },  // BRAILLE PATTERN DOTS-135
  { 0x2816, BIDI_L   },  // BRAILLE PATTERN DOTS-235
  { 0x2817, BIDI_L   },  // BRAILLE PATTERN DOTS-1235
  { 0x2818, BIDI_L   },  // BRAILLE PATTERN DOTS-45
  { 0x2819, BIDI_L   },  // BRAILLE PATTERN DOTS-145
  { 0x281A, BIDI_L   },  // BRAILLE PATTERN DOTS-245
  { 0x281B, BIDI_L   },  // BRAILLE PATTERN DOTS-1245
  { 0x281C, BIDI_L   },  // BRAILLE PATTERN DOTS-345
  { 0x281D, BIDI_L   },  // BRAILLE PATTERN DOTS-1345
  { 0x281E, BIDI_L   },  // BRAILLE PATTERN DOTS-2345
  { 0x281F, BIDI_L   },  // BRAILLE PATTERN DOTS-12345
  { 0x2820, BIDI_L   },  // BRAILLE PATTERN DOTS-6
  { 0x2821, BIDI_L   },  // BRAILLE PATTERN DOTS-16
  { 0x2822, BIDI_L   },  // BRAILLE PATTERN DOTS-26
  { 0x2823, BIDI_L   },  // BRAILLE PATTERN DOTS-126
  { 0x2824, BIDI_L   },  // BRAILLE PATTERN DOTS-36
  { 0x2825, BIDI_L   },  // BRAILLE PATTERN DOTS-136
  { 0x2826, BIDI_L   },  // BRAILLE PATTERN DOTS-236
  { 0x2827, BIDI_L   },  // BRAILLE PATTERN DOTS-1236
  { 0x2828, BIDI_L   },  // BRAILLE PATTERN DOTS-46
  { 0x2829, BIDI_L   },  // BRAILLE PATTERN DOTS-146
  { 0x282A, BIDI_L   },  // BRAILLE PATTERN DOTS-246
  { 0x282B, BIDI_L   },  // BRAILLE PATTERN DOTS-1246
  { 0x282C, BIDI_L   },  // BRAILLE PATTERN DOTS-346
  { 0x282D, BIDI_L   },  // BRAILLE PATTERN DOTS-1346
  { 0x282E, BIDI_L   },  // BRAILLE PATTERN DOTS-2346
  { 0x282F, BIDI_L   },  // BRAILLE PATTERN DOTS-12346
  { 0x2830, BIDI_L   },  // BRAILLE PATTERN DOTS-56
  { 0x2831, BIDI_L   },  // BRAILLE PATTERN DOTS-156
  { 0x2832, BIDI_L   },  // BRAILLE PATTERN DOTS-256
  { 0x2833, BIDI_L   },  // BRAILLE PATTERN DOTS-1256
  { 0x2834, BIDI_L   },  // BRAILLE PATTERN DOTS-356
  { 0x2835, BIDI_L   },  // BRAILLE PATTERN DOTS-1356
  { 0x2836, BIDI_L   },  // BRAILLE PATTERN DOTS-2356
  { 0x2837, BIDI_L   },  // BRAILLE PATTERN DOTS-12356
  { 0x2838, BIDI_L   },  // BRAILLE PATTERN DOTS-456
  { 0x2839, BIDI_L   },  // BRAILLE PATTERN DOTS-1456
  { 0x283A, BIDI_L   },  // BRAILLE PATTERN DOTS-2456
  { 0x283B, BIDI_L   },  // BRAILLE PATTERN DOTS-12456
  { 0x283C, BIDI_L   },  // BRAILLE PATTERN DOTS-3456
  { 0x283D, BIDI_L   },  // BRAILLE PATTERN DOTS-13456
  { 0x283E, BIDI_L   },  // BRAILLE PATTERN DOTS-23456
  { 0x283F, BIDI_L   },  // BRAILLE PATTERN DOTS-123456
  { 0x2840, BIDI_L   },  // BRAILLE PATTERN DOTS-7
  { 0x2841, BIDI_L   },  // BRAILLE PATTERN DOTS-17
  { 0x2842, BIDI_L   },  // BRAILLE PATTERN DOTS-27
  { 0x2843, BIDI_L   },  // BRAILLE PATTERN DOTS-127
  { 0x2844, BIDI_L   },  // BRAILLE PATTERN DOTS-37
  { 0x2845, BIDI_L   },  // BRAILLE PATTERN DOTS-137
  { 0x2846, BIDI_L   },  // BRAILLE PATTERN DOTS-237
  { 0x2847, BIDI_L   },  // BRAILLE PATTERN DOTS-1237
  { 0x2848, BIDI_L   },  // BRAILLE PATTERN DOTS-47
  { 0x2849, BIDI_L   },  // BRAILLE PATTERN DOTS-147
  { 0x284A, BIDI_L   },  // BRAILLE PATTERN DOTS-247
  { 0x284B, BIDI_L   },  // BRAILLE PATTERN DOTS-1247
  { 0x284C, BIDI_L   },  // BRAILLE PATTERN DOTS-347
  { 0x284D, BIDI_L   },  // BRAILLE PATTERN DOTS-1347
  { 0x284E, BIDI_L   },  // BRAILLE PATTERN DOTS-2347
  { 0x284F, BIDI_L   },  // BRAILLE PATTERN DOTS-12347
  { 0x2850, BIDI_L   },  // BRAILLE PATTERN DOTS-57
  { 0x2851, BIDI_L   },  // BRAILLE PATTERN DOTS-157
  { 0x2852, BIDI_L   },  // BRAILLE PATTERN DOTS-257
  { 0x2853, BIDI_L   },  // BRAILLE PATTERN DOTS-1257
  { 0x2854, BIDI_L   },  // BRAILLE PATTERN DOTS-357
  { 0x2855, BIDI_L   },  // BRAILLE PATTERN DOTS-1357
  { 0x2856, BIDI_L   },  // BRAILLE PATTERN DOTS-2357
  { 0x2857, BIDI_L   },  // BRAILLE PATTERN DOTS-12357
  { 0x2858, BIDI_L   },  // BRAILLE PATTERN DOTS-457
  { 0x2859, BIDI_L   },  // BRAILLE PATTERN DOTS-1457
  { 0x285A, BIDI_L   },  // BRAILLE PATTERN DOTS-2457
  { 0x285B, BIDI_L   },  // BRAILLE PATTERN DOTS-12457
  { 0x285C, BIDI_L   },  // BRAILLE PATTERN DOTS-3457
  { 0x285D, BIDI_L   },  // BRAILLE PATTERN DOTS-13457
  { 0x285E, BIDI_L   },  // BRAILLE PATTERN DOTS-23457
  { 0x285F, BIDI_L   },  // BRAILLE PATTERN DOTS-123457
  { 0x2860, BIDI_L   },  // BRAILLE PATTERN DOTS-67
  { 0x2861, BIDI_L   },  // BRAILLE PATTERN DOTS-167
  { 0x2862, BIDI_L   },  // BRAILLE PATTERN DOTS-267
  { 0x2863, BIDI_L   },  // BRAILLE PATTERN DOTS-1267
  { 0x2864, BIDI_L   },  // BRAILLE PATTERN DOTS-367
  { 0x2865, BIDI_L   },  // BRAILLE PATTERN DOTS-1367
  { 0x2866, BIDI_L   },  // BRAILLE PATTERN DOTS-2367
  { 0x2867, BIDI_L   },  // BRAILLE PATTERN DOTS-12367
  { 0x2868, BIDI_L   },  // BRAILLE PATTERN DOTS-467
  { 0x2869, BIDI_L   },  // BRAILLE PATTERN DOTS-1467
  { 0x286A, BIDI_L   },  // BRAILLE PATTERN DOTS-2467
  { 0x286B, BIDI_L   },  // BRAILLE PATTERN DOTS-12467
  { 0x286C, BIDI_L   },  // BRAILLE PATTERN DOTS-3467
  { 0x286D, BIDI_L   },  // BRAILLE PATTERN DOTS-13467
  { 0x286E, BIDI_L   },  // BRAILLE PATTERN DOTS-23467
  { 0x286F, BIDI_L   },  // BRAILLE PATTERN DOTS-123467
  { 0x2870, BIDI_L   },  // BRAILLE PATTERN DOTS-567
  { 0x2871, BIDI_L   },  // BRAILLE PATTERN DOTS-1567
  { 0x2872, BIDI_L   },  // BRAILLE PATTERN DOTS-2567
  { 0x2873, BIDI_L   },  // BRAILLE PATTERN DOTS-12567
  { 0x2874, BIDI_L   },  // BRAILLE PATTERN DOTS-3567
  { 0x2875, BIDI_L   },  // BRAILLE PATTERN DOTS-13567
  { 0x2876, BIDI_L   },  // BRAILLE PATTERN DOTS-23567
  { 0x2877, BIDI_L   },  // BRAILLE PATTERN DOTS-123567
  { 0x2878, BIDI_L   },  // BRAILLE PATTERN DOTS-4567
  { 0x2879, BIDI_L   },  // BRAILLE PATTERN DOTS-14567
  { 0x287A, BIDI_L   },  // BRAILLE PATTERN DOTS-24567
  { 0x287B, BIDI_L   },  // BRAILLE PATTERN DOTS-124567
  { 0x287C, BIDI_L   },  // BRAILLE PATTERN DOTS-34567
  { 0x287D, BIDI_L   },  // BRAILLE PATTERN DOTS-134567
  { 0x287E, BIDI_L   },  // BRAILLE PATTERN DOTS-234567
  { 0x287F, BIDI_L   },  // BRAILLE PATTERN DOTS-1234567
  { 0x2880, BIDI_L   },  // BRAILLE PATTERN DOTS-8
  { 0x2881, BIDI_L   },  // BRAILLE PATTERN DOTS-18
  { 0x2882, BIDI_L   },  // BRAILLE PATTERN DOTS-28
  { 0x2883, BIDI_L   },  // BRAILLE PATTERN DOTS-128
  { 0x2884, BIDI_L   },  // BRAILLE PATTERN DOTS-38
  { 0x2885, BIDI_L   },  // BRAILLE PATTERN DOTS-138
  { 0x2886, BIDI_L   },  // BRAILLE PATTERN DOTS-238
  { 0x2887, BIDI_L   },  // BRAILLE PATTERN DOTS-1238
  { 0x2888, BIDI_L   },  // BRAILLE PATTERN DOTS-48
  { 0x2889, BIDI_L   },  // BRAILLE PATTERN DOTS-148
  { 0x288A, BIDI_L   },  // BRAILLE PATTERN DOTS-248
  { 0x288B, BIDI_L   },  // BRAILLE PATTERN DOTS-1248
  { 0x288C, BIDI_L   },  // BRAILLE PATTERN DOTS-348
  { 0x288D, BIDI_L   },  // BRAILLE PATTERN DOTS-1348
  { 0x288E, BIDI_L   },  // BRAILLE PATTERN DOTS-2348
  { 0x288F, BIDI_L   },  // BRAILLE PATTERN DOTS-12348
  { 0x2890, BIDI_L   },  // BRAILLE PATTERN DOTS-58
  { 0x2891, BIDI_L   },  // BRAILLE PATTERN DOTS-158
  { 0x2892, BIDI_L   },  // BRAILLE PATTERN DOTS-258
  { 0x2893, BIDI_L   },  // BRAILLE PATTERN DOTS-1258
  { 0x2894, BIDI_L   },  // BRAILLE PATTERN DOTS-358
  { 0x2895, BIDI_L   },  // BRAILLE PATTERN DOTS-1358
  { 0x2896, BIDI_L   },  // BRAILLE PATTERN DOTS-2358
  { 0x2897, BIDI_L   },  // BRAILLE PATTERN DOTS-12358
  { 0x2898, BIDI_L   },  // BRAILLE PATTERN DOTS-458
  { 0x2899, BIDI_L   },  // BRAILLE PATTERN DOTS-1458
  { 0x289A, BIDI_L   },  // BRAILLE PATTERN DOTS-2458
  { 0x289B, BIDI_L   },  // BRAILLE PATTERN DOTS-12458
  { 0x289C, BIDI_L   },  // BRAILLE PATTERN DOTS-3458
  { 0x289D, BIDI_L   },  // BRAILLE PATTERN DOTS-13458
  { 0x289E, BIDI_L   },  // BRAILLE PATTERN DOTS-23458
  { 0x289F, BIDI_L   },  // BRAILLE PATTERN DOTS-123458
  { 0x28A0, BIDI_L   },  // BRAILLE PATTERN DOTS-68
  { 0x28A1, BIDI_L   },  // BRAILLE PATTERN DOTS-168
  { 0x28A2, BIDI_L   },  // BRAILLE PATTERN DOTS-268
  { 0x28A3, BIDI_L   },  // BRAILLE PATTERN DOTS-1268
  { 0x28A4, BIDI_L   },  // BRAILLE PATTERN DOTS-368
  { 0x28A5, BIDI_L   },  // BRAILLE PATTERN DOTS-1368
  { 0x28A6, BIDI_L   },  // BRAILLE PATTERN DOTS-2368
  { 0x28A7, BIDI_L   },  // BRAILLE PATTERN DOTS-12368
  { 0x28A8, BIDI_L   },  // BRAILLE PATTERN DOTS-468
  { 0x28A9, BIDI_L   },  // BRAILLE PATTERN DOTS-1468
  { 0x28AA, BIDI_L   },  // BRAILLE PATTERN DOTS-2468
  { 0x28AB, BIDI_L   },  // BRAILLE PATTERN DOTS-12468
  { 0x28AC, BIDI_L   },  // BRAILLE PATTERN DOTS-3468
  { 0x28AD, BIDI_L   },  // BRAILLE PATTERN DOTS-13468
  { 0x28AE, BIDI_L   },  // BRAILLE PATTERN DOTS-23468
  { 0x28AF, BIDI_L   },  // BRAILLE PATTERN DOTS-123468
  { 0x28B0, BIDI_L   },  // BRAILLE PATTERN DOTS-568
  { 0x28B1, BIDI_L   },  // BRAILLE PATTERN DOTS-1568
  { 0x28B2, BIDI_L   },  // BRAILLE PATTERN DOTS-2568
  { 0x28B3, BIDI_L   },  // BRAILLE PATTERN DOTS-12568
  { 0x28B4, BIDI_L   },  // BRAILLE PATTERN DOTS-3568
  { 0x28B5, BIDI_L   },  // BRAILLE PATTERN DOTS-13568
  { 0x28B6, BIDI_L   },  // BRAILLE PATTERN DOTS-23568
  { 0x28B7, BIDI_L   },  // BRAILLE PATTERN DOTS-123568
  { 0x28B8, BIDI_L   },  // BRAILLE PATTERN DOTS-4568
  { 0x28B9, BIDI_L   },  // BRAILLE PATTERN DOTS-14568
  { 0x28BA, BIDI_L   },  // BRAILLE PATTERN DOTS-24568
  { 0x28BB, BIDI_L   },  // BRAILLE PATTERN DOTS-124568
  { 0x28BC, BIDI_L   },  // BRAILLE PATTERN DOTS-34568
  { 0x28BD, BIDI_L   },  // BRAILLE PATTERN DOTS-134568
  { 0x28BE, BIDI_L   },  // BRAILLE PATTERN DOTS-234568
  { 0x28BF, BIDI_L   },  // BRAILLE PATTERN DOTS-1234568
  { 0x28C0, BIDI_L   },  // BRAILLE PATTERN DOTS-78
  { 0x28C1, BIDI_L   },  // BRAILLE PATTERN DOTS-178
  { 0x28C2, BIDI_L   },  // BRAILLE PATTERN DOTS-278
  { 0x28C3, BIDI_L   },  // BRAILLE PATTERN DOTS-1278
  { 0x28C4, BIDI_L   },  // BRAILLE PATTERN DOTS-378
  { 0x28C5, BIDI_L   },  // BRAILLE PATTERN DOTS-1378
  { 0x28C6, BIDI_L   },  // BRAILLE PATTERN DOTS-2378
  { 0x28C7, BIDI_L   },  // BRAILLE PATTERN DOTS-12378
  { 0x28C8, BIDI_L   },  // BRAILLE PATTERN DOTS-478
  { 0x28C9, BIDI_L   },  // BRAILLE PATTERN DOTS-1478
  { 0x28CA, BIDI_L   },  // BRAILLE PATTERN DOTS-2478
  { 0x28CB, BIDI_L   },  // BRAILLE PATTERN DOTS-12478
  { 0x28CC, BIDI_L   },  // BRAILLE PATTERN DOTS-3478
  { 0x28CD, BIDI_L   },  // BRAILLE PATTERN DOTS-13478
  { 0x28CE, BIDI_L   },  // BRAILLE PATTERN DOTS-23478
  { 0x28CF, BIDI_L   },  // BRAILLE PATTERN DOTS-123478
  { 0x28D0, BIDI_L   },  // BRAILLE PATTERN DOTS-578
  { 0x28D1, BIDI_L   },  // BRAILLE PATTERN DOTS-1578
  { 0x28D2, BIDI_L   },  // BRAILLE PATTERN DOTS-2578
  { 0x28D3, BIDI_L   },  // BRAILLE PATTERN DOTS-12578
  { 0x28D4, BIDI_L   },  // BRAILLE PATTERN DOTS-3578
  { 0x28D5, BIDI_L   },  // BRAILLE PATTERN DOTS-13578
  { 0x28D6, BIDI_L   },  // BRAILLE PATTERN DOTS-23578
  { 0x28D7, BIDI_L   },  // BRAILLE PATTERN DOTS-123578
  { 0x28D8, BIDI_L   },  // BRAILLE PATTERN DOTS-4578
  { 0x28D9, BIDI_L   },  // BRAILLE PATTERN DOTS-14578
  { 0x28DA, BIDI_L   },  // BRAILLE PATTERN DOTS-24578
  { 0x28DB, BIDI_L   },  // BRAILLE PATTERN DOTS-124578
  { 0x28DC, BIDI_L   },  // BRAILLE PATTERN DOTS-34578
  { 0x28DD, BIDI_L   },  // BRAILLE PATTERN DOTS-134578
  { 0x28DE, BIDI_L   },  // BRAILLE PATTERN DOTS-234578
  { 0x28DF, BIDI_L   },  // BRAILLE PATTERN DOTS-1234578
  { 0x28E0, BIDI_L   },  // BRAILLE PATTERN DOTS-678
  { 0x28E1, BIDI_L   },  // BRAILLE PATTERN DOTS-1678
  { 0x28E2, BIDI_L   },  // BRAILLE PATTERN DOTS-2678
  { 0x28E3, BIDI_L   },  // BRAILLE PATTERN DOTS-12678
  { 0x28E4, BIDI_L   },  // BRAILLE PATTERN DOTS-3678
  { 0x28E5, BIDI_L   },  // BRAILLE PATTERN DOTS-13678
  { 0x28E6, BIDI_L   },  // BRAILLE PATTERN DOTS-23678
  { 0x28E7, BIDI_L   },  // BRAILLE PATTERN DOTS-123678
  { 0x28E8, BIDI_L   },  // BRAILLE PATTERN DOTS-4678
  { 0x28E9, BIDI_L   },  // BRAILLE PATTERN DOTS-14678
  { 0x28EA, BIDI_L   },  // BRAILLE PATTERN DOTS-24678
  { 0x28EB, BIDI_L   },  // BRAILLE PATTERN DOTS-124678
  { 0x28EC, BIDI_L   },  // BRAILLE PATTERN DOTS-34678
  { 0x28ED, BIDI_L   },  // BRAILLE PATTERN DOTS-134678
  { 0x28EE, BIDI_L   },  // BRAILLE PATTERN DOTS-234678
  { 0x28EF, BIDI_L   },  // BRAILLE PATTERN DOTS-1234678
  { 0x28F0, BIDI_L   },  // BRAILLE PATTERN DOTS-5678
  { 0x28F1, BIDI_L   },  // BRAILLE PATTERN DOTS-15678
  { 0x28F2, BIDI_L   },  // BRAILLE PATTERN DOTS-25678
  { 0x28F3, BIDI_L   },  // BRAILLE PATTERN DOTS-125678
  { 0x28F4, BIDI_L   },  // BRAILLE PATTERN DOTS-35678
  { 0x28F5, BIDI_L   },  // BRAILLE PATTERN DOTS-135678
  { 0x28F6, BIDI_L   },  // BRAILLE PATTERN DOTS-235678
  { 0x28F7, BIDI_L   },  // BRAILLE PATTERN DOTS-1235678
  { 0x28F8, BIDI_L   },  // BRAILLE PATTERN DOTS-45678
  { 0x28F9, BIDI_L   },  // BRAILLE PATTERN DOTS-145678
  { 0x28FA, BIDI_L   },  // BRAILLE PATTERN DOTS-245678
  { 0x28FB, BIDI_L   },  // BRAILLE PATTERN DOTS-1245678
  { 0x28FC, BIDI_L   },  // BRAILLE PATTERN DOTS-345678
  { 0x28FD, BIDI_L   },  // BRAILLE PATTERN DOTS-1345678
  { 0x28FE, BIDI_L   },  // BRAILLE PATTERN DOTS-2345678
  { 0x28FF, BIDI_L   },  // BRAILLE PATTERN DOTS-12345678
  { 0x2900, BIDI_ON  },  // RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
  { 0x2901, BIDI_ON  },  // RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
  { 0x2902, BIDI_ON  },  // LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE
  { 0x2903, BIDI_ON  },  // RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE
  { 0x2904, BIDI_ON  },  // LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE
  { 0x2905, BIDI_ON  },  // RIGHTWARDS TWO-HEADED ARROW FROM BAR
  { 0x2906, BIDI_ON  },  // LEFTWARDS DOUBLE ARROW FROM BAR
  { 0x2907, BIDI_ON  },  // RIGHTWARDS DOUBLE ARROW FROM BAR
  { 0x2908, BIDI_ON  },  // DOWNWARDS ARROW WITH HORIZONTAL STROKE
  { 0x2909, BIDI_ON  },  // UPWARDS ARROW WITH HORIZONTAL STROKE
  { 0x290A, BIDI_ON  },  // UPWARDS TRIPLE ARROW
  { 0x290B, BIDI_ON  },  // DOWNWARDS TRIPLE ARROW
  { 0x290C, BIDI_ON  },  // LEFTWARDS DOUBLE DASH ARROW
  { 0x290D, BIDI_ON  },  // RIGHTWARDS DOUBLE DASH ARROW
  { 0x290E, BIDI_ON  },  // LEFTWARDS TRIPLE DASH ARROW
  { 0x290F, BIDI_ON  },  // RIGHTWARDS TRIPLE DASH ARROW
  { 0x2910, BIDI_ON  },  // RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW
  { 0x2911, BIDI_ON  },  // RIGHTWARDS ARROW WITH DOTTED STEM
  { 0x2912, BIDI_ON  },  // UPWARDS ARROW TO BAR
  { 0x2913, BIDI_ON  },  // DOWNWARDS ARROW TO BAR
  { 0x2914, BIDI_ON  },  // RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE
  { 0x2915, BIDI_ON  },  // RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
  { 0x2916, BIDI_ON  },  // RIGHTWARDS TWO-HEADED ARROW WITH TAIL
  { 0x2917, BIDI_ON  },  // RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE
  { 0x2918, BIDI_ON  },  // RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
  { 0x2919, BIDI_ON  },  // LEFTWARDS ARROW-TAIL
  { 0x291A, BIDI_ON  },  // RIGHTWARDS ARROW-TAIL
  { 0x291B, BIDI_ON  },  // LEFTWARDS DOUBLE ARROW-TAIL
  { 0x291C, BIDI_ON  },  // RIGHTWARDS DOUBLE ARROW-TAIL
  { 0x291D, BIDI_ON  },  // LEFTWARDS ARROW TO BLACK DIAMOND
  { 0x291E, BIDI_ON  },  // RIGHTWARDS ARROW TO BLACK DIAMOND
  { 0x291F, BIDI_ON  },  // LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND
  { 0x2920, BIDI_ON  },  // RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND
  { 0x2921, BIDI_ON  },  // NORTH WEST AND SOUTH EAST ARROW
  { 0x2922, BIDI_ON  },  // NORTH EAST AND SOUTH WEST ARROW
  { 0x2923, BIDI_ON  },  // NORTH WEST ARROW WITH HOOK
  { 0x2924, BIDI_ON  },  // NORTH EAST ARROW WITH HOOK
  { 0x2925, BIDI_ON  },  // SOUTH EAST ARROW WITH HOOK
  { 0x2926, BIDI_ON  },  // SOUTH WEST ARROW WITH HOOK
  { 0x2927, BIDI_ON  },  // NORTH WEST ARROW AND NORTH EAST ARROW
  { 0x2928, BIDI_ON  },  // NORTH EAST ARROW AND SOUTH EAST ARROW
  { 0x2929, BIDI_ON  },  // SOUTH EAST ARROW AND SOUTH WEST ARROW
  { 0x292A, BIDI_ON  },  // SOUTH WEST ARROW AND NORTH WEST ARROW
  { 0x292B, BIDI_ON  },  // RISING DIAGONAL CROSSING FALLING DIAGONAL
  { 0x292C, BIDI_ON  },  // FALLING DIAGONAL CROSSING RISING DIAGONAL
  { 0x292D, BIDI_ON  },  // SOUTH EAST ARROW CROSSING NORTH EAST ARROW
  { 0x292E, BIDI_ON  },  // NORTH EAST ARROW CROSSING SOUTH EAST ARROW
  { 0x292F, BIDI_ON  },  // FALLING DIAGONAL CROSSING NORTH EAST ARROW
  { 0x2930, BIDI_ON  },  // RISING DIAGONAL CROSSING SOUTH EAST ARROW
  { 0x2931, BIDI_ON  },  // NORTH EAST ARROW CROSSING NORTH WEST ARROW
  { 0x2932, BIDI_ON  },  // NORTH WEST ARROW CROSSING NORTH EAST ARROW
  { 0x2933, BIDI_ON  },  // WAVE ARROW POINTING DIRECTLY RIGHT
  { 0x2934, BIDI_ON  },  // ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS
  { 0x2935, BIDI_ON  },  // ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS
  { 0x2936, BIDI_ON  },  // ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS
  { 0x2937, BIDI_ON  },  // ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS
  { 0x2938, BIDI_ON  },  // RIGHT-SIDE ARC CLOCKWISE ARROW
  { 0x2939, BIDI_ON  },  // LEFT-SIDE ARC ANTICLOCKWISE ARROW
  { 0x293A, BIDI_ON  },  // TOP ARC ANTICLOCKWISE ARROW
  { 0x293B, BIDI_ON  },  // BOTTOM ARC ANTICLOCKWISE ARROW
  { 0x293C, BIDI_ON  },  // TOP ARC CLOCKWISE ARROW WITH MINUS
  { 0x293D, BIDI_ON  },  // TOP ARC ANTICLOCKWISE ARROW WITH PLUS
  { 0x293E, BIDI_ON  },  // LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW
  { 0x293F, BIDI_ON  },  // LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW
  { 0x2940, BIDI_ON  },  // ANTICLOCKWISE CLOSED CIRCLE ARROW
  { 0x2941, BIDI_ON  },  // CLOCKWISE CLOSED CIRCLE ARROW
  { 0x2942, BIDI_ON  },  // RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW
  { 0x2943, BIDI_ON  },  // LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW
  { 0x2944, BIDI_ON  },  // SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW
  { 0x2945, BIDI_ON  },  // RIGHTWARDS ARROW WITH PLUS BELOW
  { 0x2946, BIDI_ON  },  // LEFTWARDS ARROW WITH PLUS BELOW
  { 0x2947, BIDI_ON  },  // RIGHTWARDS ARROW THROUGH X
  { 0x2948, BIDI_ON  },  // LEFT RIGHT ARROW THROUGH SMALL CIRCLE
  { 0x2949, BIDI_ON  },  // UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE
  { 0x294A, BIDI_ON  },  // LEFT BARB UP RIGHT BARB DOWN HARPOON
  { 0x294B, BIDI_ON  },  // LEFT BARB DOWN RIGHT BARB UP HARPOON
  { 0x294C, BIDI_ON  },  // UP BARB RIGHT DOWN BARB LEFT HARPOON
  { 0x294D, BIDI_ON  },  // UP BARB LEFT DOWN BARB RIGHT HARPOON
  { 0x294E, BIDI_ON  },  // LEFT BARB UP RIGHT BARB UP HARPOON
  { 0x294F, BIDI_ON  },  // UP BARB RIGHT DOWN BARB RIGHT HARPOON
  { 0x2950, BIDI_ON  },  // LEFT BARB DOWN RIGHT BARB DOWN HARPOON
  { 0x2951, BIDI_ON  },  // UP BARB LEFT DOWN BARB LEFT HARPOON
  { 0x2952, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB UP TO BAR
  { 0x2953, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB UP TO BAR
  { 0x2954, BIDI_ON  },  // UPWARDS HARPOON WITH BARB RIGHT TO BAR
  { 0x2955, BIDI_ON  },  // DOWNWARDS HARPOON WITH BARB RIGHT TO BAR
  { 0x2956, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB DOWN TO BAR
  { 0x2957, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB DOWN TO BAR
  { 0x2958, BIDI_ON  },  // UPWARDS HARPOON WITH BARB LEFT TO BAR
  { 0x2959, BIDI_ON  },  // DOWNWARDS HARPOON WITH BARB LEFT TO BAR
  { 0x295A, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB UP FROM BAR
  { 0x295B, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB UP FROM BAR
  { 0x295C, BIDI_ON  },  // UPWARDS HARPOON WITH BARB RIGHT FROM BAR
  { 0x295D, BIDI_ON  },  // DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR
  { 0x295E, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB DOWN FROM BAR
  { 0x295F, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR
  { 0x2960, BIDI_ON  },  // UPWARDS HARPOON WITH BARB LEFT FROM BAR
  { 0x2961, BIDI_ON  },  // DOWNWARDS HARPOON WITH BARB LEFT FROM BAR
  { 0x2962, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN
  { 0x2963, BIDI_ON  },  // UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
  { 0x2964, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
  { 0x2965, BIDI_ON  },  // DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
  { 0x2966, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP
  { 0x2967, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
  { 0x2968, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP
  { 0x2969, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN
  { 0x296A, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
  { 0x296B, BIDI_ON  },  // LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
  { 0x296C, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
  { 0x296D, BIDI_ON  },  // RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
  { 0x296E, BIDI_ON  },  // UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
  { 0x296F, BIDI_ON  },  // DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
  { 0x2970, BIDI_ON  },  // RIGHT DOUBLE ARROW WITH ROUNDED HEAD
  { 0x2971, BIDI_ON  },  // EQUALS SIGN ABOVE RIGHTWARDS ARROW
  { 0x2972, BIDI_ON  },  // TILDE OPERATOR ABOVE RIGHTWARDS ARROW
  { 0x2973, BIDI_ON  },  // LEFTWARDS ARROW ABOVE TILDE OPERATOR
  { 0x2974, BIDI_ON  },  // RIGHTWARDS ARROW ABOVE TILDE OPERATOR
  { 0x2975, BIDI_ON  },  // RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO
  { 0x2976, BIDI_ON  },  // LESS-THAN ABOVE LEFTWARDS ARROW
  { 0x2977, BIDI_ON  },  // LEFTWARDS ARROW THROUGH LESS-THAN
  { 0x2978, BIDI_ON  },  // GREATER-THAN ABOVE RIGHTWARDS ARROW
  { 0x2979, BIDI_ON  },  // SUBSET ABOVE RIGHTWARDS ARROW
  { 0x297A, BIDI_ON  },  // LEFTWARDS ARROW THROUGH SUBSET
  { 0x297B, BIDI_ON  },  // SUPERSET ABOVE LEFTWARDS ARROW
  { 0x297C, BIDI_ON  },  // LEFT FISH TAIL
  { 0x297D, BIDI_ON  },  // RIGHT FISH TAIL
  { 0x297E, BIDI_ON  },  // UP FISH TAIL
  { 0x297F, BIDI_ON  },  // DOWN FISH TAIL
  { 0x2980, BIDI_ON  },  // TRIPLE VERTICAL BAR DELIMITER
  { 0x2981, BIDI_ON  },  // Z NOTATION SPOT
  { 0x2982, BIDI_ON  },  // Z NOTATION TYPE COLON
  { 0x2983, BIDI_ON  },  // LEFT WHITE CURLY BRACKET
  { 0x2984, BIDI_ON  },  // RIGHT WHITE CURLY BRACKET
  { 0x2985, BIDI_ON  },  // LEFT WHITE PARENTHESIS
  { 0x2986, BIDI_ON  },  // RIGHT WHITE PARENTHESIS
  { 0x2987, BIDI_ON  },  // Z NOTATION LEFT IMAGE BRACKET
  { 0x2988, BIDI_ON  },  // Z NOTATION RIGHT IMAGE BRACKET
  { 0x2989, BIDI_ON  },  // Z NOTATION LEFT BINDING BRACKET
  { 0x298A, BIDI_ON  },  // Z NOTATION RIGHT BINDING BRACKET
  { 0x298B, BIDI_ON  },  // LEFT SQUARE BRACKET WITH UNDERBAR
  { 0x298C, BIDI_ON  },  // RIGHT SQUARE BRACKET WITH UNDERBAR
  { 0x298D, BIDI_ON  },  // LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
  { 0x298E, BIDI_ON  },  // RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
  { 0x298F, BIDI_ON  },  // LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
  { 0x2990, BIDI_ON  },  // RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
  { 0x2991, BIDI_ON  },  // LEFT ANGLE BRACKET WITH DOT
  { 0x2992, BIDI_ON  },  // RIGHT ANGLE BRACKET WITH DOT
  { 0x2993, BIDI_ON  },  // LEFT ARC LESS-THAN BRACKET
  { 0x2994, BIDI_ON  },  // RIGHT ARC GREATER-THAN BRACKET
  { 0x2995, BIDI_ON  },  // DOUBLE LEFT ARC GREATER-THAN BRACKET
  { 0x2996, BIDI_ON  },  // DOUBLE RIGHT ARC LESS-THAN BRACKET
  { 0x2997, BIDI_ON  },  // LEFT BLACK TORTOISE SHELL BRACKET
  { 0x2998, BIDI_ON  },  // RIGHT BLACK TORTOISE SHELL BRACKET
  { 0x2999, BIDI_ON  },  // DOTTED FENCE
  { 0x299A, BIDI_ON  },  // VERTICAL ZIGZAG LINE
  { 0x299B, BIDI_ON  },  // MEASURED ANGLE OPENING LEFT
  { 0x299C, BIDI_ON  },  // RIGHT ANGLE VARIANT WITH SQUARE
  { 0x299D, BIDI_ON  },  // MEASURED RIGHT ANGLE WITH DOT
  { 0x299E, BIDI_ON  },  // ANGLE WITH S INSIDE
  { 0x299F, BIDI_ON  },  // ACUTE ANGLE
  { 0x29A0, BIDI_ON  },  // SPHERICAL ANGLE OPENING LEFT
  { 0x29A1, BIDI_ON  },  // SPHERICAL ANGLE OPENING UP
  { 0x29A2, BIDI_ON  },  // TURNED ANGLE
  { 0x29A3, BIDI_ON  },  // REVERSED ANGLE
  { 0x29A4, BIDI_ON  },  // ANGLE WITH UNDERBAR
  { 0x29A5, BIDI_ON  },  // REVERSED ANGLE WITH UNDERBAR
  { 0x29A6, BIDI_ON  },  // OBLIQUE ANGLE OPENING UP
  { 0x29A7, BIDI_ON  },  // OBLIQUE ANGLE OPENING DOWN
  { 0x29A8, BIDI_ON  },  // MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT
  { 0x29A9, BIDI_ON  },  // MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT
  { 0x29AA, BIDI_ON  },  // MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT
  { 0x29AB, BIDI_ON  },  // MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT
  { 0x29AC, BIDI_ON  },  // MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP
  { 0x29AD, BIDI_ON  },  // MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP
  { 0x29AE, BIDI_ON  },  // MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN
  { 0x29AF, BIDI_ON  },  // MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN
  { 0x29B0, BIDI_ON  },  // REVERSED EMPTY SET
  { 0x29B1, BIDI_ON  },  // EMPTY SET WITH OVERBAR
  { 0x29B2, BIDI_ON  },  // EMPTY SET WITH SMALL CIRCLE ABOVE
  { 0x29B3, BIDI_ON  },  // EMPTY SET WITH RIGHT ARROW ABOVE
  { 0x29B4, BIDI_ON  },  // EMPTY SET WITH LEFT ARROW ABOVE
  { 0x29B5, BIDI_ON  },  // CIRCLE WITH HORIZONTAL BAR
  { 0x29B6, BIDI_ON  },  // CIRCLED VERTICAL BAR
  { 0x29B7, BIDI_ON  },  // CIRCLED PARALLEL
  { 0x29B8, BIDI_ON  },  // CIRCLED REVERSE SOLIDUS
  { 0x29B9, BIDI_ON  },  // CIRCLED PERPENDICULAR
  { 0x29BA, BIDI_ON  },  // CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR
  { 0x29BB, BIDI_ON  },  // CIRCLE WITH SUPERIMPOSED X
  { 0x29BC, BIDI_ON  },  // CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN
  { 0x29BD, BIDI_ON  },  // UP ARROW THROUGH CIRCLE
  { 0x29BE, BIDI_ON  },  // CIRCLED WHITE BULLET
  { 0x29BF, BIDI_ON  },  // CIRCLED BULLET
  { 0x29C0, BIDI_ON  },  // CIRCLED LESS-THAN
  { 0x29C1, BIDI_ON  },  // CIRCLED GREATER-THAN
  { 0x29C2, BIDI_ON  },  // CIRCLE WITH SMALL CIRCLE TO THE RIGHT
  { 0x29C3, BIDI_ON  },  // CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT
  { 0x29C4, BIDI_ON  },  // SQUARED RISING DIAGONAL SLASH
  { 0x29C5, BIDI_ON  },  // SQUARED FALLING DIAGONAL SLASH
  { 0x29C6, BIDI_ON  },  // SQUARED ASTERISK
  { 0x29C7, BIDI_ON  },  // SQUARED SMALL CIRCLE
  { 0x29C8, BIDI_ON  },  // SQUARED SQUARE
  { 0x29C9, BIDI_ON  },  // TWO JOINED SQUARES
  { 0x29CA, BIDI_ON  },  // TRIANGLE WITH DOT ABOVE
  { 0x29CB, BIDI_ON  },  // TRIANGLE WITH UNDERBAR
  { 0x29CC, BIDI_ON  },  // S IN TRIANGLE
  { 0x29CD, BIDI_ON  },  // TRIANGLE WITH SERIFS AT BOTTOM
  { 0x29CE, BIDI_ON  },  // RIGHT TRIANGLE ABOVE LEFT TRIANGLE
  { 0x29CF, BIDI_ON  },  // LEFT TRIANGLE BESIDE VERTICAL BAR
  { 0x29D0, BIDI_ON  },  // VERTICAL BAR BESIDE RIGHT TRIANGLE
  { 0x29D1, BIDI_ON  },  // BOWTIE WITH LEFT HALF BLACK
  { 0x29D2, BIDI_ON  },  // BOWTIE WITH RIGHT HALF BLACK
  { 0x29D3, BIDI_ON  },  // BLACK BOWTIE
  { 0x29D4, BIDI_ON  },  // TIMES WITH LEFT HALF BLACK
  { 0x29D5, BIDI_ON  },  // TIMES WITH RIGHT HALF BLACK
  { 0x29D6, BIDI_ON  },  // WHITE HOURGLASS
  { 0x29D7, BIDI_ON  },  // BLACK HOURGLASS
  { 0x29D8, BIDI_ON  },  // LEFT WIGGLY FENCE
  { 0x29D9, BIDI_ON  },  // RIGHT WIGGLY FENCE
  { 0x29DA, BIDI_ON  },  // LEFT DOUBLE WIGGLY FENCE
  { 0x29DB, BIDI_ON  },  // RIGHT DOUBLE WIGGLY FENCE
  { 0x29DC, BIDI_ON  },  // INCOMPLETE INFINITY
  { 0x29DD, BIDI_ON  },  // TIE OVER INFINITY
  { 0x29DE, BIDI_ON  },  // INFINITY NEGATED WITH VERTICAL BAR
  { 0x29DF, BIDI_ON  },  // DOUBLE-ENDED MULTIMAP
  { 0x29E0, BIDI_ON  },  // SQUARE WITH CONTOURED OUTLINE
  { 0x29E1, BIDI_ON  },  // INCREASES AS
  { 0x29E2, BIDI_ON  },  // SHUFFLE PRODUCT
  { 0x29E3, BIDI_ON  },  // EQUALS SIGN AND SLANTED PARALLEL
  { 0x29E4, BIDI_ON  },  // EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE
  { 0x29E5, BIDI_ON  },  // IDENTICAL TO AND SLANTED PARALLEL
  { 0x29E6, BIDI_ON  },  // GLEICH STARK
  { 0x29E7, BIDI_ON  },  // THERMODYNAMIC
  { 0x29E8, BIDI_ON  },  // DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK
  { 0x29E9, BIDI_ON  },  // DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK
  { 0x29EA, BIDI_ON  },  // BLACK DIAMOND WITH DOWN ARROW
  { 0x29EB, BIDI_ON  },  // BLACK LOZENGE
  { 0x29EC, BIDI_ON  },  // WHITE CIRCLE WITH DOWN ARROW
  { 0x29ED, BIDI_ON  },  // BLACK CIRCLE WITH DOWN ARROW
  { 0x29EE, BIDI_ON  },  // ERROR-BARRED WHITE SQUARE
  { 0x29EF, BIDI_ON  },  // ERROR-BARRED BLACK SQUARE
  { 0x29F0, BIDI_ON  },  // ERROR-BARRED WHITE DIAMOND
  { 0x29F1, BIDI_ON  },  // ERROR-BARRED BLACK DIAMOND
  { 0x29F2, BIDI_ON  },  // ERROR-BARRED WHITE CIRCLE
  { 0x29F3, BIDI_ON  },  // ERROR-BARRED BLACK CIRCLE
  { 0x29F4, BIDI_ON  },  // RULE-DELAYED
  { 0x29F5, BIDI_ON  },  // REVERSE SOLIDUS OPERATOR
  { 0x29F6, BIDI_ON  },  // SOLIDUS WITH OVERBAR
  { 0x29F7, BIDI_ON  },  // REVERSE SOLIDUS WITH HORIZONTAL STROKE
  { 0x29F8, BIDI_ON  },  // BIG SOLIDUS
  { 0x29F9, BIDI_ON  },  // BIG REVERSE SOLIDUS
  { 0x29FA, BIDI_ON  },  // DOUBLE PLUS
  { 0x29FB, BIDI_ON  },  // TRIPLE PLUS
  { 0x29FC, BIDI_ON  },  // LEFT-POINTING CURVED ANGLE BRACKET
  { 0x29FD, BIDI_ON  },  // RIGHT-POINTING CURVED ANGLE BRACKET
  { 0x29FE, BIDI_ON  },  // TINY
  { 0x29FF, BIDI_ON  },  // MINY
  { 0x2A00, BIDI_ON  },  // N-ARY CIRCLED DOT OPERATOR
  { 0x2A01, BIDI_ON  },  // N-ARY CIRCLED PLUS OPERATOR
  { 0x2A02, BIDI_ON  },  // N-ARY CIRCLED TIMES OPERATOR
  { 0x2A03, BIDI_ON  },  // N-ARY UNION OPERATOR WITH DOT
  { 0x2A04, BIDI_ON  },  // N-ARY UNION OPERATOR WITH PLUS
  { 0x2A05, BIDI_ON  },  // N-ARY SQUARE INTERSECTION OPERATOR
  { 0x2A06, BIDI_ON  },  // N-ARY SQUARE UNION OPERATOR
  { 0x2A07, BIDI_ON  },  // TWO LOGICAL AND OPERATOR
  { 0x2A08, BIDI_ON  },  // TWO LOGICAL OR OPERATOR
  { 0x2A09, BIDI_ON  },  // N-ARY TIMES OPERATOR
  { 0x2A0A, BIDI_ON  },  // MODULO TWO SUM
  { 0x2A0B, BIDI_ON  },  // SUMMATION WITH INTEGRAL
  { 0x2A0C, BIDI_ON  },  // QUADRUPLE INTEGRAL OPERATOR
  { 0x2A0D, BIDI_ON  },  // FINITE PART INTEGRAL
  { 0x2A0E, BIDI_ON  },  // INTEGRAL WITH DOUBLE STROKE
  { 0x2A0F, BIDI_ON  },  // INTEGRAL AVERAGE WITH SLASH
  { 0x2A10, BIDI_ON  },  // CIRCULATION FUNCTION
  { 0x2A11, BIDI_ON  },  // ANTICLOCKWISE INTEGRATION
  { 0x2A12, BIDI_ON  },  // LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE
  { 0x2A13, BIDI_ON  },  // LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE
  { 0x2A14, BIDI_ON  },  // LINE INTEGRATION NOT INCLUDING THE POLE
  { 0x2A15, BIDI_ON  },  // INTEGRAL AROUND A POINT OPERATOR
  { 0x2A16, BIDI_ON  },  // QUATERNION INTEGRAL OPERATOR
  { 0x2A17, BIDI_ON  },  // INTEGRAL WITH LEFTWARDS ARROW WITH HOOK
  { 0x2A18, BIDI_ON  },  // INTEGRAL WITH TIMES SIGN
  { 0x2A19, BIDI_ON  },  // INTEGRAL WITH INTERSECTION
  { 0x2A1A, BIDI_ON  },  // INTEGRAL WITH UNION
  { 0x2A1B, BIDI_ON  },  // INTEGRAL WITH OVERBAR
  { 0x2A1C, BIDI_ON  },  // INTEGRAL WITH UNDERBAR
  { 0x2A1D, BIDI_ON  },  // JOIN
  { 0x2A1E, BIDI_ON  },  // LARGE LEFT TRIANGLE OPERATOR
  { 0x2A1F, BIDI_ON  },  // Z NOTATION SCHEMA COMPOSITION
  { 0x2A20, BIDI_ON  },  // Z NOTATION SCHEMA PIPING
  { 0x2A21, BIDI_ON  },  // Z NOTATION SCHEMA PROJECTION
  { 0x2A22, BIDI_ON  },  // PLUS SIGN WITH SMALL CIRCLE ABOVE
  { 0x2A23, BIDI_ON  },  // PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE
  { 0x2A24, BIDI_ON  },  // PLUS SIGN WITH TILDE ABOVE
  { 0x2A25, BIDI_ON  },  // PLUS SIGN WITH DOT BELOW
  { 0x2A26, BIDI_ON  },  // PLUS SIGN WITH TILDE BELOW
  { 0x2A27, BIDI_ON  },  // PLUS SIGN WITH SUBSCRIPT TWO
  { 0x2A28, BIDI_ON  },  // PLUS SIGN WITH BLACK TRIANGLE
  { 0x2A29, BIDI_ON  },  // MINUS SIGN WITH COMMA ABOVE
  { 0x2A2A, BIDI_ON  },  // MINUS SIGN WITH DOT BELOW
  { 0x2A2B, BIDI_ON  },  // MINUS SIGN WITH FALLING DOTS
  { 0x2A2C, BIDI_ON  },  // MINUS SIGN WITH RISING DOTS
  { 0x2A2D, BIDI_ON  },  // PLUS SIGN IN LEFT HALF CIRCLE
  { 0x2A2E, BIDI_ON  },  // PLUS SIGN IN RIGHT HALF CIRCLE
  { 0x2A2F, BIDI_ON  },  // VECTOR OR CROSS PRODUCT
  { 0x2A30, BIDI_ON  },  // MULTIPLICATION SIGN WITH DOT ABOVE
  { 0x2A31, BIDI_ON  },  // MULTIPLICATION SIGN WITH UNDERBAR
  { 0x2A32, BIDI_ON  },  // SEMIDIRECT PRODUCT WITH BOTTOM CLOSED
  { 0x2A33, BIDI_ON  },  // SMASH PRODUCT
  { 0x2A34, BIDI_ON  },  // MULTIPLICATION SIGN IN LEFT HALF CIRCLE
  { 0x2A35, BIDI_ON  },  // MULTIPLICATION SIGN IN RIGHT HALF CIRCLE
  { 0x2A36, BIDI_ON  },  // CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT
  { 0x2A37, BIDI_ON  },  // MULTIPLICATION SIGN IN DOUBLE CIRCLE
  { 0x2A38, BIDI_ON  },  // CIRCLED DIVISION SIGN
  { 0x2A39, BIDI_ON  },  // PLUS SIGN IN TRIANGLE
  { 0x2A3A, BIDI_ON  },  // MINUS SIGN IN TRIANGLE
  { 0x2A3B, BIDI_ON  },  // MULTIPLICATION SIGN IN TRIANGLE
  { 0x2A3C, BIDI_ON  },  // INTERIOR PRODUCT
  { 0x2A3D, BIDI_ON  },  // RIGHTHAND INTERIOR PRODUCT
  { 0x2A3E, BIDI_ON  },  // Z NOTATION RELATIONAL COMPOSITION
  { 0x2A3F, BIDI_ON  },  // AMALGAMATION OR COPRODUCT
  { 0x2A40, BIDI_ON  },  // INTERSECTION WITH DOT
  { 0x2A41, BIDI_ON  },  // UNION WITH MINUS SIGN
  { 0x2A42, BIDI_ON  },  // UNION WITH OVERBAR
  { 0x2A43, BIDI_ON  },  // INTERSECTION WITH OVERBAR
  { 0x2A44, BIDI_ON  },  // INTERSECTION WITH LOGICAL AND
  { 0x2A45, BIDI_ON  },  // UNION WITH LOGICAL OR
  { 0x2A46, BIDI_ON  },  // UNION ABOVE INTERSECTION
  { 0x2A47, BIDI_ON  },  // INTERSECTION ABOVE UNION
  { 0x2A48, BIDI_ON  },  // UNION ABOVE BAR ABOVE INTERSECTION
  { 0x2A49, BIDI_ON  },  // INTERSECTION ABOVE BAR ABOVE UNION
  { 0x2A4A, BIDI_ON  },  // UNION BESIDE AND JOINED WITH UNION
  { 0x2A4B, BIDI_ON  },  // INTERSECTION BESIDE AND JOINED WITH INTERSECTION
  { 0x2A4C, BIDI_ON  },  // CLOSED UNION WITH SERIFS
  { 0x2A4D, BIDI_ON  },  // CLOSED INTERSECTION WITH SERIFS
  { 0x2A4E, BIDI_ON  },  // DOUBLE SQUARE INTERSECTION
  { 0x2A4F, BIDI_ON  },  // DOUBLE SQUARE UNION
  { 0x2A50, BIDI_ON  },  // CLOSED UNION WITH SERIFS AND SMASH PRODUCT
  { 0x2A51, BIDI_ON  },  // LOGICAL AND WITH DOT ABOVE
  { 0x2A52, BIDI_ON  },  // LOGICAL OR WITH DOT ABOVE
  { 0x2A53, BIDI_ON  },  // DOUBLE LOGICAL AND
  { 0x2A54, BIDI_ON  },  // DOUBLE LOGICAL OR
  { 0x2A55, BIDI_ON  },  // TWO INTERSECTING LOGICAL AND
  { 0x2A56, BIDI_ON  },  // TWO INTERSECTING LOGICAL OR
  { 0x2A57, BIDI_ON  },  // SLOPING LARGE OR
  { 0x2A58, BIDI_ON  },  // SLOPING LARGE AND
  { 0x2A59, BIDI_ON  },  // LOGICAL OR OVERLAPPING LOGICAL AND
  { 0x2A5A, BIDI_ON  },  // LOGICAL AND WITH MIDDLE STEM
  { 0x2A5B, BIDI_ON  },  // LOGICAL OR WITH MIDDLE STEM
  { 0x2A5C, BIDI_ON  },  // LOGICAL AND WITH HORIZONTAL DASH
  { 0x2A5D, BIDI_ON  },  // LOGICAL OR WITH HORIZONTAL DASH
  { 0x2A5E, BIDI_ON  },  // LOGICAL AND WITH DOUBLE OVERBAR
  { 0x2A5F, BIDI_ON  },  // LOGICAL AND WITH UNDERBAR
  { 0x2A60, BIDI_ON  },  // LOGICAL AND WITH DOUBLE UNDERBAR
  { 0x2A61, BIDI_ON  },  // SMALL VEE WITH UNDERBAR
  { 0x2A62, BIDI_ON  },  // LOGICAL OR WITH DOUBLE OVERBAR
  { 0x2A63, BIDI_ON  },  // LOGICAL OR WITH DOUBLE UNDERBAR
  { 0x2A64, BIDI_ON  },  // Z NOTATION DOMAIN ANTIRESTRICTION
  { 0x2A65, BIDI_ON  },  // Z NOTATION RANGE ANTIRESTRICTION
  { 0x2A66, BIDI_ON  },  // EQUALS SIGN WITH DOT BELOW
  { 0x2A67, BIDI_ON  },  // IDENTICAL WITH DOT ABOVE
  { 0x2A68, BIDI_ON  },  // TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE
  { 0x2A69, BIDI_ON  },  // TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE
  { 0x2A6A, BIDI_ON  },  // TILDE OPERATOR WITH DOT ABOVE
  { 0x2A6B, BIDI_ON  },  // TILDE OPERATOR WITH RISING DOTS
  { 0x2A6C, BIDI_ON  },  // SIMILAR MINUS SIMILAR
  { 0x2A6D, BIDI_ON  },  // CONGRUENT WITH DOT ABOVE
  { 0x2A6E, BIDI_ON  },  // EQUALS WITH ASTERISK
  { 0x2A6F, BIDI_ON  },  // ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT
  { 0x2A70, BIDI_ON  },  // APPROXIMATELY EQUAL OR EQUAL TO
  { 0x2A71, BIDI_ON  },  // EQUALS SIGN ABOVE PLUS SIGN
  { 0x2A72, BIDI_ON  },  // PLUS SIGN ABOVE EQUALS SIGN
  { 0x2A73, BIDI_ON  },  // EQUALS SIGN ABOVE TILDE OPERATOR
  { 0x2A74, BIDI_ON  },  // DOUBLE COLON EQUAL
  { 0x2A75, BIDI_ON  },  // TWO CONSECUTIVE EQUALS SIGNS
  { 0x2A76, BIDI_ON  },  // THREE CONSECUTIVE EQUALS SIGNS
  { 0x2A77, BIDI_ON  },  // EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW
  { 0x2A78, BIDI_ON  },  // EQUIVALENT WITH FOUR DOTS ABOVE
  { 0x2A79, BIDI_ON  },  // LESS-THAN WITH CIRCLE INSIDE
  { 0x2A7A, BIDI_ON  },  // GREATER-THAN WITH CIRCLE INSIDE
  { 0x2A7B, BIDI_ON  },  // LESS-THAN WITH QUESTION MARK ABOVE
  { 0x2A7C, BIDI_ON  },  // GREATER-THAN WITH QUESTION MARK ABOVE
  { 0x2A7D, BIDI_ON  },  // LESS-THAN OR SLANTED EQUAL TO
  { 0x2A7E, BIDI_ON  },  // GREATER-THAN OR SLANTED EQUAL TO
  { 0x2A7F, BIDI_ON  },  // LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
  { 0x2A80, BIDI_ON  },  // GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
  { 0x2A81, BIDI_ON  },  // LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
  { 0x2A82, BIDI_ON  },  // GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
  { 0x2A83, BIDI_ON  },  // LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT
  { 0x2A84, BIDI_ON  },  // GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT
  { 0x2A85, BIDI_ON  },  // LESS-THAN OR APPROXIMATE
  { 0x2A86, BIDI_ON  },  // GREATER-THAN OR APPROXIMATE
  { 0x2A87, BIDI_ON  },  // LESS-THAN AND SINGLE-LINE NOT EQUAL TO
  { 0x2A88, BIDI_ON  },  // GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
  { 0x2A89, BIDI_ON  },  // LESS-THAN AND NOT APPROXIMATE
  { 0x2A8A, BIDI_ON  },  // GREATER-THAN AND NOT APPROXIMATE
  { 0x2A8B, BIDI_ON  },  // LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN
  { 0x2A8C, BIDI_ON  },  // GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN
  { 0x2A8D, BIDI_ON  },  // LESS-THAN ABOVE SIMILAR OR EQUAL
  { 0x2A8E, BIDI_ON  },  // GREATER-THAN ABOVE SIMILAR OR EQUAL
  { 0x2A8F, BIDI_ON  },  // LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN
  { 0x2A90, BIDI_ON  },  // GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN
  { 0x2A91, BIDI_ON  },  // LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL
  { 0x2A92, BIDI_ON  },  // GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL
  { 0x2A93, BIDI_ON  },  // LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL
  { 0x2A94, BIDI_ON  },  // GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL
  { 0x2A95, BIDI_ON  },  // SLANTED EQUAL TO OR LESS-THAN
  { 0x2A96, BIDI_ON  },  // SLANTED EQUAL TO OR GREATER-THAN
  { 0x2A97, BIDI_ON  },  // SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE
  { 0x2A98, BIDI_ON  },  // SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE
  { 0x2A99, BIDI_ON  },  // DOUBLE-LINE EQUAL TO OR LESS-THAN
  { 0x2A9A, BIDI_ON  },  // DOUBLE-LINE EQUAL TO OR GREATER-THAN
  { 0x2A9B, BIDI_ON  },  // DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN
  { 0x2A9C, BIDI_ON  },  // DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN
  { 0x2A9D, BIDI_ON  },  // SIMILAR OR LESS-THAN
  { 0x2A9E, BIDI_ON  },  // SIMILAR OR GREATER-THAN
  { 0x2A9F, BIDI_ON  },  // SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN
  { 0x2AA0, BIDI_ON  },  // SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN
  { 0x2AA1, BIDI_ON  },  // DOUBLE NESTED LESS-THAN
  { 0x2AA2, BIDI_ON  },  // DOUBLE NESTED GREATER-THAN
  { 0x2AA3, BIDI_ON  },  // DOUBLE NESTED LESS-THAN WITH UNDERBAR
  { 0x2AA4, BIDI_ON  },  // GREATER-THAN OVERLAPPING LESS-THAN
  { 0x2AA5, BIDI_ON  },  // GREATER-THAN BESIDE LESS-THAN
  { 0x2AA6, BIDI_ON  },  // LESS-THAN CLOSED BY CURVE
  { 0x2AA7, BIDI_ON  },  // GREATER-THAN CLOSED BY CURVE
  { 0x2AA8, BIDI_ON  },  // LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
  { 0x2AA9, BIDI_ON  },  // GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
  { 0x2AAA, BIDI_ON  },  // SMALLER THAN
  { 0x2AAB, BIDI_ON  },  // LARGER THAN
  { 0x2AAC, BIDI_ON  },  // SMALLER THAN OR EQUAL TO
  { 0x2AAD, BIDI_ON  },  // LARGER THAN OR EQUAL TO
  { 0x2AAE, BIDI_ON  },  // EQUALS SIGN WITH BUMPY ABOVE
  { 0x2AAF, BIDI_ON  },  // PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
  { 0x2AB0, BIDI_ON  },  // SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
  { 0x2AB1, BIDI_ON  },  // PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO
  { 0x2AB2, BIDI_ON  },  // SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO
  { 0x2AB3, BIDI_ON  },  // PRECEDES ABOVE EQUALS SIGN
  { 0x2AB4, BIDI_ON  },  // SUCCEEDS ABOVE EQUALS SIGN
  { 0x2AB5, BIDI_ON  },  // PRECEDES ABOVE NOT EQUAL TO
  { 0x2AB6, BIDI_ON  },  // SUCCEEDS ABOVE NOT EQUAL TO
  { 0x2AB7, BIDI_ON  },  // PRECEDES ABOVE ALMOST EQUAL TO
  { 0x2AB8, BIDI_ON  },  // SUCCEEDS ABOVE ALMOST EQUAL TO
  { 0x2AB9, BIDI_ON  },  // PRECEDES ABOVE NOT ALMOST EQUAL TO
  { 0x2ABA, BIDI_ON  },  // SUCCEEDS ABOVE NOT ALMOST EQUAL TO
  { 0x2ABB, BIDI_ON  },  // DOUBLE PRECEDES
  { 0x2ABC, BIDI_ON  },  // DOUBLE SUCCEEDS
  { 0x2ABD, BIDI_ON  },  // SUBSET WITH DOT
  { 0x2ABE, BIDI_ON  },  // SUPERSET WITH DOT
  { 0x2ABF, BIDI_ON  },  // SUBSET WITH PLUS SIGN BELOW
  { 0x2AC0, BIDI_ON  },  // SUPERSET WITH PLUS SIGN BELOW
  { 0x2AC1, BIDI_ON  },  // SUBSET WITH MULTIPLICATION SIGN BELOW
  { 0x2AC2, BIDI_ON  },  // SUPERSET WITH MULTIPLICATION SIGN BELOW
  { 0x2AC3, BIDI_ON  },  // SUBSET OF OR EQUAL TO WITH DOT ABOVE
  { 0x2AC4, BIDI_ON  },  // SUPERSET OF OR EQUAL TO WITH DOT ABOVE
  { 0x2AC5, BIDI_ON  },  // SUBSET OF ABOVE EQUALS SIGN
  { 0x2AC6, BIDI_ON  },  // SUPERSET OF ABOVE EQUALS SIGN
  { 0x2AC7, BIDI_ON  },  // SUBSET OF ABOVE TILDE OPERATOR
  { 0x2AC8, BIDI_ON  },  // SUPERSET OF ABOVE TILDE OPERATOR
  { 0x2AC9, BIDI_ON  },  // SUBSET OF ABOVE ALMOST EQUAL TO
  { 0x2ACA, BIDI_ON  },  // SUPERSET OF ABOVE ALMOST EQUAL TO
  { 0x2ACB, BIDI_ON  },  // SUBSET OF ABOVE NOT EQUAL TO
  { 0x2ACC, BIDI_ON  },  // SUPERSET OF ABOVE NOT EQUAL TO
  { 0x2ACD, BIDI_ON  },  // SQUARE LEFT OPEN BOX OPERATOR
  { 0x2ACE, BIDI_ON  },  // SQUARE RIGHT OPEN BOX OPERATOR
  { 0x2ACF, BIDI_ON  },  // CLOSED SUBSET
  { 0x2AD0, BIDI_ON  },  // CLOSED SUPERSET
  { 0x2AD1, BIDI_ON  },  // CLOSED SUBSET OR EQUAL TO
  { 0x2AD2, BIDI_ON  },  // CLOSED SUPERSET OR EQUAL TO
  { 0x2AD3, BIDI_ON  },  // SUBSET ABOVE SUPERSET
  { 0x2AD4, BIDI_ON  },  // SUPERSET ABOVE SUBSET
  { 0x2AD5, BIDI_ON  },  // SUBSET ABOVE SUBSET
  { 0x2AD6, BIDI_ON  },  // SUPERSET ABOVE SUPERSET
  { 0x2AD7, BIDI_ON  },  // SUPERSET BESIDE SUBSET
  { 0x2AD8, BIDI_ON  },  // SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET
  { 0x2AD9, BIDI_ON  },  // ELEMENT OF OPENING DOWNWARDS
  { 0x2ADA, BIDI_ON  },  // PITCHFORK WITH TEE TOP
  { 0x2ADB, BIDI_ON  },  // TRANSVERSAL INTERSECTION
  { 0x2ADC, BIDI_ON  },  // FORKING
  { 0x2ADD, BIDI_ON  },  // NONFORKING
  { 0x2ADE, BIDI_ON  },  // SHORT LEFT TACK
  { 0x2ADF, BIDI_ON  },  // SHORT DOWN TACK
  { 0x2AE0, BIDI_ON  },  // SHORT UP TACK
  { 0x2AE1, BIDI_ON  },  // PERPENDICULAR WITH S
  { 0x2AE2, BIDI_ON  },  // VERTICAL BAR TRIPLE RIGHT TURNSTILE
  { 0x2AE3, BIDI_ON  },  // DOUBLE VERTICAL BAR LEFT TURNSTILE
  { 0x2AE4, BIDI_ON  },  // VERTICAL BAR DOUBLE LEFT TURNSTILE
  { 0x2AE5, BIDI_ON  },  // DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE
  { 0x2AE6, BIDI_ON  },  // LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL
  { 0x2AE7, BIDI_ON  },  // SHORT DOWN TACK WITH OVERBAR
  { 0x2AE8, BIDI_ON  },  // SHORT UP TACK WITH UNDERBAR
  { 0x2AE9, BIDI_ON  },  // SHORT UP TACK ABOVE SHORT DOWN TACK
  { 0x2AEA, BIDI_ON  },  // DOUBLE DOWN TACK
  { 0x2AEB, BIDI_ON  },  // DOUBLE UP TACK
  { 0x2AEC, BIDI_ON  },  // DOUBLE STROKE NOT SIGN
  { 0x2AED, BIDI_ON  },  // REVERSED DOUBLE STROKE NOT SIGN
  { 0x2AEE, BIDI_ON  },  // DOES NOT DIVIDE WITH REVERSED NEGATION SLASH
  { 0x2AEF, BIDI_ON  },  // VERTICAL LINE WITH CIRCLE ABOVE
  { 0x2AF0, BIDI_ON  },  // VERTICAL LINE WITH CIRCLE BELOW
  { 0x2AF1, BIDI_ON  },  // DOWN TACK WITH CIRCLE BELOW
  { 0x2AF2, BIDI_ON  },  // PARALLEL WITH HORIZONTAL STROKE
  { 0x2AF3, BIDI_ON  },  // PARALLEL WITH TILDE OPERATOR
  { 0x2AF4, BIDI_ON  },  // TRIPLE VERTICAL BAR BINARY RELATION
  { 0x2AF5, BIDI_ON  },  // TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE
  { 0x2AF6, BIDI_ON  },  // TRIPLE COLON OPERATOR
  { 0x2AF7, BIDI_ON  },  // TRIPLE NESTED LESS-THAN
  { 0x2AF8, BIDI_ON  },  // TRIPLE NESTED GREATER-THAN
  { 0x2AF9, BIDI_ON  },  // DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO
  { 0x2AFA, BIDI_ON  },  // DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO
  { 0x2AFB, BIDI_ON  },  // TRIPLE SOLIDUS BINARY RELATION
  { 0x2AFC, BIDI_ON  },  // LARGE TRIPLE VERTICAL BAR OPERATOR
  { 0x2AFD, BIDI_ON  },  // DOUBLE SOLIDUS OPERATOR
  { 0x2AFE, BIDI_ON  },  // WHITE VERTICAL BAR
  { 0x2AFF, BIDI_ON  },  // N-ARY WHITE VERTICAL BAR
  { 0x2B00, BIDI_ON  },  // NORTH EAST WHITE ARROW
  { 0x2B01, BIDI_ON  },  // NORTH WEST WHITE ARROW
  { 0x2B02, BIDI_ON  },  // SOUTH EAST WHITE ARROW
  { 0x2B03, BIDI_ON  },  // SOUTH WEST WHITE ARROW
  { 0x2B04, BIDI_ON  },  // LEFT RIGHT WHITE ARROW
  { 0x2B05, BIDI_ON  },  // LEFTWARDS BLACK ARROW
  { 0x2B06, BIDI_ON  },  // UPWARDS BLACK ARROW
  { 0x2B07, BIDI_ON  },  // DOWNWARDS BLACK ARROW
  { 0x2B08, BIDI_ON  },  // NORTH EAST BLACK ARROW
  { 0x2B09, BIDI_ON  },  // NORTH WEST BLACK ARROW
  { 0x2B0A, BIDI_ON  },  // SOUTH EAST BLACK ARROW
  { 0x2B0B, BIDI_ON  },  // SOUTH WEST BLACK ARROW
  { 0x2B0C, BIDI_ON  },  // LEFT RIGHT BLACK ARROW
  { 0x2B0D, BIDI_ON  },  // UP DOWN BLACK ARROW
  { 0x2B0E, BIDI_ON  },  // RIGHTWARDS ARROW WITH TIP DOWNWARDS
  { 0x2B0F, BIDI_ON  },  // RIGHTWARDS ARROW WITH TIP UPWARDS
  { 0x2B10, BIDI_ON  },  // LEFTWARDS ARROW WITH TIP DOWNWARDS
  { 0x2B11, BIDI_ON  },  // LEFTWARDS ARROW WITH TIP UPWARDS
  { 0x2B12, BIDI_ON  },  // SQUARE WITH TOP HALF BLACK
  { 0x2B13, BIDI_ON  },  // SQUARE WITH BOTTOM HALF BLACK
  { 0x2B14, BIDI_ON  },  // SQUARE WITH UPPER RIGHT DIAGONAL HALF BLACK
  { 0x2B15, BIDI_ON  },  // SQUARE WITH LOWER LEFT DIAGONAL HALF BLACK
  { 0x2B16, BIDI_ON  },  // DIAMOND WITH LEFT HALF BLACK
  { 0x2B17, BIDI_ON  },  // DIAMOND WITH RIGHT HALF BLACK
  { 0x2B18, BIDI_ON  },  // DIAMOND WITH TOP HALF BLACK
  { 0x2B19, BIDI_ON  },  // DIAMOND WITH BOTTOM HALF BLACK
  { 0x2B1A, BIDI_ON  },  // DOTTED SQUARE
  { 0x2B1B, BIDI_ON  },  // BLACK LARGE SQUARE
  { 0x2B1C, BIDI_ON  },  // WHITE LARGE SQUARE
  { 0x2B1D, BIDI_ON  },  // BLACK VERY SMALL SQUARE
  { 0x2B1E, BIDI_ON  },  // WHITE VERY SMALL SQUARE
  { 0x2B1F, BIDI_ON  },  // BLACK PENTAGON
  { 0x2B20, BIDI_ON  },  // WHITE PENTAGON
  { 0x2B21, BIDI_ON  },  // WHITE HEXAGON
  { 0x2B22, BIDI_ON  },  // BLACK HEXAGON
  { 0x2B23, BIDI_ON  },  // HORIZONTAL BLACK HEXAGON
  { 0x2B24, BIDI_ON  },  // BLACK LARGE CIRCLE
  { 0x2B25, BIDI_ON  },  // BLACK MEDIUM DIAMOND
  { 0x2B26, BIDI_ON  },  // WHITE MEDIUM DIAMOND
  { 0x2B27, BIDI_ON  },  // BLACK MEDIUM LOZENGE
  { 0x2B28, BIDI_ON  },  // WHITE MEDIUM LOZENGE
  { 0x2B29, BIDI_ON  },  // BLACK SMALL DIAMOND
  { 0x2B2A, BIDI_ON  },  // BLACK SMALL LOZENGE
  { 0x2B2B, BIDI_ON  },  // WHITE SMALL LOZENGE
  { 0x2B2C, BIDI_ON  },  // BLACK HORIZONTAL ELLIPSE
  { 0x2B2D, BIDI_ON  },  // WHITE HORIZONTAL ELLIPSE
  { 0x2B2E, BIDI_ON  },  // BLACK VERTICAL ELLIPSE
  { 0x2B2F, BIDI_ON  },  // WHITE VERTICAL ELLIPSE
  { 0x2B30, BIDI_ON  },  // LEFT ARROW WITH SMALL CIRCLE
  { 0x2B31, BIDI_ON  },  // THREE LEFTWARDS ARROWS
  { 0x2B32, BIDI_ON  },  // LEFT ARROW WITH CIRCLED PLUS
  { 0x2B33, BIDI_ON  },  // LONG LEFTWARDS SQUIGGLE ARROW
  { 0x2B34, BIDI_ON  },  // LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
  { 0x2B35, BIDI_ON  },  // LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
  { 0x2B36, BIDI_ON  },  // LEFTWARDS TWO-HEADED ARROW FROM BAR
  { 0x2B37, BIDI_ON  },  // LEFTWARDS TWO-HEADED TRIPLE DASH ARROW
  { 0x2B38, BIDI_ON  },  // LEFTWARDS ARROW WITH DOTTED STEM
  { 0x2B39, BIDI_ON  },  // LEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKE
  { 0x2B3A, BIDI_ON  },  // LEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
  { 0x2B3B, BIDI_ON  },  // LEFTWARDS TWO-HEADED ARROW WITH TAIL
  { 0x2B3C, BIDI_ON  },  // LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE
  { 0x2B3D, BIDI_ON  },  // LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
  { 0x2B3E, BIDI_ON  },  // LEFTWARDS ARROW THROUGH X
  { 0x2B3F, BIDI_ON  },  // WAVE ARROW POINTING DIRECTLY LEFT
  { 0x2B40, BIDI_ON  },  // EQUALS SIGN ABOVE LEFTWARDS ARROW
  { 0x2B41, BIDI_ON  },  // REVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROW
  { 0x2B42, BIDI_ON  },  // LEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO
  { 0x2B43, BIDI_ON  },  // RIGHTWARDS ARROW THROUGH GREATER-THAN
  { 0x2B44, BIDI_ON  },  // RIGHTWARDS ARROW THROUGH SUPERSET
  { 0x2B45, BIDI_ON  },  // LEFTWARDS QUADRUPLE ARROW
  { 0x2B46, BIDI_ON  },  // RIGHTWARDS QUADRUPLE ARROW
  { 0x2B47, BIDI_ON  },  // REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW
  { 0x2B48, BIDI_ON  },  // RIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO
  { 0x2B49, BIDI_ON  },  // TILDE OPERATOR ABOVE LEFTWARDS ARROW
  { 0x2B4A, BIDI_ON  },  // LEFTWARDS ARROW ABOVE ALMOST EQUAL TO
  { 0x2B4B, BIDI_ON  },  // LEFTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
  { 0x2B4C, BIDI_ON  },  // RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
  { 0x2B4D, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED ZIGZAG ARROW
  { 0x2B4E, BIDI_ON  },  // SHORT SLANTED NORTH ARROW
  { 0x2B4F, BIDI_ON  },  // SHORT BACKSLANTED SOUTH ARROW
  { 0x2B50, BIDI_ON  },  // WHITE MEDIUM STAR
  { 0x2B51, BIDI_ON  },  // BLACK SMALL STAR
  { 0x2B52, BIDI_ON  },  // WHITE SMALL STAR
  { 0x2B53, BIDI_ON  },  // BLACK RIGHT-POINTING PENTAGON
  { 0x2B54, BIDI_ON  },  // WHITE RIGHT-POINTING PENTAGON
  { 0x2B55, BIDI_ON  },  // HEAVY LARGE CIRCLE
  { 0x2B56, BIDI_ON  },  // HEAVY OVAL WITH OVAL INSIDE
  { 0x2B57, BIDI_ON  },  // HEAVY CIRCLE WITH CIRCLE INSIDE
  { 0x2B58, BIDI_ON  },  // HEAVY CIRCLE
  { 0x2B59, BIDI_ON  },  // HEAVY CIRCLED SALTIRE
  { 0x2B5A, BIDI_ON  },  // SLANTED NORTH ARROW WITH HOOKED HEAD
  { 0x2B5B, BIDI_ON  },  // BACKSLANTED SOUTH ARROW WITH HOOKED TAIL
  { 0x2B5C, BIDI_ON  },  // SLANTED NORTH ARROW WITH HORIZONTAL TAIL
  { 0x2B5D, BIDI_ON  },  // BACKSLANTED SOUTH ARROW WITH HORIZONTAL TAIL
  { 0x2B5E, BIDI_ON  },  // BENT ARROW POINTING DOWNWARDS THEN NORTH EAST
  { 0x2B5F, BIDI_ON  },  // SHORT BENT ARROW POINTING DOWNWARDS THEN NORTH EAST
  { 0x2B60, BIDI_ON  },  // LEFTWARDS TRIANGLE-HEADED ARROW
  { 0x2B61, BIDI_ON  },  // UPWARDS TRIANGLE-HEADED ARROW
  { 0x2B62, BIDI_ON  },  // RIGHTWARDS TRIANGLE-HEADED ARROW
  { 0x2B63, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED ARROW
  { 0x2B64, BIDI_ON  },  // LEFT RIGHT TRIANGLE-HEADED ARROW
  { 0x2B65, BIDI_ON  },  // UP DOWN TRIANGLE-HEADED ARROW
  { 0x2B66, BIDI_ON  },  // NORTH WEST TRIANGLE-HEADED ARROW
  { 0x2B67, BIDI_ON  },  // NORTH EAST TRIANGLE-HEADED ARROW
  { 0x2B68, BIDI_ON  },  // SOUTH EAST TRIANGLE-HEADED ARROW
  { 0x2B69, BIDI_ON  },  // SOUTH WEST TRIANGLE-HEADED ARROW
  { 0x2B6A, BIDI_ON  },  // LEFTWARDS TRIANGLE-HEADED DASHED ARROW
  { 0x2B6B, BIDI_ON  },  // UPWARDS TRIANGLE-HEADED DASHED ARROW
  { 0x2B6C, BIDI_ON  },  // RIGHTWARDS TRIANGLE-HEADED DASHED ARROW
  { 0x2B6D, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED DASHED ARROW
  { 0x2B6E, BIDI_ON  },  // CLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROW
  { 0x2B6F, BIDI_ON  },  // ANTICLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROW
  { 0x2B70, BIDI_ON  },  // LEFTWARDS TRIANGLE-HEADED ARROW TO BAR
  { 0x2B71, BIDI_ON  },  // UPWARDS TRIANGLE-HEADED ARROW TO BAR
  { 0x2B72, BIDI_ON  },  // RIGHTWARDS TRIANGLE-HEADED ARROW TO BAR
  { 0x2B73, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED ARROW TO BAR
  { 0x2B76, BIDI_ON  },  // NORTH WEST TRIANGLE-HEADED ARROW TO BAR
  { 0x2B77, BIDI_ON  },  // NORTH EAST TRIANGLE-HEADED ARROW TO BAR
  { 0x2B78, BIDI_ON  },  // SOUTH EAST TRIANGLE-HEADED ARROW TO BAR
  { 0x2B79, BIDI_ON  },  // SOUTH WEST TRIANGLE-HEADED ARROW TO BAR
  { 0x2B7A, BIDI_ON  },  // LEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE
  { 0x2B7B, BIDI_ON  },  // UPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE
  { 0x2B7C, BIDI_ON  },  // RIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE
  { 0x2B7D, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE
  { 0x2B7E, BIDI_ON  },  // HORIZONTAL TAB KEY
  { 0x2B7F, BIDI_ON  },  // VERTICAL TAB KEY
  { 0x2B80, BIDI_ON  },  // LEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANGLE-HEADED ARROW
  { 0x2B81, BIDI_ON  },  // UPWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW
  { 0x2B82, BIDI_ON  },  // RIGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGLE-HEADED ARROW
  { 0x2B83, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW
  { 0x2B84, BIDI_ON  },  // LEFTWARDS TRIANGLE-HEADED PAIRED ARROWS
  { 0x2B85, BIDI_ON  },  // UPWARDS TRIANGLE-HEADED PAIRED ARROWS
  { 0x2B86, BIDI_ON  },  // RIGHTWARDS TRIANGLE-HEADED PAIRED ARROWS
  { 0x2B87, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED PAIRED ARROWS
  { 0x2B88, BIDI_ON  },  // LEFTWARDS BLACK CIRCLED WHITE ARROW
  { 0x2B89, BIDI_ON  },  // UPWARDS BLACK CIRCLED WHITE ARROW
  { 0x2B8A, BIDI_ON  },  // RIGHTWARDS BLACK CIRCLED WHITE ARROW
  { 0x2B8B, BIDI_ON  },  // DOWNWARDS BLACK CIRCLED WHITE ARROW
  { 0x2B8C, BIDI_ON  },  // ANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROW
  { 0x2B8D, BIDI_ON  },  // ANTICLOCKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROW
  { 0x2B8E, BIDI_ON  },  // ANTICLOCKWISE TRIANGLE-HEADED LEFT U-SHAPED ARROW
  { 0x2B8F, BIDI_ON  },  // ANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED ARROW
  { 0x2B90, BIDI_ON  },  // RETURN LEFT
  { 0x2B91, BIDI_ON  },  // RETURN RIGHT
  { 0x2B92, BIDI_ON  },  // NEWLINE LEFT
  { 0x2B93, BIDI_ON  },  // NEWLINE RIGHT
  { 0x2B94, BIDI_ON  },  // FOUR CORNER ARROWS CIRCLING ANTICLOCKWISE
  { 0x2B95, BIDI_ON  },  // RIGHTWARDS BLACK ARROW
  { 0x2B98, BIDI_ON  },  // THREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEAD
  { 0x2B99, BIDI_ON  },  // THREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD
  { 0x2B9A, BIDI_ON  },  // THREE-D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEAD
  { 0x2B9B, BIDI_ON  },  // THREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD
  { 0x2B9C, BIDI_ON  },  // BLACK LEFTWARDS EQUILATERAL ARROWHEAD
  { 0x2B9D, BIDI_ON  },  // BLACK UPWARDS EQUILATERAL ARROWHEAD
  { 0x2B9E, BIDI_ON  },  // BLACK RIGHTWARDS EQUILATERAL ARROWHEAD
  { 0x2B9F, BIDI_ON  },  // BLACK DOWNWARDS EQUILATERAL ARROWHEAD
  { 0x2BA0, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDS
  { 0x2BA1, BIDI_ON  },  // DOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDS
  { 0x2BA2, BIDI_ON  },  // UPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDS
  { 0x2BA3, BIDI_ON  },  // UPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDS
  { 0x2BA4, BIDI_ON  },  // LEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDS
  { 0x2BA5, BIDI_ON  },  // RIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDS
  { 0x2BA6, BIDI_ON  },  // LEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS
  { 0x2BA7, BIDI_ON  },  // RIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS
  { 0x2BA8, BIDI_ON  },  // BLACK CURVED DOWNWARDS AND LEFTWARDS ARROW
  { 0x2BA9, BIDI_ON  },  // BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW
  { 0x2BAA, BIDI_ON  },  // BLACK CURVED UPWARDS AND LEFTWARDS ARROW
  { 0x2BAB, BIDI_ON  },  // BLACK CURVED UPWARDS AND RIGHTWARDS ARROW
  { 0x2BAC, BIDI_ON  },  // BLACK CURVED LEFTWARDS AND UPWARDS ARROW
  { 0x2BAD, BIDI_ON  },  // BLACK CURVED RIGHTWARDS AND UPWARDS ARROW
  { 0x2BAE, BIDI_ON  },  // BLACK CURVED LEFTWARDS AND DOWNWARDS ARROW
  { 0x2BAF, BIDI_ON  },  // BLACK CURVED RIGHTWARDS AND DOWNWARDS ARROW
  { 0x2BB0, BIDI_ON  },  // RIBBON ARROW DOWN LEFT
  { 0x2BB1, BIDI_ON  },  // RIBBON ARROW DOWN RIGHT
  { 0x2BB2, BIDI_ON  },  // RIBBON ARROW UP LEFT
  { 0x2BB3, BIDI_ON  },  // RIBBON ARROW UP RIGHT
  { 0x2BB4, BIDI_ON  },  // RIBBON ARROW LEFT UP
  { 0x2BB5, BIDI_ON  },  // RIBBON ARROW RIGHT UP
  { 0x2BB6, BIDI_ON  },  // RIBBON ARROW LEFT DOWN
  { 0x2BB7, BIDI_ON  },  // RIBBON ARROW RIGHT DOWN
  { 0x2BB8, BIDI_ON  },  // UPWARDS WHITE ARROW FROM BAR WITH HORIZONTAL BAR
  { 0x2BB9, BIDI_ON  },  // UP ARROWHEAD IN A RECTANGLE BOX
  { 0x2BBD, BIDI_ON  },  // BALLOT BOX WITH LIGHT X
  { 0x2BBE, BIDI_ON  },  // CIRCLED X
  { 0x2BBF, BIDI_ON  },  // CIRCLED BOLD X
  { 0x2BC0, BIDI_ON  },  // BLACK SQUARE CENTRED
  { 0x2BC1, BIDI_ON  },  // BLACK DIAMOND CENTRED
  { 0x2BC2, BIDI_ON  },  // TURNED BLACK PENTAGON
  { 0x2BC3, BIDI_ON  },  // HORIZONTAL BLACK OCTAGON
  { 0x2BC4, BIDI_ON  },  // BLACK OCTAGON
  { 0x2BC5, BIDI_ON  },  // BLACK MEDIUM UP-POINTING TRIANGLE CENTRED
  { 0x2BC6, BIDI_ON  },  // BLACK MEDIUM DOWN-POINTING TRIANGLE CENTRED
  { 0x2BC7, BIDI_ON  },  // BLACK MEDIUM LEFT-POINTING TRIANGLE CENTRED
  { 0x2BC8, BIDI_ON  },  // BLACK MEDIUM RIGHT-POINTING TRIANGLE CENTRED
  { 0x2BCA, BIDI_ON  },  // TOP HALF BLACK CIRCLE
  { 0x2BCB, BIDI_ON  },  // BOTTOM HALF BLACK CIRCLE
  { 0x2BCC, BIDI_ON  },  // LIGHT FOUR POINTED BLACK CUSP
  { 0x2BCD, BIDI_ON  },  // ROTATED LIGHT FOUR POINTED BLACK CUSP
  { 0x2BCE, BIDI_ON  },  // WHITE FOUR POINTED CUSP
  { 0x2BCF, BIDI_ON  },  // ROTATED WHITE FOUR POINTED CUSP
  { 0x2BD0, BIDI_ON  },  // SQUARE POSITION INDICATOR
  { 0x2BD1, BIDI_ON  },  // UNCERTAINTY SIGN
  { 0x2BEC, BIDI_ON  },  // LEFTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS
  { 0x2BED, BIDI_ON  },  // UPWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS
  { 0x2BEE, BIDI_ON  },  // RIGHTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS
  { 0x2BEF, BIDI_ON  },  // DOWNWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS
  { 0x2C00, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER AZU
  { 0x2C01, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER BUKY
  { 0x2C02, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER VEDE
  { 0x2C03, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER GLAGOLI
  { 0x2C04, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER DOBRO
  { 0x2C05, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER YESTU
  { 0x2C06, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER ZHIVETE
  { 0x2C07, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER DZELO
  { 0x2C08, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER ZEMLJA
  { 0x2C09, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER IZHE
  { 0x2C0A, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER INITIAL IZHE
  { 0x2C0B, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER I
  { 0x2C0C, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER DJERVI
  { 0x2C0D, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER KAKO
  { 0x2C0E, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER LJUDIJE
  { 0x2C0F, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER MYSLITE
  { 0x2C10, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER NASHI
  { 0x2C11, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER ONU
  { 0x2C12, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER POKOJI
  { 0x2C13, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER RITSI
  { 0x2C14, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER SLOVO
  { 0x2C15, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER TVRIDO
  { 0x2C16, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER UKU
  { 0x2C17, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER FRITU
  { 0x2C18, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER HERU
  { 0x2C19, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER OTU
  { 0x2C1A, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER PE
  { 0x2C1B, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER SHTA
  { 0x2C1C, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER TSI
  { 0x2C1D, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER CHRIVI
  { 0x2C1E, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER SHA
  { 0x2C1F, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER YERU
  { 0x2C20, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER YERI
  { 0x2C21, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER YATI
  { 0x2C22, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER SPIDERY HA
  { 0x2C23, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER YU
  { 0x2C24, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER SMALL YUS
  { 0x2C25, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL
  { 0x2C26, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER YO
  { 0x2C27, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS
  { 0x2C28, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER BIG YUS
  { 0x2C29, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS
  { 0x2C2A, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER FITA
  { 0x2C2B, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER IZHITSA
  { 0x2C2C, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER SHTAPIC
  { 0x2C2D, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER TROKUTASTI A
  { 0x2C2E, BIDI_L   },  // GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
  { 0x2C30, BIDI_L   },  // GLAGOLITIC SMALL LETTER AZU
  { 0x2C31, BIDI_L   },  // GLAGOLITIC SMALL LETTER BUKY
  { 0x2C32, BIDI_L   },  // GLAGOLITIC SMALL LETTER VEDE
  { 0x2C33, BIDI_L   },  // GLAGOLITIC SMALL LETTER GLAGOLI
  { 0x2C34, BIDI_L   },  // GLAGOLITIC SMALL LETTER DOBRO
  { 0x2C35, BIDI_L   },  // GLAGOLITIC SMALL LETTER YESTU
  { 0x2C36, BIDI_L   },  // GLAGOLITIC SMALL LETTER ZHIVETE
  { 0x2C37, BIDI_L   },  // GLAGOLITIC SMALL LETTER DZELO
  { 0x2C38, BIDI_L   },  // GLAGOLITIC SMALL LETTER ZEMLJA
  { 0x2C39, BIDI_L   },  // GLAGOLITIC SMALL LETTER IZHE
  { 0x2C3A, BIDI_L   },  // GLAGOLITIC SMALL LETTER INITIAL IZHE
  { 0x2C3B, BIDI_L   },  // GLAGOLITIC SMALL LETTER I
  { 0x2C3C, BIDI_L   },  // GLAGOLITIC SMALL LETTER DJERVI
  { 0x2C3D, BIDI_L   },  // GLAGOLITIC SMALL LETTER KAKO
  { 0x2C3E, BIDI_L   },  // GLAGOLITIC SMALL LETTER LJUDIJE
  { 0x2C3F, BIDI_L   },  // GLAGOLITIC SMALL LETTER MYSLITE
  { 0x2C40, BIDI_L   },  // GLAGOLITIC SMALL LETTER NASHI
  { 0x2C41, BIDI_L   },  // GLAGOLITIC SMALL LETTER ONU
  { 0x2C42, BIDI_L   },  // GLAGOLITIC SMALL LETTER POKOJI
  { 0x2C43, BIDI_L   },  // GLAGOLITIC SMALL LETTER RITSI
  { 0x2C44, BIDI_L   },  // GLAGOLITIC SMALL LETTER SLOVO
  { 0x2C45, BIDI_L   },  // GLAGOLITIC SMALL LETTER TVRIDO
  { 0x2C46, BIDI_L   },  // GLAGOLITIC SMALL LETTER UKU
  { 0x2C47, BIDI_L   },  // GLAGOLITIC SMALL LETTER FRITU
  { 0x2C48, BIDI_L   },  // GLAGOLITIC SMALL LETTER HERU
  { 0x2C49, BIDI_L   },  // GLAGOLITIC SMALL LETTER OTU
  { 0x2C4A, BIDI_L   },  // GLAGOLITIC SMALL LETTER PE
  { 0x2C4B, BIDI_L   },  // GLAGOLITIC SMALL LETTER SHTA
  { 0x2C4C, BIDI_L   },  // GLAGOLITIC SMALL LETTER TSI
  { 0x2C4D, BIDI_L   },  // GLAGOLITIC SMALL LETTER CHRIVI
  { 0x2C4E, BIDI_L   },  // GLAGOLITIC SMALL LETTER SHA
  { 0x2C4F, BIDI_L   },  // GLAGOLITIC SMALL LETTER YERU
  { 0x2C50, BIDI_L   },  // GLAGOLITIC SMALL LETTER YERI
  { 0x2C51, BIDI_L   },  // GLAGOLITIC SMALL LETTER YATI
  { 0x2C52, BIDI_L   },  // GLAGOLITIC SMALL LETTER SPIDERY HA
  { 0x2C53, BIDI_L   },  // GLAGOLITIC SMALL LETTER YU
  { 0x2C54, BIDI_L   },  // GLAGOLITIC SMALL LETTER SMALL YUS
  { 0x2C55, BIDI_L   },  // GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL
  { 0x2C56, BIDI_L   },  // GLAGOLITIC SMALL LETTER YO
  { 0x2C57, BIDI_L   },  // GLAGOLITIC SMALL LETTER IOTATED SMALL YUS
  { 0x2C58, BIDI_L   },  // GLAGOLITIC SMALL LETTER BIG YUS
  { 0x2C59, BIDI_L   },  // GLAGOLITIC SMALL LETTER IOTATED BIG YUS
  { 0x2C5A, BIDI_L   },  // GLAGOLITIC SMALL LETTER FITA
  { 0x2C5B, BIDI_L   },  // GLAGOLITIC SMALL LETTER IZHITSA
  { 0x2C5C, BIDI_L   },  // GLAGOLITIC SMALL LETTER SHTAPIC
  { 0x2C5D, BIDI_L   },  // GLAGOLITIC SMALL LETTER TROKUTASTI A
  { 0x2C5E, BIDI_L   },  // GLAGOLITIC SMALL LETTER LATINATE MYSLITE
  { 0x2C60, BIDI_L   },  // LATIN CAPITAL LETTER L WITH DOUBLE BAR
  { 0x2C61, BIDI_L   },  // LATIN SMALL LETTER L WITH DOUBLE BAR
  { 0x2C62, BIDI_L   },  // LATIN CAPITAL LETTER L WITH MIDDLE TILDE
  { 0x2C63, BIDI_L   },  // LATIN CAPITAL LETTER P WITH STROKE
  { 0x2C64, BIDI_L   },  // LATIN CAPITAL LETTER R WITH TAIL
  { 0x2C65, BIDI_L   },  // LATIN SMALL LETTER A WITH STROKE
  { 0x2C66, BIDI_L   },  // LATIN SMALL LETTER T WITH DIAGONAL STROKE
  { 0x2C67, BIDI_L   },  // LATIN CAPITAL LETTER H WITH DESCENDER
  { 0x2C68, BIDI_L   },  // LATIN SMALL LETTER H WITH DESCENDER
  { 0x2C69, BIDI_L   },  // LATIN CAPITAL LETTER K WITH DESCENDER
  { 0x2C6A, BIDI_L   },  // LATIN SMALL LETTER K WITH DESCENDER
  { 0x2C6B, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH DESCENDER
  { 0x2C6C, BIDI_L   },  // LATIN SMALL LETTER Z WITH DESCENDER
  { 0x2C6D, BIDI_L   },  // LATIN CAPITAL LETTER ALPHA
  { 0x2C6E, BIDI_L   },  // LATIN CAPITAL LETTER M WITH HOOK
  { 0x2C6F, BIDI_L   },  // LATIN CAPITAL LETTER TURNED A
  { 0x2C70, BIDI_L   },  // LATIN CAPITAL LETTER TURNED ALPHA
  { 0x2C71, BIDI_L   },  // LATIN SMALL LETTER V WITH RIGHT HOOK
  { 0x2C72, BIDI_L   },  // LATIN CAPITAL LETTER W WITH HOOK
  { 0x2C73, BIDI_L   },  // LATIN SMALL LETTER W WITH HOOK
  { 0x2C74, BIDI_L   },  // LATIN SMALL LETTER V WITH CURL
  { 0x2C75, BIDI_L   },  // LATIN CAPITAL LETTER HALF H
  { 0x2C76, BIDI_L   },  // LATIN SMALL LETTER HALF H
  { 0x2C77, BIDI_L   },  // LATIN SMALL LETTER TAILLESS PHI
  { 0x2C78, BIDI_L   },  // LATIN SMALL LETTER E WITH NOTCH
  { 0x2C79, BIDI_L   },  // LATIN SMALL LETTER TURNED R WITH TAIL
  { 0x2C7A, BIDI_L   },  // LATIN SMALL LETTER O WITH LOW RING INSIDE
  { 0x2C7B, BIDI_L   },  // LATIN LETTER SMALL CAPITAL TURNED E
  { 0x2C7C, BIDI_L   },  // LATIN SUBSCRIPT SMALL LETTER J
  { 0x2C7D, BIDI_L   },  // MODIFIER LETTER CAPITAL V
  { 0x2C7E, BIDI_L   },  // LATIN CAPITAL LETTER S WITH SWASH TAIL
  { 0x2C7F, BIDI_L   },  // LATIN CAPITAL LETTER Z WITH SWASH TAIL
  { 0x2C80, BIDI_L   },  // COPTIC CAPITAL LETTER ALFA
  { 0x2C81, BIDI_L   },  // COPTIC SMALL LETTER ALFA
  { 0x2C82, BIDI_L   },  // COPTIC CAPITAL LETTER VIDA
  { 0x2C83, BIDI_L   },  // COPTIC SMALL LETTER VIDA
  { 0x2C84, BIDI_L   },  // COPTIC CAPITAL LETTER GAMMA
  { 0x2C85, BIDI_L   },  // COPTIC SMALL LETTER GAMMA
  { 0x2C86, BIDI_L   },  // COPTIC CAPITAL LETTER DALDA
  { 0x2C87, BIDI_L   },  // COPTIC SMALL LETTER DALDA
  { 0x2C88, BIDI_L   },  // COPTIC CAPITAL LETTER EIE
  { 0x2C89, BIDI_L   },  // COPTIC SMALL LETTER EIE
  { 0x2C8A, BIDI_L   },  // COPTIC CAPITAL LETTER SOU
  { 0x2C8B, BIDI_L   },  // COPTIC SMALL LETTER SOU
  { 0x2C8C, BIDI_L   },  // COPTIC CAPITAL LETTER ZATA
  { 0x2C8D, BIDI_L   },  // COPTIC SMALL LETTER ZATA
  { 0x2C8E, BIDI_L   },  // COPTIC CAPITAL LETTER HATE
  { 0x2C8F, BIDI_L   },  // COPTIC SMALL LETTER HATE
  { 0x2C90, BIDI_L   },  // COPTIC CAPITAL LETTER THETHE
  { 0x2C91, BIDI_L   },  // COPTIC SMALL LETTER THETHE
  { 0x2C92, BIDI_L   },  // COPTIC CAPITAL LETTER IAUDA
  { 0x2C93, BIDI_L   },  // COPTIC SMALL LETTER IAUDA
  { 0x2C94, BIDI_L   },  // COPTIC CAPITAL LETTER KAPA
  { 0x2C95, BIDI_L   },  // COPTIC SMALL LETTER KAPA
  { 0x2C96, BIDI_L   },  // COPTIC CAPITAL LETTER LAULA
  { 0x2C97, BIDI_L   },  // COPTIC SMALL LETTER LAULA
  { 0x2C98, BIDI_L   },  // COPTIC CAPITAL LETTER MI
  { 0x2C99, BIDI_L   },  // COPTIC SMALL LETTER MI
  { 0x2C9A, BIDI_L   },  // COPTIC CAPITAL LETTER NI
  { 0x2C9B, BIDI_L   },  // COPTIC SMALL LETTER NI
  { 0x2C9C, BIDI_L   },  // COPTIC CAPITAL LETTER KSI
  { 0x2C9D, BIDI_L   },  // COPTIC SMALL LETTER KSI
  { 0x2C9E, BIDI_L   },  // COPTIC CAPITAL LETTER O
  { 0x2C9F, BIDI_L   },  // COPTIC SMALL LETTER O
  { 0x2CA0, BIDI_L   },  // COPTIC CAPITAL LETTER PI
  { 0x2CA1, BIDI_L   },  // COPTIC SMALL LETTER PI
  { 0x2CA2, BIDI_L   },  // COPTIC CAPITAL LETTER RO
  { 0x2CA3, BIDI_L   },  // COPTIC SMALL LETTER RO
  { 0x2CA4, BIDI_L   },  // COPTIC CAPITAL LETTER SIMA
  { 0x2CA5, BIDI_L   },  // COPTIC SMALL LETTER SIMA
  { 0x2CA6, BIDI_L   },  // COPTIC CAPITAL LETTER TAU
  { 0x2CA7, BIDI_L   },  // COPTIC SMALL LETTER TAU
  { 0x2CA8, BIDI_L   },  // COPTIC CAPITAL LETTER UA
  { 0x2CA9, BIDI_L   },  // COPTIC SMALL LETTER UA
  { 0x2CAA, BIDI_L   },  // COPTIC CAPITAL LETTER FI
  { 0x2CAB, BIDI_L   },  // COPTIC SMALL LETTER FI
  { 0x2CAC, BIDI_L   },  // COPTIC CAPITAL LETTER KHI
  { 0x2CAD, BIDI_L   },  // COPTIC SMALL LETTER KHI
  { 0x2CAE, BIDI_L   },  // COPTIC CAPITAL LETTER PSI
  { 0x2CAF, BIDI_L   },  // COPTIC SMALL LETTER PSI
  { 0x2CB0, BIDI_L   },  // COPTIC CAPITAL LETTER OOU
  { 0x2CB1, BIDI_L   },  // COPTIC SMALL LETTER OOU
  { 0x2CB2, BIDI_L   },  // COPTIC CAPITAL LETTER DIALECT-P ALEF
  { 0x2CB3, BIDI_L   },  // COPTIC SMALL LETTER DIALECT-P ALEF
  { 0x2CB4, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC AIN
  { 0x2CB5, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC AIN
  { 0x2CB6, BIDI_L   },  // COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
  { 0x2CB7, BIDI_L   },  // COPTIC SMALL LETTER CRYPTOGRAMMIC EIE
  { 0x2CB8, BIDI_L   },  // COPTIC CAPITAL LETTER DIALECT-P KAPA
  { 0x2CB9, BIDI_L   },  // COPTIC SMALL LETTER DIALECT-P KAPA
  { 0x2CBA, BIDI_L   },  // COPTIC CAPITAL LETTER DIALECT-P NI
  { 0x2CBB, BIDI_L   },  // COPTIC SMALL LETTER DIALECT-P NI
  { 0x2CBC, BIDI_L   },  // COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
  { 0x2CBD, BIDI_L   },  // COPTIC SMALL LETTER CRYPTOGRAMMIC NI
  { 0x2CBE, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC OOU
  { 0x2CBF, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC OOU
  { 0x2CC0, BIDI_L   },  // COPTIC CAPITAL LETTER SAMPI
  { 0x2CC1, BIDI_L   },  // COPTIC SMALL LETTER SAMPI
  { 0x2CC2, BIDI_L   },  // COPTIC CAPITAL LETTER CROSSED SHEI
  { 0x2CC3, BIDI_L   },  // COPTIC SMALL LETTER CROSSED SHEI
  { 0x2CC4, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC SHEI
  { 0x2CC5, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC SHEI
  { 0x2CC6, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC ESH
  { 0x2CC7, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC ESH
  { 0x2CC8, BIDI_L   },  // COPTIC CAPITAL LETTER AKHMIMIC KHEI
  { 0x2CC9, BIDI_L   },  // COPTIC SMALL LETTER AKHMIMIC KHEI
  { 0x2CCA, BIDI_L   },  // COPTIC CAPITAL LETTER DIALECT-P HORI
  { 0x2CCB, BIDI_L   },  // COPTIC SMALL LETTER DIALECT-P HORI
  { 0x2CCC, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC HORI
  { 0x2CCD, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC HORI
  { 0x2CCE, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC HA
  { 0x2CCF, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC HA
  { 0x2CD0, BIDI_L   },  // COPTIC CAPITAL LETTER L-SHAPED HA
  { 0x2CD1, BIDI_L   },  // COPTIC SMALL LETTER L-SHAPED HA
  { 0x2CD2, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC HEI
  { 0x2CD3, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC HEI
  { 0x2CD4, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC HAT
  { 0x2CD5, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC HAT
  { 0x2CD6, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC GANGIA
  { 0x2CD7, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC GANGIA
  { 0x2CD8, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC DJA
  { 0x2CD9, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC DJA
  { 0x2CDA, BIDI_L   },  // COPTIC CAPITAL LETTER OLD COPTIC SHIMA
  { 0x2CDB, BIDI_L   },  // COPTIC SMALL LETTER OLD COPTIC SHIMA
  { 0x2CDC, BIDI_L   },  // COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
  { 0x2CDD, BIDI_L   },  // COPTIC SMALL LETTER OLD NUBIAN SHIMA
  { 0x2CDE, BIDI_L   },  // COPTIC CAPITAL LETTER OLD NUBIAN NGI
  { 0x2CDF, BIDI_L   },  // COPTIC SMALL LETTER OLD NUBIAN NGI
  { 0x2CE0, BIDI_L   },  // COPTIC CAPITAL LETTER OLD NUBIAN NYI
  { 0x2CE1, BIDI_L   },  // COPTIC SMALL LETTER OLD NUBIAN NYI
  { 0x2CE2, BIDI_L   },  // COPTIC CAPITAL LETTER OLD NUBIAN WAU
  { 0x2CE3, BIDI_L   },  // COPTIC SMALL LETTER OLD NUBIAN WAU
  { 0x2CE4, BIDI_L   },  // COPTIC SYMBOL KAI
  { 0x2CE5, BIDI_ON  },  // COPTIC SYMBOL MI RO
  { 0x2CE6, BIDI_ON  },  // COPTIC SYMBOL PI RO
  { 0x2CE7, BIDI_ON  },  // COPTIC SYMBOL STAUROS
  { 0x2CE8, BIDI_ON  },  // COPTIC SYMBOL TAU RO
  { 0x2CE9, BIDI_ON  },  // COPTIC SYMBOL KHI RO
  { 0x2CEA, BIDI_ON  },  // COPTIC SYMBOL SHIMA SIMA
  { 0x2CEB, BIDI_L   },  // COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI
  { 0x2CEC, BIDI_L   },  // COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI
  { 0x2CED, BIDI_L   },  // COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA
  { 0x2CEE, BIDI_L   },  // COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
  { 0x2CEF, BIDI_NSM },  // COPTIC COMBINING NI ABOVE
  { 0x2CF0, BIDI_NSM },  // COPTIC COMBINING SPIRITUS ASPER
  { 0x2CF1, BIDI_NSM },  // COPTIC COMBINING SPIRITUS LENIS
  { 0x2CF2, BIDI_L   },  // COPTIC CAPITAL LETTER BOHAIRIC KHEI
  { 0x2CF3, BIDI_L   },  // COPTIC SMALL LETTER BOHAIRIC KHEI
  { 0x2CF9, BIDI_ON  },  // COPTIC OLD NUBIAN FULL STOP
  { 0x2CFA, BIDI_ON  },  // COPTIC OLD NUBIAN DIRECT QUESTION MARK
  { 0x2CFB, BIDI_ON  },  // COPTIC OLD NUBIAN INDIRECT QUESTION MARK
  { 0x2CFC, BIDI_ON  },  // COPTIC OLD NUBIAN VERSE DIVIDER
  { 0x2CFD, BIDI_ON  },  // COPTIC FRACTION ONE HALF
  { 0x2CFE, BIDI_ON  },  // COPTIC FULL STOP
  { 0x2CFF, BIDI_ON  },  // COPTIC MORPHOLOGICAL DIVIDER
  { 0x2D00, BIDI_L   },  // GEORGIAN SMALL LETTER AN
  { 0x2D01, BIDI_L   },  // GEORGIAN SMALL LETTER BAN
  { 0x2D02, BIDI_L   },  // GEORGIAN SMALL LETTER GAN
  { 0x2D03, BIDI_L   },  // GEORGIAN SMALL LETTER DON
  { 0x2D04, BIDI_L   },  // GEORGIAN SMALL LETTER EN
  { 0x2D05, BIDI_L   },  // GEORGIAN SMALL LETTER VIN
  { 0x2D06, BIDI_L   },  // GEORGIAN SMALL LETTER ZEN
  { 0x2D07, BIDI_L   },  // GEORGIAN SMALL LETTER TAN
  { 0x2D08, BIDI_L   },  // GEORGIAN SMALL LETTER IN
  { 0x2D09, BIDI_L   },  // GEORGIAN SMALL LETTER KAN
  { 0x2D0A, BIDI_L   },  // GEORGIAN SMALL LETTER LAS
  { 0x2D0B, BIDI_L   },  // GEORGIAN SMALL LETTER MAN
  { 0x2D0C, BIDI_L   },  // GEORGIAN SMALL LETTER NAR
  { 0x2D0D, BIDI_L   },  // GEORGIAN SMALL LETTER ON
  { 0x2D0E, BIDI_L   },  // GEORGIAN SMALL LETTER PAR
  { 0x2D0F, BIDI_L   },  // GEORGIAN SMALL LETTER ZHAR
  { 0x2D10, BIDI_L   },  // GEORGIAN SMALL LETTER RAE
  { 0x2D11, BIDI_L   },  // GEORGIAN SMALL LETTER SAN
  { 0x2D12, BIDI_L   },  // GEORGIAN SMALL LETTER TAR
  { 0x2D13, BIDI_L   },  // GEORGIAN SMALL LETTER UN
  { 0x2D14, BIDI_L   },  // GEORGIAN SMALL LETTER PHAR
  { 0x2D15, BIDI_L   },  // GEORGIAN SMALL LETTER KHAR
  { 0x2D16, BIDI_L   },  // GEORGIAN SMALL LETTER GHAN
  { 0x2D17, BIDI_L   },  // GEORGIAN SMALL LETTER QAR
  { 0x2D18, BIDI_L   },  // GEORGIAN SMALL LETTER SHIN
  { 0x2D19, BIDI_L   },  // GEORGIAN SMALL LETTER CHIN
  { 0x2D1A, BIDI_L   },  // GEORGIAN SMALL LETTER CAN
  { 0x2D1B, BIDI_L   },  // GEORGIAN SMALL LETTER JIL
  { 0x2D1C, BIDI_L   },  // GEORGIAN SMALL LETTER CIL
  { 0x2D1D, BIDI_L   },  // GEORGIAN SMALL LETTER CHAR
  { 0x2D1E, BIDI_L   },  // GEORGIAN SMALL LETTER XAN
  { 0x2D1F, BIDI_L   },  // GEORGIAN SMALL LETTER JHAN
  { 0x2D20, BIDI_L   },  // GEORGIAN SMALL LETTER HAE
  { 0x2D21, BIDI_L   },  // GEORGIAN SMALL LETTER HE
  { 0x2D22, BIDI_L   },  // GEORGIAN SMALL LETTER HIE
  { 0x2D23, BIDI_L   },  // GEORGIAN SMALL LETTER WE
  { 0x2D24, BIDI_L   },  // GEORGIAN SMALL LETTER HAR
  { 0x2D25, BIDI_L   },  // GEORGIAN SMALL LETTER HOE
  { 0x2D27, BIDI_L   },  // GEORGIAN SMALL LETTER YN
  { 0x2D2D, BIDI_L   },  // GEORGIAN SMALL LETTER AEN
  { 0x2D30, BIDI_L   },  // TIFINAGH LETTER YA
  { 0x2D31, BIDI_L   },  // TIFINAGH LETTER YAB
  { 0x2D32, BIDI_L   },  // TIFINAGH LETTER YABH
  { 0x2D33, BIDI_L   },  // TIFINAGH LETTER YAG
  { 0x2D34, BIDI_L   },  // TIFINAGH LETTER YAGHH
  { 0x2D35, BIDI_L   },  // TIFINAGH LETTER BERBER ACADEMY YAJ
  { 0x2D36, BIDI_L   },  // TIFINAGH LETTER YAJ
  { 0x2D37, BIDI_L   },  // TIFINAGH LETTER YAD
  { 0x2D38, BIDI_L   },  // TIFINAGH LETTER YADH
  { 0x2D39, BIDI_L   },  // TIFINAGH LETTER YADD
  { 0x2D3A, BIDI_L   },  // TIFINAGH LETTER YADDH
  { 0x2D3B, BIDI_L   },  // TIFINAGH LETTER YEY
  { 0x2D3C, BIDI_L   },  // TIFINAGH LETTER YAF
  { 0x2D3D, BIDI_L   },  // TIFINAGH LETTER YAK
  { 0x2D3E, BIDI_L   },  // TIFINAGH LETTER TUAREG YAK
  { 0x2D3F, BIDI_L   },  // TIFINAGH LETTER YAKHH
  { 0x2D40, BIDI_L   },  // TIFINAGH LETTER YAH
  { 0x2D41, BIDI_L   },  // TIFINAGH LETTER BERBER ACADEMY YAH
  { 0x2D42, BIDI_L   },  // TIFINAGH LETTER TUAREG YAH
  { 0x2D43, BIDI_L   },  // TIFINAGH LETTER YAHH
  { 0x2D44, BIDI_L   },  // TIFINAGH LETTER YAA
  { 0x2D45, BIDI_L   },  // TIFINAGH LETTER YAKH
  { 0x2D46, BIDI_L   },  // TIFINAGH LETTER TUAREG YAKH
  { 0x2D47, BIDI_L   },  // TIFINAGH LETTER YAQ
  { 0x2D48, BIDI_L   },  // TIFINAGH LETTER TUAREG YAQ
  { 0x2D49, BIDI_L   },  // TIFINAGH LETTER YI
  { 0x2D4A, BIDI_L   },  // TIFINAGH LETTER YAZH
  { 0x2D4B, BIDI_L   },  // TIFINAGH LETTER AHAGGAR YAZH
  { 0x2D4C, BIDI_L   },  // TIFINAGH LETTER TUAREG YAZH
  { 0x2D4D, BIDI_L   },  // TIFINAGH LETTER YAL
  { 0x2D4E, BIDI_L   },  // TIFINAGH LETTER YAM
  { 0x2D4F, BIDI_L   },  // TIFINAGH LETTER YAN
  { 0x2D50, BIDI_L   },  // TIFINAGH LETTER TUAREG YAGN
  { 0x2D51, BIDI_L   },  // TIFINAGH LETTER TUAREG YANG
  { 0x2D52, BIDI_L   },  // TIFINAGH LETTER YAP
  { 0x2D53, BIDI_L   },  // TIFINAGH LETTER YU
  { 0x2D54, BIDI_L   },  // TIFINAGH LETTER YAR
  { 0x2D55, BIDI_L   },  // TIFINAGH LETTER YARR
  { 0x2D56, BIDI_L   },  // TIFINAGH LETTER YAGH
  { 0x2D57, BIDI_L   },  // TIFINAGH LETTER TUAREG YAGH
  { 0x2D58, BIDI_L   },  // TIFINAGH LETTER AYER YAGH
  { 0x2D59, BIDI_L   },  // TIFINAGH LETTER YAS
  { 0x2D5A, BIDI_L   },  // TIFINAGH LETTER YASS
  { 0x2D5B, BIDI_L   },  // TIFINAGH LETTER YASH
  { 0x2D5C, BIDI_L   },  // TIFINAGH LETTER YAT
  { 0x2D5D, BIDI_L   },  // TIFINAGH LETTER YATH
  { 0x2D5E, BIDI_L   },  // TIFINAGH LETTER YACH
  { 0x2D5F, BIDI_L   },  // TIFINAGH LETTER YATT
  { 0x2D60, BIDI_L   },  // TIFINAGH LETTER YAV
  { 0x2D61, BIDI_L   },  // TIFINAGH LETTER YAW
  { 0x2D62, BIDI_L   },  // TIFINAGH LETTER YAY
  { 0x2D63, BIDI_L   },  // TIFINAGH LETTER YAZ
  { 0x2D64, BIDI_L   },  // TIFINAGH LETTER TAWELLEMET YAZ
  { 0x2D65, BIDI_L   },  // TIFINAGH LETTER YAZZ
  { 0x2D66, BIDI_L   },  // TIFINAGH LETTER YE
  { 0x2D67, BIDI_L   },  // TIFINAGH LETTER YO
  { 0x2D6F, BIDI_L   },  // TIFINAGH MODIFIER LETTER LABIALIZATION MARK
  { 0x2D70, BIDI_L   },  // TIFINAGH SEPARATOR MARK
  { 0x2D7F, BIDI_NSM },  // TIFINAGH CONSONANT JOINER
  { 0x2D80, BIDI_L   },  // ETHIOPIC SYLLABLE LOA
  { 0x2D81, BIDI_L   },  // ETHIOPIC SYLLABLE MOA
  { 0x2D82, BIDI_L   },  // ETHIOPIC SYLLABLE ROA
  { 0x2D83, BIDI_L   },  // ETHIOPIC SYLLABLE SOA
  { 0x2D84, BIDI_L   },  // ETHIOPIC SYLLABLE SHOA
  { 0x2D85, BIDI_L   },  // ETHIOPIC SYLLABLE BOA
  { 0x2D86, BIDI_L   },  // ETHIOPIC SYLLABLE TOA
  { 0x2D87, BIDI_L   },  // ETHIOPIC SYLLABLE COA
  { 0x2D88, BIDI_L   },  // ETHIOPIC SYLLABLE NOA
  { 0x2D89, BIDI_L   },  // ETHIOPIC SYLLABLE NYOA
  { 0x2D8A, BIDI_L   },  // ETHIOPIC SYLLABLE GLOTTAL OA
  { 0x2D8B, BIDI_L   },  // ETHIOPIC SYLLABLE ZOA
  { 0x2D8C, BIDI_L   },  // ETHIOPIC SYLLABLE DOA
  { 0x2D8D, BIDI_L   },  // ETHIOPIC SYLLABLE DDOA
  { 0x2D8E, BIDI_L   },  // ETHIOPIC SYLLABLE JOA
  { 0x2D8F, BIDI_L   },  // ETHIOPIC SYLLABLE THOA
  { 0x2D90, BIDI_L   },  // ETHIOPIC SYLLABLE CHOA
  { 0x2D91, BIDI_L   },  // ETHIOPIC SYLLABLE PHOA
  { 0x2D92, BIDI_L   },  // ETHIOPIC SYLLABLE POA
  { 0x2D93, BIDI_L   },  // ETHIOPIC SYLLABLE GGWA
  { 0x2D94, BIDI_L   },  // ETHIOPIC SYLLABLE GGWI
  { 0x2D95, BIDI_L   },  // ETHIOPIC SYLLABLE GGWEE
  { 0x2D96, BIDI_L   },  // ETHIOPIC SYLLABLE GGWE
  { 0x2DA0, BIDI_L   },  // ETHIOPIC SYLLABLE SSA
  { 0x2DA1, BIDI_L   },  // ETHIOPIC SYLLABLE SSU
  { 0x2DA2, BIDI_L   },  // ETHIOPIC SYLLABLE SSI
  { 0x2DA3, BIDI_L   },  // ETHIOPIC SYLLABLE SSAA
  { 0x2DA4, BIDI_L   },  // ETHIOPIC SYLLABLE SSEE
  { 0x2DA5, BIDI_L   },  // ETHIOPIC SYLLABLE SSE
  { 0x2DA6, BIDI_L   },  // ETHIOPIC SYLLABLE SSO
  { 0x2DA8, BIDI_L   },  // ETHIOPIC SYLLABLE CCA
  { 0x2DA9, BIDI_L   },  // ETHIOPIC SYLLABLE CCU
  { 0x2DAA, BIDI_L   },  // ETHIOPIC SYLLABLE CCI
  { 0x2DAB, BIDI_L   },  // ETHIOPIC SYLLABLE CCAA
  { 0x2DAC, BIDI_L   },  // ETHIOPIC SYLLABLE CCEE
  { 0x2DAD, BIDI_L   },  // ETHIOPIC SYLLABLE CCE
  { 0x2DAE, BIDI_L   },  // ETHIOPIC SYLLABLE CCO
  { 0x2DB0, BIDI_L   },  // ETHIOPIC SYLLABLE ZZA
  { 0x2DB1, BIDI_L   },  // ETHIOPIC SYLLABLE ZZU
  { 0x2DB2, BIDI_L   },  // ETHIOPIC SYLLABLE ZZI
  { 0x2DB3, BIDI_L   },  // ETHIOPIC SYLLABLE ZZAA
  { 0x2DB4, BIDI_L   },  // ETHIOPIC SYLLABLE ZZEE
  { 0x2DB5, BIDI_L   },  // ETHIOPIC SYLLABLE ZZE
  { 0x2DB6, BIDI_L   },  // ETHIOPIC SYLLABLE ZZO
  { 0x2DB8, BIDI_L   },  // ETHIOPIC SYLLABLE CCHA
  { 0x2DB9, BIDI_L   },  // ETHIOPIC SYLLABLE CCHU
  { 0x2DBA, BIDI_L   },  // ETHIOPIC SYLLABLE CCHI
  { 0x2DBB, BIDI_L   },  // ETHIOPIC SYLLABLE CCHAA
  { 0x2DBC, BIDI_L   },  // ETHIOPIC SYLLABLE CCHEE
  { 0x2DBD, BIDI_L   },  // ETHIOPIC SYLLABLE CCHE
  { 0x2DBE, BIDI_L   },  // ETHIOPIC SYLLABLE CCHO
  { 0x2DC0, BIDI_L   },  // ETHIOPIC SYLLABLE QYA
  { 0x2DC1, BIDI_L   },  // ETHIOPIC SYLLABLE QYU
  { 0x2DC2, BIDI_L   },  // ETHIOPIC SYLLABLE QYI
  { 0x2DC3, BIDI_L   },  // ETHIOPIC SYLLABLE QYAA
  { 0x2DC4, BIDI_L   },  // ETHIOPIC SYLLABLE QYEE
  { 0x2DC5, BIDI_L   },  // ETHIOPIC SYLLABLE QYE
  { 0x2DC6, BIDI_L   },  // ETHIOPIC SYLLABLE QYO
  { 0x2DC8, BIDI_L   },  // ETHIOPIC SYLLABLE KYA
  { 0x2DC9, BIDI_L   },  // ETHIOPIC SYLLABLE KYU
  { 0x2DCA, BIDI_L   },  // ETHIOPIC SYLLABLE KYI
  { 0x2DCB, BIDI_L   },  // ETHIOPIC SYLLABLE KYAA
  { 0x2DCC, BIDI_L   },  // ETHIOPIC SYLLABLE KYEE
  { 0x2DCD, BIDI_L   },  // ETHIOPIC SYLLABLE KYE
  { 0x2DCE, BIDI_L   },  // ETHIOPIC SYLLABLE KYO
  { 0x2DD0, BIDI_L   },  // ETHIOPIC SYLLABLE XYA
  { 0x2DD1, BIDI_L   },  // ETHIOPIC SYLLABLE XYU
  { 0x2DD2, BIDI_L   },  // ETHIOPIC SYLLABLE XYI
  { 0x2DD3, BIDI_L   },  // ETHIOPIC SYLLABLE XYAA
  { 0x2DD4, BIDI_L   },  // ETHIOPIC SYLLABLE XYEE
  { 0x2DD5, BIDI_L   },  // ETHIOPIC SYLLABLE XYE
  { 0x2DD6, BIDI_L   },  // ETHIOPIC SYLLABLE XYO
  { 0x2DD8, BIDI_L   },  // ETHIOPIC SYLLABLE GYA
  { 0x2DD9, BIDI_L   },  // ETHIOPIC SYLLABLE GYU
  { 0x2DDA, BIDI_L   },  // ETHIOPIC SYLLABLE GYI
  { 0x2DDB, BIDI_L   },  // ETHIOPIC SYLLABLE GYAA
  { 0x2DDC, BIDI_L   },  // ETHIOPIC SYLLABLE GYEE
  { 0x2DDD, BIDI_L   },  // ETHIOPIC SYLLABLE GYE
  { 0x2DDE, BIDI_L   },  // ETHIOPIC SYLLABLE GYO
  { 0x2DE0, BIDI_NSM },  // COMBINING CYRILLIC LETTER BE
  { 0x2DE1, BIDI_NSM },  // COMBINING CYRILLIC LETTER VE
  { 0x2DE2, BIDI_NSM },  // COMBINING CYRILLIC LETTER GHE
  { 0x2DE3, BIDI_NSM },  // COMBINING CYRILLIC LETTER DE
  { 0x2DE4, BIDI_NSM },  // COMBINING CYRILLIC LETTER ZHE
  { 0x2DE5, BIDI_NSM },  // COMBINING CYRILLIC LETTER ZE
  { 0x2DE6, BIDI_NSM },  // COMBINING CYRILLIC LETTER KA
  { 0x2DE7, BIDI_NSM },  // COMBINING CYRILLIC LETTER EL
  { 0x2DE8, BIDI_NSM },  // COMBINING CYRILLIC LETTER EM
  { 0x2DE9, BIDI_NSM },  // COMBINING CYRILLIC LETTER EN
  { 0x2DEA, BIDI_NSM },  // COMBINING CYRILLIC LETTER O
  { 0x2DEB, BIDI_NSM },  // COMBINING CYRILLIC LETTER PE
  { 0x2DEC, BIDI_NSM },  // COMBINING CYRILLIC LETTER ER
  { 0x2DED, BIDI_NSM },  // COMBINING CYRILLIC LETTER ES
  { 0x2DEE, BIDI_NSM },  // COMBINING CYRILLIC LETTER TE
  { 0x2DEF, BIDI_NSM },  // COMBINING CYRILLIC LETTER HA
  { 0x2DF0, BIDI_NSM },  // COMBINING CYRILLIC LETTER TSE
  { 0x2DF1, BIDI_NSM },  // COMBINING CYRILLIC LETTER CHE
  { 0x2DF2, BIDI_NSM },  // COMBINING CYRILLIC LETTER SHA
  { 0x2DF3, BIDI_NSM },  // COMBINING CYRILLIC LETTER SHCHA
  { 0x2DF4, BIDI_NSM },  // COMBINING CYRILLIC LETTER FITA
  { 0x2DF5, BIDI_NSM },  // COMBINING CYRILLIC LETTER ES-TE
  { 0x2DF6, BIDI_NSM },  // COMBINING CYRILLIC LETTER A
  { 0x2DF7, BIDI_NSM },  // COMBINING CYRILLIC LETTER IE
  { 0x2DF8, BIDI_NSM },  // COMBINING CYRILLIC LETTER DJERV
  { 0x2DF9, BIDI_NSM },  // COMBINING CYRILLIC LETTER MONOGRAPH UK
  { 0x2DFA, BIDI_NSM },  // COMBINING CYRILLIC LETTER YAT
  { 0x2DFB, BIDI_NSM },  // COMBINING CYRILLIC LETTER YU
  { 0x2DFC, BIDI_NSM },  // COMBINING CYRILLIC LETTER IOTIFIED A
  { 0x2DFD, BIDI_NSM },  // COMBINING CYRILLIC LETTER LITTLE YUS
  { 0x2DFE, BIDI_NSM },  // COMBINING CYRILLIC LETTER BIG YUS
  { 0x2DFF, BIDI_NSM },  // COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
  { 0x2E00, BIDI_ON  },  // RIGHT ANGLE SUBSTITUTION MARKER
  { 0x2E01, BIDI_ON  },  // RIGHT ANGLE DOTTED SUBSTITUTION MARKER
  { 0x2E02, BIDI_ON  },  // LEFT SUBSTITUTION BRACKET
  { 0x2E03, BIDI_ON  },  // RIGHT SUBSTITUTION BRACKET
  { 0x2E04, BIDI_ON  },  // LEFT DOTTED SUBSTITUTION BRACKET
  { 0x2E05, BIDI_ON  },  // RIGHT DOTTED SUBSTITUTION BRACKET
  { 0x2E06, BIDI_ON  },  // RAISED INTERPOLATION MARKER
  { 0x2E07, BIDI_ON  },  // RAISED DOTTED INTERPOLATION MARKER
  { 0x2E08, BIDI_ON  },  // DOTTED TRANSPOSITION MARKER
  { 0x2E09, BIDI_ON  },  // LEFT TRANSPOSITION BRACKET
  { 0x2E0A, BIDI_ON  },  // RIGHT TRANSPOSITION BRACKET
  { 0x2E0B, BIDI_ON  },  // RAISED SQUARE
  { 0x2E0C, BIDI_ON  },  // LEFT RAISED OMISSION BRACKET
  { 0x2E0D, BIDI_ON  },  // RIGHT RAISED OMISSION BRACKET
  { 0x2E0E, BIDI_ON  },  // EDITORIAL CORONIS
  { 0x2E0F, BIDI_ON  },  // PARAGRAPHOS
  { 0x2E10, BIDI_ON  },  // FORKED PARAGRAPHOS
  { 0x2E11, BIDI_ON  },  // REVERSED FORKED PARAGRAPHOS
  { 0x2E12, BIDI_ON  },  // HYPODIASTOLE
  { 0x2E13, BIDI_ON  },  // DOTTED OBELOS
  { 0x2E14, BIDI_ON  },  // DOWNWARDS ANCORA
  { 0x2E15, BIDI_ON  },  // UPWARDS ANCORA
  { 0x2E16, BIDI_ON  },  // DOTTED RIGHT-POINTING ANGLE
  { 0x2E17, BIDI_ON  },  // DOUBLE OBLIQUE HYPHEN
  { 0x2E18, BIDI_ON  },  // INVERTED INTERROBANG
  { 0x2E19, BIDI_ON  },  // PALM BRANCH
  { 0x2E1A, BIDI_ON  },  // HYPHEN WITH DIAERESIS
  { 0x2E1B, BIDI_ON  },  // TILDE WITH RING ABOVE
  { 0x2E1C, BIDI_ON  },  // LEFT LOW PARAPHRASE BRACKET
  { 0x2E1D, BIDI_ON  },  // RIGHT LOW PARAPHRASE BRACKET
  { 0x2E1E, BIDI_ON  },  // TILDE WITH DOT ABOVE
  { 0x2E1F, BIDI_ON  },  // TILDE WITH DOT BELOW
  { 0x2E20, BIDI_ON  },  // LEFT VERTICAL BAR WITH QUILL
  { 0x2E21, BIDI_ON  },  // RIGHT VERTICAL BAR WITH QUILL
  { 0x2E22, BIDI_ON  },  // TOP LEFT HALF BRACKET
  { 0x2E23, BIDI_ON  },  // TOP RIGHT HALF BRACKET
  { 0x2E24, BIDI_ON  },  // BOTTOM LEFT HALF BRACKET
  { 0x2E25, BIDI_ON  },  // BOTTOM RIGHT HALF BRACKET
  { 0x2E26, BIDI_ON  },  // LEFT SIDEWAYS U BRACKET
  { 0x2E27, BIDI_ON  },  // RIGHT SIDEWAYS U BRACKET
  { 0x2E28, BIDI_ON  },  // LEFT DOUBLE PARENTHESIS
  { 0x2E29, BIDI_ON  },  // RIGHT DOUBLE PARENTHESIS
  { 0x2E2A, BIDI_ON  },  // TWO DOTS OVER ONE DOT PUNCTUATION
  { 0x2E2B, BIDI_ON  },  // ONE DOT OVER TWO DOTS PUNCTUATION
  { 0x2E2C, BIDI_ON  },  // SQUARED FOUR DOT PUNCTUATION
  { 0x2E2D, BIDI_ON  },  // FIVE DOT MARK
  { 0x2E2E, BIDI_ON  },  // REVERSED QUESTION MARK
  { 0x2E2F, BIDI_ON  },  // VERTICAL TILDE
  { 0x2E30, BIDI_ON  },  // RING POINT
  { 0x2E31, BIDI_ON  },  // WORD SEPARATOR MIDDLE DOT
  { 0x2E32, BIDI_ON  },  // TURNED COMMA
  { 0x2E33, BIDI_ON  },  // RAISED DOT
  { 0x2E34, BIDI_ON  },  // RAISED COMMA
  { 0x2E35, BIDI_ON  },  // TURNED SEMICOLON
  { 0x2E36, BIDI_ON  },  // DAGGER WITH LEFT GUARD
  { 0x2E37, BIDI_ON  },  // DAGGER WITH RIGHT GUARD
  { 0x2E38, BIDI_ON  },  // TURNED DAGGER
  { 0x2E39, BIDI_ON  },  // TOP HALF SECTION SIGN
  { 0x2E3A, BIDI_ON  },  // TWO-EM DASH
  { 0x2E3B, BIDI_ON  },  // THREE-EM DASH
  { 0x2E3C, BIDI_ON  },  // STENOGRAPHIC FULL STOP
  { 0x2E3D, BIDI_ON  },  // VERTICAL SIX DOTS
  { 0x2E3E, BIDI_ON  },  // WIGGLY VERTICAL LINE
  { 0x2E3F, BIDI_ON  },  // CAPITULUM
  { 0x2E40, BIDI_ON  },  // DOUBLE HYPHEN
  { 0x2E41, BIDI_ON  },  // REVERSED COMMA
  { 0x2E42, BIDI_ON  },  // DOUBLE LOW-REVERSED-9 QUOTATION MARK
  { 0x2E80, BIDI_ON  },  // CJK RADICAL REPEAT
  { 0x2E81, BIDI_ON  },  // CJK RADICAL CLIFF
  { 0x2E82, BIDI_ON  },  // CJK RADICAL SECOND ONE
  { 0x2E83, BIDI_ON  },  // CJK RADICAL SECOND TWO
  { 0x2E84, BIDI_ON  },  // CJK RADICAL SECOND THREE
  { 0x2E85, BIDI_ON  },  // CJK RADICAL PERSON
  { 0x2E86, BIDI_ON  },  // CJK RADICAL BOX
  { 0x2E87, BIDI_ON  },  // CJK RADICAL TABLE
  { 0x2E88, BIDI_ON  },  // CJK RADICAL KNIFE ONE
  { 0x2E89, BIDI_ON  },  // CJK RADICAL KNIFE TWO
  { 0x2E8A, BIDI_ON  },  // CJK RADICAL DIVINATION
  { 0x2E8B, BIDI_ON  },  // CJK RADICAL SEAL
  { 0x2E8C, BIDI_ON  },  // CJK RADICAL SMALL ONE
  { 0x2E8D, BIDI_ON  },  // CJK RADICAL SMALL TWO
  { 0x2E8E, BIDI_ON  },  // CJK RADICAL LAME ONE
  { 0x2E8F, BIDI_ON  },  // CJK RADICAL LAME TWO
  { 0x2E90, BIDI_ON  },  // CJK RADICAL LAME THREE
  { 0x2E91, BIDI_ON  },  // CJK RADICAL LAME FOUR
  { 0x2E92, BIDI_ON  },  // CJK RADICAL SNAKE
  { 0x2E93, BIDI_ON  },  // CJK RADICAL THREAD
  { 0x2E94, BIDI_ON  },  // CJK RADICAL SNOUT ONE
  { 0x2E95, BIDI_ON  },  // CJK RADICAL SNOUT TWO
  { 0x2E96, BIDI_ON  },  // CJK RADICAL HEART ONE
  { 0x2E97, BIDI_ON  },  // CJK RADICAL HEART TWO
  { 0x2E98, BIDI_ON  },  // CJK RADICAL HAND
  { 0x2E99, BIDI_ON  },  // CJK RADICAL RAP
  { 0x2E9B, BIDI_ON  },  // CJK RADICAL CHOKE
  { 0x2E9C, BIDI_ON  },  // CJK RADICAL SUN
  { 0x2E9D, BIDI_ON  },  // CJK RADICAL MOON
  { 0x2E9E, BIDI_ON  },  // CJK RADICAL DEATH
  { 0x2E9F, BIDI_ON  },  // CJK RADICAL MOTHER
  { 0x2EA0, BIDI_ON  },  // CJK RADICAL CIVILIAN
  { 0x2EA1, BIDI_ON  },  // CJK RADICAL WATER ONE
  { 0x2EA2, BIDI_ON  },  // CJK RADICAL WATER TWO
  { 0x2EA3, BIDI_ON  },  // CJK RADICAL FIRE
  { 0x2EA4, BIDI_ON  },  // CJK RADICAL PAW ONE
  { 0x2EA5, BIDI_ON  },  // CJK RADICAL PAW TWO
  { 0x2EA6, BIDI_ON  },  // CJK RADICAL SIMPLIFIED HALF TREE TRUNK
  { 0x2EA7, BIDI_ON  },  // CJK RADICAL COW
  { 0x2EA8, BIDI_ON  },  // CJK RADICAL DOG
  { 0x2EA9, BIDI_ON  },  // CJK RADICAL JADE
  { 0x2EAA, BIDI_ON  },  // CJK RADICAL BOLT OF CLOTH
  { 0x2EAB, BIDI_ON  },  // CJK RADICAL EYE
  { 0x2EAC, BIDI_ON  },  // CJK RADICAL SPIRIT ONE
  { 0x2EAD, BIDI_ON  },  // CJK RADICAL SPIRIT TWO
  { 0x2EAE, BIDI_ON  },  // CJK RADICAL BAMBOO
  { 0x2EAF, BIDI_ON  },  // CJK RADICAL SILK
  { 0x2EB0, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED SILK
  { 0x2EB1, BIDI_ON  },  // CJK RADICAL NET ONE
  { 0x2EB2, BIDI_ON  },  // CJK RADICAL NET TWO
  { 0x2EB3, BIDI_ON  },  // CJK RADICAL NET THREE
  { 0x2EB4, BIDI_ON  },  // CJK RADICAL NET FOUR
  { 0x2EB5, BIDI_ON  },  // CJK RADICAL MESH
  { 0x2EB6, BIDI_ON  },  // CJK RADICAL SHEEP
  { 0x2EB7, BIDI_ON  },  // CJK RADICAL RAM
  { 0x2EB8, BIDI_ON  },  // CJK RADICAL EWE
  { 0x2EB9, BIDI_ON  },  // CJK RADICAL OLD
  { 0x2EBA, BIDI_ON  },  // CJK RADICAL BRUSH ONE
  { 0x2EBB, BIDI_ON  },  // CJK RADICAL BRUSH TWO
  { 0x2EBC, BIDI_ON  },  // CJK RADICAL MEAT
  { 0x2EBD, BIDI_ON  },  // CJK RADICAL MORTAR
  { 0x2EBE, BIDI_ON  },  // CJK RADICAL GRASS ONE
  { 0x2EBF, BIDI_ON  },  // CJK RADICAL GRASS TWO
  { 0x2EC0, BIDI_ON  },  // CJK RADICAL GRASS THREE
  { 0x2EC1, BIDI_ON  },  // CJK RADICAL TIGER
  { 0x2EC2, BIDI_ON  },  // CJK RADICAL CLOTHES
  { 0x2EC3, BIDI_ON  },  // CJK RADICAL WEST ONE
  { 0x2EC4, BIDI_ON  },  // CJK RADICAL WEST TWO
  { 0x2EC5, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED SEE
  { 0x2EC6, BIDI_ON  },  // CJK RADICAL SIMPLIFIED HORN
  { 0x2EC7, BIDI_ON  },  // CJK RADICAL HORN
  { 0x2EC8, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED SPEECH
  { 0x2EC9, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED SHELL
  { 0x2ECA, BIDI_ON  },  // CJK RADICAL FOOT
  { 0x2ECB, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED CART
  { 0x2ECC, BIDI_ON  },  // CJK RADICAL SIMPLIFIED WALK
  { 0x2ECD, BIDI_ON  },  // CJK RADICAL WALK ONE
  { 0x2ECE, BIDI_ON  },  // CJK RADICAL WALK TWO
  { 0x2ECF, BIDI_ON  },  // CJK RADICAL CITY
  { 0x2ED0, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED GOLD
  { 0x2ED1, BIDI_ON  },  // CJK RADICAL LONG ONE
  { 0x2ED2, BIDI_ON  },  // CJK RADICAL LONG TWO
  { 0x2ED3, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED LONG
  { 0x2ED4, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED GATE
  { 0x2ED5, BIDI_ON  },  // CJK RADICAL MOUND ONE
  { 0x2ED6, BIDI_ON  },  // CJK RADICAL MOUND TWO
  { 0x2ED7, BIDI_ON  },  // CJK RADICAL RAIN
  { 0x2ED8, BIDI_ON  },  // CJK RADICAL BLUE
  { 0x2ED9, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED TANNED LEATHER
  { 0x2EDA, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED LEAF
  { 0x2EDB, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED WIND
  { 0x2EDC, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED FLY
  { 0x2EDD, BIDI_ON  },  // CJK RADICAL EAT ONE
  { 0x2EDE, BIDI_ON  },  // CJK RADICAL EAT TWO
  { 0x2EDF, BIDI_ON  },  // CJK RADICAL EAT THREE
  { 0x2EE0, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED EAT
  { 0x2EE1, BIDI_ON  },  // CJK RADICAL HEAD
  { 0x2EE2, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED HORSE
  { 0x2EE3, BIDI_ON  },  // CJK RADICAL BONE
  { 0x2EE4, BIDI_ON  },  // CJK RADICAL GHOST
  { 0x2EE5, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED FISH
  { 0x2EE6, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED BIRD
  { 0x2EE7, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED SALT
  { 0x2EE8, BIDI_ON  },  // CJK RADICAL SIMPLIFIED WHEAT
  { 0x2EE9, BIDI_ON  },  // CJK RADICAL SIMPLIFIED YELLOW
  { 0x2EEA, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED FROG
  { 0x2EEB, BIDI_ON  },  // CJK RADICAL J-SIMPLIFIED EVEN
  { 0x2EEC, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED EVEN
  { 0x2EED, BIDI_ON  },  // CJK RADICAL J-SIMPLIFIED TOOTH
  { 0x2EEE, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED TOOTH
  { 0x2EEF, BIDI_ON  },  // CJK RADICAL J-SIMPLIFIED DRAGON
  { 0x2EF0, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED DRAGON
  { 0x2EF1, BIDI_ON  },  // CJK RADICAL TURTLE
  { 0x2EF2, BIDI_ON  },  // CJK RADICAL J-SIMPLIFIED TURTLE
  { 0x2EF3, BIDI_ON  },  // CJK RADICAL C-SIMPLIFIED TURTLE
  { 0x2F00, BIDI_ON  },  // KANGXI RADICAL ONE
  { 0x2F01, BIDI_ON  },  // KANGXI RADICAL LINE
  { 0x2F02, BIDI_ON  },  // KANGXI RADICAL DOT
  { 0x2F03, BIDI_ON  },  // KANGXI RADICAL SLASH
  { 0x2F04, BIDI_ON  },  // KANGXI RADICAL SECOND
  { 0x2F05, BIDI_ON  },  // KANGXI RADICAL HOOK
  { 0x2F06, BIDI_ON  },  // KANGXI RADICAL TWO
  { 0x2F07, BIDI_ON  },  // KANGXI RADICAL LID
  { 0x2F08, BIDI_ON  },  // KANGXI RADICAL MAN
  { 0x2F09, BIDI_ON  },  // KANGXI RADICAL LEGS
  { 0x2F0A, BIDI_ON  },  // KANGXI RADICAL ENTER
  { 0x2F0B, BIDI_ON  },  // KANGXI RADICAL EIGHT
  { 0x2F0C, BIDI_ON  },  // KANGXI RADICAL DOWN BOX
  { 0x2F0D, BIDI_ON  },  // KANGXI RADICAL COVER
  { 0x2F0E, BIDI_ON  },  // KANGXI RADICAL ICE
  { 0x2F0F, BIDI_ON  },  // KANGXI RADICAL TABLE
  { 0x2F10, BIDI_ON  },  // KANGXI RADICAL OPEN BOX
  { 0x2F11, BIDI_ON  },  // KANGXI RADICAL KNIFE
  { 0x2F12, BIDI_ON  },  // KANGXI RADICAL POWER
  { 0x2F13, BIDI_ON  },  // KANGXI RADICAL WRAP
  { 0x2F14, BIDI_ON  },  // KANGXI RADICAL SPOON
  { 0x2F15, BIDI_ON  },  // KANGXI RADICAL RIGHT OPEN BOX
  { 0x2F16, BIDI_ON  },  // KANGXI RADICAL HIDING ENCLOSURE
  { 0x2F17, BIDI_ON  },  // KANGXI RADICAL TEN
  { 0x2F18, BIDI_ON  },  // KANGXI RADICAL DIVINATION
  { 0x2F19, BIDI_ON  },  // KANGXI RADICAL SEAL
  { 0x2F1A, BIDI_ON  },  // KANGXI RADICAL CLIFF
  { 0x2F1B, BIDI_ON  },  // KANGXI RADICAL PRIVATE
  { 0x2F1C, BIDI_ON  },  // KANGXI RADICAL AGAIN
  { 0x2F1D, BIDI_ON  },  // KANGXI RADICAL MOUTH
  { 0x2F1E, BIDI_ON  },  // KANGXI RADICAL ENCLOSURE
  { 0x2F1F, BIDI_ON  },  // KANGXI RADICAL EARTH
  { 0x2F20, BIDI_ON  },  // KANGXI RADICAL SCHOLAR
  { 0x2F21, BIDI_ON  },  // KANGXI RADICAL GO
  { 0x2F22, BIDI_ON  },  // KANGXI RADICAL GO SLOWLY
  { 0x2F23, BIDI_ON  },  // KANGXI RADICAL EVENING
  { 0x2F24, BIDI_ON  },  // KANGXI RADICAL BIG
  { 0x2F25, BIDI_ON  },  // KANGXI RADICAL WOMAN
  { 0x2F26, BIDI_ON  },  // KANGXI RADICAL CHILD
  { 0x2F27, BIDI_ON  },  // KANGXI RADICAL ROOF
  { 0x2F28, BIDI_ON  },  // KANGXI RADICAL INCH
  { 0x2F29, BIDI_ON  },  // KANGXI RADICAL SMALL
  { 0x2F2A, BIDI_ON  },  // KANGXI RADICAL LAME
  { 0x2F2B, BIDI_ON  },  // KANGXI RADICAL CORPSE
  { 0x2F2C, BIDI_ON  },  // KANGXI RADICAL SPROUT
  { 0x2F2D, BIDI_ON  },  // KANGXI RADICAL MOUNTAIN
  { 0x2F2E, BIDI_ON  },  // KANGXI RADICAL RIVER
  { 0x2F2F, BIDI_ON  },  // KANGXI RADICAL WORK
  { 0x2F30, BIDI_ON  },  // KANGXI RADICAL ONESELF
  { 0x2F31, BIDI_ON  },  // KANGXI RADICAL TURBAN
  { 0x2F32, BIDI_ON  },  // KANGXI RADICAL DRY
  { 0x2F33, BIDI_ON  },  // KANGXI RADICAL SHORT THREAD
  { 0x2F34, BIDI_ON  },  // KANGXI RADICAL DOTTED CLIFF
  { 0x2F35, BIDI_ON  },  // KANGXI RADICAL LONG STRIDE
  { 0x2F36, BIDI_ON  },  // KANGXI RADICAL TWO HANDS
  { 0x2F37, BIDI_ON  },  // KANGXI RADICAL SHOOT
  { 0x2F38, BIDI_ON  },  // KANGXI RADICAL BOW
  { 0x2F39, BIDI_ON  },  // KANGXI RADICAL SNOUT
  { 0x2F3A, BIDI_ON  },  // KANGXI RADICAL BRISTLE
  { 0x2F3B, BIDI_ON  },  // KANGXI RADICAL STEP
  { 0x2F3C, BIDI_ON  },  // KANGXI RADICAL HEART
  { 0x2F3D, BIDI_ON  },  // KANGXI RADICAL HALBERD
  { 0x2F3E, BIDI_ON  },  // KANGXI RADICAL DOOR
  { 0x2F3F, BIDI_ON  },  // KANGXI RADICAL HAND
  { 0x2F40, BIDI_ON  },  // KANGXI RADICAL BRANCH
  { 0x2F41, BIDI_ON  },  // KANGXI RADICAL RAP
  { 0x2F42, BIDI_ON  },  // KANGXI RADICAL SCRIPT
  { 0x2F43, BIDI_ON  },  // KANGXI RADICAL DIPPER
  { 0x2F44, BIDI_ON  },  // KANGXI RADICAL AXE
  { 0x2F45, BIDI_ON  },  // KANGXI RADICAL SQUARE
  { 0x2F46, BIDI_ON  },  // KANGXI RADICAL NOT
  { 0x2F47, BIDI_ON  },  // KANGXI RADICAL SUN
  { 0x2F48, BIDI_ON  },  // KANGXI RADICAL SAY
  { 0x2F49, BIDI_ON  },  // KANGXI RADICAL MOON
  { 0x2F4A, BIDI_ON  },  // KANGXI RADICAL TREE
  { 0x2F4B, BIDI_ON  },  // KANGXI RADICAL LACK
  { 0x2F4C, BIDI_ON  },  // KANGXI RADICAL STOP
  { 0x2F4D, BIDI_ON  },  // KANGXI RADICAL DEATH
  { 0x2F4E, BIDI_ON  },  // KANGXI RADICAL WEAPON
  { 0x2F4F, BIDI_ON  },  // KANGXI RADICAL DO NOT
  { 0x2F50, BIDI_ON  },  // KANGXI RADICAL COMPARE
  { 0x2F51, BIDI_ON  },  // KANGXI RADICAL FUR
  { 0x2F52, BIDI_ON  },  // KANGXI RADICAL CLAN
  { 0x2F53, BIDI_ON  },  // KANGXI RADICAL STEAM
  { 0x2F54, BIDI_ON  },  // KANGXI RADICAL WATER
  { 0x2F55, BIDI_ON  },  // KANGXI RADICAL FIRE
  { 0x2F56, BIDI_ON  },  // KANGXI RADICAL CLAW
  { 0x2F57, BIDI_ON  },  // KANGXI RADICAL FATHER
  { 0x2F58, BIDI_ON  },  // KANGXI RADICAL DOUBLE X
  { 0x2F59, BIDI_ON  },  // KANGXI RADICAL HALF TREE TRUNK
  { 0x2F5A, BIDI_ON  },  // KANGXI RADICAL SLICE
  { 0x2F5B, BIDI_ON  },  // KANGXI RADICAL FANG
  { 0x2F5C, BIDI_ON  },  // KANGXI RADICAL COW
  { 0x2F5D, BIDI_ON  },  // KANGXI RADICAL DOG
  { 0x2F5E, BIDI_ON  },  // KANGXI RADICAL PROFOUND
  { 0x2F5F, BIDI_ON  },  // KANGXI RADICAL JADE
  { 0x2F60, BIDI_ON  },  // KANGXI RADICAL MELON
  { 0x2F61, BIDI_ON  },  // KANGXI RADICAL TILE
  { 0x2F62, BIDI_ON  },  // KANGXI RADICAL SWEET
  { 0x2F63, BIDI_ON  },  // KANGXI RADICAL LIFE
  { 0x2F64, BIDI_ON  },  // KANGXI RADICAL USE
  { 0x2F65, BIDI_ON  },  // KANGXI RADICAL FIELD
  { 0x2F66, BIDI_ON  },  // KANGXI RADICAL BOLT OF CLOTH
  { 0x2F67, BIDI_ON  },  // KANGXI RADICAL SICKNESS
  { 0x2F68, BIDI_ON  },  // KANGXI RADICAL DOTTED TENT
  { 0x2F69, BIDI_ON  },  // KANGXI RADICAL WHITE
  { 0x2F6A, BIDI_ON  },  // KANGXI RADICAL SKIN
  { 0x2F6B, BIDI_ON  },  // KANGXI RADICAL DISH
  { 0x2F6C, BIDI_ON  },  // KANGXI RADICAL EYE
  { 0x2F6D, BIDI_ON  },  // KANGXI RADICAL SPEAR
  { 0x2F6E, BIDI_ON  },  // KANGXI RADICAL ARROW
  { 0x2F6F, BIDI_ON  },  // KANGXI RADICAL STONE
  { 0x2F70, BIDI_ON  },  // KANGXI RADICAL SPIRIT
  { 0x2F71, BIDI_ON  },  // KANGXI RADICAL TRACK
  { 0x2F72, BIDI_ON  },  // KANGXI RADICAL GRAIN
  { 0x2F73, BIDI_ON  },  // KANGXI RADICAL CAVE
  { 0x2F74, BIDI_ON  },  // KANGXI RADICAL STAND
  { 0x2F75, BIDI_ON  },  // KANGXI RADICAL BAMBOO
  { 0x2F76, BIDI_ON  },  // KANGXI RADICAL RICE
  { 0x2F77, BIDI_ON  },  // KANGXI RADICAL SILK
  { 0x2F78, BIDI_ON  },  // KANGXI RADICAL JAR
  { 0x2F79, BIDI_ON  },  // KANGXI RADICAL NET
  { 0x2F7A, BIDI_ON  },  // KANGXI RADICAL SHEEP
  { 0x2F7B, BIDI_ON  },  // KANGXI RADICAL FEATHER
  { 0x2F7C, BIDI_ON  },  // KANGXI RADICAL OLD
  { 0x2F7D, BIDI_ON  },  // KANGXI RADICAL AND
  { 0x2F7E, BIDI_ON  },  // KANGXI RADICAL PLOW
  { 0x2F7F, BIDI_ON  },  // KANGXI RADICAL EAR
  { 0x2F80, BIDI_ON  },  // KANGXI RADICAL BRUSH
  { 0x2F81, BIDI_ON  },  // KANGXI RADICAL MEAT
  { 0x2F82, BIDI_ON  },  // KANGXI RADICAL MINISTER
  { 0x2F83, BIDI_ON  },  // KANGXI RADICAL SELF
  { 0x2F84, BIDI_ON  },  // KANGXI RADICAL ARRIVE
  { 0x2F85, BIDI_ON  },  // KANGXI RADICAL MORTAR
  { 0x2F86, BIDI_ON  },  // KANGXI RADICAL TONGUE
  { 0x2F87, BIDI_ON  },  // KANGXI RADICAL OPPOSE
  { 0x2F88, BIDI_ON  },  // KANGXI RADICAL BOAT
  { 0x2F89, BIDI_ON  },  // KANGXI RADICAL STOPPING
  { 0x2F8A, BIDI_ON  },  // KANGXI RADICAL COLOR
  { 0x2F8B, BIDI_ON  },  // KANGXI RADICAL GRASS
  { 0x2F8C, BIDI_ON  },  // KANGXI RADICAL TIGER
  { 0x2F8D, BIDI_ON  },  // KANGXI RADICAL INSECT
  { 0x2F8E, BIDI_ON  },  // KANGXI RADICAL BLOOD
  { 0x2F8F, BIDI_ON  },  // KANGXI RADICAL WALK ENCLOSURE
  { 0x2F90, BIDI_ON  },  // KANGXI RADICAL CLOTHES
  { 0x2F91, BIDI_ON  },  // KANGXI RADICAL WEST
  { 0x2F92, BIDI_ON  },  // KANGXI RADICAL SEE
  { 0x2F93, BIDI_ON  },  // KANGXI RADICAL HORN
  { 0x2F94, BIDI_ON  },  // KANGXI RADICAL SPEECH
  { 0x2F95, BIDI_ON  },  // KANGXI RADICAL VALLEY
  { 0x2F96, BIDI_ON  },  // KANGXI RADICAL BEAN
  { 0x2F97, BIDI_ON  },  // KANGXI RADICAL PIG
  { 0x2F98, BIDI_ON  },  // KANGXI RADICAL BADGER
  { 0x2F99, BIDI_ON  },  // KANGXI RADICAL SHELL
  { 0x2F9A, BIDI_ON  },  // KANGXI RADICAL RED
  { 0x2F9B, BIDI_ON  },  // KANGXI RADICAL RUN
  { 0x2F9C, BIDI_ON  },  // KANGXI RADICAL FOOT
  { 0x2F9D, BIDI_ON  },  // KANGXI RADICAL BODY
  { 0x2F9E, BIDI_ON  },  // KANGXI RADICAL CART
  { 0x2F9F, BIDI_ON  },  // KANGXI RADICAL BITTER
  { 0x2FA0, BIDI_ON  },  // KANGXI RADICAL MORNING
  { 0x2FA1, BIDI_ON  },  // KANGXI RADICAL WALK
  { 0x2FA2, BIDI_ON  },  // KANGXI RADICAL CITY
  { 0x2FA3, BIDI_ON  },  // KANGXI RADICAL WINE
  { 0x2FA4, BIDI_ON  },  // KANGXI RADICAL DISTINGUISH
  { 0x2FA5, BIDI_ON  },  // KANGXI RADICAL VILLAGE
  { 0x2FA6, BIDI_ON  },  // KANGXI RADICAL GOLD
  { 0x2FA7, BIDI_ON  },  // KANGXI RADICAL LONG
  { 0x2FA8, BIDI_ON  },  // KANGXI RADICAL GATE
  { 0x2FA9, BIDI_ON  },  // KANGXI RADICAL MOUND
  { 0x2FAA, BIDI_ON  },  // KANGXI RADICAL SLAVE
  { 0x2FAB, BIDI_ON  },  // KANGXI RADICAL SHORT TAILED BIRD
  { 0x2FAC, BIDI_ON  },  // KANGXI RADICAL RAIN
  { 0x2FAD, BIDI_ON  },  // KANGXI RADICAL BLUE
  { 0x2FAE, BIDI_ON  },  // KANGXI RADICAL WRONG
  { 0x2FAF, BIDI_ON  },  // KANGXI RADICAL FACE
  { 0x2FB0, BIDI_ON  },  // KANGXI RADICAL LEATHER
  { 0x2FB1, BIDI_ON  },  // KANGXI RADICAL TANNED LEATHER
  { 0x2FB2, BIDI_ON  },  // KANGXI RADICAL LEEK
  { 0x2FB3, BIDI_ON  },  // KANGXI RADICAL SOUND
  { 0x2FB4, BIDI_ON  },  // KANGXI RADICAL LEAF
  { 0x2FB5, BIDI_ON  },  // KANGXI RADICAL WIND
  { 0x2FB6, BIDI_ON  },  // KANGXI RADICAL FLY
  { 0x2FB7, BIDI_ON  },  // KANGXI RADICAL EAT
  { 0x2FB8, BIDI_ON  },  // KANGXI RADICAL HEAD
  { 0x2FB9, BIDI_ON  },  // KANGXI RADICAL FRAGRANT
  { 0x2FBA, BIDI_ON  },  // KANGXI RADICAL HORSE
  { 0x2FBB, BIDI_ON  },  // KANGXI RADICAL BONE
  { 0x2FBC, BIDI_ON  },  // KANGXI RADICAL TALL
  { 0x2FBD, BIDI_ON  },  // KANGXI RADICAL HAIR
  { 0x2FBE, BIDI_ON  },  // KANGXI RADICAL FIGHT
  { 0x2FBF, BIDI_ON  },  // KANGXI RADICAL SACRIFICIAL WINE
  { 0x2FC0, BIDI_ON  },  // KANGXI RADICAL CAULDRON
  { 0x2FC1, BIDI_ON  },  // KANGXI RADICAL GHOST
  { 0x2FC2, BIDI_ON  },  // KANGXI RADICAL FISH
  { 0x2FC3, BIDI_ON  },  // KANGXI RADICAL BIRD
  { 0x2FC4, BIDI_ON  },  // KANGXI RADICAL SALT
  { 0x2FC5, BIDI_ON  },  // KANGXI RADICAL DEER
  { 0x2FC6, BIDI_ON  },  // KANGXI RADICAL WHEAT
  { 0x2FC7, BIDI_ON  },  // KANGXI RADICAL HEMP
  { 0x2FC8, BIDI_ON  },  // KANGXI RADICAL YELLOW
  { 0x2FC9, BIDI_ON  },  // KANGXI RADICAL MILLET
  { 0x2FCA, BIDI_ON  },  // KANGXI RADICAL BLACK
  { 0x2FCB, BIDI_ON  },  // KANGXI RADICAL EMBROIDERY
  { 0x2FCC, BIDI_ON  },  // KANGXI RADICAL FROG
  { 0x2FCD, BIDI_ON  },  // KANGXI RADICAL TRIPOD
  { 0x2FCE, BIDI_ON  },  // KANGXI RADICAL DRUM
  { 0x2FCF, BIDI_ON  },  // KANGXI RADICAL RAT
  { 0x2FD0, BIDI_ON  },  // KANGXI RADICAL NOSE
  { 0x2FD1, BIDI_ON  },  // KANGXI RADICAL EVEN
  { 0x2FD2, BIDI_ON  },  // KANGXI RADICAL TOOTH
  { 0x2FD3, BIDI_ON  },  // KANGXI RADICAL DRAGON
  { 0x2FD4, BIDI_ON  },  // KANGXI RADICAL TURTLE
  { 0x2FD5, BIDI_ON  },  // KANGXI RADICAL FLUTE
  { 0x2FF0, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT
  { 0x2FF1, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW
  { 0x2FF2, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT
  { 0x2FF3, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW
  { 0x2FF4, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND
  { 0x2FF5, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE
  { 0x2FF6, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW
  { 0x2FF7, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT
  { 0x2FF8, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT
  { 0x2FF9, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT
  { 0x2FFA, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT
  { 0x2FFB, BIDI_ON  },  // IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID

#endif
#if (GUI_BIDI_SUPPORT_RANGE_3 == 1)

  { 0x3000, BIDI_WS  },  // IDEOGRAPHIC SPACE
  { 0x3001, BIDI_ON  },  // IDEOGRAPHIC COMMA
  { 0x3002, BIDI_ON  },  // IDEOGRAPHIC FULL STOP
  { 0x3003, BIDI_ON  },  // DITTO MARK
  { 0x3004, BIDI_ON  },  // JAPANESE INDUSTRIAL STANDARD SYMBOL
  { 0x3005, BIDI_L   },  // IDEOGRAPHIC ITERATION MARK
  { 0x3006, BIDI_L   },  // IDEOGRAPHIC CLOSING MARK
  { 0x3007, BIDI_L   },  // IDEOGRAPHIC NUMBER ZERO
  { 0x3008, BIDI_ON  },  // LEFT ANGLE BRACKET
  { 0x3009, BIDI_ON  },  // RIGHT ANGLE BRACKET
  { 0x300A, BIDI_ON  },  // LEFT DOUBLE ANGLE BRACKET
  { 0x300B, BIDI_ON  },  // RIGHT DOUBLE ANGLE BRACKET
  { 0x300C, BIDI_ON  },  // LEFT CORNER BRACKET
  { 0x300D, BIDI_ON  },  // RIGHT CORNER BRACKET
  { 0x300E, BIDI_ON  },  // LEFT WHITE CORNER BRACKET
  { 0x300F, BIDI_ON  },  // RIGHT WHITE CORNER BRACKET
  { 0x3010, BIDI_ON  },  // LEFT BLACK LENTICULAR BRACKET
  { 0x3011, BIDI_ON  },  // RIGHT BLACK LENTICULAR BRACKET
  { 0x3012, BIDI_ON  },  // POSTAL MARK
  { 0x3013, BIDI_ON  },  // GETA MARK
  { 0x3014, BIDI_ON  },  // LEFT TORTOISE SHELL BRACKET
  { 0x3015, BIDI_ON  },  // RIGHT TORTOISE SHELL BRACKET
  { 0x3016, BIDI_ON  },  // LEFT WHITE LENTICULAR BRACKET
  { 0x3017, BIDI_ON  },  // RIGHT WHITE LENTICULAR BRACKET
  { 0x3018, BIDI_ON  },  // LEFT WHITE TORTOISE SHELL BRACKET
  { 0x3019, BIDI_ON  },  // RIGHT WHITE TORTOISE SHELL BRACKET
  { 0x301A, BIDI_ON  },  // LEFT WHITE SQUARE BRACKET
  { 0x301B, BIDI_ON  },  // RIGHT WHITE SQUARE BRACKET
  { 0x301C, BIDI_ON  },  // WAVE DASH
  { 0x301D, BIDI_ON  },  // REVERSED DOUBLE PRIME QUOTATION MARK
  { 0x301E, BIDI_ON  },  // DOUBLE PRIME QUOTATION MARK
  { 0x301F, BIDI_ON  },  // LOW DOUBLE PRIME QUOTATION MARK
  { 0x3020, BIDI_ON  },  // POSTAL MARK FACE
  { 0x3021, BIDI_L   },  // HANGZHOU NUMERAL ONE
  { 0x3022, BIDI_L   },  // HANGZHOU NUMERAL TWO
  { 0x3023, BIDI_L   },  // HANGZHOU NUMERAL THREE
  { 0x3024, BIDI_L   },  // HANGZHOU NUMERAL FOUR
  { 0x3025, BIDI_L   },  // HANGZHOU NUMERAL FIVE
  { 0x3026, BIDI_L   },  // HANGZHOU NUMERAL SIX
  { 0x3027, BIDI_L   },  // HANGZHOU NUMERAL SEVEN
  { 0x3028, BIDI_L   },  // HANGZHOU NUMERAL EIGHT
  { 0x3029, BIDI_L   },  // HANGZHOU NUMERAL NINE
  { 0x302A, BIDI_NSM },  // IDEOGRAPHIC LEVEL TONE MARK
  { 0x302B, BIDI_NSM },  // IDEOGRAPHIC RISING TONE MARK
  { 0x302C, BIDI_NSM },  // IDEOGRAPHIC DEPARTING TONE MARK
  { 0x302D, BIDI_NSM },  // IDEOGRAPHIC ENTERING TONE MARK
  { 0x302E, BIDI_L   },  // HANGUL SINGLE DOT TONE MARK
  { 0x302F, BIDI_L   },  // HANGUL DOUBLE DOT TONE MARK
  { 0x3030, BIDI_ON  },  // WAVY DASH
  { 0x3031, BIDI_L   },  // VERTICAL KANA REPEAT MARK
  { 0x3032, BIDI_L   },  // VERTICAL KANA REPEAT WITH VOICED SOUND MARK
  { 0x3033, BIDI_L   },  // VERTICAL KANA REPEAT MARK UPPER HALF
  { 0x3034, BIDI_L   },  // VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF
  { 0x3035, BIDI_L   },  // VERTICAL KANA REPEAT MARK LOWER HALF
  { 0x3036, BIDI_ON  },  // CIRCLED POSTAL MARK
  { 0x3037, BIDI_ON  },  // IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL
  { 0x3038, BIDI_L   },  // HANGZHOU NUMERAL TEN
  { 0x3039, BIDI_L   },  // HANGZHOU NUMERAL TWENTY
  { 0x303A, BIDI_L   },  // HANGZHOU NUMERAL THIRTY
  { 0x303B, BIDI_L   },  // VERTICAL IDEOGRAPHIC ITERATION MARK
  { 0x303C, BIDI_L   },  // MASU MARK
  { 0x303D, BIDI_ON  },  // PART ALTERNATION MARK
  { 0x303E, BIDI_ON  },  // IDEOGRAPHIC VARIATION INDICATOR
  { 0x303F, BIDI_ON  },  // IDEOGRAPHIC HALF FILL SPACE
  { 0x3041, BIDI_L   },  // HIRAGANA LETTER SMALL A
  { 0x3042, BIDI_L   },  // HIRAGANA LETTER A
  { 0x3043, BIDI_L   },  // HIRAGANA LETTER SMALL I
  { 0x3044, BIDI_L   },  // HIRAGANA LETTER I
  { 0x3045, BIDI_L   },  // HIRAGANA LETTER SMALL U
  { 0x3046, BIDI_L   },  // HIRAGANA LETTER U
  { 0x3047, BIDI_L   },  // HIRAGANA LETTER SMALL E
  { 0x3048, BIDI_L   },  // HIRAGANA LETTER E
  { 0x3049, BIDI_L   },  // HIRAGANA LETTER SMALL O
  { 0x304A, BIDI_L   },  // HIRAGANA LETTER O
  { 0x304B, BIDI_L   },  // HIRAGANA LETTER KA
  { 0x304C, BIDI_L   },  // HIRAGANA LETTER GA
  { 0x304D, BIDI_L   },  // HIRAGANA LETTER KI
  { 0x304E, BIDI_L   },  // HIRAGANA LETTER GI
  { 0x304F, BIDI_L   },  // HIRAGANA LETTER KU
  { 0x3050, BIDI_L   },  // HIRAGANA LETTER GU
  { 0x3051, BIDI_L   },  // HIRAGANA LETTER KE
  { 0x3052, BIDI_L   },  // HIRAGANA LETTER GE
  { 0x3053, BIDI_L   },  // HIRAGANA LETTER KO
  { 0x3054, BIDI_L   },  // HIRAGANA LETTER GO
  { 0x3055, BIDI_L   },  // HIRAGANA LETTER SA
  { 0x3056, BIDI_L   },  // HIRAGANA LETTER ZA
  { 0x3057, BIDI_L   },  // HIRAGANA LETTER SI
  { 0x3058, BIDI_L   },  // HIRAGANA LETTER ZI
  { 0x3059, BIDI_L   },  // HIRAGANA LETTER SU
  { 0x305A, BIDI_L   },  // HIRAGANA LETTER ZU
  { 0x305B, BIDI_L   },  // HIRAGANA LETTER SE
  { 0x305C, BIDI_L   },  // HIRAGANA LETTER ZE
  { 0x305D, BIDI_L   },  // HIRAGANA LETTER SO
  { 0x305E, BIDI_L   },  // HIRAGANA LETTER ZO
  { 0x305F, BIDI_L   },  // HIRAGANA LETTER TA
  { 0x3060, BIDI_L   },  // HIRAGANA LETTER DA
  { 0x3061, BIDI_L   },  // HIRAGANA LETTER TI
  { 0x3062, BIDI_L   },  // HIRAGANA LETTER DI
  { 0x3063, BIDI_L   },  // HIRAGANA LETTER SMALL TU
  { 0x3064, BIDI_L   },  // HIRAGANA LETTER TU
  { 0x3065, BIDI_L   },  // HIRAGANA LETTER DU
  { 0x3066, BIDI_L   },  // HIRAGANA LETTER TE
  { 0x3067, BIDI_L   },  // HIRAGANA LETTER DE
  { 0x3068, BIDI_L   },  // HIRAGANA LETTER TO
  { 0x3069, BIDI_L   },  // HIRAGANA LETTER DO
  { 0x306A, BIDI_L   },  // HIRAGANA LETTER NA
  { 0x306B, BIDI_L   },  // HIRAGANA LETTER NI
  { 0x306C, BIDI_L   },  // HIRAGANA LETTER NU
  { 0x306D, BIDI_L   },  // HIRAGANA LETTER NE
  { 0x306E, BIDI_L   },  // HIRAGANA LETTER NO
  { 0x306F, BIDI_L   },  // HIRAGANA LETTER HA
  { 0x3070, BIDI_L   },  // HIRAGANA LETTER BA
  { 0x3071, BIDI_L   },  // HIRAGANA LETTER PA
  { 0x3072, BIDI_L   },  // HIRAGANA LETTER HI
  { 0x3073, BIDI_L   },  // HIRAGANA LETTER BI
  { 0x3074, BIDI_L   },  // HIRAGANA LETTER PI
  { 0x3075, BIDI_L   },  // HIRAGANA LETTER HU
  { 0x3076, BIDI_L   },  // HIRAGANA LETTER BU
  { 0x3077, BIDI_L   },  // HIRAGANA LETTER PU
  { 0x3078, BIDI_L   },  // HIRAGANA LETTER HE
  { 0x3079, BIDI_L   },  // HIRAGANA LETTER BE
  { 0x307A, BIDI_L   },  // HIRAGANA LETTER PE
  { 0x307B, BIDI_L   },  // HIRAGANA LETTER HO
  { 0x307C, BIDI_L   },  // HIRAGANA LETTER BO
  { 0x307D, BIDI_L   },  // HIRAGANA LETTER PO
  { 0x307E, BIDI_L   },  // HIRAGANA LETTER MA
  { 0x307F, BIDI_L   },  // HIRAGANA LETTER MI
  { 0x3080, BIDI_L   },  // HIRAGANA LETTER MU
  { 0x3081, BIDI_L   },  // HIRAGANA LETTER ME
  { 0x3082, BIDI_L   },  // HIRAGANA LETTER MO
  { 0x3083, BIDI_L   },  // HIRAGANA LETTER SMALL YA
  { 0x3084, BIDI_L   },  // HIRAGANA LETTER YA
  { 0x3085, BIDI_L   },  // HIRAGANA LETTER SMALL YU
  { 0x3086, BIDI_L   },  // HIRAGANA LETTER YU
  { 0x3087, BIDI_L   },  // HIRAGANA LETTER SMALL YO
  { 0x3088, BIDI_L   },  // HIRAGANA LETTER YO
  { 0x3089, BIDI_L   },  // HIRAGANA LETTER RA
  { 0x308A, BIDI_L   },  // HIRAGANA LETTER RI
  { 0x308B, BIDI_L   },  // HIRAGANA LETTER RU
  { 0x308C, BIDI_L   },  // HIRAGANA LETTER RE
  { 0x308D, BIDI_L   },  // HIRAGANA LETTER RO
  { 0x308E, BIDI_L   },  // HIRAGANA LETTER SMALL WA
  { 0x308F, BIDI_L   },  // HIRAGANA LETTER WA
  { 0x3090, BIDI_L   },  // HIRAGANA LETTER WI
  { 0x3091, BIDI_L   },  // HIRAGANA LETTER WE
  { 0x3092, BIDI_L   },  // HIRAGANA LETTER WO
  { 0x3093, BIDI_L   },  // HIRAGANA LETTER N
  { 0x3094, BIDI_L   },  // HIRAGANA LETTER VU
  { 0x3095, BIDI_L   },  // HIRAGANA LETTER SMALL KA
  { 0x3096, BIDI_L   },  // HIRAGANA LETTER SMALL KE
  { 0x3099, BIDI_NSM },  // COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
  { 0x309A, BIDI_NSM },  // COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
  { 0x309B, BIDI_ON  },  // KATAKANA-HIRAGANA VOICED SOUND MARK
  { 0x309C, BIDI_ON  },  // KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
  { 0x309D, BIDI_L   },  // HIRAGANA ITERATION MARK
  { 0x309E, BIDI_L   },  // HIRAGANA VOICED ITERATION MARK
  { 0x309F, BIDI_L   },  // HIRAGANA DIGRAPH YORI
  { 0x30A0, BIDI_ON  },  // KATAKANA-HIRAGANA DOUBLE HYPHEN
  { 0x30A1, BIDI_L   },  // KATAKANA LETTER SMALL A
  { 0x30A2, BIDI_L   },  // KATAKANA LETTER A
  { 0x30A3, BIDI_L   },  // KATAKANA LETTER SMALL I
  { 0x30A4, BIDI_L   },  // KATAKANA LETTER I
  { 0x30A5, BIDI_L   },  // KATAKANA LETTER SMALL U
  { 0x30A6, BIDI_L   },  // KATAKANA LETTER U
  { 0x30A7, BIDI_L   },  // KATAKANA LETTER SMALL E
  { 0x30A8, BIDI_L   },  // KATAKANA LETTER E
  { 0x30A9, BIDI_L   },  // KATAKANA LETTER SMALL O
  { 0x30AA, BIDI_L   },  // KATAKANA LETTER O
  { 0x30AB, BIDI_L   },  // KATAKANA LETTER KA
  { 0x30AC, BIDI_L   },  // KATAKANA LETTER GA
  { 0x30AD, BIDI_L   },  // KATAKANA LETTER KI
  { 0x30AE, BIDI_L   },  // KATAKANA LETTER GI
  { 0x30AF, BIDI_L   },  // KATAKANA LETTER KU
  { 0x30B0, BIDI_L   },  // KATAKANA LETTER GU
  { 0x30B1, BIDI_L   },  // KATAKANA LETTER KE
  { 0x30B2, BIDI_L   },  // KATAKANA LETTER GE
  { 0x30B3, BIDI_L   },  // KATAKANA LETTER KO
  { 0x30B4, BIDI_L   },  // KATAKANA LETTER GO
  { 0x30B5, BIDI_L   },  // KATAKANA LETTER SA
  { 0x30B6, BIDI_L   },  // KATAKANA LETTER ZA
  { 0x30B7, BIDI_L   },  // KATAKANA LETTER SI
  { 0x30B8, BIDI_L   },  // KATAKANA LETTER ZI
  { 0x30B9, BIDI_L   },  // KATAKANA LETTER SU
  { 0x30BA, BIDI_L   },  // KATAKANA LETTER ZU
  { 0x30BB, BIDI_L   },  // KATAKANA LETTER SE
  { 0x30BC, BIDI_L   },  // KATAKANA LETTER ZE
  { 0x30BD, BIDI_L   },  // KATAKANA LETTER SO
  { 0x30BE, BIDI_L   },  // KATAKANA LETTER ZO
  { 0x30BF, BIDI_L   },  // KATAKANA LETTER TA
  { 0x30C0, BIDI_L   },  // KATAKANA LETTER DA
  { 0x30C1, BIDI_L   },  // KATAKANA LETTER TI
  { 0x30C2, BIDI_L   },  // KATAKANA LETTER DI
  { 0x30C3, BIDI_L   },  // KATAKANA LETTER SMALL TU
  { 0x30C4, BIDI_L   },  // KATAKANA LETTER TU
  { 0x30C5, BIDI_L   },  // KATAKANA LETTER DU
  { 0x30C6, BIDI_L   },  // KATAKANA LETTER TE
  { 0x30C7, BIDI_L   },  // KATAKANA LETTER DE
  { 0x30C8, BIDI_L   },  // KATAKANA LETTER TO
  { 0x30C9, BIDI_L   },  // KATAKANA LETTER DO
  { 0x30CA, BIDI_L   },  // KATAKANA LETTER NA
  { 0x30CB, BIDI_L   },  // KATAKANA LETTER NI
  { 0x30CC, BIDI_L   },  // KATAKANA LETTER NU
  { 0x30CD, BIDI_L   },  // KATAKANA LETTER NE
  { 0x30CE, BIDI_L   },  // KATAKANA LETTER NO
  { 0x30CF, BIDI_L   },  // KATAKANA LETTER HA
  { 0x30D0, BIDI_L   },  // KATAKANA LETTER BA
  { 0x30D1, BIDI_L   },  // KATAKANA LETTER PA
  { 0x30D2, BIDI_L   },  // KATAKANA LETTER HI
  { 0x30D3, BIDI_L   },  // KATAKANA LETTER BI
  { 0x30D4, BIDI_L   },  // KATAKANA LETTER PI
  { 0x30D5, BIDI_L   },  // KATAKANA LETTER HU
  { 0x30D6, BIDI_L   },  // KATAKANA LETTER BU
  { 0x30D7, BIDI_L   },  // KATAKANA LETTER PU
  { 0x30D8, BIDI_L   },  // KATAKANA LETTER HE
  { 0x30D9, BIDI_L   },  // KATAKANA LETTER BE
  { 0x30DA, BIDI_L   },  // KATAKANA LETTER PE
  { 0x30DB, BIDI_L   },  // KATAKANA LETTER HO
  { 0x30DC, BIDI_L   },  // KATAKANA LETTER BO
  { 0x30DD, BIDI_L   },  // KATAKANA LETTER PO
  { 0x30DE, BIDI_L   },  // KATAKANA LETTER MA
  { 0x30DF, BIDI_L   },  // KATAKANA LETTER MI
  { 0x30E0, BIDI_L   },  // KATAKANA LETTER MU
  { 0x30E1, BIDI_L   },  // KATAKANA LETTER ME
  { 0x30E2, BIDI_L   },  // KATAKANA LETTER MO
  { 0x30E3, BIDI_L   },  // KATAKANA LETTER SMALL YA
  { 0x30E4, BIDI_L   },  // KATAKANA LETTER YA
  { 0x30E5, BIDI_L   },  // KATAKANA LETTER SMALL YU
  { 0x30E6, BIDI_L   },  // KATAKANA LETTER YU
  { 0x30E7, BIDI_L   },  // KATAKANA LETTER SMALL YO
  { 0x30E8, BIDI_L   },  // KATAKANA LETTER YO
  { 0x30E9, BIDI_L   },  // KATAKANA LETTER RA
  { 0x30EA, BIDI_L   },  // KATAKANA LETTER RI
  { 0x30EB, BIDI_L   },  // KATAKANA LETTER RU
  { 0x30EC, BIDI_L   },  // KATAKANA LETTER RE
  { 0x30ED, BIDI_L   },  // KATAKANA LETTER RO
  { 0x30EE, BIDI_L   },  // KATAKANA LETTER SMALL WA
  { 0x30EF, BIDI_L   },  // KATAKANA LETTER WA
  { 0x30F0, BIDI_L   },  // KATAKANA LETTER WI
  { 0x30F1, BIDI_L   },  // KATAKANA LETTER WE
  { 0x30F2, BIDI_L   },  // KATAKANA LETTER WO
  { 0x30F3, BIDI_L   },  // KATAKANA LETTER N
  { 0x30F4, BIDI_L   },  // KATAKANA LETTER VU
  { 0x30F5, BIDI_L   },  // KATAKANA LETTER SMALL KA
  { 0x30F6, BIDI_L   },  // KATAKANA LETTER SMALL KE
  { 0x30F7, BIDI_L   },  // KATAKANA LETTER VA
  { 0x30F8, BIDI_L   },  // KATAKANA LETTER VI
  { 0x30F9, BIDI_L   },  // KATAKANA LETTER VE
  { 0x30FA, BIDI_L   },  // KATAKANA LETTER VO
  { 0x30FB, BIDI_ON  },  // KATAKANA MIDDLE DOT
  { 0x30FC, BIDI_L   },  // KATAKANA-HIRAGANA PROLONGED SOUND MARK
  { 0x30FD, BIDI_L   },  // KATAKANA ITERATION MARK
  { 0x30FE, BIDI_L   },  // KATAKANA VOICED ITERATION MARK
  { 0x30FF, BIDI_L   },  // KATAKANA DIGRAPH KOTO
  { 0x3105, BIDI_L   },  // BOPOMOFO LETTER B
  { 0x3106, BIDI_L   },  // BOPOMOFO LETTER P
  { 0x3107, BIDI_L   },  // BOPOMOFO LETTER M
  { 0x3108, BIDI_L   },  // BOPOMOFO LETTER F
  { 0x3109, BIDI_L   },  // BOPOMOFO LETTER D
  { 0x310A, BIDI_L   },  // BOPOMOFO LETTER T
  { 0x310B, BIDI_L   },  // BOPOMOFO LETTER N
  { 0x310C, BIDI_L   },  // BOPOMOFO LETTER L
  { 0x310D, BIDI_L   },  // BOPOMOFO LETTER G
  { 0x310E, BIDI_L   },  // BOPOMOFO LETTER K
  { 0x310F, BIDI_L   },  // BOPOMOFO LETTER H
  { 0x3110, BIDI_L   },  // BOPOMOFO LETTER J
  { 0x3111, BIDI_L   },  // BOPOMOFO LETTER Q
  { 0x3112, BIDI_L   },  // BOPOMOFO LETTER X
  { 0x3113, BIDI_L   },  // BOPOMOFO LETTER ZH
  { 0x3114, BIDI_L   },  // BOPOMOFO LETTER CH
  { 0x3115, BIDI_L   },  // BOPOMOFO LETTER SH
  { 0x3116, BIDI_L   },  // BOPOMOFO LETTER R
  { 0x3117, BIDI_L   },  // BOPOMOFO LETTER Z
  { 0x3118, BIDI_L   },  // BOPOMOFO LETTER C
  { 0x3119, BIDI_L   },  // BOPOMOFO LETTER S
  { 0x311A, BIDI_L   },  // BOPOMOFO LETTER A
  { 0x311B, BIDI_L   },  // BOPOMOFO LETTER O
  { 0x311C, BIDI_L   },  // BOPOMOFO LETTER E
  { 0x311D, BIDI_L   },  // BOPOMOFO LETTER EH
  { 0x311E, BIDI_L   },  // BOPOMOFO LETTER AI
  { 0x311F, BIDI_L   },  // BOPOMOFO LETTER EI
  { 0x3120, BIDI_L   },  // BOPOMOFO LETTER AU
  { 0x3121, BIDI_L   },  // BOPOMOFO LETTER OU
  { 0x3122, BIDI_L   },  // BOPOMOFO LETTER AN
  { 0x3123, BIDI_L   },  // BOPOMOFO LETTER EN
  { 0x3124, BIDI_L   },  // BOPOMOFO LETTER ANG
  { 0x3125, BIDI_L   },  // BOPOMOFO LETTER ENG
  { 0x3126, BIDI_L   },  // BOPOMOFO LETTER ER
  { 0x3127, BIDI_L   },  // BOPOMOFO LETTER I
  { 0x3128, BIDI_L   },  // BOPOMOFO LETTER U
  { 0x3129, BIDI_L   },  // BOPOMOFO LETTER IU
  { 0x312A, BIDI_L   },  // BOPOMOFO LETTER V
  { 0x312B, BIDI_L   },  // BOPOMOFO LETTER NG
  { 0x312C, BIDI_L   },  // BOPOMOFO LETTER GN
  { 0x312D, BIDI_L   },  // BOPOMOFO LETTER IH
  { 0x3131, BIDI_L   },  // HANGUL LETTER KIYEOK
  { 0x3132, BIDI_L   },  // HANGUL LETTER SSANGKIYEOK
  { 0x3133, BIDI_L   },  // HANGUL LETTER KIYEOK-SIOS
  { 0x3134, BIDI_L   },  // HANGUL LETTER NIEUN
  { 0x3135, BIDI_L   },  // HANGUL LETTER NIEUN-CIEUC
  { 0x3136, BIDI_L   },  // HANGUL LETTER NIEUN-HIEUH
  { 0x3137, BIDI_L   },  // HANGUL LETTER TIKEUT
  { 0x3138, BIDI_L   },  // HANGUL LETTER SSANGTIKEUT
  { 0x3139, BIDI_L   },  // HANGUL LETTER RIEUL
  { 0x313A, BIDI_L   },  // HANGUL LETTER RIEUL-KIYEOK
  { 0x313B, BIDI_L   },  // HANGUL LETTER RIEUL-MIEUM
  { 0x313C, BIDI_L   },  // HANGUL LETTER RIEUL-PIEUP
  { 0x313D, BIDI_L   },  // HANGUL LETTER RIEUL-SIOS
  { 0x313E, BIDI_L   },  // HANGUL LETTER RIEUL-THIEUTH
  { 0x313F, BIDI_L   },  // HANGUL LETTER RIEUL-PHIEUPH
  { 0x3140, BIDI_L   },  // HANGUL LETTER RIEUL-HIEUH
  { 0x3141, BIDI_L   },  // HANGUL LETTER MIEUM
  { 0x3142, BIDI_L   },  // HANGUL LETTER PIEUP
  { 0x3143, BIDI_L   },  // HANGUL LETTER SSANGPIEUP
  { 0x3144, BIDI_L   },  // HANGUL LETTER PIEUP-SIOS
  { 0x3145, BIDI_L   },  // HANGUL LETTER SIOS
  { 0x3146, BIDI_L   },  // HANGUL LETTER SSANGSIOS
  { 0x3147, BIDI_L   },  // HANGUL LETTER IEUNG
  { 0x3148, BIDI_L   },  // HANGUL LETTER CIEUC
  { 0x3149, BIDI_L   },  // HANGUL LETTER SSANGCIEUC
  { 0x314A, BIDI_L   },  // HANGUL LETTER CHIEUCH
  { 0x314B, BIDI_L   },  // HANGUL LETTER KHIEUKH
  { 0x314C, BIDI_L   },  // HANGUL LETTER THIEUTH
  { 0x314D, BIDI_L   },  // HANGUL LETTER PHIEUPH
  { 0x314E, BIDI_L   },  // HANGUL LETTER HIEUH
  { 0x314F, BIDI_L   },  // HANGUL LETTER A
  { 0x3150, BIDI_L   },  // HANGUL LETTER AE
  { 0x3151, BIDI_L   },  // HANGUL LETTER YA
  { 0x3152, BIDI_L   },  // HANGUL LETTER YAE
  { 0x3153, BIDI_L   },  // HANGUL LETTER EO
  { 0x3154, BIDI_L   },  // HANGUL LETTER E
  { 0x3155, BIDI_L   },  // HANGUL LETTER YEO
  { 0x3156, BIDI_L   },  // HANGUL LETTER YE
  { 0x3157, BIDI_L   },  // HANGUL LETTER O
  { 0x3158, BIDI_L   },  // HANGUL LETTER WA
  { 0x3159, BIDI_L   },  // HANGUL LETTER WAE
  { 0x315A, BIDI_L   },  // HANGUL LETTER OE
  { 0x315B, BIDI_L   },  // HANGUL LETTER YO
  { 0x315C, BIDI_L   },  // HANGUL LETTER U
  { 0x315D, BIDI_L   },  // HANGUL LETTER WEO
  { 0x315E, BIDI_L   },  // HANGUL LETTER WE
  { 0x315F, BIDI_L   },  // HANGUL LETTER WI
  { 0x3160, BIDI_L   },  // HANGUL LETTER YU
  { 0x3161, BIDI_L   },  // HANGUL LETTER EU
  { 0x3162, BIDI_L   },  // HANGUL LETTER YI
  { 0x3163, BIDI_L   },  // HANGUL LETTER I
  { 0x3164, BIDI_L   },  // HANGUL FILLER
  { 0x3165, BIDI_L   },  // HANGUL LETTER SSANGNIEUN
  { 0x3166, BIDI_L   },  // HANGUL LETTER NIEUN-TIKEUT
  { 0x3167, BIDI_L   },  // HANGUL LETTER NIEUN-SIOS
  { 0x3168, BIDI_L   },  // HANGUL LETTER NIEUN-PANSIOS
  { 0x3169, BIDI_L   },  // HANGUL LETTER RIEUL-KIYEOK-SIOS
  { 0x316A, BIDI_L   },  // HANGUL LETTER RIEUL-TIKEUT
  { 0x316B, BIDI_L   },  // HANGUL LETTER RIEUL-PIEUP-SIOS
  { 0x316C, BIDI_L   },  // HANGUL LETTER RIEUL-PANSIOS
  { 0x316D, BIDI_L   },  // HANGUL LETTER RIEUL-YEORINHIEUH
  { 0x316E, BIDI_L   },  // HANGUL LETTER MIEUM-PIEUP
  { 0x316F, BIDI_L   },  // HANGUL LETTER MIEUM-SIOS
  { 0x3170, BIDI_L   },  // HANGUL LETTER MIEUM-PANSIOS
  { 0x3171, BIDI_L   },  // HANGUL LETTER KAPYEOUNMIEUM
  { 0x3172, BIDI_L   },  // HANGUL LETTER PIEUP-KIYEOK
  { 0x3173, BIDI_L   },  // HANGUL LETTER PIEUP-TIKEUT
  { 0x3174, BIDI_L   },  // HANGUL LETTER PIEUP-SIOS-KIYEOK
  { 0x3175, BIDI_L   },  // HANGUL LETTER PIEUP-SIOS-TIKEUT
  { 0x3176, BIDI_L   },  // HANGUL LETTER PIEUP-CIEUC
  { 0x3177, BIDI_L   },  // HANGUL LETTER PIEUP-THIEUTH
  { 0x3178, BIDI_L   },  // HANGUL LETTER KAPYEOUNPIEUP
  { 0x3179, BIDI_L   },  // HANGUL LETTER KAPYEOUNSSANGPIEUP
  { 0x317A, BIDI_L   },  // HANGUL LETTER SIOS-KIYEOK
  { 0x317B, BIDI_L   },  // HANGUL LETTER SIOS-NIEUN
  { 0x317C, BIDI_L   },  // HANGUL LETTER SIOS-TIKEUT
  { 0x317D, BIDI_L   },  // HANGUL LETTER SIOS-PIEUP
  { 0x317E, BIDI_L   },  // HANGUL LETTER SIOS-CIEUC
  { 0x317F, BIDI_L   },  // HANGUL LETTER PANSIOS
  { 0x3180, BIDI_L   },  // HANGUL LETTER SSANGIEUNG
  { 0x3181, BIDI_L   },  // HANGUL LETTER YESIEUNG
  { 0x3182, BIDI_L   },  // HANGUL LETTER YESIEUNG-SIOS
  { 0x3183, BIDI_L   },  // HANGUL LETTER YESIEUNG-PANSIOS
  { 0x3184, BIDI_L   },  // HANGUL LETTER KAPYEOUNPHIEUPH
  { 0x3185, BIDI_L   },  // HANGUL LETTER SSANGHIEUH
  { 0x3186, BIDI_L   },  // HANGUL LETTER YEORINHIEUH
  { 0x3187, BIDI_L   },  // HANGUL LETTER YO-YA
  { 0x3188, BIDI_L   },  // HANGUL LETTER YO-YAE
  { 0x3189, BIDI_L   },  // HANGUL LETTER YO-I
  { 0x318A, BIDI_L   },  // HANGUL LETTER YU-YEO
  { 0x318B, BIDI_L   },  // HANGUL LETTER YU-YE
  { 0x318C, BIDI_L   },  // HANGUL LETTER YU-I
  { 0x318D, BIDI_L   },  // HANGUL LETTER ARAEA
  { 0x318E, BIDI_L   },  // HANGUL LETTER ARAEAE
  { 0x3190, BIDI_L   },  // IDEOGRAPHIC ANNOTATION LINKING MARK
  { 0x3191, BIDI_L   },  // IDEOGRAPHIC ANNOTATION REVERSE MARK
  { 0x3192, BIDI_L   },  // IDEOGRAPHIC ANNOTATION ONE MARK
  { 0x3193, BIDI_L   },  // IDEOGRAPHIC ANNOTATION TWO MARK
  { 0x3194, BIDI_L   },  // IDEOGRAPHIC ANNOTATION THREE MARK
  { 0x3195, BIDI_L   },  // IDEOGRAPHIC ANNOTATION FOUR MARK
  { 0x3196, BIDI_L   },  // IDEOGRAPHIC ANNOTATION TOP MARK
  { 0x3197, BIDI_L   },  // IDEOGRAPHIC ANNOTATION MIDDLE MARK
  { 0x3198, BIDI_L   },  // IDEOGRAPHIC ANNOTATION BOTTOM MARK
  { 0x3199, BIDI_L   },  // IDEOGRAPHIC ANNOTATION FIRST MARK
  { 0x319A, BIDI_L   },  // IDEOGRAPHIC ANNOTATION SECOND MARK
  { 0x319B, BIDI_L   },  // IDEOGRAPHIC ANNOTATION THIRD MARK
  { 0x319C, BIDI_L   },  // IDEOGRAPHIC ANNOTATION FOURTH MARK
  { 0x319D, BIDI_L   },  // IDEOGRAPHIC ANNOTATION HEAVEN MARK
  { 0x319E, BIDI_L   },  // IDEOGRAPHIC ANNOTATION EARTH MARK
  { 0x319F, BIDI_L   },  // IDEOGRAPHIC ANNOTATION MAN MARK
  { 0x31A0, BIDI_L   },  // BOPOMOFO LETTER BU
  { 0x31A1, BIDI_L   },  // BOPOMOFO LETTER ZI
  { 0x31A2, BIDI_L   },  // BOPOMOFO LETTER JI
  { 0x31A3, BIDI_L   },  // BOPOMOFO LETTER GU
  { 0x31A4, BIDI_L   },  // BOPOMOFO LETTER EE
  { 0x31A5, BIDI_L   },  // BOPOMOFO LETTER ENN
  { 0x31A6, BIDI_L   },  // BOPOMOFO LETTER OO
  { 0x31A7, BIDI_L   },  // BOPOMOFO LETTER ONN
  { 0x31A8, BIDI_L   },  // BOPOMOFO LETTER IR
  { 0x31A9, BIDI_L   },  // BOPOMOFO LETTER ANN
  { 0x31AA, BIDI_L   },  // BOPOMOFO LETTER INN
  { 0x31AB, BIDI_L   },  // BOPOMOFO LETTER UNN
  { 0x31AC, BIDI_L   },  // BOPOMOFO LETTER IM
  { 0x31AD, BIDI_L   },  // BOPOMOFO LETTER NGG
  { 0x31AE, BIDI_L   },  // BOPOMOFO LETTER AINN
  { 0x31AF, BIDI_L   },  // BOPOMOFO LETTER AUNN
  { 0x31B0, BIDI_L   },  // BOPOMOFO LETTER AM
  { 0x31B1, BIDI_L   },  // BOPOMOFO LETTER OM
  { 0x31B2, BIDI_L   },  // BOPOMOFO LETTER ONG
  { 0x31B3, BIDI_L   },  // BOPOMOFO LETTER INNN
  { 0x31B4, BIDI_L   },  // BOPOMOFO FINAL LETTER P
  { 0x31B5, BIDI_L   },  // BOPOMOFO FINAL LETTER T
  { 0x31B6, BIDI_L   },  // BOPOMOFO FINAL LETTER K
  { 0x31B7, BIDI_L   },  // BOPOMOFO FINAL LETTER H
  { 0x31B8, BIDI_L   },  // BOPOMOFO LETTER GH
  { 0x31B9, BIDI_L   },  // BOPOMOFO LETTER LH
  { 0x31BA, BIDI_L   },  // BOPOMOFO LETTER ZY
  { 0x31C0, BIDI_ON  },  // CJK STROKE T
  { 0x31C1, BIDI_ON  },  // CJK STROKE WG
  { 0x31C2, BIDI_ON  },  // CJK STROKE XG
  { 0x31C3, BIDI_ON  },  // CJK STROKE BXG
  { 0x31C4, BIDI_ON  },  // CJK STROKE SW
  { 0x31C5, BIDI_ON  },  // CJK STROKE HZZ
  { 0x31C6, BIDI_ON  },  // CJK STROKE HZG
  { 0x31C7, BIDI_ON  },  // CJK STROKE HP
  { 0x31C8, BIDI_ON  },  // CJK STROKE HZWG
  { 0x31C9, BIDI_ON  },  // CJK STROKE SZWG
  { 0x31CA, BIDI_ON  },  // CJK STROKE HZT
  { 0x31CB, BIDI_ON  },  // CJK STROKE HZZP
  { 0x31CC, BIDI_ON  },  // CJK STROKE HPWG
  { 0x31CD, BIDI_ON  },  // CJK STROKE HZW
  { 0x31CE, BIDI_ON  },  // CJK STROKE HZZZ
  { 0x31CF, BIDI_ON  },  // CJK STROKE N
  { 0x31D0, BIDI_ON  },  // CJK STROKE H
  { 0x31D1, BIDI_ON  },  // CJK STROKE S
  { 0x31D2, BIDI_ON  },  // CJK STROKE P
  { 0x31D3, BIDI_ON  },  // CJK STROKE SP
  { 0x31D4, BIDI_ON  },  // CJK STROKE D
  { 0x31D5, BIDI_ON  },  // CJK STROKE HZ
  { 0x31D6, BIDI_ON  },  // CJK STROKE HG
  { 0x31D7, BIDI_ON  },  // CJK STROKE SZ
  { 0x31D8, BIDI_ON  },  // CJK STROKE SWZ
  { 0x31D9, BIDI_ON  },  // CJK STROKE ST
  { 0x31DA, BIDI_ON  },  // CJK STROKE SG
  { 0x31DB, BIDI_ON  },  // CJK STROKE PD
  { 0x31DC, BIDI_ON  },  // CJK STROKE PZ
  { 0x31DD, BIDI_ON  },  // CJK STROKE TN
  { 0x31DE, BIDI_ON  },  // CJK STROKE SZZ
  { 0x31DF, BIDI_ON  },  // CJK STROKE SWG
  { 0x31E0, BIDI_ON  },  // CJK STROKE HXWG
  { 0x31E1, BIDI_ON  },  // CJK STROKE HZZZG
  { 0x31E2, BIDI_ON  },  // CJK STROKE PG
  { 0x31E3, BIDI_ON  },  // CJK STROKE Q
  { 0x31F0, BIDI_L   },  // KATAKANA LETTER SMALL KU
  { 0x31F1, BIDI_L   },  // KATAKANA LETTER SMALL SI
  { 0x31F2, BIDI_L   },  // KATAKANA LETTER SMALL SU
  { 0x31F3, BIDI_L   },  // KATAKANA LETTER SMALL TO
  { 0x31F4, BIDI_L   },  // KATAKANA LETTER SMALL NU
  { 0x31F5, BIDI_L   },  // KATAKANA LETTER SMALL HA
  { 0x31F6, BIDI_L   },  // KATAKANA LETTER SMALL HI
  { 0x31F7, BIDI_L   },  // KATAKANA LETTER SMALL HU
  { 0x31F8, BIDI_L   },  // KATAKANA LETTER SMALL HE
  { 0x31F9, BIDI_L   },  // KATAKANA LETTER SMALL HO
  { 0x31FA, BIDI_L   },  // KATAKANA LETTER SMALL MU
  { 0x31FB, BIDI_L   },  // KATAKANA LETTER SMALL RA
  { 0x31FC, BIDI_L   },  // KATAKANA LETTER SMALL RI
  { 0x31FD, BIDI_L   },  // KATAKANA LETTER SMALL RU
  { 0x31FE, BIDI_L   },  // KATAKANA LETTER SMALL RE
  { 0x31FF, BIDI_L   },  // KATAKANA LETTER SMALL RO
  { 0x3200, BIDI_L   },  // PARENTHESIZED HANGUL KIYEOK
  { 0x3201, BIDI_L   },  // PARENTHESIZED HANGUL NIEUN
  { 0x3202, BIDI_L   },  // PARENTHESIZED HANGUL TIKEUT
  { 0x3203, BIDI_L   },  // PARENTHESIZED HANGUL RIEUL
  { 0x3204, BIDI_L   },  // PARENTHESIZED HANGUL MIEUM
  { 0x3205, BIDI_L   },  // PARENTHESIZED HANGUL PIEUP
  { 0x3206, BIDI_L   },  // PARENTHESIZED HANGUL SIOS
  { 0x3207, BIDI_L   },  // PARENTHESIZED HANGUL IEUNG
  { 0x3208, BIDI_L   },  // PARENTHESIZED HANGUL CIEUC
  { 0x3209, BIDI_L   },  // PARENTHESIZED HANGUL CHIEUCH
  { 0x320A, BIDI_L   },  // PARENTHESIZED HANGUL KHIEUKH
  { 0x320B, BIDI_L   },  // PARENTHESIZED HANGUL THIEUTH
  { 0x320C, BIDI_L   },  // PARENTHESIZED HANGUL PHIEUPH
  { 0x320D, BIDI_L   },  // PARENTHESIZED HANGUL HIEUH
  { 0x320E, BIDI_L   },  // PARENTHESIZED HANGUL KIYEOK A
  { 0x320F, BIDI_L   },  // PARENTHESIZED HANGUL NIEUN A
  { 0x3210, BIDI_L   },  // PARENTHESIZED HANGUL TIKEUT A
  { 0x3211, BIDI_L   },  // PARENTHESIZED HANGUL RIEUL A
  { 0x3212, BIDI_L   },  // PARENTHESIZED HANGUL MIEUM A
  { 0x3213, BIDI_L   },  // PARENTHESIZED HANGUL PIEUP A
  { 0x3214, BIDI_L   },  // PARENTHESIZED HANGUL SIOS A
  { 0x3215, BIDI_L   },  // PARENTHESIZED HANGUL IEUNG A
  { 0x3216, BIDI_L   },  // PARENTHESIZED HANGUL CIEUC A
  { 0x3217, BIDI_L   },  // PARENTHESIZED HANGUL CHIEUCH A
  { 0x3218, BIDI_L   },  // PARENTHESIZED HANGUL KHIEUKH A
  { 0x3219, BIDI_L   },  // PARENTHESIZED HANGUL THIEUTH A
  { 0x321A, BIDI_L   },  // PARENTHESIZED HANGUL PHIEUPH A
  { 0x321B, BIDI_L   },  // PARENTHESIZED HANGUL HIEUH A
  { 0x321C, BIDI_L   },  // PARENTHESIZED HANGUL CIEUC U
  { 0x321D, BIDI_ON  },  // PARENTHESIZED KOREAN CHARACTER OJEON
  { 0x321E, BIDI_ON  },  // PARENTHESIZED KOREAN CHARACTER O HU
  { 0x3220, BIDI_L   },  // PARENTHESIZED IDEOGRAPH ONE
  { 0x3221, BIDI_L   },  // PARENTHESIZED IDEOGRAPH TWO
  { 0x3222, BIDI_L   },  // PARENTHESIZED IDEOGRAPH THREE
  { 0x3223, BIDI_L   },  // PARENTHESIZED IDEOGRAPH FOUR
  { 0x3224, BIDI_L   },  // PARENTHESIZED IDEOGRAPH FIVE
  { 0x3225, BIDI_L   },  // PARENTHESIZED IDEOGRAPH SIX
  { 0x3226, BIDI_L   },  // PARENTHESIZED IDEOGRAPH SEVEN
  { 0x3227, BIDI_L   },  // PARENTHESIZED IDEOGRAPH EIGHT
  { 0x3228, BIDI_L   },  // PARENTHESIZED IDEOGRAPH NINE
  { 0x3229, BIDI_L   },  // PARENTHESIZED IDEOGRAPH TEN
  { 0x322A, BIDI_L   },  // PARENTHESIZED IDEOGRAPH MOON
  { 0x322B, BIDI_L   },  // PARENTHESIZED IDEOGRAPH FIRE
  { 0x322C, BIDI_L   },  // PARENTHESIZED IDEOGRAPH WATER
  { 0x322D, BIDI_L   },  // PARENTHESIZED IDEOGRAPH WOOD
  { 0x322E, BIDI_L   },  // PARENTHESIZED IDEOGRAPH METAL
  { 0x322F, BIDI_L   },  // PARENTHESIZED IDEOGRAPH EARTH
  { 0x3230, BIDI_L   },  // PARENTHESIZED IDEOGRAPH SUN
  { 0x3231, BIDI_L   },  // PARENTHESIZED IDEOGRAPH STOCK
  { 0x3232, BIDI_L   },  // PARENTHESIZED IDEOGRAPH HAVE
  { 0x3233, BIDI_L   },  // PARENTHESIZED IDEOGRAPH SOCIETY
  { 0x3234, BIDI_L   },  // PARENTHESIZED IDEOGRAPH NAME
  { 0x3235, BIDI_L   },  // PARENTHESIZED IDEOGRAPH SPECIAL
  { 0x3236, BIDI_L   },  // PARENTHESIZED IDEOGRAPH FINANCIAL
  { 0x3237, BIDI_L   },  // PARENTHESIZED IDEOGRAPH CONGRATULATION
  { 0x3238, BIDI_L   },  // PARENTHESIZED IDEOGRAPH LABOR
  { 0x3239, BIDI_L   },  // PARENTHESIZED IDEOGRAPH REPRESENT
  { 0x323A, BIDI_L   },  // PARENTHESIZED IDEOGRAPH CALL
  { 0x323B, BIDI_L   },  // PARENTHESIZED IDEOGRAPH STUDY
  { 0x323C, BIDI_L   },  // PARENTHESIZED IDEOGRAPH SUPERVISE
  { 0x323D, BIDI_L   },  // PARENTHESIZED IDEOGRAPH ENTERPRISE
  { 0x323E, BIDI_L   },  // PARENTHESIZED IDEOGRAPH RESOURCE
  { 0x323F, BIDI_L   },  // PARENTHESIZED IDEOGRAPH ALLIANCE
  { 0x3240, BIDI_L   },  // PARENTHESIZED IDEOGRAPH FESTIVAL
  { 0x3241, BIDI_L   },  // PARENTHESIZED IDEOGRAPH REST
  { 0x3242, BIDI_L   },  // PARENTHESIZED IDEOGRAPH SELF
  { 0x3243, BIDI_L   },  // PARENTHESIZED IDEOGRAPH REACH
  { 0x3244, BIDI_L   },  // CIRCLED IDEOGRAPH QUESTION
  { 0x3245, BIDI_L   },  // CIRCLED IDEOGRAPH KINDERGARTEN
  { 0x3246, BIDI_L   },  // CIRCLED IDEOGRAPH SCHOOL
  { 0x3247, BIDI_L   },  // CIRCLED IDEOGRAPH KOTO
  { 0x3248, BIDI_L   },  // CIRCLED NUMBER TEN ON BLACK SQUARE
  { 0x3249, BIDI_L   },  // CIRCLED NUMBER TWENTY ON BLACK SQUARE
  { 0x324A, BIDI_L   },  // CIRCLED NUMBER THIRTY ON BLACK SQUARE
  { 0x324B, BIDI_L   },  // CIRCLED NUMBER FORTY ON BLACK SQUARE
  { 0x324C, BIDI_L   },  // CIRCLED NUMBER FIFTY ON BLACK SQUARE
  { 0x324D, BIDI_L   },  // CIRCLED NUMBER SIXTY ON BLACK SQUARE
  { 0x324E, BIDI_L   },  // CIRCLED NUMBER SEVENTY ON BLACK SQUARE
  { 0x324F, BIDI_L   },  // CIRCLED NUMBER EIGHTY ON BLACK SQUARE
  { 0x3250, BIDI_ON  },  // PARTNERSHIP SIGN
  { 0x3251, BIDI_ON  },  // CIRCLED NUMBER TWENTY ONE
  { 0x3252, BIDI_ON  },  // CIRCLED NUMBER TWENTY TWO
  { 0x3253, BIDI_ON  },  // CIRCLED NUMBER TWENTY THREE
  { 0x3254, BIDI_ON  },  // CIRCLED NUMBER TWENTY FOUR
  { 0x3255, BIDI_ON  },  // CIRCLED NUMBER TWENTY FIVE
  { 0x3256, BIDI_ON  },  // CIRCLED NUMBER TWENTY SIX
  { 0x3257, BIDI_ON  },  // CIRCLED NUMBER TWENTY SEVEN
  { 0x3258, BIDI_ON  },  // CIRCLED NUMBER TWENTY EIGHT
  { 0x3259, BIDI_ON  },  // CIRCLED NUMBER TWENTY NINE
  { 0x325A, BIDI_ON  },  // CIRCLED NUMBER THIRTY
  { 0x325B, BIDI_ON  },  // CIRCLED NUMBER THIRTY ONE
  { 0x325C, BIDI_ON  },  // CIRCLED NUMBER THIRTY TWO
  { 0x325D, BIDI_ON  },  // CIRCLED NUMBER THIRTY THREE
  { 0x325E, BIDI_ON  },  // CIRCLED NUMBER THIRTY FOUR
  { 0x325F, BIDI_ON  },  // CIRCLED NUMBER THIRTY FIVE
  { 0x3260, BIDI_L   },  // CIRCLED HANGUL KIYEOK
  { 0x3261, BIDI_L   },  // CIRCLED HANGUL NIEUN
  { 0x3262, BIDI_L   },  // CIRCLED HANGUL TIKEUT
  { 0x3263, BIDI_L   },  // CIRCLED HANGUL RIEUL
  { 0x3264, BIDI_L   },  // CIRCLED HANGUL MIEUM
  { 0x3265, BIDI_L   },  // CIRCLED HANGUL PIEUP
  { 0x3266, BIDI_L   },  // CIRCLED HANGUL SIOS
  { 0x3267, BIDI_L   },  // CIRCLED HANGUL IEUNG
  { 0x3268, BIDI_L   },  // CIRCLED HANGUL CIEUC
  { 0x3269, BIDI_L   },  // CIRCLED HANGUL CHIEUCH
  { 0x326A, BIDI_L   },  // CIRCLED HANGUL KHIEUKH
  { 0x326B, BIDI_L   },  // CIRCLED HANGUL THIEUTH
  { 0x326C, BIDI_L   },  // CIRCLED HANGUL PHIEUPH
  { 0x326D, BIDI_L   },  // CIRCLED HANGUL HIEUH
  { 0x326E, BIDI_L   },  // CIRCLED HANGUL KIYEOK A
  { 0x326F, BIDI_L   },  // CIRCLED HANGUL NIEUN A
  { 0x3270, BIDI_L   },  // CIRCLED HANGUL TIKEUT A
  { 0x3271, BIDI_L   },  // CIRCLED HANGUL RIEUL A
  { 0x3272, BIDI_L   },  // CIRCLED HANGUL MIEUM A
  { 0x3273, BIDI_L   },  // CIRCLED HANGUL PIEUP A
  { 0x3274, BIDI_L   },  // CIRCLED HANGUL SIOS A
  { 0x3275, BIDI_L   },  // CIRCLED HANGUL IEUNG A
  { 0x3276, BIDI_L   },  // CIRCLED HANGUL CIEUC A
  { 0x3277, BIDI_L   },  // CIRCLED HANGUL CHIEUCH A
  { 0x3278, BIDI_L   },  // CIRCLED HANGUL KHIEUKH A
  { 0x3279, BIDI_L   },  // CIRCLED HANGUL THIEUTH A
  { 0x327A, BIDI_L   },  // CIRCLED HANGUL PHIEUPH A
  { 0x327B, BIDI_L   },  // CIRCLED HANGUL HIEUH A
  { 0x327C, BIDI_ON  },  // CIRCLED KOREAN CHARACTER CHAMKO
  { 0x327D, BIDI_ON  },  // CIRCLED KOREAN CHARACTER JUEUI
  { 0x327E, BIDI_ON  },  // CIRCLED HANGUL IEUNG U
  { 0x327F, BIDI_L   },  // KOREAN STANDARD SYMBOL
  { 0x3280, BIDI_L   },  // CIRCLED IDEOGRAPH ONE
  { 0x3281, BIDI_L   },  // CIRCLED IDEOGRAPH TWO
  { 0x3282, BIDI_L   },  // CIRCLED IDEOGRAPH THREE
  { 0x3283, BIDI_L   },  // CIRCLED IDEOGRAPH FOUR
  { 0x3284, BIDI_L   },  // CIRCLED IDEOGRAPH FIVE
  { 0x3285, BIDI_L   },  // CIRCLED IDEOGRAPH SIX
  { 0x3286, BIDI_L   },  // CIRCLED IDEOGRAPH SEVEN
  { 0x3287, BIDI_L   },  // CIRCLED IDEOGRAPH EIGHT
  { 0x3288, BIDI_L   },  // CIRCLED IDEOGRAPH NINE
  { 0x3289, BIDI_L   },  // CIRCLED IDEOGRAPH TEN
  { 0x328A, BIDI_L   },  // CIRCLED IDEOGRAPH MOON
  { 0x328B, BIDI_L   },  // CIRCLED IDEOGRAPH FIRE
  { 0x328C, BIDI_L   },  // CIRCLED IDEOGRAPH WATER
  { 0x328D, BIDI_L   },  // CIRCLED IDEOGRAPH WOOD
  { 0x328E, BIDI_L   },  // CIRCLED IDEOGRAPH METAL
  { 0x328F, BIDI_L   },  // CIRCLED IDEOGRAPH EARTH
  { 0x3290, BIDI_L   },  // CIRCLED IDEOGRAPH SUN
  { 0x3291, BIDI_L   },  // CIRCLED IDEOGRAPH STOCK
  { 0x3292, BIDI_L   },  // CIRCLED IDEOGRAPH HAVE
  { 0x3293, BIDI_L   },  // CIRCLED IDEOGRAPH SOCIETY
  { 0x3294, BIDI_L   },  // CIRCLED IDEOGRAPH NAME
  { 0x3295, BIDI_L   },  // CIRCLED IDEOGRAPH SPECIAL
  { 0x3296, BIDI_L   },  // CIRCLED IDEOGRAPH FINANCIAL
  { 0x3297, BIDI_L   },  // CIRCLED IDEOGRAPH CONGRATULATION
  { 0x3298, BIDI_L   },  // CIRCLED IDEOGRAPH LABOR
  { 0x3299, BIDI_L   },  // CIRCLED IDEOGRAPH SECRET
  { 0x329A, BIDI_L   },  // CIRCLED IDEOGRAPH MALE
  { 0x329B, BIDI_L   },  // CIRCLED IDEOGRAPH FEMALE
  { 0x329C, BIDI_L   },  // CIRCLED IDEOGRAPH SUITABLE
  { 0x329D, BIDI_L   },  // CIRCLED IDEOGRAPH EXCELLENT
  { 0x329E, BIDI_L   },  // CIRCLED IDEOGRAPH PRINT
  { 0x329F, BIDI_L   },  // CIRCLED IDEOGRAPH ATTENTION
  { 0x32A0, BIDI_L   },  // CIRCLED IDEOGRAPH ITEM
  { 0x32A1, BIDI_L   },  // CIRCLED IDEOGRAPH REST
  { 0x32A2, BIDI_L   },  // CIRCLED IDEOGRAPH COPY
  { 0x32A3, BIDI_L   },  // CIRCLED IDEOGRAPH CORRECT
  { 0x32A4, BIDI_L   },  // CIRCLED IDEOGRAPH HIGH
  { 0x32A5, BIDI_L   },  // CIRCLED IDEOGRAPH CENTRE
  { 0x32A6, BIDI_L   },  // CIRCLED IDEOGRAPH LOW
  { 0x32A7, BIDI_L   },  // CIRCLED IDEOGRAPH LEFT
  { 0x32A8, BIDI_L   },  // CIRCLED IDEOGRAPH RIGHT
  { 0x32A9, BIDI_L   },  // CIRCLED IDEOGRAPH MEDICINE
  { 0x32AA, BIDI_L   },  // CIRCLED IDEOGRAPH RELIGION
  { 0x32AB, BIDI_L   },  // CIRCLED IDEOGRAPH STUDY
  { 0x32AC, BIDI_L   },  // CIRCLED IDEOGRAPH SUPERVISE
  { 0x32AD, BIDI_L   },  // CIRCLED IDEOGRAPH ENTERPRISE
  { 0x32AE, BIDI_L   },  // CIRCLED IDEOGRAPH RESOURCE
  { 0x32AF, BIDI_L   },  // CIRCLED IDEOGRAPH ALLIANCE
  { 0x32B0, BIDI_L   },  // CIRCLED IDEOGRAPH NIGHT
  { 0x32B1, BIDI_ON  },  // CIRCLED NUMBER THIRTY SIX
  { 0x32B2, BIDI_ON  },  // CIRCLED NUMBER THIRTY SEVEN
  { 0x32B3, BIDI_ON  },  // CIRCLED NUMBER THIRTY EIGHT
  { 0x32B4, BIDI_ON  },  // CIRCLED NUMBER THIRTY NINE
  { 0x32B5, BIDI_ON  },  // CIRCLED NUMBER FORTY
  { 0x32B6, BIDI_ON  },  // CIRCLED NUMBER FORTY ONE
  { 0x32B7, BIDI_ON  },  // CIRCLED NUMBER FORTY TWO
  { 0x32B8, BIDI_ON  },  // CIRCLED NUMBER FORTY THREE
  { 0x32B9, BIDI_ON  },  // CIRCLED NUMBER FORTY FOUR
  { 0x32BA, BIDI_ON  },  // CIRCLED NUMBER FORTY FIVE
  { 0x32BB, BIDI_ON  },  // CIRCLED NUMBER FORTY SIX
  { 0x32BC, BIDI_ON  },  // CIRCLED NUMBER FORTY SEVEN
  { 0x32BD, BIDI_ON  },  // CIRCLED NUMBER FORTY EIGHT
  { 0x32BE, BIDI_ON  },  // CIRCLED NUMBER FORTY NINE
  { 0x32BF, BIDI_ON  },  // CIRCLED NUMBER FIFTY
  { 0x32C0, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
  { 0x32C1, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
  { 0x32C2, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
  { 0x32C3, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
  { 0x32C4, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
  { 0x32C5, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
  { 0x32C6, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
  { 0x32C7, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
  { 0x32C8, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
  { 0x32C9, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
  { 0x32CA, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
  { 0x32CB, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
  { 0x32CC, BIDI_ON  },  // SQUARE HG
  { 0x32CD, BIDI_ON  },  // SQUARE ERG
  { 0x32CE, BIDI_ON  },  // SQUARE EV
  { 0x32CF, BIDI_ON  },  // LIMITED LIABILITY SIGN
  { 0x32D0, BIDI_L   },  // CIRCLED KATAKANA A
  { 0x32D1, BIDI_L   },  // CIRCLED KATAKANA I
  { 0x32D2, BIDI_L   },  // CIRCLED KATAKANA U
  { 0x32D3, BIDI_L   },  // CIRCLED KATAKANA E
  { 0x32D4, BIDI_L   },  // CIRCLED KATAKANA O
  { 0x32D5, BIDI_L   },  // CIRCLED KATAKANA KA
  { 0x32D6, BIDI_L   },  // CIRCLED KATAKANA KI
  { 0x32D7, BIDI_L   },  // CIRCLED KATAKANA KU
  { 0x32D8, BIDI_L   },  // CIRCLED KATAKANA KE
  { 0x32D9, BIDI_L   },  // CIRCLED KATAKANA KO
  { 0x32DA, BIDI_L   },  // CIRCLED KATAKANA SA
  { 0x32DB, BIDI_L   },  // CIRCLED KATAKANA SI
  { 0x32DC, BIDI_L   },  // CIRCLED KATAKANA SU
  { 0x32DD, BIDI_L   },  // CIRCLED KATAKANA SE
  { 0x32DE, BIDI_L   },  // CIRCLED KATAKANA SO
  { 0x32DF, BIDI_L   },  // CIRCLED KATAKANA TA
  { 0x32E0, BIDI_L   },  // CIRCLED KATAKANA TI
  { 0x32E1, BIDI_L   },  // CIRCLED KATAKANA TU
  { 0x32E2, BIDI_L   },  // CIRCLED KATAKANA TE
  { 0x32E3, BIDI_L   },  // CIRCLED KATAKANA TO
  { 0x32E4, BIDI_L   },  // CIRCLED KATAKANA NA
  { 0x32E5, BIDI_L   },  // CIRCLED KATAKANA NI
  { 0x32E6, BIDI_L   },  // CIRCLED KATAKANA NU
  { 0x32E7, BIDI_L   },  // CIRCLED KATAKANA NE
  { 0x32E8, BIDI_L   },  // CIRCLED KATAKANA NO
  { 0x32E9, BIDI_L   },  // CIRCLED KATAKANA HA
  { 0x32EA, BIDI_L   },  // CIRCLED KATAKANA HI
  { 0x32EB, BIDI_L   },  // CIRCLED KATAKANA HU
  { 0x32EC, BIDI_L   },  // CIRCLED KATAKANA HE
  { 0x32ED, BIDI_L   },  // CIRCLED KATAKANA HO
  { 0x32EE, BIDI_L   },  // CIRCLED KATAKANA MA
  { 0x32EF, BIDI_L   },  // CIRCLED KATAKANA MI
  { 0x32F0, BIDI_L   },  // CIRCLED KATAKANA MU
  { 0x32F1, BIDI_L   },  // CIRCLED KATAKANA ME
  { 0x32F2, BIDI_L   },  // CIRCLED KATAKANA MO
  { 0x32F3, BIDI_L   },  // CIRCLED KATAKANA YA
  { 0x32F4, BIDI_L   },  // CIRCLED KATAKANA YU
  { 0x32F5, BIDI_L   },  // CIRCLED KATAKANA YO
  { 0x32F6, BIDI_L   },  // CIRCLED KATAKANA RA
  { 0x32F7, BIDI_L   },  // CIRCLED KATAKANA RI
  { 0x32F8, BIDI_L   },  // CIRCLED KATAKANA RU
  { 0x32F9, BIDI_L   },  // CIRCLED KATAKANA RE
  { 0x32FA, BIDI_L   },  // CIRCLED KATAKANA RO
  { 0x32FB, BIDI_L   },  // CIRCLED KATAKANA WA
  { 0x32FC, BIDI_L   },  // CIRCLED KATAKANA WI
  { 0x32FD, BIDI_L   },  // CIRCLED KATAKANA WE
  { 0x32FE, BIDI_L   },  // CIRCLED KATAKANA WO
  { 0x3300, BIDI_L   },  // SQUARE APAATO
  { 0x3301, BIDI_L   },  // SQUARE ARUHUA
  { 0x3302, BIDI_L   },  // SQUARE ANPEA
  { 0x3303, BIDI_L   },  // SQUARE AARU
  { 0x3304, BIDI_L   },  // SQUARE ININGU
  { 0x3305, BIDI_L   },  // SQUARE INTI
  { 0x3306, BIDI_L   },  // SQUARE UON
  { 0x3307, BIDI_L   },  // SQUARE ESUKUUDO
  { 0x3308, BIDI_L   },  // SQUARE EEKAA
  { 0x3309, BIDI_L   },  // SQUARE ONSU
  { 0x330A, BIDI_L   },  // SQUARE OOMU
  { 0x330B, BIDI_L   },  // SQUARE KAIRI
  { 0x330C, BIDI_L   },  // SQUARE KARATTO
  { 0x330D, BIDI_L   },  // SQUARE KARORII
  { 0x330E, BIDI_L   },  // SQUARE GARON
  { 0x330F, BIDI_L   },  // SQUARE GANMA
  { 0x3310, BIDI_L   },  // SQUARE GIGA
  { 0x3311, BIDI_L   },  // SQUARE GINII
  { 0x3312, BIDI_L   },  // SQUARE KYURII
  { 0x3313, BIDI_L   },  // SQUARE GIRUDAA
  { 0x3314, BIDI_L   },  // SQUARE KIRO
  { 0x3315, BIDI_L   },  // SQUARE KIROGURAMU
  { 0x3316, BIDI_L   },  // SQUARE KIROMEETORU
  { 0x3317, BIDI_L   },  // SQUARE KIROWATTO
  { 0x3318, BIDI_L   },  // SQUARE GURAMU
  { 0x3319, BIDI_L   },  // SQUARE GURAMUTON
  { 0x331A, BIDI_L   },  // SQUARE KURUZEIRO
  { 0x331B, BIDI_L   },  // SQUARE KUROONE
  { 0x331C, BIDI_L   },  // SQUARE KEESU
  { 0x331D, BIDI_L   },  // SQUARE KORUNA
  { 0x331E, BIDI_L   },  // SQUARE KOOPO
  { 0x331F, BIDI_L   },  // SQUARE SAIKURU
  { 0x3320, BIDI_L   },  // SQUARE SANTIIMU
  { 0x3321, BIDI_L   },  // SQUARE SIRINGU
  { 0x3322, BIDI_L   },  // SQUARE SENTI
  { 0x3323, BIDI_L   },  // SQUARE SENTO
  { 0x3324, BIDI_L   },  // SQUARE DAASU
  { 0x3325, BIDI_L   },  // SQUARE DESI
  { 0x3326, BIDI_L   },  // SQUARE DORU
  { 0x3327, BIDI_L   },  // SQUARE TON
  { 0x3328, BIDI_L   },  // SQUARE NANO
  { 0x3329, BIDI_L   },  // SQUARE NOTTO
  { 0x332A, BIDI_L   },  // SQUARE HAITU
  { 0x332B, BIDI_L   },  // SQUARE PAASENTO
  { 0x332C, BIDI_L   },  // SQUARE PAATU
  { 0x332D, BIDI_L   },  // SQUARE BAARERU
  { 0x332E, BIDI_L   },  // SQUARE PIASUTORU
  { 0x332F, BIDI_L   },  // SQUARE PIKURU
  { 0x3330, BIDI_L   },  // SQUARE PIKO
  { 0x3331, BIDI_L   },  // SQUARE BIRU
  { 0x3332, BIDI_L   },  // SQUARE HUARADDO
  { 0x3333, BIDI_L   },  // SQUARE HUIITO
  { 0x3334, BIDI_L   },  // SQUARE BUSSYERU
  { 0x3335, BIDI_L   },  // SQUARE HURAN
  { 0x3336, BIDI_L   },  // SQUARE HEKUTAARU
  { 0x3337, BIDI_L   },  // SQUARE PESO
  { 0x3338, BIDI_L   },  // SQUARE PENIHI
  { 0x3339, BIDI_L   },  // SQUARE HERUTU
  { 0x333A, BIDI_L   },  // SQUARE PENSU
  { 0x333B, BIDI_L   },  // SQUARE PEEZI
  { 0x333C, BIDI_L   },  // SQUARE BEETA
  { 0x333D, BIDI_L   },  // SQUARE POINTO
  { 0x333E, BIDI_L   },  // SQUARE BORUTO
  { 0x333F, BIDI_L   },  // SQUARE HON
  { 0x3340, BIDI_L   },  // SQUARE PONDO
  { 0x3341, BIDI_L   },  // SQUARE HOORU
  { 0x3342, BIDI_L   },  // SQUARE HOON
  { 0x3343, BIDI_L   },  // SQUARE MAIKURO
  { 0x3344, BIDI_L   },  // SQUARE MAIRU
  { 0x3345, BIDI_L   },  // SQUARE MAHHA
  { 0x3346, BIDI_L   },  // SQUARE MARUKU
  { 0x3347, BIDI_L   },  // SQUARE MANSYON
  { 0x3348, BIDI_L   },  // SQUARE MIKURON
  { 0x3349, BIDI_L   },  // SQUARE MIRI
  { 0x334A, BIDI_L   },  // SQUARE MIRIBAARU
  { 0x334B, BIDI_L   },  // SQUARE MEGA
  { 0x334C, BIDI_L   },  // SQUARE MEGATON
  { 0x334D, BIDI_L   },  // SQUARE MEETORU
  { 0x334E, BIDI_L   },  // SQUARE YAADO
  { 0x334F, BIDI_L   },  // SQUARE YAARU
  { 0x3350, BIDI_L   },  // SQUARE YUAN
  { 0x3351, BIDI_L   },  // SQUARE RITTORU
  { 0x3352, BIDI_L   },  // SQUARE RIRA
  { 0x3353, BIDI_L   },  // SQUARE RUPII
  { 0x3354, BIDI_L   },  // SQUARE RUUBURU
  { 0x3355, BIDI_L   },  // SQUARE REMU
  { 0x3356, BIDI_L   },  // SQUARE RENTOGEN
  { 0x3357, BIDI_L   },  // SQUARE WATTO
  { 0x3358, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
  { 0x3359, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
  { 0x335A, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
  { 0x335B, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
  { 0x335C, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
  { 0x335D, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
  { 0x335E, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
  { 0x335F, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
  { 0x3360, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
  { 0x3361, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
  { 0x3362, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
  { 0x3363, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
  { 0x3364, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
  { 0x3365, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
  { 0x3366, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
  { 0x3367, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
  { 0x3368, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
  { 0x3369, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
  { 0x336A, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
  { 0x336B, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
  { 0x336C, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
  { 0x336D, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
  { 0x336E, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
  { 0x336F, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
  { 0x3370, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
  { 0x3371, BIDI_L   },  // SQUARE HPA
  { 0x3372, BIDI_L   },  // SQUARE DA
  { 0x3373, BIDI_L   },  // SQUARE AU
  { 0x3374, BIDI_L   },  // SQUARE BAR
  { 0x3375, BIDI_L   },  // SQUARE OV
  { 0x3376, BIDI_L   },  // SQUARE PC
  { 0x3377, BIDI_ON  },  // SQUARE DM
  { 0x3378, BIDI_ON  },  // SQUARE DM SQUARED
  { 0x3379, BIDI_ON  },  // SQUARE DM CUBED
  { 0x337A, BIDI_ON  },  // SQUARE IU
  { 0x337B, BIDI_L   },  // SQUARE ERA NAME HEISEI
  { 0x337C, BIDI_L   },  // SQUARE ERA NAME SYOUWA
  { 0x337D, BIDI_L   },  // SQUARE ERA NAME TAISYOU
  { 0x337E, BIDI_L   },  // SQUARE ERA NAME MEIZI
  { 0x337F, BIDI_L   },  // SQUARE CORPORATION
  { 0x3380, BIDI_L   },  // SQUARE PA AMPS
  { 0x3381, BIDI_L   },  // SQUARE NA
  { 0x3382, BIDI_L   },  // SQUARE MU A
  { 0x3383, BIDI_L   },  // SQUARE MA
  { 0x3384, BIDI_L   },  // SQUARE KA
  { 0x3385, BIDI_L   },  // SQUARE KB
  { 0x3386, BIDI_L   },  // SQUARE MB
  { 0x3387, BIDI_L   },  // SQUARE GB
  { 0x3388, BIDI_L   },  // SQUARE CAL
  { 0x3389, BIDI_L   },  // SQUARE KCAL
  { 0x338A, BIDI_L   },  // SQUARE PF
  { 0x338B, BIDI_L   },  // SQUARE NF
  { 0x338C, BIDI_L   },  // SQUARE MU F
  { 0x338D, BIDI_L   },  // SQUARE MU G
  { 0x338E, BIDI_L   },  // SQUARE MG
  { 0x338F, BIDI_L   },  // SQUARE KG
  { 0x3390, BIDI_L   },  // SQUARE HZ
  { 0x3391, BIDI_L   },  // SQUARE KHZ
  { 0x3392, BIDI_L   },  // SQUARE MHZ
  { 0x3393, BIDI_L   },  // SQUARE GHZ
  { 0x3394, BIDI_L   },  // SQUARE THZ
  { 0x3395, BIDI_L   },  // SQUARE MU L
  { 0x3396, BIDI_L   },  // SQUARE ML
  { 0x3397, BIDI_L   },  // SQUARE DL
  { 0x3398, BIDI_L   },  // SQUARE KL
  { 0x3399, BIDI_L   },  // SQUARE FM
  { 0x339A, BIDI_L   },  // SQUARE NM
  { 0x339B, BIDI_L   },  // SQUARE MU M
  { 0x339C, BIDI_L   },  // SQUARE MM
  { 0x339D, BIDI_L   },  // SQUARE CM
  { 0x339E, BIDI_L   },  // SQUARE KM
  { 0x339F, BIDI_L   },  // SQUARE MM SQUARED
  { 0x33A0, BIDI_L   },  // SQUARE CM SQUARED
  { 0x33A1, BIDI_L   },  // SQUARE M SQUARED
  { 0x33A2, BIDI_L   },  // SQUARE KM SQUARED
  { 0x33A3, BIDI_L   },  // SQUARE MM CUBED
  { 0x33A4, BIDI_L   },  // SQUARE CM CUBED
  { 0x33A5, BIDI_L   },  // SQUARE M CUBED
  { 0x33A6, BIDI_L   },  // SQUARE KM CUBED
  { 0x33A7, BIDI_L   },  // SQUARE M OVER S
  { 0x33A8, BIDI_L   },  // SQUARE M OVER S SQUARED
  { 0x33A9, BIDI_L   },  // SQUARE PA
  { 0x33AA, BIDI_L   },  // SQUARE KPA
  { 0x33AB, BIDI_L   },  // SQUARE MPA
  { 0x33AC, BIDI_L   },  // SQUARE GPA
  { 0x33AD, BIDI_L   },  // SQUARE RAD
  { 0x33AE, BIDI_L   },  // SQUARE RAD OVER S
  { 0x33AF, BIDI_L   },  // SQUARE RAD OVER S SQUARED
  { 0x33B0, BIDI_L   },  // SQUARE PS
  { 0x33B1, BIDI_L   },  // SQUARE NS
  { 0x33B2, BIDI_L   },  // SQUARE MU S
  { 0x33B3, BIDI_L   },  // SQUARE MS
  { 0x33B4, BIDI_L   },  // SQUARE PV
  { 0x33B5, BIDI_L   },  // SQUARE NV
  { 0x33B6, BIDI_L   },  // SQUARE MU V
  { 0x33B7, BIDI_L   },  // SQUARE MV
  { 0x33B8, BIDI_L   },  // SQUARE KV
  { 0x33B9, BIDI_L   },  // SQUARE MV MEGA
  { 0x33BA, BIDI_L   },  // SQUARE PW
  { 0x33BB, BIDI_L   },  // SQUARE NW
  { 0x33BC, BIDI_L   },  // SQUARE MU W
  { 0x33BD, BIDI_L   },  // SQUARE MW
  { 0x33BE, BIDI_L   },  // SQUARE KW
  { 0x33BF, BIDI_L   },  // SQUARE MW MEGA
  { 0x33C0, BIDI_L   },  // SQUARE K OHM
  { 0x33C1, BIDI_L   },  // SQUARE M OHM
  { 0x33C2, BIDI_L   },  // SQUARE AM
  { 0x33C3, BIDI_L   },  // SQUARE BQ
  { 0x33C4, BIDI_L   },  // SQUARE CC
  { 0x33C5, BIDI_L   },  // SQUARE CD
  { 0x33C6, BIDI_L   },  // SQUARE C OVER KG
  { 0x33C7, BIDI_L   },  // SQUARE CO
  { 0x33C8, BIDI_L   },  // SQUARE DB
  { 0x33C9, BIDI_L   },  // SQUARE GY
  { 0x33CA, BIDI_L   },  // SQUARE HA
  { 0x33CB, BIDI_L   },  // SQUARE HP
  { 0x33CC, BIDI_L   },  // SQUARE IN
  { 0x33CD, BIDI_L   },  // SQUARE KK
  { 0x33CE, BIDI_L   },  // SQUARE KM CAPITAL
  { 0x33CF, BIDI_L   },  // SQUARE KT
  { 0x33D0, BIDI_L   },  // SQUARE LM
  { 0x33D1, BIDI_L   },  // SQUARE LN
  { 0x33D2, BIDI_L   },  // SQUARE LOG
  { 0x33D3, BIDI_L   },  // SQUARE LX
  { 0x33D4, BIDI_L   },  // SQUARE MB SMALL
  { 0x33D5, BIDI_L   },  // SQUARE MIL
  { 0x33D6, BIDI_L   },  // SQUARE MOL
  { 0x33D7, BIDI_L   },  // SQUARE PH
  { 0x33D8, BIDI_L   },  // SQUARE PM
  { 0x33D9, BIDI_L   },  // SQUARE PPM
  { 0x33DA, BIDI_L   },  // SQUARE PR
  { 0x33DB, BIDI_L   },  // SQUARE SR
  { 0x33DC, BIDI_L   },  // SQUARE SV
  { 0x33DD, BIDI_L   },  // SQUARE WB
  { 0x33DE, BIDI_ON  },  // SQUARE V OVER M
  { 0x33DF, BIDI_ON  },  // SQUARE A OVER M
  { 0x33E0, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
  { 0x33E1, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
  { 0x33E2, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
  { 0x33E3, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
  { 0x33E4, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
  { 0x33E5, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
  { 0x33E6, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
  { 0x33E7, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
  { 0x33E8, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
  { 0x33E9, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
  { 0x33EA, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
  { 0x33EB, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
  { 0x33EC, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
  { 0x33ED, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
  { 0x33EE, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
  { 0x33EF, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
  { 0x33F0, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
  { 0x33F1, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
  { 0x33F2, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
  { 0x33F3, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
  { 0x33F4, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
  { 0x33F5, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
  { 0x33F6, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
  { 0x33F7, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
  { 0x33F8, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
  { 0x33F9, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
  { 0x33FA, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
  { 0x33FB, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
  { 0x33FC, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
  { 0x33FD, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
  { 0x33FE, BIDI_L   },  // IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
  { 0x33FF, BIDI_ON  },  // SQUARE GAL
  //{ 0x3400, BIDI_L   },  // <CJK Ideograph Extension A, First>
  //{ 0x4DB5, BIDI_L   },  // <CJK Ideograph Extension A, Last>

#endif
#if (GUI_BIDI_SUPPORT_RANGE_4 == 1)

  { 0x4DC0, BIDI_ON  },  // HEXAGRAM FOR THE CREATIVE HEAVEN
  { 0x4DC1, BIDI_ON  },  // HEXAGRAM FOR THE RECEPTIVE EARTH
  { 0x4DC2, BIDI_ON  },  // HEXAGRAM FOR DIFFICULTY AT THE BEGINNING
  { 0x4DC3, BIDI_ON  },  // HEXAGRAM FOR YOUTHFUL FOLLY
  { 0x4DC4, BIDI_ON  },  // HEXAGRAM FOR WAITING
  { 0x4DC5, BIDI_ON  },  // HEXAGRAM FOR CONFLICT
  { 0x4DC6, BIDI_ON  },  // HEXAGRAM FOR THE ARMY
  { 0x4DC7, BIDI_ON  },  // HEXAGRAM FOR HOLDING TOGETHER
  { 0x4DC8, BIDI_ON  },  // HEXAGRAM FOR SMALL TAMING
  { 0x4DC9, BIDI_ON  },  // HEXAGRAM FOR TREADING
  { 0x4DCA, BIDI_ON  },  // HEXAGRAM FOR PEACE
  { 0x4DCB, BIDI_ON  },  // HEXAGRAM FOR STANDSTILL
  { 0x4DCC, BIDI_ON  },  // HEXAGRAM FOR FELLOWSHIP
  { 0x4DCD, BIDI_ON  },  // HEXAGRAM FOR GREAT POSSESSION
  { 0x4DCE, BIDI_ON  },  // HEXAGRAM FOR MODESTY
  { 0x4DCF, BIDI_ON  },  // HEXAGRAM FOR ENTHUSIASM
  { 0x4DD0, BIDI_ON  },  // HEXAGRAM FOR FOLLOWING
  { 0x4DD1, BIDI_ON  },  // HEXAGRAM FOR WORK ON THE DECAYED
  { 0x4DD2, BIDI_ON  },  // HEXAGRAM FOR APPROACH
  { 0x4DD3, BIDI_ON  },  // HEXAGRAM FOR CONTEMPLATION
  { 0x4DD4, BIDI_ON  },  // HEXAGRAM FOR BITING THROUGH
  { 0x4DD5, BIDI_ON  },  // HEXAGRAM FOR GRACE
  { 0x4DD6, BIDI_ON  },  // HEXAGRAM FOR SPLITTING APART
  { 0x4DD7, BIDI_ON  },  // HEXAGRAM FOR RETURN
  { 0x4DD8, BIDI_ON  },  // HEXAGRAM FOR INNOCENCE
  { 0x4DD9, BIDI_ON  },  // HEXAGRAM FOR GREAT TAMING
  { 0x4DDA, BIDI_ON  },  // HEXAGRAM FOR MOUTH CORNERS
  { 0x4DDB, BIDI_ON  },  // HEXAGRAM FOR GREAT PREPONDERANCE
  { 0x4DDC, BIDI_ON  },  // HEXAGRAM FOR THE ABYSMAL WATER
  { 0x4DDD, BIDI_ON  },  // HEXAGRAM FOR THE CLINGING FIRE
  { 0x4DDE, BIDI_ON  },  // HEXAGRAM FOR INFLUENCE
  { 0x4DDF, BIDI_ON  },  // HEXAGRAM FOR DURATION
  { 0x4DE0, BIDI_ON  },  // HEXAGRAM FOR RETREAT
  { 0x4DE1, BIDI_ON  },  // HEXAGRAM FOR GREAT POWER
  { 0x4DE2, BIDI_ON  },  // HEXAGRAM FOR PROGRESS
  { 0x4DE3, BIDI_ON  },  // HEXAGRAM FOR DARKENING OF THE LIGHT
  { 0x4DE4, BIDI_ON  },  // HEXAGRAM FOR THE FAMILY
  { 0x4DE5, BIDI_ON  },  // HEXAGRAM FOR OPPOSITION
  { 0x4DE6, BIDI_ON  },  // HEXAGRAM FOR OBSTRUCTION
  { 0x4DE7, BIDI_ON  },  // HEXAGRAM FOR DELIVERANCE
  { 0x4DE8, BIDI_ON  },  // HEXAGRAM FOR DECREASE
  { 0x4DE9, BIDI_ON  },  // HEXAGRAM FOR INCREASE
  { 0x4DEA, BIDI_ON  },  // HEXAGRAM FOR BREAKTHROUGH
  { 0x4DEB, BIDI_ON  },  // HEXAGRAM FOR COMING TO MEET
  { 0x4DEC, BIDI_ON  },  // HEXAGRAM FOR GATHERING TOGETHER
  { 0x4DED, BIDI_ON  },  // HEXAGRAM FOR PUSHING UPWARD
  { 0x4DEE, BIDI_ON  },  // HEXAGRAM FOR OPPRESSION
  { 0x4DEF, BIDI_ON  },  // HEXAGRAM FOR THE WELL
  { 0x4DF0, BIDI_ON  },  // HEXAGRAM FOR REVOLUTION
  { 0x4DF1, BIDI_ON  },  // HEXAGRAM FOR THE CAULDRON
  { 0x4DF2, BIDI_ON  },  // HEXAGRAM FOR THE AROUSING THUNDER
  { 0x4DF3, BIDI_ON  },  // HEXAGRAM FOR THE KEEPING STILL MOUNTAIN
  { 0x4DF4, BIDI_ON  },  // HEXAGRAM FOR DEVELOPMENT
  { 0x4DF5, BIDI_ON  },  // HEXAGRAM FOR THE MARRYING MAIDEN
  { 0x4DF6, BIDI_ON  },  // HEXAGRAM FOR ABUNDANCE
  { 0x4DF7, BIDI_ON  },  // HEXAGRAM FOR THE WANDERER
  { 0x4DF8, BIDI_ON  },  // HEXAGRAM FOR THE GENTLE WIND
  { 0x4DF9, BIDI_ON  },  // HEXAGRAM FOR THE JOYOUS LAKE
  { 0x4DFA, BIDI_ON  },  // HEXAGRAM FOR DISPERSION
  { 0x4DFB, BIDI_ON  },  // HEXAGRAM FOR LIMITATION
  { 0x4DFC, BIDI_ON  },  // HEXAGRAM FOR INNER TRUTH
  { 0x4DFD, BIDI_ON  },  // HEXAGRAM FOR SMALL PREPONDERANCE
  { 0x4DFE, BIDI_ON  },  // HEXAGRAM FOR AFTER COMPLETION
  { 0x4DFF, BIDI_ON  },  // HEXAGRAM FOR BEFORE COMPLETION
  //{ 0x4E00, BIDI_L   },  // <CJK Ideograph, First>
  //{ 0x9FD5, BIDI_L   },  // <CJK Ideograph, Last>

#endif
#if (GUI_BIDI_SUPPORT_RANGE_A == 1)

  { 0xA000, BIDI_L   },  // YI SYLLABLE IT
  { 0xA001, BIDI_L   },  // YI SYLLABLE IX
  { 0xA002, BIDI_L   },  // YI SYLLABLE I
  { 0xA003, BIDI_L   },  // YI SYLLABLE IP
  { 0xA004, BIDI_L   },  // YI SYLLABLE IET
  { 0xA005, BIDI_L   },  // YI SYLLABLE IEX
  { 0xA006, BIDI_L   },  // YI SYLLABLE IE
  { 0xA007, BIDI_L   },  // YI SYLLABLE IEP
  { 0xA008, BIDI_L   },  // YI SYLLABLE AT
  { 0xA009, BIDI_L   },  // YI SYLLABLE AX
  { 0xA00A, BIDI_L   },  // YI SYLLABLE A
  { 0xA00B, BIDI_L   },  // YI SYLLABLE AP
  { 0xA00C, BIDI_L   },  // YI SYLLABLE UOX
  { 0xA00D, BIDI_L   },  // YI SYLLABLE UO
  { 0xA00E, BIDI_L   },  // YI SYLLABLE UOP
  { 0xA00F, BIDI_L   },  // YI SYLLABLE OT
  { 0xA010, BIDI_L   },  // YI SYLLABLE OX
  { 0xA011, BIDI_L   },  // YI SYLLABLE O
  { 0xA012, BIDI_L   },  // YI SYLLABLE OP
  { 0xA013, BIDI_L   },  // YI SYLLABLE EX
  { 0xA014, BIDI_L   },  // YI SYLLABLE E
  { 0xA015, BIDI_L   },  // YI SYLLABLE WU
  { 0xA016, BIDI_L   },  // YI SYLLABLE BIT
  { 0xA017, BIDI_L   },  // YI SYLLABLE BIX
  { 0xA018, BIDI_L   },  // YI SYLLABLE BI
  { 0xA019, BIDI_L   },  // YI SYLLABLE BIP
  { 0xA01A, BIDI_L   },  // YI SYLLABLE BIET
  { 0xA01B, BIDI_L   },  // YI SYLLABLE BIEX
  { 0xA01C, BIDI_L   },  // YI SYLLABLE BIE
  { 0xA01D, BIDI_L   },  // YI SYLLABLE BIEP
  { 0xA01E, BIDI_L   },  // YI SYLLABLE BAT
  { 0xA01F, BIDI_L   },  // YI SYLLABLE BAX
  { 0xA020, BIDI_L   },  // YI SYLLABLE BA
  { 0xA021, BIDI_L   },  // YI SYLLABLE BAP
  { 0xA022, BIDI_L   },  // YI SYLLABLE BUOX
  { 0xA023, BIDI_L   },  // YI SYLLABLE BUO
  { 0xA024, BIDI_L   },  // YI SYLLABLE BUOP
  { 0xA025, BIDI_L   },  // YI SYLLABLE BOT
  { 0xA026, BIDI_L   },  // YI SYLLABLE BOX
  { 0xA027, BIDI_L   },  // YI SYLLABLE BO
  { 0xA028, BIDI_L   },  // YI SYLLABLE BOP
  { 0xA029, BIDI_L   },  // YI SYLLABLE BEX
  { 0xA02A, BIDI_L   },  // YI SYLLABLE BE
  { 0xA02B, BIDI_L   },  // YI SYLLABLE BEP
  { 0xA02C, BIDI_L   },  // YI SYLLABLE BUT
  { 0xA02D, BIDI_L   },  // YI SYLLABLE BUX
  { 0xA02E, BIDI_L   },  // YI SYLLABLE BU
  { 0xA02F, BIDI_L   },  // YI SYLLABLE BUP
  { 0xA030, BIDI_L   },  // YI SYLLABLE BURX
  { 0xA031, BIDI_L   },  // YI SYLLABLE BUR
  { 0xA032, BIDI_L   },  // YI SYLLABLE BYT
  { 0xA033, BIDI_L   },  // YI SYLLABLE BYX
  { 0xA034, BIDI_L   },  // YI SYLLABLE BY
  { 0xA035, BIDI_L   },  // YI SYLLABLE BYP
  { 0xA036, BIDI_L   },  // YI SYLLABLE BYRX
  { 0xA037, BIDI_L   },  // YI SYLLABLE BYR
  { 0xA038, BIDI_L   },  // YI SYLLABLE PIT
  { 0xA039, BIDI_L   },  // YI SYLLABLE PIX
  { 0xA03A, BIDI_L   },  // YI SYLLABLE PI
  { 0xA03B, BIDI_L   },  // YI SYLLABLE PIP
  { 0xA03C, BIDI_L   },  // YI SYLLABLE PIEX
  { 0xA03D, BIDI_L   },  // YI SYLLABLE PIE
  { 0xA03E, BIDI_L   },  // YI SYLLABLE PIEP
  { 0xA03F, BIDI_L   },  // YI SYLLABLE PAT
  { 0xA040, BIDI_L   },  // YI SYLLABLE PAX
  { 0xA041, BIDI_L   },  // YI SYLLABLE PA
  { 0xA042, BIDI_L   },  // YI SYLLABLE PAP
  { 0xA043, BIDI_L   },  // YI SYLLABLE PUOX
  { 0xA044, BIDI_L   },  // YI SYLLABLE PUO
  { 0xA045, BIDI_L   },  // YI SYLLABLE PUOP
  { 0xA046, BIDI_L   },  // YI SYLLABLE POT
  { 0xA047, BIDI_L   },  // YI SYLLABLE POX
  { 0xA048, BIDI_L   },  // YI SYLLABLE PO
  { 0xA049, BIDI_L   },  // YI SYLLABLE POP
  { 0xA04A, BIDI_L   },  // YI SYLLABLE PUT
  { 0xA04B, BIDI_L   },  // YI SYLLABLE PUX
  { 0xA04C, BIDI_L   },  // YI SYLLABLE PU
  { 0xA04D, BIDI_L   },  // YI SYLLABLE PUP
  { 0xA04E, BIDI_L   },  // YI SYLLABLE PURX
  { 0xA04F, BIDI_L   },  // YI SYLLABLE PUR
  { 0xA050, BIDI_L   },  // YI SYLLABLE PYT
  { 0xA051, BIDI_L   },  // YI SYLLABLE PYX
  { 0xA052, BIDI_L   },  // YI SYLLABLE PY
  { 0xA053, BIDI_L   },  // YI SYLLABLE PYP
  { 0xA054, BIDI_L   },  // YI SYLLABLE PYRX
  { 0xA055, BIDI_L   },  // YI SYLLABLE PYR
  { 0xA056, BIDI_L   },  // YI SYLLABLE BBIT
  { 0xA057, BIDI_L   },  // YI SYLLABLE BBIX
  { 0xA058, BIDI_L   },  // YI SYLLABLE BBI
  { 0xA059, BIDI_L   },  // YI SYLLABLE BBIP
  { 0xA05A, BIDI_L   },  // YI SYLLABLE BBIET
  { 0xA05B, BIDI_L   },  // YI SYLLABLE BBIEX
  { 0xA05C, BIDI_L   },  // YI SYLLABLE BBIE
  { 0xA05D, BIDI_L   },  // YI SYLLABLE BBIEP
  { 0xA05E, BIDI_L   },  // YI SYLLABLE BBAT
  { 0xA05F, BIDI_L   },  // YI SYLLABLE BBAX
  { 0xA060, BIDI_L   },  // YI SYLLABLE BBA
  { 0xA061, BIDI_L   },  // YI SYLLABLE BBAP
  { 0xA062, BIDI_L   },  // YI SYLLABLE BBUOX
  { 0xA063, BIDI_L   },  // YI SYLLABLE BBUO
  { 0xA064, BIDI_L   },  // YI SYLLABLE BBUOP
  { 0xA065, BIDI_L   },  // YI SYLLABLE BBOT
  { 0xA066, BIDI_L   },  // YI SYLLABLE BBOX
  { 0xA067, BIDI_L   },  // YI SYLLABLE BBO
  { 0xA068, BIDI_L   },  // YI SYLLABLE BBOP
  { 0xA069, BIDI_L   },  // YI SYLLABLE BBEX
  { 0xA06A, BIDI_L   },  // YI SYLLABLE BBE
  { 0xA06B, BIDI_L   },  // YI SYLLABLE BBEP
  { 0xA06C, BIDI_L   },  // YI SYLLABLE BBUT
  { 0xA06D, BIDI_L   },  // YI SYLLABLE BBUX
  { 0xA06E, BIDI_L   },  // YI SYLLABLE BBU
  { 0xA06F, BIDI_L   },  // YI SYLLABLE BBUP
  { 0xA070, BIDI_L   },  // YI SYLLABLE BBURX
  { 0xA071, BIDI_L   },  // YI SYLLABLE BBUR
  { 0xA072, BIDI_L   },  // YI SYLLABLE BBYT
  { 0xA073, BIDI_L   },  // YI SYLLABLE BBYX
  { 0xA074, BIDI_L   },  // YI SYLLABLE BBY
  { 0xA075, BIDI_L   },  // YI SYLLABLE BBYP
  { 0xA076, BIDI_L   },  // YI SYLLABLE NBIT
  { 0xA077, BIDI_L   },  // YI SYLLABLE NBIX
  { 0xA078, BIDI_L   },  // YI SYLLABLE NBI
  { 0xA079, BIDI_L   },  // YI SYLLABLE NBIP
  { 0xA07A, BIDI_L   },  // YI SYLLABLE NBIEX
  { 0xA07B, BIDI_L   },  // YI SYLLABLE NBIE
  { 0xA07C, BIDI_L   },  // YI SYLLABLE NBIEP
  { 0xA07D, BIDI_L   },  // YI SYLLABLE NBAT
  { 0xA07E, BIDI_L   },  // YI SYLLABLE NBAX
  { 0xA07F, BIDI_L   },  // YI SYLLABLE NBA
  { 0xA080, BIDI_L   },  // YI SYLLABLE NBAP
  { 0xA081, BIDI_L   },  // YI SYLLABLE NBOT
  { 0xA082, BIDI_L   },  // YI SYLLABLE NBOX
  { 0xA083, BIDI_L   },  // YI SYLLABLE NBO
  { 0xA084, BIDI_L   },  // YI SYLLABLE NBOP
  { 0xA085, BIDI_L   },  // YI SYLLABLE NBUT
  { 0xA086, BIDI_L   },  // YI SYLLABLE NBUX
  { 0xA087, BIDI_L   },  // YI SYLLABLE NBU
  { 0xA088, BIDI_L   },  // YI SYLLABLE NBUP
  { 0xA089, BIDI_L   },  // YI SYLLABLE NBURX
  { 0xA08A, BIDI_L   },  // YI SYLLABLE NBUR
  { 0xA08B, BIDI_L   },  // YI SYLLABLE NBYT
  { 0xA08C, BIDI_L   },  // YI SYLLABLE NBYX
  { 0xA08D, BIDI_L   },  // YI SYLLABLE NBY
  { 0xA08E, BIDI_L   },  // YI SYLLABLE NBYP
  { 0xA08F, BIDI_L   },  // YI SYLLABLE NBYRX
  { 0xA090, BIDI_L   },  // YI SYLLABLE NBYR
  { 0xA091, BIDI_L   },  // YI SYLLABLE HMIT
  { 0xA092, BIDI_L   },  // YI SYLLABLE HMIX
  { 0xA093, BIDI_L   },  // YI SYLLABLE HMI
  { 0xA094, BIDI_L   },  // YI SYLLABLE HMIP
  { 0xA095, BIDI_L   },  // YI SYLLABLE HMIEX
  { 0xA096, BIDI_L   },  // YI SYLLABLE HMIE
  { 0xA097, BIDI_L   },  // YI SYLLABLE HMIEP
  { 0xA098, BIDI_L   },  // YI SYLLABLE HMAT
  { 0xA099, BIDI_L   },  // YI SYLLABLE HMAX
  { 0xA09A, BIDI_L   },  // YI SYLLABLE HMA
  { 0xA09B, BIDI_L   },  // YI SYLLABLE HMAP
  { 0xA09C, BIDI_L   },  // YI SYLLABLE HMUOX
  { 0xA09D, BIDI_L   },  // YI SYLLABLE HMUO
  { 0xA09E, BIDI_L   },  // YI SYLLABLE HMUOP
  { 0xA09F, BIDI_L   },  // YI SYLLABLE HMOT
  { 0xA0A0, BIDI_L   },  // YI SYLLABLE HMOX
  { 0xA0A1, BIDI_L   },  // YI SYLLABLE HMO
  { 0xA0A2, BIDI_L   },  // YI SYLLABLE HMOP
  { 0xA0A3, BIDI_L   },  // YI SYLLABLE HMUT
  { 0xA0A4, BIDI_L   },  // YI SYLLABLE HMUX
  { 0xA0A5, BIDI_L   },  // YI SYLLABLE HMU
  { 0xA0A6, BIDI_L   },  // YI SYLLABLE HMUP
  { 0xA0A7, BIDI_L   },  // YI SYLLABLE HMURX
  { 0xA0A8, BIDI_L   },  // YI SYLLABLE HMUR
  { 0xA0A9, BIDI_L   },  // YI SYLLABLE HMYX
  { 0xA0AA, BIDI_L   },  // YI SYLLABLE HMY
  { 0xA0AB, BIDI_L   },  // YI SYLLABLE HMYP
  { 0xA0AC, BIDI_L   },  // YI SYLLABLE HMYRX
  { 0xA0AD, BIDI_L   },  // YI SYLLABLE HMYR
  { 0xA0AE, BIDI_L   },  // YI SYLLABLE MIT
  { 0xA0AF, BIDI_L   },  // YI SYLLABLE MIX
  { 0xA0B0, BIDI_L   },  // YI SYLLABLE MI
  { 0xA0B1, BIDI_L   },  // YI SYLLABLE MIP
  { 0xA0B2, BIDI_L   },  // YI SYLLABLE MIEX
  { 0xA0B3, BIDI_L   },  // YI SYLLABLE MIE
  { 0xA0B4, BIDI_L   },  // YI SYLLABLE MIEP
  { 0xA0B5, BIDI_L   },  // YI SYLLABLE MAT
  { 0xA0B6, BIDI_L   },  // YI SYLLABLE MAX
  { 0xA0B7, BIDI_L   },  // YI SYLLABLE MA
  { 0xA0B8, BIDI_L   },  // YI SYLLABLE MAP
  { 0xA0B9, BIDI_L   },  // YI SYLLABLE MUOT
  { 0xA0BA, BIDI_L   },  // YI SYLLABLE MUOX
  { 0xA0BB, BIDI_L   },  // YI SYLLABLE MUO
  { 0xA0BC, BIDI_L   },  // YI SYLLABLE MUOP
  { 0xA0BD, BIDI_L   },  // YI SYLLABLE MOT
  { 0xA0BE, BIDI_L   },  // YI SYLLABLE MOX
  { 0xA0BF, BIDI_L   },  // YI SYLLABLE MO
  { 0xA0C0, BIDI_L   },  // YI SYLLABLE MOP
  { 0xA0C1, BIDI_L   },  // YI SYLLABLE MEX
  { 0xA0C2, BIDI_L   },  // YI SYLLABLE ME
  { 0xA0C3, BIDI_L   },  // YI SYLLABLE MUT
  { 0xA0C4, BIDI_L   },  // YI SYLLABLE MUX
  { 0xA0C5, BIDI_L   },  // YI SYLLABLE MU
  { 0xA0C6, BIDI_L   },  // YI SYLLABLE MUP
  { 0xA0C7, BIDI_L   },  // YI SYLLABLE MURX
  { 0xA0C8, BIDI_L   },  // YI SYLLABLE MUR
  { 0xA0C9, BIDI_L   },  // YI SYLLABLE MYT
  { 0xA0CA, BIDI_L   },  // YI SYLLABLE MYX
  { 0xA0CB, BIDI_L   },  // YI SYLLABLE MY
  { 0xA0CC, BIDI_L   },  // YI SYLLABLE MYP
  { 0xA0CD, BIDI_L   },  // YI SYLLABLE FIT
  { 0xA0CE, BIDI_L   },  // YI SYLLABLE FIX
  { 0xA0CF, BIDI_L   },  // YI SYLLABLE FI
  { 0xA0D0, BIDI_L   },  // YI SYLLABLE FIP
  { 0xA0D1, BIDI_L   },  // YI SYLLABLE FAT
  { 0xA0D2, BIDI_L   },  // YI SYLLABLE FAX
  { 0xA0D3, BIDI_L   },  // YI SYLLABLE FA
  { 0xA0D4, BIDI_L   },  // YI SYLLABLE FAP
  { 0xA0D5, BIDI_L   },  // YI SYLLABLE FOX
  { 0xA0D6, BIDI_L   },  // YI SYLLABLE FO
  { 0xA0D7, BIDI_L   },  // YI SYLLABLE FOP
  { 0xA0D8, BIDI_L   },  // YI SYLLABLE FUT
  { 0xA0D9, BIDI_L   },  // YI SYLLABLE FUX
  { 0xA0DA, BIDI_L   },  // YI SYLLABLE FU
  { 0xA0DB, BIDI_L   },  // YI SYLLABLE FUP
  { 0xA0DC, BIDI_L   },  // YI SYLLABLE FURX
  { 0xA0DD, BIDI_L   },  // YI SYLLABLE FUR
  { 0xA0DE, BIDI_L   },  // YI SYLLABLE FYT
  { 0xA0DF, BIDI_L   },  // YI SYLLABLE FYX
  { 0xA0E0, BIDI_L   },  // YI SYLLABLE FY
  { 0xA0E1, BIDI_L   },  // YI SYLLABLE FYP
  { 0xA0E2, BIDI_L   },  // YI SYLLABLE VIT
  { 0xA0E3, BIDI_L   },  // YI SYLLABLE VIX
  { 0xA0E4, BIDI_L   },  // YI SYLLABLE VI
  { 0xA0E5, BIDI_L   },  // YI SYLLABLE VIP
  { 0xA0E6, BIDI_L   },  // YI SYLLABLE VIET
  { 0xA0E7, BIDI_L   },  // YI SYLLABLE VIEX
  { 0xA0E8, BIDI_L   },  // YI SYLLABLE VIE
  { 0xA0E9, BIDI_L   },  // YI SYLLABLE VIEP
  { 0xA0EA, BIDI_L   },  // YI SYLLABLE VAT
  { 0xA0EB, BIDI_L   },  // YI SYLLABLE VAX
  { 0xA0EC, BIDI_L   },  // YI SYLLABLE VA
  { 0xA0ED, BIDI_L   },  // YI SYLLABLE VAP
  { 0xA0EE, BIDI_L   },  // YI SYLLABLE VOT
  { 0xA0EF, BIDI_L   },  // YI SYLLABLE VOX
  { 0xA0F0, BIDI_L   },  // YI SYLLABLE VO
  { 0xA0F1, BIDI_L   },  // YI SYLLABLE VOP
  { 0xA0F2, BIDI_L   },  // YI SYLLABLE VEX
  { 0xA0F3, BIDI_L   },  // YI SYLLABLE VEP
  { 0xA0F4, BIDI_L   },  // YI SYLLABLE VUT
  { 0xA0F5, BIDI_L   },  // YI SYLLABLE VUX
  { 0xA0F6, BIDI_L   },  // YI SYLLABLE VU
  { 0xA0F7, BIDI_L   },  // YI SYLLABLE VUP
  { 0xA0F8, BIDI_L   },  // YI SYLLABLE VURX
  { 0xA0F9, BIDI_L   },  // YI SYLLABLE VUR
  { 0xA0FA, BIDI_L   },  // YI SYLLABLE VYT
  { 0xA0FB, BIDI_L   },  // YI SYLLABLE VYX
  { 0xA0FC, BIDI_L   },  // YI SYLLABLE VY
  { 0xA0FD, BIDI_L   },  // YI SYLLABLE VYP
  { 0xA0FE, BIDI_L   },  // YI SYLLABLE VYRX
  { 0xA0FF, BIDI_L   },  // YI SYLLABLE VYR
  { 0xA100, BIDI_L   },  // YI SYLLABLE DIT
  { 0xA101, BIDI_L   },  // YI SYLLABLE DIX
  { 0xA102, BIDI_L   },  // YI SYLLABLE DI
  { 0xA103, BIDI_L   },  // YI SYLLABLE DIP
  { 0xA104, BIDI_L   },  // YI SYLLABLE DIEX
  { 0xA105, BIDI_L   },  // YI SYLLABLE DIE
  { 0xA106, BIDI_L   },  // YI SYLLABLE DIEP
  { 0xA107, BIDI_L   },  // YI SYLLABLE DAT
  { 0xA108, BIDI_L   },  // YI SYLLABLE DAX
  { 0xA109, BIDI_L   },  // YI SYLLABLE DA
  { 0xA10A, BIDI_L   },  // YI SYLLABLE DAP
  { 0xA10B, BIDI_L   },  // YI SYLLABLE DUOX
  { 0xA10C, BIDI_L   },  // YI SYLLABLE DUO
  { 0xA10D, BIDI_L   },  // YI SYLLABLE DOT
  { 0xA10E, BIDI_L   },  // YI SYLLABLE DOX
  { 0xA10F, BIDI_L   },  // YI SYLLABLE DO
  { 0xA110, BIDI_L   },  // YI SYLLABLE DOP
  { 0xA111, BIDI_L   },  // YI SYLLABLE DEX
  { 0xA112, BIDI_L   },  // YI SYLLABLE DE
  { 0xA113, BIDI_L   },  // YI SYLLABLE DEP
  { 0xA114, BIDI_L   },  // YI SYLLABLE DUT
  { 0xA115, BIDI_L   },  // YI SYLLABLE DUX
  { 0xA116, BIDI_L   },  // YI SYLLABLE DU
  { 0xA117, BIDI_L   },  // YI SYLLABLE DUP
  { 0xA118, BIDI_L   },  // YI SYLLABLE DURX
  { 0xA119, BIDI_L   },  // YI SYLLABLE DUR
  { 0xA11A, BIDI_L   },  // YI SYLLABLE TIT
  { 0xA11B, BIDI_L   },  // YI SYLLABLE TIX
  { 0xA11C, BIDI_L   },  // YI SYLLABLE TI
  { 0xA11D, BIDI_L   },  // YI SYLLABLE TIP
  { 0xA11E, BIDI_L   },  // YI SYLLABLE TIEX
  { 0xA11F, BIDI_L   },  // YI SYLLABLE TIE
  { 0xA120, BIDI_L   },  // YI SYLLABLE TIEP
  { 0xA121, BIDI_L   },  // YI SYLLABLE TAT
  { 0xA122, BIDI_L   },  // YI SYLLABLE TAX
  { 0xA123, BIDI_L   },  // YI SYLLABLE TA
  { 0xA124, BIDI_L   },  // YI SYLLABLE TAP
  { 0xA125, BIDI_L   },  // YI SYLLABLE TUOT
  { 0xA126, BIDI_L   },  // YI SYLLABLE TUOX
  { 0xA127, BIDI_L   },  // YI SYLLABLE TUO
  { 0xA128, BIDI_L   },  // YI SYLLABLE TUOP
  { 0xA129, BIDI_L   },  // YI SYLLABLE TOT
  { 0xA12A, BIDI_L   },  // YI SYLLABLE TOX
  { 0xA12B, BIDI_L   },  // YI SYLLABLE TO
  { 0xA12C, BIDI_L   },  // YI SYLLABLE TOP
  { 0xA12D, BIDI_L   },  // YI SYLLABLE TEX
  { 0xA12E, BIDI_L   },  // YI SYLLABLE TE
  { 0xA12F, BIDI_L   },  // YI SYLLABLE TEP
  { 0xA130, BIDI_L   },  // YI SYLLABLE TUT
  { 0xA131, BIDI_L   },  // YI SYLLABLE TUX
  { 0xA132, BIDI_L   },  // YI SYLLABLE TU
  { 0xA133, BIDI_L   },  // YI SYLLABLE TUP
  { 0xA134, BIDI_L   },  // YI SYLLABLE TURX
  { 0xA135, BIDI_L   },  // YI SYLLABLE TUR
  { 0xA136, BIDI_L   },  // YI SYLLABLE DDIT
  { 0xA137, BIDI_L   },  // YI SYLLABLE DDIX
  { 0xA138, BIDI_L   },  // YI SYLLABLE DDI
  { 0xA139, BIDI_L   },  // YI SYLLABLE DDIP
  { 0xA13A, BIDI_L   },  // YI SYLLABLE DDIEX
  { 0xA13B, BIDI_L   },  // YI SYLLABLE DDIE
  { 0xA13C, BIDI_L   },  // YI SYLLABLE DDIEP
  { 0xA13D, BIDI_L   },  // YI SYLLABLE DDAT
  { 0xA13E, BIDI_L   },  // YI SYLLABLE DDAX
  { 0xA13F, BIDI_L   },  // YI SYLLABLE DDA
  { 0xA140, BIDI_L   },  // YI SYLLABLE DDAP
  { 0xA141, BIDI_L   },  // YI SYLLABLE DDUOX
  { 0xA142, BIDI_L   },  // YI SYLLABLE DDUO
  { 0xA143, BIDI_L   },  // YI SYLLABLE DDUOP
  { 0xA144, BIDI_L   },  // YI SYLLABLE DDOT
  { 0xA145, BIDI_L   },  // YI SYLLABLE DDOX
  { 0xA146, BIDI_L   },  // YI SYLLABLE DDO
  { 0xA147, BIDI_L   },  // YI SYLLABLE DDOP
  { 0xA148, BIDI_L   },  // YI SYLLABLE DDEX
  { 0xA149, BIDI_L   },  // YI SYLLABLE DDE
  { 0xA14A, BIDI_L   },  // YI SYLLABLE DDEP
  { 0xA14B, BIDI_L   },  // YI SYLLABLE DDUT
  { 0xA14C, BIDI_L   },  // YI SYLLABLE DDUX
  { 0xA14D, BIDI_L   },  // YI SYLLABLE DDU
  { 0xA14E, BIDI_L   },  // YI SYLLABLE DDUP
  { 0xA14F, BIDI_L   },  // YI SYLLABLE DDURX
  { 0xA150, BIDI_L   },  // YI SYLLABLE DDUR
  { 0xA151, BIDI_L   },  // YI SYLLABLE NDIT
  { 0xA152, BIDI_L   },  // YI SYLLABLE NDIX
  { 0xA153, BIDI_L   },  // YI SYLLABLE NDI
  { 0xA154, BIDI_L   },  // YI SYLLABLE NDIP
  { 0xA155, BIDI_L   },  // YI SYLLABLE NDIEX
  { 0xA156, BIDI_L   },  // YI SYLLABLE NDIE
  { 0xA157, BIDI_L   },  // YI SYLLABLE NDAT
  { 0xA158, BIDI_L   },  // YI SYLLABLE NDAX
  { 0xA159, BIDI_L   },  // YI SYLLABLE NDA
  { 0xA15A, BIDI_L   },  // YI SYLLABLE NDAP
  { 0xA15B, BIDI_L   },  // YI SYLLABLE NDOT
  { 0xA15C, BIDI_L   },  // YI SYLLABLE NDOX
  { 0xA15D, BIDI_L   },  // YI SYLLABLE NDO
  { 0xA15E, BIDI_L   },  // YI SYLLABLE NDOP
  { 0xA15F, BIDI_L   },  // YI SYLLABLE NDEX
  { 0xA160, BIDI_L   },  // YI SYLLABLE NDE
  { 0xA161, BIDI_L   },  // YI SYLLABLE NDEP
  { 0xA162, BIDI_L   },  // YI SYLLABLE NDUT
  { 0xA163, BIDI_L   },  // YI SYLLABLE NDUX
  { 0xA164, BIDI_L   },  // YI SYLLABLE NDU
  { 0xA165, BIDI_L   },  // YI SYLLABLE NDUP
  { 0xA166, BIDI_L   },  // YI SYLLABLE NDURX
  { 0xA167, BIDI_L   },  // YI SYLLABLE NDUR
  { 0xA168, BIDI_L   },  // YI SYLLABLE HNIT
  { 0xA169, BIDI_L   },  // YI SYLLABLE HNIX
  { 0xA16A, BIDI_L   },  // YI SYLLABLE HNI
  { 0xA16B, BIDI_L   },  // YI SYLLABLE HNIP
  { 0xA16C, BIDI_L   },  // YI SYLLABLE HNIET
  { 0xA16D, BIDI_L   },  // YI SYLLABLE HNIEX
  { 0xA16E, BIDI_L   },  // YI SYLLABLE HNIE
  { 0xA16F, BIDI_L   },  // YI SYLLABLE HNIEP
  { 0xA170, BIDI_L   },  // YI SYLLABLE HNAT
  { 0xA171, BIDI_L   },  // YI SYLLABLE HNAX
  { 0xA172, BIDI_L   },  // YI SYLLABLE HNA
  { 0xA173, BIDI_L   },  // YI SYLLABLE HNAP
  { 0xA174, BIDI_L   },  // YI SYLLABLE HNUOX
  { 0xA175, BIDI_L   },  // YI SYLLABLE HNUO
  { 0xA176, BIDI_L   },  // YI SYLLABLE HNOT
  { 0xA177, BIDI_L   },  // YI SYLLABLE HNOX
  { 0xA178, BIDI_L   },  // YI SYLLABLE HNOP
  { 0xA179, BIDI_L   },  // YI SYLLABLE HNEX
  { 0xA17A, BIDI_L   },  // YI SYLLABLE HNE
  { 0xA17B, BIDI_L   },  // YI SYLLABLE HNEP
  { 0xA17C, BIDI_L   },  // YI SYLLABLE HNUT
  { 0xA17D, BIDI_L   },  // YI SYLLABLE NIT
  { 0xA17E, BIDI_L   },  // YI SYLLABLE NIX
  { 0xA17F, BIDI_L   },  // YI SYLLABLE NI
  { 0xA180, BIDI_L   },  // YI SYLLABLE NIP
  { 0xA181, BIDI_L   },  // YI SYLLABLE NIEX
  { 0xA182, BIDI_L   },  // YI SYLLABLE NIE
  { 0xA183, BIDI_L   },  // YI SYLLABLE NIEP
  { 0xA184, BIDI_L   },  // YI SYLLABLE NAX
  { 0xA185, BIDI_L   },  // YI SYLLABLE NA
  { 0xA186, BIDI_L   },  // YI SYLLABLE NAP
  { 0xA187, BIDI_L   },  // YI SYLLABLE NUOX
  { 0xA188, BIDI_L   },  // YI SYLLABLE NUO
  { 0xA189, BIDI_L   },  // YI SYLLABLE NUOP
  { 0xA18A, BIDI_L   },  // YI SYLLABLE NOT
  { 0xA18B, BIDI_L   },  // YI SYLLABLE NOX
  { 0xA18C, BIDI_L   },  // YI SYLLABLE NO
  { 0xA18D, BIDI_L   },  // YI SYLLABLE NOP
  { 0xA18E, BIDI_L   },  // YI SYLLABLE NEX
  { 0xA18F, BIDI_L   },  // YI SYLLABLE NE
  { 0xA190, BIDI_L   },  // YI SYLLABLE NEP
  { 0xA191, BIDI_L   },  // YI SYLLABLE NUT
  { 0xA192, BIDI_L   },  // YI SYLLABLE NUX
  { 0xA193, BIDI_L   },  // YI SYLLABLE NU
  { 0xA194, BIDI_L   },  // YI SYLLABLE NUP
  { 0xA195, BIDI_L   },  // YI SYLLABLE NURX
  { 0xA196, BIDI_L   },  // YI SYLLABLE NUR
  { 0xA197, BIDI_L   },  // YI SYLLABLE HLIT
  { 0xA198, BIDI_L   },  // YI SYLLABLE HLIX
  { 0xA199, BIDI_L   },  // YI SYLLABLE HLI
  { 0xA19A, BIDI_L   },  // YI SYLLABLE HLIP
  { 0xA19B, BIDI_L   },  // YI SYLLABLE HLIEX
  { 0xA19C, BIDI_L   },  // YI SYLLABLE HLIE
  { 0xA19D, BIDI_L   },  // YI SYLLABLE HLIEP
  { 0xA19E, BIDI_L   },  // YI SYLLABLE HLAT
  { 0xA19F, BIDI_L   },  // YI SYLLABLE HLAX
  { 0xA1A0, BIDI_L   },  // YI SYLLABLE HLA
  { 0xA1A1, BIDI_L   },  // YI SYLLABLE HLAP
  { 0xA1A2, BIDI_L   },  // YI SYLLABLE HLUOX
  { 0xA1A3, BIDI_L   },  // YI SYLLABLE HLUO
  { 0xA1A4, BIDI_L   },  // YI SYLLABLE HLUOP
  { 0xA1A5, BIDI_L   },  // YI SYLLABLE HLOX
  { 0xA1A6, BIDI_L   },  // YI SYLLABLE HLO
  { 0xA1A7, BIDI_L   },  // YI SYLLABLE HLOP
  { 0xA1A8, BIDI_L   },  // YI SYLLABLE HLEX
  { 0xA1A9, BIDI_L   },  // YI SYLLABLE HLE
  { 0xA1AA, BIDI_L   },  // YI SYLLABLE HLEP
  { 0xA1AB, BIDI_L   },  // YI SYLLABLE HLUT
  { 0xA1AC, BIDI_L   },  // YI SYLLABLE HLUX
  { 0xA1AD, BIDI_L   },  // YI SYLLABLE HLU
  { 0xA1AE, BIDI_L   },  // YI SYLLABLE HLUP
  { 0xA1AF, BIDI_L   },  // YI SYLLABLE HLURX
  { 0xA1B0, BIDI_L   },  // YI SYLLABLE HLUR
  { 0xA1B1, BIDI_L   },  // YI SYLLABLE HLYT
  { 0xA1B2, BIDI_L   },  // YI SYLLABLE HLYX
  { 0xA1B3, BIDI_L   },  // YI SYLLABLE HLY
  { 0xA1B4, BIDI_L   },  // YI SYLLABLE HLYP
  { 0xA1B5, BIDI_L   },  // YI SYLLABLE HLYRX
  { 0xA1B6, BIDI_L   },  // YI SYLLABLE HLYR
  { 0xA1B7, BIDI_L   },  // YI SYLLABLE LIT
  { 0xA1B8, BIDI_L   },  // YI SYLLABLE LIX
  { 0xA1B9, BIDI_L   },  // YI SYLLABLE LI
  { 0xA1BA, BIDI_L   },  // YI SYLLABLE LIP
  { 0xA1BB, BIDI_L   },  // YI SYLLABLE LIET
  { 0xA1BC, BIDI_L   },  // YI SYLLABLE LIEX
  { 0xA1BD, BIDI_L   },  // YI SYLLABLE LIE
  { 0xA1BE, BIDI_L   },  // YI SYLLABLE LIEP
  { 0xA1BF, BIDI_L   },  // YI SYLLABLE LAT
  { 0xA1C0, BIDI_L   },  // YI SYLLABLE LAX
  { 0xA1C1, BIDI_L   },  // YI SYLLABLE LA
  { 0xA1C2, BIDI_L   },  // YI SYLLABLE LAP
  { 0xA1C3, BIDI_L   },  // YI SYLLABLE LUOT
  { 0xA1C4, BIDI_L   },  // YI SYLLABLE LUOX
  { 0xA1C5, BIDI_L   },  // YI SYLLABLE LUO
  { 0xA1C6, BIDI_L   },  // YI SYLLABLE LUOP
  { 0xA1C7, BIDI_L   },  // YI SYLLABLE LOT
  { 0xA1C8, BIDI_L   },  // YI SYLLABLE LOX
  { 0xA1C9, BIDI_L   },  // YI SYLLABLE LO
  { 0xA1CA, BIDI_L   },  // YI SYLLABLE LOP
  { 0xA1CB, BIDI_L   },  // YI SYLLABLE LEX
  { 0xA1CC, BIDI_L   },  // YI SYLLABLE LE
  { 0xA1CD, BIDI_L   },  // YI SYLLABLE LEP
  { 0xA1CE, BIDI_L   },  // YI SYLLABLE LUT
  { 0xA1CF, BIDI_L   },  // YI SYLLABLE LUX
  { 0xA1D0, BIDI_L   },  // YI SYLLABLE LU
  { 0xA1D1, BIDI_L   },  // YI SYLLABLE LUP
  { 0xA1D2, BIDI_L   },  // YI SYLLABLE LURX
  { 0xA1D3, BIDI_L   },  // YI SYLLABLE LUR
  { 0xA1D4, BIDI_L   },  // YI SYLLABLE LYT
  { 0xA1D5, BIDI_L   },  // YI SYLLABLE LYX
  { 0xA1D6, BIDI_L   },  // YI SYLLABLE LY
  { 0xA1D7, BIDI_L   },  // YI SYLLABLE LYP
  { 0xA1D8, BIDI_L   },  // YI SYLLABLE LYRX
  { 0xA1D9, BIDI_L   },  // YI SYLLABLE LYR
  { 0xA1DA, BIDI_L   },  // YI SYLLABLE GIT
  { 0xA1DB, BIDI_L   },  // YI SYLLABLE GIX
  { 0xA1DC, BIDI_L   },  // YI SYLLABLE GI
  { 0xA1DD, BIDI_L   },  // YI SYLLABLE GIP
  { 0xA1DE, BIDI_L   },  // YI SYLLABLE GIET
  { 0xA1DF, BIDI_L   },  // YI SYLLABLE GIEX
  { 0xA1E0, BIDI_L   },  // YI SYLLABLE GIE
  { 0xA1E1, BIDI_L   },  // YI SYLLABLE GIEP
  { 0xA1E2, BIDI_L   },  // YI SYLLABLE GAT
  { 0xA1E3, BIDI_L   },  // YI SYLLABLE GAX
  { 0xA1E4, BIDI_L   },  // YI SYLLABLE GA
  { 0xA1E5, BIDI_L   },  // YI SYLLABLE GAP
  { 0xA1E6, BIDI_L   },  // YI SYLLABLE GUOT
  { 0xA1E7, BIDI_L   },  // YI SYLLABLE GUOX
  { 0xA1E8, BIDI_L   },  // YI SYLLABLE GUO
  { 0xA1E9, BIDI_L   },  // YI SYLLABLE GUOP
  { 0xA1EA, BIDI_L   },  // YI SYLLABLE GOT
  { 0xA1EB, BIDI_L   },  // YI SYLLABLE GOX
  { 0xA1EC, BIDI_L   },  // YI SYLLABLE GO
  { 0xA1ED, BIDI_L   },  // YI SYLLABLE GOP
  { 0xA1EE, BIDI_L   },  // YI SYLLABLE GET
  { 0xA1EF, BIDI_L   },  // YI SYLLABLE GEX
  { 0xA1F0, BIDI_L   },  // YI SYLLABLE GE
  { 0xA1F1, BIDI_L   },  // YI SYLLABLE GEP
  { 0xA1F2, BIDI_L   },  // YI SYLLABLE GUT
  { 0xA1F3, BIDI_L   },  // YI SYLLABLE GUX
  { 0xA1F4, BIDI_L   },  // YI SYLLABLE GU
  { 0xA1F5, BIDI_L   },  // YI SYLLABLE GUP
  { 0xA1F6, BIDI_L   },  // YI SYLLABLE GURX
  { 0xA1F7, BIDI_L   },  // YI SYLLABLE GUR
  { 0xA1F8, BIDI_L   },  // YI SYLLABLE KIT
  { 0xA1F9, BIDI_L   },  // YI SYLLABLE KIX
  { 0xA1FA, BIDI_L   },  // YI SYLLABLE KI
  { 0xA1FB, BIDI_L   },  // YI SYLLABLE KIP
  { 0xA1FC, BIDI_L   },  // YI SYLLABLE KIEX
  { 0xA1FD, BIDI_L   },  // YI SYLLABLE KIE
  { 0xA1FE, BIDI_L   },  // YI SYLLABLE KIEP
  { 0xA1FF, BIDI_L   },  // YI SYLLABLE KAT
  { 0xA200, BIDI_L   },  // YI SYLLABLE KAX
  { 0xA201, BIDI_L   },  // YI SYLLABLE KA
  { 0xA202, BIDI_L   },  // YI SYLLABLE KAP
  { 0xA203, BIDI_L   },  // YI SYLLABLE KUOX
  { 0xA204, BIDI_L   },  // YI SYLLABLE KUO
  { 0xA205, BIDI_L   },  // YI SYLLABLE KUOP
  { 0xA206, BIDI_L   },  // YI SYLLABLE KOT
  { 0xA207, BIDI_L   },  // YI SYLLABLE KOX
  { 0xA208, BIDI_L   },  // YI SYLLABLE KO
  { 0xA209, BIDI_L   },  // YI SYLLABLE KOP
  { 0xA20A, BIDI_L   },  // YI SYLLABLE KET
  { 0xA20B, BIDI_L   },  // YI SYLLABLE KEX
  { 0xA20C, BIDI_L   },  // YI SYLLABLE KE
  { 0xA20D, BIDI_L   },  // YI SYLLABLE KEP
  { 0xA20E, BIDI_L   },  // YI SYLLABLE KUT
  { 0xA20F, BIDI_L   },  // YI SYLLABLE KUX
  { 0xA210, BIDI_L   },  // YI SYLLABLE KU
  { 0xA211, BIDI_L   },  // YI SYLLABLE KUP
  { 0xA212, BIDI_L   },  // YI SYLLABLE KURX
  { 0xA213, BIDI_L   },  // YI SYLLABLE KUR
  { 0xA214, BIDI_L   },  // YI SYLLABLE GGIT
  { 0xA215, BIDI_L   },  // YI SYLLABLE GGIX
  { 0xA216, BIDI_L   },  // YI SYLLABLE GGI
  { 0xA217, BIDI_L   },  // YI SYLLABLE GGIEX
  { 0xA218, BIDI_L   },  // YI SYLLABLE GGIE
  { 0xA219, BIDI_L   },  // YI SYLLABLE GGIEP
  { 0xA21A, BIDI_L   },  // YI SYLLABLE GGAT
  { 0xA21B, BIDI_L   },  // YI SYLLABLE GGAX
  { 0xA21C, BIDI_L   },  // YI SYLLABLE GGA
  { 0xA21D, BIDI_L   },  // YI SYLLABLE GGAP
  { 0xA21E, BIDI_L   },  // YI SYLLABLE GGUOT
  { 0xA21F, BIDI_L   },  // YI SYLLABLE GGUOX
  { 0xA220, BIDI_L   },  // YI SYLLABLE GGUO
  { 0xA221, BIDI_L   },  // YI SYLLABLE GGUOP
  { 0xA222, BIDI_L   },  // YI SYLLABLE GGOT
  { 0xA223, BIDI_L   },  // YI SYLLABLE GGOX
  { 0xA224, BIDI_L   },  // YI SYLLABLE GGO
  { 0xA225, BIDI_L   },  // YI SYLLABLE GGOP
  { 0xA226, BIDI_L   },  // YI SYLLABLE GGET
  { 0xA227, BIDI_L   },  // YI SYLLABLE GGEX
  { 0xA228, BIDI_L   },  // YI SYLLABLE GGE
  { 0xA229, BIDI_L   },  // YI SYLLABLE GGEP
  { 0xA22A, BIDI_L   },  // YI SYLLABLE GGUT
  { 0xA22B, BIDI_L   },  // YI SYLLABLE GGUX
  { 0xA22C, BIDI_L   },  // YI SYLLABLE GGU
  { 0xA22D, BIDI_L   },  // YI SYLLABLE GGUP
  { 0xA22E, BIDI_L   },  // YI SYLLABLE GGURX
  { 0xA22F, BIDI_L   },  // YI SYLLABLE GGUR
  { 0xA230, BIDI_L   },  // YI SYLLABLE MGIEX
  { 0xA231, BIDI_L   },  // YI SYLLABLE MGIE
  { 0xA232, BIDI_L   },  // YI SYLLABLE MGAT
  { 0xA233, BIDI_L   },  // YI SYLLABLE MGAX
  { 0xA234, BIDI_L   },  // YI SYLLABLE MGA
  { 0xA235, BIDI_L   },  // YI SYLLABLE MGAP
  { 0xA236, BIDI_L   },  // YI SYLLABLE MGUOX
  { 0xA237, BIDI_L   },  // YI SYLLABLE MGUO
  { 0xA238, BIDI_L   },  // YI SYLLABLE MGUOP
  { 0xA239, BIDI_L   },  // YI SYLLABLE MGOT
  { 0xA23A, BIDI_L   },  // YI SYLLABLE MGOX
  { 0xA23B, BIDI_L   },  // YI SYLLABLE MGO
  { 0xA23C, BIDI_L   },  // YI SYLLABLE MGOP
  { 0xA23D, BIDI_L   },  // YI SYLLABLE MGEX
  { 0xA23E, BIDI_L   },  // YI SYLLABLE MGE
  { 0xA23F, BIDI_L   },  // YI SYLLABLE MGEP
  { 0xA240, BIDI_L   },  // YI SYLLABLE MGUT
  { 0xA241, BIDI_L   },  // YI SYLLABLE MGUX
  { 0xA242, BIDI_L   },  // YI SYLLABLE MGU
  { 0xA243, BIDI_L   },  // YI SYLLABLE MGUP
  { 0xA244, BIDI_L   },  // YI SYLLABLE MGURX
  { 0xA245, BIDI_L   },  // YI SYLLABLE MGUR
  { 0xA246, BIDI_L   },  // YI SYLLABLE HXIT
  { 0xA247, BIDI_L   },  // YI SYLLABLE HXIX
  { 0xA248, BIDI_L   },  // YI SYLLABLE HXI
  { 0xA249, BIDI_L   },  // YI SYLLABLE HXIP
  { 0xA24A, BIDI_L   },  // YI SYLLABLE HXIET
  { 0xA24B, BIDI_L   },  // YI SYLLABLE HXIEX
  { 0xA24C, BIDI_L   },  // YI SYLLABLE HXIE
  { 0xA24D, BIDI_L   },  // YI SYLLABLE HXIEP
  { 0xA24E, BIDI_L   },  // YI SYLLABLE HXAT
  { 0xA24F, BIDI_L   },  // YI SYLLABLE HXAX
  { 0xA250, BIDI_L   },  // YI SYLLABLE HXA
  { 0xA251, BIDI_L   },  // YI SYLLABLE HXAP
  { 0xA252, BIDI_L   },  // YI SYLLABLE HXUOT
  { 0xA253, BIDI_L   },  // YI SYLLABLE HXUOX
  { 0xA254, BIDI_L   },  // YI SYLLABLE HXUO
  { 0xA255, BIDI_L   },  // YI SYLLABLE HXUOP
  { 0xA256, BIDI_L   },  // YI SYLLABLE HXOT
  { 0xA257, BIDI_L   },  // YI SYLLABLE HXOX
  { 0xA258, BIDI_L   },  // YI SYLLABLE HXO
  { 0xA259, BIDI_L   },  // YI SYLLABLE HXOP
  { 0xA25A, BIDI_L   },  // YI SYLLABLE HXEX
  { 0xA25B, BIDI_L   },  // YI SYLLABLE HXE
  { 0xA25C, BIDI_L   },  // YI SYLLABLE HXEP
  { 0xA25D, BIDI_L   },  // YI SYLLABLE NGIEX
  { 0xA25E, BIDI_L   },  // YI SYLLABLE NGIE
  { 0xA25F, BIDI_L   },  // YI SYLLABLE NGIEP
  { 0xA260, BIDI_L   },  // YI SYLLABLE NGAT
  { 0xA261, BIDI_L   },  // YI SYLLABLE NGAX
  { 0xA262, BIDI_L   },  // YI SYLLABLE NGA
  { 0xA263, BIDI_L   },  // YI SYLLABLE NGAP
  { 0xA264, BIDI_L   },  // YI SYLLABLE NGUOT
  { 0xA265, BIDI_L   },  // YI SYLLABLE NGUOX
  { 0xA266, BIDI_L   },  // YI SYLLABLE NGUO
  { 0xA267, BIDI_L   },  // YI SYLLABLE NGOT
  { 0xA268, BIDI_L   },  // YI SYLLABLE NGOX
  { 0xA269, BIDI_L   },  // YI SYLLABLE NGO
  { 0xA26A, BIDI_L   },  // YI SYLLABLE NGOP
  { 0xA26B, BIDI_L   },  // YI SYLLABLE NGEX
  { 0xA26C, BIDI_L   },  // YI SYLLABLE NGE
  { 0xA26D, BIDI_L   },  // YI SYLLABLE NGEP
  { 0xA26E, BIDI_L   },  // YI SYLLABLE HIT
  { 0xA26F, BIDI_L   },  // YI SYLLABLE HIEX
  { 0xA270, BIDI_L   },  // YI SYLLABLE HIE
  { 0xA271, BIDI_L   },  // YI SYLLABLE HAT
  { 0xA272, BIDI_L   },  // YI SYLLABLE HAX
  { 0xA273, BIDI_L   },  // YI SYLLABLE HA
  { 0xA274, BIDI_L   },  // YI SYLLABLE HAP
  { 0xA275, BIDI_L   },  // YI SYLLABLE HUOT
  { 0xA276, BIDI_L   },  // YI SYLLABLE HUOX
  { 0xA277, BIDI_L   },  // YI SYLLABLE HUO
  { 0xA278, BIDI_L   },  // YI SYLLABLE HUOP
  { 0xA279, BIDI_L   },  // YI SYLLABLE HOT
  { 0xA27A, BIDI_L   },  // YI SYLLABLE HOX
  { 0xA27B, BIDI_L   },  // YI SYLLABLE HO
  { 0xA27C, BIDI_L   },  // YI SYLLABLE HOP
  { 0xA27D, BIDI_L   },  // YI SYLLABLE HEX
  { 0xA27E, BIDI_L   },  // YI SYLLABLE HE
  { 0xA27F, BIDI_L   },  // YI SYLLABLE HEP
  { 0xA280, BIDI_L   },  // YI SYLLABLE WAT
  { 0xA281, BIDI_L   },  // YI SYLLABLE WAX
  { 0xA282, BIDI_L   },  // YI SYLLABLE WA
  { 0xA283, BIDI_L   },  // YI SYLLABLE WAP
  { 0xA284, BIDI_L   },  // YI SYLLABLE WUOX
  { 0xA285, BIDI_L   },  // YI SYLLABLE WUO
  { 0xA286, BIDI_L   },  // YI SYLLABLE WUOP
  { 0xA287, BIDI_L   },  // YI SYLLABLE WOX
  { 0xA288, BIDI_L   },  // YI SYLLABLE WO
  { 0xA289, BIDI_L   },  // YI SYLLABLE WOP
  { 0xA28A, BIDI_L   },  // YI SYLLABLE WEX
  { 0xA28B, BIDI_L   },  // YI SYLLABLE WE
  { 0xA28C, BIDI_L   },  // YI SYLLABLE WEP
  { 0xA28D, BIDI_L   },  // YI SYLLABLE ZIT
  { 0xA28E, BIDI_L   },  // YI SYLLABLE ZIX
  { 0xA28F, BIDI_L   },  // YI SYLLABLE ZI
  { 0xA290, BIDI_L   },  // YI SYLLABLE ZIP
  { 0xA291, BIDI_L   },  // YI SYLLABLE ZIEX
  { 0xA292, BIDI_L   },  // YI SYLLABLE ZIE
  { 0xA293, BIDI_L   },  // YI SYLLABLE ZIEP
  { 0xA294, BIDI_L   },  // YI SYLLABLE ZAT
  { 0xA295, BIDI_L   },  // YI SYLLABLE ZAX
  { 0xA296, BIDI_L   },  // YI SYLLABLE ZA
  { 0xA297, BIDI_L   },  // YI SYLLABLE ZAP
  { 0xA298, BIDI_L   },  // YI SYLLABLE ZUOX
  { 0xA299, BIDI_L   },  // YI SYLLABLE ZUO
  { 0xA29A, BIDI_L   },  // YI SYLLABLE ZUOP
  { 0xA29B, BIDI_L   },  // YI SYLLABLE ZOT
  { 0xA29C, BIDI_L   },  // YI SYLLABLE ZOX
  { 0xA29D, BIDI_L   },  // YI SYLLABLE ZO
  { 0xA29E, BIDI_L   },  // YI SYLLABLE ZOP
  { 0xA29F, BIDI_L   },  // YI SYLLABLE ZEX
  { 0xA2A0, BIDI_L   },  // YI SYLLABLE ZE
  { 0xA2A1, BIDI_L   },  // YI SYLLABLE ZEP
  { 0xA2A2, BIDI_L   },  // YI SYLLABLE ZUT
  { 0xA2A3, BIDI_L   },  // YI SYLLABLE ZUX
  { 0xA2A4, BIDI_L   },  // YI SYLLABLE ZU
  { 0xA2A5, BIDI_L   },  // YI SYLLABLE ZUP
  { 0xA2A6, BIDI_L   },  // YI SYLLABLE ZURX
  { 0xA2A7, BIDI_L   },  // YI SYLLABLE ZUR
  { 0xA2A8, BIDI_L   },  // YI SYLLABLE ZYT
  { 0xA2A9, BIDI_L   },  // YI SYLLABLE ZYX
  { 0xA2AA, BIDI_L   },  // YI SYLLABLE ZY
  { 0xA2AB, BIDI_L   },  // YI SYLLABLE ZYP
  { 0xA2AC, BIDI_L   },  // YI SYLLABLE ZYRX
  { 0xA2AD, BIDI_L   },  // YI SYLLABLE ZYR
  { 0xA2AE, BIDI_L   },  // YI SYLLABLE CIT
  { 0xA2AF, BIDI_L   },  // YI SYLLABLE CIX
  { 0xA2B0, BIDI_L   },  // YI SYLLABLE CI
  { 0xA2B1, BIDI_L   },  // YI SYLLABLE CIP
  { 0xA2B2, BIDI_L   },  // YI SYLLABLE CIET
  { 0xA2B3, BIDI_L   },  // YI SYLLABLE CIEX
  { 0xA2B4, BIDI_L   },  // YI SYLLABLE CIE
  { 0xA2B5, BIDI_L   },  // YI SYLLABLE CIEP
  { 0xA2B6, BIDI_L   },  // YI SYLLABLE CAT
  { 0xA2B7, BIDI_L   },  // YI SYLLABLE CAX
  { 0xA2B8, BIDI_L   },  // YI SYLLABLE CA
  { 0xA2B9, BIDI_L   },  // YI SYLLABLE CAP
  { 0xA2BA, BIDI_L   },  // YI SYLLABLE CUOX
  { 0xA2BB, BIDI_L   },  // YI SYLLABLE CUO
  { 0xA2BC, BIDI_L   },  // YI SYLLABLE CUOP
  { 0xA2BD, BIDI_L   },  // YI SYLLABLE COT
  { 0xA2BE, BIDI_L   },  // YI SYLLABLE COX
  { 0xA2BF, BIDI_L   },  // YI SYLLABLE CO
  { 0xA2C0, BIDI_L   },  // YI SYLLABLE COP
  { 0xA2C1, BIDI_L   },  // YI SYLLABLE CEX
  { 0xA2C2, BIDI_L   },  // YI SYLLABLE CE
  { 0xA2C3, BIDI_L   },  // YI SYLLABLE CEP
  { 0xA2C4, BIDI_L   },  // YI SYLLABLE CUT
  { 0xA2C5, BIDI_L   },  // YI SYLLABLE CUX
  { 0xA2C6, BIDI_L   },  // YI SYLLABLE CU
  { 0xA2C7, BIDI_L   },  // YI SYLLABLE CUP
  { 0xA2C8, BIDI_L   },  // YI SYLLABLE CURX
  { 0xA2C9, BIDI_L   },  // YI SYLLABLE CUR
  { 0xA2CA, BIDI_L   },  // YI SYLLABLE CYT
  { 0xA2CB, BIDI_L   },  // YI SYLLABLE CYX
  { 0xA2CC, BIDI_L   },  // YI SYLLABLE CY
  { 0xA2CD, BIDI_L   },  // YI SYLLABLE CYP
  { 0xA2CE, BIDI_L   },  // YI SYLLABLE CYRX
  { 0xA2CF, BIDI_L   },  // YI SYLLABLE CYR
  { 0xA2D0, BIDI_L   },  // YI SYLLABLE ZZIT
  { 0xA2D1, BIDI_L   },  // YI SYLLABLE ZZIX
  { 0xA2D2, BIDI_L   },  // YI SYLLABLE ZZI
  { 0xA2D3, BIDI_L   },  // YI SYLLABLE ZZIP
  { 0xA2D4, BIDI_L   },  // YI SYLLABLE ZZIET
  { 0xA2D5, BIDI_L   },  // YI SYLLABLE ZZIEX
  { 0xA2D6, BIDI_L   },  // YI SYLLABLE ZZIE
  { 0xA2D7, BIDI_L   },  // YI SYLLABLE ZZIEP
  { 0xA2D8, BIDI_L   },  // YI SYLLABLE ZZAT
  { 0xA2D9, BIDI_L   },  // YI SYLLABLE ZZAX
  { 0xA2DA, BIDI_L   },  // YI SYLLABLE ZZA
  { 0xA2DB, BIDI_L   },  // YI SYLLABLE ZZAP
  { 0xA2DC, BIDI_L   },  // YI SYLLABLE ZZOX
  { 0xA2DD, BIDI_L   },  // YI SYLLABLE ZZO
  { 0xA2DE, BIDI_L   },  // YI SYLLABLE ZZOP
  { 0xA2DF, BIDI_L   },  // YI SYLLABLE ZZEX
  { 0xA2E0, BIDI_L   },  // YI SYLLABLE ZZE
  { 0xA2E1, BIDI_L   },  // YI SYLLABLE ZZEP
  { 0xA2E2, BIDI_L   },  // YI SYLLABLE ZZUX
  { 0xA2E3, BIDI_L   },  // YI SYLLABLE ZZU
  { 0xA2E4, BIDI_L   },  // YI SYLLABLE ZZUP
  { 0xA2E5, BIDI_L   },  // YI SYLLABLE ZZURX
  { 0xA2E6, BIDI_L   },  // YI SYLLABLE ZZUR
  { 0xA2E7, BIDI_L   },  // YI SYLLABLE ZZYT
  { 0xA2E8, BIDI_L   },  // YI SYLLABLE ZZYX
  { 0xA2E9, BIDI_L   },  // YI SYLLABLE ZZY
  { 0xA2EA, BIDI_L   },  // YI SYLLABLE ZZYP
  { 0xA2EB, BIDI_L   },  // YI SYLLABLE ZZYRX
  { 0xA2EC, BIDI_L   },  // YI SYLLABLE ZZYR
  { 0xA2ED, BIDI_L   },  // YI SYLLABLE NZIT
  { 0xA2EE, BIDI_L   },  // YI SYLLABLE NZIX
  { 0xA2EF, BIDI_L   },  // YI SYLLABLE NZI
  { 0xA2F0, BIDI_L   },  // YI SYLLABLE NZIP
  { 0xA2F1, BIDI_L   },  // YI SYLLABLE NZIEX
  { 0xA2F2, BIDI_L   },  // YI SYLLABLE NZIE
  { 0xA2F3, BIDI_L   },  // YI SYLLABLE NZIEP
  { 0xA2F4, BIDI_L   },  // YI SYLLABLE NZAT
  { 0xA2F5, BIDI_L   },  // YI SYLLABLE NZAX
  { 0xA2F6, BIDI_L   },  // YI SYLLABLE NZA
  { 0xA2F7, BIDI_L   },  // YI SYLLABLE NZAP
  { 0xA2F8, BIDI_L   },  // YI SYLLABLE NZUOX
  { 0xA2F9, BIDI_L   },  // YI SYLLABLE NZUO
  { 0xA2FA, BIDI_L   },  // YI SYLLABLE NZOX
  { 0xA2FB, BIDI_L   },  // YI SYLLABLE NZOP
  { 0xA2FC, BIDI_L   },  // YI SYLLABLE NZEX
  { 0xA2FD, BIDI_L   },  // YI SYLLABLE NZE
  { 0xA2FE, BIDI_L   },  // YI SYLLABLE NZUX
  { 0xA2FF, BIDI_L   },  // YI SYLLABLE NZU
  { 0xA300, BIDI_L   },  // YI SYLLABLE NZUP
  { 0xA301, BIDI_L   },  // YI SYLLABLE NZURX
  { 0xA302, BIDI_L   },  // YI SYLLABLE NZUR
  { 0xA303, BIDI_L   },  // YI SYLLABLE NZYT
  { 0xA304, BIDI_L   },  // YI SYLLABLE NZYX
  { 0xA305, BIDI_L   },  // YI SYLLABLE NZY
  { 0xA306, BIDI_L   },  // YI SYLLABLE NZYP
  { 0xA307, BIDI_L   },  // YI SYLLABLE NZYRX
  { 0xA308, BIDI_L   },  // YI SYLLABLE NZYR
  { 0xA309, BIDI_L   },  // YI SYLLABLE SIT
  { 0xA30A, BIDI_L   },  // YI SYLLABLE SIX
  { 0xA30B, BIDI_L   },  // YI SYLLABLE SI
  { 0xA30C, BIDI_L   },  // YI SYLLABLE SIP
  { 0xA30D, BIDI_L   },  // YI SYLLABLE SIEX
  { 0xA30E, BIDI_L   },  // YI SYLLABLE SIE
  { 0xA30F, BIDI_L   },  // YI SYLLABLE SIEP
  { 0xA310, BIDI_L   },  // YI SYLLABLE SAT
  { 0xA311, BIDI_L   },  // YI SYLLABLE SAX
  { 0xA312, BIDI_L   },  // YI SYLLABLE SA
  { 0xA313, BIDI_L   },  // YI SYLLABLE SAP
  { 0xA314, BIDI_L   },  // YI SYLLABLE SUOX
  { 0xA315, BIDI_L   },  // YI SYLLABLE SUO
  { 0xA316, BIDI_L   },  // YI SYLLABLE SUOP
  { 0xA317, BIDI_L   },  // YI SYLLABLE SOT
  { 0xA318, BIDI_L   },  // YI SYLLABLE SOX
  { 0xA319, BIDI_L   },  // YI SYLLABLE SO
  { 0xA31A, BIDI_L   },  // YI SYLLABLE SOP
  { 0xA31B, BIDI_L   },  // YI SYLLABLE SEX
  { 0xA31C, BIDI_L   },  // YI SYLLABLE SE
  { 0xA31D, BIDI_L   },  // YI SYLLABLE SEP
  { 0xA31E, BIDI_L   },  // YI SYLLABLE SUT
  { 0xA31F, BIDI_L   },  // YI SYLLABLE SUX
  { 0xA320, BIDI_L   },  // YI SYLLABLE SU
  { 0xA321, BIDI_L   },  // YI SYLLABLE SUP
  { 0xA322, BIDI_L   },  // YI SYLLABLE SURX
  { 0xA323, BIDI_L   },  // YI SYLLABLE SUR
  { 0xA324, BIDI_L   },  // YI SYLLABLE SYT
  { 0xA325, BIDI_L   },  // YI SYLLABLE SYX
  { 0xA326, BIDI_L   },  // YI SYLLABLE SY
  { 0xA327, BIDI_L   },  // YI SYLLABLE SYP
  { 0xA328, BIDI_L   },  // YI SYLLABLE SYRX
  { 0xA329, BIDI_L   },  // YI SYLLABLE SYR
  { 0xA32A, BIDI_L   },  // YI SYLLABLE SSIT
  { 0xA32B, BIDI_L   },  // YI SYLLABLE SSIX
  { 0xA32C, BIDI_L   },  // YI SYLLABLE SSI
  { 0xA32D, BIDI_L   },  // YI SYLLABLE SSIP
  { 0xA32E, BIDI_L   },  // YI SYLLABLE SSIEX
  { 0xA32F, BIDI_L   },  // YI SYLLABLE SSIE
  { 0xA330, BIDI_L   },  // YI SYLLABLE SSIEP
  { 0xA331, BIDI_L   },  // YI SYLLABLE SSAT
  { 0xA332, BIDI_L   },  // YI SYLLABLE SSAX
  { 0xA333, BIDI_L   },  // YI SYLLABLE SSA
  { 0xA334, BIDI_L   },  // YI SYLLABLE SSAP
  { 0xA335, BIDI_L   },  // YI SYLLABLE SSOT
  { 0xA336, BIDI_L   },  // YI SYLLABLE SSOX
  { 0xA337, BIDI_L   },  // YI SYLLABLE SSO
  { 0xA338, BIDI_L   },  // YI SYLLABLE SSOP
  { 0xA339, BIDI_L   },  // YI SYLLABLE SSEX
  { 0xA33A, BIDI_L   },  // YI SYLLABLE SSE
  { 0xA33B, BIDI_L   },  // YI SYLLABLE SSEP
  { 0xA33C, BIDI_L   },  // YI SYLLABLE SSUT
  { 0xA33D, BIDI_L   },  // YI SYLLABLE SSUX
  { 0xA33E, BIDI_L   },  // YI SYLLABLE SSU
  { 0xA33F, BIDI_L   },  // YI SYLLABLE SSUP
  { 0xA340, BIDI_L   },  // YI SYLLABLE SSYT
  { 0xA341, BIDI_L   },  // YI SYLLABLE SSYX
  { 0xA342, BIDI_L   },  // YI SYLLABLE SSY
  { 0xA343, BIDI_L   },  // YI SYLLABLE SSYP
  { 0xA344, BIDI_L   },  // YI SYLLABLE SSYRX
  { 0xA345, BIDI_L   },  // YI SYLLABLE SSYR
  { 0xA346, BIDI_L   },  // YI SYLLABLE ZHAT
  { 0xA347, BIDI_L   },  // YI SYLLABLE ZHAX
  { 0xA348, BIDI_L   },  // YI SYLLABLE ZHA
  { 0xA349, BIDI_L   },  // YI SYLLABLE ZHAP
  { 0xA34A, BIDI_L   },  // YI SYLLABLE ZHUOX
  { 0xA34B, BIDI_L   },  // YI SYLLABLE ZHUO
  { 0xA34C, BIDI_L   },  // YI SYLLABLE ZHUOP
  { 0xA34D, BIDI_L   },  // YI SYLLABLE ZHOT
  { 0xA34E, BIDI_L   },  // YI SYLLABLE ZHOX
  { 0xA34F, BIDI_L   },  // YI SYLLABLE ZHO
  { 0xA350, BIDI_L   },  // YI SYLLABLE ZHOP
  { 0xA351, BIDI_L   },  // YI SYLLABLE ZHET
  { 0xA352, BIDI_L   },  // YI SYLLABLE ZHEX
  { 0xA353, BIDI_L   },  // YI SYLLABLE ZHE
  { 0xA354, BIDI_L   },  // YI SYLLABLE ZHEP
  { 0xA355, BIDI_L   },  // YI SYLLABLE ZHUT
  { 0xA356, BIDI_L   },  // YI SYLLABLE ZHUX
  { 0xA357, BIDI_L   },  // YI SYLLABLE ZHU
  { 0xA358, BIDI_L   },  // YI SYLLABLE ZHUP
  { 0xA359, BIDI_L   },  // YI SYLLABLE ZHURX
  { 0xA35A, BIDI_L   },  // YI SYLLABLE ZHUR
  { 0xA35B, BIDI_L   },  // YI SYLLABLE ZHYT
  { 0xA35C, BIDI_L   },  // YI SYLLABLE ZHYX
  { 0xA35D, BIDI_L   },  // YI SYLLABLE ZHY
  { 0xA35E, BIDI_L   },  // YI SYLLABLE ZHYP
  { 0xA35F, BIDI_L   },  // YI SYLLABLE ZHYRX
  { 0xA360, BIDI_L   },  // YI SYLLABLE ZHYR
  { 0xA361, BIDI_L   },  // YI SYLLABLE CHAT
  { 0xA362, BIDI_L   },  // YI SYLLABLE CHAX
  { 0xA363, BIDI_L   },  // YI SYLLABLE CHA
  { 0xA364, BIDI_L   },  // YI SYLLABLE CHAP
  { 0xA365, BIDI_L   },  // YI SYLLABLE CHUOT
  { 0xA366, BIDI_L   },  // YI SYLLABLE CHUOX
  { 0xA367, BIDI_L   },  // YI SYLLABLE CHUO
  { 0xA368, BIDI_L   },  // YI SYLLABLE CHUOP
  { 0xA369, BIDI_L   },  // YI SYLLABLE CHOT
  { 0xA36A, BIDI_L   },  // YI SYLLABLE CHOX
  { 0xA36B, BIDI_L   },  // YI SYLLABLE CHO
  { 0xA36C, BIDI_L   },  // YI SYLLABLE CHOP
  { 0xA36D, BIDI_L   },  // YI SYLLABLE CHET
  { 0xA36E, BIDI_L   },  // YI SYLLABLE CHEX
  { 0xA36F, BIDI_L   },  // YI SYLLABLE CHE
  { 0xA370, BIDI_L   },  // YI SYLLABLE CHEP
  { 0xA371, BIDI_L   },  // YI SYLLABLE CHUX
  { 0xA372, BIDI_L   },  // YI SYLLABLE CHU
  { 0xA373, BIDI_L   },  // YI SYLLABLE CHUP
  { 0xA374, BIDI_L   },  // YI SYLLABLE CHURX
  { 0xA375, BIDI_L   },  // YI SYLLABLE CHUR
  { 0xA376, BIDI_L   },  // YI SYLLABLE CHYT
  { 0xA377, BIDI_L   },  // YI SYLLABLE CHYX
  { 0xA378, BIDI_L   },  // YI SYLLABLE CHY
  { 0xA379, BIDI_L   },  // YI SYLLABLE CHYP
  { 0xA37A, BIDI_L   },  // YI SYLLABLE CHYRX
  { 0xA37B, BIDI_L   },  // YI SYLLABLE CHYR
  { 0xA37C, BIDI_L   },  // YI SYLLABLE RRAX
  { 0xA37D, BIDI_L   },  // YI SYLLABLE RRA
  { 0xA37E, BIDI_L   },  // YI SYLLABLE RRUOX
  { 0xA37F, BIDI_L   },  // YI SYLLABLE RRUO
  { 0xA380, BIDI_L   },  // YI SYLLABLE RROT
  { 0xA381, BIDI_L   },  // YI SYLLABLE RROX
  { 0xA382, BIDI_L   },  // YI SYLLABLE RRO
  { 0xA383, BIDI_L   },  // YI SYLLABLE RROP
  { 0xA384, BIDI_L   },  // YI SYLLABLE RRET
  { 0xA385, BIDI_L   },  // YI SYLLABLE RREX
  { 0xA386, BIDI_L   },  // YI SYLLABLE RRE
  { 0xA387, BIDI_L   },  // YI SYLLABLE RREP
  { 0xA388, BIDI_L   },  // YI SYLLABLE RRUT
  { 0xA389, BIDI_L   },  // YI SYLLABLE RRUX
  { 0xA38A, BIDI_L   },  // YI SYLLABLE RRU
  { 0xA38B, BIDI_L   },  // YI SYLLABLE RRUP
  { 0xA38C, BIDI_L   },  // YI SYLLABLE RRURX
  { 0xA38D, BIDI_L   },  // YI SYLLABLE RRUR
  { 0xA38E, BIDI_L   },  // YI SYLLABLE RRYT
  { 0xA38F, BIDI_L   },  // YI SYLLABLE RRYX
  { 0xA390, BIDI_L   },  // YI SYLLABLE RRY
  { 0xA391, BIDI_L   },  // YI SYLLABLE RRYP
  { 0xA392, BIDI_L   },  // YI SYLLABLE RRYRX
  { 0xA393, BIDI_L   },  // YI SYLLABLE RRYR
  { 0xA394, BIDI_L   },  // YI SYLLABLE NRAT
  { 0xA395, BIDI_L   },  // YI SYLLABLE NRAX
  { 0xA396, BIDI_L   },  // YI SYLLABLE NRA
  { 0xA397, BIDI_L   },  // YI SYLLABLE NRAP
  { 0xA398, BIDI_L   },  // YI SYLLABLE NROX
  { 0xA399, BIDI_L   },  // YI SYLLABLE NRO
  { 0xA39A, BIDI_L   },  // YI SYLLABLE NROP
  { 0xA39B, BIDI_L   },  // YI SYLLABLE NRET
  { 0xA39C, BIDI_L   },  // YI SYLLABLE NREX
  { 0xA39D, BIDI_L   },  // YI SYLLABLE NRE
  { 0xA39E, BIDI_L   },  // YI SYLLABLE NREP
  { 0xA39F, BIDI_L   },  // YI SYLLABLE NRUT
  { 0xA3A0, BIDI_L   },  // YI SYLLABLE NRUX
  { 0xA3A1, BIDI_L   },  // YI SYLLABLE NRU
  { 0xA3A2, BIDI_L   },  // YI SYLLABLE NRUP
  { 0xA3A3, BIDI_L   },  // YI SYLLABLE NRURX
  { 0xA3A4, BIDI_L   },  // YI SYLLABLE NRUR
  { 0xA3A5, BIDI_L   },  // YI SYLLABLE NRYT
  { 0xA3A6, BIDI_L   },  // YI SYLLABLE NRYX
  { 0xA3A7, BIDI_L   },  // YI SYLLABLE NRY
  { 0xA3A8, BIDI_L   },  // YI SYLLABLE NRYP
  { 0xA3A9, BIDI_L   },  // YI SYLLABLE NRYRX
  { 0xA3AA, BIDI_L   },  // YI SYLLABLE NRYR
  { 0xA3AB, BIDI_L   },  // YI SYLLABLE SHAT
  { 0xA3AC, BIDI_L   },  // YI SYLLABLE SHAX
  { 0xA3AD, BIDI_L   },  // YI SYLLABLE SHA
  { 0xA3AE, BIDI_L   },  // YI SYLLABLE SHAP
  { 0xA3AF, BIDI_L   },  // YI SYLLABLE SHUOX
  { 0xA3B0, BIDI_L   },  // YI SYLLABLE SHUO
  { 0xA3B1, BIDI_L   },  // YI SYLLABLE SHUOP
  { 0xA3B2, BIDI_L   },  // YI SYLLABLE SHOT
  { 0xA3B3, BIDI_L   },  // YI SYLLABLE SHOX
  { 0xA3B4, BIDI_L   },  // YI SYLLABLE SHO
  { 0xA3B5, BIDI_L   },  // YI SYLLABLE SHOP
  { 0xA3B6, BIDI_L   },  // YI SYLLABLE SHET
  { 0xA3B7, BIDI_L   },  // YI SYLLABLE SHEX
  { 0xA3B8, BIDI_L   },  // YI SYLLABLE SHE
  { 0xA3B9, BIDI_L   },  // YI SYLLABLE SHEP
  { 0xA3BA, BIDI_L   },  // YI SYLLABLE SHUT
  { 0xA3BB, BIDI_L   },  // YI SYLLABLE SHUX
  { 0xA3BC, BIDI_L   },  // YI SYLLABLE SHU
  { 0xA3BD, BIDI_L   },  // YI SYLLABLE SHUP
  { 0xA3BE, BIDI_L   },  // YI SYLLABLE SHURX
  { 0xA3BF, BIDI_L   },  // YI SYLLABLE SHUR
  { 0xA3C0, BIDI_L   },  // YI SYLLABLE SHYT
  { 0xA3C1, BIDI_L   },  // YI SYLLABLE SHYX
  { 0xA3C2, BIDI_L   },  // YI SYLLABLE SHY
  { 0xA3C3, BIDI_L   },  // YI SYLLABLE SHYP
  { 0xA3C4, BIDI_L   },  // YI SYLLABLE SHYRX
  { 0xA3C5, BIDI_L   },  // YI SYLLABLE SHYR
  { 0xA3C6, BIDI_L   },  // YI SYLLABLE RAT
  { 0xA3C7, BIDI_L   },  // YI SYLLABLE RAX
  { 0xA3C8, BIDI_L   },  // YI SYLLABLE RA
  { 0xA3C9, BIDI_L   },  // YI SYLLABLE RAP
  { 0xA3CA, BIDI_L   },  // YI SYLLABLE RUOX
  { 0xA3CB, BIDI_L   },  // YI SYLLABLE RUO
  { 0xA3CC, BIDI_L   },  // YI SYLLABLE RUOP
  { 0xA3CD, BIDI_L   },  // YI SYLLABLE ROT
  { 0xA3CE, BIDI_L   },  // YI SYLLABLE ROX
  { 0xA3CF, BIDI_L   },  // YI SYLLABLE RO
  { 0xA3D0, BIDI_L   },  // YI SYLLABLE ROP
  { 0xA3D1, BIDI_L   },  // YI SYLLABLE REX
  { 0xA3D2, BIDI_L   },  // YI SYLLABLE RE
  { 0xA3D3, BIDI_L   },  // YI SYLLABLE REP
  { 0xA3D4, BIDI_L   },  // YI SYLLABLE RUT
  { 0xA3D5, BIDI_L   },  // YI SYLLABLE RUX
  { 0xA3D6, BIDI_L   },  // YI SYLLABLE RU
  { 0xA3D7, BIDI_L   },  // YI SYLLABLE RUP
  { 0xA3D8, BIDI_L   },  // YI SYLLABLE RURX
  { 0xA3D9, BIDI_L   },  // YI SYLLABLE RUR
  { 0xA3DA, BIDI_L   },  // YI SYLLABLE RYT
  { 0xA3DB, BIDI_L   },  // YI SYLLABLE RYX
  { 0xA3DC, BIDI_L   },  // YI SYLLABLE RY
  { 0xA3DD, BIDI_L   },  // YI SYLLABLE RYP
  { 0xA3DE, BIDI_L   },  // YI SYLLABLE RYRX
  { 0xA3DF, BIDI_L   },  // YI SYLLABLE RYR
  { 0xA3E0, BIDI_L   },  // YI SYLLABLE JIT
  { 0xA3E1, BIDI_L   },  // YI SYLLABLE JIX
  { 0xA3E2, BIDI_L   },  // YI SYLLABLE JI
  { 0xA3E3, BIDI_L   },  // YI SYLLABLE JIP
  { 0xA3E4, BIDI_L   },  // YI SYLLABLE JIET
  { 0xA3E5, BIDI_L   },  // YI SYLLABLE JIEX
  { 0xA3E6, BIDI_L   },  // YI SYLLABLE JIE
  { 0xA3E7, BIDI_L   },  // YI SYLLABLE JIEP
  { 0xA3E8, BIDI_L   },  // YI SYLLABLE JUOT
  { 0xA3E9, BIDI_L   },  // YI SYLLABLE JUOX
  { 0xA3EA, BIDI_L   },  // YI SYLLABLE JUO
  { 0xA3EB, BIDI_L   },  // YI SYLLABLE JUOP
  { 0xA3EC, BIDI_L   },  // YI SYLLABLE JOT
  { 0xA3ED, BIDI_L   },  // YI SYLLABLE JOX
  { 0xA3EE, BIDI_L   },  // YI SYLLABLE JO
  { 0xA3EF, BIDI_L   },  // YI SYLLABLE JOP
  { 0xA3F0, BIDI_L   },  // YI SYLLABLE JUT
  { 0xA3F1, BIDI_L   },  // YI SYLLABLE JUX
  { 0xA3F2, BIDI_L   },  // YI SYLLABLE JU
  { 0xA3F3, BIDI_L   },  // YI SYLLABLE JUP
  { 0xA3F4, BIDI_L   },  // YI SYLLABLE JURX
  { 0xA3F5, BIDI_L   },  // YI SYLLABLE JUR
  { 0xA3F6, BIDI_L   },  // YI SYLLABLE JYT
  { 0xA3F7, BIDI_L   },  // YI SYLLABLE JYX
  { 0xA3F8, BIDI_L   },  // YI SYLLABLE JY
  { 0xA3F9, BIDI_L   },  // YI SYLLABLE JYP
  { 0xA3FA, BIDI_L   },  // YI SYLLABLE JYRX
  { 0xA3FB, BIDI_L   },  // YI SYLLABLE JYR
  { 0xA3FC, BIDI_L   },  // YI SYLLABLE QIT
  { 0xA3FD, BIDI_L   },  // YI SYLLABLE QIX
  { 0xA3FE, BIDI_L   },  // YI SYLLABLE QI
  { 0xA3FF, BIDI_L   },  // YI SYLLABLE QIP
  { 0xA400, BIDI_L   },  // YI SYLLABLE QIET
  { 0xA401, BIDI_L   },  // YI SYLLABLE QIEX
  { 0xA402, BIDI_L   },  // YI SYLLABLE QIE
  { 0xA403, BIDI_L   },  // YI SYLLABLE QIEP
  { 0xA404, BIDI_L   },  // YI SYLLABLE QUOT
  { 0xA405, BIDI_L   },  // YI SYLLABLE QUOX
  { 0xA406, BIDI_L   },  // YI SYLLABLE QUO
  { 0xA407, BIDI_L   },  // YI SYLLABLE QUOP
  { 0xA408, BIDI_L   },  // YI SYLLABLE QOT
  { 0xA409, BIDI_L   },  // YI SYLLABLE QOX
  { 0xA40A, BIDI_L   },  // YI SYLLABLE QO
  { 0xA40B, BIDI_L   },  // YI SYLLABLE QOP
  { 0xA40C, BIDI_L   },  // YI SYLLABLE QUT
  { 0xA40D, BIDI_L   },  // YI SYLLABLE QUX
  { 0xA40E, BIDI_L   },  // YI SYLLABLE QU
  { 0xA40F, BIDI_L   },  // YI SYLLABLE QUP
  { 0xA410, BIDI_L   },  // YI SYLLABLE QURX
  { 0xA411, BIDI_L   },  // YI SYLLABLE QUR
  { 0xA412, BIDI_L   },  // YI SYLLABLE QYT
  { 0xA413, BIDI_L   },  // YI SYLLABLE QYX
  { 0xA414, BIDI_L   },  // YI SYLLABLE QY
  { 0xA415, BIDI_L   },  // YI SYLLABLE QYP
  { 0xA416, BIDI_L   },  // YI SYLLABLE QYRX
  { 0xA417, BIDI_L   },  // YI SYLLABLE QYR
  { 0xA418, BIDI_L   },  // YI SYLLABLE JJIT
  { 0xA419, BIDI_L   },  // YI SYLLABLE JJIX
  { 0xA41A, BIDI_L   },  // YI SYLLABLE JJI
  { 0xA41B, BIDI_L   },  // YI SYLLABLE JJIP
  { 0xA41C, BIDI_L   },  // YI SYLLABLE JJIET
  { 0xA41D, BIDI_L   },  // YI SYLLABLE JJIEX
  { 0xA41E, BIDI_L   },  // YI SYLLABLE JJIE
  { 0xA41F, BIDI_L   },  // YI SYLLABLE JJIEP
  { 0xA420, BIDI_L   },  // YI SYLLABLE JJUOX
  { 0xA421, BIDI_L   },  // YI SYLLABLE JJUO
  { 0xA422, BIDI_L   },  // YI SYLLABLE JJUOP
  { 0xA423, BIDI_L   },  // YI SYLLABLE JJOT
  { 0xA424, BIDI_L   },  // YI SYLLABLE JJOX
  { 0xA425, BIDI_L   },  // YI SYLLABLE JJO
  { 0xA426, BIDI_L   },  // YI SYLLABLE JJOP
  { 0xA427, BIDI_L   },  // YI SYLLABLE JJUT
  { 0xA428, BIDI_L   },  // YI SYLLABLE JJUX
  { 0xA429, BIDI_L   },  // YI SYLLABLE JJU
  { 0xA42A, BIDI_L   },  // YI SYLLABLE JJUP
  { 0xA42B, BIDI_L   },  // YI SYLLABLE JJURX
  { 0xA42C, BIDI_L   },  // YI SYLLABLE JJUR
  { 0xA42D, BIDI_L   },  // YI SYLLABLE JJYT
  { 0xA42E, BIDI_L   },  // YI SYLLABLE JJYX
  { 0xA42F, BIDI_L   },  // YI SYLLABLE JJY
  { 0xA430, BIDI_L   },  // YI SYLLABLE JJYP
  { 0xA431, BIDI_L   },  // YI SYLLABLE NJIT
  { 0xA432, BIDI_L   },  // YI SYLLABLE NJIX
  { 0xA433, BIDI_L   },  // YI SYLLABLE NJI
  { 0xA434, BIDI_L   },  // YI SYLLABLE NJIP
  { 0xA435, BIDI_L   },  // YI SYLLABLE NJIET
  { 0xA436, BIDI_L   },  // YI SYLLABLE NJIEX
  { 0xA437, BIDI_L   },  // YI SYLLABLE NJIE
  { 0xA438, BIDI_L   },  // YI SYLLABLE NJIEP
  { 0xA439, BIDI_L   },  // YI SYLLABLE NJUOX
  { 0xA43A, BIDI_L   },  // YI SYLLABLE NJUO
  { 0xA43B, BIDI_L   },  // YI SYLLABLE NJOT
  { 0xA43C, BIDI_L   },  // YI SYLLABLE NJOX
  { 0xA43D, BIDI_L   },  // YI SYLLABLE NJO
  { 0xA43E, BIDI_L   },  // YI SYLLABLE NJOP
  { 0xA43F, BIDI_L   },  // YI SYLLABLE NJUX
  { 0xA440, BIDI_L   },  // YI SYLLABLE NJU
  { 0xA441, BIDI_L   },  // YI SYLLABLE NJUP
  { 0xA442, BIDI_L   },  // YI SYLLABLE NJURX
  { 0xA443, BIDI_L   },  // YI SYLLABLE NJUR
  { 0xA444, BIDI_L   },  // YI SYLLABLE NJYT
  { 0xA445, BIDI_L   },  // YI SYLLABLE NJYX
  { 0xA446, BIDI_L   },  // YI SYLLABLE NJY
  { 0xA447, BIDI_L   },  // YI SYLLABLE NJYP
  { 0xA448, BIDI_L   },  // YI SYLLABLE NJYRX
  { 0xA449, BIDI_L   },  // YI SYLLABLE NJYR
  { 0xA44A, BIDI_L   },  // YI SYLLABLE NYIT
  { 0xA44B, BIDI_L   },  // YI SYLLABLE NYIX
  { 0xA44C, BIDI_L   },  // YI SYLLABLE NYI
  { 0xA44D, BIDI_L   },  // YI SYLLABLE NYIP
  { 0xA44E, BIDI_L   },  // YI SYLLABLE NYIET
  { 0xA44F, BIDI_L   },  // YI SYLLABLE NYIEX
  { 0xA450, BIDI_L   },  // YI SYLLABLE NYIE
  { 0xA451, BIDI_L   },  // YI SYLLABLE NYIEP
  { 0xA452, BIDI_L   },  // YI SYLLABLE NYUOX
  { 0xA453, BIDI_L   },  // YI SYLLABLE NYUO
  { 0xA454, BIDI_L   },  // YI SYLLABLE NYUOP
  { 0xA455, BIDI_L   },  // YI SYLLABLE NYOT
  { 0xA456, BIDI_L   },  // YI SYLLABLE NYOX
  { 0xA457, BIDI_L   },  // YI SYLLABLE NYO
  { 0xA458, BIDI_L   },  // YI SYLLABLE NYOP
  { 0xA459, BIDI_L   },  // YI SYLLABLE NYUT
  { 0xA45A, BIDI_L   },  // YI SYLLABLE NYUX
  { 0xA45B, BIDI_L   },  // YI SYLLABLE NYU
  { 0xA45C, BIDI_L   },  // YI SYLLABLE NYUP
  { 0xA45D, BIDI_L   },  // YI SYLLABLE XIT
  { 0xA45E, BIDI_L   },  // YI SYLLABLE XIX
  { 0xA45F, BIDI_L   },  // YI SYLLABLE XI
  { 0xA460, BIDI_L   },  // YI SYLLABLE XIP
  { 0xA461, BIDI_L   },  // YI SYLLABLE XIET
  { 0xA462, BIDI_L   },  // YI SYLLABLE XIEX
  { 0xA463, BIDI_L   },  // YI SYLLABLE XIE
  { 0xA464, BIDI_L   },  // YI SYLLABLE XIEP
  { 0xA465, BIDI_L   },  // YI SYLLABLE XUOX
  { 0xA466, BIDI_L   },  // YI SYLLABLE XUO
  { 0xA467, BIDI_L   },  // YI SYLLABLE XOT
  { 0xA468, BIDI_L   },  // YI SYLLABLE XOX
  { 0xA469, BIDI_L   },  // YI SYLLABLE XO
  { 0xA46A, BIDI_L   },  // YI SYLLABLE XOP
  { 0xA46B, BIDI_L   },  // YI SYLLABLE XYT
  { 0xA46C, BIDI_L   },  // YI SYLLABLE XYX
  { 0xA46D, BIDI_L   },  // YI SYLLABLE XY
  { 0xA46E, BIDI_L   },  // YI SYLLABLE XYP
  { 0xA46F, BIDI_L   },  // YI SYLLABLE XYRX
  { 0xA470, BIDI_L   },  // YI SYLLABLE XYR
  { 0xA471, BIDI_L   },  // YI SYLLABLE YIT
  { 0xA472, BIDI_L   },  // YI SYLLABLE YIX
  { 0xA473, BIDI_L   },  // YI SYLLABLE YI
  { 0xA474, BIDI_L   },  // YI SYLLABLE YIP
  { 0xA475, BIDI_L   },  // YI SYLLABLE YIET
  { 0xA476, BIDI_L   },  // YI SYLLABLE YIEX
  { 0xA477, BIDI_L   },  // YI SYLLABLE YIE
  { 0xA478, BIDI_L   },  // YI SYLLABLE YIEP
  { 0xA479, BIDI_L   },  // YI SYLLABLE YUOT
  { 0xA47A, BIDI_L   },  // YI SYLLABLE YUOX
  { 0xA47B, BIDI_L   },  // YI SYLLABLE YUO
  { 0xA47C, BIDI_L   },  // YI SYLLABLE YUOP
  { 0xA47D, BIDI_L   },  // YI SYLLABLE YOT
  { 0xA47E, BIDI_L   },  // YI SYLLABLE YOX
  { 0xA47F, BIDI_L   },  // YI SYLLABLE YO
  { 0xA480, BIDI_L   },  // YI SYLLABLE YOP
  { 0xA481, BIDI_L   },  // YI SYLLABLE YUT
  { 0xA482, BIDI_L   },  // YI SYLLABLE YUX
  { 0xA483, BIDI_L   },  // YI SYLLABLE YU
  { 0xA484, BIDI_L   },  // YI SYLLABLE YUP
  { 0xA485, BIDI_L   },  // YI SYLLABLE YURX
  { 0xA486, BIDI_L   },  // YI SYLLABLE YUR
  { 0xA487, BIDI_L   },  // YI SYLLABLE YYT
  { 0xA488, BIDI_L   },  // YI SYLLABLE YYX
  { 0xA489, BIDI_L   },  // YI SYLLABLE YY
  { 0xA48A, BIDI_L   },  // YI SYLLABLE YYP
  { 0xA48B, BIDI_L   },  // YI SYLLABLE YYRX
  { 0xA48C, BIDI_L   },  // YI SYLLABLE YYR
  { 0xA490, BIDI_ON  },  // YI RADICAL QOT
  { 0xA491, BIDI_ON  },  // YI RADICAL LI
  { 0xA492, BIDI_ON  },  // YI RADICAL KIT
  { 0xA493, BIDI_ON  },  // YI RADICAL NYIP
  { 0xA494, BIDI_ON  },  // YI RADICAL CYP
  { 0xA495, BIDI_ON  },  // YI RADICAL SSI
  { 0xA496, BIDI_ON  },  // YI RADICAL GGOP
  { 0xA497, BIDI_ON  },  // YI RADICAL GEP
  { 0xA498, BIDI_ON  },  // YI RADICAL MI
  { 0xA499, BIDI_ON  },  // YI RADICAL HXIT
  { 0xA49A, BIDI_ON  },  // YI RADICAL LYR
  { 0xA49B, BIDI_ON  },  // YI RADICAL BBUT
  { 0xA49C, BIDI_ON  },  // YI RADICAL MOP
  { 0xA49D, BIDI_ON  },  // YI RADICAL YO
  { 0xA49E, BIDI_ON  },  // YI RADICAL PUT
  { 0xA49F, BIDI_ON  },  // YI RADICAL HXUO
  { 0xA4A0, BIDI_ON  },  // YI RADICAL TAT
  { 0xA4A1, BIDI_ON  },  // YI RADICAL GA
  { 0xA4A2, BIDI_ON  },  // YI RADICAL ZUP
  { 0xA4A3, BIDI_ON  },  // YI RADICAL CYT
  { 0xA4A4, BIDI_ON  },  // YI RADICAL DDUR
  { 0xA4A5, BIDI_ON  },  // YI RADICAL BUR
  { 0xA4A6, BIDI_ON  },  // YI RADICAL GGUO
  { 0xA4A7, BIDI_ON  },  // YI RADICAL NYOP
  { 0xA4A8, BIDI_ON  },  // YI RADICAL TU
  { 0xA4A9, BIDI_ON  },  // YI RADICAL OP
  { 0xA4AA, BIDI_ON  },  // YI RADICAL JJUT
  { 0xA4AB, BIDI_ON  },  // YI RADICAL ZOT
  { 0xA4AC, BIDI_ON  },  // YI RADICAL PYT
  { 0xA4AD, BIDI_ON  },  // YI RADICAL HMO
  { 0xA4AE, BIDI_ON  },  // YI RADICAL YIT
  { 0xA4AF, BIDI_ON  },  // YI RADICAL VUR
  { 0xA4B0, BIDI_ON  },  // YI RADICAL SHY
  { 0xA4B1, BIDI_ON  },  // YI RADICAL VEP
  { 0xA4B2, BIDI_ON  },  // YI RADICAL ZA
  { 0xA4B3, BIDI_ON  },  // YI RADICAL JO
  { 0xA4B4, BIDI_ON  },  // YI RADICAL NZUP
  { 0xA4B5, BIDI_ON  },  // YI RADICAL JJY
  { 0xA4B6, BIDI_ON  },  // YI RADICAL GOT
  { 0xA4B7, BIDI_ON  },  // YI RADICAL JJIE
  { 0xA4B8, BIDI_ON  },  // YI RADICAL WO
  { 0xA4B9, BIDI_ON  },  // YI RADICAL DU
  { 0xA4BA, BIDI_ON  },  // YI RADICAL SHUR
  { 0xA4BB, BIDI_ON  },  // YI RADICAL LIE
  { 0xA4BC, BIDI_ON  },  // YI RADICAL CY
  { 0xA4BD, BIDI_ON  },  // YI RADICAL CUOP
  { 0xA4BE, BIDI_ON  },  // YI RADICAL CIP
  { 0xA4BF, BIDI_ON  },  // YI RADICAL HXOP
  { 0xA4C0, BIDI_ON  },  // YI RADICAL SHAT
  { 0xA4C1, BIDI_ON  },  // YI RADICAL ZUR
  { 0xA4C2, BIDI_ON  },  // YI RADICAL SHOP
  { 0xA4C3, BIDI_ON  },  // YI RADICAL CHE
  { 0xA4C4, BIDI_ON  },  // YI RADICAL ZZIET
  { 0xA4C5, BIDI_ON  },  // YI RADICAL NBIE
  { 0xA4C6, BIDI_ON  },  // YI RADICAL KE
  { 0xA4D0, BIDI_L   },  // LISU LETTER BA
  { 0xA4D1, BIDI_L   },  // LISU LETTER PA
  { 0xA4D2, BIDI_L   },  // LISU LETTER PHA
  { 0xA4D3, BIDI_L   },  // LISU LETTER DA
  { 0xA4D4, BIDI_L   },  // LISU LETTER TA
  { 0xA4D5, BIDI_L   },  // LISU LETTER THA
  { 0xA4D6, BIDI_L   },  // LISU LETTER GA
  { 0xA4D7, BIDI_L   },  // LISU LETTER KA
  { 0xA4D8, BIDI_L   },  // LISU LETTER KHA
  { 0xA4D9, BIDI_L   },  // LISU LETTER JA
  { 0xA4DA, BIDI_L   },  // LISU LETTER CA
  { 0xA4DB, BIDI_L   },  // LISU LETTER CHA
  { 0xA4DC, BIDI_L   },  // LISU LETTER DZA
  { 0xA4DD, BIDI_L   },  // LISU LETTER TSA
  { 0xA4DE, BIDI_L   },  // LISU LETTER TSHA
  { 0xA4DF, BIDI_L   },  // LISU LETTER MA
  { 0xA4E0, BIDI_L   },  // LISU LETTER NA
  { 0xA4E1, BIDI_L   },  // LISU LETTER LA
  { 0xA4E2, BIDI_L   },  // LISU LETTER SA
  { 0xA4E3, BIDI_L   },  // LISU LETTER ZHA
  { 0xA4E4, BIDI_L   },  // LISU LETTER ZA
  { 0xA4E5, BIDI_L   },  // LISU LETTER NGA
  { 0xA4E6, BIDI_L   },  // LISU LETTER HA
  { 0xA4E7, BIDI_L   },  // LISU LETTER XA
  { 0xA4E8, BIDI_L   },  // LISU LETTER HHA
  { 0xA4E9, BIDI_L   },  // LISU LETTER FA
  { 0xA4EA, BIDI_L   },  // LISU LETTER WA
  { 0xA4EB, BIDI_L   },  // LISU LETTER SHA
  { 0xA4EC, BIDI_L   },  // LISU LETTER YA
  { 0xA4ED, BIDI_L   },  // LISU LETTER GHA
  { 0xA4EE, BIDI_L   },  // LISU LETTER A
  { 0xA4EF, BIDI_L   },  // LISU LETTER AE
  { 0xA4F0, BIDI_L   },  // LISU LETTER E
  { 0xA4F1, BIDI_L   },  // LISU LETTER EU
  { 0xA4F2, BIDI_L   },  // LISU LETTER I
  { 0xA4F3, BIDI_L   },  // LISU LETTER O
  { 0xA4F4, BIDI_L   },  // LISU LETTER U
  { 0xA4F5, BIDI_L   },  // LISU LETTER UE
  { 0xA4F6, BIDI_L   },  // LISU LETTER UH
  { 0xA4F7, BIDI_L   },  // LISU LETTER OE
  { 0xA4F8, BIDI_L   },  // LISU LETTER TONE MYA TI
  { 0xA4F9, BIDI_L   },  // LISU LETTER TONE NA PO
  { 0xA4FA, BIDI_L   },  // LISU LETTER TONE MYA CYA
  { 0xA4FB, BIDI_L   },  // LISU LETTER TONE MYA BO
  { 0xA4FC, BIDI_L   },  // LISU LETTER TONE MYA NA
  { 0xA4FD, BIDI_L   },  // LISU LETTER TONE MYA JEU
  { 0xA4FE, BIDI_L   },  // LISU PUNCTUATION COMMA
  { 0xA4FF, BIDI_L   },  // LISU PUNCTUATION FULL STOP
  { 0xA500, BIDI_L   },  // VAI SYLLABLE EE
  { 0xA501, BIDI_L   },  // VAI SYLLABLE EEN
  { 0xA502, BIDI_L   },  // VAI SYLLABLE HEE
  { 0xA503, BIDI_L   },  // VAI SYLLABLE WEE
  { 0xA504, BIDI_L   },  // VAI SYLLABLE WEEN
  { 0xA505, BIDI_L   },  // VAI SYLLABLE PEE
  { 0xA506, BIDI_L   },  // VAI SYLLABLE BHEE
  { 0xA507, BIDI_L   },  // VAI SYLLABLE BEE
  { 0xA508, BIDI_L   },  // VAI SYLLABLE MBEE
  { 0xA509, BIDI_L   },  // VAI SYLLABLE KPEE
  { 0xA50A, BIDI_L   },  // VAI SYLLABLE MGBEE
  { 0xA50B, BIDI_L   },  // VAI SYLLABLE GBEE
  { 0xA50C, BIDI_L   },  // VAI SYLLABLE FEE
  { 0xA50D, BIDI_L   },  // VAI SYLLABLE VEE
  { 0xA50E, BIDI_L   },  // VAI SYLLABLE TEE
  { 0xA50F, BIDI_L   },  // VAI SYLLABLE THEE
  { 0xA510, BIDI_L   },  // VAI SYLLABLE DHEE
  { 0xA511, BIDI_L   },  // VAI SYLLABLE DHHEE
  { 0xA512, BIDI_L   },  // VAI SYLLABLE LEE
  { 0xA513, BIDI_L   },  // VAI SYLLABLE REE
  { 0xA514, BIDI_L   },  // VAI SYLLABLE DEE
  { 0xA515, BIDI_L   },  // VAI SYLLABLE NDEE
  { 0xA516, BIDI_L   },  // VAI SYLLABLE SEE
  { 0xA517, BIDI_L   },  // VAI SYLLABLE SHEE
  { 0xA518, BIDI_L   },  // VAI SYLLABLE ZEE
  { 0xA519, BIDI_L   },  // VAI SYLLABLE ZHEE
  { 0xA51A, BIDI_L   },  // VAI SYLLABLE CEE
  { 0xA51B, BIDI_L   },  // VAI SYLLABLE JEE
  { 0xA51C, BIDI_L   },  // VAI SYLLABLE NJEE
  { 0xA51D, BIDI_L   },  // VAI SYLLABLE YEE
  { 0xA51E, BIDI_L   },  // VAI SYLLABLE KEE
  { 0xA51F, BIDI_L   },  // VAI SYLLABLE NGGEE
  { 0xA520, BIDI_L   },  // VAI SYLLABLE GEE
  { 0xA521, BIDI_L   },  // VAI SYLLABLE MEE
  { 0xA522, BIDI_L   },  // VAI SYLLABLE NEE
  { 0xA523, BIDI_L   },  // VAI SYLLABLE NYEE
  { 0xA524, BIDI_L   },  // VAI SYLLABLE I
  { 0xA525, BIDI_L   },  // VAI SYLLABLE IN
  { 0xA526, BIDI_L   },  // VAI SYLLABLE HI
  { 0xA527, BIDI_L   },  // VAI SYLLABLE HIN
  { 0xA528, BIDI_L   },  // VAI SYLLABLE WI
  { 0xA529, BIDI_L   },  // VAI SYLLABLE WIN
  { 0xA52A, BIDI_L   },  // VAI SYLLABLE PI
  { 0xA52B, BIDI_L   },  // VAI SYLLABLE BHI
  { 0xA52C, BIDI_L   },  // VAI SYLLABLE BI
  { 0xA52D, BIDI_L   },  // VAI SYLLABLE MBI
  { 0xA52E, BIDI_L   },  // VAI SYLLABLE KPI
  { 0xA52F, BIDI_L   },  // VAI SYLLABLE MGBI
  { 0xA530, BIDI_L   },  // VAI SYLLABLE GBI
  { 0xA531, BIDI_L   },  // VAI SYLLABLE FI
  { 0xA532, BIDI_L   },  // VAI SYLLABLE VI
  { 0xA533, BIDI_L   },  // VAI SYLLABLE TI
  { 0xA534, BIDI_L   },  // VAI SYLLABLE THI
  { 0xA535, BIDI_L   },  // VAI SYLLABLE DHI
  { 0xA536, BIDI_L   },  // VAI SYLLABLE DHHI
  { 0xA537, BIDI_L   },  // VAI SYLLABLE LI
  { 0xA538, BIDI_L   },  // VAI SYLLABLE RI
  { 0xA539, BIDI_L   },  // VAI SYLLABLE DI
  { 0xA53A, BIDI_L   },  // VAI SYLLABLE NDI
  { 0xA53B, BIDI_L   },  // VAI SYLLABLE SI
  { 0xA53C, BIDI_L   },  // VAI SYLLABLE SHI
  { 0xA53D, BIDI_L   },  // VAI SYLLABLE ZI
  { 0xA53E, BIDI_L   },  // VAI SYLLABLE ZHI
  { 0xA53F, BIDI_L   },  // VAI SYLLABLE CI
  { 0xA540, BIDI_L   },  // VAI SYLLABLE JI
  { 0xA541, BIDI_L   },  // VAI SYLLABLE NJI
  { 0xA542, BIDI_L   },  // VAI SYLLABLE YI
  { 0xA543, BIDI_L   },  // VAI SYLLABLE KI
  { 0xA544, BIDI_L   },  // VAI SYLLABLE NGGI
  { 0xA545, BIDI_L   },  // VAI SYLLABLE GI
  { 0xA546, BIDI_L   },  // VAI SYLLABLE MI
  { 0xA547, BIDI_L   },  // VAI SYLLABLE NI
  { 0xA548, BIDI_L   },  // VAI SYLLABLE NYI
  { 0xA549, BIDI_L   },  // VAI SYLLABLE A
  { 0xA54A, BIDI_L   },  // VAI SYLLABLE AN
  { 0xA54B, BIDI_L   },  // VAI SYLLABLE NGAN
  { 0xA54C, BIDI_L   },  // VAI SYLLABLE HA
  { 0xA54D, BIDI_L   },  // VAI SYLLABLE HAN
  { 0xA54E, BIDI_L   },  // VAI SYLLABLE WA
  { 0xA54F, BIDI_L   },  // VAI SYLLABLE WAN
  { 0xA550, BIDI_L   },  // VAI SYLLABLE PA
  { 0xA551, BIDI_L   },  // VAI SYLLABLE BHA
  { 0xA552, BIDI_L   },  // VAI SYLLABLE BA
  { 0xA553, BIDI_L   },  // VAI SYLLABLE MBA
  { 0xA554, BIDI_L   },  // VAI SYLLABLE KPA
  { 0xA555, BIDI_L   },  // VAI SYLLABLE KPAN
  { 0xA556, BIDI_L   },  // VAI SYLLABLE MGBA
  { 0xA557, BIDI_L   },  // VAI SYLLABLE GBA
  { 0xA558, BIDI_L   },  // VAI SYLLABLE FA
  { 0xA559, BIDI_L   },  // VAI SYLLABLE VA
  { 0xA55A, BIDI_L   },  // VAI SYLLABLE TA
  { 0xA55B, BIDI_L   },  // VAI SYLLABLE THA
  { 0xA55C, BIDI_L   },  // VAI SYLLABLE DHA
  { 0xA55D, BIDI_L   },  // VAI SYLLABLE DHHA
  { 0xA55E, BIDI_L   },  // VAI SYLLABLE LA
  { 0xA55F, BIDI_L   },  // VAI SYLLABLE RA
  { 0xA560, BIDI_L   },  // VAI SYLLABLE DA
  { 0xA561, BIDI_L   },  // VAI SYLLABLE NDA
  { 0xA562, BIDI_L   },  // VAI SYLLABLE SA
  { 0xA563, BIDI_L   },  // VAI SYLLABLE SHA
  { 0xA564, BIDI_L   },  // VAI SYLLABLE ZA
  { 0xA565, BIDI_L   },  // VAI SYLLABLE ZHA
  { 0xA566, BIDI_L   },  // VAI SYLLABLE CA
  { 0xA567, BIDI_L   },  // VAI SYLLABLE JA
  { 0xA568, BIDI_L   },  // VAI SYLLABLE NJA
  { 0xA569, BIDI_L   },  // VAI SYLLABLE YA
  { 0xA56A, BIDI_L   },  // VAI SYLLABLE KA
  { 0xA56B, BIDI_L   },  // VAI SYLLABLE KAN
  { 0xA56C, BIDI_L   },  // VAI SYLLABLE NGGA
  { 0xA56D, BIDI_L   },  // VAI SYLLABLE GA
  { 0xA56E, BIDI_L   },  // VAI SYLLABLE MA
  { 0xA56F, BIDI_L   },  // VAI SYLLABLE NA
  { 0xA570, BIDI_L   },  // VAI SYLLABLE NYA
  { 0xA571, BIDI_L   },  // VAI SYLLABLE OO
  { 0xA572, BIDI_L   },  // VAI SYLLABLE OON
  { 0xA573, BIDI_L   },  // VAI SYLLABLE HOO
  { 0xA574, BIDI_L   },  // VAI SYLLABLE WOO
  { 0xA575, BIDI_L   },  // VAI SYLLABLE WOON
  { 0xA576, BIDI_L   },  // VAI SYLLABLE POO
  { 0xA577, BIDI_L   },  // VAI SYLLABLE BHOO
  { 0xA578, BIDI_L   },  // VAI SYLLABLE BOO
  { 0xA579, BIDI_L   },  // VAI SYLLABLE MBOO
  { 0xA57A, BIDI_L   },  // VAI SYLLABLE KPOO
  { 0xA57B, BIDI_L   },  // VAI SYLLABLE MGBOO
  { 0xA57C, BIDI_L   },  // VAI SYLLABLE GBOO
  { 0xA57D, BIDI_L   },  // VAI SYLLABLE FOO
  { 0xA57E, BIDI_L   },  // VAI SYLLABLE VOO
  { 0xA57F, BIDI_L   },  // VAI SYLLABLE TOO
  { 0xA580, BIDI_L   },  // VAI SYLLABLE THOO
  { 0xA581, BIDI_L   },  // VAI SYLLABLE DHOO
  { 0xA582, BIDI_L   },  // VAI SYLLABLE DHHOO
  { 0xA583, BIDI_L   },  // VAI SYLLABLE LOO
  { 0xA584, BIDI_L   },  // VAI SYLLABLE ROO
  { 0xA585, BIDI_L   },  // VAI SYLLABLE DOO
  { 0xA586, BIDI_L   },  // VAI SYLLABLE NDOO
  { 0xA587, BIDI_L   },  // VAI SYLLABLE SOO
  { 0xA588, BIDI_L   },  // VAI SYLLABLE SHOO
  { 0xA589, BIDI_L   },  // VAI SYLLABLE ZOO
  { 0xA58A, BIDI_L   },  // VAI SYLLABLE ZHOO
  { 0xA58B, BIDI_L   },  // VAI SYLLABLE COO
  { 0xA58C, BIDI_L   },  // VAI SYLLABLE JOO
  { 0xA58D, BIDI_L   },  // VAI SYLLABLE NJOO
  { 0xA58E, BIDI_L   },  // VAI SYLLABLE YOO
  { 0xA58F, BIDI_L   },  // VAI SYLLABLE KOO
  { 0xA590, BIDI_L   },  // VAI SYLLABLE NGGOO
  { 0xA591, BIDI_L   },  // VAI SYLLABLE GOO
  { 0xA592, BIDI_L   },  // VAI SYLLABLE MOO
  { 0xA593, BIDI_L   },  // VAI SYLLABLE NOO
  { 0xA594, BIDI_L   },  // VAI SYLLABLE NYOO
  { 0xA595, BIDI_L   },  // VAI SYLLABLE U
  { 0xA596, BIDI_L   },  // VAI SYLLABLE UN
  { 0xA597, BIDI_L   },  // VAI SYLLABLE HU
  { 0xA598, BIDI_L   },  // VAI SYLLABLE HUN
  { 0xA599, BIDI_L   },  // VAI SYLLABLE WU
  { 0xA59A, BIDI_L   },  // VAI SYLLABLE WUN
  { 0xA59B, BIDI_L   },  // VAI SYLLABLE PU
  { 0xA59C, BIDI_L   },  // VAI SYLLABLE BHU
  { 0xA59D, BIDI_L   },  // VAI SYLLABLE BU
  { 0xA59E, BIDI_L   },  // VAI SYLLABLE MBU
  { 0xA59F, BIDI_L   },  // VAI SYLLABLE KPU
  { 0xA5A0, BIDI_L   },  // VAI SYLLABLE MGBU
  { 0xA5A1, BIDI_L   },  // VAI SYLLABLE GBU
  { 0xA5A2, BIDI_L   },  // VAI SYLLABLE FU
  { 0xA5A3, BIDI_L   },  // VAI SYLLABLE VU
  { 0xA5A4, BIDI_L   },  // VAI SYLLABLE TU
  { 0xA5A5, BIDI_L   },  // VAI SYLLABLE THU
  { 0xA5A6, BIDI_L   },  // VAI SYLLABLE DHU
  { 0xA5A7, BIDI_L   },  // VAI SYLLABLE DHHU
  { 0xA5A8, BIDI_L   },  // VAI SYLLABLE LU
  { 0xA5A9, BIDI_L   },  // VAI SYLLABLE RU
  { 0xA5AA, BIDI_L   },  // VAI SYLLABLE DU
  { 0xA5AB, BIDI_L   },  // VAI SYLLABLE NDU
  { 0xA5AC, BIDI_L   },  // VAI SYLLABLE SU
  { 0xA5AD, BIDI_L   },  // VAI SYLLABLE SHU
  { 0xA5AE, BIDI_L   },  // VAI SYLLABLE ZU
  { 0xA5AF, BIDI_L   },  // VAI SYLLABLE ZHU
  { 0xA5B0, BIDI_L   },  // VAI SYLLABLE CU
  { 0xA5B1, BIDI_L   },  // VAI SYLLABLE JU
  { 0xA5B2, BIDI_L   },  // VAI SYLLABLE NJU
  { 0xA5B3, BIDI_L   },  // VAI SYLLABLE YU
  { 0xA5B4, BIDI_L   },  // VAI SYLLABLE KU
  { 0xA5B5, BIDI_L   },  // VAI SYLLABLE NGGU
  { 0xA5B6, BIDI_L   },  // VAI SYLLABLE GU
  { 0xA5B7, BIDI_L   },  // VAI SYLLABLE MU
  { 0xA5B8, BIDI_L   },  // VAI SYLLABLE NU
  { 0xA5B9, BIDI_L   },  // VAI SYLLABLE NYU
  { 0xA5BA, BIDI_L   },  // VAI SYLLABLE O
  { 0xA5BB, BIDI_L   },  // VAI SYLLABLE ON
  { 0xA5BC, BIDI_L   },  // VAI SYLLABLE NGON
  { 0xA5BD, BIDI_L   },  // VAI SYLLABLE HO
  { 0xA5BE, BIDI_L   },  // VAI SYLLABLE HON
  { 0xA5BF, BIDI_L   },  // VAI SYLLABLE WO
  { 0xA5C0, BIDI_L   },  // VAI SYLLABLE WON
  { 0xA5C1, BIDI_L   },  // VAI SYLLABLE PO
  { 0xA5C2, BIDI_L   },  // VAI SYLLABLE BHO
  { 0xA5C3, BIDI_L   },  // VAI SYLLABLE BO
  { 0xA5C4, BIDI_L   },  // VAI SYLLABLE MBO
  { 0xA5C5, BIDI_L   },  // VAI SYLLABLE KPO
  { 0xA5C6, BIDI_L   },  // VAI SYLLABLE MGBO
  { 0xA5C7, BIDI_L   },  // VAI SYLLABLE GBO
  { 0xA5C8, BIDI_L   },  // VAI SYLLABLE GBON
  { 0xA5C9, BIDI_L   },  // VAI SYLLABLE FO
  { 0xA5CA, BIDI_L   },  // VAI SYLLABLE VO
  { 0xA5CB, BIDI_L   },  // VAI SYLLABLE TO
  { 0xA5CC, BIDI_L   },  // VAI SYLLABLE THO
  { 0xA5CD, BIDI_L   },  // VAI SYLLABLE DHO
  { 0xA5CE, BIDI_L   },  // VAI SYLLABLE DHHO
  { 0xA5CF, BIDI_L   },  // VAI SYLLABLE LO
  { 0xA5D0, BIDI_L   },  // VAI SYLLABLE RO
  { 0xA5D1, BIDI_L   },  // VAI SYLLABLE DO
  { 0xA5D2, BIDI_L   },  // VAI SYLLABLE NDO
  { 0xA5D3, BIDI_L   },  // VAI SYLLABLE SO
  { 0xA5D4, BIDI_L   },  // VAI SYLLABLE SHO
  { 0xA5D5, BIDI_L   },  // VAI SYLLABLE ZO
  { 0xA5D6, BIDI_L   },  // VAI SYLLABLE ZHO
  { 0xA5D7, BIDI_L   },  // VAI SYLLABLE CO
  { 0xA5D8, BIDI_L   },  // VAI SYLLABLE JO
  { 0xA5D9, BIDI_L   },  // VAI SYLLABLE NJO
  { 0xA5DA, BIDI_L   },  // VAI SYLLABLE YO
  { 0xA5DB, BIDI_L   },  // VAI SYLLABLE KO
  { 0xA5DC, BIDI_L   },  // VAI SYLLABLE NGGO
  { 0xA5DD, BIDI_L   },  // VAI SYLLABLE GO
  { 0xA5DE, BIDI_L   },  // VAI SYLLABLE MO
  { 0xA5DF, BIDI_L   },  // VAI SYLLABLE NO
  { 0xA5E0, BIDI_L   },  // VAI SYLLABLE NYO
  { 0xA5E1, BIDI_L   },  // VAI SYLLABLE E
  { 0xA5E2, BIDI_L   },  // VAI SYLLABLE EN
  { 0xA5E3, BIDI_L   },  // VAI SYLLABLE NGEN
  { 0xA5E4, BIDI_L   },  // VAI SYLLABLE HE
  { 0xA5E5, BIDI_L   },  // VAI SYLLABLE HEN
  { 0xA5E6, BIDI_L   },  // VAI SYLLABLE WE
  { 0xA5E7, BIDI_L   },  // VAI SYLLABLE WEN
  { 0xA5E8, BIDI_L   },  // VAI SYLLABLE PE
  { 0xA5E9, BIDI_L   },  // VAI SYLLABLE BHE
  { 0xA5EA, BIDI_L   },  // VAI SYLLABLE BE
  { 0xA5EB, BIDI_L   },  // VAI SYLLABLE MBE
  { 0xA5EC, BIDI_L   },  // VAI SYLLABLE KPE
  { 0xA5ED, BIDI_L   },  // VAI SYLLABLE KPEN
  { 0xA5EE, BIDI_L   },  // VAI SYLLABLE MGBE
  { 0xA5EF, BIDI_L   },  // VAI SYLLABLE GBE
  { 0xA5F0, BIDI_L   },  // VAI SYLLABLE GBEN
  { 0xA5F1, BIDI_L   },  // VAI SYLLABLE FE
  { 0xA5F2, BIDI_L   },  // VAI SYLLABLE VE
  { 0xA5F3, BIDI_L   },  // VAI SYLLABLE TE
  { 0xA5F4, BIDI_L   },  // VAI SYLLABLE THE
  { 0xA5F5, BIDI_L   },  // VAI SYLLABLE DHE
  { 0xA5F6, BIDI_L   },  // VAI SYLLABLE DHHE
  { 0xA5F7, BIDI_L   },  // VAI SYLLABLE LE
  { 0xA5F8, BIDI_L   },  // VAI SYLLABLE RE
  { 0xA5F9, BIDI_L   },  // VAI SYLLABLE DE
  { 0xA5FA, BIDI_L   },  // VAI SYLLABLE NDE
  { 0xA5FB, BIDI_L   },  // VAI SYLLABLE SE
  { 0xA5FC, BIDI_L   },  // VAI SYLLABLE SHE
  { 0xA5FD, BIDI_L   },  // VAI SYLLABLE ZE
  { 0xA5FE, BIDI_L   },  // VAI SYLLABLE ZHE
  { 0xA5FF, BIDI_L   },  // VAI SYLLABLE CE
  { 0xA600, BIDI_L   },  // VAI SYLLABLE JE
  { 0xA601, BIDI_L   },  // VAI SYLLABLE NJE
  { 0xA602, BIDI_L   },  // VAI SYLLABLE YE
  { 0xA603, BIDI_L   },  // VAI SYLLABLE KE
  { 0xA604, BIDI_L   },  // VAI SYLLABLE NGGE
  { 0xA605, BIDI_L   },  // VAI SYLLABLE NGGEN
  { 0xA606, BIDI_L   },  // VAI SYLLABLE GE
  { 0xA607, BIDI_L   },  // VAI SYLLABLE GEN
  { 0xA608, BIDI_L   },  // VAI SYLLABLE ME
  { 0xA609, BIDI_L   },  // VAI SYLLABLE NE
  { 0xA60A, BIDI_L   },  // VAI SYLLABLE NYE
  { 0xA60B, BIDI_L   },  // VAI SYLLABLE NG
  { 0xA60C, BIDI_L   },  // VAI SYLLABLE LENGTHENER
  { 0xA60D, BIDI_ON  },  // VAI COMMA
  { 0xA60E, BIDI_ON  },  // VAI FULL STOP
  { 0xA60F, BIDI_ON  },  // VAI QUESTION MARK
  { 0xA610, BIDI_L   },  // VAI SYLLABLE NDOLE FA
  { 0xA611, BIDI_L   },  // VAI SYLLABLE NDOLE KA
  { 0xA612, BIDI_L   },  // VAI SYLLABLE NDOLE SOO
  { 0xA613, BIDI_L   },  // VAI SYMBOL FEENG
  { 0xA614, BIDI_L   },  // VAI SYMBOL KEENG
  { 0xA615, BIDI_L   },  // VAI SYMBOL TING
  { 0xA616, BIDI_L   },  // VAI SYMBOL NII
  { 0xA617, BIDI_L   },  // VAI SYMBOL BANG
  { 0xA618, BIDI_L   },  // VAI SYMBOL FAA
  { 0xA619, BIDI_L   },  // VAI SYMBOL TAA
  { 0xA61A, BIDI_L   },  // VAI SYMBOL DANG
  { 0xA61B, BIDI_L   },  // VAI SYMBOL DOONG
  { 0xA61C, BIDI_L   },  // VAI SYMBOL KUNG
  { 0xA61D, BIDI_L   },  // VAI SYMBOL TONG
  { 0xA61E, BIDI_L   },  // VAI SYMBOL DO-O
  { 0xA61F, BIDI_L   },  // VAI SYMBOL JONG
  { 0xA620, BIDI_L   },  // VAI DIGIT ZERO
  { 0xA621, BIDI_L   },  // VAI DIGIT ONE
  { 0xA622, BIDI_L   },  // VAI DIGIT TWO
  { 0xA623, BIDI_L   },  // VAI DIGIT THREE
  { 0xA624, BIDI_L   },  // VAI DIGIT FOUR
  { 0xA625, BIDI_L   },  // VAI DIGIT FIVE
  { 0xA626, BIDI_L   },  // VAI DIGIT SIX
  { 0xA627, BIDI_L   },  // VAI DIGIT SEVEN
  { 0xA628, BIDI_L   },  // VAI DIGIT EIGHT
  { 0xA629, BIDI_L   },  // VAI DIGIT NINE
  { 0xA62A, BIDI_L   },  // VAI SYLLABLE NDOLE MA
  { 0xA62B, BIDI_L   },  // VAI SYLLABLE NDOLE DO
  { 0xA640, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZEMLYA
  { 0xA641, BIDI_L   },  // CYRILLIC SMALL LETTER ZEMLYA
  { 0xA642, BIDI_L   },  // CYRILLIC CAPITAL LETTER DZELO
  { 0xA643, BIDI_L   },  // CYRILLIC SMALL LETTER DZELO
  { 0xA644, BIDI_L   },  // CYRILLIC CAPITAL LETTER REVERSED DZE
  { 0xA645, BIDI_L   },  // CYRILLIC SMALL LETTER REVERSED DZE
  { 0xA646, BIDI_L   },  // CYRILLIC CAPITAL LETTER IOTA
  { 0xA647, BIDI_L   },  // CYRILLIC SMALL LETTER IOTA
  { 0xA648, BIDI_L   },  // CYRILLIC CAPITAL LETTER DJERV
  { 0xA649, BIDI_L   },  // CYRILLIC SMALL LETTER DJERV
  { 0xA64A, BIDI_L   },  // CYRILLIC CAPITAL LETTER MONOGRAPH UK
  { 0xA64B, BIDI_L   },  // CYRILLIC SMALL LETTER MONOGRAPH UK
  { 0xA64C, BIDI_L   },  // CYRILLIC CAPITAL LETTER BROAD OMEGA
  { 0xA64D, BIDI_L   },  // CYRILLIC SMALL LETTER BROAD OMEGA
  { 0xA64E, BIDI_L   },  // CYRILLIC CAPITAL LETTER NEUTRAL YER
  { 0xA64F, BIDI_L   },  // CYRILLIC SMALL LETTER NEUTRAL YER
  { 0xA650, BIDI_L   },  // CYRILLIC CAPITAL LETTER YERU WITH BACK YER
  { 0xA651, BIDI_L   },  // CYRILLIC SMALL LETTER YERU WITH BACK YER
  { 0xA652, BIDI_L   },  // CYRILLIC CAPITAL LETTER IOTIFIED YAT
  { 0xA653, BIDI_L   },  // CYRILLIC SMALL LETTER IOTIFIED YAT
  { 0xA654, BIDI_L   },  // CYRILLIC CAPITAL LETTER REVERSED YU
  { 0xA655, BIDI_L   },  // CYRILLIC SMALL LETTER REVERSED YU
  { 0xA656, BIDI_L   },  // CYRILLIC CAPITAL LETTER IOTIFIED A
  { 0xA657, BIDI_L   },  // CYRILLIC SMALL LETTER IOTIFIED A
  { 0xA658, BIDI_L   },  // CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
  { 0xA659, BIDI_L   },  // CYRILLIC SMALL LETTER CLOSED LITTLE YUS
  { 0xA65A, BIDI_L   },  // CYRILLIC CAPITAL LETTER BLENDED YUS
  { 0xA65B, BIDI_L   },  // CYRILLIC SMALL LETTER BLENDED YUS
  { 0xA65C, BIDI_L   },  // CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
  { 0xA65D, BIDI_L   },  // CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS
  { 0xA65E, BIDI_L   },  // CYRILLIC CAPITAL LETTER YN
  { 0xA65F, BIDI_L   },  // CYRILLIC SMALL LETTER YN
  { 0xA660, BIDI_L   },  // CYRILLIC CAPITAL LETTER REVERSED TSE
  { 0xA661, BIDI_L   },  // CYRILLIC SMALL LETTER REVERSED TSE
  { 0xA662, BIDI_L   },  // CYRILLIC CAPITAL LETTER SOFT DE
  { 0xA663, BIDI_L   },  // CYRILLIC SMALL LETTER SOFT DE
  { 0xA664, BIDI_L   },  // CYRILLIC CAPITAL LETTER SOFT EL
  { 0xA665, BIDI_L   },  // CYRILLIC SMALL LETTER SOFT EL
  { 0xA666, BIDI_L   },  // CYRILLIC CAPITAL LETTER SOFT EM
  { 0xA667, BIDI_L   },  // CYRILLIC SMALL LETTER SOFT EM
  { 0xA668, BIDI_L   },  // CYRILLIC CAPITAL LETTER MONOCULAR O
  { 0xA669, BIDI_L   },  // CYRILLIC SMALL LETTER MONOCULAR O
  { 0xA66A, BIDI_L   },  // CYRILLIC CAPITAL LETTER BINOCULAR O
  { 0xA66B, BIDI_L   },  // CYRILLIC SMALL LETTER BINOCULAR O
  { 0xA66C, BIDI_L   },  // CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
  { 0xA66D, BIDI_L   },  // CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
  { 0xA66E, BIDI_L   },  // CYRILLIC LETTER MULTIOCULAR O
  { 0xA66F, BIDI_NSM },  // COMBINING CYRILLIC VZMET
  { 0xA670, BIDI_NSM },  // COMBINING CYRILLIC TEN MILLIONS SIGN
  { 0xA671, BIDI_NSM },  // COMBINING CYRILLIC HUNDRED MILLIONS SIGN
  { 0xA672, BIDI_NSM },  // COMBINING CYRILLIC THOUSAND MILLIONS SIGN
  { 0xA673, BIDI_ON  },  // SLAVONIC ASTERISK
  { 0xA674, BIDI_NSM },  // COMBINING CYRILLIC LETTER UKRAINIAN IE
  { 0xA675, BIDI_NSM },  // COMBINING CYRILLIC LETTER I
  { 0xA676, BIDI_NSM },  // COMBINING CYRILLIC LETTER YI
  { 0xA677, BIDI_NSM },  // COMBINING CYRILLIC LETTER U
  { 0xA678, BIDI_NSM },  // COMBINING CYRILLIC LETTER HARD SIGN
  { 0xA679, BIDI_NSM },  // COMBINING CYRILLIC LETTER YERU
  { 0xA67A, BIDI_NSM },  // COMBINING CYRILLIC LETTER SOFT SIGN
  { 0xA67B, BIDI_NSM },  // COMBINING CYRILLIC LETTER OMEGA
  { 0xA67C, BIDI_NSM },  // COMBINING CYRILLIC KAVYKA
  { 0xA67D, BIDI_NSM },  // COMBINING CYRILLIC PAYEROK
  { 0xA67E, BIDI_ON  },  // CYRILLIC KAVYKA
  { 0xA67F, BIDI_ON  },  // CYRILLIC PAYEROK
  { 0xA680, BIDI_L   },  // CYRILLIC CAPITAL LETTER DWE
  { 0xA681, BIDI_L   },  // CYRILLIC SMALL LETTER DWE
  { 0xA682, BIDI_L   },  // CYRILLIC CAPITAL LETTER DZWE
  { 0xA683, BIDI_L   },  // CYRILLIC SMALL LETTER DZWE
  { 0xA684, BIDI_L   },  // CYRILLIC CAPITAL LETTER ZHWE
  { 0xA685, BIDI_L   },  // CYRILLIC SMALL LETTER ZHWE
  { 0xA686, BIDI_L   },  // CYRILLIC CAPITAL LETTER CCHE
  { 0xA687, BIDI_L   },  // CYRILLIC SMALL LETTER CCHE
  { 0xA688, BIDI_L   },  // CYRILLIC CAPITAL LETTER DZZE
  { 0xA689, BIDI_L   },  // CYRILLIC SMALL LETTER DZZE
  { 0xA68A, BIDI_L   },  // CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
  { 0xA68B, BIDI_L   },  // CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK
  { 0xA68C, BIDI_L   },  // CYRILLIC CAPITAL LETTER TWE
  { 0xA68D, BIDI_L   },  // CYRILLIC SMALL LETTER TWE
  { 0xA68E, BIDI_L   },  // CYRILLIC CAPITAL LETTER TSWE
  { 0xA68F, BIDI_L   },  // CYRILLIC SMALL LETTER TSWE
  { 0xA690, BIDI_L   },  // CYRILLIC CAPITAL LETTER TSSE
  { 0xA691, BIDI_L   },  // CYRILLIC SMALL LETTER TSSE
  { 0xA692, BIDI_L   },  // CYRILLIC CAPITAL LETTER TCHE
  { 0xA693, BIDI_L   },  // CYRILLIC SMALL LETTER TCHE
  { 0xA694, BIDI_L   },  // CYRILLIC CAPITAL LETTER HWE
  { 0xA695, BIDI_L   },  // CYRILLIC SMALL LETTER HWE
  { 0xA696, BIDI_L   },  // CYRILLIC CAPITAL LETTER SHWE
  { 0xA697, BIDI_L   },  // CYRILLIC SMALL LETTER SHWE
  { 0xA698, BIDI_L   },  // CYRILLIC CAPITAL LETTER DOUBLE O
  { 0xA699, BIDI_L   },  // CYRILLIC SMALL LETTER DOUBLE O
  { 0xA69A, BIDI_L   },  // CYRILLIC CAPITAL LETTER CROSSED O
  { 0xA69B, BIDI_L   },  // CYRILLIC SMALL LETTER CROSSED O
  { 0xA69C, BIDI_L   },  // MODIFIER LETTER CYRILLIC HARD SIGN
  { 0xA69D, BIDI_L   },  // MODIFIER LETTER CYRILLIC SOFT SIGN
  { 0xA69E, BIDI_NSM },  // COMBINING CYRILLIC LETTER EF
  { 0xA69F, BIDI_NSM },  // COMBINING CYRILLIC LETTER IOTIFIED E
  { 0xA6A0, BIDI_L   },  // BAMUM LETTER A
  { 0xA6A1, BIDI_L   },  // BAMUM LETTER KA
  { 0xA6A2, BIDI_L   },  // BAMUM LETTER U
  { 0xA6A3, BIDI_L   },  // BAMUM LETTER KU
  { 0xA6A4, BIDI_L   },  // BAMUM LETTER EE
  { 0xA6A5, BIDI_L   },  // BAMUM LETTER REE
  { 0xA6A6, BIDI_L   },  // BAMUM LETTER TAE
  { 0xA6A7, BIDI_L   },  // BAMUM LETTER O
  { 0xA6A8, BIDI_L   },  // BAMUM LETTER NYI
  { 0xA6A9, BIDI_L   },  // BAMUM LETTER I
  { 0xA6AA, BIDI_L   },  // BAMUM LETTER LA
  { 0xA6AB, BIDI_L   },  // BAMUM LETTER PA
  { 0xA6AC, BIDI_L   },  // BAMUM LETTER RII
  { 0xA6AD, BIDI_L   },  // BAMUM LETTER RIEE
  { 0xA6AE, BIDI_L   },  // BAMUM LETTER LEEEE
  { 0xA6AF, BIDI_L   },  // BAMUM LETTER MEEEE
  { 0xA6B0, BIDI_L   },  // BAMUM LETTER TAA
  { 0xA6B1, BIDI_L   },  // BAMUM LETTER NDAA
  { 0xA6B2, BIDI_L   },  // BAMUM LETTER NJAEM
  { 0xA6B3, BIDI_L   },  // BAMUM LETTER M
  { 0xA6B4, BIDI_L   },  // BAMUM LETTER SUU
  { 0xA6B5, BIDI_L   },  // BAMUM LETTER MU
  { 0xA6B6, BIDI_L   },  // BAMUM LETTER SHII
  { 0xA6B7, BIDI_L   },  // BAMUM LETTER SI
  { 0xA6B8, BIDI_L   },  // BAMUM LETTER SHEUX
  { 0xA6B9, BIDI_L   },  // BAMUM LETTER SEUX
  { 0xA6BA, BIDI_L   },  // BAMUM LETTER KYEE
  { 0xA6BB, BIDI_L   },  // BAMUM LETTER KET
  { 0xA6BC, BIDI_L   },  // BAMUM LETTER NUAE
  { 0xA6BD, BIDI_L   },  // BAMUM LETTER NU
  { 0xA6BE, BIDI_L   },  // BAMUM LETTER NJUAE
  { 0xA6BF, BIDI_L   },  // BAMUM LETTER YOQ
  { 0xA6C0, BIDI_L   },  // BAMUM LETTER SHU
  { 0xA6C1, BIDI_L   },  // BAMUM LETTER YUQ
  { 0xA6C2, BIDI_L   },  // BAMUM LETTER YA
  { 0xA6C3, BIDI_L   },  // BAMUM LETTER NSHA
  { 0xA6C4, BIDI_L   },  // BAMUM LETTER KEUX
  { 0xA6C5, BIDI_L   },  // BAMUM LETTER PEUX
  { 0xA6C6, BIDI_L   },  // BAMUM LETTER NJEE
  { 0xA6C7, BIDI_L   },  // BAMUM LETTER NTEE
  { 0xA6C8, BIDI_L   },  // BAMUM LETTER PUE
  { 0xA6C9, BIDI_L   },  // BAMUM LETTER WUE
  { 0xA6CA, BIDI_L   },  // BAMUM LETTER PEE
  { 0xA6CB, BIDI_L   },  // BAMUM LETTER FEE
  { 0xA6CC, BIDI_L   },  // BAMUM LETTER RU
  { 0xA6CD, BIDI_L   },  // BAMUM LETTER LU
  { 0xA6CE, BIDI_L   },  // BAMUM LETTER MI
  { 0xA6CF, BIDI_L   },  // BAMUM LETTER NI
  { 0xA6D0, BIDI_L   },  // BAMUM LETTER REUX
  { 0xA6D1, BIDI_L   },  // BAMUM LETTER RAE
  { 0xA6D2, BIDI_L   },  // BAMUM LETTER KEN
  { 0xA6D3, BIDI_L   },  // BAMUM LETTER NGKWAEN
  { 0xA6D4, BIDI_L   },  // BAMUM LETTER NGGA
  { 0xA6D5, BIDI_L   },  // BAMUM LETTER NGA
  { 0xA6D6, BIDI_L   },  // BAMUM LETTER SHO
  { 0xA6D7, BIDI_L   },  // BAMUM LETTER PUAE
  { 0xA6D8, BIDI_L   },  // BAMUM LETTER FU
  { 0xA6D9, BIDI_L   },  // BAMUM LETTER FOM
  { 0xA6DA, BIDI_L   },  // BAMUM LETTER WA
  { 0xA6DB, BIDI_L   },  // BAMUM LETTER NA
  { 0xA6DC, BIDI_L   },  // BAMUM LETTER LI
  { 0xA6DD, BIDI_L   },  // BAMUM LETTER PI
  { 0xA6DE, BIDI_L   },  // BAMUM LETTER LOQ
  { 0xA6DF, BIDI_L   },  // BAMUM LETTER KO
  { 0xA6E0, BIDI_L   },  // BAMUM LETTER MBEN
  { 0xA6E1, BIDI_L   },  // BAMUM LETTER REN
  { 0xA6E2, BIDI_L   },  // BAMUM LETTER MEN
  { 0xA6E3, BIDI_L   },  // BAMUM LETTER MA
  { 0xA6E4, BIDI_L   },  // BAMUM LETTER TI
  { 0xA6E5, BIDI_L   },  // BAMUM LETTER KI
  { 0xA6E6, BIDI_L   },  // BAMUM LETTER MO
  { 0xA6E7, BIDI_L   },  // BAMUM LETTER MBAA
  { 0xA6E8, BIDI_L   },  // BAMUM LETTER TET
  { 0xA6E9, BIDI_L   },  // BAMUM LETTER KPA
  { 0xA6EA, BIDI_L   },  // BAMUM LETTER TEN
  { 0xA6EB, BIDI_L   },  // BAMUM LETTER NTUU
  { 0xA6EC, BIDI_L   },  // BAMUM LETTER SAMBA
  { 0xA6ED, BIDI_L   },  // BAMUM LETTER FAAMAE
  { 0xA6EE, BIDI_L   },  // BAMUM LETTER KOVUU
  { 0xA6EF, BIDI_L   },  // BAMUM LETTER KOGHOM
  { 0xA6F0, BIDI_NSM },  // BAMUM COMBINING MARK KOQNDON
  { 0xA6F1, BIDI_NSM },  // BAMUM COMBINING MARK TUKWENTIS
  { 0xA6F2, BIDI_L   },  // BAMUM NJAEMLI
  { 0xA6F3, BIDI_L   },  // BAMUM FULL STOP
  { 0xA6F4, BIDI_L   },  // BAMUM COLON
  { 0xA6F5, BIDI_L   },  // BAMUM COMMA
  { 0xA6F6, BIDI_L   },  // BAMUM SEMICOLON
  { 0xA6F7, BIDI_L   },  // BAMUM QUESTION MARK
  { 0xA700, BIDI_ON  },  // MODIFIER LETTER CHINESE TONE YIN PING
  { 0xA701, BIDI_ON  },  // MODIFIER LETTER CHINESE TONE YANG PING
  { 0xA702, BIDI_ON  },  // MODIFIER LETTER CHINESE TONE YIN SHANG
  { 0xA703, BIDI_ON  },  // MODIFIER LETTER CHINESE TONE YANG SHANG
  { 0xA704, BIDI_ON  },  // MODIFIER LETTER CHINESE TONE YIN QU
  { 0xA705, BIDI_ON  },  // MODIFIER LETTER CHINESE TONE YANG QU
  { 0xA706, BIDI_ON  },  // MODIFIER LETTER CHINESE TONE YIN RU
  { 0xA707, BIDI_ON  },  // MODIFIER LETTER CHINESE TONE YANG RU
  { 0xA708, BIDI_ON  },  // MODIFIER LETTER EXTRA-HIGH DOTTED TONE BAR
  { 0xA709, BIDI_ON  },  // MODIFIER LETTER HIGH DOTTED TONE BAR
  { 0xA70A, BIDI_ON  },  // MODIFIER LETTER MID DOTTED TONE BAR
  { 0xA70B, BIDI_ON  },  // MODIFIER LETTER LOW DOTTED TONE BAR
  { 0xA70C, BIDI_ON  },  // MODIFIER LETTER EXTRA-LOW DOTTED TONE BAR
  { 0xA70D, BIDI_ON  },  // MODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TONE BAR
  { 0xA70E, BIDI_ON  },  // MODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BAR
  { 0xA70F, BIDI_ON  },  // MODIFIER LETTER MID DOTTED LEFT-STEM TONE BAR
  { 0xA710, BIDI_ON  },  // MODIFIER LETTER LOW DOTTED LEFT-STEM TONE BAR
  { 0xA711, BIDI_ON  },  // MODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BAR
  { 0xA712, BIDI_ON  },  // MODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE BAR
  { 0xA713, BIDI_ON  },  // MODIFIER LETTER HIGH LEFT-STEM TONE BAR
  { 0xA714, BIDI_ON  },  // MODIFIER LETTER MID LEFT-STEM TONE BAR
  { 0xA715, BIDI_ON  },  // MODIFIER LETTER LOW LEFT-STEM TONE BAR
  { 0xA716, BIDI_ON  },  // MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR
  { 0xA717, BIDI_ON  },  // MODIFIER LETTER DOT VERTICAL BAR
  { 0xA718, BIDI_ON  },  // MODIFIER LETTER DOT SLASH
  { 0xA719, BIDI_ON  },  // MODIFIER LETTER DOT HORIZONTAL BAR
  { 0xA71A, BIDI_ON  },  // MODIFIER LETTER LOWER RIGHT CORNER ANGLE
  { 0xA71B, BIDI_ON  },  // MODIFIER LETTER RAISED UP ARROW
  { 0xA71C, BIDI_ON  },  // MODIFIER LETTER RAISED DOWN ARROW
  { 0xA71D, BIDI_ON  },  // MODIFIER LETTER RAISED EXCLAMATION MARK
  { 0xA71E, BIDI_ON  },  // MODIFIER LETTER RAISED INVERTED EXCLAMATION MARK
  { 0xA71F, BIDI_ON  },  // MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
  { 0xA720, BIDI_ON  },  // MODIFIER LETTER STRESS AND HIGH TONE
  { 0xA721, BIDI_ON  },  // MODIFIER LETTER STRESS AND LOW TONE
  { 0xA722, BIDI_L   },  // LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
  { 0xA723, BIDI_L   },  // LATIN SMALL LETTER EGYPTOLOGICAL ALEF
  { 0xA724, BIDI_L   },  // LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
  { 0xA725, BIDI_L   },  // LATIN SMALL LETTER EGYPTOLOGICAL AIN
  { 0xA726, BIDI_L   },  // LATIN CAPITAL LETTER HENG
  { 0xA727, BIDI_L   },  // LATIN SMALL LETTER HENG
  { 0xA728, BIDI_L   },  // LATIN CAPITAL LETTER TZ
  { 0xA729, BIDI_L   },  // LATIN SMALL LETTER TZ
  { 0xA72A, BIDI_L   },  // LATIN CAPITAL LETTER TRESILLO
  { 0xA72B, BIDI_L   },  // LATIN SMALL LETTER TRESILLO
  { 0xA72C, BIDI_L   },  // LATIN CAPITAL LETTER CUATRILLO
  { 0xA72D, BIDI_L   },  // LATIN SMALL LETTER CUATRILLO
  { 0xA72E, BIDI_L   },  // LATIN CAPITAL LETTER CUATRILLO WITH COMMA
  { 0xA72F, BIDI_L   },  // LATIN SMALL LETTER CUATRILLO WITH COMMA
  { 0xA730, BIDI_L   },  // LATIN LETTER SMALL CAPITAL F
  { 0xA731, BIDI_L   },  // LATIN LETTER SMALL CAPITAL S
  { 0xA732, BIDI_L   },  // LATIN CAPITAL LETTER AA
  { 0xA733, BIDI_L   },  // LATIN SMALL LETTER AA
  { 0xA734, BIDI_L   },  // LATIN CAPITAL LETTER AO
  { 0xA735, BIDI_L   },  // LATIN SMALL LETTER AO
  { 0xA736, BIDI_L   },  // LATIN CAPITAL LETTER AU
  { 0xA737, BIDI_L   },  // LATIN SMALL LETTER AU
  { 0xA738, BIDI_L   },  // LATIN CAPITAL LETTER AV
  { 0xA739, BIDI_L   },  // LATIN SMALL LETTER AV
  { 0xA73A, BIDI_L   },  // LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
  { 0xA73B, BIDI_L   },  // LATIN SMALL LETTER AV WITH HORIZONTAL BAR
  { 0xA73C, BIDI_L   },  // LATIN CAPITAL LETTER AY
  { 0xA73D, BIDI_L   },  // LATIN SMALL LETTER AY
  { 0xA73E, BIDI_L   },  // LATIN CAPITAL LETTER REVERSED C WITH DOT
  { 0xA73F, BIDI_L   },  // LATIN SMALL LETTER REVERSED C WITH DOT
  { 0xA740, BIDI_L   },  // LATIN CAPITAL LETTER K WITH STROKE
  { 0xA741, BIDI_L   },  // LATIN SMALL LETTER K WITH STROKE
  { 0xA742, BIDI_L   },  // LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
  { 0xA743, BIDI_L   },  // LATIN SMALL LETTER K WITH DIAGONAL STROKE
  { 0xA744, BIDI_L   },  // LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
  { 0xA745, BIDI_L   },  // LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE
  { 0xA746, BIDI_L   },  // LATIN CAPITAL LETTER BROKEN L
  { 0xA747, BIDI_L   },  // LATIN SMALL LETTER BROKEN L
  { 0xA748, BIDI_L   },  // LATIN CAPITAL LETTER L WITH HIGH STROKE
  { 0xA749, BIDI_L   },  // LATIN SMALL LETTER L WITH HIGH STROKE
  { 0xA74A, BIDI_L   },  // LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
  { 0xA74B, BIDI_L   },  // LATIN SMALL LETTER O WITH LONG STROKE OVERLAY
  { 0xA74C, BIDI_L   },  // LATIN CAPITAL LETTER O WITH LOOP
  { 0xA74D, BIDI_L   },  // LATIN SMALL LETTER O WITH LOOP
  { 0xA74E, BIDI_L   },  // LATIN CAPITAL LETTER OO
  { 0xA74F, BIDI_L   },  // LATIN SMALL LETTER OO
  { 0xA750, BIDI_L   },  // LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
  { 0xA751, BIDI_L   },  // LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER
  { 0xA752, BIDI_L   },  // LATIN CAPITAL LETTER P WITH FLOURISH
  { 0xA753, BIDI_L   },  // LATIN SMALL LETTER P WITH FLOURISH
  { 0xA754, BIDI_L   },  // LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
  { 0xA755, BIDI_L   },  // LATIN SMALL LETTER P WITH SQUIRREL TAIL
  { 0xA756, BIDI_L   },  // LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
  { 0xA757, BIDI_L   },  // LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER
  { 0xA758, BIDI_L   },  // LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
  { 0xA759, BIDI_L   },  // LATIN SMALL LETTER Q WITH DIAGONAL STROKE
  { 0xA75A, BIDI_L   },  // LATIN CAPITAL LETTER R ROTUNDA
  { 0xA75B, BIDI_L   },  // LATIN SMALL LETTER R ROTUNDA
  { 0xA75C, BIDI_L   },  // LATIN CAPITAL LETTER RUM ROTUNDA
  { 0xA75D, BIDI_L   },  // LATIN SMALL LETTER RUM ROTUNDA
  { 0xA75E, BIDI_L   },  // LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
  { 0xA75F, BIDI_L   },  // LATIN SMALL LETTER V WITH DIAGONAL STROKE
  { 0xA760, BIDI_L   },  // LATIN CAPITAL LETTER VY
  { 0xA761, BIDI_L   },  // LATIN SMALL LETTER VY
  { 0xA762, BIDI_L   },  // LATIN CAPITAL LETTER VISIGOTHIC Z
  { 0xA763, BIDI_L   },  // LATIN SMALL LETTER VISIGOTHIC Z
  { 0xA764, BIDI_L   },  // LATIN CAPITAL LETTER THORN WITH STROKE
  { 0xA765, BIDI_L   },  // LATIN SMALL LETTER THORN WITH STROKE
  { 0xA766, BIDI_L   },  // LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
  { 0xA767, BIDI_L   },  // LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER
  { 0xA768, BIDI_L   },  // LATIN CAPITAL LETTER VEND
  { 0xA769, BIDI_L   },  // LATIN SMALL LETTER VEND
  { 0xA76A, BIDI_L   },  // LATIN CAPITAL LETTER ET
  { 0xA76B, BIDI_L   },  // LATIN SMALL LETTER ET
  { 0xA76C, BIDI_L   },  // LATIN CAPITAL LETTER IS
  { 0xA76D, BIDI_L   },  // LATIN SMALL LETTER IS
  { 0xA76E, BIDI_L   },  // LATIN CAPITAL LETTER CON
  { 0xA76F, BIDI_L   },  // LATIN SMALL LETTER CON
  { 0xA770, BIDI_L   },  // MODIFIER LETTER US
  { 0xA771, BIDI_L   },  // LATIN SMALL LETTER DUM
  { 0xA772, BIDI_L   },  // LATIN SMALL LETTER LUM
  { 0xA773, BIDI_L   },  // LATIN SMALL LETTER MUM
  { 0xA774, BIDI_L   },  // LATIN SMALL LETTER NUM
  { 0xA775, BIDI_L   },  // LATIN SMALL LETTER RUM
  { 0xA776, BIDI_L   },  // LATIN LETTER SMALL CAPITAL RUM
  { 0xA777, BIDI_L   },  // LATIN SMALL LETTER TUM
  { 0xA778, BIDI_L   },  // LATIN SMALL LETTER UM
  { 0xA779, BIDI_L   },  // LATIN CAPITAL LETTER INSULAR D
  { 0xA77A, BIDI_L   },  // LATIN SMALL LETTER INSULAR D
  { 0xA77B, BIDI_L   },  // LATIN CAPITAL LETTER INSULAR F
  { 0xA77C, BIDI_L   },  // LATIN SMALL LETTER INSULAR F
  { 0xA77D, BIDI_L   },  // LATIN CAPITAL LETTER INSULAR G
  { 0xA77E, BIDI_L   },  // LATIN CAPITAL LETTER TURNED INSULAR G
  { 0xA77F, BIDI_L   },  // LATIN SMALL LETTER TURNED INSULAR G
  { 0xA780, BIDI_L   },  // LATIN CAPITAL LETTER TURNED L
  { 0xA781, BIDI_L   },  // LATIN SMALL LETTER TURNED L
  { 0xA782, BIDI_L   },  // LATIN CAPITAL LETTER INSULAR R
  { 0xA783, BIDI_L   },  // LATIN SMALL LETTER INSULAR R
  { 0xA784, BIDI_L   },  // LATIN CAPITAL LETTER INSULAR S
  { 0xA785, BIDI_L   },  // LATIN SMALL LETTER INSULAR S
  { 0xA786, BIDI_L   },  // LATIN CAPITAL LETTER INSULAR T
  { 0xA787, BIDI_L   },  // LATIN SMALL LETTER INSULAR T
  { 0xA788, BIDI_ON  },  // MODIFIER LETTER LOW CIRCUMFLEX ACCENT
  { 0xA789, BIDI_L   },  // MODIFIER LETTER COLON
  { 0xA78A, BIDI_L   },  // MODIFIER LETTER SHORT EQUALS SIGN
  { 0xA78B, BIDI_L   },  // LATIN CAPITAL LETTER SALTILLO
  { 0xA78C, BIDI_L   },  // LATIN SMALL LETTER SALTILLO
  { 0xA78D, BIDI_L   },  // LATIN CAPITAL LETTER TURNED H
  { 0xA78E, BIDI_L   },  // LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
  { 0xA78F, BIDI_L   },  // LATIN LETTER SINOLOGICAL DOT
  { 0xA790, BIDI_L   },  // LATIN CAPITAL LETTER N WITH DESCENDER
  { 0xA791, BIDI_L   },  // LATIN SMALL LETTER N WITH DESCENDER
  { 0xA792, BIDI_L   },  // LATIN CAPITAL LETTER C WITH BAR
  { 0xA793, BIDI_L   },  // LATIN SMALL LETTER C WITH BAR
  { 0xA794, BIDI_L   },  // LATIN SMALL LETTER C WITH PALATAL HOOK
  { 0xA795, BIDI_L   },  // LATIN SMALL LETTER H WITH PALATAL HOOK
  { 0xA796, BIDI_L   },  // LATIN CAPITAL LETTER B WITH FLOURISH
  { 0xA797, BIDI_L   },  // LATIN SMALL LETTER B WITH FLOURISH
  { 0xA798, BIDI_L   },  // LATIN CAPITAL LETTER F WITH STROKE
  { 0xA799, BIDI_L   },  // LATIN SMALL LETTER F WITH STROKE
  { 0xA79A, BIDI_L   },  // LATIN CAPITAL LETTER VOLAPUK AE
  { 0xA79B, BIDI_L   },  // LATIN SMALL LETTER VOLAPUK AE
  { 0xA79C, BIDI_L   },  // LATIN CAPITAL LETTER VOLAPUK OE
  { 0xA79D, BIDI_L   },  // LATIN SMALL LETTER VOLAPUK OE
  { 0xA79E, BIDI_L   },  // LATIN CAPITAL LETTER VOLAPUK UE
  { 0xA79F, BIDI_L   },  // LATIN SMALL LETTER VOLAPUK UE
  { 0xA7A0, BIDI_L   },  // LATIN CAPITAL LETTER G WITH OBLIQUE STROKE
  { 0xA7A1, BIDI_L   },  // LATIN SMALL LETTER G WITH OBLIQUE STROKE
  { 0xA7A2, BIDI_L   },  // LATIN CAPITAL LETTER K WITH OBLIQUE STROKE
  { 0xA7A3, BIDI_L   },  // LATIN SMALL LETTER K WITH OBLIQUE STROKE
  { 0xA7A4, BIDI_L   },  // LATIN CAPITAL LETTER N WITH OBLIQUE STROKE
  { 0xA7A5, BIDI_L   },  // LATIN SMALL LETTER N WITH OBLIQUE STROKE
  { 0xA7A6, BIDI_L   },  // LATIN CAPITAL LETTER R WITH OBLIQUE STROKE
  { 0xA7A7, BIDI_L   },  // LATIN SMALL LETTER R WITH OBLIQUE STROKE
  { 0xA7A8, BIDI_L   },  // LATIN CAPITAL LETTER S WITH OBLIQUE STROKE
  { 0xA7A9, BIDI_L   },  // LATIN SMALL LETTER S WITH OBLIQUE STROKE
  { 0xA7AA, BIDI_L   },  // LATIN CAPITAL LETTER H WITH HOOK
  { 0xA7AB, BIDI_L   },  // LATIN CAPITAL LETTER REVERSED OPEN E
  { 0xA7AC, BIDI_L   },  // LATIN CAPITAL LETTER SCRIPT G
  { 0xA7AD, BIDI_L   },  // LATIN CAPITAL LETTER L WITH BELT
  { 0xA7B0, BIDI_L   },  // LATIN CAPITAL LETTER TURNED K
  { 0xA7B1, BIDI_L   },  // LATIN CAPITAL LETTER TURNED T
  { 0xA7B2, BIDI_L   },  // LATIN CAPITAL LETTER J WITH CROSSED-TAIL
  { 0xA7B3, BIDI_L   },  // LATIN CAPITAL LETTER CHI
  { 0xA7B4, BIDI_L   },  // LATIN CAPITAL LETTER BETA
  { 0xA7B5, BIDI_L   },  // LATIN SMALL LETTER BETA
  { 0xA7B6, BIDI_L   },  // LATIN CAPITAL LETTER OMEGA
  { 0xA7B7, BIDI_L   },  // LATIN SMALL LETTER OMEGA
  { 0xA7F7, BIDI_L   },  // LATIN EPIGRAPHIC LETTER SIDEWAYS I
  { 0xA7F8, BIDI_L   },  // MODIFIER LETTER CAPITAL H WITH STROKE
  { 0xA7F9, BIDI_L   },  // MODIFIER LETTER SMALL LIGATURE OE
  { 0xA7FA, BIDI_L   },  // LATIN LETTER SMALL CAPITAL TURNED M
  { 0xA7FB, BIDI_L   },  // LATIN EPIGRAPHIC LETTER REVERSED F
  { 0xA7FC, BIDI_L   },  // LATIN EPIGRAPHIC LETTER REVERSED P
  { 0xA7FD, BIDI_L   },  // LATIN EPIGRAPHIC LETTER INVERTED M
  { 0xA7FE, BIDI_L   },  // LATIN EPIGRAPHIC LETTER I LONGA
  { 0xA7FF, BIDI_L   },  // LATIN EPIGRAPHIC LETTER ARCHAIC M
  { 0xA800, BIDI_L   },  // SYLOTI NAGRI LETTER A
  { 0xA801, BIDI_L   },  // SYLOTI NAGRI LETTER I
  { 0xA802, BIDI_NSM },  // SYLOTI NAGRI SIGN DVISVARA
  { 0xA803, BIDI_L   },  // SYLOTI NAGRI LETTER U
  { 0xA804, BIDI_L   },  // SYLOTI NAGRI LETTER E
  { 0xA805, BIDI_L   },  // SYLOTI NAGRI LETTER O
  { 0xA806, BIDI_NSM },  // SYLOTI NAGRI SIGN HASANTA
  { 0xA807, BIDI_L   },  // SYLOTI NAGRI LETTER KO
  { 0xA808, BIDI_L   },  // SYLOTI NAGRI LETTER KHO
  { 0xA809, BIDI_L   },  // SYLOTI NAGRI LETTER GO
  { 0xA80A, BIDI_L   },  // SYLOTI NAGRI LETTER GHO
  { 0xA80B, BIDI_NSM },  // SYLOTI NAGRI SIGN ANUSVARA
  { 0xA80C, BIDI_L   },  // SYLOTI NAGRI LETTER CO
  { 0xA80D, BIDI_L   },  // SYLOTI NAGRI LETTER CHO
  { 0xA80E, BIDI_L   },  // SYLOTI NAGRI LETTER JO
  { 0xA80F, BIDI_L   },  // SYLOTI NAGRI LETTER JHO
  { 0xA810, BIDI_L   },  // SYLOTI NAGRI LETTER TTO
  { 0xA811, BIDI_L   },  // SYLOTI NAGRI LETTER TTHO
  { 0xA812, BIDI_L   },  // SYLOTI NAGRI LETTER DDO
  { 0xA813, BIDI_L   },  // SYLOTI NAGRI LETTER DDHO
  { 0xA814, BIDI_L   },  // SYLOTI NAGRI LETTER TO
  { 0xA815, BIDI_L   },  // SYLOTI NAGRI LETTER THO
  { 0xA816, BIDI_L   },  // SYLOTI NAGRI LETTER DO
  { 0xA817, BIDI_L   },  // SYLOTI NAGRI LETTER DHO
  { 0xA818, BIDI_L   },  // SYLOTI NAGRI LETTER NO
  { 0xA819, BIDI_L   },  // SYLOTI NAGRI LETTER PO
  { 0xA81A, BIDI_L   },  // SYLOTI NAGRI LETTER PHO
  { 0xA81B, BIDI_L   },  // SYLOTI NAGRI LETTER BO
  { 0xA81C, BIDI_L   },  // SYLOTI NAGRI LETTER BHO
  { 0xA81D, BIDI_L   },  // SYLOTI NAGRI LETTER MO
  { 0xA81E, BIDI_L   },  // SYLOTI NAGRI LETTER RO
  { 0xA81F, BIDI_L   },  // SYLOTI NAGRI LETTER LO
  { 0xA820, BIDI_L   },  // SYLOTI NAGRI LETTER RRO
  { 0xA821, BIDI_L   },  // SYLOTI NAGRI LETTER SO
  { 0xA822, BIDI_L   },  // SYLOTI NAGRI LETTER HO
  { 0xA823, BIDI_L   },  // SYLOTI NAGRI VOWEL SIGN A
  { 0xA824, BIDI_L   },  // SYLOTI NAGRI VOWEL SIGN I
  { 0xA825, BIDI_NSM },  // SYLOTI NAGRI VOWEL SIGN U
  { 0xA826, BIDI_NSM },  // SYLOTI NAGRI VOWEL SIGN E
  { 0xA827, BIDI_L   },  // SYLOTI NAGRI VOWEL SIGN OO
  { 0xA828, BIDI_ON  },  // SYLOTI NAGRI POETRY MARK-1
  { 0xA829, BIDI_ON  },  // SYLOTI NAGRI POETRY MARK-2
  { 0xA82A, BIDI_ON  },  // SYLOTI NAGRI POETRY MARK-3
  { 0xA82B, BIDI_ON  },  // SYLOTI NAGRI POETRY MARK-4
  { 0xA830, BIDI_L   },  // NORTH INDIC FRACTION ONE QUARTER
  { 0xA831, BIDI_L   },  // NORTH INDIC FRACTION ONE HALF
  { 0xA832, BIDI_L   },  // NORTH INDIC FRACTION THREE QUARTERS
  { 0xA833, BIDI_L   },  // NORTH INDIC FRACTION ONE SIXTEENTH
  { 0xA834, BIDI_L   },  // NORTH INDIC FRACTION ONE EIGHTH
  { 0xA835, BIDI_L   },  // NORTH INDIC FRACTION THREE SIXTEENTHS
  { 0xA836, BIDI_L   },  // NORTH INDIC QUARTER MARK
  { 0xA837, BIDI_L   },  // NORTH INDIC PLACEHOLDER MARK
  { 0xA838, BIDI_ET  },  // NORTH INDIC RUPEE MARK
  { 0xA839, BIDI_ET  },  // NORTH INDIC QUANTITY MARK
  { 0xA840, BIDI_L   },  // PHAGS-PA LETTER KA
  { 0xA841, BIDI_L   },  // PHAGS-PA LETTER KHA
  { 0xA842, BIDI_L   },  // PHAGS-PA LETTER GA
  { 0xA843, BIDI_L   },  // PHAGS-PA LETTER NGA
  { 0xA844, BIDI_L   },  // PHAGS-PA LETTER CA
  { 0xA845, BIDI_L   },  // PHAGS-PA LETTER CHA
  { 0xA846, BIDI_L   },  // PHAGS-PA LETTER JA
  { 0xA847, BIDI_L   },  // PHAGS-PA LETTER NYA
  { 0xA848, BIDI_L   },  // PHAGS-PA LETTER TA
  { 0xA849, BIDI_L   },  // PHAGS-PA LETTER THA
  { 0xA84A, BIDI_L   },  // PHAGS-PA LETTER DA
  { 0xA84B, BIDI_L   },  // PHAGS-PA LETTER NA
  { 0xA84C, BIDI_L   },  // PHAGS-PA LETTER PA
  { 0xA84D, BIDI_L   },  // PHAGS-PA LETTER PHA
  { 0xA84E, BIDI_L   },  // PHAGS-PA LETTER BA
  { 0xA84F, BIDI_L   },  // PHAGS-PA LETTER MA
  { 0xA850, BIDI_L   },  // PHAGS-PA LETTER TSA
  { 0xA851, BIDI_L   },  // PHAGS-PA LETTER TSHA
  { 0xA852, BIDI_L   },  // PHAGS-PA LETTER DZA
  { 0xA853, BIDI_L   },  // PHAGS-PA LETTER WA
  { 0xA854, BIDI_L   },  // PHAGS-PA LETTER ZHA
  { 0xA855, BIDI_L   },  // PHAGS-PA LETTER ZA
  { 0xA856, BIDI_L   },  // PHAGS-PA LETTER SMALL A
  { 0xA857, BIDI_L   },  // PHAGS-PA LETTER YA
  { 0xA858, BIDI_L   },  // PHAGS-PA LETTER RA
  { 0xA859, BIDI_L   },  // PHAGS-PA LETTER LA
  { 0xA85A, BIDI_L   },  // PHAGS-PA LETTER SHA
  { 0xA85B, BIDI_L   },  // PHAGS-PA LETTER SA
  { 0xA85C, BIDI_L   },  // PHAGS-PA LETTER HA
  { 0xA85D, BIDI_L   },  // PHAGS-PA LETTER A
  { 0xA85E, BIDI_L   },  // PHAGS-PA LETTER I
  { 0xA85F, BIDI_L   },  // PHAGS-PA LETTER U
  { 0xA860, BIDI_L   },  // PHAGS-PA LETTER E
  { 0xA861, BIDI_L   },  // PHAGS-PA LETTER O
  { 0xA862, BIDI_L   },  // PHAGS-PA LETTER QA
  { 0xA863, BIDI_L   },  // PHAGS-PA LETTER XA
  { 0xA864, BIDI_L   },  // PHAGS-PA LETTER FA
  { 0xA865, BIDI_L   },  // PHAGS-PA LETTER GGA
  { 0xA866, BIDI_L   },  // PHAGS-PA LETTER EE
  { 0xA867, BIDI_L   },  // PHAGS-PA SUBJOINED LETTER WA
  { 0xA868, BIDI_L   },  // PHAGS-PA SUBJOINED LETTER YA
  { 0xA869, BIDI_L   },  // PHAGS-PA LETTER TTA
  { 0xA86A, BIDI_L   },  // PHAGS-PA LETTER TTHA
  { 0xA86B, BIDI_L   },  // PHAGS-PA LETTER DDA
  { 0xA86C, BIDI_L   },  // PHAGS-PA LETTER NNA
  { 0xA86D, BIDI_L   },  // PHAGS-PA LETTER ALTERNATE YA
  { 0xA86E, BIDI_L   },  // PHAGS-PA LETTER VOICELESS SHA
  { 0xA86F, BIDI_L   },  // PHAGS-PA LETTER VOICED HA
  { 0xA870, BIDI_L   },  // PHAGS-PA LETTER ASPIRATED FA
  { 0xA871, BIDI_L   },  // PHAGS-PA SUBJOINED LETTER RA
  { 0xA872, BIDI_L   },  // PHAGS-PA SUPERFIXED LETTER RA
  { 0xA873, BIDI_L   },  // PHAGS-PA LETTER CANDRABINDU
  { 0xA874, BIDI_ON  },  // PHAGS-PA SINGLE HEAD MARK
  { 0xA875, BIDI_ON  },  // PHAGS-PA DOUBLE HEAD MARK
  { 0xA876, BIDI_ON  },  // PHAGS-PA MARK SHAD
  { 0xA877, BIDI_ON  },  // PHAGS-PA MARK DOUBLE SHAD
  { 0xA880, BIDI_L   },  // SAURASHTRA SIGN ANUSVARA
  { 0xA881, BIDI_L   },  // SAURASHTRA SIGN VISARGA
  { 0xA882, BIDI_L   },  // SAURASHTRA LETTER A
  { 0xA883, BIDI_L   },  // SAURASHTRA LETTER AA
  { 0xA884, BIDI_L   },  // SAURASHTRA LETTER I
  { 0xA885, BIDI_L   },  // SAURASHTRA LETTER II
  { 0xA886, BIDI_L   },  // SAURASHTRA LETTER U
  { 0xA887, BIDI_L   },  // SAURASHTRA LETTER UU
  { 0xA888, BIDI_L   },  // SAURASHTRA LETTER VOCALIC R
  { 0xA889, BIDI_L   },  // SAURASHTRA LETTER VOCALIC RR
  { 0xA88A, BIDI_L   },  // SAURASHTRA LETTER VOCALIC L
  { 0xA88B, BIDI_L   },  // SAURASHTRA LETTER VOCALIC LL
  { 0xA88C, BIDI_L   },  // SAURASHTRA LETTER E
  { 0xA88D, BIDI_L   },  // SAURASHTRA LETTER EE
  { 0xA88E, BIDI_L   },  // SAURASHTRA LETTER AI
  { 0xA88F, BIDI_L   },  // SAURASHTRA LETTER O
  { 0xA890, BIDI_L   },  // SAURASHTRA LETTER OO
  { 0xA891, BIDI_L   },  // SAURASHTRA LETTER AU
  { 0xA892, BIDI_L   },  // SAURASHTRA LETTER KA
  { 0xA893, BIDI_L   },  // SAURASHTRA LETTER KHA
  { 0xA894, BIDI_L   },  // SAURASHTRA LETTER GA
  { 0xA895, BIDI_L   },  // SAURASHTRA LETTER GHA
  { 0xA896, BIDI_L   },  // SAURASHTRA LETTER NGA
  { 0xA897, BIDI_L   },  // SAURASHTRA LETTER CA
  { 0xA898, BIDI_L   },  // SAURASHTRA LETTER CHA
  { 0xA899, BIDI_L   },  // SAURASHTRA LETTER JA
  { 0xA89A, BIDI_L   },  // SAURASHTRA LETTER JHA
  { 0xA89B, BIDI_L   },  // SAURASHTRA LETTER NYA
  { 0xA89C, BIDI_L   },  // SAURASHTRA LETTER TTA
  { 0xA89D, BIDI_L   },  // SAURASHTRA LETTER TTHA
  { 0xA89E, BIDI_L   },  // SAURASHTRA LETTER DDA
  { 0xA89F, BIDI_L   },  // SAURASHTRA LETTER DDHA
  { 0xA8A0, BIDI_L   },  // SAURASHTRA LETTER NNA
  { 0xA8A1, BIDI_L   },  // SAURASHTRA LETTER TA
  { 0xA8A2, BIDI_L   },  // SAURASHTRA LETTER THA
  { 0xA8A3, BIDI_L   },  // SAURASHTRA LETTER DA
  { 0xA8A4, BIDI_L   },  // SAURASHTRA LETTER DHA
  { 0xA8A5, BIDI_L   },  // SAURASHTRA LETTER NA
  { 0xA8A6, BIDI_L   },  // SAURASHTRA LETTER PA
  { 0xA8A7, BIDI_L   },  // SAURASHTRA LETTER PHA
  { 0xA8A8, BIDI_L   },  // SAURASHTRA LETTER BA
  { 0xA8A9, BIDI_L   },  // SAURASHTRA LETTER BHA
  { 0xA8AA, BIDI_L   },  // SAURASHTRA LETTER MA
  { 0xA8AB, BIDI_L   },  // SAURASHTRA LETTER YA
  { 0xA8AC, BIDI_L   },  // SAURASHTRA LETTER RA
  { 0xA8AD, BIDI_L   },  // SAURASHTRA LETTER LA
  { 0xA8AE, BIDI_L   },  // SAURASHTRA LETTER VA
  { 0xA8AF, BIDI_L   },  // SAURASHTRA LETTER SHA
  { 0xA8B0, BIDI_L   },  // SAURASHTRA LETTER SSA
  { 0xA8B1, BIDI_L   },  // SAURASHTRA LETTER SA
  { 0xA8B2, BIDI_L   },  // SAURASHTRA LETTER HA
  { 0xA8B3, BIDI_L   },  // SAURASHTRA LETTER LLA
  { 0xA8B4, BIDI_L   },  // SAURASHTRA CONSONANT SIGN HAARU
  { 0xA8B5, BIDI_L   },  // SAURASHTRA VOWEL SIGN AA
  { 0xA8B6, BIDI_L   },  // SAURASHTRA VOWEL SIGN I
  { 0xA8B7, BIDI_L   },  // SAURASHTRA VOWEL SIGN II
  { 0xA8B8, BIDI_L   },  // SAURASHTRA VOWEL SIGN U
  { 0xA8B9, BIDI_L   },  // SAURASHTRA VOWEL SIGN UU
  { 0xA8BA, BIDI_L   },  // SAURASHTRA VOWEL SIGN VOCALIC R
  { 0xA8BB, BIDI_L   },  // SAURASHTRA VOWEL SIGN VOCALIC RR
  { 0xA8BC, BIDI_L   },  // SAURASHTRA VOWEL SIGN VOCALIC L
  { 0xA8BD, BIDI_L   },  // SAURASHTRA VOWEL SIGN VOCALIC LL
  { 0xA8BE, BIDI_L   },  // SAURASHTRA VOWEL SIGN E
  { 0xA8BF, BIDI_L   },  // SAURASHTRA VOWEL SIGN EE
  { 0xA8C0, BIDI_L   },  // SAURASHTRA VOWEL SIGN AI
  { 0xA8C1, BIDI_L   },  // SAURASHTRA VOWEL SIGN O
  { 0xA8C2, BIDI_L   },  // SAURASHTRA VOWEL SIGN OO
  { 0xA8C3, BIDI_L   },  // SAURASHTRA VOWEL SIGN AU
  { 0xA8C4, BIDI_NSM },  // SAURASHTRA SIGN VIRAMA
  { 0xA8CE, BIDI_L   },  // SAURASHTRA DANDA
  { 0xA8CF, BIDI_L   },  // SAURASHTRA DOUBLE DANDA
  { 0xA8D0, BIDI_L   },  // SAURASHTRA DIGIT ZERO
  { 0xA8D1, BIDI_L   },  // SAURASHTRA DIGIT ONE
  { 0xA8D2, BIDI_L   },  // SAURASHTRA DIGIT TWO
  { 0xA8D3, BIDI_L   },  // SAURASHTRA DIGIT THREE
  { 0xA8D4, BIDI_L   },  // SAURASHTRA DIGIT FOUR
  { 0xA8D5, BIDI_L   },  // SAURASHTRA DIGIT FIVE
  { 0xA8D6, BIDI_L   },  // SAURASHTRA DIGIT SIX
  { 0xA8D7, BIDI_L   },  // SAURASHTRA DIGIT SEVEN
  { 0xA8D8, BIDI_L   },  // SAURASHTRA DIGIT EIGHT
  { 0xA8D9, BIDI_L   },  // SAURASHTRA DIGIT NINE
  { 0xA8E0, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT ZERO
  { 0xA8E1, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT ONE
  { 0xA8E2, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT TWO
  { 0xA8E3, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT THREE
  { 0xA8E4, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT FOUR
  { 0xA8E5, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT FIVE
  { 0xA8E6, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT SIX
  { 0xA8E7, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT SEVEN
  { 0xA8E8, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT EIGHT
  { 0xA8E9, BIDI_NSM },  // COMBINING DEVANAGARI DIGIT NINE
  { 0xA8EA, BIDI_NSM },  // COMBINING DEVANAGARI LETTER A
  { 0xA8EB, BIDI_NSM },  // COMBINING DEVANAGARI LETTER U
  { 0xA8EC, BIDI_NSM },  // COMBINING DEVANAGARI LETTER KA
  { 0xA8ED, BIDI_NSM },  // COMBINING DEVANAGARI LETTER NA
  { 0xA8EE, BIDI_NSM },  // COMBINING DEVANAGARI LETTER PA
  { 0xA8EF, BIDI_NSM },  // COMBINING DEVANAGARI LETTER RA
  { 0xA8F0, BIDI_NSM },  // COMBINING DEVANAGARI LETTER VI
  { 0xA8F1, BIDI_NSM },  // COMBINING DEVANAGARI SIGN AVAGRAHA
  { 0xA8F2, BIDI_L   },  // DEVANAGARI SIGN SPACING CANDRABINDU
  { 0xA8F3, BIDI_L   },  // DEVANAGARI SIGN CANDRABINDU VIRAMA
  { 0xA8F4, BIDI_L   },  // DEVANAGARI SIGN DOUBLE CANDRABINDU VIRAMA
  { 0xA8F5, BIDI_L   },  // DEVANAGARI SIGN CANDRABINDU TWO
  { 0xA8F6, BIDI_L   },  // DEVANAGARI SIGN CANDRABINDU THREE
  { 0xA8F7, BIDI_L   },  // DEVANAGARI SIGN CANDRABINDU AVAGRAHA
  { 0xA8F8, BIDI_L   },  // DEVANAGARI SIGN PUSHPIKA
  { 0xA8F9, BIDI_L   },  // DEVANAGARI GAP FILLER
  { 0xA8FA, BIDI_L   },  // DEVANAGARI CARET
  { 0xA8FB, BIDI_L   },  // DEVANAGARI HEADSTROKE
  { 0xA8FC, BIDI_L   },  // DEVANAGARI SIGN SIDDHAM
  { 0xA8FD, BIDI_L   },  // DEVANAGARI JAIN OM
  { 0xA900, BIDI_L   },  // KAYAH LI DIGIT ZERO
  { 0xA901, BIDI_L   },  // KAYAH LI DIGIT ONE
  { 0xA902, BIDI_L   },  // KAYAH LI DIGIT TWO
  { 0xA903, BIDI_L   },  // KAYAH LI DIGIT THREE
  { 0xA904, BIDI_L   },  // KAYAH LI DIGIT FOUR
  { 0xA905, BIDI_L   },  // KAYAH LI DIGIT FIVE
  { 0xA906, BIDI_L   },  // KAYAH LI DIGIT SIX
  { 0xA907, BIDI_L   },  // KAYAH LI DIGIT SEVEN
  { 0xA908, BIDI_L   },  // KAYAH LI DIGIT EIGHT
  { 0xA909, BIDI_L   },  // KAYAH LI DIGIT NINE
  { 0xA90A, BIDI_L   },  // KAYAH LI LETTER KA
  { 0xA90B, BIDI_L   },  // KAYAH LI LETTER KHA
  { 0xA90C, BIDI_L   },  // KAYAH LI LETTER GA
  { 0xA90D, BIDI_L   },  // KAYAH LI LETTER NGA
  { 0xA90E, BIDI_L   },  // KAYAH LI LETTER SA
  { 0xA90F, BIDI_L   },  // KAYAH LI LETTER SHA
  { 0xA910, BIDI_L   },  // KAYAH LI LETTER ZA
  { 0xA911, BIDI_L   },  // KAYAH LI LETTER NYA
  { 0xA912, BIDI_L   },  // KAYAH LI LETTER TA
  { 0xA913, BIDI_L   },  // KAYAH LI LETTER HTA
  { 0xA914, BIDI_L   },  // KAYAH LI LETTER NA
  { 0xA915, BIDI_L   },  // KAYAH LI LETTER PA
  { 0xA916, BIDI_L   },  // KAYAH LI LETTER PHA
  { 0xA917, BIDI_L   },  // KAYAH LI LETTER MA
  { 0xA918, BIDI_L   },  // KAYAH LI LETTER DA
  { 0xA919, BIDI_L   },  // KAYAH LI LETTER BA
  { 0xA91A, BIDI_L   },  // KAYAH LI LETTER RA
  { 0xA91B, BIDI_L   },  // KAYAH LI LETTER YA
  { 0xA91C, BIDI_L   },  // KAYAH LI LETTER LA
  { 0xA91D, BIDI_L   },  // KAYAH LI LETTER WA
  { 0xA91E, BIDI_L   },  // KAYAH LI LETTER THA
  { 0xA91F, BIDI_L   },  // KAYAH LI LETTER HA
  { 0xA920, BIDI_L   },  // KAYAH LI LETTER VA
  { 0xA921, BIDI_L   },  // KAYAH LI LETTER CA
  { 0xA922, BIDI_L   },  // KAYAH LI LETTER A
  { 0xA923, BIDI_L   },  // KAYAH LI LETTER OE
  { 0xA924, BIDI_L   },  // KAYAH LI LETTER I
  { 0xA925, BIDI_L   },  // KAYAH LI LETTER OO
  { 0xA926, BIDI_NSM },  // KAYAH LI VOWEL UE
  { 0xA927, BIDI_NSM },  // KAYAH LI VOWEL E
  { 0xA928, BIDI_NSM },  // KAYAH LI VOWEL U
  { 0xA929, BIDI_NSM },  // KAYAH LI VOWEL EE
  { 0xA92A, BIDI_NSM },  // KAYAH LI VOWEL O
  { 0xA92B, BIDI_NSM },  // KAYAH LI TONE PLOPHU
  { 0xA92C, BIDI_NSM },  // KAYAH LI TONE CALYA
  { 0xA92D, BIDI_NSM },  // KAYAH LI TONE CALYA PLOPHU
  { 0xA92E, BIDI_L   },  // KAYAH LI SIGN CWI
  { 0xA92F, BIDI_L   },  // KAYAH LI SIGN SHYA
  { 0xA930, BIDI_L   },  // REJANG LETTER KA
  { 0xA931, BIDI_L   },  // REJANG LETTER GA
  { 0xA932, BIDI_L   },  // REJANG LETTER NGA
  { 0xA933, BIDI_L   },  // REJANG LETTER TA
  { 0xA934, BIDI_L   },  // REJANG LETTER DA
  { 0xA935, BIDI_L   },  // REJANG LETTER NA
  { 0xA936, BIDI_L   },  // REJANG LETTER PA
  { 0xA937, BIDI_L   },  // REJANG LETTER BA
  { 0xA938, BIDI_L   },  // REJANG LETTER MA
  { 0xA939, BIDI_L   },  // REJANG LETTER CA
  { 0xA93A, BIDI_L   },  // REJANG LETTER JA
  { 0xA93B, BIDI_L   },  // REJANG LETTER NYA
  { 0xA93C, BIDI_L   },  // REJANG LETTER SA
  { 0xA93D, BIDI_L   },  // REJANG LETTER RA
  { 0xA93E, BIDI_L   },  // REJANG LETTER LA
  { 0xA93F, BIDI_L   },  // REJANG LETTER YA
  { 0xA940, BIDI_L   },  // REJANG LETTER WA
  { 0xA941, BIDI_L   },  // REJANG LETTER HA
  { 0xA942, BIDI_L   },  // REJANG LETTER MBA
  { 0xA943, BIDI_L   },  // REJANG LETTER NGGA
  { 0xA944, BIDI_L   },  // REJANG LETTER NDA
  { 0xA945, BIDI_L   },  // REJANG LETTER NYJA
  { 0xA946, BIDI_L   },  // REJANG LETTER A
  { 0xA947, BIDI_NSM },  // REJANG VOWEL SIGN I
  { 0xA948, BIDI_NSM },  // REJANG VOWEL SIGN U
  { 0xA949, BIDI_NSM },  // REJANG VOWEL SIGN E
  { 0xA94A, BIDI_NSM },  // REJANG VOWEL SIGN AI
  { 0xA94B, BIDI_NSM },  // REJANG VOWEL SIGN O
  { 0xA94C, BIDI_NSM },  // REJANG VOWEL SIGN AU
  { 0xA94D, BIDI_NSM },  // REJANG VOWEL SIGN EU
  { 0xA94E, BIDI_NSM },  // REJANG VOWEL SIGN EA
  { 0xA94F, BIDI_NSM },  // REJANG CONSONANT SIGN NG
  { 0xA950, BIDI_NSM },  // REJANG CONSONANT SIGN N
  { 0xA951, BIDI_NSM },  // REJANG CONSONANT SIGN R
  { 0xA952, BIDI_L   },  // REJANG CONSONANT SIGN H
  { 0xA953, BIDI_L   },  // REJANG VIRAMA
  { 0xA95F, BIDI_L   },  // REJANG SECTION MARK
  { 0xA960, BIDI_L   },  // HANGUL CHOSEONG TIKEUT-MIEUM
  { 0xA961, BIDI_L   },  // HANGUL CHOSEONG TIKEUT-PIEUP
  { 0xA962, BIDI_L   },  // HANGUL CHOSEONG TIKEUT-SIOS
  { 0xA963, BIDI_L   },  // HANGUL CHOSEONG TIKEUT-CIEUC
  { 0xA964, BIDI_L   },  // HANGUL CHOSEONG RIEUL-KIYEOK
  { 0xA965, BIDI_L   },  // HANGUL CHOSEONG RIEUL-SSANGKIYEOK
  { 0xA966, BIDI_L   },  // HANGUL CHOSEONG RIEUL-TIKEUT
  { 0xA967, BIDI_L   },  // HANGUL CHOSEONG RIEUL-SSANGTIKEUT
  { 0xA968, BIDI_L   },  // HANGUL CHOSEONG RIEUL-MIEUM
  { 0xA969, BIDI_L   },  // HANGUL CHOSEONG RIEUL-PIEUP
  { 0xA96A, BIDI_L   },  // HANGUL CHOSEONG RIEUL-SSANGPIEUP
  { 0xA96B, BIDI_L   },  // HANGUL CHOSEONG RIEUL-KAPYEOUNPIEUP
  { 0xA96C, BIDI_L   },  // HANGUL CHOSEONG RIEUL-SIOS
  { 0xA96D, BIDI_L   },  // HANGUL CHOSEONG RIEUL-CIEUC
  { 0xA96E, BIDI_L   },  // HANGUL CHOSEONG RIEUL-KHIEUKH
  { 0xA96F, BIDI_L   },  // HANGUL CHOSEONG MIEUM-KIYEOK
  { 0xA970, BIDI_L   },  // HANGUL CHOSEONG MIEUM-TIKEUT
  { 0xA971, BIDI_L   },  // HANGUL CHOSEONG MIEUM-SIOS
  { 0xA972, BIDI_L   },  // HANGUL CHOSEONG PIEUP-SIOS-THIEUTH
  { 0xA973, BIDI_L   },  // HANGUL CHOSEONG PIEUP-KHIEUKH
  { 0xA974, BIDI_L   },  // HANGUL CHOSEONG PIEUP-HIEUH
  { 0xA975, BIDI_L   },  // HANGUL CHOSEONG SSANGSIOS-PIEUP
  { 0xA976, BIDI_L   },  // HANGUL CHOSEONG IEUNG-RIEUL
  { 0xA977, BIDI_L   },  // HANGUL CHOSEONG IEUNG-HIEUH
  { 0xA978, BIDI_L   },  // HANGUL CHOSEONG SSANGCIEUC-HIEUH
  { 0xA979, BIDI_L   },  // HANGUL CHOSEONG SSANGTHIEUTH
  { 0xA97A, BIDI_L   },  // HANGUL CHOSEONG PHIEUPH-HIEUH
  { 0xA97B, BIDI_L   },  // HANGUL CHOSEONG HIEUH-SIOS
  { 0xA97C, BIDI_L   },  // HANGUL CHOSEONG SSANGYEORINHIEUH
  { 0xA980, BIDI_NSM },  // JAVANESE SIGN PANYANGGA
  { 0xA981, BIDI_NSM },  // JAVANESE SIGN CECAK
  { 0xA982, BIDI_NSM },  // JAVANESE SIGN LAYAR
  { 0xA983, BIDI_L   },  // JAVANESE SIGN WIGNYAN
  { 0xA984, BIDI_L   },  // JAVANESE LETTER A
  { 0xA985, BIDI_L   },  // JAVANESE LETTER I KAWI
  { 0xA986, BIDI_L   },  // JAVANESE LETTER I
  { 0xA987, BIDI_L   },  // JAVANESE LETTER II
  { 0xA988, BIDI_L   },  // JAVANESE LETTER U
  { 0xA989, BIDI_L   },  // JAVANESE LETTER PA CEREK
  { 0xA98A, BIDI_L   },  // JAVANESE LETTER NGA LELET
  { 0xA98B, BIDI_L   },  // JAVANESE LETTER NGA LELET RASWADI
  { 0xA98C, BIDI_L   },  // JAVANESE LETTER E
  { 0xA98D, BIDI_L   },  // JAVANESE LETTER AI
  { 0xA98E, BIDI_L   },  // JAVANESE LETTER O
  { 0xA98F, BIDI_L   },  // JAVANESE LETTER KA
  { 0xA990, BIDI_L   },  // JAVANESE LETTER KA SASAK
  { 0xA991, BIDI_L   },  // JAVANESE LETTER KA MURDA
  { 0xA992, BIDI_L   },  // JAVANESE LETTER GA
  { 0xA993, BIDI_L   },  // JAVANESE LETTER GA MURDA
  { 0xA994, BIDI_L   },  // JAVANESE LETTER NGA
  { 0xA995, BIDI_L   },  // JAVANESE LETTER CA
  { 0xA996, BIDI_L   },  // JAVANESE LETTER CA MURDA
  { 0xA997, BIDI_L   },  // JAVANESE LETTER JA
  { 0xA998, BIDI_L   },  // JAVANESE LETTER NYA MURDA
  { 0xA999, BIDI_L   },  // JAVANESE LETTER JA MAHAPRANA
  { 0xA99A, BIDI_L   },  // JAVANESE LETTER NYA
  { 0xA99B, BIDI_L   },  // JAVANESE LETTER TTA
  { 0xA99C, BIDI_L   },  // JAVANESE LETTER TTA MAHAPRANA
  { 0xA99D, BIDI_L   },  // JAVANESE LETTER DDA
  { 0xA99E, BIDI_L   },  // JAVANESE LETTER DDA MAHAPRANA
  { 0xA99F, BIDI_L   },  // JAVANESE LETTER NA MURDA
  { 0xA9A0, BIDI_L   },  // JAVANESE LETTER TA
  { 0xA9A1, BIDI_L   },  // JAVANESE LETTER TA MURDA
  { 0xA9A2, BIDI_L   },  // JAVANESE LETTER DA
  { 0xA9A3, BIDI_L   },  // JAVANESE LETTER DA MAHAPRANA
  { 0xA9A4, BIDI_L   },  // JAVANESE LETTER NA
  { 0xA9A5, BIDI_L   },  // JAVANESE LETTER PA
  { 0xA9A6, BIDI_L   },  // JAVANESE LETTER PA MURDA
  { 0xA9A7, BIDI_L   },  // JAVANESE LETTER BA
  { 0xA9A8, BIDI_L   },  // JAVANESE LETTER BA MURDA
  { 0xA9A9, BIDI_L   },  // JAVANESE LETTER MA
  { 0xA9AA, BIDI_L   },  // JAVANESE LETTER YA
  { 0xA9AB, BIDI_L   },  // JAVANESE LETTER RA
  { 0xA9AC, BIDI_L   },  // JAVANESE LETTER RA AGUNG
  { 0xA9AD, BIDI_L   },  // JAVANESE LETTER LA
  { 0xA9AE, BIDI_L   },  // JAVANESE LETTER WA
  { 0xA9AF, BIDI_L   },  // JAVANESE LETTER SA MURDA
  { 0xA9B0, BIDI_L   },  // JAVANESE LETTER SA MAHAPRANA
  { 0xA9B1, BIDI_L   },  // JAVANESE LETTER SA
  { 0xA9B2, BIDI_L   },  // JAVANESE LETTER HA
  { 0xA9B3, BIDI_NSM },  // JAVANESE SIGN CECAK TELU
  { 0xA9B4, BIDI_L   },  // JAVANESE VOWEL SIGN TARUNG
  { 0xA9B5, BIDI_L   },  // JAVANESE VOWEL SIGN TOLONG
  { 0xA9B6, BIDI_NSM },  // JAVANESE VOWEL SIGN WULU
  { 0xA9B7, BIDI_NSM },  // JAVANESE VOWEL SIGN WULU MELIK
  { 0xA9B8, BIDI_NSM },  // JAVANESE VOWEL SIGN SUKU
  { 0xA9B9, BIDI_NSM },  // JAVANESE VOWEL SIGN SUKU MENDUT
  { 0xA9BA, BIDI_L   },  // JAVANESE VOWEL SIGN TALING
  { 0xA9BB, BIDI_L   },  // JAVANESE VOWEL SIGN DIRGA MURE
  { 0xA9BC, BIDI_NSM },  // JAVANESE VOWEL SIGN PEPET
  { 0xA9BD, BIDI_L   },  // JAVANESE CONSONANT SIGN KERET
  { 0xA9BE, BIDI_L   },  // JAVANESE CONSONANT SIGN PENGKAL
  { 0xA9BF, BIDI_L   },  // JAVANESE CONSONANT SIGN CAKRA
  { 0xA9C0, BIDI_L   },  // JAVANESE PANGKON
  { 0xA9C1, BIDI_L   },  // JAVANESE LEFT RERENGGAN
  { 0xA9C2, BIDI_L   },  // JAVANESE RIGHT RERENGGAN
  { 0xA9C3, BIDI_L   },  // JAVANESE PADA ANDAP
  { 0xA9C4, BIDI_L   },  // JAVANESE PADA MADYA
  { 0xA9C5, BIDI_L   },  // JAVANESE PADA LUHUR
  { 0xA9C6, BIDI_L   },  // JAVANESE PADA WINDU
  { 0xA9C7, BIDI_L   },  // JAVANESE PADA PANGKAT
  { 0xA9C8, BIDI_L   },  // JAVANESE PADA LINGSA
  { 0xA9C9, BIDI_L   },  // JAVANESE PADA LUNGSI
  { 0xA9CA, BIDI_L   },  // JAVANESE PADA ADEG
  { 0xA9CB, BIDI_L   },  // JAVANESE PADA ADEG ADEG
  { 0xA9CC, BIDI_L   },  // JAVANESE PADA PISELEH
  { 0xA9CD, BIDI_L   },  // JAVANESE TURNED PADA PISELEH
  { 0xA9CF, BIDI_L   },  // JAVANESE PANGRANGKEP
  { 0xA9D0, BIDI_L   },  // JAVANESE DIGIT ZERO
  { 0xA9D1, BIDI_L   },  // JAVANESE DIGIT ONE
  { 0xA9D2, BIDI_L   },  // JAVANESE DIGIT TWO
  { 0xA9D3, BIDI_L   },  // JAVANESE DIGIT THREE
  { 0xA9D4, BIDI_L   },  // JAVANESE DIGIT FOUR
  { 0xA9D5, BIDI_L   },  // JAVANESE DIGIT FIVE
  { 0xA9D6, BIDI_L   },  // JAVANESE DIGIT SIX
  { 0xA9D7, BIDI_L   },  // JAVANESE DIGIT SEVEN
  { 0xA9D8, BIDI_L   },  // JAVANESE DIGIT EIGHT
  { 0xA9D9, BIDI_L   },  // JAVANESE DIGIT NINE
  { 0xA9DE, BIDI_L   },  // JAVANESE PADA TIRTA TUMETES
  { 0xA9DF, BIDI_L   },  // JAVANESE PADA ISEN-ISEN
  { 0xA9E0, BIDI_L   },  // MYANMAR LETTER SHAN GHA
  { 0xA9E1, BIDI_L   },  // MYANMAR LETTER SHAN CHA
  { 0xA9E2, BIDI_L   },  // MYANMAR LETTER SHAN JHA
  { 0xA9E3, BIDI_L   },  // MYANMAR LETTER SHAN NNA
  { 0xA9E4, BIDI_L   },  // MYANMAR LETTER SHAN BHA
  { 0xA9E5, BIDI_NSM },  // MYANMAR SIGN SHAN SAW
  { 0xA9E6, BIDI_L   },  // MYANMAR MODIFIER LETTER SHAN REDUPLICATION
  { 0xA9E7, BIDI_L   },  // MYANMAR LETTER TAI LAING NYA
  { 0xA9E8, BIDI_L   },  // MYANMAR LETTER TAI LAING FA
  { 0xA9E9, BIDI_L   },  // MYANMAR LETTER TAI LAING GA
  { 0xA9EA, BIDI_L   },  // MYANMAR LETTER TAI LAING GHA
  { 0xA9EB, BIDI_L   },  // MYANMAR LETTER TAI LAING JA
  { 0xA9EC, BIDI_L   },  // MYANMAR LETTER TAI LAING JHA
  { 0xA9ED, BIDI_L   },  // MYANMAR LETTER TAI LAING DDA
  { 0xA9EE, BIDI_L   },  // MYANMAR LETTER TAI LAING DDHA
  { 0xA9EF, BIDI_L   },  // MYANMAR LETTER TAI LAING NNA
  { 0xA9F0, BIDI_L   },  // MYANMAR TAI LAING DIGIT ZERO
  { 0xA9F1, BIDI_L   },  // MYANMAR TAI LAING DIGIT ONE
  { 0xA9F2, BIDI_L   },  // MYANMAR TAI LAING DIGIT TWO
  { 0xA9F3, BIDI_L   },  // MYANMAR TAI LAING DIGIT THREE
  { 0xA9F4, BIDI_L   },  // MYANMAR TAI LAING DIGIT FOUR
  { 0xA9F5, BIDI_L   },  // MYANMAR TAI LAING DIGIT FIVE
  { 0xA9F6, BIDI_L   },  // MYANMAR TAI LAING DIGIT SIX
  { 0xA9F7, BIDI_L   },  // MYANMAR TAI LAING DIGIT SEVEN
  { 0xA9F8, BIDI_L   },  // MYANMAR TAI LAING DIGIT EIGHT
  { 0xA9F9, BIDI_L   },  // MYANMAR TAI LAING DIGIT NINE
  { 0xA9FA, BIDI_L   },  // MYANMAR LETTER TAI LAING LLA
  { 0xA9FB, BIDI_L   },  // MYANMAR LETTER TAI LAING DA
  { 0xA9FC, BIDI_L   },  // MYANMAR LETTER TAI LAING DHA
  { 0xA9FD, BIDI_L   },  // MYANMAR LETTER TAI LAING BA
  { 0xA9FE, BIDI_L   },  // MYANMAR LETTER TAI LAING BHA
  { 0xAA00, BIDI_L   },  // CHAM LETTER A
  { 0xAA01, BIDI_L   },  // CHAM LETTER I
  { 0xAA02, BIDI_L   },  // CHAM LETTER U
  { 0xAA03, BIDI_L   },  // CHAM LETTER E
  { 0xAA04, BIDI_L   },  // CHAM LETTER AI
  { 0xAA05, BIDI_L   },  // CHAM LETTER O
  { 0xAA06, BIDI_L   },  // CHAM LETTER KA
  { 0xAA07, BIDI_L   },  // CHAM LETTER KHA
  { 0xAA08, BIDI_L   },  // CHAM LETTER GA
  { 0xAA09, BIDI_L   },  // CHAM LETTER GHA
  { 0xAA0A, BIDI_L   },  // CHAM LETTER NGUE
  { 0xAA0B, BIDI_L   },  // CHAM LETTER NGA
  { 0xAA0C, BIDI_L   },  // CHAM LETTER CHA
  { 0xAA0D, BIDI_L   },  // CHAM LETTER CHHA
  { 0xAA0E, BIDI_L   },  // CHAM LETTER JA
  { 0xAA0F, BIDI_L   },  // CHAM LETTER JHA
  { 0xAA10, BIDI_L   },  // CHAM LETTER NHUE
  { 0xAA11, BIDI_L   },  // CHAM LETTER NHA
  { 0xAA12, BIDI_L   },  // CHAM LETTER NHJA
  { 0xAA13, BIDI_L   },  // CHAM LETTER TA
  { 0xAA14, BIDI_L   },  // CHAM LETTER THA
  { 0xAA15, BIDI_L   },  // CHAM LETTER DA
  { 0xAA16, BIDI_L   },  // CHAM LETTER DHA
  { 0xAA17, BIDI_L   },  // CHAM LETTER NUE
  { 0xAA18, BIDI_L   },  // CHAM LETTER NA
  { 0xAA19, BIDI_L   },  // CHAM LETTER DDA
  { 0xAA1A, BIDI_L   },  // CHAM LETTER PA
  { 0xAA1B, BIDI_L   },  // CHAM LETTER PPA
  { 0xAA1C, BIDI_L   },  // CHAM LETTER PHA
  { 0xAA1D, BIDI_L   },  // CHAM LETTER BA
  { 0xAA1E, BIDI_L   },  // CHAM LETTER BHA
  { 0xAA1F, BIDI_L   },  // CHAM LETTER MUE
  { 0xAA20, BIDI_L   },  // CHAM LETTER MA
  { 0xAA21, BIDI_L   },  // CHAM LETTER BBA
  { 0xAA22, BIDI_L   },  // CHAM LETTER YA
  { 0xAA23, BIDI_L   },  // CHAM LETTER RA
  { 0xAA24, BIDI_L   },  // CHAM LETTER LA
  { 0xAA25, BIDI_L   },  // CHAM LETTER VA
  { 0xAA26, BIDI_L   },  // CHAM LETTER SSA
  { 0xAA27, BIDI_L   },  // CHAM LETTER SA
  { 0xAA28, BIDI_L   },  // CHAM LETTER HA
  { 0xAA29, BIDI_NSM },  // CHAM VOWEL SIGN AA
  { 0xAA2A, BIDI_NSM },  // CHAM VOWEL SIGN I
  { 0xAA2B, BIDI_NSM },  // CHAM VOWEL SIGN II
  { 0xAA2C, BIDI_NSM },  // CHAM VOWEL SIGN EI
  { 0xAA2D, BIDI_NSM },  // CHAM VOWEL SIGN U
  { 0xAA2E, BIDI_NSM },  // CHAM VOWEL SIGN OE
  { 0xAA2F, BIDI_L   },  // CHAM VOWEL SIGN O
  { 0xAA30, BIDI_L   },  // CHAM VOWEL SIGN AI
  { 0xAA31, BIDI_NSM },  // CHAM VOWEL SIGN AU
  { 0xAA32, BIDI_NSM },  // CHAM VOWEL SIGN UE
  { 0xAA33, BIDI_L   },  // CHAM CONSONANT SIGN YA
  { 0xAA34, BIDI_L   },  // CHAM CONSONANT SIGN RA
  { 0xAA35, BIDI_NSM },  // CHAM CONSONANT SIGN LA
  { 0xAA36, BIDI_NSM },  // CHAM CONSONANT SIGN WA
  { 0xAA40, BIDI_L   },  // CHAM LETTER FINAL K
  { 0xAA41, BIDI_L   },  // CHAM LETTER FINAL G
  { 0xAA42, BIDI_L   },  // CHAM LETTER FINAL NG
  { 0xAA43, BIDI_NSM },  // CHAM CONSONANT SIGN FINAL NG
  { 0xAA44, BIDI_L   },  // CHAM LETTER FINAL CH
  { 0xAA45, BIDI_L   },  // CHAM LETTER FINAL T
  { 0xAA46, BIDI_L   },  // CHAM LETTER FINAL N
  { 0xAA47, BIDI_L   },  // CHAM LETTER FINAL P
  { 0xAA48, BIDI_L   },  // CHAM LETTER FINAL Y
  { 0xAA49, BIDI_L   },  // CHAM LETTER FINAL R
  { 0xAA4A, BIDI_L   },  // CHAM LETTER FINAL L
  { 0xAA4B, BIDI_L   },  // CHAM LETTER FINAL SS
  { 0xAA4C, BIDI_NSM },  // CHAM CONSONANT SIGN FINAL M
  { 0xAA4D, BIDI_L   },  // CHAM CONSONANT SIGN FINAL H
  { 0xAA50, BIDI_L   },  // CHAM DIGIT ZERO
  { 0xAA51, BIDI_L   },  // CHAM DIGIT ONE
  { 0xAA52, BIDI_L   },  // CHAM DIGIT TWO
  { 0xAA53, BIDI_L   },  // CHAM DIGIT THREE
  { 0xAA54, BIDI_L   },  // CHAM DIGIT FOUR
  { 0xAA55, BIDI_L   },  // CHAM DIGIT FIVE
  { 0xAA56, BIDI_L   },  // CHAM DIGIT SIX
  { 0xAA57, BIDI_L   },  // CHAM DIGIT SEVEN
  { 0xAA58, BIDI_L   },  // CHAM DIGIT EIGHT
  { 0xAA59, BIDI_L   },  // CHAM DIGIT NINE
  { 0xAA5C, BIDI_L   },  // CHAM PUNCTUATION SPIRAL
  { 0xAA5D, BIDI_L   },  // CHAM PUNCTUATION DANDA
  { 0xAA5E, BIDI_L   },  // CHAM PUNCTUATION DOUBLE DANDA
  { 0xAA5F, BIDI_L   },  // CHAM PUNCTUATION TRIPLE DANDA
  { 0xAA60, BIDI_L   },  // MYANMAR LETTER KHAMTI GA
  { 0xAA61, BIDI_L   },  // MYANMAR LETTER KHAMTI CA
  { 0xAA62, BIDI_L   },  // MYANMAR LETTER KHAMTI CHA
  { 0xAA63, BIDI_L   },  // MYANMAR LETTER KHAMTI JA
  { 0xAA64, BIDI_L   },  // MYANMAR LETTER KHAMTI JHA
  { 0xAA65, BIDI_L   },  // MYANMAR LETTER KHAMTI NYA
  { 0xAA66, BIDI_L   },  // MYANMAR LETTER KHAMTI TTA
  { 0xAA67, BIDI_L   },  // MYANMAR LETTER KHAMTI TTHA
  { 0xAA68, BIDI_L   },  // MYANMAR LETTER KHAMTI DDA
  { 0xAA69, BIDI_L   },  // MYANMAR LETTER KHAMTI DDHA
  { 0xAA6A, BIDI_L   },  // MYANMAR LETTER KHAMTI DHA
  { 0xAA6B, BIDI_L   },  // MYANMAR LETTER KHAMTI NA
  { 0xAA6C, BIDI_L   },  // MYANMAR LETTER KHAMTI SA
  { 0xAA6D, BIDI_L   },  // MYANMAR LETTER KHAMTI HA
  { 0xAA6E, BIDI_L   },  // MYANMAR LETTER KHAMTI HHA
  { 0xAA6F, BIDI_L   },  // MYANMAR LETTER KHAMTI FA
  { 0xAA70, BIDI_L   },  // MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
  { 0xAA71, BIDI_L   },  // MYANMAR LETTER KHAMTI XA
  { 0xAA72, BIDI_L   },  // MYANMAR LETTER KHAMTI ZA
  { 0xAA73, BIDI_L   },  // MYANMAR LETTER KHAMTI RA
  { 0xAA74, BIDI_L   },  // MYANMAR LOGOGRAM KHAMTI OAY
  { 0xAA75, BIDI_L   },  // MYANMAR LOGOGRAM KHAMTI QN
  { 0xAA76, BIDI_L   },  // MYANMAR LOGOGRAM KHAMTI HM
  { 0xAA77, BIDI_L   },  // MYANMAR SYMBOL AITON EXCLAMATION
  { 0xAA78, BIDI_L   },  // MYANMAR SYMBOL AITON ONE
  { 0xAA79, BIDI_L   },  // MYANMAR SYMBOL AITON TWO
  { 0xAA7A, BIDI_L   },  // MYANMAR LETTER AITON RA
  { 0xAA7B, BIDI_L   },  // MYANMAR SIGN PAO KAREN TONE
  { 0xAA7C, BIDI_NSM },  // MYANMAR SIGN TAI LAING TONE-2
  { 0xAA7D, BIDI_L   },  // MYANMAR SIGN TAI LAING TONE-5
  { 0xAA7E, BIDI_L   },  // MYANMAR LETTER SHWE PALAUNG CHA
  { 0xAA7F, BIDI_L   },  // MYANMAR LETTER SHWE PALAUNG SHA
  { 0xAA80, BIDI_L   },  // TAI VIET LETTER LOW KO
  { 0xAA81, BIDI_L   },  // TAI VIET LETTER HIGH KO
  { 0xAA82, BIDI_L   },  // TAI VIET LETTER LOW KHO
  { 0xAA83, BIDI_L   },  // TAI VIET LETTER HIGH KHO
  { 0xAA84, BIDI_L   },  // TAI VIET LETTER LOW KHHO
  { 0xAA85, BIDI_L   },  // TAI VIET LETTER HIGH KHHO
  { 0xAA86, BIDI_L   },  // TAI VIET LETTER LOW GO
  { 0xAA87, BIDI_L   },  // TAI VIET LETTER HIGH GO
  { 0xAA88, BIDI_L   },  // TAI VIET LETTER LOW NGO
  { 0xAA89, BIDI_L   },  // TAI VIET LETTER HIGH NGO
  { 0xAA8A, BIDI_L   },  // TAI VIET LETTER LOW CO
  { 0xAA8B, BIDI_L   },  // TAI VIET LETTER HIGH CO
  { 0xAA8C, BIDI_L   },  // TAI VIET LETTER LOW CHO
  { 0xAA8D, BIDI_L   },  // TAI VIET LETTER HIGH CHO
  { 0xAA8E, BIDI_L   },  // TAI VIET LETTER LOW SO
  { 0xAA8F, BIDI_L   },  // TAI VIET LETTER HIGH SO
  { 0xAA90, BIDI_L   },  // TAI VIET LETTER LOW NYO
  { 0xAA91, BIDI_L   },  // TAI VIET LETTER HIGH NYO
  { 0xAA92, BIDI_L   },  // TAI VIET LETTER LOW DO
  { 0xAA93, BIDI_L   },  // TAI VIET LETTER HIGH DO
  { 0xAA94, BIDI_L   },  // TAI VIET LETTER LOW TO
  { 0xAA95, BIDI_L   },  // TAI VIET LETTER HIGH TO
  { 0xAA96, BIDI_L   },  // TAI VIET LETTER LOW THO
  { 0xAA97, BIDI_L   },  // TAI VIET LETTER HIGH THO
  { 0xAA98, BIDI_L   },  // TAI VIET LETTER LOW NO
  { 0xAA99, BIDI_L   },  // TAI VIET LETTER HIGH NO
  { 0xAA9A, BIDI_L   },  // TAI VIET LETTER LOW BO
  { 0xAA9B, BIDI_L   },  // TAI VIET LETTER HIGH BO
  { 0xAA9C, BIDI_L   },  // TAI VIET LETTER LOW PO
  { 0xAA9D, BIDI_L   },  // TAI VIET LETTER HIGH PO
  { 0xAA9E, BIDI_L   },  // TAI VIET LETTER LOW PHO
  { 0xAA9F, BIDI_L   },  // TAI VIET LETTER HIGH PHO
  { 0xAAA0, BIDI_L   },  // TAI VIET LETTER LOW FO
  { 0xAAA1, BIDI_L   },  // TAI VIET LETTER HIGH FO
  { 0xAAA2, BIDI_L   },  // TAI VIET LETTER LOW MO
  { 0xAAA3, BIDI_L   },  // TAI VIET LETTER HIGH MO
  { 0xAAA4, BIDI_L   },  // TAI VIET LETTER LOW YO
  { 0xAAA5, BIDI_L   },  // TAI VIET LETTER HIGH YO
  { 0xAAA6, BIDI_L   },  // TAI VIET LETTER LOW RO
  { 0xAAA7, BIDI_L   },  // TAI VIET LETTER HIGH RO
  { 0xAAA8, BIDI_L   },  // TAI VIET LETTER LOW LO
  { 0xAAA9, BIDI_L   },  // TAI VIET LETTER HIGH LO
  { 0xAAAA, BIDI_L   },  // TAI VIET LETTER LOW VO
  { 0xAAAB, BIDI_L   },  // TAI VIET LETTER HIGH VO
  { 0xAAAC, BIDI_L   },  // TAI VIET LETTER LOW HO
  { 0xAAAD, BIDI_L   },  // TAI VIET LETTER HIGH HO
  { 0xAAAE, BIDI_L   },  // TAI VIET LETTER LOW O
  { 0xAAAF, BIDI_L   },  // TAI VIET LETTER HIGH O
  { 0xAAB0, BIDI_NSM },  // TAI VIET MAI KANG
  { 0xAAB1, BIDI_L   },  // TAI VIET VOWEL AA
  { 0xAAB2, BIDI_NSM },  // TAI VIET VOWEL I
  { 0xAAB3, BIDI_NSM },  // TAI VIET VOWEL UE
  { 0xAAB4, BIDI_NSM },  // TAI VIET VOWEL U
  { 0xAAB5, BIDI_L   },  // TAI VIET VOWEL E
  { 0xAAB6, BIDI_L   },  // TAI VIET VOWEL O
  { 0xAAB7, BIDI_NSM },  // TAI VIET MAI KHIT
  { 0xAAB8, BIDI_NSM },  // TAI VIET VOWEL IA
  { 0xAAB9, BIDI_L   },  // TAI VIET VOWEL UEA
  { 0xAABA, BIDI_L   },  // TAI VIET VOWEL UA
  { 0xAABB, BIDI_L   },  // TAI VIET VOWEL AUE
  { 0xAABC, BIDI_L   },  // TAI VIET VOWEL AY
  { 0xAABD, BIDI_L   },  // TAI VIET VOWEL AN
  { 0xAABE, BIDI_NSM },  // TAI VIET VOWEL AM
  { 0xAABF, BIDI_NSM },  // TAI VIET TONE MAI EK
  { 0xAAC0, BIDI_L   },  // TAI VIET TONE MAI NUENG
  { 0xAAC1, BIDI_NSM },  // TAI VIET TONE MAI THO
  { 0xAAC2, BIDI_L   },  // TAI VIET TONE MAI SONG
  { 0xAADB, BIDI_L   },  // TAI VIET SYMBOL KON
  { 0xAADC, BIDI_L   },  // TAI VIET SYMBOL NUENG
  { 0xAADD, BIDI_L   },  // TAI VIET SYMBOL SAM
  { 0xAADE, BIDI_L   },  // TAI VIET SYMBOL HO HOI
  { 0xAADF, BIDI_L   },  // TAI VIET SYMBOL KOI KOI
  { 0xAAE0, BIDI_L   },  // MEETEI MAYEK LETTER E
  { 0xAAE1, BIDI_L   },  // MEETEI MAYEK LETTER O
  { 0xAAE2, BIDI_L   },  // MEETEI MAYEK LETTER CHA
  { 0xAAE3, BIDI_L   },  // MEETEI MAYEK LETTER NYA
  { 0xAAE4, BIDI_L   },  // MEETEI MAYEK LETTER TTA
  { 0xAAE5, BIDI_L   },  // MEETEI MAYEK LETTER TTHA
  { 0xAAE6, BIDI_L   },  // MEETEI MAYEK LETTER DDA
  { 0xAAE7, BIDI_L   },  // MEETEI MAYEK LETTER DDHA
  { 0xAAE8, BIDI_L   },  // MEETEI MAYEK LETTER NNA
  { 0xAAE9, BIDI_L   },  // MEETEI MAYEK LETTER SHA
  { 0xAAEA, BIDI_L   },  // MEETEI MAYEK LETTER SSA
  { 0xAAEB, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN II
  { 0xAAEC, BIDI_NSM },  // MEETEI MAYEK VOWEL SIGN UU
  { 0xAAED, BIDI_NSM },  // MEETEI MAYEK VOWEL SIGN AAI
  { 0xAAEE, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN AU
  { 0xAAEF, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN AAU
  { 0xAAF0, BIDI_L   },  // MEETEI MAYEK CHEIKHAN
  { 0xAAF1, BIDI_L   },  // MEETEI MAYEK AHANG KHUDAM
  { 0xAAF2, BIDI_L   },  // MEETEI MAYEK ANJI
  { 0xAAF3, BIDI_L   },  // MEETEI MAYEK SYLLABLE REPETITION MARK
  { 0xAAF4, BIDI_L   },  // MEETEI MAYEK WORD REPETITION MARK
  { 0xAAF5, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN VISARGA
  { 0xAAF6, BIDI_NSM },  // MEETEI MAYEK VIRAMA
  { 0xAB01, BIDI_L   },  // ETHIOPIC SYLLABLE TTHU
  { 0xAB02, BIDI_L   },  // ETHIOPIC SYLLABLE TTHI
  { 0xAB03, BIDI_L   },  // ETHIOPIC SYLLABLE TTHAA
  { 0xAB04, BIDI_L   },  // ETHIOPIC SYLLABLE TTHEE
  { 0xAB05, BIDI_L   },  // ETHIOPIC SYLLABLE TTHE
  { 0xAB06, BIDI_L   },  // ETHIOPIC SYLLABLE TTHO
  { 0xAB09, BIDI_L   },  // ETHIOPIC SYLLABLE DDHU
  { 0xAB0A, BIDI_L   },  // ETHIOPIC SYLLABLE DDHI
  { 0xAB0B, BIDI_L   },  // ETHIOPIC SYLLABLE DDHAA
  { 0xAB0C, BIDI_L   },  // ETHIOPIC SYLLABLE DDHEE
  { 0xAB0D, BIDI_L   },  // ETHIOPIC SYLLABLE DDHE
  { 0xAB0E, BIDI_L   },  // ETHIOPIC SYLLABLE DDHO
  { 0xAB11, BIDI_L   },  // ETHIOPIC SYLLABLE DZU
  { 0xAB12, BIDI_L   },  // ETHIOPIC SYLLABLE DZI
  { 0xAB13, BIDI_L   },  // ETHIOPIC SYLLABLE DZAA
  { 0xAB14, BIDI_L   },  // ETHIOPIC SYLLABLE DZEE
  { 0xAB15, BIDI_L   },  // ETHIOPIC SYLLABLE DZE
  { 0xAB16, BIDI_L   },  // ETHIOPIC SYLLABLE DZO
  { 0xAB20, BIDI_L   },  // ETHIOPIC SYLLABLE CCHHA
  { 0xAB21, BIDI_L   },  // ETHIOPIC SYLLABLE CCHHU
  { 0xAB22, BIDI_L   },  // ETHIOPIC SYLLABLE CCHHI
  { 0xAB23, BIDI_L   },  // ETHIOPIC SYLLABLE CCHHAA
  { 0xAB24, BIDI_L   },  // ETHIOPIC SYLLABLE CCHHEE
  { 0xAB25, BIDI_L   },  // ETHIOPIC SYLLABLE CCHHE
  { 0xAB26, BIDI_L   },  // ETHIOPIC SYLLABLE CCHHO
  { 0xAB28, BIDI_L   },  // ETHIOPIC SYLLABLE BBA
  { 0xAB29, BIDI_L   },  // ETHIOPIC SYLLABLE BBU
  { 0xAB2A, BIDI_L   },  // ETHIOPIC SYLLABLE BBI
  { 0xAB2B, BIDI_L   },  // ETHIOPIC SYLLABLE BBAA
  { 0xAB2C, BIDI_L   },  // ETHIOPIC SYLLABLE BBEE
  { 0xAB2D, BIDI_L   },  // ETHIOPIC SYLLABLE BBE
  { 0xAB2E, BIDI_L   },  // ETHIOPIC SYLLABLE BBO
  { 0xAB30, BIDI_L   },  // LATIN SMALL LETTER BARRED ALPHA
  { 0xAB31, BIDI_L   },  // LATIN SMALL LETTER A REVERSED-SCHWA
  { 0xAB32, BIDI_L   },  // LATIN SMALL LETTER BLACKLETTER E
  { 0xAB33, BIDI_L   },  // LATIN SMALL LETTER BARRED E
  { 0xAB34, BIDI_L   },  // LATIN SMALL LETTER E WITH FLOURISH
  { 0xAB35, BIDI_L   },  // LATIN SMALL LETTER LENIS F
  { 0xAB36, BIDI_L   },  // LATIN SMALL LETTER SCRIPT G WITH CROSSED-TAIL
  { 0xAB37, BIDI_L   },  // LATIN SMALL LETTER L WITH INVERTED LAZY S
  { 0xAB38, BIDI_L   },  // LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE
  { 0xAB39, BIDI_L   },  // LATIN SMALL LETTER L WITH MIDDLE RING
  { 0xAB3A, BIDI_L   },  // LATIN SMALL LETTER M WITH CROSSED-TAIL
  { 0xAB3B, BIDI_L   },  // LATIN SMALL LETTER N WITH CROSSED-TAIL
  { 0xAB3C, BIDI_L   },  // LATIN SMALL LETTER ENG WITH CROSSED-TAIL
  { 0xAB3D, BIDI_L   },  // LATIN SMALL LETTER BLACKLETTER O
  { 0xAB3E, BIDI_L   },  // LATIN SMALL LETTER BLACKLETTER O WITH STROKE
  { 0xAB3F, BIDI_L   },  // LATIN SMALL LETTER OPEN O WITH STROKE
  { 0xAB40, BIDI_L   },  // LATIN SMALL LETTER INVERTED OE
  { 0xAB41, BIDI_L   },  // LATIN SMALL LETTER TURNED OE WITH STROKE
  { 0xAB42, BIDI_L   },  // LATIN SMALL LETTER TURNED OE WITH HORIZONTAL STROKE
  { 0xAB43, BIDI_L   },  // LATIN SMALL LETTER TURNED O OPEN-O
  { 0xAB44, BIDI_L   },  // LATIN SMALL LETTER TURNED O OPEN-O WITH STROKE
  { 0xAB45, BIDI_L   },  // LATIN SMALL LETTER STIRRUP R
  { 0xAB46, BIDI_L   },  // LATIN LETTER SMALL CAPITAL R WITH RIGHT LEG
  { 0xAB47, BIDI_L   },  // LATIN SMALL LETTER R WITHOUT HANDLE
  { 0xAB48, BIDI_L   },  // LATIN SMALL LETTER DOUBLE R
  { 0xAB49, BIDI_L   },  // LATIN SMALL LETTER R WITH CROSSED-TAIL
  { 0xAB4A, BIDI_L   },  // LATIN SMALL LETTER DOUBLE R WITH CROSSED-TAIL
  { 0xAB4B, BIDI_L   },  // LATIN SMALL LETTER SCRIPT R
  { 0xAB4C, BIDI_L   },  // LATIN SMALL LETTER SCRIPT R WITH RING
  { 0xAB4D, BIDI_L   },  // LATIN SMALL LETTER BASELINE ESH
  { 0xAB4E, BIDI_L   },  // LATIN SMALL LETTER U WITH SHORT RIGHT LEG
  { 0xAB4F, BIDI_L   },  // LATIN SMALL LETTER U BAR WITH SHORT RIGHT LEG
  { 0xAB50, BIDI_L   },  // LATIN SMALL LETTER UI
  { 0xAB51, BIDI_L   },  // LATIN SMALL LETTER TURNED UI
  { 0xAB52, BIDI_L   },  // LATIN SMALL LETTER U WITH LEFT HOOK
  { 0xAB53, BIDI_L   },  // LATIN SMALL LETTER CHI
  { 0xAB54, BIDI_L   },  // LATIN SMALL LETTER CHI WITH LOW RIGHT RING
  { 0xAB55, BIDI_L   },  // LATIN SMALL LETTER CHI WITH LOW LEFT SERIF
  { 0xAB56, BIDI_L   },  // LATIN SMALL LETTER X WITH LOW RIGHT RING
  { 0xAB57, BIDI_L   },  // LATIN SMALL LETTER X WITH LONG LEFT LEG
  { 0xAB58, BIDI_L   },  // LATIN SMALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RING
  { 0xAB59, BIDI_L   },  // LATIN SMALL LETTER X WITH LONG LEFT LEG WITH SERIF
  { 0xAB5A, BIDI_L   },  // LATIN SMALL LETTER Y WITH SHORT RIGHT LEG
  { 0xAB5B, BIDI_L   },  // MODIFIER BREVE WITH INVERTED BREVE
  { 0xAB5C, BIDI_L   },  // MODIFIER LETTER SMALL HENG
  { 0xAB5D, BIDI_L   },  // MODIFIER LETTER SMALL L WITH INVERTED LAZY S
  { 0xAB5E, BIDI_L   },  // MODIFIER LETTER SMALL L WITH MIDDLE TILDE
  { 0xAB5F, BIDI_L   },  // MODIFIER LETTER SMALL U WITH LEFT HOOK
  { 0xAB60, BIDI_L   },  // LATIN SMALL LETTER SAKHA YAT
  { 0xAB61, BIDI_L   },  // LATIN SMALL LETTER IOTIFIED E
  { 0xAB62, BIDI_L   },  // LATIN SMALL LETTER OPEN OE
  { 0xAB63, BIDI_L   },  // LATIN SMALL LETTER UO
  { 0xAB64, BIDI_L   },  // LATIN SMALL LETTER INVERTED ALPHA
  { 0xAB65, BIDI_L   },  // GREEK LETTER SMALL CAPITAL OMEGA
  { 0xAB70, BIDI_L   },  // CHEROKEE SMALL LETTER A
  { 0xAB71, BIDI_L   },  // CHEROKEE SMALL LETTER E
  { 0xAB72, BIDI_L   },  // CHEROKEE SMALL LETTER I
  { 0xAB73, BIDI_L   },  // CHEROKEE SMALL LETTER O
  { 0xAB74, BIDI_L   },  // CHEROKEE SMALL LETTER U
  { 0xAB75, BIDI_L   },  // CHEROKEE SMALL LETTER V
  { 0xAB76, BIDI_L   },  // CHEROKEE SMALL LETTER GA
  { 0xAB77, BIDI_L   },  // CHEROKEE SMALL LETTER KA
  { 0xAB78, BIDI_L   },  // CHEROKEE SMALL LETTER GE
  { 0xAB79, BIDI_L   },  // CHEROKEE SMALL LETTER GI
  { 0xAB7A, BIDI_L   },  // CHEROKEE SMALL LETTER GO
  { 0xAB7B, BIDI_L   },  // CHEROKEE SMALL LETTER GU
  { 0xAB7C, BIDI_L   },  // CHEROKEE SMALL LETTER GV
  { 0xAB7D, BIDI_L   },  // CHEROKEE SMALL LETTER HA
  { 0xAB7E, BIDI_L   },  // CHEROKEE SMALL LETTER HE
  { 0xAB7F, BIDI_L   },  // CHEROKEE SMALL LETTER HI
  { 0xAB80, BIDI_L   },  // CHEROKEE SMALL LETTER HO
  { 0xAB81, BIDI_L   },  // CHEROKEE SMALL LETTER HU
  { 0xAB82, BIDI_L   },  // CHEROKEE SMALL LETTER HV
  { 0xAB83, BIDI_L   },  // CHEROKEE SMALL LETTER LA
  { 0xAB84, BIDI_L   },  // CHEROKEE SMALL LETTER LE
  { 0xAB85, BIDI_L   },  // CHEROKEE SMALL LETTER LI
  { 0xAB86, BIDI_L   },  // CHEROKEE SMALL LETTER LO
  { 0xAB87, BIDI_L   },  // CHEROKEE SMALL LETTER LU
  { 0xAB88, BIDI_L   },  // CHEROKEE SMALL LETTER LV
  { 0xAB89, BIDI_L   },  // CHEROKEE SMALL LETTER MA
  { 0xAB8A, BIDI_L   },  // CHEROKEE SMALL LETTER ME
  { 0xAB8B, BIDI_L   },  // CHEROKEE SMALL LETTER MI
  { 0xAB8C, BIDI_L   },  // CHEROKEE SMALL LETTER MO
  { 0xAB8D, BIDI_L   },  // CHEROKEE SMALL LETTER MU
  { 0xAB8E, BIDI_L   },  // CHEROKEE SMALL LETTER NA
  { 0xAB8F, BIDI_L   },  // CHEROKEE SMALL LETTER HNA
  { 0xAB90, BIDI_L   },  // CHEROKEE SMALL LETTER NAH
  { 0xAB91, BIDI_L   },  // CHEROKEE SMALL LETTER NE
  { 0xAB92, BIDI_L   },  // CHEROKEE SMALL LETTER NI
  { 0xAB93, BIDI_L   },  // CHEROKEE SMALL LETTER NO
  { 0xAB94, BIDI_L   },  // CHEROKEE SMALL LETTER NU
  { 0xAB95, BIDI_L   },  // CHEROKEE SMALL LETTER NV
  { 0xAB96, BIDI_L   },  // CHEROKEE SMALL LETTER QUA
  { 0xAB97, BIDI_L   },  // CHEROKEE SMALL LETTER QUE
  { 0xAB98, BIDI_L   },  // CHEROKEE SMALL LETTER QUI
  { 0xAB99, BIDI_L   },  // CHEROKEE SMALL LETTER QUO
  { 0xAB9A, BIDI_L   },  // CHEROKEE SMALL LETTER QUU
  { 0xAB9B, BIDI_L   },  // CHEROKEE SMALL LETTER QUV
  { 0xAB9C, BIDI_L   },  // CHEROKEE SMALL LETTER SA
  { 0xAB9D, BIDI_L   },  // CHEROKEE SMALL LETTER S
  { 0xAB9E, BIDI_L   },  // CHEROKEE SMALL LETTER SE
  { 0xAB9F, BIDI_L   },  // CHEROKEE SMALL LETTER SI
  { 0xABA0, BIDI_L   },  // CHEROKEE SMALL LETTER SO
  { 0xABA1, BIDI_L   },  // CHEROKEE SMALL LETTER SU
  { 0xABA2, BIDI_L   },  // CHEROKEE SMALL LETTER SV
  { 0xABA3, BIDI_L   },  // CHEROKEE SMALL LETTER DA
  { 0xABA4, BIDI_L   },  // CHEROKEE SMALL LETTER TA
  { 0xABA5, BIDI_L   },  // CHEROKEE SMALL LETTER DE
  { 0xABA6, BIDI_L   },  // CHEROKEE SMALL LETTER TE
  { 0xABA7, BIDI_L   },  // CHEROKEE SMALL LETTER DI
  { 0xABA8, BIDI_L   },  // CHEROKEE SMALL LETTER TI
  { 0xABA9, BIDI_L   },  // CHEROKEE SMALL LETTER DO
  { 0xABAA, BIDI_L   },  // CHEROKEE SMALL LETTER DU
  { 0xABAB, BIDI_L   },  // CHEROKEE SMALL LETTER DV
  { 0xABAC, BIDI_L   },  // CHEROKEE SMALL LETTER DLA
  { 0xABAD, BIDI_L   },  // CHEROKEE SMALL LETTER TLA
  { 0xABAE, BIDI_L   },  // CHEROKEE SMALL LETTER TLE
  { 0xABAF, BIDI_L   },  // CHEROKEE SMALL LETTER TLI
  { 0xABB0, BIDI_L   },  // CHEROKEE SMALL LETTER TLO
  { 0xABB1, BIDI_L   },  // CHEROKEE SMALL LETTER TLU
  { 0xABB2, BIDI_L   },  // CHEROKEE SMALL LETTER TLV
  { 0xABB3, BIDI_L   },  // CHEROKEE SMALL LETTER TSA
  { 0xABB4, BIDI_L   },  // CHEROKEE SMALL LETTER TSE
  { 0xABB5, BIDI_L   },  // CHEROKEE SMALL LETTER TSI
  { 0xABB6, BIDI_L   },  // CHEROKEE SMALL LETTER TSO
  { 0xABB7, BIDI_L   },  // CHEROKEE SMALL LETTER TSU
  { 0xABB8, BIDI_L   },  // CHEROKEE SMALL LETTER TSV
  { 0xABB9, BIDI_L   },  // CHEROKEE SMALL LETTER WA
  { 0xABBA, BIDI_L   },  // CHEROKEE SMALL LETTER WE
  { 0xABBB, BIDI_L   },  // CHEROKEE SMALL LETTER WI
  { 0xABBC, BIDI_L   },  // CHEROKEE SMALL LETTER WO
  { 0xABBD, BIDI_L   },  // CHEROKEE SMALL LETTER WU
  { 0xABBE, BIDI_L   },  // CHEROKEE SMALL LETTER WV
  { 0xABBF, BIDI_L   },  // CHEROKEE SMALL LETTER YA
  { 0xABC0, BIDI_L   },  // MEETEI MAYEK LETTER KOK
  { 0xABC1, BIDI_L   },  // MEETEI MAYEK LETTER SAM
  { 0xABC2, BIDI_L   },  // MEETEI MAYEK LETTER LAI
  { 0xABC3, BIDI_L   },  // MEETEI MAYEK LETTER MIT
  { 0xABC4, BIDI_L   },  // MEETEI MAYEK LETTER PA
  { 0xABC5, BIDI_L   },  // MEETEI MAYEK LETTER NA
  { 0xABC6, BIDI_L   },  // MEETEI MAYEK LETTER CHIL
  { 0xABC7, BIDI_L   },  // MEETEI MAYEK LETTER TIL
  { 0xABC8, BIDI_L   },  // MEETEI MAYEK LETTER KHOU
  { 0xABC9, BIDI_L   },  // MEETEI MAYEK LETTER NGOU
  { 0xABCA, BIDI_L   },  // MEETEI MAYEK LETTER THOU
  { 0xABCB, BIDI_L   },  // MEETEI MAYEK LETTER WAI
  { 0xABCC, BIDI_L   },  // MEETEI MAYEK LETTER YANG
  { 0xABCD, BIDI_L   },  // MEETEI MAYEK LETTER HUK
  { 0xABCE, BIDI_L   },  // MEETEI MAYEK LETTER UN
  { 0xABCF, BIDI_L   },  // MEETEI MAYEK LETTER I
  { 0xABD0, BIDI_L   },  // MEETEI MAYEK LETTER PHAM
  { 0xABD1, BIDI_L   },  // MEETEI MAYEK LETTER ATIYA
  { 0xABD2, BIDI_L   },  // MEETEI MAYEK LETTER GOK
  { 0xABD3, BIDI_L   },  // MEETEI MAYEK LETTER JHAM
  { 0xABD4, BIDI_L   },  // MEETEI MAYEK LETTER RAI
  { 0xABD5, BIDI_L   },  // MEETEI MAYEK LETTER BA
  { 0xABD6, BIDI_L   },  // MEETEI MAYEK LETTER JIL
  { 0xABD7, BIDI_L   },  // MEETEI MAYEK LETTER DIL
  { 0xABD8, BIDI_L   },  // MEETEI MAYEK LETTER GHOU
  { 0xABD9, BIDI_L   },  // MEETEI MAYEK LETTER DHOU
  { 0xABDA, BIDI_L   },  // MEETEI MAYEK LETTER BHAM
  { 0xABDB, BIDI_L   },  // MEETEI MAYEK LETTER KOK LONSUM
  { 0xABDC, BIDI_L   },  // MEETEI MAYEK LETTER LAI LONSUM
  { 0xABDD, BIDI_L   },  // MEETEI MAYEK LETTER MIT LONSUM
  { 0xABDE, BIDI_L   },  // MEETEI MAYEK LETTER PA LONSUM
  { 0xABDF, BIDI_L   },  // MEETEI MAYEK LETTER NA LONSUM
  { 0xABE0, BIDI_L   },  // MEETEI MAYEK LETTER TIL LONSUM
  { 0xABE1, BIDI_L   },  // MEETEI MAYEK LETTER NGOU LONSUM
  { 0xABE2, BIDI_L   },  // MEETEI MAYEK LETTER I LONSUM
  { 0xABE3, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN ONAP
  { 0xABE4, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN INAP
  { 0xABE5, BIDI_NSM },  // MEETEI MAYEK VOWEL SIGN ANAP
  { 0xABE6, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN YENAP
  { 0xABE7, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN SOUNAP
  { 0xABE8, BIDI_NSM },  // MEETEI MAYEK VOWEL SIGN UNAP
  { 0xABE9, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN CHEINAP
  { 0xABEA, BIDI_L   },  // MEETEI MAYEK VOWEL SIGN NUNG
  { 0xABEB, BIDI_L   },  // MEETEI MAYEK CHEIKHEI
  { 0xABEC, BIDI_L   },  // MEETEI MAYEK LUM IYEK
  { 0xABED, BIDI_NSM },  // MEETEI MAYEK APUN IYEK
  { 0xABF0, BIDI_L   },  // MEETEI MAYEK DIGIT ZERO
  { 0xABF1, BIDI_L   },  // MEETEI MAYEK DIGIT ONE
  { 0xABF2, BIDI_L   },  // MEETEI MAYEK DIGIT TWO
  { 0xABF3, BIDI_L   },  // MEETEI MAYEK DIGIT THREE
  { 0xABF4, BIDI_L   },  // MEETEI MAYEK DIGIT FOUR
  { 0xABF5, BIDI_L   },  // MEETEI MAYEK DIGIT FIVE
  { 0xABF6, BIDI_L   },  // MEETEI MAYEK DIGIT SIX
  { 0xABF7, BIDI_L   },  // MEETEI MAYEK DIGIT SEVEN
  { 0xABF8, BIDI_L   },  // MEETEI MAYEK DIGIT EIGHT
  { 0xABF9, BIDI_L   },  // MEETEI MAYEK DIGIT NINE
  //{ 0xAC00, BIDI_L   },  // <Hangul Syllable, First>
  //{ 0xD7A3, BIDI_L   },  // <Hangul Syllable, Last>

#endif
#if (GUI_BIDI_SUPPORT_RANGE_D == 1)

  { 0xD7B0, BIDI_L   },  // HANGUL JUNGSEONG O-YEO
  { 0xD7B1, BIDI_L   },  // HANGUL JUNGSEONG O-O-I
  { 0xD7B2, BIDI_L   },  // HANGUL JUNGSEONG YO-A
  { 0xD7B3, BIDI_L   },  // HANGUL JUNGSEONG YO-AE
  { 0xD7B4, BIDI_L   },  // HANGUL JUNGSEONG YO-EO
  { 0xD7B5, BIDI_L   },  // HANGUL JUNGSEONG U-YEO
  { 0xD7B6, BIDI_L   },  // HANGUL JUNGSEONG U-I-I
  { 0xD7B7, BIDI_L   },  // HANGUL JUNGSEONG YU-AE
  { 0xD7B8, BIDI_L   },  // HANGUL JUNGSEONG YU-O
  { 0xD7B9, BIDI_L   },  // HANGUL JUNGSEONG EU-A
  { 0xD7BA, BIDI_L   },  // HANGUL JUNGSEONG EU-EO
  { 0xD7BB, BIDI_L   },  // HANGUL JUNGSEONG EU-E
  { 0xD7BC, BIDI_L   },  // HANGUL JUNGSEONG EU-O
  { 0xD7BD, BIDI_L   },  // HANGUL JUNGSEONG I-YA-O
  { 0xD7BE, BIDI_L   },  // HANGUL JUNGSEONG I-YAE
  { 0xD7BF, BIDI_L   },  // HANGUL JUNGSEONG I-YEO
  { 0xD7C0, BIDI_L   },  // HANGUL JUNGSEONG I-YE
  { 0xD7C1, BIDI_L   },  // HANGUL JUNGSEONG I-O-I
  { 0xD7C2, BIDI_L   },  // HANGUL JUNGSEONG I-YO
  { 0xD7C3, BIDI_L   },  // HANGUL JUNGSEONG I-YU
  { 0xD7C4, BIDI_L   },  // HANGUL JUNGSEONG I-I
  { 0xD7C5, BIDI_L   },  // HANGUL JUNGSEONG ARAEA-A
  { 0xD7C6, BIDI_L   },  // HANGUL JUNGSEONG ARAEA-E
  { 0xD7CB, BIDI_L   },  // HANGUL JONGSEONG NIEUN-RIEUL
  { 0xD7CC, BIDI_L   },  // HANGUL JONGSEONG NIEUN-CHIEUCH
  { 0xD7CD, BIDI_L   },  // HANGUL JONGSEONG SSANGTIKEUT
  { 0xD7CE, BIDI_L   },  // HANGUL JONGSEONG SSANGTIKEUT-PIEUP
  { 0xD7CF, BIDI_L   },  // HANGUL JONGSEONG TIKEUT-PIEUP
  { 0xD7D0, BIDI_L   },  // HANGUL JONGSEONG TIKEUT-SIOS
  { 0xD7D1, BIDI_L   },  // HANGUL JONGSEONG TIKEUT-SIOS-KIYEOK
  { 0xD7D2, BIDI_L   },  // HANGUL JONGSEONG TIKEUT-CIEUC
  { 0xD7D3, BIDI_L   },  // HANGUL JONGSEONG TIKEUT-CHIEUCH
  { 0xD7D4, BIDI_L   },  // HANGUL JONGSEONG TIKEUT-THIEUTH
  { 0xD7D5, BIDI_L   },  // HANGUL JONGSEONG RIEUL-SSANGKIYEOK
  { 0xD7D6, BIDI_L   },  // HANGUL JONGSEONG RIEUL-KIYEOK-HIEUH
  { 0xD7D7, BIDI_L   },  // HANGUL JONGSEONG SSANGRIEUL-KHIEUKH
  { 0xD7D8, BIDI_L   },  // HANGUL JONGSEONG RIEUL-MIEUM-HIEUH
  { 0xD7D9, BIDI_L   },  // HANGUL JONGSEONG RIEUL-PIEUP-TIKEUT
  { 0xD7DA, BIDI_L   },  // HANGUL JONGSEONG RIEUL-PIEUP-PHIEUPH
  { 0xD7DB, BIDI_L   },  // HANGUL JONGSEONG RIEUL-YESIEUNG
  { 0xD7DC, BIDI_L   },  // HANGUL JONGSEONG RIEUL-YEORINHIEUH-HIEUH
  { 0xD7DD, BIDI_L   },  // HANGUL JONGSEONG KAPYEOUNRIEUL
  { 0xD7DE, BIDI_L   },  // HANGUL JONGSEONG MIEUM-NIEUN
  { 0xD7DF, BIDI_L   },  // HANGUL JONGSEONG MIEUM-SSANGNIEUN
  { 0xD7E0, BIDI_L   },  // HANGUL JONGSEONG SSANGMIEUM
  { 0xD7E1, BIDI_L   },  // HANGUL JONGSEONG MIEUM-PIEUP-SIOS
  { 0xD7E2, BIDI_L   },  // HANGUL JONGSEONG MIEUM-CIEUC
  { 0xD7E3, BIDI_L   },  // HANGUL JONGSEONG PIEUP-TIKEUT
  { 0xD7E4, BIDI_L   },  // HANGUL JONGSEONG PIEUP-RIEUL-PHIEUPH
  { 0xD7E5, BIDI_L   },  // HANGUL JONGSEONG PIEUP-MIEUM
  { 0xD7E6, BIDI_L   },  // HANGUL JONGSEONG SSANGPIEUP
  { 0xD7E7, BIDI_L   },  // HANGUL JONGSEONG PIEUP-SIOS-TIKEUT
  { 0xD7E8, BIDI_L   },  // HANGUL JONGSEONG PIEUP-CIEUC
  { 0xD7E9, BIDI_L   },  // HANGUL JONGSEONG PIEUP-CHIEUCH
  { 0xD7EA, BIDI_L   },  // HANGUL JONGSEONG SIOS-MIEUM
  { 0xD7EB, BIDI_L   },  // HANGUL JONGSEONG SIOS-KAPYEOUNPIEUP
  { 0xD7EC, BIDI_L   },  // HANGUL JONGSEONG SSANGSIOS-KIYEOK
  { 0xD7ED, BIDI_L   },  // HANGUL JONGSEONG SSANGSIOS-TIKEUT
  { 0xD7EE, BIDI_L   },  // HANGUL JONGSEONG SIOS-PANSIOS
  { 0xD7EF, BIDI_L   },  // HANGUL JONGSEONG SIOS-CIEUC
  { 0xD7F0, BIDI_L   },  // HANGUL JONGSEONG SIOS-CHIEUCH
  { 0xD7F1, BIDI_L   },  // HANGUL JONGSEONG SIOS-THIEUTH
  { 0xD7F2, BIDI_L   },  // HANGUL JONGSEONG SIOS-HIEUH
  { 0xD7F3, BIDI_L   },  // HANGUL JONGSEONG PANSIOS-PIEUP
  { 0xD7F4, BIDI_L   },  // HANGUL JONGSEONG PANSIOS-KAPYEOUNPIEUP
  { 0xD7F5, BIDI_L   },  // HANGUL JONGSEONG YESIEUNG-MIEUM
  { 0xD7F6, BIDI_L   },  // HANGUL JONGSEONG YESIEUNG-HIEUH
  { 0xD7F7, BIDI_L   },  // HANGUL JONGSEONG CIEUC-PIEUP
  { 0xD7F8, BIDI_L   },  // HANGUL JONGSEONG CIEUC-SSANGPIEUP
  { 0xD7F9, BIDI_L   },  // HANGUL JONGSEONG SSANGCIEUC
  { 0xD7FA, BIDI_L   },  // HANGUL JONGSEONG PHIEUPH-SIOS
  { 0xD7FB, BIDI_L   },  // HANGUL JONGSEONG PHIEUPH-THIEUTH
  //{ 0xD800, BIDI_L   },  // <Non Private Use High Surrogate, First>
  //{ 0xDB7F, BIDI_L   },  // <Non Private Use High Surrogate, Last>
  //{ 0xDB80, BIDI_L   },  // <Private Use High Surrogate, First>
  //{ 0xDBFF, BIDI_L   },  // <Private Use High Surrogate, Last>
  //{ 0xDC00, BIDI_L   },  // <Low Surrogate, First>
  //{ 0xDFFF, BIDI_L   },  // <Low Surrogate, Last>
  //{ 0xE000, BIDI_L   },  // <Private Use, First>
  //{ 0xF8FF, BIDI_L   },  // <Private Use, Last>

#endif
#if (GUI_BIDI_SUPPORT_RANGE_F == 1)

  { 0xF900, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F900
  { 0xF901, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F901
  { 0xF902, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F902
  { 0xF903, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F903
  { 0xF904, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F904
  { 0xF905, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F905
  { 0xF906, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F906
  { 0xF907, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F907
  { 0xF908, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F908
  { 0xF909, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F909
  { 0xF90A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F90A
  { 0xF90B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F90B
  { 0xF90C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F90C
  { 0xF90D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F90D
  { 0xF90E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F90E
  { 0xF90F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F90F
  { 0xF910, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F910
  { 0xF911, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F911
  { 0xF912, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F912
  { 0xF913, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F913
  { 0xF914, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F914
  { 0xF915, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F915
  { 0xF916, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F916
  { 0xF917, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F917
  { 0xF918, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F918
  { 0xF919, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F919
  { 0xF91A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F91A
  { 0xF91B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F91B
  { 0xF91C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F91C
  { 0xF91D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F91D
  { 0xF91E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F91E
  { 0xF91F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F91F
  { 0xF920, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F920
  { 0xF921, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F921
  { 0xF922, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F922
  { 0xF923, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F923
  { 0xF924, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F924
  { 0xF925, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F925
  { 0xF926, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F926
  { 0xF927, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F927
  { 0xF928, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F928
  { 0xF929, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F929
  { 0xF92A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F92A
  { 0xF92B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F92B
  { 0xF92C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F92C
  { 0xF92D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F92D
  { 0xF92E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F92E
  { 0xF92F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F92F
  { 0xF930, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F930
  { 0xF931, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F931
  { 0xF932, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F932
  { 0xF933, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F933
  { 0xF934, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F934
  { 0xF935, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F935
  { 0xF936, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F936
  { 0xF937, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F937
  { 0xF938, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F938
  { 0xF939, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F939
  { 0xF93A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F93A
  { 0xF93B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F93B
  { 0xF93C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F93C
  { 0xF93D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F93D
  { 0xF93E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F93E
  { 0xF93F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F93F
  { 0xF940, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F940
  { 0xF941, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F941
  { 0xF942, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F942
  { 0xF943, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F943
  { 0xF944, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F944
  { 0xF945, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F945
  { 0xF946, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F946
  { 0xF947, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F947
  { 0xF948, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F948
  { 0xF949, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F949
  { 0xF94A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F94A
  { 0xF94B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F94B
  { 0xF94C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F94C
  { 0xF94D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F94D
  { 0xF94E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F94E
  { 0xF94F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F94F
  { 0xF950, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F950
  { 0xF951, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F951
  { 0xF952, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F952
  { 0xF953, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F953
  { 0xF954, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F954
  { 0xF955, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F955
  { 0xF956, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F956
  { 0xF957, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F957
  { 0xF958, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F958
  { 0xF959, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F959
  { 0xF95A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F95A
  { 0xF95B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F95B
  { 0xF95C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F95C
  { 0xF95D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F95D
  { 0xF95E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F95E
  { 0xF95F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F95F
  { 0xF960, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F960
  { 0xF961, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F961
  { 0xF962, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F962
  { 0xF963, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F963
  { 0xF964, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F964
  { 0xF965, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F965
  { 0xF966, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F966
  { 0xF967, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F967
  { 0xF968, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F968
  { 0xF969, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F969
  { 0xF96A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F96A
  { 0xF96B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F96B
  { 0xF96C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F96C
  { 0xF96D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F96D
  { 0xF96E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F96E
  { 0xF96F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F96F
  { 0xF970, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F970
  { 0xF971, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F971
  { 0xF972, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F972
  { 0xF973, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F973
  { 0xF974, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F974
  { 0xF975, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F975
  { 0xF976, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F976
  { 0xF977, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F977
  { 0xF978, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F978
  { 0xF979, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F979
  { 0xF97A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F97A
  { 0xF97B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F97B
  { 0xF97C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F97C
  { 0xF97D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F97D
  { 0xF97E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F97E
  { 0xF97F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F97F
  { 0xF980, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F980
  { 0xF981, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F981
  { 0xF982, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F982
  { 0xF983, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F983
  { 0xF984, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F984
  { 0xF985, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F985
  { 0xF986, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F986
  { 0xF987, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F987
  { 0xF988, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F988
  { 0xF989, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F989
  { 0xF98A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F98A
  { 0xF98B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F98B
  { 0xF98C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F98C
  { 0xF98D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F98D
  { 0xF98E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F98E
  { 0xF98F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F98F
  { 0xF990, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F990
  { 0xF991, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F991
  { 0xF992, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F992
  { 0xF993, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F993
  { 0xF994, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F994
  { 0xF995, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F995
  { 0xF996, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F996
  { 0xF997, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F997
  { 0xF998, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F998
  { 0xF999, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F999
  { 0xF99A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F99A
  { 0xF99B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F99B
  { 0xF99C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F99C
  { 0xF99D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F99D
  { 0xF99E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F99E
  { 0xF99F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F99F
  { 0xF9A0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A0
  { 0xF9A1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A1
  { 0xF9A2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A2
  { 0xF9A3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A3
  { 0xF9A4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A4
  { 0xF9A5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A5
  { 0xF9A6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A6
  { 0xF9A7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A7
  { 0xF9A8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A8
  { 0xF9A9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9A9
  { 0xF9AA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9AA
  { 0xF9AB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9AB
  { 0xF9AC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9AC
  { 0xF9AD, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9AD
  { 0xF9AE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9AE
  { 0xF9AF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9AF
  { 0xF9B0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B0
  { 0xF9B1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B1
  { 0xF9B2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B2
  { 0xF9B3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B3
  { 0xF9B4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B4
  { 0xF9B5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B5
  { 0xF9B6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B6
  { 0xF9B7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B7
  { 0xF9B8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B8
  { 0xF9B9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9B9
  { 0xF9BA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9BA
  { 0xF9BB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9BB
  { 0xF9BC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9BC
  { 0xF9BD, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9BD
  { 0xF9BE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9BE
  { 0xF9BF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9BF
  { 0xF9C0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C0
  { 0xF9C1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C1
  { 0xF9C2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C2
  { 0xF9C3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C3
  { 0xF9C4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C4
  { 0xF9C5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C5
  { 0xF9C6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C6
  { 0xF9C7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C7
  { 0xF9C8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C8
  { 0xF9C9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9C9
  { 0xF9CA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9CA
  { 0xF9CB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9CB
  { 0xF9CC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9CC
  { 0xF9CD, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9CD
  { 0xF9CE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9CE
  { 0xF9CF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9CF
  { 0xF9D0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D0
  { 0xF9D1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D1
  { 0xF9D2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D2
  { 0xF9D3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D3
  { 0xF9D4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D4
  { 0xF9D5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D5
  { 0xF9D6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D6
  { 0xF9D7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D7
  { 0xF9D8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D8
  { 0xF9D9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9D9
  { 0xF9DA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9DA
  { 0xF9DB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9DB
  { 0xF9DC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9DC
  { 0xF9DD, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9DD
  { 0xF9DE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9DE
  { 0xF9DF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9DF
  { 0xF9E0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E0
  { 0xF9E1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E1
  { 0xF9E2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E2
  { 0xF9E3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E3
  { 0xF9E4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E4
  { 0xF9E5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E5
  { 0xF9E6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E6
  { 0xF9E7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E7
  { 0xF9E8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E8
  { 0xF9E9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9E9
  { 0xF9EA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9EA
  { 0xF9EB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9EB
  { 0xF9EC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9EC
  { 0xF9ED, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9ED
  { 0xF9EE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9EE
  { 0xF9EF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9EF
  { 0xF9F0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F0
  { 0xF9F1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F1
  { 0xF9F2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F2
  { 0xF9F3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F3
  { 0xF9F4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F4
  { 0xF9F5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F5
  { 0xF9F6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F6
  { 0xF9F7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F7
  { 0xF9F8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F8
  { 0xF9F9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9F9
  { 0xF9FA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9FA
  { 0xF9FB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9FB
  { 0xF9FC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9FC
  { 0xF9FD, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9FD
  { 0xF9FE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9FE
  { 0xF9FF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-F9FF
  { 0xFA00, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA00
  { 0xFA01, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA01
  { 0xFA02, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA02
  { 0xFA03, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA03
  { 0xFA04, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA04
  { 0xFA05, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA05
  { 0xFA06, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA06
  { 0xFA07, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA07
  { 0xFA08, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA08
  { 0xFA09, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA09
  { 0xFA0A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA0A
  { 0xFA0B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA0B
  { 0xFA0C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA0C
  { 0xFA0D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA0D
  { 0xFA0E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA0E
  { 0xFA0F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA0F
  { 0xFA10, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA10
  { 0xFA11, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA11
  { 0xFA12, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA12
  { 0xFA13, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA13
  { 0xFA14, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA14
  { 0xFA15, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA15
  { 0xFA16, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA16
  { 0xFA17, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA17
  { 0xFA18, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA18
  { 0xFA19, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA19
  { 0xFA1A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA1A
  { 0xFA1B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA1B
  { 0xFA1C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA1C
  { 0xFA1D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA1D
  { 0xFA1E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA1E
  { 0xFA1F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA1F
  { 0xFA20, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA20
  { 0xFA21, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA21
  { 0xFA22, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA22
  { 0xFA23, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA23
  { 0xFA24, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA24
  { 0xFA25, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA25
  { 0xFA26, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA26
  { 0xFA27, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA27
  { 0xFA28, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA28
  { 0xFA29, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA29
  { 0xFA2A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA2A
  { 0xFA2B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA2B
  { 0xFA2C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA2C
  { 0xFA2D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA2D
  { 0xFA2E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA2E
  { 0xFA2F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA2F
  { 0xFA30, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA30
  { 0xFA31, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA31
  { 0xFA32, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA32
  { 0xFA33, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA33
  { 0xFA34, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA34
  { 0xFA35, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA35
  { 0xFA36, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA36
  { 0xFA37, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA37
  { 0xFA38, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA38
  { 0xFA39, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA39
  { 0xFA3A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA3A
  { 0xFA3B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA3B
  { 0xFA3C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA3C
  { 0xFA3D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA3D
  { 0xFA3E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA3E
  { 0xFA3F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA3F
  { 0xFA40, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA40
  { 0xFA41, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA41
  { 0xFA42, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA42
  { 0xFA43, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA43
  { 0xFA44, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA44
  { 0xFA45, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA45
  { 0xFA46, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA46
  { 0xFA47, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA47
  { 0xFA48, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA48
  { 0xFA49, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA49
  { 0xFA4A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA4A
  { 0xFA4B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA4B
  { 0xFA4C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA4C
  { 0xFA4D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA4D
  { 0xFA4E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA4E
  { 0xFA4F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA4F
  { 0xFA50, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA50
  { 0xFA51, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA51
  { 0xFA52, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA52
  { 0xFA53, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA53
  { 0xFA54, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA54
  { 0xFA55, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA55
  { 0xFA56, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA56
  { 0xFA57, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA57
  { 0xFA58, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA58
  { 0xFA59, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA59
  { 0xFA5A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA5A
  { 0xFA5B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA5B
  { 0xFA5C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA5C
  { 0xFA5D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA5D
  { 0xFA5E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA5E
  { 0xFA5F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA5F
  { 0xFA60, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA60
  { 0xFA61, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA61
  { 0xFA62, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA62
  { 0xFA63, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA63
  { 0xFA64, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA64
  { 0xFA65, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA65
  { 0xFA66, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA66
  { 0xFA67, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA67
  { 0xFA68, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA68
  { 0xFA69, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA69
  { 0xFA6A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA6A
  { 0xFA6B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA6B
  { 0xFA6C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA6C
  { 0xFA6D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA6D
  { 0xFA70, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA70
  { 0xFA71, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA71
  { 0xFA72, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA72
  { 0xFA73, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA73
  { 0xFA74, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA74
  { 0xFA75, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA75
  { 0xFA76, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA76
  { 0xFA77, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA77
  { 0xFA78, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA78
  { 0xFA79, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA79
  { 0xFA7A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA7A
  { 0xFA7B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA7B
  { 0xFA7C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA7C
  { 0xFA7D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA7D
  { 0xFA7E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA7E
  { 0xFA7F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA7F
  { 0xFA80, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA80
  { 0xFA81, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA81
  { 0xFA82, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA82
  { 0xFA83, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA83
  { 0xFA84, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA84
  { 0xFA85, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA85
  { 0xFA86, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA86
  { 0xFA87, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA87
  { 0xFA88, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA88
  { 0xFA89, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA89
  { 0xFA8A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA8A
  { 0xFA8B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA8B
  { 0xFA8C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA8C
  { 0xFA8D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA8D
  { 0xFA8E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA8E
  { 0xFA8F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA8F
  { 0xFA90, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA90
  { 0xFA91, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA91
  { 0xFA92, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA92
  { 0xFA93, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA93
  { 0xFA94, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA94
  { 0xFA95, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA95
  { 0xFA96, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA96
  { 0xFA97, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA97
  { 0xFA98, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA98
  { 0xFA99, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA99
  { 0xFA9A, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA9A
  { 0xFA9B, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA9B
  { 0xFA9C, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA9C
  { 0xFA9D, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA9D
  { 0xFA9E, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA9E
  { 0xFA9F, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FA9F
  { 0xFAA0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA0
  { 0xFAA1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA1
  { 0xFAA2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA2
  { 0xFAA3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA3
  { 0xFAA4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA4
  { 0xFAA5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA5
  { 0xFAA6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA6
  { 0xFAA7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA7
  { 0xFAA8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA8
  { 0xFAA9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAA9
  { 0xFAAA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAAA
  { 0xFAAB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAAB
  { 0xFAAC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAAC
  { 0xFAAD, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAAD
  { 0xFAAE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAAE
  { 0xFAAF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAAF
  { 0xFAB0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB0
  { 0xFAB1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB1
  { 0xFAB2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB2
  { 0xFAB3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB3
  { 0xFAB4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB4
  { 0xFAB5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB5
  { 0xFAB6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB6
  { 0xFAB7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB7
  { 0xFAB8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB8
  { 0xFAB9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAB9
  { 0xFABA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FABA
  { 0xFABB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FABB
  { 0xFABC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FABC
  { 0xFABD, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FABD
  { 0xFABE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FABE
  { 0xFABF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FABF
  { 0xFAC0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC0
  { 0xFAC1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC1
  { 0xFAC2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC2
  { 0xFAC3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC3
  { 0xFAC4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC4
  { 0xFAC5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC5
  { 0xFAC6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC6
  { 0xFAC7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC7
  { 0xFAC8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC8
  { 0xFAC9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAC9
  { 0xFACA, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FACA
  { 0xFACB, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FACB
  { 0xFACC, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FACC
  { 0xFACD, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FACD
  { 0xFACE, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FACE
  { 0xFACF, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FACF
  { 0xFAD0, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD0
  { 0xFAD1, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD1
  { 0xFAD2, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD2
  { 0xFAD3, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD3
  { 0xFAD4, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD4
  { 0xFAD5, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD5
  { 0xFAD6, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD6
  { 0xFAD7, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD7
  { 0xFAD8, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD8
  { 0xFAD9, BIDI_L   },  // CJK COMPATIBILITY IDEOGRAPH-FAD9
  { 0xFB00, BIDI_L   },  // LATIN SMALL LIGATURE FF
  { 0xFB01, BIDI_L   },  // LATIN SMALL LIGATURE FI
  { 0xFB02, BIDI_L   },  // LATIN SMALL LIGATURE FL
  { 0xFB03, BIDI_L   },  // LATIN SMALL LIGATURE FFI
  { 0xFB04, BIDI_L   },  // LATIN SMALL LIGATURE FFL
  { 0xFB05, BIDI_L   },  // LATIN SMALL LIGATURE LONG S T
  { 0xFB06, BIDI_L   },  // LATIN SMALL LIGATURE ST
  { 0xFB13, BIDI_L   },  // ARMENIAN SMALL LIGATURE MEN NOW
  { 0xFB14, BIDI_L   },  // ARMENIAN SMALL LIGATURE MEN ECH
  { 0xFB15, BIDI_L   },  // ARMENIAN SMALL LIGATURE MEN INI
  { 0xFB16, BIDI_L   },  // ARMENIAN SMALL LIGATURE VEW NOW
  { 0xFB17, BIDI_L   },  // ARMENIAN SMALL LIGATURE MEN XEH
  { 0xFB1D, BIDI_R   },  // HEBREW LETTER YOD WITH HIRIQ
  { 0xFB1E, BIDI_NSM },  // HEBREW POINT JUDEO-SPANISH VARIKA
  { 0xFB1F, BIDI_R   },  // HEBREW LIGATURE YIDDISH YOD YOD PATAH
  { 0xFB20, BIDI_R   },  // HEBREW LETTER ALTERNATIVE AYIN
  { 0xFB21, BIDI_R   },  // HEBREW LETTER WIDE ALEF
  { 0xFB22, BIDI_R   },  // HEBREW LETTER WIDE DALET
  { 0xFB23, BIDI_R   },  // HEBREW LETTER WIDE HE
  { 0xFB24, BIDI_R   },  // HEBREW LETTER WIDE KAF
  { 0xFB25, BIDI_R   },  // HEBREW LETTER WIDE LAMED
  { 0xFB26, BIDI_R   },  // HEBREW LETTER WIDE FINAL MEM
  { 0xFB27, BIDI_R   },  // HEBREW LETTER WIDE RESH
  { 0xFB28, BIDI_R   },  // HEBREW LETTER WIDE TAV
  { 0xFB29, BIDI_ES  },  // HEBREW LETTER ALTERNATIVE PLUS SIGN
  { 0xFB2A, BIDI_R   },  // HEBREW LETTER SHIN WITH SHIN DOT
  { 0xFB2B, BIDI_R   },  // HEBREW LETTER SHIN WITH SIN DOT
  { 0xFB2C, BIDI_R   },  // HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT
  { 0xFB2D, BIDI_R   },  // HEBREW LETTER SHIN WITH DAGESH AND SIN DOT
  { 0xFB2E, BIDI_R   },  // HEBREW LETTER ALEF WITH PATAH
  { 0xFB2F, BIDI_R   },  // HEBREW LETTER ALEF WITH QAMATS
  { 0xFB30, BIDI_R   },  // HEBREW LETTER ALEF WITH MAPIQ
  { 0xFB31, BIDI_R   },  // HEBREW LETTER BET WITH DAGESH
  { 0xFB32, BIDI_R   },  // HEBREW LETTER GIMEL WITH DAGESH
  { 0xFB33, BIDI_R   },  // HEBREW LETTER DALET WITH DAGESH
  { 0xFB34, BIDI_R   },  // HEBREW LETTER HE WITH MAPIQ
  { 0xFB35, BIDI_R   },  // HEBREW LETTER VAV WITH DAGESH
  { 0xFB36, BIDI_R   },  // HEBREW LETTER ZAYIN WITH DAGESH
  { 0xFB38, BIDI_R   },  // HEBREW LETTER TET WITH DAGESH
  { 0xFB39, BIDI_R   },  // HEBREW LETTER YOD WITH DAGESH
  { 0xFB3A, BIDI_R   },  // HEBREW LETTER FINAL KAF WITH DAGESH
  { 0xFB3B, BIDI_R   },  // HEBREW LETTER KAF WITH DAGESH
  { 0xFB3C, BIDI_R   },  // HEBREW LETTER LAMED WITH DAGESH
  { 0xFB3E, BIDI_R   },  // HEBREW LETTER MEM WITH DAGESH
  { 0xFB40, BIDI_R   },  // HEBREW LETTER NUN WITH DAGESH
  { 0xFB41, BIDI_R   },  // HEBREW LETTER SAMEKH WITH DAGESH
  { 0xFB43, BIDI_R   },  // HEBREW LETTER FINAL PE WITH DAGESH
  { 0xFB44, BIDI_R   },  // HEBREW LETTER PE WITH DAGESH
  { 0xFB46, BIDI_R   },  // HEBREW LETTER TSADI WITH DAGESH
  { 0xFB47, BIDI_R   },  // HEBREW LETTER QOF WITH DAGESH
  { 0xFB48, BIDI_R   },  // HEBREW LETTER RESH WITH DAGESH
  { 0xFB49, BIDI_R   },  // HEBREW LETTER SHIN WITH DAGESH
  { 0xFB4A, BIDI_R   },  // HEBREW LETTER TAV WITH DAGESH
  { 0xFB4B, BIDI_R   },  // HEBREW LETTER VAV WITH HOLAM
  { 0xFB4C, BIDI_R   },  // HEBREW LETTER BET WITH RAFE
  { 0xFB4D, BIDI_R   },  // HEBREW LETTER KAF WITH RAFE
  { 0xFB4E, BIDI_R   },  // HEBREW LETTER PE WITH RAFE
  { 0xFB4F, BIDI_R   },  // HEBREW LIGATURE ALEF LAMED
  { 0xFB50, BIDI_AL  },  // ARABIC LETTER ALEF WASLA ISOLATED FORM
  { 0xFB51, BIDI_AL  },  // ARABIC LETTER ALEF WASLA FINAL FORM
  { 0xFB52, BIDI_AL  },  // ARABIC LETTER BEEH ISOLATED FORM
  { 0xFB53, BIDI_AL  },  // ARABIC LETTER BEEH FINAL FORM
  { 0xFB54, BIDI_AL  },  // ARABIC LETTER BEEH INITIAL FORM
  { 0xFB55, BIDI_AL  },  // ARABIC LETTER BEEH MEDIAL FORM
  { 0xFB56, BIDI_AL  },  // ARABIC LETTER PEH ISOLATED FORM
  { 0xFB57, BIDI_AL  },  // ARABIC LETTER PEH FINAL FORM
  { 0xFB58, BIDI_AL  },  // ARABIC LETTER PEH INITIAL FORM
  { 0xFB59, BIDI_AL  },  // ARABIC LETTER PEH MEDIAL FORM
  { 0xFB5A, BIDI_AL  },  // ARABIC LETTER BEHEH ISOLATED FORM
  { 0xFB5B, BIDI_AL  },  // ARABIC LETTER BEHEH FINAL FORM
  { 0xFB5C, BIDI_AL  },  // ARABIC LETTER BEHEH INITIAL FORM
  { 0xFB5D, BIDI_AL  },  // ARABIC LETTER BEHEH MEDIAL FORM
  { 0xFB5E, BIDI_AL  },  // ARABIC LETTER TTEHEH ISOLATED FORM
  { 0xFB5F, BIDI_AL  },  // ARABIC LETTER TTEHEH FINAL FORM
  { 0xFB60, BIDI_AL  },  // ARABIC LETTER TTEHEH INITIAL FORM
  { 0xFB61, BIDI_AL  },  // ARABIC LETTER TTEHEH MEDIAL FORM
  { 0xFB62, BIDI_AL  },  // ARABIC LETTER TEHEH ISOLATED FORM
  { 0xFB63, BIDI_AL  },  // ARABIC LETTER TEHEH FINAL FORM
  { 0xFB64, BIDI_AL  },  // ARABIC LETTER TEHEH INITIAL FORM
  { 0xFB65, BIDI_AL  },  // ARABIC LETTER TEHEH MEDIAL FORM
  { 0xFB66, BIDI_AL  },  // ARABIC LETTER TTEH ISOLATED FORM
  { 0xFB67, BIDI_AL  },  // ARABIC LETTER TTEH FINAL FORM
  { 0xFB68, BIDI_AL  },  // ARABIC LETTER TTEH INITIAL FORM
  { 0xFB69, BIDI_AL  },  // ARABIC LETTER TTEH MEDIAL FORM
  { 0xFB6A, BIDI_AL  },  // ARABIC LETTER VEH ISOLATED FORM
  { 0xFB6B, BIDI_AL  },  // ARABIC LETTER VEH FINAL FORM
  { 0xFB6C, BIDI_AL  },  // ARABIC LETTER VEH INITIAL FORM
  { 0xFB6D, BIDI_AL  },  // ARABIC LETTER VEH MEDIAL FORM
  { 0xFB6E, BIDI_AL  },  // ARABIC LETTER PEHEH ISOLATED FORM
  { 0xFB6F, BIDI_AL  },  // ARABIC LETTER PEHEH FINAL FORM
  { 0xFB70, BIDI_AL  },  // ARABIC LETTER PEHEH INITIAL FORM
  { 0xFB71, BIDI_AL  },  // ARABIC LETTER PEHEH MEDIAL FORM
  { 0xFB72, BIDI_AL  },  // ARABIC LETTER DYEH ISOLATED FORM
  { 0xFB73, BIDI_AL  },  // ARABIC LETTER DYEH FINAL FORM
  { 0xFB74, BIDI_AL  },  // ARABIC LETTER DYEH INITIAL FORM
  { 0xFB75, BIDI_AL  },  // ARABIC LETTER DYEH MEDIAL FORM
  { 0xFB76, BIDI_AL  },  // ARABIC LETTER NYEH ISOLATED FORM
  { 0xFB77, BIDI_AL  },  // ARABIC LETTER NYEH FINAL FORM
  { 0xFB78, BIDI_AL  },  // ARABIC LETTER NYEH INITIAL FORM
  { 0xFB79, BIDI_AL  },  // ARABIC LETTER NYEH MEDIAL FORM
  { 0xFB7A, BIDI_AL  },  // ARABIC LETTER TCHEH ISOLATED FORM
  { 0xFB7B, BIDI_AL  },  // ARABIC LETTER TCHEH FINAL FORM
  { 0xFB7C, BIDI_AL  },  // ARABIC LETTER TCHEH INITIAL FORM
  { 0xFB7D, BIDI_AL  },  // ARABIC LETTER TCHEH MEDIAL FORM
  { 0xFB7E, BIDI_AL  },  // ARABIC LETTER TCHEHEH ISOLATED FORM
  { 0xFB7F, BIDI_AL  },  // ARABIC LETTER TCHEHEH FINAL FORM
  { 0xFB80, BIDI_AL  },  // ARABIC LETTER TCHEHEH INITIAL FORM
  { 0xFB81, BIDI_AL  },  // ARABIC LETTER TCHEHEH MEDIAL FORM
  { 0xFB82, BIDI_AL  },  // ARABIC LETTER DDAHAL ISOLATED FORM
  { 0xFB83, BIDI_AL  },  // ARABIC LETTER DDAHAL FINAL FORM
  { 0xFB84, BIDI_AL  },  // ARABIC LETTER DAHAL ISOLATED FORM
  { 0xFB85, BIDI_AL  },  // ARABIC LETTER DAHAL FINAL FORM
  { 0xFB86, BIDI_AL  },  // ARABIC LETTER DUL ISOLATED FORM
  { 0xFB87, BIDI_AL  },  // ARABIC LETTER DUL FINAL FORM
  { 0xFB88, BIDI_AL  },  // ARABIC LETTER DDAL ISOLATED FORM
  { 0xFB89, BIDI_AL  },  // ARABIC LETTER DDAL FINAL FORM
  { 0xFB8A, BIDI_AL  },  // ARABIC LETTER JEH ISOLATED FORM
  { 0xFB8B, BIDI_AL  },  // ARABIC LETTER JEH FINAL FORM
  { 0xFB8C, BIDI_AL  },  // ARABIC LETTER RREH ISOLATED FORM
  { 0xFB8D, BIDI_AL  },  // ARABIC LETTER RREH FINAL FORM
  { 0xFB8E, BIDI_AL  },  // ARABIC LETTER KEHEH ISOLATED FORM
  { 0xFB8F, BIDI_AL  },  // ARABIC LETTER KEHEH FINAL FORM
  { 0xFB90, BIDI_AL  },  // ARABIC LETTER KEHEH INITIAL FORM
  { 0xFB91, BIDI_AL  },  // ARABIC LETTER KEHEH MEDIAL FORM
  { 0xFB92, BIDI_AL  },  // ARABIC LETTER GAF ISOLATED FORM
  { 0xFB93, BIDI_AL  },  // ARABIC LETTER GAF FINAL FORM
  { 0xFB94, BIDI_AL  },  // ARABIC LETTER GAF INITIAL FORM
  { 0xFB95, BIDI_AL  },  // ARABIC LETTER GAF MEDIAL FORM
  { 0xFB96, BIDI_AL  },  // ARABIC LETTER GUEH ISOLATED FORM
  { 0xFB97, BIDI_AL  },  // ARABIC LETTER GUEH FINAL FORM
  { 0xFB98, BIDI_AL  },  // ARABIC LETTER GUEH INITIAL FORM
  { 0xFB99, BIDI_AL  },  // ARABIC LETTER GUEH MEDIAL FORM
  { 0xFB9A, BIDI_AL  },  // ARABIC LETTER NGOEH ISOLATED FORM
  { 0xFB9B, BIDI_AL  },  // ARABIC LETTER NGOEH FINAL FORM
  { 0xFB9C, BIDI_AL  },  // ARABIC LETTER NGOEH INITIAL FORM
  { 0xFB9D, BIDI_AL  },  // ARABIC LETTER NGOEH MEDIAL FORM
  { 0xFB9E, BIDI_AL  },  // ARABIC LETTER NOON GHUNNA ISOLATED FORM
  { 0xFB9F, BIDI_AL  },  // ARABIC LETTER NOON GHUNNA FINAL FORM
  { 0xFBA0, BIDI_AL  },  // ARABIC LETTER RNOON ISOLATED FORM
  { 0xFBA1, BIDI_AL  },  // ARABIC LETTER RNOON FINAL FORM
  { 0xFBA2, BIDI_AL  },  // ARABIC LETTER RNOON INITIAL FORM
  { 0xFBA3, BIDI_AL  },  // ARABIC LETTER RNOON MEDIAL FORM
  { 0xFBA4, BIDI_AL  },  // ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM
  { 0xFBA5, BIDI_AL  },  // ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM
  { 0xFBA6, BIDI_AL  },  // ARABIC LETTER HEH GOAL ISOLATED FORM
  { 0xFBA7, BIDI_AL  },  // ARABIC LETTER HEH GOAL FINAL FORM
  { 0xFBA8, BIDI_AL  },  // ARABIC LETTER HEH GOAL INITIAL FORM
  { 0xFBA9, BIDI_AL  },  // ARABIC LETTER HEH GOAL MEDIAL FORM
  { 0xFBAA, BIDI_AL  },  // ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM
  { 0xFBAB, BIDI_AL  },  // ARABIC LETTER HEH DOACHASHMEE FINAL FORM
  { 0xFBAC, BIDI_AL  },  // ARABIC LETTER HEH DOACHASHMEE INITIAL FORM
  { 0xFBAD, BIDI_AL  },  // ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM
  { 0xFBAE, BIDI_AL  },  // ARABIC LETTER YEH BARREE ISOLATED FORM
  { 0xFBAF, BIDI_AL  },  // ARABIC LETTER YEH BARREE FINAL FORM
  { 0xFBB0, BIDI_AL  },  // ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM
  { 0xFBB1, BIDI_AL  },  // ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
  { 0xFBB2, BIDI_AL  },  // ARABIC SYMBOL DOT ABOVE
  { 0xFBB3, BIDI_AL  },  // ARABIC SYMBOL DOT BELOW
  { 0xFBB4, BIDI_AL  },  // ARABIC SYMBOL TWO DOTS ABOVE
  { 0xFBB5, BIDI_AL  },  // ARABIC SYMBOL TWO DOTS BELOW
  { 0xFBB6, BIDI_AL  },  // ARABIC SYMBOL THREE DOTS ABOVE
  { 0xFBB7, BIDI_AL  },  // ARABIC SYMBOL THREE DOTS BELOW
  { 0xFBB8, BIDI_AL  },  // ARABIC SYMBOL THREE DOTS POINTING DOWNWARDS ABOVE
  { 0xFBB9, BIDI_AL  },  // ARABIC SYMBOL THREE DOTS POINTING DOWNWARDS BELOW
  { 0xFBBA, BIDI_AL  },  // ARABIC SYMBOL FOUR DOTS ABOVE
  { 0xFBBB, BIDI_AL  },  // ARABIC SYMBOL FOUR DOTS BELOW
  { 0xFBBC, BIDI_AL  },  // ARABIC SYMBOL DOUBLE VERTICAL BAR BELOW
  { 0xFBBD, BIDI_AL  },  // ARABIC SYMBOL TWO DOTS VERTICALLY ABOVE
  { 0xFBBE, BIDI_AL  },  // ARABIC SYMBOL TWO DOTS VERTICALLY BELOW
  { 0xFBBF, BIDI_AL  },  // ARABIC SYMBOL RING
  { 0xFBC0, BIDI_AL  },  // ARABIC SYMBOL SMALL TAH ABOVE
  { 0xFBC1, BIDI_AL  },  // ARABIC SYMBOL SMALL TAH BELOW
  { 0xFBD3, BIDI_AL  },  // ARABIC LETTER NG ISOLATED FORM
  { 0xFBD4, BIDI_AL  },  // ARABIC LETTER NG FINAL FORM
  { 0xFBD5, BIDI_AL  },  // ARABIC LETTER NG INITIAL FORM
  { 0xFBD6, BIDI_AL  },  // ARABIC LETTER NG MEDIAL FORM
  { 0xFBD7, BIDI_AL  },  // ARABIC LETTER U ISOLATED FORM
  { 0xFBD8, BIDI_AL  },  // ARABIC LETTER U FINAL FORM
  { 0xFBD9, BIDI_AL  },  // ARABIC LETTER OE ISOLATED FORM
  { 0xFBDA, BIDI_AL  },  // ARABIC LETTER OE FINAL FORM
  { 0xFBDB, BIDI_AL  },  // ARABIC LETTER YU ISOLATED FORM
  { 0xFBDC, BIDI_AL  },  // ARABIC LETTER YU FINAL FORM
  { 0xFBDD, BIDI_AL  },  // ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM
  { 0xFBDE, BIDI_AL  },  // ARABIC LETTER VE ISOLATED FORM
  { 0xFBDF, BIDI_AL  },  // ARABIC LETTER VE FINAL FORM
  { 0xFBE0, BIDI_AL  },  // ARABIC LETTER KIRGHIZ OE ISOLATED FORM
  { 0xFBE1, BIDI_AL  },  // ARABIC LETTER KIRGHIZ OE FINAL FORM
  { 0xFBE2, BIDI_AL  },  // ARABIC LETTER KIRGHIZ YU ISOLATED FORM
  { 0xFBE3, BIDI_AL  },  // ARABIC LETTER KIRGHIZ YU FINAL FORM
  { 0xFBE4, BIDI_AL  },  // ARABIC LETTER E ISOLATED FORM
  { 0xFBE5, BIDI_AL  },  // ARABIC LETTER E FINAL FORM
  { 0xFBE6, BIDI_AL  },  // ARABIC LETTER E INITIAL FORM
  { 0xFBE7, BIDI_AL  },  // ARABIC LETTER E MEDIAL FORM
  { 0xFBE8, BIDI_AL  },  // ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM
  { 0xFBE9, BIDI_AL  },  // ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM
  { 0xFBEA, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM
  { 0xFBEB, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM
  { 0xFBEC, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM
  { 0xFBED, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM
  { 0xFBEE, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM
  { 0xFBEF, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM
  { 0xFBF0, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM
  { 0xFBF1, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM
  { 0xFBF2, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM
  { 0xFBF3, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM
  { 0xFBF4, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM
  { 0xFBF5, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM
  { 0xFBF6, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM
  { 0xFBF7, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM
  { 0xFBF8, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM
  { 0xFBF9, BIDI_AL  },  // ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
  { 0xFBFA, BIDI_AL  },  // ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
  { 0xFBFB, BIDI_AL  },  // ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM
  { 0xFBFC, BIDI_AL  },  // ARABIC LETTER FARSI YEH ISOLATED FORM
  { 0xFBFD, BIDI_AL  },  // ARABIC LETTER FARSI YEH FINAL FORM
  { 0xFBFE, BIDI_AL  },  // ARABIC LETTER FARSI YEH INITIAL FORM
  { 0xFBFF, BIDI_AL  },  // ARABIC LETTER FARSI YEH MEDIAL FORM
  { 0xFC00, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM
  { 0xFC01, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM
  { 0xFC02, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM
  { 0xFC03, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC04, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM
  { 0xFC05, BIDI_AL  },  // ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM
  { 0xFC06, BIDI_AL  },  // ARABIC LIGATURE BEH WITH HAH ISOLATED FORM
  { 0xFC07, BIDI_AL  },  // ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM
  { 0xFC08, BIDI_AL  },  // ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM
  { 0xFC09, BIDI_AL  },  // ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC0A, BIDI_AL  },  // ARABIC LIGATURE BEH WITH YEH ISOLATED FORM
  { 0xFC0B, BIDI_AL  },  // ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM
  { 0xFC0C, BIDI_AL  },  // ARABIC LIGATURE TEH WITH HAH ISOLATED FORM
  { 0xFC0D, BIDI_AL  },  // ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM
  { 0xFC0E, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM
  { 0xFC0F, BIDI_AL  },  // ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC10, BIDI_AL  },  // ARABIC LIGATURE TEH WITH YEH ISOLATED FORM
  { 0xFC11, BIDI_AL  },  // ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM
  { 0xFC12, BIDI_AL  },  // ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM
  { 0xFC13, BIDI_AL  },  // ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC14, BIDI_AL  },  // ARABIC LIGATURE THEH WITH YEH ISOLATED FORM
  { 0xFC15, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM
  { 0xFC16, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM
  { 0xFC17, BIDI_AL  },  // ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM
  { 0xFC18, BIDI_AL  },  // ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM
  { 0xFC19, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM
  { 0xFC1A, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM
  { 0xFC1B, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM
  { 0xFC1C, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM
  { 0xFC1D, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM
  { 0xFC1E, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM
  { 0xFC1F, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM
  { 0xFC20, BIDI_AL  },  // ARABIC LIGATURE SAD WITH HAH ISOLATED FORM
  { 0xFC21, BIDI_AL  },  // ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM
  { 0xFC22, BIDI_AL  },  // ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM
  { 0xFC23, BIDI_AL  },  // ARABIC LIGATURE DAD WITH HAH ISOLATED FORM
  { 0xFC24, BIDI_AL  },  // ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM
  { 0xFC25, BIDI_AL  },  // ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM
  { 0xFC26, BIDI_AL  },  // ARABIC LIGATURE TAH WITH HAH ISOLATED FORM
  { 0xFC27, BIDI_AL  },  // ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM
  { 0xFC28, BIDI_AL  },  // ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM
  { 0xFC29, BIDI_AL  },  // ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM
  { 0xFC2A, BIDI_AL  },  // ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM
  { 0xFC2B, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM
  { 0xFC2C, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM
  { 0xFC2D, BIDI_AL  },  // ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM
  { 0xFC2E, BIDI_AL  },  // ARABIC LIGATURE FEH WITH HAH ISOLATED FORM
  { 0xFC2F, BIDI_AL  },  // ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM
  { 0xFC30, BIDI_AL  },  // ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM
  { 0xFC31, BIDI_AL  },  // ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC32, BIDI_AL  },  // ARABIC LIGATURE FEH WITH YEH ISOLATED FORM
  { 0xFC33, BIDI_AL  },  // ARABIC LIGATURE QAF WITH HAH ISOLATED FORM
  { 0xFC34, BIDI_AL  },  // ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM
  { 0xFC35, BIDI_AL  },  // ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC36, BIDI_AL  },  // ARABIC LIGATURE QAF WITH YEH ISOLATED FORM
  { 0xFC37, BIDI_AL  },  // ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM
  { 0xFC38, BIDI_AL  },  // ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM
  { 0xFC39, BIDI_AL  },  // ARABIC LIGATURE KAF WITH HAH ISOLATED FORM
  { 0xFC3A, BIDI_AL  },  // ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM
  { 0xFC3B, BIDI_AL  },  // ARABIC LIGATURE KAF WITH LAM ISOLATED FORM
  { 0xFC3C, BIDI_AL  },  // ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM
  { 0xFC3D, BIDI_AL  },  // ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC3E, BIDI_AL  },  // ARABIC LIGATURE KAF WITH YEH ISOLATED FORM
  { 0xFC3F, BIDI_AL  },  // ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM
  { 0xFC40, BIDI_AL  },  // ARABIC LIGATURE LAM WITH HAH ISOLATED FORM
  { 0xFC41, BIDI_AL  },  // ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM
  { 0xFC42, BIDI_AL  },  // ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM
  { 0xFC43, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC44, BIDI_AL  },  // ARABIC LIGATURE LAM WITH YEH ISOLATED FORM
  { 0xFC45, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM
  { 0xFC46, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM
  { 0xFC47, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM
  { 0xFC48, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM
  { 0xFC49, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC4A, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM
  { 0xFC4B, BIDI_AL  },  // ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM
  { 0xFC4C, BIDI_AL  },  // ARABIC LIGATURE NOON WITH HAH ISOLATED FORM
  { 0xFC4D, BIDI_AL  },  // ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM
  { 0xFC4E, BIDI_AL  },  // ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM
  { 0xFC4F, BIDI_AL  },  // ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC50, BIDI_AL  },  // ARABIC LIGATURE NOON WITH YEH ISOLATED FORM
  { 0xFC51, BIDI_AL  },  // ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM
  { 0xFC52, BIDI_AL  },  // ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM
  { 0xFC53, BIDI_AL  },  // ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC54, BIDI_AL  },  // ARABIC LIGATURE HEH WITH YEH ISOLATED FORM
  { 0xFC55, BIDI_AL  },  // ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM
  { 0xFC56, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAH ISOLATED FORM
  { 0xFC57, BIDI_AL  },  // ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM
  { 0xFC58, BIDI_AL  },  // ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM
  { 0xFC59, BIDI_AL  },  // ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFC5A, BIDI_AL  },  // ARABIC LIGATURE YEH WITH YEH ISOLATED FORM
  { 0xFC5B, BIDI_AL  },  // ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM
  { 0xFC5C, BIDI_AL  },  // ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM
  { 0xFC5D, BIDI_AL  },  // ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM
  { 0xFC5E, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM
  { 0xFC5F, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM
  { 0xFC60, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM
  { 0xFC61, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM
  { 0xFC62, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM
  { 0xFC63, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM
  { 0xFC64, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM
  { 0xFC65, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM
  { 0xFC66, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM
  { 0xFC67, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM
  { 0xFC68, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
  { 0xFC69, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM
  { 0xFC6A, BIDI_AL  },  // ARABIC LIGATURE BEH WITH REH FINAL FORM
  { 0xFC6B, BIDI_AL  },  // ARABIC LIGATURE BEH WITH ZAIN FINAL FORM
  { 0xFC6C, BIDI_AL  },  // ARABIC LIGATURE BEH WITH MEEM FINAL FORM
  { 0xFC6D, BIDI_AL  },  // ARABIC LIGATURE BEH WITH NOON FINAL FORM
  { 0xFC6E, BIDI_AL  },  // ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM
  { 0xFC6F, BIDI_AL  },  // ARABIC LIGATURE BEH WITH YEH FINAL FORM
  { 0xFC70, BIDI_AL  },  // ARABIC LIGATURE TEH WITH REH FINAL FORM
  { 0xFC71, BIDI_AL  },  // ARABIC LIGATURE TEH WITH ZAIN FINAL FORM
  { 0xFC72, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM FINAL FORM
  { 0xFC73, BIDI_AL  },  // ARABIC LIGATURE TEH WITH NOON FINAL FORM
  { 0xFC74, BIDI_AL  },  // ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM
  { 0xFC75, BIDI_AL  },  // ARABIC LIGATURE TEH WITH YEH FINAL FORM
  { 0xFC76, BIDI_AL  },  // ARABIC LIGATURE THEH WITH REH FINAL FORM
  { 0xFC77, BIDI_AL  },  // ARABIC LIGATURE THEH WITH ZAIN FINAL FORM
  { 0xFC78, BIDI_AL  },  // ARABIC LIGATURE THEH WITH MEEM FINAL FORM
  { 0xFC79, BIDI_AL  },  // ARABIC LIGATURE THEH WITH NOON FINAL FORM
  { 0xFC7A, BIDI_AL  },  // ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM
  { 0xFC7B, BIDI_AL  },  // ARABIC LIGATURE THEH WITH YEH FINAL FORM
  { 0xFC7C, BIDI_AL  },  // ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM
  { 0xFC7D, BIDI_AL  },  // ARABIC LIGATURE FEH WITH YEH FINAL FORM
  { 0xFC7E, BIDI_AL  },  // ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM
  { 0xFC7F, BIDI_AL  },  // ARABIC LIGATURE QAF WITH YEH FINAL FORM
  { 0xFC80, BIDI_AL  },  // ARABIC LIGATURE KAF WITH ALEF FINAL FORM
  { 0xFC81, BIDI_AL  },  // ARABIC LIGATURE KAF WITH LAM FINAL FORM
  { 0xFC82, BIDI_AL  },  // ARABIC LIGATURE KAF WITH MEEM FINAL FORM
  { 0xFC83, BIDI_AL  },  // ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM
  { 0xFC84, BIDI_AL  },  // ARABIC LIGATURE KAF WITH YEH FINAL FORM
  { 0xFC85, BIDI_AL  },  // ARABIC LIGATURE LAM WITH MEEM FINAL FORM
  { 0xFC86, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM
  { 0xFC87, BIDI_AL  },  // ARABIC LIGATURE LAM WITH YEH FINAL FORM
  { 0xFC88, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH ALEF FINAL FORM
  { 0xFC89, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH MEEM FINAL FORM
  { 0xFC8A, BIDI_AL  },  // ARABIC LIGATURE NOON WITH REH FINAL FORM
  { 0xFC8B, BIDI_AL  },  // ARABIC LIGATURE NOON WITH ZAIN FINAL FORM
  { 0xFC8C, BIDI_AL  },  // ARABIC LIGATURE NOON WITH MEEM FINAL FORM
  { 0xFC8D, BIDI_AL  },  // ARABIC LIGATURE NOON WITH NOON FINAL FORM
  { 0xFC8E, BIDI_AL  },  // ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM
  { 0xFC8F, BIDI_AL  },  // ARABIC LIGATURE NOON WITH YEH FINAL FORM
  { 0xFC90, BIDI_AL  },  // ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM
  { 0xFC91, BIDI_AL  },  // ARABIC LIGATURE YEH WITH REH FINAL FORM
  { 0xFC92, BIDI_AL  },  // ARABIC LIGATURE YEH WITH ZAIN FINAL FORM
  { 0xFC93, BIDI_AL  },  // ARABIC LIGATURE YEH WITH MEEM FINAL FORM
  { 0xFC94, BIDI_AL  },  // ARABIC LIGATURE YEH WITH NOON FINAL FORM
  { 0xFC95, BIDI_AL  },  // ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM
  { 0xFC96, BIDI_AL  },  // ARABIC LIGATURE YEH WITH YEH FINAL FORM
  { 0xFC97, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM
  { 0xFC98, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM
  { 0xFC99, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM
  { 0xFC9A, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM
  { 0xFC9B, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM
  { 0xFC9C, BIDI_AL  },  // ARABIC LIGATURE BEH WITH JEEM INITIAL FORM
  { 0xFC9D, BIDI_AL  },  // ARABIC LIGATURE BEH WITH HAH INITIAL FORM
  { 0xFC9E, BIDI_AL  },  // ARABIC LIGATURE BEH WITH KHAH INITIAL FORM
  { 0xFC9F, BIDI_AL  },  // ARABIC LIGATURE BEH WITH MEEM INITIAL FORM
  { 0xFCA0, BIDI_AL  },  // ARABIC LIGATURE BEH WITH HEH INITIAL FORM
  { 0xFCA1, BIDI_AL  },  // ARABIC LIGATURE TEH WITH JEEM INITIAL FORM
  { 0xFCA2, BIDI_AL  },  // ARABIC LIGATURE TEH WITH HAH INITIAL FORM
  { 0xFCA3, BIDI_AL  },  // ARABIC LIGATURE TEH WITH KHAH INITIAL FORM
  { 0xFCA4, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM INITIAL FORM
  { 0xFCA5, BIDI_AL  },  // ARABIC LIGATURE TEH WITH HEH INITIAL FORM
  { 0xFCA6, BIDI_AL  },  // ARABIC LIGATURE THEH WITH MEEM INITIAL FORM
  { 0xFCA7, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH HAH INITIAL FORM
  { 0xFCA8, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM
  { 0xFCA9, BIDI_AL  },  // ARABIC LIGATURE HAH WITH JEEM INITIAL FORM
  { 0xFCAA, BIDI_AL  },  // ARABIC LIGATURE HAH WITH MEEM INITIAL FORM
  { 0xFCAB, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM
  { 0xFCAC, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM
  { 0xFCAD, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM
  { 0xFCAE, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH HAH INITIAL FORM
  { 0xFCAF, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM
  { 0xFCB0, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM
  { 0xFCB1, BIDI_AL  },  // ARABIC LIGATURE SAD WITH HAH INITIAL FORM
  { 0xFCB2, BIDI_AL  },  // ARABIC LIGATURE SAD WITH KHAH INITIAL FORM
  { 0xFCB3, BIDI_AL  },  // ARABIC LIGATURE SAD WITH MEEM INITIAL FORM
  { 0xFCB4, BIDI_AL  },  // ARABIC LIGATURE DAD WITH JEEM INITIAL FORM
  { 0xFCB5, BIDI_AL  },  // ARABIC LIGATURE DAD WITH HAH INITIAL FORM
  { 0xFCB6, BIDI_AL  },  // ARABIC LIGATURE DAD WITH KHAH INITIAL FORM
  { 0xFCB7, BIDI_AL  },  // ARABIC LIGATURE DAD WITH MEEM INITIAL FORM
  { 0xFCB8, BIDI_AL  },  // ARABIC LIGATURE TAH WITH HAH INITIAL FORM
  { 0xFCB9, BIDI_AL  },  // ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM
  { 0xFCBA, BIDI_AL  },  // ARABIC LIGATURE AIN WITH JEEM INITIAL FORM
  { 0xFCBB, BIDI_AL  },  // ARABIC LIGATURE AIN WITH MEEM INITIAL FORM
  { 0xFCBC, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM
  { 0xFCBD, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM
  { 0xFCBE, BIDI_AL  },  // ARABIC LIGATURE FEH WITH JEEM INITIAL FORM
  { 0xFCBF, BIDI_AL  },  // ARABIC LIGATURE FEH WITH HAH INITIAL FORM
  { 0xFCC0, BIDI_AL  },  // ARABIC LIGATURE FEH WITH KHAH INITIAL FORM
  { 0xFCC1, BIDI_AL  },  // ARABIC LIGATURE FEH WITH MEEM INITIAL FORM
  { 0xFCC2, BIDI_AL  },  // ARABIC LIGATURE QAF WITH HAH INITIAL FORM
  { 0xFCC3, BIDI_AL  },  // ARABIC LIGATURE QAF WITH MEEM INITIAL FORM
  { 0xFCC4, BIDI_AL  },  // ARABIC LIGATURE KAF WITH JEEM INITIAL FORM
  { 0xFCC5, BIDI_AL  },  // ARABIC LIGATURE KAF WITH HAH INITIAL FORM
  { 0xFCC6, BIDI_AL  },  // ARABIC LIGATURE KAF WITH KHAH INITIAL FORM
  { 0xFCC7, BIDI_AL  },  // ARABIC LIGATURE KAF WITH LAM INITIAL FORM
  { 0xFCC8, BIDI_AL  },  // ARABIC LIGATURE KAF WITH MEEM INITIAL FORM
  { 0xFCC9, BIDI_AL  },  // ARABIC LIGATURE LAM WITH JEEM INITIAL FORM
  { 0xFCCA, BIDI_AL  },  // ARABIC LIGATURE LAM WITH HAH INITIAL FORM
  { 0xFCCB, BIDI_AL  },  // ARABIC LIGATURE LAM WITH KHAH INITIAL FORM
  { 0xFCCC, BIDI_AL  },  // ARABIC LIGATURE LAM WITH MEEM INITIAL FORM
  { 0xFCCD, BIDI_AL  },  // ARABIC LIGATURE LAM WITH HEH INITIAL FORM
  { 0xFCCE, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM
  { 0xFCCF, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH HAH INITIAL FORM
  { 0xFCD0, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM
  { 0xFCD1, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM
  { 0xFCD2, BIDI_AL  },  // ARABIC LIGATURE NOON WITH JEEM INITIAL FORM
  { 0xFCD3, BIDI_AL  },  // ARABIC LIGATURE NOON WITH HAH INITIAL FORM
  { 0xFCD4, BIDI_AL  },  // ARABIC LIGATURE NOON WITH KHAH INITIAL FORM
  { 0xFCD5, BIDI_AL  },  // ARABIC LIGATURE NOON WITH MEEM INITIAL FORM
  { 0xFCD6, BIDI_AL  },  // ARABIC LIGATURE NOON WITH HEH INITIAL FORM
  { 0xFCD7, BIDI_AL  },  // ARABIC LIGATURE HEH WITH JEEM INITIAL FORM
  { 0xFCD8, BIDI_AL  },  // ARABIC LIGATURE HEH WITH MEEM INITIAL FORM
  { 0xFCD9, BIDI_AL  },  // ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM
  { 0xFCDA, BIDI_AL  },  // ARABIC LIGATURE YEH WITH JEEM INITIAL FORM
  { 0xFCDB, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAH INITIAL FORM
  { 0xFCDC, BIDI_AL  },  // ARABIC LIGATURE YEH WITH KHAH INITIAL FORM
  { 0xFCDD, BIDI_AL  },  // ARABIC LIGATURE YEH WITH MEEM INITIAL FORM
  { 0xFCDE, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HEH INITIAL FORM
  { 0xFCDF, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM
  { 0xFCE0, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM
  { 0xFCE1, BIDI_AL  },  // ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM
  { 0xFCE2, BIDI_AL  },  // ARABIC LIGATURE BEH WITH HEH MEDIAL FORM
  { 0xFCE3, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM
  { 0xFCE4, BIDI_AL  },  // ARABIC LIGATURE TEH WITH HEH MEDIAL FORM
  { 0xFCE5, BIDI_AL  },  // ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM
  { 0xFCE6, BIDI_AL  },  // ARABIC LIGATURE THEH WITH HEH MEDIAL FORM
  { 0xFCE7, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM
  { 0xFCE8, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM
  { 0xFCE9, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM
  { 0xFCEA, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM
  { 0xFCEB, BIDI_AL  },  // ARABIC LIGATURE KAF WITH LAM MEDIAL FORM
  { 0xFCEC, BIDI_AL  },  // ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM
  { 0xFCED, BIDI_AL  },  // ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM
  { 0xFCEE, BIDI_AL  },  // ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM
  { 0xFCEF, BIDI_AL  },  // ARABIC LIGATURE NOON WITH HEH MEDIAL FORM
  { 0xFCF0, BIDI_AL  },  // ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM
  { 0xFCF1, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HEH MEDIAL FORM
  { 0xFCF2, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM
  { 0xFCF3, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM
  { 0xFCF4, BIDI_AL  },  // ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM
  { 0xFCF5, BIDI_AL  },  // ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFCF6, BIDI_AL  },  // ARABIC LIGATURE TAH WITH YEH ISOLATED FORM
  { 0xFCF7, BIDI_AL  },  // ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM
  { 0xFCF8, BIDI_AL  },  // ARABIC LIGATURE AIN WITH YEH ISOLATED FORM
  { 0xFCF9, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM
  { 0xFCFA, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM
  { 0xFCFB, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM
  { 0xFCFC, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM
  { 0xFCFD, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM
  { 0xFCFE, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM
  { 0xFCFF, BIDI_AL  },  // ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFD00, BIDI_AL  },  // ARABIC LIGATURE HAH WITH YEH ISOLATED FORM
  { 0xFD01, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM
  { 0xFD02, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM
  { 0xFD03, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM
  { 0xFD04, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM
  { 0xFD05, BIDI_AL  },  // ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM
  { 0xFD06, BIDI_AL  },  // ARABIC LIGATURE SAD WITH YEH ISOLATED FORM
  { 0xFD07, BIDI_AL  },  // ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM
  { 0xFD08, BIDI_AL  },  // ARABIC LIGATURE DAD WITH YEH ISOLATED FORM
  { 0xFD09, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM
  { 0xFD0A, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM
  { 0xFD0B, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM
  { 0xFD0C, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM
  { 0xFD0D, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM
  { 0xFD0E, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH REH ISOLATED FORM
  { 0xFD0F, BIDI_AL  },  // ARABIC LIGATURE SAD WITH REH ISOLATED FORM
  { 0xFD10, BIDI_AL  },  // ARABIC LIGATURE DAD WITH REH ISOLATED FORM
  { 0xFD11, BIDI_AL  },  // ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM
  { 0xFD12, BIDI_AL  },  // ARABIC LIGATURE TAH WITH YEH FINAL FORM
  { 0xFD13, BIDI_AL  },  // ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM
  { 0xFD14, BIDI_AL  },  // ARABIC LIGATURE AIN WITH YEH FINAL FORM
  { 0xFD15, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM
  { 0xFD16, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH YEH FINAL FORM
  { 0xFD17, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM
  { 0xFD18, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH YEH FINAL FORM
  { 0xFD19, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM
  { 0xFD1A, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH YEH FINAL FORM
  { 0xFD1B, BIDI_AL  },  // ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM
  { 0xFD1C, BIDI_AL  },  // ARABIC LIGATURE HAH WITH YEH FINAL FORM
  { 0xFD1D, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFD1E, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH YEH FINAL FORM
  { 0xFD1F, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM
  { 0xFD20, BIDI_AL  },  // ARABIC LIGATURE KHAH WITH YEH FINAL FORM
  { 0xFD21, BIDI_AL  },  // ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM
  { 0xFD22, BIDI_AL  },  // ARABIC LIGATURE SAD WITH YEH FINAL FORM
  { 0xFD23, BIDI_AL  },  // ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM
  { 0xFD24, BIDI_AL  },  // ARABIC LIGATURE DAD WITH YEH FINAL FORM
  { 0xFD25, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM
  { 0xFD26, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HAH FINAL FORM
  { 0xFD27, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM
  { 0xFD28, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM
  { 0xFD29, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH REH FINAL FORM
  { 0xFD2A, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH REH FINAL FORM
  { 0xFD2B, BIDI_AL  },  // ARABIC LIGATURE SAD WITH REH FINAL FORM
  { 0xFD2C, BIDI_AL  },  // ARABIC LIGATURE DAD WITH REH FINAL FORM
  { 0xFD2D, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM
  { 0xFD2E, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM
  { 0xFD2F, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM
  { 0xFD30, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM
  { 0xFD31, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH HEH INITIAL FORM
  { 0xFD32, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM
  { 0xFD33, BIDI_AL  },  // ARABIC LIGATURE TAH WITH MEEM INITIAL FORM
  { 0xFD34, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM
  { 0xFD35, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM
  { 0xFD36, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM
  { 0xFD37, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM
  { 0xFD38, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM
  { 0xFD39, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM
  { 0xFD3A, BIDI_AL  },  // ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM
  { 0xFD3B, BIDI_AL  },  // ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM
  { 0xFD3C, BIDI_AL  },  // ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM
  { 0xFD3D, BIDI_AL  },  // ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
  { 0xFD3E, BIDI_ON  },  // ORNATE LEFT PARENTHESIS
  { 0xFD3F, BIDI_ON  },  // ORNATE RIGHT PARENTHESIS
  { 0xFD50, BIDI_AL  },  // ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM
  { 0xFD51, BIDI_AL  },  // ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM
  { 0xFD52, BIDI_AL  },  // ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM
  { 0xFD53, BIDI_AL  },  // ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM
  { 0xFD54, BIDI_AL  },  // ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM
  { 0xFD55, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM
  { 0xFD56, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM
  { 0xFD57, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM
  { 0xFD58, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM
  { 0xFD59, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM
  { 0xFD5A, BIDI_AL  },  // ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM
  { 0xFD5B, BIDI_AL  },  // ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFD5C, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM
  { 0xFD5D, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM
  { 0xFD5E, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFD5F, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM
  { 0xFD60, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM
  { 0xFD61, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM
  { 0xFD62, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM
  { 0xFD63, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM
  { 0xFD64, BIDI_AL  },  // ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM
  { 0xFD65, BIDI_AL  },  // ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM
  { 0xFD66, BIDI_AL  },  // ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM
  { 0xFD67, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM
  { 0xFD68, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM
  { 0xFD69, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM
  { 0xFD6A, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM
  { 0xFD6B, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM
  { 0xFD6C, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM
  { 0xFD6D, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM
  { 0xFD6E, BIDI_AL  },  // ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM
  { 0xFD6F, BIDI_AL  },  // ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM
  { 0xFD70, BIDI_AL  },  // ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM
  { 0xFD71, BIDI_AL  },  // ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM
  { 0xFD72, BIDI_AL  },  // ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM
  { 0xFD73, BIDI_AL  },  // ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM
  { 0xFD74, BIDI_AL  },  // ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM
  { 0xFD75, BIDI_AL  },  // ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM
  { 0xFD76, BIDI_AL  },  // ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM
  { 0xFD77, BIDI_AL  },  // ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM
  { 0xFD78, BIDI_AL  },  // ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFD79, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM
  { 0xFD7A, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM
  { 0xFD7B, BIDI_AL  },  // ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFD7C, BIDI_AL  },  // ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM
  { 0xFD7D, BIDI_AL  },  // ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM
  { 0xFD7E, BIDI_AL  },  // ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM
  { 0xFD7F, BIDI_AL  },  // ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM
  { 0xFD80, BIDI_AL  },  // ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM
  { 0xFD81, BIDI_AL  },  // ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM
  { 0xFD82, BIDI_AL  },  // ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM
  { 0xFD83, BIDI_AL  },  // ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM
  { 0xFD84, BIDI_AL  },  // ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM
  { 0xFD85, BIDI_AL  },  // ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM
  { 0xFD86, BIDI_AL  },  // ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM
  { 0xFD87, BIDI_AL  },  // ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM
  { 0xFD88, BIDI_AL  },  // ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM
  { 0xFD89, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM
  { 0xFD8A, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM
  { 0xFD8B, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM
  { 0xFD8C, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM
  { 0xFD8D, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM
  { 0xFD8E, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM
  { 0xFD8F, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
  { 0xFD92, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM
  { 0xFD93, BIDI_AL  },  // ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM
  { 0xFD94, BIDI_AL  },  // ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM
  { 0xFD95, BIDI_AL  },  // ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM
  { 0xFD96, BIDI_AL  },  // ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM
  { 0xFD97, BIDI_AL  },  // ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM
  { 0xFD98, BIDI_AL  },  // ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM
  { 0xFD99, BIDI_AL  },  // ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFD9A, BIDI_AL  },  // ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM
  { 0xFD9B, BIDI_AL  },  // ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFD9C, BIDI_AL  },  // ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM
  { 0xFD9D, BIDI_AL  },  // ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM
  { 0xFD9E, BIDI_AL  },  // ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM
  { 0xFD9F, BIDI_AL  },  // ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM
  { 0xFDA0, BIDI_AL  },  // ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFDA1, BIDI_AL  },  // ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM
  { 0xFDA2, BIDI_AL  },  // ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM
  { 0xFDA3, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM
  { 0xFDA4, BIDI_AL  },  // ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFDA5, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM
  { 0xFDA6, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM
  { 0xFDA7, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM
  { 0xFDA8, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM
  { 0xFDA9, BIDI_AL  },  // ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM
  { 0xFDAA, BIDI_AL  },  // ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM
  { 0xFDAB, BIDI_AL  },  // ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM
  { 0xFDAC, BIDI_AL  },  // ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM
  { 0xFDAD, BIDI_AL  },  // ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM
  { 0xFDAE, BIDI_AL  },  // ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM
  { 0xFDAF, BIDI_AL  },  // ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM
  { 0xFDB0, BIDI_AL  },  // ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM
  { 0xFDB1, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM
  { 0xFDB2, BIDI_AL  },  // ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM
  { 0xFDB3, BIDI_AL  },  // ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM
  { 0xFDB4, BIDI_AL  },  // ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM
  { 0xFDB5, BIDI_AL  },  // ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM
  { 0xFDB6, BIDI_AL  },  // ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM
  { 0xFDB7, BIDI_AL  },  // ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM
  { 0xFDB8, BIDI_AL  },  // ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM
  { 0xFDB9, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM
  { 0xFDBA, BIDI_AL  },  // ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM
  { 0xFDBB, BIDI_AL  },  // ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM
  { 0xFDBC, BIDI_AL  },  // ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM
  { 0xFDBD, BIDI_AL  },  // ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM
  { 0xFDBE, BIDI_AL  },  // ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM
  { 0xFDBF, BIDI_AL  },  // ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM
  { 0xFDC0, BIDI_AL  },  // ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM
  { 0xFDC1, BIDI_AL  },  // ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM
  { 0xFDC2, BIDI_AL  },  // ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM
  { 0xFDC3, BIDI_AL  },  // ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM
  { 0xFDC4, BIDI_AL  },  // ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM
  { 0xFDC5, BIDI_AL  },  // ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM
  { 0xFDC6, BIDI_AL  },  // ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM
  { 0xFDC7, BIDI_AL  },  // ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
  { 0xFDF0, BIDI_AL  },  // ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM
  { 0xFDF1, BIDI_AL  },  // ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM
  { 0xFDF2, BIDI_AL  },  // ARABIC LIGATURE ALLAH ISOLATED FORM
  { 0xFDF3, BIDI_AL  },  // ARABIC LIGATURE AKBAR ISOLATED FORM
  { 0xFDF4, BIDI_AL  },  // ARABIC LIGATURE MOHAMMAD ISOLATED FORM
  { 0xFDF5, BIDI_AL  },  // ARABIC LIGATURE SALAM ISOLATED FORM
  { 0xFDF6, BIDI_AL  },  // ARABIC LIGATURE RASOUL ISOLATED FORM
  { 0xFDF7, BIDI_AL  },  // ARABIC LIGATURE ALAYHE ISOLATED FORM
  { 0xFDF8, BIDI_AL  },  // ARABIC LIGATURE WASALLAM ISOLATED FORM
  { 0xFDF9, BIDI_AL  },  // ARABIC LIGATURE SALLA ISOLATED FORM
  { 0xFDFA, BIDI_AL  },  // ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM
  { 0xFDFB, BIDI_AL  },  // ARABIC LIGATURE JALLAJALALOUHOU
  { 0xFDFC, BIDI_AL  },  // RIAL SIGN
  { 0xFDFD, BIDI_ON  },  // ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM
  { 0xFE00, BIDI_NSM },  // VARIATION SELECTOR-1
  { 0xFE01, BIDI_NSM },  // VARIATION SELECTOR-2
  { 0xFE02, BIDI_NSM },  // VARIATION SELECTOR-3
  { 0xFE03, BIDI_NSM },  // VARIATION SELECTOR-4
  { 0xFE04, BIDI_NSM },  // VARIATION SELECTOR-5
  { 0xFE05, BIDI_NSM },  // VARIATION SELECTOR-6
  { 0xFE06, BIDI_NSM },  // VARIATION SELECTOR-7
  { 0xFE07, BIDI_NSM },  // VARIATION SELECTOR-8
  { 0xFE08, BIDI_NSM },  // VARIATION SELECTOR-9
  { 0xFE09, BIDI_NSM },  // VARIATION SELECTOR-10
  { 0xFE0A, BIDI_NSM },  // VARIATION SELECTOR-11
  { 0xFE0B, BIDI_NSM },  // VARIATION SELECTOR-12
  { 0xFE0C, BIDI_NSM },  // VARIATION SELECTOR-13
  { 0xFE0D, BIDI_NSM },  // VARIATION SELECTOR-14
  { 0xFE0E, BIDI_NSM },  // VARIATION SELECTOR-15
  { 0xFE0F, BIDI_NSM },  // VARIATION SELECTOR-16
  { 0xFE10, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL COMMA
  { 0xFE11, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA
  { 0xFE12, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOP
  { 0xFE13, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL COLON
  { 0xFE14, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL SEMICOLON
  { 0xFE15, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL EXCLAMATION MARK
  { 0xFE16, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL QUESTION MARK
  { 0xFE17, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET
  { 0xFE18, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET
  { 0xFE19, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS
  { 0xFE20, BIDI_NSM },  // COMBINING LIGATURE LEFT HALF
  { 0xFE21, BIDI_NSM },  // COMBINING LIGATURE RIGHT HALF
  { 0xFE22, BIDI_NSM },  // COMBINING DOUBLE TILDE LEFT HALF
  { 0xFE23, BIDI_NSM },  // COMBINING DOUBLE TILDE RIGHT HALF
  { 0xFE24, BIDI_NSM },  // COMBINING MACRON LEFT HALF
  { 0xFE25, BIDI_NSM },  // COMBINING MACRON RIGHT HALF
  { 0xFE26, BIDI_NSM },  // COMBINING CONJOINING MACRON
  { 0xFE27, BIDI_NSM },  // COMBINING LIGATURE LEFT HALF BELOW
  { 0xFE28, BIDI_NSM },  // COMBINING LIGATURE RIGHT HALF BELOW
  { 0xFE29, BIDI_NSM },  // COMBINING TILDE LEFT HALF BELOW
  { 0xFE2A, BIDI_NSM },  // COMBINING TILDE RIGHT HALF BELOW
  { 0xFE2B, BIDI_NSM },  // COMBINING MACRON LEFT HALF BELOW
  { 0xFE2C, BIDI_NSM },  // COMBINING MACRON RIGHT HALF BELOW
  { 0xFE2D, BIDI_NSM },  // COMBINING CONJOINING MACRON BELOW
  { 0xFE2E, BIDI_NSM },  // COMBINING CYRILLIC TITLO LEFT HALF
  { 0xFE2F, BIDI_NSM },  // COMBINING CYRILLIC TITLO RIGHT HALF
  { 0xFE30, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
  { 0xFE31, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL EM DASH
  { 0xFE32, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL EN DASH
  { 0xFE33, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LOW LINE
  { 0xFE34, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
  { 0xFE35, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
  { 0xFE36, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
  { 0xFE37, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
  { 0xFE38, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
  { 0xFE39, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
  { 0xFE3A, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
  { 0xFE3B, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
  { 0xFE3C, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
  { 0xFE3D, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
  { 0xFE3E, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
  { 0xFE3F, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
  { 0xFE40, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
  { 0xFE41, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
  { 0xFE42, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
  { 0xFE43, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
  { 0xFE44, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
  { 0xFE45, BIDI_ON  },  // SESAME DOT
  { 0xFE46, BIDI_ON  },  // WHITE SESAME DOT
  { 0xFE47, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
  { 0xFE48, BIDI_ON  },  // PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
  { 0xFE49, BIDI_ON  },  // DASHED OVERLINE
  { 0xFE4A, BIDI_ON  },  // CENTRELINE OVERLINE
  { 0xFE4B, BIDI_ON  },  // WAVY OVERLINE
  { 0xFE4C, BIDI_ON  },  // DOUBLE WAVY OVERLINE
  { 0xFE4D, BIDI_ON  },  // DASHED LOW LINE
  { 0xFE4E, BIDI_ON  },  // CENTRELINE LOW LINE
  { 0xFE4F, BIDI_ON  },  // WAVY LOW LINE
  { 0xFE50, BIDI_CS  },  // SMALL COMMA
  { 0xFE51, BIDI_ON  },  // SMALL IDEOGRAPHIC COMMA
  { 0xFE52, BIDI_CS  },  // SMALL FULL STOP
  { 0xFE54, BIDI_ON  },  // SMALL SEMICOLON
  { 0xFE55, BIDI_CS  },  // SMALL COLON
  { 0xFE56, BIDI_ON  },  // SMALL QUESTION MARK
  { 0xFE57, BIDI_ON  },  // SMALL EXCLAMATION MARK
  { 0xFE58, BIDI_ON  },  // SMALL EM DASH
  { 0xFE59, BIDI_ON  },  // SMALL LEFT PARENTHESIS
  { 0xFE5A, BIDI_ON  },  // SMALL RIGHT PARENTHESIS
  { 0xFE5B, BIDI_ON  },  // SMALL LEFT CURLY BRACKET
  { 0xFE5C, BIDI_ON  },  // SMALL RIGHT CURLY BRACKET
  { 0xFE5D, BIDI_ON  },  // SMALL LEFT TORTOISE SHELL BRACKET
  { 0xFE5E, BIDI_ON  },  // SMALL RIGHT TORTOISE SHELL BRACKET
  { 0xFE5F, BIDI_ET  },  // SMALL NUMBER SIGN
  { 0xFE60, BIDI_ON  },  // SMALL AMPERSAND
  { 0xFE61, BIDI_ON  },  // SMALL ASTERISK
  { 0xFE62, BIDI_ES  },  // SMALL PLUS SIGN
  { 0xFE63, BIDI_ES  },  // SMALL HYPHEN-MINUS
  { 0xFE64, BIDI_ON  },  // SMALL LESS-THAN SIGN
  { 0xFE65, BIDI_ON  },  // SMALL GREATER-THAN SIGN
  { 0xFE66, BIDI_ON  },  // SMALL EQUALS SIGN
  { 0xFE68, BIDI_ON  },  // SMALL REVERSE SOLIDUS
  { 0xFE69, BIDI_ET  },  // SMALL DOLLAR SIGN
  { 0xFE6A, BIDI_ET  },  // SMALL PERCENT SIGN
  { 0xFE6B, BIDI_ON  },  // SMALL COMMERCIAL AT
  { 0xFE70, BIDI_AL  },  // ARABIC FATHATAN ISOLATED FORM
  { 0xFE71, BIDI_AL  },  // ARABIC TATWEEL WITH FATHATAN ABOVE
  { 0xFE72, BIDI_AL  },  // ARABIC DAMMATAN ISOLATED FORM
  { 0xFE73, BIDI_AL  },  // ARABIC TAIL FRAGMENT
  { 0xFE74, BIDI_AL  },  // ARABIC KASRATAN ISOLATED FORM
  { 0xFE76, BIDI_AL  },  // ARABIC FATHA ISOLATED FORM
  { 0xFE77, BIDI_AL  },  // ARABIC FATHA MEDIAL FORM
  { 0xFE78, BIDI_AL  },  // ARABIC DAMMA ISOLATED FORM
  { 0xFE79, BIDI_AL  },  // ARABIC DAMMA MEDIAL FORM
  { 0xFE7A, BIDI_AL  },  // ARABIC KASRA ISOLATED FORM
  { 0xFE7B, BIDI_AL  },  // ARABIC KASRA MEDIAL FORM
  { 0xFE7C, BIDI_AL  },  // ARABIC SHADDA ISOLATED FORM
  { 0xFE7D, BIDI_AL  },  // ARABIC SHADDA MEDIAL FORM
  { 0xFE7E, BIDI_AL  },  // ARABIC SUKUN ISOLATED FORM
  { 0xFE7F, BIDI_AL  },  // ARABIC SUKUN MEDIAL FORM
  { 0xFE80, BIDI_AL  },  // ARABIC LETTER HAMZA ISOLATED FORM
  { 0xFE81, BIDI_AL  },  // ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM
  { 0xFE82, BIDI_AL  },  // ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM
  { 0xFE83, BIDI_AL  },  // ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM
  { 0xFE84, BIDI_AL  },  // ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM
  { 0xFE85, BIDI_AL  },  // ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM
  { 0xFE86, BIDI_AL  },  // ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM
  { 0xFE87, BIDI_AL  },  // ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM
  { 0xFE88, BIDI_AL  },  // ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM
  { 0xFE89, BIDI_AL  },  // ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM
  { 0xFE8A, BIDI_AL  },  // ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM
  { 0xFE8B, BIDI_AL  },  // ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM
  { 0xFE8C, BIDI_AL  },  // ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM
  { 0xFE8D, BIDI_AL  },  // ARABIC LETTER ALEF ISOLATED FORM
  { 0xFE8E, BIDI_AL  },  // ARABIC LETTER ALEF FINAL FORM
  { 0xFE8F, BIDI_AL  },  // ARABIC LETTER BEH ISOLATED FORM
  { 0xFE90, BIDI_AL  },  // ARABIC LETTER BEH FINAL FORM
  { 0xFE91, BIDI_AL  },  // ARABIC LETTER BEH INITIAL FORM
  { 0xFE92, BIDI_AL  },  // ARABIC LETTER BEH MEDIAL FORM
  { 0xFE93, BIDI_AL  },  // ARABIC LETTER TEH MARBUTA ISOLATED FORM
  { 0xFE94, BIDI_AL  },  // ARABIC LETTER TEH MARBUTA FINAL FORM
  { 0xFE95, BIDI_AL  },  // ARABIC LETTER TEH ISOLATED FORM
  { 0xFE96, BIDI_AL  },  // ARABIC LETTER TEH FINAL FORM
  { 0xFE97, BIDI_AL  },  // ARABIC LETTER TEH INITIAL FORM
  { 0xFE98, BIDI_AL  },  // ARABIC LETTER TEH MEDIAL FORM
  { 0xFE99, BIDI_AL  },  // ARABIC LETTER THEH ISOLATED FORM
  { 0xFE9A, BIDI_AL  },  // ARABIC LETTER THEH FINAL FORM
  { 0xFE9B, BIDI_AL  },  // ARABIC LETTER THEH INITIAL FORM
  { 0xFE9C, BIDI_AL  },  // ARABIC LETTER THEH MEDIAL FORM
  { 0xFE9D, BIDI_AL  },  // ARABIC LETTER JEEM ISOLATED FORM
  { 0xFE9E, BIDI_AL  },  // ARABIC LETTER JEEM FINAL FORM
  { 0xFE9F, BIDI_AL  },  // ARABIC LETTER JEEM INITIAL FORM
  { 0xFEA0, BIDI_AL  },  // ARABIC LETTER JEEM MEDIAL FORM
  { 0xFEA1, BIDI_AL  },  // ARABIC LETTER HAH ISOLATED FORM
  { 0xFEA2, BIDI_AL  },  // ARABIC LETTER HAH FINAL FORM
  { 0xFEA3, BIDI_AL  },  // ARABIC LETTER HAH INITIAL FORM
  { 0xFEA4, BIDI_AL  },  // ARABIC LETTER HAH MEDIAL FORM
  { 0xFEA5, BIDI_AL  },  // ARABIC LETTER KHAH ISOLATED FORM
  { 0xFEA6, BIDI_AL  },  // ARABIC LETTER KHAH FINAL FORM
  { 0xFEA7, BIDI_AL  },  // ARABIC LETTER KHAH INITIAL FORM
  { 0xFEA8, BIDI_AL  },  // ARABIC LETTER KHAH MEDIAL FORM
  { 0xFEA9, BIDI_AL  },  // ARABIC LETTER DAL ISOLATED FORM
  { 0xFEAA, BIDI_AL  },  // ARABIC LETTER DAL FINAL FORM
  { 0xFEAB, BIDI_AL  },  // ARABIC LETTER THAL ISOLATED FORM
  { 0xFEAC, BIDI_AL  },  // ARABIC LETTER THAL FINAL FORM
  { 0xFEAD, BIDI_AL  },  // ARABIC LETTER REH ISOLATED FORM
  { 0xFEAE, BIDI_AL  },  // ARABIC LETTER REH FINAL FORM
  { 0xFEAF, BIDI_AL  },  // ARABIC LETTER ZAIN ISOLATED FORM
  { 0xFEB0, BIDI_AL  },  // ARABIC LETTER ZAIN FINAL FORM
  { 0xFEB1, BIDI_AL  },  // ARABIC LETTER SEEN ISOLATED FORM
  { 0xFEB2, BIDI_AL  },  // ARABIC LETTER SEEN FINAL FORM
  { 0xFEB3, BIDI_AL  },  // ARABIC LETTER SEEN INITIAL FORM
  { 0xFEB4, BIDI_AL  },  // ARABIC LETTER SEEN MEDIAL FORM
  { 0xFEB5, BIDI_AL  },  // ARABIC LETTER SHEEN ISOLATED FORM
  { 0xFEB6, BIDI_AL  },  // ARABIC LETTER SHEEN FINAL FORM
  { 0xFEB7, BIDI_AL  },  // ARABIC LETTER SHEEN INITIAL FORM
  { 0xFEB8, BIDI_AL  },  // ARABIC LETTER SHEEN MEDIAL FORM
  { 0xFEB9, BIDI_AL  },  // ARABIC LETTER SAD ISOLATED FORM
  { 0xFEBA, BIDI_AL  },  // ARABIC LETTER SAD FINAL FORM
  { 0xFEBB, BIDI_AL  },  // ARABIC LETTER SAD INITIAL FORM
  { 0xFEBC, BIDI_AL  },  // ARABIC LETTER SAD MEDIAL FORM
  { 0xFEBD, BIDI_AL  },  // ARABIC LETTER DAD ISOLATED FORM
  { 0xFEBE, BIDI_AL  },  // ARABIC LETTER DAD FINAL FORM
  { 0xFEBF, BIDI_AL  },  // ARABIC LETTER DAD INITIAL FORM
  { 0xFEC0, BIDI_AL  },  // ARABIC LETTER DAD MEDIAL FORM
  { 0xFEC1, BIDI_AL  },  // ARABIC LETTER TAH ISOLATED FORM
  { 0xFEC2, BIDI_AL  },  // ARABIC LETTER TAH FINAL FORM
  { 0xFEC3, BIDI_AL  },  // ARABIC LETTER TAH INITIAL FORM
  { 0xFEC4, BIDI_AL  },  // ARABIC LETTER TAH MEDIAL FORM
  { 0xFEC5, BIDI_AL  },  // ARABIC LETTER ZAH ISOLATED FORM
  { 0xFEC6, BIDI_AL  },  // ARABIC LETTER ZAH FINAL FORM
  { 0xFEC7, BIDI_AL  },  // ARABIC LETTER ZAH INITIAL FORM
  { 0xFEC8, BIDI_AL  },  // ARABIC LETTER ZAH MEDIAL FORM
  { 0xFEC9, BIDI_AL  },  // ARABIC LETTER AIN ISOLATED FORM
  { 0xFECA, BIDI_AL  },  // ARABIC LETTER AIN FINAL FORM
  { 0xFECB, BIDI_AL  },  // ARABIC LETTER AIN INITIAL FORM
  { 0xFECC, BIDI_AL  },  // ARABIC LETTER AIN MEDIAL FORM
  { 0xFECD, BIDI_AL  },  // ARABIC LETTER GHAIN ISOLATED FORM
  { 0xFECE, BIDI_AL  },  // ARABIC LETTER GHAIN FINAL FORM
  { 0xFECF, BIDI_AL  },  // ARABIC LETTER GHAIN INITIAL FORM
  { 0xFED0, BIDI_AL  },  // ARABIC LETTER GHAIN MEDIAL FORM
  { 0xFED1, BIDI_AL  },  // ARABIC LETTER FEH ISOLATED FORM
  { 0xFED2, BIDI_AL  },  // ARABIC LETTER FEH FINAL FORM
  { 0xFED3, BIDI_AL  },  // ARABIC LETTER FEH INITIAL FORM
  { 0xFED4, BIDI_AL  },  // ARABIC LETTER FEH MEDIAL FORM
  { 0xFED5, BIDI_AL  },  // ARABIC LETTER QAF ISOLATED FORM
  { 0xFED6, BIDI_AL  },  // ARABIC LETTER QAF FINAL FORM
  { 0xFED7, BIDI_AL  },  // ARABIC LETTER QAF INITIAL FORM
  { 0xFED8, BIDI_AL  },  // ARABIC LETTER QAF MEDIAL FORM
  { 0xFED9, BIDI_AL  },  // ARABIC LETTER KAF ISOLATED FORM
  { 0xFEDA, BIDI_AL  },  // ARABIC LETTER KAF FINAL FORM
  { 0xFEDB, BIDI_AL  },  // ARABIC LETTER KAF INITIAL FORM
  { 0xFEDC, BIDI_AL  },  // ARABIC LETTER KAF MEDIAL FORM
  { 0xFEDD, BIDI_AL  },  // ARABIC LETTER LAM ISOLATED FORM
  { 0xFEDE, BIDI_AL  },  // ARABIC LETTER LAM FINAL FORM
  { 0xFEDF, BIDI_AL  },  // ARABIC LETTER LAM INITIAL FORM
  { 0xFEE0, BIDI_AL  },  // ARABIC LETTER LAM MEDIAL FORM
  { 0xFEE1, BIDI_AL  },  // ARABIC LETTER MEEM ISOLATED FORM
  { 0xFEE2, BIDI_AL  },  // ARABIC LETTER MEEM FINAL FORM
  { 0xFEE3, BIDI_AL  },  // ARABIC LETTER MEEM INITIAL FORM
  { 0xFEE4, BIDI_AL  },  // ARABIC LETTER MEEM MEDIAL FORM
  { 0xFEE5, BIDI_AL  },  // ARABIC LETTER NOON ISOLATED FORM
  { 0xFEE6, BIDI_AL  },  // ARABIC LETTER NOON FINAL FORM
  { 0xFEE7, BIDI_AL  },  // ARABIC LETTER NOON INITIAL FORM
  { 0xFEE8, BIDI_AL  },  // ARABIC LETTER NOON MEDIAL FORM
  { 0xFEE9, BIDI_AL  },  // ARABIC LETTER HEH ISOLATED FORM
  { 0xFEEA, BIDI_AL  },  // ARABIC LETTER HEH FINAL FORM
  { 0xFEEB, BIDI_AL  },  // ARABIC LETTER HEH INITIAL FORM
  { 0xFEEC, BIDI_AL  },  // ARABIC LETTER HEH MEDIAL FORM
  { 0xFEED, BIDI_AL  },  // ARABIC LETTER WAW ISOLATED FORM
  { 0xFEEE, BIDI_AL  },  // ARABIC LETTER WAW FINAL FORM
  { 0xFEEF, BIDI_AL  },  // ARABIC LETTER ALEF MAKSURA ISOLATED FORM
  { 0xFEF0, BIDI_AL  },  // ARABIC LETTER ALEF MAKSURA FINAL FORM
  { 0xFEF1, BIDI_AL  },  // ARABIC LETTER YEH ISOLATED FORM
  { 0xFEF2, BIDI_AL  },  // ARABIC LETTER YEH FINAL FORM
  { 0xFEF3, BIDI_AL  },  // ARABIC LETTER YEH INITIAL FORM
  { 0xFEF4, BIDI_AL  },  // ARABIC LETTER YEH MEDIAL FORM
  { 0xFEF5, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM
  { 0xFEF6, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM
  { 0xFEF7, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM
  { 0xFEF8, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM
  { 0xFEF9, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM
  { 0xFEFA, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM
  { 0xFEFB, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM
  { 0xFEFC, BIDI_AL  },  // ARABIC LIGATURE LAM WITH ALEF FINAL FORM
  { 0xFEFF, BIDI_BN  },  // ZERO WIDTH NO-BREAK SPACE
  { 0xFF01, BIDI_ON  },  // FULLWIDTH EXCLAMATION MARK
  { 0xFF02, BIDI_ON  },  // FULLWIDTH QUOTATION MARK
  { 0xFF03, BIDI_ET  },  // FULLWIDTH NUMBER SIGN
  { 0xFF04, BIDI_ET  },  // FULLWIDTH DOLLAR SIGN
  { 0xFF05, BIDI_ET  },  // FULLWIDTH PERCENT SIGN
  { 0xFF06, BIDI_ON  },  // FULLWIDTH AMPERSAND
  { 0xFF07, BIDI_ON  },  // FULLWIDTH APOSTROPHE
  { 0xFF08, BIDI_ON  },  // FULLWIDTH LEFT PARENTHESIS
  { 0xFF09, BIDI_ON  },  // FULLWIDTH RIGHT PARENTHESIS
  { 0xFF0A, BIDI_ON  },  // FULLWIDTH ASTERISK
  { 0xFF0B, BIDI_ES  },  // FULLWIDTH PLUS SIGN
  { 0xFF0C, BIDI_CS  },  // FULLWIDTH COMMA
  { 0xFF0D, BIDI_ES  },  // FULLWIDTH HYPHEN-MINUS
  { 0xFF0E, BIDI_CS  },  // FULLWIDTH FULL STOP
  { 0xFF0F, BIDI_CS  },  // FULLWIDTH SOLIDUS
  { 0xFF10, BIDI_EN  },  // FULLWIDTH DIGIT ZERO
  { 0xFF11, BIDI_EN  },  // FULLWIDTH DIGIT ONE
  { 0xFF12, BIDI_EN  },  // FULLWIDTH DIGIT TWO
  { 0xFF13, BIDI_EN  },  // FULLWIDTH DIGIT THREE
  { 0xFF14, BIDI_EN  },  // FULLWIDTH DIGIT FOUR
  { 0xFF15, BIDI_EN  },  // FULLWIDTH DIGIT FIVE
  { 0xFF16, BIDI_EN  },  // FULLWIDTH DIGIT SIX
  { 0xFF17, BIDI_EN  },  // FULLWIDTH DIGIT SEVEN
  { 0xFF18, BIDI_EN  },  // FULLWIDTH DIGIT EIGHT
  { 0xFF19, BIDI_EN  },  // FULLWIDTH DIGIT NINE
  { 0xFF1A, BIDI_CS  },  // FULLWIDTH COLON
  { 0xFF1B, BIDI_ON  },  // FULLWIDTH SEMICOLON
  { 0xFF1C, BIDI_ON  },  // FULLWIDTH LESS-THAN SIGN
  { 0xFF1D, BIDI_ON  },  // FULLWIDTH EQUALS SIGN
  { 0xFF1E, BIDI_ON  },  // FULLWIDTH GREATER-THAN SIGN
  { 0xFF1F, BIDI_ON  },  // FULLWIDTH QUESTION MARK
  { 0xFF20, BIDI_ON  },  // FULLWIDTH COMMERCIAL AT
  { 0xFF21, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER A
  { 0xFF22, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER B
  { 0xFF23, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER C
  { 0xFF24, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER D
  { 0xFF25, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER E
  { 0xFF26, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER F
  { 0xFF27, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER G
  { 0xFF28, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER H
  { 0xFF29, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER I
  { 0xFF2A, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER J
  { 0xFF2B, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER K
  { 0xFF2C, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER L
  { 0xFF2D, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER M
  { 0xFF2E, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER N
  { 0xFF2F, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER O
  { 0xFF30, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER P
  { 0xFF31, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER Q
  { 0xFF32, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER R
  { 0xFF33, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER S
  { 0xFF34, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER T
  { 0xFF35, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER U
  { 0xFF36, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER V
  { 0xFF37, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER W
  { 0xFF38, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER X
  { 0xFF39, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER Y
  { 0xFF3A, BIDI_L   },  // FULLWIDTH LATIN CAPITAL LETTER Z
  { 0xFF3B, BIDI_ON  },  // FULLWIDTH LEFT SQUARE BRACKET
  { 0xFF3C, BIDI_ON  },  // FULLWIDTH REVERSE SOLIDUS
  { 0xFF3D, BIDI_ON  },  // FULLWIDTH RIGHT SQUARE BRACKET
  { 0xFF3E, BIDI_ON  },  // FULLWIDTH CIRCUMFLEX ACCENT
  { 0xFF3F, BIDI_ON  },  // FULLWIDTH LOW LINE
  { 0xFF40, BIDI_ON  },  // FULLWIDTH GRAVE ACCENT
  { 0xFF41, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER A
  { 0xFF42, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER B
  { 0xFF43, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER C
  { 0xFF44, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER D
  { 0xFF45, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER E
  { 0xFF46, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER F
  { 0xFF47, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER G
  { 0xFF48, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER H
  { 0xFF49, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER I
  { 0xFF4A, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER J
  { 0xFF4B, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER K
  { 0xFF4C, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER L
  { 0xFF4D, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER M
  { 0xFF4E, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER N
  { 0xFF4F, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER O
  { 0xFF50, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER P
  { 0xFF51, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER Q
  { 0xFF52, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER R
  { 0xFF53, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER S
  { 0xFF54, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER T
  { 0xFF55, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER U
  { 0xFF56, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER V
  { 0xFF57, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER W
  { 0xFF58, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER X
  { 0xFF59, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER Y
  { 0xFF5A, BIDI_L   },  // FULLWIDTH LATIN SMALL LETTER Z
  { 0xFF5B, BIDI_ON  },  // FULLWIDTH LEFT CURLY BRACKET
  { 0xFF5C, BIDI_ON  },  // FULLWIDTH VERTICAL LINE
  { 0xFF5D, BIDI_ON  },  // FULLWIDTH RIGHT CURLY BRACKET
  { 0xFF5E, BIDI_ON  },  // FULLWIDTH TILDE
  { 0xFF5F, BIDI_ON  },  // FULLWIDTH LEFT WHITE PARENTHESIS
  { 0xFF60, BIDI_ON  },  // FULLWIDTH RIGHT WHITE PARENTHESIS
  { 0xFF61, BIDI_ON  },  // HALFWIDTH IDEOGRAPHIC FULL STOP
  { 0xFF62, BIDI_ON  },  // HALFWIDTH LEFT CORNER BRACKET
  { 0xFF63, BIDI_ON  },  // HALFWIDTH RIGHT CORNER BRACKET
  { 0xFF64, BIDI_ON  },  // HALFWIDTH IDEOGRAPHIC COMMA
  { 0xFF65, BIDI_ON  },  // HALFWIDTH KATAKANA MIDDLE DOT
  { 0xFF66, BIDI_L   },  // HALFWIDTH KATAKANA LETTER WO
  { 0xFF67, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL A
  { 0xFF68, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL I
  { 0xFF69, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL U
  { 0xFF6A, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL E
  { 0xFF6B, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL O
  { 0xFF6C, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL YA
  { 0xFF6D, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL YU
  { 0xFF6E, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL YO
  { 0xFF6F, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SMALL TU
  { 0xFF70, BIDI_L   },  // HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
  { 0xFF71, BIDI_L   },  // HALFWIDTH KATAKANA LETTER A
  { 0xFF72, BIDI_L   },  // HALFWIDTH KATAKANA LETTER I
  { 0xFF73, BIDI_L   },  // HALFWIDTH KATAKANA LETTER U
  { 0xFF74, BIDI_L   },  // HALFWIDTH KATAKANA LETTER E
  { 0xFF75, BIDI_L   },  // HALFWIDTH KATAKANA LETTER O
  { 0xFF76, BIDI_L   },  // HALFWIDTH KATAKANA LETTER KA
  { 0xFF77, BIDI_L   },  // HALFWIDTH KATAKANA LETTER KI
  { 0xFF78, BIDI_L   },  // HALFWIDTH KATAKANA LETTER KU
  { 0xFF79, BIDI_L   },  // HALFWIDTH KATAKANA LETTER KE
  { 0xFF7A, BIDI_L   },  // HALFWIDTH KATAKANA LETTER KO
  { 0xFF7B, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SA
  { 0xFF7C, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SI
  { 0xFF7D, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SU
  { 0xFF7E, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SE
  { 0xFF7F, BIDI_L   },  // HALFWIDTH KATAKANA LETTER SO
  { 0xFF80, BIDI_L   },  // HALFWIDTH KATAKANA LETTER TA
  { 0xFF81, BIDI_L   },  // HALFWIDTH KATAKANA LETTER TI
  { 0xFF82, BIDI_L   },  // HALFWIDTH KATAKANA LETTER TU
  { 0xFF83, BIDI_L   },  // HALFWIDTH KATAKANA LETTER TE
  { 0xFF84, BIDI_L   },  // HALFWIDTH KATAKANA LETTER TO
  { 0xFF85, BIDI_L   },  // HALFWIDTH KATAKANA LETTER NA
  { 0xFF86, BIDI_L   },  // HALFWIDTH KATAKANA LETTER NI
  { 0xFF87, BIDI_L   },  // HALFWIDTH KATAKANA LETTER NU
  { 0xFF88, BIDI_L   },  // HALFWIDTH KATAKANA LETTER NE
  { 0xFF89, BIDI_L   },  // HALFWIDTH KATAKANA LETTER NO
  { 0xFF8A, BIDI_L   },  // HALFWIDTH KATAKANA LETTER HA
  { 0xFF8B, BIDI_L   },  // HALFWIDTH KATAKANA LETTER HI
  { 0xFF8C, BIDI_L   },  // HALFWIDTH KATAKANA LETTER HU
  { 0xFF8D, BIDI_L   },  // HALFWIDTH KATAKANA LETTER HE
  { 0xFF8E, BIDI_L   },  // HALFWIDTH KATAKANA LETTER HO
  { 0xFF8F, BIDI_L   },  // HALFWIDTH KATAKANA LETTER MA
  { 0xFF90, BIDI_L   },  // HALFWIDTH KATAKANA LETTER MI
  { 0xFF91, BIDI_L   },  // HALFWIDTH KATAKANA LETTER MU
  { 0xFF92, BIDI_L   },  // HALFWIDTH KATAKANA LETTER ME
  { 0xFF93, BIDI_L   },  // HALFWIDTH KATAKANA LETTER MO
  { 0xFF94, BIDI_L   },  // HALFWIDTH KATAKANA LETTER YA
  { 0xFF95, BIDI_L   },  // HALFWIDTH KATAKANA LETTER YU
  { 0xFF96, BIDI_L   },  // HALFWIDTH KATAKANA LETTER YO
  { 0xFF97, BIDI_L   },  // HALFWIDTH KATAKANA LETTER RA
  { 0xFF98, BIDI_L   },  // HALFWIDTH KATAKANA LETTER RI
  { 0xFF99, BIDI_L   },  // HALFWIDTH KATAKANA LETTER RU
  { 0xFF9A, BIDI_L   },  // HALFWIDTH KATAKANA LETTER RE
  { 0xFF9B, BIDI_L   },  // HALFWIDTH KATAKANA LETTER RO
  { 0xFF9C, BIDI_L   },  // HALFWIDTH KATAKANA LETTER WA
  { 0xFF9D, BIDI_L   },  // HALFWIDTH KATAKANA LETTER N
  { 0xFF9E, BIDI_L   },  // HALFWIDTH KATAKANA VOICED SOUND MARK
  { 0xFF9F, BIDI_L   },  // HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
  { 0xFFA0, BIDI_L   },  // HALFWIDTH HANGUL FILLER
  { 0xFFA1, BIDI_L   },  // HALFWIDTH HANGUL LETTER KIYEOK
  { 0xFFA2, BIDI_L   },  // HALFWIDTH HANGUL LETTER SSANGKIYEOK
  { 0xFFA3, BIDI_L   },  // HALFWIDTH HANGUL LETTER KIYEOK-SIOS
  { 0xFFA4, BIDI_L   },  // HALFWIDTH HANGUL LETTER NIEUN
  { 0xFFA5, BIDI_L   },  // HALFWIDTH HANGUL LETTER NIEUN-CIEUC
  { 0xFFA6, BIDI_L   },  // HALFWIDTH HANGUL LETTER NIEUN-HIEUH
  { 0xFFA7, BIDI_L   },  // HALFWIDTH HANGUL LETTER TIKEUT
  { 0xFFA8, BIDI_L   },  // HALFWIDTH HANGUL LETTER SSANGTIKEUT
  { 0xFFA9, BIDI_L   },  // HALFWIDTH HANGUL LETTER RIEUL
  { 0xFFAA, BIDI_L   },  // HALFWIDTH HANGUL LETTER RIEUL-KIYEOK
  { 0xFFAB, BIDI_L   },  // HALFWIDTH HANGUL LETTER RIEUL-MIEUM
  { 0xFFAC, BIDI_L   },  // HALFWIDTH HANGUL LETTER RIEUL-PIEUP
  { 0xFFAD, BIDI_L   },  // HALFWIDTH HANGUL LETTER RIEUL-SIOS
  { 0xFFAE, BIDI_L   },  // HALFWIDTH HANGUL LETTER RIEUL-THIEUTH
  { 0xFFAF, BIDI_L   },  // HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH
  { 0xFFB0, BIDI_L   },  // HALFWIDTH HANGUL LETTER RIEUL-HIEUH
  { 0xFFB1, BIDI_L   },  // HALFWIDTH HANGUL LETTER MIEUM
  { 0xFFB2, BIDI_L   },  // HALFWIDTH HANGUL LETTER PIEUP
  { 0xFFB3, BIDI_L   },  // HALFWIDTH HANGUL LETTER SSANGPIEUP
  { 0xFFB4, BIDI_L   },  // HALFWIDTH HANGUL LETTER PIEUP-SIOS
  { 0xFFB5, BIDI_L   },  // HALFWIDTH HANGUL LETTER SIOS
  { 0xFFB6, BIDI_L   },  // HALFWIDTH HANGUL LETTER SSANGSIOS
  { 0xFFB7, BIDI_L   },  // HALFWIDTH HANGUL LETTER IEUNG
  { 0xFFB8, BIDI_L   },  // HALFWIDTH HANGUL LETTER CIEUC
  { 0xFFB9, BIDI_L   },  // HALFWIDTH HANGUL LETTER SSANGCIEUC
  { 0xFFBA, BIDI_L   },  // HALFWIDTH HANGUL LETTER CHIEUCH
  { 0xFFBB, BIDI_L   },  // HALFWIDTH HANGUL LETTER KHIEUKH
  { 0xFFBC, BIDI_L   },  // HALFWIDTH HANGUL LETTER THIEUTH
  { 0xFFBD, BIDI_L   },  // HALFWIDTH HANGUL LETTER PHIEUPH
  { 0xFFBE, BIDI_L   },  // HALFWIDTH HANGUL LETTER HIEUH
  { 0xFFC2, BIDI_L   },  // HALFWIDTH HANGUL LETTER A
  { 0xFFC3, BIDI_L   },  // HALFWIDTH HANGUL LETTER AE
  { 0xFFC4, BIDI_L   },  // HALFWIDTH HANGUL LETTER YA
  { 0xFFC5, BIDI_L   },  // HALFWIDTH HANGUL LETTER YAE
  { 0xFFC6, BIDI_L   },  // HALFWIDTH HANGUL LETTER EO
  { 0xFFC7, BIDI_L   },  // HALFWIDTH HANGUL LETTER E
  { 0xFFCA, BIDI_L   },  // HALFWIDTH HANGUL LETTER YEO
  { 0xFFCB, BIDI_L   },  // HALFWIDTH HANGUL LETTER YE
  { 0xFFCC, BIDI_L   },  // HALFWIDTH HANGUL LETTER O
  { 0xFFCD, BIDI_L   },  // HALFWIDTH HANGUL LETTER WA
  { 0xFFCE, BIDI_L   },  // HALFWIDTH HANGUL LETTER WAE
  { 0xFFCF, BIDI_L   },  // HALFWIDTH HANGUL LETTER OE
  { 0xFFD2, BIDI_L   },  // HALFWIDTH HANGUL LETTER YO
  { 0xFFD3, BIDI_L   },  // HALFWIDTH HANGUL LETTER U
  { 0xFFD4, BIDI_L   },  // HALFWIDTH HANGUL LETTER WEO
  { 0xFFD5, BIDI_L   },  // HALFWIDTH HANGUL LETTER WE
  { 0xFFD6, BIDI_L   },  // HALFWIDTH HANGUL LETTER WI
  { 0xFFD7, BIDI_L   },  // HALFWIDTH HANGUL LETTER YU
  { 0xFFDA, BIDI_L   },  // HALFWIDTH HANGUL LETTER EU
  { 0xFFDB, BIDI_L   },  // HALFWIDTH HANGUL LETTER YI
  { 0xFFDC, BIDI_L   },  // HALFWIDTH HANGUL LETTER I
  { 0xFFE0, BIDI_ET  },  // FULLWIDTH CENT SIGN
  { 0xFFE1, BIDI_ET  },  // FULLWIDTH POUND SIGN
  { 0xFFE2, BIDI_ON  },  // FULLWIDTH NOT SIGN
  { 0xFFE3, BIDI_ON  },  // FULLWIDTH MACRON
  { 0xFFE4, BIDI_ON  },  // FULLWIDTH BROKEN BAR
  { 0xFFE5, BIDI_ET  },  // FULLWIDTH YEN SIGN
  { 0xFFE6, BIDI_ET  },  // FULLWIDTH WON SIGN
  { 0xFFE8, BIDI_ON  },  // HALFWIDTH FORMS LIGHT VERTICAL
  { 0xFFE9, BIDI_ON  },  // HALFWIDTH LEFTWARDS ARROW
  { 0xFFEA, BIDI_ON  },  // HALFWIDTH UPWARDS ARROW
  { 0xFFEB, BIDI_ON  },  // HALFWIDTH RIGHTWARDS ARROW
  { 0xFFEC, BIDI_ON  },  // HALFWIDTH DOWNWARDS ARROW
  { 0xFFED, BIDI_ON  },  // HALFWIDTH BLACK SQUARE
  { 0xFFEE, BIDI_ON  },  // HALFWIDTH WHITE CIRCLE
  { 0xFFF9, BIDI_ON  },  // INTERLINEAR ANNOTATION ANCHOR
  { 0xFFFA, BIDI_ON  },  // INTERLINEAR ANNOTATION SEPARATOR
  { 0xFFFB, BIDI_ON  },  // INTERLINEAR ANNOTATION TERMINATOR
  { 0xFFFC, BIDI_ON  },  // OBJECT REPLACEMENT CHARACTER
  { 0xFFFD, BIDI_ON  },  // REPLACEMENT CHARACTER

#endif // GUI_BIDI_SUPPORT_RANGE_F

#endif // GUI__BIDI2

/*************************** End of file ****************************/

