/*
 * Copyright 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v8.0
processor: MKE17Z256xxx7
package_id: MKE17Z256VLL7
mcu_data: ksdk2_0
processor_version: 0.9.1
board: FRDM-KE17Z
pin_labels:
- {pin_num: '63', pin_signal: PTB17/FTM0_CH5/LPSPI1_PCS3, label: 'J3[5]/J6[4]/MC_PWM_CB/RF_SPI1_PCS3', identifier: MC_PWM_CB}
- {pin_num: '64', pin_signal: PTB16/FTM0_CH4/LPSPI1_SOUT, label: 'J3[7]/J6[6]/MC_PWM_CT/RF_SPI1_SOUT', identifier: MC_PWM_CB;MC_PWM_CT}
- {pin_num: '65', pin_signal: PTB15/FTM0_CH3/LPSPI1_SIN, label: 'J3[9]/J6[7]/MC_PWM_BB/RF_SPI1_SIN', identifier: MC_PWM_CT;MC_PWM_BB}
- {pin_num: '66', pin_signal: ADC1_SE9/PTB14/FTM0_CH2/LPSPI1_SCK, label: 'J3[11]/J6[5]/MC_PWM_BT/RF_SPI1_SCK', identifier: MC_PWM_BB;MC_PWM_BT}
- {pin_num: '67', pin_signal: ADC1_SE8/PTB13/FTM0_CH1, label: 'J3[13]/J6[8]/MC_PWM_AB/RF_GPIO_IRQ', identifier: MC_PWM_AB}
- {pin_num: '68', pin_signal: ADC1_SE7/PTB12/FTM0_CH0, label: 'J3[15]/MC_PWM_AT', identifier: MC_PWM_AT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "fsl_gpio.h"
#include "fsl_trgmux.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    /* Clock Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortB);
    CLOCK_EnableClock(kCLOCK_PortC);
    CLOCK_EnableClock(kCLOCK_PortD);
    CLOCK_EnableClock(kCLOCK_PortE);

	PinTool_PWM();
    PinTool_Misc();
    PinTool_LPUART();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
PinTool_PWM:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '68', peripheral: FTM0, signal: 'CH, 0', pin_signal: ADC1_SE7/PTB12/FTM0_CH0}
  - {pin_num: '67', peripheral: FTM0, signal: 'CH, 1', pin_signal: ADC1_SE8/PTB13/FTM0_CH1}
  - {pin_num: '66', peripheral: FTM0, signal: 'CH, 2', pin_signal: ADC1_SE9/PTB14/FTM0_CH2/LPSPI1_SCK, identifier: MC_PWM_BT}
  - {pin_num: '65', peripheral: FTM0, signal: 'CH, 3', pin_signal: PTB15/FTM0_CH3/LPSPI1_SIN, identifier: MC_PWM_BB}
  - {pin_num: '64', peripheral: FTM0, signal: 'CH, 4', pin_signal: PTB16/FTM0_CH4/LPSPI1_SOUT, identifier: MC_PWM_CT}
  - {pin_num: '63', peripheral: FTM0, signal: 'CH, 5', pin_signal: PTB17/FTM0_CH5/LPSPI1_PCS3}
  - {peripheral: PDB0, signal: TRG, pin_signal: FTM0_Trigger}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : PinTool_PWM
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void PinTool_PWM(void)
{
    /* PORTB12 (pin 68) is configured as FTM0_CH0 */
    PORT_SetPinMux(PINTOOL_PWM_MC_PWM_AT_PORT, PINTOOL_PWM_MC_PWM_AT_PIN, kPORT_MuxAlt2);

    /* PORTB13 (pin 67) is configured as FTM0_CH1 */
    PORT_SetPinMux(PINTOOL_PWM_MC_PWM_AB_PORT, PINTOOL_PWM_MC_PWM_AB_PIN, kPORT_MuxAlt2);

    /* PORTB14 (pin 66) is configured as FTM0_CH2 */
    PORT_SetPinMux(PINTOOL_PWM_MC_PWM_BT_PORT, PINTOOL_PWM_MC_PWM_BT_PIN, kPORT_MuxAlt2);

    /* PORTB15 (pin 65) is configured as FTM0_CH3 */
    PORT_SetPinMux(PINTOOL_PWM_MC_PWM_BB_PORT, PINTOOL_PWM_MC_PWM_BB_PIN, kPORT_MuxAlt2);

    /* PORTB16 (pin 64) is configured as FTM0_CH4 */
    PORT_SetPinMux(PINTOOL_PWM_MC_PWM_CT_PORT, PINTOOL_PWM_MC_PWM_CT_PIN, kPORT_MuxAlt2);

    /* PORTB17 (pin 63) is configured as FTM0_CH5 */
    PORT_SetPinMux(PINTOOL_PWM_MC_PWM_CB_PORT, PINTOOL_PWM_MC_PWM_CB_PIN, kPORT_MuxAlt2);

    SIM->ADCOPT = ((SIM->ADCOPT &
                    /* Mask bits to zero which are setting */
                    (~(SIM_ADCOPT_ADC0TRGSEL_MASK | SIM_ADCOPT_ADC0PRETRGSEL_MASK)))

                   /* ADC0 trigger source select: TRGMUX output. */
                   | SIM_ADCOPT_ADC0TRGSEL(0x01u)

                   /* ADC0 pre-trigger source select: TRGMUX output. */
                   | SIM_ADCOPT_ADC0PRETRGSEL(0x01u));

    /* FTM0 is selected as PDB0 device trigger input 0 */
    TRGMUX_SetTriggerSource(TRGMUX0, kTRGMUX_Lpit, kTRGMUX_TriggerInput0, kTRGMUX_SourceFtm0);
    /* ADC0 COCOA is selected as LPIT device trigger input 1 */
    TRGMUX_SetTriggerSource(TRGMUX0, kTRGMUX_Lpit, kTRGMUX_TriggerInput1, kTRGMUX_SourceAdc0CocoA);
    /* ADC0 COCOB is selected as LPIT device trigger input 2 */
    TRGMUX_SetTriggerSource(TRGMUX0, kTRGMUX_Lpit, kTRGMUX_TriggerInput2, kTRGMUX_SourceAdc0CocoB);

    /* LPIT0 Channel0 is selected as ADC0 device trigger input 0 */
    TRGMUX_SetTriggerSource(TRGMUX0, kTRGMUX_Adc0, kTRGMUX_TriggerInput0, kTRGMUX_SourceLpit0Ch0);
    /* LPIT0 Channel1 is selected as ADC0 device trigger input 1 */
    TRGMUX_SetTriggerSource(TRGMUX0, kTRGMUX_Adc0, kTRGMUX_TriggerInput1, kTRGMUX_SourceLpit0Ch1);
    /* LPIT0 Channel2 is selected as ADC0 device trigger input 2 */
    TRGMUX_SetTriggerSource(TRGMUX0, kTRGMUX_Adc0, kTRGMUX_TriggerInput2, kTRGMUX_SourceLpit0Ch2);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
PinTool_Misc:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : PinTool_Misc
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void PinTool_Misc(void)
{
    gpio_pin_config_t SW2_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PTB11 (pin 74)  */
    GPIO_PinInit(PINTOOL_MISC_SW2_GPIO, PINTOOL_MISC_SW2_PIN, &SW2_config);

    gpio_pin_config_t LED_RED_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PTD0 (pin 4)  */
    GPIO_PinInit(PINTOOL_MISC_LED_RED_GPIO, PINTOOL_MISC_LED_RED_PIN, &LED_RED_config);

    gpio_pin_config_t SW3_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PTD3 (pin 70)  */
    GPIO_PinInit(PINTOOL_MISC_SW3_GPIO, PINTOOL_MISC_SW3_PIN, &SW3_config);

    gpio_pin_config_t LED_GREEN_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PTD16 (pin 21)  */
    GPIO_PinInit(PINTOOL_MISC_LED_GREEN_GPIO, PINTOOL_MISC_LED_GREEN_PIN, &LED_GREEN_config);

    const port_pin_config_t SW2 = {/* Internal pull-up resistor is enabled */
                                   kPORT_PullUp,
                                   /* Passive filter is disabled */
                                   kPORT_PassiveFilterDisable,
                                   /* Low drive strength is configured */
                                   kPORT_LowDriveStrength,
                                   /* Pin is configured as PTB11 */
                                   kPORT_MuxAsGpio,
                                   /* Pin Control Register fields [15:0] are not locked */
                                   kPORT_UnlockRegister};
    /* PORTB11 (pin 74) is configured as PTB11 */
    PORT_SetPinConfig(PINTOOL_MISC_SW2_PORT, PINTOOL_MISC_SW2_PIN, &SW2);

    /* Interrupt configuration on PORTB11 (pin 74): Interrupt on rising edge */
    PORT_SetPinInterruptConfig(PINTOOL_MISC_SW2_PORT, PINTOOL_MISC_SW2_PIN, kPORT_InterruptRisingEdge);

    /* PORTD0 (pin 4) is configured as PTD0 */
    PORT_SetPinMux(PINTOOL_MISC_LED_RED_PORT, PINTOOL_MISC_LED_RED_PIN, kPORT_MuxAsGpio);

    /* PORTD16 (pin 21) is configured as PTD16 */
    PORT_SetPinMux(PINTOOL_MISC_LED_GREEN_PORT, PINTOOL_MISC_LED_GREEN_PIN, kPORT_MuxAsGpio);

    /* PORTD3 (pin 70) is configured as PTD3 */
    PORT_SetPinMux(PINTOOL_MISC_SW3_PORT, PINTOOL_MISC_SW3_PIN, kPORT_MuxAsGpio);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
PinTool_LPUART:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '81', peripheral: LPUART1, signal: RX, pin_signal: ADC1_SE4/TSI0_CH15/PTC6/LPUART1_RX}
  - {pin_num: '80', peripheral: LPUART1, signal: TX, pin_signal: ADC1_SE5/TSI0_CH16/PTC7/LPUART1_TX}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : PinTool_LPUART
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void PinTool_LPUART(void)
{
    /* PORTC6 (pin 81) is configured as LPUART1_RX */
    PORT_SetPinMux(PINTOOL_LPUART_DEBUG_UART_RX_PORT, PINTOOL_LPUART_DEBUG_UART_RX_PIN, kPORT_MuxAlt2);

    /* PORTC7 (pin 80) is configured as LPUART1_TX */
    PORT_SetPinMux(PINTOOL_LPUART_DEBUG_UART_TX_PORT, PINTOOL_LPUART_DEBUG_UART_TX_PIN, kPORT_MuxAlt2);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
