/*
 * Copyright 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PERIPHERALS_H_
#define _PERIPHERALS_H_

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "fsl_common.h"
#include "fsl_lpuart.h"
#include "fsl_clock.h"
#include "freemaster.h"
#include "freemaster_serial_lpuart.h"

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/
/* Definitions for BOARD_InitPeripherals functional group */
/* NVIC interrupt vector ID (number). */
#define INT_0_IRQN PORTBCD_IRQn
/* NVIC interrupt vector priority. */
#define INT_0_IRQ_PRIORITY 4
/* NVIC interrupt handler identifier. */
#define INT_0_IRQHANDLER PORTBCD_IRQHandler
/* FreeMASTER_Recorder_0's buffer size definition */
#define FREEMASTER_REC_0_SIZE 4096
/* Definition of peripheral ID */
#define FREEMASTER_SERIAL_PERIPHERAL LPUART0
/* Definition of the clock source frequency */
#define FREEMASTER_SERIAL_PERIPHERAL_CLK_FREQ 8000000UL
/* Definition of the Baud rate */
#define FREEMASTER_SERIAL_PERIPHERAL_BAUDRATE 19200UL

/***********************************************************************************************************************
 * Global variables
 **********************************************************************************************************************/
/* LPUART configuration structure */
extern lpuart_config_t FreeMASTER_serial_config;
/* Recorder0 configuration */
extern FMSTR_U8 FreeMASTER_RecBuffer0[FREEMASTER_REC_0_SIZE];

/***********************************************************************************************************************
 * Initialization functions
 **********************************************************************************************************************/

void BOARD_InitPeripherals(void);

/***********************************************************************************************************************
 * BOARD_InitBootPeripherals function
 **********************************************************************************************************************/
void BOARD_InitBootPeripherals(void);

#if defined(__cplusplus)
}
#endif

#endif /* _PERIPHERALS_H_ */
