/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"

#include "lvgl/lvgl.h"

#include "lvgl/lvgl.h"

#ifndef LV_ATTRIBUTE_MEM_ALIGN
#define LV_ATTRIBUTE_MEM_ALIGN
#endif

#ifndef LV_ATTRIBUTE_IMG__RISTRETTO_ALPHA_50X50
#define LV_ATTRIBUTE_IMG__RISTRETTO_ALPHA_50X50
#endif

const LV_ATTRIBUTE_MEM_ALIGN LV_ATTRIBUTE_IMG__RISTRETTO_ALPHA_50X50 uint8_t _ristretto_alpha_50x50_map[] = {
#if LV_COLOR_DEPTH == 16 && LV_COLOR_16_SWAP == 0
  /*Pixel format: Alpha 8 bit, Red: 5 bit, Green: 6 bit, Blue: 5 bit*/
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe3, 0x18, 0x00, 0x69, 0x4a, 0x16, 0x49, 0x4a, 0x3b, 0x08, 0x42, 0x59, 0xcb, 0x5a, 0x67, 0x6d, 0x6b, 0x6a, 0xef, 0x7b, 0x6a, 0x51, 0x8c, 0x6b, 0xb2, 0x94, 0x6f, 0x14, 0xa5, 0x73, 0x75, 0xad, 0x8b, 0xd7, 0xbd, 0xa1, 0x38, 0xc6, 0x9e, 0x9a, 0xd6, 0x81, 0x1c, 0xe7, 0x6f, 0x7d, 0xef, 0x6b, 0xbe, 0xf7, 0x67, 0xdf, 0xff, 0x66, 0xff, 0xff, 0x67, 0x5d, 0xef, 0x62, 0x14, 0xa5, 0x50, 0x14, 0xa5, 0x2f, 0xf3, 0x9c, 0x0a, 0x28, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x29, 0x00, 0xae, 0x73, 0x30, 0xd3, 0x9c, 0x51, 0x30, 0x84, 0x75, 0x51, 0x8c, 0x7f, 0x30, 0x84, 0x72, 0x30, 0x84, 0x6d, 0x51, 0x8c, 0x6e, 0x92, 0x94, 0x6a, 0xb2, 0x94, 0x63, 0xb2, 0x94, 0x59, 0xd3, 0x9c, 0x51, 0xd3, 0x9c, 0x4a, 0xd3, 0x9c, 0x43, 0xf3, 0x9c, 0x3e, 0xf3, 0x9c, 0x3e, 0xf3, 0x9c, 0x43, 0x14, 0xa5, 0x48, 0x34, 0xa5, 0x4e, 0x55, 0xad, 0x56, 0x75, 0xad, 0x60, 0xd7, 0xbd, 0x68, 0x59, 0xce, 0x6a, 0xdb, 0xde, 0x6b, 0x3c, 0xe7, 0x76, 0x7d, 0xef, 0x7f, 0xdb, 0xde, 0x67, 0x18, 0xc6, 0x43, 0xcb, 0x5a, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x29, 0x01, 0xb6, 0xb5, 0x60, 0x38, 0xc6, 0x83, 0x55, 0xad, 0x77, 0xd3, 0x9c, 0x52, 0xd3, 0x9c, 0x42, 0xf3, 0x9c, 0x33, 0xf3, 0x9c, 0x23, 0xd3, 0x9c, 0x18, 0xd3, 0x9c, 0x14, 0xd3, 0x9c, 0x14, 0xd3, 0x9c, 0x16, 0xd3, 0x9c, 0x18, 0xd3, 0x9c, 0x19, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x19, 0xb2, 0x94, 0x18, 0xb2, 0x94, 0x16, 0x92, 0x94, 0x15, 0x92, 0x94, 0x13, 0xb2, 0x94, 0x12, 0xb2, 0x94, 0x18, 0x92, 0x94, 0x26, 0x92, 0x94, 0x37, 0x14, 0xa5, 0x44, 0x18, 0xc6, 0x58, 0xdb, 0xde, 0x76, 0x1c, 0xe7, 0x6f, 0x14, 0xa5, 0x39, 0xc7, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x75, 0xad, 0x45, 0x1c, 0xe7, 0x99, 0x14, 0xa5, 0x50, 0xb2, 0x94, 0x1b, 0xd3, 0x9c, 0x1a, 0xd3, 0x9c, 0x18, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x1a, 0xd3, 0x9c, 0x1a, 0xd3, 0x9c, 0x1a, 0xd3, 0x9c, 0x1a, 0xd3, 0x9c, 0x1a, 0xd3, 0x9c, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x18, 0xb2, 0x94, 0x17, 0x92, 0x94, 0x15, 0x71, 0x8c, 0x12, 0x96, 0xb5, 0x5f, 0x7d, 0xef, 0x6c, 0xeb, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xa5, 0x35, 0xdb, 0xde, 0x8b, 0x55, 0xad, 0x6a, 0xb2, 0x94, 0x2c, 0x92, 0x94, 0x17, 0xb2, 0x94, 0x12, 0xd3, 0x9c, 0x13, 0xd3, 0x9c, 0x17, 0xd3, 0x9c, 0x18, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xd3, 0x9c, 0x19, 0xb2, 0x94, 0x1a, 0xb2, 0x94, 0x1a, 0xd3, 0x9c, 0x1b, 0xd3, 0x9c, 0x1c, 0xd3, 0x9c, 0x1d, 0xf3, 0x9c, 0x1d, 0xd3, 0x9c, 0x1e, 0xd3, 0x9c, 0x1d, 0xd3, 0x9c, 0x1d, 0xb2, 0x94, 0x20, 0xb2, 0x94, 0x24, 0x14, 0xa5, 0x3c, 0x59, 0xce, 0x79, 0x9a, 0xd6, 0x70, 0x49, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7, 0x39, 0x02, 0xb6, 0xb5, 0x58, 0x59, 0xce, 0x79, 0x96, 0xb5, 0x7e, 0xd3, 0x9c, 0x62, 0x51, 0x8c, 0x4e, 0x92, 0x94, 0x3f, 0xd3, 0x9c, 0x27, 0xb2, 0x94, 0x12, 0xb2, 0x94, 0x07, 0xb2, 0x94, 0x07, 0xb2, 0x94, 0x09, 0xb2, 0x94, 0x0b, 0xb2, 0x94, 0x0d, 0x92, 0x94, 0x0f, 0x92, 0x94, 0x0f, 0x71, 0x8c, 0x10, 0x51, 0x8c, 0x11, 0x71, 0x8c, 0x12, 0x92, 0x94, 0x14, 0xb2, 0x94, 0x1a, 0xd3, 0x9c, 0x22, 0xf3, 0x9c, 0x2d, 0x14, 0xa5, 0x3c, 0x14, 0xa5, 0x4b, 0x75, 0xad, 0x58, 0x18, 0xc6, 0x63, 0xba, 0xd6, 0x7a, 0x1c, 0xe7, 0x83, 0xdb, 0xde, 0x76, 0xf3, 0x9c, 0x46, 0x45, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x39, 0x00, 0x75, 0xad, 0x39, 0x18, 0xc6, 0x3c, 0x38, 0xc6, 0x41, 0xf7, 0xbd, 0x5c, 0xf7, 0xbd, 0x8a, 0x75, 0xad, 0x93, 0x92, 0x94, 0x82, 0x10, 0x84, 0x7a, 0xef, 0x7b, 0x74, 0x51, 0x8c, 0x6a, 0x71, 0x8c, 0x63, 0x71, 0x8c, 0x5d, 0x92, 0x94, 0x57, 0x92, 0x94, 0x53, 0xd3, 0x9c, 0x51, 0xf3, 0x9c, 0x52, 0x14, 0xa5, 0x55, 0x75, 0xad, 0x5d, 0xd7, 0xbd, 0x66, 0x18, 0xc6, 0x70, 0x79, 0xce, 0x76, 0xba, 0xd6, 0x79, 0x1c, 0xe7, 0x79, 0x5d, 0xef, 0x7d, 0x5d, 0xef, 0x82, 0x3c, 0xe7, 0x76, 0xfb, 0xde, 0x56, 0x59, 0xce, 0x40, 0xb6, 0xb5, 0x46, 0xef, 0x7b, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7, 0x39, 0x00, 0x55, 0xad, 0x3a, 0x18, 0xc6, 0x3e, 0x38, 0xc6, 0x29, 0x79, 0xce, 0x1f, 0x3c, 0xe7, 0x5f, 0x9e, 0xf7, 0x87, 0x7d, 0xef, 0x80, 0x3c, 0xe7, 0x7a, 0xdb, 0xde, 0x71, 0xf7, 0xbd, 0x61, 0x75, 0xad, 0x5c, 0x96, 0xb5, 0x5c, 0xd7, 0xbd, 0x5d, 0xf7, 0xbd, 0x5f, 0x59, 0xce, 0x60, 0x9a, 0xd6, 0x60, 0xdb, 0xde, 0x5f, 0x1c, 0xe7, 0x60, 0x5d, 0xef, 0x60, 0x5d, 0xef, 0x62, 0x3c, 0xe7, 0x61, 0xdb, 0xde, 0x5b, 0xba, 0xd6, 0x4d, 0xba, 0xd6, 0x38, 0x9a, 0xd6, 0x25, 0x59, 0xce, 0x1f, 0x38, 0xc6, 0x27, 0xf7, 0xbd, 0x33, 0xd7, 0xbd, 0x4a, 0xcf, 0x7b, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0x10, 0x00, 0x51, 0x8c, 0x34, 0xf7, 0xbd, 0x40, 0x59, 0xce, 0x2c, 0x38, 0xc6, 0x26, 0xfb, 0xde, 0x58, 0xdf, 0xff, 0x81, 0xbe, 0xf7, 0x71, 0xbe, 0xf7, 0x61, 0x9e, 0xf7, 0x4f, 0xdb, 0xde, 0x2d, 0x9a, 0xd6, 0x1e, 0x9a, 0xd6, 0x21, 0xba, 0xd6, 0x23, 0x9a, 0xd6, 0x24, 0x9a, 0xd6, 0x25, 0x9a, 0xd6, 0x25, 0x9a, 0xd6, 0x24, 0x79, 0xce, 0x22, 0x79, 0xce, 0x20, 0x79, 0xce, 0x1e, 0x79, 0xce, 0x1c, 0x79, 0xce, 0x1d, 0x79, 0xce, 0x1f, 0x79, 0xce, 0x22, 0x59, 0xce, 0x25, 0x59, 0xce, 0x27, 0x38, 0xc6, 0x2b, 0xf7, 0xbd, 0x36, 0xb6, 0xb5, 0x4a, 0xcf, 0x7b, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x7b, 0x29, 0xf7, 0xbd, 0x43, 0x38, 0xc6, 0x2d, 0x38, 0xc6, 0x26, 0xfb, 0xde, 0x50, 0xbe, 0xf7, 0x81, 0xbe, 0xf7, 0x73, 0x9e, 0xf7, 0x63, 0x7d, 0xef, 0x52, 0xdb, 0xde, 0x33, 0x79, 0xce, 0x24, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x59, 0xce, 0x26, 0x59, 0xce, 0x27, 0x38, 0xc6, 0x2c, 0xf7, 0xbd, 0x39, 0x75, 0xad, 0x45, 0xeb, 0x5a, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x7b, 0x1e, 0xf7, 0xbd, 0x47, 0x38, 0xc6, 0x2f, 0x38, 0xc6, 0x26, 0xdb, 0xde, 0x48, 0xbe, 0xf7, 0x7f, 0xbe, 0xf7, 0x73, 0x9e, 0xf7, 0x63, 0x7d, 0xef, 0x53, 0xdb, 0xde, 0x34, 0x79, 0xce, 0x24, 0x79, 0xce, 0x25, 0x7a, 0xce, 0x25, 0x7a, 0xce, 0x25, 0x7a, 0xce, 0x25, 0x7a, 0xce, 0x25, 0x7a, 0xce, 0x25, 0x7a, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x79, 0xce, 0x25, 0x59, 0xce, 0x26, 0x38, 0xc6, 0x2a, 0x18, 0xc6, 0x38, 0x75, 0xad, 0x3b, 0x65, 0x29, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x7b, 0x17, 0xd7, 0xbd, 0x4a, 0x38, 0xc6, 0x32, 0x59, 0xce, 0x25, 0xdb, 0xde, 0x40, 0xbe, 0xf7, 0x7b, 0xbe, 0xf7, 0x71, 0xbe, 0xf7, 0x60, 0x9e, 0xf7, 0x4d, 0xfc, 0xde, 0x2b, 0x9a, 0xce, 0x0e, 0x9a, 0xd6, 0x0b, 0x79, 0xce, 0x0a, 0x79, 0xd6, 0x0a, 0x79, 0xce, 0x0c, 0x79, 0xce, 0x0b, 0x7a, 0xd6, 0x0a, 0x99, 0xd6, 0x0a, 0x99, 0xce, 0x0d, 0x9a, 0xd6, 0x11, 0x9b, 0xd6, 0x17, 0xbb, 0xd6, 0x1c, 0xbb, 0xd6, 0x20, 0x7a, 0xce, 0x22, 0x99, 0xd6, 0x23, 0x79, 0xce, 0x23, 0x79, 0xce, 0x25, 0x79, 0xce, 0x32, 0x96, 0xb5, 0x30, 0x45, 0x29, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcb, 0x5a, 0x10, 0x96, 0xb5, 0x49, 0x38, 0xc6, 0x37, 0x59, 0xce, 0x14, 0xfc, 0xde, 0x2d, 0xbe, 0xf7, 0x77, 0x9d, 0xf7, 0x7d, 0x5c, 0xf7, 0x7d, 0x3b, 0xef, 0x82, 0x99, 0xde, 0x89, 0x37, 0xd6, 0x96, 0x15, 0xd6, 0xa4, 0x14, 0xd6, 0xad, 0xf4, 0xd5, 0xb2, 0xf3, 0xd5, 0xb4, 0xf3, 0xd5, 0xb4, 0xd3, 0xd5, 0xb1, 0xd3, 0xd5, 0xab, 0xf4, 0xd5, 0xa0, 0x37, 0xd6, 0x91, 0x38, 0xd6, 0x7b, 0x59, 0xd6, 0x61, 0x78, 0xd6, 0x47, 0x99, 0xd6, 0x2e, 0xdc, 0xd6, 0x13, 0xfc, 0xd6, 0x00, 0xdb, 0xd6, 0x14, 0xdb, 0xde, 0x2b, 0xb6, 0xb5, 0x27, 0x65, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x21, 0x06, 0x34, 0xa5, 0x42, 0x18, 0xc6, 0x43, 0x16, 0xce, 0x6d, 0xf4, 0xd5, 0x9d, 0xb7, 0xee, 0xd1, 0x96, 0xe6, 0xe8, 0x55, 0xe6, 0xee, 0x34, 0xe6, 0xf1, 0xd1, 0xdd, 0xf3, 0xb0, 0xdd, 0xf7, 0xb0, 0xdd, 0xfa, 0xb0, 0xdd, 0xfc, 0xb0, 0xdd, 0xfe, 0xb0, 0xdd, 0xfe, 0xb0, 0xdd, 0xfe, 0xb0, 0xdd, 0xfd, 0x90, 0xdd, 0xfc, 0x8f, 0xdd, 0xf9, 0x8f, 0xdd, 0xf5, 0x6f, 0xdd, 0xf1, 0x6e, 0xdd, 0xec, 0x6f, 0xd5, 0xe6, 0x91, 0xd5, 0xd0, 0xd3, 0xd5, 0xaa, 0x15, 0xd6, 0x82, 0x9b, 0xce, 0x45, 0x1c, 0xe7, 0x1a, 0x55, 0xad, 0x20, 0xe3, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x21, 0x00, 0x14, 0xa5, 0x58, 0xb3, 0xcd, 0xba, 0x6f, 0xd5, 0xea, 0x6f, 0xd5, 0xfd, 0x34, 0xe6, 0xff, 0x54, 0xe6, 0xff, 0x34, 0xe6, 0xff, 0x13, 0xe6, 0xff, 0xd2, 0xdd, 0xff, 0xb1, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0xd2, 0xdd, 0xff, 0xf2, 0xdd, 0xff, 0xf2, 0xdd, 0xff, 0xf2, 0xdd, 0xff, 0xf2, 0xdd, 0xff, 0xf2, 0xdd, 0xff, 0xf2, 0xdd, 0xff, 0xf2, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0x90, 0xdd, 0xff, 0x6f, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x4e, 0xd5, 0xfe, 0x4d, 0xd5, 0xf7, 0x4e, 0xd5, 0xd5, 0x57, 0xde, 0x89, 0x10, 0x84, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x19, 0x00, 0xb1, 0xa4, 0x84, 0x70, 0xd5, 0xf6, 0x4f, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x13, 0xe6, 0xff, 0x54, 0xe6, 0xff, 0x33, 0xe6, 0xff, 0x13, 0xde, 0xff, 0xb1, 0xdd, 0xff, 0x8f, 0xd5, 0xff, 0x90, 0xdd, 0xff, 0xb0, 0xdd, 0xff, 0xb0, 0xdd, 0xff, 0xb1, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0xb0, 0xdd, 0xff, 0x90, 0xdd, 0xff, 0x8f, 0xdd, 0xff, 0x8f, 0xd5, 0xff, 0x8f, 0xdd, 0xff, 0x8f, 0xdd, 0xff, 0xb1, 0xd5, 0xdb, 0x8c, 0x7b, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0x83, 0x71, 0x4f, 0xcd, 0xef, 0x2e, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x13, 0xde, 0xff, 0x54, 0xe6, 0xff, 0x13, 0xe6, 0xff, 0xf2, 0xdd, 0xff, 0xb0, 0xdd, 0xff, 0x6f, 0xd5, 0xff, 0x6f, 0xd5, 0xff, 0x6f, 0xd5, 0xff, 0x6f, 0xd5, 0xff, 0x6e, 0xd5, 0xff, 0x6f, 0xd5, 0xff, 0x6f, 0xd5, 0xff, 0x90, 0xdd, 0xff, 0xb0, 0xdd, 0xff, 0xb0, 0xdd, 0xff, 0xb0, 0xdd, 0xff, 0xb0, 0xdd, 0xff, 0x90, 0xdd, 0xff, 0x90, 0xdd, 0xff, 0x8f, 0xdd, 0xff, 0x6f, 0xd5, 0xff, 0x0d, 0xcd, 0xff, 0xcf, 0xbc, 0xda, 0x0b, 0x73, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x73, 0x4e, 0x2f, 0xcd, 0xe7, 0xed, 0xcc, 0xff, 0xed, 0xcc, 0xff, 0xb1, 0xdd, 0xff, 0x34, 0xe6, 0xff, 0xf2, 0xdd, 0xff, 0xd1, 0xdd, 0xff, 0x90, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x6e, 0xd5, 0xff, 0x6f, 0xd5, 0xff, 0x6f, 0xd5, 0xff, 0x4e, 0xd5, 0xff, 0x2e, 0xcd, 0xff, 0x0d, 0xcd, 0xff, 0xac, 0xc4, 0xff, 0x6b, 0xbc, 0xff, 0xe9, 0xab, 0xff, 0x88, 0x9b, 0xff, 0x50, 0xa4, 0xc5, 0x4f, 0x6b, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x7b, 0x31, 0x2f, 0xcd, 0xe1, 0x0d, 0xcd, 0xff, 0xec, 0xcc, 0xff, 0x70, 0xd5, 0xff, 0xd2, 0xdd, 0xff, 0x91, 0xd5, 0xff, 0x4f, 0xcd, 0xff, 0xed, 0xc4, 0xff, 0xab, 0xc4, 0xff, 0xac, 0xc4, 0xff, 0xcc, 0xc4, 0xff, 0xcc, 0xc4, 0xff, 0xcc, 0xc4, 0xff, 0xcc, 0xc4, 0xff, 0xcc, 0xc4, 0xff, 0xab, 0xc4, 0xff, 0x6b, 0xbc, 0xff, 0x2a, 0xb4, 0xff, 0xe9, 0xab, 0xff, 0xa8, 0xa3, 0xff, 0x88, 0x9b, 0xff, 0x68, 0x9b, 0xff, 0x47, 0x9b, 0xff, 0x47, 0x93, 0xff, 0x88, 0x9b, 0xff, 0xaa, 0x93, 0xac, 0x82, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x73, 0x18, 0x92, 0xcd, 0xd2, 0xed, 0xcc, 0xff, 0xec, 0xcc, 0xff, 0x6f, 0xd5, 0xff, 0xd2, 0xdd, 0xff, 0x91, 0xd5, 0xff, 0x2f, 0xcd, 0xff, 0xcc, 0xc4, 0xff, 0x6a, 0xbc, 0xff, 0x6a, 0xbc, 0xff, 0x6a, 0xbc, 0xff, 0x6a, 0xbc, 0xff, 0x6a, 0xbc, 0xff, 0x6a, 0xbc, 0xff, 0x6a, 0xbc, 0xff, 0x4a, 0xbc, 0xff, 0x09, 0xb4, 0xff, 0xc8, 0xa3, 0xff, 0x88, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x89, 0x9b, 0xfe, 0xcb, 0x93, 0x97, 0x81, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x43, 0x00, 0x31, 0xbd, 0xba, 0x0d, 0xcd, 0xff, 0xec, 0xcc, 0xff, 0x4f, 0xd5, 0xff, 0xd2, 0xdd, 0xff, 0x91, 0xd5, 0xff, 0x4f, 0xd5, 0xff, 0xed, 0xcc, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x6a, 0xc4, 0xff, 0x4a, 0xbc, 0xff, 0x09, 0xb4, 0xff, 0xc9, 0xab, 0xff, 0x88, 0x9b, 0xff, 0x68, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0xa9, 0x9b, 0xfb, 0xcd, 0x93, 0x88, 0x82, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xeb, 0xa3, 0xa2, 0x8b, 0xc4, 0xfe, 0xab, 0xcc, 0xff, 0x2e, 0xd5, 0xff, 0xf2, 0xdd, 0xff, 0xb1, 0xd5, 0xff, 0x4f, 0xd5, 0xff, 0xed, 0xcc, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8b, 0xc4, 0xff, 0x8a, 0xc4, 0xff, 0x6a, 0xbc, 0xff, 0x09, 0xb4, 0xff, 0xc9, 0xa3, 0xff, 0x88, 0x9b, 0xff, 0x68, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x68, 0x9b, 0xff, 0x48, 0x9b, 0xff, 0x27, 0x93, 0xff, 0x29, 0x83, 0xf0, 0x92, 0x6c, 0x72, 0xe4, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x10, 0x00, 0x6a, 0x8b, 0x91, 0xe5, 0x92, 0xfd, 0x46, 0x9b, 0xff, 0x4b, 0xb4, 0xff, 0x70, 0xd5, 0xff, 0x70, 0xd5, 0xff, 0x2f, 0xcd, 0xff, 0xed, 0xcc, 0xff, 0x8a, 0xc4, 0xff, 0x8a, 0xc4, 0xff, 0x8a, 0xc4, 0xff, 0x8a, 0xc4, 0xff, 0x6a, 0xbc, 0xff, 0x6a, 0xbc, 0xff, 0x4a, 0xbc, 0xff, 0x2a, 0xb4, 0xff, 0xe9, 0xab, 0xff, 0x88, 0xa3, 0xff, 0x68, 0x9b, 0xff, 0x47, 0x93, 0xff, 0x07, 0x93, 0xff, 0xe6, 0x8a, 0xff, 0x85, 0x7a, 0xff, 0xe4, 0x59, 0xff, 0xc6, 0x41, 0xe4, 0xcf, 0x23, 0x54, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x19, 0x00, 0xd1, 0x9c, 0x7f, 0x86, 0x82, 0xf7, 0xc0, 0x71, 0xff, 0x85, 0x82, 0xff, 0x0c, 0xac, 0xff, 0x0b, 0xac, 0xff, 0xea, 0xab, 0xff, 0xa8, 0xa3, 0xff, 0x46, 0x9b, 0xff, 0x67, 0x9b, 0xff, 0x67, 0xa3, 0xff, 0x67, 0xa3, 0xff, 0x67, 0x9b, 0xff, 0x47, 0x9b, 0xff, 0x27, 0x9b, 0xff, 0x06, 0x93, 0xff, 0xc5, 0x8a, 0xff, 0x85, 0x82, 0xff, 0x44, 0x72, 0xff, 0x04, 0x6a, 0xff, 0xa3, 0x59, 0xff, 0x42, 0x51, 0xff, 0xe1, 0x40, 0xff, 0x60, 0x28, 0xff, 0x65, 0x39, 0xda, 0x81, 0x28, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x09, 0x00, 0xd6, 0x7d, 0x65, 0xe8, 0x8a, 0xeb, 0xc1, 0x71, 0xff, 0x24, 0x7a, 0xff, 0xcb, 0xa3, 0xff, 0x8a, 0x9b, 0xff, 0x28, 0x93, 0xff, 0x85, 0x82, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xe1, 0x71, 0xff, 0xe1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xa1, 0x69, 0xff, 0x81, 0x61, 0xff, 0x61, 0x59, 0xff, 0x21, 0x51, 0xff, 0x01, 0x49, 0xff, 0xe1, 0x40, 0xff, 0xa0, 0x38, 0xff, 0x80, 0x30, 0xff, 0x40, 0x28, 0xff, 0xe7, 0x49, 0xd2, 0x65, 0x31, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0x4a, 0x43, 0xc7, 0x8a, 0xdf, 0xc1, 0x71, 0xff, 0x23, 0x7a, 0xff, 0xaa, 0x9b, 0xff, 0xaa, 0x9b, 0xff, 0x28, 0x93, 0xff, 0xa5, 0x8a, 0xff, 0xe1, 0x79, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xa1, 0x71, 0xff, 0xa1, 0x69, 0xff, 0x81, 0x69, 0xff, 0x61, 0x61, 0xff, 0x41, 0x59, 0xff, 0x01, 0x49, 0xff, 0xe1, 0x40, 0xff, 0xc0, 0x40, 0xff, 0xa0, 0x38, 0xff, 0x60, 0x30, 0xff, 0x00, 0x20, 0xff, 0x0f, 0x63, 0xbe, 0x8d, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x52, 0x1e, 0x08, 0x8b, 0xd7, 0xc1, 0x71, 0xff, 0x02, 0x7a, 0xff, 0x8a, 0x9b, 0xff, 0xaa, 0xa3, 0xff, 0x28, 0x93, 0xff, 0xa5, 0x8a, 0xff, 0xe2, 0x79, 0xff, 0xc1, 0x79, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xa1, 0x69, 0xff, 0x81, 0x69, 0xff, 0x61, 0x61, 0xff, 0x41, 0x59, 0xff, 0x21, 0x51, 0xff, 0xe1, 0x48, 0xff, 0xc0, 0x40, 0xff, 0xa0, 0x38, 0xff, 0x80, 0x30, 0xff, 0x60, 0x28, 0xff, 0x60, 0x28, 0xfc, 0x2c, 0x4a, 0xa4, 0xaa, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x6b, 0x00, 0x0d, 0x9c, 0xca, 0x80, 0x69, 0xff, 0xc2, 0x71, 0xff, 0x49, 0x93, 0xff, 0x8a, 0x9b, 0xff, 0x27, 0x93, 0xff, 0xa5, 0x8a, 0xff, 0xe2, 0x79, 0xff, 0xc1, 0x71, 0xff, 0xc1, 0x71, 0xff, 0xa1, 0x69, 0xff, 0x81, 0x69, 0xff, 0x61, 0x61, 0xff, 0x61, 0x59, 0xff, 0x21, 0x59, 0xff, 0x01, 0x51, 0xff, 0xe1, 0x48, 0xff, 0xc0, 0x40, 0xff, 0xa0, 0x38, 0xff, 0x80, 0x30, 0xff, 0x60, 0x28, 0xff, 0x40, 0x20, 0xff, 0xc2, 0x28, 0xfb, 0x44, 0x31, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x5c, 0x00, 0xd2, 0x8c, 0xb2, 0x20, 0x61, 0xfe, 0x61, 0x61, 0xff, 0x08, 0x8b, 0xff, 0x6a, 0x93, 0xff, 0xe7, 0x8a, 0xff, 0x85, 0x82, 0xff, 0xc2, 0x71, 0xff, 0xa1, 0x69, 0xff, 0x81, 0x69, 0xff, 0x61, 0x61, 0xff, 0x41, 0x59, 0xff, 0x21, 0x51, 0xff, 0x01, 0x49, 0xff, 0xe1, 0x40, 0xff, 0xc0, 0x40, 0xff, 0xa0, 0x38, 0xff, 0x80, 0x30, 0xff, 0x60, 0x28, 0xff, 0x60, 0x28, 0xff, 0x60, 0x20, 0xff, 0x40, 0x20, 0xff, 0xc2, 0x28, 0xf8, 0x85, 0x39, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x00, 0xa8, 0x62, 0x96, 0x83, 0x59, 0xfb, 0x20, 0x51, 0xff, 0xa8, 0x7a, 0xff, 0x4a, 0x8b, 0xff, 0xc7, 0x82, 0xff, 0x45, 0x72, 0xff, 0x82, 0x61, 0xff, 0x61, 0x61, 0xff, 0x41, 0x59, 0xff, 0x21, 0x51, 0xff, 0x01, 0x49, 0xff, 0xe1, 0x40, 0xff, 0xa1, 0x38, 0xff, 0xa0, 0x30, 0xff, 0x80, 0x30, 0xff, 0x60, 0x28, 0xff, 0x60, 0x20, 0xff, 0x40, 0x20, 0xff, 0x40, 0x20, 0xff, 0x40, 0x20, 0xff, 0x20, 0x18, 0xff, 0xc7, 0x41, 0xee, 0x30, 0x84, 0x65, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x6a, 0x81, 0xa4, 0x49, 0xfa, 0xc0, 0x38, 0xff, 0x47, 0x62, 0xff, 0x0a, 0x7b, 0xff, 0x87, 0x72, 0xff, 0x05, 0x6a, 0xff, 0x42, 0x51, 0xff, 0x21, 0x51, 0xff, 0x01, 0x49, 0xff, 0xe1, 0x40, 0xff, 0xa1, 0x38, 0xff, 0x81, 0x30, 0xff, 0x60, 0x28, 0xff, 0x60, 0x28, 0xff, 0x40, 0x20, 0xff, 0x40, 0x18, 0xff, 0x40, 0x18, 0xff, 0x40, 0x18, 0xff, 0x40, 0x18, 0xff, 0x40, 0x18, 0xff, 0x20, 0x18, 0xff, 0x86, 0x39, 0xde, 0x4d, 0x6b, 0x4a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0xac, 0x83, 0x70, 0xe6, 0x49, 0xf4, 0x40, 0x20, 0xff, 0xe6, 0x49, 0xff, 0xc9, 0x6a, 0xff, 0x47, 0x62, 0xff, 0xc5, 0x51, 0xff, 0x02, 0x41, 0xff, 0xc1, 0x38, 0xff, 0xc1, 0x38, 0xff, 0xa1, 0x30, 0xff, 0x80, 0x28, 0xff, 0x60, 0x20, 0xff, 0x40, 0x18, 0xff, 0x40, 0x18, 0xff, 0x40, 0x18, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x03, 0x29, 0xd0, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x08, 0x00, 0xf3, 0xa4, 0x59, 0x69, 0x52, 0xe6, 0x00, 0x00, 0xff, 0x85, 0x39, 0xff, 0x89, 0x5a, 0xff, 0x07, 0x4a, 0xff, 0x85, 0x41, 0xff, 0xc1, 0x28, 0xff, 0x80, 0x20, 0xff, 0x80, 0x20, 0xff, 0x60, 0x20, 0xff, 0x40, 0x18, 0xff, 0x40, 0x18, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x20, 0x10, 0xff, 0x45, 0x29, 0xc6, 0xa2, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x39, 0x39, 0xa6, 0x39, 0xd6, 0x00, 0x00, 0xff, 0x45, 0x29, 0xff, 0x49, 0x4a, 0xff, 0xe7, 0x41, 0xff, 0x45, 0x31, 0xff, 0x81, 0x18, 0xff, 0x40, 0x10, 0xff, 0x40, 0x10, 0xff, 0x40, 0x10, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x00, 0x08, 0xfe, 0x8a, 0x52, 0xb6, 0xa6, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x29, 0x0c, 0xe6, 0x41, 0xcb, 0x00, 0x00, 0xff, 0x04, 0x21, 0xff, 0x28, 0x4a, 0xff, 0xc7, 0x39, 0xff, 0x24, 0x29, 0xff, 0x61, 0x10, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x00, 0x00, 0xfa, 0x71, 0x8c, 0x9a, 0x0c, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x52, 0x00, 0x30, 0x8c, 0xc7, 0x20, 0x08, 0xff, 0x61, 0x10, 0xff, 0x28, 0x42, 0xff, 0xc7, 0x39, 0xff, 0x24, 0x29, 0xff, 0x61, 0x10, 0xff, 0x00, 0x00, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x00, 0x08, 0xff, 0x00, 0x00, 0xff, 0x86, 0x31, 0xf7, 0xcb, 0x5a, 0x82, 0xa2, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x41, 0x08, 0x03, 0x00, 0x00, 0x04, 0x0c, 0x63, 0x00, 0xf7, 0xbd, 0xb7, 0x30, 0x84, 0xf6, 0x69, 0x4a, 0xff, 0x28, 0x4a, 0xff, 0xa6, 0x31, 0xff, 0x04, 0x21, 0xff, 0x41, 0x08, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x08, 0xff, 0x20, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x08, 0x42, 0xfe, 0x10, 0x84, 0xe8, 0x51, 0x8c, 0x6e, 0x00, 0x00, 0x00, 0x20, 0x00, 0x05, 0x41, 0x08, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x20, 0x00, 0x05, 0x82, 0x10, 0x07, 0x61, 0x08, 0x09, 0xa2, 0x10, 0x0c, 0x41, 0x08, 0x0e, 0x28, 0x42, 0x10, 0xb2, 0x94, 0x6e, 0xb2, 0x94, 0x97, 0xf3, 0x9c, 0xc5, 0x34, 0xa5, 0xee, 0x30, 0x8c, 0xfe, 0xcb, 0x5a, 0xff, 0xa6, 0x31, 0xff, 0x04, 0x21, 0xff, 0xa2, 0x18, 0xff, 0x61, 0x10, 0xff, 0x61, 0x08, 0xff, 0x61, 0x08, 0xff, 0x61, 0x08, 0xff, 0xa2, 0x10, 0xff, 0xe3, 0x18, 0xff, 0x65, 0x29, 0xff, 0x69, 0x4a, 0xff, 0xcf, 0x7b, 0xfe, 0xf3, 0x9c, 0xee, 0x34, 0xa5, 0xca, 0x14, 0xa5, 0x9c, 0x30, 0x84, 0x49, 0x00, 0x00, 0x09, 0x82, 0x10, 0x0f, 0xa2, 0x10, 0x0c, 0x61, 0x08, 0x09, 0x82, 0x10, 0x07, 0x20, 0x00, 0x05, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x20, 0x00, 0x04, 0x41, 0x08, 0x06, 0x82, 0x10, 0x09, 0x82, 0x10, 0x0c, 0x82, 0x10, 0x10, 0x82, 0x10, 0x14, 0x61, 0x08, 0x18, 0x41, 0x08, 0x1c, 0x65, 0x29, 0x21, 0xef, 0x7b, 0x6b, 0x4d, 0x6b, 0x68, 0x6d, 0x6b, 0x61, 0x34, 0xa5, 0xa5, 0xb6, 0xb5, 0xdb, 0xb6, 0xb5, 0xf7, 0x75, 0xad, 0xfc, 0xf3, 0x9c, 0xfa, 0x92, 0x94, 0xf7, 0x71, 0x8c, 0xf5, 0x51, 0x8c, 0xf3, 0x51, 0x8c, 0xf4, 0x92, 0x94, 0xf8, 0xd3, 0x9c, 0xfe, 0x55, 0xad, 0xff, 0xd7, 0xbd, 0xf6, 0xf7, 0xbd, 0xe0, 0xb6, 0xb5, 0xb7, 0xd3, 0x9c, 0x86, 0x30, 0x84, 0x65, 0xd3, 0x9c, 0x8c, 0xae, 0x73, 0x5a, 0x00, 0x00, 0x1b, 0x61, 0x08, 0x1d, 0x61, 0x08, 0x18, 0x82, 0x10, 0x14, 0x82, 0x10, 0x10, 0x82, 0x10, 0x0c, 0x82, 0x10, 0x09, 0x41, 0x08, 0x06, 0x20, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x61, 0x08, 0x06, 0xa2, 0x10, 0x09, 0xa2, 0x10, 0x0d, 0x82, 0x10, 0x11, 0x61, 0x08, 0x15, 0x61, 0x08, 0x1a, 0x82, 0x10, 0x20, 0x61, 0x08, 0x26, 0x41, 0x08, 0x2c, 0xa2, 0x10, 0x2d, 0x8e, 0x73, 0x8e, 0x30, 0x84, 0xb8, 0x10, 0x84, 0x9a, 0xf3, 0x9c, 0xa6, 0x34, 0xa5, 0xb8, 0xd3, 0x9c, 0xc8, 0x30, 0x84, 0xce, 0xef, 0x7b, 0xc7, 0xef, 0x7b, 0xbb, 0x10, 0x84, 0xad, 0xef, 0x7b, 0xa2, 0x10, 0x84, 0xa6, 0x51, 0x8c, 0xbe, 0xd3, 0x9c, 0xd6, 0x14, 0xa5, 0xd8, 0xf3, 0x9c, 0xc0, 0x51, 0x8c, 0x9a, 0x6d, 0x6b, 0x7a, 0x6d, 0x6b, 0x78, 0x51, 0x8c, 0xa0, 0xb2, 0x94, 0xc9, 0x8a, 0x52, 0x67, 0x00, 0x00, 0x2d, 0x61, 0x08, 0x2c, 0x61, 0x08, 0x25, 0x82, 0x10, 0x20, 0x61, 0x08, 0x1a, 0x61, 0x08, 0x15, 0x82, 0x10, 0x10, 0xa2, 0x10, 0x0d, 0xa2, 0x10, 0x09, 0x61, 0x08, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x41, 0x08, 0x06, 0xc3, 0x18, 0x0a, 0xa2, 0x10, 0x0e, 0x61, 0x08, 0x12, 0x61, 0x08, 0x18, 0x82, 0x10, 0x1e, 0x61, 0x08, 0x24, 0x61, 0x08, 0x2b, 0x41, 0x08, 0x32, 0x61, 0x08, 0x3a, 0x20, 0x00, 0x41, 0x86, 0x31, 0x64, 0x6d, 0x6b, 0xbc, 0x92, 0x94, 0xdf, 0xd7, 0xbd, 0xe2, 0x38, 0xc6, 0xe8, 0xf7, 0xbd, 0xe6, 0x14, 0xa5, 0xd6, 0xcf, 0x7b, 0xc4, 0x8a, 0x52, 0xb7, 0x65, 0x29, 0xac, 0xa2, 0x10, 0xa5, 0xc3, 0x18, 0xa6, 0x08, 0x42, 0xb2, 0x4d, 0x6b, 0xc1, 0x92, 0x94, 0xcf, 0x14, 0xa5, 0xd7, 0x14, 0xa5, 0xd1, 0xd3, 0x9c, 0xc4, 0xd3, 0x9c, 0xcd, 0x92, 0x94, 0xd9, 0x0c, 0x63, 0xa5, 0xa2, 0x10, 0x50, 0x41, 0x08, 0x42, 0x61, 0x08, 0x3a, 0x41, 0x08, 0x32, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x24, 0x82, 0x10, 0x1e, 0x61, 0x08, 0x18, 0x61, 0x08, 0x12, 0xa2, 0x10, 0x0e, 0xc3, 0x18, 0x0a, 0x41, 0x08, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x20, 0x00, 0x05, 0xc3, 0x18, 0x09, 0xa2, 0x10, 0x0d, 0x61, 0x08, 0x11, 0x61, 0x08, 0x17, 0x82, 0x10, 0x1d, 0x61, 0x08, 0x24, 0x61, 0x08, 0x2b, 0x41, 0x08, 0x33, 0x61, 0x08, 0x3c, 0x41, 0x08, 0x45, 0x41, 0x08, 0x4f, 0x00, 0x00, 0x57, 0xc3, 0x18, 0x6c, 0xaa, 0x52, 0xac, 0x55, 0xad, 0xe3, 0xfb, 0xde, 0xfa, 0x3c, 0xe7, 0xff, 0xdb, 0xde, 0xfc, 0x18, 0xc6, 0xf3, 0x34, 0xa5, 0xea, 0x51, 0x8c, 0xe2, 0xae, 0x73, 0xde, 0xcf, 0x7b, 0xdf, 0x92, 0x94, 0xe6, 0x96, 0xb5, 0xf0, 0x59, 0xce, 0xfa, 0xba, 0xd6, 0xfe, 0x9a, 0xd6, 0xf9, 0xb6, 0xb5, 0xf1, 0x51, 0x8c, 0xd8, 0x49, 0x4a, 0x9f, 0x20, 0x00, 0x65, 0x20, 0x00, 0x58, 0x41, 0x08, 0x4f, 0x41, 0x08, 0x45, 0x61, 0x08, 0x3c, 0x41, 0x08, 0x33, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x24, 0x82, 0x10, 0x1d, 0x61, 0x08, 0x17, 0x61, 0x08, 0x11, 0xa2, 0x10, 0x0d, 0xc3, 0x18, 0x09, 0x20, 0x00, 0x05, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 
  0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0x61, 0x08, 0x06, 0xc3, 0x18, 0x0a, 0x82, 0x10, 0x0e, 0x61, 0x08, 0x13, 0x61, 0x08, 0x18, 0x82, 0x10, 0x1f, 0x61, 0x08, 0x26, 0x41, 0x08, 0x2e, 0x61, 0x08, 0x36, 0x61, 0x08, 0x3f, 0x41, 0x08, 0x49, 0x41, 0x08, 0x53, 0x41, 0x08, 0x5f, 0x20, 0x00, 0x69, 0x00, 0x00, 0x74, 0xc7, 0x39, 0x91, 0x8e, 0x73, 0xb9, 0xf3, 0x9c, 0xd7, 0xb6, 0xb5, 0xe9, 0x18, 0xc6, 0xf1, 0x38, 0xc6, 0xf5, 0x18, 0xc6, 0xf6, 0xf7, 0xbd, 0xf7, 0xf7, 0xbd, 0xf8, 0x18, 0xc6, 0xf7, 0x38, 0xc6, 0xf5, 0x18, 0xc6, 0xf2, 0x96, 0xb5, 0xe8, 0x71, 0x8c, 0xd3, 0xcb, 0x5a, 0xb3, 0x24, 0x21, 0x8c, 0x00, 0x00, 0x74, 0x20, 0x00, 0x6a, 0x41, 0x08, 0x5f, 0x41, 0x08, 0x53, 0x41, 0x08, 0x49, 0x61, 0x08, 0x3f, 0x61, 0x08, 0x36, 0x41, 0x08, 0x2e, 0x61, 0x08, 0x26, 0x82, 0x10, 0x1f, 0x61, 0x08, 0x18, 0x61, 0x08, 0x13, 0x82, 0x10, 0x0e, 0xc3, 0x18, 0x0a, 0x61, 0x08, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 
  0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x20, 0x00, 0x06, 0xc3, 0x18, 0x09, 0xa2, 0x10, 0x0d, 0x61, 0x08, 0x12, 0x61, 0x08, 0x17, 0x82, 0x10, 0x1d, 0x61, 0x08, 0x24, 0x61, 0x08, 0x2b, 0x41, 0x08, 0x33, 0x61, 0x08, 0x3c, 0x41, 0x08, 0x45, 0x41, 0x08, 0x4f, 0x41, 0x08, 0x5a, 0x41, 0x08, 0x64, 0x20, 0x00, 0x70, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x85, 0x00, 0x00, 0x93, 0x61, 0x08, 0xa4, 0x24, 0x21, 0xb4, 0xa6, 0x31, 0xc0, 0xe7, 0x39, 0xc9, 0x08, 0x42, 0xce, 0x08, 0x42, 0xce, 0xe7, 0x39, 0xc9, 0x86, 0x31, 0xc0, 0x04, 0x21, 0xb3, 0x41, 0x08, 0xa3, 0x00, 0x00, 0x93, 0x00, 0x00, 0x85, 0x00, 0x00, 0x7b, 0x20, 0x00, 0x70, 0x41, 0x08, 0x64, 0x41, 0x08, 0x59, 0x41, 0x08, 0x4f, 0x41, 0x08, 0x45, 0x61, 0x08, 0x3c, 0x41, 0x08, 0x33, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x24, 0x82, 0x10, 0x1d, 0x61, 0x08, 0x17, 0x61, 0x08, 0x12, 0xa2, 0x10, 0x0d, 0xa2, 0x10, 0x09, 0x20, 0x00, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x04, 0xa2, 0x10, 0x06, 0xc3, 0x18, 0x0a, 0xa2, 0x10, 0x0e, 0x61, 0x08, 0x13, 0x61, 0x08, 0x18, 0x82, 0x10, 0x1e, 0x61, 0x08, 0x24, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x32, 0x61, 0x08, 0x3a, 0x61, 0x08, 0x43, 0x41, 0x08, 0x4c, 0x41, 0x08, 0x54, 0x41, 0x08, 0x5d, 0x41, 0x08, 0x67, 0x20, 0x00, 0x70, 0x20, 0x00, 0x79, 0x20, 0x00, 0x80, 0x00, 0x00, 0x87, 0x00, 0x00, 0x8d, 0x00, 0x00, 0x92, 0x00, 0x00, 0x95, 0x00, 0x00, 0x95, 0x00, 0x00, 0x92, 0x00, 0x00, 0x8d, 0x00, 0x00, 0x87, 0x20, 0x00, 0x80, 0x20, 0x00, 0x79, 0x20, 0x00, 0x70, 0x41, 0x08, 0x67, 0x41, 0x08, 0x5d, 0x41, 0x08, 0x54, 0x41, 0x08, 0x4c, 0x61, 0x08, 0x43, 0x61, 0x08, 0x3a, 0x61, 0x08, 0x33, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x24, 0x82, 0x10, 0x1e, 0x61, 0x08, 0x18, 0x61, 0x08, 0x13, 0xa2, 0x10, 0x0e, 0xa2, 0x10, 0x0a, 0x20, 0x00, 0x06, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x41, 0x08, 0x06, 0x82, 0x10, 0x09, 0xa2, 0x10, 0x0d, 0x82, 0x10, 0x11, 0x61, 0x08, 0x16, 0x61, 0x08, 0x1b, 0x61, 0x08, 0x20, 0x61, 0x08, 0x26, 0x61, 0x08, 0x2c, 0x61, 0x08, 0x32, 0x61, 0x08, 0x39, 0x61, 0x08, 0x40, 0x41, 0x08, 0x47, 0x41, 0x08, 0x4d, 0x41, 0x08, 0x54, 0x41, 0x08, 0x5a, 0x41, 0x08, 0x5f, 0x41, 0x08, 0x63, 0x41, 0x08, 0x67, 0x20, 0x00, 0x6a, 0x20, 0x00, 0x6b, 0x20, 0x00, 0x6b, 0x20, 0x00, 0x6a, 0x41, 0x08, 0x67, 0x41, 0x08, 0x63, 0x41, 0x08, 0x5f, 0x41, 0x08, 0x5a, 0x41, 0x08, 0x54, 0x41, 0x08, 0x4d, 0x41, 0x08, 0x47, 0x61, 0x08, 0x40, 0x61, 0x08, 0x39, 0x61, 0x08, 0x32, 0x61, 0x08, 0x2c, 0x61, 0x08, 0x26, 0x61, 0x08, 0x20, 0x61, 0x08, 0x1b, 0x61, 0x08, 0x16, 0x82, 0x10, 0x11, 0xa2, 0x10, 0x0d, 0x82, 0x10, 0x09, 0x41, 0x08, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x61, 0x08, 0x06, 0xa2, 0x10, 0x09, 0xa2, 0x10, 0x0c, 0x82, 0x10, 0x10, 0x61, 0x08, 0x14, 0x61, 0x08, 0x18, 0x61, 0x08, 0x1d, 0x61, 0x08, 0x21, 0x61, 0x08, 0x26, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x2f, 0x61, 0x08, 0x34, 0x61, 0x08, 0x38, 0x61, 0x08, 0x3c, 0x41, 0x08, 0x3f, 0x41, 0x08, 0x43, 0x41, 0x08, 0x45, 0x41, 0x08, 0x46, 0x41, 0x08, 0x47, 0x41, 0x08, 0x47, 0x41, 0x08, 0x46, 0x41, 0x08, 0x45, 0x41, 0x08, 0x43, 0x41, 0x08, 0x3f, 0x61, 0x08, 0x3c, 0x61, 0x08, 0x38, 0x61, 0x08, 0x34, 0x61, 0x08, 0x2f, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x26, 0x61, 0x08, 0x21, 0x61, 0x08, 0x1d, 0x61, 0x08, 0x18, 0x61, 0x08, 0x14, 0x82, 0x10, 0x10, 0xa2, 0x10, 0x0c, 0xa2, 0x10, 0x09, 0x61, 0x08, 0x06, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x41, 0x08, 0x05, 0x61, 0x08, 0x07, 0x82, 0x10, 0x0a, 0xa2, 0x10, 0x0c, 0x82, 0x10, 0x0f, 0x82, 0x10, 0x12, 0x82, 0x10, 0x16, 0x61, 0x08, 0x19, 0x61, 0x08, 0x1c, 0x82, 0x10, 0x1f, 0x61, 0x08, 0x21, 0x61, 0x08, 0x24, 0x61, 0x08, 0x26, 0x61, 0x08, 0x28, 0x61, 0x08, 0x29, 0x61, 0x08, 0x2a, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x2b, 0x61, 0x08, 0x2a, 0x61, 0x08, 0x29, 0x61, 0x08, 0x28, 0x61, 0x08, 0x26, 0x61, 0x08, 0x24, 0x61, 0x08, 0x21, 0x82, 0x10, 0x1f, 0x61, 0x08, 0x1c, 0x61, 0x08, 0x19, 0x82, 0x10, 0x15, 0x82, 0x10, 0x12, 0x82, 0x10, 0x0f, 0xa2, 0x10, 0x0c, 0x82, 0x10, 0x0a, 0x61, 0x08, 0x07, 0x41, 0x08, 0x05, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x20, 0x00, 0x03, 0x00, 0x00, 0x05, 0x82, 0x10, 0x06, 0x82, 0x10, 0x08, 0x82, 0x10, 0x0a, 0x61, 0x08, 0x0c, 0xa2, 0x10, 0x0e, 0xa2, 0x10, 0x0f, 0xa2, 0x10, 0x11, 0x82, 0x10, 0x12, 0x82, 0x10, 0x13, 0x82, 0x10, 0x14, 0x82, 0x10, 0x14, 0x82, 0x10, 0x15, 0x82, 0x10, 0x15, 0x82, 0x10, 0x14, 0x82, 0x10, 0x14, 0x82, 0x10, 0x13, 0x82, 0x10, 0x12, 0xa2, 0x10, 0x11, 0xa2, 0x10, 0x0f, 0xa2, 0x10, 0x0e, 0x61, 0x08, 0x0c, 0x82, 0x10, 0x0a, 0x82, 0x10, 0x08, 0x82, 0x10, 0x07, 0x00, 0x00, 0x05, 0x20, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0x61, 0x08, 0x03, 0x82, 0x10, 0x04, 0x61, 0x08, 0x05, 0x61, 0x08, 0x05, 0x41, 0x08, 0x06, 0x41, 0x08, 0x06, 0x41, 0x08, 0x07, 0x41, 0x08, 0x07, 0x41, 0x08, 0x07, 0x41, 0x08, 0x07, 0x41, 0x08, 0x06, 0x41, 0x08, 0x06, 0x61, 0x08, 0x05, 0x61, 0x08, 0x05, 0x82, 0x10, 0x04, 0x61, 0x08, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
#endif
#if LV_COLOR_DEPTH == 16 && LV_COLOR_16_SWAP != 0
  /*Pixel format: Alpha 8 bit, Red: 5 bit, Green: 6 bit, Blue: 5 bit  BUT the 2  color bytes are swapped*/
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xe3, 0x00, 0x4a, 0x69, 0x16, 0x4a, 0x49, 0x3b, 0x42, 0x08, 0x59, 0x5a, 0xcb, 0x67, 0x6b, 0x6d, 0x6a, 0x7b, 0xef, 0x6a, 0x8c, 0x51, 0x6b, 0x94, 0xb2, 0x6f, 0xa5, 0x14, 0x73, 0xad, 0x75, 0x8b, 0xbd, 0xd7, 0xa1, 0xc6, 0x38, 0x9e, 0xd6, 0x9a, 0x81, 0xe7, 0x1c, 0x6f, 0xef, 0x7d, 0x6b, 0xf7, 0xbe, 0x67, 0xff, 0xdf, 0x66, 0xff, 0xff, 0x67, 0xef, 0x5d, 0x62, 0xa5, 0x14, 0x50, 0xa5, 0x14, 0x2f, 0x9c, 0xf3, 0x0a, 0x42, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x45, 0x00, 0x73, 0xae, 0x30, 0x9c, 0xd3, 0x51, 0x84, 0x30, 0x75, 0x8c, 0x51, 0x7f, 0x84, 0x30, 0x72, 0x84, 0x30, 0x6d, 0x8c, 0x51, 0x6e, 0x94, 0x92, 0x6a, 0x94, 0xb2, 0x63, 0x94, 0xb2, 0x59, 0x9c, 0xd3, 0x51, 0x9c, 0xd3, 0x4a, 0x9c, 0xd3, 0x43, 0x9c, 0xf3, 0x3e, 0x9c, 0xf3, 0x3e, 0x9c, 0xf3, 0x43, 0xa5, 0x14, 0x48, 0xa5, 0x34, 0x4e, 0xad, 0x55, 0x56, 0xad, 0x75, 0x60, 0xbd, 0xd7, 0x68, 0xce, 0x59, 0x6a, 0xde, 0xdb, 0x6b, 0xe7, 0x3c, 0x76, 0xef, 0x7d, 0x7f, 0xde, 0xdb, 0x67, 0xc6, 0x18, 0x43, 0x5a, 0xcb, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x65, 0x01, 0xb5, 0xb6, 0x60, 0xc6, 0x38, 0x83, 0xad, 0x55, 0x77, 0x9c, 0xd3, 0x52, 0x9c, 0xd3, 0x42, 0x9c, 0xf3, 0x33, 0x9c, 0xf3, 0x23, 0x9c, 0xd3, 0x18, 0x9c, 0xd3, 0x14, 0x9c, 0xd3, 0x14, 0x9c, 0xd3, 0x16, 0x9c, 0xd3, 0x18, 0x9c, 0xd3, 0x19, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x19, 0x94, 0xb2, 0x18, 0x94, 0xb2, 0x16, 0x94, 0x92, 0x15, 0x94, 0x92, 0x13, 0x94, 0xb2, 0x12, 0x94, 0xb2, 0x18, 0x94, 0x92, 0x26, 0x94, 0x92, 0x37, 0xa5, 0x14, 0x44, 0xc6, 0x18, 0x58, 0xde, 0xdb, 0x76, 0xe7, 0x1c, 0x6f, 0xa5, 0x14, 0x39, 0x39, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xad, 0x75, 0x45, 0xe7, 0x1c, 0x99, 0xa5, 0x14, 0x50, 0x94, 0xb2, 0x1b, 0x9c, 0xd3, 0x1a, 0x9c, 0xd3, 0x18, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x1a, 0x9c, 0xd3, 0x1a, 0x9c, 0xd3, 0x1a, 0x9c, 0xd3, 0x1a, 0x9c, 0xd3, 0x1a, 0x9c, 0xd3, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x18, 0x94, 0xb2, 0x17, 0x94, 0x92, 0x15, 0x8c, 0x71, 0x12, 0xb5, 0x96, 0x5f, 0xef, 0x7d, 0x6c, 0x5a, 0xeb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0x14, 0x35, 0xde, 0xdb, 0x8b, 0xad, 0x55, 0x6a, 0x94, 0xb2, 0x2c, 0x94, 0x92, 0x17, 0x94, 0xb2, 0x12, 0x9c, 0xd3, 0x13, 0x9c, 0xd3, 0x17, 0x9c, 0xd3, 0x18, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x9c, 0xd3, 0x19, 0x94, 0xb2, 0x1a, 0x94, 0xb2, 0x1a, 0x9c, 0xd3, 0x1b, 0x9c, 0xd3, 0x1c, 0x9c, 0xd3, 0x1d, 0x9c, 0xf3, 0x1d, 0x9c, 0xd3, 0x1e, 0x9c, 0xd3, 0x1d, 0x9c, 0xd3, 0x1d, 0x94, 0xb2, 0x20, 0x94, 0xb2, 0x24, 0xa5, 0x14, 0x3c, 0xce, 0x59, 0x79, 0xd6, 0x9a, 0x70, 0x4a, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xc7, 0x02, 0xb5, 0xb6, 0x58, 0xce, 0x59, 0x79, 0xb5, 0x96, 0x7e, 0x9c, 0xd3, 0x62, 0x8c, 0x51, 0x4e, 0x94, 0x92, 0x3f, 0x9c, 0xd3, 0x27, 0x94, 0xb2, 0x12, 0x94, 0xb2, 0x07, 0x94, 0xb2, 0x07, 0x94, 0xb2, 0x09, 0x94, 0xb2, 0x0b, 0x94, 0xb2, 0x0d, 0x94, 0x92, 0x0f, 0x94, 0x92, 0x0f, 0x8c, 0x71, 0x10, 0x8c, 0x51, 0x11, 0x8c, 0x71, 0x12, 0x94, 0x92, 0x14, 0x94, 0xb2, 0x1a, 0x9c, 0xd3, 0x22, 0x9c, 0xf3, 0x2d, 0xa5, 0x14, 0x3c, 0xa5, 0x14, 0x4b, 0xad, 0x75, 0x58, 0xc6, 0x18, 0x63, 0xd6, 0xba, 0x7a, 0xe7, 0x1c, 0x83, 0xde, 0xdb, 0x76, 0x9c, 0xf3, 0x46, 0x29, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xe7, 0x00, 0xad, 0x75, 0x39, 0xc6, 0x18, 0x3c, 0xc6, 0x38, 0x41, 0xbd, 0xf7, 0x5c, 0xbd, 0xf7, 0x8a, 0xad, 0x75, 0x93, 0x94, 0x92, 0x82, 0x84, 0x10, 0x7a, 0x7b, 0xef, 0x74, 0x8c, 0x51, 0x6a, 0x8c, 0x71, 0x63, 0x8c, 0x71, 0x5d, 0x94, 0x92, 0x57, 0x94, 0x92, 0x53, 0x9c, 0xd3, 0x51, 0x9c, 0xf3, 0x52, 0xa5, 0x14, 0x55, 0xad, 0x75, 0x5d, 0xbd, 0xd7, 0x66, 0xc6, 0x18, 0x70, 0xce, 0x79, 0x76, 0xd6, 0xba, 0x79, 0xe7, 0x1c, 0x79, 0xef, 0x5d, 0x7d, 0xef, 0x5d, 0x82, 0xe7, 0x3c, 0x76, 0xde, 0xfb, 0x56, 0xce, 0x59, 0x40, 0xb5, 0xb6, 0x46, 0x7b, 0xef, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xc7, 0x00, 0xad, 0x55, 0x3a, 0xc6, 0x18, 0x3e, 0xc6, 0x38, 0x29, 0xce, 0x79, 0x1f, 0xe7, 0x3c, 0x5f, 0xf7, 0x9e, 0x87, 0xef, 0x7d, 0x80, 0xe7, 0x3c, 0x7a, 0xde, 0xdb, 0x71, 0xbd, 0xf7, 0x61, 0xad, 0x75, 0x5c, 0xb5, 0x96, 0x5c, 0xbd, 0xd7, 0x5d, 0xbd, 0xf7, 0x5f, 0xce, 0x59, 0x60, 0xd6, 0x9a, 0x60, 0xde, 0xdb, 0x5f, 0xe7, 0x1c, 0x60, 0xef, 0x5d, 0x60, 0xef, 0x5d, 0x62, 0xe7, 0x3c, 0x61, 0xde, 0xdb, 0x5b, 0xd6, 0xba, 0x4d, 0xd6, 0xba, 0x38, 0xd6, 0x9a, 0x25, 0xce, 0x59, 0x1f, 0xc6, 0x38, 0x27, 0xbd, 0xf7, 0x33, 0xbd, 0xd7, 0x4a, 0x7b, 0xcf, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xa2, 0x00, 0x8c, 0x51, 0x34, 0xbd, 0xf7, 0x40, 0xce, 0x59, 0x2c, 0xc6, 0x38, 0x26, 0xde, 0xfb, 0x58, 0xff, 0xdf, 0x81, 0xf7, 0xbe, 0x71, 0xf7, 0xbe, 0x61, 0xf7, 0x9e, 0x4f, 0xde, 0xdb, 0x2d, 0xd6, 0x9a, 0x1e, 0xd6, 0x9a, 0x21, 0xd6, 0xba, 0x23, 0xd6, 0x9a, 0x24, 0xd6, 0x9a, 0x25, 0xd6, 0x9a, 0x25, 0xd6, 0x9a, 0x24, 0xce, 0x79, 0x22, 0xce, 0x79, 0x20, 0xce, 0x79, 0x1e, 0xce, 0x79, 0x1c, 0xce, 0x79, 0x1d, 0xce, 0x79, 0x1f, 0xce, 0x79, 0x22, 0xce, 0x59, 0x25, 0xce, 0x59, 0x27, 0xc6, 0x38, 0x2b, 0xbd, 0xf7, 0x36, 0xb5, 0xb6, 0x4a, 0x7b, 0xcf, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xcf, 0x29, 0xbd, 0xf7, 0x43, 0xc6, 0x38, 0x2d, 0xc6, 0x38, 0x26, 0xde, 0xfb, 0x50, 0xf7, 0xbe, 0x81, 0xf7, 0xbe, 0x73, 0xf7, 0x9e, 0x63, 0xef, 0x7d, 0x52, 0xde, 0xdb, 0x33, 0xce, 0x79, 0x24, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x59, 0x26, 0xce, 0x59, 0x27, 0xc6, 0x38, 0x2c, 0xbd, 0xf7, 0x39, 0xad, 0x75, 0x45, 0x5a, 0xeb, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xef, 0x1e, 0xbd, 0xf7, 0x47, 0xc6, 0x38, 0x2f, 0xc6, 0x38, 0x26, 0xde, 0xdb, 0x48, 0xf7, 0xbe, 0x7f, 0xf7, 0xbe, 0x73, 0xf7, 0x9e, 0x63, 0xef, 0x7d, 0x53, 0xde, 0xdb, 0x34, 0xce, 0x79, 0x24, 0xce, 0x79, 0x25, 0xce, 0x7a, 0x25, 0xce, 0x7a, 0x25, 0xce, 0x7a, 0x25, 0xce, 0x7a, 0x25, 0xce, 0x7a, 0x25, 0xce, 0x7a, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x79, 0x25, 0xce, 0x59, 0x26, 0xc6, 0x38, 0x2a, 0xc6, 0x18, 0x38, 0xad, 0x75, 0x3b, 0x29, 0x65, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xcf, 0x17, 0xbd, 0xd7, 0x4a, 0xc6, 0x38, 0x32, 0xce, 0x59, 0x25, 0xde, 0xdb, 0x40, 0xf7, 0xbe, 0x7b, 0xf7, 0xbe, 0x71, 0xf7, 0xbe, 0x60, 0xf7, 0x9e, 0x4d, 0xde, 0xfc, 0x2b, 0xce, 0x9a, 0x0e, 0xd6, 0x9a, 0x0b, 0xce, 0x79, 0x0a, 0xd6, 0x79, 0x0a, 0xce, 0x79, 0x0c, 0xce, 0x79, 0x0b, 0xd6, 0x7a, 0x0a, 0xd6, 0x99, 0x0a, 0xce, 0x99, 0x0d, 0xd6, 0x9a, 0x11, 0xd6, 0x9b, 0x17, 0xd6, 0xbb, 0x1c, 0xd6, 0xbb, 0x20, 0xce, 0x7a, 0x22, 0xd6, 0x99, 0x23, 0xce, 0x79, 0x23, 0xce, 0x79, 0x25, 0xce, 0x79, 0x32, 0xb5, 0x96, 0x30, 0x29, 0x45, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xcb, 0x10, 0xb5, 0x96, 0x49, 0xc6, 0x38, 0x37, 0xce, 0x59, 0x14, 0xde, 0xfc, 0x2d, 0xf7, 0xbe, 0x77, 0xf7, 0x9d, 0x7d, 0xf7, 0x5c, 0x7d, 0xef, 0x3b, 0x82, 0xde, 0x99, 0x89, 0xd6, 0x37, 0x96, 0xd6, 0x15, 0xa4, 0xd6, 0x14, 0xad, 0xd5, 0xf4, 0xb2, 0xd5, 0xf3, 0xb4, 0xd5, 0xf3, 0xb4, 0xd5, 0xd3, 0xb1, 0xd5, 0xd3, 0xab, 0xd5, 0xf4, 0xa0, 0xd6, 0x37, 0x91, 0xd6, 0x38, 0x7b, 0xd6, 0x59, 0x61, 0xd6, 0x78, 0x47, 0xd6, 0x99, 0x2e, 0xd6, 0xdc, 0x13, 0xd6, 0xfc, 0x00, 0xd6, 0xdb, 0x14, 0xde, 0xdb, 0x2b, 0xb5, 0xb6, 0x27, 0x29, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x24, 0x06, 0xa5, 0x34, 0x42, 0xc6, 0x18, 0x43, 0xce, 0x16, 0x6d, 0xd5, 0xf4, 0x9d, 0xee, 0xb7, 0xd1, 0xe6, 0x96, 0xe8, 0xe6, 0x55, 0xee, 0xe6, 0x34, 0xf1, 0xdd, 0xd1, 0xf3, 0xdd, 0xb0, 0xf7, 0xdd, 0xb0, 0xfa, 0xdd, 0xb0, 0xfc, 0xdd, 0xb0, 0xfe, 0xdd, 0xb0, 0xfe, 0xdd, 0xb0, 0xfe, 0xdd, 0xb0, 0xfd, 0xdd, 0x90, 0xfc, 0xdd, 0x8f, 0xf9, 0xdd, 0x8f, 0xf5, 0xdd, 0x6f, 0xf1, 0xdd, 0x6e, 0xec, 0xd5, 0x6f, 0xe6, 0xd5, 0x91, 0xd0, 0xd5, 0xd3, 0xaa, 0xd6, 0x15, 0x82, 0xce, 0x9b, 0x45, 0xe7, 0x1c, 0x1a, 0xad, 0x55, 0x20, 0x18, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x45, 0x00, 0xa5, 0x14, 0x58, 0xcd, 0xb3, 0xba, 0xd5, 0x6f, 0xea, 0xd5, 0x6f, 0xfd, 0xe6, 0x34, 0xff, 0xe6, 0x54, 0xff, 0xe6, 0x34, 0xff, 0xe6, 0x13, 0xff, 0xdd, 0xd2, 0xff, 0xdd, 0xb1, 0xff, 0xdd, 0xd1, 0xff, 0xdd, 0xd2, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xd1, 0xff, 0xdd, 0x90, 0xff, 0xd5, 0x6f, 0xff, 0xd5, 0x4e, 0xff, 0xd5, 0x4e, 0xfe, 0xd5, 0x4d, 0xf7, 0xd5, 0x4e, 0xd5, 0xde, 0x57, 0x89, 0x84, 0x10, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x04, 0x00, 0xa4, 0xb1, 0x84, 0xd5, 0x70, 0xf6, 0xd5, 0x4f, 0xff, 0xd5, 0x4e, 0xff, 0xe6, 0x13, 0xff, 0xe6, 0x54, 0xff, 0xe6, 0x33, 0xff, 0xde, 0x13, 0xff, 0xdd, 0xb1, 0xff, 0xd5, 0x8f, 0xff, 0xdd, 0x90, 0xff, 0xdd, 0xb0, 0xff, 0xdd, 0xb0, 0xff, 0xdd, 0xb1, 0xff, 0xdd, 0xd1, 0xff, 0xdd, 0xd1, 0xff, 0xdd, 0xd1, 0xff, 0xdd, 0xd1, 0xff, 0xdd, 0xd1, 0xff, 0xdd, 0xd1, 0xff, 0xdd, 0xb0, 0xff, 0xdd, 0x90, 0xff, 0xdd, 0x8f, 0xff, 0xd5, 0x8f, 0xff, 0xdd, 0x8f, 0xff, 0xdd, 0x8f, 0xff, 0xd5, 0xb1, 0xdb, 0x7b, 0x8c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xac, 0x71, 0xcd, 0x4f, 0xef, 0xd5, 0x2e, 0xff, 0xd5, 0x4e, 0xff, 0xde, 0x13, 0xff, 0xe6, 0x54, 0xff, 0xe6, 0x13, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xb0, 0xff, 0xd5, 0x6f, 0xff, 0xd5, 0x6f, 0xff, 0xd5, 0x6f, 0xff, 0xd5, 0x6f, 0xff, 0xd5, 0x6e, 0xff, 0xd5, 0x6f, 0xff, 0xd5, 0x6f, 0xff, 0xdd, 0x90, 0xff, 0xdd, 0xb0, 0xff, 0xdd, 0xb0, 0xff, 0xdd, 0xb0, 0xff, 0xdd, 0xb0, 0xff, 0xdd, 0x90, 0xff, 0xdd, 0x90, 0xff, 0xdd, 0x8f, 0xff, 0xd5, 0x6f, 0xff, 0xcd, 0x0d, 0xff, 0xbc, 0xcf, 0xda, 0x73, 0x0b, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x2a, 0x4e, 0xcd, 0x2f, 0xe7, 0xcc, 0xed, 0xff, 0xcc, 0xed, 0xff, 0xdd, 0xb1, 0xff, 0xe6, 0x34, 0xff, 0xdd, 0xf2, 0xff, 0xdd, 0xd1, 0xff, 0xd5, 0x90, 0xff, 0xd5, 0x4e, 0xff, 0xd5, 0x4e, 0xff, 0xd5, 0x4e, 0xff, 0xd5, 0x4e, 0xff, 0xd5, 0x4e, 0xff, 0xd5, 0x4e, 0xff, 0xd5, 0x4e, 0xff, 0xd5, 0x6e, 0xff, 0xd5, 0x6f, 0xff, 0xd5, 0x6f, 0xff, 0xd5, 0x4e, 0xff, 0xcd, 0x2e, 0xff, 0xcd, 0x0d, 0xff, 0xc4, 0xac, 0xff, 0xbc, 0x6b, 0xff, 0xab, 0xe9, 0xff, 0x9b, 0x88, 0xff, 0xa4, 0x50, 0xc5, 0x6b, 0x4f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0x4a, 0x31, 0xcd, 0x2f, 0xe1, 0xcd, 0x0d, 0xff, 0xcc, 0xec, 0xff, 0xd5, 0x70, 0xff, 0xdd, 0xd2, 0xff, 0xd5, 0x91, 0xff, 0xcd, 0x4f, 0xff, 0xc4, 0xed, 0xff, 0xc4, 0xab, 0xff, 0xc4, 0xac, 0xff, 0xc4, 0xcc, 0xff, 0xc4, 0xcc, 0xff, 0xc4, 0xcc, 0xff, 0xc4, 0xcc, 0xff, 0xc4, 0xcc, 0xff, 0xc4, 0xab, 0xff, 0xbc, 0x6b, 0xff, 0xb4, 0x2a, 0xff, 0xab, 0xe9, 0xff, 0xa3, 0xa8, 0xff, 0x9b, 0x88, 0xff, 0x9b, 0x68, 0xff, 0x9b, 0x47, 0xff, 0x93, 0x47, 0xff, 0x9b, 0x88, 0xff, 0x93, 0xaa, 0xac, 0x10, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0xef, 0x18, 0xcd, 0x92, 0xd2, 0xcc, 0xed, 0xff, 0xcc, 0xec, 0xff, 0xd5, 0x6f, 0xff, 0xdd, 0xd2, 0xff, 0xd5, 0x91, 0xff, 0xcd, 0x2f, 0xff, 0xc4, 0xcc, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x4a, 0xff, 0xb4, 0x09, 0xff, 0xa3, 0xc8, 0xff, 0x9b, 0x88, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x89, 0xfe, 0x93, 0xcb, 0x97, 0x10, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x4d, 0x00, 0xbd, 0x31, 0xba, 0xcd, 0x0d, 0xff, 0xcc, 0xec, 0xff, 0xd5, 0x4f, 0xff, 0xdd, 0xd2, 0xff, 0xd5, 0x91, 0xff, 0xd5, 0x4f, 0xff, 0xcc, 0xed, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x6a, 0xff, 0xbc, 0x4a, 0xff, 0xb4, 0x09, 0xff, 0xab, 0xc9, 0xff, 0x9b, 0x88, 0xff, 0x9b, 0x68, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0xa9, 0xfb, 0x93, 0xcd, 0x88, 0x10, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa3, 0xeb, 0xa2, 0xc4, 0x8b, 0xfe, 0xcc, 0xab, 0xff, 0xd5, 0x2e, 0xff, 0xdd, 0xf2, 0xff, 0xd5, 0xb1, 0xff, 0xd5, 0x4f, 0xff, 0xcc, 0xed, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8b, 0xff, 0xc4, 0x8a, 0xff, 0xbc, 0x6a, 0xff, 0xb4, 0x09, 0xff, 0xa3, 0xc9, 0xff, 0x9b, 0x88, 0xff, 0x9b, 0x68, 0xff, 0x9b, 0x48, 0xff, 0x9b, 0x68, 0xff, 0x9b, 0x48, 0xff, 0x93, 0x27, 0xff, 0x83, 0x29, 0xf0, 0x6c, 0x92, 0x72, 0x08, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x81, 0x00, 0x8b, 0x6a, 0x91, 0x92, 0xe5, 0xfd, 0x9b, 0x46, 0xff, 0xb4, 0x4b, 0xff, 0xd5, 0x70, 0xff, 0xd5, 0x70, 0xff, 0xcd, 0x2f, 0xff, 0xcc, 0xed, 0xff, 0xc4, 0x8a, 0xff, 0xc4, 0x8a, 0xff, 0xc4, 0x8a, 0xff, 0xc4, 0x8a, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x6a, 0xff, 0xbc, 0x4a, 0xff, 0xb4, 0x2a, 0xff, 0xab, 0xe9, 0xff, 0xa3, 0x88, 0xff, 0x9b, 0x68, 0xff, 0x93, 0x47, 0xff, 0x93, 0x07, 0xff, 0x8a, 0xe6, 0xff, 0x7a, 0x85, 0xff, 0x59, 0xe4, 0xff, 0x41, 0xc6, 0xe4, 0x23, 0xcf, 0x54, 0x00, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x04, 0x00, 0x9c, 0xd1, 0x7f, 0x82, 0x86, 0xf7, 0x71, 0xc0, 0xff, 0x82, 0x85, 0xff, 0xac, 0x0c, 0xff, 0xac, 0x0b, 0xff, 0xab, 0xea, 0xff, 0xa3, 0xa8, 0xff, 0x9b, 0x46, 0xff, 0x9b, 0x67, 0xff, 0xa3, 0x67, 0xff, 0xa3, 0x67, 0xff, 0x9b, 0x67, 0xff, 0x9b, 0x47, 0xff, 0x9b, 0x27, 0xff, 0x93, 0x06, 0xff, 0x8a, 0xc5, 0xff, 0x82, 0x85, 0xff, 0x72, 0x44, 0xff, 0x6a, 0x04, 0xff, 0x59, 0xa3, 0xff, 0x51, 0x42, 0xff, 0x40, 0xe1, 0xff, 0x28, 0x60, 0xff, 0x39, 0x65, 0xda, 0x28, 0x81, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x65, 0x00, 0x7d, 0xd6, 0x65, 0x8a, 0xe8, 0xeb, 0x71, 0xc1, 0xff, 0x7a, 0x24, 0xff, 0xa3, 0xcb, 0xff, 0x9b, 0x8a, 0xff, 0x93, 0x28, 0xff, 0x82, 0x85, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xe1, 0xff, 0x71, 0xe1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x69, 0xa1, 0xff, 0x61, 0x81, 0xff, 0x59, 0x61, 0xff, 0x51, 0x21, 0xff, 0x49, 0x01, 0xff, 0x40, 0xe1, 0xff, 0x38, 0xa0, 0xff, 0x30, 0x80, 0xff, 0x28, 0x40, 0xff, 0x49, 0xe7, 0xd2, 0x31, 0x65, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xa9, 0x43, 0x8a, 0xc7, 0xdf, 0x71, 0xc1, 0xff, 0x7a, 0x23, 0xff, 0x9b, 0xaa, 0xff, 0x9b, 0xaa, 0xff, 0x93, 0x28, 0xff, 0x8a, 0xa5, 0xff, 0x79, 0xe1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xa1, 0xff, 0x69, 0xa1, 0xff, 0x69, 0x81, 0xff, 0x61, 0x61, 0xff, 0x59, 0x41, 0xff, 0x49, 0x01, 0xff, 0x40, 0xe1, 0xff, 0x40, 0xc0, 0xff, 0x38, 0xa0, 0xff, 0x30, 0x60, 0xff, 0x20, 0x00, 0xff, 0x63, 0x0f, 0xbe, 0x52, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x06, 0x1e, 0x8b, 0x08, 0xd7, 0x71, 0xc1, 0xff, 0x7a, 0x02, 0xff, 0x9b, 0x8a, 0xff, 0xa3, 0xaa, 0xff, 0x93, 0x28, 0xff, 0x8a, 0xa5, 0xff, 0x79, 0xe2, 0xff, 0x79, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x69, 0xa1, 0xff, 0x69, 0x81, 0xff, 0x61, 0x61, 0xff, 0x59, 0x41, 0xff, 0x51, 0x21, 0xff, 0x48, 0xe1, 0xff, 0x40, 0xc0, 0xff, 0x38, 0xa0, 0xff, 0x30, 0x80, 0xff, 0x28, 0x60, 0xff, 0x28, 0x60, 0xfc, 0x4a, 0x2c, 0xa4, 0x31, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x2b, 0x00, 0x9c, 0x0d, 0xca, 0x69, 0x80, 0xff, 0x71, 0xc2, 0xff, 0x93, 0x49, 0xff, 0x9b, 0x8a, 0xff, 0x93, 0x27, 0xff, 0x8a, 0xa5, 0xff, 0x79, 0xe2, 0xff, 0x71, 0xc1, 0xff, 0x71, 0xc1, 0xff, 0x69, 0xa1, 0xff, 0x69, 0x81, 0xff, 0x61, 0x61, 0xff, 0x59, 0x61, 0xff, 0x59, 0x21, 0xff, 0x51, 0x01, 0xff, 0x48, 0xe1, 0xff, 0x40, 0xc0, 0xff, 0x38, 0xa0, 0xff, 0x30, 0x80, 0xff, 0x28, 0x60, 0xff, 0x20, 0x40, 0xff, 0x28, 0xc2, 0xfb, 0x31, 0x44, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x0f, 0x00, 0x8c, 0xd2, 0xb2, 0x61, 0x20, 0xfe, 0x61, 0x61, 0xff, 0x8b, 0x08, 0xff, 0x93, 0x6a, 0xff, 0x8a, 0xe7, 0xff, 0x82, 0x85, 0xff, 0x71, 0xc2, 0xff, 0x69, 0xa1, 0xff, 0x69, 0x81, 0xff, 0x61, 0x61, 0xff, 0x59, 0x41, 0xff, 0x51, 0x21, 0xff, 0x49, 0x01, 0xff, 0x40, 0xe1, 0xff, 0x40, 0xc0, 0xff, 0x38, 0xa0, 0xff, 0x30, 0x80, 0xff, 0x28, 0x60, 0xff, 0x28, 0x60, 0xff, 0x20, 0x60, 0xff, 0x20, 0x40, 0xff, 0x28, 0xc2, 0xf8, 0x39, 0x85, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x24, 0x00, 0x62, 0xa8, 0x96, 0x59, 0x83, 0xfb, 0x51, 0x20, 0xff, 0x7a, 0xa8, 0xff, 0x8b, 0x4a, 0xff, 0x82, 0xc7, 0xff, 0x72, 0x45, 0xff, 0x61, 0x82, 0xff, 0x61, 0x61, 0xff, 0x59, 0x41, 0xff, 0x51, 0x21, 0xff, 0x49, 0x01, 0xff, 0x40, 0xe1, 0xff, 0x38, 0xa1, 0xff, 0x30, 0xa0, 0xff, 0x30, 0x80, 0xff, 0x28, 0x60, 0xff, 0x20, 0x60, 0xff, 0x20, 0x40, 0xff, 0x20, 0x40, 0xff, 0x20, 0x40, 0xff, 0x18, 0x20, 0xff, 0x41, 0xc7, 0xee, 0x84, 0x30, 0x65, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xa8, 0x81, 0x49, 0xa4, 0xfa, 0x38, 0xc0, 0xff, 0x62, 0x47, 0xff, 0x7b, 0x0a, 0xff, 0x72, 0x87, 0xff, 0x6a, 0x05, 0xff, 0x51, 0x42, 0xff, 0x51, 0x21, 0xff, 0x49, 0x01, 0xff, 0x40, 0xe1, 0xff, 0x38, 0xa1, 0xff, 0x30, 0x81, 0xff, 0x28, 0x60, 0xff, 0x28, 0x60, 0xff, 0x20, 0x40, 0xff, 0x18, 0x40, 0xff, 0x18, 0x40, 0xff, 0x18, 0x40, 0xff, 0x18, 0x40, 0xff, 0x18, 0x40, 0xff, 0x18, 0x20, 0xff, 0x39, 0x86, 0xde, 0x6b, 0x4d, 0x4a, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x83, 0xac, 0x70, 0x49, 0xe6, 0xf4, 0x20, 0x40, 0xff, 0x49, 0xe6, 0xff, 0x6a, 0xc9, 0xff, 0x62, 0x47, 0xff, 0x51, 0xc5, 0xff, 0x41, 0x02, 0xff, 0x38, 0xc1, 0xff, 0x38, 0xc1, 0xff, 0x30, 0xa1, 0xff, 0x28, 0x80, 0xff, 0x20, 0x60, 0xff, 0x18, 0x40, 0xff, 0x18, 0x40, 0xff, 0x18, 0x40, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x29, 0x03, 0xd0, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x41, 0x00, 0xa4, 0xf3, 0x59, 0x52, 0x69, 0xe6, 0x00, 0x00, 0xff, 0x39, 0x85, 0xff, 0x5a, 0x89, 0xff, 0x4a, 0x07, 0xff, 0x41, 0x85, 0xff, 0x28, 0xc1, 0xff, 0x20, 0x80, 0xff, 0x20, 0x80, 0xff, 0x20, 0x60, 0xff, 0x18, 0x40, 0xff, 0x18, 0x40, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x10, 0x20, 0xff, 0x29, 0x45, 0xc6, 0x18, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xc6, 0x39, 0x39, 0xa6, 0xd6, 0x00, 0x00, 0xff, 0x29, 0x45, 0xff, 0x4a, 0x49, 0xff, 0x41, 0xe7, 0xff, 0x31, 0x45, 0xff, 0x18, 0x81, 0xff, 0x10, 0x40, 0xff, 0x10, 0x40, 0xff, 0x10, 0x40, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x00, 0xfe, 0x52, 0x8a, 0xb6, 0x31, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x24, 0x0c, 0x41, 0xe6, 0xcb, 0x00, 0x00, 0xff, 0x21, 0x04, 0xff, 0x4a, 0x28, 0xff, 0x39, 0xc7, 0xff, 0x29, 0x24, 0xff, 0x10, 0x61, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x00, 0x00, 0xfa, 0x8c, 0x71, 0x9a, 0x63, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xaa, 0x00, 0x8c, 0x30, 0xc7, 0x08, 0x20, 0xff, 0x10, 0x61, 0xff, 0x42, 0x28, 0xff, 0x39, 0xc7, 0xff, 0x29, 0x24, 0xff, 0x10, 0x61, 0xff, 0x00, 0x00, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x00, 0xff, 0x00, 0x00, 0xff, 0x31, 0x86, 0xf7, 0x5a, 0xcb, 0x82, 0x10, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x08, 0x41, 0x03, 0x00, 0x00, 0x04, 0x63, 0x0c, 0x00, 0xbd, 0xf7, 0xb7, 0x84, 0x30, 0xf6, 0x4a, 0x69, 0xff, 0x4a, 0x28, 0xff, 0x31, 0xa6, 0xff, 0x21, 0x04, 0xff, 0x08, 0x41, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x08, 0x20, 0xff, 0x00, 0x20, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x42, 0x08, 0xfe, 0x84, 0x10, 0xe8, 0x8c, 0x51, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x20, 0x05, 0x08, 0x41, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x00, 0x20, 0x05, 0x10, 0x82, 0x07, 0x08, 0x61, 0x09, 0x10, 0xa2, 0x0c, 0x08, 0x41, 0x0e, 0x42, 0x28, 0x10, 0x94, 0xb2, 0x6e, 0x94, 0xb2, 0x97, 0x9c, 0xf3, 0xc5, 0xa5, 0x34, 0xee, 0x8c, 0x30, 0xfe, 0x5a, 0xcb, 0xff, 0x31, 0xa6, 0xff, 0x21, 0x04, 0xff, 0x18, 0xa2, 0xff, 0x10, 0x61, 0xff, 0x08, 0x61, 0xff, 0x08, 0x61, 0xff, 0x08, 0x61, 0xff, 0x10, 0xa2, 0xff, 0x18, 0xe3, 0xff, 0x29, 0x65, 0xff, 0x4a, 0x69, 0xff, 0x7b, 0xcf, 0xfe, 0x9c, 0xf3, 0xee, 0xa5, 0x34, 0xca, 0xa5, 0x14, 0x9c, 0x84, 0x30, 0x49, 0x00, 0x00, 0x09, 0x10, 0x82, 0x0f, 0x10, 0xa2, 0x0c, 0x08, 0x61, 0x09, 0x10, 0x82, 0x07, 0x00, 0x20, 0x05, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x20, 0x04, 0x08, 0x41, 0x06, 0x10, 0x82, 0x09, 0x10, 0x82, 0x0c, 0x10, 0x82, 0x10, 0x10, 0x82, 0x14, 0x08, 0x61, 0x18, 0x08, 0x41, 0x1c, 0x29, 0x65, 0x21, 0x7b, 0xef, 0x6b, 0x6b, 0x4d, 0x68, 0x6b, 0x6d, 0x61, 0xa5, 0x34, 0xa5, 0xb5, 0xb6, 0xdb, 0xb5, 0xb6, 0xf7, 0xad, 0x75, 0xfc, 0x9c, 0xf3, 0xfa, 0x94, 0x92, 0xf7, 0x8c, 0x71, 0xf5, 0x8c, 0x51, 0xf3, 0x8c, 0x51, 0xf4, 0x94, 0x92, 0xf8, 0x9c, 0xd3, 0xfe, 0xad, 0x55, 0xff, 0xbd, 0xd7, 0xf6, 0xbd, 0xf7, 0xe0, 0xb5, 0xb6, 0xb7, 0x9c, 0xd3, 0x86, 0x84, 0x30, 0x65, 0x9c, 0xd3, 0x8c, 0x73, 0xae, 0x5a, 0x00, 0x00, 0x1b, 0x08, 0x61, 0x1d, 0x08, 0x61, 0x18, 0x10, 0x82, 0x14, 0x10, 0x82, 0x10, 0x10, 0x82, 0x0c, 0x10, 0x82, 0x09, 0x08, 0x41, 0x06, 0x00, 0x20, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x08, 0x61, 0x06, 0x10, 0xa2, 0x09, 0x10, 0xa2, 0x0d, 0x10, 0x82, 0x11, 0x08, 0x61, 0x15, 0x08, 0x61, 0x1a, 0x10, 0x82, 0x20, 0x08, 0x61, 0x26, 0x08, 0x41, 0x2c, 0x10, 0xa2, 0x2d, 0x73, 0x8e, 0x8e, 0x84, 0x30, 0xb8, 0x84, 0x10, 0x9a, 0x9c, 0xf3, 0xa6, 0xa5, 0x34, 0xb8, 0x9c, 0xd3, 0xc8, 0x84, 0x30, 0xce, 0x7b, 0xef, 0xc7, 0x7b, 0xef, 0xbb, 0x84, 0x10, 0xad, 0x7b, 0xef, 0xa2, 0x84, 0x10, 0xa6, 0x8c, 0x51, 0xbe, 0x9c, 0xd3, 0xd6, 0xa5, 0x14, 0xd8, 0x9c, 0xf3, 0xc0, 0x8c, 0x51, 0x9a, 0x6b, 0x6d, 0x7a, 0x6b, 0x6d, 0x78, 0x8c, 0x51, 0xa0, 0x94, 0xb2, 0xc9, 0x52, 0x8a, 0x67, 0x00, 0x00, 0x2d, 0x08, 0x61, 0x2c, 0x08, 0x61, 0x25, 0x10, 0x82, 0x20, 0x08, 0x61, 0x1a, 0x08, 0x61, 0x15, 0x10, 0x82, 0x10, 0x10, 0xa2, 0x0d, 0x10, 0xa2, 0x09, 0x08, 0x61, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x08, 0x41, 0x06, 0x18, 0xc3, 0x0a, 0x10, 0xa2, 0x0e, 0x08, 0x61, 0x12, 0x08, 0x61, 0x18, 0x10, 0x82, 0x1e, 0x08, 0x61, 0x24, 0x08, 0x61, 0x2b, 0x08, 0x41, 0x32, 0x08, 0x61, 0x3a, 0x00, 0x20, 0x41, 0x31, 0x86, 0x64, 0x6b, 0x6d, 0xbc, 0x94, 0x92, 0xdf, 0xbd, 0xd7, 0xe2, 0xc6, 0x38, 0xe8, 0xbd, 0xf7, 0xe6, 0xa5, 0x14, 0xd6, 0x7b, 0xcf, 0xc4, 0x52, 0x8a, 0xb7, 0x29, 0x65, 0xac, 0x10, 0xa2, 0xa5, 0x18, 0xc3, 0xa6, 0x42, 0x08, 0xb2, 0x6b, 0x4d, 0xc1, 0x94, 0x92, 0xcf, 0xa5, 0x14, 0xd7, 0xa5, 0x14, 0xd1, 0x9c, 0xd3, 0xc4, 0x9c, 0xd3, 0xcd, 0x94, 0x92, 0xd9, 0x63, 0x0c, 0xa5, 0x10, 0xa2, 0x50, 0x08, 0x41, 0x42, 0x08, 0x61, 0x3a, 0x08, 0x41, 0x32, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x24, 0x10, 0x82, 0x1e, 0x08, 0x61, 0x18, 0x08, 0x61, 0x12, 0x10, 0xa2, 0x0e, 0x18, 0xc3, 0x0a, 0x08, 0x41, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x00, 0x20, 0x05, 0x18, 0xc3, 0x09, 0x10, 0xa2, 0x0d, 0x08, 0x61, 0x11, 0x08, 0x61, 0x17, 0x10, 0x82, 0x1d, 0x08, 0x61, 0x24, 0x08, 0x61, 0x2b, 0x08, 0x41, 0x33, 0x08, 0x61, 0x3c, 0x08, 0x41, 0x45, 0x08, 0x41, 0x4f, 0x00, 0x00, 0x57, 0x18, 0xc3, 0x6c, 0x52, 0xaa, 0xac, 0xad, 0x55, 0xe3, 0xde, 0xfb, 0xfa, 0xe7, 0x3c, 0xff, 0xde, 0xdb, 0xfc, 0xc6, 0x18, 0xf3, 0xa5, 0x34, 0xea, 0x8c, 0x51, 0xe2, 0x73, 0xae, 0xde, 0x7b, 0xcf, 0xdf, 0x94, 0x92, 0xe6, 0xb5, 0x96, 0xf0, 0xce, 0x59, 0xfa, 0xd6, 0xba, 0xfe, 0xd6, 0x9a, 0xf9, 0xb5, 0xb6, 0xf1, 0x8c, 0x51, 0xd8, 0x4a, 0x49, 0x9f, 0x00, 0x20, 0x65, 0x00, 0x20, 0x58, 0x08, 0x41, 0x4f, 0x08, 0x41, 0x45, 0x08, 0x61, 0x3c, 0x08, 0x41, 0x33, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x24, 0x10, 0x82, 0x1d, 0x08, 0x61, 0x17, 0x08, 0x61, 0x11, 0x10, 0xa2, 0x0d, 0x18, 0xc3, 0x09, 0x00, 0x20, 0x05, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 
  0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0x08, 0x61, 0x06, 0x18, 0xc3, 0x0a, 0x10, 0x82, 0x0e, 0x08, 0x61, 0x13, 0x08, 0x61, 0x18, 0x10, 0x82, 0x1f, 0x08, 0x61, 0x26, 0x08, 0x41, 0x2e, 0x08, 0x61, 0x36, 0x08, 0x61, 0x3f, 0x08, 0x41, 0x49, 0x08, 0x41, 0x53, 0x08, 0x41, 0x5f, 0x00, 0x20, 0x69, 0x00, 0x00, 0x74, 0x39, 0xc7, 0x91, 0x73, 0x8e, 0xb9, 0x9c, 0xf3, 0xd7, 0xb5, 0xb6, 0xe9, 0xc6, 0x18, 0xf1, 0xc6, 0x38, 0xf5, 0xc6, 0x18, 0xf6, 0xbd, 0xf7, 0xf7, 0xbd, 0xf7, 0xf8, 0xc6, 0x18, 0xf7, 0xc6, 0x38, 0xf5, 0xc6, 0x18, 0xf2, 0xb5, 0x96, 0xe8, 0x8c, 0x71, 0xd3, 0x5a, 0xcb, 0xb3, 0x21, 0x24, 0x8c, 0x00, 0x00, 0x74, 0x00, 0x20, 0x6a, 0x08, 0x41, 0x5f, 0x08, 0x41, 0x53, 0x08, 0x41, 0x49, 0x08, 0x61, 0x3f, 0x08, 0x61, 0x36, 0x08, 0x41, 0x2e, 0x08, 0x61, 0x26, 0x10, 0x82, 0x1f, 0x08, 0x61, 0x18, 0x08, 0x61, 0x13, 0x10, 0x82, 0x0e, 0x18, 0xc3, 0x0a, 0x08, 0x61, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 
  0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x00, 0x20, 0x06, 0x18, 0xc3, 0x09, 0x10, 0xa2, 0x0d, 0x08, 0x61, 0x12, 0x08, 0x61, 0x17, 0x10, 0x82, 0x1d, 0x08, 0x61, 0x24, 0x08, 0x61, 0x2b, 0x08, 0x41, 0x33, 0x08, 0x61, 0x3c, 0x08, 0x41, 0x45, 0x08, 0x41, 0x4f, 0x08, 0x41, 0x5a, 0x08, 0x41, 0x64, 0x00, 0x20, 0x70, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x85, 0x00, 0x00, 0x93, 0x08, 0x61, 0xa4, 0x21, 0x24, 0xb4, 0x31, 0xa6, 0xc0, 0x39, 0xe7, 0xc9, 0x42, 0x08, 0xce, 0x42, 0x08, 0xce, 0x39, 0xe7, 0xc9, 0x31, 0x86, 0xc0, 0x21, 0x04, 0xb3, 0x08, 0x41, 0xa3, 0x00, 0x00, 0x93, 0x00, 0x00, 0x85, 0x00, 0x00, 0x7b, 0x00, 0x20, 0x70, 0x08, 0x41, 0x64, 0x08, 0x41, 0x59, 0x08, 0x41, 0x4f, 0x08, 0x41, 0x45, 0x08, 0x61, 0x3c, 0x08, 0x41, 0x33, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x24, 0x10, 0x82, 0x1d, 0x08, 0x61, 0x17, 0x08, 0x61, 0x12, 0x10, 0xa2, 0x0d, 0x10, 0xa2, 0x09, 0x00, 0x20, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x04, 0x10, 0xa2, 0x06, 0x18, 0xc3, 0x0a, 0x10, 0xa2, 0x0e, 0x08, 0x61, 0x13, 0x08, 0x61, 0x18, 0x10, 0x82, 0x1e, 0x08, 0x61, 0x24, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x32, 0x08, 0x61, 0x3a, 0x08, 0x61, 0x43, 0x08, 0x41, 0x4c, 0x08, 0x41, 0x54, 0x08, 0x41, 0x5d, 0x08, 0x41, 0x67, 0x00, 0x20, 0x70, 0x00, 0x20, 0x79, 0x00, 0x20, 0x80, 0x00, 0x00, 0x87, 0x00, 0x00, 0x8d, 0x00, 0x00, 0x92, 0x00, 0x00, 0x95, 0x00, 0x00, 0x95, 0x00, 0x00, 0x92, 0x00, 0x00, 0x8d, 0x00, 0x00, 0x87, 0x00, 0x20, 0x80, 0x00, 0x20, 0x79, 0x00, 0x20, 0x70, 0x08, 0x41, 0x67, 0x08, 0x41, 0x5d, 0x08, 0x41, 0x54, 0x08, 0x41, 0x4c, 0x08, 0x61, 0x43, 0x08, 0x61, 0x3a, 0x08, 0x61, 0x33, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x24, 0x10, 0x82, 0x1e, 0x08, 0x61, 0x18, 0x08, 0x61, 0x13, 0x10, 0xa2, 0x0e, 0x10, 0xa2, 0x0a, 0x00, 0x20, 0x06, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x08, 0x41, 0x06, 0x10, 0x82, 0x09, 0x10, 0xa2, 0x0d, 0x10, 0x82, 0x11, 0x08, 0x61, 0x16, 0x08, 0x61, 0x1b, 0x08, 0x61, 0x20, 0x08, 0x61, 0x26, 0x08, 0x61, 0x2c, 0x08, 0x61, 0x32, 0x08, 0x61, 0x39, 0x08, 0x61, 0x40, 0x08, 0x41, 0x47, 0x08, 0x41, 0x4d, 0x08, 0x41, 0x54, 0x08, 0x41, 0x5a, 0x08, 0x41, 0x5f, 0x08, 0x41, 0x63, 0x08, 0x41, 0x67, 0x00, 0x20, 0x6a, 0x00, 0x20, 0x6b, 0x00, 0x20, 0x6b, 0x00, 0x20, 0x6a, 0x08, 0x41, 0x67, 0x08, 0x41, 0x63, 0x08, 0x41, 0x5f, 0x08, 0x41, 0x5a, 0x08, 0x41, 0x54, 0x08, 0x41, 0x4d, 0x08, 0x41, 0x47, 0x08, 0x61, 0x40, 0x08, 0x61, 0x39, 0x08, 0x61, 0x32, 0x08, 0x61, 0x2c, 0x08, 0x61, 0x26, 0x08, 0x61, 0x20, 0x08, 0x61, 0x1b, 0x08, 0x61, 0x16, 0x10, 0x82, 0x11, 0x10, 0xa2, 0x0d, 0x10, 0x82, 0x09, 0x08, 0x41, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x08, 0x61, 0x06, 0x10, 0xa2, 0x09, 0x10, 0xa2, 0x0c, 0x10, 0x82, 0x10, 0x08, 0x61, 0x14, 0x08, 0x61, 0x18, 0x08, 0x61, 0x1d, 0x08, 0x61, 0x21, 0x08, 0x61, 0x26, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x2f, 0x08, 0x61, 0x34, 0x08, 0x61, 0x38, 0x08, 0x61, 0x3c, 0x08, 0x41, 0x3f, 0x08, 0x41, 0x43, 0x08, 0x41, 0x45, 0x08, 0x41, 0x46, 0x08, 0x41, 0x47, 0x08, 0x41, 0x47, 0x08, 0x41, 0x46, 0x08, 0x41, 0x45, 0x08, 0x41, 0x43, 0x08, 0x41, 0x3f, 0x08, 0x61, 0x3c, 0x08, 0x61, 0x38, 0x08, 0x61, 0x34, 0x08, 0x61, 0x2f, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x26, 0x08, 0x61, 0x21, 0x08, 0x61, 0x1d, 0x08, 0x61, 0x18, 0x08, 0x61, 0x14, 0x10, 0x82, 0x10, 0x10, 0xa2, 0x0c, 0x10, 0xa2, 0x09, 0x08, 0x61, 0x06, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x08, 0x41, 0x05, 0x08, 0x61, 0x07, 0x10, 0x82, 0x0a, 0x10, 0xa2, 0x0c, 0x10, 0x82, 0x0f, 0x10, 0x82, 0x12, 0x10, 0x82, 0x16, 0x08, 0x61, 0x19, 0x08, 0x61, 0x1c, 0x10, 0x82, 0x1f, 0x08, 0x61, 0x21, 0x08, 0x61, 0x24, 0x08, 0x61, 0x26, 0x08, 0x61, 0x28, 0x08, 0x61, 0x29, 0x08, 0x61, 0x2a, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x2b, 0x08, 0x61, 0x2a, 0x08, 0x61, 0x29, 0x08, 0x61, 0x28, 0x08, 0x61, 0x26, 0x08, 0x61, 0x24, 0x08, 0x61, 0x21, 0x10, 0x82, 0x1f, 0x08, 0x61, 0x1c, 0x08, 0x61, 0x19, 0x10, 0x82, 0x15, 0x10, 0x82, 0x12, 0x10, 0x82, 0x0f, 0x10, 0xa2, 0x0c, 0x10, 0x82, 0x0a, 0x08, 0x61, 0x07, 0x08, 0x41, 0x05, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x20, 0x03, 0x00, 0x00, 0x05, 0x10, 0x82, 0x06, 0x10, 0x82, 0x08, 0x10, 0x82, 0x0a, 0x08, 0x61, 0x0c, 0x10, 0xa2, 0x0e, 0x10, 0xa2, 0x0f, 0x10, 0xa2, 0x11, 0x10, 0x82, 0x12, 0x10, 0x82, 0x13, 0x10, 0x82, 0x14, 0x10, 0x82, 0x14, 0x10, 0x82, 0x15, 0x10, 0x82, 0x15, 0x10, 0x82, 0x14, 0x10, 0x82, 0x14, 0x10, 0x82, 0x13, 0x10, 0x82, 0x12, 0x10, 0xa2, 0x11, 0x10, 0xa2, 0x0f, 0x10, 0xa2, 0x0e, 0x08, 0x61, 0x0c, 0x10, 0x82, 0x0a, 0x10, 0x82, 0x08, 0x10, 0x82, 0x07, 0x00, 0x00, 0x05, 0x00, 0x20, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0x08, 0x61, 0x03, 0x10, 0x82, 0x04, 0x08, 0x61, 0x05, 0x08, 0x61, 0x05, 0x08, 0x41, 0x06, 0x08, 0x41, 0x06, 0x08, 0x41, 0x07, 0x08, 0x41, 0x07, 0x08, 0x41, 0x07, 0x08, 0x41, 0x07, 0x08, 0x41, 0x06, 0x08, 0x41, 0x06, 0x08, 0x61, 0x05, 0x08, 0x61, 0x05, 0x10, 0x82, 0x04, 0x08, 0x61, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
#endif
};

const lv_img_dsc_t _ristretto_alpha_50x50 = {
  .header.always_zero = 0,
  .header.w = 50,
  .header.h = 50,
  .data_size = 2500 * LV_COLOR_SIZE / 8,
  .header.cf = LV_IMG_CF_TRUE_COLOR_ALPHA,
  .data = _ristretto_alpha_50x50_map,
};
