/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v7.0
processor: LPC54S018
package_id: LPC54S018JET180
mcu_data: ksdk2_0
processor_version: 7.0.1
board: LPCXpresso54S018
pin_labels:
- {pin_num: E2, pin_signal: PIO3_24/FC2_RTS_SCL_SSEL1/CTIMER4_CAP0/USB0_VBUS, label: 'J11[9]/J9[1]/U10[2]/J17[4]/U19[2]/P3_24-FC2_SCLX', identifier: FC2_SCLX;SCL}
- {pin_num: C2, pin_signal: PIO3_23/FC2_CTS_SDA_SSEL0/UTICK_CAP3, label: 'J11[10]/J9[3]/U10[3]/J17[5]/U19[10]/P3_23-FC2_SDAX', identifier: FC2_SDAX;SDA}
- {pin_num: B13, pin_signal: PIO0_29/FC0_RXD_SDA_MOSI/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA(2), label: 'U24[13]/P0_29-ISP_FC0_RXD', identifier: ISP_FC0_RXD;RX_GPIO;RX}
- {pin_num: A2, pin_signal: PIO0_30/FC0_TXD_SCL_MISO/CTIMER0_MAT0/SCT0_OUT9/TRACEDATA(1), label: 'U24[12]/P0_30-ISP_FC0_TXD', identifier: ISP_FC0_TXD;TX}
- {pin_num: N2, pin_signal: PIO3_20/FC9_SCK/SD_CARD_INT_N/CLKOUT/SCT0_OUT7, label: 'J9[9]/P3_20-FC9_SCK', identifier: SCK}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_gpio.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
UART0_PollForActivity:
- options: {callFromInitBoot: 'false', coreID: core0, enableClock: 'false'}
- pin_list:
  - {pin_num: B13, peripheral: GPIO, signal: 'PIO0, 29', pin_signal: PIO0_29/FC0_RXD_SDA_MOSI/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA(2), identifier: RX_GPIO, direction: INPUT,
    glitch_filter: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : UART0_PollForActivity
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M4F */
void UART0_PollForActivity(void)
{
    /* Enables the clock for the GPIO0 module */
    CLOCK_EnableClock(kCLOCK_Gpio0);

    gpio_pin_config_t RX_GPIO_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_29 (pin B13)  */
    GPIO_PinInit(UART0_POLLFORACTIVITY_RX_GPIO_GPIO, UART0_POLLFORACTIVITY_RX_GPIO_PORT, UART0_POLLFORACTIVITY_RX_GPIO_PIN, &RX_GPIO_config);

    IOCON->PIO[0][29] = ((IOCON->PIO[0][29] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_FILTEROFF_MASK)))

                         /* Selects pin function.
                          * : PORT029 (pin B13) is configured as PIO0_29. */
                         | IOCON_PIO_FUNC(PIO029_FUNC_ALT0)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO029_DIGIMODE_DIGITAL)

                         /* Controls input glitch filter.
                          * : Filter disabled.
                          * No input filtering is done. */
                         | IOCON_PIO_FILTEROFF(PIO029_FILTEROFF_DISABLED));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
UART0_InitPins:
- options: {callFromInitBoot: 'false', prefix: UART0_, coreID: core0, enableClock: 'false'}
- pin_list:
  - {pin_num: B13, peripheral: FLEXCOMM0, signal: RXD_SDA_MOSI, pin_signal: PIO0_29/FC0_RXD_SDA_MOSI/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA(2), identifier: RX, mode: inactive,
    glitch_filter: disabled}
  - {pin_num: A2, peripheral: FLEXCOMM0, signal: TXD_SCL_MISO, pin_signal: PIO0_30/FC0_TXD_SCL_MISO/CTIMER0_MAT0/SCT0_OUT9/TRACEDATA(1), identifier: TX, mode: inactive,
    glitch_filter: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : UART0_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M4F */
void UART0_InitPins(void)
{

    IOCON->PIO[0][29] =
        ((IOCON->PIO[0][29] &
          /* Mask bits to zero which are setting */
          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_FILTEROFF_MASK)))

         /* Selects pin function.
          * : PORT029 (pin B13) is configured as FC0_RXD_SDA_MOSI. */
         | IOCON_PIO_FUNC(PIO029_FUNC_ALT1)

         /* Selects function mode (on-chip pull-up/pull-down resistor control).
          * : Inactive.
          * Inactive (no pull-down/pull-up resistor enabled). */
         | IOCON_PIO_MODE(PIO029_MODE_INACTIVE)

         /* Select Analog/Digital mode.
          * : Digital mode. */
         | IOCON_PIO_DIGIMODE(PIO029_DIGIMODE_DIGITAL)

         /* Controls input glitch filter.
          * : Filter disabled.
          * No input filtering is done. */
         | IOCON_PIO_FILTEROFF(PIO029_FILTEROFF_DISABLED));

    IOCON->PIO[0][30] =
        ((IOCON->PIO[0][30] &
          /* Mask bits to zero which are setting */
          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_FILTEROFF_MASK)))

         /* Selects pin function.
          * : PORT030 (pin A2) is configured as FC0_TXD_SCL_MISO. */
         | IOCON_PIO_FUNC(PIO030_FUNC_ALT1)

         /* Selects function mode (on-chip pull-up/pull-down resistor control).
          * : Inactive.
          * Inactive (no pull-down/pull-up resistor enabled). */
         | IOCON_PIO_MODE(PIO030_MODE_INACTIVE)

         /* Select Analog/Digital mode.
          * : Digital mode. */
         | IOCON_PIO_DIGIMODE(PIO030_DIGIMODE_DIGITAL)

         /* Controls input glitch filter.
          * : Filter disabled.
          * No input filtering is done. */
         | IOCON_PIO_FILTEROFF(PIO030_FILTEROFF_DISABLED));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
UART0_RestoreDefault:
- options: {callFromInitBoot: 'false', coreID: core0, enableClock: 'false'}
- pin_list:
  - {pin_num: B13, peripheral: GPIO, signal: 'PIO0, 29', pin_signal: PIO0_29/FC0_RXD_SDA_MOSI/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA(2), identifier: RX}
  - {pin_num: A2, peripheral: GPIO, signal: 'PIO0, 30', pin_signal: PIO0_30/FC0_TXD_SCL_MISO/CTIMER0_MAT0/SCT0_OUT9/TRACEDATA(1), identifier: TX}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : UART0_RestoreDefault
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M4F */
void UART0_RestoreDefault(void)
{

    IOCON->PIO[0][29] = ((IOCON->PIO[0][29] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Selects pin function.
                          * : PORT029 (pin B13) is configured as PIO0_29. */
                         | IOCON_PIO_FUNC(PIO029_FUNC_ALT0)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO029_DIGIMODE_DIGITAL));

    IOCON->PIO[0][30] = ((IOCON->PIO[0][30] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Selects pin function.
                          * : PORT030 (pin A2) is configured as PIO0_30. */
                         | IOCON_PIO_FUNC(PIO030_FUNC_ALT0)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO030_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
I2C2_InitPins:
- options: {callFromInitBoot: 'false', prefix: I2C2_, coreID: core0, enableClock: 'false'}
- pin_list:
  - {pin_num: C2, peripheral: FLEXCOMM2, signal: CTS_SDA_SSEL0, pin_signal: PIO3_23/FC2_CTS_SDA_SSEL0/UTICK_CAP3, identifier: SDA, glitch_filter: disabled}
  - {pin_num: E2, peripheral: FLEXCOMM2, signal: RTS_SCL_SSEL1, pin_signal: PIO3_24/FC2_RTS_SCL_SSEL1/CTIMER4_CAP0/USB0_VBUS, identifier: SCL, glitch_filter: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : I2C2_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M4F */
void I2C2_InitPins(void)
{

    IOCON->PIO[3][23] = ((IOCON->PIO[3][23] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_FILTEROFF_MASK)))

                         /* Selects pin function.
                          * : PORT323 (pin C2) is configured as FC2_CTS_SDA_SSEL0. */
                         | IOCON_PIO_FUNC(PIO323_FUNC_ALT1)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO323_DIGIMODE_DIGITAL)

                         /* Controls input glitch filter.
                          * : Filter disabled.
                          * No input filtering is done. */
                         | IOCON_PIO_FILTEROFF(PIO323_FILTEROFF_DISABLED));

    IOCON->PIO[3][24] = ((IOCON->PIO[3][24] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_FILTEROFF_MASK)))

                         /* Selects pin function.
                          * : PORT324 (pin E2) is configured as FC2_RTS_SCL_SSEL1. */
                         | IOCON_PIO_FUNC(PIO324_FUNC_ALT1)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO324_DIGIMODE_DIGITAL)

                         /* Controls input glitch filter.
                          * : Filter disabled.
                          * No input filtering is done. */
                         | IOCON_PIO_FILTEROFF(PIO324_FILTEROFF_DISABLED));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
I2C2_RestoreDefault:
- options: {callFromInitBoot: 'false', coreID: core0, enableClock: 'false'}
- pin_list:
  - {pin_num: C2, peripheral: GPIO, signal: 'PIO3, 23', pin_signal: PIO3_23/FC2_CTS_SDA_SSEL0/UTICK_CAP3}
  - {pin_num: E2, peripheral: GPIO, signal: 'PIO3, 24', pin_signal: PIO3_24/FC2_RTS_SCL_SSEL1/CTIMER4_CAP0/USB0_VBUS}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : I2C2_RestoreDefault
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M4F */
void I2C2_RestoreDefault(void)
{

    IOCON->PIO[3][23] = ((IOCON->PIO[3][23] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Selects pin function.
                          * : PORT323 (pin C2) is configured as PIO3_23. */
                         | IOCON_PIO_FUNC(PIO323_FUNC_ALT0)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO323_DIGIMODE_DIGITAL));

    IOCON->PIO[3][24] = ((IOCON->PIO[3][24] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Selects pin function.
                          * : PORT324 (pin E2) is configured as PIO3_24. */
                         | IOCON_PIO_FUNC(PIO324_FUNC_ALT0)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO324_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
SPI9_InitPins:
- options: {callFromInitBoot: 'false', prefix: SPI9_, coreID: core0, enableClock: 'false'}
- pin_list:
  - {pin_num: N2, peripheral: FLEXCOMM9, signal: SCK, pin_signal: PIO3_20/FC9_SCK/SD_CARD_INT_N/CLKOUT/SCT0_OUT7, mode: pullUp}
  - {pin_num: P5, peripheral: FLEXCOMM9, signal: RXD_SDA_MOSI, pin_signal: PIO3_21/FC9_RXD_SDA_MOSI/SD_BACKEND_PWR/CTIMER4_MAT3/UTICK_CAP2/ADC0_9, mode: pullUp}
  - {pin_num: N5, peripheral: FLEXCOMM9, signal: TXD_SCL_MISO, pin_signal: PIO3_22/FC9_TXD_SCL_MISO/ADC0_10, mode: pullUp}
  - {pin_num: K13, peripheral: FLEXCOMM9, signal: CTS_SDA_SSEL0, pin_signal: PIO3_30/FC9_CTS_SDA_SSEL0/SCT0_OUT4/FC4_SSEL2/EMC_A(19), mode: pullUp}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : SPI9_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M4F */
void SPI9_InitPins(void)
{

    IOCON->PIO[3][20] = ((IOCON->PIO[3][20] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Selects pin function.
                          * : PORT320 (pin N2) is configured as FC9_SCK. */
                         | IOCON_PIO_FUNC(PIO320_FUNC_ALT1)

                         /* Selects function mode (on-chip pull-up/pull-down resistor control).
                          * : Pull-up.
                          * Pull-up resistor enabled. */
                         | IOCON_PIO_MODE(PIO320_MODE_PULL_UP)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO320_DIGIMODE_DIGITAL));

    IOCON->PIO[3][21] =
        ((IOCON->PIO[3][21] &
          /* Mask bits to zero which are setting */
          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_ANAMODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

         /* Selects pin function.
          * : PORT321 (pin P5) is configured as FC9_RXD_SDA_MOSI. */
         | IOCON_PIO_FUNC(PIO321_FUNC_ALT1)

         /* Selects function mode (on-chip pull-up/pull-down resistor control).
          * : Pull-up.
          * Pull-up resistor enabled. */
         | IOCON_PIO_MODE(PIO321_MODE_PULL_UP)

         /* Enables or disables analog mode.
          * : Disable analog Mode. */
         | IOCON_PIO_ANAMODE(PIO321_ANAMODE_DISABLED)

         /* Select Analog/Digital mode.
          * : Digital mode. */
         | IOCON_PIO_DIGIMODE(PIO321_DIGIMODE_DIGITAL));

    IOCON->PIO[3][22] =
        ((IOCON->PIO[3][22] &
          /* Mask bits to zero which are setting */
          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_ANAMODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

         /* Selects pin function.
          * : PORT322 (pin N5) is configured as FC9_TXD_SCL_MISO. */
         | IOCON_PIO_FUNC(PIO322_FUNC_ALT1)

         /* Selects function mode (on-chip pull-up/pull-down resistor control).
          * : Pull-up.
          * Pull-up resistor enabled. */
         | IOCON_PIO_MODE(PIO322_MODE_PULL_UP)

         /* Enables or disables analog mode.
          * : Disable analog Mode. */
         | IOCON_PIO_ANAMODE(PIO322_ANAMODE_DISABLED)

         /* Select Analog/Digital mode.
          * : Digital mode. */
         | IOCON_PIO_DIGIMODE(PIO322_DIGIMODE_DIGITAL));

    IOCON->PIO[3][30] = ((IOCON->PIO[3][30] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Selects pin function.
                          * : PORT330 (pin K13) is configured as FC9_CTS_SDA_SSEL0. */
                         | IOCON_PIO_FUNC(PIO330_FUNC_ALT1)

                         /* Selects function mode (on-chip pull-up/pull-down resistor control).
                          * : Pull-up.
                          * Pull-up resistor enabled. */
                         | IOCON_PIO_MODE(PIO330_MODE_PULL_UP)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO330_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
SPI9_RestoreDefault:
- options: {callFromInitBoot: 'false', coreID: core0, enableClock: 'false'}
- pin_list:
  - {pin_num: N2, peripheral: GPIO, signal: 'PIO3, 20', pin_signal: PIO3_20/FC9_SCK/SD_CARD_INT_N/CLKOUT/SCT0_OUT7, mode: inactive}
  - {pin_num: P5, peripheral: GPIO, signal: 'PIO3, 21', pin_signal: PIO3_21/FC9_RXD_SDA_MOSI/SD_BACKEND_PWR/CTIMER4_MAT3/UTICK_CAP2/ADC0_9, mode: inactive}
  - {pin_num: N5, peripheral: GPIO, signal: 'PIO3, 22', pin_signal: PIO3_22/FC9_TXD_SCL_MISO/ADC0_10, mode: inactive}
  - {pin_num: K13, peripheral: GPIO, signal: 'PIO3, 30', pin_signal: PIO3_30/FC9_CTS_SDA_SSEL0/SCT0_OUT4/FC4_SSEL2/EMC_A(19), mode: inactive}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : SPI9_RestoreDefault
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M4F */
void SPI9_RestoreDefault(void)
{

    IOCON->PIO[3][20] = ((IOCON->PIO[3][20] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Selects pin function.
                          * : PORT320 (pin N2) is configured as PIO3_20. */
                         | IOCON_PIO_FUNC(PIO320_FUNC_ALT0)

                         /* Selects function mode (on-chip pull-up/pull-down resistor control).
                          * : Inactive.
                          * Inactive (no pull-down/pull-up resistor enabled). */
                         | IOCON_PIO_MODE(PIO320_MODE_INACTIVE)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO320_DIGIMODE_DIGITAL));

    IOCON->PIO[3][21] =
        ((IOCON->PIO[3][21] &
          /* Mask bits to zero which are setting */
          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_ANAMODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

         /* Selects pin function.
          * : PORT321 (pin P5) is configured as PIO3_21. */
         | IOCON_PIO_FUNC(PIO321_FUNC_ALT0)

         /* Selects function mode (on-chip pull-up/pull-down resistor control).
          * : Inactive.
          * Inactive (no pull-down/pull-up resistor enabled). */
         | IOCON_PIO_MODE(PIO321_MODE_INACTIVE)

         /* Enables or disables analog mode.
          * : Disable analog Mode. */
         | IOCON_PIO_ANAMODE(PIO321_ANAMODE_DISABLED)

         /* Select Analog/Digital mode.
          * : Digital mode. */
         | IOCON_PIO_DIGIMODE(PIO321_DIGIMODE_DIGITAL));

    IOCON->PIO[3][22] =
        ((IOCON->PIO[3][22] &
          /* Mask bits to zero which are setting */
          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_ANAMODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

         /* Selects pin function.
          * : PORT322 (pin N5) is configured as PIO3_22. */
         | IOCON_PIO_FUNC(PIO322_FUNC_ALT0)

         /* Selects function mode (on-chip pull-up/pull-down resistor control).
          * : Inactive.
          * Inactive (no pull-down/pull-up resistor enabled). */
         | IOCON_PIO_MODE(PIO322_MODE_INACTIVE)

         /* Enables or disables analog mode.
          * : Disable analog Mode. */
         | IOCON_PIO_ANAMODE(PIO322_ANAMODE_DISABLED)

         /* Select Analog/Digital mode.
          * : Digital mode. */
         | IOCON_PIO_DIGIMODE(PIO322_DIGIMODE_DIGITAL));

    IOCON->PIO[3][30] = ((IOCON->PIO[3][30] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Selects pin function.
                          * : PORT330 (pin K13) is configured as PIO3_30. */
                         | IOCON_PIO_FUNC(PIO330_FUNC_ALT0)

                         /* Selects function mode (on-chip pull-up/pull-down resistor control).
                          * : Inactive.
                          * Inactive (no pull-down/pull-up resistor enabled). */
                         | IOCON_PIO_MODE(PIO330_MODE_INACTIVE)

                         /* Select Analog/Digital mode.
                          * : Digital mode. */
                         | IOCON_PIO_DIGIMODE(PIO330_DIGIMODE_DIGITAL));
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
