/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __FUNDAMENTAL3PH_H
#define __FUNDAMENTAL3PH_H

#include "MeteringLPRT.h"

#define zSINETABLE 60

/******************************************************************************
 * public variables                                                           *
 ******************************************************************************/
#define NFSAMPS zSINETABLE
#define NTHDAVG 8

extern int64  VSinSum3Ph[nBUFFERS][nVPHASES];
extern int64  VCosSum3Ph[nBUFFERS][nVPHASES];
extern int64  ISinSum3Ph[nBUFFERS][nVPHASES];
extern int64  ICosSum3Ph[nBUFFERS][nVPHASES];
extern const  int16 SinTable[zSINETABLE];
extern const  int16 CosTable[zSINETABLE];
extern uint16 nFSamps;

/******************************************************************************
 * public function prototypes                                                 *
 ******************************************************************************/
extern void CalculateFundamentalQuantities3Ph(void);

#endif /* __FUNDAMENTAL3PH_H */
