/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */ 
#include "flash_FTFL.h" /* include flash driver header file */
#include "types.h"
#include "fsl_common.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
* Prototypes
******************************************************************************/
/*! @brief Flash driver Structure */
flash_config_t s_flashDriver;
/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief erase number of  sectors of the flash
 */
uint8 EraseSectors(uint32 FlashStartAddress, uint32 NumberOfBytes)
{
  status_t result;    /* Return code from each flash driver function */
  
  result = FLASH_Erase(&s_flashDriver, (uint32_t)FlashStartAddress, NumberOfBytes, kFTFx_ApiEraseKey);
  if (kStatus_FTFx_Success != result)
  {
  }
  
  /* Verify sector if it's been erased. */
  result = FLASH_VerifyErase(&s_flashDriver, FlashStartAddress, NumberOfBytes, kFTFx_MarginValueUser);
  if (kStatus_FTFx_Success != result)
  {
  }
  
  return result;
} /* EndBody */




