/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef COMPORTDRIVER_H
#define COMPORTDRIVER_H

#include "common.h"
#include "Defines.h"
#include "Application.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define MAX_HDLC_PORTS_PER_CHANNEL      2
#define HDLC_PORT_P0       0
#define HDLC_PORT_P1       1

#define EOL                     0x0D
#define zUARTBUFFER             550

#define STX                     0x02
#define ETX                     0x03
#define EOT                     0x04
#define ACK                     0x06

#define MIN_IMAGE_SIZE          127
#define CUSTOM_IMAGE_TRANS_BLOCK_SIZE   128

#define IMAGE_BLOCK_SIZE      (128)
#define IMG_TX_MAX_IDENT_LEN  10			/* Maximum length for Image identification string */
#define IMG_TX_MAX_SIGN_LEN    12			/* Maximum length for Image signature string */
#define IMG_TX_MAX_IMAGE_SIZE (256*1025)	        /* Max Firmware size in bytes */
#define MAX_APDU_SIZE_RECV    256                       /* Size of COSEM Application layer input buffer.*/
#define IMG_TX_MAX_BLOCK_SIZE (MAX_APDU_SIZE_RECV - (24 + 21)) 
#define IMAGE_TRANSFREED_BLOCK_STATUS_SIZE_IN_BYTES     ((IMG_TX_MAX_IMAGE_SIZE/1025)*1024)/(IMAGE_BLOCK_SIZE*8)

typedef enum
{
  UART_ELEC_INDEX,
  UART_OPTICAL_INDEX,
  NUM_UART_CHANNEL
} UART_INDEX;

enum
{
  UART_TX,
  UART_RX,
};

typedef enum
{
  UART_IDLE,
  UART_RXING,
  UART_PROCESSING,
  UART_TXING
} UART_STATUS;

typedef enum
{
  UARTPROTOCOL_CUSTOM,
} UARTPROTOCOL;

typedef enum
{
  BATTCOMMS_IDLE,
  BATTCOMMS_ACTIVE,
  BATTCOMMS_OVER,
} BATTCOMMS;

enum
{
  /* 0 */ k_cmdunlock,
  /* 1 */ k_cmdgcsm,
  /* 2 */ k_cmdgsr, 
  /* 3 */ k_cmdgln, 
  /* 4 */ k_cmdgpcb,
  /* 5 */ k_cmdgnv256,
  /* 6 */ k_cmdgnv128,
  /* 7 */ k_cmdgnv16,
  /* 8 */ k_cmdginst,
  /* 9 */ k_cmdsmm, 
  /* 10 */ k_cmdssr, 
  /* 11 */ k_cmdsln, 
  /* 12 */ k_cmdspcb,
  /* 13 */ k_cmdgrtc,
  /* 14 */ k_cmdsrtc,
  /* 15 */ k_cmdmer, 
  /* 16 */ k_cmdscall,
  /* 17 */ k_cmdcalp,
  /* 18 */ k_cmdcaln,
  /* 19 */ k_cmddcal,
  /* 20 */ k_cmdrtccomps,
  /* 21 */ k_cmdrtccompg,
  /* FW upgrade specific */
  /* 22 */ k_cmdsignin,
  /* 23 */ k_cmdctompd,
  /* 24 */ k_cmdfwuinit,
  /* 25 */ k_cmdfwuhdr,
  /* 26 */ k_cmdfwutx,
  /* 27 */ k_cmdfwuver,
  /* 28 */ k_cmdfwuact,
  /* 29 */ k_cmdfwusts,
};

enum
{
  E_IMAGE_TS_NOT_INITIATED,
  E_IMAGE_TS_INITIATED,
  E_IMAGE_TS_VERIFICATION_INITIATED,
  E_IMAGE_TS_VERIFICATION_SUCCESSFUL,
  E_IMAGE_TS_VERIFICATION_FAILED,
  E_IMAGE_TS_ACTIVATION_INITIATED,
  E_IMAGE_TS_ACTIVATION_SUCCESSFUL,
  E_IMAGE_TS_ACTIVATION_FAILED,
};

typedef struct
{
  uint8 size;
  const char *cmd_string;
} sidecommand_t;

typedef struct
{
  uint32  Size;
  uint8 Identity[IMG_TX_MAX_IDENT_LEN ];
  uint16 IdentityLength;
  int8 Signature[ IMG_TX_MAX_SIGN_LEN ];
  uint16 SigLength;
} stImageToActivate;

typedef struct
{
  uint32 BlockSize ;
  stImageToActivate        ImageToActivateInfo;
  uint8                    ImageTransferStatus;
  uint32                   ImageFirstNotTransferredBlockNumber;
  uint32                   ActiveImageUTCTime;
  uint8                    ImageTransferredBlocksStatus[IMAGE_TRANSFREED_BLOCK_STATUS_SIZE_IN_BYTES];
}stImageTransfer;
/*******************************************************************************
* Prototypes
******************************************************************************/
extern volatile uint8  UartPortStatus[NUM_UART_CHANNEL];
extern uint8  UartProtocol[NUM_UART_CHANNEL];
extern uint16 UARTRxBufIndex[NUM_UART_CHANNEL];
extern uint16 UARTTxBufIndex[NUM_UART_CHANNEL];
extern uint16 UARTBytesToTx[NUM_UART_CHANNEL];
extern uint16 UARTTimeout[NUM_UART_CHANNEL];
extern uint8  MeterUnlocked;
extern uint8  UARTBuffer[zUARTBUFFER];
extern uint16 UartChkSumStartIndex;
extern uint16 UartChkSumEndIndex;
extern uint16 ChkSum;
extern const sidecommand_t metercommand[];
extern stImageTransfer imageTransfer;
extern uint16 DontCheckEOLCount;
extern uint16 DontCheckEOLTimeout;

void UART_Transmit_Optical(uint8* txBuff, uint16 txLength);
extern void Communication(void);

extern void UartModuleInit(void);
extern void DRxETx_UART_Optical(void);
extern void DTxERx_UART_Optical(void);
extern void UART_Transmit_Optical(uint8* txBuff, uint16 txLength);
#endif