/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef APPLICATION_H
#define APPLICATION_H

#include "common.h"
#include "appstructures.h"
#include "RTCDriver.h"
#include "MeteringLPRT.h"
#include "Calibration3Ph.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define VER_NO 0001u

typedef enum
{
  POWERMODE_RUN,               // Powered through mains
  POWERMODE_BAT,               // No current, only comms & LCD
} POWERMODES;

typedef struct
{
  uint32 BusClk;        /* Holds the Bus clock of the MCU */
  uint32 SysClk;        /* Holds the system clock of the MCU */
  uint8  PowerMode;     /* Holds the power mode of the meter */
} tSystemState;

extern tSystemState SystemState;
extern tMETERLIBLPRT3PH_DATA mlib3phdata;
extern tCalibPoint3Ph CalibPoint;
/*******************************************************************************
* Prototypes
******************************************************************************/
extern void InitModules(void);
extern void DoPulsing3Ph(void);
extern void ON_KWH_LED(void);
extern void OFF_KWH_LED(void);
extern void ON_KVARH_LED(void);
extern void OFF_KVARH_LED(void);
extern void SARADCCallback(void);
extern void TMR2callback(void);
extern void LLWU_Init(void);
#endif
