/*
 * Copyright (c) 2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "Defines.h"
#include "fsl_wdog.h"
#include "fsl_flash.h"
#include "EEPROMDriver.h"
#include "ComPortDriver.h"
#include "UserInterface.h"
#include "Timer.h"
#include "MeteringLPRT.h"
#include "MeteringInterface3Ph.h"
#include "Calibration3Ph.h"
#include "Application.h"
#include "RTCDriver.h"
#include "PowerModes.h"
#include "iic_config.h"
#include "IOControls.h"
#include "AppInterface.h"
#include "UpgradeFW.h"
#include "flash_FTFL.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define WDOG_WCT_INSTRUCITON_COUNT (256U)

/*******************************************************************************
* Prototypes
******************************************************************************/
#if defined(__ICCARM__)
  volatile uint8_t IRTC_BbRam[32] @0x40051000u;
#elif defined(__GNUC__)
  volatile uint8_t IRTC_BbRam[32] __attribute__((section(".RtcRamSection")));
#elif defined(__CC_ARM)
  volatile uint8_t IRTC_BbRam[32] __attribute__((section(".RtcRamSection")));
#endif

static void WaitWctClose(WDOG_Type *base);
/*******************************************************************************
 * Code
 ******************************************************************************/
static void WaitWctClose(WDOG_Type *base)
{
    /* Accessing register by bus clock */
    for (uint32_t i = 0; i < WDOG_WCT_INSTRUCITON_COUNT; i++)
    {
        (void)base->RSTCNT;
    }
}

/*!
 * @brief Initializes the Watch Dog module of the MCU and starts it.
 */
void WDOGModuleInit(void)
{
  wdog_config_t config;
  WDOG_GetDefaultConfig(&config);
  config.timeoutValue = 4000;
  WDOG_Init(WDOG, &config);
  WaitWctClose(WDOG);
}

/*!
* @brief Initializes flash driver components
*/
void InitializeFlash(void)
{
  /* Flash cache driver Structure */
  ftfx_cache_config_t s_cacheDriver;
  status_t result;    /* Return code from each flash driver function */
  uint32_t pflashBlockBase  = 0;
  uint32_t pflashTotalSize  = 0;
  uint32_t pflashSectorSize = 0;
  
  /* Clean up Flash, Cache driver Structure*/
  memset(&s_flashDriver, 0, sizeof(flash_config_t));
  memset(&s_cacheDriver, 0, sizeof(ftfx_cache_config_t));
  
  /* Setup flash driver structure for device and initialize variables. */
  result = FLASH_Init(&s_flashDriver);
  if (kStatus_FTFx_Success != result)
  {
  }
  
  /* Setup flash cache driver structure for device and initialize variables. */
  result = FTFx_CACHE_Init(&s_cacheDriver);
  if (kStatus_FTFx_Success != result)
  {
  }
  
  /* Get flash properties*/
  FLASH_GetProperty(&s_flashDriver, kFLASH_PropertyPflash0BlockBaseAddr, &pflashBlockBase);
  FLASH_GetProperty(&s_flashDriver, kFLASH_PropertyPflash0TotalSize, &pflashTotalSize);
  FLASH_GetProperty(&s_flashDriver, kFLASH_PropertyPflash0SectorSize, &pflashSectorSize);
}

