/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _CALIBRATION3PH_H        /* prevent duplicated includes*/
#define _CALIBRATION3PH_H

#include "types.h"
#include "Metering3Ph.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define CALIBACCUMCYCLES 12
#define CALIBDONE 0xDEADBEEF

#define CALIBLOCK 0xA5A5
  
typedef enum
{
  CALIB_R = 1 << V_R_PHASE,
  CALIB_Y = 1 << V_Y_PHASE,
  CALIB_B = 1 << V_B_PHASE,
  CALIB_N = 1 << I_N_PHASE
} CALIB_PHASES;

/** Updated Calibration Parameters, only during Factory Calibration */

typedef struct
{
  uint32 CalibStatus;                   /*!< Defines calibration status = 0xFFFFFFFF for phases, 0x0000FFFF for neutral */                     
                                   
  float VCoeff[nVPHASES];               /*!< Calibration Voltage coefficient for all phases */
  float ICoeff[nIPHASES];               /*!< Calibration Current coefficient for all phases */
  float ActPowerCoeff[nVPHASES];        /*!< Phase active power coefficient for all phases */
  float FrequencyCoeff;                 /*!< Frequency coefficient for calibration */
  float PhAngle[nVPHASES];              /*!< Phase error */
  /* Fundamental quantities */
  float VFCoeff[nVPHASES];              /*!< Calibration Voltage coefficient fundamental */
  float IFCoeff[nIPHASES];              /*!< Calibration Current coefficient fundamental */

  int8 RTCCompValue;                   /*!< RTC crystal compensation value */
  uint8 RTCCompInterval;                /*!< RTC crystal compensation interval */
  uint16 CRC;                           /*!< CRC */
}tCalibStruct3Ph;

typedef enum
{
  CALIB_SETUP,
  CALIB_ANGLEACCUMULATE,
  CALIB_ANGLEAPPLY,
  CALIB_ACCUMULATE,
  CALIB_APPLY,
  CALIB_MEMWRITE,
  CALIB_COMPLETE,
  CALIB_NEU_SETUP,
  CALIB_NEU_ACCUMULATE,
  CALIB_NEU_APPLY,
  CALIB_NEU_MEMWRITE,
  CALIB_NEU_COMPLETE,
} CALIBSTEPS;

typedef enum
{
  CALIBSTATE_IDLE,
  CALIBSTATE_PROGRESS,
  CALIBSTATE_COMPLETE
} CALIBSTATE;

typedef enum
{
  CALIBSTATE_NEU_IDLE = 0x10,
  CALIBSTATE_NEU_PROGRESS,
  CALIBSTATE_NEU_COMPLETE
} CALIBNEUSTATE;

typedef struct
{
  float VSum[nVPHASES];
  float ISum[nIPHASES];
  float VFSum[nVPHASES];
  float IFSum[nIPHASES];
  float ActPowerSums[nVPHASES];
  float PhAngle[nVPHASES];
  float Frequency;
} tCalibSums3Ph;

typedef struct
{
  float Voltage;        /*!< Calibration voltage - application to load */
  float Current;        /*!< Calibration current - application to load */
  float PhAngle;        /*!< Calibration Phase angle in radians - application to load */
  float PowerFactor;    /*!< Calibration voltage - application to load */
  float Frequency;      /*!< Calibration frequency - application to load */
} tCalibPoint3Ph;


/*******************************************************************************
* Prototypes
******************************************************************************/
extern uint8 CalibStep3Ph;
extern tCalibStruct3Ph CalibStruct3Ph;
extern tCalibSums3Ph CalibSums3Ph;
extern tCalibPoint3Ph CalibPoint3Ph;
extern void DoCalibration3Ph(tCalibPoint3Ph *calibpoint);
extern void InitCalibration(void);
extern void RestoreDefCalib(void);
extern uint8 ReadVerifyCalib(uint32 Address);

#endif /* _CALIBRATION3PH_H */
