/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdio.h>
#include <string.h>
#include <stdbool.h>

#include "board.h"
#include "pin_mux.h"
#include "fsl_debug_console.h"

#include "fsl_iocon.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/


/*!
 * @brief Main function
 */
int main(void)
{
    char ch;

    BOARD_InitPins();
    BOARD_BootClockPLL180M();
    BOARD_InitDebugConsole();

    PRINTF("\r\nhello world. build at %s, on %s.\r\n", __TIME__, __DATE__);

    while (1)
    {
        ch = GETCHAR();
        PUTCHAR(ch);
    }
}

#if 0
void NMI_Handler                (void) { PRINTF("isr NMI_Handler              .\r\n");  while (1); }
void HardFault_Handler          (void) { PRINTF("isr HardFault_Handler        .\r\n");  while (1); }
void MemManage_Handler          (void) { PRINTF("isr MemManage_Handler        .\r\n");  while (1); }
void BusFault_Handler           (void) { PRINTF("isr BusFault_Handler         .\r\n");  while (1); }
void UsageFault_Handler         (void) { PRINTF("isr UsageFault_Handler       .\r\n");  while (1); }
void SVC_Handler                (void) { PRINTF("isr SVC_Handler              .\r\n");  while (1); }
void DebugMon_Handler           (void) { PRINTF("isr DebugMon_Handler         .\r\n");  while (1); }
void PendSV_Handler             (void) { PRINTF("isr PendSV_Handler           .\r\n");  while (1); }
void SysTick_Handler            (void) { PRINTF("isr SysTick_Handler          .\r\n");  while (1); }
void WDT_BOD_IRQHandler         (void) { PRINTF("isr WDT_BOD_IRQHandler       .\r\n");  while (1); }
void DMA0_IRQHandler            (void) { PRINTF("isr DMA0_IRQHandler          .\r\n");  while (1); }
void GINT0_IRQHandler           (void) { PRINTF("isr GINT0_IRQHandler         .\r\n");  while (1); }
void GINT1_IRQHandler           (void) { PRINTF("isr GINT1_IRQHandler         .\r\n");  while (1); }
void PIN_INT0_IRQHandler        (void) { PRINTF("isr PIN_INT0_IRQHandler      .\r\n");  while (1); }
void PIN_INT1_IRQHandler        (void) { PRINTF("isr PIN_INT1_IRQHandler      .\r\n");  while (1); }
void PIN_INT2_IRQHandler        (void) { PRINTF("isr PIN_INT2_IRQHandler      .\r\n");  while (1); }
void PIN_INT3_IRQHandler        (void) { PRINTF("isr PIN_INT3_IRQHandler      .\r\n");  while (1); }
void UTICK0_IRQHandler          (void) { PRINTF("isr UTICK0_IRQHandler        .\r\n");  while (1); }
void MRT0_IRQHandler            (void) { PRINTF("isr MRT0_IRQHandler          .\r\n");  while (1); }
void CTIMER0_IRQHandler         (void) { PRINTF("isr CTIMER0_IRQHandler       .\r\n");  while (1); }
void CTIMER1_IRQHandler         (void) { PRINTF("isr CTIMER1_IRQHandler       .\r\n");  while (1); }
void SCT0_IRQHandler            (void) { PRINTF("isr SCT0_IRQHandler          .\r\n");  while (1); }
void CTIMER3_IRQHandler         (void) { PRINTF("isr CTIMER3_IRQHandler       .\r\n");  while (1); }
void FLEXCOMM0_IRQHandler       (void) { PRINTF("isr FLEXCOMM0_IRQHandler     .\r\n");  while (1); }
void FLEXCOMM1_IRQHandler       (void) { PRINTF("isr FLEXCOMM1_IRQHandler     .\r\n");  while (1); }
void FLEXCOMM2_IRQHandler       (void) { PRINTF("isr FLEXCOMM2_IRQHandler     .\r\n");  while (1); }
void FLEXCOMM3_IRQHandler       (void) { PRINTF("isr FLEXCOMM3_IRQHandler     .\r\n");  while (1); }
void FLEXCOMM4_IRQHandler       (void) { PRINTF("isr FLEXCOMM4_IRQHandler     .\r\n");  while (1); }
void FLEXCOMM5_IRQHandler       (void) { PRINTF("isr FLEXCOMM5_IRQHandler     .\r\n");  while (1); }
void FLEXCOMM6_IRQHandler       (void) { PRINTF("isr FLEXCOMM6_IRQHandler     .\r\n");  while (1); }
void FLEXCOMM7_IRQHandler       (void) { PRINTF("isr FLEXCOMM7_IRQHandler     .\r\n");  while (1); }
void ADC0_SEQA_IRQHandler       (void) { PRINTF("isr ADC0_SEQA_IRQHandler     .\r\n");  while (1); }
void ADC0_SEQB_IRQHandler       (void) { PRINTF("isr ADC0_SEQB_IRQHandler     .\r\n");  while (1); }
void ADC0_THCMP_IRQHandler      (void) { PRINTF("isr ADC0_THCMP_IRQHandler    .\r\n");  while (1); }
void DMIC0_IRQHandler           (void) { PRINTF("isr DMIC0_IRQHandler         .\r\n");  while (1); }
void HWVAD0_IRQHandler          (void) { PRINTF("isr HWVAD0_IRQHandler        .\r\n");  while (1); }
void USB0_NEEDCLK_IRQHandler    (void) { PRINTF("isr USB0_NEEDCLK_IRQHandler  .\r\n");  while (1); }
void USB0_IRQHandler            (void) { PRINTF("isr USB0_IRQHandler          .\r\n");  while (1); }
void RTC_IRQHandler             (void) { PRINTF("isr RTC_IRQHandler           .\r\n");  while (1); }
void Reserved46_IRQHandler      (void) { PRINTF("isr Reserved46_IRQHandler    .\r\n");  while (1); }
void Reserved47_IRQHandler      (void) { PRINTF("isr Reserved47_IRQHandler    .\r\n");  while (1); }
void PIN_INT4_IRQHandler        (void) { PRINTF("isr PIN_INT4_IRQHandler      .\r\n");  while (1); }
void PIN_INT5_IRQHandler        (void) { PRINTF("isr PIN_INT5_IRQHandler      .\r\n");  while (1); }
void PIN_INT6_IRQHandler        (void) { PRINTF("isr PIN_INT6_IRQHandler      .\r\n");  while (1); }
void PIN_INT7_IRQHandler        (void) { PRINTF("isr PIN_INT7_IRQHandler      .\r\n");  while (1); }
void CTIMER2_IRQHandler         (void) { PRINTF("isr CTIMER2_IRQHandler       .\r\n");  while (1); }
void CTIMER4_IRQHandler         (void) { PRINTF("isr CTIMER4_IRQHandler       .\r\n");  while (1); }
void RIT_IRQHandler             (void) { PRINTF("isr RIT_IRQHandler           .\r\n");  while (1); }
void SPIFI0_IRQHandler          (void) { PRINTF("isr SPIFI0_IRQHandler        .\r\n");  while (1); }
void FLEXCOMM8_IRQHandler       (void) { PRINTF("isr FLEXCOMM8_IRQHandler     .\r\n");  while (1); }
void FLEXCOMM9_IRQHandler       (void) { PRINTF("isr FLEXCOMM9_IRQHandler     .\r\n");  while (1); }
void SDIO_IRQHandler            (void) { PRINTF("isr SDIO_IRQHandler          .\r\n");  while (1); }
void CAN0_IRQ0_IRQHandler       (void) { PRINTF("isr CAN0_IRQ0_IRQHandler     .\r\n");  while (1); }
void CAN0_IRQ1_IRQHandler       (void) { PRINTF("isr CAN0_IRQ1_IRQHandler     .\r\n");  while (1); }
void CAN1_IRQ0_IRQHandler       (void) { PRINTF("isr CAN1_IRQ0_IRQHandler     .\r\n");  while (1); }
void CAN1_IRQ1_IRQHandler       (void) { PRINTF("isr CAN1_IRQ1_IRQHandler     .\r\n");  while (1); }
void USB1_IRQHandler            (void) { PRINTF("isr USB1_IRQHandler          .\r\n");  while (1); }
void USB1_NEEDCLK_IRQHandler    (void) { PRINTF("isr USB1_NEEDCLK_IRQHandler  .\r\n");  while (1); }
void ETHERNET_IRQHandler        (void) { PRINTF("isr ETHERNET_IRQHandler      .\r\n");  while (1); }
void ETHERNET_PMT_IRQHandler    (void) { PRINTF("isr ETHERNET_PMT_IRQHandler  .\r\n");  while (1); }
void ETHERNET_MACLP_IRQHandler  (void) { PRINTF("isr ETHERNET_MACLP_IRQHandler.\r\n");  while (1); }
void EEPROM_IRQHandler          (void) { PRINTF("isr EEPROM_IRQHandler        .\r\n");  while (1); }
void LCD_IRQHandler             (void) { PRINTF("isr LCD_IRQHandler           .\r\n");  while (1); }
void SHA_IRQHandler             (void) { PRINTF("isr SHA_IRQHandler           .\r\n");  while (1); }
void SMARTCARD0_IRQHandler      (void) { PRINTF("isr SMARTCARD0_IRQHandler    .\r\n");  while (1); }
void SMARTCARD1_IRQHandler      (void) { PRINTF("isr SMARTCARD1_IRQHandler    .\r\n");  while (1); }
#endif

/* EOF. */
