/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdio.h>
#include <string.h>
#include <stdbool.h>

#include "board.h"
#include "pin_mux.h"
#include "fsl_debug_console.h"

#include "fsl_iocon.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
void led_init(void);
void led_on(void);
void led_off(void);
void app_delay(void);

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/


/*!
 * @brief Main function
 */
int main(void)
{
    BOARD_InitPins();
    BOARD_BootClockPLL180M();
    BOARD_InitDebugConsole();

    PRINTF("\r\nblinky example. build at %s, on %s.\r\n", __TIME__, __DATE__);

    led_init();

    while (1)
    {
        led_on();
        app_delay();

        led_off();
        app_delay();
    }
}

void app_delay(void)
{
    uint32_t i, j;

    for (i = 0u; i < 100000u; i++)
    {
        for (j = 0u; j < 20u; j++)
        {
            asm("nop");
        }
    }
}

#include "fsl_power.h"
#include "fsl_iocon.h"
#include "fsl_gpio.h"

void led_init(void)
{
    /* clock. */
    CLOCK_EnableClock(kCLOCK_Gpio3);

    /* port. */
    uint32_t iocon_pin_config = IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE(1);
    IOCON_PinMuxSet(IOCON, 3u, 3u, iocon_pin_config); /* PORT3 PIN15 (coords: D2) is configured as SD_WR_PRT */

    /* gpio. */
    gpio_pin_config_t gpio_pin_config;
    gpio_pin_config.pinDirection = kGPIO_DigitalOutput;
    gpio_pin_config.outputLogic = 1u;
    GPIO_PinInit(GPIO, 3u, 3u, &gpio_pin_config);
}

void led_on(void)
{
    GPIO_PinWrite(GPIO, 3u, 3u, 0u);
}

void led_off(void)
{
    GPIO_PinWrite(GPIO, 3u, 3u, 1u);
}
/* EOF. */
