/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __UART_TO_HID_PROTOCOL_H__
#define __UART_TO_HID_PROTOCOL_H__

#include "stdint.h"
#include "mouse.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/

#define CMD_GET_INFO                 0x01U
#define CMD_SEND_KB_GENERAL_DATA     0x02U

/* Send absolute position of USB Mouse */
#define CMD_SEND_MS_ABS_DATA         0x04U
/* Send the relative position of USB Mouse */
#define CMD_SEND_MS_REL_DATA         0x05U

typedef struct _ch9329_uart_data_struct
{
    uint8_t header[2]; 
    uint8_t addr;
    uint8_t cmd;
    uint8_t length;
    uint8_t data[65]; /*64 bit data + 1 bit sum*/
    //uint8_t sum;   /* sum = header + addr + cmd + len + data */
} ch9329_uart_data_struct_t;

void uart_mouse_handle(ch9329_uart_data_struct_t * uart_hid_data);
void uart_to_hid_init(void);

/*******************************************************************************
 * API
 ******************************************************************************/

#endif /* __UART_TO_HID_PROTOCOL_H__ */
