/*
 * Copyright (c) 2015 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


//#include "core_cm4.h"
#include "MK20D10.h"
#include "fsl_uart.h"
#include "uart.h"
#include "uart_to_hid_protocol.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/



/*******************************************************************************
 * Prototypes
 ******************************************************************************/


/*******************************************************************************
 * Variables
 ******************************************************************************/



/*
  Ring buffer for data input and output, in this example, input data are saved
  to ring buffer in IRQ handler. The main function polls the ring buffer status,
  if there are new data, then send them out.
  Ring buffer full: (((rxIndex + 1) % DEMO_RING_BUFFER_SIZE) == txIndex)
  Ring buffer empty: (rxIndex == txIndex)
*/
uint8_t g_UartRxBuffer[72];
volatile uint16_t txIndex; /* Index of the data to send out. */
volatile uint16_t rxIndex; /* Index of the memory to save new arrived data. */

extern ch9329_uart_data_struct_t g_UartCmd;
uint8_t g_UartCmdHeaderFlag;
uint8_t g_UartFrameCompleteFlag;

/*******************************************************************************
 * Code
 ******************************************************************************/
void uart_init()
{
	  NVIC_DisableIRQ(UART1_RX_TX_IRQn);
    // enable clk PORTC
    SIM->SCGC5 |= SIM_SCGC5_PORTC_MASK;
    // enable clk uart
    SIM->SCGC4 |= SIM_SCGC4_UART1_MASK;

    // disable interrupt
    NVIC_DisableIRQ(UART1_RX_TX_IRQn);
    // transmitter and receiver disabled
    UART1->C2 &= ~(UART_C2_RE_MASK | UART_C2_TE_MASK);
    // disable interrupt
    UART1->C2 &= ~(UART_C2_RIE_MASK | UART_C2_TIE_MASK);
    
    //clear_buffers();

    // Enable receiver and transmitter
    UART1->C2 |= UART_C2_RE_MASK | UART_C2_TE_MASK;
    // alternate 3: UART1
    PORTC->PCR[3] = (3 << 8);
    PORTC->PCR[4] = (3 << 8);
    // Enable receive interrupt
    UART1->C2 |= UART_C2_RIE_MASK;
    NVIC_ClearPendingIRQ(UART1_RX_TX_IRQn);
    NVIC_EnableIRQ(UART1_RX_TX_IRQn);
    
}

void UART1_RX_TX_IRQHandler(void)
{
    uint8_t data;
    static uint8_t length = 0;
	  static uint8_t index = 0;

    /* If new data arrived. */
    if ((kUART_RxDataRegFullFlag | kUART_RxOverrunFlag) & UART_GetStatusFlags(UART1))
    {
        data = UART_ReadByte(UART1);
			
			  g_UartRxBuffer[index++] = data;
			
			  /* If the uart frame header has not appeared */
			  if (!g_UartCmdHeaderFlag)
				{
					  if (data == 0x57)
						{
							  g_UartRxBuffer[0] = data;
							  g_UartFrameCompleteFlag = 0;
							  index = 1;
						}
						if (data == 0xAB)
						{
							  g_UartRxBuffer[1] = data;
							  index = 2;
							  /* Uart frame header appeared */
							  g_UartCmdHeaderFlag = 1;
						}
							
				}
				else
				{
					  if((index-1) == 4)
						{
							  length = g_UartRxBuffer[4];
						}
					  if(index > 5 && ((length + 6)== index) )
						{
							  /* Received a complete uart cmd frame */
							  g_UartFrameCompleteFlag = 1; 
							  memcpy(&g_UartCmd,&g_UartRxBuffer[0], (length + 6));
							  uart_mouse_handle(&g_UartCmd);
							  g_UartCmdHeaderFlag = 0;
							  index = 0;
							  length = 0; 
						}
				}
				if(g_UartFrameCompleteFlag == 1 || index > 13)
				{
					  index = 0;
					  length = 0;
					  memset(g_UartRxBuffer, 0, sizeof(g_UartRxBuffer));
				}
				
			
    }
}

