#ifndef __BOARD_USART_H_
#define __BOARD_USART_H_

#include "fsl_common.h"

extern uint8_t  recvFlagFromUSART0;
extern uint8_t  recvDataFromUSART0;
extern uint8_t  recvFlagFromUSART1;
extern uint8_t  recvDataFromUSART1;
extern int32_t  recvDataUsartID;

/*!
 * brief get USART channel number
 * param void
 * return int8_t->USART channel number
 */
extern int8_t getUSARTChannelNum(void);
 
/*!
 * brief USART initialization
 * param void
 * return void
 */
extern void BOARD_UsartInit(void);

/*!
 * brief USART send data saved in buffer
 * param USART_Type *base->USART peripheral base address
 * param uint8_t* p_dataBuf->pointer to buffer for data to be send
 * param uint32_t dataLengh->data length to be send
 * return void
 */
extern void BOARD_UsartSendData(USART_Type *base, uint8_t* p_dataBuf, uint32_t dataLengh);

#endif
