#include "fsl_ctimer.h"
#include "fsl_gpio.h"
#include "spi_to_dual_usart_bridge.h"

//function declaration for ctimer match0 callback
void ctimer_match0_callback(uint32_t flags);

//Array of function pointers for callback for each channel
ctimer_callback_t ctimer_callback_table[] = 
{
	ctimer_match0_callback, 
	NULL, 
	NULL, 
	NULL, 
	NULL, 
	NULL, 
	NULL, 
	NULL
};

/*!
 * brief  enable software watchdog
 * param  void
 * return void
 */
void enableSoftWDT(void)
{
	//Start ctimer
	CTIMER_StartTimer(CTIMER0);
}

/*!
 * brief  disable software watchdog
 * param  void
 * return void
 */
void disableSoftWDT(void)
{
	//Stop ctimer
	CTIMER_StopTimer(CTIMER0);
}


/*!
 * brief  feed software watchdog
 * param  void
 * return void
 */
void feedSoftWDT(void)
{
	//reset ctimer
	CTIMER_Reset(CTIMER0);
}

/*!
 * brief  ctimer match0 callback
 * param  uint32_t flags->flag
 * return void
 */
void ctimer_match0_callback(uint32_t flags)
{
	//Stop ctimer
	CTIMER_StopTimer(CTIMER0);
	//set transfer timeout flag
	setTransferTimeOutFlag();
}

/*!
 * brief  configure software watchdog
 * param  void
 * return void
 */
void BOARD_ConfigSoftWDT(void)
{
	//ctimer configuration structure
	ctimer_config_t config;
	//match configuration for channel 0
  ctimer_match_config_t matchConfig0;
		
	//fills in the timer's configuration structure with the default settings
	CTIMER_GetDefaultConfig(&config);
	//Ungates the clock and configures the peripheral for basic operation
	CTIMER_Init(CTIMER0, &config);

	//match configuration for channel 0
	matchConfig0.enableCounterReset = true;
	matchConfig0.enableCounterStop  = false;
	matchConfig0.matchValue         = CLOCK_GetFreq(kCLOCK_CoreSysClk)/20;
	matchConfig0.outControl         = kCTIMER_Output_NoAction;
	matchConfig0.outPinInitState    = false;
	matchConfig0.enableInterrupt    = true;
	//Register callback
	CTIMER_RegisterCallBack(CTIMER0, &ctimer_callback_table[0], kCTIMER_SingleCallback);
	//Setup the match register.
	CTIMER_SetupMatch(CTIMER0, kCTIMER_Match_0, &matchConfig0);
	//Stop ctimer
	CTIMER_StopTimer(CTIMER0);
}
