'''
* Copyright 2020 NXP
* All rights reserved.
*
* SPDX-License-Identifier: BSD-3-Clause
'''

import tensorflow as tf
import argparse

def load_graph(frozen_graph_filename):
    with tf.gfile.GFile(frozen_graph_filename, "rb") as f:
        graph_def = tf.GraphDef()
        graph_def.ParseFromString(f.read())

    with tf.Graph().as_default() as graph:
        tf.import_graph_def(graph_def, name="prefix")
    return graph

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--pbfile', type=str, default=\
                        "file.pb",
                        help='Get protocol buffer file (.pb)')
    cmd_args, _ = parser.parse_known_args()
    pbfileName = cmd_args.pbfile
    graph = load_graph(pbfileName)
    for op in graph.get_operations():
        layerName = graph.get_tensor_by_name(op.name + ":0")
        print(layerName)
