/*********************************Header File********************************************************/
#include "BLDC_gpio.h"
/*********************************Header File********************************************************/

/*********************************Function definition************************************************/
/*****************************************************************************
+FUNCTION----------------------------------------------------------------
* @function name: GPIO_Configuration
*
* @brief   The function is used to initialize IO pin function.
*        
* @param  none
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/
void GPIO_Configuration(void)
{
  /******************GPIO input and output structure definition***************************/
  //Define the init structure for the output pin
  gpio_pin_config_t output_config = 
  {
    kGPIO_DigitalOutput,
    0,
  };
  //Define the init structure for the input pin
  gpio_pin_config_t input_config =
  {
    kGPIO_DigitalInput,
    0,
  };
  /******************GPIO input and output structure definition***************************/
  
  /******************Enable clock and Reset for GPIO port 0 and port 1********************/
  //Enable clock for GPIO0
  CLOCK_EnableClock(kCLOCK_Gpio0);
  //Enable clock for GPIO1
  CLOCK_EnableClock(kCLOCK_Gpio1);
  //Reset GPIO0, GPIO1 including assert reset and then clear reset
  RESET_PeripheralReset(kGPIO0_RST_SHIFT_RSTn);
  RESET_PeripheralReset(kGPIO1_RST_SHIFT_RSTn);
  /******************Enable clock and Reset for GPIO port 0 and port 1********************/
    
  /******************Set pins connected to hall sensor phase A,B,C output as input********/
  //set P0_2 as input,P0_2 is connected to Hall sensor phase A 
  GPIO_PinInit(GPIO, GPIO_PORT_0, 2, &input_config);
  //set P0_3 as input,P0_3 is connected to Hall sensor phase B
  GPIO_PinInit(GPIO, GPIO_PORT_0, 3, &input_config);
  //set P0_5 as input,P0_5 is connected to Hall sensor phase C 
  GPIO_PinInit(GPIO, GPIO_PORT_0, 5, &input_config);
  /******************Set pins connected to hall sensor phase A,B,C output as input********/
  
  /******************Set pin used for SCT interrupt***************************************/
  //set P0_6 as output, P0_6 is used as SCT interrupt source
  GPIO_PinInit(GPIO, GPIO_PORT_0, 6, &output_config);
  /******************Set pin used for SCT interrupt***************************************/
  
  /******************Set pins connected to SCTimer PWM out as output**********************/
  //set P0_7 as output, P0_7 is also used as SCT0_OUT0
  GPIO_PinInit(GPIO, GPIO_PORT_0, 7, &output_config);
  //set P0_8 as output, P0_8 is also used as SCT0_OUT1
  GPIO_PinInit(GPIO, GPIO_PORT_0, 8, &output_config);
  //set P0_9 as output, P0_9 is also used as SCT0_OUT2
  GPIO_PinInit(GPIO, GPIO_PORT_0, 9, &output_config);
  //set P0_10 as output, P0_10 is also used as SCT0_OUT3
  GPIO_PinInit(GPIO, GPIO_PORT_0, 10, &output_config);
  //set P1_2 as output, P1_2 is also used as SCT0_OUT5
  GPIO_PinInit(GPIO, GPIO_PORT_1, 2, &output_config);
  //set P1_3 as output, P1_3 is also used as SCT0_OUT6
  GPIO_PinInit(GPIO, GPIO_PORT_1, 3, &output_config);
  /******************Set pins connected to SCTimer PWM out as output**********************/
  
   /******************Set pin used for debugging*********************************************/
  //set P0_21 as output, P0_21 is used to indicate ADC isr begin and end
  GPIO_PinInit(GPIO, GPIO_PORT_0, 21, &output_config);
  /******************Set pin used for debugging*********************************************/
  
  //set P0_23 as input,P0_23 is connected to SCT input 0
  GPIO_PinInit(GPIO, GPIO_PORT_0, 23, &input_config);
  
  /******************Clear all pins for SCTimer PWM output**********************************/
  GPIO_PinWrite(GPIO, GPIO_PORT_0, 7,  0);
  GPIO_PinWrite(GPIO, GPIO_PORT_0, 8,  0);
  GPIO_PinWrite(GPIO, GPIO_PORT_0, 9,  0);
  GPIO_PinWrite(GPIO, GPIO_PORT_0, 10, 0);
  GPIO_PinWrite(GPIO, GPIO_PORT_1, 2, 0);
  GPIO_PinWrite(GPIO, GPIO_PORT_1, 3,  0);
  /******************Clear all pins for SCTimer PWM output**********************************/
  
  /******************Clear pin for SCT interrupt********************************************/
  GPIO_PinWrite(GPIO, GPIO_PORT_0, 6,  0);
  /******************Clear pin for SCT interrupt********************************************/
}
/*********************************Function definition************************************************/