/* glitch_filter.c */
#include "glitch_filter.h"

void glitch_filter_init(glitch_filter_handler_t *handler, int32_t init_value, uint32_t filter_level)
{
    /* For Attr. */
    handler->filter_level_max = filter_level-1U;

    /* For Static. */
    handler->init_value = init_value;
    handler->stable_output = init_value;
    handler->new_output = init_value;
    handler->filter_level_count = 1U;
}


int32_t glitch_filter_output(glitch_filter_handler_t *handler, int32_t input_raw)
{
    /* 如果滤波器的输入值同当前输出值相等，则各内部状态机相安无事，直接输出。否则，开始准备更新内部状态 */
    if (input_raw != handler->stable_output)
    {
        if (input_raw != handler->new_output)
        {
            handler->new_output = input_raw;
            handler->filter_level_count = 1u; /* 计数器开始计数 */
        }
        else /* input_raw == handler->new_output */
        {
            if (handler->filter_level_count < handler->filter_level_max)
            {
                handler->filter_level_count++; /* 积攒能量准备突破 */
            }
            else /* (handler->filter_level_count >= handler->filter_level_max) */
            {
                handler->stable_output = handler->new_output; /* 成功突破封锁线 */
            }
        }
    }
    return handler->stable_output;
}

/* EOF. */

