# NXP KL16Z Touch 2D EVK board (WPI)

[TOC]

## Pins

1. Touch

| Touch 2d | TSI channel | PORT pin |
| -------- | ----------- | -------- |
| R0       | TSI_CH2     | PTA1     |
| R1       | TSI_CH3     | PTA2     |
| R2       | TSI_CH0     | PTB0     |
| R3       | TSI_CH6     | PTB1     |
| R4       | TSI_CH7     | PTB2     |
| C0       | TSI_CH8     | PTB3     |
| C1       | TSI_CH9     | PTB16    |
| C2       | TSI_CH10    | PTB17    |
| C3       | TSI_CH13    | PTC0     |
| C4       | TSI_CH14    | PTC1     |
| Shield   | TSI_CH15    | PTC2     |

2. UART Comm

| UART Comm | UART Signal | PORT pin   |
| --------- | ----------- | ---------- |
| UART_RX   | UART0_RX    | PTD6(ALT3) |
| UART_TX   | UART0_TX    | PTD7(ALT3) |

3. I2C Comm

| I2C Comm | I2C Signal | PORT pin    |
| -------- | ---------- | ----------- |
| I2C_SDA  | I2C0_SDA   | PTE18(ALT4) |
| I2C_SCL  | I2C0_SCL   | PTE19(ALT4) |
| I2C_INTn | GPIO_out   | PTE17(ALT1) |

## Projects

- \application\hello_world
The basic example for board to print "hello, world" through the on-board USB-TTL chip. This is a startup for debugging the board, so that developer can use UART terminal to communicate with MCU.

- \application\touch_basic
The basic example for using touch function. In this project, the application deals with the conversion and get the touch sensing value of touch pads, and show them in the GUI based on FreeMASTER tool. The sensing values can be displayed through the UART terminal if developer would not like to setup the FreeMASTER tool.

- \application\touch_2d
This project enables the 2D position algorithm. The linear position values for X and Y axis are calculated from each 5 channels' sensing values. The UART terminal is not enabled in this project. Only the FreeMASTER GUI would show the position values for X and Y in real time.

- \application\touch_2d_led
This project enables the LEDs based on the "touch_2d" project. it looks more like a demo, since it enables the LEDs to show the positions with no wire connection between the board and the PC (like UART terminal or FreeMASTER with debugger).

- \application\touch_2d_i2c_slave
This project enables the i2c slave function based on the "touch_2d_led" project. It makes the board as a I2C slave device, with a 7-bit slave address "0x02". The I2C master can read its first register's value as X position, and 2nd register's value as Y position. I2C_INTn would be low when there is an available touch position, while high for no touch. I2C master can always read the most recent available touch position.
