/*******************************************************************************
*
* E M B E D D E D   W I Z A R D   P R O J E C T
*
*                                                Copyright (c) TARA Systems GmbH
*                                    written by Paul Banach and Manfred Schweyer
*
********************************************************************************
*
* This file was generated automatically by Embedded Wizard Studio.
*
* Please do not make any modifications of this file! The modifications are lost
* when the file is generated again by Embedded Wizard Studio!
*
* The template of this heading text can be found in the file 'head.ewt' in the
* directory 'Platforms' of your Embedded Wizard installation directory. If you
* wish to adapt this text, please copy the template file 'head.ewt' into your
* project directory and edit the copy only. Please avoid any modifications of
* the original template file!
*
* Version  : 9.20
* Profile  : Profile
* Platform : NXP.iMX_RT.RGBA8888
*
*******************************************************************************/

#include <mnist_dataset.h>
#include "ewlocale.h"
#include "_ApplicationApplication.h"
#include "_CoreSimpleTouchHandler.h"
#include "_CoreView.h"
#include "_GraphicsCanvas.h"
#include "_ResourcesBitmap.h"
#include "_ResourcesFont.h"
#include "_ViewsBorder.h"
#include "_ViewsImage.h"
#include "_ViewsRectangle.h"
#include "_ViewsText.h"
#include "_WidgetSetPushButton.h"
#include "_WidgetSetPushButtonConfig.h"
#include "Application.h"
#include "Core.h"
#include "CustomConstants.h"
#include "Resources.h"
#include "WidgetSet.h"

#include "stdlib.h"
#include "fsl_debug_console.h"
#include <stdio.h>

/* Compressed strings for the language 'Default'. */
static const unsigned int _StringsDefault0[] =
{
  0x0000005C, /* ratio 91.30 % */
  0xB8002900, 0x40C00452, 0x24005200, 0x40054001, 0x010C1041, 0x00087120, 0x550013A2,
  0x20013400, 0x83426284, 0x04160605, 0x8020C300, 0x0E0D2204, 0x4006C001, 0x00610019,
  0x20A931C8, 0x00298025, 0x031000EA, 0x34800DA0, 0x1C98E800, 0x0000101A, 0x00000000
};

/* Constant values used in this 'C' module only. */
static const XRect _Const0000 = {{ 0, 0 }, { 480, 270 }};
static const XPoint _Const0001 = { 112, 112 };
static const XRect _Const0002 = {{ 4, 80 }, { 116, 192 }};
static const XPoint _Const0003 = { 4, 80 };
static const XPoint _Const0004 = { 116, 80 };
static const XPoint _Const0005 = { 116, 192 };
static const XPoint _Const0006 = { 4, 192 };
static const XRect _Const0007 = {{ 2, 78 }, { 118, 194 }};
static const XRect _Const0008 = {{ 124, 80 }, { 236, 192 }};
static const XPoint _Const0009 = { 124, 80 };
static const XPoint _Const000A = { 236, 80 };
static const XPoint _Const000B = { 236, 192 };
static const XPoint _Const000C = { 124, 192 };
static const XRect _Const000D = {{ 122, 78 }, { 238, 194 }};
static const XRect _Const000E = {{ 244, 80 }, { 356, 192 }};
static const XPoint _Const000F = { 244, 80 };
static const XPoint _Const0010 = { 356, 80 };
static const XPoint _Const0011 = { 356, 192 };
static const XPoint _Const0012 = { 244, 192 };
static const XRect _Const0013 = {{ 242, 78 }, { 358, 194 }};
static const XRect _Const0014 = {{ 364, 80 }, { 476, 192 }};
static const XColor _Const0015 = { 0xFF, 0xFF, 0xFF, 0xFF };
static const XPoint _Const0016 = { 364, 80 };
static const XPoint _Const0017 = { 476, 80 };
static const XPoint _Const0018 = { 476, 192 };
static const XPoint _Const0019 = { 364, 192 };
static const XRect _Const001A = {{ 362, 78 }, { 478, 194 }};
static const XRect _Const001B = {{ 140, 6 }, { 340, 40 }};
static const XStringRes _Const001C = { _StringsDefault0, 0x0003 };
static const XRect _Const001D = {{ 227, 36 }, { 253, 72 }};
static const XStringRes _Const001E = { _StringsDefault0, 0x0017 };
static const XRect _Const001F = {{ 242, 208 }, { 392, 258 }};
static const XStringRes _Const0020 = { _StringsDefault0, 0x001C };
static const XRect _Const0021 = {{ 90, 208 }, { 240, 258 }};
static const XStringRes _Const0022 = { _StringsDefault0, 0x0025 };
static int next_digit = -1;

/* Initializer for the class 'Application::Application' */
void ApplicationApplication__Init( ApplicationApplication _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreRoot__Init( &_this->_Super, aLink, aArg );

  /* ... then construct all embedded objects */
  ViewsRectangle__Init( &_this->Rectangle, &_this->_XObject, 0 );
  GraphicsCanvas__Init( &_this->InputCanvas, &_this->_XObject, 0 );
  ViewsImage__Init( &_this->InputImage, &_this->_XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleInputTouchHandler, &_this->_XObject, 0 );
  ViewsBorder__Init( &_this->InputBorder, &_this->_XObject, 0 );
  ViewsImage__Init( &_this->InputImage1, &_this->_XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleInputTouchHandler1, &_this->_XObject, 0 );
  ViewsBorder__Init( &_this->InputBorder1, &_this->_XObject, 0 );
  ViewsImage__Init( &_this->InputImage2, &_this->_XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleInputTouchHandler2, &_this->_XObject, 0 );
  ViewsBorder__Init( &_this->InputBorder2, &_this->_XObject, 0 );
  ViewsImage__Init( &_this->InputImage3, &_this->_XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleInputTouchHandler3, &_this->_XObject, 0 );
  ViewsBorder__Init( &_this->InputBorder3, &_this->_XObject, 0 );
  GraphicsCanvas__Init( &_this->InputCanvas1, &_this->_XObject, 0 );
  GraphicsCanvas__Init( &_this->InputCanvas2, &_this->_XObject, 0 );
  GraphicsCanvas__Init( &_this->InputCanvas3, &_this->_XObject, 0 );
  ViewsText__Init( &_this->Text, &_this->_XObject, 0 );
  ViewsText__Init( &_this->TextNextNumber, &_this->_XObject, 0 );
  WidgetSetPushButton__Init( &_this->PushButtonClear, &_this->_XObject, 0 );
  WidgetSetPushButton__Init( &_this->PushButtonSubmit, &_this->_XObject, 0 );

  /* Setup the VMT pointer */
  _this->_VMT = EW_CLASS( ApplicationApplication );

  /* ... and initialize objects, variables, properties, etc. */
  CoreRectView__OnSetBounds( _this, _Const0000 );
  CoreRectView__OnSetBounds( &_this->Rectangle, _Const0000 );
  ViewsRectangle_OnSetColorBL( &_this->Rectangle, CustomConstantsbackground_color );
  ViewsRectangle_OnSetColorBR( &_this->Rectangle, CustomConstantsbackground_color );
  ViewsRectangle_OnSetColorTR( &_this->Rectangle, CustomConstantsbackground_color );
  ViewsRectangle_OnSetColorTL( &_this->Rectangle, CustomConstantsbackground_color );
  ViewsRectangle_OnSetColor( &_this->Rectangle, CustomConstantsbackground_color );
  ResourcesBitmap__OnSetFrameSize( &_this->InputCanvas, _Const0001 );
  CoreRectView__OnSetBounds( &_this->InputImage, _Const0002 );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleInputTouchHandler, _Const0003 );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleInputTouchHandler, _Const0004 );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleInputTouchHandler, _Const0005 );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleInputTouchHandler, _Const0006 );
  CoreRectView__OnSetBounds( &_this->InputBorder, _Const0007 );
  ViewsBorder_OnSetColorBL( &_this->InputBorder, CustomConstantsmain_color );
  ViewsBorder_OnSetColorBR( &_this->InputBorder, CustomConstantsmain_color );
  ViewsBorder_OnSetColorTR( &_this->InputBorder, CustomConstantsmain_color );
  ViewsBorder_OnSetColorTL( &_this->InputBorder, CustomConstantsmain_color );
  ViewsBorder_OnSetColor( &_this->InputBorder, CustomConstantsmain_color );
  CoreRectView__OnSetBounds( &_this->InputImage1, _Const0008 );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleInputTouchHandler1, _Const0009 );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleInputTouchHandler1, _Const000A );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleInputTouchHandler1, _Const000B );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleInputTouchHandler1, _Const000C );
  CoreRectView__OnSetBounds( &_this->InputBorder1, _Const000D );
  ViewsBorder_OnSetColorBL( &_this->InputBorder1, CustomConstantsmain_color );
  ViewsBorder_OnSetColorBR( &_this->InputBorder1, CustomConstantsmain_color );
  ViewsBorder_OnSetColorTR( &_this->InputBorder1, CustomConstantsmain_color );
  ViewsBorder_OnSetColorTL( &_this->InputBorder1, CustomConstantsmain_color );
  ViewsBorder_OnSetColor( &_this->InputBorder1, CustomConstantsmain_color );
  CoreRectView__OnSetBounds( &_this->InputImage2, _Const000E );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleInputTouchHandler2, _Const000F );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleInputTouchHandler2, _Const0010 );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleInputTouchHandler2, _Const0011 );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleInputTouchHandler2, _Const0012 );
  CoreRectView__OnSetBounds( &_this->InputBorder2, _Const0013 );
  ViewsBorder_OnSetColorBL( &_this->InputBorder2, CustomConstantsmain_color );
  ViewsBorder_OnSetColorBR( &_this->InputBorder2, CustomConstantsmain_color );
  ViewsBorder_OnSetColorTR( &_this->InputBorder2, CustomConstantsmain_color );
  ViewsBorder_OnSetColorTL( &_this->InputBorder2, CustomConstantsmain_color );
  ViewsBorder_OnSetColor( &_this->InputBorder2, CustomConstantsmain_color );
  CoreRectView__OnSetBounds( &_this->InputImage3, _Const0014 );
  ViewsImage_OnSetColorBL( &_this->InputImage3, _Const0015 );
  ViewsImage_OnSetColorBR( &_this->InputImage3, _Const0015 );
  ViewsImage_OnSetColorTR( &_this->InputImage3, _Const0015 );
  ViewsImage_OnSetColorTL( &_this->InputImage3, _Const0015 );
  ViewsImage_OnSetColor( &_this->InputImage3, _Const0015 );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleInputTouchHandler3, _Const0016 );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleInputTouchHandler3, _Const0017 );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleInputTouchHandler3, _Const0018 );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleInputTouchHandler3, _Const0019 );
  CoreRectView__OnSetBounds( &_this->InputBorder3, _Const001A );
  ViewsBorder_OnSetColorBL( &_this->InputBorder3, CustomConstantsmain_color );
  ViewsBorder_OnSetColorBR( &_this->InputBorder3, CustomConstantsmain_color );
  ViewsBorder_OnSetColorTR( &_this->InputBorder3, CustomConstantsmain_color );
  ViewsBorder_OnSetColorTL( &_this->InputBorder3, CustomConstantsmain_color );
  ViewsBorder_OnSetColor( &_this->InputBorder3, CustomConstantsmain_color );
  ResourcesBitmap__OnSetFrameSize( &_this->InputCanvas1, _Const0001 );
  ResourcesBitmap__OnSetFrameSize( &_this->InputCanvas2, _Const0001 );
  ResourcesBitmap__OnSetFrameSize( &_this->InputCanvas3, _Const0001 );
  CoreRectView__OnSetBounds( &_this->Text, _Const001B );
  ViewsText_OnSetString( &_this->Text, EwLoadString( &_Const001C ));
  CoreRectView__OnSetBounds( &_this->TextNextNumber, _Const001D );
  ViewsText_OnSetString( &_this->TextNextNumber, EwLoadString( &_Const001E ));
  CoreRectView__OnSetBounds( &_this->PushButtonClear, _Const001F );
  WidgetSetPushButton_OnSetLabel( &_this->PushButtonClear, EwLoadString( &_Const0020 ));
  CoreRectView__OnSetBounds( &_this->PushButtonSubmit, _Const0021 );
  WidgetSetPushButton_OnSetLabel( &_this->PushButtonSubmit, EwLoadString( &_Const0022 ));
  CoreGroup__Add( _this, ((CoreView)&_this->Rectangle ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->InputImage ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->SimpleInputTouchHandler ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->InputBorder ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->InputImage1 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->SimpleInputTouchHandler1 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->InputBorder1 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->InputImage2 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->SimpleInputTouchHandler2 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->InputBorder2 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->InputImage3 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->SimpleInputTouchHandler3 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->InputBorder3 ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->Text ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->TextNextNumber ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->PushButtonClear ), 0 );
  CoreGroup__Add( _this, ((CoreView)&_this->PushButtonSubmit ), 0 );
  ViewsImage_OnSetBitmap( &_this->InputImage, ((ResourcesBitmap)&_this->InputCanvas ));
  _this->SimpleInputTouchHandler.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag );
  ViewsImage_OnSetBitmap( &_this->InputImage1, ((ResourcesBitmap)&_this->InputCanvas1 ));
  _this->SimpleInputTouchHandler1.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag1 );
  ViewsImage_OnSetBitmap( &_this->InputImage2, ((ResourcesBitmap)&_this->InputCanvas2 ));
  _this->SimpleInputTouchHandler2.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag2 );
  ViewsImage_OnSetBitmap( &_this->InputImage3, ((ResourcesBitmap)&_this->InputCanvas3 ));
  _this->SimpleInputTouchHandler3.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag3 );
  ViewsText_OnSetFont( &_this->Text, EwLoadResource( &ResourcesFontMedium, ResourcesFont ));
  ViewsText_OnSetFont( &_this->TextNextNumber, EwLoadResource( &ResourcesFontLarge, 
  ResourcesFont ));
  _this->PushButtonClear.OnPress = EwNewSlot( _this, ApplicationApplication_onPushClear );
  WidgetSetPushButton_OnSetAppearance( &_this->PushButtonClear, EwGetAutoObject( 
  &WidgetSetPushButton_Medium, WidgetSetPushButtonConfig ));
  _this->PushButtonSubmit.OnPress = EwNewSlot( _this, ApplicationApplication_onPushSubmit );
  WidgetSetPushButton_OnSetAppearance( &_this->PushButtonSubmit, EwGetAutoObject( 
  &WidgetSetPushButton_Medium, WidgetSetPushButtonConfig ));

  /* Call the user defined constructor */
  ApplicationApplication_Init( _this, aArg );
}

/* Re-Initializer for the class 'Application::Application' */
void ApplicationApplication__ReInit( ApplicationApplication _this )
{
  /* At first re-initialize the super class ... */
  CoreRoot__ReInit( &_this->_Super );

  /* ... then re-construct all embedded objects */
  ViewsRectangle__ReInit( &_this->Rectangle );
  GraphicsCanvas__ReInit( &_this->InputCanvas );
  ViewsImage__ReInit( &_this->InputImage );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleInputTouchHandler );
  ViewsBorder__ReInit( &_this->InputBorder );
  ViewsImage__ReInit( &_this->InputImage1 );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleInputTouchHandler1 );
  ViewsBorder__ReInit( &_this->InputBorder1 );
  ViewsImage__ReInit( &_this->InputImage2 );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleInputTouchHandler2 );
  ViewsBorder__ReInit( &_this->InputBorder2 );
  ViewsImage__ReInit( &_this->InputImage3 );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleInputTouchHandler3 );
  ViewsBorder__ReInit( &_this->InputBorder3 );
  GraphicsCanvas__ReInit( &_this->InputCanvas1 );
  GraphicsCanvas__ReInit( &_this->InputCanvas2 );
  GraphicsCanvas__ReInit( &_this->InputCanvas3 );
  ViewsText__ReInit( &_this->Text );
  ViewsText__ReInit( &_this->TextNextNumber );
  WidgetSetPushButton__ReInit( &_this->PushButtonClear );
  WidgetSetPushButton__ReInit( &_this->PushButtonSubmit );
}

/* Finalizer method for the class 'Application::Application' */
void ApplicationApplication__Done( ApplicationApplication _this )
{
  /* Finalize this class */
  _this->_VMT = EW_CLASS( ApplicationApplication );

  /* Finalize all embedded objects */
  ViewsRectangle__Done( &_this->Rectangle );
  GraphicsCanvas__Done( &_this->InputCanvas );
  ViewsImage__Done( &_this->InputImage );
  CoreSimpleTouchHandler__Done( &_this->SimpleInputTouchHandler );
  ViewsBorder__Done( &_this->InputBorder );
  ViewsImage__Done( &_this->InputImage1 );
  CoreSimpleTouchHandler__Done( &_this->SimpleInputTouchHandler1 );
  ViewsBorder__Done( &_this->InputBorder1 );
  ViewsImage__Done( &_this->InputImage2 );
  CoreSimpleTouchHandler__Done( &_this->SimpleInputTouchHandler2 );
  ViewsBorder__Done( &_this->InputBorder2 );
  ViewsImage__Done( &_this->InputImage3 );
  CoreSimpleTouchHandler__Done( &_this->SimpleInputTouchHandler3 );
  ViewsBorder__Done( &_this->InputBorder3 );
  GraphicsCanvas__Done( &_this->InputCanvas1 );
  GraphicsCanvas__Done( &_this->InputCanvas2 );
  GraphicsCanvas__Done( &_this->InputCanvas3 );
  ViewsText__Done( &_this->Text );
  ViewsText__Done( &_this->TextNextNumber );
  WidgetSetPushButton__Done( &_this->PushButtonClear );
  WidgetSetPushButton__Done( &_this->PushButtonSubmit );

  /* Don't forget to deinitialize the super class ... */
  CoreRoot__Done( &_this->_Super );
}

/* The method Init() is invoked automatically after the component has been created. 
   This method can be overridden and filled with logic containing additional initialization 
   statements. */
void ApplicationApplication_Init( ApplicationApplication _this, XHandle aArg )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( aArg );

  GraphicsCanvas_FillRectangle( &_this->InputCanvas, EwGetRectORect( _this->InputImage.Super1.Bounds ), 
  EwGetRectORect( _this->InputImage.Super1.Bounds ), CustomConstantsbackground_color, 
  CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color, 
  0 );
  GraphicsCanvas_FillRectangle( &_this->InputCanvas1, EwGetRectORect( _this->InputImage1.Super1.Bounds ), 
  EwGetRectORect( _this->InputImage1.Super1.Bounds ), CustomConstantsbackground_color, 
  CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color, 
  0 );
  GraphicsCanvas_FillRectangle( &_this->InputCanvas2, EwGetRectORect( _this->InputImage2.Super1.Bounds ), 
  EwGetRectORect( _this->InputImage2.Super1.Bounds ), CustomConstantsbackground_color, 
  CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color, 
  0 );
  GraphicsCanvas_FillRectangle( &_this->InputCanvas3, EwGetRectORect( _this->InputImage3.Super1.Bounds ), 
  EwGetRectORect( _this->InputImage3.Super1.Bounds ), CustomConstantsbackground_color, 
  CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color, 
  0 );
  CoreView__ChangeViewState( &_this->PushButtonClear, CoreViewStateEnabled, CoreViewStateFocused );
  CoreView__ChangeViewState( &_this->PushButtonSubmit, CoreViewStateEnabled, CoreViewStateFocused );

  next_digit = rand() % 10;
  ViewsText_OnSetString( &_this->TextNextNumber, EwNewStringInt(next_digit, 0, 0) );
}

/* This is a slot method. */
void ApplicationApplication_onDrag( ApplicationApplication _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_DrawLine( &_this->InputCanvas, EwGetRectORect( _this->InputImage.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleInputTouchHandler.CurrentPos, _this->SimpleInputTouchHandler.Offset ), 
  _this->InputImage.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleInputTouchHandler.CurrentPos, 
  _this->InputImage.Super1.Bounds.Point1 ), CustomConstantsmain_color, CustomConstantsmain_color, 
  1 );
  EwNotifyObjObservers((XObject)&_this->InputCanvas, 0 );
}

/* 'C' function for method : 'Application::Application.onPushClear()' */
void ApplicationApplication_onPushClear( ApplicationApplication _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_FillRectangle( &_this->InputCanvas, EwGetRectORect( _this->InputImage.Super1.Bounds ), 
  EwGetRectORect( _this->InputImage.Super1.Bounds ), CustomConstantsbackground_color, 
  CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color, 
  0 );
  GraphicsCanvas_FillRectangle( &_this->InputCanvas1, EwGetRectORect( _this->InputImage1.Super1.Bounds ), 
  EwGetRectORect( _this->InputImage1.Super1.Bounds ), CustomConstantsbackground_color, 
  CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color, 
  0 );
  GraphicsCanvas_FillRectangle( &_this->InputCanvas2, EwGetRectORect( _this->InputImage2.Super1.Bounds ), 
  EwGetRectORect( _this->InputImage2.Super1.Bounds ), CustomConstantsbackground_color, 
  CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color, 
  0 );
  GraphicsCanvas_FillRectangle( &_this->InputCanvas3, EwGetRectORect( _this->InputImage3.Super1.Bounds ), 
  EwGetRectORect( _this->InputImage3.Super1.Bounds ), CustomConstantsbackground_color, 
  CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color, 
  0 );
  CoreGroup__InvalidateArea( _this, _this->InputImage.Super1.Bounds );
  CoreGroup__InvalidateArea( _this, _this->InputImage1.Super1.Bounds );
  CoreGroup__InvalidateArea( _this, _this->InputImage2.Super1.Bounds );
  CoreGroup__InvalidateArea( _this, _this->InputImage3.Super1.Bounds );
}


/* Runs inference on the drawn symbol inside the input area */
void ApplicationApplication_onPushSubmit( ApplicationApplication _this, XObject sender )
{
	XHandle tmp;
	XHandle tmp1;
	XHandle tmp2;
	XHandle tmp3;
	XRect aArea;
	XRect aArea1;
	XRect aArea2;
	XRect aArea3;
	XInt32 width;
	XInt32 height;
	XColor main_color;

	tmp = _this->InputCanvas.Super1.bitmap;
	tmp1 = _this->InputCanvas1.Super1.bitmap;
	tmp2 = _this->InputCanvas2.Super1.bitmap;
	tmp3 = _this->InputCanvas3.Super1.bitmap;

	aArea = EwGetRectORect( _this->InputImage.Super1.Bounds );
	aArea1 = EwGetRectORect( _this->InputImage1.Super1.Bounds );
	aArea2 = EwGetRectORect( _this->InputImage2.Super1.Bounds );
	aArea3 = EwGetRectORect( _this->InputImage3.Super1.Bounds );

	width = aArea.Point2.X - aArea.Point1.X;
	height = aArea.Point2.Y - aArea.Point1.Y;
	main_color = CustomConstantsmain_color; // the color used for drawing, text and borders

	XBitmap* bitmap = (XBitmap*)tmp;
	XBitmap* bitmap1 = (XBitmap*)tmp1;
	XBitmap* bitmap2 = (XBitmap*)tmp2;
	XBitmap* bitmap3 = (XBitmap*)tmp3;

	/* The color is stored in an embedded wizard structure and needs to be converted
	   into an integer so that it can be compared to the stored color values
	   in the memory. The stored color format is 0xAARRGGBB, where A stands for Alpha,
	   R for red, G for green and B for blue. */
	uint32_t drawing_colorINT = ((uint32_t) main_color.Alpha) << 24 |((uint32_t) main_color.Red) << 16 | ((uint32_t) main_color.Green) << 8 | ((uint32_t) main_color.Blue);

	XBitmapLock* lock = EwLockBitmap(bitmap, 0, aArea, 1, 0);
	XBitmapLock* lock1 = EwLockBitmap(bitmap1, 0, aArea1, 1, 0);
	XBitmapLock* lock2 = EwLockBitmap(bitmap2, 0, aArea2, 1, 0);
	XBitmapLock* lock3 = EwLockBitmap(bitmap3, 0, aArea3, 1, 0);

	uint32_t* src   = (uint32_t*)lock->Pixel1;
	uint32_t* src1   = (uint32_t*)lock1->Pixel1;
	uint32_t* src2   = (uint32_t*)lock2->Pixel1;
	uint32_t* src3   = (uint32_t*)lock3->Pixel1;

	int ofs = ( lock->Pitch1Y / 4 ) - width; // offset between rows (to skip irrelevant pixels on each row)
	int ofs1 = ( lock1->Pitch1Y / 4 ) - width;
	int ofs2 = ( lock2->Pitch1Y / 4 ) - width;
	int ofs3 = ( lock3->Pitch1Y / 4 ) - width;

	uint8_t *bmp = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp1 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp2 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp3 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);

	if (bmp == NULL || bmp1 == NULL || bmp2 == NULL || bmp3 == NULL)
	{
		EwPrint("Out of memory!\n\r");
		return;
	}

	for (int i = 0; i < width * height; i++)
	{
		bmp[i] = 0;
		bmp1[i] = 0;
		bmp2[i] = 0;
		bmp3[i] = 0;
	}

	for (int y = 0; y < height; y++, src += ofs, src1 += ofs1, src2 += ofs2, src3 += ofs3 )
	{
		for (int x = 0; x < width; x++, src++, src1++, src2++, src3++ )
		{
			/* <drawing_color> colored pixel and its 8 neighboring pixels are stored as 0xFF bytes
			 (the input line is thickened so that it retains more detail when the input image gets
			 scaled from 112x112 down to 28x28 so that it has the same size as the MNIST images).
			 All the other pixels are stored as 0x00. Since the MNIST dataset contains single-channel
			 greyscale images, feeding the trained model single-channel black and white images
			 created this way works as well. */
			if (*src == drawing_colorINT)
			{
				/* -- 0 -- */
				bmp[x + y*width] = 0xFF;


				/* -- 1 -- */
				/*
				 X 0 0
				 0 1 0
				 0 0 0
				 */
				if (((x - 1) > 0) && ((y - 1) > 0))
				{
					bmp[(x - 1) + (y - 1)  * width] = 0xFF;
				}

				/*
				 0 0 0
				 X 1 0
				 0 0 0
				 */
				if ((x - 1) > 0)
				{
					bmp[(x - 1) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 X 0 0
				 */
				if (((x - 1) > 0) && ((y + 1) < height))
				{
					bmp[(x - 1) + (y + 1) * width] = 0xFF;
				}

				/*
				 0 X 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 1) > 0)
				{
					bmp[x + (y - 1) * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 X 0
				 0 0 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 2) > 0)
				{
					bmp[x + (y - 2) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 X 0
				 */
				if ((y + 1) < height)
				{
					bmp[x + (y + 1) * width] = 0xFF;
				}

				/*
				 0 0 X
				 0 1 0
				 0 0 0
				 */
				if (((x + 1) < width) && ((y - 1) > 0))
				{
					bmp[(x + 1) + (y - 1) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 X
				 0 0 0
				 */
				if ((x + 1) < width)
				{
					bmp[(x + 1) + y * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 0 0 0
				 0 1 0 X
				 0 0 0 0
				 */
				if ((x + 2) < width)
				{
					bmp[(x + 2) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 0 X
				 */
				if (((x + 1) < width) && ((y + 1) < height))
				{
					bmp[(x + 1) + (y + 1) * width] = 0xFF;
				}
			}

			if (*src1 == drawing_colorINT)
			{
				/* -- 0 -- */
				bmp1[x + y*width] = 0xFF;


				/* -- 1 -- */
				/*
				 X 0 0
				 0 1 0
				 0 0 0
				 */
				if (((x - 1) > 0) && ((y - 1) > 0))
				{
					bmp1[(x - 1) + (y - 1)  * width] = 0xFF;
				}

				/*
				 0 0 0
				 X 1 0
				 0 0 0
				 */
				if ((x - 1) > 0)
				{
					bmp1[(x - 1) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 X 0 0
				 */
				if (((x - 1) > 0) && ((y + 1) < height))
				{
					bmp1[(x - 1) + (y + 1) * width] = 0xFF;
				}

				/*
				 0 X 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 1) > 0)
				{
					bmp1[x + (y - 1) * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 X 0
				 0 0 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 2) > 0)
				{
					bmp1[x + (y - 2) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 X 0
				 */
				if ((y + 1) < height)
				{
					bmp1[x + (y + 1) * width] = 0xFF;
				}

				/*
				 0 0 X
				 0 1 0
				 0 0 0
				 */
				if (((x + 1) < width) && ((y - 1) > 0))
				{
					bmp1[(x + 1) + (y - 1) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 X
				 0 0 0
				 */
				if ((x + 1) < width)
				{
					bmp1[(x + 1) + y * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 0 0 0
				 0 1 0 X
				 0 0 0 0
				 */
				if ((x + 2) < width)
				{
					bmp1[(x + 2) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 0 X
				 */
				if (((x + 1) < width) && ((y + 1) < height))
				{
					bmp1[(x + 1) + (y + 1) * width] = 0xFF;
				}
			}

			if (*src2 == drawing_colorINT)
			{
				/* -- 0 -- */
				bmp2[x + y*width] = 0xFF;


				/* -- 1 -- */
				/*
				 X 0 0
				 0 1 0
				 0 0 0
				 */
				if (((x - 1) > 0) && ((y - 1) > 0))
				{
					bmp2[(x - 1) + (y - 1)  * width] = 0xFF;
				}

				/*
				 0 0 0
				 X 1 0
				 0 0 0
				 */
				if ((x - 1) > 0)
				{
					bmp2[(x - 1) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 X 0 0
				 */
				if (((x - 1) > 0) && ((y + 1) < height))
				{
					bmp2[(x - 1) + (y + 1) * width] = 0xFF;
				}

				/*
				 0 X 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 1) > 0)
				{
					bmp2[x + (y - 1) * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 X 0
				 0 0 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 2) > 0)
				{
					bmp2[x + (y - 2) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 X 0
				 */
				if ((y + 1) < height)
				{
					bmp2[x + (y + 1) * width] = 0xFF;
				}

				/*
				 0 0 X
				 0 1 0
				 0 0 0
				 */
				if (((x + 1) < width) && ((y - 1) > 0))
				{
					bmp2[(x + 1) + (y - 1) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 X
				 0 0 0
				 */
				if ((x + 1) < width)
				{
					bmp2[(x + 1) + y * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 0 0 0
				 0 1 0 X
				 0 0 0 0
				 */
				if ((x + 2) < width)
				{
					bmp2[(x + 2) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 0 X
				 */
				if (((x + 1) < width) && ((y + 1) < height))
				{
					bmp2[(x + 1) + (y + 1) * width] = 0xFF;
				}
			}

			if (*src3 == drawing_colorINT)
			{
				/* -- 0 -- */
				bmp3[x + y*width] = 0xFF;


				/* -- 1 -- */
				/*
				 X 0 0
				 0 1 0
				 0 0 0
				 */
				if (((x - 1) > 0) && ((y - 1) > 0))
				{
					bmp3[(x - 1) + (y - 1)  * width] = 0xFF;
				}

				/*
				 0 0 0
				 X 1 0
				 0 0 0
				 */
				if ((x - 1) > 0)
				{
					bmp3[(x - 1) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 X 0 0
				 */
				if (((x - 1) > 0) && ((y + 1) < height))
				{
					bmp3[(x - 1) + (y + 1) * width] = 0xFF;
				}

				/*
				 0 X 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 1) > 0)
				{
					bmp3[x + (y - 1) * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 X 0
				 0 0 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 2) > 0)
				{
					bmp3[x + (y - 2) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 X 0
				 */
				if ((y + 1) < height)
				{
					bmp3[x + (y + 1) * width] = 0xFF;
				}

				/*
				 0 0 X
				 0 1 0
				 0 0 0
				 */
				if (((x + 1) < width) && ((y - 1) > 0))
				{
					bmp3[(x + 1) + (y - 1) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 X
				 0 0 0
				 */
				if ((x + 1) < width)
				{
					bmp3[(x + 1) + y * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 0 0 0
				 0 1 0 X
				 0 0 0 0
				 */
				if ((x + 2) < width)
				{
					bmp3[(x + 2) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 0 X
				 */
				if (((x + 1) < width) && ((y + 1) < height))
				{
					bmp3[(x + 1) + (y + 1) * width] = 0xFF;
				}
			}
		}
	}

	processImage(bmp, width, height, next_digit);
	processImage(bmp1, width, height, next_digit);
	processImage(bmp2, width, height, next_digit);
	processImage(bmp3, width, height, next_digit);

	free(bmp);
	bmp = NULL;

	free(bmp1);
	bmp1 = NULL;

	free(bmp2);
	bmp2 = NULL;

	free(bmp3);
	bmp3 = NULL;

	EwUnlockBitmap(lock);
	EwUnlockBitmap(lock1);
	EwUnlockBitmap(lock2);
	EwUnlockBitmap(lock3);

	next_digit = rand() % 10;
	ViewsText_OnSetString( &_this->TextNextNumber, EwNewStringInt(next_digit, 0, 0) );
	ApplicationApplication_onPushClear( _this, sender );
}

/* This is a slot method. */
void ApplicationApplication_onDrag1( ApplicationApplication _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_DrawLine( &_this->InputCanvas1, EwGetRectORect( _this->InputImage1.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleInputTouchHandler1.CurrentPos, _this->SimpleInputTouchHandler1.Offset ), 
  _this->InputImage1.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleInputTouchHandler1.CurrentPos, 
  _this->InputImage1.Super1.Bounds.Point1 ), CustomConstantsmain_color, CustomConstantsmain_color, 
  1 );
  EwNotifyObjObservers((XObject)&_this->InputCanvas1, 0 );
}

/* This is a slot method. */
void ApplicationApplication_onDrag2( ApplicationApplication _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_DrawLine( &_this->InputCanvas2, EwGetRectORect( _this->InputImage2.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleInputTouchHandler2.CurrentPos, _this->SimpleInputTouchHandler2.Offset ), 
  _this->InputImage2.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleInputTouchHandler2.CurrentPos, 
  _this->InputImage2.Super1.Bounds.Point1 ), CustomConstantsmain_color, CustomConstantsmain_color, 
  1 );
  EwNotifyObjObservers((XObject)&_this->InputCanvas2, 0 );
}

/* This is a slot method. */
void ApplicationApplication_onDrag3( ApplicationApplication _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_DrawLine( &_this->InputCanvas3, EwGetRectORect( _this->InputImage3.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleInputTouchHandler3.CurrentPos, _this->SimpleInputTouchHandler3.Offset ), 
  _this->InputImage3.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleInputTouchHandler3.CurrentPos, 
  _this->InputImage3.Super1.Bounds.Point1 ), CustomConstantsmain_color, CustomConstantsmain_color, 
  1 );
  EwNotifyObjObservers((XObject)&_this->InputCanvas3, 0 );
}

/* Variants derived from the class : 'Application::Application' */
EW_DEFINE_CLASS_VARIANTS( ApplicationApplication )
EW_END_OF_CLASS_VARIANTS( ApplicationApplication )

/* Virtual Method Table (VMT) for the class : 'Application::Application' */
EW_DEFINE_CLASS( ApplicationApplication, CoreRoot, Rectangle, Rectangle, Rectangle, 
                 Rectangle, _None, "Application::Application" )
  CoreRectView_initLayoutContext,
  CoreRoot_GetRoot,
  CoreRoot_Draw,
  CoreView_HandleEvent,
  CoreGroup_CursorHitTest,
  CoreRectView_ArrangeView,
  CoreRectView_MoveView,
  CoreRectView_GetExtent,
  CoreRoot_ChangeViewState,
  CoreGroup_OnSetBounds,
  CoreRoot_OnSetFocus,
  CoreRoot_DispatchEvent,
  CoreRoot_BroadcastEvent,
  CoreGroup_UpdateViewState,
  CoreRoot_InvalidateArea,
  CoreRoot_RestackBehind,
  CoreRoot_RestackTop,
  CoreRoot_Restack,
  CoreRoot_Add,
EW_END_OF_CLASS( ApplicationApplication )

/* Embedded Wizard */
