/*

Copyright 2016-2019 NXP
All rights reserved.
SPDX-License-Identifier: BSD-3-Clause

*/

#ifndef _APPL_MAIN_H_
#define _APPL_MAIN_H_


/*! *********************************************************************************
*************************************************************************************
* Include
*************************************************************************************
********************************************************************************** */
#include "EmbeddedTypes.h"
#include "fsl_os_abstraction.h"

/*! *********************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
********************************************************************************** */
/*application state machine states enumeration*/
typedef enum app_states_tag
{
    gAppStateInit_c = 0,
    gAppStateIdle_c,
    gAppStateSelectTest_c,
    gAppStateRunning_c,
    gAppStateMaxState_c
}app_states_t;

/*! *********************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
********************************************************************************** */
/*
 * These values should be modified by the application as necessary.
 * They are used by the idle task initialization code from ApplMain.c.
 */
/*! Idle Task Stack Size */
#ifndef gAppIdleTaskStackSize_c
#define gAppIdleTaskStackSize_c (400)
#endif

/*! Idle Task OS Abstraction Priority */
#ifndef gAppIdleTaskPriority_c
#define gAppIdleTaskPriority_c  (8)
#endif

/*! Push Buttons States used in application. */
#define PB1_PRESSED     0x01
#define PB2_PRESSED     0x02
#define PB1_LONG_PRESS  0x03
#define PB2_LONG_PRESS  0x04
#define PB_INVALID      0xFF

/*! *********************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */

/*! *********************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
********************************************************************************** */
extern void APP_Can_LinCallback(void* param); 

#endif /* _APPL_MAIN_H_ */
