/*! *********************************************************************************
 * \addtogroup can and lin common api
 * @{
 ********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2018 NXP
* All rights reserved.
*
* \file
*
* This file is the source file for the CAN and LIN
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

/************************************************************************************
 *************************************************************************************
 * Include
 *************************************************************************************
 ************************************************************************************/
#include "can_lin_common.h"
#include "board.h"
#include "pin_mux.h"
#include "fsl_debug_console.h"
#include "gen_fsk_tests.h"
#include "connectivity_test.h"

/************************************************************************************
 *************************************************************************************
 * Private macros
 *************************************************************************************
 ************************************************************************************/


/************************************************************************************
 *************************************************************************************
 * Private type definitions
 *************************************************************************************
 ************************************************************************************/


/************************************************************************************
 *************************************************************************************
 * Private memory declarations
 *************************************************************************************
 ************************************************************************************/


/************************************************************************************
 *************************************************************************************
 * Private functions prototypes
 *************************************************************************************
 ************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/
link_monitor_para_t gLMParaArry[gLinkMonitorNumMax];
link_monitor_para_t gLMPara; 

extern uint16_t g_can_device_id;

extern void can_demo_init(void);
extern void lin_demo_init_slave(void);

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/
void GfskApp_InitCAN_LIN(void)
{
    /* Initialize application support for drivers */   
    BOARD_InitLPUART();
    BOARD_InitDebugConsole();
#if (gOtaUseBusSelection_d == gOtaUseBus_CAN_c)
    uint32_t uid[4];
    uint8_t lenth;
    can_demo_init();
    BOARD_GetMCUUid((uint8_t*)uid, &lenth);
    g_can_device_id = uid[3];
    PRINTF("\r\nLink Monitor + CAN demo V1!");     
#elif (gOtaUseBusSelection_d == gOtaUseBus_LIN_c)
    lin_demo_init_slave();
    PRINTF("\r\n Link Monitor + LIN demo!");
#endif    
    
    StopLed1Flashing();
    StopLed2Flashing();
    StopLed3Flashing();
    StopLed4Flashing();
}

void GfskApp_StartLM(void)
{
    hoppingInit(gLMParaArry, gLMPara);
    APP_Can_LinCallback(NULL);
    
    PRINTF("\r\npeerDeviceId:%d", mLMTrackConnStatus.id);
    PRINTF("\r\nconnOrDisconn:%d",mLMTrackConnStatus.status);
    PRINTF("\r\nHopIncrement: %d", gLMPara.hopIncrement);
    PRINTF("\r\nConnection Interval:%d", (uint8_t)(gLMPara.CI*1.25));
    PRINTF("\r\nCRC seed: %X", gLMPara.crcSeed);
    PRINTF("\r\nAA:%X", gLMPara.syncAddress);
}



/*! *********************************************************************************
 * @}
 ********************************************************************************** */
