/*! *********************************************************************************
 * \addtogroup can and lin common api
 * @{
 ********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2018 NXP
* All rights reserved.
*
* \file
*
* This file is the source file for the CAN and LIN
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

/************************************************************************************
 *************************************************************************************
 * Include
 *************************************************************************************
 ************************************************************************************/
#include "can_lin_common.h"
#include "board.h"
#include "ble_general.h"
#include "fsl_debug_console.h"

/************************************************************************************
 *************************************************************************************
 * Private macros
 *************************************************************************************
 ************************************************************************************/


/************************************************************************************
 *************************************************************************************
 * Private type definitions
 *************************************************************************************
 ************************************************************************************/


/************************************************************************************
 *************************************************************************************
 * Private memory declarations
 *************************************************************************************
 ************************************************************************************/


/************************************************************************************
 *************************************************************************************
 * Private functions prototypes
 *************************************************************************************
 ************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/
 //link monitor
bool_t gLMConnectionReady = FALSE;
link_monitor_para_t gLMPara;

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/
void LM_GetConnInfo(deviceId_t peerDeviceId, uint8_t connOrDisconn)
{
    gLMConnectionReady = TRUE;
    gLMPara.peerDeviceId = peerDeviceId;
    gLMPara.connOrDisconn = connOrDisconn;
    if(BTLE_CONNECT == connOrDisconn)
    {
        gLMPara.hopIncrement = (*(uint16_t*)(BTLE_RF->RESERVED_0 + 0xF4) & 0xFF) >> 3;
        gLMPara.crcSeed = (uint32_t)(*(uint16_t*)(BTLE_RF->RESERVED_0 + 0xF4) >> 8) | ((uint32_t)*(uint16_t*)(BTLE_RF->RESERVED_0 + 0xF6) << 8);
        gLMPara.syncAddress = (*(uint16_t*)(BTLE_RF->RESERVED_0 + 0x88)) | ((uint32_t)*(uint16_t*)(BTLE_RF->RESERVED_0 + 0x8A) << 16);
        gLMPara.CI = (*(uint16_t*)(BTLE_RF->RESERVED_0 + 0x80));
    }
    
    PRINTF("\r\npeerDeviceId:%d", peerDeviceId);
    PRINTF("\r\nconnOrDisconn:%d", connOrDisconn);
    PRINTF("\r\nHopIncrement: %d", gLMPara.hopIncrement);
    PRINTF("\r\nConnection Interval:%d", gLMPara.CI);
    PRINTF("\r\nCRC seed: %X", gLMPara.crcSeed);
    PRINTF("\r\nAA:%X", gLMPara.syncAddress);
}



/*! *********************************************************************************
 * @}
 ********************************************************************************** */
