/*! *********************************************************************************
 * \addtogroup Wireless UART Profile
 * @{
 ********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2018 NXP
* All rights reserved.
*
* \file
*
* This file is the interface file for the Wireless UART Service
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

#ifndef WIRELESS_UART_INTERFACE_H
#define WIRELESS_UART_INTERFACE_H

/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public constants & macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/
/*! Wireless UART Service - Configuration */
typedef struct wusConfig_tag
{
    uint16_t    serviceHandle;
} wusConfig_t;

/*! Wireless UART Client - Configuration */
typedef struct wucConfig_tag
{
    uint16_t    hService;
    uint16_t    hUartStream;
} wucConfig_t;
/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/*!**********************************************************************************
* \brief        Starts Wireless UART Service functionality
*
* \param[in]    pServiceConfig  Pointer to structure that contains server
*                               configuration information.
*
* \return       gBleSuccess_c or error.
************************************************************************************/
bleResult_t Wus_Start(wusConfig_t *pServiceConfig);

/*!**********************************************************************************
* \brief        Stops Wireless UART Service functionality
*
* \param[in]    pServiceConfig  Pointer to structure that contains server
*                               configuration information.
*
* \return       gBleSuccess_c or error.
************************************************************************************/
bleResult_t Wus_Stop(wusConfig_t *pServiceConfig);

/*!**********************************************************************************
* \brief        Subscribes a GATT client to the Wireless UART Service
*
* \param[in]    clientDeviceId  Client Id in Device DB.
*
* \return       gBleSuccess_c or error.
************************************************************************************/
bleResult_t Wus_Subscribe(deviceId_t clientDeviceId);

/*!**********************************************************************************
* \brief        Unsubscribes a GATT client from the Wireless UART Service
*
* \return       gBleSuccess_c or error.
************************************************************************************/
bleResult_t Wus_Unsubscribe(void);

#ifdef __cplusplus
}
#endif

#endif /* WIRELESS_UART_INTERFACE_H */

/*! **********************************************************************************
 * @}
 ************************************************************************************/
