/*! *********************************************************************************
 * \addtogroup BLE
 * @{
 ********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
* \file
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/
#include "Messaging.h"
#include "ble_host_tasks.h"
#include "ble_host_task_config.h"
#include "Panic.h"

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/
osaEventId_t gHost_TaskEvent;

msgQueue_t   gApp2Host_TaskQueue;
msgQueue_t   gHci2Host_TaskQueue;

/************************************************************************************
*************************************************************************************
* Private prototypes
*************************************************************************************
************************************************************************************/
static void Host_Task(osaTaskParam_t argument);
/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/
static osaTaskId_t  mHost_TaskId = NULL;

static OSA_TASK_DEFINE(Host_Task, gHost_TaskPriority_c, 1, gHost_TaskStackSize_c, FALSE);

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

osaStatus_t Ble_HostTaskInit(void)
{
    /* Already initialized? */
    if (NULL != mHost_TaskId)
    {
        return osaStatus_Error;
    }

    /* Initialization of task related */
    gHost_TaskEvent = OSA_EventCreate(TRUE);

    if (gHost_TaskEvent == NULL)
    {
        return osaStatus_Error;
    }

    /* Initialization of task message queue */
    MSG_InitQueue(&gApp2Host_TaskQueue);
    MSG_InitQueue(&gHci2Host_TaskQueue);

    /* Task creation */

    mHost_TaskId = OSA_TaskCreate(OSA_TASK(Host_Task), NULL);

    if (NULL == mHost_TaskId)
    {
        panic(0, 0, 0, 0);
        return osaStatus_Error;
    }

    return osaStatus_Success;
}

/************************************************************************************
*************************************************************************************
* Private functions
*************************************************************************************
************************************************************************************/

static void Host_Task(osaTaskParam_t argument)
{
    Host_TaskHandler((void *) NULL);
}

/*! *********************************************************************************
* @}
********************************************************************************** */
